--
-- Get database event types and their attributes
--
-- Some of the syntax is MySQL-specific (group_concat)
--
-- Author: Dan Gunter
-- Created: December 3, 2008
--
-- Cleanup
drop table if exists event_types, event_attrs, event_idents, event_dn, event_text;

--
-- Put event types in a temporary table
--
create temporary table event_types (id integer, name varchar(255)) 
select id, 
       count(*) 'num',
       min(time) 'first',
       max(time) 'last',
       (case 
           when startend = 0 then concat(name,'.start') 
           when startend = 1 then concat(name,'.end')
           else name
       end) name
       from event group by name, startend;
--
-- Join with attr(ibutes) table
--
create temporary table event_attrs (event varchar(255), names varchar(4096))
select e.name as 'event',
       group_concat(attr.name order by attr.e_id separator ',') as 'names'
from event_types e
     left join attr on e.id = attr.e_id
group by e.name;

--
-- Join with ident(ifiers) table
--
create temporary table event_idents (event varchar(255), names varchar(4096))
select e.name as 'event',
       group_concat(ident.name order by ident.e_id separator ',') 'names'
from event_types e
     left join ident on e.id = ident.e_id
group by e.name;

--
-- Join with DN table
--
create temporary table event_dn (event varchar(255), has_dn varchar(3))
select e.name as 'event',
(case when isnull(dn.id) then 'no' else 'yes' end) 'has_dn'
from event_types e
     left join dn on e.id = dn.e_id
group by e.name;

--
-- Join with text table
--
create temporary table event_text (event varchar(255), has_text varchar(3))
select e.name as 'event',
(case when isnull(text.id) then 'no' else 'yes' end) 'has_text'
from event_types e
     left join text on e.id = text.e_id
group by e.name;

--
-- Project them all into the same table
--
select x.event, e.num, from_unixtime(e.first, "%Y-%m-%dT%H:%i:%S") 'first', from_unixtime(e.last, "%Y-%m-%dT%H:%i:%S") 'last', x.names 'attributes', y.names 'identifiers', d.has_dn, t.has_text
from event_attrs x 
join event_idents y on x.event = y.event
join event_types e on x.event=e.name
join event_dn d on d.event=e.name
join event_text t on t.event=e.name
order by num;
