#!/bin/sh

#
# File: common.sh
# Common functions for info_broker examples.
#

#
# Function: write_logs
# Write input log files.
#
# Create a directory 'input_files' under the $TMP
# directory (TMP must be defined in the including file)
# and write a total of 9 files in it:
# * a_1.log ... a_3.log
# * b_1.log ... b_3.log
# * c_1.log ... c_3.log
#
# The contents of each file are NetLogger events
# with the event name 'event-a', etc. and the number
# of events in each file is the file number (1..3) times
# the base number of log events, <N>.
#
# Arguments:
# N - Base number of log events to write
#
# Return:
# tmpdir - Temporary directory with the logs
# total - Total number of log events (integer)
#
write_logs ()
{
    N=$1
    d=${TMP}/input_files
    total=0
    mkdir $d
    for type in a b c
    do
        for num in 1 2 3
        do
            events=$(($N * $num))
            nl_write -n $events event="event-$type" > $d/${type}_${num}.log
            total=$(($total + $events))
        done
    done
    echo $d $total
}

#
# Function: cleanup
# Cleanup temporary files.
#
# Remove the 'input_files' directory created by <write_logs>.
#
cleanup ()
{
    #printf "Cleanup in '%s' ...\n" $TMP
    /bin/rm -rf $TMP/input_files
}

