"""
Create a table with a summary of BeStMan transfers since
the last invocation.

Parameters:
   table = Database table to create. Default: 'bestman'.
"""
__author__ = "Dan Gunter <dkgunter@lbl.gov>"
__rcsid__ = "$Id: bestman.py 23923 2009-09-18 22:42:26Z ksb $"

## Imports

import time
from netlogger.actions.base import BaseAction
from netlogger.nllog import DoesLogging, get_logger
from netlogger import nldate

## Classes

class Action(BaseAction,DoesLogging):
    """Create a table with a summary of BeStMan transfers since
    the last invocation.
    """

    TABLE_PARAM = 'table'    
    TABLE_DEFAULT = 'bestman'

    MAX_URL_LEN = 1024 # max length of source/dest URL in table

    def __init__(self):
        BaseAction.__init__(self)
        DoesLogging.__init__(self)

    def execute(self):
        self.start_time = self.getLastRun()
        self.log.info("execute.start")
        # Setup
        self.log.debug("setup.start")
        conn = self.getConnection()
        curs = conn.cursor()
        # : parse parameters
        param = self.getParameters()
        table_name = param.get(self.TABLE_PARAM, self.TABLE_DEFAULT)
        self.log.debug("setup.end")
        # : time at which to start the query
        self.start_time = self.getLastRun()
        # Create target table, if necessary
        self.log.debug("create.table.start", value=table_name)
        try:
            curs.execute("create table if not exists %s ("
                         "request_id varchar(100), ",
                         "time double, "
                         "source varchar(%d), "
                         "dest varchar(%d), "
                         "size_bytes integer(14), "
                         "duration_sec double "
                         ") " % (table_name,self.MAX_URL_LEN,self.MAX_URL_LEN))
        except:
            pass # mysql still raises an exception here!!
        self.log.debug("create.table.end", value=table_name, status=0)
        # Run queries
        self.log.debug("queries.start",start__time=self.start_time)
        self.log.debug("queries.end", status=0)
        # Cleanup
        self.log.info("execute.end", status=0)
        conn.commit()
        conn.close()

    def finish(self, status):
        BaseAction.finish(self, status)
        if status < 0:
            # If we failed, reset the last run time
            # to be the same as before, so that we don't skip data
            # on the next successful run.
            # Make sure this is AFTER the base method, which also
            # sets the last run time.
            self.setLastRun(self.start_time)
