"""
Implementation of a GridFTP storage service using MongoDB.
"""
__rcsid__ = '$Id: mongo_gridftp_store.py 24892 2010-06-12 00:43:29Z dang $'
__author__ = 'Dan Gunter <dkgunter@lbl.gov>'

# System imports
from pymongo import Connection
# Local imports
from gridftp_store import GridFTPStore

class MongoGridFTPStore(GridFTPStore):
    """GridFTPStore with MongoDB backend.
    """
    def __init__(self, **conn_kw):
        """Connect to MongoDB backend using the provided
        keywords in 'conn_kw', if any.

        Exceptions: Anything pymongo.Connection() can raise.
        """
        self.conn = Connection(**conn_kw)
        self.db = self.conn.gridftp
        self.coll = self.db.nersc

    def get_transfers(self, start, end):
        """See superclass documentation.
        """
        return self.coll.find({'ts' : {'$ge':start, '$le':end}})

def __test():
    import datetime
    start = datetime.utcnow()
    end = datetime.utcnow()
    db = MongoGridFTPStore()
    db.get_transfers(start, end)
