#!/usr/bin/env python
## Copyright (c) 2004, The Regents of the University of California, through 
## Lawrence Berkeley National Laboratory (subject to receipt of any required 
## approvals from the U.S. Dept. of Energy).  All rights reserved.
"""
Generic histogram class.
"""
class Histogram:
    def __init__(self,min_,max_,n):
        self._min, self._max, self.nbins = min_,max_,n
        self._width = float(self._max - self._min) / self.nbins
        self._n = 0 # total number of points
        self.counts, self.outliers = [0] * self.nbins, [0,0]

    def getQuantile(self,q):
        """Return left edge if bin for q-th quantile of
        cumulative distribution of the counts
        No interpolation is performed.
        """
        if q < 0.0 or q > 1.0:
            raise ValueError("Quantile must be in range (0,1)")
            return self._max
        n1 = self._n + 1
        if q < 1/n1:
            return self._min
        elif q > self._n/n1:
            return self._max
        k = int(q * self._n)
        num = 0
        for i,b in enumerate(self.counts):
            num += b
            if num >= k:
                break
        xk = i * self._width + self._min
        return xk
            
    def getBreaks(self):
        """Return list of breakpoints between histogram cells.
        If there are N cells, there will be N-1 breakpoints.
        """
        breaks = [(x * self._width + self._min) for x in range(1,self.nbins)]
        return breaks
    
    def addLine(self,value):
        bin = self._getBin(value)
        if bin == -1:
            self.outliers[0] += 1
            return
        if bin == self.nbins:
            self.outliers[1] += 1
        else:
            self.counts[bin] += 1
        self._n += 1
        
    def _getBin(self,value):
        #print "value",value
        if value < self._min: return -1
        if value > self._max: return self.nbins
        bin = int((value - self._min) / self._width)
        return bin

