"""
Run all tests in the current directory as a single suite.
"""
import glob
import imp
import os
import sys
import unittest


def main():
    suite = unittest.TestSuite()
    for filename in glob.glob("test*.py"):
        name = filename[:-3]
        file, path, desc = imp.find_module(name)
        tmod = imp.load_module(name, file, path, desc)
        suite.addTest(tmod.suite())
    runner = unittest.TextTestRunner()
    runner.run(suite)

if __name__ == '__main__':
    workdir = os.path.dirname(os.path.abspath(__file__))
    os.chdir(workdir)
    main()
