#!/usr/bin/env python
"""
Fake nl_parser / nl_loader for
testing the nl_pipeline.
"""
import logging, os, signal, sys, time

from netlogger.nllog import get_logger, OptionParser
from netlogger.pipeline import PipelineApplication

# Globals, etc.
options = None
dir = os.path.dirname(sys.argv[0])
prog = os.path.basename(sys.argv[0])

def on_term(signo, frame):
    log = get_logger(__file__)
    log.info("terminated", signo=signo)
    sys.exit(0)

# setup signal handling
signal.signal(signal.SIGTERM, on_term)

def parse_args():
    """
    Just enough of the args that parser and loader take to fake out
    the pipeline.
    """
    global options

    parser = OptionParser(description=' '.join(__doc__.split()))
    parser.add_option('-c', '--config', action="store",
                      dest="config", default=None,
                      metavar="FILE", help="use configuration in FILE")
    parser.add_option('-d', '--daemon', action='store_true', dest="daemon",
                      help="run in daemon mode")
    options, args = parser.parse_args()

def main():
    global options
    parse_args()
    log = get_logger(__file__)
    log.info("run.start")
    fakePipelineApp = PipelineApplication()
    while True:
        time.sleep(1)
    log.info("run.end", status=0)
    return 0

if __name__ == '__main__':
    sys.exit(main())
