#!/usr/bin/env python
"""
Unittests for vmstat parser
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseVmstat.py 24045 2010-01-09 15:32:24Z dang $'

import logging
import StringIO
import unittest
#
from netlogger.parsers.modules import vmstat
from netlogger.tests import shared

SAMPLE1 = """\
procs -----------memory---------- ---swap-- -----io---- --system-- -----cpu------
r  b   swpd   free   buff  cache   si   so    bi    bo   in   cs us sy id wa st
0  0      0 5414724 245476 481588    0    0  4425  1225    4   10  2  8 90  0  0
"""

SAMPLE1_PARSED = dict(r=0,  b=0,   swpd=0,
      free=5414724, buff=245476, cache=481588,
      si=0, so=0, bi=4425, bo=1225, cs=10,
      us=2, sy=8, id=90, wa=0, st=0)
SAMPLE1_PARSED['in'] = 4 # keyword

class TestCase(shared.BaseTestCase, shared.ParserTestCase):

    def setUp(self):
        self.setParser(vmstat.Parser)

    def test1(self):
        """Validate on correct input
        """
        # Parse the data
        result = self.feedRecord(SAMPLE1)
        self.failUnless(result, "Could not parse: %s" % SAMPLE1)
        data = result[0]
        # Check the result
        for key, value in SAMPLE1_PARSED.items():
            self.failUnless(data.has_key(key), "Missing key '%s'" % key)
            self.failUnless(data[key] == value, "Wrong value (%d, not %d) "
                    "for key '%s'" % (data[key], value, key))

# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()
