from netlogger.analysis.datamining import bandwidth as bw
import sys
from netlogger.analysis.datamining import base
from netlogger.analysis.datamining import rpython
import pymongo

def main(n):
    conn = pymongo.Connection()
    db = conn.koa
    coll = db.xfer
    cursor = coll.find({'status':0},limit=n)
    ds = rpython.RDataSource(cursor)
    if ds.data is None:
        print "No data"
        return -1
    plot = bw.SmoothedTsPlot()
    plot.param = bw.SmoothedTsPlot.Param(filename="/tmp/test_plot",
                                         title="Test plot", device="pdf")
    plot.data = ds.data
    plot_out = plot.create()
    print "plot is in: %s" % plot_out.path

if __name__ == '__main__':
    if len(sys.argv) > 1:
        n = int(sys.argv[1])
    else:
        n = 100
    main(n)
