<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" 
      xmlns:py="http://purl.org/kid/ns#"
      xmlns:mochi="http://www.mochikit.org/"
    py:extends="'master.kid'">
<head>
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" py:replace="''"/>
<title>CEDPS-TS Database Query</title>
</head>
<body>
  <!--
      Page parameters:
      qt_nav - List of objects with attributes 'name' and 'is_selected'
      form_data - Widget for selected form
      data - Result data as a list of rows. The columns in each row should
             be in the same order as data_cols. All values should be strings.
      data_cols - List of data column names.
    -->

  <!-- List each type of query, with a hyperlink that
       changes the form displayed. -->
  <div id="q_nav">
    <h3>Query</h3>
    <ul>
      <li py:for="qt in qt_nav">
        <span py:if="qt.is_selected" id="q_nav_ptr">&nbsp;</span>
        <span py:if="not qt.is_selected">&nbsp;</span>
        <a href="${'query?query_type=%s' % qt.name}" py:content="qt.name"/>
      </li>
    </ul>
  </div>
  <!-- Show the selected query form. Which form is determined by the
    form_data parameter. -->
  <div id="q_form">
    <h3>Parameters</h3>
    <div py:if="form" id="q_form_inner">
      ${form(value=form_data)}
    </div>
  </div>
  <!-- Show the results, if there are any -->
  <div id="q_results">
    <h3>Results</h3>
    <table py:if="data" id="sortable_table" class="datagrid"> 
      <thead> 
        <tr>
          <th py:for="col in data_cols" class="${col.title()}" mochi:format="istr"
              py:content="col.title()"/>
        </tr>
      </thead> 
      <tbody> 
        <tr py:for="row in data"> 
          <td py:for="i, col in enumerate(data_cols)" class="${col.title()}" 
              py:content="row[i]"/>
        </tr>
      </tbody>
    </table>      
  </div>
</body>
</html>
