# This is an auto-generated Django model module.
# You'll have to do the following manually to clean this up:
#     * Rearrange models' order
#     * Make sure each model has one field with primary_key=True
# Feel free to rename the models, but don't rename db_table values or field names.
#
# Also note: You'll have to insert the output of 'django-admin.py sqlcustom [appname]'
# into your database.

from django.db import models
from datetime import date

class Event(models.Model):
    id = models.IntegerField(primary_key=True)
    hash = models.CharField(max_length=96)
    time = models.FloatField()
    name = models.CharField(max_length=765)
    startend = models.IntegerField()
    severity = models.IntegerField()

    def __unicode__(self) :
        return "%d %s %f %s %d %d" % (self.id, self.hash, self.time, self.name,
                                      self.startend, self.severity)

    class Meta:
        db_table = u'event'

class Attr(models.Model):
#    row_id = models.IntegerField(primary_key=True)
 #
    id = models.IntegerField(primary_key = True)
    e_id = models.ForeignKey(Event, db_column='id')
    #id = models.IntegerField()
    name = models.CharField(max_length=765)
    value = models.CharField(max_length=765)

    class Meta:
        db_table = u'attr'


class Dn(models.Model):
    e_id = models.IntegerField(null=True, blank=True)
    value = models.CharField(max_length=765)
    class Meta:
        db_table = u'dn'

class Ident(models.Model):
    e_id = models.ForeignKey(Event, db_column='id')
    name = models.CharField(max_length=765)
    value = models.CharField(max_length=765)
    class Meta:
        db_table = u'ident'

class Text(models.Model):
    e_id = models.IntegerField(null=True, blank=True)
    value = models.TextField(blank=True)
    class Meta:
        db_table = u'text'


### to get all workflows
## workflows=set([x.value for x in Ident.objects.filter(name='workflow')])

## to get the event ids associated with a workflow w:
## w = workflows.pop()
## evt_ids = [x.e_id for x in Ident.objects.filter(value=w)]

## get all the corresponding events:
## l = [Event.objects.filter(id=x)[0] for x in evt_ids]





## utility fns:
def getJobsPerDay(event_list) :
    jobhash = {}
    for e in event_list :
        if date.utcfromtimestamp(e.time) in jobhash :
            jobhash[date.utcfromtimestamp(e.time)].append(e)
        else :
            jobhash[date.utcfromtimestamp(e.time)] = [e]
    return jobhash

#def getJobsPerHost(event_list) :
    




###### classes for transformed data

#class Workflow(models.Model) :
#    name = models.CharField(max_length=765)

#class Job(models.Model) :
#    workflow = models.ForeignKey(Workflow)
#    start = 













