"""
Example of usage of netlogger.nfd module.

Will create 10 files counting 100 bottles of beer
down to 0, then print out the contents of these files.

"""
import os
import tempfile
from netlogger import nfd

# File directory and base name
TEMPDIR = tempfile.gettempdir()
BASE_FILE_NAME = "nfd-example"

# Writer
cond = nfd.Condition(lines=10) # new file every 10 lines
writer = nfd.Writer(TEMPDIR, BASE_FILE_NAME, cond)
for i in xrange(100,0,-1):
    writer.write_line("%d bottles of beer on the wall. "
                      "Take one down, pass it around," % i)
writer.write_line("no more bottles of beer on the wall!")
writer.close()

# Reader; will delete files when done reading them
reader = nfd.Reader(TEMPDIR, BASE_FILE_NAME, nfd.Delete())
while 1:
    line = reader.read_line()
    if line is None: # no more data
        break
    print line

print "Done. %s should have no files starting with %s" % (
    TEMPDIR, BASE_FILE_NAME)
