"""
Write input as NetLogger Best Practices (ASCII) format records to a file.
"""
__rcsid__ = "$Id: bp.py 26531 2010-09-29 23:35:31Z dang $"
__author__ = "Dan Gunter"

import sys
from netlogger.analysis.modules._base import Analyzer as BaseAnalyzer
from netlogger import nlapi
from netlogger import util

class Analyzer(BaseAnalyzer):
    """Write NetLogger records to a valid NetLogger destination.
    
    Parameters:
        - ostrm {filename,x-netlog://host:port,standard output*}: 
            Output stream
        - pretty {yes,no,no*}: If true, use the more readable variant
          of the BP format. Note that most NetLogger tools do not parse
          this format.
    """
    def __init__(self, ostrm=sys.stdout, pretty='no', **kw):
        BaseAnalyzer.__init__(self, **kw)
        pretty = util.as_bool(pretty)
        # create log output
        self._log = nlapi.Log(logfile=ostrm, guid=False, pretty=pretty,
                              level=nlapi.Level.ALL)

    def process(self, data):
        if self._dbg:
            self.log.debug("process_data.start", data=data)
        self._log.write(**data)
        if self._dbg:
            self.log.debug("process_data.end")

    def flush(self):
        self._log.flush()
