"""
Parse HSI ndapid log files
eg.
Tue Oct 21 06:05:04 2008 gonzo.nersc.gov[18694] hsi: 17717 28074 Username: welcome  UID: 17717  Acct: 17717(17717) Copies: 1 Firewall: off [hsi.3.4.1 Tue Aug 26 15:45:21 PDT 2008][V3.4.1_2008_08_26.01] 

"""
__author__ = 'Shreyas Cholia scholia@lbl.gov'
__rcsid__ = '$Id: hsi.py 1030 2008-09-12 19:52:45Z shreyas $'

from logging import DEBUG
import re
import time
#
from netlogger.parsers.base import BaseParser

class Parser(BaseParser):
    """Parse HSI ndapid log files
    """
    def __init__(self, f, **kwargs):
        BaseParser.__init__(self, f, fullname=__name__, **kwargs)

    def process(self, line):
	# Timestamp is 0-24 chars 	
	try:
	  parsed_ts=time.strptime(line[:24])
	except ValueError:
	  self.log.debug("Bad Time Format: " + line)
          return()
        ts=time.mktime(parsed_ts)
	# Split the line
        fields=line.split(' ', 7)
        
        # Pull out hostname and pid from "hostname[PID]"
        pattern=re.compile('(.*)\[(\d+)\]')
        hostname, pid = pattern.match(fields[5]).groups()

	# Client program
        util=fields[6].rstrip(':')	

	# Get the message
	log_msg=fields[7]
        pattern=re.compile("(\d+) (\d+) Username: (.+) UID: (\d+)")
        if pattern.match(log_msg):
          user=pattern.search(log_msg).group(3).strip()
          uid=pattern.search(log_msg).group(4)
	  result = ({'ts':ts, 'event':'hsi.event', 'hostname':hostname, 'pid':pid, 'util':util, 'msg':log_msg, 'user':user, 'uid':uid},)
	else:
          result = ({'ts':ts, 'event':'hsi.event', 'hostname':hostname, 'pid':pid, 'util':util, 'msg':log_msg},)
        return result

