#!/usr/bin/env python
"""
Unittests for condor_dag.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseCondorDag.py 23923 2009-09-18 22:42:26Z ksb $'

import unittest
from netlogger.tests import shared
from netlogger.parsers.modules import condor_dag

class TestCase(shared.BaseParserTestCase):
    """Unit test cases.
    """
    basename = "condor_dag_parser-"
    parser_class = condor_dag.Parser

    def setUp(self):
        shared.BaseParserTestCase.setUp(self)
        self.set_up_nl_logger()

    def testBasic(self):
        """Basic test of the parser
        """
        filename = "sample.log"
        # count lines in file that have "PARENT" in them
        expected = 0
        for line in file(self.getFullPath(filename)):
            if 'PARENT' in line:
                expected += 1
        # Check if all (expected) lines got parsed
        self.checkGood(filename=filename, num_expected=expected)

    def testCrazy(self):
        """Test parser against cuh-RAY-zeee inputs
        """
        filename = "crazy.log"
        self.checkGood(filename=filename, num_expected=0)


# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()


