#!/usr/bin/env python
"""
Unittests for <module>.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseCsaAcct.py 23798 2009-07-14 17:18:22Z dang $'

import unittest
from netlogger.tests import shared
from netlogger.parsers.modules import csa_acct

class TestCase(shared.BaseParserTestCase):
    """Unit test cases.
    """
    basename = "csa_acct-"
    parser_class = csa_acct.Parser

    def testBasic(self):
        """Parse the sample log
        """
        filename = "basic.log"
        # count lines in file
        expected = len(list(file(self.getFullPath(filename))))
        # Try default (one event) mode
        self.checkGood(filename=filename, num_expected=expected)
        # Try two-event mode
        self.checkGood(filename=filename, num_expected=expected*2, 
                       parser_kw = dict(one_event=False))
        
# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()


