#!/usr/bin/env python
"""
Unittests for gram_acct.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseGramAcct.py 23798 2009-07-14 17:18:22Z dang $'

import unittest
from netlogger.tests import shared
from netlogger.parsers.modules import gram_acct

class TestCase(shared.BaseParserTestCase):
    """Unit test cases.
    """
    basename = "gram_acct-"
    parser_class = gram_acct.Parser

    def testBasic(self):
        """Parse the sample log
        """
        filename = "basic.log"
        # count jobs in file
        expected = 0
        f = file(self.getFullPath(filename))
        for line in f:
            if "GRAM_SCRIPT_JOB_ID" in line:
                expected += 1
        # see if all jobs are found
        self.checkGood(filename=filename, num_expected=expected)

# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()


