#!/usr/bin/env python
"""
Unittests for sge.py
"""
__author__ = 'Shreyas Cholia scholia@lbl.gov'
__rcsid__ = '$Id$'

import unittest
import time
import re
from netlogger.tests import shared
from netlogger.parsers.modules import hsi_ndapi

class TestCase(shared.BaseParserTestCase):
    basename = 'hsi_ndapi-'
    parser_class = hsi_ndapi.Parser

    def __init__(self, *args, **kw):
        shared.BaseParserTestCase.__init__(self, *args, **kw)

    def testBasic(self):
        """Test for correctly parsed lines
        """
        def _test(e, num):
            # Count number of fields in e
            self.assert_(e.has_key('ts'))
            self.assert_(e.has_key('pid'))
            self.assertNotEquals(e['event'], '')
	filename='ndapilog'
	expected=0
        pattern=re.compile('\w{3} \w{3} \d{1,2} \d{1,2}:\d{1,2}:\d{1,2} \d{4}'
)
	for line in list(file(self.getFullPath(filename))):
	  if pattern.match(line):
            expected+=1
        self.checkGood(filename=filename, test=_test, num_expected=expected)


# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()
