#!/usr/bin/env python
"""
Unittests for Pegasus jobstate parser.
"""
__author__ = 'Dan Gunter <dkgunter@lbl.gov>'
__rcsid__ = '$Id: testParseJobstate.py 23798 2009-07-14 17:18:22Z dang $'

import unittest
from netlogger import nlapi
from netlogger.tests import shared
from netlogger.parsers.modules import jobstate

class TestCase(shared.BaseParserTestCase):
    basename = 'jobstate-'
    parser_class = jobstate.Parser
    NUM = 6

    def testWithoutHeader(self):
        """Test for lines without a header
        """
        def _test(event, num):
            self.must_have(event, {'event':'pegasus\.jobstate\.\S+',
                                   'comp.id':'CyberShake_USC_.*'}, regex=True)
        self.checkGood(filename="nohdr.log", test=_test,
                       num_expected=self.NUM)

    def testWithHeader(self):
        """Test for lines with a header
        """
        def _test(event, num):
            self.must_have(event, {'event':'pegasus\.jobstate\.\S+',
                                   jobstate.Parser.WORKFLOW_LABEL : '\S+'},
                           regex=True)
        self.checkGood(filename="hdr.log", test=_test, num_expected=self.NUM)

# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()
