#!/usr/bin/env python
"""
Unittests for pbs_parser.py
"""
__author__ = 'Shreyas Cholia scholia@lbl.gov'
__rcsid__ = '$Id: testParsePBS.py 23798 2009-07-14 17:18:22Z dang $'

import unittest
from netlogger.tests import shared
from netlogger.parsers.modules import pbs

class TestCase(shared.BaseParserTestCase):
    """Unit test cases.
    """
    basename = "pbs_parser-"
    parser_class = pbs.Parser

    def testBasic(self):
        """Basic test of pbs_parser
        """
        # the full path should be data/pbs_parser-sample.log
        filename = "sample.log"
        # count lines in file
        expected = len(list(file(self.getFullPath(filename))))
        # Check if all lines got parsed
        self.checkGood(filename=filename, num_expected=expected)
        
# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()


