"""
Benchmark the tsreg module.
"""
import random
import sys
import time
#
import tsreg

def main(outp=None):
    if outp is None:
        outp = sys.stdout
    # Measure
    DELTAS = 1, 2,  4, 8, 16
    SIZES = map(int, (1e3, 1e4, 5e4, 1e5))
    I = 1
    outp.write("Num\tDur\tTime\n")
    for sz in SIZES:
        for delta in DELTAS:
            t, d, v = [ ], [ ], [ ]
            for i in xrange(sz):
                t.append(random.uniform(i - I/2, i + I/2))
                d.append(random.uniform(delta/2, delta*2))
                v.append(random.random())
            n = sz * I
            t0 = time.time()
            _ = tsreg.reg((t, d, v), I, (0, n))
            t1 = time.time()
            outp.write("%d\t%d\t%g\n" % (sz, delta, t1 - t0))
    return 0

if __name__ == '__main__':
    sys.exit(main())
