#!/usr/bin/env python
"""
Unittests for FIFODict.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testFIFODict.py 23798 2009-07-14 17:18:22Z dang $'

# Standard library imports
import time
import unittest
# NetLogger imports
from netlogger.tests import shared
from netlogger.util import FIFODict

class TestCase(shared.BaseTestCase):
    """Unit test cases.
    """
    def testAdd(self):
        """The add() method
        """
        n = 2
        fifod = FIFODict(n)
        for i in range(n):
            # new keys should return True
            self.failUnless(fifod.add(i))
        for i in range(n):
            # old keys should return False
            self.failIf(fifod.add(i))
        for i in range(n, 2*n):
            # more new keys (kick out old)
            self.failUnless(fifod.add(i))
        for i in range(n):
            # old is now new
            self.failUnless(fifod.add(i))
            
    def testTiming(self):
        """Time FIFO additions
        """
        # Just for fun, do 1 timing
        SZ = 10000
        N = 2 * SZ
        d = FIFODict(SZ)
        t0 = time.time()
        for i in xrange(N):
            d.add(i)
        t1 = time.time()
        self.debug_("inserting %d items in a FIFO of %d "
                    "took %lf sec (%lf usec/item)" %
                (N, SZ, t1 - t0, ((t1 - t0) / float(N)) * 1e6))
        self.assert_(t1 - t0 < (SZ/1000), "your computer is too slow!")
 
# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()
