"""
Unittests for parsers/modules/dynamic.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseDynamic.py 23614 2009-03-26 16:27:48Z dang $'

## Imports

import re
from StringIO import StringIO
import unittest
#
from netlogger.parsers.modules import dynamic
from netlogger.parsers.modules import globus_condor
from netlogger.tests import shared
import testParseGlobusCondor
## Constants and Global Variables

HEADER = "MyApp "
EVENT1 = HEADER + "This-is-my-data  "

## Classes

class Parser:
    """Dummy parser class
    """
    def process(self, line):
        return line
    def setHeaderValues(self, data):
        return

class TestCase(shared.BaseTestCase):
    """Unit test cases.
    """

    def setUp(self):
        """Create a parser instance.
        """
        self.parser = dynamic.Parser(StringIO("FAKE"), pattern="(?P<app>\S+)")

    def tearDown(self):
        """Any cleanup actions
        """
        pass

    def testStripWhitespace(self):
        """Make sure leading/trailing whitespace is stripped.
        """
        self.parser.add('me', {'app':re.compile("MyApp")}, Parser())
        value = self.parser.process(EVENT1)
        self.failUnless(value.strip() ==  value, "Whitespace in '%s'" % value)

    def testStripWhitespaceGC(self):
        """Check globus_condor parser with whitespace stripping
        """
        self.parser.add('gc', {'app':re.compile("MyApp")}, 
                        globus_condor.Parser(StringIO("FAKE")))
        result = ()
        for line in testParseGlobusCondor.SUBMIT_EVENT.split("\n"):
            self.failIf(result, "Event parsed prematurely")
            event = HEADER + line
            result = self.parser.process(event)            
        self.failUnless(len(result) == 1, "Event not parsed")

# Boilerplate to run the tests
def suite(): 
    return shared.suite(TestCase)
if __name__ == '__main__':
    shared.main()
