#!/usr/bin/env python
"""
Fake job that does a little CEDPS logging to standard err
"""
import os
import sys
import random
import socket
import syslog
import time
import uuid


SYSLOG_HOST, SYSLOG_PORT = 'netlogger.lbl.gov', 5141
_sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
#_sock.connect((SYSLOG_HOST, SYSLOG_PORT))

try:
    _ip = socket.gethostbyname(socket.getfqdn())
except:
    _ip = '127.0.0.1'

def _syslogHeader(host=_ip, program="fake_job.py"):
    """Return string to be used as a message header for syslogging it """
    # build syslog 'priority'
    pri =  "<%d>" % (syslog.LOG_USER + syslog.LOG_INFO)
    # build syslog formatted date
    localtime = time.localtime()
    day = time.strftime("%d", localtime)
    if day[0] == "0":
        day = " " + day[1:]  # syslog RFC says this MUST be a space
    val = time.strftime("%b %%s %H:%M:%S", localtime)
    date = val % day 
    # put it all together
    return "%s%s %s %s: " % (pri, date, host, program)

DATE_FMT = "%04d-%02d-%02dT%02d:%02d:%02d"
def formatDate(t):
    gmtm = time.gmtime(t)
    usec = int((t - int(t)) * 1000000 + 0.5)
    return "%s.%06dZ" % (DATE_FMT % gmtm[0:6], usec)

def log(event, level="Info", **kw):
    curtm = time.time()
    ts = formatDate(time.time())
    line = "ts=%s event=fake_job.%s level=%s guid=%s" % (
        ts, event, level, guid)
    line += ''.join([" %s=%s" % i for i in kw.items()])
    hdr = _syslogHeader()
    _sock.sendto(hdr + line + "\n", (SYSLOG_HOST, SYSLOG_PORT))

def write_output():
    f = open('/scratch/osg-demo/output.txt', 'w')
    f.write('foobar, foobar, foobar\n')
    f.close()

def run(min_sec=1, max_sec=2):
    run_sec = random.randint(min_sec, max_sec)
    log("start")
    time.sleep(run_sec)
    write_output()
    log("end", status='0')

def fail():
    log("start")
    time.sleep(0.5)
    log("end", status='-1', level="Error")

def hang():
    log("start")
    time.sleep(1000)
    log("end", status='0')

if __name__ == '__main__':
    global guid
    if len(sys.argv) > 1:
        guid = sys.argv[1]
    else:
        guid = os.environ[GLOBUS_GRAM_JOB_HANDLE].split('?')[1]
        #guid = str(uuid.uuid4())
    os.system('touch /scratch/osg-demo/output.txt')
    os.system('rm /scratch/osg-demo/output.txt')
    random.seed()
    fn = random.choice((run, fail, hang))
    fn()
