#!/usr/bin/env python
import time, random, os, socket, sys, syslog, uuid

SYSLOG_HOST, SYSLOG_PORT = 'netlogger.lbl.gov', 5141
_sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
#_sock.connect((SYSLOG_HOST, SYSLOG_PORT))

hostname = socket.getfqdn()
try:
    _ip = socket.gethostbyname(hostname)
except:
    _ip = '127.0.0.1'

def _syslogHeader(host=_ip, program="fake_job.py"):
    """Return string to be used as a message header for syslogging it """
    # build syslog 'priority'
    pri =  "<%d>" % (syslog.LOG_USER + syslog.LOG_INFO)
    # build syslog formatted date
    localtime = time.localtime()
    day = time.strftime("%d", localtime)
    if day[0] == "0":
        day = " " + day[1:]  # syslog RFC says this MUST be a space
    val = time.strftime("%b %%s %H:%M:%S", localtime)
    date = val % day 
    # put it all together
    return "%s%s %s %s: " % (pri, date, host, program)

DATE_FMT = "%04d-%02d-%02dT%02d:%02d:%02d"
def formatDate(t):
    gmtm = time.gmtime(t)
    usec = int((t - int(t)) * 1000000 + 0.5)
    return "%s.%06dZ" % (DATE_FMT % gmtm[0:6], usec)

def log(event, level="Info", **kw):
    curtm = time.time()
    ts = formatDate(time.time())
    line = "ts=%s event=firewall_test_%s.%s level=%s guid=%s" % (
        ts, hostname, event, level, guid)
    line += ''.join([" %s=%s" % i for i in kw.items()])
    hdr = _syslogHeader()
    _sock.sendto(hdr + line + "\n", (SYSLOG_HOST, SYSLOG_PORT))

def firewall_on():
    log('start_firewall_on')
    os.system("/sbin/iptables -A INPUT -p TCP --dport 50000:51000 -j REJECT")
    os.system("/sbin/iptables -A INPUT -p TCP --sport 50000:51000 -j REJECT")
    log('stop_firewall_on')

def firewall_off():
    log('start_firewall_off')
    os.system("/sbin/iptables -D INPUT 2")
    os.system("/sbin/iptables -D INPUT 1")
    log('stop_firewall_off')
    
def main():
    global guid
    if len(sys.argv) > 1:
        guid = sys.argv[1]
    else:
        guid = str(uuid.uuid4())
    random.seed()
    while True:
        firewall_on()
        print "firewall on"
        time.sleep(300 + random.randint(60, 240))
        firewall_off()
        print "firewall off"
        time.sleep(2400 + random.randint(60, 480))


if __name__ == '__main__':
    main()
