"""
Controller for CEDPS DB query pages
"""
# python imports
import time
from datetime import datetime
import logging
# turbogears and cherrypy imports
from turbogears import controllers, expose, flash

import pkg_resources
try:
    pkg_resources.require("SQLObject>=0.8,<=0.10.0")
except pkg_resources.DistributionNotFound:
    import sys
    print >> sys.stderr, """You are required to install SQLObject but appear not to have done so.
Please run your projects setup.py or run `easy_install SQLObject`.

"""
    sys.exit(1)
from turbogears import identity, redirect, widgets, validators
from cherrypy import request, response
# project imports
from cedps_ts import json
from cedps_ts import model

# logging
log = logging.getLogger("cedps_ts.controllers")
log.setLevel(logging.DEBUG)

# globals
db = model.DB()
date_fmt = "%Y-%m-%d %H:%M:%S"
now = time.time()
week_sec = 60*60*24*7
formatDate = lambda d: datetime.fromtimestamp(d).strftime(date_fmt)
parseDate = lambda d, fmt: time.mktime(datetime.strptime(d, fmt).timetuple())

gridftp_form = widgets.TableForm(
    fields = [ 
        widgets.CalendarDateTimePicker(
            label = _('Start date'),
            name = 'start_date',
            calendar_lang = 'en',
            format = date_fmt,
            validator = validators.DateTimeConverter(format=date_fmt),
            default=formatDate(now - week_sec), ),
        widgets.CalendarDateTimePicker(
            label = _('End date'),
            name = 'end_date',
            calendar_lang = 'en',
            format = date_fmt,
            validator = validators.DateTimeConverter(format=date_fmt),
            default=formatDate(now), ),
        widgets.HiddenField(name='gridftp'),
        ],
    action = 'query',
    )
def gridftpValidate(kw):
    for name in ('start_date', 'end_date'):
        if not kw.get(name, None):
            return '%s is required' % gridftp_form_labels[name]
    return None
gridftp_form.validate = gridftpValidate
gridftp_form_labels = { }
for field in gridftp_form.fields:
    gridftp_form_labels[field.name] = field.label
    

grep_form = widgets.TableForm(
    fields = [ 
        widgets.TextField(
            label = _('Event'),
            name = 'event',
            ),
        widgets.TextField(
            label = _('DN'),
            name = 'dn',
            ),
        widgets.CalendarDateTimePicker(
            label = _('Start date'),
            name = 'start_date',
            calendar_lang = 'en',
            format = date_fmt,
            validator = validators.DateTimeConverter(format=date_fmt),
            default=formatDate(now - week_sec), ),
        widgets.CalendarDateTimePicker(
            label = _('End date'),
            name = 'end_date',
            calendar_lang = 'en',
            format = date_fmt,
            validator = validators.DateTimeConverter(format=date_fmt),
            default=formatDate(now), ),
        widgets.TextField(
            label = _('Max rows'),
            name = 'limit',
            default='100',
            ),
        widgets.HiddenField(name='grep'),
        ],
    action = 'query',
    )
grep_form.validate = lambda x: None

all_forms = { 'gridftp' : gridftp_form,
              'grep' : grep_form }

class Root(controllers.RootController):
    """Root document for web pages
    """
    query_types = ('gridftp', 'grep')

    class QueryType:
        def __init__(self, name, is_sel):
            self.name = name
            self.is_selected = is_sel
        def __repr__(self):
            return "Query[name=%s,is_selected=%s]" % (self.name, self.is_selected)
        __str__ = __repr__

    @expose(template=".templates.query")
    def query(self, tg_errors=None, data=None, data_cols=None, 
              query_type=None, **kw):
        log.debug("query.start")
        input_ok, show_form = True, None
        if query_type: # switching query type
            input_ok = False 
            show_form = all_forms[query_type]                
        else: # look for hidden field value
            for qt in all_forms.keys():
                if kw.has_key(qt):
                    query_type = qt
                    break
        if query_type is not None and input_ok:
            input_ok = True
            if tg_errors:
                flash('There was a problem with the form!')
                input_ok = False
            else:
                show_form = all_forms[query_type]                
                error = show_form.validate(kw)
                if error:
                    flash(error)
                    input_ok = False
        if query_type is not None and input_ok:
            fn = getattr(self,'%sQuery' % query_type)
            data_cols, data = fn(**kw)         
        qt_nav = [ ]
        for qt in self.query_types:
            if qt == query_type:
                qt_nav.append(self.QueryType(qt, True))
            else:
                qt_nav.append(self.QueryType(qt, False))
        log.debug("query.returning qt_nav=%s" % qt_nav)
        return dict(form=show_form, form_data=kw, qt_nav=qt_nav,
                    data=data, data_cols=data_cols)

    def _parseStartEnd(self, kw):
        for d in 'start', 'end':
            kw['%s_sec' % d] = parseDate(kw['%s_date' % d], date_fmt)
        
    def gridftpQuery(self, **kw):
        self._parseStartEnd(kw)
        return db.gridftpFailedJobsQuery(**kw)

    def grepQuery(self, **kw):
        self._parseStartEnd(kw)
        kw['limit'] = int(kw['limit'])
        #return (('bogus',),[('foo',)])
        return db.grepQuery(**kw)

    @expose(template="cedps_ts.templates.login")
    def login(self, forward_url=None, previous_url=None, *args, **kw):
        if not identity.current.anonymous \
            and identity.was_login_attempted() \
            and not identity.get_identity_errors():
            raise redirect(forward_url)
        forward_url=None
        previous_url= request.path
        if identity.was_login_attempted():
            msg=_("The credentials you supplied were not correct or "
                   "did not grant access to this resource.")
        elif identity.get_identity_errors():
            msg=_("You must provide your credentials before accessing "
                   "this resource.")
        else:
            msg=_("Please log in.")
            forward_url= request.headers.get("Referer", "/")
        response.status=403
        return dict(message=msg, previous_url=previous_url, logging_in=True,
                    original_parameters=request.params,
                    forward_url=forward_url)

    @expose()
    def logout(self):
        identity.current.logout()
        raise redirect("/")
