
"""    
    This package contains some of the nonsynthetic data sets that are used in examples of usage. 

    .. note:: For some data sets links to download pages are available here. All needed data preprocessing code
              for successful running of the particular example is included in its corresponding example code. In order
              to run the example download and put the data set in ``nimfa/datasets`` directory.
    
    List of data sets used in the examples. 
    
        #. Leukemia data set; `leukemia gene expressions`_, `leukemia samples`_, `leukemia genes`_.
        #. Medulloblastoma data set; `medulloblastoma gene expressions`_, `medulloblastoma samples`_, `medulloblastoma genes`_.
        #. `CBCL face images`_ database.
        #. `ORL face images`_ database.
        #. `MovieLens 100k`_ data set.
        #. `Medlars`_ data set.
        #. `S. cerevisiae`_ with annotations from the MIPS Functional Catalogue data set. 
        
    .. _leukemia gene expressions: http://www.broadinstitute.org/mpr/publications/projects/NMF/ALL_AML_data.txt
    .. _leukemia samples: http://www.broadinstitute.org/mpr/publications/projects/NMF/ALL_AML_samples.txt
    .. _leukemia genes: http://www.broadinstitute.org/mpr/publications/projects/NMF/ALL_AML_genes.txt
    .. _medulloblastoma gene expressions: http://www.broadinstitute.org/mpr/publications/projects/NMF/Medulloblastoma_data.txt
    .. _medulloblastoma samples: http://www.broadinstitute.org/mpr/publications/projects/NMF/Medulloblastomas_samples.txt
    .. _medulloblastoma genes: http://www.broadinstitute.org/mpr/publications/projects/NMF/Medulloblastoma_genes.txt
    .. _CBCL face images: http://cbcl.mit.edu/cbcl/software-datasets/FaceData2.html
    .. _ORL face images: http://www.cl.cam.ac.uk/research/dtg/attarchive/facedatabase.html
    .. _MovieLens 100k: http://www.grouplens.org/node/12
    .. _Medlars: http://web.eecs.utk.edu/research/lsi/
    .. _S. cerevisiae: http://dtai.cs.kuleuven.be/clus/hmc-ens/
        
"""