#!/usr/bin/env python
# -*- coding: utf-8 -*-


import nkit4py
import json


xml = '''\
<?xml version="1.0" encoding="utf-8" ?>
<data>
       <salon>
               <firmID>67</firmID>
               <name>АвтоГЕРМЕС Trade-in</name>
               <country>Россия</country>
               <city>Москва</city>
               <street>м. Южная, м. Чертановская, м. Варшавская, Варшавское шоссе</street>
               <house />
               <building />
               <office />
               <address_extra />
               <phone>+7(495)663-65-46</phone>
               <url>http://www.avtogermes.ru/sale/second_hand/</url>
               <email>tradein@avtogermes.ru</email>
               <e_contact />
               <contact_name />
               <working_time />
               <license />
               <info><![CDATA[Предложение от 04.07.2014. ]]></info>
       </salon>
       <salon>
               <firmID>487</firmID>
               <name>АвтоГЕРМЕС</name>
               <country>Россия</country>
               <city>Москва</city>
               <street>Шоссе Энтузиастов 59</street>
               <house />
               <building />
               <office />
               <address_extra />
               <phone>+7(495) 308-98-50</phone>
               <url>avtogermes.ru</url>
               <email>info@avtogermes.ru</email>
               <e_contact />
               <contact_name />
               <working_time />
               <license />
               <info><![CDATA[Предложение от 04.07.2014. ]]></info>
       </salon>
</data>'''

mapping = '''["/salon",
    {
        "/e_contact -> e-contact": "string",
        "/email -> email": "string",
        "/firmID -> salon-id": "integer",
        "/office -> office": "string",
        "/country -> country": "string",
        "/info -> info": "string",
        "/phone -> phone": "string",
        "/city -> city": "string",
        "/contact_name -> contact-name": "string",
        "/name -> name": "string",
        "/address_extra -> address-extra": "string",
        "/house -> house": "string",
        "/license -> license": "string",
        "/url -> url": "string",
        "/street -> address-full": "string",
        "/building -> building": "string",
        "/working_time -> working-time": "string"
    }
]'''

builder = nkit4py.Xml2VarBuilder(mapping)
builder.feed(xml)
result = builder.end()

json.dumps(result, indent=2, ensure_ascii=False,
           cls=nkit4py.DatetimeJSONEncoder)

