/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.OutputStream;
import org.python.core.Py;
import org.python.core.PyAttributeDeleted;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFileWriter;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyUnicode;
import org.python.core.util.StringUtil;

public class StdoutWrapper
extends OutputStream {
    protected String name = "stdout";

    protected PyObject getObject(PySystemState ss) {
        return ss.stdout;
    }

    protected void setObject(PySystemState ss, PyObject out) {
        ss.stdout = out;
    }

    protected PyObject myFile() {
        PySystemState ss = Py.getSystemState();
        PyObject out = this.getObject(ss);
        if (out == null) {
            throw Py.AttributeError("missing sys." + this.name);
        }
        if (out instanceof PyAttributeDeleted) {
            throw Py.RuntimeError("lost sys." + this.name);
        }
        if (out.getJavaProxy() != null) {
            PyFile f = null;
            Object tojava = out.__tojava__(OutputStream.class);
            if (tojava != null && tojava != Py.NoConversion) {
                f = new PyFile((OutputStream)tojava);
            }
            if (f != null) {
                this.setObject(ss, f);
                return f;
            }
        }
        return out;
    }

    @Override
    public void flush() {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            ((PyFile)out).flush();
        } else {
            try {
                out.invoke("flush");
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
    }

    public void write(String s) {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            ((PyFile)out).write(s);
        } else {
            out.invoke("write", new PyString(s));
        }
    }

    @Override
    public void write(int i) {
        this.write(new String(new char[]{(char)i}));
    }

    @Override
    public void write(byte[] data, int off, int len) {
        this.write(StringUtil.fromBytes(data, off, len));
    }

    public void flushLine() {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            PyFile file = (PyFile)out;
            if (file.softspace) {
                file.write("\n");
            }
            file.flush();
            file.softspace = false;
        } else {
            PyObject ss = out.__findattr__("softspace");
            if (ss != null && ss.__nonzero__()) {
                out.invoke("write", Py.Newline);
            }
            try {
                out.invoke("flush");
            }
            catch (PyException pyException) {
                // empty catch block
            }
            out.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }

    private String printToFile(PyFile file, PyObject o) {
        String s = o instanceof PyUnicode ? ((PyUnicode)o).encode(file.encoding, file.errors) : o.__str__().toString();
        file.write(s);
        return s;
    }

    private String printToFileWriter(PyFileWriter file, PyObject o) {
        String s = o instanceof PyString ? ((PyString)o).getString() : o.toString();
        file.write(s);
        return s;
    }

    private void printToFileObject(PyObject file, PyObject o) {
        if (!(o instanceof PyUnicode)) {
            o = o.__str__();
        }
        file.invoke("write", o);
    }

    public void print(PyObject[] args, PyObject sep, PyObject end) {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            PyFile file = (PyFile)out;
            for (int i = 0; i < args.length; ++i) {
                this.printToFile(file, args[i]);
                if (i >= args.length - 1) continue;
                this.printToFile(file, sep);
            }
            this.printToFile(file, end);
        } else if (out instanceof PyFileWriter) {
            PyFileWriter file = (PyFileWriter)out;
            for (int i = 0; i < args.length; ++i) {
                this.printToFileWriter(file, args[i]);
                if (i >= args.length - 1) continue;
                this.printToFileWriter(file, sep);
            }
            this.printToFileWriter(file, end);
        } else {
            for (int i = 0; i < args.length; ++i) {
                this.printToFileObject(out, args[i]);
                if (i >= args.length - 1) continue;
                this.printToFileObject(out, sep);
            }
            this.printToFileObject(out, end);
        }
    }

    public void print(PyObject o, boolean space, boolean newline) {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            PyFile file = (PyFile)out;
            if (file.softspace) {
                file.write(" ");
                file.softspace = false;
            }
            String s = this.printToFile(file, o);
            if (o instanceof PyString) {
                int len = s.length();
                if (len == 0 || !Character.isWhitespace(s.charAt(len - 1)) || s.charAt(len - 1) == ' ') {
                    file.softspace = space;
                }
            } else {
                file.softspace = space;
            }
            if (newline) {
                file.write("\n");
                file.softspace = false;
            }
            file.flush();
        } else if (out instanceof PyFileWriter) {
            PyFileWriter file = (PyFileWriter)out;
            if (file.softspace) {
                file.write(" ");
                file.softspace = false;
            }
            String s = this.printToFileWriter(file, o);
            if (o instanceof PyString) {
                int len = s.length();
                if (len == 0 || !Character.isWhitespace(s.charAt(len - 1)) || s.charAt(len - 1) == ' ') {
                    file.softspace = space;
                }
            } else {
                file.softspace = space;
            }
            if (newline) {
                file.write("\n");
                file.softspace = false;
            }
            file.flush();
        } else {
            PyObject ss = out.__findattr__("softspace");
            if (ss != null && ss.__nonzero__()) {
                out.invoke("write", Py.Space);
                out.__setattr__("softspace", (PyObject)Py.Zero);
            }
            this.printToFileObject(out, o);
            if (o instanceof PyString) {
                String s = o.toString();
                int len = s.length();
                if (len == 0 || !Character.isWhitespace(s.charAt(len - 1)) || s.charAt(len - 1) == ' ') {
                    out.__setattr__("softspace", (PyObject)(space ? Py.One : Py.Zero));
                }
            } else {
                out.__setattr__("softspace", (PyObject)(space ? Py.One : Py.Zero));
            }
            if (newline) {
                out.invoke("write", Py.Newline);
                out.__setattr__("softspace", (PyObject)Py.Zero);
            }
        }
    }

    public void print(String s) {
        this.print(new PyString(s), false, false);
    }

    public void println(String s) {
        this.print(new PyString(s), false, true);
    }

    public void print(PyObject o) {
        this.print(o, false, false);
    }

    public void printComma(PyObject o) {
        this.print(o, true, false);
    }

    public void println(PyObject o) {
        this.print(o, false, true);
    }

    public void println() {
        this.println(false);
    }

    public void println(boolean useUnicode) {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            PyFile file = (PyFile)out;
            file.write("\n");
            file.flush();
            file.softspace = false;
        } else {
            if (useUnicode) {
                out.invoke("write", Py.UnicodeNewline);
            } else {
                out.invoke("write", Py.Newline);
            }
            out.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }
}

