#!/usr/bin/env python
# -*- coding: utf-8 -*-
from distutils.core import setup
import os
import subprocess
from pip.req import parse_requirements
from setuptools.command import easy_install


def calculate_version():
    # Fetch version from git tags, and write to version.py.
    # Also, when git is not available (PyPi package), use stored version.py.
    version_py = os.path.join(os.path.dirname(__file__), 'version.py')
    try:
        version_git = subprocess.check_output(["git", "describe"]).rstrip()
    except Exception:
        with open(version_py, 'r') as fh:
            version_git = (open(version_py).read()
                           .strip().split('=')[-1].replace('"', ''))
    version_msg = ('# Do not edit this file, pipeline versioning is '
                   'governed by git tags')
    with open(version_py, 'w') as fh:
        fh.write(version_msg + os.linesep + "__version__=" + version_git)
    return version_git


requirements = [str(ir.req) for ir in parse_requirements('requirements.txt')]
version_git = calculate_version()


def get_long_description():
    readme_file = 'README.md'
    if not os.path.isfile(readme_file):
        return ''
    # Try to transform the README from Markdown to reStructuredText.
    try:
        easy_install.main(['-U', 'pyandoc==0.0.1'])
        import pandoc
        pandoc.core.PANDOC_PATH = 'pandoc'
        doc = pandoc.Document()
        doc.markdown = open(readme_file).read()
        description = doc.rst
    except Exception:
        description = open(readme_file).read()
    return description


setup(
    name='noaaclass',
    version=version_git,
    author=u'Eloy Adonis Colell',
    author_email='eloy.colell@gmail.com',
    packages=['noaaclass', ],
    url='https://github.com/ecolell/noaaclass',
    license='MIT',
    description=('A python library that allow to request images '
                 'to the NOAA CLASS (Comprehensive Large Array-Data '
                 'Stewardship System).'),
    long_description=get_long_description(),
    zip_safe=True,
    install_requires=requirements,
    classifiers=[
        "Intended Audience :: Science/Research",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.2",
        "Programming Language :: Python :: 3.3",
        "Topic :: Scientific/Engineering :: Atmospheric Science",
        "Topic :: Scientific/Engineering :: Bio-Informatics",
        "Topic :: Scientific/Engineering :: GIS",
        "Topic :: Scientific/Engineering :: Information Analysis",
        "Topic :: Scientific/Engineering :: Physics",
    ],
)
