#!/usr/bin/env python

__version__ = '$Revision: 4791 $'.split()[1]
__date__ = '$Date: 2012-10-20 $'.split()[1]
__author__ = 'xmlbinmsg'

__doc__='''

Autogenerated python functions to serialize/deserialize binary messages.

Generated by: ../scripts/aisxmlbinmsg2py.py

Need to then wrap these functions with the outer AIS packet and then
convert the whole binary blob to a NMEA string.  Those functions are
not currently provided in this file.

serialize: python to ais binary
deserialize: ais binary to python

The generated code uses translators.py, binary.py, and aisstring.py
which should be packaged with the resulting files.


@requires: U{epydoc<http://epydoc.sourceforge.net/>} > 3.0alpha3
@requires: U{BitVector<http://cheeseshop.python.org/pypi/BitVector>}

@author: '''+__author__+'''
@version: ''' + __version__ +'''
@var __date__: Date of last svn commit
@undocumented: __version__ __author__ __doc__ parser
@status: under development
@license: Generated code has no license
@todo: FIX: put in a description of the message here with fields and types.
'''

import sys
from decimal import Decimal
from BitVector import BitVector

import binary, aisstring

# FIX: check to see if these will be needed
TrueBV  = BitVector(bitstring="1")
"Why always rebuild the True bit?  This should speed things up a bunch"
FalseBV = BitVector(bitstring="0")
"Why always rebuild the False bit?  This should speed things up a bunch"


fieldList = (
	'MessageID',
	'RepeatIndicator',
	'UserID',
	'Spare',
	'offset1',
	'numslots1',
	'timeout1',
	'increment1',
	'offset2',
	'numslots2',
	'timeout2',
	'increment2',
	'offset3',
	'numslots3',
	'timeout3',
	'increment3',
	'offset4',
	'numslots4',
	'timeout4',
	'increment4',
	'variablespare',
)

fieldListPostgres = (
	'MessageID',
	'RepeatIndicator',
	'UserID',
	'Spare',
	'offset1',
	'numslots1',
	'timeout1',
	'increment1',
	'offset2',
	'numslots2',
	'timeout2',
	'increment2',
	'offset3',
	'numslots3',
	'timeout3',
	'increment3',
	'offset4',
	'numslots4',
	'timeout4',
	'increment4',
	'variablespare',
)

toPgFields = {
}
'''
Go to the Postgis field names from the straight field name
'''

fromPgFields = {
}
'''
Go from the Postgis field names to the straight field name
'''

pgTypes = {
}
'''
Lookup table for each postgis field name to get its type.
'''

def encode(params, validate=False):
	'''Create a datalinkmng binary message payload to pack into an AIS Msg datalinkmng.

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 20 (field automatically set to "20")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): Unique ship identification number (MMSI)
	  - Spare(uint): Not used.  Should be set to zero. (field automatically set to "0")
	  - offset1(uint): Reserved offset number
	  - numslots1(uint): Number of reserved consecutive slots
	  - timeout1(uint): Time-out value in minutes
	  - increment1(uint): Increment to repeast reservation of this block
	  - offset2(uint): Reserved offset number (optional)
	  - numslots2(uint): Number of reserved consecutive slots (optional)
	  - timeout2(uint): Time-out value in minutes (optional)
	  - increment2(uint): Increment to repeast reservation of this block (optional)
	  - offset3(uint): Reserved offset number (optional)
	  - numslots3(uint): Number of reserved consecutive slots (optional)
	  - timeout3(uint): Time-out value in minutes (optional)
	  - increment3(uint): Increment to repeast reservation of this block (optional)
	  - offset4(uint): Reserved offset number (optional)
	  - numslots4(uint): Number of reserved consecutive slots (optional)
	  - timeout4(uint): Time-out value in minutes (optional)
	  - increment4(uint): Increment to repeast reservation of this block (optional)
	  - variablespare(uint): This field is a serious pain.  This padding makes the message byte aligned (field automatically set to "0")
	@param params: Dictionary of field names/values.  Throws a ValueError exception if required is missing
	@param validate: Set to true to cause checking to occur.  Runs slower.  FIX: not implemented.
	@rtype: BitVector
	@return: encoded binary message (for binary messages, this needs to be wrapped in a msg 8
	@note: The returned bits may not be 6 bit aligned.  It is up to you to pad out the bits.
	'''

	bvList = []
	bvList.append(binary.setBitVectorSize(BitVector(intVal=20),6))
	if 'RepeatIndicator' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['RepeatIndicator']),2))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),2))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['UserID']),30))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=0),2))
	if 'offset1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['offset1']),12))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),12))
	if 'numslots1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['numslots1']),4))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),4))
	if 'timeout1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['timeout1']),3))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),3))
	if 'increment1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['increment1']),11))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),11))
	if 'offset2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['offset2']),12))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),12))
	if 'numslots2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['numslots2']),4))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),4))
	if 'timeout2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['timeout2']),3))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),3))
	if 'increment2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['increment2']),11))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),11))
	if 'offset3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['offset3']),12))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),12))
	if 'numslots3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['numslots3']),4))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),4))
	if 'timeout3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['timeout3']),3))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),3))
	if 'increment3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['increment3']),11))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),11))
	if 'offset4' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['offset4']),12))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),12))
	if 'numslots4' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['numslots4']),4))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),4))
	if 'timeout4' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['timeout4']),3))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),3))
	if 'increment4' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['increment4']),11))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),11))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=0),6))

	return binary.joinBV(bvList)

def decode(bv, validate=False):
	'''Unpack a datalinkmng message 

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 20 (field automatically set to "20")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): Unique ship identification number (MMSI)
	  - Spare(uint): Not used.  Should be set to zero. (field automatically set to "0")
	  - offset1(uint): Reserved offset number
	  - numslots1(uint): Number of reserved consecutive slots
	  - timeout1(uint): Time-out value in minutes
	  - increment1(uint): Increment to repeast reservation of this block
	  - offset2(uint): Reserved offset number (optional)
	  - numslots2(uint): Number of reserved consecutive slots (optional)
	  - timeout2(uint): Time-out value in minutes (optional)
	  - increment2(uint): Increment to repeast reservation of this block (optional)
	  - offset3(uint): Reserved offset number (optional)
	  - numslots3(uint): Number of reserved consecutive slots (optional)
	  - timeout3(uint): Time-out value in minutes (optional)
	  - increment3(uint): Increment to repeast reservation of this block (optional)
	  - offset4(uint): Reserved offset number (optional)
	  - numslots4(uint): Number of reserved consecutive slots (optional)
	  - timeout4(uint): Time-out value in minutes (optional)
	  - increment4(uint): Increment to repeast reservation of this block (optional)
	  - variablespare(uint): This field is a serious pain.  This padding makes the message byte aligned (field automatically set to "0")
	@type bv: BitVector
	@param bv: Bits defining a message
	@param validate: Set to true to cause checking to occur.  Runs slower.  FIX: not implemented.
	@rtype: dict
	@return: params
	'''

	#Would be nice to check the bit count here..
	#if validate:
	#	assert (len(bv)==FIX: SOME NUMBER)
	r = {}
	r['MessageID']=20
	r['RepeatIndicator']=int(bv[6:8])
	r['UserID']=int(bv[8:38])
	r['Spare']=0
	r['offset1']=int(bv[40:52])
	r['numslots1']=int(bv[52:56])
	r['timeout1']=int(bv[56:59])
	r['increment1']=int(bv[59:70])
	if len(bv)<=72: return r; # All fields below are optional
	r['offset2']=int(bv[70:82])
	r['numslots2']=int(bv[82:86])
	r['timeout2']=int(bv[86:89])
	r['increment2']=int(bv[89:100])
	if len(bv)<=104: return r; # All fields below are optional
	r['offset3']=int(bv[100:112])
	r['numslots3']=int(bv[112:116])
	r['timeout3']=int(bv[116:119])
	r['increment3']=int(bv[119:130])
	if len(bv)<=136: return r; # All fields below are optional
	r['offset4']=int(bv[130:142])
	r['numslots4']=int(bv[142:146])
	r['timeout4']=int(bv[146:149])
	r['increment4']=int(bv[149:160])
	r['variablespare']=0
	return r

def decodeMessageID(bv, validate=False):
	return 20

def decodeRepeatIndicator(bv, validate=False):
	return int(bv[6:8])

def decodeUserID(bv, validate=False):
	return int(bv[8:38])

def decodeSpare(bv, validate=False):
	return 0

def decodeoffset1(bv, validate=False):
	return int(bv[40:52])

def decodenumslots1(bv, validate=False):
	return int(bv[52:56])

def decodetimeout1(bv, validate=False):
	return int(bv[56:59])

def decodeincrement1(bv, validate=False):
	return int(bv[59:70])

def decodeoffset2(bv, validate=False):
	return int(bv[70:82])

def decodenumslots2(bv, validate=False):
	return int(bv[82:86])

def decodetimeout2(bv, validate=False):
	return int(bv[86:89])

def decodeincrement2(bv, validate=False):
	return int(bv[89:100])

def decodeoffset3(bv, validate=False):
	return int(bv[100:112])

def decodenumslots3(bv, validate=False):
	return int(bv[112:116])

def decodetimeout3(bv, validate=False):
	return int(bv[116:119])

def decodeincrement3(bv, validate=False):
	return int(bv[119:130])

def decodeoffset4(bv, validate=False):
	return int(bv[130:142])

def decodenumslots4(bv, validate=False):
	return int(bv[142:146])

def decodetimeout4(bv, validate=False):
	return int(bv[146:149])

def decodeincrement4(bv, validate=False):
	return int(bv[149:160])

def decodevariablespare(bv, validate=False):
	return 0


def printHtml(params, out=sys.stdout):
		out.write("<h3>datalinkmng</h3>\n")
		out.write("<table border=\"1\">\n")
		out.write("<tr bgcolor=\"orange\">\n")
		out.write("<th align=\"left\">Field Name</th>\n")
		out.write("<th align=\"left\">Type</th>\n")
		out.write("<th align=\"left\">Value</th>\n")
		out.write("<th align=\"left\">Value in Lookup Table</th>\n")
		out.write("<th align=\"left\">Units</th>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>MessageID</td>\n")
		out.write("<td>uint</td>\n")
		if 'MessageID' in params:
			out.write("	<td>"+str(params['MessageID'])+"</td>\n")
			out.write("	<td>"+str(params['MessageID'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>RepeatIndicator</td>\n")
		out.write("<td>uint</td>\n")
		if 'RepeatIndicator' in params:
			out.write("	<td>"+str(params['RepeatIndicator'])+"</td>\n")
			if str(params['RepeatIndicator']) in RepeatIndicatorDecodeLut:
				out.write("<td>"+RepeatIndicatorDecodeLut[str(params['RepeatIndicator'])]+"</td>")
			else:
				out.write("<td><i>Missing LUT entry</i></td>")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>UserID</td>\n")
		out.write("<td>uint</td>\n")
		if 'UserID' in params:
			out.write("	<td>"+str(params['UserID'])+"</td>\n")
			out.write("	<td>"+str(params['UserID'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>Spare</td>\n")
		out.write("<td>uint</td>\n")
		if 'Spare' in params:
			out.write("	<td>"+str(params['Spare'])+"</td>\n")
			out.write("	<td>"+str(params['Spare'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>offset1</td>\n")
		out.write("<td>uint</td>\n")
		if 'offset1' in params:
			out.write("	<td>"+str(params['offset1'])+"</td>\n")
			out.write("	<td>"+str(params['offset1'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>numslots1</td>\n")
		out.write("<td>uint</td>\n")
		if 'numslots1' in params:
			out.write("	<td>"+str(params['numslots1'])+"</td>\n")
			out.write("	<td>"+str(params['numslots1'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>timeout1</td>\n")
		out.write("<td>uint</td>\n")
		if 'timeout1' in params:
			out.write("	<td>"+str(params['timeout1'])+"</td>\n")
			out.write("	<td>"+str(params['timeout1'])+"</td>\n")
		out.write("<td>min</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>increment1</td>\n")
		out.write("<td>uint</td>\n")
		if 'increment1' in params:
			out.write("	<td>"+str(params['increment1'])+"</td>\n")
			out.write("	<td>"+str(params['increment1'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>offset2</td>\n")
		out.write("<td>uint</td>\n")
		if 'offset2' in params:
			out.write("	<td>"+str(params['offset2'])+"</td>\n")
			out.write("	<td>"+str(params['offset2'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>numslots2</td>\n")
		out.write("<td>uint</td>\n")
		if 'numslots2' in params:
			out.write("	<td>"+str(params['numslots2'])+"</td>\n")
			out.write("	<td>"+str(params['numslots2'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>timeout2</td>\n")
		out.write("<td>uint</td>\n")
		if 'timeout2' in params:
			out.write("	<td>"+str(params['timeout2'])+"</td>\n")
			out.write("	<td>"+str(params['timeout2'])+"</td>\n")
		out.write("<td>min</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>increment2</td>\n")
		out.write("<td>uint</td>\n")
		if 'increment2' in params:
			out.write("	<td>"+str(params['increment2'])+"</td>\n")
			out.write("	<td>"+str(params['increment2'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>offset3</td>\n")
		out.write("<td>uint</td>\n")
		if 'offset3' in params:
			out.write("	<td>"+str(params['offset3'])+"</td>\n")
			out.write("	<td>"+str(params['offset3'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>numslots3</td>\n")
		out.write("<td>uint</td>\n")
		if 'numslots3' in params:
			out.write("	<td>"+str(params['numslots3'])+"</td>\n")
			out.write("	<td>"+str(params['numslots3'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>timeout3</td>\n")
		out.write("<td>uint</td>\n")
		if 'timeout3' in params:
			out.write("	<td>"+str(params['timeout3'])+"</td>\n")
			out.write("	<td>"+str(params['timeout3'])+"</td>\n")
		out.write("<td>min</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>increment3</td>\n")
		out.write("<td>uint</td>\n")
		if 'increment3' in params:
			out.write("	<td>"+str(params['increment3'])+"</td>\n")
			out.write("	<td>"+str(params['increment3'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>offset4</td>\n")
		out.write("<td>uint</td>\n")
		if 'offset4' in params:
			out.write("	<td>"+str(params['offset4'])+"</td>\n")
			out.write("	<td>"+str(params['offset4'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>numslots4</td>\n")
		out.write("<td>uint</td>\n")
		if 'numslots4' in params:
			out.write("	<td>"+str(params['numslots4'])+"</td>\n")
			out.write("	<td>"+str(params['numslots4'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>timeout4</td>\n")
		out.write("<td>uint</td>\n")
		if 'timeout4' in params:
			out.write("	<td>"+str(params['timeout4'])+"</td>\n")
			out.write("	<td>"+str(params['timeout4'])+"</td>\n")
		out.write("<td>min</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>increment4</td>\n")
		out.write("<td>uint</td>\n")
		if 'increment4' in params:
			out.write("	<td>"+str(params['increment4'])+"</td>\n")
			out.write("	<td>"+str(params['increment4'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>variablespare</td>\n")
		out.write("<td>uint</td>\n")
		if 'variablespare' in params:
			out.write("	<td>"+str(params['variablespare'])+"</td>\n")
			out.write("	<td>"+str(params['variablespare'])+"</td>\n")
		out.write("</tr>\n")
		out.write("</table>\n")

def printFields(params, out=sys.stdout, format='std', fieldList=None, dbType='postgres'):
	'''Print a datalinkmng message to stdout.

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 20 (field automatically set to "20")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): Unique ship identification number (MMSI)
	  - Spare(uint): Not used.  Should be set to zero. (field automatically set to "0")
	  - offset1(uint): Reserved offset number
	  - numslots1(uint): Number of reserved consecutive slots
	  - timeout1(uint): Time-out value in minutes
	  - increment1(uint): Increment to repeast reservation of this block
	  - offset2(uint): Reserved offset number (optional)
	  - numslots2(uint): Number of reserved consecutive slots (optional)
	  - timeout2(uint): Time-out value in minutes (optional)
	  - increment2(uint): Increment to repeast reservation of this block (optional)
	  - offset3(uint): Reserved offset number (optional)
	  - numslots3(uint): Number of reserved consecutive slots (optional)
	  - timeout3(uint): Time-out value in minutes (optional)
	  - increment3(uint): Increment to repeast reservation of this block (optional)
	  - offset4(uint): Reserved offset number (optional)
	  - numslots4(uint): Number of reserved consecutive slots (optional)
	  - timeout4(uint): Time-out value in minutes (optional)
	  - increment4(uint): Increment to repeast reservation of this block (optional)
	  - variablespare(uint): This field is a serious pain.  This padding makes the message byte aligned (field automatically set to "0")
	@param params: Dictionary of field names/values.  
	@param out: File like object to write to
	@rtype: stdout
	@return: text to out
	'''

	if 'std'==format:
		out.write("datalinkmng:\n")
		if 'MessageID' in params: out.write("	MessageID:        "+str(params['MessageID'])+"\n")
		if 'RepeatIndicator' in params: out.write("	RepeatIndicator:  "+str(params['RepeatIndicator'])+"\n")
		if 'UserID' in params: out.write("	UserID:           "+str(params['UserID'])+"\n")
		if 'Spare' in params: out.write("	Spare:            "+str(params['Spare'])+"\n")
		if 'offset1' in params: out.write("	offset1:          "+str(params['offset1'])+"\n")
		if 'numslots1' in params: out.write("	numslots1:        "+str(params['numslots1'])+"\n")
		if 'timeout1' in params: out.write("	timeout1:         "+str(params['timeout1'])+"\n")
		if 'increment1' in params: out.write("	increment1:       "+str(params['increment1'])+"\n")
		if 'offset2' in params: out.write("	offset2:          "+str(params['offset2'])+"\n")
		if 'numslots2' in params: out.write("	numslots2:        "+str(params['numslots2'])+"\n")
		if 'timeout2' in params: out.write("	timeout2:         "+str(params['timeout2'])+"\n")
		if 'increment2' in params: out.write("	increment2:       "+str(params['increment2'])+"\n")
		if 'offset3' in params: out.write("	offset3:          "+str(params['offset3'])+"\n")
		if 'numslots3' in params: out.write("	numslots3:        "+str(params['numslots3'])+"\n")
		if 'timeout3' in params: out.write("	timeout3:         "+str(params['timeout3'])+"\n")
		if 'increment3' in params: out.write("	increment3:       "+str(params['increment3'])+"\n")
		if 'offset4' in params: out.write("	offset4:          "+str(params['offset4'])+"\n")
		if 'numslots4' in params: out.write("	numslots4:        "+str(params['numslots4'])+"\n")
		if 'timeout4' in params: out.write("	timeout4:         "+str(params['timeout4'])+"\n")
		if 'increment4' in params: out.write("	increment4:       "+str(params['increment4'])+"\n")
		if 'variablespare' in params: out.write("	variablespare:    "+str(params['variablespare'])+"\n")
	elif 'csv'==format:
		if None == options.fieldList:
			options.fieldList = fieldList
		needComma = False;
		for field in fieldList:
			if needComma: out.write(',')
			needComma = True
			if field in params:
				out.write(str(params[field]))
			# else: leave it empty
		out.write("\n")
	elif 'html'==format:
		printHtml(params,out)
	elif 'sql'==format:
		sqlInsertStr(params,out,dbType=dbType)
	else: 
		print "ERROR: unknown format:",format
		assert False

	return # Nothing to return

RepeatIndicatorEncodeLut = {
	'default':'0',
	'do not repeat any more':'3',
	} #RepeatIndicatorEncodeLut

RepeatIndicatorDecodeLut = {
	'0':'default',
	'3':'do not repeat any more',
	} # RepeatIndicatorEncodeLut

######################################################################
# SQL SUPPORT
######################################################################

dbTableName='datalinkmng'
'Database table name'

def sqlCreateStr(outfile=sys.stdout, fields=None, extraFields=None
		,addCoastGuardFields=True
		,dbType='postgres'
		):
	'''
	Return the SQL CREATE command for this message type
	@param outfile: file like object to print to.
	@param fields: which fields to put in the create.  Defaults to all.
	@param extraFields: A sequence of tuples containing (name,sql type) for additional fields
	@param addCoastGuardFields: Add the extra fields that come after the NMEA check some from the USCG N-AIS format
	@param dbType: Which flavor of database we are using so that the create is tailored ('sqlite' or 'postgres')
	@type addCoastGuardFields: bool
	@return: sql create string
	@rtype: str

	@see: sqlCreate
	'''
	# FIX: should this sqlCreate be the same as in LaTeX (createFuncName) rather than hard coded?
	outfile.write(str(sqlCreate(fields,extraFields,addCoastGuardFields,dbType=dbType)))

def sqlCreate(fields=None, extraFields=None, addCoastGuardFields=True, dbType='postgres'):
	'''
	Return the sqlhelp object to create the table.

	@param fields: which fields to put in the create.  Defaults to all.
	@param extraFields: A sequence of tuples containing (name,sql type) for additional fields
	@param addCoastGuardFields: Add the extra fields that come after the NMEA check some from the USCG N-AIS format
	@type addCoastGuardFields: bool
	@param dbType: Which flavor of database we are using so that the create is tailored ('sqlite' or 'postgres')
	@return: An object that can be used to generate a return
	@rtype: sqlhelp.create
	'''
	if None == fields: fields = fieldList
	import sqlhelp
	c = sqlhelp.create('datalinkmng',dbType=dbType)
	c.addPrimaryKey()
	if 'MessageID' in fields: c.addInt ('MessageID')
	if 'RepeatIndicator' in fields: c.addInt ('RepeatIndicator')
	if 'UserID' in fields: c.addInt ('UserID')
	if 'Spare' in fields: c.addInt ('Spare')
	if 'offset1' in fields: c.addInt ('offset1')
	if 'numslots1' in fields: c.addInt ('numslots1')
	if 'timeout1' in fields: c.addInt ('timeout1')
	if 'increment1' in fields: c.addInt ('increment1')
	if 'offset2' in fields: c.addInt ('offset2')
	if 'numslots2' in fields: c.addInt ('numslots2')
	if 'timeout2' in fields: c.addInt ('timeout2')
	if 'increment2' in fields: c.addInt ('increment2')
	if 'offset3' in fields: c.addInt ('offset3')
	if 'numslots3' in fields: c.addInt ('numslots3')
	if 'timeout3' in fields: c.addInt ('timeout3')
	if 'increment3' in fields: c.addInt ('increment3')
	if 'offset4' in fields: c.addInt ('offset4')
	if 'numslots4' in fields: c.addInt ('numslots4')
	if 'timeout4' in fields: c.addInt ('timeout4')
	if 'increment4' in fields: c.addInt ('increment4')
	if 'variablespare' in fields: c.addInt ('variablespare')

	if addCoastGuardFields:
		# c.addInt('cg_s_rssi')     # Relative signal strength indicator
		# c.addInt('cg_d_strength')        # dBm receive strength
		# c.addVarChar('cg_x',10) # Idonno
		c.addInt('cg_t_arrival')        # Receive timestamp from the AIS equipment 'T'
		c.addInt('cg_s_slotnum')        # Slot received in
		c.addVarChar('cg_r',15)   # Receiver station ID  -  should usually be an MMSI, but sometimes is a string
		c.addInt('cg_sec')        # UTC seconds since the epoch

		c.addTimestamp('cg_timestamp') # UTC decoded cg_sec - not actually in the data stream

	return c

def sqlInsertStr(params, outfile=sys.stdout, extraParams=None, dbType='postgres'):
	'''
	Return the SQL INSERT command for this message type
	@param params: dictionary of values keyed by field name
	@param outfile: file like object to print to.
	@param extraParams: A sequence of tuples containing (name,sql type) for additional fields
	@return: sql create string
	@rtype: str

	@see: sqlCreate
	'''
	outfile.write(str(sqlInsert(params,extraParams,dbType=dbType)))


def sqlInsert(params,extraParams=None,dbType='postgres'):
	'''
	Give the SQL INSERT statement
	@param params: dict keyed by field name of values
	@param extraParams: any extra fields that you have created beyond the normal ais message fields
	@rtype: sqlhelp.insert
	@return: insert class instance
	@todo: allow optional type checking of params?
	@warning: this will take invalid keys happily and do what???
	'''
	import sqlhelp
	i = sqlhelp.insert('datalinkmng',dbType=dbType)

	if dbType=='postgres':
		finished = []
		for key in params:
			if key in finished: 
				continue

			if key not in toPgFields and key not in fromPgFields:
				if type(params[key])==Decimal: i.add(key,float(params[key]))
				else: i.add(key,params[key])
			else:
				if key in fromPgFields:
					val = params[key]
				        # Had better be a WKT type like POINT(-88.1 30.321)
					i.addPostGIS(key,val)
					finished.append(key)
				else:
					# Need to construct the type.
					pgName = toPgFields[key]
					#valStr='GeomFromText(\''+pgTypes[pgName]+'('
					valStr=pgTypes[pgName]+'('
					vals = []
					for nonPgKey in fromPgFields[pgName]:
						vals.append(str(params[nonPgKey]))
						finished.append(nonPgKey)
					valStr+=' '.join(vals)+')'
					i.addPostGIS(pgName,valStr)
	else:
		for key in params: 
			if type(params[key])==Decimal: i.add(key,float(params[key]))
			else: i.add(key,params[key])

	if None != extraParams:
		for key in extraParams: 
			i.add(key,extraParams[key])

	return i

######################################################################
# LATEX SUPPORT
######################################################################

def latexDefinitionTable(outfile=sys.stdout
		):
	'''
	Return the LaTeX definition table for this message type
	@param outfile: file like object to print to.
	@type outfile: file obj
	@return: LaTeX table string via the outfile
	@rtype: str

	'''
	o = outfile

	o.write('''
\\begin{table}%[htb]
\\centering
\\begin{tabular}{|l|c|l|}
\\hline
Parameter & Number of bits & Description 
\\\\  \\hline\\hline
MessageID & 6 & AIS message number.  Must be 20 \\\\ \hline 
RepeatIndicator & 2 & Indicated how many times a message has been repeated \\\\ \hline 
UserID & 30 & Unique ship identification number (MMSI) \\\\ \hline 
Spare & 2 & Not used.  Should be set to zero. \\\\ \hline 
offset1 & 12 & Reserved offset number \\\\ \hline 
numslots1 & 4 & Number of reserved consecutive slots \\\\ \hline 
timeout1 & 3 & Time-out value in minutes \\\\ \hline 
increment1 & 11 & Increment to repeast reservation of this block \\\\ \hline 
offset2 & 12 & Reserved offset number (optional) \\\\ \hline 
numslots2 & 4 & Number of reserved consecutive slots (optional) \\\\ \hline 
timeout2 & 3 & Time-out value in minutes (optional) \\\\ \hline 
increment2 & 11 & Increment to repeast reservation of this block (optional) \\\\ \hline 
offset3 & 12 & Reserved offset number (optional) \\\\ \hline 
numslots3 & 4 & Number of reserved consecutive slots (optional) \\\\ \hline 
timeout3 & 3 & Time-out value in minutes (optional) \\\\ \hline 
increment3 & 11 & Increment to repeast reservation of this block (optional) \\\\ \hline 
offset4 & 12 & Reserved offset number (optional) \\\\ \hline 
numslots4 & 4 & Number of reserved consecutive slots (optional) \\\\ \hline 
timeout4 & 3 & Time-out value in minutes (optional) \\\\ \hline 
increment4 & 11 & Increment to repeast reservation of this block (optional) \\\\ \hline 
variablespare & 6 & This field is a serious pain.  This padding makes the message byte aligned\\\\ \\hline \\hline
Total bits & 166 & Appears to take 1 slot with 2 pad bits to fill the last slot \\\\ \\hline
\\end{tabular}
\\caption{AIS message number 20: Data Link Management - D.  This message uses an     optional tag that should not be reused.  The spare at the end     is used to byte align the message.     }
\\label{tab:datalinkmng}
\\end{table}
''')

######################################################################
# Text Definition
######################################################################

def textDefinitionTable(outfile=sys.stdout
		,delim='\t'
		):
	'''
	Return the text definition table for this message type
	@param outfile: file like object to print to.
	@type outfile: file obj
	@return: text table string via the outfile
	@rtype: str

	'''
	o = outfile
	o.write('''Parameter'''+delim+'Number of bits'''+delim+'''Description 
MessageID'''+delim+'''6'''+delim+'''AIS message number.  Must be 20
RepeatIndicator'''+delim+'''2'''+delim+'''Indicated how many times a message has been repeated
UserID'''+delim+'''30'''+delim+'''Unique ship identification number (MMSI)
Spare'''+delim+'''2'''+delim+'''Not used.  Should be set to zero.
offset1'''+delim+'''12'''+delim+'''Reserved offset number
numslots1'''+delim+'''4'''+delim+'''Number of reserved consecutive slots
timeout1'''+delim+'''3'''+delim+'''Time-out value in minutes
increment1'''+delim+'''11'''+delim+'''Increment to repeast reservation of this block
offset2'''+delim+'''12'''+delim+'''Reserved offset number (optional)
numslots2'''+delim+'''4'''+delim+'''Number of reserved consecutive slots (optional)
timeout2'''+delim+'''3'''+delim+'''Time-out value in minutes (optional)
increment2'''+delim+'''11'''+delim+'''Increment to repeast reservation of this block (optional)
offset3'''+delim+'''12'''+delim+'''Reserved offset number (optional)
numslots3'''+delim+'''4'''+delim+'''Number of reserved consecutive slots (optional)
timeout3'''+delim+'''3'''+delim+'''Time-out value in minutes (optional)
increment3'''+delim+'''11'''+delim+'''Increment to repeast reservation of this block (optional)
offset4'''+delim+'''12'''+delim+'''Reserved offset number (optional)
numslots4'''+delim+'''4'''+delim+'''Number of reserved consecutive slots (optional)
timeout4'''+delim+'''3'''+delim+'''Time-out value in minutes (optional)
increment4'''+delim+'''11'''+delim+'''Increment to repeast reservation of this block (optional)
variablespare'''+delim+'''6'''+delim+'''This field is a serious pain.  This padding makes the message byte aligned
Total bits'''+delim+'''166'''+delim+'''Appears to take 1 slot with 2 pad bits to fill the last slot''')


######################################################################
# UNIT TESTING
######################################################################
import unittest
def testParams():
	'''Return a params file base on the testvalue tags.
	@rtype: dict
	@return: params based on testvalue tags
	'''
	params = {}
	params['MessageID'] = 20
	params['RepeatIndicator'] = 1
	params['UserID'] = 1193046
	params['Spare'] = 0
	params['offset1'] = 10
	params['numslots1'] = 1
	params['timeout1'] = 1
	params['increment1'] = 14
	params['offset2'] = 20
	params['numslots2'] = 2
	params['timeout2'] = 2
	params['increment2'] = 24
	params['offset3'] = 30
	params['numslots3'] = 3
	params['timeout3'] = 3
	params['increment3'] = 34
	params['offset4'] = 40
	params['numslots4'] = 4
	params['timeout4'] = 4
	params['increment4'] = 44
	params['variablespare'] = 0

	return params

class Testdatalinkmng(unittest.TestCase):
	'''Use testvalue tag text from each type to build test case the datalinkmng message'''
	def testEncodeDecode(self):

		params = testParams()
		bits   = encode(params)
		r      = decode(bits)

		# Check that each parameter came through ok.
		self.failUnlessEqual(r['MessageID'],params['MessageID'])
		self.failUnlessEqual(r['RepeatIndicator'],params['RepeatIndicator'])
		self.failUnlessEqual(r['UserID'],params['UserID'])
		self.failUnlessEqual(r['Spare'],params['Spare'])
		self.failUnlessEqual(r['offset1'],params['offset1'])
		self.failUnlessEqual(r['numslots1'],params['numslots1'])
		self.failUnlessEqual(r['timeout1'],params['timeout1'])
		self.failUnlessEqual(r['increment1'],params['increment1'])
		self.failUnlessEqual(r['offset2'],params['offset2'])
		self.failUnlessEqual(r['numslots2'],params['numslots2'])
		self.failUnlessEqual(r['timeout2'],params['timeout2'])
		self.failUnlessEqual(r['increment2'],params['increment2'])
		self.failUnlessEqual(r['offset3'],params['offset3'])
		self.failUnlessEqual(r['numslots3'],params['numslots3'])
		self.failUnlessEqual(r['timeout3'],params['timeout3'])
		self.failUnlessEqual(r['increment3'],params['increment3'])
		self.failUnlessEqual(r['offset4'],params['offset4'])
		self.failUnlessEqual(r['numslots4'],params['numslots4'])
		self.failUnlessEqual(r['timeout4'],params['timeout4'])
		self.failUnlessEqual(r['increment4'],params['increment4'])
		self.failUnlessEqual(r['variablespare'],params['variablespare'])

def addMsgOptions(parser):
	parser.add_option('-d','--decode',dest='doDecode',default=False,action='store_true',
		help='decode a "datalinkmng" AIS message')
	parser.add_option('-e','--encode',dest='doEncode',default=False,action='store_true',
		help='encode a "datalinkmng" AIS message')
	parser.add_option('--RepeatIndicator-field', dest='RepeatIndicatorField',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--UserID-field', dest='UserIDField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--offset1-field', dest='offset1Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--numslots1-field', dest='numslots1Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--timeout1-field', dest='timeout1Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--increment1-field', dest='increment1Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--offset2-field', dest='offset2Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--numslots2-field', dest='numslots2Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--timeout2-field', dest='timeout2Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--increment2-field', dest='increment2Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--offset3-field', dest='offset3Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--numslots3-field', dest='numslots3Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--timeout3-field', dest='timeout3Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--increment3-field', dest='increment3Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--offset4-field', dest='offset4Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--numslots4-field', dest='numslots4Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--timeout4-field', dest='timeout4Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--increment4-field', dest='increment4Field',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')

def main():
	from optparse import OptionParser
	parser = OptionParser(usage="%prog [options]",
		version="%prog "+__version__)

	parser.add_option('--doc-test',dest='doctest',default=False,action='store_true',
		help='run the documentation tests')
	parser.add_option('--unit-test',dest='unittest',default=False,action='store_true',
		help='run the unit tests')
	parser.add_option('-v','--verbose',dest='verbose',default=False,action='store_true',
		help='Make the test output verbose')

	# FIX: remove nmea from binary messages.  No way to build the whole packet?
	# FIX: or build the surrounding msg 8 for a broadcast?
	typeChoices = ('binary','nmeapayload','nmea') # FIX: what about a USCG type message?
	parser.add_option('-t','--type',choices=typeChoices,type='choice',dest='ioType'
		,default='nmeapayload'
		,help='What kind of string to write for encoding ('+', '.join(typeChoices)+') [default: %default]')


	outputChoices = ('std','html','csv','sql' )
	parser.add_option('-T','--output-type',choices=outputChoices,type='choice',dest='outputType'
		,default='std'
		,help='What kind of string to output ('+', '.join(outputChoices)+') [default: %default]')

	parser.add_option('-o','--output',dest='outputFileName',default=None,
			  help='Name of the python file to write [default: stdout]')

	parser.add_option('-f','--fields',dest='fieldList',default=None, action='append',
			  choices=fieldList,
			  help='Which fields to include in the output.  Currently only for csv output [default: all]')

	parser.add_option('-p','--print-csv-field-list',dest='printCsvfieldList',default=False,action='store_true',
			  help='Print the field name for csv')

	parser.add_option('-c','--sql-create',dest='sqlCreate',default=False,action='store_true',
			  help='Print out an sql create command for the table.')

	parser.add_option('--latex-table',dest='latexDefinitionTable',default=False,action='store_true',
			  help='Print a LaTeX table of the type')

	parser.add_option('--text-table',dest='textDefinitionTable',default=False,action='store_true',
			  help='Print delimited table of the type (for Word table importing)')
	parser.add_option('--delimt-text-table',dest='delimTextDefinitionTable',default='\t'
			  ,help='Delimiter for text table [default: \'%default\'](for Word table importing)')


	dbChoices = ('sqlite','postgres')
	parser.add_option('-D','--db-type',dest='dbType',default='postgres'
			  ,choices=dbChoices,type='choice'
			  ,help='What kind of database ('+', '.join(dbChoices)+') [default: %default]')

	addMsgOptions(parser)

	(options,args) = parser.parse_args()
	success=True

	if options.doctest:
		import os; print os.path.basename(sys.argv[0]), 'doctests ...',
		sys.argv= [sys.argv[0]]
		if options.verbose: sys.argv.append('-v')
		import doctest
		numfail,numtests=doctest.testmod()
		if numfail==0: print 'ok'
		else: 
			print 'FAILED'
			success=False

	if not success: sys.exit('Something Failed')
	del success # Hide success from epydoc

	if options.unittest:
		sys.argv = [sys.argv[0]]
		if options.verbose: sys.argv.append('-v')
		unittest.main()

	outfile = sys.stdout
	if None!=options.outputFileName:
		outfile = file(options.outputFileName,'w')


	if options.doEncode:
		# First make sure all non required options are specified
		if None==options.RepeatIndicatorField: parser.error("missing value for RepeatIndicatorField")
		if None==options.UserIDField: parser.error("missing value for UserIDField")
		if None==options.offset1Field: parser.error("missing value for offset1Field")
		if None==options.numslots1Field: parser.error("missing value for numslots1Field")
		if None==options.timeout1Field: parser.error("missing value for timeout1Field")
		if None==options.increment1Field: parser.error("missing value for increment1Field")
		if None==options.offset2Field: parser.error("missing value for offset2Field")
		if None==options.numslots2Field: parser.error("missing value for numslots2Field")
		if None==options.timeout2Field: parser.error("missing value for timeout2Field")
		if None==options.increment2Field: parser.error("missing value for increment2Field")
		if None==options.offset3Field: parser.error("missing value for offset3Field")
		if None==options.numslots3Field: parser.error("missing value for numslots3Field")
		if None==options.timeout3Field: parser.error("missing value for timeout3Field")
		if None==options.increment3Field: parser.error("missing value for increment3Field")
		if None==options.offset4Field: parser.error("missing value for offset4Field")
		if None==options.numslots4Field: parser.error("missing value for numslots4Field")
		if None==options.timeout4Field: parser.error("missing value for timeout4Field")
		if None==options.increment4Field: parser.error("missing value for increment4Field")
		msgDict={
			'MessageID': '20',
			'RepeatIndicator': options.RepeatIndicatorField,
			'UserID': options.UserIDField,
			'Spare': '0',
			'offset1': options.offset1Field,
			'numslots1': options.numslots1Field,
			'timeout1': options.timeout1Field,
			'increment1': options.increment1Field,
			'offset2': options.offset2Field,
			'numslots2': options.numslots2Field,
			'timeout2': options.timeout2Field,
			'increment2': options.increment2Field,
			'offset3': options.offset3Field,
			'numslots3': options.numslots3Field,
			'timeout3': options.timeout3Field,
			'increment3': options.increment3Field,
			'offset4': options.offset4Field,
			'numslots4': options.numslots4Field,
			'timeout4': options.timeout4Field,
			'increment4': options.increment4Field,
			'variablespare': '0',
		}

		bits = encode(msgDict)
		if 'binary'==options.ioType: print str(bits)
		elif 'nmeapayload'==options.ioType:
		    # FIX: figure out if this might be necessary at compile time
		    #print "bitLen",len(bits)
		    bitLen=len(bits)
		    if bitLen%6!=0:
			bits = bits + BitVector(size=(6 - (bitLen%6)))  # Pad out to multiple of 6
		    #print "result:",binary.bitvectoais6(bits)[0]
		    print binary.bitvectoais6(bits)[0]


		# FIX: Do not emit this option for the binary message payloads.  Does not make sense.
		elif 'nmea'==options.ioType: 
		    #bitLen=len(bits)
                    #if bitLen%6!=0:
		    #	bits = bits + BitVector(size=(6 - (bitLen%6)))  # Pad out to multiple of 6
                    import aisutils.uscg as uscg
                    nmea = uscg.create_nmea(bits)
                    print nmea
                    #
                    #


                    #sys.exit("FIX: need to implement creating nmea capability")
		else: sys.exit('ERROR: unknown ioType.  Help!')


	if options.sqlCreate:
		sqlCreateStr(outfile,options.fieldList,dbType=options.dbType)

	if options.latexDefinitionTable:
		latexDefinitionTable(outfile)

	# For conversion to word tables
	if options.textDefinitionTable:
		textDefinitionTable(outfile,options.delimTextDefinitionTable)

	if options.printCsvfieldList:
		# Make a csv separated list of fields that will be displayed for csv
		if None == options.fieldList: options.fieldList = fieldList
		import StringIO
		buf = StringIO.StringIO()
		for field in options.fieldList:
			buf.write(field+',')
		result = buf.getvalue()
		if result[-1] == ',': print result[:-1]
		else: print result

	if options.doDecode:
		if len(args)==0: args = sys.stdin
		for msg in args:
			bv = None

			if msg[0] in ('$','!') and msg[3:6] in ('VDM','VDO'):
				# Found nmea
				# FIX: do checksum
				bv = binary.ais6tobitvec(msg.split(',')[5])
			else: # either binary or nmeapayload... expect mostly nmeapayloads
				# assumes that an all 0 and 1 string can not be a nmeapayload
				binaryMsg=True
				for c in msg:
					if c not in ('0','1'):
						binaryMsg=False
						break
				if binaryMsg:
					bv = BitVector(bitstring=msg)
				else: # nmeapayload
					bv = binary.ais6tobitvec(msg)

			printFields(decode(bv)
				    ,out=outfile
				    ,format=options.outputType
				    ,fieldList=options.fieldList
				    ,dbType=options.dbType
				    )

############################################################
if __name__=='__main__':
    main()
