#!/usr/bin/env python

__version__ = '$Revision: 4791 $'.split()[1]
__date__ = '$Date: 2012-10-07 $'.split()[1]
__author__ = 'xmlbinmsg'

__doc__='''

Autogenerated python functions to serialize/deserialize binary messages.

Generated by: ../scripts/aisxmlbinmsg2py.py

Need to then wrap these functions with the outer AIS packet and then
convert the whole binary blob to a NMEA string.  Those functions are
not currently provided in this file.

serialize: python to ais binary
deserialize: ais binary to python

The generated code uses translators.py, binary.py, and aisstring.py
which should be packaged with the resulting files.


@requires: U{epydoc<http://epydoc.sourceforge.net/>} > 3.0alpha3
@requires: U{BitVector<http://cheeseshop.python.org/pypi/BitVector>}

@author: '''+__author__+'''
@version: ''' + __version__ +'''
@var __date__: Date of last svn commit
@undocumented: __version__ __author__ __doc__ parser
@status: under development
@license: Generated code has no license
@todo: FIX: put in a description of the message here with fields and types.
'''

import sys
from decimal import Decimal
from BitVector import BitVector

import binary, aisstring

# FIX: check to see if these will be needed
TrueBV  = BitVector(bitstring="1")
"Why always rebuild the True bit?  This should speed things up a bunch"
FalseBV = BitVector(bitstring="0")
"Why always rebuild the False bit?  This should speed things up a bunch"


fieldList = (
	'MessageID',
	'RepeatIndicator',
	'UserID',
	'Spare',
	'dac',
	'fid',
	'reason',
	'from',
	'to',
	'radius',
	'unit',
	'closingday',
	'closingmonth',
	'fromhour',
	'frommin',
	'today',
	'tomonth',
	'tohour',
	'tomin',
	'spare2',
)

fieldListPostgres = (
	'MessageID',
	'RepeatIndicator',
	'UserID',
	'Spare',
	'dac',
	'fid',
	'reason',
	'from',
	'to',
	'radius',
	'unit',
	'closingday',
	'closingmonth',
	'fromhour',
	'frommin',
	'today',
	'tomonth',
	'tohour',
	'tomin',
	'spare2',
)

toPgFields = {
}
'''
Go to the Postgis field names from the straight field name
'''

fromPgFields = {
}
'''
Go from the Postgis field names to the straight field name
'''

pgTypes = {
}
'''
Lookup table for each postgis field name to get its type.
'''

def encode(params, validate=False):
	'''Create a imo_fairway_closed binary message payload to pack into an AIS Msg imo_fairway_closed.

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 8 (field automatically set to "8")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): MMSI number of transmitter broadcasting the message
	  - Spare(uint): Reserved for definition by a regional authority. (field automatically set to "0")
	  - dac(uint): Designated Area Code - part 1 of the IAI (field automatically set to "1")
	  - fid(uint): Functional Identifier - part 2 of the IAI (field automatically set to "11")
	  - reason(aisstr6): Reason for closing
	  - from(aisstr6): Location of closing from
	  - to(aisstr6): Location of closing To
	  - radius(uint): Extention of closed area
	  - unit(uint): Unit of extension value for range field
	  - closingday(uint): Closing from day
	  - closingmonth(uint): Closing from month
	  - fromhour(uint): From LT hour (appr)
	  - frommin(uint): From LT minute (appr)
	  - today(uint): To day
	  - tomonth(uint): To month
	  - tohour(uint): To LT hour (appr)
	  - tomin(uint): To LT minute (appr)
	  - spare2(uint): Padding out the slot (field automatically set to "0")
	@param params: Dictionary of field names/values.  Throws a ValueError exception if required is missing
	@param validate: Set to true to cause checking to occur.  Runs slower.  FIX: not implemented.
	@rtype: BitVector
	@return: encoded binary message (for binary messages, this needs to be wrapped in a msg 8
	@note: The returned bits may not be 6 bit aligned.  It is up to you to pad out the bits.
	'''

	bvList = []
	bvList.append(binary.setBitVectorSize(BitVector(intVal=8),6))
	if 'RepeatIndicator' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['RepeatIndicator']),2))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),2))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['UserID']),30))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=0),2))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=1),10))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=11),6))
	if 'reason' in params:
		bvList.append(aisstring.encode(params['reason'],120))
	else:
		bvList.append(aisstring.encode('@@@@@@@@@@@@@@@@@@@@',120))
	if 'from' in params:
		bvList.append(aisstring.encode(params['from'],120))
	else:
		bvList.append(aisstring.encode('@@@@@@@@@@@@@@@@@@@@',120))
	if 'to' in params:
		bvList.append(aisstring.encode(params['to'],120))
	else:
		bvList.append(aisstring.encode('@@@@@@@@@@@@@@@@@@@@',120))
	if 'radius' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['radius']),10))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=1001),10))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['unit']),2))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['closingday']),5))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['closingmonth']),4))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['fromhour']),5))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['frommin']),6))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['today']),5))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tomonth']),4))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tohour']),5))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tomin']),6))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=0),4))

	return binary.joinBV(bvList)

def decode(bv, validate=False):
	'''Unpack a imo_fairway_closed message 

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 8 (field automatically set to "8")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): MMSI number of transmitter broadcasting the message
	  - Spare(uint): Reserved for definition by a regional authority. (field automatically set to "0")
	  - dac(uint): Designated Area Code - part 1 of the IAI (field automatically set to "1")
	  - fid(uint): Functional Identifier - part 2 of the IAI (field automatically set to "11")
	  - reason(aisstr6): Reason for closing
	  - from(aisstr6): Location of closing from
	  - to(aisstr6): Location of closing To
	  - radius(uint): Extention of closed area
	  - unit(uint): Unit of extension value for range field
	  - closingday(uint): Closing from day
	  - closingmonth(uint): Closing from month
	  - fromhour(uint): From LT hour (appr)
	  - frommin(uint): From LT minute (appr)
	  - today(uint): To day
	  - tomonth(uint): To month
	  - tohour(uint): To LT hour (appr)
	  - tomin(uint): To LT minute (appr)
	  - spare2(uint): Padding out the slot (field automatically set to "0")
	@type bv: BitVector
	@param bv: Bits defining a message
	@param validate: Set to true to cause checking to occur.  Runs slower.  FIX: not implemented.
	@rtype: dict
	@return: params
	'''

	#Would be nice to check the bit count here..
	#if validate:
	#	assert (len(bv)==FIX: SOME NUMBER)
	r = {}
	r['MessageID']=8
	r['RepeatIndicator']=int(bv[6:8])
	r['UserID']=int(bv[8:38])
	r['Spare']=0
	r['dac']=1
	r['fid']=11
	r['reason']=aisstring.decode(bv[56:176])
	r['from']=aisstring.decode(bv[176:296])
	r['to']=aisstring.decode(bv[296:416])
	r['radius']=int(bv[416:426])
	r['unit']=int(bv[426:428])
	r['closingday']=int(bv[428:433])
	r['closingmonth']=int(bv[433:437])
	r['fromhour']=int(bv[437:442])
	r['frommin']=int(bv[442:448])
	r['today']=int(bv[448:453])
	r['tomonth']=int(bv[453:457])
	r['tohour']=int(bv[457:462])
	r['tomin']=int(bv[462:468])
	r['spare2']=0
	return r

def decodeMessageID(bv, validate=False):
	return 8

def decodeRepeatIndicator(bv, validate=False):
	return int(bv[6:8])

def decodeUserID(bv, validate=False):
	return int(bv[8:38])

def decodeSpare(bv, validate=False):
	return 0

def decodedac(bv, validate=False):
	return 1

def decodefid(bv, validate=False):
	return 11

def decodereason(bv, validate=False):
	return aisstring.decode(bv[56:176])

def decodefrom(bv, validate=False):
	return aisstring.decode(bv[176:296])

def decodeto(bv, validate=False):
	return aisstring.decode(bv[296:416])

def decoderadius(bv, validate=False):
	return int(bv[416:426])

def decodeunit(bv, validate=False):
	return int(bv[426:428])

def decodeclosingday(bv, validate=False):
	return int(bv[428:433])

def decodeclosingmonth(bv, validate=False):
	return int(bv[433:437])

def decodefromhour(bv, validate=False):
	return int(bv[437:442])

def decodefrommin(bv, validate=False):
	return int(bv[442:448])

def decodetoday(bv, validate=False):
	return int(bv[448:453])

def decodetomonth(bv, validate=False):
	return int(bv[453:457])

def decodetohour(bv, validate=False):
	return int(bv[457:462])

def decodetomin(bv, validate=False):
	return int(bv[462:468])

def decodespare2(bv, validate=False):
	return 0


def printHtml(params, out=sys.stdout):
		out.write("<h3>imo_fairway_closed</h3>\n")
		out.write("<table border=\"1\">\n")
		out.write("<tr bgcolor=\"orange\">\n")
		out.write("<th align=\"left\">Field Name</th>\n")
		out.write("<th align=\"left\">Type</th>\n")
		out.write("<th align=\"left\">Value</th>\n")
		out.write("<th align=\"left\">Value in Lookup Table</th>\n")
		out.write("<th align=\"left\">Units</th>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>MessageID</td>\n")
		out.write("<td>uint</td>\n")
		if 'MessageID' in params:
			out.write("	<td>"+str(params['MessageID'])+"</td>\n")
			out.write("	<td>"+str(params['MessageID'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>RepeatIndicator</td>\n")
		out.write("<td>uint</td>\n")
		if 'RepeatIndicator' in params:
			out.write("	<td>"+str(params['RepeatIndicator'])+"</td>\n")
			if str(params['RepeatIndicator']) in RepeatIndicatorDecodeLut:
				out.write("<td>"+RepeatIndicatorDecodeLut[str(params['RepeatIndicator'])]+"</td>")
			else:
				out.write("<td><i>Missing LUT entry</i></td>")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>UserID</td>\n")
		out.write("<td>uint</td>\n")
		if 'UserID' in params:
			out.write("	<td>"+str(params['UserID'])+"</td>\n")
			out.write("	<td>"+str(params['UserID'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>Spare</td>\n")
		out.write("<td>uint</td>\n")
		if 'Spare' in params:
			out.write("	<td>"+str(params['Spare'])+"</td>\n")
			out.write("	<td>"+str(params['Spare'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>dac</td>\n")
		out.write("<td>uint</td>\n")
		if 'dac' in params:
			out.write("	<td>"+str(params['dac'])+"</td>\n")
			out.write("	<td>"+str(params['dac'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>fid</td>\n")
		out.write("<td>uint</td>\n")
		if 'fid' in params:
			out.write("	<td>"+str(params['fid'])+"</td>\n")
			out.write("	<td>"+str(params['fid'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>reason</td>\n")
		out.write("<td>aisstr6</td>\n")
		if 'reason' in params:
			out.write("	<td>"+str(params['reason'])+"</td>\n")
			out.write("	<td>"+str(params['reason'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>from</td>\n")
		out.write("<td>aisstr6</td>\n")
		if 'from' in params:
			out.write("	<td>"+str(params['from'])+"</td>\n")
			out.write("	<td>"+str(params['from'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>to</td>\n")
		out.write("<td>aisstr6</td>\n")
		if 'to' in params:
			out.write("	<td>"+str(params['to'])+"</td>\n")
			out.write("	<td>"+str(params['to'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>radius</td>\n")
		out.write("<td>uint</td>\n")
		if 'radius' in params:
			out.write("	<td>"+str(params['radius'])+"</td>\n")
			out.write("	<td>"+str(params['radius'])+"</td>\n")
		out.write("<td>See unit field</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>unit</td>\n")
		out.write("<td>uint</td>\n")
		if 'unit' in params:
			out.write("	<td>"+str(params['unit'])+"</td>\n")
			if str(params['unit']) in unitDecodeLut:
				out.write("<td>"+unitDecodeLut[str(params['unit'])]+"</td>")
			else:
				out.write("<td><i>Missing LUT entry</i></td>")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>closingday</td>\n")
		out.write("<td>uint</td>\n")
		if 'closingday' in params:
			out.write("	<td>"+str(params['closingday'])+"</td>\n")
			out.write("	<td>"+str(params['closingday'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>closingmonth</td>\n")
		out.write("<td>uint</td>\n")
		if 'closingmonth' in params:
			out.write("	<td>"+str(params['closingmonth'])+"</td>\n")
			out.write("	<td>"+str(params['closingmonth'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>fromhour</td>\n")
		out.write("<td>uint</td>\n")
		if 'fromhour' in params:
			out.write("	<td>"+str(params['fromhour'])+"</td>\n")
			out.write("	<td>"+str(params['fromhour'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>frommin</td>\n")
		out.write("<td>uint</td>\n")
		if 'frommin' in params:
			out.write("	<td>"+str(params['frommin'])+"</td>\n")
			out.write("	<td>"+str(params['frommin'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>today</td>\n")
		out.write("<td>uint</td>\n")
		if 'today' in params:
			out.write("	<td>"+str(params['today'])+"</td>\n")
			out.write("	<td>"+str(params['today'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tomonth</td>\n")
		out.write("<td>uint</td>\n")
		if 'tomonth' in params:
			out.write("	<td>"+str(params['tomonth'])+"</td>\n")
			out.write("	<td>"+str(params['tomonth'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tohour</td>\n")
		out.write("<td>uint</td>\n")
		if 'tohour' in params:
			out.write("	<td>"+str(params['tohour'])+"</td>\n")
			out.write("	<td>"+str(params['tohour'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tomin</td>\n")
		out.write("<td>uint</td>\n")
		if 'tomin' in params:
			out.write("	<td>"+str(params['tomin'])+"</td>\n")
			out.write("	<td>"+str(params['tomin'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>spare2</td>\n")
		out.write("<td>uint</td>\n")
		if 'spare2' in params:
			out.write("	<td>"+str(params['spare2'])+"</td>\n")
			out.write("	<td>"+str(params['spare2'])+"</td>\n")
		out.write("</tr>\n")
		out.write("</table>\n")

def printFields(params, out=sys.stdout, format='std', fieldList=None, dbType='postgres'):
	'''Print a imo_fairway_closed message to stdout.

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 8 (field automatically set to "8")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): MMSI number of transmitter broadcasting the message
	  - Spare(uint): Reserved for definition by a regional authority. (field automatically set to "0")
	  - dac(uint): Designated Area Code - part 1 of the IAI (field automatically set to "1")
	  - fid(uint): Functional Identifier - part 2 of the IAI (field automatically set to "11")
	  - reason(aisstr6): Reason for closing
	  - from(aisstr6): Location of closing from
	  - to(aisstr6): Location of closing To
	  - radius(uint): Extention of closed area
	  - unit(uint): Unit of extension value for range field
	  - closingday(uint): Closing from day
	  - closingmonth(uint): Closing from month
	  - fromhour(uint): From LT hour (appr)
	  - frommin(uint): From LT minute (appr)
	  - today(uint): To day
	  - tomonth(uint): To month
	  - tohour(uint): To LT hour (appr)
	  - tomin(uint): To LT minute (appr)
	  - spare2(uint): Padding out the slot (field automatically set to "0")
	@param params: Dictionary of field names/values.  
	@param out: File like object to write to
	@rtype: stdout
	@return: text to out
	'''

	if 'std'==format:
		out.write("imo_fairway_closed:\n")
		if 'MessageID' in params: out.write("	MessageID:        "+str(params['MessageID'])+"\n")
		if 'RepeatIndicator' in params: out.write("	RepeatIndicator:  "+str(params['RepeatIndicator'])+"\n")
		if 'UserID' in params: out.write("	UserID:           "+str(params['UserID'])+"\n")
		if 'Spare' in params: out.write("	Spare:            "+str(params['Spare'])+"\n")
		if 'dac' in params: out.write("	dac:              "+str(params['dac'])+"\n")
		if 'fid' in params: out.write("	fid:              "+str(params['fid'])+"\n")
		if 'reason' in params: out.write("	reason:           "+str(params['reason'])+"\n")
		if 'from' in params: out.write("	from:             "+str(params['from'])+"\n")
		if 'to' in params: out.write("	to:               "+str(params['to'])+"\n")
		if 'radius' in params: out.write("	radius:           "+str(params['radius'])+"\n")
		if 'unit' in params: out.write("	unit:             "+str(params['unit'])+"\n")
		if 'closingday' in params: out.write("	closingday:       "+str(params['closingday'])+"\n")
		if 'closingmonth' in params: out.write("	closingmonth:     "+str(params['closingmonth'])+"\n")
		if 'fromhour' in params: out.write("	fromhour:         "+str(params['fromhour'])+"\n")
		if 'frommin' in params: out.write("	frommin:          "+str(params['frommin'])+"\n")
		if 'today' in params: out.write("	today:            "+str(params['today'])+"\n")
		if 'tomonth' in params: out.write("	tomonth:          "+str(params['tomonth'])+"\n")
		if 'tohour' in params: out.write("	tohour:           "+str(params['tohour'])+"\n")
		if 'tomin' in params: out.write("	tomin:            "+str(params['tomin'])+"\n")
		if 'spare2' in params: out.write("	spare2:           "+str(params['spare2'])+"\n")
	elif 'csv'==format:
		if None == options.fieldList:
			options.fieldList = fieldList
		needComma = False;
		for field in fieldList:
			if needComma: out.write(',')
			needComma = True
			if field in params:
				out.write(str(params[field]))
			# else: leave it empty
		out.write("\n")
	elif 'html'==format:
		printHtml(params,out)
	elif 'sql'==format:
		sqlInsertStr(params,out,dbType=dbType)
	else: 
		print "ERROR: unknown format:",format
		assert False

	return # Nothing to return

RepeatIndicatorEncodeLut = {
	'default':'0',
	'do not repeat any more':'3',
	} #RepeatIndicatorEncodeLut

RepeatIndicatorDecodeLut = {
	'0':'default',
	'3':'do not repeat any more',
	} # RepeatIndicatorEncodeLut

unitEncodeLut = {
	'm':'0',
	'km':'1',
	'nm':'2',
	'cbl':'3',
	} #unitEncodeLut

unitDecodeLut = {
	'0':'m',
	'1':'km',
	'2':'nm',
	'3':'cbl',
	} # unitEncodeLut

######################################################################
# SQL SUPPORT
######################################################################

dbTableName='imo_fairway_closed'
'Database table name'

def sqlCreateStr(outfile=sys.stdout, fields=None, extraFields=None
		,addCoastGuardFields=True
		,dbType='postgres'
		):
	'''
	Return the SQL CREATE command for this message type
	@param outfile: file like object to print to.
	@param fields: which fields to put in the create.  Defaults to all.
	@param extraFields: A sequence of tuples containing (name,sql type) for additional fields
	@param addCoastGuardFields: Add the extra fields that come after the NMEA check some from the USCG N-AIS format
	@param dbType: Which flavor of database we are using so that the create is tailored ('sqlite' or 'postgres')
	@type addCoastGuardFields: bool
	@return: sql create string
	@rtype: str

	@see: sqlCreate
	'''
	# FIX: should this sqlCreate be the same as in LaTeX (createFuncName) rather than hard coded?
	outfile.write(str(sqlCreate(fields,extraFields,addCoastGuardFields,dbType=dbType)))

def sqlCreate(fields=None, extraFields=None, addCoastGuardFields=True, dbType='postgres'):
	'''
	Return the sqlhelp object to create the table.

	@param fields: which fields to put in the create.  Defaults to all.
	@param extraFields: A sequence of tuples containing (name,sql type) for additional fields
	@param addCoastGuardFields: Add the extra fields that come after the NMEA check some from the USCG N-AIS format
	@type addCoastGuardFields: bool
	@param dbType: Which flavor of database we are using so that the create is tailored ('sqlite' or 'postgres')
	@return: An object that can be used to generate a return
	@rtype: sqlhelp.create
	'''
	if None == fields: fields = fieldList
	import sqlhelp
	c = sqlhelp.create('imo_fairway_closed',dbType=dbType)
	c.addPrimaryKey()
	if 'MessageID' in fields: c.addInt ('MessageID')
	if 'RepeatIndicator' in fields: c.addInt ('RepeatIndicator')
	if 'UserID' in fields: c.addInt ('UserID')
	if 'Spare' in fields: c.addInt ('Spare')
	if 'dac' in fields: c.addInt ('dac')
	if 'fid' in fields: c.addInt ('fid')
	if 'reason' in fields: c.addVarChar('reason',20)
	if 'from' in fields: c.addVarChar('from',20)
	if 'to' in fields: c.addVarChar('to',20)
	if 'radius' in fields: c.addInt ('radius')
	if 'unit' in fields: c.addInt ('unit')
	if 'closingday' in fields: c.addInt ('closingday')
	if 'closingmonth' in fields: c.addInt ('closingmonth')
	if 'fromhour' in fields: c.addInt ('fromhour')
	if 'frommin' in fields: c.addInt ('frommin')
	if 'today' in fields: c.addInt ('today')
	if 'tomonth' in fields: c.addInt ('tomonth')
	if 'tohour' in fields: c.addInt ('tohour')
	if 'tomin' in fields: c.addInt ('tomin')
	if 'spare2' in fields: c.addInt ('spare2')

	if addCoastGuardFields:
		# c.addInt('cg_s_rssi')     # Relative signal strength indicator
		# c.addInt('cg_d_strength')        # dBm receive strength
		# c.addVarChar('cg_x',10) # Idonno
		c.addInt('cg_t_arrival')        # Receive timestamp from the AIS equipment 'T'
		c.addInt('cg_s_slotnum')        # Slot received in
		c.addVarChar('cg_r',15)   # Receiver station ID  -  should usually be an MMSI, but sometimes is a string
		c.addInt('cg_sec')        # UTC seconds since the epoch

		c.addTimestamp('cg_timestamp') # UTC decoded cg_sec - not actually in the data stream

	return c

def sqlInsertStr(params, outfile=sys.stdout, extraParams=None, dbType='postgres'):
	'''
	Return the SQL INSERT command for this message type
	@param params: dictionary of values keyed by field name
	@param outfile: file like object to print to.
	@param extraParams: A sequence of tuples containing (name,sql type) for additional fields
	@return: sql create string
	@rtype: str

	@see: sqlCreate
	'''
	outfile.write(str(sqlInsert(params,extraParams,dbType=dbType)))


def sqlInsert(params,extraParams=None,dbType='postgres'):
	'''
	Give the SQL INSERT statement
	@param params: dict keyed by field name of values
	@param extraParams: any extra fields that you have created beyond the normal ais message fields
	@rtype: sqlhelp.insert
	@return: insert class instance
	@todo: allow optional type checking of params?
	@warning: this will take invalid keys happily and do what???
	'''
	import sqlhelp
	i = sqlhelp.insert('imo_fairway_closed',dbType=dbType)

	if dbType=='postgres':
		finished = []
		for key in params:
			if key in finished: 
				continue

			if key not in toPgFields and key not in fromPgFields:
				if type(params[key])==Decimal: i.add(key,float(params[key]))
				else: i.add(key,params[key])
			else:
				if key in fromPgFields:
					val = params[key]
				        # Had better be a WKT type like POINT(-88.1 30.321)
					i.addPostGIS(key,val)
					finished.append(key)
				else:
					# Need to construct the type.
					pgName = toPgFields[key]
					#valStr='GeomFromText(\''+pgTypes[pgName]+'('
					valStr=pgTypes[pgName]+'('
					vals = []
					for nonPgKey in fromPgFields[pgName]:
						vals.append(str(params[nonPgKey]))
						finished.append(nonPgKey)
					valStr+=' '.join(vals)+')'
					i.addPostGIS(pgName,valStr)
	else:
		for key in params: 
			if type(params[key])==Decimal: i.add(key,float(params[key]))
			else: i.add(key,params[key])

	if None != extraParams:
		for key in extraParams: 
			i.add(key,extraParams[key])

	return i

######################################################################
# LATEX SUPPORT
######################################################################

def latexDefinitionTable(outfile=sys.stdout
		):
	'''
	Return the LaTeX definition table for this message type
	@param outfile: file like object to print to.
	@type outfile: file obj
	@return: LaTeX table string via the outfile
	@rtype: str

	'''
	o = outfile

	o.write('''
\\begin{table}%[htb]
\\centering
\\begin{tabular}{|l|c|l|}
\\hline
Parameter & Number of bits & Description 
\\\\  \\hline\\hline
MessageID & 6 & AIS message number.  Must be 8 \\\\ \hline 
RepeatIndicator & 2 & Indicated how many times a message has been repeated \\\\ \hline 
UserID & 30 & MMSI number of transmitter broadcasting the message \\\\ \hline 
Spare & 2 & Reserved for definition by a regional authority. \\\\ \hline 
dac & 10 & Designated Area Code - part 1 of the IAI \\\\ \hline 
fid & 6 & Functional Identifier - part 2 of the IAI \\\\ \hline 
reason & 120 & Reason for closing \\\\ \hline 
from & 120 & Location of closing from \\\\ \hline 
to & 120 & Location of closing To \\\\ \hline 
radius & 10 & Extention of closed area \\\\ \hline 
unit & 2 & Unit of extension value for range field \\\\ \hline 
closingday & 5 & Closing from day \\\\ \hline 
closingmonth & 4 & Closing from month \\\\ \hline 
fromhour & 5 & From LT hour (appr) \\\\ \hline 
frommin & 6 & From LT minute (appr) \\\\ \hline 
today & 5 & To day \\\\ \hline 
tomonth & 4 & To month \\\\ \hline 
tohour & 5 & To LT hour (appr) \\\\ \hline 
tomin & 6 & To LT minute (appr) \\\\ \hline 
spare2 & 4 & Padding out the slot\\\\ \\hline \\hline
Total bits & 472 & Appears to take 3 slots with 208 pad bits to fill the last slot \\\\ \\hline
\\end{tabular}
\\caption{AIS message number 8: IMO fairway closed.  Specified       in SN\\Circ.236 Annex 2, page 4, Application 3.  Also defined in IALA Guidelines on AIS,       Vol 1, Part 1, Ed. 1.3. Guildeline No 1028.        This message should be used to inform ships, in particular to give       guidance to large vessels about temporary closed fairways or sections       in ports. Attributes: broadcast, shore station transmitting, no       acknowledgement.     }
\\label{tab:imo_fairway_closed}
\\end{table}
''')

######################################################################
# Text Definition
######################################################################

def textDefinitionTable(outfile=sys.stdout
		,delim='\t'
		):
	'''
	Return the text definition table for this message type
	@param outfile: file like object to print to.
	@type outfile: file obj
	@return: text table string via the outfile
	@rtype: str

	'''
	o = outfile
	o.write('''Parameter'''+delim+'Number of bits'''+delim+'''Description 
MessageID'''+delim+'''6'''+delim+'''AIS message number.  Must be 8
RepeatIndicator'''+delim+'''2'''+delim+'''Indicated how many times a message has been repeated
UserID'''+delim+'''30'''+delim+'''MMSI number of transmitter broadcasting the message
Spare'''+delim+'''2'''+delim+'''Reserved for definition by a regional authority.
dac'''+delim+'''10'''+delim+'''Designated Area Code - part 1 of the IAI
fid'''+delim+'''6'''+delim+'''Functional Identifier - part 2 of the IAI
reason'''+delim+'''120'''+delim+'''Reason for closing
from'''+delim+'''120'''+delim+'''Location of closing from
to'''+delim+'''120'''+delim+'''Location of closing To
radius'''+delim+'''10'''+delim+'''Extention of closed area
unit'''+delim+'''2'''+delim+'''Unit of extension value for range field
closingday'''+delim+'''5'''+delim+'''Closing from day
closingmonth'''+delim+'''4'''+delim+'''Closing from month
fromhour'''+delim+'''5'''+delim+'''From LT hour (appr)
frommin'''+delim+'''6'''+delim+'''From LT minute (appr)
today'''+delim+'''5'''+delim+'''To day
tomonth'''+delim+'''4'''+delim+'''To month
tohour'''+delim+'''5'''+delim+'''To LT hour (appr)
tomin'''+delim+'''6'''+delim+'''To LT minute (appr)
spare2'''+delim+'''4'''+delim+'''Padding out the slot
Total bits'''+delim+'''472'''+delim+'''Appears to take 3 slots with 208 pad bits to fill the last slot''')


######################################################################
# UNIT TESTING
######################################################################
import unittest
def testParams():
	'''Return a params file base on the testvalue tags.
	@rtype: dict
	@return: params based on testvalue tags
	'''
	params = {}
	params['MessageID'] = 8
	params['RepeatIndicator'] = 1
	params['UserID'] = 1193046
	params['Spare'] = 0
	params['dac'] = 1
	params['fid'] = 11
	params['reason'] = 'FIX GIVE SAMPLE     '
	params['from'] = 'FIX GIVE SAMPLE     '
	params['to'] = 'FIX GIVE SAMPLE     '
	params['radius'] = 321
	params['unit'] = 0
	params['closingday'] = 31
	params['closingmonth'] = 12
	params['fromhour'] = 20
	params['frommin'] = 23
	params['today'] = 27
	params['tomonth'] = 2
	params['tohour'] = 22
	params['tomin'] = 35
	params['spare2'] = 0

	return params

class Testimo_fairway_closed(unittest.TestCase):
	'''Use testvalue tag text from each type to build test case the imo_fairway_closed message'''
	def testEncodeDecode(self):

		params = testParams()
		bits   = encode(params)
		r      = decode(bits)

		# Check that each parameter came through ok.
		self.failUnlessEqual(r['MessageID'],params['MessageID'])
		self.failUnlessEqual(r['RepeatIndicator'],params['RepeatIndicator'])
		self.failUnlessEqual(r['UserID'],params['UserID'])
		self.failUnlessEqual(r['Spare'],params['Spare'])
		self.failUnlessEqual(r['dac'],params['dac'])
		self.failUnlessEqual(r['fid'],params['fid'])
		self.failUnlessEqual(r['reason'],params['reason'])
		self.failUnlessEqual(r['from'],params['from'])
		self.failUnlessEqual(r['to'],params['to'])
		self.failUnlessEqual(r['radius'],params['radius'])
		self.failUnlessEqual(r['unit'],params['unit'])
		self.failUnlessEqual(r['closingday'],params['closingday'])
		self.failUnlessEqual(r['closingmonth'],params['closingmonth'])
		self.failUnlessEqual(r['fromhour'],params['fromhour'])
		self.failUnlessEqual(r['frommin'],params['frommin'])
		self.failUnlessEqual(r['today'],params['today'])
		self.failUnlessEqual(r['tomonth'],params['tomonth'])
		self.failUnlessEqual(r['tohour'],params['tohour'])
		self.failUnlessEqual(r['tomin'],params['tomin'])
		self.failUnlessEqual(r['spare2'],params['spare2'])

def addMsgOptions(parser):
	parser.add_option('-d','--decode',dest='doDecode',default=False,action='store_true',
		help='decode a "imo_fairway_closed" AIS message')
	parser.add_option('-e','--encode',dest='doEncode',default=False,action='store_true',
		help='encode a "imo_fairway_closed" AIS message')
	parser.add_option('--RepeatIndicator-field', dest='RepeatIndicatorField',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--UserID-field', dest='UserIDField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--reason-field', dest='reasonField',default='@@@@@@@@@@@@@@@@@@@@',metavar='aisstr6',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--from-field', dest='fromField',default='@@@@@@@@@@@@@@@@@@@@',metavar='aisstr6',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--to-field', dest='toField',default='@@@@@@@@@@@@@@@@@@@@',metavar='aisstr6',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--radius-field', dest='radiusField',default=1001,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--unit-field', dest='unitField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--closingday-field', dest='closingdayField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--closingmonth-field', dest='closingmonthField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--fromhour-field', dest='fromhourField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--frommin-field', dest='fromminField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--today-field', dest='todayField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tomonth-field', dest='tomonthField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tohour-field', dest='tohourField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tomin-field', dest='tominField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')

def main():
	from optparse import OptionParser
	parser = OptionParser(usage="%prog [options]",
		version="%prog "+__version__)

	parser.add_option('--doc-test',dest='doctest',default=False,action='store_true',
		help='run the documentation tests')
	parser.add_option('--unit-test',dest='unittest',default=False,action='store_true',
		help='run the unit tests')
	parser.add_option('-v','--verbose',dest='verbose',default=False,action='store_true',
		help='Make the test output verbose')

	# FIX: remove nmea from binary messages.  No way to build the whole packet?
	# FIX: or build the surrounding msg 8 for a broadcast?
	typeChoices = ('binary','nmeapayload','nmea') # FIX: what about a USCG type message?
	parser.add_option('-t','--type',choices=typeChoices,type='choice',dest='ioType'
		,default='nmeapayload'
		,help='What kind of string to write for encoding ('+', '.join(typeChoices)+') [default: %default]')


	outputChoices = ('std','html','csv','sql' )
	parser.add_option('-T','--output-type',choices=outputChoices,type='choice',dest='outputType'
		,default='std'
		,help='What kind of string to output ('+', '.join(outputChoices)+') [default: %default]')

	parser.add_option('-o','--output',dest='outputFileName',default=None,
			  help='Name of the python file to write [default: stdout]')

	parser.add_option('-f','--fields',dest='fieldList',default=None, action='append',
			  choices=fieldList,
			  help='Which fields to include in the output.  Currently only for csv output [default: all]')

	parser.add_option('-p','--print-csv-field-list',dest='printCsvfieldList',default=False,action='store_true',
			  help='Print the field name for csv')

	parser.add_option('-c','--sql-create',dest='sqlCreate',default=False,action='store_true',
			  help='Print out an sql create command for the table.')

	parser.add_option('--latex-table',dest='latexDefinitionTable',default=False,action='store_true',
			  help='Print a LaTeX table of the type')

	parser.add_option('--text-table',dest='textDefinitionTable',default=False,action='store_true',
			  help='Print delimited table of the type (for Word table importing)')
	parser.add_option('--delimt-text-table',dest='delimTextDefinitionTable',default='\t'
			  ,help='Delimiter for text table [default: \'%default\'](for Word table importing)')


	dbChoices = ('sqlite','postgres')
	parser.add_option('-D','--db-type',dest='dbType',default='postgres'
			  ,choices=dbChoices,type='choice'
			  ,help='What kind of database ('+', '.join(dbChoices)+') [default: %default]')

	addMsgOptions(parser)

	(options,args) = parser.parse_args()
	success=True

	if options.doctest:
		import os; print os.path.basename(sys.argv[0]), 'doctests ...',
		sys.argv= [sys.argv[0]]
		if options.verbose: sys.argv.append('-v')
		import doctest
		numfail,numtests=doctest.testmod()
		if numfail==0: print 'ok'
		else: 
			print 'FAILED'
			success=False

	if not success: sys.exit('Something Failed')
	del success # Hide success from epydoc

	if options.unittest:
		sys.argv = [sys.argv[0]]
		if options.verbose: sys.argv.append('-v')
		unittest.main()

	outfile = sys.stdout
	if None!=options.outputFileName:
		outfile = file(options.outputFileName,'w')


	if options.doEncode:
		# First make sure all non required options are specified
		if None==options.RepeatIndicatorField: parser.error("missing value for RepeatIndicatorField")
		if None==options.UserIDField: parser.error("missing value for UserIDField")
		if None==options.reasonField: parser.error("missing value for reasonField")
		if None==options.fromField: parser.error("missing value for fromField")
		if None==options.toField: parser.error("missing value for toField")
		if None==options.radiusField: parser.error("missing value for radiusField")
		if None==options.unitField: parser.error("missing value for unitField")
		if None==options.closingdayField: parser.error("missing value for closingdayField")
		if None==options.closingmonthField: parser.error("missing value for closingmonthField")
		if None==options.fromhourField: parser.error("missing value for fromhourField")
		if None==options.fromminField: parser.error("missing value for fromminField")
		if None==options.todayField: parser.error("missing value for todayField")
		if None==options.tomonthField: parser.error("missing value for tomonthField")
		if None==options.tohourField: parser.error("missing value for tohourField")
		if None==options.tominField: parser.error("missing value for tominField")
		msgDict={
			'MessageID': '8',
			'RepeatIndicator': options.RepeatIndicatorField,
			'UserID': options.UserIDField,
			'Spare': '0',
			'dac': '1',
			'fid': '11',
			'reason': options.reasonField,
			'from': options.fromField,
			'to': options.toField,
			'radius': options.radiusField,
			'unit': options.unitField,
			'closingday': options.closingdayField,
			'closingmonth': options.closingmonthField,
			'fromhour': options.fromhourField,
			'frommin': options.fromminField,
			'today': options.todayField,
			'tomonth': options.tomonthField,
			'tohour': options.tohourField,
			'tomin': options.tominField,
			'spare2': '0',
		}

		bits = encode(msgDict)
		if 'binary'==options.ioType: print str(bits)
		elif 'nmeapayload'==options.ioType:
		    # FIX: figure out if this might be necessary at compile time
		    #print "bitLen",len(bits)
		    bitLen=len(bits)
		    if bitLen%6!=0:
			bits = bits + BitVector(size=(6 - (bitLen%6)))  # Pad out to multiple of 6
		    #print "result:",binary.bitvectoais6(bits)[0]
		    print binary.bitvectoais6(bits)[0]


		# FIX: Do not emit this option for the binary message payloads.  Does not make sense.
		elif 'nmea'==options.ioType: 
		    #bitLen=len(bits)
                    #if bitLen%6!=0:
		    #	bits = bits + BitVector(size=(6 - (bitLen%6)))  # Pad out to multiple of 6
                    import aisutils.uscg as uscg
                    nmea = uscg.create_nmea(bits)
                    print nmea
                    #
                    #


                    #sys.exit("FIX: need to implement creating nmea capability")
		else: sys.exit('ERROR: unknown ioType.  Help!')


	if options.sqlCreate:
		sqlCreateStr(outfile,options.fieldList,dbType=options.dbType)

	if options.latexDefinitionTable:
		latexDefinitionTable(outfile)

	# For conversion to word tables
	if options.textDefinitionTable:
		textDefinitionTable(outfile,options.delimTextDefinitionTable)

	if options.printCsvfieldList:
		# Make a csv separated list of fields that will be displayed for csv
		if None == options.fieldList: options.fieldList = fieldList
		import StringIO
		buf = StringIO.StringIO()
		for field in options.fieldList:
			buf.write(field+',')
		result = buf.getvalue()
		if result[-1] == ',': print result[:-1]
		else: print result

	if options.doDecode:
		if len(args)==0: args = sys.stdin
		for msg in args:
			bv = None

			if msg[0] in ('$','!') and msg[3:6] in ('VDM','VDO'):
				# Found nmea
				# FIX: do checksum
				bv = binary.ais6tobitvec(msg.split(',')[5])
			else: # either binary or nmeapayload... expect mostly nmeapayloads
				# assumes that an all 0 and 1 string can not be a nmeapayload
				binaryMsg=True
				for c in msg:
					if c not in ('0','1'):
						binaryMsg=False
						break
				if binaryMsg:
					bv = BitVector(bitstring=msg)
				else: # nmeapayload
					bv = binary.ais6tobitvec(msg)

			printFields(decode(bv)
				    ,out=outfile
				    ,format=options.outputType
				    ,fieldList=options.fieldList
				    ,dbType=options.dbType
				    )

############################################################
if __name__=='__main__':
    main()
