#!/usr/bin/env python

__version__ = '$Revision: 4791 $'.split()[1]
__date__ = '$Date: 2012-10-07 $'.split()[1]
__author__ = 'xmlbinmsg'

__doc__='''

Autogenerated python functions to serialize/deserialize binary messages.

Generated by: ../scripts/aisxmlbinmsg2py.py

Need to then wrap these functions with the outer AIS packet and then
convert the whole binary blob to a NMEA string.  Those functions are
not currently provided in this file.

serialize: python to ais binary
deserialize: ais binary to python

The generated code uses translators.py, binary.py, and aisstring.py
which should be packaged with the resulting files.


@requires: U{epydoc<http://epydoc.sourceforge.net/>} > 3.0alpha3
@requires: U{BitVector<http://cheeseshop.python.org/pypi/BitVector>}

@author: '''+__author__+'''
@version: ''' + __version__ +'''
@var __date__: Date of last svn commit
@undocumented: __version__ __author__ __doc__ parser
@status: under development
@license: Generated code has no license
@todo: FIX: put in a description of the message here with fields and types.
'''

import sys
from decimal import Decimal
from BitVector import BitVector

import binary, aisstring

# FIX: check to see if these will be needed
TrueBV  = BitVector(bitstring="1")
"Why always rebuild the True bit?  This should speed things up a bunch"
FalseBV = BitVector(bitstring="0")
"Why always rebuild the False bit?  This should speed things up a bunch"


fieldList = (
	'MessageID',
	'RepeatIndicator',
	'UserID',
	'SeqNum',
	'DestinationID',
	'RetransmitFlag',
	'Spare',
	'dac',
	'fid',
	'month',
	'day',
	'window1_longitude',
	'window1_latitude',
	'fromhour1',
	'frommin1',
	'tohour1',
	'tomin1',
	'curdir1',
	'curspeed1',
	'window2_longitude',
	'window2_latitude',
	'fromhour2',
	'frommin2',
	'tohour2',
	'tomin2',
	'curdir2',
	'curspeed2',
	'window3_longitude',
	'window3_latitude',
	'fromhour3',
	'frommin3',
	'tohour3',
	'tomin3',
	'curdir3',
	'curspeed3',
)

fieldListPostgres = (
	'MessageID',
	'RepeatIndicator',
	'UserID',
	'SeqNum',
	'DestinationID',
	'RetransmitFlag',
	'Spare',
	'dac',
	'fid',
	'month',
	'day',
	'window1',	# PostGIS data type
	'fromhour1',
	'frommin1',
	'tohour1',
	'tomin1',
	'curdir1',
	'curspeed1',
	'window2',	# PostGIS data type
	'fromhour2',
	'frommin2',
	'tohour2',
	'tomin2',
	'curdir2',
	'curspeed2',
	'window3',	# PostGIS data type
	'fromhour3',
	'frommin3',
	'tohour3',
	'tomin3',
	'curdir3',
	'curspeed3',
)

toPgFields = {
	'window1_longitude':'window1',
	'window1_latitude':'window1',
	'window2_longitude':'window2',
	'window2_latitude':'window2',
	'window3_longitude':'window3',
	'window3_latitude':'window3',
}
'''
Go to the Postgis field names from the straight field name
'''

fromPgFields = {
	'window1':('window1_longitude','window1_latitude',),
	'window2':('window2_longitude','window2_latitude',),
	'window3':('window3_longitude','window3_latitude',),
}
'''
Go from the Postgis field names to the straight field name
'''

pgTypes = {
	'window1':'POINT',
	'window2':'POINT',
	'window3':'POINT',
}
'''
Lookup table for each postgis field name to get its type.
'''

def encode(params, validate=False):
	'''Create a imo_tidal_window binary message payload to pack into an AIS Msg imo_tidal_window.

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 6 (field automatically set to "6")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): MMSI number of transmitter broadcasting the message
	  - SeqNum(uint): Sequence number as described in 5.3.1.  Assigned to each station
	  - DestinationID(uint): Unique ship identification number (MMSI)
	  - RetransmitFlag(bool): Should be set upon retransmission
	  - Spare(uint): Must be 0 (field automatically set to "0")
	  - dac(uint): Designated Area Code - part 1 of the IAI (field automatically set to "1")
	  - fid(uint): Functional Identifier - part 2 of the IAI (field automatically set to "11")
	  - month(uint): UTC month
	  - day(uint): UTC day
	  - window1_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window1_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour1(uint): From UTC hour
	  - frommin1(uint): From UTC minute
	  - tohour1(uint): To UTC hour
	  - tomin1(uint): To UTC minute
	  - curdir1(uint): Current direction
	  - curspeed1(udecimal): Current speed
	  - window2_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window2_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour2(uint): From UTC hour
	  - frommin2(uint): From UTC minute
	  - tohour2(uint): To UTC hour
	  - tomin2(uint): To UTC minute
	  - curdir2(uint): Current direction
	  - curspeed2(udecimal): Current speed
	  - window3_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window3_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour3(uint): From UTC hour
	  - frommin3(uint): From UTC minute
	  - tohour3(uint): To UTC hour
	  - tomin3(uint): To UTC minute
	  - curdir3(uint): Current direction
	  - curspeed3(udecimal): Current speed
	@param params: Dictionary of field names/values.  Throws a ValueError exception if required is missing
	@param validate: Set to true to cause checking to occur.  Runs slower.  FIX: not implemented.
	@rtype: BitVector
	@return: encoded binary message (for binary messages, this needs to be wrapped in a msg 8
	@note: The returned bits may not be 6 bit aligned.  It is up to you to pad out the bits.
	'''

	bvList = []
	bvList.append(binary.setBitVectorSize(BitVector(intVal=6),6))
	if 'RepeatIndicator' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['RepeatIndicator']),2))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),2))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['UserID']),30))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['SeqNum']),2))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=params['DestinationID']),30))
	if params["RetransmitFlag"]: bvList.append(TrueBV)
	else: bvList.append(FalseBV)
	bvList.append(binary.setBitVectorSize(BitVector(intVal=0),1))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=1),10))
	bvList.append(binary.setBitVectorSize(BitVector(intVal=11),6))
	if 'month' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['month']),4))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),4))
	if 'day' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['day']),5))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=0),5))
	if 'window1_longitude' in params:
		bvList.append(binary.bvFromSignedInt(int(Decimal(params['window1_longitude'])*Decimal('600000')),28))
	else:
		bvList.append(binary.bvFromSignedInt(108600000,28))
	if 'window1_latitude' in params:
		bvList.append(binary.bvFromSignedInt(int(Decimal(params['window1_latitude'])*Decimal('600000')),27))
	else:
		bvList.append(binary.bvFromSignedInt(54600000,27))
	if 'fromhour1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['fromhour1']),5))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=24),5))
	if 'frommin1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['frommin1']),6))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=60),6))
	if 'tohour1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tohour1']),5))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=24),5))
	if 'tomin1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tomin1']),6))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=60),6))
	if 'curdir1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['curdir1']),9))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=360),9))
	if 'curspeed1' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=int((Decimal(params['curspeed1'])*Decimal('10')))),7))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=int(127)),7))
	if 'window2_longitude' in params:
		bvList.append(binary.bvFromSignedInt(int(Decimal(params['window2_longitude'])*Decimal('600000')),28))
	else:
		bvList.append(binary.bvFromSignedInt(108600000,28))
	if 'window2_latitude' in params:
		bvList.append(binary.bvFromSignedInt(int(Decimal(params['window2_latitude'])*Decimal('600000')),27))
	else:
		bvList.append(binary.bvFromSignedInt(54600000,27))
	if 'fromhour2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['fromhour2']),5))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=24),5))
	if 'frommin2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['frommin2']),6))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=60),6))
	if 'tohour2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tohour2']),5))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=24),5))
	if 'tomin2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tomin2']),6))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=60),6))
	if 'curdir2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['curdir2']),9))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=360),9))
	if 'curspeed2' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=int((Decimal(params['curspeed2'])*Decimal('10')))),7))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=int(127)),7))
	if 'window3_longitude' in params:
		bvList.append(binary.bvFromSignedInt(int(Decimal(params['window3_longitude'])*Decimal('600000')),28))
	else:
		bvList.append(binary.bvFromSignedInt(108600000,28))
	if 'window3_latitude' in params:
		bvList.append(binary.bvFromSignedInt(int(Decimal(params['window3_latitude'])*Decimal('600000')),27))
	else:
		bvList.append(binary.bvFromSignedInt(54600000,27))
	if 'fromhour3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['fromhour3']),5))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=24),5))
	if 'frommin3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['frommin3']),6))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=60),6))
	if 'tohour3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tohour3']),5))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=24),5))
	if 'tomin3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['tomin3']),6))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=60),6))
	if 'curdir3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=params['curdir3']),9))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=360),9))
	if 'curspeed3' in params:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=int((Decimal(params['curspeed3'])*Decimal('10')))),7))
	else:
		bvList.append(binary.setBitVectorSize(BitVector(intVal=int(127)),7))

	return binary.joinBV(bvList)

def decode(bv, validate=False):
	'''Unpack a imo_tidal_window message 

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 6 (field automatically set to "6")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): MMSI number of transmitter broadcasting the message
	  - SeqNum(uint): Sequence number as described in 5.3.1.  Assigned to each station
	  - DestinationID(uint): Unique ship identification number (MMSI)
	  - RetransmitFlag(bool): Should be set upon retransmission
	  - Spare(uint): Must be 0 (field automatically set to "0")
	  - dac(uint): Designated Area Code - part 1 of the IAI (field automatically set to "1")
	  - fid(uint): Functional Identifier - part 2 of the IAI (field automatically set to "11")
	  - month(uint): UTC month
	  - day(uint): UTC day
	  - window1_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window1_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour1(uint): From UTC hour
	  - frommin1(uint): From UTC minute
	  - tohour1(uint): To UTC hour
	  - tomin1(uint): To UTC minute
	  - curdir1(uint): Current direction
	  - curspeed1(udecimal): Current speed
	  - window2_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window2_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour2(uint): From UTC hour
	  - frommin2(uint): From UTC minute
	  - tohour2(uint): To UTC hour
	  - tomin2(uint): To UTC minute
	  - curdir2(uint): Current direction
	  - curspeed2(udecimal): Current speed
	  - window3_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window3_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour3(uint): From UTC hour
	  - frommin3(uint): From UTC minute
	  - tohour3(uint): To UTC hour
	  - tomin3(uint): To UTC minute
	  - curdir3(uint): Current direction
	  - curspeed3(udecimal): Current speed
	@type bv: BitVector
	@param bv: Bits defining a message
	@param validate: Set to true to cause checking to occur.  Runs slower.  FIX: not implemented.
	@rtype: dict
	@return: params
	'''

	#Would be nice to check the bit count here..
	#if validate:
	#	assert (len(bv)==FIX: SOME NUMBER)
	r = {}
	r['MessageID']=6
	r['RepeatIndicator']=int(bv[6:8])
	r['UserID']=int(bv[8:38])
	r['SeqNum']=int(bv[38:40])
	r['DestinationID']=int(bv[40:70])
	r['RetransmitFlag']=bool(int(bv[70:71]))
	r['Spare']=0
	r['dac']=1
	r['fid']=11
	r['month']=int(bv[88:92])
	r['day']=int(bv[92:97])
	r['window1_longitude']=Decimal(binary.signedIntFromBV(bv[97:125]))/Decimal('600000')
	r['window1_latitude']=Decimal(binary.signedIntFromBV(bv[125:152]))/Decimal('600000')
	r['fromhour1']=int(bv[152:157])
	r['frommin1']=int(bv[157:163])
	r['tohour1']=int(bv[163:168])
	r['tomin1']=int(bv[168:174])
	r['curdir1']=int(bv[174:183])
	r['curspeed1']=Decimal(int(bv[183:190]))/Decimal('10')
	r['window2_longitude']=Decimal(binary.signedIntFromBV(bv[190:218]))/Decimal('600000')
	r['window2_latitude']=Decimal(binary.signedIntFromBV(bv[218:245]))/Decimal('600000')
	r['fromhour2']=int(bv[245:250])
	r['frommin2']=int(bv[250:256])
	r['tohour2']=int(bv[256:261])
	r['tomin2']=int(bv[261:267])
	r['curdir2']=int(bv[267:276])
	r['curspeed2']=Decimal(int(bv[276:283]))/Decimal('10')
	r['window3_longitude']=Decimal(binary.signedIntFromBV(bv[283:311]))/Decimal('600000')
	r['window3_latitude']=Decimal(binary.signedIntFromBV(bv[311:338]))/Decimal('600000')
	r['fromhour3']=int(bv[338:343])
	r['frommin3']=int(bv[343:349])
	r['tohour3']=int(bv[349:354])
	r['tomin3']=int(bv[354:360])
	r['curdir3']=int(bv[360:369])
	r['curspeed3']=Decimal(int(bv[369:376]))/Decimal('10')
	return r

def decodeMessageID(bv, validate=False):
	return 6

def decodeRepeatIndicator(bv, validate=False):
	return int(bv[6:8])

def decodeUserID(bv, validate=False):
	return int(bv[8:38])

def decodeSeqNum(bv, validate=False):
	return int(bv[38:40])

def decodeDestinationID(bv, validate=False):
	return int(bv[40:70])

def decodeRetransmitFlag(bv, validate=False):
	return bool(int(bv[70:71]))

def decodeSpare(bv, validate=False):
	return 0

def decodedac(bv, validate=False):
	return 1

def decodefid(bv, validate=False):
	return 11

def decodemonth(bv, validate=False):
	return int(bv[88:92])

def decodeday(bv, validate=False):
	return int(bv[92:97])

def decodewindow1_longitude(bv, validate=False):
	return Decimal(binary.signedIntFromBV(bv[97:125]))/Decimal('600000')

def decodewindow1_latitude(bv, validate=False):
	return Decimal(binary.signedIntFromBV(bv[125:152]))/Decimal('600000')

def decodefromhour1(bv, validate=False):
	return int(bv[152:157])

def decodefrommin1(bv, validate=False):
	return int(bv[157:163])

def decodetohour1(bv, validate=False):
	return int(bv[163:168])

def decodetomin1(bv, validate=False):
	return int(bv[168:174])

def decodecurdir1(bv, validate=False):
	return int(bv[174:183])

def decodecurspeed1(bv, validate=False):
	return Decimal(int(bv[183:190]))/Decimal('10')

def decodewindow2_longitude(bv, validate=False):
	return Decimal(binary.signedIntFromBV(bv[190:218]))/Decimal('600000')

def decodewindow2_latitude(bv, validate=False):
	return Decimal(binary.signedIntFromBV(bv[218:245]))/Decimal('600000')

def decodefromhour2(bv, validate=False):
	return int(bv[245:250])

def decodefrommin2(bv, validate=False):
	return int(bv[250:256])

def decodetohour2(bv, validate=False):
	return int(bv[256:261])

def decodetomin2(bv, validate=False):
	return int(bv[261:267])

def decodecurdir2(bv, validate=False):
	return int(bv[267:276])

def decodecurspeed2(bv, validate=False):
	return Decimal(int(bv[276:283]))/Decimal('10')

def decodewindow3_longitude(bv, validate=False):
	return Decimal(binary.signedIntFromBV(bv[283:311]))/Decimal('600000')

def decodewindow3_latitude(bv, validate=False):
	return Decimal(binary.signedIntFromBV(bv[311:338]))/Decimal('600000')

def decodefromhour3(bv, validate=False):
	return int(bv[338:343])

def decodefrommin3(bv, validate=False):
	return int(bv[343:349])

def decodetohour3(bv, validate=False):
	return int(bv[349:354])

def decodetomin3(bv, validate=False):
	return int(bv[354:360])

def decodecurdir3(bv, validate=False):
	return int(bv[360:369])

def decodecurspeed3(bv, validate=False):
	return Decimal(int(bv[369:376]))/Decimal('10')


def printHtml(params, out=sys.stdout):
		out.write("<h3>imo_tidal_window</h3>\n")
		out.write("<table border=\"1\">\n")
		out.write("<tr bgcolor=\"orange\">\n")
		out.write("<th align=\"left\">Field Name</th>\n")
		out.write("<th align=\"left\">Type</th>\n")
		out.write("<th align=\"left\">Value</th>\n")
		out.write("<th align=\"left\">Value in Lookup Table</th>\n")
		out.write("<th align=\"left\">Units</th>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>MessageID</td>\n")
		out.write("<td>uint</td>\n")
		if 'MessageID' in params:
			out.write("	<td>"+str(params['MessageID'])+"</td>\n")
			out.write("	<td>"+str(params['MessageID'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>RepeatIndicator</td>\n")
		out.write("<td>uint</td>\n")
		if 'RepeatIndicator' in params:
			out.write("	<td>"+str(params['RepeatIndicator'])+"</td>\n")
			if str(params['RepeatIndicator']) in RepeatIndicatorDecodeLut:
				out.write("<td>"+RepeatIndicatorDecodeLut[str(params['RepeatIndicator'])]+"</td>")
			else:
				out.write("<td><i>Missing LUT entry</i></td>")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>UserID</td>\n")
		out.write("<td>uint</td>\n")
		if 'UserID' in params:
			out.write("	<td>"+str(params['UserID'])+"</td>\n")
			out.write("	<td>"+str(params['UserID'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>SeqNum</td>\n")
		out.write("<td>uint</td>\n")
		if 'SeqNum' in params:
			out.write("	<td>"+str(params['SeqNum'])+"</td>\n")
			out.write("	<td>"+str(params['SeqNum'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>DestinationID</td>\n")
		out.write("<td>uint</td>\n")
		if 'DestinationID' in params:
			out.write("	<td>"+str(params['DestinationID'])+"</td>\n")
			out.write("	<td>"+str(params['DestinationID'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>RetransmitFlag</td>\n")
		out.write("<td>bool</td>\n")
		if 'RetransmitFlag' in params:
			out.write("	<td>"+str(params['RetransmitFlag'])+"</td>\n")
			if str(params['RetransmitFlag']) in RetransmitFlagDecodeLut:
				out.write("<td>"+RetransmitFlagDecodeLut[str(params['RetransmitFlag'])]+"</td>")
			else:
				out.write("<td><i>Missing LUT entry</i></td>")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>Spare</td>\n")
		out.write("<td>uint</td>\n")
		if 'Spare' in params:
			out.write("	<td>"+str(params['Spare'])+"</td>\n")
			out.write("	<td>"+str(params['Spare'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>dac</td>\n")
		out.write("<td>uint</td>\n")
		if 'dac' in params:
			out.write("	<td>"+str(params['dac'])+"</td>\n")
			out.write("	<td>"+str(params['dac'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>fid</td>\n")
		out.write("<td>uint</td>\n")
		if 'fid' in params:
			out.write("	<td>"+str(params['fid'])+"</td>\n")
			out.write("	<td>"+str(params['fid'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>month</td>\n")
		out.write("<td>uint</td>\n")
		if 'month' in params:
			out.write("	<td>"+str(params['month'])+"</td>\n")
			out.write("	<td>"+str(params['month'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>day</td>\n")
		out.write("<td>uint</td>\n")
		if 'day' in params:
			out.write("	<td>"+str(params['day'])+"</td>\n")
			out.write("	<td>"+str(params['day'])+"</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>window1_longitude</td>\n")
		out.write("<td>decimal</td>\n")
		if 'window1_longitude' in params:
			out.write("	<td>"+str(params['window1_longitude'])+"</td>\n")
			out.write("	<td>"+str(params['window1_longitude'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>window1_latitude</td>\n")
		out.write("<td>decimal</td>\n")
		if 'window1_latitude' in params:
			out.write("	<td>"+str(params['window1_latitude'])+"</td>\n")
			out.write("	<td>"+str(params['window1_latitude'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>fromhour1</td>\n")
		out.write("<td>uint</td>\n")
		if 'fromhour1' in params:
			out.write("	<td>"+str(params['fromhour1'])+"</td>\n")
			out.write("	<td>"+str(params['fromhour1'])+"</td>\n")
		out.write("<td>hours</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>frommin1</td>\n")
		out.write("<td>uint</td>\n")
		if 'frommin1' in params:
			out.write("	<td>"+str(params['frommin1'])+"</td>\n")
			out.write("	<td>"+str(params['frommin1'])+"</td>\n")
		out.write("<td>minutes</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tohour1</td>\n")
		out.write("<td>uint</td>\n")
		if 'tohour1' in params:
			out.write("	<td>"+str(params['tohour1'])+"</td>\n")
			out.write("	<td>"+str(params['tohour1'])+"</td>\n")
		out.write("<td>hours</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tomin1</td>\n")
		out.write("<td>uint</td>\n")
		if 'tomin1' in params:
			out.write("	<td>"+str(params['tomin1'])+"</td>\n")
			out.write("	<td>"+str(params['tomin1'])+"</td>\n")
		out.write("<td>minutes</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>curdir1</td>\n")
		out.write("<td>uint</td>\n")
		if 'curdir1' in params:
			out.write("	<td>"+str(params['curdir1'])+"</td>\n")
			out.write("	<td>"+str(params['curdir1'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>curspeed1</td>\n")
		out.write("<td>udecimal</td>\n")
		if 'curspeed1' in params:
			out.write("	<td>"+str(params['curspeed1'])+"</td>\n")
			out.write("	<td>"+str(params['curspeed1'])+"</td>\n")
		out.write("<td>knots</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>window2_longitude</td>\n")
		out.write("<td>decimal</td>\n")
		if 'window2_longitude' in params:
			out.write("	<td>"+str(params['window2_longitude'])+"</td>\n")
			out.write("	<td>"+str(params['window2_longitude'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>window2_latitude</td>\n")
		out.write("<td>decimal</td>\n")
		if 'window2_latitude' in params:
			out.write("	<td>"+str(params['window2_latitude'])+"</td>\n")
			out.write("	<td>"+str(params['window2_latitude'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>fromhour2</td>\n")
		out.write("<td>uint</td>\n")
		if 'fromhour2' in params:
			out.write("	<td>"+str(params['fromhour2'])+"</td>\n")
			out.write("	<td>"+str(params['fromhour2'])+"</td>\n")
		out.write("<td>hours</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>frommin2</td>\n")
		out.write("<td>uint</td>\n")
		if 'frommin2' in params:
			out.write("	<td>"+str(params['frommin2'])+"</td>\n")
			out.write("	<td>"+str(params['frommin2'])+"</td>\n")
		out.write("<td>minutes</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tohour2</td>\n")
		out.write("<td>uint</td>\n")
		if 'tohour2' in params:
			out.write("	<td>"+str(params['tohour2'])+"</td>\n")
			out.write("	<td>"+str(params['tohour2'])+"</td>\n")
		out.write("<td>hours</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tomin2</td>\n")
		out.write("<td>uint</td>\n")
		if 'tomin2' in params:
			out.write("	<td>"+str(params['tomin2'])+"</td>\n")
			out.write("	<td>"+str(params['tomin2'])+"</td>\n")
		out.write("<td>minutes</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>curdir2</td>\n")
		out.write("<td>uint</td>\n")
		if 'curdir2' in params:
			out.write("	<td>"+str(params['curdir2'])+"</td>\n")
			out.write("	<td>"+str(params['curdir2'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>curspeed2</td>\n")
		out.write("<td>udecimal</td>\n")
		if 'curspeed2' in params:
			out.write("	<td>"+str(params['curspeed2'])+"</td>\n")
			out.write("	<td>"+str(params['curspeed2'])+"</td>\n")
		out.write("<td>knots</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>window3_longitude</td>\n")
		out.write("<td>decimal</td>\n")
		if 'window3_longitude' in params:
			out.write("	<td>"+str(params['window3_longitude'])+"</td>\n")
			out.write("	<td>"+str(params['window3_longitude'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>window3_latitude</td>\n")
		out.write("<td>decimal</td>\n")
		if 'window3_latitude' in params:
			out.write("	<td>"+str(params['window3_latitude'])+"</td>\n")
			out.write("	<td>"+str(params['window3_latitude'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>fromhour3</td>\n")
		out.write("<td>uint</td>\n")
		if 'fromhour3' in params:
			out.write("	<td>"+str(params['fromhour3'])+"</td>\n")
			out.write("	<td>"+str(params['fromhour3'])+"</td>\n")
		out.write("<td>hours</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>frommin3</td>\n")
		out.write("<td>uint</td>\n")
		if 'frommin3' in params:
			out.write("	<td>"+str(params['frommin3'])+"</td>\n")
			out.write("	<td>"+str(params['frommin3'])+"</td>\n")
		out.write("<td>minutes</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tohour3</td>\n")
		out.write("<td>uint</td>\n")
		if 'tohour3' in params:
			out.write("	<td>"+str(params['tohour3'])+"</td>\n")
			out.write("	<td>"+str(params['tohour3'])+"</td>\n")
		out.write("<td>hours</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>tomin3</td>\n")
		out.write("<td>uint</td>\n")
		if 'tomin3' in params:
			out.write("	<td>"+str(params['tomin3'])+"</td>\n")
			out.write("	<td>"+str(params['tomin3'])+"</td>\n")
		out.write("<td>minutes</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>curdir3</td>\n")
		out.write("<td>uint</td>\n")
		if 'curdir3' in params:
			out.write("	<td>"+str(params['curdir3'])+"</td>\n")
			out.write("	<td>"+str(params['curdir3'])+"</td>\n")
		out.write("<td>degrees</td>\n")
		out.write("</tr>\n")
		out.write("\n")
		out.write("<tr>\n")
		out.write("<td>curspeed3</td>\n")
		out.write("<td>udecimal</td>\n")
		if 'curspeed3' in params:
			out.write("	<td>"+str(params['curspeed3'])+"</td>\n")
			out.write("	<td>"+str(params['curspeed3'])+"</td>\n")
		out.write("<td>knots</td>\n")
		out.write("</tr>\n")
		out.write("</table>\n")


def printKml(params, out=sys.stdout):
	'''KML (Keyhole Markup Language) for Google Earth, but without the header/footer'''
	out.write("\	<Placemark>\n")
	out.write("\t	<name>"+str(params['UserID'])+"</name>\n")
	out.write("\t\t<description>\n")
	import StringIO
	buf = StringIO.StringIO()
	printHtml(params,buf)
	import cgi
	out.write(cgi.escape(buf.getvalue()))
	out.write("\t\t</description>\n")
	out.write("\t\t<styleUrl>#m_ylw-pushpin_copy0</styleUrl>\n")
	out.write("\t\t<Point>\n")
	out.write("\t\t\t<coordinates>")
	out.write(str(params['window1_longitude']))
	out.write(',')
	out.write(str(params['window1_latitude']))
	out.write(",0</coordinates>\n")
	out.write("\t\t</Point>\n")
	out.write("\t</Placemark>\n")

def printFields(params, out=sys.stdout, format='std', fieldList=None, dbType='postgres'):
	'''Print a imo_tidal_window message to stdout.

	Fields in params:
	  - MessageID(uint): AIS message number.  Must be 6 (field automatically set to "6")
	  - RepeatIndicator(uint): Indicated how many times a message has been repeated
	  - UserID(uint): MMSI number of transmitter broadcasting the message
	  - SeqNum(uint): Sequence number as described in 5.3.1.  Assigned to each station
	  - DestinationID(uint): Unique ship identification number (MMSI)
	  - RetransmitFlag(bool): Should be set upon retransmission
	  - Spare(uint): Must be 0 (field automatically set to "0")
	  - dac(uint): Designated Area Code - part 1 of the IAI (field automatically set to "1")
	  - fid(uint): Functional Identifier - part 2 of the IAI (field automatically set to "11")
	  - month(uint): UTC month
	  - day(uint): UTC day
	  - window1_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window1_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour1(uint): From UTC hour
	  - frommin1(uint): From UTC minute
	  - tohour1(uint): To UTC hour
	  - tomin1(uint): To UTC minute
	  - curdir1(uint): Current direction
	  - curspeed1(udecimal): Current speed
	  - window2_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window2_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour2(uint): From UTC hour
	  - frommin2(uint): From UTC minute
	  - tohour2(uint): To UTC hour
	  - tomin2(uint): To UTC minute
	  - curdir2(uint): Current direction
	  - curspeed2(udecimal): Current speed
	  - window3_longitude(decimal): Not sure what this position is for?  Center?  East West location
	  - window3_latitude(decimal): Not sure what this position is for?  Center?  North South location
	  - fromhour3(uint): From UTC hour
	  - frommin3(uint): From UTC minute
	  - tohour3(uint): To UTC hour
	  - tomin3(uint): To UTC minute
	  - curdir3(uint): Current direction
	  - curspeed3(udecimal): Current speed
	@param params: Dictionary of field names/values.  
	@param out: File like object to write to
	@rtype: stdout
	@return: text to out
	'''

	if 'std'==format:
		out.write("imo_tidal_window:\n")
		if 'MessageID' in params: out.write("	MessageID:          "+str(params['MessageID'])+"\n")
		if 'RepeatIndicator' in params: out.write("	RepeatIndicator:    "+str(params['RepeatIndicator'])+"\n")
		if 'UserID' in params: out.write("	UserID:             "+str(params['UserID'])+"\n")
		if 'SeqNum' in params: out.write("	SeqNum:             "+str(params['SeqNum'])+"\n")
		if 'DestinationID' in params: out.write("	DestinationID:      "+str(params['DestinationID'])+"\n")
		if 'RetransmitFlag' in params: out.write("	RetransmitFlag:     "+str(params['RetransmitFlag'])+"\n")
		if 'Spare' in params: out.write("	Spare:              "+str(params['Spare'])+"\n")
		if 'dac' in params: out.write("	dac:                "+str(params['dac'])+"\n")
		if 'fid' in params: out.write("	fid:                "+str(params['fid'])+"\n")
		if 'month' in params: out.write("	month:              "+str(params['month'])+"\n")
		if 'day' in params: out.write("	day:                "+str(params['day'])+"\n")
		if 'window1_longitude' in params: out.write("	window1_longitude:  "+str(params['window1_longitude'])+"\n")
		if 'window1_latitude' in params: out.write("	window1_latitude:   "+str(params['window1_latitude'])+"\n")
		if 'fromhour1' in params: out.write("	fromhour1:          "+str(params['fromhour1'])+"\n")
		if 'frommin1' in params: out.write("	frommin1:           "+str(params['frommin1'])+"\n")
		if 'tohour1' in params: out.write("	tohour1:            "+str(params['tohour1'])+"\n")
		if 'tomin1' in params: out.write("	tomin1:             "+str(params['tomin1'])+"\n")
		if 'curdir1' in params: out.write("	curdir1:            "+str(params['curdir1'])+"\n")
		if 'curspeed1' in params: out.write("	curspeed1:          "+str(params['curspeed1'])+"\n")
		if 'window2_longitude' in params: out.write("	window2_longitude:  "+str(params['window2_longitude'])+"\n")
		if 'window2_latitude' in params: out.write("	window2_latitude:   "+str(params['window2_latitude'])+"\n")
		if 'fromhour2' in params: out.write("	fromhour2:          "+str(params['fromhour2'])+"\n")
		if 'frommin2' in params: out.write("	frommin2:           "+str(params['frommin2'])+"\n")
		if 'tohour2' in params: out.write("	tohour2:            "+str(params['tohour2'])+"\n")
		if 'tomin2' in params: out.write("	tomin2:             "+str(params['tomin2'])+"\n")
		if 'curdir2' in params: out.write("	curdir2:            "+str(params['curdir2'])+"\n")
		if 'curspeed2' in params: out.write("	curspeed2:          "+str(params['curspeed2'])+"\n")
		if 'window3_longitude' in params: out.write("	window3_longitude:  "+str(params['window3_longitude'])+"\n")
		if 'window3_latitude' in params: out.write("	window3_latitude:   "+str(params['window3_latitude'])+"\n")
		if 'fromhour3' in params: out.write("	fromhour3:          "+str(params['fromhour3'])+"\n")
		if 'frommin3' in params: out.write("	frommin3:           "+str(params['frommin3'])+"\n")
		if 'tohour3' in params: out.write("	tohour3:            "+str(params['tohour3'])+"\n")
		if 'tomin3' in params: out.write("	tomin3:             "+str(params['tomin3'])+"\n")
		if 'curdir3' in params: out.write("	curdir3:            "+str(params['curdir3'])+"\n")
		if 'curspeed3' in params: out.write("	curspeed3:          "+str(params['curspeed3'])+"\n")
	elif 'csv'==format:
		if None == options.fieldList:
			options.fieldList = fieldList
		needComma = False;
		for field in fieldList:
			if needComma: out.write(',')
			needComma = True
			if field in params:
				out.write(str(params[field]))
			# else: leave it empty
		out.write("\n")
	elif 'html'==format:
		printHtml(params,out)
	elif 'sql'==format:
		sqlInsertStr(params,out,dbType=dbType)
	elif 'kml'==format:
		printKml(params,out)
	elif 'kml-full'==format:
		out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n")
		out.write("<kml xmlns=\"http://earth.google.com/kml/2.1\">\n")
		out.write("<Document>\n")
		out.write("	<name>imo_tidal_window</name>\n")
		printKml(params,out)
		out.write("</Document>\n")
		out.write("</kml>\n")
	else: 
		print "ERROR: unknown format:",format
		assert False

	return # Nothing to return

RepeatIndicatorEncodeLut = {
	'default':'0',
	'do not repeat any more':'3',
	} #RepeatIndicatorEncodeLut

RepeatIndicatorDecodeLut = {
	'0':'default',
	'3':'do not repeat any more',
	} # RepeatIndicatorEncodeLut

RetransmitFlagEncodeLut = {
	'no retransmission':'0',
	'restransmitted':'1',
	} #RetransmitFlagEncodeLut

RetransmitFlagDecodeLut = {
	'0':'no retransmission',
	'1':'restransmitted',
	} # RetransmitFlagEncodeLut

######################################################################
# SQL SUPPORT
######################################################################

dbTableName='imo_tidal_window'
'Database table name'

def sqlCreateStr(outfile=sys.stdout, fields=None, extraFields=None
		,addCoastGuardFields=True
		,dbType='postgres'
		):
	'''
	Return the SQL CREATE command for this message type
	@param outfile: file like object to print to.
	@param fields: which fields to put in the create.  Defaults to all.
	@param extraFields: A sequence of tuples containing (name,sql type) for additional fields
	@param addCoastGuardFields: Add the extra fields that come after the NMEA check some from the USCG N-AIS format
	@param dbType: Which flavor of database we are using so that the create is tailored ('sqlite' or 'postgres')
	@type addCoastGuardFields: bool
	@return: sql create string
	@rtype: str

	@see: sqlCreate
	'''
	# FIX: should this sqlCreate be the same as in LaTeX (createFuncName) rather than hard coded?
	outfile.write(str(sqlCreate(fields,extraFields,addCoastGuardFields,dbType=dbType)))

def sqlCreate(fields=None, extraFields=None, addCoastGuardFields=True, dbType='postgres'):
	'''
	Return the sqlhelp object to create the table.

	@param fields: which fields to put in the create.  Defaults to all.
	@param extraFields: A sequence of tuples containing (name,sql type) for additional fields
	@param addCoastGuardFields: Add the extra fields that come after the NMEA check some from the USCG N-AIS format
	@type addCoastGuardFields: bool
	@param dbType: Which flavor of database we are using so that the create is tailored ('sqlite' or 'postgres')
	@return: An object that can be used to generate a return
	@rtype: sqlhelp.create
	'''
	if None == fields: fields = fieldList
	import sqlhelp
	c = sqlhelp.create('imo_tidal_window',dbType=dbType)
	c.addPrimaryKey()
	if 'MessageID' in fields: c.addInt ('MessageID')
	if 'RepeatIndicator' in fields: c.addInt ('RepeatIndicator')
	if 'UserID' in fields: c.addInt ('UserID')
	if 'SeqNum' in fields: c.addInt ('SeqNum')
	if 'DestinationID' in fields: c.addInt ('DestinationID')
	if 'RetransmitFlag' in fields: c.addBool('RetransmitFlag')
	if 'Spare' in fields: c.addInt ('Spare')
	if 'dac' in fields: c.addInt ('dac')
	if 'fid' in fields: c.addInt ('fid')
	if 'month' in fields: c.addInt ('month')
	if 'day' in fields: c.addInt ('day')
	if dbType != 'postgres':
		if 'window1_longitude' in fields: c.addDecimal('window1_longitude',8,5)
	if dbType != 'postgres':
		if 'window1_latitude' in fields: c.addDecimal('window1_latitude',8,5)
	if 'fromhour1' in fields: c.addInt ('fromhour1')
	if 'frommin1' in fields: c.addInt ('frommin1')
	if 'tohour1' in fields: c.addInt ('tohour1')
	if 'tomin1' in fields: c.addInt ('tomin1')
	if 'curdir1' in fields: c.addInt ('curdir1')
	if 'curspeed1' in fields: c.addDecimal('curspeed1',3,1)
	if dbType != 'postgres':
		if 'window2_longitude' in fields: c.addDecimal('window2_longitude',8,5)
	if dbType != 'postgres':
		if 'window2_latitude' in fields: c.addDecimal('window2_latitude',8,5)
	if 'fromhour2' in fields: c.addInt ('fromhour2')
	if 'frommin2' in fields: c.addInt ('frommin2')
	if 'tohour2' in fields: c.addInt ('tohour2')
	if 'tomin2' in fields: c.addInt ('tomin2')
	if 'curdir2' in fields: c.addInt ('curdir2')
	if 'curspeed2' in fields: c.addDecimal('curspeed2',3,1)
	if dbType != 'postgres':
		if 'window3_longitude' in fields: c.addDecimal('window3_longitude',8,5)
	if dbType != 'postgres':
		if 'window3_latitude' in fields: c.addDecimal('window3_latitude',8,5)
	if 'fromhour3' in fields: c.addInt ('fromhour3')
	if 'frommin3' in fields: c.addInt ('frommin3')
	if 'tohour3' in fields: c.addInt ('tohour3')
	if 'tomin3' in fields: c.addInt ('tomin3')
	if 'curdir3' in fields: c.addInt ('curdir3')
	if 'curspeed3' in fields: c.addDecimal('curspeed3',3,1)

	if addCoastGuardFields:
		# c.addInt('cg_s_rssi')     # Relative signal strength indicator
		# c.addInt('cg_d_strength')        # dBm receive strength
		# c.addVarChar('cg_x',10) # Idonno
		c.addInt('cg_t_arrival')        # Receive timestamp from the AIS equipment 'T'
		c.addInt('cg_s_slotnum')        # Slot received in
		c.addVarChar('cg_r',15)   # Receiver station ID  -  should usually be an MMSI, but sometimes is a string
		c.addInt('cg_sec')        # UTC seconds since the epoch

		c.addTimestamp('cg_timestamp') # UTC decoded cg_sec - not actually in the data stream

	if dbType == 'postgres':
		#--- EPSG 4326 : WGS 84
		#INSERT INTO "spatial_ref_sys" ("srid","auth_name","auth_srid","srtext","proj4text") VALUES (4326,'EPSG',4326,'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]]','+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ');
		c.addPostGIS('window1','POINT',2,SRID=4326);
		#--- EPSG 4326 : WGS 84
		#INSERT INTO "spatial_ref_sys" ("srid","auth_name","auth_srid","srtext","proj4text") VALUES (4326,'EPSG',4326,'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]]','+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ');
		c.addPostGIS('window2','POINT',2,SRID=4326);
		#--- EPSG 4326 : WGS 84
		#INSERT INTO "spatial_ref_sys" ("srid","auth_name","auth_srid","srtext","proj4text") VALUES (4326,'EPSG',4326,'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]]','+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ');
		c.addPostGIS('window3','POINT',2,SRID=4326);

	return c

def sqlInsertStr(params, outfile=sys.stdout, extraParams=None, dbType='postgres'):
	'''
	Return the SQL INSERT command for this message type
	@param params: dictionary of values keyed by field name
	@param outfile: file like object to print to.
	@param extraParams: A sequence of tuples containing (name,sql type) for additional fields
	@return: sql create string
	@rtype: str

	@see: sqlCreate
	'''
	outfile.write(str(sqlInsert(params,extraParams,dbType=dbType)))


def sqlInsert(params,extraParams=None,dbType='postgres'):
	'''
	Give the SQL INSERT statement
	@param params: dict keyed by field name of values
	@param extraParams: any extra fields that you have created beyond the normal ais message fields
	@rtype: sqlhelp.insert
	@return: insert class instance
	@todo: allow optional type checking of params?
	@warning: this will take invalid keys happily and do what???
	'''
	import sqlhelp
	i = sqlhelp.insert('imo_tidal_window',dbType=dbType)

	if dbType=='postgres':
		finished = []
		for key in params:
			if key in finished: 
				continue

			if key not in toPgFields and key not in fromPgFields:
				if type(params[key])==Decimal: i.add(key,float(params[key]))
				else: i.add(key,params[key])
			else:
				if key in fromPgFields:
					val = params[key]
				        # Had better be a WKT type like POINT(-88.1 30.321)
					i.addPostGIS(key,val)
					finished.append(key)
				else:
					# Need to construct the type.
					pgName = toPgFields[key]
					#valStr='GeomFromText(\''+pgTypes[pgName]+'('
					valStr=pgTypes[pgName]+'('
					vals = []
					for nonPgKey in fromPgFields[pgName]:
						vals.append(str(params[nonPgKey]))
						finished.append(nonPgKey)
					valStr+=' '.join(vals)+')'
					i.addPostGIS(pgName,valStr)
	else:
		for key in params: 
			if type(params[key])==Decimal: i.add(key,float(params[key]))
			else: i.add(key,params[key])

	if None != extraParams:
		for key in extraParams: 
			i.add(key,extraParams[key])

	return i

######################################################################
# LATEX SUPPORT
######################################################################

def latexDefinitionTable(outfile=sys.stdout
		):
	'''
	Return the LaTeX definition table for this message type
	@param outfile: file like object to print to.
	@type outfile: file obj
	@return: LaTeX table string via the outfile
	@rtype: str

	'''
	o = outfile

	o.write('''
\\begin{table}%[htb]
\\centering
\\begin{tabular}{|l|c|l|}
\\hline
Parameter & Number of bits & Description 
\\\\  \\hline\\hline
MessageID & 6 & AIS message number.  Must be 6 \\\\ \hline 
RepeatIndicator & 2 & Indicated how many times a message has been repeated \\\\ \hline 
UserID & 30 & MMSI number of transmitter broadcasting the message \\\\ \hline 
SeqNum & 2 & Sequence number as described in 5.3.1.  Assigned to each station \\\\ \hline 
DestinationID & 30 & Unique ship identification number (MMSI) \\\\ \hline 
RetransmitFlag & 1 & Should be set upon retransmission \\\\ \hline 
Spare & 1 & Must be 0 \\\\ \hline 
dac & 10 & Designated Area Code - part 1 of the IAI \\\\ \hline 
fid & 6 & Functional Identifier - part 2 of the IAI \\\\ \hline 
month & 4 & UTC month \\\\ \hline 
day & 5 & UTC day \\\\ \hline 
window1\_longitude & 28 & Not sure what this position is for?  Center?  East West location \\\\ \hline 
window1\_latitude & 27 & Not sure what this position is for?  Center?  North South location \\\\ \hline 
fromhour1 & 5 & From UTC hour \\\\ \hline 
frommin1 & 6 & From UTC minute \\\\ \hline 
tohour1 & 5 & To UTC hour \\\\ \hline 
tomin1 & 6 & To UTC minute \\\\ \hline 
curdir1 & 9 & Current direction \\\\ \hline 
curspeed1 & 7 & Current speed \\\\ \hline 
window2\_longitude & 28 & Not sure what this position is for?  Center?  East West location \\\\ \hline 
window2\_latitude & 27 & Not sure what this position is for?  Center?  North South location \\\\ \hline 
fromhour2 & 5 & From UTC hour \\\\ \hline 
frommin2 & 6 & From UTC minute \\\\ \hline 
tohour2 & 5 & To UTC hour \\\\ \hline 
tomin2 & 6 & To UTC minute \\\\ \hline 
curdir2 & 9 & Current direction \\\\ \hline 
curspeed2 & 7 & Current speed \\\\ \hline 
window3\_longitude & 28 & Not sure what this position is for?  Center?  East West location \\\\ \hline 
window3\_latitude & 27 & Not sure what this position is for?  Center?  North South location \\\\ \hline 
fromhour3 & 5 & From UTC hour \\\\ \hline 
frommin3 & 6 & From UTC minute \\\\ \hline 
tohour3 & 5 & To UTC hour \\\\ \hline 
tomin3 & 6 & To UTC minute \\\\ \hline 
curdir3 & 9 & Current direction \\\\ \hline 
curspeed3 & 7 & Current speed\\\\ \\hline \\hline
Total bits & 376 & Appears to take 2 slots with 48 pad bits to fill the last slot \\\\ \\hline
\\end{tabular}
\\caption{AIS message number 6: IMO tidal window.  Specified       in SN\\Circ.236 Annex 2, page 5, Application 3.  Also defined in IALA Guidelines on AIS,       Vol 1, Part 1, Ed. 1.3. Guildeline No 1028.        This message should be used to inform vessels about tidal       windows which allow a vessel the safe passage of a fairway.  The       message includes predictions of current speed and current       direction. In this example, three points of tidal information       are given. Attributes of message: addressed, shore station       transmitting, acknowledgement required.     }
\\label{tab:imo_tidal_window}
\\end{table}
''')

######################################################################
# Text Definition
######################################################################

def textDefinitionTable(outfile=sys.stdout
		,delim='\t'
		):
	'''
	Return the text definition table for this message type
	@param outfile: file like object to print to.
	@type outfile: file obj
	@return: text table string via the outfile
	@rtype: str

	'''
	o = outfile
	o.write('''Parameter'''+delim+'Number of bits'''+delim+'''Description 
MessageID'''+delim+'''6'''+delim+'''AIS message number.  Must be 6
RepeatIndicator'''+delim+'''2'''+delim+'''Indicated how many times a message has been repeated
UserID'''+delim+'''30'''+delim+'''MMSI number of transmitter broadcasting the message
SeqNum'''+delim+'''2'''+delim+'''Sequence number as described in 5.3.1.  Assigned to each station
DestinationID'''+delim+'''30'''+delim+'''Unique ship identification number (MMSI)
RetransmitFlag'''+delim+'''1'''+delim+'''Should be set upon retransmission
Spare'''+delim+'''1'''+delim+'''Must be 0
dac'''+delim+'''10'''+delim+'''Designated Area Code - part 1 of the IAI
fid'''+delim+'''6'''+delim+'''Functional Identifier - part 2 of the IAI
month'''+delim+'''4'''+delim+'''UTC month
day'''+delim+'''5'''+delim+'''UTC day
window1_longitude'''+delim+'''28'''+delim+'''Not sure what this position is for?  Center?  East West location
window1_latitude'''+delim+'''27'''+delim+'''Not sure what this position is for?  Center?  North South location
fromhour1'''+delim+'''5'''+delim+'''From UTC hour
frommin1'''+delim+'''6'''+delim+'''From UTC minute
tohour1'''+delim+'''5'''+delim+'''To UTC hour
tomin1'''+delim+'''6'''+delim+'''To UTC minute
curdir1'''+delim+'''9'''+delim+'''Current direction
curspeed1'''+delim+'''7'''+delim+'''Current speed
window2_longitude'''+delim+'''28'''+delim+'''Not sure what this position is for?  Center?  East West location
window2_latitude'''+delim+'''27'''+delim+'''Not sure what this position is for?  Center?  North South location
fromhour2'''+delim+'''5'''+delim+'''From UTC hour
frommin2'''+delim+'''6'''+delim+'''From UTC minute
tohour2'''+delim+'''5'''+delim+'''To UTC hour
tomin2'''+delim+'''6'''+delim+'''To UTC minute
curdir2'''+delim+'''9'''+delim+'''Current direction
curspeed2'''+delim+'''7'''+delim+'''Current speed
window3_longitude'''+delim+'''28'''+delim+'''Not sure what this position is for?  Center?  East West location
window3_latitude'''+delim+'''27'''+delim+'''Not sure what this position is for?  Center?  North South location
fromhour3'''+delim+'''5'''+delim+'''From UTC hour
frommin3'''+delim+'''6'''+delim+'''From UTC minute
tohour3'''+delim+'''5'''+delim+'''To UTC hour
tomin3'''+delim+'''6'''+delim+'''To UTC minute
curdir3'''+delim+'''9'''+delim+'''Current direction
curspeed3'''+delim+'''7'''+delim+'''Current speed
Total bits'''+delim+'''376'''+delim+'''Appears to take 2 slots with 48 pad bits to fill the last slot''')


######################################################################
# UNIT TESTING
######################################################################
import unittest
def testParams():
	'''Return a params file base on the testvalue tags.
	@rtype: dict
	@return: params based on testvalue tags
	'''
	params = {}
	params['MessageID'] = 6
	params['RepeatIndicator'] = 1
	params['UserID'] = 1193046
	params['SeqNum'] = 3
	params['DestinationID'] = 1193047
	params['RetransmitFlag'] = True
	params['Spare'] = 0
	params['dac'] = 1
	params['fid'] = 11
	params['month'] = 2
	params['day'] = 1
	params['window1_longitude'] = Decimal('-122.16328055555556')
	params['window1_latitude'] = Decimal('37.424458333333334')
	params['fromhour1'] = 1
	params['frommin1'] = 21
	params['tohour1'] = 23
	params['tomin1'] = 24
	params['curdir1'] = 300
	params['curspeed1'] = Decimal('12.1')
	params['window2_longitude'] = Decimal('-122.16328055555556')
	params['window2_latitude'] = Decimal('37.424458333333334')
	params['fromhour2'] = 1
	params['frommin2'] = 21
	params['tohour2'] = 23
	params['tomin2'] = 24
	params['curdir2'] = 300
	params['curspeed2'] = Decimal('12.1')
	params['window3_longitude'] = Decimal('-122.16328055555556')
	params['window3_latitude'] = Decimal('37.424458333333334')
	params['fromhour3'] = 1
	params['frommin3'] = 21
	params['tohour3'] = 23
	params['tomin3'] = 24
	params['curdir3'] = 300
	params['curspeed3'] = Decimal('12.1')

	return params

class Testimo_tidal_window(unittest.TestCase):
	'''Use testvalue tag text from each type to build test case the imo_tidal_window message'''
	def testEncodeDecode(self):

		params = testParams()
		bits   = encode(params)
		r      = decode(bits)

		# Check that each parameter came through ok.
		self.failUnlessEqual(r['MessageID'],params['MessageID'])
		self.failUnlessEqual(r['RepeatIndicator'],params['RepeatIndicator'])
		self.failUnlessEqual(r['UserID'],params['UserID'])
		self.failUnlessEqual(r['SeqNum'],params['SeqNum'])
		self.failUnlessEqual(r['DestinationID'],params['DestinationID'])
		self.failUnlessEqual(r['RetransmitFlag'],params['RetransmitFlag'])
		self.failUnlessEqual(r['Spare'],params['Spare'])
		self.failUnlessEqual(r['dac'],params['dac'])
		self.failUnlessEqual(r['fid'],params['fid'])
		self.failUnlessEqual(r['month'],params['month'])
		self.failUnlessEqual(r['day'],params['day'])
		self.failUnlessAlmostEqual(r['window1_longitude'],params['window1_longitude'],5)
		self.failUnlessAlmostEqual(r['window1_latitude'],params['window1_latitude'],5)
		self.failUnlessEqual(r['fromhour1'],params['fromhour1'])
		self.failUnlessEqual(r['frommin1'],params['frommin1'])
		self.failUnlessEqual(r['tohour1'],params['tohour1'])
		self.failUnlessEqual(r['tomin1'],params['tomin1'])
		self.failUnlessEqual(r['curdir1'],params['curdir1'])
		self.failUnlessAlmostEqual(r['curspeed1'],params['curspeed1'],1)
		self.failUnlessAlmostEqual(r['window2_longitude'],params['window2_longitude'],5)
		self.failUnlessAlmostEqual(r['window2_latitude'],params['window2_latitude'],5)
		self.failUnlessEqual(r['fromhour2'],params['fromhour2'])
		self.failUnlessEqual(r['frommin2'],params['frommin2'])
		self.failUnlessEqual(r['tohour2'],params['tohour2'])
		self.failUnlessEqual(r['tomin2'],params['tomin2'])
		self.failUnlessEqual(r['curdir2'],params['curdir2'])
		self.failUnlessAlmostEqual(r['curspeed2'],params['curspeed2'],1)
		self.failUnlessAlmostEqual(r['window3_longitude'],params['window3_longitude'],5)
		self.failUnlessAlmostEqual(r['window3_latitude'],params['window3_latitude'],5)
		self.failUnlessEqual(r['fromhour3'],params['fromhour3'])
		self.failUnlessEqual(r['frommin3'],params['frommin3'])
		self.failUnlessEqual(r['tohour3'],params['tohour3'])
		self.failUnlessEqual(r['tomin3'],params['tomin3'])
		self.failUnlessEqual(r['curdir3'],params['curdir3'])
		self.failUnlessAlmostEqual(r['curspeed3'],params['curspeed3'],1)

def addMsgOptions(parser):
	parser.add_option('-d','--decode',dest='doDecode',default=False,action='store_true',
		help='decode a "imo_tidal_window" AIS message')
	parser.add_option('-e','--encode',dest='doEncode',default=False,action='store_true',
		help='encode a "imo_tidal_window" AIS message')
	parser.add_option('--RepeatIndicator-field', dest='RepeatIndicatorField',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--UserID-field', dest='UserIDField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--SeqNum-field', dest='SeqNumField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--DestinationID-field', dest='DestinationIDField',metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--RetransmitFlag-field', dest='RetransmitFlagField',metavar='bool',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--month-field', dest='monthField',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--day-field', dest='dayField',default=0,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--window1_longitude-field', dest='window1_longitudeField',default=Decimal('181'),metavar='decimal',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--window1_latitude-field', dest='window1_latitudeField',default=Decimal('91'),metavar='decimal',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--fromhour1-field', dest='fromhour1Field',default=24,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--frommin1-field', dest='frommin1Field',default=60,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tohour1-field', dest='tohour1Field',default=24,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tomin1-field', dest='tomin1Field',default=60,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--curdir1-field', dest='curdir1Field',default=360,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--curspeed1-field', dest='curspeed1Field',default=Decimal('12.7'),metavar='udecimal',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--window2_longitude-field', dest='window2_longitudeField',default=Decimal('181'),metavar='decimal',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--window2_latitude-field', dest='window2_latitudeField',default=Decimal('91'),metavar='decimal',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--fromhour2-field', dest='fromhour2Field',default=24,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--frommin2-field', dest='frommin2Field',default=60,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tohour2-field', dest='tohour2Field',default=24,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tomin2-field', dest='tomin2Field',default=60,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--curdir2-field', dest='curdir2Field',default=360,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--curspeed2-field', dest='curspeed2Field',default=Decimal('12.7'),metavar='udecimal',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--window3_longitude-field', dest='window3_longitudeField',default=Decimal('181'),metavar='decimal',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--window3_latitude-field', dest='window3_latitudeField',default=Decimal('91'),metavar='decimal',type='string'
		,help='Field parameter value [default: %default]')
	parser.add_option('--fromhour3-field', dest='fromhour3Field',default=24,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--frommin3-field', dest='frommin3Field',default=60,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tohour3-field', dest='tohour3Field',default=24,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--tomin3-field', dest='tomin3Field',default=60,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--curdir3-field', dest='curdir3Field',default=360,metavar='uint',type='int'
		,help='Field parameter value [default: %default]')
	parser.add_option('--curspeed3-field', dest='curspeed3Field',default=Decimal('12.7'),metavar='udecimal',type='string'
		,help='Field parameter value [default: %default]')

def main():
	from optparse import OptionParser
	parser = OptionParser(usage="%prog [options]",
		version="%prog "+__version__)

	parser.add_option('--doc-test',dest='doctest',default=False,action='store_true',
		help='run the documentation tests')
	parser.add_option('--unit-test',dest='unittest',default=False,action='store_true',
		help='run the unit tests')
	parser.add_option('-v','--verbose',dest='verbose',default=False,action='store_true',
		help='Make the test output verbose')

	# FIX: remove nmea from binary messages.  No way to build the whole packet?
	# FIX: or build the surrounding msg 8 for a broadcast?
	typeChoices = ('binary','nmeapayload','nmea') # FIX: what about a USCG type message?
	parser.add_option('-t','--type',choices=typeChoices,type='choice',dest='ioType'
		,default='nmeapayload'
		,help='What kind of string to write for encoding ('+', '.join(typeChoices)+') [default: %default]')


	outputChoices = ('std','html','csv','sql' , 'kml','kml-full')
	parser.add_option('-T','--output-type',choices=outputChoices,type='choice',dest='outputType'
		,default='std'
		,help='What kind of string to output ('+', '.join(outputChoices)+') [default: %default]')

	parser.add_option('-o','--output',dest='outputFileName',default=None,
			  help='Name of the python file to write [default: stdout]')

	parser.add_option('-f','--fields',dest='fieldList',default=None, action='append',
			  choices=fieldList,
			  help='Which fields to include in the output.  Currently only for csv output [default: all]')

	parser.add_option('-p','--print-csv-field-list',dest='printCsvfieldList',default=False,action='store_true',
			  help='Print the field name for csv')

	parser.add_option('-c','--sql-create',dest='sqlCreate',default=False,action='store_true',
			  help='Print out an sql create command for the table.')

	parser.add_option('--latex-table',dest='latexDefinitionTable',default=False,action='store_true',
			  help='Print a LaTeX table of the type')

	parser.add_option('--text-table',dest='textDefinitionTable',default=False,action='store_true',
			  help='Print delimited table of the type (for Word table importing)')
	parser.add_option('--delimt-text-table',dest='delimTextDefinitionTable',default='\t'
			  ,help='Delimiter for text table [default: \'%default\'](for Word table importing)')


	dbChoices = ('sqlite','postgres')
	parser.add_option('-D','--db-type',dest='dbType',default='postgres'
			  ,choices=dbChoices,type='choice'
			  ,help='What kind of database ('+', '.join(dbChoices)+') [default: %default]')

	addMsgOptions(parser)

	(options,args) = parser.parse_args()
	success=True

	if options.doctest:
		import os; print os.path.basename(sys.argv[0]), 'doctests ...',
		sys.argv= [sys.argv[0]]
		if options.verbose: sys.argv.append('-v')
		import doctest
		numfail,numtests=doctest.testmod()
		if numfail==0: print 'ok'
		else: 
			print 'FAILED'
			success=False

	if not success: sys.exit('Something Failed')
	del success # Hide success from epydoc

	if options.unittest:
		sys.argv = [sys.argv[0]]
		if options.verbose: sys.argv.append('-v')
		unittest.main()

	outfile = sys.stdout
	if None!=options.outputFileName:
		outfile = file(options.outputFileName,'w')


	if options.doEncode:
		# First make sure all non required options are specified
		if None==options.RepeatIndicatorField: parser.error("missing value for RepeatIndicatorField")
		if None==options.UserIDField: parser.error("missing value for UserIDField")
		if None==options.SeqNumField: parser.error("missing value for SeqNumField")
		if None==options.DestinationIDField: parser.error("missing value for DestinationIDField")
		if None==options.RetransmitFlagField: parser.error("missing value for RetransmitFlagField")
		if None==options.monthField: parser.error("missing value for monthField")
		if None==options.dayField: parser.error("missing value for dayField")
		if None==options.window1_longitudeField: parser.error("missing value for window1_longitudeField")
		if None==options.window1_latitudeField: parser.error("missing value for window1_latitudeField")
		if None==options.fromhour1Field: parser.error("missing value for fromhour1Field")
		if None==options.frommin1Field: parser.error("missing value for frommin1Field")
		if None==options.tohour1Field: parser.error("missing value for tohour1Field")
		if None==options.tomin1Field: parser.error("missing value for tomin1Field")
		if None==options.curdir1Field: parser.error("missing value for curdir1Field")
		if None==options.curspeed1Field: parser.error("missing value for curspeed1Field")
		if None==options.window2_longitudeField: parser.error("missing value for window2_longitudeField")
		if None==options.window2_latitudeField: parser.error("missing value for window2_latitudeField")
		if None==options.fromhour2Field: parser.error("missing value for fromhour2Field")
		if None==options.frommin2Field: parser.error("missing value for frommin2Field")
		if None==options.tohour2Field: parser.error("missing value for tohour2Field")
		if None==options.tomin2Field: parser.error("missing value for tomin2Field")
		if None==options.curdir2Field: parser.error("missing value for curdir2Field")
		if None==options.curspeed2Field: parser.error("missing value for curspeed2Field")
		if None==options.window3_longitudeField: parser.error("missing value for window3_longitudeField")
		if None==options.window3_latitudeField: parser.error("missing value for window3_latitudeField")
		if None==options.fromhour3Field: parser.error("missing value for fromhour3Field")
		if None==options.frommin3Field: parser.error("missing value for frommin3Field")
		if None==options.tohour3Field: parser.error("missing value for tohour3Field")
		if None==options.tomin3Field: parser.error("missing value for tomin3Field")
		if None==options.curdir3Field: parser.error("missing value for curdir3Field")
		if None==options.curspeed3Field: parser.error("missing value for curspeed3Field")
		msgDict={
			'MessageID': '6',
			'RepeatIndicator': options.RepeatIndicatorField,
			'UserID': options.UserIDField,
			'SeqNum': options.SeqNumField,
			'DestinationID': options.DestinationIDField,
			'RetransmitFlag': options.RetransmitFlagField,
			'Spare': '0',
			'dac': '1',
			'fid': '11',
			'month': options.monthField,
			'day': options.dayField,
			'window1_longitude': options.window1_longitudeField,
			'window1_latitude': options.window1_latitudeField,
			'fromhour1': options.fromhour1Field,
			'frommin1': options.frommin1Field,
			'tohour1': options.tohour1Field,
			'tomin1': options.tomin1Field,
			'curdir1': options.curdir1Field,
			'curspeed1': options.curspeed1Field,
			'window2_longitude': options.window2_longitudeField,
			'window2_latitude': options.window2_latitudeField,
			'fromhour2': options.fromhour2Field,
			'frommin2': options.frommin2Field,
			'tohour2': options.tohour2Field,
			'tomin2': options.tomin2Field,
			'curdir2': options.curdir2Field,
			'curspeed2': options.curspeed2Field,
			'window3_longitude': options.window3_longitudeField,
			'window3_latitude': options.window3_latitudeField,
			'fromhour3': options.fromhour3Field,
			'frommin3': options.frommin3Field,
			'tohour3': options.tohour3Field,
			'tomin3': options.tomin3Field,
			'curdir3': options.curdir3Field,
			'curspeed3': options.curspeed3Field,
		}

		bits = encode(msgDict)
		if 'binary'==options.ioType: print str(bits)
		elif 'nmeapayload'==options.ioType:
		    # FIX: figure out if this might be necessary at compile time
		    #print "bitLen",len(bits)
		    bitLen=len(bits)
		    if bitLen%6!=0:
			bits = bits + BitVector(size=(6 - (bitLen%6)))  # Pad out to multiple of 6
		    #print "result:",binary.bitvectoais6(bits)[0]
		    print binary.bitvectoais6(bits)[0]


		# FIX: Do not emit this option for the binary message payloads.  Does not make sense.
		elif 'nmea'==options.ioType: 
		    #bitLen=len(bits)
                    #if bitLen%6!=0:
		    #	bits = bits + BitVector(size=(6 - (bitLen%6)))  # Pad out to multiple of 6
                    import aisutils.uscg as uscg
                    nmea = uscg.create_nmea(bits)
                    print nmea
                    #
                    #


                    #sys.exit("FIX: need to implement creating nmea capability")
		else: sys.exit('ERROR: unknown ioType.  Help!')


	if options.sqlCreate:
		sqlCreateStr(outfile,options.fieldList,dbType=options.dbType)

	if options.latexDefinitionTable:
		latexDefinitionTable(outfile)

	# For conversion to word tables
	if options.textDefinitionTable:
		textDefinitionTable(outfile,options.delimTextDefinitionTable)

	if options.printCsvfieldList:
		# Make a csv separated list of fields that will be displayed for csv
		if None == options.fieldList: options.fieldList = fieldList
		import StringIO
		buf = StringIO.StringIO()
		for field in options.fieldList:
			buf.write(field+',')
		result = buf.getvalue()
		if result[-1] == ',': print result[:-1]
		else: print result

	if options.doDecode:
		if len(args)==0: args = sys.stdin
		for msg in args:
			bv = None

			if msg[0] in ('$','!') and msg[3:6] in ('VDM','VDO'):
				# Found nmea
				# FIX: do checksum
				bv = binary.ais6tobitvec(msg.split(',')[5])
			else: # either binary or nmeapayload... expect mostly nmeapayloads
				# assumes that an all 0 and 1 string can not be a nmeapayload
				binaryMsg=True
				for c in msg:
					if c not in ('0','1'):
						binaryMsg=False
						break
				if binaryMsg:
					bv = BitVector(bitstring=msg)
				else: # nmeapayload
					bv = binary.ais6tobitvec(msg)

			printFields(decode(bv)
				    ,out=outfile
				    ,format=options.outputType
				    ,fieldList=options.fieldList
				    ,dbType=options.dbType
				    )

############################################################
if __name__=='__main__':
    main()
