# -*- coding: utf-8 -*-
##----------------------------------------------------------------------
## System classification rules
## System event classes are generated by NOC itself
##----------------------------------------------------------------------
## Copyright (C) 2007-2009 The NOC Project
## See LICENSE for details
##----------------------------------------------------------------------
"""
"""
from noc.fm.rules.classification import ClassificationRule
from noc.fm.rules.classes.system import *

##
## Match Unhandled System Exception
##
class UnhandledExceptionRule(ClassificationRule):
    name="Unhandled System Exception"
    event_class=UnhandledException
    patterns=[
        (r"^source$",  r"^system$"),
        (r"^type$",    r"^Unhandled Exception$"),
    ]

##
## Match Invalid Event Source
##
class InvalidEventSourceRule(ClassificationRule):
    name="Invalid Event Source"
    event_class=InvalidEventSource
    patterns=[
        (r"^source$",  r"^system$"),
        (r"^type$",    r"^Invalid Event Source$"),
    ]

##
## Match Periodic Task Failed
##
class PeriodicTaskFailedRule(ClassificationRule):
    name="Periodic Task Failed"
    event_class=PeriodicTaskFailed
    patterns=[
        (r"^source$",  r"^system$"),
        (r"^type$",    r"^Periodic Task Failed$"),
    ]
##
## Match Object unreachable event
##
class ObjectUnreachableRule(ClassificationRule):
    name="Object Unreachable Rule"
    event_class=ObjectUnreachable
    patterns=[
        (r"^source$",  r"^system$"),
        (r"^result$",  r"^failed$"),
        (r"^probe$",   r"^ping$")
    ]
##
## Match Object reachable event
##
class ObjectReachableRule(ClassificationRule):
    name="Object Reachable Rule"
    event_class=ObjectReachable
    patterns=[
        (r"^source$",  r"^system$"),
        (r"^result$",  r"^success$"),
        (r"^probe$",   r"^ping$")
    ]
