# -*- coding: utf-8 -*-
##----------------------------------------------------------------------
## IGetLLDPNeighbors
##----------------------------------------------------------------------
## Copyright (C) 2007-2009 The NOC Project
## See LICENSE for details
##----------------------------------------------------------------------
"""
"""
from base import *

##
## LLDP neighbor information
##
## Rules:
## local_inteface must be filled with interface name (will be cleaned automatically)
##
## local_interface_id depens upon how the box advertises own interfaces:
##
## If interfaces advertised with macAddress(3) LldpPortIdSubtype,
## local_interface_id must be set to interface MAC address
## (will be cleaned automatically)
##
## If interface advertised with networkAddress(4) LldpPortIdSubtype,
## local_interface_id must be set to interface IP address
##
## If interfaces advertised with interfaceName(5) LldpPortIdSubtype,
## local_interface_id must be left empty or ommited.
##
## If interfaces advertised with local(7) LldpPortIdSubtype,
## local_interface_id must be set to local identifier
##
## Remote port handling solely depends upon remote_port_subtype:
##
## For macAddress(3) - convert to common normalized form
##
## For networkAddress(4) - return as IP address
##
## For interfaceName(5) - return untouched
##
## For local(7) - convert to integer and return untouched
##
class IGetLLDPNeighbors(Interface):
    returns=ListOfParameter(element=DictParameter(attrs={
        "local_interface"    : InterfaceNameParameter(),
        "local_interface_id" : IntParameter(required=False)|MACAddressParameter(required=False)|IPParameter(required=False), # Should be set when platform advertises not LldpPortIdSubtype==5
        "neighbors"       : ListOfParameter(element=DictParameter(attrs={
            "remote_chassis_id_subtype" : IntParameter(default=4), # LldpChassisIdSubtype TC, macAddress(4)
            "remote_chassis_id"         : MACAddressParameter() | IPParameter() , # Remote chassis ID
            "remote_port_subtype"       : IntParameter(default=5), # LldpPortIdSubtype TC, interfaceName(5)
            "remote_port"               : StringParameter(),
            "remote_system_name"        : StringParameter(required=False),
            "remote_capabilities"       : IntParameter(default=0), # LldpSystemCapabilitiesMap TC bitmask
        }))
    }))
