# -*- coding: utf-8 -*-
##----------------------------------------------------------------------
## DLink.DxS_Cisco_CLI.get_mac_address_table
##----------------------------------------------------------------------
## Copyright (C) 2007-2011 The NOC Project
## See LICENSE for details
##----------------------------------------------------------------------
"""
"""
from noc.sa.script import Script as NOCScript
from noc.sa.interfaces import IGetMACAddressTable
import re

class Script(NOCScript):
    name="DLink.DxS_Cisco_CLI.get_mac_address_table"
    implements=[IGetMACAddressTable]
    rx_line=re.compile(r"^\s*(?P<vlan_id>\d+)\s+(?P<mac>\S+)\s+(?P<type>\S+)\s+(?P<interfaces>\S+\s*\d+\/\d+)$",re.MULTILINE)
    def execute(self,interface=None,vlan=None,mac=None):
        cmd="show mac-address-table"
        if mac is not None:
            cmd+=" address %s"%self.profile.convert_mac(mac)
        if interface is not None:
            cmd+=" interface %s"%interface
        if vlan is not None:
            cmd+=" vlan %s"%vlan
        try:
            macs=self.cli(cmd)
        except self.CLISyntaxError:
            # Not supported at all
            raise self.NotSupportedError()
        r=[]
        for match in self.rx_line.finditer(macs):
            r+=[{
                "vlan_id"   : match.group("vlan_id"),
                "mac"       : match.group("mac"),
                "interfaces": [match.group("interfaces")],
                "type"      : {"dynamic":"D","static":"S"}[match.group("type").lower()],
            }]
        return r
