# -*- coding: utf-8 -*-
##----------------------------------------------------------------------
## Ericsson.SEOS.get_config
##----------------------------------------------------------------------
## Copyright (C) 2007-2011 The NOC Project
## See LICENSE for details
##----------------------------------------------------------------------

## NOC modules
from noc.sa.script import Script as NOCScript
from noc.sa.interfaces import IGetConfig


class Script(NOCScript):
    name = "Ericsson.SEOS.get_config"
    implements = [IGetConfig]

    def execute(self):
        config = self.cli("show config")
        config = self.strip_first_lines(config, 3)
        return self.cleaned_config(config)
