# -*- coding: utf-8 -*-
##----------------------------------------------------------------------
## H3C.VRP.get_chassis_id test
## Auto-generated by manage.py debug-script at 2011-03-11 09:09:57
##----------------------------------------------------------------------
## Copyright (C) 2007-2011 The NOC Project
## See LICENSE for details
##----------------------------------------------------------------------
from noc.lib.test import ScriptTestCase
class H3C_VRP_get_chassis_id_Test(ScriptTestCase):
    script="H3C.VRP.get_chassis_id"
    vendor="H3C"
    platform='4200G'
    version='3.01.00s56'
    input={}
    result='00:18:6E:3E:71:00'
    motd='\n'
    cli={
## 'display version'
'display version': """
%Dec  9 17:00:04:024 2000 4200G SHELL/5/LOGIN:- 1 - admin(172.20.0.181) in unit1 logindisplay version
3Com Corporation
Switch 4200G 48-Port Software Version 3Com OS V3.01.00s56
Copyright(c) 2004-2006 3Com Corporation and its licensors, All rights reserved.
Switch 4200G 48-Port uptime is 35 weeks, 6 days, 17 hours, 5 minutes

Switch 4200G 48-Port with 1 MIPS Processor
64M   bytes DRAM
16M   bytes Flash Memory
Config Register points to FLASH

Hardware Version is REV.B
CPLD Version is 002
Bootrom Version is 1.00
[SubSlot 0] 48 GE ( 4 COMBO ) Hardware Version is REV.B
[SubSlot 1] 1  XGE Hardware Version is REV.B
""",
## 'display stp'
'display stp': """display stp
-------[CIST Global Info][Mode MSTP]-------
CIST Bridge         :32768.0018-6e3e-7100
Bridge Times        :Hello 2s MaxAge 20s FwDly 15s MaxHop 20
CIST Root/ERPC      :32768.0018-6e3e-7100 / 0
CIST RegRoot/IRPC   :32768.0018-6e3e-7100 / 0
CIST RootPortId     :0.0
BPDU-Protection     :disabled
TC-Protection       :enabled / Threshold=6
Bridge Config
Digest Snooping     :disabled
TC or TCN received  :2536153
Time since last TC  :0 days 0h:50m:18s

----[Port1(GigabitEthernet1/0/1)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.1
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :13908
          TCN: 0, Config: 0, RST: 0, MST: 13908
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port2(GigabitEthernet1/0/2)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.2
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
                                           BPDU Sent           :11868
          TCN: 0, Config: 0, RST: 0, MST: 11868
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port3(GigabitEthernet1/0/3)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.3
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                          
----[Port4(GigabitEthernet1/0/4)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.4
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :14352
          TCN: 0, Config: 0, RST: 0, MST: 14352
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port5(GigabitEthernet1/0/5)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
                                           Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.5
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :12618957
          TCN: 0, Config: 0, RST: 0, MST: 12618957
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port6(GigabitEthernet1/0/6)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.6
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :12618957
          TCN: 0, Config: 0, RST: 0, MST: 12618957
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port7(GigabitEthernet1/0/7)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.7
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :382353
          TCN: 0, Config: 0, RST: 0, MST: 382353
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port8(GigabitEthernet1/0/8)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.8
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
                                           BPDU Sent           :2221686
          TCN: 0, Config: 0, RST: 0, MST: 2221686
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port9(GigabitEthernet1/0/9)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.9
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :699691
          TCN: 0, Config: 0, RST: 0, MST: 699691
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                          
----[Port10(GigabitEthernet1/0/10)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.10
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :915819
          TCN: 0, Config: 0, RST: 0, MST: 915819
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port11(GigabitEthernet1/0/11)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
                                           Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.11
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :3 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1922736
          TCN: 0, Config: 0, RST: 0, MST: 1922736
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port12(GigabitEthernet1/0/12)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.12
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :381130
          TCN: 0, Config: 0, RST: 0, MST: 381130
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port13(GigabitEthernet1/0/13)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.13
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :915820
          TCN: 0, Config: 0, RST: 0, MST: 915820
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port14(GigabitEthernet1/0/14)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.14
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
                                           BPDU Sent           :43
          TCN: 0, Config: 0, RST: 0, MST: 43
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port15(GigabitEthernet1/0/15)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.15
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :627691
          TCN: 0, Config: 0, RST: 0, MST: 627691
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                          
----[Port16(GigabitEthernet1/0/16)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.16
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1712
          TCN: 0, Config: 0, RST: 0, MST: 1712
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port17(GigabitEthernet1/0/17)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
                                           Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.17
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1766037
          TCN: 0, Config: 0, RST: 0, MST: 1766037
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port18(GigabitEthernet1/0/18)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.18
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :7366646
          TCN: 0, Config: 0, RST: 0, MST: 7366646
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port19(GigabitEthernet1/0/19)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.19
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :357905
          TCN: 0, Config: 0, RST: 0, MST: 357905
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port20(GigabitEthernet1/0/20)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.20
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
                                           BPDU Sent           :3914793
          TCN: 0, Config: 0, RST: 0, MST: 3914793
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port21(GigabitEthernet1/0/21)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.21
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :10805
          TCN: 0, Config: 0, RST: 0, MST: 10805
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                          
----[Port22(GigabitEthernet1/0/22)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.22
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :624742
          TCN: 0, Config: 0, RST: 0, MST: 624742
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port23(GigabitEthernet1/0/49)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
                                           Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.23
 Port Edged          :Config=enabled / Active=disabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :0 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :6
          TCN: 0, Config: 0, RST: 0, MST: 6
 BPDU Received       :132
          TCN: 0, Config: 0, RST: 0, MST: 132

----[Port24(GigabitEthernet1/0/50)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.24
 Port Edged          :Config=enabled / Active=disabled  
                                           Point-to-point      :Config=auto / Active=false
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :0 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1
          TCN: 0, Config: 0, RST: 0, MST: 1
 BPDU Received       :100
          TCN: 0, Config: 0, RST: 0, MST: 100

----[Port25(GigabitEthernet1/0/25)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.25
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :13577
          TCN: 0, Config: 0, RST: 0, MST: 13577
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port26(GigabitEthernet1/0/26)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.26
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
                                           BPDU Sent           :13292
          TCN: 0, Config: 0, RST: 0, MST: 13292
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port27(GigabitEthernet1/0/27)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.27
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :749328
          TCN: 0, Config: 0, RST: 0, MST: 749328
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                          
----[Port28(GigabitEthernet1/0/28)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.28
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :13012
          TCN: 0, Config: 0, RST: 0, MST: 13012
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port29(GigabitEthernet1/0/29)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
                                           Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.29
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :627691
          TCN: 0, Config: 0, RST: 0, MST: 627691
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port30(GigabitEthernet1/0/30)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.30
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :12165
          TCN: 0, Config: 0, RST: 0, MST: 12165
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port31(GigabitEthernet1/0/31)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.31
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :732839
          TCN: 0, Config: 0, RST: 0, MST: 732839
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port32(GigabitEthernet1/0/32)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.32
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
                                           BPDU Sent           :12618954
          TCN: 0, Config: 0, RST: 0, MST: 12618954
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port33(GigabitEthernet1/0/33)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.33
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :25
          TCN: 0, Config: 0, RST: 0, MST: 25
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                          
----[Port34(GigabitEthernet1/0/34)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.34
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1712
          TCN: 0, Config: 0, RST: 0, MST: 1712
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port35(GigabitEthernet1/0/35)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
                                           Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.35
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :381078
          TCN: 0, Config: 0, RST: 0, MST: 381078
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port36(GigabitEthernet1/0/36)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.36
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :2515362
          TCN: 0, Config: 0, RST: 0, MST: 2515362
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port37(GigabitEthernet1/0/37)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.37
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :12438
          TCN: 0, Config: 0, RST: 0, MST: 12438
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port38(GigabitEthernet1/0/38)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.38
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
                                           BPDU Sent           :699691
          TCN: 0, Config: 0, RST: 0, MST: 699691
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port39(GigabitEthernet1/0/39)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.39
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :749331
          TCN: 0, Config: 0, RST: 0, MST: 749331
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                          
----[Port40(GigabitEthernet1/0/40)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.40
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :7480682
          TCN: 0, Config: 0, RST: 0, MST: 7480682
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port41(GigabitEthernet1/0/41)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
                                           Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.41
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1894746
          TCN: 0, Config: 0, RST: 0, MST: 1894746
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port42(GigabitEthernet1/0/42)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.42
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :2496157
          TCN: 0, Config: 0, RST: 0, MST: 2496157
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port43(GigabitEthernet1/0/43)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.43
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1840208
          TCN: 0, Config: 0, RST: 0, MST: 1840208
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port44(GigabitEthernet1/0/44)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.44
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
                                           BPDU Sent           :586275
          TCN: 0, Config: 0, RST: 0, MST: 586275
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port45(GigabitEthernet1/0/45)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.45
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1206693
          TCN: 0, Config: 0, RST: 0, MST: 1206693
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                          
----[Port46(GigabitEthernet1/0/46)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=20000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.46
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1195825
          TCN: 0, Config: 0, RST: 0, MST: 1195825
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port47(GigabitEthernet1/0/51)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
                                           Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.47
 Port Edged          :Config=enabled / Active=disabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :0 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :1
          TCN: 0, Config: 0, RST: 0, MST: 1
 BPDU Received       :104
          TCN: 0, Config: 0, RST: 0, MST: 104

----[Port48(GigabitEthernet1/0/52)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=200000000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.48
 Port Edged          :Config=enabled / Active=disabled  
                                           Point-to-point      :Config=auto / Active=false
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :0 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :6
          TCN: 0, Config: 0, RST: 0, MST: 6
 BPDU Received       :4
          TCN: 0, Config: 0, RST: 0, MST: 4

----[Port49(TenGigabitEthernet1/1/1)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Dot1T)    :Config=auto / Active=2000
 Desg. Bridge/Port   :32768.0018-6e3e-7100 / 128.49
 Port Edged          :Config=disabled / Active=disabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit       :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :3 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :11842940
          TCN: 420463, Config: 11421538, RST: 0, MST: 939
 BPDU Received       :15717463
          TCN: 1, Config: 15496734, RST: 14, MST: 220714""",
}
    snmp_get={}
    snmp_getnext={}
