//---------------------------------------------------------------------
// main.shard application
//---------------------------------------------------------------------
// Copyright (C) 2007-2011 The NOC Project
// See LICENSE for details
//---------------------------------------------------------------------
console.debug("Defining NOC.main.shard.Application");

Ext.define("NOC.main.shard.Application", {
    extend: "NOC.core.ModelApplication",
    uses: ["NOC.main.shard.Model"],
    model: "NOC.main.shard.Model",
    columns: [
        {
            text: "Name",
            dataIndex: "name"
        },
        {
            text: "Active",
            dataIndex: "is_active",
            width: 50,
            renderer: noc_renderBool
        },
        {
            text: "Description",
            dataIndex: "description",
            flex: true
        }
    ],
    fields: [
        {
            name: "name",
            xtype: "textfield",
            fieldLabel: "Name",
            allowBlank: false
        },
        {
            name: "is_active",
            xtype: "checkboxfield",
            boxLabel: "Is Active"
        },
        {
            name: "description",
            xtype: "textfield",
            fieldLabel: "Description",
            allowBlank: true
        }
    ]
});
