# -*- coding: utf-8 -*-
##----------------------------------------------------------------------
## H3C.VRP.get_chassis_id test
## Auto-generated by manage.py debug-script at 2011-03-11 09:23:09
##----------------------------------------------------------------------
## Copyright (C) 2007-2011 The NOC Project
## See LICENSE for details
##----------------------------------------------------------------------
from noc.lib.test import ScriptTestCase
class H3C_VRP_get_chassis_id_Test(ScriptTestCase):
    script="H3C.VRP.get_chassis_id"
    vendor="H3C"
    platform='4500'
    version='3.03.02s56p05'
    input={}
    result='00:24:73:80:30:40'
    motd='\n'
    cli={
## 'display version'
'display version': """
%Mar 11 09:23:02:061 2011 4500 SHELL/5/LOGIN:- 1 - admin(172.20.0.181) in unit1 logindisplay version
3Com Corporation
Switch 4500 50-Port Software Version 3Com OS V3.03.02s56p05
Copyright (c) 2004-2009 3Com Corporation and its licensors, All rights reserved.
Switch 4500 50-Port uptime is 14 weeks, 2 days, 11 hours, 56 minutes

Switch 4500 50-Port with 1 Processor
64M     bytes DRAM
8196K   bytes Flash Memory
Config Register points to FLASH

CPLD Version is CPLD 001
Bootrom Version is 4.02
[Subslot 0] 48 FE + 4 GE Hardware Version is 00.00.00 
""",
## 'display stp'
'display stp': """display stp
-------[CIST Global Info][Mode MSTP]-------
CIST Bridge         :32768.0024-7380-3040
Bridge Times        :Hello 2s MaxAge 20s FwDly 15s MaxHop 20
CIST Root/ERPC      :0.001e-c1ec-0800 / 20
CIST RegRoot/IRPC   :32768.0024-7380-3040 / 0
CIST RootPortId     :128.50
BPDU-Protection     :disabled
TC-Protection       :enabled / Threshold=6
Bridge Config
Digest Snooping     :disabled
TC or TCN received  :25
Time since last TC  :43 days 23h:3m:13s

----[Port1(Ethernet1/0/1)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.1
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
                                           Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2788
          TCN: 0, Config: 0, RST: 0, MST: 2788
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port2(Ethernet1/0/2)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.2
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
                                           Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :4320771
          TCN: 0, Config: 0, RST: 0, MST: 4320771
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port3(Ethernet1/0/3)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.3
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                           BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port4(Ethernet1/0/4)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.4
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :3497
          TCN: 0, Config: 0, RST: 0, MST: 3497
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

                                          ----[Port5(Ethernet1/0/5)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.5
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2426
          TCN: 0, Config: 0, RST: 0, MST: 2426
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port6(Ethernet1/0/6)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
                                           Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.6
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2583
          TCN: 0, Config: 0, RST: 0, MST: 2583
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port7(Ethernet1/0/7)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.7
                                           Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :3293
          TCN: 0, Config: 0, RST: 0, MST: 3293
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port8(Ethernet1/0/8)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.8
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
                                           Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :428854
          TCN: 0, Config: 0, RST: 0, MST: 428854
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port9(Ethernet1/0/9)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.9
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
                                           Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port10(Ethernet1/0/10)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.10
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
                                           BPDU Sent           :1781
          TCN: 0, Config: 0, RST: 0, MST: 1781
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port11(Ethernet1/0/11)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.11
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :3287
          TCN: 0, Config: 0, RST: 0, MST: 3287
 BPDU Received       :0
                                                    TCN: 0, Config: 0, RST: 0, MST: 0

----[Port12(Ethernet1/0/12)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.12
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :3125
          TCN: 0, Config: 0, RST: 0, MST: 3125
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port13(Ethernet1/0/13)][FORWARDING]----
                                           Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=2000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.13
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :4320770
          TCN: 0, Config: 0, RST: 0, MST: 4320770
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port14(Ethernet1/0/14)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
                                           Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.14
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :30084
          TCN: 0, Config: 0, RST: 0, MST: 30084
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port15(Ethernet1/0/15)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.15
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :3287
          TCN: 0, Config: 0, RST: 0, MST: 3287
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port16(Ethernet1/0/16)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.16
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
                                           MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2957
          TCN: 0, Config: 0, RST: 0, MST: 2957
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port17(Ethernet1/0/17)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.17
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
                                           Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :699
          TCN: 0, Config: 0, RST: 0, MST: 699
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port18(Ethernet1/0/18)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.18
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
                                           BPDU Sent           :3229
          TCN: 0, Config: 0, RST: 0, MST: 3229
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port19(Ethernet1/0/19)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.19
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2247
          TCN: 0, Config: 0, RST: 0, MST: 2247
 BPDU Received       :0
                                                    TCN: 0, Config: 0, RST: 0, MST: 0

----[Port20(Ethernet1/0/20)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.20
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :776034
          TCN: 0, Config: 0, RST: 0, MST: 776034
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port21(Ethernet1/0/21)][FORWARDING]----
                                           Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=2000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.21
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :4320770
          TCN: 0, Config: 0, RST: 0, MST: 4320770
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port22(Ethernet1/0/22)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
                                           Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.22
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :12067
          TCN: 0, Config: 0, RST: 0, MST: 12067
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port23(Ethernet1/0/23)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.23
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :1558
          TCN: 0, Config: 0, RST: 0, MST: 1558
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port24(Ethernet1/0/24)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.24
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
                                           MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :635104
          TCN: 0, Config: 0, RST: 0, MST: 635104
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port25(Ethernet1/0/25)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.25
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
                                           Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port26(Ethernet1/0/26)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.26
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
                                           BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port27(Ethernet1/0/27)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.27
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port28(Ethernet1/0/28)][DOWN]----
                                           Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.28
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port29(Ethernet1/0/29)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
                                           Desg. Bridge/Port   :32768.0024-7380-3040 / 128.29
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2527
          TCN: 0, Config: 0, RST: 0, MST: 2527
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port30(Ethernet1/0/30)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.30
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
                                           Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :48595
          TCN: 0, Config: 0, RST: 0, MST: 48595
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port31(Ethernet1/0/31)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.31
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
                                           Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port32(Ethernet1/0/32)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.32
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
                                           PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2449
          TCN: 0, Config: 0, RST: 0, MST: 2449
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port33(Ethernet1/0/33)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.33
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :511
          TCN: 0, Config: 0, RST: 0, MST: 511
                                           BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port34(Ethernet1/0/34)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.34
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2689
          TCN: 0, Config: 0, RST: 0, MST: 2689
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

                                          ----[Port35(Ethernet1/0/35)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.35
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :13447
          TCN: 0, Config: 0, RST: 0, MST: 13447
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port36(Ethernet1/0/36)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
                                           Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.36
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :3159
          TCN: 0, Config: 0, RST: 0, MST: 3159
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port37(Ethernet1/0/37)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.37
                                           Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2478
          TCN: 0, Config: 0, RST: 0, MST: 2478
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port38(Ethernet1/0/38)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.38
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
                                           Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port39(Ethernet1/0/39)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.39
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
                                           Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2411
          TCN: 0, Config: 0, RST: 0, MST: 2411
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port40(Ethernet1/0/40)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.40
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
                                           BPDU Sent           :2431
          TCN: 0, Config: 0, RST: 0, MST: 2431
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port41(Ethernet1/0/41)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.41
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2437
          TCN: 0, Config: 0, RST: 0, MST: 2437
 BPDU Received       :0
                                                    TCN: 0, Config: 0, RST: 0, MST: 0

----[Port42(Ethernet1/0/42)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.42
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2595
          TCN: 0, Config: 0, RST: 0, MST: 2595
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port43(Ethernet1/0/43)][FORWARDING]----
                                           Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.43
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :900
          TCN: 0, Config: 0, RST: 0, MST: 900
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port44(Ethernet1/0/44)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
                                           Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.44
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2517
          TCN: 0, Config: 0, RST: 0, MST: 2517
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port45(Ethernet1/0/45)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.45
 Port Edged          :Config=enabled / Active=enabled  
                                           Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2462
          TCN: 0, Config: 0, RST: 0, MST: 2462
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port46(Ethernet1/0/46)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.46
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
                                           MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :2904
          TCN: 0, Config: 0, RST: 0, MST: 2904
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port47(Ethernet1/0/47)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Designated Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.47
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
                                           Rapid Fwd State     :Rapid Forwarding 
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 1s RemHop 20
 BPDU Sent           :3342
          TCN: 0, Config: 0, RST: 0, MST: 3342
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port48(Ethernet1/0/48)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.48
 Port Edged          :Config=enabled / Active=enabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
                                                    TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

----[Port49(GigabitEthernet1/0/51)][DOWN]----
 Port Protocol       :enabled
 Port Role           :CIST Disabled Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=200000
 Desg. Bridge/Port   :32768.0024-7380-3040 / 128.49
 Port Edged          :Config=disabled / Active=disabled  
 Point-to-point      :Config=auto / Active=false
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :0
          TCN: 0, Config: 0, RST: 0, MST: 0
 BPDU Received       :0
          TCN: 0, Config: 0, RST: 0, MST: 0

                                          ----[Port50(GigabitEthernet1/0/52)][FORWARDING]----
 Port Protocol       :enabled
 Port Role           :CIST Root Port
 Port Priority       :128
 Port Cost(Legacy)   :Config=auto / Active=20
 Desg. Bridge/Port   :0.001e-c1ec-0800 / 128.76
 Port Edged          :Config=disabled / Active=disabled  
 Point-to-point      :Config=auto / Active=true
 Transmit Limit      :10 packets/hello-time
 Protection Type     :None
 MSTP BPDU format    :Config=auto / Active=legacy
 Port Config
 Digest Snooping     :disabled
 Num of Vlans Mapped :1 
 PortTimes           :Hello 2s MaxAge 20s FwDly 15s MsgAge 0s RemHop 20
 BPDU Sent           :5
          TCN: 0, Config: 0, RST: 0, MST: 5
 BPDU Received       :4339658
          TCN: 0, Config: 0, RST: 0, MST: 4339658""",
}
    snmp_get={}
    snmp_getnext={}
