/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2013 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
 * almond 0.2.6 Copyright (c) 2011-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @fileOverview
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
  @license
  fontmetrics.js - https://github.com/Pomax/fontmetrics.js

  Copyright (C) 2011 by Mike "Pomax" Kamermans

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
**/

/**
@license
topojson - https://github.com/mbostock/topojson

Copyright (c) 2012, Michael Bostock
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* The name Michael Bostock may not be used to endorse or promote products
  derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
 * @license
 * Cellular noise ("Worley noise") in 2D in GLSL.
 * Copyright (c) Stefan Gustavson 2011-04-19. All rights reserved.
 * This code is released under the conditions of the MIT license.
 * See LICENSE file for details.
 */

/**
 * @license
 * Description : Array and textureless GLSL 2D/3D/4D simplex 
 *               noise functions.
 *      Author : Ian McEwan, Ashima Arts.
 *  Maintainer : ijm
 *     Lastmod : 20110822 (ijm)
 *     License : Copyright (C) 2011 Ashima Arts. All rights reserved.
 *               Distributed under the MIT License. See LICENSE file.
 *               https://github.com/ashima/webgl-noise
 */

/**
@license
tween.js - https://github.com/sole/tween.js

Copyright (c) 2010-2012 Tween.js authors.

Easing equations Copyright (c) 2001 Robert Penner http://robertpenner.com/easing/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/**
 * @license
 * Copyright (c) 2000-2005, Sean O'Neil (s_p_oneil@hotmail.com)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * * Neither the name of the project nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Modifications made by Analytical Graphics, Inc.
 */

/**
@license
Knockout JavaScript library v3.0.0
(c) Steven Sanderson - http://knockoutjs.com/
License: MIT (http://www.opensource.org/licenses/mit-license.php)
*/

/**
 * @license
 * WeakMap shim
 * (The MIT License)
 *
 * Copyright (c) 2012 Brandon Benvie <http://bbenvie.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the 'Software'), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included with all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY  CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @license
 * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5
 * Copyright (c) Steve Sanderson
 * MIT license
 */

!function(){var e,t,r;!function(i){function n(e,t){return w.call(e,t)}function o(e,t){var r,i,n,o,a,s,l,u,c,h,d=t&&t.split("/"),m=g.map,p=m&&m["*"]||{};if(e&&"."===e.charAt(0))if(t){for(d=d.slice(0,d.length-1),e=d.concat(e.split("/")),u=0;u<e.length;u+=1)if(h=e[u],"."===h)e.splice(u,1),u-=1;else if(".."===h){if(1===u&&(".."===e[2]||".."===e[0]))break;u>0&&(e.splice(u-1,2),u-=2)}e=e.join("/")}else 0===e.indexOf("./")&&(e=e.substring(2));if((d||p)&&m){for(r=e.split("/"),u=r.length;u>0;u-=1){if(i=r.slice(0,u).join("/"),d)for(c=d.length;c>0;c-=1)if(n=m[d.slice(0,c).join("/")],n&&(n=n[i])){o=n,a=u;break}if(o)break;!s&&p&&p[i]&&(s=p[i],l=u)}!o&&s&&(o=s,a=l),o&&(r.splice(0,a,o),e=r.join("/"))}return e}function a(e,t){return function(){return m.apply(i,C.call(arguments,0).concat([e,t]))}}function s(e){return function(t){return o(t,e)}}function l(e){return function(t){v[e]=t}}function u(e){if(n(y,e)){var t=y[e];delete y[e],_[e]=!0,d.apply(i,t)}if(!n(v,e)&&!n(_,e))throw new Error("No "+e);return v[e]}function c(e){var t,r=e?e.indexOf("!"):-1;return r>-1&&(t=e.substring(0,r),e=e.substring(r+1,e.length)),[t,e]}function h(e){return function(){return g&&g.config&&g.config[e]||{}}}var d,m,p,f,v={},y={},g={},_={},w=Object.prototype.hasOwnProperty,C=[].slice;p=function(e,t){var r,i=c(e),n=i[0];return e=i[1],n&&(n=o(n,t),r=u(n)),n?e=r&&r.normalize?r.normalize(e,s(t)):o(e,t):(e=o(e,t),i=c(e),n=i[0],e=i[1],n&&(r=u(n))),{f:n?n+"!"+e:e,n:e,pr:n,p:r}},f={require:function(e){return a(e)},exports:function(e){var t=v[e];return"undefined"!=typeof t?t:v[e]={}},module:function(e){return{id:e,uri:"",exports:v[e],config:h(e)}}},d=function(e,t,r,o){var s,c,h,d,m,g,w=[];if(o=o||e,"function"==typeof r){for(t=!t.length&&r.length?["require","exports","module"]:t,m=0;m<t.length;m+=1)if(d=p(t[m],o),c=d.f,"require"===c)w[m]=f.require(e);else if("exports"===c)w[m]=f.exports(e),g=!0;else if("module"===c)s=w[m]=f.module(e);else if(n(v,c)||n(y,c)||n(_,c))w[m]=u(c);else{if(!d.p)throw new Error(e+" missing "+c);d.p.load(d.n,a(o,!0),l(c),{}),w[m]=v[c]}h=r.apply(v[e],w),e&&(s&&s.exports!==i&&s.exports!==v[e]?v[e]=s.exports:h===i&&g||(v[e]=h))}else e&&(v[e]=r)},e=t=m=function(e,t,r,n,o){return"string"==typeof e?f[e]?f[e](t):u(p(e,t).f):(e.splice||(g=e,t.splice?(e=t,t=r,r=null):e=i),t=t||function(){},"function"==typeof r&&(r=n,n=o),n?d(i,e,t,r):setTimeout(function(){d(i,e,t,r)},4),m)},m.config=function(e){return g=e,g.deps&&m(g.deps,g.callback),m},e._defined=v,r=function(e,t,r){t.splice||(r=t,t=[]),n(v,e)||n(y,e)||(y[e]=[e,t,r])},r.amd={jQuery:!0}}(),r("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),r("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),r("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),r("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),r("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i){"use strict";var n=function(t,r,i){this.x=e(t,0),this.y=e(r,0),this.z=e(i,0)};n.fromSpherical=function(r,i){t(i)||(i=new n);var o=r.clock,a=r.cone,s=e(r.magnitude,1),l=s*Math.sin(a);return i.x=l*Math.cos(o),i.y=l*Math.sin(o),i.z=s*Math.cos(a),i},n.fromElements=function(e,r,i,o){return t(o)?(o.x=e,o.y=r,o.z=i,o):new n(e,r,i)},n.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new n(e.x,e.y,e.z):void 0},n.fromCartesian4=n.clone,n.packedLength=3,n.pack=function(t,r,i){i=e(i,0),r[i++]=t.x,r[i++]=t.y,r[i]=t.z},n.unpack=function(r,i,o){return i=e(i,0),t(o)||(o=new n),o.x=r[i++],o.y=r[i++],o.z=r[i],o},n.fromArray=n.unpack,n.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z)},n.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z)},n.getMinimumByComponent=function(e,r,i){return t(i)||(i=new n),i.x=Math.min(e.x,r.x),i.y=Math.min(e.y,r.y),i.z=Math.min(e.z,r.z),i},n.getMaximumByComponent=function(e,r,i){return t(i)||(i=new n),i.x=Math.max(e.x,r.x),i.y=Math.max(e.y,r.y),i.z=Math.max(e.z,r.z),i},n.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},n.magnitude=function(e){return Math.sqrt(n.magnitudeSquared(e))};var o=new n;n.distance=function(e,t){return n.subtract(e,t,o),n.magnitude(o)},n.normalize=function(e,r){var i=n.magnitude(e);return t(r)?(r.x=e.x/i,r.y=e.y/i,r.z=e.z/i,r):new n(e.x/i,e.y/i,e.z/i)},n.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},n.multiplyComponents=function(e,r,i){return t(i)?(i.x=e.x*r.x,i.y=e.y*r.y,i.z=e.z*r.z,i):new n(e.x*r.x,e.y*r.y,e.z*r.z)},n.add=function(e,r,i){return t(i)?(i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i):new n(e.x+r.x,e.y+r.y,e.z+r.z)},n.subtract=function(e,r,i){return t(i)?(i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i):new n(e.x-r.x,e.y-r.y,e.z-r.z)},n.multiplyByScalar=function(e,r,i){return t(i)?(i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i):new n(e.x*r,e.y*r,e.z*r)},n.divideByScalar=function(e,r,i){return t(i)?(i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i):new n(e.x/r,e.y/r,e.z/r)},n.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r):new n(-e.x,-e.y,-e.z)},n.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r):new n(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z))};var a=new n;n.lerp=function(e,t,r,i){return n.multiplyByScalar(t,r,a),i=n.multiplyByScalar(e,1-r,i),n.add(a,i,i)};var s=new n,l=new n;n.angleBetween=function(e,t){n.normalize(e,s),n.normalize(t,l);var r=n.dot(s,l),i=n.magnitude(n.cross(s,l,s));return Math.atan2(i,r)};var u=new n;return n.mostOrthogonalAxis=function(e,t){var r=n.normalize(e,u);return n.abs(r,r),t=r.x<=r.y?r.x<=r.z?n.clone(n.UNIT_X,t):n.clone(n.UNIT_Z,t):r.y<=r.z?n.clone(n.UNIT_Y,t):n.clone(n.UNIT_Z,t)},n.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},n.equalsEpsilon=function(e,r,i){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i},n.cross=function(e,r,i){var o=e.x,a=e.y,s=e.z,l=r.x,u=r.y,c=r.z,h=a*c-s*u,d=s*l-o*c,m=o*u-a*l;return t(i)?(i.x=h,i.y=d,i.z=m,i):new n(h,d,m)},n.ZERO=i(new n(0,0,0)),n.UNIT_X=i(new n(1,0,0)),n.UNIT_Y=i(new n(0,1,0)),n.UNIT_Z=i(new n(0,0,1)),n.prototype.clone=function(e){return n.clone(this,e)},n.prototype.equals=function(e){return n.equals(this,e)},n.prototype.equalsEpsilon=function(e,t){return n.equalsEpsilon(this,e,t)},n.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},n}),r("Core/Enumeration",["./defined"],function(e){"use strict";var t=function(t,r,i){if(this.value=t,this.name=r,e(i))for(var n in i)i.hasOwnProperty(n)&&(this[n]=i[n])};return t.prototype.valueOf=function(){return this.value},t.prototype.toString=function(){return this.name},t}),r("Core/Intersect",["./Enumeration"],function(e){"use strict";var t={OUTSIDE:new e(-1,"OUTSIDE"),INTERSECTING:new e(0,"INTERSECTING"),INSIDE:new e(1,"INSIDE")};return t}),r("Core/AxisAlignedBoundingBox",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Intersect"],function(e,t,r,i,n){"use strict";var o=function(r,n,o){this.minimum=i.clone(e(r,i.ZERO)),this.maximum=i.clone(e(n,i.ZERO)),t(o)?o=i.clone(o):(o=i.add(this.minimum,this.maximum),i.multiplyByScalar(o,.5,o)),this.center=o};o.fromPoints=function(e,r){if(t(r)||(r=new o),!t(e)||0===e.length)return r.minimum=i.clone(i.ZERO,r.minimum),r.maximum=i.clone(i.ZERO,r.maximum),r.center=i.clone(i.ZERO,r.center),r;for(var n=e[0].x,a=e[0].y,s=e[0].z,l=e[0].x,u=e[0].y,c=e[0].z,h=e.length,d=1;h>d;d++){var m=e[d],p=m.x,f=m.y,v=m.z;n=Math.min(p,n),l=Math.max(p,l),a=Math.min(f,a),u=Math.max(f,u),s=Math.min(v,s),c=Math.max(v,c)}var y=r.minimum;y.x=n,y.y=a,y.z=s;var g=r.maximum;g.x=l,g.y=u,g.z=c;var _=i.add(y,g,r.center);return i.multiplyByScalar(_,.5,_),r},o.clone=function(e,r){return t(e)?t(r)?(r.minimum=i.clone(e.minimum,r.minimum),r.maximum=i.clone(e.maximum,r.maximum),r.center=i.clone(e.center,r.center),r):new o(e.minimum,e.maximum):void 0},o.equals=function(e,r){return e===r||t(e)&&t(r)&&i.equals(e.center,r.center)&&i.equals(e.minimum,r.minimum)&&i.equals(e.maximum,r.maximum)};var a=new i;return o.intersect=function(e,o){if(!t(e))throw new r("box is required.");if(!t(o))throw new r("plane is required.");a=i.subtract(e.maximum,e.minimum,a);var s=i.multiplyByScalar(a,.5,a),l=s.x*Math.abs(o.x)+s.y*Math.abs(o.y)+s.z*Math.abs(o.z),u=i.dot(e.center,o)+o.w;return u-l>0?n.INSIDE:0>u+l?n.OUTSIDE:n.INTERSECTING},o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.intersect=function(e){return o.intersect(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o}),r("Core/BingMapsApi",["./defined"],function(e){"use strict";var t={};t.defaultKey=void 0;var r=!1;return t.getKey=function(i){return e(i)?i:e(t.defaultKey)?t.defaultKey:(r||(console.log("This application is using Cesium's default Bing Maps key.  Please create a new key for the application as soon as possible and prior to deployment by visiting https://www.bingmapsportal.com/, and provide your key to Cesium by setting the Cesium.BingMapsApi.defaultKey property before constructing the CesiumWidget or any other object that uses the Bing Maps API."),r=!0),"Aj1ony_-Typ-KjG9SJWiKSHY23U1KmK7yAmZa9lDmuF2osXWkcZ22VPsqmCt0TCt")},t}),r("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i){"use strict";var n=function(t,r){this.x=e(t,0),this.y=e(r,0)};n.fromElements=function(e,r,i){return t(i)?(i.x=e,i.y=r,i):new n(e,r)},n.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new n(e.x,e.y):void 0},n.fromCartesian3=n.clone,n.fromCartesian4=n.clone,n.packedLength=2,n.pack=function(t,r,i){i=e(i,0),r[i++]=t.x,r[i]=t.y},n.unpack=function(r,i,o){return i=e(i,0),t(o)||(o=new n),o.x=r[i++],o.y=r[i],o},n.fromArray=n.unpack,n.getMaximumComponent=function(e){return Math.max(e.x,e.y)},n.getMinimumComponent=function(e){return Math.min(e.x,e.y)},n.getMinimumByComponent=function(e,r,i){return t(i)||(i=new n),i.x=Math.min(e.x,r.x),i.y=Math.min(e.y,r.y),i},n.getMaximumByComponent=function(e,r,i){return t(i)||(i=new n),i.x=Math.max(e.x,r.x),i.y=Math.max(e.y,r.y),i},n.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},n.magnitude=function(e){return Math.sqrt(n.magnitudeSquared(e))};var o=new n;n.distance=function(e,t){return n.subtract(e,t,o),n.magnitude(o)},n.normalize=function(e,r){var i=n.magnitude(e);return t(r)?(r.x=e.x/i,r.y=e.y/i,r):new n(e.x/i,e.y/i)},n.dot=function(e,t){return e.x*t.x+e.y*t.y},n.multiplyComponents=function(e,r,i){return t(i)?(i.x=e.x*r.x,i.y=e.y*r.y,i):new n(e.x*r.x,e.y*r.y)},n.add=function(e,r,i){return t(i)?(i.x=e.x+r.x,i.y=e.y+r.y,i):new n(e.x+r.x,e.y+r.y)},n.subtract=function(e,r,i){return t(i)?(i.x=e.x-r.x,i.y=e.y-r.y,i):new n(e.x-r.x,e.y-r.y)},n.multiplyByScalar=function(e,r,i){return t(i)?(i.x=e.x*r,i.y=e.y*r,i):new n(e.x*r,e.y*r)},n.divideByScalar=function(e,r,i){return t(i)?(i.x=e.x/r,i.y=e.y/r,i):new n(e.x/r,e.y/r)},n.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r):new n(-e.x,-e.y)},n.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r):new n(Math.abs(e.x),Math.abs(e.y))};var a=new n;n.lerp=function(e,t,r,i){return n.multiplyByScalar(t,r,a),i=n.multiplyByScalar(e,1-r,i),n.add(a,i,i)};var s=new n,l=new n;n.angleBetween=function(e,t){return n.normalize(e,s),n.normalize(t,l),Math.acos(n.dot(s,l))};var u=new n;return n.mostOrthogonalAxis=function(e,t){var r=n.normalize(e,u);return n.abs(r,r),t=r.x<=r.y?n.clone(n.UNIT_X,t):n.clone(n.UNIT_Y,t)},n.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},n.equalsEpsilon=function(e,r,i){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i},n.ZERO=i(new n(0,0)),n.UNIT_X=i(new n(1,0)),n.UNIT_Y=i(new n(0,1)),n.prototype.clone=function(e){return n.clone(this,e)},n.prototype.equals=function(e){return n.equals(this,e)},n.prototype.equalsEpsilon=function(e,t){return n.equalsEpsilon(this,e,t)},n.prototype.toString=function(){return"("+this.x+", "+this.y+")"},n}),r("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),r("Core/Math",["./defaultValue","./defined","./DeveloperError","../ThirdParty/mersenne-twister"],function(e,t,r,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},n.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},n.lerp=function(e,t,r){return(1-r)*e+r*t},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=.5*3*Math.PI,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){var t=n.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},n.negativePiToPi=function(e){for(var t=n.EPSILON10,r=n.PI,i=n.TWO_PI;-(r+t)>e;)e+=i;if(-r>e)return-r;for(;e>r+t;)e-=i;return e>r?r:e},n.zeroToTwoPi=function(e){var t=e%n.TWO_PI;return 0>t?(t+n.TWO_PI)%n.TWO_PI:t},n.equalsEpsilon=function(t,r,i){return i=e(i,0),Math.abs(t-r)<=i};var o=[1];n.factorial=function(e){var t=o.length;if(e>=t)for(var r=o[t-1],i=t;e>=i;i++)o.push(r*i);return o[e]},n.incrementWrap=function(t,r,i){return i=e(i,0),++t,t>r&&(t=i),t},n.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,t,r){return t>e?t:e>r?r:e};var a=new i;return n.setRandomNumberSeed=function(e){a=new i(e)},n.nextRandomNumber=function(){return a.random()},n}),r("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";var o=function(t,r,i){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(i,0)};return o.fromDegrees=function(r,i,a,s){return r=n.toRadians(e(r,0)),i=n.toRadians(e(i,0)),a=e(a,0),t(s)?(s.longitude=r,s.latitude=i,s.height=a,s):new o(r,i,a)},o.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},o.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new r("epsilon is required and must be a number.");return e===i||t(e)&&t(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},o.toString=function(e){if(!t(e))throw new r("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=i(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return o.toString(this)},o}),r("Core/Ellipsoid",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic"],function(e,t,r,i,n,o,a){"use strict";var s=function(e,r,a){if(e=t(e,0),r=t(r,0),a=t(a,0),0>e||0>r||0>a)throw new i("All radii components must be greater than or equal to zero.");this._radii=new o(e,r,a),this._radiiSquared=new o(e*e,r*r,a*a),this._radiiToTheFourth=new o(e*e*e*e,r*r*r*r,a*a*a*a),this._oneOverRadii=new o(0===e?0:1/e,0===r?0:1/r,0===a?0:1/a),this._oneOverRadiiSquared=new o(0===e?0:1/(e*e),0===r?0:1/(r*r),0===a?0:1/(a*a)),this._minimumRadius=Math.min(e,r,a),this._maximumRadius=Math.max(e,r,a),this._centerToleranceSquared=n.EPSILON1};s.clone=function(e,t){if(!r(e))return void 0;var i=e._radii;return r(t)?(o.clone(i,t._radii),o.clone(e._radiiSquared,t._radiiSquared),o.clone(e._radiiToTheFourth,t._radiiToTheFourth),o.clone(e._oneOverRadii,t._oneOverRadii),o.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new s(i.x,i.y,i.z)},s.fromCartesian3=function(e){return r(e)?new s(e.x,e.y,e.z):new s},s.WGS84=e(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=e(new s(1,1,1)),s.MOON=e(new s(n.LUNAR_RADIUS,n.LUNAR_RADIUS,n.LUNAR_RADIUS)),s.prototype.getRadii=function(){return this._radii},s.prototype.getRadiiSquared=function(){return this._radiiSquared},s.prototype.getRadiiToTheFourth=function(){return this._radiiToTheFourth},s.prototype.getOneOverRadii=function(){return this._oneOverRadii},s.prototype.getOneOverRadiiSquared=function(){return this._oneOverRadiiSquared},s.prototype.getMinimumRadius=function(){return this._minimumRadius},s.prototype.getMaximumRadius=function(){return this._maximumRadius},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=o.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(e,t){if(!r(e))throw new i("cartographic is required.");var n=e.longitude,a=e.latitude,s=Math.cos(a),l=s*Math.cos(n),u=s*Math.sin(n),c=Math.sin(a);return r(t)||(t=new o),t.x=l,t.y=u,t.z=c,o.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(e,t){return t=o.multiplyComponents(e,this._oneOverRadiiSquared,t),o.normalize(t,t)};var l=new o,u=new o;s.prototype.cartographicToCartesian=function(e,t){var r=l,i=u;this.geodeticSurfaceNormalCartographic(e,r),o.multiplyComponents(this._radiiSquared,r,i);var n=Math.sqrt(o.dot(r,i));return o.divideByScalar(i,n,i),o.multiplyByScalar(r,e.height,r),o.add(i,r,t)},s.prototype.cartographicArrayToCartesianArray=function(e,t){if(!r(e))throw new i("cartographics is required.");var n=e.length;r(t)?t.length=n:t=new Array(n);for(var o=0;n>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var c=new o,h=new o,d=new o;s.prototype.cartesianToCartographic=function(e,t){var i=this.scaleToGeodeticSurface(e,h);if(!r(i))return void 0;var s=this.geodeticSurfaceNormal(i,c),l=o.subtract(e,i,d),u=Math.atan2(s.y,s.x),m=Math.asin(s.z),p=n.sign(o.dot(l,e))*o.magnitude(l);return r(t)?(t.longitude=u,t.latitude=m,t.height=p,t):new a(u,m,p)},s.prototype.cartesianArrayToCartographicArray=function(e,t){if(!r(e))throw new i("cartesians is required.");var n=e.length;r(t)?t.length=n:t=new Array(n);for(var o=0;n>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t};var m=new o,p=new o;return s.prototype.scaleToGeodeticSurface=function(e,t){if(!r(e))throw new i("cartesian is required.");var a=e.x,s=e.y,l=e.z,u=this._oneOverRadii,c=u.x,h=u.y,d=u.z,f=a*a*c*c,v=s*s*h*h,y=l*l*d*d,g=f+v+y,_=Math.sqrt(1/g),w=o.multiplyByScalar(e,_,m);if(g<this._centerToleranceSquared)return isFinite(_)?o.clone(w,t):void 0;var C=this._oneOverRadiiSquared,x=C.x,S=C.y,E=C.z,b=p;b.x=2*w.x*x,b.y=2*w.y*S,b.z=2*w.z*E;var T,A,D,P,M,I,O,R,L,z,N,B=(1-_)*o.magnitude(e)/(.5*o.magnitude(b)),F=0;do{B-=F,D=1/(1+B*x),P=1/(1+B*S),M=1/(1+B*E),I=D*D,O=P*P,R=M*M,L=I*D,z=O*P,N=R*M,T=f*I+v*O+y*R-1,A=f*L*x+v*z*S+y*N*E;var V=-2*A;F=T/V}while(Math.abs(T)>n.EPSILON12);return r(t)?(t.x=a*D,t.y=s*P,t.z=l*M,t):new o(a*D,s*P,l*M)},s.prototype.scaleToGeocentricSurface=function(e,t){if(!r(e))throw new i("cartesian is required.");var n=e.x,a=e.y,s=e.z,l=this._oneOverRadiiSquared,u=1/Math.sqrt(n*n*l.x+a*a*l.y+s*s*l.z);return o.multiplyByScalar(e,u,t)},s.prototype.transformPositionToScaledSpace=function(e,t){return o.multiplyComponents(e,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(e,t){return o.multiplyComponents(e,this._radii,t)},s.prototype.equals=function(e){return this===e||r(e)&&o.equals(this._radii,e._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),r("Core/GeographicProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Ellipsoid"],function(e,t,r,i,n){"use strict";var o=function(t){this._ellipsoid=e(t,n.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return o.prototype.getEllipsoid=function(){return this._ellipsoid},o.prototype.project=function(e,i){var n=this._semimajorAxis,o=e.longitude*n,a=e.latitude*n,s=e.height;return t(i)?(i.x=o,i.y=a,i.z=s,i):new r(o,a,s)},o.prototype.unproject=function(e,r){var n=this._oneOverSemimajorAxis,o=e.x*n,a=e.y*n,s=e.z;return t(r)?(r.longitude=o,r.latitude=a,r.height=s,r):new i(o,a,s)},o}),r("Core/BoundingRectangle",["./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartographic","./GeographicProjection","./Intersect"],function(e,t,r,i,n,o,a){"use strict";var s=function(t,r,i,n){this.x=e(t,0),this.y=e(r,0),this.width=e(i,0),this.height=e(n,0)};s.fromPoints=function(e,r){if(t(r)||(r=new s),!t(e)||0===e.length)return r.x=0,r.y=0,r.width=0,r.height=0,r;for(var i=e.length,n=e[0].x,o=e[0].y,a=e[0].x,l=e[0].y,u=1;i>u;u++){var c=e[u],h=c.x,d=c.y;n=Math.min(h,n),a=Math.max(h,a),o=Math.min(d,o),l=Math.max(d,l)}return r.x=n,r.y=o,r.width=a-n,r.height=l-o,r};var l=new o,u=new n,c=new n;return s.fromExtent=function(r,n,o){if(t(o)||(o=new s),!t(r))return o.x=0,o.y=0,o.width=0,o.height=0,o;n=e(n,l);var a=n.project(r.getSouthwest(u)),h=n.project(r.getNortheast(c));return i.subtract(h,a,h),o.x=a.x,o.y=a.y,o.width=h.x,o.height=h.y,o},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.width=e.width,r.height=e.height,r):new s(e.x,e.y,e.width,e.height):void 0},s.union=function(e,i,n){if(!t(e))throw new r("left is required.");if(!t(i))throw new r("right is required.");t(n)||(n=new s);var o=Math.min(e.x,i.x),a=Math.min(e.y,i.y),l=Math.max(e.x+e.width,i.x+i.width),u=Math.max(e.y+e.height,i.y+i.height);return n.x=o,n.y=a,n.width=l-o,n.height=u-a,n},s.expand=function(e,i,n){if(!t(e))throw new r("rectangle is required.");if(!t(i))throw new r("point is required.");n=s.clone(e,n);var o=i.x-n.x,a=i.y-n.y;return o>n.width?n.width=o:0>o&&(n.width-=o,n.x=i.x),a>n.height?n.height=a:0>a&&(n.height-=a,n.y=i.y),n},s.intersect=function(e,i){if(!t(e))throw new r("left is required.");if(!t(i))throw new r("right is required.");var n=e.x,o=e.y,s=i.x,l=i.y;return n>s+i.width||n+e.width<s||o+e.height<l||o>l+i.height?a.OUTSIDE:a.INTERSECTING},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.width===r.width&&e.height===r.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.union=function(e,t){return s.union(this,e,t)},s.prototype.expand=function(e,t){return s.expand(this,e,t)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),r("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i){"use strict";var n=function(t,r,i,n){this.x=e(t,0),this.y=e(r,0),this.z=e(i,0),this.w=e(n,0)};n.fromElements=function(e,r,i,o,a){return t(a)?(a.x=e,a.y=r,a.z=i,a.w=o,a):new n(e,r,i,o)},n.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new n(e.x,e.y,e.z,e.w):void 0},n.packedLength=4,n.pack=function(t,r,i){i=e(i,0),r[i++]=t.x,r[i++]=t.y,r[i++]=t.z,r[i]=t.w},n.unpack=function(r,i,o){return i=e(i,0),t(o)||(o=new n),o.x=r[i++],o.y=r[i++],o.z=r[i++],o.w=r[i],o},n.fromArray=n.unpack,n.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},n.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},n.getMinimumByComponent=function(e,r,i){return t(i)||(i=new n),i.x=Math.min(e.x,r.x),i.y=Math.min(e.y,r.y),i.z=Math.min(e.z,r.z),i.w=Math.min(e.w,r.w),i},n.getMaximumByComponent=function(e,r,i){return t(i)||(i=new n),i.x=Math.max(e.x,r.x),i.y=Math.max(e.y,r.y),i.z=Math.max(e.z,r.z),i.w=Math.max(e.w,r.w),i},n.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},n.magnitude=function(e){return Math.sqrt(n.magnitudeSquared(e))};var o=new n;n.distance=function(e,t){return n.subtract(e,t,o),n.magnitude(o)},n.normalize=function(e,r){var i=n.magnitude(e);return t(r)?(r.x=e.x/i,r.y=e.y/i,r.z=e.z/i,r.w=e.w/i,r):new n(e.x/i,e.y/i,e.z/i,e.w/i)},n.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},n.multiplyComponents=function(e,r,i){return t(i)?(i.x=e.x*r.x,i.y=e.y*r.y,i.z=e.z*r.z,i.w=e.w*r.w,i):new n(e.x*r.x,e.y*r.y,e.z*r.z,e.w*r.w)},n.add=function(e,r,i){return t(i)?(i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i):new n(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},n.subtract=function(e,r,i){return t(i)?(i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i):new n(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},n.multiplyByScalar=function(e,r,i){return t(i)?(i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i):new n(e.x*r,e.y*r,e.z*r,e.w*r)},n.divideByScalar=function(e,r,i){return t(i)?(i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i):new n(e.x/r,e.y/r,e.z/r,e.w/r)},n.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new n(-e.x,-e.y,-e.z,-e.w)},n.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r.w=Math.abs(e.w),r):new n(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z),Math.abs(e.w))};var a=new n;n.lerp=function(e,t,r,i){return n.multiplyByScalar(t,r,a),i=n.multiplyByScalar(e,1-r,i),n.add(a,i,i)};var s=new n;return n.mostOrthogonalAxis=function(e,t){var r=n.normalize(e,s);return n.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?n.clone(n.UNIT_X,t):n.clone(n.UNIT_W,t):r.z<=r.w?n.clone(n.UNIT_Z,t):n.clone(n.UNIT_W,t):r.y<=r.z?r.y<=r.w?n.clone(n.UNIT_Y,t):n.clone(n.UNIT_W,t):r.z<=r.w?n.clone(n.UNIT_Z,t):n.clone(n.UNIT_W,t)},n.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},n.equalsEpsilon=function(e,r,i){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},n.ZERO=i(new n(0,0,0,0)),n.UNIT_X=i(new n(1,0,0,0)),n.UNIT_Y=i(new n(0,1,0,0)),n.UNIT_Z=i(new n(0,0,1,0)),n.UNIT_W=i(new n(0,0,0,1)),n.prototype.clone=function(e){return n.clone(this,e)},n.prototype.equals=function(e){return n.equals(this,e)},n.prototype.equalsEpsilon=function(e,t){return n.equalsEpsilon(this,e,t)},n.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},n}),r("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),r("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n,o){"use strict";function a(e){for(var t=0,r=0;9>r;++r){var i=e[r];t+=i*i}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var i=e[u.getElementIndex(h[r],c[r])];t+=2*i*i}return Math.sqrt(t)}function l(e,t){for(var r=o.EPSILON15,i=0,n=1,a=0;3>a;++a){var s=Math.abs(e[u.getElementIndex(h[a],c[a])]);s>i&&(n=a,i=s)}var l=1,d=0,m=c[n],p=h[n];if(Math.abs(e[u.getElementIndex(p,m)])>r){var f,v=e[u.getElementIndex(p,p)],y=e[u.getElementIndex(m,m)],g=e[u.getElementIndex(p,m)],_=(v-y)/2/g;f=0>_?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),l=1/Math.sqrt(1+f*f),d=f*l}return t=u.clone(u.IDENTITY,t),t[u.getElementIndex(m,m)]=t[u.getElementIndex(p,p)]=l,t[u.getElementIndex(p,m)]=d,t[u.getElementIndex(m,p)]=-d,t}var u=function(e,r,i,n,o,a,s,l,u){this[0]=t(e,0),this[1]=t(n,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(o,0),this[5]=t(l,0),this[6]=t(i,0),this[7]=t(a,0),this[8]=t(u,0)};u.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new u(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},u.fromArray=function(e,i,n){return i=t(i,0),r(n)||(n=new u),n[0]=e[i],n[1]=e[i+1],n[2]=e[i+2],n[3]=e[i+3],n[4]=e[i+4],n[5]=e[i+5],n[6]=e[i+6],n[7]=e[i+7],n[8]=e[i+8],n[9]=e[i+9],n},u.fromColumnMajorArray=function(e,t){return u.clone(e,t)},u.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},u.fromQuaternion=function(e,t){var i=e.x*e.x,n=e.x*e.y,o=e.x*e.z,a=e.x*e.w,s=e.y*e.y,l=e.y*e.z,c=e.y*e.w,h=e.z*e.z,d=e.z*e.w,m=e.w*e.w,p=i-s-h+m,f=2*(n-d),v=2*(o+c),y=2*(n+d),g=-i+s-h+m,_=2*(l-a),w=2*(o-c),C=2*(l+a),x=-i-s+h+m;return r(t)?(t[0]=p,t[1]=y,t[2]=w,t[3]=f,t[4]=g,t[5]=C,t[6]=v,t[7]=_,t[8]=x,t):new u(p,f,v,y,g,_,w,C,x)},u.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new u(e.x,0,0,0,e.y,0,0,0,e.z)},u.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new u(e,0,0,0,e,0,0,0,e)},u.fromRotationX=function(e,t){var i=Math.cos(e),n=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=i,t[5]=n,t[6]=0,t[7]=-n,t[8]=i,t):new u(1,0,0,0,i,-n,0,n,i)},u.fromRotationY=function(e,t){var i=Math.cos(e),n=Math.sin(e);return r(t)?(t[0]=i,t[1]=0,t[2]=-n,t[3]=0,t[4]=1,t[5]=0,t[6]=n,t[7]=0,t[8]=i,t):new u(i,0,n,0,1,0,-n,0,i)},u.fromRotationZ=function(e,t){var i=Math.cos(e),n=Math.sin(e);return r(t)?(t[0]=i,t[1]=n,t[2]=0,t[3]=-n,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new u(i,-n,0,n,i,0,0,0,1)},u.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},u.getElementIndex=function(e,t){return 3*e+t},u.getColumn=function(t,i,n){var o=3*i,a=t[o],s=t[o+1],l=t[o+2];return r(n)?(n.x=a,n.y=s,n.z=l,n):new e(a,s,l)},u.setColumn=function(e,t,r,i){i=u.clone(e,i);var n=3*t;return i[n]=r.x,i[n+1]=r.y,i[n+2]=r.z,i},u.getRow=function(t,i,n){var o=t[i],a=t[i+3],s=t[i+6];return r(n)?(n.x=o,n.y=a,n.z=s,n):new e(o,a,s)},u.setRow=function(e,t,r,i){return i=u.clone(e,i),i[t]=r.x,i[t+3]=r.y,i[t+6]=r.z,i},u.multiply=function(e,t,i){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],s=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],l=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],h=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],d=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],m=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r(i)?(i[0]=n,i[1]=o,i[2]=a,i[3]=s,i[4]=l,i[5]=c,i[6]=h,i[7]=d,i[8]=m,i):new u(n,s,h,o,l,d,a,c,m)},u.multiplyByVector=function(t,i,n){var o=i.x,a=i.y,s=i.z,l=t[0]*o+t[3]*a+t[6]*s,u=t[1]*o+t[4]*a+t[7]*s,c=t[2]*o+t[5]*a+t[8]*s;return r(n)?(n.x=l,n.y=u,n.z=c,n):new e(l,u,c)},u.multiplyByScalar=function(e,t,i){return r(i)?(i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i):new u(e[0]*t,e[3]*t,e[6]*t,e[1]*t,e[4]*t,e[7]*t,e[2]*t,e[5]*t,e[8]*t)
},u.negate=function(e,t){return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t):new u(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},u.transpose=function(e,t){var i=e[0],n=e[3],o=e[6],a=e[1],s=e[4],l=e[7],c=e[2],h=e[5],d=e[8];return r(t)?(t[0]=i,t[1]=n,t[2]=o,t[3]=a,t[4]=s,t[5]=l,t[6]=c,t[7]=h,t[8]=d,t):new u(i,a,c,n,s,h,o,l,d)};var c=[1,0,0],h=[2,2,1],d=new u,m=new u;return u.getEigenDecomposition=function(e,t){var i=o.EPSILON20,n=10,c=0,h=0;r(t)||(t={});for(var p=t.unitary=u.clone(u.IDENTITY,t.unitary),f=t.diagonal=u.clone(e,t.diagonal),v=i*a(f);n>h&&s(f)>v;)l(f,d),u.transpose(d,m),u.multiply(f,d,f),u.multiply(m,f,f),u.multiply(p,d,p),++c>2&&(++h,c=0);return t},u.abs=function(e,t){return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t):new u(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},u.determinant=function(e){if(!r(e))throw new i("matrix is required");var t=e[0],n=e[3],o=e[6],a=e[1],s=e[4],l=e[7],u=e[2],c=e[5],h=e[8];return t*(s*h-c*l)+a*(c*o-n*h)+u*(n*l-s*o)},u.inverse=function(e,t){if(!r(e))throw new i("matrix is required");var n=e[0],a=e[1],s=e[2],l=e[3],c=e[4],h=e[5],d=e[6],m=e[7],p=e[8],f=u.determinant(e);if(Math.abs(f)<=o.EPSILON15)throw new i("matrix is not invertible");var v=new u(c*p-m*h,d*h-l*p,l*m-d*c,m*s-a*p,n*p-d*s,d*a-n*m,a*h-c*s,l*s-n*h,n*c-l*a),y=1/f;return u.multiplyByScalar(v,y,t)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},u.equalsEpsilon=function(e,t,i){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i},u.IDENTITY=n(new u(1,0,0,0,1,0,0,0,1)),u.COLUMN0ROW0=0,u.COLUMN0ROW1=1,u.COLUMN0ROW2=2,u.COLUMN1ROW0=3,u.COLUMN1ROW1=4,u.COLUMN1ROW2=5,u.COLUMN2ROW0=6,u.COLUMN2ROW1=7,u.COLUMN2ROW2=8,u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},u}),r("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),r("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,i,n,o,a,s,l){"use strict";var u=function(e,t,i,n,o,a,s,l,u,c,h,d,m,p,f,v){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(u,0),this[3]=r(m,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(c,0),this[7]=r(p,0),this[8]=r(i,0),this[9]=r(s,0),this[10]=r(h,0),this[11]=r(f,0),this[12]=r(n,0),this[13]=r(l,0),this[14]=r(d,0),this[15]=r(v,0)};u.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new u(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},u.fromArray=function(e,t,n){return t=r(t,0),i(n)||(n=new u),n[0]=e[t],n[1]=e[t+1],n[2]=e[t+2],n[3]=e[t+3],n[4]=e[t+4],n[5]=e[t+5],n[6]=e[t+6],n[7]=e[t+7],n[8]=e[t+8],n[9]=e[t+9],n[10]=e[t+10],n[11]=e[t+11],n[12]=e[t+12],n[13]=e[t+13],n[14]=e[t+14],n[15]=e[t+15],n},u.fromColumnMajorArray=function(e,t){return u.clone(e,t)},u.fromRowMajorArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},u.fromRotationTranslation=function(e,t,r){return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=0,r[4]=e[3],r[5]=e[4],r[6]=e[5],r[7]=0,r[8]=e[6],r[9]=e[7],r[10]=e[8],r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,r):new u(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},new s,u.fromTranslationQuaternionRotationScale=function(e,t,r,n){i(n)||(n=new u);var o=r.x,a=r.y,s=r.z,l=t.x*t.x,c=t.x*t.y,h=t.x*t.z,d=t.x*t.w,m=t.y*t.y,p=t.y*t.z,f=t.y*t.w,v=t.z*t.z,y=t.z*t.w,g=t.w*t.w,_=l-m-v+g,w=2*(c-y),C=2*(h+f),x=2*(c+y),S=-l+m-v+g,E=2*(p-d),b=2*(h-f),T=2*(p+d),A=-l-m+v+g;return n[0]=_*o,n[1]=x*o,n[2]=b*o,n[3]=0,n[4]=w*a,n[5]=S*a,n[6]=T*a,n[7]=0,n[8]=C*s,n[9]=E*s,n[10]=A*s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n},u.fromTranslation=function(e,t){return u.fromRotationTranslation(s.IDENTITY,e,t)},u.fromScale=function(e,t){return i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new u(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},u.fromUniformScale=function(e,t){return i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new u(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,h=new e,d=new e;u.fromCamera=function(t,r){var n=t.eye,o=t.target,a=t.up;e.normalize(e.subtract(o,n,c),c),e.normalize(e.cross(c,a,h),h),e.normalize(e.cross(h,c,d),d);var s=h.x,l=h.y,m=h.z,p=c.x,f=c.y,v=c.z,y=d.x,g=d.y,_=d.z,w=n.x,C=n.y,x=n.z,S=s*-w+l*-C+m*-x,E=y*-w+g*-C+_*-x,b=p*w+f*C+v*x;return i(r)?(r[0]=s,r[1]=y,r[2]=-p,r[3]=0,r[4]=l,r[5]=g,r[6]=-f,r[7]=0,r[8]=m,r[9]=_,r[10]=-v,r[11]=0,r[12]=S,r[13]=E,r[14]=b,r[15]=1,r):new u(s,l,m,S,y,g,_,E,-p,-f,-v,b,0,0,0,1)},u.computePerspectiveFieldOfView=function(e,t,r,n,o){var a=Math.tan(.5*e),s=1/a,l=s/t,c=(n+r)/(r-n),h=2*n*r/(r-n);return i(o)?(o[0]=l,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o):new u(l,0,0,0,0,s,0,0,0,0,c,h,0,0,-1,0)},u.computeOrthographicOffCenter=function(e,t,r,n,o,a,s){var l=1/(t-e),c=1/(n-r),h=1/(a-o),d=-(t+e)*l,m=-(n+r)*c,p=-(a+o)*h;return l*=2,c*=2,h*=-2,i(s)?(s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=h,s[11]=0,s[12]=d,s[13]=m,s[14]=p,s[15]=1,s):new u(l,0,0,d,0,c,0,m,0,0,h,p,0,0,0,1)},u.computePerspectiveOffCenter=function(e,t,r,n,o,a,s){var l=2*o/(t-e),c=2*o/(n-r),h=(t+e)/(t-e),d=(n+r)/(n-r),m=-(a+o)/(a-o),p=-1,f=-2*a*o/(a-o);return i(s)?(s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=h,s[9]=d,s[10]=m,s[11]=p,s[12]=0,s[13]=0,s[14]=f,s[15]=0,s):new u(l,0,h,0,0,c,d,0,0,0,m,f,0,0,p,0)},u.computeInfinitePerspectiveOffCenter=function(e,t,r,n,o,a){var s=2*o/(t-e),l=2*o/(n-r),c=(t+e)/(t-e),h=(n+r)/(n-r),d=-1,m=-1,p=-2*o;return i(a)?(a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=l,a[6]=0,a[7]=0,a[8]=c,a[9]=h,a[10]=d,a[11]=m,a[12]=0,a[13]=0,a[14]=p,a[15]=0,a):new u(s,0,c,0,0,l,h,0,0,0,d,p,0,0,m,0)},u.computeViewportTransformation=function(e,t,n,o){e=r(e,r.EMPTY_OBJECT);var a=r(e.x,0),s=r(e.y,0),l=r(e.width,0),c=r(e.height,0);t=r(t,0),n=r(n,1);var h=.5*l,d=.5*c,m=.5*(n-t),p=h,f=d,v=m,y=a+h,g=s+d,_=t+m,w=1;return i(o)?(o[0]=p,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=f,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=v,o[11]=0,o[12]=y,o[13]=g,o[14]=_,o[15]=w,o):new u(p,0,0,y,0,f,0,g,0,0,v,_,0,0,0,w)},u.toArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},u.getElementIndex=function(e,t){return 4*e+t},u.getColumn=function(e,r,n){var o=4*r,a=e[o],s=e[o+1],l=e[o+2],u=e[o+3];return i(n)?(n.x=a,n.y=s,n.z=l,n.w=u,n):new t(a,s,l,u)},u.setColumn=function(e,t,r,i){i=u.clone(e,i);var n=4*t;return i[n]=r.x,i[n+1]=r.y,i[n+2]=r.z,i[n+3]=r.w,i},u.getRow=function(e,r,n){var o=e[r],a=e[r+4],s=e[r+8],l=e[r+12];return i(n)?(n.x=o,n.y=a,n.z=s,n.w=l,n):new t(o,a,s,l)},u.setRow=function(e,t,r,i){return i=u.clone(e,i),i[t]=r.x,i[t+4]=r.y,i[t+8]=r.z,i[t+12]=r.w,i},u.multiply=function(e,t,r){var n=e[0],o=e[1],a=e[2],s=e[3],l=e[4],c=e[5],h=e[6],d=e[7],m=e[8],p=e[9],f=e[10],v=e[11],y=e[12],g=e[13],_=e[14],w=e[15],C=t[0],x=t[1],S=t[2],E=t[3],b=t[4],T=t[5],A=t[6],D=t[7],P=t[8],M=t[9],I=t[10],O=t[11],R=t[12],L=t[13],z=t[14],N=t[15],B=n*C+l*x+m*S+y*E,F=o*C+c*x+p*S+g*E,V=a*C+h*x+f*S+_*E,k=s*C+d*x+v*S+w*E,U=n*b+l*T+m*A+y*D,W=o*b+c*T+p*A+g*D,q=a*b+h*T+f*A+_*D,G=s*b+d*T+v*A+w*D,H=n*P+l*M+m*I+y*O,j=o*P+c*M+p*I+g*O,Y=a*P+h*M+f*I+_*O,X=s*P+d*M+v*I+w*O,Z=n*R+l*L+m*z+y*N,J=o*R+c*L+p*z+g*N,K=a*R+h*L+f*z+_*N,Q=s*R+d*L+v*z+w*N;return i(r)?(r[0]=B,r[1]=F,r[2]=V,r[3]=k,r[4]=U,r[5]=W,r[6]=q,r[7]=G,r[8]=H,r[9]=j,r[10]=Y,r[11]=X,r[12]=Z,r[13]=J,r[14]=K,r[15]=Q,r):new u(B,U,H,Z,F,W,j,J,V,q,Y,K,k,G,X,Q)},u.multiplyTransformation=function(e,t,r){var n=e[0],o=e[1],a=e[2],s=e[4],l=e[5],c=e[6],h=e[8],d=e[9],m=e[10],p=e[12],f=e[13],v=e[14],y=t[0],g=t[1],_=t[2],w=t[4],C=t[5],x=t[6],S=t[8],E=t[9],b=t[10],T=t[12],A=t[13],D=t[14],P=n*y+s*g+h*_,M=o*y+l*g+d*_,I=a*y+c*g+m*_,O=n*w+s*C+h*x,R=o*w+l*C+d*x,L=a*w+c*C+m*x,z=n*S+s*E+h*b,N=o*S+l*E+d*b,B=a*S+c*E+m*b,F=n*T+s*A+h*D+p,V=o*T+l*A+d*D+f,k=a*T+c*A+m*D+v;return i(r)?(r[0]=P,r[1]=M,r[2]=I,r[3]=0,r[4]=O,r[5]=R,r[6]=L,r[7]=0,r[8]=z,r[9]=N,r[10]=B,r[11]=0,r[12]=F,r[13]=V,r[14]=k,r[15]=1,r):new u(P,O,z,F,M,R,N,V,I,L,B,k,0,0,0,1)},u.multiplyByTranslation=function(e,t,r){var n=t.x,o=t.y,a=t.z,s=n*e[0]+o*e[4]+a*e[8]+e[12],l=n*e[1]+o*e[5]+a*e[9]+e[13],c=n*e[2]+o*e[6]+a*e[10]+e[14];return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=s,r[13]=l,r[14]=c,r[15]=e[15],r):new u(e[0],e[4],e[8],s,e[1],e[5],e[9],l,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var m=new e;return u.multiplyByUniformScale=function(e,t,r){return m.x=t,m.y=t,m.z=t,u.multiplyByScale(e,m,r)},u.multiplyByScale=function(e,t,r){var n=t.x,o=t.y,a=t.z;return 1===n&&1===o&&1===a?u.clone(e,r):i(r)?(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=a*e[8],r[9]=a*e[9],r[10]=a*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r):new u(n*e[0],o*e[4],a*e[8],e[12],n*e[1],o*e[5],a*e[9],e[13],n*e[2],o*e[6],a*e[10],e[14],0,0,0,1)},u.multiplyByVector=function(e,r,n){var o=r.x,a=r.y,s=r.z,l=r.w,u=e[0]*o+e[4]*a+e[8]*s+e[12]*l,c=e[1]*o+e[5]*a+e[9]*s+e[13]*l,h=e[2]*o+e[6]*a+e[10]*s+e[14]*l,d=e[3]*o+e[7]*a+e[11]*s+e[15]*l;return i(n)?(n.x=u,n.y=c,n.z=h,n.w=d,n):new t(u,c,h,d)},u.multiplyByPointAsVector=function(t,r,n){var o=r.x,a=r.y,s=r.z,l=t[0]*o+t[4]*a+t[8]*s,u=t[1]*o+t[5]*a+t[9]*s,c=t[2]*o+t[6]*a+t[10]*s;return i(n)?(n.x=l,n.y=u,n.z=c,n):new e(l,u,c)},u.multiplyByPoint=function(t,r,n){var o=r.x,a=r.y,s=r.z,l=t[0]*o+t[4]*a+t[8]*s+t[12],u=t[1]*o+t[5]*a+t[9]*s+t[13],c=t[2]*o+t[6]*a+t[10]*s+t[14];return i(n)?(n.x=l,n.y=u,n.z=c,n):new e(l,u,c)},u.multiplyByScalar=function(e,t,r){return i(r)?(r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r):new u(e[0]*t,e[4]*t,e[8]*t,e[12]*t,e[1]*t,e[5]*t,e[9]*t,e[13]*t,e[2]*t,e[6]*t,e[10]*t,e[14]*t,e[3]*t,e[7]*t,e[11]*t,e[15]*t)},u.negate=function(e,t){return i(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t):new u(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},u.transpose=function(e,t){if(!i(t))return new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var r=e[1],n=e[2],o=e[3],a=e[6],s=e[7],l=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=s,t[14]=l,t[15]=e[15],t},u.abs=function(e,t){return i(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t):new u(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},u.equals=function(e,t){return e===t||i(e)&&i(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[11]===t[11]&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[15]===t[15]},u.equalsEpsilon=function(e,t,r){return e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},u.getTranslation=function(t,r){return i(r)?(r.x=t[12],r.y=t[13],r.z=t[14],r):new e(t[12],t[13],t[14])},u.getRotation=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},u.inverse=function(e,t){var r=e[0],n=e[4],o=e[8],s=e[12],c=e[1],h=e[5],d=e[9],m=e[13],p=e[2],f=e[6],v=e[10],y=e[14],g=e[3],_=e[7],w=e[11],C=e[15],x=v*C,S=y*w,E=f*C,b=y*_,T=f*w,A=v*_,D=p*C,P=y*g,M=p*w,I=v*g,O=p*_,R=f*g,L=x*h+b*d+T*m-(S*h+E*d+A*m),z=S*c+D*d+I*m-(x*c+P*d+M*m),N=E*c+P*h+O*m-(b*c+D*h+R*m),B=A*c+M*h+R*d-(T*c+I*h+O*d),F=S*n+E*o+A*s-(x*n+b*o+T*s),V=x*r+P*o+M*s-(S*r+D*o+I*s),k=b*r+D*n+R*s-(E*r+P*n+O*s),U=T*r+I*n+O*o-(A*r+M*n+R*o);x=o*m,S=s*d,E=n*m,b=s*h,T=n*d,A=o*h,D=r*m,P=s*c,M=r*d,I=o*c,O=r*h,R=n*c;var W=x*_+b*w+T*C-(S*_+E*w+A*C),q=S*g+D*w+I*C-(x*g+P*w+M*C),G=E*g+P*_+O*C-(b*g+D*_+R*C),H=A*g+M*_+R*w-(T*g+I*_+O*w),j=E*v+A*y+S*f-(T*y+x*f+b*v),Y=M*y+x*p+P*v-(D*v+I*y+S*p),X=D*f+R*y+b*p-(O*y+E*p+P*f),Z=O*v+T*p+I*f-(M*f+R*v+A*p),J=r*L+n*z+o*N+s*B;if(Math.abs(J)<a.EPSILON20)throw new l("matrix is not invertible because its determinate is zero.");return J=1/J,i(t)?(t[0]=L*J,t[1]=z*J,t[2]=N*J,t[3]=B*J,t[4]=F*J,t[5]=V*J,t[6]=k*J,t[7]=U*J,t[8]=W*J,t[9]=q*J,t[10]=G*J,t[11]=H*J,t[12]=j*J,t[13]=Y*J,t[14]=X*J,t[15]=Z*J,t):new u(L*J,F*J,W*J,j*J,z*J,V*J,q*J,Y*J,N*J,k*J,G*J,X*J,B*J,U*J,H*J,Z*J)},u.inverseTransformation=function(e,t){var r=e[0],n=e[1],o=e[2],a=e[4],s=e[5],l=e[6],c=e[8],h=e[9],d=e[10],m=e[12],p=e[13],f=e[14],v=-r*m-n*p-o*f,y=-a*m-s*p-l*f,g=-c*m-h*p-d*f;return i(t)?(t[0]=r,t[1]=a,t[2]=c,t[3]=0,t[4]=n,t[5]=s,t[6]=h,t[7]=0,t[8]=o,t[9]=l,t[10]=d,t[11]=0,t[12]=v,t[13]=y,t[14]=g,t[15]=1,t):new u(r,n,o,v,a,s,l,y,c,h,d,g,0,0,0,1)},u.IDENTITY=o(new u(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),u.COLUMN0ROW0=0,u.COLUMN0ROW1=1,u.COLUMN0ROW2=2,u.COLUMN0ROW3=3,u.COLUMN1ROW0=4,u.COLUMN1ROW1=5,u.COLUMN1ROW2=6,u.COLUMN1ROW3=7,u.COLUMN2ROW0=8,u.COLUMN2ROW1=9,u.COLUMN2ROW2=10,u.COLUMN2ROW3=11,u.COLUMN3ROW0=12,u.COLUMN3ROW1=13,u.COLUMN3ROW2=14,u.COLUMN3ROW3=15,u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},u}),r("Core/BoundingSphere",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Cartesian4","./Cartographic","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";var h=function(t,r){this.center=i.clone(e(t,i.ZERO)),this.radius=e(r,0)},d=new i,m=new i,p=new i,f=new i,v=new i,y=new i,g=new i,_=new i,w=new i,C=new i,x=new i,S=new i;h.fromPoints=function(e,r){if(t(r)||(r=new h),!t(e)||0===e.length)return r.center=i.clone(i.ZERO,r.center),r.radius=0,r;for(var n=i.clone(e[0],g),o=i.clone(n,d),a=i.clone(n,m),s=i.clone(n,p),l=i.clone(n,f),u=i.clone(n,v),c=i.clone(n,y),E=e.length,b=1;E>b;b++){i.clone(e[b],n);var T=n.x,A=n.y,D=n.z;T<o.x&&i.clone(n,o),T>l.x&&i.clone(n,l),A<a.y&&i.clone(n,a),A>u.y&&i.clone(n,u),D<s.z&&i.clone(n,s),D>c.z&&i.clone(n,c)}var P=i.magnitudeSquared(i.subtract(l,o,_)),M=i.magnitudeSquared(i.subtract(u,a,_)),I=i.magnitudeSquared(i.subtract(c,s,_)),O=o,R=l,L=P;M>L&&(L=M,O=a,R=u),I>L&&(L=I,O=s,R=c);var z=w;z.x=.5*(O.x+R.x),z.y=.5*(O.y+R.y),z.z=.5*(O.z+R.z);var N=i.magnitudeSquared(i.subtract(R,z,_)),B=Math.sqrt(N),F=C;F.x=o.x,F.y=a.y,F.z=s.z;var V=x;V.x=l.x,V.y=u.y,V.z=c.z;var k=i.multiplyByScalar(i.add(F,V,_),.5,S),U=0;for(b=0;E>b;b++){i.clone(e[b],n);var W=i.magnitude(i.subtract(n,k,_));W>U&&(U=W);var q=i.magnitudeSquared(i.subtract(n,z,_));if(q>N){var G=Math.sqrt(q);B=.5*(B+G),N=B*B;var H=G-B;z.x=(B*z.x+H*n.x)/G,z.y=(B*z.y+H*n.y)/G,z.z=(B*z.z+H*n.z)/G}}return U>B?(i.clone(z,r.center),r.radius=B):(i.clone(k,r.center),r.radius=U),r};var E=new s,b=new i,T=new i,A=new o,D=new o;h.fromExtent2D=function(e,t,r){return h.fromExtentWithHeights2D(e,t,0,0,r)},h.fromExtentWithHeights2D=function(r,n,o,a,s){if(t(s)||(s=new h),!t(r))return s.center=i.clone(i.ZERO,s.center),s.radius=0,s;n=e(n,E),r.getSouthwest(A),A.height=o,r.getNortheast(D),D.height=a;var l=n.project(A,b),u=n.project(D,T),c=u.x-l.x,d=u.y-l.y,m=u.z-l.z;s.radius=.5*Math.sqrt(c*c+d*d+m*m);var p=s.center;return p.x=l.x+.5*c,p.y=l.y+.5*d,p.z=l.z+.5*m,s};var P=[];h.fromExtent3D=function(r,i,n,o){i=e(i,a.WGS84),n=e(n,0);var s;return t(r)&&(s=r.subsample(i,n,P)),h.fromPoints(s,o)},h.fromVertices=function(r,n,o,a){if(t(a)||(a=new h),!t(r)||0===r.length)return a.center=i.clone(i.ZERO,a.center),a.radius=0,a;n=e(n,i.ZERO),o=e(o,3);var s=g;s.x=r[0]+n.x,s.y=r[1]+n.y,s.z=r[2]+n.z;for(var l=i.clone(s,d),u=i.clone(s,m),c=i.clone(s,p),E=i.clone(s,f),b=i.clone(s,v),T=i.clone(s,y),A=r.length,D=0;A>D;D+=o){var P=r[D]+n.x,M=r[D+1]+n.y,I=r[D+2]+n.z;s.x=P,s.y=M,s.z=I,P<l.x&&i.clone(s,l),P>E.x&&i.clone(s,E),M<u.y&&i.clone(s,u),M>b.y&&i.clone(s,b),I<c.z&&i.clone(s,c),I>T.z&&i.clone(s,T)}var O=i.magnitudeSquared(i.subtract(E,l,_)),R=i.magnitudeSquared(i.subtract(b,u,_)),L=i.magnitudeSquared(i.subtract(T,c,_)),z=l,N=E,B=O;R>B&&(B=R,z=u,N=b),L>B&&(B=L,z=c,N=T);var F=w;F.x=.5*(z.x+N.x),F.y=.5*(z.y+N.y),F.z=.5*(z.z+N.z);var V=i.magnitudeSquared(i.subtract(N,F,_)),k=Math.sqrt(V),U=C;U.x=l.x,U.y=u.y,U.z=c.z;var W=x;W.x=E.x,W.y=b.y,W.z=T.z;var q=i.multiplyByScalar(i.add(U,W,_),.5,S),G=0;for(D=0;A>D;D+=o){s.x=r[D]+n.x,s.y=r[D+1]+n.y,s.z=r[D+2]+n.z;var H=i.magnitude(i.subtract(s,q,_));H>G&&(G=H);var j=i.magnitudeSquared(i.subtract(s,F,_));if(j>V){var Y=Math.sqrt(j);k=.5*(k+Y),V=k*k;var X=Y-k;F.x=(k*F.x+X*s.x)/Y,F.y=(k*F.y+X*s.y)/Y,F.z=(k*F.z+X*s.z)/Y}}return G>k?(i.clone(F,a.center),a.radius=k):(i.clone(q,a.center),a.radius=G),a},h.fromCornerPoints=function(e,r,n){t(n)||(n=new h);var o=n.center;return i.add(e,r,o),i.multiplyByScalar(o,.5,o),n.radius=i.distance(o,r),n},h.fromEllipsoid=function(e,r){return t(r)||(r=new h),i.clone(i.ZERO,r.center),r.radius=e.getMaximumRadius(),r},h.clone=function(e,r){return t(e)?t(r)?(r.center=i.clone(e.center,r.center),r.radius=e.radius,r):new h(e.center,e.radius):void 0};var M=new i,I=new i;h.union=function(e,r,n){t(n)||(n=new h);var o=e.center,a=r.center;i.add(o,a,I);var s=i.multiplyByScalar(I,.5,I),l=i.magnitude(i.subtract(o,s,M))+e.radius,u=i.magnitude(i.subtract(a,s,M))+r.radius;return n.radius=Math.max(l,u),i.clone(s,n.center),n};var O=new i;h.expand=function(e,t,r){r=h.clone(e,r);var n=i.magnitude(i.subtract(t,r.center,O));return n>r.radius&&(r.radius=n),r},h.intersect=function(e,t){var r=e.center,n=e.radius,o=i.dot(t,r)+t.w;return-n>o?l.OUTSIDE:n>o?l.INTERSECTING:l.INSIDE};var R=new i;h.transform=function(e,r,n){return t(n)||(n=new h),n.center=c.multiplyByPoint(r,e.center,n.center),n.radius=Math.max(i.magnitude(c.getColumn(r,0,R)),i.magnitude(c.getColumn(r,1,R)),i.magnitude(c.getColumn(r,2,R)))*e.radius,n},h.transformWithoutScale=function(e,r,i){return t(i)||(i=new h),i.center=c.multiplyByPoint(r,e.center,i.center),i.radius=e.radius,i};var L=new i;h.getPlaneDistances=function(e,r,n,o){t(o)||(o=new u);var a=i.subtract(e.center,r,L),s=i.multiplyByScalar(n,i.dot(n,a),L),l=i.magnitude(s);return o.start=l-e.radius,o.stop=l+e.radius,o};for(var z=new i,N=new i,B=new i,F=new i,V=new i,k=new o,U=new Array(8),W=0;8>W;++W)U[W]=new i;var q=new s;return h.projectTo2D=function(t,r,n){r=e(r,q);var o=r.getEllipsoid(),a=t.center,s=t.radius,l=o.geodeticSurfaceNormal(a,z),u=i.cross(i.UNIT_Z,l,N);i.normalize(u,u);var c=i.cross(l,u,B);i.normalize(c,c),i.multiplyByScalar(l,s,l),i.multiplyByScalar(c,s,c),i.multiplyByScalar(u,s,u);var d=i.negate(c,V),m=i.negate(u,F),p=U,f=p[0];i.add(l,c,f),i.add(f,u,f),f=p[1],i.add(l,c,f),i.add(f,m,f),f=p[2],i.add(l,d,f),i.add(f,m,f),f=p[3],i.add(l,d,f),i.add(f,u,f),i.negate(l,l),f=p[4],i.add(l,c,f),i.add(f,u,f),f=p[5],i.add(l,c,f),i.add(f,m,f),f=p[6],i.add(l,d,f),i.add(f,m,f),f=p[7],i.add(l,d,f),i.add(f,u,f);for(var v=p.length,y=0;v>y;++y){var g=p[y];i.add(a,g,g);var _=o.cartesianToCartographic(g,k);r.project(_,g)}n=h.fromPoints(p,n),a=n.center;var w=a.x,C=a.y,x=a.z;return a.x=x,a.y=w,a.z=C,n},h.equals=function(e,r){return e===r||t(e)&&t(r)&&i.equals(e.center,r.center)&&e.radius===r.radius},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.union=function(e,t){return h.union(this,e,t)},h.prototype.expand=function(e,t){return h.expand(this,e,t)},h.prototype.intersect=function(e){return h.intersect(this,e)},h.prototype.getPlaneDistances=function(e,t,r){return h.getPlaneDistances(this,e,t,r)},h.prototype.projectTo2D=function(e,t){return h.projectTo2D(this,e,t)},h.prototype.equals=function(e){return h.equals(this,e)},h}),r("Core/Fullscreen",["./defined"],function(e){"use strict";var t,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return i.supportsFullscreen=function(){if(e(t))return t;t=!1;var i=document.body;if("function"==typeof i.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",t=!0;for(var n,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var l=o[a];n=l+"RequestFullscreen","function"==typeof i[n]?(r.requestFullscreen=n,t=!0):(n=l+"RequestFullScreen","function"==typeof i[n]&&(r.requestFullscreen=n,t=!0)),n=l+"ExitFullscreen","function"==typeof document[n]?r.exitFullscreen=n:(n=l+"CancelFullScreen","function"==typeof document[n]&&(r.exitFullscreen=n)),n=l+"FullscreenEnabled",e(document[n])?r.fullscreenEnabled=n:(n=l+"FullScreenEnabled",e(document[n])&&(r.fullscreenEnabled=n)),n=l+"FullscreenElement",e(document[n])?r.fullscreenElement=n:(n=l+"FullScreenElement",e(document[n])&&(r.fullscreenElement=n)),n=l+"fullscreenchange",e(document["on"+n])&&("ms"===l&&(n="MSFullscreenChange"),r.fullscreenchange=n),n=l+"fullscreenerror",e(document["on"+n])&&("ms"===l&&(n="MSFullscreenError"),r.fullscreenerror=n)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[r.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[r.exitFullscreen]()},i.isFullscreenEnabled=function(){return i.supportsFullscreen()?document[r.fullscreenEnabled]:void 0},i.getFullscreenElement=function(){return i.supportsFullscreen()?document[r.fullscreenElement]:void 0},i.isFullscreen=function(){return i.supportsFullscreen()?null!==i.getFullscreenElement():void 0},i.getFullscreenChangeEventName=function(){return i.supportsFullscreen()?r.fullscreenchange:void 0},i.getFullscreenErrorEventName=function(){return i.supportsFullscreen()?r.fullscreenerror:void 0},i}),r("Core/FeatureDetection",["./defined","./Fullscreen"],function(e,t){"use strict";function r(e){for(var t=e.split("."),r=0,i=t.length;i>r;++r)t[r]=parseInt(t[r],10);return t}function i(){if(!e(h)){var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===t?h=!1:(h=!0,d=r(t[1]))}return h}function n(){return i()&&d}function o(){if(!e(m))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))m=!1;else{var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===t?m=!1:(m=!0,p=r(t[1]))}return m}function a(){return o()&&p}function s(){if(!e(f)){var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===t?f=!1:(f=!0,v=r(t[1]),v.isNightly=!!t[2])}return f}function l(){return s()&&v}function u(){if(!e(y)){var t=/ MSIE ([\.0-9]+)/.exec(navigator.userAgent);null===t?y=!1:(y=!0,g=r(t[1]))}return y}function c(){return u()&&g}var h,d,m,p,f,v,y,g,_,w={isChrome:i,chromeVersion:n,isSafari:o,safariVersion:a,isWebkit:s,webkitVersion:l,isInternetExplorer:u,internetExplorerVersion:c};return w.supportsCrossOriginImagery=function(){return e(_)||(_=o()&&l()[0]<536?!1:"withCredentials"in new XMLHttpRequest),_},w.supportsFullscreen=function(){return t.supportsFullscreen()},w.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},w}),r("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./Enumeration"],function(e,t,r,i,n){"use strict";if(!i.supportsTypedArrays())return{};var o={BYTE:new n(5120,"BYTE",{sizeInBytes:Int8Array.BYTES_PER_ELEMENT}),UNSIGNED_BYTE:new n(5121,"UNSIGNED_BYTE",{sizeInBytes:Uint8Array.BYTES_PER_ELEMENT}),SHORT:new n(5122,"SHORT",{sizeInBytes:Int16Array.BYTES_PER_ELEMENT}),UNSIGNED_SHORT:new n(5123,"UNSIGNED_SHORT",{sizeInBytes:Uint16Array.BYTES_PER_ELEMENT}),FLOAT:new n(5126,"FLOAT",{sizeInBytes:Float32Array.BYTES_PER_ELEMENT}),DOUBLE:new n(5130,"DOUBLE",{sizeInBytes:Float64Array.BYTES_PER_ELEMENT})};return o.validate=function(e){return t(e)&&t(e.value)&&(e.value===o.BYTE.value||e.value===o.UNSIGNED_BYTE.value||e.value===o.SHORT.value||e.value===o.UNSIGNED_SHORT.value||e.value===o.FLOAT.value||e.value===o.DOUBLE.value)},o.createTypedArray=function(e,i){if(!t(e))throw new r("componentDatatype is required.");if(!t(i))throw new r("valuesOrLength is required.");switch(e.value){case o.BYTE.value:return new Int8Array(i);case o.UNSIGNED_BYTE.value:return new Uint8Array(i);case o.SHORT.value:return new Int16Array(i);case o.UNSIGNED_SHORT.value:return new Uint16Array(i);case o.FLOAT.value:return new Float32Array(i);case o.DOUBLE.value:return new Float64Array(i);default:throw new r("componentDatatype is not a valid enumeration value.")}},o.createArrayBufferView=function(i,n,a,s){if(!t(i))throw new r("componentDatatype is required.");if(!t(n))throw new r("buffer is required.");switch(a=e(a,0),s=e(s,(n.byteLength-a)/i.sizeInBytes),i.value){case o.BYTE.value:return new Int8Array(n,a,s);case o.UNSIGNED_BYTE.value:return new Uint8Array(n,a,s);case o.SHORT.value:return new Int16Array(n,a,s);case o.UNSIGNED_SHORT.value:return new Uint16Array(n,a,s);case o.FLOAT.value:return new Float32Array(n,a,s);case o.DOUBLE.value:return new Float64Array(n,a,s);default:throw new r("componentDatatype is not a valid enumeration value.")}},o}),r("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(t){return t===e.POINTS||t===e.LINES||t===e.LINE_LOOP||t===e.LINE_STRIP||t===e.TRIANGLES||t===e.TRIANGLE_STRIP||t===e.TRIANGLE_FAN}};return e}),r("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(i.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(i.componentsPerAttribute<1||i.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(i.values))throw new r("options.values is required.");this.componentDatatype=i.componentDatatype,this.componentsPerAttribute=i.componentsPerAttribute,this.normalize=e(i.normalize,!1),this.values=i.values};return i}),r("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),r("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,t){"use strict";var r=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1)};return r.POSITION_ONLY=t(new r({position:!0})),r.POSITION_AND_NORMAL=t(new r({position:!0,normal:!0})),r.POSITION_NORMAL_AND_ST=t(new r({position:!0,normal:!0,st:!0})),r.POSITION_AND_ST=t(new r({position:!0,st:!0})),r.ALL=t(new r({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),r.DEFAULT=r.POSITION_NORMAL_AND_ST,r}),r("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./BoundingSphere"],function(e,t,r){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.attributes))throw new r("options.attributes is required.");if(!t(i.primitiveType))throw new r("options.primitiveType is required.");this.attributes=i.attributes,this.indices=i.indices,this.primitiveType=i.primitiveType,this.boundingSphere=i.boundingSphere};return i.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var i=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&t(e.attributes[n])&&t(e.attributes[n].values)){var o=e.attributes[n],a=o.values.length/o.componentsPerAttribute;if(i!==a&&-1!==i)throw new r("All attribute lists must have the same number of attributes.");i=a}return i},i}),r("Core/BoxGeometry",["./defined","./DeveloperError","./Cartesian3","./ComponentDatatype","./PrimitiveType","./defaultValue","./BoundingSphere","./GeometryAttribute","./GeometryAttributes","./VertexFormat","./Geometry"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";var h=new r,d=function(i){i=o(i,o.EMPTY_OBJECT);var n=i.minimumCorner,a=i.maximumCorner;if(!e(n))throw new t("options.minimumCorner is required.");if(!e(a))throw new t("options.maximumCorner is required");var s=o(i.vertexFormat,u.DEFAULT);this._minimumCorner=r.clone(n),this._maximumCorner=r.clone(a),this._vertexFormat=s,this._workerName="createBoxGeometry"};return d.fromDimensions=function(i){i=o(i,o.EMPTY_OBJECT);var n=i.dimensions;if(!e(n))throw new t("options.dimensions is required.");if(n.x<0||n.y<0||n.z<0)throw new t("All dimensions components must be greater than or equal to zero.");var a=r.multiplyByScalar(n,.5),s=r.negate(a),l=a,u={minimumCorner:s,maximumCorner:l,vertexFormat:i.vertexFormat};return new d(u)},d.createGeometry=function(e){var t,o,u=e._minimumCorner,d=e._maximumCorner,m=e._vertexFormat,p=new l;if(m.position&&(m.st||m.normal||m.binormal||m.tangent)){if(m.position&&(o=new Float64Array(72),o[0]=u.x,o[1]=u.y,o[2]=d.z,o[3]=d.x,o[4]=u.y,o[5]=d.z,o[6]=d.x,o[7]=d.y,o[8]=d.z,o[9]=u.x,o[10]=d.y,o[11]=d.z,o[12]=u.x,o[13]=u.y,o[14]=u.z,o[15]=d.x,o[16]=u.y,o[17]=u.z,o[18]=d.x,o[19]=d.y,o[20]=u.z,o[21]=u.x,o[22]=d.y,o[23]=u.z,o[24]=d.x,o[25]=u.y,o[26]=u.z,o[27]=d.x,o[28]=d.y,o[29]=u.z,o[30]=d.x,o[31]=d.y,o[32]=d.z,o[33]=d.x,o[34]=u.y,o[35]=d.z,o[36]=u.x,o[37]=u.y,o[38]=u.z,o[39]=u.x,o[40]=d.y,o[41]=u.z,o[42]=u.x,o[43]=d.y,o[44]=d.z,o[45]=u.x,o[46]=u.y,o[47]=d.z,o[48]=u.x,o[49]=d.y,o[50]=u.z,o[51]=d.x,o[52]=d.y,o[53]=u.z,o[54]=d.x,o[55]=d.y,o[56]=d.z,o[57]=u.x,o[58]=d.y,o[59]=d.z,o[60]=u.x,o[61]=u.y,o[62]=u.z,o[63]=d.x,o[64]=u.y,o[65]=u.z,o[66]=d.x,o[67]=u.y,o[68]=d.z,o[69]=u.x,o[70]=u.y,o[71]=d.z,p.position=new s({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:o})),m.normal){var f=new Float32Array(72);
f[0]=0,f[1]=0,f[2]=1,f[3]=0,f[4]=0,f[5]=1,f[6]=0,f[7]=0,f[8]=1,f[9]=0,f[10]=0,f[11]=1,f[12]=0,f[13]=0,f[14]=-1,f[15]=0,f[16]=0,f[17]=-1,f[18]=0,f[19]=0,f[20]=-1,f[21]=0,f[22]=0,f[23]=-1,f[24]=1,f[25]=0,f[26]=0,f[27]=1,f[28]=0,f[29]=0,f[30]=1,f[31]=0,f[32]=0,f[33]=1,f[34]=0,f[35]=0,f[36]=-1,f[37]=0,f[38]=0,f[39]=-1,f[40]=0,f[41]=0,f[42]=-1,f[43]=0,f[44]=0,f[45]=-1,f[46]=0,f[47]=0,f[48]=0,f[49]=1,f[50]=0,f[51]=0,f[52]=1,f[53]=0,f[54]=0,f[55]=1,f[56]=0,f[57]=0,f[58]=1,f[59]=0,f[60]=0,f[61]=-1,f[62]=0,f[63]=0,f[64]=-1,f[65]=0,f[66]=0,f[67]=-1,f[68]=0,f[69]=0,f[70]=-1,f[71]=0,p.normal=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:f})}if(m.st){var v=new Float32Array(48);v[0]=0,v[1]=0,v[2]=1,v[3]=0,v[4]=1,v[5]=1,v[6]=0,v[7]=1,v[8]=1,v[9]=0,v[10]=0,v[11]=0,v[12]=0,v[13]=1,v[14]=1,v[15]=1,v[16]=0,v[17]=0,v[18]=1,v[19]=0,v[20]=1,v[21]=1,v[22]=0,v[23]=1,v[24]=1,v[25]=0,v[26]=0,v[27]=0,v[28]=0,v[29]=1,v[30]=1,v[31]=1,v[32]=1,v[33]=0,v[34]=0,v[35]=0,v[36]=0,v[37]=1,v[38]=1,v[39]=1,v[40]=0,v[41]=0,v[42]=1,v[43]=0,v[44]=1,v[45]=1,v[46]=0,v[47]=1,p.st=new s({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:v})}if(m.tangent){var y=new Float32Array(72);y[0]=1,y[1]=0,y[2]=0,y[3]=1,y[4]=0,y[5]=0,y[6]=1,y[7]=0,y[8]=0,y[9]=1,y[10]=0,y[11]=0,y[12]=-1,y[13]=0,y[14]=0,y[15]=-1,y[16]=0,y[17]=0,y[18]=-1,y[19]=0,y[20]=0,y[21]=-1,y[22]=0,y[23]=0,y[24]=0,y[25]=1,y[26]=0,y[27]=0,y[28]=1,y[29]=0,y[30]=0,y[31]=1,y[32]=0,y[33]=0,y[34]=1,y[35]=0,y[36]=0,y[37]=-1,y[38]=0,y[39]=0,y[40]=-1,y[41]=0,y[42]=0,y[43]=-1,y[44]=0,y[45]=0,y[46]=-1,y[47]=0,y[48]=-1,y[49]=0,y[50]=0,y[51]=-1,y[52]=0,y[53]=0,y[54]=-1,y[55]=0,y[56]=0,y[57]=-1,y[58]=0,y[59]=0,y[60]=1,y[61]=0,y[62]=0,y[63]=1,y[64]=0,y[65]=0,y[66]=1,y[67]=0,y[68]=0,y[69]=1,y[70]=0,y[71]=0,p.tangent=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:y})}if(m.binormal){var g=new Float32Array(72);g[0]=0,g[1]=1,g[2]=0,g[3]=0,g[4]=1,g[5]=0,g[6]=0,g[7]=1,g[8]=0,g[9]=0,g[10]=1,g[11]=0,g[12]=0,g[13]=1,g[14]=0,g[15]=0,g[16]=1,g[17]=0,g[18]=0,g[19]=1,g[20]=0,g[21]=0,g[22]=1,g[23]=0,g[24]=0,g[25]=0,g[26]=1,g[27]=0,g[28]=0,g[29]=1,g[30]=0,g[31]=0,g[32]=1,g[33]=0,g[34]=0,g[35]=1,g[36]=0,g[37]=0,g[38]=1,g[39]=0,g[40]=0,g[41]=1,g[42]=0,g[43]=0,g[44]=1,g[45]=0,g[46]=0,g[47]=1,g[48]=0,g[49]=0,g[50]=1,g[51]=0,g[52]=0,g[53]=1,g[54]=0,g[55]=0,g[56]=1,g[57]=0,g[58]=0,g[59]=1,g[60]=0,g[61]=0,g[62]=1,g[63]=0,g[64]=0,g[65]=1,g[66]=0,g[67]=0,g[68]=1,g[69]=0,g[70]=0,g[71]=1,p.binormal=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:g})}t=new Uint16Array(36),t[0]=0,t[1]=1,t[2]=2,t[3]=0,t[4]=2,t[5]=3,t[6]=6,t[7]=5,t[8]=4,t[9]=7,t[10]=6,t[11]=4,t[12]=8,t[13]=9,t[14]=10,t[15]=8,t[16]=10,t[17]=11,t[18]=14,t[19]=13,t[20]=12,t[21]=15,t[22]=14,t[23]=12,t[24]=18,t[25]=17,t[26]=16,t[27]=19,t[28]=18,t[29]=16,t[30]=20,t[31]=21,t[32]=22,t[33]=20,t[34]=22,t[35]=23}else o=new Float64Array(24),o[0]=u.x,o[1]=u.y,o[2]=u.z,o[3]=d.x,o[4]=u.y,o[5]=u.z,o[6]=d.x,o[7]=d.y,o[8]=u.z,o[9]=u.x,o[10]=d.y,o[11]=u.z,o[12]=u.x,o[13]=u.y,o[14]=d.z,o[15]=d.x,o[16]=u.y,o[17]=d.z,o[18]=d.x,o[19]=d.y,o[20]=d.z,o[21]=u.x,o[22]=d.y,o[23]=d.z,p.position=new s({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:o}),t=new Uint16Array(36),t[0]=4,t[1]=5,t[2]=6,t[3]=4,t[4]=6,t[5]=7,t[6]=1,t[7]=0,t[8]=3,t[9]=1,t[10]=3,t[11]=2,t[12]=1,t[13]=6,t[14]=5,t[15]=1,t[16]=2,t[17]=6,t[18]=2,t[19]=3,t[20]=7,t[21]=2,t[22]=7,t[23]=6,t[24]=3,t[25]=0,t[26]=4,t[27]=3,t[28]=4,t[29]=7,t[30]=0,t[31]=1,t[32]=5,t[33]=0,t[34]=5,t[35]=4;var _=r.subtract(d,u,h),w=.5*r.magnitude(_);return new c({attributes:p,indices:t,primitiveType:n.TRIANGLES,boundingSphere:new a(r.ZERO,w)})},d}),r("Core/BoxOutlineGeometry",["./defined","./DeveloperError","./Cartesian3","./ComponentDatatype","./PrimitiveType","./defaultValue","./BoundingSphere","./Geometry","./GeometryAttribute","./GeometryAttributes"],function(e,t,r,i,n,o,a,s,l,u){"use strict";var c=new r,h=function(i){i=o(i,o.EMPTY_OBJECT);var n=i.minimumCorner,a=i.maximumCorner;if(!e(n))throw new t("options.minimumCorner is required.");if(!e(a))throw new t("options.maximumCorner is required");this._min=r.clone(n),this._max=r.clone(a),this._workerName="createBoxOutlineGeometry"};return h.fromDimensions=function(i){i=o(i,o.EMPTY_OBJECT);var n=i.dimensions;if(!e(n))throw new t("options.dimensions is required.");if(n.x<0||n.y<0||n.z<0)throw new t("All dimensions components must be greater than or equal to zero.");var a=r.multiplyByScalar(n,.5),s=r.negate(a),l=a,u={minimumCorner:s,maximumCorner:l};return new h(u)},h.createGeometry=function(e){var t=e._min,o=e._max,h=new u,d=new Uint16Array(24),m=new Float64Array(24);m[0]=t.x,m[1]=t.y,m[2]=t.z,m[3]=o.x,m[4]=t.y,m[5]=t.z,m[6]=o.x,m[7]=o.y,m[8]=t.z,m[9]=t.x,m[10]=o.y,m[11]=t.z,m[12]=t.x,m[13]=t.y,m[14]=o.z,m[15]=o.x,m[16]=t.y,m[17]=o.z,m[18]=o.x,m[19]=o.y,m[20]=o.z,m[21]=t.x,m[22]=o.y,m[23]=o.z,h.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:m}),d[0]=4,d[1]=5,d[2]=5,d[3]=6,d[4]=6,d[5]=7,d[6]=7,d[7]=4,d[8]=0,d[9]=1,d[10]=1,d[11]=2,d[12]=2,d[13]=3,d[14]=3,d[15]=0,d[16]=0,d[17]=4,d[18]=1,d[19]=5,d[20]=2,d[21]=6,d[22]=3,d[23]=7;var p=r.subtract(o,t,c),f=.5*r.magnitude(p);return new s({attributes:h,indices:d,primitiveType:n.LINES,boundingSphere:new a(r.ZERO,f)})},h}),r("Core/Spline",["../Core/defaultValue","../Core/defined","../Core/DeveloperError"],function(e,t,r){"use strict";var i=function(){throw this.times=void 0,this.points=void 0,new r("This type should not be instantiated directly.")};return i.prototype.evaluate=function(){throw new r("This type should not be instantiated directly.")},i.prototype.findTimeInterval=function(i,n){if(!t(i))throw new r("time is required.");var o=this.times,a=o.length;if(i<o[0]||i>o[a-1])throw new r("time is out of range.");if(n=e(n,0),i>=o[n]){if(a>n+1&&i<o[n+1])return n;if(a>n+2&&i<o[n+2])return n+1}else if(n-1>=0&&i>=o[n-1])return n-1;var s;if(i>o[n])for(s=n;a-1>s&&!(i>=o[s]&&i<o[s+1]);++s);else for(s=n-1;s>=0&&!(i>=o[s]&&i<o[s+1]);--s);return s===a-1&&(s=a-2),s},i}),r("Core/TridiagonalSystemSolver",["./defined","./DeveloperError","./Cartesian3"],function(e,t,r){"use strict";var i={};return i.solve=function(i,n,o,a){if(!(e(i)&&i instanceof Array))throw new t("The array lower is required.");if(!(e(n)&&n instanceof Array))throw new t("The array diagonal is required.");if(!(e(o)&&o instanceof Array))throw new t("The array upper is required.");if(!(e(a)&&a instanceof Array))throw new t("The array right is required.");if(n.length!==a.length)throw new t("diagonal and right must have the same lengths.");if(i.length!==o.length)throw new t("lower and upper must have the same lengths.");if(i.length!==n.length-1)throw new t("lower and upper must be one less than the length of diagonal.");var s=[],l=[],u=[];s.length=o.length,l.length=u.length=a.length,s[0]=o[0]/n[0],l[0]=r.multiplyByScalar(a[0],1/n[0]);for(var c,h=1;h<s.length;++h)c=1/(n[h]-s[h-1]*i[h-1]),s[h]=o[h]*c,l[h]=r.subtract(a[h],r.multiplyByScalar(l[h-1],i[h-1])),l[h]=r.multiplyByScalar(l[h],c);for(c=1/(n[h]-s[h-1]*i[h-1]),l[h]=r.subtract(a[h],r.multiplyByScalar(l[h-1],i[h-1])),l[h]=r.multiplyByScalar(l[h],c),u[u.length-1]=l[l.length-1],h=u.length-2;h>=0;--h)u[h]=r.subtract(l[h],r.multiplyByScalar(u[h+1],s[h]));return u},i}),r("Core/HermiteSpline",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Matrix4","./Cartesian4","./Spline","./TridiagonalSystemSolver"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,r,n){var o=h,a=m,l=d,u=p;o.length=a.length=e.length-1,l.length=u.length=e.length;var c;o[0]=l[0]=1,a[0]=0;var f=u[0];for(t(f)||(f=u[0]=new i),i.clone(r,f),c=1;c<o.length-1;++c)o[c]=a[c]=1,l[c]=4,f=u[c],t(f)||(f=u[c]=new i),i.subtract(e[c+1],e[c-1],f),i.multiplyByScalar(f,3,f);return o[c]=0,a[c]=1,l[c]=4,f=u[c],t(f)||(f=u[c]=new i),i.subtract(e[c+1],e[c-1],f),i.multiplyByScalar(f,3,f),l[c+1]=1,f=u[c+1],t(f)||(f=u[c+1]=new i),i.clone(n,f),s.solve(o,l,a,u)}function u(e){var r=h,n=m,o=d,a=p;r.length=n.length=e.length-1,o.length=a.length=e.length;var l;r[0]=n[0]=1,o[0]=2;var u=a[0];for(t(u)||(u=a[0]=new i),i.subtract(e[1],e[0],u),i.multiplyByScalar(u,3,u),l=1;l<r.length;++l)r[l]=n[l]=1,o[l]=4,u=a[l],t(u)||(u=a[l]=new i),i.subtract(e[l+1],e[l-1],u),i.multiplyByScalar(u,3,u);return o[l]=2,u=a[l],t(u)||(u=a[l]=new i),i.subtract(e[l],e[l-1],u),i.multiplyByScalar(u,3,u),s.solve(r,o,n,a)}function c(e){var t=e.points,r=e.times;if(t.length<3){var o=r[0],a=1/(r[1]-o),s=t[0],l=t[1];return function(e,t){var r=(e-o)*a;return i.lerp(s,l,r,t)}}var u=e.tangents;return function(o,a){var s=e._lastTimeIndex=e.findTimeInterval(o,e._lastTimeIndex),l=(o-r[s])/(r[s+1]-r[s]),c=f;c.z=l,c.y=l*l,c.x=c.y*l,c.w=1;var h=n.multiplyByVector(y.hermiteCoefficientMatrix,c,c);return a=i.multiplyByScalar(t[s],h.x,a),i.multiplyByScalar(t[s+1],h.y,v),i.add(a,v,a),i.multiplyByScalar(u[s],h.z,v),i.add(a,v,a),i.multiplyByScalar(u[s+1],h.w,v),i.add(a,v,a)}}var h=[],d=[],m=[],p=[],f=new o,v=new i,y=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.points,o=i.times,a=i.tangents,s=i.firstTangent,h=i.lastTangent;if(!t(n))throw new r("points is required.");if(n.length<2)throw new r("points.length must be greater than or equal to 2.");if(!t(o))throw new r("times is required.");if(o.length!==n.length)throw new r("times.length must be equal to points.length.");t(a)||(a=t(s)&&t(h)?l(n,s,h):u(n)),this.times=o,this.points=n,this.tangents=a,this._evaluateFunction=c(this),this._lastTimeIndex=0};return y.hermiteCoefficientMatrix=new n(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0),y.prototype.findTimeInterval=a.prototype.findTimeInterval,y.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},y}),r("Core/CatmullRomSpline",["./defaultValue","./defined","./DeveloperError","./Matrix4","./Cartesian3","./Cartesian4","./Spline","./HermiteSpline"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){var t=e.points,r=e.times;if(t.length<3){var o=r[0],a=1/(r[1]-o),l=t[0],d=t[1];return function(e,t){var r=(e-o)*a;return n.lerp(l,d,r,t)}}return function(o,a){var l=e._lastTimeIndex=e.findTimeInterval(o,e._lastTimeIndex),d=(o-r[l])/(r[l+1]-r[l]),m=u;m.z=d,m.y=d*d,m.x=m.y*d,m.w=1;var f,v,y,g,_;return 0===l?(f=t[0],v=t[1],y=e.firstTangent,g=n.subtract(t[2],f,c),n.multiplyByScalar(g,.5,g),_=i.multiplyByVector(s.hermiteCoefficientMatrix,m,m)):l===t.length-2?(f=t[l],v=t[l+1],g=e.lastTangent,y=n.subtract(v,t[l-1],c),n.multiplyByScalar(y,.5,y),_=i.multiplyByVector(s.hermiteCoefficientMatrix,m,m)):(f=t[l-1],v=t[l],y=t[l+1],g=t[l+2],_=i.multiplyByVector(p.catmullRomCoefficientMatrix,m,m)),a=n.multiplyByScalar(f,_.x,a),n.multiplyByScalar(v,_.y,h),n.add(a,h,a),n.multiplyByScalar(y,_.z,h),n.add(a,h,a),n.multiplyByScalar(g,_.w,h),n.add(a,h,a)}}var u=new o,c=new n,h=new n,d=new n,m=new n,p=function(i){i=e(i,e.EMPTY_OBJECT);var o=i.points,a=i.times,s=i.firstTangent,u=i.lastTangent;if(!t(o))throw new r("points is required.");if(o.length<2)throw new r("points.length must be greater than or equal to 2.");if(!t(a))throw new r("times is required.");if(a.length!==o.length)throw new r("times.length must be equal to points.length.");if(o.length>2&&(t(s)||(s=d,n.multiplyByScalar(o[1],2,s),n.subtract(s,o[2],s),n.subtract(s,o[0],s),n.multiplyByScalar(s,.5,s)),!t(u))){var c=o.length-1;u=m,n.multiplyByScalar(o[c-1],2,u),n.subtract(o[c],u,u),n.add(u,o[c-2],u),n.multiplyByScalar(u,.5,u)}this.times=a,this.points=o,this.firstTangent=n.clone(s),this.lastTangent=n.clone(u),this._evaluateFunction=l(this),this._lastTimeIndex=0};return p.catmullRomCoefficientMatrix=new i(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0),p.prototype.findTimeInterval=a.prototype.findTimeInterval,p.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},p}),r("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,t,r){"use strict";var i={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(i,n){if(!e(i))throw new t("numberOfVertices is required.");return i>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},i}),r("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3"],function(e,t,r,i,n,o,a){"use strict";var s,l=function(e,r,i,n){this.x=t(e,0),this.y=t(r,0),this.z=t(i,0),this.w=t(n,0)};l.fromAxisAngle=function(t,i,n){var o=i/2,a=Math.sin(o);s=e.normalize(t,s);var u=s.x*a,c=s.y*a,h=s.z*a,d=Math.cos(o);return r(n)?(n.x=u,n.y=c,n.z=h,n.w=d,n):new l(u,c,h,d)};var u=[1,2,0],c=new Array(3);l.fromRotationMatrix=function(e,t){var i,n,o,s,h,d=e[a.COLUMN0ROW0],m=e[a.COLUMN1ROW1],p=e[a.COLUMN2ROW2],f=d+m+p;if(f>0)i=Math.sqrt(f+1),h=.5*i,i=.5/i,n=(e[a.COLUMN1ROW2]-e[a.COLUMN2ROW1])*i,o=(e[a.COLUMN2ROW0]-e[a.COLUMN0ROW2])*i,s=(e[a.COLUMN0ROW1]-e[a.COLUMN1ROW0])*i;else{var v=u,y=0;m>d&&(y=1),p>d&&p>m&&(y=2);var g=v[y],_=v[g];i=Math.sqrt(e[a.getElementIndex(y,y)]-e[a.getElementIndex(g,g)]-e[a.getElementIndex(_,_)]+1);var w=c;w[y]=.5*i,i=.5/i,h=(e[a.getElementIndex(_,g)]-e[a.getElementIndex(g,_)])*i,w[g]=(e[a.getElementIndex(g,y)]+e[a.getElementIndex(y,g)])*i,w[_]=(e[a.getElementIndex(_,y)]+e[a.getElementIndex(y,_)])*i,n=-w[0],o=-w[1],s=-w[2]}return r(t)?(t.x=n,t.y=o,t.z=s,t.w=h,t):new l(n,o,s,h)};var h=new e,d=new e,m=new l,p=new l,f=new l;l.packedLength=4,l.pack=function(e,r,i){i=t(i,0),r[i++]=e.x,r[i++]=e.y,r[i++]=e.z,r[i]=e.w},l.unpack=function(e,i,n){return i=t(i,0),r(n)||(n=new l),n.x=e[i],n.y=e[i+1],n.z=e[i+2],n.w=e[i+3],n},l.packedInterpolationLength=3,l.convertPackedArrayForInterpolation=function(e,t,r,i){l.unpack(e,4*r,f),l.conjugate(f,f);for(var n=0,o=r-t+1;o>n;n++){var a=3*n;l.unpack(e,4*(t+n),m),l.multiply(m,f,m),m.w<0&&l.negate(m,m),l.getAxis(m,h);var s=l.getAngle(m);i[a]=h.x*s,i[a+1]=h.y*s,i[a+2]=h.z*s}},l.unpackInterpolationResult=function(t,i,n,o,a){r(a)||(a=new l),e.fromArray(t,0,d);var s=e.magnitude(d);return l.unpack(i,4*o,p),0===s?l.clone(l.IDENTITY,m):l.fromAxisAngle(d,s,m),l.multiply(m,p,a)},l.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new l(e.x,e.y,e.z,e.w):void 0},l.conjugate=function(e,t){return r(t)?(t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t):new l(-e.x,-e.y,-e.z,e.w)},l.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},l.magnitude=function(e){return Math.sqrt(l.magnitudeSquared(e))},l.normalize=function(e,t){var i=1/l.magnitude(e),n=e.x*i,o=e.y*i,a=e.z*i,s=e.w*i;return r(t)?(t.x=n,t.y=o,t.z=a,t.w=s,t):new l(n,o,a,s)},l.inverse=function(e,t){var r=l.magnitudeSquared(e);return t=l.conjugate(e,t),l.multiplyByScalar(t,1/r,t)},l.add=function(e,t,i){return r(i)?(i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i):new l(e.x+t.x,e.y+t.y,e.z+t.z,e.w+t.w)},l.subtract=function(e,t,i){return r(i)?(i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i):new l(e.x-t.x,e.y-t.y,e.z-t.z,e.w-t.w)},l.negate=function(e,t){return r(t)?(t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t):new l(-e.x,-e.y,-e.z,-e.w)},l.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},l.multiply=function(e,t,i){var n=e.x,o=e.y,a=e.z,s=e.w,u=t.x,c=t.y,h=t.z,d=t.w,m=s*u+n*d+o*h-a*c,p=s*c-n*h+o*d+a*u,f=s*h+n*c-o*u+a*d,v=s*d-n*u-o*c-a*h;return r(i)?(i.x=m,i.y=p,i.z=f,i.w=v,i):new l(m,p,f,v)},l.multiplyByScalar=function(e,t,i){return r(i)?(i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i):new l(e.x*t,e.y*t,e.z*t,e.w*t)},l.divideByScalar=function(e,t,i){return r(i)?(i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i):new l(e.x/t,e.y/t,e.z/t,e.w/t)},l.getAxis=function(t,i){var n=t.w;if(Math.abs(n-1)<o.EPSILON6)return r(i)?(i.x=i.y=i.z=0,i):new e;var a=1/Math.sqrt(1-n*n);return r(i)?(i.x=t.x*a,i.y=t.y*a,i.z=t.z*a,i):new e(t.x*a,t.y*a,t.z*a)},l.getAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var v;l.lerp=function(e,t,r,i){return v=l.multiplyByScalar(t,r,v),i=l.multiplyByScalar(e,1-r,i),l.add(v,i,i)};var y,g,_;l.slerp=function(e,t,r,i){var n=l.dot(e,t),a=t;if(0>n&&(n=-n,a=y=l.negate(t,y)),1-n<o.EPSILON6)return l.lerp(e,a,r,i);var s=Math.acos(n);return g=l.multiplyByScalar(e,Math.sin((1-r)*s),g),_=l.multiplyByScalar(a,Math.sin(r*s),_),i=l.add(g,_,i),l.multiplyByScalar(i,1/Math.sin(s),i)},l.log=function(t,i){var n=Math.acos(o.clamp(t.w,-1,1)),a=0;return 0!==n&&(a=n/Math.sin(n)),r(i)||(i=new e),e.multiplyByScalar(t,a,i)},new e,l.exp=function(t,i){var n=e.magnitude(t),o=0;return 0!==n&&(o=Math.sin(n)/n),r(i)||(i=new l),i.x=t.x*o,i.y=t.y*o,i.z=t.z*o,i.w=Math.cos(n),i};var w=new e,C=new e,x=new l,S=new l;return l.innerQuadrangle=function(t,r,i,n){var o=l.conjugate(r,x);l.multiply(o,i,S);var a=l.log(S,w);l.multiply(o,t,S);var s=l.log(S,C);return e.add(a,s,a),e.multiplyByScalar(a,.25,a),e.negate(a,a),l.exp(a,x),l.multiply(r,x,n)},l.squad=function(e,t,r,i,n,o){var a=l.slerp(e,t,n,x),s=l.slerp(r,i,n,S);return l.slerp(a,s,2*n*(1-n),o)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},l.equalsEpsilon=function(e,t,i){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=i&&Math.abs(e.y-t.y)<=i&&Math.abs(e.z-t.z)<=i&&Math.abs(e.w-t.w)<=i},l.ZERO=n(new l(0,0,0,0)),l.IDENTITY=n(new l(0,0,0,1)),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},l}),r("Core/EllipseGeometryLibrary",["./Cartesian3","./Ellipsoid","./Math","./Matrix3","./Quaternion"],function(e,t,r,i,n){"use strict";function o(t,r,o,a,h,d,m,p,f,v){var y=t+r;e.multiplyByScalar(a,Math.cos(y),s),e.multiplyByScalar(o,Math.sin(y),l),e.add(s,l,s);var g=Math.cos(t);g*=g;var _=Math.sin(t);_*=_;var w=d/Math.sqrt(m*g+h*_),C=w/p;return n.fromAxisAngle(s,C,u),i.fromQuaternion(u,c),i.multiplyByVector(c,f,v),e.normalize(v,v),e.multiplyByScalar(v,p,v),v}var a={},s=new e,l=new e,u=new n,c=new i,h=new e,d=new e,m=new e,p=new e;a.raisePositionsToHeight=function(t,r,i){for(var n=r.ellipsoid,o=r.height,a=r.extrudedHeight,s=i?2*(t.length/3):t.length/3,l=new Float64Array(3*s),u=p,c=t.length,f=i?c:0,v=0;c>v;v+=3){var y,g=v+1,_=v+2,w=e.fromArray(t,v,h);w=n.scaleToGeodeticSurface(w,w),y=e.clone(w,d),u=n.geodeticSurfaceNormal(w,u);var C=e.multiplyByScalar(u,o,m);w=e.add(w,C,w),i&&(C=e.multiplyByScalar(u,a,C),y=e.add(y,C,y),l[v+f]=y.x,l[g+f]=y.y,l[_+f]=y.z),l[v]=w.x,l[g]=w.y,l[_]=w.z}return l};var f=new e,v=new e,y=new e;return a.computeEllipsePositions=function(t,i,n){var a=t.semiMinorAxis,s=t.semiMajorAxis,l=t.rotation,u=t.center,c=t.granularity,p=2.31,g=a*a,_=s*s,w=s*a,C=e.magnitude(u),x=e.normalize(u,f),S=e.cross(e.UNIT_Z,u,v);S=e.normalize(S,S);var E,b,T,A,D,P=e.cross(x,S,y),M=1+Math.ceil(r.PI_OVER_TWO/c),I=p/(M-1),O=2*M*(M+1),R=i?new Array(3*O):void 0,L=0,z=h,N=d,B=n?[]:void 0,F=n?[]:void 0,V=r.PI_OVER_TWO;for(E=0;M>E&&V>0;++E){if(z=o(V,l,P,S,g,w,_,C,x,z),N=o(Math.PI-V,l,P,S,g,w,_,C,x,N),i){for(R[L++]=z.x,R[L++]=z.y,R[L++]=z.z,T=2*E+2,b=1;T-1>b;++b)A=b/(T-1),D=e.lerp(z,N,A,m),R[L++]=D.x,R[L++]=D.y,R[L++]=D.z;R[L++]=N.x,R[L++]=N.y,R[L++]=N.z}n&&(F.unshift(z.x,z.y,z.z),0!==E&&B.push(N.x,N.y,N.z)),V=r.PI_OVER_TWO-(E+1)*I}for(M=E,E=M;E>0;--E){if(V=r.PI_OVER_TWO-(E-1)*I,z=o(-V,l,P,S,g,w,_,C,x,z),N=o(V+Math.PI,l,P,S,g,w,_,C,x,N),i){for(R[L++]=z.x,R[L++]=z.y,R[L++]=z.z,T=2*(E-1)+2,b=1;T-1>b;++b)A=b/(T-1),D=e.lerp(z,N,A,m),R[L++]=D.x,R[L++]=D.y,R[L++]=D.z;R[L++]=N.x,R[L++]=N.y,R[L++]=N.z}n&&(F.unshift(z.x,z.y,z.z),1!==E&&B.push(N.x,N.y,N.z))}var k={};return i&&(R.length!==L&&(O=L/3,R.length=L),k.positions=R,k.numPts=M),n&&(k.outerPositions=F.concat(B)),k},a}),r("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,i){"use strict";var n=new t,o=new t,a=new t,s=function(s,l,u,c,h){if(!(r(s)&&r(l)&&r(u)&&r(c)))throw new i("point, p0, p1, and p2 are required.");r(h)||(h=new t);var d,m,p,f,v,y,g,_;r(l.z)?(d=t.subtract(u,l,n),m=t.subtract(c,l,o),p=t.subtract(s,l,a),f=t.dot(d,d),v=t.dot(d,m),y=t.dot(d,p),g=t.dot(m,m),_=t.dot(m,p)):(d=e.subtract(u,l,n),m=e.subtract(c,l,o),p=e.subtract(s,l,a),f=e.dot(d,d),v=e.dot(d,m),y=e.dot(d,p),g=e.dot(m,m),_=e.dot(m,p));var w=1/(f*g-v*v);return h.y=(g*y-v*_)*w,h.z=(f*_-v*y)*w,h.x=1-h.y-h.z,h};return s}),r("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};i.encode=function(e,i){if(!t(e))throw new r("value is required");t(i)||(i={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),i.high=n,i.low=e-n):(n=65536*Math.floor(-e/65536),i.high=-n,i.low=e+n),i};var n={high:0,low:0};i.fromCartesian=function(e,o){if(!t(e))throw new r("cartesian is required");t(o)||(o=new i);var a=o.high,s=o.low;return i.encode(e.x,n),a.x=n.high,s.x=n.low,i.encode(e.y,n),a.y=n.high,s.y=n.low,i.encode(e.z,n),a.z=n.high,s.z=n.low,o};var o=new i;return i.writeElements=function(e,n,a){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("cartesianArray is required");if("number"!=typeof a||0>a)throw new r("index must be a number greater than or equal to 0.");i.fromCartesian(e,o);var s=o.high,l=o.low;n[a]=s.x,n[a+1]=s.y,n[a+2]=s.z,n[a+3]=l.x,n[a+4]=l.y,n[a+5]=l.z},i}),r("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,i){var n=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<i?0:n}var i={};return i.discriminant=function(t,r,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");var n=r*r-4*t*i;return n},i.realRoots=function(i,n,o){if("number"!=typeof i)throw new e("a is a required number.");if("number"!=typeof n)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===i)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var s=Math.abs(o),l=Math.abs(i);if(l>s&&s/l<t.EPSILON14)return[0,0];if(s>l&&l/s<t.EPSILON14)return[];if(a=-o/i,0>a)return[];var u=Math.sqrt(a);return[-u,u]}if(0===o)return a=-n/i,0>a?[a,0]:[0,a];var c=n*n,h=4*i*o,d=r(c,-h,t.EPSILON14);if(0>d)return[];var m=-.5*r(n,t.sign(n)*Math.sqrt(d),t.EPSILON14);return n>0?[m/i,o/m]:[o/m,m/i]},i}),r("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,i){var n,o,a=e,s=t/3,l=r/3,u=i,c=a*l,h=s*u,d=s*s,m=l*l,p=a*l-d,f=a*u-s*l,v=s*u-m,y=4*p*v-f*f;if(0>y){var g,_,w;d*h>=c*m?(g=a,_=p,w=-2*s*p+a*f):(g=u,_=v,w=-u*f+2*l*v);var C=0>w?-1:1,x=-C*Math.abs(g)*Math.sqrt(-y);o=-w+x;var S=o/2,E=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),b=o===x?-E:-_/E;return n=0>=_?E+b:-w/(E*E+b*b+_),d*h>=c*m?[(n-s)/a]:[-u/(n+l)]}var T=p,A=-2*s*p+a*f,D=v,P=-u*f+2*l*v,M=Math.sqrt(y),I=Math.sqrt(3)/2,O=Math.abs(Math.atan2(a*M,-A)/3);n=2*Math.sqrt(-T);var R=Math.cos(O);o=n*R;var L=n*(-R/2-I*Math.sin(O)),z=o+L>2*s?o-s:L-s,N=a,B=z/N;O=Math.abs(Math.atan2(u*M,-P)/3),n=2*Math.sqrt(-D),R=Math.cos(O),o=n*R,L=n*(-R/2-I*Math.sin(O));var F=-u,V=2*l>o+L?o+l:L+l,k=F/V,U=N*V,W=-z*V-N*F,q=z*F,G=(l*W-s*q)/(-s*W+l*U);return G>=B?k>=B?k>=G?[B,G,k]:[B,k,G]:[k,B,G]:k>=B?[G,B,k]:k>=G?[G,k,B]:[k,G,B]}var i={};return i.discriminant=function(t,r,i,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");if("number"!=typeof n)throw new e("d is a required number.");var o=t*t,a=r*r,s=i*i,l=n*n,u=18*t*r*i*n+a*s-27*o*l-4*(t*s*i+a*r*n);return u},i.realRoots=function(i,n,o,a){if("number"!=typeof i)throw new e("a is a required number.");if("number"!=typeof n)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,l;if(0===i)return t.realRoots(n,o,a);if(0===n){if(0===o){if(0===a)return[0,0,0];l=-a/i;var u=0>l?-Math.pow(-l,1/3):Math.pow(l,1/3);return[u,u,u]}return 0===a?(s=t.realRoots(i,0,o),0===s.Length?[0]:[s[0],0,s[1]]):r(i,0,o,a)}return 0===o?0===a?(l=-n/i,0>l?[l,0,0]:[0,0,l]):r(i,n,0,a):0===a?(s=t.realRoots(i,n,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):r(i,n,o,a)},i}),r("Core/QuarticRealPolynomial",["./DeveloperError","./Math","./CubicRealPolynomial","./QuadraticRealPolynomial"],function(e,t,r,i){"use strict";function n(e,n,o,a){var s=e*e,l=n-3*s/8,u=o-n*e/2+s*e/8,c=a-o*e/4+n*s/16-3*s*s/256,h=r.realRoots(1,2*l,l*l-4*c,-u*u);if(h.length>0){var d=-e/4,m=h[h.length-1];if(Math.abs(m)<t.EPSILON14){var p=i.realRoots(1,l,c);if(2===p.length){var f,v=p[0],y=p[1];if(v>=0&&y>=0){var g=Math.sqrt(v),_=Math.sqrt(y);return[d-_,d-g,d+g,d+_]}if(v>=0&&0>y)return f=Math.sqrt(v),[d-f,d+f];if(0>v&&y>=0)return f=Math.sqrt(y),[d-f,d+f]}return[]}if(m>0){var w=Math.sqrt(m),C=(l+m-u/w)/2,x=(l+m+u/w)/2,S=i.realRoots(1,w,C),E=i.realRoots(1,-w,x);return 0!==S.length?(S[0]+=d,S[1]+=d,0!==E.length?(E[0]+=d,E[1]+=d,S[1]<=E[0]?[S[0],S[1],E[0],E[1]]:E[1]<=S[0]?[E[0],E[1],S[0],S[1]]:S[0]>=E[0]&&S[1]<=E[1]?[E[0],S[0],S[1],E[1]]:E[0]>=S[0]&&E[1]<=S[1]?[S[0],E[0],E[1],S[1]]:S[0]>E[0]&&S[0]<E[1]?[E[0],S[0],E[1],S[1]]:[S[0],E[0],S[1],E[1]]):S):0!==E.length?(E[0]+=d,E[1]+=d,E):[]}}return[]}function o(e,n,o,a){var s=o*o,l=n*n,u=e*e,c=-2*n,h=o*e+l-4*a,d=u*a-o*n*e+s,m=r.realRoots(1,c,h,d);if(m.length>0){var p,f,v=m[0],y=n-v,g=y*y,_=e/2,w=y/2,C=g-4*a,x=g+4*Math.abs(a),S=u-4*v,E=u+4*Math.abs(v);if(0>v||S*x>C*E){var b=Math.sqrt(S);p=b/2,f=0===b?0:(e*w-o)/b}else{var T=Math.sqrt(C);p=0===T?0:(e*w-o)/T,f=T/2}var A,D;0===_&&0===p?(A=0,D=0):t.sign(_)===t.sign(p)?(A=_+p,D=v/A):(D=_-p,A=v/D);var P,M;0===w&&0===f?(P=0,M=0):t.sign(w)===t.sign(f)?(P=w+f,M=a/P):(M=w-f,P=a/M);var I=i.realRoots(1,A,P),O=i.realRoots(1,D,M);if(0!==I.length)return 0!==O.length?I[1]<=O[0]?[I[0],I[1],O[0],O[1]]:O[1]<=I[0]?[O[0],O[1],I[0],I[1]]:I[0]>=O[0]&&I[1]<=O[1]?[O[0],I[0],I[1],O[1]]:O[0]>=I[0]&&O[1]<=I[1]?[I[0],O[0],O[1],I[1]]:I[0]>O[0]&&I[0]<O[1]?[O[0],I[0],O[1],I[1]]:[I[0],O[0],I[1],O[1]]:I;if(0!==O.length)return O}return[]}var a={};return a.discriminant=function(t,r,i,n,o){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");if("number"!=typeof n)throw new e("d is a required number.");if("number"!=typeof o)throw new e("e is a required number.");var a=t*t,s=a*t,l=r*r,u=l*r,c=i*i,h=c*i,d=n*n,m=d*n,p=o*o,f=p*o,v=l*c*d-4*u*m-4*t*h*d+18*t*r*i*m-27*a*d*d+256*s*f+o*(18*u*i*n-4*l*h+16*t*c*c-80*t*r*c*n-6*t*l*d+144*a*i*d)+p*(144*t*l*i-27*l*l-128*a*c-192*a*r*n);return v},a.realRoots=function(i,a,s,l,u){if("number"!=typeof i)throw new e("a is a required number.");if("number"!=typeof a)throw new e("b is a required number.");if("number"!=typeof s)throw new e("c is a required number.");if("number"!=typeof l)throw new e("d is a required number.");if("number"!=typeof u)throw new e("e is a required number.");if(Math.abs(i)<t.EPSILON15)return r.realRoots(a,s,l,u);var c=a/i,h=s/i,d=l/i,m=u/i,p=0>c?1:0;switch(p+=0>h?p+1:p,p+=0>d?p+1:p,p+=0>m?p+1:p){case 0:return n(c,h,d,m);case 1:return o(c,h,d,m);case 2:return o(c,h,d,m);case 3:return n(c,h,d,m);case 4:return n(c,h,d,m);case 5:return o(c,h,d,m);case 6:return n(c,h,d,m);case 7:return n(c,h,d,m);case 8:return o(c,h,d,m);case 9:return n(c,h,d,m);case 10:return n(c,h,d,m);case 11:return o(c,h,d,m);case 12:return n(c,h,d,m);case 13:return n(c,h,d,m);case 14:return n(c,h,d,m);case 15:return n(c,h,d,m);default:return void 0}},a}),r("Core/IntersectionTests",["./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,t,i){var n=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<i?0:n}function u(e,t,n,u,c){var h,d=u*u,m=c*c,p=(e[o.COLUMN1ROW1]-e[o.COLUMN2ROW2])*m,f=c*(u*l(e[o.COLUMN1ROW0],e[o.COLUMN0ROW1],r.EPSILON15)+t.y),v=e[o.COLUMN0ROW0]*d+e[o.COLUMN2ROW2]*m+u*t.x+n,y=m*l(e[o.COLUMN2ROW1],e[o.COLUMN1ROW2],r.EPSILON15),g=c*(u*l(e[o.COLUMN2ROW0],e[o.COLUMN0ROW2])+t.z),_=[];if(0===g&&0===y){if(h=a.realRoots(p,f,v),0===h.length)return _;var w=h[0],C=Math.sqrt(Math.max(1-w*w,0));if(_.push(new i(u,c*w,c*-C)),_.push(new i(u,c*w,c*C)),2===h.length){var x=h[1],S=Math.sqrt(Math.max(1-x*x,0));_.push(new i(u,c*x,c*-S)),_.push(new i(u,c*x,c*S))}return _}var E=g*g,b=y*y,T=p*p,A=g*y,D=T+b,P=2*(f*p+A),M=2*v*p+f*f-b+E,I=2*(v*f-A),O=v*v-E;if(0===D&&0===P&&0===M&&0===I)return _;h=s.realRoots(D,P,M,I,O);var R=h.length;if(0===R)return _;for(var L=0;R>L;++L){var z,N=h[L],B=N*N,F=Math.max(1-B,0),V=Math.sqrt(F);z=r.sign(p)===r.sign(v)?l(p*B+v,f*N,r.EPSILON12):r.sign(v)===r.sign(f*N)?l(p*B,f*N+v,r.EPSILON12):l(p*B+f*N,v,r.EPSILON12);var k=l(y*N,g,r.EPSILON15),U=z*k;0>U?_.push(new i(u,c*N,c*V)):U>0?_.push(new i(u,c*N,c*-V)):0!==V?(_.push(new i(u,c*N,c*-V)),_.push(new i(u,c*N,c*V)),++L):_.push(new i(u,c*N,c*V))}return _}var c={};c.rayPlane=function(n,o,a){if(!e(n))throw new t("ray is required.");if(!e(o))throw new t("plane is required.");var s=n.origin,l=n.direction,u=o.normal,c=i.dot(u,l);if(Math.abs(c)<r.EPSILON15)return void 0;var h=(-o.distance-i.dot(u,s))/c;return 0>h?void 0:(a=i.multiplyByScalar(l,h,a),i.add(s,a,a))};var h=new i,d=new i;c.rayEllipsoid=function(r,n){if(!e(r))throw new t("ray is required.");if(!e(n))throw new t("ellipsoid is required.");var o,a,s,l,u,c=n.getOneOverRadii(),m=i.multiplyComponents(c,r.origin,h),p=i.multiplyComponents(c,r.direction,d),f=i.magnitudeSquared(m),v=i.dot(m,p);if(f>1){if(v>=0)return void 0;var y=v*v;if(o=f-1,a=i.magnitudeSquared(p),s=a*o,s>y)return void 0;if(y>s){l=v*v-s,u=-v+Math.sqrt(l);var g=u/a,_=o/u;return _>g?{start:g,stop:_}:{start:_,stop:g}}var w=Math.sqrt(o/a);return{start:w,stop:w}}return 1>f?(o=f-1,a=i.magnitudeSquared(p),s=a*o,l=v*v-s,u=-v+Math.sqrt(l),{start:0,stop:u/a}):0>v?(a=i.magnitudeSquared(p),{start:0,stop:-v/a}):void 0},c.grazingAltitudeLocation=function(a,s){if(!e(a))throw new t("ray is required.");if(!e(s))throw new t("ellipsoid is required.");var l=a.origin,c=a.direction,h=s.geodeticSurfaceNormal(l);if(i.dot(c,h)>=0)return l;var d,m,p=e(this.rayEllipsoid(a,s)),f=s.transformPositionToScaledSpace(c),v=i.normalize(f),y=i.mostOrthogonalAxis(f),g=i.normalize(i.cross(y,v)),_=i.normalize(i.cross(v,g)),w=new o(v.x,g.x,_.x,v.y,g.y,_.y,v.z,g.z,_.z),C=o.transpose(w),x=o.fromScale(s.getRadii()),S=o.fromScale(s.getOneOverRadii()),E=new o(0,c.z,-c.y,-c.z,0,c.x,c.y,-c.x,0),b=o.multiply(o.multiply(C,S),E),T=o.multiply(o.multiply(b,x),w),A=o.multiplyByVector(b,l),D=u(T,i.negate(A),0,0,1),P=D.length;if(P>0){for(var M=i.ZERO,I=Number.NEGATIVE_INFINITY,O=0;P>O;++O){d=o.multiplyByVector(x,o.multiplyByVector(w,D[O]));var R=i.normalize(i.subtract(d,l)),L=i.dot(R,c);L>I&&(I=L,M=d)}var z=s.cartesianToCartographic(M);return I=r.clamp(I,0,1),m=i.magnitude(i.subtract(M,l))*Math.sqrt(1-I*I),m=p?-m:m,s.cartographicToCartesian(new n(z.longitude,z.latitude,m))}return void 0};var m=new i;return c.lineSegmentPlane=function(n,o,a,s){if(!e(n))throw new t("endPoint0 is required.");if(!e(o))throw new t("endPoint1 is required.");if(!e(a))throw new t("plane is required.");var l=i.subtract(o,n,m),u=a.normal,c=i.dot(u,l);if(Math.abs(c)<r.EPSILON6)return void 0;var h=i.dot(u,n),d=-(a.distance+h)/c;return 0>d||d>1?void 0:(e(s)||(s=new i),i.multiplyByScalar(l,d,s),i.add(n,s,s),s)},c.trianglePlaneIntersection=function(r,n,o,a){if(!(e(r)&&e(n)&&e(o)&&e(a)))throw new t("p0, p1, p2, and plane are required.");var s=a.normal,l=a.distance,u=i.dot(s,r)+l<0,h=i.dot(s,n)+l<0,d=i.dot(s,o)+l<0,m=0;m+=u?1:0,m+=h?1:0,m+=d?1:0;var p,f;if((1===m||2===m)&&(p=new i,f=new i),1===m){if(u)return c.lineSegmentPlane(r,n,a,p),c.lineSegmentPlane(r,o,a,f),{positions:[r,n,o,p,f],indices:[0,3,4,1,2,4,1,4,3]};
if(h)return c.lineSegmentPlane(n,o,a,p),c.lineSegmentPlane(n,r,a,f),{positions:[r,n,o,p,f],indices:[1,3,4,2,0,4,2,4,3]};if(d)return c.lineSegmentPlane(o,r,a,p),c.lineSegmentPlane(o,n,a,f),{positions:[r,n,o,p,f],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===m){if(!u)return c.lineSegmentPlane(n,r,a,p),c.lineSegmentPlane(o,r,a,f),{positions:[r,n,o,p,f],indices:[1,2,4,1,4,3,0,3,4]};if(!h)return c.lineSegmentPlane(o,n,a,p),c.lineSegmentPlane(r,n,a,f),{positions:[r,n,o,p,f],indices:[2,0,4,2,4,3,1,3,4]};if(!d)return c.lineSegmentPlane(r,o,a,p),c.lineSegmentPlane(n,o,a,f),{positions:[r,n,o,p,f],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},c}),r("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(i,n){if(!t(i))throw new r("normal is required.");if(!t(n))throw new r("distance is required.");this.normal=e.clone(i),this.distance=n};return i.fromPointNormal=function(n,o,a){if(!t(n))throw new r("point is required.");if(!t(o))throw new r("normal is required.");var s=-e.dot(o,n);return t(a)?(e.clone(o,a.normal),a.distance=s,a):new i(o,s)},i.getPointDistance=function(i,n){if(!t(i))throw new r("plane is required.");if(!t(n))throw new r("point is required.");return e.dot(i.normal,n)+i.distance},i.prototype.getPointDistance=function(e){return i.getPointDistance(this,e)},i}),r("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i={};return i.calculateACMR=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.indices,o=i.maximumIndex,a=e(i.cacheSize,24);if(!t(n))throw new r("indices is required.");var s=n.length;if(3>s||0!==s%3)throw new r("indices length must be a multiple of three.");if(0>=o)throw new r("maximumIndex must be greater than zero.");if(3>a)throw new r("cacheSize must be greater than two.");if(!t(o)){o=0;for(var l=0,u=n[l];s>l;)u>o&&(o=u),++l,u=n[l]}for(var c=[],h=0;o+1>h;h++)c[h]=0;for(var d=a+1,m=0;s>m;++m)d-c[n[m]]>a&&(c[n[m]]=d,++d);return(d-a+1)/(s/3)},i.tipsify=function(i){function n(e,t,r,i){for(;t.length>=1;){var n=t[t.length-1];if(t.splice(t.length-1,1),e[n].numLiveTriangles>0)return n}for(;i>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,t,r,i,o,a,s){for(var l,u=-1,c=-1,h=0;h<r.length;){var d=r[h];i[d].numLiveTriangles&&(l=0,o-i[d].timeStamp+2*i[d].numLiveTriangles<=t&&(l=o-i[d].timeStamp),(l>c||-1===c)&&(c=l,u=d)),++h}return-1===u?n(i,a,e,s):u}i=e(i,e.EMPTY_OBJECT);var a,s=i.indices,l=i.maximumIndex,u=e(i.cacheSize,24);if(!t(s))throw new r("indices is required.");var c=s.length;if(3>c||0!==c%3)throw new r("indices length must be a multiple of three.");if(0>=l)throw new r("maximumIndex must be greater than zero.");if(3>u)throw new r("cacheSize must be greater than two.");var h=0,d=0,m=s[d],p=c;if(t(l))h=l+1;else{for(;p>d;)m>h&&(h=m),++d,m=s[d];if(-1===h)return 0;++h}for(var f=[],v=0;h>v;v++)f[v]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};d=0;for(var y=0;p>d;)f[s[d]].vertexTriangles.push(y),++f[s[d]].numLiveTriangles,f[s[d+1]].vertexTriangles.push(y),++f[s[d+1]].numLiveTriangles,f[s[d+2]].vertexTriangles.push(y),++f[s[d+2]].numLiveTriangles,++y,d+=3;var g=0,_=u+1;a=1;var w,C,x=[],S=[],E=0,b=[],T=c/3,A=[];for(v=0;T>v;v++)A[v]=!1;for(var D,P;-1!==g;){x=[],C=f[g],P=C.vertexTriangles.length;for(var M=0;P>M;++M)if(y=C.vertexTriangles[M],!A[y]){A[y]=!0,d=y+y+y;for(var I=0;3>I;++I)D=s[d],x.push(D),S.push(D),b[E]=D,++E,w=f[D],--w.numLiveTriangles,_-w.timeStamp>u&&(w.timeStamp=_,++_),++d}g=o(s,u,x,f,_,S,h)}return b},i}),r("Core/GeometryPipeline",["./barycentricCoordinates","./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./EncodedCartesian3","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./GeographicProjection","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./Tipsify","./BoundingSphere","./Geometry","./GeometryAttribute"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x){"use strict";function S(e,t,r,i,n){e[t++]=r,e[t++]=i,e[t++]=i,e[t++]=n,e[t++]=n,e[t]=r}function E(e){for(var t=e.length,r=6*(t/3),i=y.createTypedArray(t,r),n=0,o=0;t>o;o+=3,n+=6)S(i,n,e[o],e[o+1],e[o+2]);return i}function b(e){var t=e.length;if(t>=3){var r=6*(t-2),i=y.createTypedArray(t,r);S(i,0,e[0],e[1],e[2]);for(var n=6,o=3;t>o;++o,n+=6)S(i,n,e[o-1],e[o],e[o-2]);return i}return new Uint16Array}function T(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),i=y.createTypedArray(t,r),n=e[0],o=0,a=1;t>a;++a,o+=6)S(i,o,n,e[a],e[a+1]);return i}return new Uint16Array}function A(e){var t={};for(var i in e)if(e.hasOwnProperty(i)&&r(e[i])&&r(e[i].values)){var n=e[i];t[i]=new x({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function D(e,t,i){for(var n in t)if(t.hasOwnProperty(n)&&r(t[n])&&r(t[n].values))for(var o=t[n],a=0;a<o.componentsPerAttribute;++a)e[n].values.push(o.values[i*o.componentsPerAttribute+a])}function P(e,t){if(r(t))for(var i=t.values,n=i.length,a=0;n>a;a+=3)o.unpack(i,a,Z),m.multiplyByPoint(e,Z,Z),o.pack(Z,i,a)}function M(e,t){if(r(t))for(var i=t.values,n=i.length,a=0;n>a;a+=3)o.unpack(i,a,Z),d.multiplyByVector(e,Z,Z),Z=o.normalize(Z,Z),o.pack(Z,i,a)}function I(e){var t,i=e.length,n={},o=e[0].geometry.attributes;for(t in o)if(o.hasOwnProperty(t)&&r(o[t])&&r(o[t].values)){for(var a=o[t],s=a.values.length,l=!0,u=1;i>u;++u){var c=e[u].geometry.attributes[t];if(!r(c)||a.componentDatatype.value!==c.componentDatatype.value||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){l=!1;break}s+=c.values.length}l&&(n[t]=new x({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:v.createTypedArray(a.componentDatatype,s)}))}return n}function O(e){if(r(e.indices))return e;var t=C.computeNumberOfVertices(e);if(3>t)throw new i("The number of vertices must be at least three.");if(0!==t%3)throw new i("The number of vertices must be a multiple of three.");for(var n=y.createTypedArray(t,t),o=0;t>o;++o)n[o]=o;return e.indices=n,e}function R(e){var t=C.computeNumberOfVertices(e);if(3>t)throw new i("The number of vertices must be at least three.");var r=y.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,o=3;t>o;++o)r[n++]=o-1,r[n++]=0,r[n++]=o;return e.indices=r,e.primitiveType=g.TRIANGLES,e}function L(e){var t=C.computeNumberOfVertices(e);if(3>t)throw new i("The number of vertices must be at least 3.");var r=y.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,o=3;t-1>o;o+=2)r[n++]=o,r[n++]=o-1,r[n++]=o+1,t>o+2&&(r[n++]=o,r[n++]=o+1,r[n++]=o+2);return e.indices=r,e.primitiveType=g.TRIANGLES,e}function z(e){if(r(e.indices))return e;var t=C.computeNumberOfVertices(e);if(2>t)throw new i("The number of vertices must be at least two.");if(0!==t%2)throw new i("The number of vertices must be a multiple of 2.");for(var n=y.createTypedArray(t,t),o=0;t>o;++o)n[o]=o;return e.indices=n,e}function N(e){var t=C.computeNumberOfVertices(e);if(2>t)throw new i("The number of vertices must be at least two.");var r=y.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,o=2;t>o;++o)r[n++]=o-1,r[n++]=o;return e.indices=r,e.primitiveType=g.LINES,e}function B(e){var t=C.computeNumberOfVertices(e);if(2>t)throw new i("The number of vertices must be at least two.");var r=y.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,o=2;t>o;++o)r[n++]=o-1,r[n++]=o;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=g.LINES,e}function F(e){switch(e.primitiveType){case g.TRIANGLE_FAN:return R(e);case g.TRIANGLE_STRIP:return L(e);case g.TRIANGLES:return O(e);case g.LINE_STRIP:return N(e);case g.LINE_LOOP:return B(e);case g.LINES:return z(e)}return e}function V(e,t){Math.abs(e.y)<h.EPSILON11&&(e.y=t?-h.EPSILON11:h.EPSILON11)}function k(e,t,r,i){o.add(e,o.multiplyByScalar(o.subtract(t,e,ot),e.y/(e.y-t.y),ot),r),o.clone(r,i),V(r,!0),V(i,!1)}function U(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;var i=e.y<0,n=t.y<0,o=r.y<0;V(e,i),V(t,n),V(r,o);var a=0;a+=i?1:0,a+=n?1:0,a+=o?1:0;var s=ct.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,i?(k(e,t,at,lt),k(e,r,st,ut),s[0]=0,s[3]=1,s[4]=2,s[6]=1):n?(k(t,r,at,lt),k(t,e,st,ut),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(k(r,e,at,lt),k(r,t,st,ut),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,i?n?o||(k(r,e,at,lt),k(r,t,st,ut),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(k(t,r,at,lt),k(t,e,st,ut),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(k(e,t,at,lt),k(e,r,st,ut),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var l=ct.positions;return l[0]=e,l[1]=t,l[2]=r,ct.length=3,(1===a||2===a)&&(l[3]=at,l[4]=st,l[5]=lt,l[6]=ut,ct.length=7),ct}function W(t,i,a,s,l,u,c,h){if(r(l)||r(u)||r(c)||r(h)){var d,m,p,f,v,y,g,_,w,C,x,S,E,b,T,A,D,P,M=s.positions,I=M[0],O=M[1],R=M[2];r(l)&&(d=o.fromArray(l,3*t),m=o.fromArray(l,3*i),p=o.fromArray(l,3*a)),r(u)&&(f=o.fromArray(u,3*t),v=o.fromArray(u,3*i),y=o.fromArray(u,3*a)),r(c)&&(g=o.fromArray(c,3*t),_=o.fromArray(c,3*i),w=o.fromArray(c,3*a)),r(h)&&(C=n.fromArray(h,2*t),x=n.fromArray(h,2*i),S=n.fromArray(h,2*a));for(var L=3;L<M.length;++L){var z=M[L],N=e(z,I,O,R);if(r(l)){E=o.multiplyByScalar(d,N.x,E),b=o.multiplyByScalar(m,N.y,b),T=o.multiplyByScalar(p,N.z,T);var B=o.add(E,b);o.add(B,T,B),o.normalize(B,B),l.push(B.x,B.y,B.z)}if(r(u)){E=o.multiplyByScalar(f,N.x,E),b=o.multiplyByScalar(v,N.y,b),T=o.multiplyByScalar(y,N.z,T);var F=o.add(E,b);o.add(F,T,F),o.normalize(F,F),u.push(F.x,F.y,F.z)}if(r(c)){E=o.multiplyByScalar(g,N.x,E),b=o.multiplyByScalar(_,N.y,b),T=o.multiplyByScalar(w,N.z,T);var V=o.add(E,b);o.add(V,T,V),o.normalize(V,V),c.push(V.x,V.y,V.z)}if(r(h)){A=n.multiplyByScalar(C,N.x,A),D=n.multiplyByScalar(x,N.y,D),P=n.multiplyByScalar(S,N.z,P);var k=n.add(A,D);n.add(k,P,k),h.push(k.x,k.y)}}}}function q(e){for(var t=e.attributes,i=t.position.values,n=r(t.normal)?t.normal.values:void 0,a=r(t.binormal)?t.binormal.values:void 0,s=r(t.tangent)?t.tangent.values:void 0,l=r(t.st)?t.st.values:void 0,u=e.indices,c=Array.prototype.slice.call(i,0),h=r(n)?Array.prototype.slice.call(n,0):void 0,d=r(a)?Array.prototype.slice.call(a,0):void 0,m=r(s)?Array.prototype.slice.call(s,0):void 0,p=r(l)?Array.prototype.slice.call(l,0):void 0,f=[],g=u.length,_=0;g>_;_+=3){var w=u[_],x=u[_+1],S=u[_+2],E=o.fromArray(i,3*w),b=o.fromArray(i,3*x),T=o.fromArray(i,3*S),A=U(E,b,T);if(r(A))if(c[3*w+1]=A.positions[0].y,c[3*x+1]=A.positions[1].y,c[3*S+1]=A.positions[2].y,A.length>3){for(var D=c.length/3,P=0;P<A.indices.length;++P){var M=A.indices[P];3>M?f.push(u[_+M]):f.push(M-3+D)}for(var I=3;I<A.positions.length;++I){var O=A.positions[I];c.push(O.x,O.y,O.z)}W(w,x,S,A,h,d,m,p)}else f.push(w,x,S);else f.push(w,x,S)}e.attributes.position.values=new Float64Array(c),r(h)&&(t.normal.values=v.createTypedArray(t.normal.componentDatatype,h)),r(d)&&(t.binormal.values=v.createTypedArray(t.binormal.componentDatatype,d)),r(m)&&(t.tangent.values=v.createTypedArray(t.tangent.componentDatatype,m)),r(p)&&(t.st.values=v.createTypedArray(t.st.componentDatatype,p));var R=C.computeNumberOfVertices(e);e.indices=y.createTypedArray(R,f)}function G(e){for(var t=e.attributes,i=t.position.values,n=e.indices,a=Array.prototype.slice.call(i,0),s=[],l=p.fromPointNormal(o.ZERO,o.UNIT_Y),u=n.length,d=0;u>d;d+=2){var m=n[d],f=n[d+1],v=o.fromArray(i,3*m),g=o.fromArray(i,3*f);if(Math.abs(v.y)<h.EPSILON6&&(v.y=v.y<0?-h.EPSILON6:h.EPSILON6,a[3*m+1]=v.y),Math.abs(g.y)<h.EPSILON6&&(g.y=g.y<0?-h.EPSILON6:h.EPSILON6,a[3*f+1]=g.y),s.push(m),v.x<0||g.x<0){var _=c.lineSegmentPlane(v,g,l);if(r(_)){var w=o.multiplyByScalar(o.UNIT_Y,5*h.EPSILON9);v.y<0&&o.negate(w,w);var x=a.length/3;s.push(x,x+1);var S=o.add(_,w);a.push(S.x,S.y,S.z),o.negate(w,w),o.add(_,w,S),a.push(S.x,S.y,S.z)}}s.push(f)}e.attributes.position.values=new Float64Array(a);var E=C.computeNumberOfVertices(e);e.indices=y.createTypedArray(E,s)}var H={};H.toWireframe=function(e){if(!r(e))throw new i("geometry is required.");var t=e.indices;if(r(t)){switch(e.primitiveType){case g.TRIANGLES:e.indices=E(t);break;case g.TRIANGLE_STRIP:e.indices=b(t);break;case g.TRIANGLE_FAN:e.indices=T(t);break;default:throw new i("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=g.LINES}return e},H.createLineSegmentsForVectors=function(e,n,o){if(!r(e))throw new i("geometry is required.");if(!r(e.attributes.position))throw new i("geometry.attributes.position is required.");if(n=t(n,"normal"),!r(e.attributes[n]))throw new i("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+n+".");o=t(o,1e4);for(var a=e.attributes.position.values,s=e.attributes[n].values,l=a.length,u=new Float64Array(2*l),c=0,h=0;l>h;h+=3)u[c++]=a[h],u[c++]=a[h+1],u[c++]=a[h+2],u[c++]=a[h]+s[h]*o,u[c++]=a[h+1]+s[h+1]*o,u[c++]=a[h+2]+s[h+2]*o;var d,m=e.boundingSphere;return r(m)&&(d=new w(m.center,m.radius+o)),new C({attributes:{position:new x({componentDatatype:v.DOUBLE,componentsPerAttribute:3,values:u})},primitiveType:g.LINES,boundingSphere:d})},H.createAttributeIndices=function(e){if(!r(e))throw new i("geometry is required.");var t,n=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],o=e.attributes,a={},s=0,l=n.length;for(t=0;l>t;++t){var u=n[t];r(o[u])&&(a[u]=s++)}for(var c in o)o.hasOwnProperty(c)&&!r(a[c])&&(a[c]=s++);return a},H.reorderForPreVertexCache=function(e){if(!r(e))throw new i("geometry is required.");var t=C.computeNumberOfVertices(e),n=e.indices;if(r(n)){for(var o=new Int32Array(t),a=0;t>a;a++)o[a]=-1;for(var s,l=n,u=l.length,c=y.createTypedArray(t,u),h=0,d=0,m=0;u>h;)s=o[l[h]],-1!==s?c[d]=s:(s=l[h],o[s]=m,c[d]=m,++m),++h,++d;e.indices=c;var p=e.attributes;for(var f in p)if(p.hasOwnProperty(f)&&r(p[f])&&r(p[f].values)){for(var g=p[f],_=g.values,w=0,x=g.componentsPerAttribute,S=v.createTypedArray(g.componentDatatype,m*x);t>w;){var E=o[w];if(-1!==E)for(a=0;x>a;a++)S[x*E+a]=_[x*w+a];++w}g.values=S}}return e},H.reorderForPostVertexCache=function(e,t){if(!r(e))throw new i("geometry is required.");var n=e.indices;if(e.primitiveType===g.TRIANGLES&&r(n)){for(var o=n.length,a=0,s=0;o>s;s++)n[s]>a&&(a=n[s]);e.indices=_.tipsify({indices:n,maximumIndex:a,cacheSize:t})}return e},H.fitToUnsignedShortIndices=function(e){if(!r(e))throw new i("geometry is required.");if(r(e.indices)&&e.primitiveType!==g.TRIANGLES&&e.primitiveType!==g.LINES&&e.primitiveType!==g.POINTS)throw new i("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],n=C.computeNumberOfVertices(e);if(r(e.indices)&&n>h.SIXTY_FOUR_KILOBYTES){var o,a=[],s=[],l=0,u=A(e.attributes),c=e.indices,d=c.length;e.primitiveType===g.TRIANGLES?o=3:e.primitiveType===g.LINES?o=2:e.primitiveType===g.POINTS&&(o=1);for(var m=0;d>m;m+=o){for(var p=0;o>p;++p){var f=c[m+p],v=a[f];r(v)||(v=l++,a[f]=v,D(u,e.attributes,f)),s.push(v)}l+o>h.SIXTY_FOUR_KILOBYTES&&(t.push(new C({attributes:u,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),a=[],s=[],l=0,u=A(e.attributes))}0!==s.length&&t.push(new C({attributes:u,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else t.push(e);return t};var j=new o,Y=new s;H.projectTo2D=function(e,t,n,a,s){if(!r(e))throw new i("geometry is required.");if(!r(t))throw new i("attributeName is required.");if(!r(n))throw new i("attributeName3D is required.");if(!r(a))throw new i("attributeName2D is required.");var l=e.attributes[t];if(!r(l))throw new i("geometry must have attribute matching the attributeName argument: "+t+".");if(l.componentDatatype.value!==v.DOUBLE.value)throw new i("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");s=r(s)?s:new f;for(var u=s.getEllipsoid(),c=l.values,h=new Float64Array(c.length),d=0,m=0;m<c.length;m+=3){var p=o.fromArray(c,m,j),y=u.cartesianToCartographic(p,Y);if(!r(y))throw new i("Could not project point ("+p.x+", "+p.y+", "+p.z+") to 2D.");var g=s.project(y,j);h[d++]=g.x,h[d++]=g.y,h[d++]=g.z}return e.attributes[n]=l,e.attributes[a]=new x({componentDatatype:v.DOUBLE,componentsPerAttribute:3,values:h}),delete e.attributes[t],e};var X={high:0,low:0};H.encodeAttribute=function(e,t,n,o){if(!r(e))throw new i("geometry is required.");if(!r(t))throw new i("attributeName is required.");if(!r(n))throw new i("attributeHighName is required.");if(!r(o))throw new i("attributeLowName is required.");var a=e.attributes[t];if(!r(a))throw new i("geometry must have attribute matching the attributeName argument: "+t+".");if(a.componentDatatype.value!==v.DOUBLE.value)throw new i("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var s=a.values,u=s.length,c=new Float32Array(u),h=new Float32Array(u),d=0;u>d;++d)l.encode(s[d],X),c[d]=X.high,h[d]=X.low;var m=a.componentsPerAttribute;return e.attributes[n]=new x({componentDatatype:v.FLOAT,componentsPerAttribute:m,values:c}),e.attributes[o]=new x({componentDatatype:v.FLOAT,componentsPerAttribute:m,values:h}),delete e.attributes[t],e};var Z=new o,J=new m,K=new d;H.transformToWorldCoordinates=function(e){if(!r(e))throw new i("instance is required.");var t=e.modelMatrix;if(m.equals(t,m.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(r(n.normal)||r(n.binormal)||r(n.tangent))&&(m.inverse(t,J),m.transpose(J,J),m.getRotation(J,K),M(K,n.normal),M(K,n.binormal),M(K,n.tangent));var o=e.geometry.boundingSphere;return r(o)&&(e.geometry.boundingSphere=w.transform(o,t,o)),e.modelMatrix=m.clone(m.IDENTITY),e},H.combine=function(e){if(!r(e)||e.length<1)throw new i("instances is required and must have length greater than zero.");var t,n,a,s,l=e.length,u=e[0].modelMatrix,c=r(e[0].geometry.indices),h=e[0].geometry.primitiveType;for(n=1;l>n;++n){if(!m.equals(e[n].modelMatrix,u))throw new i("All instances must have the same modelMatrix.");if(r(e[n].geometry.indices)!==c)throw new i("All instance geometries must have an indices or not have one.");if(e[n].geometry.primitiveType!==h)throw new i("All instance geometries must have the same primitiveType.")}var d,p,f,v=I(e);for(t in v)if(v.hasOwnProperty(t))for(d=v[t].values,s=0,n=0;l>n;++n)for(p=e[n].geometry.attributes[t].values,f=p.length,a=0;f>a;++a)d[s++]=p[a];var _;if(c){var x=0;for(n=0;l>n;++n)x+=e[n].geometry.indices.length;var S=C.computeNumberOfVertices(new C({attributes:v,primitiveType:g.POINTS})),E=y.createTypedArray(S,x),b=0,T=0;for(n=0;l>n;++n){var A=e[n].geometry.indices,D=A.length;for(s=0;D>s;++s)E[b++]=T+A[s];T+=C.computeNumberOfVertices(e[n].geometry)}_=E}var P,M=new o,O=0;for(n=0;l>n;++n){if(P=e[n].geometry.boundingSphere,!r(P)){M=void 0;break}o.add(P.center,M,M)}if(r(M))for(o.divideByScalar(M,l,M),n=0;l>n;++n){P=e[n].geometry.boundingSphere;var R=o.magnitude(o.subtract(P.center,M))+P.radius;R>O&&(O=R)}return new C({attributes:v,indices:_,primitiveType:h,boundingSphere:r(M)?new w(M,O):void 0})};var Q=new o,$=new o,et=new o,tt=new o;H.computeNormal=function(e){if(!r(e))throw new i("geometry is required.");var t=e.attributes,n=e.indices;if(!r(t.position)||!r(t.position.values))throw new i("geometry.attributes.position.values is required.");if(!r(n))throw new i("geometry.indices is required.");if(n.length<2||0!==n.length%3)throw new i("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==g.TRIANGLES)throw new i("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,s=e.attributes.position.values.length/3,l=n.length,u=new Array(s),c=new Array(l/3),h=new Array(l),d=0;s>d;d++)u[d]={indexOffset:0,count:0,currentCount:0};var m=0;for(d=0;l>d;d+=3){var p=n[d],f=n[d+1],y=n[d+2],_=3*p,w=3*f,C=3*y;$.x=a[_],$.y=a[_+1],$.z=a[_+2],et.x=a[w],et.y=a[w+1],et.z=a[w+2],tt.x=a[C],tt.y=a[C+1],tt.z=a[C+2],u[p].count++,u[f].count++,u[y].count++,o.subtract(et,$,et),o.subtract(tt,$,tt),c[m]=o.cross(et,tt),m++}var S=0;for(d=0;s>d;d++)u[d].indexOffset+=S,S+=u[d].count;m=0;var E;for(d=0;l>d;d+=3){E=u[n[d]];var b=E.indexOffset+E.currentCount;h[b]=m,E.currentCount++,E=u[n[d+1]],b=E.indexOffset+E.currentCount,h[b]=m,E.currentCount++,E=u[n[d+2]],b=E.indexOffset+E.currentCount,h[b]=m,E.currentCount++,m++}var T=new Float32Array(3*s);for(d=0;s>d;d++){var A=3*d;if(E=u[d],E.count>0){for(o.clone(o.ZERO,Q),m=0;m<E.count;m++)o.add(Q,c[h[E.indexOffset+m]],Q);o.normalize(Q,Q),T[A]=Q.x,T[A+1]=Q.y,T[A+2]=Q.z}else T[A]=0,T[A+1]=0,T[A+2]=1}return e.attributes.normal=new x({componentDatatype:v.FLOAT,componentsPerAttribute:3,values:T}),e};var rt=new o,it=new o,nt=new o;H.computeBinormalAndTangent=function(e){if(!r(e))throw new i("geometry is required.");var t=e.attributes,n=e.indices;if(!r(t.position)||!r(t.position.values))throw new i("geometry.attributes.position.values is required.");if(!r(t.normal)||!r(t.normal.values))throw new i("geometry.attributes.normal.values is required.");if(!r(t.st)||!r(t.st.values))throw new i("geometry.attributes.st.values is required.");if(!r(n))throw new i("geometry.indices is required.");if(n.length<2||0!==n.length%3)throw new i("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==g.TRIANGLES)throw new i("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,s=e.attributes.normal.values,l=e.attributes.st.values,u=e.attributes.position.values.length/3,c=n.length,h=new Array(3*u),d=0;d<h.length;d++)h[d]=0;var m,p,f;for(d=0;c>d;d+=3){var y=n[d],_=n[d+1],w=n[d+2];m=3*y,p=3*_,f=3*w;var C=2*y,S=2*_,E=2*w,b=a[m],T=a[m+1],A=a[m+2],D=l[C],P=l[C+1],M=l[S+1]-P,I=l[E+1]-P,O=1/((l[S]-D)*I-(l[E]-D)*M),R=(I*(a[p]-b)-M*(a[f]-b))*O,L=(I*(a[p+1]-T)-M*(a[f+1]-T))*O,z=(I*(a[p+2]-A)-M*(a[f+2]-A))*O;h[m]+=R,h[m+1]+=L,h[m+2]+=z,h[p]+=R,h[p+1]+=L,h[p+2]+=z,h[f]+=R,h[f+1]+=L,h[f+2]+=z}var N=new Float32Array(3*u),B=new Float32Array(3*u);for(d=0;u>d;d++){m=3*d,p=m+1,f=m+2;var F=o.fromArray(s,m,rt),V=o.fromArray(h,m,nt),k=o.dot(F,V);o.multiplyByScalar(F,k,it),o.normalize(o.subtract(V,it,V),V),B[m]=V.x,B[p]=V.y,B[f]=V.z,o.normalize(o.cross(F,V,V),V),N[m]=V.x,N[p]=V.y,N[f]=V.z}return e.attributes.tangent=new x({componentDatatype:v.FLOAT,componentsPerAttribute:3,values:B}),e.attributes.binormal=new x({componentDatatype:v.FLOAT,componentsPerAttribute:3,values:N}),e};var ot=new o,at=new o,st=new o,lt=new o,ut=new o,ct={positions:new Array(7),indices:new Array(9)};return H.wrapLongitude=function(e){if(!r(e))throw new i("geometry is required.");var t=e.boundingSphere;if(r(t)){var n=t.center.x-t.radius;if(n>0||w.intersect(t,a.UNIT_Y)!==u.INTERSECTING)return e}return F(e),e.primitiveType===g.TRIANGLES?q(e):e.primitiveType===g.LINES&&G(e),e},H}),r("Core/GeometryInstanceAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(i.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(i.componentsPerAttribute<1||i.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(i.value))throw new r("options.value is required.");this.componentDatatype=i.componentDatatype,this.componentsPerAttribute=i.componentsPerAttribute,this.normalize=e(i.normalize,!1),this.value=i.value};return i}),r("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4","./Geometry","./GeometryInstanceAttribute"],function(e,t,r,i){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.geometry))throw new r("options.geometry is required.");this.geometry=n.geometry,this.modelMatrix=i.clone(e(n.modelMatrix,i.IDENTITY)),this.id=n.id,this.pickPrimitive=n.pickPrimitive,this.attributes=e(n.attributes,{})};return n}),r("Core/EllipseGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./EllipseGeometryLibrary","./GeographicProjection","./Geometry","./GeometryPipeline","./GeometryInstance","./GeometryAttribute","./GeometryAttributes","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C){"use strict";function x(e,t,r){var i=t.vertexFormat,o=t.center,s=t.semiMajorAxis,l=t.ellipsoid,u=t.stRotation,d=r?2*(e.length/3):e.length/3,m=i.st?new Float32Array(2*d):void 0,p=i.normal?new Float32Array(3*d):void 0,y=i.tangent?new Float32Array(3*d):void 0,_=i.binormal?new Float32Array(3*d):void 0,C=0,x=z,S=N,E=B,b=new h(l),T=b.project(l.cartesianToCartographic(o,F),V),A=l.scaleToGeodeticSurface(o,D);l.geodeticSurfaceNormal(A,A);for(var I=w.fromAxisAngle(A,u,L),k=g.fromQuaternion(I,R),U=e.length,W=r?U:0,q=2*(W/3),G=0;U>G;G+=3){var H=G+1,j=G+2,Y=n.fromArray(e,G,D);if(i.st){var X=g.multiplyByVector(k,Y,P),Z=b.project(l.cartesianToCartographic(X,F),M);n.subtract(Z,T,Z),O.x=(Z.x+s)/(2*s),O.y=(Z.y+s)/(2*s),r&&(m[C+q]=O.x,m[C+1+q]=O.y),m[C++]=O.x,m[C++]=O.y}x=l.geodeticSurfaceNormal(Y,x),(i.normal||i.tangent||i.binormal)&&((i.tangent||i.binormal)&&(S=n.cross(n.UNIT_Z,x,S),g.multiplyByVector(k,S,S)),i.normal&&(p[G]=x.x,p[H]=x.y,p[j]=x.z,r&&(p[G+W]=-x.x,p[H+W]=-x.y,p[j+W]=-x.z)),i.tangent&&(y[G]=S.x,y[H]=S.y,y[j]=S.z,r&&(y[G+W]=-S.x,y[H+W]=-S.y,y[j+W]=-S.z)),i.binormal&&(E=n.cross(x,S,E),_[G]=E.x,_[H]=E.y,_[j]=E.z,r&&(_[G+W]=E.x,_[H+W]=E.y,_[j+W]=E.z)))}var J=new v;if(i.position){var K=c.raisePositionsToHeight(e,t,r);J.position=new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:K})}return i.st&&(J.st=new f({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:m})),i.normal&&(J.normal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:p})),i.tangent&&(J.tangent=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:y})),i.binormal&&(J.binormal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:_})),J}function S(e){var t,r,i,n,o,a=new Array(2*e*(e+1)),s=0;for(n=1;e>n;++n){for(i=n*(n+1),t=(n-1)*n,a[s++]=i++,a[s++]=t,a[s++]=i,r=2*n,o=0;r-1>o;++o)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;a[s++]=i++,a[s++]=t,a[s++]=i}for(r=2*e,++i,++t,n=0;r-1>n;++n)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;for(++t,++i,n=e-1;n>0;--n){for(a[s++]=t++,a[s++]=t,a[s++]=i,r=2*n,o=0;r-1>o;++o)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;a[s++]=t++,a[s++]=t++,a[s++]=i++}return a}function E(e){var t=e.center;k=n.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,k),e.height,k),k=n.add(t,k,k);var i=new r(k,e.semiMajorAxis),o=c.computeEllipsePositions(e,!0,!1),a=o.positions,l=o.numPts,u=x(a,e,!1),h=S(l);return h=s.createTypedArray(a.length/3,h),{boundingSphere:i,attributes:u,indices:h}}function b(e,t){var r=t.vertexFormat,i=t.center,o=t.semiMajorAxis,s=t.ellipsoid,l=t.height,u=t.extrudedHeight,c=t.stRotation,d=2*(e.length/3),m=new Float64Array(3*d),p=r.st?new Float32Array(2*d):void 0,y=r.normal?new Float32Array(3*d):void 0,_=r.tangent?new Float32Array(3*d):void 0,C=r.binormal?new Float32Array(3*d):void 0,x=0,S=z,E=N,b=B,T=new h(s),A=T.project(s.cartesianToCartographic(i,F),V),k=s.scaleToGeodeticSurface(i,D);s.geodeticSurfaceNormal(k,k);for(var U=w.fromAxisAngle(k,c,L),W=g.fromQuaternion(U,R),q=e.length,G=2*(q/3),H=0;q>H;H+=3){var j,Y=H+1,X=H+2,Z=n.fromArray(e,H,D);if(r.st){var J=g.multiplyByVector(W,Z,P),K=T.project(s.cartesianToCartographic(J,F),M);n.subtract(K,A,K),O.x=(K.x+o)/(2*o),O.y=(K.y+o)/(2*o),p[x+G]=O.x,p[x+1+G]=O.y,p[x++]=O.x,p[x++]=O.y}Z=s.scaleToGeodeticSurface(Z,Z),j=n.clone(Z,P),S=s.geodeticSurfaceNormal(Z,S);var Q=n.multiplyByScalar(S,l,I);if(Z=n.add(Z,Q,Z),Q=n.multiplyByScalar(S,u,Q),j=n.add(j,Q,j),r.position&&(m[H+q]=j.x,m[Y+q]=j.y,m[X+q]=j.z,m[H]=Z.x,m[Y]=Z.y,m[X]=Z.z),r.normal||r.tangent||r.binormal){b=n.clone(S,b);var $=n.fromArray(e,(H+3)%q,I);n.subtract($,Z,$);var et=n.subtract(j,Z,M);S=n.normalize(n.cross(et,$,S),S),r.normal&&(y[H]=S.x,y[Y]=S.y,y[X]=S.z,y[H+q]=S.x,y[Y+q]=S.y,y[X+q]=S.z),r.tangent&&(E=n.normalize(n.cross(b,S,E),E),_[H]=E.x,_[Y]=E.y,_[X]=E.z,_[H+q]=E.x,_[H+1+q]=E.y,_[H+2+q]=E.z),r.binormal&&(C[H]=b.x,C[Y]=b.y,C[X]=b.z,C[H+q]=b.x,C[Y+q]=b.y,C[X+q]=b.z)}}var tt=new v;return r.position&&(tt.position=new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:m})),r.st&&(tt.st=new f({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:p})),r.normal&&(tt.normal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:y})),r.tangent&&(tt.tangent=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:_})),r.binormal&&(tt.binormal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:C})),tt}function T(e){for(var t,r,i,n,o=e.length/3,a=s.createTypedArray(o,6*o),l=0,u=0;o-1>u;u++)t=u,i=u+o,r=t+1,n=r+o,a[l++]=t,a[l++]=i,a[l++]=r,a[l++]=r,a[l++]=i,a[l++]=n;return t=o-1,i=u+o,r=0,n=r+o,a[l++]=t,a[l++]=i,a[l++]=r,a[l++]=r,a[l++]=i,a[l++]=n,a}function A(e){var t=e.center,i=e.ellipsoid,o=e.semiMajorAxis,a=n.multiplyByScalar(i.geodeticSurfaceNormal(t,D),e.height,D);U.center=n.add(t,a,U.center),U.radius=o,a=n.multiplyByScalar(i.geodeticSurfaceNormal(t,a),e.extrudedHeight,a),W.center=n.add(t,a,W.center),W.radius=o;var l=c.computeEllipsePositions(e,!0,!0),u=l.positions,h=l.numPts,f=l.outerPositions,v=r.union(U,W),y=x(u,e,!0),g=S(h),w=g.length;g.length=2*w;for(var C=u.length/3,E=0;w>E;E+=3)g[E+w]=g[E+2]+C,g[E+1+w]=g[E+1]+C,g[E+2+w]=g[E]+C;var A=s.createTypedArray(2*C/3,g),P=new d({attributes:y,indices:A,primitiveType:_.TRIANGLES}),M=b(f,e);g=T(f);var I=s.createTypedArray(2*f.length/3,g),O=new d({attributes:M,indices:I,primitiveType:_.TRIANGLES}),R=m.combine([new p({geometry:P}),new p({geometry:O})]);return{boundingSphere:v,attributes:R.attributes,indices:R.indices}}var D=new n,P=new n,M=new n,I=new n,O=new i,R=new g,L=new w,z=new n,N=new n,B=new n,F=new o,V=new n,k=new n,U=new r,W=new r,q=function(r){r=e(r,e.EMPTY_OBJECT);var i=r.center,o=r.semiMajorAxis,a=r.semiMinorAxis,s=e(r.granularity,y.RADIANS_PER_DEGREE),c=e(r.height,0),h=r.extrudedHeight,d=t(h)&&!y.equalsEpsilon(c,h,1);if(!t(i))throw new l("center is required.");if(!t(o))throw new l("semiMajorAxis is required.");if(!t(a))throw new l("semiMinorAxis is required.");if(0>=o||0>=a)throw new l("Semi-major and semi-minor axes must be greater than zero.");if(a>o)throw new l("semiMajorAxis must be larger than the semiMajorAxis.");if(0>=s)throw new l("granularity must be greater than zero.");this._center=n.clone(i),this._semiMajorAxis=o,this._semiMinorAxis=a,this._ellipsoid=e(r.ellipsoid,u.WGS84),this._rotation=e(r.rotation,0),this._stRotation=e(r.stRotation,0),this._height=c,this._granularity=s,this._vertexFormat=e(r.vertexFormat,C.DEFAULT),this._extrudedHeight=h,this._extrude=d,this._workerName="createEllipseGeometry"};return q.createGeometry=function(e){var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=A(r)):t=E(r),new d({attributes:t.attributes,indices:t.indices,primitiveType:_.TRIANGLES,boundingSphere:t.boundingSphere})},q}),r("Core/CircleGeometry",["./defaultValue","./defined","./DeveloperError","./EllipseGeometry"],function(e,t,r,i){"use strict";var n=function(n){n=e(n,e.EMPTY_OBJECT);var o=n.radius;if(!t(o))throw new r("radius is required.");if(0>=o)throw new r("radius must be greater than zero.");var a={center:n.center,semiMajorAxis:o,semiMinorAxis:o,ellipsoid:n.ellipsoid,height:n.height,extrudedHeight:n.extrudedHeight,granularity:n.granularity,vertexFormat:n.vertexFormat,stRotation:n.stRotation};this._ellipseGeometry=new i(a),this._workerName="createCircleGeometry"};return n.createGeometry=function(e){return i.createGeometry(e._ellipseGeometry)},n}),r("Core/EllipseOutlineGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian3","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./EllipseGeometryLibrary","./Geometry","./GeometryAttribute","./GeometryAttributes","./Math","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m){"use strict";
function p(e){var t=e.center;y=i.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,y),e.height,y),y=i.add(t,y,y);for(var a=new r(y,e.semiMajorAxis),s=l.computeEllipsePositions(e,!1,!0).outerPositions,u=new h({position:new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:l.raisePositionsToHeight(s,e,!1)})}),d=s.length/3,m=o.createTypedArray(d,2*d),p=0,f=0;d-1>f;f++)m[p++]=f,m[p++]=f+1;return m[p++]=d-1,m[p++]=0,{boundingSphere:a,attributes:u,indices:m}}function f(t){var a=e(t.numberOfVerticalLines,16);a=Math.max(a,0);var s=t.center,u=t.ellipsoid,d=t.semiMajorAxis,m=i.multiplyByScalar(u.geodeticSurfaceNormal(s,v),t.height,v);g.center=i.add(s,m,g.center),g.radius=d,m=i.multiplyByScalar(u.geodeticSurfaceNormal(s,m),t.extrudedHeight,m),_.center=i.add(s,m,_.center),_.radius=d;var p=l.computeEllipsePositions(t,!1,!0).outerPositions,f=new h({position:new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:l.raisePositionsToHeight(p,t,!0)})});p=f.position.values;var y=r.union(g,_),w=p.length/3,C=o.createTypedArray(w,2*w+2*a);w/=2;for(var x=0,S=0;w-1>S;S++)C[x++]=S,C[x++]=S+1,C[x++]=S+w,C[x++]=S+w+1;C[x++]=w-1,C[x++]=0,C[x++]=w+w-1,C[x++]=w;var E;if(a>0){var b=Math.min(a,w);E=Math.round(w/b)}var T=Math.min(E*a,w);if(a>0)for(S=0;T>S;S+=E)C[x++]=S,C[x++]=S+w;return{boundingSphere:y,attributes:f,indices:C}}var v=new i,y=new i,g=new r,_=new r,w=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.center,o=r.semiMajorAxis,l=r.semiMinorAxis,u=e(r.granularity,d.RADIANS_PER_DEGREE),c=e(r.height,0),h=r.extrudedHeight,m=t(h)&&!d.equalsEpsilon(c,h,1);if(!t(n))throw new a("center is required.");if(!t(o))throw new a("semiMajorAxis is required.");if(!t(l))throw new a("semiMinorAxis is required.");if(0>=o||0>=l)throw new a("Semi-major and semi-minor axes must be greater than zero.");if(l>o)throw new a("semiMajorAxis must be larger than the semiMajorAxis.");if(0>=u)throw new a("granularity must be greater than zero.");this._center=i.clone(n),this._semiMajorAxis=o,this._semiMinorAxis=l,this._ellipsoid=e(r.ellipsoid,s.WGS84),this._rotation=e(r.rotation,0),this._height=c,this._granularity=u,this._extrudedHeight=h,this._extrude=m,this._numberOfVerticalLines=Math.max(e(r.numberOfVerticalLines,16),0),this._workerName="createEllipseOutlineGeometry"};return w.createGeometry=function(e){var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=f(r)):t=p(r),new u({attributes:t.attributes,indices:t.indices,primitiveType:m.LINES,boundingSphere:t.boundingSphere})},w}),r("Core/CircleOutlineGeometry",["./defaultValue","./defined","./DeveloperError","./EllipseOutlineGeometry"],function(e,t,r,i){"use strict";var n=function(n){n=e(n,e.EMPTY_OBJECT);var o=n.radius;if(!t(o))throw new r("radius is required.");if(0>=o)throw new r("radius must be greater than zero.");var a={center:n.center,semiMajorAxis:o,semiMinorAxis:o,ellipsoid:n.ellipsoid,height:n.height,extrudedHeight:n.extrudedHeight,granularity:n.granularity,numberOfVerticalLines:n.numberOfVerticalLines};this._ellipseGeometry=new i(a),this._workerName="createCircleOutlineGeometry"};return n.createGeometry=function(e){return i.createGeometry(e._ellipseGeometry)},n}),r("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(r,i,n){if(!e(r))throw new t("array is required.");if(!e(i))throw new t("itemToFind is required.");if(!e(n))throw new t("comparator is required.");for(var o,a,s=0,l=r.length-1;l>=s;)if(o=~~((s+l)/2),a=n(r[o],i),0>a)s=o+1;else{if(!(a>0))return o;l=o-1}return~(l+1)};return r}),r("Core/TimeConstants",[],function(){"use strict";var e={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e}),r("Core/LeapSecond",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(r,i){if(!e(r))throw new t("date is required.");if(null===i||isNaN(i))throw new t("offset is required and must be a number.");this.julianDate=r,this.offset=i};return r.setLeapSeconds=function(e){if(!Array.isArray(e))throw new t("leapSeconds is required and must be an array.");r._leapSeconds=e,r._leapSeconds.sort(r.compareLeapSecondDate)},r.getLeapSeconds=function(){return r._leapSeconds},r.prototype.equals=function(e){return this.julianDate.equals(e.julianDate)&&this.offset===e.offset},r.compareLeapSecondDate=function(e,t){return e.julianDate.compareTo(t.julianDate)},r._leapSeconds=[],r}),r("Core/TimeStandard",[],function(){"use strict";var e={UTC:0,TAI:1};return e}),r("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return 0===t%4&&0!==t%100||0===t%400}return t}),r("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,i=t[r++],n=function(e,t,r,i){r||(r=" ");var n=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return i?e+n:n+e},o=function(e,t,r,i,o,a){var s=i-e.length;return s>0&&(e=r||!o?n(e,i,a,r):e.slice(0,t.length)+n("",s,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,i,a,s,l){var u=e>>>0;return r=r&&u&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+n(u.toString(t),s||0,"0",!1),o(e,r,i,a,l)},s=function(e,t,r,i,n,a){return null!=i&&(e=e.slice(0,i)),o(e,"",t,r,n,a)},l=function(e,i,l,u,c,h,d){var m,p,f,v,y;if("%%"==e)return"%";for(var g=!1,_="",w=!1,C=!1,x=" ",S=l.length,E=0;l&&S>E;E++)switch(l.charAt(E)){case" ":_=" ";break;case"+":_="+";break;case"-":g=!0;break;case"'":x=l.charAt(E+1);break;case"0":w=!0;break;case"#":C=!0}if(u=u?"*"==u?+t[r++]:"*"==u.charAt(0)?+t[u.slice(1,-1)]:+u:0,0>u&&(u=-u,g=!0),!isFinite(u))throw new Error("sprintf: (minimum-)width must be finite");switch(h=h?"*"==h?+t[r++]:"*"==h.charAt(0)?+t[h.slice(1,-1)]:+h:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,y=i?t[i.slice(0,-1)]:t[r++],d){case"s":return s(String(y),g,u,h,w,x);case"c":return s(String.fromCharCode(+y),g,u,h,w);case"b":return a(y,2,C,g,u,h,w);case"o":return a(y,8,C,g,u,h,w);case"x":return a(y,16,C,g,u,h,w);case"X":return a(y,16,C,g,u,h,w).toUpperCase();case"u":return a(y,10,C,g,u,h,w);case"i":case"d":return m=+y||0,m=Math.round(m-m%1),p=0>m?"-":_,y=p+n(String(Math.abs(m)),h,"0",!1),o(y,p,g,u,w);case"e":case"E":case"f":case"F":case"g":case"G":return m=+y,p=0>m?"-":_,f=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],v=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],y=p+Math.abs(m)[f](h),o(y,p,g,u,w)[v]();default:return e}};return i.replace(e,l)}return e}),r("Core/JulianDate",["./DeveloperError","./binarySearch","./defined","./TimeConstants","./LeapSecond","./TimeStandard","./isLeapYear","../ThirdParty/sprintf"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){v.julianDate=e;var r=n.getLeapSeconds(),i=t(r,v,n.compareLeapSecondDate);0>i&&(i=~i),i>=r.length&&(i=r.length-1);var o=r[i].offset;if(i>0){var a=e.getSecondsDifference(r[i].julianDate);a>o&&(i--,o=r[i].offset)}e.addSeconds(o,e)}function u(e,r){v.julianDate=e;var i=n.getLeapSeconds(),o=t(i,v,n.compareLeapSecondDate);if(0>o&&(o=~o),0===o)return e.addSeconds(-i[0].offset,r);if(o>=i.length)return e.addSeconds(-i[o-1].offset,r);var a=e.getSecondsDifference(i[o].julianDate);return 0===a?e.addSeconds(-i[o].offset,r):1>=a?void 0:e.addSeconds(-i[--o].offset,r)}function c(e,t,n){var a=0|t/i.SECONDS_PER_DAY;return e+=a,t-=i.SECONDS_PER_DAY*a,0>t&&(e--,t+=i.SECONDS_PER_DAY),r(n)?(n._julianDayNumber=e,n._secondsOfDay=t,n):new A(e,t,o.TAI)}function h(e,t,r,n,o,a,s){var l=0|(t-14)/12,u=e+4800+l,c=(0|1461*u/4)+(0|367*(t-2-12*l)/12)-(0|3*((u+100)/100)/4)+r-32075;n-=12,0>n&&(n+=24);var h=a+(n*i.SECONDS_PER_HOUR+o*i.SECONDS_PER_MINUTE+s*i.SECONDS_PER_MILLISECOND);return h>=43200&&(c-=1),[c,h]}function d(e){return h(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds())}var m=function(e,t,r,i,n,o,a,s){this.year=e,this.month=t,this.day=r,this.hour=i,this.minute=n,this.second=o,this.millisecond=a,this.isLeapSecond=s},p=[31,28,31,30,31,30,31,31,30,31,30,31],f=29,v={julianDate:void 0},y=/^(\d{4})$/,g=/^(\d{4})-(\d{2})$/,_=/^(\d{4})-?(\d{3})$/,w=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,C=/^(\d{4})-?(\d{2})-?(\d{2})$/,x=/([Z+\-])?(\d{2})?:?(\d{2})?$/,S=/^(\d{2})(\.\d+)?/.source+x.source,E=/^(\d{2}):?(\d{2})(\.\d+)?/.source+x.source,b=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+x.source,T="Valid ISO 8601 date string required.",A=function(t,n,a){this._julianDayNumber=void 0,this._secondsOfDay=void 0;var s,u;if(r(t)||r(n)||r(a)){if(r(a)){if(a!==o.UTC&&a!==o.TAI)throw new e("timeStandard is not a known TimeStandard.")}else a=o.UTC;if(null===t||isNaN(t))throw new e("julianDayNumber is required.");if(null===n||isNaN(n))throw new e("julianSecondsOfDay is required.");s=0|t,u=n+(t-s)*i.SECONDS_PER_DAY}else{var h=new Date,m=d(h);s=m[0],u=m[1],a=o.UTC}c(s,u,this),a===o.UTC&&l(this)};A.clone=function(e,t){return r(e)?r(t)?(t._julianDayNumber=e._julianDayNumber,t._secondsOfDay=e._secondsOfDay,t):new A(e._julianDayNumber,e._secondsOfDay,o.TAI):void 0},A.fromDate=function(t,r){if(!(t instanceof Date)||isNaN(t.getTime()))throw new e("date must be a valid JavaScript Date.");var i=d(t);return new A(i[0],i[1],r)},A.fromIso8601=function(t){if("string"!=typeof t)throw new e(T);t=t.replace(",",".");var i,n,s,l=t.split("T"),u=1,c=1,d=0,m=0,v=0,x=0,D=l[0],P=l[1];if(!r(D))throw new e(T);var M;if(l=D.match(C),null!==l){if(M=D.split("-").length-1,M>0&&2!==M)throw new e(T);i=+l[1],u=+l[2],c=+l[3]}else if(l=D.match(g),null!==l)i=+l[1],u=+l[2];else if(l=D.match(y),null!==l)i=+l[1];else{var I;if(l=D.match(_),null!==l){if(i=+l[1],I=+l[2],s=a(i),1>I||s&&I>366||!s&&I>365)throw new e(T)}else{if(l=D.match(w),null===l)throw new e(T);i=+l[1];var O=+l[2],R=+l[3]||0;if(M=D.split("-").length-1,M>0&&(!r(l[3])&&1!==M||r(l[3])&&2!==M))throw new e(T);var L=new Date(Date.UTC(i,0,4));I=7*O+R-L.getUTCDay()-3}n=new Date(Date.UTC(i,0,1)),n.setUTCDate(I),u=n.getUTCMonth()+1,c=n.getUTCDate()}if(s=a(i),1>u||u>12||1>c||(2!==u||!s)&&c>p[u-1]||s&&2===u&&c>f)throw new e(T);var z;if(r(P)){if(l=P.match(b),null!==l){if(M=P.split(":").length-1,M>0&&2!==M&&3!==M)throw new e(T);d=+l[1],m=+l[2],v=+l[3],x=1e3*+(l[4]||0),z=5}else if(l=P.match(E),null!==l){if(M=P.split(":").length-1,M>0&&1!==M)throw new e(T);d=+l[1],m=+l[2],v=60*+(l[3]||0),z=4}else{if(l=P.match(S),null===l)throw new e(T);d=+l[1],m=60*+(l[2]||0),z=3}if(m>=60||v>=61||d>24||24===d&&(m>0||v>0||x>0))throw new e(T);var N=l[z],B=+l[z+1],F=+(l[z+2]||0);switch(N){case"+":d-=B,m-=F;break;case"-":d+=B,m+=F;break;case"Z":break;default:m+=new Date(Date.UTC(i,u-1,c,d,m)).getTimezoneOffset()}}else m+=new Date(Date.UTC(i,u-1,c)).getTimezoneOffset();var V=60===v;for(V&&v--;m>=60;)m-=60,d++;for(;d>=24;)d-=24,c++;for(n=s&&2===u?f:p[u-1];c>n;)c-=n,u++,u>12&&(u-=12,i++),n=s&&2===u?f:p[u-1];for(;0>m;)m+=60,d--;for(;0>d;)d+=24,c--;for(;1>c;)u--,1>u&&(u+=12,i--),n=s&&2===u?f:p[u-1],c+=n;var k=h(i,u,c,d,m,v,x),U=new A(k[0],k[1],o.UTC);return V&&U.addSeconds(1,U),U},A.fromTotalDays=function(t,r){if(null===t||isNaN(t))throw new e("totalDays is required.");return new A(t,0,r)},A.compare=function(e,t){var r=e._julianDayNumber-t._julianDayNumber;return 0!==r?r:e._secondsOfDay-t._secondsOfDay},A.equals=function(e,t){return e===t||r(e)&&r(t)&&e._julianDayNumber===t._julianDayNumber&&e._secondsOfDay===t._secondsOfDay},A.equalsEpsilon=function(t,r,i){if(null===i||isNaN(i))throw new e("epsilon is required and must be a number.");return Math.abs(t.getSecondsDifference(r))<=i},A.prototype.clone=function(e){return A.clone(this,e)},A.prototype.getTotalDays=function(){return this._julianDayNumber+this._secondsOfDay/i.SECONDS_PER_DAY},A.prototype.getJulianDayNumber=function(){return this._julianDayNumber},A.prototype.getJulianTimeFraction=function(){return this._secondsOfDay/i.SECONDS_PER_DAY},A.prototype.getSecondsOfDay=function(){return this._secondsOfDay};var D=new A(0,0,o.TAI);return A.prototype.toGregorianDate=function(){var e=!1,t=u(this,D);r(t)||(this.addSeconds(-1,D),t=u(D,D),e=!0);var n=t._julianDayNumber,o=t._secondsOfDay;o>=43200&&(n+=1);var a=0|n+68569,s=0|4*a/146097;a=0|a-(0|(146097*s+3)/4);var l=0|4e3*(a+1)/1461001;a=0|a-(0|1461*l/4)+31;var c=0|80*a/2447,h=0|a-(0|2447*c/80);a=0|c/11;var d=0|c+2-12*a,p=0|100*(s-49)+l+a,f=0|o/i.SECONDS_PER_HOUR,v=o-f*i.SECONDS_PER_HOUR,y=0|v/i.SECONDS_PER_MINUTE;v-=y*i.SECONDS_PER_MINUTE;var g=0|v,_=(v-g)/i.SECONDS_PER_MILLISECOND;return f+=12,f>23&&(f-=24),e&&(g+=1),new m(p,d,h,f,y,g,_,e)},A.prototype.toDate=function(){var e=this.toGregorianDate(),t=e.second;return e.isLeapSecond&&(t-=1),new Date(Date.UTC(e.year,e.month-1,e.day,e.hour,e.minute,t,e.millisecond))},A.prototype.toIso8601=function(e){var t,i=this.toGregorianDate();return r(e)||0===i.millisecond?r(e)&&0!==e?(t=(.01*i.millisecond).toFixed(e).replace(".","").slice(0,e),s("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,t)):s("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(t=(.01*i.millisecond).toString().replace(".",""),s("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,t))},A.prototype.getSecondsDifference=function(e){var t=this,r=e,n=(r._julianDayNumber-t._julianDayNumber)*i.SECONDS_PER_DAY;return n+(r._secondsOfDay-t._secondsOfDay)},A.prototype.getMinutesDifference=function(e){return this.getSecondsDifference(e)/i.SECONDS_PER_MINUTE},A.prototype.getDaysDifference=function(e){var t=this,r=e,n=r._julianDayNumber-t._julianDayNumber,o=(r._secondsOfDay-t._secondsOfDay)/i.SECONDS_PER_DAY;return n+o},A.prototype.getTaiMinusUtc=function(){v.julianDate=this;var e=n.getLeapSeconds(),r=t(e,v,n.compareLeapSecondDate);return 0>r&&(r=~r,--r,0>r&&(r=0)),e[r].offset},A.prototype.addSeconds=function(t,r){if(null===t||isNaN(t))throw new e("seconds is required and must be a number.");return c(this._julianDayNumber,this._secondsOfDay+t,r)},A.prototype.addMinutes=function(t){if(null===t||isNaN(t))throw new e("duration is required and must be a number.");var r=this._secondsOfDay+t*i.SECONDS_PER_MINUTE;return new A(this._julianDayNumber,r,o.TAI)},A.prototype.addHours=function(t){if(null===t||isNaN(t))throw new e("duration is required and must be a number.");var r=this._secondsOfDay+t*i.SECONDS_PER_HOUR;return new A(this._julianDayNumber,r,o.TAI)},A.prototype.addDays=function(t){if(null===t||isNaN(t))throw new e("duration is required and must be a number.");var r=this._julianDayNumber+t;return new A(r,this._secondsOfDay,o.TAI)},A.prototype.lessThan=function(e){return A.compare(this,e)<0},A.prototype.lessThanOrEquals=function(e){return A.compare(this,e)<=0},A.prototype.greaterThan=function(e){return A.compare(this,e)>0},A.prototype.greaterThanOrEquals=function(e){return A.compare(this,e)>=0},A.prototype.compareTo=function(e){return A.compare(this,e)},A.prototype.equals=function(e){return A.equals(this,e)},A.prototype.equalsEpsilon=function(e,t){return A.equalsEpsilon(this,e,t)},0===n._leapSeconds.length&&(n._leapSeconds=[new n(new A(2441317,43210,o.TAI),10),new n(new A(2441499,43211,o.TAI),11),new n(new A(2441683,43212,o.TAI),12),new n(new A(2442048,43213,o.TAI),13),new n(new A(2442413,43214,o.TAI),14),new n(new A(2442778,43215,o.TAI),15),new n(new A(2443144,43216,o.TAI),16),new n(new A(2443509,43217,o.TAI),17),new n(new A(2443874,43218,o.TAI),18),new n(new A(2444239,43219,o.TAI),19),new n(new A(2444786,43220,o.TAI),20),new n(new A(2445151,43221,o.TAI),21),new n(new A(2445516,43222,o.TAI),22),new n(new A(2446247,43223,o.TAI),23),new n(new A(2447161,43224,o.TAI),24),new n(new A(2447892,43225,o.TAI),25),new n(new A(2448257,43226,o.TAI),26),new n(new A(2448804,43227,o.TAI),27),new n(new A(2449169,43228,o.TAI),28),new n(new A(2449534,43229,o.TAI),29),new n(new A(2450083,43230,o.TAI),30),new n(new A(2450630,43231,o.TAI),31),new n(new A(2451179,43232,o.TAI),32),new n(new A(2453736,43233,o.TAI),33),new n(new A(2454832,43234,o.TAI),34),new n(new A(2456109,43235,o.TAI),35)]),A}),r("Core/ClockStep",["./Enumeration"],function(e){"use strict";var t={TICK_DEPENDENT:new e(0,"TICK_DEPENDENT"),SYSTEM_CLOCK_MULTIPLIER:new e(1,"SYSTEM_CLOCK_MULTIPLIER"),SYSTEM_CLOCK:new e(2,"SYSTEM_CLOCK")};return t}),r("Core/ClockRange",["./Enumeration"],function(e){"use strict";var t={UNBOUNDED:new e(0,"UNBOUNDED"),CLAMPED:new e(1,"CLAMPED"),LOOP_STOP:new e(2,"LOOP_STOP")};return t}),r("Core/Event",["./DeveloperError"],function(e){"use strict";var t=function(){this._listeners=[],this._scopes=[]};return t.prototype.getNumberOfListeners=function(){return this._listeners.length},t.prototype.addEventListener=function(t,r){if("function"!=typeof t)throw new e("listener is required and must be a function.");this._listeners.push(t),this._scopes.push(r);var i=this;return function(){i.removeEventListener(t,r)}},t.prototype.removeEventListener=function(t,r){if("function"!=typeof t)throw new e("listener is required and must be a function.");for(var i=this._listeners,n=this._scopes,o=-1,a=0;a<i.length;a++)if(i[a]===t&&n[a]===r){o=a;break}if(-1===o)throw new e("listener is not subscribed.");i.splice(o,1),this._scopes.splice(o,1)},t.prototype.raiseEvent=function(){for(var e=this._listeners,t=this._scopes,r=e.length,i=0;r>i;i++)e[i].apply(t[i],arguments)},t}),r("Core/Clock",["./defined","./DeveloperError","./JulianDate","./ClockStep","./ClockRange","./Event","./defaultValue"],function(e,t,r,i,n,o,a){"use strict";var s=function(s){s=a(s,a.EMPTY_OBJECT);var l=s.startTime,u=!e(l),c=s.stopTime,h=!e(c),d=s.currentTime,m=!e(d);if(u&&h&&m?(d=new r,l=r.clone(d),c=d.addDays(1)):u&&h?(l=r.clone(d),c=d.addDays(1)):u&&m?(l=c.addDays(-1),d=r.clone(l)):m&&h?(d=r.clone(l),c=l.addDays(1)):m?d=r.clone(l):h?c=d.addDays(1):u&&(l=r.clone(d)),l.greaterThan(c))throw new t("startTime must come before stopTime.");this.startTime=l,this.stopTime=c,this.currentTime=d,this.multiplier=a(s.multiplier,1),this.clockStep=a(s.clockStep,i.SYSTEM_CLOCK_MULTIPLIER),this.clockRange=a(s.clockRange,n.UNBOUNDED),this.shouldAnimate=a(s.shouldAnimate,!0),this.onTick=new o,this._lastSystemTime=Date.now()};return s.prototype.tick=function(){var e=Date.now(),t=this.currentTime,o=this.startTime,a=this.stopTime,s=this.multiplier;if(this.shouldAnimate)if(this.clockStep===i.SYSTEM_CLOCK)t=new r;else{if(this.clockStep===i.TICK_DEPENDENT)t=t.addSeconds(s);else{var l=e-this._lastSystemTime;t=t.addSeconds(s*(l/1e3))}if(this.clockRange===n.CLAMPED)t.lessThan(o)?t=o:t.greaterThan(a)&&(t=a);else if(this.clockRange===n.LOOP_STOP)for(t.lessThan(o)&&(t=r.clone(o));t.greaterThan(a);)t=o.addSeconds(a.getSecondsDifference(t))}return this.currentTime=t,this._lastSystemTime=e,this.onTick.raiseEvent(this),t},s}),r("Core/Color",["./defaultValue","./defined","./freezeObject","./DeveloperError","./FeatureDetection","./Math"],function(e,t,r,i,n,o){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+6*(t-e)*(2/3-r):e}var s=function(t,r,i,n){this.red=e(t,1),this.green=e(r,1),this.blue=e(i,1),this.alpha=e(n,1)};s.fromBytes=function(t,r,i,n){return t=s.byteToFloat(e(t,255)),r=s.byteToFloat(e(r,255)),i=s.byteToFloat(e(i,255)),n=s.byteToFloat(e(n,255)),new s(t,r,i,n)};var l,u,c;n.supportsTypedArrays()&&(l=new ArrayBuffer(4),u=new Uint32Array(l),c=new Uint8Array(l)),s.fromRgba=function(e){return u[0]=e,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(t,r,i,n){t=e(t,0)%1,r=e(r,0),i=e(i,0),n=e(n,1);var o=i,l=i,u=i;if(0!==r){var c;c=.5>i?i*(1+r):i+r-i*r;var h=2*i-c;o=a(h,c,t+1/3),l=a(h,c,t),u=a(h,c,t-1/3)}return new s(o,l,u,n)},s.fromRandom=function(r,n){r=e(r,e.EMPTY_OBJECT);var a=r.red;if(!t(a)){var l=e(r.minimumRed,0),u=e(r.maximumRed,1);if(l>u)throw new i("minimumRed must be less than or equal to maximumRed");a=l+o.nextRandomNumber()*(u-l)}var c=r.green;if(!t(c)){var h=e(r.minimumGreen,0),d=e(r.maximumGreen,1);if(h>d)throw new i("minimumGreen must be less than or equal to maximumGreen");c=h+o.nextRandomNumber()*(d-h)}var m=r.blue;if(!t(m)){var p=e(r.minimumBlue,0),f=e(r.maximumBlue,1);if(p>f)throw new i("minimumBlue must be less than or equal to maximumBlue");m=p+o.nextRandomNumber()*(f-p)}var v=r.alpha;if(!t(v)){var y=e(r.minimumAlpha,0),g=e(r.maximumAlpha,1);if(y>g)throw new i("minimumAlpha must be less than or equal to maximumAlpha");v=y+o.nextRandomNumber()*(g-y)}return t(n)?(n.red=a,n.green=c,n.blue=m,n.alpha=v,n):new s(a,c,m,v)};var h=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,d=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,m=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,p=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){if(!t(r))throw new i("color is required");var n=s[r.toUpperCase()];if(t(n))return s.clone(n);var o=h.exec(r);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=d.exec(r),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=m.exec(r),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=p.exec(r),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(r,n,o){if(!t(r))throw new i("value is required");if(!t(n))throw new i("array is required");o=e(o,0),n[o++]=r.red,n[o++]=r.green,n[o++]=r.blue,n[o]=r.alpha},s.unpack=function(r,n,o){if(!t(r))throw new i("array is required");return n=e(n,0),t(o)||(o=new s),o.red=r[n++],o.green=r[n++],o.blue=r[n++],o.alpha=r[n],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var r=s.floatToByte(this.red),i=s.floatToByte(this.green),n=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=i,e[2]=n,e[3]=o,e):[r,i,n,o]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),u[0]},s.ALICEBLUE=r(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=r(s.fromCssColorString("#FAEBD7")),s.AQUA=r(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=r(s.fromCssColorString("#7FFFD4")),s.AZURE=r(s.fromCssColorString("#F0FFFF")),s.BEIGE=r(s.fromCssColorString("#F5F5DC")),s.BISQUE=r(s.fromCssColorString("#FFE4C4")),s.BLACK=r(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=r(s.fromCssColorString("#FFEBCD")),s.BLUE=r(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=r(s.fromCssColorString("#8A2BE2")),s.BROWN=r(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=r(s.fromCssColorString("#DEB887")),s.CADETBLUE=r(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=r(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=r(s.fromCssColorString("#D2691E")),s.CORAL=r(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=r(s.fromCssColorString("#6495ED")),s.CORNSILK=r(s.fromCssColorString("#FFF8DC")),s.CRIMSON=r(s.fromCssColorString("#DC143C")),s.CYAN=r(s.fromCssColorString("#00FFFF")),s.DARKBLUE=r(s.fromCssColorString("#00008B")),s.DARKCYAN=r(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=r(s.fromCssColorString("#B8860B")),s.DARKGRAY=r(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=r(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=r(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=r(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=r(s.fromCssColorString("#556B2F")),s.DARKORANGE=r(s.fromCssColorString("#FF8C00")),s.DARKORCHID=r(s.fromCssColorString("#9932CC")),s.DARKRED=r(s.fromCssColorString("#8B0000")),s.DARKSALMON=r(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=r(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=r(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=r(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=r(s.fromCssColorString("#00CED1")),s.DARKVIOLET=r(s.fromCssColorString("#9400D3")),s.DEEPPINK=r(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=r(s.fromCssColorString("#00BFFF")),s.DIMGRAY=r(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=r(s.fromCssColorString("#1E90FF")),s.FIREBRICK=r(s.fromCssColorString("#B22222")),s.FLORALWHITE=r(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=r(s.fromCssColorString("#228B22")),s.FUSCHIA=r(s.fromCssColorString("#FF00FF")),s.GAINSBORO=r(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=r(s.fromCssColorString("#F8F8FF")),s.GOLD=r(s.fromCssColorString("#FFD700")),s.GOLDENROD=r(s.fromCssColorString("#DAA520")),s.GRAY=r(s.fromCssColorString("#808080")),s.GREEN=r(s.fromCssColorString("#008000")),s.GREENYELLOW=r(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=r(s.fromCssColorString("#F0FFF0")),s.HOTPINK=r(s.fromCssColorString("#FF69B4")),s.INDIANRED=r(s.fromCssColorString("#CD5C5C")),s.INDIGO=r(s.fromCssColorString("#4B0082")),s.IVORY=r(s.fromCssColorString("#FFFFF0")),s.KHAKI=r(s.fromCssColorString("#F0E68C")),s.LAVENDER=r(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=r(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=r(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=r(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=r(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=r(s.fromCssColorString("#F08080")),s.LIGHTCYAN=r(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=r(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=r(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=r(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=r(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=r(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=r(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=r(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=r(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=r(s.fromCssColorString("#FFFFE0")),s.LIME=r(s.fromCssColorString("#00FF00")),s.LIMEGREEN=r(s.fromCssColorString("#32CD32")),s.LINEN=r(s.fromCssColorString("#FAF0E6")),s.MAGENTA=r(s.fromCssColorString("#FF00FF")),s.MAROON=r(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=r(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=r(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=r(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=r(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=r(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=r(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=r(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=r(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=r(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=r(s.fromCssColorString("#191970")),s.MINTCREAM=r(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=r(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=r(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=r(s.fromCssColorString("#FFDEAD")),s.NAVY=r(s.fromCssColorString("#000080")),s.OLDLACE=r(s.fromCssColorString("#FDF5E6")),s.OLIVE=r(s.fromCssColorString("#808000")),s.OLIVEDRAB=r(s.fromCssColorString("#6B8E23")),s.ORANGE=r(s.fromCssColorString("#FFA500")),s.ORANGERED=r(s.fromCssColorString("#FF4500")),s.ORCHID=r(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=r(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=r(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=r(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=r(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=r(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=r(s.fromCssColorString("#FFDAB9")),s.PERU=r(s.fromCssColorString("#CD853F")),s.PINK=r(s.fromCssColorString("#FFC0CB")),s.PLUM=r(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=r(s.fromCssColorString("#B0E0E6")),s.PURPLE=r(s.fromCssColorString("#800080")),s.RED=r(s.fromCssColorString("#FF0000")),s.ROSYBROWN=r(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=r(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=r(s.fromCssColorString("#8B4513")),s.SALMON=r(s.fromCssColorString("#FA8072")),s.SANDYBROWN=r(s.fromCssColorString("#F4A460")),s.SEAGREEN=r(s.fromCssColorString("#2E8B57")),s.SEASHELL=r(s.fromCssColorString("#FFF5EE")),s.SIENNA=r(s.fromCssColorString("#A0522D")),s.SILVER=r(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=r(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=r(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=r(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=r(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=r(s.fromCssColorString("#00FF7F")),s.STEELBLUE=r(s.fromCssColorString("#4682B4")),s.TAN=r(s.fromCssColorString("#D2B48C")),s.TEAL=r(s.fromCssColorString("#008080")),s.THISTLE=r(s.fromCssColorString("#D8BFD8")),s.TOMATO=r(s.fromCssColorString("#FF6347")),s.TURQUOISE=r(s.fromCssColorString("#40E0D0")),s.VIOLET=r(s.fromCssColorString("#EE82EE")),s.WHEAT=r(s.fromCssColorString("#F5DEB3")),s.WHITE=r(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=r(s.fromCssColorString("#F5F5F5")),s.YELLOW=r(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=r(s.fromCssColorString("#9ACD32")),s}),r("Core/ColorGeometryInstanceAttribute",["./defaultValue","./defined","./Color","./ComponentDatatype","./DeveloperError"],function(e,t,r,i,n){"use strict";var o=function(t,n,o,a){t=e(t,1),n=e(n,1),o=e(o,1),a=e(a,1),this.componentDatatype=i.UNSIGNED_BYTE,this.componentsPerAttribute=4,this.normalize=!0,this.value=new Uint8Array([r.floatToByte(t),r.floatToByte(n),r.floatToByte(o),r.floatToByte(a)])};return o.fromColor=function(e){if(!t(e))throw new n("color is required.");return new o(e.red,e.green,e.blue,e.alpha)},o.toValue=function(e,r){if(!t(e))throw new n("color is required.");return t(r)?e.toBytes(r):new Uint8Array(e.toBytes())},o}),r("Core/CornerType",["../Core/Enumeration"],function(e){"use strict";var t={ROUNDED:new e(0,"ROUNDED"),MITERED:new e(1,"MITERED"),BEVELED:new e(2,"BEVELED")};return t}),r("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=i.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return o.test(t)?t:e.toUpperCase()}function r(e,t,r,i){return(t||"")+r.toLowerCase()+(i||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var i=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment
},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(a,r).replace(n,t)),this.path&&(this.path=this.path.replace(n,t)),this.query&&(this.query=this.query.replace(n,t)),this.fragment&&(this.fragment=this.fragment.replace(n,t))};var n=/%[0-9a-z]{2}/gi,o=/[a-zA-Z0-9\-\._~]/,a=/(.*@)?([^@:]*)(:.*)?/;e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(r.path=t.authority&&""==t.path?"/"+this.path:t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],i=""==t[0];for(i&&t.shift(),""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),i&&r.unshift(""),this.path=r.join("/")},e.resolve=function(t,r){var i=s[t]||(s[t]=new e(t)),n=s[r]||(s[r]=new e(r));return i.resolve(n).toString()};var s={};return e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),r("Core/buildModuleUrl",["require","./defined","./DeveloperError","../ThirdParty/Uri"],function(e,t,r,i){"use strict";function n(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var i=e[t].getAttribute("src"),n=h.exec(i);if(null!==n)return n[1]}return void 0}function o(){if(t(l))return l;var e;if(e="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:n(),!t(e))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return l=new i(e).resolve(new i(document.location.href))}function a(t){return e.toUrl("../"+t)}function s(e){return new i(e).resolve(o()).toString()}var l,u,c,h=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,d=function(r){t(u)||(u=t(e.toUrl)?a:s),t(c)||(c=document.createElement("a"));var i=u(r);return c.href=i,c.href=c.href,c.href};return d._cesiumScriptRegex=h,d}),r("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,r){this.x=e,this.y=t,this.s=r};return e}),r("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(r,i){if(null===r||"object"!=typeof r)return r;i=e(i,!1);var n=new r.constructor;for(var o in r)if(r.hasOwnProperty(o)){var a=r[o];i&&(a=t(a,i)),n[o]=a}return n};return t}),r("Core/RequestErrorEvent",["./defined"],function(e){"use strict";var t=function(e,t){this.statusCode=e,this.response=t};return t.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},t}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,i,n){return t(e).then(r,i,n)}function t(e){var t,r;return e instanceof i?t=e:s(e)?(r=a(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=n(e),t}function r(t){return e(t,o)}function i(e){this.then=e}function n(e){var r=new i(function(r){try{return t(r?r(e):e)}catch(i){return o(i)}});return r}function o(e){var r=new i(function(r,i){try{return i?t(i(e)):o(e)}catch(n){return o(n)}});return r}function a(){function e(e,t,r){return d(e,t,r)}function r(e){return p(e)}function n(e){return p(o(e))}function s(e){return m(e)}var l,u,c,h,d,m,p;return u=new i(e),l={then:e,resolve:r,reject:n,progress:s,promise:u,resolver:{resolve:r,reject:n,progress:s}},c=[],h=[],d=function(e,t,r){var i,n;return i=a(),n="function"==typeof r?function(e){try{i.progress(r(e))}catch(t){i.progress(t)}}:function(e){i.progress(e)},c.push(function(r){r.then(e,t).then(i.resolve,i.reject,n)}),h.push(n),i.promise},m=function(e){return f(h,e),e},p=function(e){return e=t(e),d=e.then,p=t,m=y,f(c,e),h=c=C,e},l}function s(e){return e&&"function"==typeof e.then}function l(t,r,i,n,o){return v(2,arguments),e(t,function(t){function s(e){f(e)}function l(e){p(e)}var u,c,h,d,m,p,f,v,g,_;if(g=t.length>>>0,u=Math.max(0,Math.min(r,g)),h=[],c=g-u+1,d=[],m=a(),u)for(v=m.progress,f=function(e){d.push(e),--c||(p=f=y,m.reject(d))},p=function(e){h.push(e),--u||(p=f=y,m.resolve(h))},_=0;g>_;++_)_ in t&&e(t[_],l,s,v);else m.resolve(h);return m.then(i,n,o)})}function u(e,t,r,i){function n(e){return t?t(e[0]):e[0]}return l(e,1,n,r,i)}function c(e,t,r,i){return v(1,arguments),d(e,g).then(t,r,i)}function h(){return d(arguments,g)}function d(t,r){return e(t,function(t){var i,n,o,s,l,u;if(o=n=t.length>>>0,i=[],u=a(),o)for(s=function(t,n){e(t,r).then(function(e){i[n]=e,--o||u.resolve(i)},u.reject)},l=0;n>l;l++)l in t?s(t[l],l):--o;else u.resolve(i);return u.promise})}function m(t,r){var i=w.call(arguments,1);return e(t,function(t){var n;return n=t.length,i[0]=function(t,i,o){return e(t,function(t){return e(i,function(e){return r(t,e,o,n)})})},_.apply(t,i)})}function p(t,r,i){var n=arguments.length>2;return e(t,function(e){return e=n?i:e,r.resolve(e),e},function(e){return r.reject(e),o(e)},r.progress)}function f(e,t){for(var r,i=0;r=e[i++];)r(t)}function v(e,t){for(var r,i=t.length;i>e;)if(r=t[--i],null!=r&&"function"!=typeof r)throw new Error("arg "+i+" must be a function")}function y(){}function g(e){return e}var _,w,C;return e.defer=a,e.resolve=t,e.reject=r,e.join=h,e.all=c,e.map=d,e.reduce=m,e.any=u,e.some=l,e.chain=p,e.isPromise=s,i.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(C,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return c(t,function(t){return e.apply(C,t)})})}},w=[].slice,_=[].reduce||function(e){var t,r,i,n,o;if(o=0,t=Object(this),n=t.length>>>0,r=arguments,r.length<=1)for(;;){if(o in t){i=t[o++];break}if(++o>=n)throw new TypeError}else i=r[1];for(;n>o;++o)o in t&&(i=e(i,t[o],o,t));return i},e})}("function"==typeof r&&r.amd?r:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),r("Core/loadWithXhr",["./defined","./defaultValue","./DeveloperError","./RequestErrorEvent","../ThirdParty/when"],function(e,t,r,i,n){"use strict";var o=function(i){if(i=t(i,t.EMPTY_OBJECT),!e(i.url))throw new r("options.url is required.");var a=i.responseType,s=t(i.method,"GET"),l=i.data,u=i.headers;return n(i.url,function(e){var t=n.defer();return o.load(e,a,s,l,u,t),t.promise})};return o.load=function(t,r,n,o,a,s){var l=new XMLHttpRequest;if(l.open(n,t,!0),e(a))for(var u in a)a.hasOwnProperty(u)&&l.setRequestHeader(u,a[u]);e(r)&&(l.responseType=r),l.onload=function(){200===l.status?s.resolve(l.response):s.reject(new i(l.status,l.response))},l.onerror=function(){s.reject(new i)},l.send(o)},o.defaultLoad=o.load,o}),r("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,headers:r})};return t}),r("Core/loadJson",["./clone","./defined","./loadText","./DeveloperError"],function(e,t,r,i){"use strict";var n={Accept:"application/json,*/*;q=0.01"},o=function(o,a){if(!t(o))throw new i("url is required.");return t(a)?t(a.Accept)||(a=e(a),a.Accept=n.Accept):a=n,r(o,a).then(function(e){return JSON.parse(e)})};return o}),r("Core/Iau2006XysData",["./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard","../ThirdParty/when"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,t,r){var i=h;return i._julianDayNumber=t,i._secondsOfDay=r,e._sampleZeroDateTT.getDaysDifference(i)}function u(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var n=s.defer();t._chunkDownloadsInProgress[i]=n;var a,l=t._xysFileUrlTemplate;return a=r(l)?l.replace("{0}",i):e("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),s(o(a),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,o=e.samples,a=3*i*t._samplesPerXysFile,s=0,l=o.length;l>s;++s)r[a+s]=o[s];n.resolve()}),n.promise}var c=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new n(this._sampleZeroJulianEphemerisDate,0,a.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,i=this._denominators=new Array(r+1),o=this._xTable=new Array(r+1),s=Math.pow(this._stepSizeDays,r),l=0;r>=l;++l){i[l]=s,o[l]=l*this._stepSizeDays;for(var u=0;r>=u;++u)u!==l&&(i[l]*=l-u);i[l]=1/i[l]}this._work=new Array(r+1),this._coef=new Array(r+1)},h=new n(0,0,a.TAI);return c.prototype.preload=function(e,t,r,i){var n=l(this,e,t),o=l(this,r,i),a=0|n/this._stepSizeDays-this._interpolationOrder/2;0>a&&(a=0);var c=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;c>=this._totalSamples&&(c=this._totalSamples-1);for(var h=0|a/this._samplesPerXysFile,d=0|c/this._samplesPerXysFile,m=[],p=h;d>=p;++p)m.push(u(this,p));return s.all(m)},c.prototype.computeXysRadians=function(e,t,n){var o=l(this,e,t);if(0>o)return void 0;var a=0|o/this._stepSizeDays;if(a>=this._totalSamples)return void 0;var s=this._interpolationOrder,c=a-(0|s/2);0>c&&(c=0);var h=c+s;h>=this._totalSamples&&(h=this._totalSamples-1,c=h-s,0>c&&(c=0));var d=!1,m=this._samples;if(r(m[3*c])||(u(this,0|c/this._samplesPerXysFile),d=!0),r(m[3*h])||(u(this,0|h/this._samplesPerXysFile),d=!0),d)return void 0;r(n)?(n.x=0,n.y=0,n.s=0):n=new i(0,0,0);var p,f,v=o-c*this._stepSizeDays,y=this._work,g=this._denominators,_=this._coef,w=this._xTable;for(p=0;s>=p;++p)y[p]=v-w[p];for(p=0;s>=p;++p){for(_[p]=1,f=0;s>=f;++f)f!==p&&(_[p]*=y[f]);_[p]*=g[p];var C=3*(c+p);n.x+=_[p]*m[C++],n.y+=_[p]*m[C++],n.s+=_[p]*m[C]}return n},c}),r("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,r,i,n){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=i,this.ut1MinusUtc=n};return e}),r("Core/EarthOrientationParameters",["./binarySearch","./defaultValue","./defined","./freezeObject","./loadJson","./EarthOrientationParametersSample","./JulianDate","./LeapSecond","./RuntimeError","./TimeConstants","./TimeStandard","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";function d(e,t){return a.compare(e.julianDate,t)}function m(t,i){if(!r(i.columnNames))return t._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!r(i.samples))return t._dataError="Error in loaded EOP data: The samples property is required.",void 0;var n=i.columnNames.indexOf("modifiedJulianDateUtc"),o=i.columnNames.indexOf("xPoleWanderRadians"),l=i.columnNames.indexOf("yPoleWanderRadians"),h=i.columnNames.indexOf("ut1MinusUtcSeconds"),m=i.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=i.columnNames.indexOf("yCelestialPoleOffsetRadians"),f=i.columnNames.indexOf("taiMinusUtcSeconds");if(0>n||0>o||0>l||0>h||0>m||0>p||0>f)return t._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var v=t._samples=i.samples,y=t._dates=[];t._dateColumn=n,t._xPoleWanderRadiansColumn=o,t._yPoleWanderRadiansColumn=l,t._ut1MinusUtcSecondsColumn=h,t._xCelestialPoleOffsetRadiansColumn=m,t._yCelestialPoleOffsetRadiansColumn=p,t._taiMinusUtcSecondsColumn=f,t._columnCount=i.columnNames.length,t._lastIndex=void 0;for(var g,_=t._addNewLeapSeconds,w=0,C=v.length;C>w;w+=t._columnCount){var x=v[w+n],S=v[w+f],E=x+u.MODIFIED_JULIAN_DATE_DIFFERENCE,b=new a(E,S,c.TAI);if(y.push(b),_){if(S!==g&&r(g)){var T=s.getLeapSeconds(),A=e(T,b,d);if(0>A){var D=new s(b,S);T.splice(~A,0,D)}}g=S}}}function p(e,t,r,i,n){var o=r*i;n.xPoleWander=t[o+e._xPoleWanderRadiansColumn],n.yPoleWander=t[o+e._yPoleWanderRadiansColumn],n.xPoleOffset=t[o+e._xCelestialPoleOffsetRadiansColumn],n.yPoleOffset=t[o+e._yCelestialPoleOffsetRadiansColumn],n.ut1MinusUtc=t[o+e._ut1MinusUtcSecondsColumn]}function f(e,t,r){return t+e*(r-t)}function v(e,t,r,i,n,o,a){var s=e._columnCount;if(o>t.length-1)return a.xPoleWander=0,a.yPoleWander=0,a.xPoleOffset=0,a.yPoleOffset=0,a.ut1MinusUtc=0,a;var l=t[n],u=t[o];if(l.equals(u)||i.equals(l))return p(e,r,n,s,a),a;if(i.equals(u))return p(e,r,o,s,a),a;var c=l.getSecondsDifference(i)/l.getSecondsDifference(u),h=n*s,d=o*s,m=r[h+e._ut1MinusUtcSecondsColumn],v=r[d+e._ut1MinusUtcSecondsColumn],y=v-m;if(y>.5||-.5>y){var g=r[h+e._taiMinusUtcSecondsColumn],_=r[d+e._taiMinusUtcSecondsColumn];g!==_&&(u.equals(i)?m=v:v-=_-g)}return a.xPoleWander=f(c,r[h+e._xPoleWanderRadiansColumn],r[d+e._xPoleWanderRadiansColumn]),a.yPoleWander=f(c,r[h+e._yPoleWanderRadiansColumn],r[d+e._yPoleWanderRadiansColumn]),a.xPoleOffset=f(c,r[h+e._xCelestialPoleOffsetRadiansColumn],r[d+e._xCelestialPoleOffsetRadiansColumn]),a.yPoleOffset=f(c,r[h+e._yCelestialPoleOffsetRadiansColumn],r[d+e._yCelestialPoleOffsetRadiansColumn]),a.ut1MinusUtc=f(c,m,v),a}var y=function(e){if(e=t(e,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(e.addNewLeapSeconds,!0),r(e.data))m(this,e.data);else if(r(e.url)){var i=this;this._downloadPromise=h(n(e.url),function(e){m(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+e.url+"."})}else m(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return y.NONE=i({getPromiseToLoad:function(){return h()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new o(0,0,0,0,0),t}}),y.prototype.getPromiseToLoad=function(){return h(this._downloadPromise)},y.prototype.compute=function(t,i){if(!r(this._samples)){if(r(this._dataError))throw new l(this._dataError);return void 0}if(r(i)||(i=new o(0,0,0,0,0)),0===this._samples.length)return i.xPoleWander=0,i.yPoleWander=0,i.xPoleOffset=0,i.yPoleOffset=0,i.ut1MinusUtc=0,i;var n=this._dates,s=this._lastIndex,u=0,c=0;if(r(s)){var h=n[s],d=n[s+1],m=h.lessThanOrEquals(t),p=!r(d),f=p||d.greaterThanOrEquals(t);if(m&&f)return u=s,!p&&d.equals(t)&&++u,c=u+1,v(this,n,this._samples,t,u,c,i),i}var y=e(n,t,a.compare,this._dateColumn);return y>=0?(y<n.length-1&&n[y+1].equals(t)&&++y,u=y,c=y):(c=~y,u=c-1,0>u&&(u=0)),this._lastIndex=u,v(this,n,this._samples,t,u,c,i),i},y}),r("Core/Transforms",["./defaultValue","./defined","./DeveloperError","./Iau2006XysData","./Iau2006XysSample","./Math","./Matrix3","./Matrix4","./Cartesian2","./Cartesian3","./Cartesian4","./TimeConstants","./Ellipsoid","./EarthOrientationParameters","./EarthOrientationParametersSample","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f){"use strict";var v={},y=new u,g=new u,_=new u;v.eastNorthUpToFixedFrame=function(r,i,n){if(o.equalsEpsilon(r.x,0,o.EPSILON14)&&o.equalsEpsilon(r.y,0,o.EPSILON14)){var a=o.sign(r.z);return t(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-a,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=a,n[11]=0,n[12]=r.x,n[13]=r.y,n[14]=r.z,n[15]=1,n):new s(0,-a,0,r.x,1,0,0,r.y,0,0,a,r.z,0,0,0,1)}var l=y,c=g,h=_;return i=e(i,d.WGS84),i.geodeticSurfaceNormal(r,l),c.x=-r.y,c.y=r.x,c.z=0,u.normalize(c,c),u.cross(l,c,h),t(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=h.x,n[5]=h.y,n[6]=h.z,n[7]=0,n[8]=l.x,n[9]=l.y,n[10]=l.z,n[11]=0,n[12]=r.x,n[13]=r.y,n[14]=r.z,n[15]=1,n):new s(c.x,h.x,l.x,r.x,c.y,h.y,l.y,r.y,c.z,h.z,l.z,r.z,0,0,0,1)};var w=new u,C=new u,x=new u;v.northEastDownToFixedFrame=function(r,i,n){if(o.equalsEpsilon(r.x,0,o.EPSILON14)&&o.equalsEpsilon(r.y,0,o.EPSILON14)){var a=o.sign(r.z);return t(n)?(n[0]=-a,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-a,n[11]=0,n[12]=r.x,n[13]=r.y,n[14]=r.z,n[15]=1,n):new s(-a,0,0,r.x,0,1,0,r.y,0,0,-a,r.z,0,0,0,1)}var l=w,c=C,h=x;return i=e(i,d.WGS84),i.geodeticSurfaceNormal(r,l),c.x=-r.y,c.y=r.x,c.z=0,u.normalize(c,c),u.cross(l,c,h),t(n)?(n[0]=h.x,n[1]=h.y,n[2]=h.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=-l.x,n[9]=-l.y,n[10]=-l.z,n[11]=0,n[12]=r.x,n[13]=r.y,n[14]=r.z,n[15]=1,n):new s(h.x,c.x,-l.x,r.x,h.y,c.y,-l.y,r.y,h.z,c.z,-l.z,r.z,0,0,0,1)};var S=24110.54841,E=8640184.812866,b=.093104,T=-62e-7,A=1.1772758384668e-19,D=72921158553e-15,P=o.TWO_PI/86400;v.computeTemeToPseudoFixedMatrix=function(e,r){var i,n=e.addSeconds(-e.getTaiMinusUtc()),s=n.getJulianDayNumber(),l=n.getSecondsOfDay(),u=s-2451545;i=l>=43200?(u+.5)/h.DAYS_PER_JULIAN_CENTURY:(u-.5)/h.DAYS_PER_JULIAN_CENTURY;var c=S+i*(E+i*(b+i*T)),d=c*P%o.TWO_PI,m=D+A*(s-2451545.5),p=(l+.5*h.SECONDS_PER_DAY)%h.SECONDS_PER_DAY,f=d+m*p,v=Math.cos(f),y=Math.sin(f);return t(r)?(r[0]=v,r[1]=-y,r[2]=0,r[3]=y,r[4]=v,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new a(v,y,0,-y,v,0,0,0,1)},v.iau2006XysData=new i,v.earthOrientationParameters=m.NONE;var M=32.184,I=2451545;v.preloadIcrfFixed=function(e){var t=e.start.getJulianDayNumber(),r=e.start.getSecondsOfDay()+M,i=e.stop.getJulianDayNumber(),n=e.stop.getSecondsOfDay()+M,o=v.iau2006XysData.preload(t,r,i,n),a=v.earthOrientationParameters.getPromiseToLoad();return f.all([o,a])},v.computeIcrfToFixedMatrix=function(e,r){var i=v.computeFixedToIcrfMatrix(e,r);return t(i)?a.transpose(i,r):void 0};var O=new n(0,0,0),R=new p(0,0,0,0,0,0),L=new a,z=new a;v.computeFixedToIcrfMatrix=function(e,r){var i=v.earthOrientationParameters.compute(e,R);if(!t(i))return void 0;var n=e.getJulianDayNumber(),s=e.getSecondsOfDay()+M,l=v.iau2006XysData.computeXysRadians(n,s,O);if(!t(l))return void 0;var u=l.x+i.xPoleOffset,c=l.y+i.yPoleOffset,d=1/(1+Math.sqrt(1-u*u-c*c)),m=L;m[0]=1-d*u*u,m[3]=-d*u*c,m[6]=u,m[1]=-d*u*c,m[4]=1-d*c*c,m[7]=c,m[2]=-u,m[5]=-c,m[8]=1-d*(u*u+c*c);var p=a.fromRotationZ(-l.s,z),f=a.multiply(m,p,L),y=e.getJulianDayNumber(),g=e.getSecondsOfDay()-e.getTaiMinusUtc()+i.ut1MinusUtc,_=y-2451545,w=g/h.SECONDS_PER_DAY,C=.779057273264+w+.00273781191135448*(_+w);C=C%1*o.TWO_PI;var x=a.fromRotationZ(C,z),S=a.multiply(f,x,L),E=Math.cos(i.xPoleWander),b=Math.cos(i.yPoleWander),T=Math.sin(i.xPoleWander),A=Math.sin(i.yPoleWander),D=n-I+s/h.SECONDS_PER_DAY;D/=36525;var P=-47e-6*D*o.RADIANS_PER_DEGREE/3600,N=Math.cos(P),B=Math.sin(P),F=z;return F[0]=E*N,F[1]=E*B,F[2]=T,F[3]=-b*B+A*T*N,F[4]=b*N+A*T*B,F[5]=-A*E,F[6]=-A*B-b*T*N,F[7]=A*N-b*T*B,F[8]=b*E,a.multiply(S,F,r)};var N=new c;return v.pointToWindowCoordinates=function(e,t,r,i){var n=N;return s.multiplyByVector(e,c.fromElements(r.x,r.y,r.z,1,n),n),c.multiplyByScalar(n,1/n.w,n),s.multiplyByVector(t,n,n),l.fromCartesian4(n,i)},v}),r("Core/Ray",["./DeveloperError","./defaultValue","./Cartesian3"],function(e,t,r){"use strict";var i=function(e,i){i=r.clone(t(i,r.ZERO)),r.equals(i,r.ZERO)||r.normalize(i,i),this.origin=r.clone(t(e,r.ZERO)),this.direction=i};return i.prototype.getPoint=function(t,i){if("number"!=typeof t)throw new e("t is a required number");return i=r.multiplyByScalar(this.direction,t,i),r.add(this.origin,i,i)},i}),r("Core/EllipsoidTangentPlane",["./defaultValue","./defined","./DeveloperError","./Transforms","./AxisAlignedBoundingBox","./IntersectionTests","./Cartesian2","./Cartesian3","./Ellipsoid","./Matrix4","./Ray","./Plane"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";var d=function(n,o){if(!t(n))throw new r("origin is required.");if(o=e(o,l.WGS84),n=o.scaleToGeodeticSurface(n),!t(n))throw new r("origin must not be at the center of the ellipsoid.");var a=i.eastNorthUpToFixedFrame(n,o);this._ellipsoid=o,this._origin=s.clone(n),this._xAxis=s.fromCartesian4(u.getColumn(a,0)),this._yAxis=s.fromCartesian4(u.getColumn(a,1));var c=s.fromCartesian4(u.getColumn(a,2));this._plane=h.fromPointNormal(n,c)},m=new n;d.fromPoints=function(e,i){if(!t(e))throw new r("cartesians is required.");var o=n.fromPoints(e,m);return new d(o.center,i)},d.prototype.getEllipsoid=function(){return this._ellipsoid},d.prototype.getOrigin=function(){return this._origin};var p=new c,f=new s;d.prototype.projectPointOntoPlane=function(e,i){if(!t(e))throw new r("cartesian is required.");var n=p;n.origin=e,s.normalize(e,n.direction);var l=o.rayPlane(n,this._plane,f);if(t(l)||(s.negate(n.direction,n.direction),l=o.rayPlane(n,this._plane,f)),t(l)){var u=s.subtract(l,this._origin,l),c=s.dot(this._xAxis,u),h=s.dot(this._yAxis,u);return t(i)?(i.x=c,i.y=h,i):new a(c,h)}return void 0},d.prototype.projectPointsOntoPlane=function(e,i){if(!t(e))throw new r("cartesians is required.");t(i)||(i=[]);for(var n=0,o=e.length,a=0;o>a;a++){var s=this.projectPointOntoPlane(e[a],i[n]);t(s)&&(i[n]=s,n++)}return i.length=n,i};var v=new s;return d.prototype.projectPointsOntoEllipsoid=function(e,i){if(!t(e))throw new r("cartesians is required.");var n=e.length;t(i)?i.length=n:i=new Array(n);for(var o=this._ellipsoid,a=this._origin,l=this._xAxis,u=this._yAxis,c=v,h=0;n>h;++h){var d=e[h];s.multiplyByScalar(l,d.x,c);var m=i[h]=s.add(a,c,i[h]);s.multiplyByScalar(u,d.y,c),s.add(m,c,m),o.scaleToGeocentricSurface(m,m)}return i},d}),r("Core/EllipsoidGeodesic",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Math","./Cartesian3","./Cartographic"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){var t=e._uSquared,r=e._ellipsoid.getMaximumRadius(),i=e._ellipsoid.getMinimumRadius(),n=(r-i)/r,o=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-n)*Math.tan(e._start.latitude),l=1/Math.sqrt(1+s*s),u=l*s,c=Math.atan2(s,o),h=l*a,d=h*h,m=1-d,p=Math.sqrt(m),f=t/4,v=f*f,y=v*f,g=v*v,_=1+f-3*v/4+5*y/4-175*g/64,w=1-f+15*v/8-35*y/8,C=1-3*f+35*v/4,x=1-5*f,S=_*c-w*Math.sin(2*c)*f/2-C*Math.sin(4*c)*v/16-x*Math.sin(6*c)*y/48-5*Math.sin(8*c)*g/512,E=e._constants;E.a=r,E.b=i,E.f=n,E.cosineHeading=o,E.sineHeading=a,E.tanU=s,E.cosineU=l,E.sineU=u,E.sigma=c,E.sineAlpha=h,E.sineSquaredAlpha=d,E.cosineSquaredAlpha=m,E.cosineAlpha=p,E.u2Over4=f,E.u4Over16=v,E.u6Over64=y,E.u8Over256=g,E.a0=_,E.a1=w,E.a2=C,E.a3=x,E.distanceRatio=S}function u(e,t){return e*t*(4+e*(4-3*t))/16}function c(e,t,r,i,n,o,a){var s=u(e,r);return(1-s)*e*t*(i+s*n*(a+s*o*(2*a*a-1)))}function h(e,t,r,i,n,a,s){var l,u,h,d,m,p=(t-r)/t,f=a-i,v=Math.atan((1-p)*Math.tan(n)),y=Math.atan((1-p)*Math.tan(s)),g=Math.cos(v),_=Math.sin(v),w=Math.cos(y),C=Math.sin(y),x=g*w,S=g*C,E=_*C,b=_*w,T=f,A=o.TWO_PI,D=Math.cos(T),P=Math.sin(T);do{D=Math.cos(T),P=Math.sin(T);var M=S-b*D;h=Math.sqrt(w*w*P*P+M*M),u=E+x*D,l=Math.atan2(h,u);var I;0===h?(I=0,d=1):(I=x*P/h,d=1-I*I),A=T,m=u-2*E/d,isNaN(m)&&(m=0),T=f+c(p,I,d,l,h,u,m)}while(Math.abs(T-A)>o.EPSILON12);var O=d*(t*t-r*r)/(r*r),R=1+O*(4096+O*(O*(320-175*O)-768))/16384,L=O*(256+O*(O*(74-47*O)-128))/1024,z=m*m,N=L*h*(m+L*(u*(2*z-1)-L*m*(4*h*h-3)*(4*z-3)/6)/4),B=r*R*(l-N),F=Math.atan2(w*P,S-b*D),V=Math.atan2(g*P,S*D-b);e._distance=B,e._startHeading=F,e._endHeading=V,e._uSquared=O}function d(e,t,r,n){var o=a.normalize(n.cartographicToCartesian(t,p),m),u=a.normalize(n.cartographicToCartesian(r,p),p);if(Math.abs(Math.abs(a.angleBetween(o,u))-Math.PI)<.0125)throw new i("geodesic position is not unique");h(e,n.getMaximumRadius(),n.getMinimumRadius(),t.longitude,t.latitude,r.longitude,r.latitude),t.height=0,r.height=0,e._start=s.clone(t,e._start),e._end=s.clone(r,e._end),l(e)}var m=new a,p=new a,f=function(e,i,o){var a=t(o,n.WGS84);this._ellipsoid=a,this._start=new s,this._end=new s,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,r(e)&&r(i)&&d(this,e,i,a)};return f.prototype.getSurfaceDistance=function(){if(!r(this._distance))throw new i("start and end must be set before calling funciton getSurfaceDistance");return this._distance},f.prototype.setEndPoints=function(e,t){if(!r(e))throw new i("start cartographic position is required");if(!r(t))throw new i("end cartgraphic position is required");d(this,e,t,this._ellipsoid)},f.prototype.getStart=function(){return this._start},f.prototype.getEnd=function(){return this._end},f.prototype.getStartHeading=function(){if(!r(this._distance))throw new i("start and end must be set before calling funciton getStartHeading");return this._startHeading},f.prototype.getEndHeading=function(){if(!r(this._distance))throw new i("start and end must be set before calling funciton getEndHeading");return this._endHeading},f.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},f.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!r(this._distance))throw new i("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var n=this._constants,o=n.distanceRatio+e/n.b,a=Math.cos(2*o),l=Math.cos(4*o),u=Math.cos(6*o),h=Math.sin(2*o),d=Math.sin(4*o),m=Math.sin(6*o),p=Math.sin(8*o),f=o*o,v=o*f,y=n.u8Over256,g=n.u2Over4,_=n.u6Over64,w=n.u4Over16,C=2*v*y*a/3+o*(1-g+7*w/4-15*_/4+579*y/64-(w-15*_/4+187*y/16)*a-(5*_/4-115*y/16)*l-29*y*u/16)+(g/2-w+71*_/32-85*y/16)*h+(5*w/16-5*_/4+383*y/96)*d-f*((_-11*y/2)*h+5*y*d/2)+(29*_/96-29*y/16)*m+539*y*p/1536,x=Math.asin(Math.sin(C)*n.cosineAlpha),S=Math.atan(n.a/n.b*Math.tan(x));C-=n.sigma;var E=Math.cos(2*n.sigma+C),b=Math.sin(C),T=Math.cos(C),A=n.cosineU*T,D=n.sineU*b,P=Math.atan2(b*n.sineHeading,A-D*n.cosineHeading),M=P-c(n.f,n.sineAlpha,n.cosineSquaredAlpha,C,b,T,E);return r(t)?(t.longitude=this._start.longitude+M,t.latitude=S,t.height=0,t):new s(this._start.longitude+M,S,0)},f}),r("Core/PolylinePipeline",["./defaultValue","./defined","./DeveloperError","./Cartographic","./Cartesian3","./Cartesian4","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./Math","./Matrix4","./Plane"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";function d(e,t,r,i){var o=i.scaleToGeodeticSurface(e,T),a=i.scaleToGeodeticSurface(t,A),s=n.angleBetween(o,a),l=Math.ceil(s/r),u=new Array(3*l),c=i.cartesianToCartographic(o,S),h=i.cartesianToCartographic(a,E);D.setEndPoints(c,h);var d=D.getSurfaceDistance()/l,m=0;c.height=0;var p=i.cartographicToCartesian(c,b);u[m++]=p.x,u[m++]=p.y,u[m++]=p.z;for(var f=1;l>f;f++){var v=D.interpolateUsingSurfaceDistance(f*d,E);p=i.cartographicToCartesian(v,b),u[m++]=p.x,u[m++]=p.y,u[m++]=p.z}return u}function m(e,t,r){var i=P;return r.geodeticSurfaceNormal(e,i),n.multiplyByScalar(i,t,i),n.add(e,i,e),e}var p={},f=new c,v=new n,y=new n,g=new h(n.ZERO,0),_=new n,w=new h(n.ZERO,0),C=new n,x=new n,S=new i,E=new i,b=new n,T=new n,A=new n,D=new s,P=new n,M=new n;return p.wrapLongitude=function(r,i){var o=[],a=[];if(t(r)&&r.length>0){i=e(i,c.IDENTITY);var s=c.inverseTransformation(i,f),u=c.multiplyByPoint(s,n.ZERO,v),d=c.multiplyByPointAsVector(s,n.UNIT_Y,y),m=h.fromPointNormal(u,d,g),p=c.multiplyByPointAsVector(s,n.UNIT_X,_),S=h.fromPointNormal(u,p,w),E=1;o.push(n.clone(r[0]));for(var b=o[0],T=r.length,A=1;T>A;++A){var D=r[A];if(h.getPointDistance(S,b)<0||h.getPointDistance(S,D)<0){var P=l.lineSegmentPlane(b,D,m,C);if(t(P)){var M=n.multiplyByScalar(d,5e-9,x);h.getPointDistance(m,b)<0&&n.negate(M,M),o.push(n.add(P,M)),a.push(E+1),n.negate(M,M),o.push(n.add(P,M)),E=1}}o.push(n.clone(r[A])),E++,b=D}a.push(E)}return{positions:o,lengths:a}},p.removeDuplicates=function(e){if(!t(e))throw new r("positions is required.");var i=e.length;if(2>i)return e.slice(0);var o=[];o.push(e[0]);for(var a=1;i>a;++a){var s=e[a-1],l=e[a];n.equals(s,l)||o.push(l)}return o},p.scaleToSurface=function(i,n,o){if(!t(i))throw new r("positions is required");n=e(n,u.RADIANS_PER_DEGREE),o=e(o,a.WGS84);for(var s=i.length,l=[],c=0;s-1>c;c++){var h=i[c],m=i[c+1];l=l.concat(d(h,m,n,o))}var p=i[s-1],f=o.cartesianToCartographic(p,S);f.height=0;var v=o.cartographicToCartesian(f,b);return l.push(v.x,v.y,v.z),l},p.scaleToGeodeticHeight=function(i,o,s,l){if(!t(i))throw new r("positions must be defined.");if(!t(o))throw new r("height must be defined");s=e(s,a.WGS84);var u,c,h=i.length,d=M;if(t(l)){if(l.length!==i.length)throw new r("result.length must be equal to positions.length");c=l}else c=new Array(i.length);if(0===o){for(u=0;h>u;u+=3)d=s.scaleToGeodeticSurface(n.fromArray(i,u,d),d),c[u]=d.x,c[u+1]=d.y,c[u+2]=d.z;return c}var p;if(Array.isArray(o)){if(o.length!==h/3)throw new r("height.length must be equal to positions.length");for(u=0;h>u;u+=3)p=o[u/3],d=n.fromArray(i,u,d),d=m(d,p,s),c[u]=d.x,c[u+1]=d.y,c[u+2]=d.z}else for(p=o,u=0;h>u;u+=3)d=n.fromArray(i,u,d),d=m(d,p,s),c[u]=d.x,c[u+1]=d.y,c[u+2]=d.z;return c},p}),r("Core/PolylineVolumeGeometryLibrary",["./defined","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./DeveloperError","./EllipsoidTangentPlane","./PolylinePipeline","./Matrix3","./Matrix4","./Quaternion","./Transforms","./Math"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m){"use strict";function p(e,t){for(var r=new Array(e.length),i=0;i<e.length;i++){var n=e[i];N=t.cartesianToCartographic(n,N),r[i]=N.height,e[i]=t.scaleToGeodeticSurface(n,n)}return r}function f(e,t,i,n){var o,a=e[0],s=e[1],l=r.angleBetween(a,s),u=Math.ceil(l/n),c=new Array(u);if(t===i){for(o=0;u>o;o++)c[o]=t;return c.push(i),c}var h=i-t,d=h/u;for(o=1;u>o;o++){var m=t+o*d;c[o]=m}return c[0]=t,c.push(i),c}function v(e,i,n,o){var a=new s(n,o),l=a.projectPointOntoPlane(r.add(n,e,Z),Z),u=a.projectPointOntoPlane(r.add(n,i,J),J),c=t.angleBetween(l,u);return u.x*l.y-u.y*l.x>=0?-c:c}function y(e,t,i,n,o,a,s,l){var h=W,m=q;F=d.eastNorthUpToFixedFrame(e,o,F),h=c.multiplyByPointAsVector(F,B,h),h=r.normalize(h,h);var p=v(h,t,e,o);k=u.fromRotationZ(p,k),G.z=a,F=c.multiplyTransformation(F,c.fromRotationTranslation(k,G,V),F);var f=U;f[0]=s;for(var y=0;l>y;y++)for(var g=0;g<i.length;g+=3)m=r.fromArray(i,g,m),m=u.multiplyByVector(f,m,m),m=c.multiplyByPoint(F,m,m),n.push(m.x,m.y,m.z);return n}function g(e,t,i,n,o,a,s){for(var l=0;l<e.length;l+=3){var u=r.fromArray(e,l,H);n=y(u,t,i,n,o,a[l/3],s,1)}return n}function _(e,t){var r=e.length,i=new Array(6*r),n=0,o=t.x+t.width/2,a=t.y+t.height/2,s=e[0];i[n++]=s.x-o,i[n++]=0,i[n++]=s.y-a;for(var l=1;r>l;l++){s=e[l];var u=s.x-o,c=s.y-a;i[n++]=u,i[n++]=0,i[n++]=c,i[n++]=u,i[n++]=0,i[n++]=c}return s=e[0],i[n++]=s.x-o,i[n++]=0,i[n++]=s.y-a,i}function w(e,t){for(var r=e.length,i=new Array(3*r),n=0,o=t.x+t.width/2,a=t.y+t.height/2,s=0;r>s;s++)i[n++]=e[s].x-o,i[n++]=0,i[n++]=e[s].y-a;return i}function C(e,t,i,n,a,s,l,c,d,p){var f,v=r.angleBetween(r.subtract(t,e,R),r.subtract(i,e,L)),g=n.value===o.BEVELED.value?0:Math.ceil(v/m.toRadians(5));f=a?u.fromQuaternion(h.fromAxisAngle(r.negate(e,R),v/(g+1),j),X):u.fromQuaternion(h.fromAxisAngle(e,v/(g+1),j),X);var _,w;if(t=r.clone(t,Y),g>0)for(var C=p?2:1,x=0;g>x;x++)t=u.multiplyByVector(f,t,t),_=r.subtract(t,e,R),_=r.normalize(_,_),a||(_=r.negate(_,_)),w=s.scaleToGeodeticSurface(t,L),l=y(w,_,c,l,s,d,1,C);else _=r.subtract(t,e,R),_=r.normalize(_,_),a||(_=r.negate(_,_)),w=s.scaleToGeodeticSurface(t,L),l=y(w,_,c,l,s,d,1,1),i=r.clone(i,Y),_=r.subtract(i,e,R),_=r.normalize(_,_),a||(_=r.negate(_,_)),w=s.scaleToGeodeticSurface(i,L),l=y(w,_,c,l,s,d,1,1);return l}function x(e,t){return m.equalsEpsilon(e.latitude,t.latitude,m.EPSILON6)&&m.equalsEpsilon(e.longitude,t.longitude,m.EPSILON6)}var S=[new r,new r],E=new r,b=new r,T=new r,A=new r,D=new r,P=new r,M=new r,I=new r,O=new r,R=new r,L=new r,z={},N=new n,B=new r(-1,0,0),F=new c,V=new c,k=new u,U=u.IDENTITY.clone(),W=new r,q=new i,G=new r,H=new r,j=new h,Y=new r,X=new u;z.removeDuplicatesFromShape=function(e){for(var r=e.length,i=[],n=r-1,o=0;r>o;n=o++){var a=e[n],s=e[o];
t.equals(a,s)||i.push(s)}return i};var Z=new r,J=new r;z.angleIsGreaterThanPi=function(e,t,i,n){var o=new s(i,n),a=o.projectPointOntoPlane(r.add(i,e,Z),Z),l=o.projectPointOntoPlane(r.add(i,t,J),J);return l.x*a.y-l.y*a.x>=0};var K=new n,Q=new n;return z.removeDuplicatesFromPositions=function(e,t){var r=e.length;if(2>r)return e.slice(0);var i=[];i.push(e[0]);for(var n=1;r>n;++n){var o=e[n-1],a=e[n],s=t.cartesianToCartographic(o,K),l=t.cartesianToCartographic(a,Q);x(s,l)||i.push(a)}return i},z.computePositions=function(e,t,i,n,a){var s=n._ellipsoid,u=p(e,s),c=n._granularity,h=n._cornerType,d=a?_(t,i):w(t,i),v=a?w(t,i):void 0,x=i.height/2,L=i.width/2,N=e.length,B=[],F=a?[]:void 0,V=E,k=b,U=T,W=A,q=D,G=P,H=M,j=I,Y=O,X=e[0],Z=e[1];W=s.geodeticSurfaceNormal(X,W),V=r.subtract(Z,X,V),V=r.normalize(V,V),j=r.cross(W,V,j),j=r.normalize(j,j);var J=u[0],K=u[1];a&&(F=y(X,j,v,F,s,J+x,1,1)),Y=r.clone(X,Y),X=Z,k=r.negate(V,k);for(var Q,$,et=1;N-1>et;et++){var tt=a?2:1;Z=e[et+1],V=r.subtract(Z,X,V),V=r.normalize(V,V),U=r.add(V,k,U),U=r.normalize(U,U),W=s.geodeticSurfaceNormal(X,W);var rt=!r.equalsEpsilon(r.negate(U,R),W,m.EPSILON2);if(rt){U=r.cross(U,W,U),U=r.cross(W,U,U),U=r.normalize(U,U);var it=1/Math.max(.25,r.magnitude(r.cross(U,k,R))),nt=z.angleIsGreaterThanPi(V,k,X,s);nt?(q=r.add(X,r.multiplyByScalar(U,it*L,U),q),G=r.add(q,r.multiplyByScalar(j,L,G),G),S[0]=r.clone(Y,S[0]),S[1]=r.clone(G,S[1]),Q=f(S,J+x,K+x,c),$=l.scaleToSurface(S),B=g($,j,d,B,s,Q,1),j=r.cross(W,V,j),j=r.normalize(j,j),H=r.add(q,r.multiplyByScalar(j,L,H),H),h.value===o.ROUNDED.value||h.value===o.BEVELED.value?C(q,G,H,h,nt,s,B,d,K+x,a):(U=r.negate(U,U),B=y(X,U,d,B,s,K+x,it,tt)),Y=r.clone(H,Y)):(q=r.add(X,r.multiplyByScalar(U,it*L,U),q),G=r.add(q,r.multiplyByScalar(j,-L,G),G),S[0]=r.clone(Y,S[0]),S[1]=r.clone(G,S[1]),Q=f(S,J+x,K+x,c),$=l.scaleToSurface(S,c,s),B=g($,j,d,B,s,Q,1),j=r.cross(W,V,j),j=r.normalize(j,j),H=r.add(q,r.multiplyByScalar(j,-L,H),H),h.value===o.ROUNDED.value||h.value===o.BEVELED.value?C(q,G,H,h,nt,s,B,d,K+x,a):B=y(X,U,d,B,s,K+x,it,tt),Y=r.clone(H,Y)),k=r.negate(V,k)}else B=y(Y,j,d,B,s,J+x,1,1),Y=X;J=K,K=u[et+1],X=Z}S[0]=r.clone(Y,S[0]),S[1]=r.clone(X,S[1]),Q=f(S,J+x,K+x,c),$=l.scaleToSurface(S,c,s),B=g($,j,d,B,s,Q,1),a&&(F=y(X,j,v,F,s,K+x,1,1)),N=B.length;var ot=a?N+F.length:N,at=new Float64Array(ot);return at.set(B),a&&at.set(F,N),at},z}),r("Core/CorridorGeometryLibrary",["./defined","./Cartesian2","./Cartesian3","./CornerType","./EllipsoidTangentPlane","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./Matrix3","./Quaternion","./Math"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e,t,n,o,a){var c=r.angleBetween(r.subtract(t,e,v),r.subtract(n,e,y)),h=o.value===i.BEVELED.value?1:Math.ceil(c/u.toRadians(5))+1,d=3*h,m=new Array(d);m[d-3]=n.x,m[d-2]=n.y,m[d-1]=n.z;var p;p=a?s.fromQuaternion(l.fromAxisAngle(r.negate(e,v),c/h,I),O):s.fromQuaternion(l.fromAxisAngle(e,c/h,I),O);var f=0;t=r.clone(t,v);for(var g=0;h>g;g++)t=s.multiplyByVector(p,t,t),m[f++]=t.x,m[f++]=t.y,m[f++]=t.z;return m}function h(e){var t=C,n=x,o=S,a=e[1];n=r.fromArray(e[1],a.length-3,n),o=r.fromArray(e[0],0,o),t=r.multiplyByScalar(r.add(n,o,t),.5,t);var s=c(t,n,o,i.ROUNDED,!1),l=e.length-1,u=e[l-1];a=e[l],n=r.fromArray(u,u.length-3,n),o=r.fromArray(a,0,o),t=r.multiplyByScalar(r.add(n,o,t),.5,t);var h=c(t,n,o,i.ROUNDED,!1);return[s,h]}function d(e,t,i,n){var o=v;return n?o=r.add(e,t,o):(t=r.negate(t,t),o=r.add(e,t,o)),[o.x,o.y,o.z,i.x,i.y,i.z]}function m(e,t,i,n){for(var o=new Array(e.length),a=new Array(e.length),s=r.multiplyByScalar(t,i,v),l=r.negate(s,y),u=0,c=e.length-1,h=0;h<e.length;h+=3){var d=r.fromArray(e,h,g),m=r.add(d,l,_);o[u++]=m.x,o[u++]=m.y,o[u++]=m.z;var p=r.add(d,s,_);a[c--]=p.z,a[c--]=p.y,a[c--]=p.x}return n.push(o,a),n}function p(e,t){for(var r=0;r<e.length;r++)e[r]=t.scaleToGeodeticSurface(e[r],e[r]);return e}var f={},v=new r,y=new r,g=new r,_=new r,w=[new r,new r],C=new r,x=new r,S=new r,E=new r,b=new r,T=new r,A=new r,D=new r,P=new r,M=new r,I=new l,O=new s;return f.addAttribute=function(t,r,i,n){var o=r.x,a=r.y,s=r.z;e(i)&&(t[i]=o,t[i+1]=a,t[i+2]=s),e(n)&&(t[n]=s,t[n-1]=a,t[n-2]=o)},f.computePositions=function(e){var t=e.granularity,n=e.positions,s=e.ellipsoid;n=p(n,s);var l=e.width/2,f=e.cornerType,y=e.saveAttributes,g=C,_=x,I=S,O=E,R=b,L=T,z=A,N=D,B=P,F=M,V=[],k=y?[]:void 0,U=y?[]:void 0,W=n[0],q=n[1];_=r.normalize(r.subtract(q,W,_),_),g=s.geodeticSurfaceNormal(W,g),O=r.normalize(r.cross(g,_,O),O),y&&(k.push(O.x,O.y,O.z),U.push(g.x,g.y,g.z)),z=r.clone(W,z),W=q,I=r.negate(_,I);var G,H,j=[],Y=n.length;for(H=1;Y-1>H;H++){g=s.geodeticSurfaceNormal(W,g),q=n[H+1],_=r.normalize(r.subtract(q,W,_),_),R=r.normalize(r.add(_,I,R),R);var X=!r.equalsEpsilon(r.negate(R,v),g,u.EPSILON2);if(X){R=r.cross(R,g,R),R=r.cross(g,R,R);var Z=l/Math.max(.25,r.magnitude(r.cross(R,I,v))),J=a.angleIsGreaterThanPi(_,I,W,s);R=r.multiplyByScalar(R,Z,R),J?(N=r.add(W,R,N),F=r.add(N,r.multiplyByScalar(O,l,F),F),B=r.add(N,r.multiplyByScalar(O,2*l,B),B),w[0]=r.clone(z,w[0]),w[1]=r.clone(F,w[1]),G=o.scaleToSurface(w,t,s),V=m(G,O,l,V),y&&(k.push(O.x,O.y,O.z),U.push(g.x,g.y,g.z)),L=r.clone(B,L),O=r.normalize(r.cross(g,_,O),O),B=r.add(N,r.multiplyByScalar(O,2*l,B),B),z=r.add(N,r.multiplyByScalar(O,l,z),z),f.value===i.ROUNDED.value||f.value===i.BEVELED.value?j.push({leftPositions:c(N,L,B,f,J)}):j.push({leftPositions:d(W,r.negate(R,R),B,J)})):(B=r.add(W,R,B),F=r.add(B,r.negate(r.multiplyByScalar(O,l,F),F),F),N=r.add(B,r.negate(r.multiplyByScalar(O,2*l,N),N),N),w[0]=r.clone(z,w[0]),w[1]=r.clone(F,w[1]),G=o.scaleToSurface(w,t,s),V=m(G,O,l,V),y&&(k.push(O.x,O.y,O.z),U.push(g.x,g.y,g.z)),L=r.clone(N,L),O=r.normalize(r.cross(g,_,O),O),N=r.add(B,r.negate(r.multiplyByScalar(O,2*l,N),N),N),z=r.add(B,r.negate(r.multiplyByScalar(O,l,z),z),z),f.value===i.ROUNDED.value||f.value===i.BEVELED.value?j.push({rightPositions:c(B,L,N,f,J)}):j.push({rightPositions:d(W,R,N,J)})),I=r.negate(_,I)}W=q}g=s.geodeticSurfaceNormal(W,g),w[0]=r.clone(z,w[0]),w[1]=r.clone(W,w[1]),G=o.scaleToSurface(w,t,s),V=m(G,O,l,V),y&&(k.push(O.x,O.y,O.z),U.push(g.x,g.y,g.z));var K;return f.value===i.ROUNDED.value&&(K=h(V,l,s)),{positions:V,corners:j,lefts:k,normals:U,endPositions:K}},f}),r("Core/CorridorGeometry",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./CornerType","./CorridorGeometryLibrary","./ComponentDatatype","./Ellipsoid","./Geometry","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./BoundingSphere","./GeometryAttribute","./GeometryAttributes","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v){"use strict";function y(e,t,r,n,a,s){var l=e.normals,u=e.tangents,c=e.binormals,h=i.normalize(i.cross(r,t,D),D);s.normal&&o.addAttribute(l,t,n,a),s.binormal&&o.addAttribute(c,r,n,a),s.tangent&&o.addAttribute(u,h,n,a)}function g(e,r,n){var s,l,h,d=e.positions,m=e.corners,v=e.endPositions,g=e.lefts,_=e.normals,w=new f,C=0,T=0,M=0;for(l=0;l<d.length;l+=2)h=d[l].length-3,C+=h,M+=2*h,T+=d[l+1].length-3;for(C+=3,T+=3,l=0;l<m.length;l++){s=m[l];var I=m[l].leftPositions;t(I)?(h=I.length,C+=h,M+=h):(h=m[l].rightPositions.length,T+=h,M+=h)}var O,R=t(v);R&&(O=v[0].length-3,C+=O,T+=O,O/=3,M+=6*O);var L,z,N,B,F,V,k=C+T,U=new Float64Array(k),W=r.normal?new Float32Array(k):void 0,q=r.tangent?new Float32Array(k):void 0,G=r.binormal?new Float32Array(k):void 0,H={normals:W,tangents:q,binormals:G},j=0,Y=k-1,X=x,Z=S,J=O/2,K=u.createTypedArray(k/3,M),Q=0;if(R){V=E,F=b;var $=v[0];for(X=i.fromArray(_,0,X),Z=i.fromArray(g,0,Z),l=0;J>l;l++)V=i.fromArray($,3*(J-1-l),V),F=i.fromArray($,3*(J+l),F),o.addAttribute(U,F,j),o.addAttribute(U,V,void 0,Y),y(H,X,Z,j,Y,r),z=j/3,B=z+1,L=(Y-2)/3,N=L-1,K[Q++]=L,K[Q++]=z,K[Q++]=N,K[Q++]=N,K[Q++]=z,K[Q++]=B,j+=3,Y-=3}var et=0,tt=0,rt=d[et++],it=d[et++];U.set(rt,j),U.set(it,Y-it.length+1),Z=i.fromArray(g,tt,Z);var nt,ot;for(h=it.length-3,l=0;h>l;l+=3)nt=n.geodeticSurfaceNormal(i.fromArray(rt,l,D),D),ot=n.geodeticSurfaceNormal(i.fromArray(it,h-l,P),P),X=i.normalize(i.add(nt,ot,X),X),y(H,X,Z,j,Y,r),z=j/3,B=z+1,L=(Y-2)/3,N=L-1,K[Q++]=L,K[Q++]=z,K[Q++]=N,K[Q++]=N,K[Q++]=z,K[Q++]=B,j+=3,Y-=3;for(nt=n.geodeticSurfaceNormal(i.fromArray(rt,h,D),D),ot=n.geodeticSurfaceNormal(i.fromArray(it,h,P),P),X=i.normalize(i.add(nt,ot,X),X),tt+=3,l=0;l<m.length;l++){var at;s=m[l];var st,lt,ut=s.leftPositions,ct=s.rightPositions,ht=A,dt=E,mt=b;if(X=i.fromArray(_,tt,X),t(ut)){for(y(H,X,Z,void 0,Y,r),Y-=3,st=B,lt=N,at=0;at<ut.length/3;at++)ht=i.fromArray(ut,3*at,ht),K[Q++]=st,K[Q++]=lt-at-1,K[Q++]=lt-at,o.addAttribute(U,ht,void 0,Y),dt=i.fromArray(U,3*(lt-at-1),dt),mt=i.fromArray(U,3*st,mt),Z=i.normalize(i.subtract(dt,mt,Z),Z),y(H,X,Z,void 0,Y,r),Y-=3;ht=i.fromArray(U,3*st,ht),dt=i.subtract(i.fromArray(U,3*lt,dt),ht,dt),mt=i.subtract(i.fromArray(U,3*(lt-at),mt),ht,mt),Z=i.normalize(i.add(dt,mt,Z),Z),y(H,X,Z,j,void 0,r),j+=3}else{for(y(H,X,Z,j,void 0,r),j+=3,st=N,lt=B,at=0;at<ct.length/3;at++)ht=i.fromArray(ct,3*at,ht),K[Q++]=st,K[Q++]=lt+at,K[Q++]=lt+at+1,o.addAttribute(U,ht,j),dt=i.fromArray(U,3*st,dt),mt=i.fromArray(U,3*(lt+at),mt),Z=i.normalize(i.subtract(dt,mt,Z),Z),y(H,X,Z,j,void 0,r),j+=3;ht=i.fromArray(U,3*st,ht),dt=i.subtract(i.fromArray(U,3*(lt+at),dt),ht,dt),mt=i.subtract(i.fromArray(U,3*lt,mt),ht,mt),Z=i.normalize(i.negate(i.add(mt,dt,Z),Z),Z),y(H,X,Z,void 0,Y,r),Y-=3}for(rt=d[et++],it=d[et++],rt.splice(0,3),it.splice(it.length-3,3),U.set(rt,j),U.set(it,Y-it.length+1),h=it.length-3,tt+=3,Z=i.fromArray(g,tt,Z),at=0;at<it.length;at+=3)nt=n.geodeticSurfaceNormal(i.fromArray(rt,at,D),D),ot=n.geodeticSurfaceNormal(i.fromArray(it,h-at,P),P),X=i.normalize(i.add(nt,ot,X),X),y(H,X,Z,j,Y,r),B=j/3,z=B-1,N=(Y-2)/3,L=N+1,K[Q++]=L,K[Q++]=z,K[Q++]=N,K[Q++]=N,K[Q++]=z,K[Q++]=B,j+=3,Y-=3;j-=3,Y+=3}if(X=i.fromArray(_,_.length-3,X),y(H,X,Z,j,Y,r),R){j+=3,Y-=3,V=E,F=b;var pt=v[1];for(l=0;J>l;l++)V=i.fromArray(pt,3*(O-l-1),V),F=i.fromArray(pt,3*l,F),o.addAttribute(U,V,void 0,Y),o.addAttribute(U,F,j),y(H,X,Z,j,Y,r),B=j/3,z=B-1,N=(Y-2)/3,L=N+1,K[Q++]=L,K[Q++]=z,K[Q++]=N,K[Q++]=N,K[Q++]=z,K[Q++]=B,j+=3,Y-=3}if(w.position=new p({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:U}),r.st){var ft,vt,yt=new Float32Array(2*(k/3)),gt=0;if(R){C/=3,T/=3;var _t=Math.PI/(O+1);vt=1/(C-O+1),ft=1/(T-O+1);var wt,Ct=O/2;for(l=Ct+1;O+1>l;l++)wt=c.PI_OVER_TWO+_t*l,yt[gt++]=ft*(1+Math.cos(wt)),yt[gt++]=.5*(1+Math.sin(wt));for(l=1;T-O+1>l;l++)yt[gt++]=l*ft,yt[gt++]=0;for(l=O;l>Ct;l--)wt=c.PI_OVER_TWO-l*_t,yt[gt++]=1-ft*(1+Math.cos(wt)),yt[gt++]=.5*(1+Math.sin(wt));for(l=Ct;l>0;l--)wt=c.PI_OVER_TWO-_t*l,yt[gt++]=1-vt*(1+Math.cos(wt)),yt[gt++]=.5*(1+Math.sin(wt));for(l=C-O;l>0;l--)yt[gt++]=l*vt,yt[gt++]=1;for(l=1;Ct+1>l;l++)wt=c.PI_OVER_TWO+_t*l,yt[gt++]=vt*(1+Math.cos(wt)),yt[gt++]=.5*(1+Math.sin(wt))}else{for(C/=3,T/=3,vt=1/(C-1),ft=1/(T-1),l=0;T>l;l++)yt[gt++]=l*ft,yt[gt++]=0;for(l=C;l>0;l--)yt[gt++]=(l-1)*vt,yt[gt++]=1}w.st=new p({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:yt})}return r.normal&&(w.normal=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:H.normals})),r.tangent&&(w.tangent=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:H.tangents})),r.binormal&&(w.binormal=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:H.binormals})),{attributes:w,indices:K}}function _(e,t){if(!(t.normal||t.binormal||t.tangent||t.st))return e;var r,n,a=e.position.values;(t.normal||t.binormal)&&(r=e.normal.values,n=e.binormal.values);var s,l=e.position.values.length/18,u=3*l,c=2*l,h=2*u;if(t.normal||t.binormal||t.tangent){var d=t.normal?new Float32Array(6*u):void 0,m=t.binormal?new Float32Array(6*u):void 0,p=t.tangent?new Float32Array(6*u):void 0,f=x,v=S,y=E,g=b,_=T,w=A,C=h;for(s=0;u>s;s+=3){var D=C+h;f=i.fromArray(a,s,f),v=i.fromArray(a,s+u,v),y=i.fromArray(a,(s+3)%u,y),v=i.subtract(v,f,v),y=i.subtract(y,f,y),g=i.normalize(i.cross(v,y,g),g),t.normal&&(o.addAttribute(d,g,D),o.addAttribute(d,g,D+3),o.addAttribute(d,g,C),o.addAttribute(d,g,C+3)),(t.tangent||t.binormal)&&(w=i.fromArray(r,s,w),t.binormal&&(o.addAttribute(m,w,D),o.addAttribute(m,w,D+3),o.addAttribute(m,w,C),o.addAttribute(m,w,C+3)),t.tangent&&(_=i.normalize(i.cross(w,g,_),_),o.addAttribute(p,_,D),o.addAttribute(p,_,D+3),o.addAttribute(p,_,C),o.addAttribute(p,_,C+3))),C+=6}if(t.normal){for(d.set(r),s=0;u>s;s+=3)d[s+u]=-r[s],d[s+u+1]=-r[s+1],d[s+u+2]=-r[s+2];e.normal.values=d}else e.normal=void 0;if(t.binormal?(m.set(n),m.set(n,u),e.binormal.values=m):e.binormal=void 0,t.tangent){var P=e.tangent.values;p.set(P),p.set(P,u),e.tangent.values=p}}if(t.st){var M=e.st.values,I=new Float32Array(6*c);I.set(M),I.set(M,c);for(var O=2*c,R=0;2>R;R++){for(I[O++]=M[0],I[O++]=M[1],s=2;c>s;s+=2){var L=M[s],z=M[s+1];I[O++]=L,I[O++]=z,I[O++]=L,I[O++]=z}I[O++]=M[0],I[O++]=M[1]}e.st.values=I}return e}function w(e,t,r){r[t++]=e[0],r[t++]=e[1],r[t++]=e[2];for(var i=3;i<e.length;i+=3){var n=e[i],o=e[i+1],a=e[i+2];r[t++]=n,r[t++]=o,r[t++]=a,r[t++]=n,r[t++]=o,r[t++]=a}return r[t++]=e[0],r[t++]=e[1],r[t++]=e[2],r}function C(e,t){var r=new v({position:t.positon,normal:t.normal||t.binormal,tangent:t.tangent,binormal:t.normal||t.binormal,st:t.st}),i=e.ellipsoid,n=o.computePositions(e),a=g(n,r,i),s=e.height,l=e.extrudedHeight,c=a.attributes,d=a.indices,m=c.position.values,p=m.length,f=new Float64Array(6*p),y=new Float64Array(p);y.set(m);var C=new Float64Array(4*p);m=h.scaleToGeodeticHeight(m,s,i,m),C=w(m,0,C),y=h.scaleToGeodeticHeight(y,l,i,y),C=w(y,2*p,C),f.set(m),f.set(y,p),f.set(C,2*p),c.position.values=f,p/=3;var x,S=d.length,E=p+p,b=u.createTypedArray(f.length/3,2*S+3*E);b.set(d);var T=S;for(x=0;S>x;x+=3){var A=d[x],D=d[x+1],P=d[x+2];b[T++]=P+p,b[T++]=D+p,b[T++]=A+p}c=_(c,t);var M,I,O,R;for(x=0;E>x;x+=2)M=x+E,I=M+E,O=M+1,R=I+1,b[T++]=M,b[T++]=I,b[T++]=O,b[T++]=O,b[T++]=I,b[T++]=R;return{attributes:c,indices:b}}var x=new i,S=new i,E=new i,b=new i,T=new i,A=new i,D=new i,P=new i,M=function(i){i=e(i,e.EMPTY_OBJECT);var o=i.positions;if(!t(o))throw new r("options.positions is required.");var a=i.width;if(!t(a))throw new r("options.width is required.");this._positions=o,this._width=a,this._ellipsoid=e(i.ellipsoid,s.WGS84),this._height=e(i.height,0),this._extrudedHeight=e(i.extrudedHeight,this._height),this._cornerType=e(i.cornerType,n.ROUNDED),this._vertexFormat=e(i.vertexFormat,v.DEFAULT),this._granularity=e(i.granularity,c.RADIANS_PER_DEGREE),this._workerName="createCorridorGeometry"};return M.createGeometry=function(e){var t=e._positions,i=e._height,n=e._extrudedHeight,a=i!==n,s=h.removeDuplicates(t);if(s.length<2)throw new r("Count of unique positions must be greater than 1.");var u,c=e._ellipsoid,p=e._vertexFormat,f={ellipsoid:c,positions:s,width:e._width,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!0};if(a){var v=Math.max(i,n);n=Math.min(i,n),i=v,f.height=i,f.extrudedHeight=n,u=C(f,p)}else{var y=o.computePositions(f);u=g(y,p,c),u.attributes.position.values=h.scaleToGeodeticHeight(u.attributes.position.values,i,c,u.attributes.position.values)}var _=u.attributes,w=m.fromVertices(_.position.values,void 0,3);return p.position||(u.attributes.position.values=void 0),new l({attributes:_,indices:u.indices,primitiveType:d.TRIANGLES,boundingSphere:w})},M}),r("Core/CorridorOutlineGeometry",["./defined","./DeveloperError","./Cartesian3","./CornerType","./CorridorGeometryLibrary","./ComponentDatatype","./Ellipsoid","./Geometry","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./defaultValue","./BoundingSphere","./GeometryAttribute","./GeometryAttributes"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f){"use strict";function v(t,a,s){var u,c,h,d=[],m=t.positions,v=t.corners,y=t.endPositions,C=new f,x=0,S=0,E=0;for(c=0;c<m.length;c+=2)h=m[c].length-3,x+=h,E+=4*(h/3),S+=m[c+1].length-3;for(x+=3,S+=3,c=0;c<v.length;c++){u=v[c];var b=v[c].leftPositions;e(b)?(h=b.length,x+=h,E+=2*(h/3)):(h=v[c].rightPositions.length,S+=h,E+=2*(h/3))}var T,A=e(y);A&&(T=y[0].length-3,x+=T,S+=T,T/=3,E+=4*T);var D,P,M,I,O,R,L=x+S,z=new Float64Array(L),N=0,B=L-1,F=T/2,V=l.createTypedArray(L/3,E+4),k=0;if(V[k++]=N/3,V[k++]=(B-2)/3,A){d.push(N/3),R=g,O=_;var U=y[0];for(c=0;F>c;c++)R=r.fromArray(U,3*(F-1-c),R),O=r.fromArray(U,3*(F+c),O),n.addAttribute(z,O,N),n.addAttribute(z,R,void 0,B),P=N/3,I=P+1,D=(B-2)/3,M=D-1,V[k++]=D,V[k++]=M,V[k++]=P,V[k++]=I,N+=3,B-=3}var W=0,q=m[W++],G=m[W++];for(z.set(q,N),z.set(G,B-G.length+1),h=G.length-3,d.push(N/3,(B-2)/3),c=0;h>c;c+=3)P=N/3,I=P+1,D=(B-2)/3,M=D-1,V[k++]=D,V[k++]=M,V[k++]=P,V[k++]=I,N+=3,B-=3;for(c=0;c<v.length;c++){var H;u=v[c];var j,Y=u.leftPositions,X=u.rightPositions,Z=w;if(e(Y)){for(B-=3,j=M,d.push(I),H=0;H<Y.length/3;H++)Z=r.fromArray(Y,3*H,Z),V[k++]=j-H-1,V[k++]=j-H,n.addAttribute(z,Z,void 0,B),B-=3;d.push(j-Math.floor(Y.length/6)),s.value===i.BEVELED.value&&d.push((B-2)/3+1),N+=3}else{for(N+=3,j=I,d.push(M),H=0;H<X.length/3;H++)Z=r.fromArray(X,3*H,Z),V[k++]=j+H,V[k++]=j+H+1,n.addAttribute(z,Z,N),N+=3;d.push(j+Math.floor(X.length/6)),s.value===i.BEVELED.value&&d.push(N/3-1),B-=3}for(q=m[W++],G=m[W++],q.splice(0,3),G.splice(G.length-3,3),z.set(q,N),z.set(G,B-G.length+1),h=G.length-3,H=0;H<G.length;H+=3)I=N/3,P=I-1,M=(B-2)/3,D=M+1,V[k++]=D,V[k++]=M,V[k++]=P,V[k++]=I,N+=3,B-=3;N-=3,B+=3,d.push(N/3,(B-2)/3)}if(A){N+=3,B-=3,R=g,O=_;var J=y[1];for(c=0;F>c;c++)R=r.fromArray(J,3*(T-c-1),R),O=r.fromArray(J,3*c,O),n.addAttribute(z,R,void 0,B),n.addAttribute(z,O,N),I=N/3,P=I-1,M=(B-2)/3,D=M+1,V[k++]=D,V[k++]=M,V[k++]=P,V[k++]=I,N+=3,B-=3;d.push(N/3)}else d.push(N/3,(B-2)/3);return V[k++]=N/3,V[k++]=(B-2)/3,C.position=new p({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:z}),{attributes:C,indices:V,wallIndices:d}}function y(e){var t=e.ellipsoid,r=n.computePositions(e),i=v(r,t,e.cornerType),o=i.wallIndices,a=e.height,s=e.extrudedHeight,u=i.attributes,h=i.indices,d=u.position.values,m=d.length,p=new Float64Array(m);p.set(d);var f=new Float64Array(2*m);d=c.scaleToGeodeticHeight(d,a,t,d),p=c.scaleToGeodeticHeight(p,s,t,p),f.set(d),f.set(p,m),u.position.values=f,m/=3;var y,g=h.length,_=l.createTypedArray(f.length/3,2*(g+o.length));_.set(h);var w=g;for(y=0;g>y;y+=2){var C=h[y],x=h[y+1];_[w++]=C+m,_[w++]=x+m}var S,E;for(y=0;y<o.length;y++)S=o[y],E=S+m,_[w++]=S,_[w++]=E;return{attributes:u,indices:_}}var g=new r,_=new r,w=new r,C=function(r){r=d(r,d.EMPTY_OBJECT);var n=r.positions;if(!e(n))throw new t("options.positions is required.");var o=r.width;if(!e(o))throw new t("options.width is required.");this._positions=n,this._width=o,this._ellipsoid=d(r.ellipsoid,a.WGS84),this._height=d(r.height,0),this._extrudedHeight=d(r.extrudedHeight,this._height),this._cornerType=d(r.cornerType,i.ROUNDED),this._granularity=d(r.granularity,u.RADIANS_PER_DEGREE),this._workerName="createCorridorOutlineGeometry"};return C.createGeometry=function(e){var r=e._positions,i=e._height,o=e._extrudedHeight,a=i!==o,l=c.removeDuplicates(r);if(l.length<2)throw new t("Count of unique positions must be greater than 1.");var u,d=e._ellipsoid,p={ellipsoid:d,positions:l,width:e._width,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!1};if(a){var f=Math.max(i,o);o=Math.min(i,o),i=f,p.height=i,p.extrudedHeight=o,u=y(p)}else{var g=n.computePositions(p);u=v(g,d,p.cornerType),u.attributes.position.values=c.scaleToGeodeticHeight(u.attributes.position.values,i,d,u.attributes.position.values)}var _=u.attributes,w=m.fromVertices(_.position.values,void 0,3);return new s({attributes:_,indices:u.indices,primitiveType:h.LINES,boundingSphere:w})},C}),r("Core/CylinderGeometryLibrary",["./Math"],function(e){"use strict";var t={};return t.computePositions=function(t,r,i,n,o){var a,s=.5*t,l=-s,u=n+n,c=o?2*u:u,h=new Float64Array(3*c),d=0,m=0,p=o?3*u:0,f=o?3*(u+n):3*n;for(a=0;n>a;a++){var v=a/n*e.TWO_PI,y=Math.cos(v),g=Math.sin(v),_=y*i,w=g*i,C=y*r,x=g*r;h[m+p]=_,h[m+p+1]=w,h[m+p+2]=l,h[m+f]=C,h[m+f+1]=x,h[m+f+2]=s,m+=3,o&&(h[d++]=_,h[d++]=w,h[d++]=l,h[d++]=C,h[d++]=x,h[d++]=s)}return h},t}),r("Core/CylinderGeometry",["./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./CylinderGeometryLibrary","./Math","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./BoundingSphere","./Geometry","./GeometryAttribute","./GeometryAttributes","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p){"use strict";var f=new i,v=new n,y=new n,g=new n,_=new n,w=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.length,o=i.topRadius,a=i.bottomRadius,s=e(i.vertexFormat,p.DEFAULT),l=e(i.slices,128);if(!t(n)||0>=n)throw new r("options.length must be greater than 0.");if(!t(o)||0>o)throw new r("options.topRadius must be greater than 0.");if(!t(a)||0>a)throw new r("options.bottomRadius must be greater than 0.");if(0===a&&0===o)throw new r("bottomRadius and topRadius cannot both equal 0.");if(3>l)throw new r("options.slices must be greater that 3.");this._length=n,this._topRadius=o,this._bottomRadius=a,this._vertexFormat=s,this._slices=l,this._workerName="createCylinderGeometry"};return w.createGeometry=function(e){var t,r=e._length,p=e._topRadius,w=e._bottomRadius,C=e._vertexFormat,x=e._slices,S=x+x,E=x+S,b=S+S,T=o.computePositions(r,p,w,x,!0),A=C.st?new Float32Array(2*b):void 0,D=C.normal?new Float32Array(3*b):void 0,P=C.tangent?new Float32Array(3*b):void 0,M=C.binormal?new Float32Array(3*b):void 0,I=C.normal||C.tangent||C.binormal;if(I){var O=C.tangent||C.binormal,R=0,L=0,z=0,N=v;N.z=0;var B=g,F=y;for(t=0;x>t;t++){var V=t/x*a.TWO_PI,k=Math.cos(V),U=Math.sin(V);I&&(N.x=k,N.y=U,O&&(B=n.normalize(n.cross(n.UNIT_Z,N,B),B)),C.normal&&(D[R++]=k,D[R++]=U,D[R++]=0,D[R++]=k,D[R++]=U,D[R++]=0),C.tangent&&(P[L++]=B.x,P[L++]=B.y,P[L++]=B.z,P[L++]=B.x,P[L++]=B.y,P[L++]=B.z),C.binormal&&(F=n.normalize(n.cross(N,B,F),F),M[z++]=F.x,M[z++]=F.y,M[z++]=F.z,M[z++]=F.x,M[z++]=F.y,M[z++]=F.z))}for(t=0;x>t;t++)C.normal&&(D[R++]=0,D[R++]=0,D[R++]=-1),C.tangent&&(P[L++]=1,P[L++]=0,P[L++]=0),C.binormal&&(M[z++]=0,M[z++]=-1,M[z++]=0);for(t=0;x>t;t++)C.normal&&(D[R++]=0,D[R++]=0,D[R++]=1),C.tangent&&(P[L++]=1,P[L++]=0,P[L++]=0),C.binormal&&(M[z++]=0,M[z++]=1,M[z++]=0)}var W=12*x-12,q=l.createTypedArray(b,W),G=0,H=0;for(t=0;x-1>t;t++)q[G++]=H,q[G++]=H+2,q[G++]=H+3,q[G++]=H,q[G++]=H+3,q[G++]=H+1,H+=2;for(q[G++]=S-2,q[G++]=0,q[G++]=1,q[G++]=S-2,q[G++]=1,q[G++]=S-1,t=1;x-1>t;t++)q[G++]=S+t+1,q[G++]=S+t,q[G++]=S;for(t=1;x-1>t;t++)q[G++]=E,q[G++]=E+t,q[G++]=E+t+1;var j=0;if(C.st){var Y=Math.max(p,w);for(t=0;b>t;t++){var X=n.fromArray(T,3*t,_);A[j++]=(X.x+Y)/(2*Y),A[j++]=(X.y+Y)/(2*Y)}}var Z=new m;C.position&&(Z.position=new d({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:T})),C.normal&&(Z.normal=new d({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:D})),C.tangent&&(Z.tangent=new d({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:P})),C.binormal&&(Z.binormal=new d({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:M})),C.st&&(Z.st=new d({componentDatatype:s.FLOAT,componentsPerAttribute:2,values:A})),f.x=.5*r,f.y=Math.max(w,p);var J=new c(n.ZERO,i.magnitude(f));return new h({attributes:Z,indices:q,primitiveType:u.TRIANGLES,boundingSphere:J})},w}),r("Core/CylinderOutlineGeometry",["./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./CylinderGeometryLibrary","./Math","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./BoundingSphere","./Geometry","./GeometryAttribute","./GeometryAttributes"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m){"use strict";var p=new i,f=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.length,o=i.topRadius,a=i.bottomRadius,s=e(i.slices,128),l=Math.max(e(i.numberOfVerticalLines,16),0);if(!t(n)||0>=n)throw new r("options.length must be greater than 0.");if(!t(o)||0>o)throw new r("options.topRadius must be greater than 0.");if(!t(a)||0>a)throw new r("options.bottomRadius must be greater than 0.");if(0===a&&0===o)throw new r("bottomRadius and topRadius cannot both equal 0.");if(3>s)throw new r("options.slices must be greater that 3.");this._length=n,this._topRadius=o,this._bottomRadius=a,this._slices=s,this._numberOfVerticalLines=l,this._workerName="createCylinderOutlineGeometry"};return f.createGeometry=function(e){var t,r=e._length,a=e._topRadius,f=e._bottomRadius,v=e._slices,y=e._numberOfVerticalLines,g=2*v,_=o.computePositions(r,a,f,v,!1),w=2*v;if(y>0){var C=Math.min(y,v);t=Math.round(v/C),w+=C}for(var x=l.createTypedArray(g,2*w),S=0,E=0;v-1>E;E++)x[S++]=E,x[S++]=E+1,x[S++]=E+v,x[S++]=E+1+v;if(x[S++]=v-1,x[S++]=0,x[S++]=v+v-1,x[S++]=v,y>0)for(E=0;v>E;E+=t)x[S++]=E,x[S++]=E+v;var b=new m;b.position=new d({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:_}),p.x=.5*r,p.y=Math.max(f,a);var T=new c(n.ZERO,i.magnitude(p));return new h({attributes:b,indices:x,primitiveType:u.LINES,boundingSphere:T})},f}),r("Core/DefaultProxy",[],function(){"use strict";var e=function(e){this.proxy=e};return e.prototype.getURL=function(e){return this.proxy+"?"+encodeURIComponent(e)},e}),r("Core/EllipsoidGeometry",["./defaultValue","./DeveloperError","./Cartesian3","./Math","./Ellipsoid","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./BoundingSphere","./Geometry","./GeometryAttribute","./GeometryAttributes","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";var m=new r,p=new r,f=new r,v=new r,y=new r(1,1,1),g=Math.cos,_=Math.sin,w=function(i){i=e(i,e.EMPTY_OBJECT);var n=e(i.radii,y),o=e(i.stackPartitions,64),a=e(i.slicePartitions,64),s=e(i.vertexFormat,d.DEFAULT);if(3>a)throw new t("options.slicePartitions cannot be less than three.");if(3>o)throw new t("options.stackPartitions cannot be less than three.");this._radii=r.clone(n),this._stackPartitions=o,this._slicePartitions=a,this._vertexFormat=s,this._workerName="createEllipsoidGeometry"};return w.createGeometry=function(e){var t,d,y=e._radii,w=n.fromCartesian3(y),C=e._stackPartitions,x=e._slicePartitions,S=e._vertexFormat,E=2+(C-1)*x,b=new Float64Array(3*E),T=6*x*(C-1),A=a.createTypedArray(E,T),D=S.normal?new Float32Array(3*E):void 0,P=S.tangent?new Float32Array(3*E):void 0,M=S.binormal?new Float32Array(3*E):void 0,I=S.st?new Float32Array(2*E):void 0,O=new Array(x),R=new Array(x);for(t=0;x>t;t++){var L=i.TWO_PI*t/x;O[t]=g(L),R[t]=_(L)}var z=0;for(b[z++]=0,b[z++]=0,b[z++]=y.z,t=1;C>t;t++){var N=Math.PI*t/C,B=_(N),F=y.x*B,V=y.y*B,k=y.z*g(N);for(d=0;x>d;d++)b[z++]=O[d]*F,b[z++]=R[d]*V,b[z++]=k}b[z++]=0,b[z++]=0,b[z++]=-y.z;var U=new h;S.position&&(U.position=new c({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:b}));var W=0,q=0,G=0,H=0;if(S.st||S.normal||S.tangent||S.binormal){for(t=0;E>t;t++){var j=r.fromArray(b,3*t,m),Y=w.geodeticSurfaceNormal(j,p);if(S.st&&(I[W++]=Math.atan2(Y.y,Y.x)/i.TWO_PI+.5,I[W++]=Math.asin(Y.z)/Math.PI+.5),S.normal&&(D[q++]=Y.x,D[q++]=Y.y,D[q++]=Y.z),S.tangent||S.binormal){var X=f;if(0===t||t===E-1?(r.cross(r.UNIT_X,Y,X),r.normalize(X,X)):(r.cross(r.UNIT_Z,Y,X),r.normalize(X,X)),S.tangent&&(P[G++]=X.x,P[G++]=X.y,P[G++]=X.z),S.binormal){var Z=r.cross(Y,X,v);r.normalize(Z,Z),M[H++]=Z.x,M[H++]=Z.y,M[H++]=Z.z}}}S.st&&(U.st=new c({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:I})),S.normal&&(U.normal=new c({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:D})),S.tangent&&(U.tangent=new c({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:P})),S.binormal&&(U.binormal=new c({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:M}))}for(z=0,t=1;x>t;t++)A[z++]=0,A[z++]=t,A[z++]=t+1;for(A[z++]=0,A[z++]=x,A[z++]=1,t=0;C-2>t;t++){var J=t*x+1,K=(t+1)*x+1;for(d=0;x-1>d;d++)A[z++]=K+d,A[z++]=K+d+1,A[z++]=J+d+1,A[z++]=K+d,A[z++]=J+d+1,A[z++]=J+d;A[z++]=K+x-1,A[z++]=K,A[z++]=J,A[z++]=K+x-1,A[z++]=J,A[z++]=J+x-1}var Q=E-1;for(t=Q-1;t>Q-x;t--)A[z++]=Q,A[z++]=t,A[z++]=t-1;return A[z++]=Q,A[z++]=Q-x,A[z++]=Q-1,new u({attributes:U,indices:A,primitiveType:s.TRIANGLES,boundingSphere:l.fromEllipsoid(w)})},w}),r("Core/EllipsoidOutlineGeometry",["./defaultValue","./DeveloperError","./Cartesian3","./Math","./Ellipsoid","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./BoundingSphere","./Geometry","./GeometryAttribute","./GeometryAttributes"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";var d=new r(1,1,1),m=Math.cos,p=Math.sin,f=function(i){i=e(i,e.EMPTY_OBJECT);var n=e(i.radii,d),o=e(i.stackPartitions,10),a=e(i.slicePartitions,8),s=e(i.subdivisions,128);if(1>o)throw new t("options.stackPartitions cannot be less than 1");if(0>a)throw new t("options.slicePartitions cannot be less than 0");if(0>s)throw new t("options.subdivisions must be greater than or equal to zero.");this._radii=r.clone(n),this._stackPartitions=o,this._slicePartitions=a,this._subdivisions=s,this._workerName="createEllipsoidOutlineGeometry"};return f.createGeometry=function(e){var t,r,d,f,v,y,g=e._radii,_=n.fromCartesian3(g),w=e._stackPartitions,C=e._slicePartitions,x=e._subdivisions,S=x*(w+C-1),E=S-C+2,b=new Float64Array(3*E),T=a.createTypedArray(E,2*S),A=0,D=new Array(x),P=new Array(x);for(t=0;x>t;t++)d=i.TWO_PI*t/x,D[t]=m(d),P[t]=p(d);for(t=1;w>t;t++)for(f=Math.PI*t/w,v=m(f),y=p(f),r=0;x>r;r++)b[A++]=g.x*D[r]*y,b[A++]=g.y*P[r]*y,b[A++]=g.z*v;for(D.length=C,P.length=C,t=0;C>t;t++)d=i.TWO_PI*t/C,D[t]=m(d),P[t]=p(d);for(b[A++]=0,b[A++]=0,b[A++]=g.z,t=1;x>t;t++)for(f=Math.PI*t/x,v=m(f),y=p(f),r=0;C>r;r++)b[A++]=g.x*D[r]*y,b[A++]=g.y*P[r]*y,b[A++]=g.z*v;for(b[A++]=0,b[A++]=0,b[A++]=-g.z,A=0,t=0;w-1>t;++t){var M=t*x;for(r=0;x-1>r;++r)T[A++]=M+r,T[A++]=M+r+1;T[A++]=M+x-1,T[A++]=M}var I=x*(w-1);for(r=1;C+1>r;++r)T[A++]=I,T[A++]=I+r;for(t=0;x-2>t;++t){var O=t*C+1+I,R=(t+1)*C+1+I;for(r=0;C-1>r;++r)T[A++]=R+r,T[A++]=O+r;T[A++]=R+C-1,T[A++]=O+C-1}var L=b.length/3-1;for(r=L-1;r>L-C-1;--r)T[A++]=L,T[A++]=r;var z=new h({position:new c({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:b})});return new u({attributes:z,indices:T,primitiveType:s.LINES,boundingSphere:l.fromEllipsoid(_)})},f}),r("Core/EllipsoidalOccluder",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./BoundingSphere"],function(e,t,r,i,n){"use strict";function o(e,t,r){var n=e.transformPositionToScaledSpace(t,d),o=i.magnitudeSquared(n),a=Math.sqrt(o),s=i.divideByScalar(n,a,m);o=Math.max(1,o),a=Math.max(1,a);var l=i.dot(s,r),u=i.magnitude(i.cross(s,r)),c=1/a,h=Math.sqrt(o-1)*c;return 1/(l*c-u*h)}function a(e,t,r){return 0>=t||t===1/0||t!==t?void 0:i.multiplyByScalar(e,t,r)}function s(e,t){return e.transformPositionToScaledSpace(t,p),i.normalize(p,p)}var l=function(e,n){if(!t(e))throw new r("ellipsoid is required.");this._ellipsoid=e,this._cameraPosition=new i,this._cameraPositionInScaledSpace=new i,this._distanceToLimbInScaledSpaceSquared=0,t(n)&&this.setCameraPosition(n)};l.prototype.getEllipsoid=function(){return this._ellipsoid},l.prototype.setCameraPosition=function(e){var t=this._ellipsoid,r=t.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),n=i.magnitudeSquared(r)-1;i.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=r,this._distanceToLimbInScaledSpaceSquared=n},l.prototype.getCameraPosition=function(){return this._cameraPosition};var u=new i;l.prototype.isPointVisible=function(e){var t=this._ellipsoid,r=t.transformPositionToScaledSpace(e,u);return this.isScaledSpacePointVisible(r)},l.prototype.isScaledSpacePointVisible=function(e){var t=this._cameraPositionInScaledSpace,r=this._distanceToLimbInScaledSpaceSquared,n=i.subtract(e,t,u),o=-i.dot(n,t),a=o>r&&o*o/i.magnitudeSquared(n)>r;return!a},l.prototype.computeHorizonCullingPoint=function(e,i,n){if(!t(e))throw new r("directionToPoint is required");if(!t(i))throw new r("positions is required");for(var l=this._ellipsoid,u=s(l,e),c=0,h=0,d=i.length;d>h;++h){var m=i[h],p=o(l,m,u);c=Math.max(c,p)}return a(u,c,n)};var c=new i;l.prototype.computeHorizonCullingPointFromVertices=function(n,l,u,h,d){if(!t(n))throw new r("directionToPoint is required");if(!t(l))throw new r("vertices is required");if(!t(u))throw new r("stride is required");h=e(h,i.ZERO);for(var m=this._ellipsoid,p=s(m,n),f=0,v=0,y=l.length;y>v;v+=u){c.x=l[v]+h.x,c.y=l[v+1]+h.y,c.z=l[v+2]+h.z;var g=o(m,c,p);f=Math.max(f,g)}return a(p,f,d)};var h=[];l.prototype.computeHorizonCullingPointFromExtent=function(e,o,a){if(!t(e))throw new r("extent is required.");
var s=e.subsample(o,0,h),l=n.fromPoints(s);return i.magnitude(l.center)<.1*o.getMinimumRadius()?void 0:this.computeHorizonCullingPoint(l.center,s,a)};var d=new i,m=new i,p=new i;return l}),r("Core/EventHelper",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(){this._removalFunctions=[]};return r.prototype.add=function(r,i,n){if(!e(r))throw new t("event is required");this._removalFunctions.push(r.addEventListener(i,n))},r.prototype.removeAll=function(){for(var e=this._removalFunctions,t=0,r=e.length;r>t;++t)e[t]();e.length=0},r}),r("Core/Extent",["./freezeObject","./defaultValue","./defined","./Ellipsoid","./Cartographic","./DeveloperError","./Math"],function(e,t,r,i,n,o,a){"use strict";var s=function(e,r,i,n){this.west=t(e,0),this.south=t(r,0),this.east=t(i,0),this.north=t(n,0)};s.fromDegrees=function(e,i,n,o,l){return e=a.toRadians(t(e,0)),i=a.toRadians(t(i,0)),n=a.toRadians(t(n,0)),o=a.toRadians(t(o,0)),r(l)?(l.west=e,l.south=i,l.east=n,l.north=o,l):new s(e,i,n,o)},s.fromCartographicArray=function(e,t){if(!r(e))throw new o("cartographics is required.");for(var i=Number.MAX_VALUE,n=-Number.MAX_VALUE,a=Number.MAX_VALUE,l=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var h=e[u];i=Math.min(i,h.longitude),n=Math.max(n,h.longitude),a=Math.min(a,h.latitude),l=Math.max(l,h.latitude)}return r(t)?(t.west=i,t.south=a,t.east=n,t.north=l,t):new s(i,a,n,l)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){if("number"!=typeof t)throw new o("epsilon is required and must be a number.");return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.prototype.validate=function(){var e=this.north;if("number"!=typeof e)throw new o("north is required to be a number.");if(e<-a.PI_OVER_TWO||e>a.PI_OVER_TWO)throw new o("north must be in the interval [-Pi/2, Pi/2].");var t=this.south;if("number"!=typeof t)throw new o("south is required to be a number.");if(t<-a.PI_OVER_TWO||t>a.PI_OVER_TWO)throw new o("south must be in the interval [-Pi/2, Pi/2].");var r=this.west;if("number"!=typeof r)throw new o("west is required to be a number.");if(r<-Math.PI||r>Math.PI)throw new o("west must be in the interval [-Pi, Pi].");var i=this.east;if("number"!=typeof i)throw new o("east is required to be a number.");if(i<-Math.PI||i>Math.PI)throw new o("east must be in the interval [-Pi, Pi].")},s.prototype.getSouthwest=function(e){return r(e)?(e.longitude=this.west,e.latitude=this.south,e.height=0,e):new n(this.west,this.south)},s.prototype.getNorthwest=function(e){return r(e)?(e.longitude=this.west,e.latitude=this.north,e.height=0,e):new n(this.west,this.north)},s.prototype.getNortheast=function(e){return r(e)?(e.longitude=this.east,e.latitude=this.north,e.height=0,e):new n(this.east,this.north)},s.prototype.getSoutheast=function(e){return r(e)?(e.longitude=this.east,e.latitude=this.south,e.height=0,e):new n(this.east,this.south)},s.prototype.getCenter=function(e){return r(e)?(e.longitude=.5*(this.west+this.east),e.latitude=.5*(this.south+this.north),e.height=0,e):new n(.5*(this.west+this.east),.5*(this.south+this.north))},s.prototype.intersectWith=function(e,t){if(!r(e))throw new o("otherExtent is required.");var i=Math.max(this.west,e.west),n=Math.max(this.south,e.south),a=Math.min(this.east,e.east),l=Math.min(this.north,e.north);return r(t)?(t.west=i,t.south=n,t.east=a,t.north=l,t):new s(i,n,a,l)},s.prototype.contains=function(e){if(!r(e))throw new o("cartographic is required.");return e.longitude>=this.west&&e.longitude<=this.east&&e.latitude>=this.south&&e.latitude<=this.north},s.prototype.isEmpty=function(){return this.west>=this.east||this.south>=this.north};var l=new n;return s.prototype.subsample=function(e,n,o){e=t(e,i.WGS84),n=t(n,0),r(o)||(o=[]);var s=0,u=this.north,c=this.south,h=this.east,d=this.west,m=l;m.height=n,m.longitude=d,m.latitude=u,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.longitude=h,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.latitude=c,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.longitude=d,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.latitude=0>u?u:c>0?c:0;for(var p=1;8>p;++p){var f=-Math.PI+p*a.PI_OVER_TWO;f>d&&h>f&&(m.longitude=f,o[s]=e.cartographicToCartesian(m,o[s]),s++)}return 0===m.latitude&&(m.longitude=d,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.longitude=h,o[s]=e.cartographicToCartesian(m,o[s]),s++),o.length=s,o},s.MAX_VALUE=e(new s(-Math.PI,-a.PI_OVER_TWO,Math.PI,a.PI_OVER_TWO)),s}),r("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i,n){"use strict";var o=function(e,r,i,n){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(r,0),this[3]=t(n,0)};return o.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3]):void 0},o.fromArray=function(e,i,n){return i=t(i,0),r(n)||(n=new o),n[0]=e[i],n[1]=e[i+1],n[2]=e[i+2],n[3]=e[i+3],n},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new o(e,0,0,e)},o.fromRotation=function(e,t){var i=Math.cos(e),n=Math.sin(e);return r(t)?(t[0]=i,t[1]=n,t[2]=-n,t[3]=i,t):new o(i,-n,n,i)},o.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,t){return 2*e+t},o.getColumn=function(t,i,n){var o=2*i,a=t[o],s=t[o+1];return r(n)?(n.x=a,n.y=s,n):new e(a,s)},o.setColumn=function(e,t,r,i){i=o.clone(e,i);var n=2*t;return i[n]=r.x,i[n+1]=r.y,i},o.getRow=function(t,i,n){var o=t[i],a=t[i+2];return r(n)?(n.x=o,n.y=a,n):new e(o,a)},o.setRow=function(e,t,r,i){return i=o.clone(e,i),i[t]=r.x,i[t+2]=r.y,i},o.multiply=function(e,t,i){var n=e[0]*t[0]+e[2]*t[1],a=e[0]*t[2]+e[2]*t[3],s=e[1]*t[0]+e[3]*t[1],l=e[1]*t[2]+e[3]*t[3];return r(i)?(i[0]=n,i[1]=s,i[2]=a,i[3]=l,i):new o(n,a,s,l)},o.multiplyByVector=function(t,i,n){var o=t[0]*i.x+t[2]*i.y,a=t[1]*i.x+t[3]*i.y;return r(n)?(n.x=o,n.y=a,n):new e(o,a)},o.multiplyByScalar=function(e,t,i){return r(i)?(i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i):new o(e[0]*t,e[2]*t,e[1]*t,e[3]*t)},o.negate=function(e,t){return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t):new o(-e[0],-e[2],-e[1],-e[3])},o.transpose=function(e,t){var i=e[0],n=e[2],a=e[1],s=e[3];return r(t)?(t[0]=i,t[1]=n,t[2]=a,t[3]=s,t):new o(i,a,n,s)},o.abs=function(e,t){return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t):new o(Math.abs(e[0]),Math.abs(e[2]),Math.abs(e[1]),Math.abs(e[3]))},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsEpsilon=function(e,t,i){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i},o.IDENTITY=n(new o(1,0,0,1)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n"+"("+this[1]+", "+this[3]+")"},o}),r("Core/ExtentGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./Extent","./Geometry","./GeometryInstance","./GeometryPipeline","./GeographicProjection","./GeometryAttribute","./GeometryAttributes","./Math","./Matrix2","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x){"use strict";function S(e,t){return e<-y.PI_OVER_TWO||e>y.PI_OVER_TWO?!1:t>y.PI||t<-y.PI?!1:!0}function E(e,r,i,n,o){var a=e.radiiSquared;O=z.latitude-e.granYCos*r+i*e.granXSin;var s=et(O),l=tt(O),u=a.z*l;R=z.longitude+r*e.granYSin+i*e.granXCos;var c=s*et(R),h=s*tt(R),d=a.x*c,m=a.y*h,p=rt(d*c+m*h+u*l),f=d/p,v=m/p,y=u/p;t(n)&&(q.x=f+c*n,q.y=v+h*n,q.z=y+l*n),t(o)&&(Y.x=f+c*o,Y.y=v+h*o,Y.z=y+l*o)}function b(e,t){var r=new h({attributes:new v,primitiveType:w.TRIANGLES});return e.position&&(r.attributes.position=new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:t.positions})),e.normal&&(r.attributes.normal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(r.attributes.tangent=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.binormal&&(r.attributes.binormal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.binormals})),r}function T(e,t,r,i,o){var a=e.length,s=t.normal?new Float32Array(a):void 0,l=t.tangent?new Float32Array(a):void 0,u=t.binormal?new Float32Array(a):void 0,c=0,h=i?a/2:0;a=i&&o?a/2:a;for(var d=0;a>d;d+=3){var m=n.fromArray(e,d,q),p=c+1,f=c+2;(t.normal||t.tangent||t.binormal)&&(G=r.geodeticSurfaceNormal(m,G),(t.tangent||t.binormal)&&(n.cross(n.UNIT_Z,G,H),_.multiplyByVector(U,H,H),n.normalize(H,H),t.binormal&&n.normalize(n.cross(G,H,j),j)),i&&(t.normal&&(s[c]=G.x,s[p]=G.y,s[f]=G.z),t.tangent&&(l[c]=H.x,l[p]=H.y,l[f]=H.z),t.binormal&&(u[c]=j.x,u[p]=j.y,u[f]=j.z)),o&&(t.normal&&(s[c+h]=-G.x,s[p+h]=-G.y,s[f+h]=-G.z),t.tangent&&(l[c+h]=-H.x,l[p+h]=-H.y,l[f+h]=-H.z),t.binormal&&(u[c+h]=j.x,u[p+h]=j.y,u[f+h]=j.z))),c+=3}return b(t,{positions:e,normals:s,tangents:l,binormals:u})}function A(e,t,r){for(var i=e.length,o=t.normal?new Float32Array(i):void 0,a=t.tangent?new Float32Array(i):void 0,s=t.binormal?new Float32Array(i):void 0,l=0,u=!0,c=i/2,h=0;c>h;h+=3){var d=n.fromArray(e,h,q),m=l+1,p=l+2;if(t.normal||t.tangent||t.binormal){var f=n.fromArray(e,h+3,J);if(u){var v=n.fromArray(e,h+c,K);n.subtract(f,d,f),n.subtract(v,d,v),G=n.normalize(n.cross(v,f,G),G),u=!1}n.equalsEpsilon(f,d,y.EPSILON10)&&(u=!0),(t.tangent||t.binormal)&&(j=r.geodeticSurfaceNormal(d,j),t.tangent&&(H=n.normalize(n.cross(j,G,H),H))),t.normal&&(o[l]=G.x,o[m]=G.y,o[p]=G.z,o[l+c]=G.x,o[m+c]=G.y,o[p+c]=G.z),t.tangent&&(a[l]=H.x,a[m]=H.y,a[p]=H.z,a[l+c]=H.x,a[m+c]=H.y,a[p+c]=H.z),t.binormal&&(s[l]=j.x,s[m]=j.y,s[p]=j.z,s[l+c]=j.x,s[m+c]=j.y,s[p+c]=j.z)}l+=3}return b(t,{positions:e,normals:o,tangents:a,binormals:s})}function D(e,r,i,n,o){return Q.x=(R-F.west)*n.lonScalar-.5,Q.y=(O-F.south)*n.latScalar-.5,g.multiplyByVector(V,Q,Q),Q.x+=.5,Q.y+=.5,t(o)&&(i[r+o]=Q.x,i[r+1+o]=Q.y),i[r++]=Q.x,i[r++]=Q.y,r}function P(e,t,r){return e[t+r]=Y.x,e[t++]=q.x,e[t+r]=Y.y,e[t++]=q.y,e[t+r]=Y.z,e[t++]=q.z,e}function M(e,t){for(var i=t.ellipsoid,n=t.size,o=t.height,l=t.width,u=t.surfaceHeight,c=0,h=e.position?new Float64Array(3*n):void 0,d=e.st?new Float32Array(2*n):void 0,m=0,p=0;o>p;++p)for(var v=0;l>v;++v)E(t,p,v,u),h[m++]=q.x,h[m++]=q.y,h[m++]=q.z,e.st&&(Q.x=(R-F.west)*t.lonScalar-.5,Q.y=(O-F.south)*t.latScalar-.5,g.multiplyByVector(V,Q,Q),Q.x+=.5,Q.y+=.5,d[c++]=Q.x,d[c++]=Q.y);for(var y=T(h,e,i,!0,!1),_=6*(l-1)*(o-1),w=s.createTypedArray(n,_),C=0,x=0,S=0;o-1>S;++S){for(var b=0;l-1>b;++b){var A=C,D=A+l,P=D+1,M=A+1;w[x++]=A,w[x++]=D,w[x++]=M,w[x++]=M,w[x++]=D,w[x++]=P,++C}++C}return y.indices=w,e.st&&(y.attributes.st=new f({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:d})),{boundingSphere:r.fromExtent3D(t.extent,i,u),geometry:y}}function I(t,i){var o=i.surfaceHeight,l=i.extrudedHeight,u=Math.min(l,o),c=Math.max(l,o);if(y.equalsEpsilon(u,c,.1))return M(t,i);var h,p=i.height,v=i.width,g=i.size,_=i.ellipsoid,w=e(i.closeTop,!0),C=e(i.closeBottom,!0),x=2*v+2*p-4,S=2*(x+4),b=new Float64Array(3*S),I=t.st?new Float32Array(2*S):void 0,O=0,R=0,L=0,z=3*(S/2);for(h=0;p>h;h++)E(i,h,O,c,u),b=P(b,R,z),R+=3,t.st&&(L=D(t,L,I,i,S));for(h=p-1,O=0;v>O;O++)E(i,h,O,c,u),b=P(b,R,z),R+=3,t.st&&(L=D(t,L,I,i,S));for(O=v-1,h=p-1;h>=0;h--)E(i,h,O,c,u),b=P(b,R,z),R+=3,t.st&&(L=D(t,L,I,i,S));for(h=0,O=v-1;O>=0;O--)E(i,h,O,c,u),b=P(b,R,z),R+=3,t.st&&(L=D(t,L,I,i,S));var N=A(b,t,_);t.st&&(N.attributes.st=new f({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:I}));var B,F,V,k,U,W=s.createTypedArray(S,6*x),G=b.length/6,H=0;for(U=0;G-1>U;U++){B=U,k=B+1;var j=n.fromArray(b,3*B,J),Q=n.fromArray(b,3*k,K);n.equalsEpsilon(j,Q,y.EPSILON10)||(F=B+G,V=F+1,W[H++]=B,W[H++]=F,W[H++]=k,W[H++]=k,W[H++]=F,W[H++]=V)}if(N.indices=W,C||w){var $,et,tt=0,rt=0;w&&(tt+=g,rt+=6*(v-1)*(p-1),$=c),C&&(tt+=g,rt+=6*(v-1)*(p-1),et=u);var it=new Float64Array(3*tt),nt=t.st?new Float32Array(2*tt):void 0,ot=s.createTypedArray(tt,rt);for(R=0,L=0,z=C&&w?3*g:0,h=0;p>h;++h)for(O=0;v>O;++O)E(i,h,O,$,et),C&&(it[R+z]=Y.x,it[R+1+z]=Y.y,it[R+2+z]=Y.z),w&&(it[R]=q.x,it[R+1]=q.y,it[R+2]=q.z),t.st&&(L=D(t,L,nt,i,2*g)),R+=3;var at=T(it,t,_,w,C);t.st&&(at.attributes.st=new f({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:nt}));var st=0;for(H=0,z/=3,U=0;p-1>U;++U){for(var lt=0;v-1>lt;++lt)B=H,F=B+v,V=F+1,k=B+1,C&&(ot[st++]=k+z,ot[st++]=F+z,ot[st++]=B+z,ot[st++]=V+z,ot[st++]=F+z,ot[st++]=k+z),w&&(ot[st++]=B,ot[st++]=F,ot[st++]=k,ot[st++]=k,ot[st++]=F,ot[st++]=V),++H;++H}at.indices=ot,N=m.combine([new d({geometry:at}),new d({geometry:N})])}var ut=r.fromExtent3D(i.extent,_,c,Z),ct=r.fromExtent3D(i.extent,_,u,X),ht=r.union(ut,ct);return{boundingSphere:ht,geometry:N}}var O,R,L=new n,z=new o,N=new o,B=new n,F=new c,V=new g,k=new g,U=new _,W=new p,q=new n,G=new n,H=new n,j=new n,Y=new n,X=new r,Z=new r,J=new n,K=new n,Q=new i,$=new C,et=Math.cos,tt=Math.sin,rt=Math.sqrt,it=function(r){r=e(r,e.EMPTY_OBJECT);var i=r.extent,n=e(r.granularity,y.RADIANS_PER_DEGREE),o=e(r.ellipsoid,u.WGS84),a=e(r.height,0),s=r.rotation,c=r.stRotation,h=e(r.vertexFormat,x.DEFAULT);if(!t(i))throw new l("extent is required.");if(i.validate(),i.east<i.west)throw new l("options.extent.east must be greater than options.extent.west");if(i.north<i.south)throw new l("options.extent.north must be greater than options.extent.south");this._extent=i,this._granularity=n,this._ellipsoid=o,this._surfaceHeight=a,this._rotation=s,this._stRotation=c,this._vertexFormat=h,this._extrudedHeight=r.extrudedHeight,this._closeTop=r.closeTop,this._closeBottom=r.closeBottom,this._workerName="createExtentGeometry"};return it.createGeometry=function(e){var r=e._extent,i=e._granularity,o=e._ellipsoid,a=e._surfaceHeight,s=e._rotation,u=e._stRotation,d=e._vertexFormat,m=e._extrudedHeight,p=e._closeTop,f=e._closeBottom,y=Math.ceil((r.east-r.west)/i)+1,w=Math.ceil((r.north-r.south)/i)+1,x=(r.east-r.west)/(y-1),E=(r.north-r.south)/(w-1),b=o.getRadiiSquared();c.clone(r,F),r.getNorthwest(z),r.getCenter(N);var T=E,A=x,D=0,P=0;if(t(s)){var O=et(s);T*=O,A*=O;var R=tt(s);D=E*R,P=x*R,W.project(z,L),W.project(N,B),n.subtract(L,B,L),g.fromRotation(s,k),g.multiplyByVector(k,L,L),n.add(L,B,L),W.unproject(L,z);var q=z.latitude,G=q+(y-1)*P,H=q-T*(w-1),j=q-T*(w-1)+(y-1)*P,Y=Math.max(q,G,H,j),X=Math.min(q,G,H,j),Z=z.longitude,K=Z+(y-1)*A,Q=Z+(w-1)*D,rt=Z+(w-1)*D+(y-1)*A,it=Math.max(Z,K,Q,rt),nt=Math.min(Z,K,Q,rt);if(!(S(Y,nt)&&S(Y,it)&&S(X,nt)&&S(X,it)))throw new l("Rotated extent is invalid.");F.north=Y,F.south=X,F.east=it,F.west=nt}var ot=1/(F.east-F.west),at=1/(F.north-F.south),st=y*w;if(t(u)){g.fromRotation(-u,V);var lt=o.cartographicToCartesian(N,J);n.normalize(lt,lt),C.fromAxisAngle(lt,-u,$),_.fromQuaternion($,U)}else g.clone(g.IDENTITY,V),_.clone(_.IDENTITY,U);var ut,ct={granYCos:T,granYSin:D,granXCos:A,granXSin:P,radiiSquared:b,ellipsoid:o,lonScalar:ot,latScalar:at,extent:r,width:y,height:w,surfaceHeight:a,size:st,extrudedHeight:m,closeTop:p,closeBottom:f};ut=t(m)?I(d,ct):M(d,ct);var ht=ut.boundingSphere;return ut=ut.geometry,new h({attributes:new v(ut.attributes),indices:ut.indices,primitiveType:ut.primitiveType,boundingSphere:ht})},it}),r("Core/ExtentOutlineGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./Math","./Matrix2","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f){"use strict";function v(e,t){return e<-m.PI_OVER_TWO||e>m.PI_OVER_TWO?!1:t>m.PI||t<-m.PI?!1:!0}function y(e,r,i,n,o){var a=e.radiiSquared;w=S.latitude-e.granYCos*r+i*e.granXSin;var s=O(w),l=R(w),u=a.z*l;C=S.longitude+r*e.granYSin+i*e.granXCos;var c=s*O(C),h=s*R(C),d=a.x*c,m=a.y*h,p=L(d*c+m*h+u*l),f=d/p,v=m/p,y=u/p;t(n)&&(D.x=f+c*n,D.y=v+h*n,D.z=y+l*n),t(o)&&(P.x=f+c*o,P.y=v+h*o,P.z=y+l*o)}function g(e){var t,i=e.extent,n=e.ellipsoid,o=e.size,s=e.height,l=e.width,u=e.surfaceHeight,c=new Float64Array(3*o),h=0,d=0;for(t=0;l>t;t++)y(e,d,t,u),c[h++]=D.x,c[h++]=D.y,c[h++]=D.z;for(t=l-1,d=1;s>d;d++)y(e,d,t,u),c[h++]=D.x,c[h++]=D.y,c[h++]=D.z;for(d=s-1,t=l-2;t>=0;t--)y(e,d,t,u),c[h++]=D.x,c[h++]=D.y,c[h++]=D.z;for(t=0,d=s-2;d>0;d--)y(e,d,t,u),c[h++]=D.x,c[h++]=D.y,c[h++]=D.z;for(var m=2*(c.length/3),p=a.createTypedArray(c.length/3,m),f=0,v=0;v<c.length/3-1;v++)p[f++]=v,p[f++]=v+1;return p[f++]=c.length/3-1,p[f++]=0,{boundingSphere:r.fromExtent3D(i,n,u),positions:c,indices:p}}function _(e,t){var i=e.surfaceHeight,n=Math.min(t,i),o=Math.max(t,i);if(m.equalsEpsilon(n,o,.1))return g(e);var s,l=e.extent,u=e.height,c=e.width,h=3*e.size,d=e.ellipsoid,p=0,f=0,v=new Float64Array(2*h);for(s=0;c>s;s++)y(e,f,s,o,n),v[p+h]=P.x,v[p+h+1]=P.y,v[p+h+2]=P.z,v[p++]=D.x,v[p++]=D.y,v[p++]=D.z;for(s=c-1,f=1;u>f;f++)y(e,f,s,o,n),v[p+h]=P.x,v[p+h+1]=P.y,v[p+h+2]=P.z,v[p++]=D.x,v[p++]=D.y,v[p++]=D.z;for(f=u-1,s=c-2;s>=0;s--)y(e,f,s,o,n),v[p+h]=P.x,v[p+h+1]=P.y,v[p+h+2]=P.z,v[p++]=D.x,v[p++]=D.y,v[p++]=D.z;for(s=0,f=u-2;f>0;f--)y(e,f,s,o,n),v[p+h]=P.x,v[p+h+1]=P.y,v[p+h+2]=P.z,v[p++]=D.x,v[p++]=D.y,v[p++]=D.z;for(var _=2*(v.length/3)+8,w=a.createTypedArray(v.length/3,_),C=v.length/6,x=0,S=0;C-1>S;S++)w[x++]=S,w[x++]=S+1,w[x++]=S+C,w[x++]=S+C+1;w[x++]=C-1,w[x++]=0,w[x++]=C+C-1,w[x++]=C,w[x++]=0,w[x++]=C,w[x++]=c-1,w[x++]=C+c-1,w[x++]=c+u-2,w[x++]=c+u-2+C,w[x++]=2*c+u-3,w[x++]=2*c+u-3+C;var E=r.fromExtent3D(l,d,o,I),b=r.fromExtent3D(l,d,n,M),T=r.union(E,b);return{boundingSphere:T,positions:v,indices:w}}var w,C,x=new i,S=new n,E=new n,b=new i,T=new p,A=new u,D=new i,P=new i,M=new r,I=new r,O=Math.cos,R=Math.sin,L=Math.sqrt,z=function(r){r=e(r,e.EMPTY_OBJECT);var i=r.extent,n=e(r.granularity,m.RADIANS_PER_DEGREE),o=e(r.ellipsoid,l.WGS84),a=e(r.height,0),u=r.rotation;if(!t(i))throw new s("extent is required.");i.validate(),this._extent=i,this._granularity=n,this._ellipsoid=o,this._surfaceHeight=a,this._rotation=u,this._extrudedHeight=r.extrudedHeight,this._workerName="createExtentOutlineGeometry"};return z.createGeometry=function(e){var r=e._extent,n=e._granularity,a=e._ellipsoid,l=e._surfaceHeight,u=e._rotation,m=e._extrudedHeight,y=Math.ceil((r.east-r.west)/n)+1,w=Math.ceil((r.north-r.south)/n)+1,C=(r.east-r.west)/(y-1),D=(r.north-r.south)/(w-1),P=a.getRadiiSquared();r.getNorthwest(S),r.getCenter(E);var M=D,I=C,L=0,z=0;if(t(u)){var N=O(u);M*=N,I*=N;var B=R(u);L=D*B,z=C*B,A.project(S,x),A.project(E,b),i.subtract(x,b,x),p.fromRotation(u,T),p.multiplyByVector(T,x,x),i.add(x,b,x),A.unproject(x,S);var F=S.latitude,V=F+(y-1)*z,k=F-M*(w-1),U=F-M*(w-1)+(y-1)*z,W=Math.max(F,V,k,U),q=Math.min(F,V,k,U),G=S.longitude,H=G+(y-1)*I,j=G+(w-1)*L,Y=G+(w-1)*L+(y-1)*I,X=Math.max(G,H,j,Y),Z=Math.min(G,H,j,Y);if(!(v(W,Z)&&v(W,X)&&v(q,Z)&&v(q,X)))throw new s("Rotated extent is invalid.")}var J,K=2*y+2*w-4,Q={granYCos:M,granYSin:L,granXCos:I,granXSin:z,radiiSquared:P,ellipsoid:a,extent:r,width:y,height:w,surfaceHeight:l,size:K};J=t(m)?_(Q,m):g(Q);var $=new d({position:new h({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:J.positions})});return new c({attributes:$,indices:J.indices,primitiveType:f.LINES,boundingSphere:J.boundingSphere})},z}),r("Core/FAR",[],function(){"use strict";var e=5906376272e3;return e}),r("Core/HeightmapTessellator",["./defaultValue","./defined","./freezeObject","./DeveloperError","./Cartesian3","./Ellipsoid","./Math"],function(e,t,r,i,n,o,a){"use strict";var s={};return s.DEFAULT_STRUCTURE=r({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1}),s.computeVertices=function(r){if(!t(r)||!t(r.heightmap))throw new i("description.heightmap is required.");if(!t(r.width)||!t(r.height))throw new i("description.width and description.height are required.");if(!t(r.vertices))throw new i("description.vertices is required.");if(!t(r.nativeExtent))throw new i("description.nativeExtent is required.");if(!t(r.skirtHeight))throw new i("description.skirtHeight is required.");var l,u,c,h,d=Math.cos,m=Math.sin,p=Math.sqrt,f=Math.atan,v=Math.exp,y=a.PI_OVER_TWO,g=a.toRadians,_=r.vertices,w=r.heightmap,C=r.width,x=r.height,S=r.skirtHeight,E=e(r.isGeographic,!0),b=e(r.ellipsoid,o.WGS84),T=1/b.getMaximumRadius(),A=r.nativeExtent,D=r.extent;t(D)?(l=D.west,u=D.south,c=D.east,h=D.north):E?(l=g(A.west),u=g(A.south),c=g(A.east),h=g(A.north)):(l=A.west*T,u=y-2*f(v(-A.south*T)),c=A.east*T,h=y-2*f(v(-A.north*T)));var P=e(r.relativeToCenter,n.ZERO),M=e(r.structure,s.DEFAULT_STRUCTURE),I=e(M.heightScale,s.DEFAULT_STRUCTURE.heightScale),O=e(M.heightOffset,s.DEFAULT_STRUCTURE.heightOffset),R=e(M.elementsPerHeight,s.DEFAULT_STRUCTURE.elementsPerHeight),L=e(M.stride,s.DEFAULT_STRUCTURE.stride),z=e(M.elementMultiplier,s.DEFAULT_STRUCTURE.elementMultiplier),N=e(M.isBigEndian,s.DEFAULT_STRUCTURE.isBigEndian),B=(A.east-A.west)/(C-1),F=(A.north-A.south)/(x-1),V=b.getRadiiSquared(),k=V.x,U=V.y,W=V.z,q=0,G=65536,H=-65536,j=0,Y=x,X=0,Z=C;S>0&&(--j,++Y,--X,++Z);for(var J=j;Y>J;++J){var K=J;0>K&&(K=0),K>=x&&(K=x-1);var Q=A.north-F*K;Q=E?g(Q):y-2*f(v(-Q*T));for(var $=d(Q),et=m(Q),tt=W*et,rt=(Q-u)/(h-u),it=X;Z>it;++it){var nt=it;0>nt&&(nt=0),nt>=C&&(nt=C-1);var ot=A.west+B*nt;E?ot=g(ot):ot*=T;var at,st=K*C*L+nt*L;if(1===R)at=w[st];else{at=0;var lt;if(N)for(lt=0;R>lt;++lt)at=at*z+w[st+lt];else for(lt=R-1;lt>=0;--lt)at=at*z+w[st+lt]}at=at*I+O,H=Math.max(H,at),G=Math.min(G,at),(it!==nt||J!==K)&&(at-=S);var ut=$*d(ot),ct=$*m(ot),ht=k*ut,dt=U*ct,mt=p(ht*ut+dt*ct+tt*et),pt=1/mt,ft=ht*pt,vt=dt*pt,yt=tt*pt;_[q++]=ft+ut*at-P.x,_[q++]=vt+ct*at-P.y,_[q++]=yt+et*at-P.z,_[q++]=at;var gt=(ot-l)/(c-l);_[q++]=gt,_[q++]=rt}}return{maximumHeight:H,minimumHeight:G}},s}),r("Core/HermitePolynomialApproximation",["./defined","./Math"],function(e,t){"use strict";function r(e,t,i,n,o,a){var s,l,u,c=0;if(n>0){for(l=0;o>l;l++){for(s=!1,u=0;u<a.length&&!s;u++)l===a[u]&&(s=!0);s||(a.push(l),c+=r(e,t,i,n-1,o,a),a.splice(a.length-1,1))}return c}for(c=1,l=0;o>l;l++){for(s=!1,u=0;u<a.length&&!s;u++)l===a[u]&&(s=!0);s||(c*=e-i[t[l]])}return c}var i=t.factorial,n={type:"Hermite"};return n.getRequiredDataPoints=function(e){return Math.max(e+1,2)},n.interpolateOrderZero=function(t,n,o,a,s){e(s)||(s=new Array(a));var l,u,c,h,d,m,p=n.length,f=new Array(a);for(l=0;a>l;l++){s[l]=0;var v=new Array(p);for(f[l]=v,u=0;p>u;u++)v[u]=[]}var y=p,g=new Array(y);for(l=0;y>l;l++)g[l]=l;var _=p-1;for(h=0;a>h;h++){for(u=0;y>u;u++)m=g[u]*a+h,f[h][0].push(o[m]);for(l=1;y>l;l++){var w=!1;for(u=0;y-l>u;u++){var C,x=n[g[u]],S=n[g[u+l]];0>=S-x?(m=g[u]*a+a*l+h,C=o[m],f[h][l].push(C/i(l))):(C=f[h][l-1][u+1]-f[h][l-1][u],f[h][l].push(C/(S-x))),w=w||0!==C}w||(_=l-1)}}for(c=0,d=0;d>=c;c++)for(l=c;_>=l;l++){var E=r(t,g,n,c,l,[]);for(h=0;a>h;h++){var b=f[h][l][0];s[h+c*a]+=b*E}}return s},n}),r("Core/IauOrientationParameters",["./defined","./DeveloperError"],function(){"use strict";var e=function(e,t,r,i){this.rightAscension=e,this.declination=t,this.rotation=r,this.rotationRate=i};return e}),r("Core/Iau2000Orientation",["./defined","./IauOrientationParameters","./JulianDate","./Math","./TimeConstants"],function(e,t,r,i,n){"use strict";var o={},a=32.184,s=2451545,l=-.0529921,u=-.1059842,c=13.0120009,h=13.3407154,d=.9856003,m=26.4057084,p=13.064993,f=.3287146,v=1.7484877,y=-.1589763,g=.0036096,_=.1643573,w=12.9590088;return o.ComputeMoon=function(o,C){e(o)||(o=new r);var x=o.addSeconds(a),S=x.getTotalDays()-s,E=S/n.DAYS_PER_JULIAN_CENTURY,b=(125.045+l*S)*i.RADIANS_PER_DEGREE,T=(250.089+u*S)*i.RADIANS_PER_DEGREE,A=(260.008+c*S)*i.RADIANS_PER_DEGREE,D=(176.625+h*S)*i.RADIANS_PER_DEGREE,P=(357.529+d*S)*i.RADIANS_PER_DEGREE,M=(311.589+m*S)*i.RADIANS_PER_DEGREE,I=(134.963+p*S)*i.RADIANS_PER_DEGREE,O=(276.617+f*S)*i.RADIANS_PER_DEGREE,R=(34.226+v*S)*i.RADIANS_PER_DEGREE,L=(15.134+y*S)*i.RADIANS_PER_DEGREE,z=(119.743+g*S)*i.RADIANS_PER_DEGREE,N=(239.961+_*S)*i.RADIANS_PER_DEGREE,B=(25.053+w*S)*i.RADIANS_PER_DEGREE,F=Math.sin(b),V=Math.sin(T),k=Math.sin(A),U=Math.sin(D),W=Math.sin(P),q=Math.sin(M),G=Math.sin(I),H=Math.sin(O),j=Math.sin(R),Y=Math.sin(L),X=Math.sin(z),Z=Math.sin(N),J=Math.sin(B),K=Math.cos(b),Q=Math.cos(T),$=Math.cos(A),et=Math.cos(D),tt=Math.cos(P),rt=Math.cos(M),it=Math.cos(I),nt=Math.cos(O),ot=Math.cos(R),at=Math.cos(L),st=Math.cos(z),lt=Math.cos(N),ut=Math.cos(B),ct=(269.9949+.0031*E-3.8787*F-.1204*V+.07*k-.0172*U+.0072*q-.0052*Y+.0043*J)*i.RADIANS_PER_DEGREE,ht=(66.5392+.013*E+1.5419*K+.0239*Q-.0278*$+.0068*et-.0029*rt+9e-4*it+8e-4*at-9e-4*ut)*i.RADIANS_PER_DEGREE,dt=(38.3213+13.17635815*S-1.4e-12*S*S+3.561*F+.1208*V-.0642*k+.0158*U+.0252*W-.0066*q-.0047*G-.0046*H+.0028*j+.0052*Y+.004*X+.0019*Z-.0044*J)*i.RADIANS_PER_DEGREE,mt=(13.17635815-1.4e-12*2*S+3.561*K*l+.1208*Q*u-.0642*$*c+.0158*et*h+.0252*tt*d-.0066*rt*m-.0047*it*p-.0046*nt*f+.0028*ot*v+.0052*at*y+.004*st*g+.0019*lt*_-.0044*ut*w)/86400*i.RADIANS_PER_DEGREE;return e(C)||(C=new t),C.rightAscension=ct,C.declination=ht,C.rotation=dt,C.rotationRate=mt,C},o}),r("Core/IauOrientationAxes",["./Cartesian3","./defined","./DeveloperError","./Iau2000Orientation","./JulianDate","./Math","./Matrix3","./Quaternion"],function(e,t,r,i,n,o,a,s){"use strict";function l(r,i,n){var s=c;s.x=Math.cos(r+o.PI_OVER_TWO),s.y=Math.sin(r+o.PI_OVER_TWO),s.z=0;var l=Math.cos(i),u=d;u.x=l*Math.cos(r),u.y=l*Math.sin(r),u.z=Math.sin(i);var m=e.cross(u,s,h);return t(n)||(n=new a),n[0]=s.x,n[1]=m.x,n[2]=u.x,n[3]=s.y,n[4]=m.y,n[5]=u.y,n[6]=s.z,n[7]=m.z,n[8]=u.z,n}var u=function(e){t(e)&&"function"==typeof e||(e=i.ComputeMoon),this._computeFunction=e},c=new e,h=new e,d=new e,m=new a,p=new s;return u.prototype.evaluate=function(r,i){t(r)||(r=new n);var u=this._computeFunction(r),c=l(u.rightAscension,u.declination,i),h=o.zeroToTwoPi(u.rotation),d=s.fromAxisAngle(e.UNIT_Z,h,p),f=a.fromQuaternion(s.conjugate(d,d),m),v=a.multiply(f,c,c);return v},u}),r("Core/InterpolationAlgorithm",["./DeveloperError"],function(e){"use strict";var t={};return t.type=void 0,t.getRequiredDataPoints=function(){throw new e("This function defines an interface and should not be called directly.")},t.interpolateOrderZero=function(){throw new e("This function defines an interface and should not be called directly.")},t}),r("Core/TimeInterval",["./defined","./DeveloperError","./freezeObject","./JulianDate","./TimeStandard"],function(e,t,r,i,n){"use strict";var o=function(r,n,o,a,s){if(!e(r))throw new t("start must be specified.");if(!e(n))throw new t("stop must be specified.");e(o)||(o=!0),e(a)||(a=!0);var l=i.compare(n,r);this.start=r,this.stop=n,this.data=s,this.isStartIncluded=o,this.isStopIncluded=a,this.isEmpty=0>l||0===l&&(!o||!a)};return o.fromIso8601=function(e,t,r,n){var a=e.split("/"),s=i.fromIso8601(a[0]),l=i.fromIso8601(a[1]);return new o(s,l,t,r,n)},o.equals=function(t,r,n){return t===r||e(t)&&e(r)&&(t.isEmpty&&r.isEmpty||t.isStartIncluded===r.isStartIncluded&&t.isStopIncluded===r.isStopIncluded&&i.equals(t.start,r.start)&&i.equals(t.stop,r.stop)&&(t.data===r.data||e(n)&&n(t.data,r.data)))},o.equalsEpsilon=function(r,n,o,a){if("number"!=typeof o)throw new t("epsilon is required and must be a number.");return r===n||e(r)&&e(n)&&(r.isEmpty&&n.isEmpty||r.isStartIncluded===n.isStartIncluded&&r.isStopIncluded===n.isStopIncluded&&i.equalsEpsilon(r.start,n.start,o)&&i.equalsEpsilon(r.stop,n.stop,o)&&(r.data===n.data||e(a)&&a(r.data,n.data)))},o.prototype.clone=function(){return new o(this.start,this.stop,this.isStartIncluded,this.isStopIncluded,this.data)},o.EMPTY=r(new o(new i(0,0,n.TAI),new i(0,0,n.TAI),!1,!1)),o.prototype.intersect=function(t,r){if(!e(t))return o.EMPTY;var n,a,s,l=t.start,u=t.stop,c=t.isStartIncluded,h=t.isStopIncluded,d=this.start,m=this.stop,p=this.isStartIncluded,f=this.isStopIncluded;return l.greaterThanOrEquals(d)&&m.greaterThanOrEquals(l)?(a=!i.equals(l,d)&&c||p&&c,s=f&&h,n=e(r)?r(this.data,t.data):this.data,m.greaterThanOrEquals(u)?(s=s||!i.equals(u,m)&&h,new o(l,u,a,s,n)):(s=s||f,new o(l,m,a,s,n))):l.lessThanOrEquals(d)&&d.lessThanOrEquals(u)?(a=i.equals(l,d)===!1&&p||p&&c,s=f&&h,n=e(r)?r(this.data,t.data):this.data,m.greaterThanOrEquals(u)?(s=s||i.equals(u,m)===!1&&h,new o(d,u,a,s,n)):(s=s||f,new o(d,m,a,s,n))):o.EMPTY},o.prototype.contains=function(e){if(this.isEmpty)return!1;var t=i.compare(this.start,e);if(0===t)return this.isStartIncluded;var r=i.compare(e,this.stop);return 0===r?this.isStopIncluded:0>t&&0>r},o.prototype.equals=function(e,t){return o.equals(this,e,t)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o}),r("Core/Iso8601",["./freezeObject","./JulianDate","./TimeInterval"],function(e,t,r){"use strict";var i=e(t.fromIso8601("0000-01-01T00:00:00Z")),n=e(t.fromIso8601("9999-12-31T24:00:00Z")),o=e(new r(i,n,!0,!0)),a={MINIMUM_VALUE:i,MAXIMUM_VALUE:n,MAXIMUM_INTERVAL:o};return a}),r("Core/KeyboardEventModifier",["./Enumeration"],function(e){"use strict";var t={SHIFT:new e(0,"SHIFT"),CTRL:new e(1,"CTRL"),ALT:new e(2,"ALT")};return t}),r("Core/LagrangePolynomialApproximation",["./defined"],function(e){"use strict";var t={type:"Lagrange"};return t.getRequiredDataPoints=function(e){return Math.max(e+1,2)},t.interpolateOrderZero=function(t,r,i,n,o){e(o)||(o=new Array(n));var a,s,l=r.length;for(a=0;n>a;a++)o[a]=0;for(a=0;l>a;a++){var u=1;for(s=0;l>s;s++)if(s!==a){var c=r[a]-r[s];u*=(t-r[s])/c}for(s=0;n>s;s++)o[s]+=u*i[a*n+s]}return o},t}),r("Core/LinearApproximation",["./defined","./DeveloperError"],function(e,t){"use strict";var r={type:"Linear"};return r.getRequiredDataPoints=function(e){if(1!==e)throw new t("Linear interpolation can only generate a first degree polynomial.");return 2},r.interpolateOrderZero=function(r,i,n,o,a){if(2!==i.length)throw new t("The xTable provided to the linear interpolator must have exactly two elements.");if(0>=o)throw new t("There must be at least 1 dependent variable for each independent variable.");e(a)||(a=new Array(o));var s,l,u,c=i[0],h=i[1];if(c===h)throw new t("Divide by zero error: xTable[0] and xTable[1] are equal");for(s=0;o>s;s++)l=n[s],u=n[s+o],a[s]=((u-l)*r+h*l-c*u)/(h-c);return a},r}),r("Core/LinearSpline",["./defaultValue","./defined","./DeveloperError","./Spline","./Cartesian3"],function(e,t,r,i,n){"use strict";var o=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.points,o=i.times;if(!t(n))throw new r("points is required.");if(n.length<2)throw new r("points.length must be greater than or equal to 2.");if(!t(o))throw new r("times is required.");if(o.length!==n.length)throw new r("times.length must be equal to points.length.");this.times=o,this.points=n,this._lastTimeIndex=0};return o.prototype.findTimeInterval=i.prototype.findTimeInterval,o.prototype.evaluate=function(e,r){var i=this.points,o=this.times,a=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),s=(e-o[a])/(o[a+1]-o[a]);return t(r)||(r=new n),n.lerp(i[a],i[a+1],s,r)},o}),r("Core/NearFarScalar",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(t,r,i,n){this.near=e(t,0),this.nearValue=e(r,0),this.far=e(i,1),this.farValue=e(n,0)};return i.clone=function(e,r){return t(e)?t(r)?(r.near=e.near,r.nearValue=e.nearValue,r.far=e.far,r.farValue=e.farValue,r):new i(e.near,e.nearValue,e.far,e.farValue):void 0
},i.packedLength=4,i.pack=function(i,n,o){if(!t(i))throw new r("value is required");if(!t(n))throw new r("array is required");o=e(o,0),n[o++]=i.near,n[o++]=i.nearValue,n[o++]=i.far,n[o]=i.farValue},i.unpack=function(n,o,a){if(!t(n))throw new r("array is required");return o=e(o,0),t(a)||(a=new i),a.near=n[o++],a.nearValue=n[o++],a.far=n[o++],a.farValue=n[o],a},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.near===r.near&&e.nearValue===r.nearValue&&e.far===r.far&&e.farValue===r.farValue},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),r("Core/ObjectOrientedBoundingBox",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Intersect","./Matrix3","./BoundingRectangle"],function(e,t,r,i,n,o){"use strict";function a(e,t,r,i,n){var a=t[e]+r[0]*i[o.getElementIndex(0,e)]+r[1]*i[o.getElementIndex(1,e)]+r[2]*i[o.getElementIndex(2,e)];return Math.abs(n[e])>a?!0:!1}function s(e,t,r,i,n){var a=n[0]*i[o.getElementIndex(0,e)]+n[1]*i[o.getElementIndex(1,e)]+n[2]*i[o.getElementIndex(2,e)],s=r[e]+t[0]*i[o.getElementIndex(0,e)]+t[1]*i[o.getElementIndex(1,e)]+t[2]*i[o.getElementIndex(2,e)];return Math.abs(a)>s?!0:!1}function l(e,t,r,i,n,a){var s=a[(e+2)%3]*n[o.getElementIndex((e+1)%3,t)]-a[(e+1)%3]*n[o.getElementIndex((e+2)%3,t)],l=r[(e+1)%3]*n[o.getElementIndex((e+2)%3,t)]+r[(e+2)%3]*n[o.getElementIndex((e+1)%3,t)];return l+=i[(t+1)%3]*n[o.getElementIndex(e,(t+2)%3)]+i[(t+2)%3]*n[o.getElementIndex(e,(t+1)%3)],Math.abs(s)>l?!0:!1}var u=function(t,r,n){this.rotation=o.clone(e(t,o.IDENTITY)),this.translation=i.clone(e(r,i.ZERO)),this.scale=i.clone(e(n,i.ZERO))},c=new i,h=new i,d=new i,m=new i,p=new i;new i;var f=new o,v={unitary:new o,diagonal:new o};u.fromPoints=function(e,r){if(t(r)||(r=new u),!t(e)||0===e.length)return r.tranformMatrix=o.IDENTITY,r.translation=i.ZERO,r.scale=i.ZERO,r;var n,a=e.length,s=i.clone(e[0],c);for(n=1;a>n;n++)i.add(s,e[n],s);var l=1/a;i.multiplyByScalar(s,l,s);var y,g=0,_=0,w=0,C=0,x=0,S=0;for(n=0;a>n;n++)y=i.subtract(e[n],s,h),g+=y.x*y.x,_+=y.x*y.y,w+=y.x*y.z,C+=y.y*y.y,x+=y.y*y.z,S+=y.z*y.z;g*=l,_*=l,w*=l,C*=l,x*=l,S*=l;var E=f;E[0]=g,E[1]=_,E[2]=w,E[3]=_,E[4]=C,E[5]=x,E[6]=w,E[7]=x,E[8]=S;var b=o.getEigenDecomposition(E,v),T=o.transpose(b.unitary,r.rotation);y=i.subtract(e[0],s,h);var A=o.multiplyByVector(T,y,d),D=i.clone(A,m),P=i.clone(A,p);for(n=1;a>n;n++)y=i.subtract(e[n],s,y),o.multiplyByVector(T,y,A),i.getMinimumByComponent(P,A,P),i.getMaximumByComponent(D,A,D);var M=i.add(P,D,d);i.multiplyByScalar(M,.5,M),o.multiplyByVector(T,M,M),i.add(s,M,r.translation);var I=i.subtract(D,P,d);return i.multiplyByScalar(I,.5,r.scale),r},u.fromBoundingRectangle=function(e,i,n){if(!t(e))throw new r("boundingRectangle is required");t(n)||(n=new u),t(i)?o.fromRotationZ(i,n.rotation):o.clone(o.IDENTITY,n.rotation);var a=n.scale;a.x=.5*e.width,a.y=.5*e.height,a.z=0;var s=o.multiplyByVector(n.rotation,a,n.translation);return s.x+=e.x,s.y+=e.y,n},u.clone=function(e,r){return t(e)?t(r)?(o.clone(e.rotation,r.rotation),i.clone(e.translation,r.translation),i.clone(e.scale,r.scale),r):new u(e.rotation,e.translation,e.scale):void 0};var y=new o,g=new o,_=new i,w=new Array(3),C=new Array(3),x=new Array(3);return u.intersect=function(e,n){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");var u=o.transpose(e.rotation,y),c=o.multiply(u,n.rotation,g);o.abs(c,c);var h=w,d=C,m=x;return i.subtract(e.translation,n.translation,_),o.multiplyByVector(u,_,_),i.pack(_,h),i.pack(e.scale,d),i.pack(n.scale,m),a(0,d,m,c,h)?!1:a(1,d,m,c,h)?!1:a(2,d,m,c,h)?!1:s(0,d,m,c,h)?!1:s(1,d,m,c,h)?!1:s(2,d,m,c,h)?!1:l(0,0,d,m,c,h)?!1:l(1,0,d,m,c,h)?!1:l(2,0,d,m,c,h)?!1:l(0,1,d,m,c,h)?!1:l(1,1,d,m,c,h)?!1:l(2,1,d,m,c,h)?!1:l(0,2,d,m,c,h)?!1:l(1,2,d,m,c,h)?!1:l(2,2,d,m,c,h)?!1:!0},u.equals=function(e,r){return e===r||t(e)&&t(r)&&i.equals(e.transformedPosition,r.transformedPosition)&&o.equals(e.transformMatrix,r.transformMatrix)&&i.equals(e.extent,r.extent)},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),r("Core/Visibility",["./Enumeration"],function(e){"use strict";var t={NONE:new e(-1,"NONE"),PARTIAL:new e(0,"PARTIAL"),FULL:new e(1,"FULL")};return t}),r("Core/Occluder",["./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Visibility","./Ellipsoid","./BoundingSphere"],function(e,t,r,i,n,o,a,s){"use strict";var l=function(e,i){if(!t(e))throw new r("occluderBoundingSphere is required.");if(!t(i))throw new r("camera position is required.");this._occluderPosition=n.clone(e.center),this._occluderRadius=e.radius,this._horizonDistance=0,this._horizonPlaneNormal=void 0,this._horizonPlanePosition=void 0,this._cameraPosition=void 0,this.setCameraPosition(i)};l.fromBoundingSphere=function(e,i,o){if(!t(e))throw new r("occluderBoundingSphere is required.");if(!t(i))throw new r("camera position is required.");return t(o)?(n.clone(e.center,o._occluderPosition),o._occluderRadius=e.radius,o.setCameraPosition(i),o):new l(e,i)},l.prototype.getPosition=function(){return this._occluderPosition},l.prototype.getRadius=function(){return this._occluderRadius};var u=new n;l.prototype.setCameraPosition=function(e){if(!t(e))throw new r("cameraPosition is required.");e=n.clone(e,this._cameraPosition);var i,o,a,s=n.subtract(this._occluderPosition,e,u),l=n.magnitudeSquared(s),c=this._occluderRadius*this._occluderRadius;if(l>c){i=Math.sqrt(l-c),l=1/Math.sqrt(l),o=n.multiplyByScalar(s,l,u);var h=i*i*l;a=n.add(e,n.multiplyByScalar(o,h,u),u)}else i=Number.MAX_VALUE;this._horizonDistance=i,this._horizonPlaneNormal=o,this._horizonPlanePosition=a,this._cameraPosition=e};var c=new n;l.prototype.isPointVisible=function(e){if(this._horizonDistance!==Number.MAX_VALUE){var t=n.subtract(e,this._occluderPosition,c),r=this._occluderRadius;if(r=n.magnitudeSquared(t)-r*r,r>0)return r=Math.sqrt(r)+this._horizonDistance,t=n.subtract(e,this._cameraPosition,t),r*r>n.magnitudeSquared(t)}return!1};var h=new n;l.prototype.isBoundingSphereVisible=function(e){var t=n.clone(e.center,h),r=e.radius;if(this._horizonDistance!==Number.MAX_VALUE){var i=n.subtract(t,this._occluderPosition,c),o=this._occluderRadius-r;if(o=n.magnitudeSquared(i)-o*o,r<this._occluderRadius)return o>0?(o=Math.sqrt(o)+this._horizonDistance,i=n.subtract(t,this._cameraPosition,i),o*o+r*r>n.magnitudeSquared(i)):!1;if(o>0){i=n.subtract(t,this._cameraPosition,i);var a=n.magnitudeSquared(i),s=this._occluderRadius*this._occluderRadius,l=r*r;return(this._horizonDistance*this._horizonDistance+s)*l>a*s?!0:(o=Math.sqrt(o)+this._horizonDistance,o*o+l>a)}return!0}return!1},l.prototype.getVisibility=function(e){if(!t(e))throw new r("occludeeBS is required.");var i=n.clone(e.center),a=e.radius;if(a>this._occluderRadius)return o.FULL;if(this._horizonDistance!==Number.MAX_VALUE){var s=n.subtract(i,this._occluderPosition),l=this._occluderRadius-a,u=n.magnitudeSquared(s);if(l=u-l*l,l>0){l=Math.sqrt(l)+this._horizonDistance,s=n.subtract(i,this._cameraPosition);var c=n.magnitudeSquared(s);return c>l*l+a*a?o.NONE:(l=this._occluderRadius+a,l=u-l*l,l>0?(l=Math.sqrt(l)+this._horizonDistance,l*l+a*a>c?o.FULL:o.PARTIAL):(s=n.subtract(i,this._horizonPlanePosition),n.dot(s,this._horizonPlaneNormal)>-a?o.PARTIAL:o.FULL))}}return o.NONE},l.getOccludeePoint=function(e,i,o){if(!t(e))throw new r("occluderBoundingSphere is required.");if(!t(o))throw new r("positions is required.");if(0===o.length)throw new r("positions must contain at least one element");var a=n.clone(i),s=n.clone(e.center),u=e.radius,c=o.length;if(n.equals(s,i))throw new r("occludeePosition must be different than occluderBoundingSphere.center");var h=n.normalize(n.subtract(a,s)),d=-n.dot(h,s),m=l._anyRotationVector(s,h,d),p=l._horizonToPlaneNormalDotProduct(e,h,d,m,o[0]);if(!p)return void 0;for(var f,v=1;c>v;++v){if(f=l._horizonToPlaneNormalDotProduct(e,h,d,m,o[v]),!f)return void 0;p>f&&(p=f)}if(.0017453283658983088>p)return void 0;var y=u/p;return n.add(s,n.multiplyByScalar(h,y))};var d=[];return l.computeOccludeePointFromExtent=function(i,o){if(!t(i))throw new r("extent is required.");o=e(o,a.WGS84);var u=i.subsample(o,0,d),c=s.fromPoints(u),h=n.ZERO;return n.equals(h,c.center)?void 0:l.getOccludeePoint(new s(h,o.getMinimumRadius()),c.center,u)},l._anyRotationVector=function(e,t,r){var i=n.abs(t),o=i.x>i.y?0:1;(0===o&&i.z>i.x||1===o&&i.z>i.y)&&(o=2);var a=new n;0===o?(i.x=e.x,i.y=e.y+1,i.z=e.z+1,a=n.UNIT_X):1===o?(i.x=e.x+1,i.y=e.y,i.z=e.z+1,a=n.UNIT_Y):(i.x=e.x+1,i.y=e.y+1,i.z=e.z,a=n.UNIT_Z);var s=(n.dot(t,i)+r)/-n.dot(t,a);return n.normalize(n.subtract(n.add(i,n.multiplyByScalar(a,s)),e))},l._rotationVector=function(e,t,r,o,a){var s=n.subtract(o,e);if(s=n.normalize(s),n.dot(t,s)<.9999999847691291){var l=n.cross(t,s),u=n.magnitude(l);if(u>i.EPSILON13)return n.normalize(l)}return a},l._horizonToPlaneNormalDotProduct=function(e,t,r,i,o){var a=n.clone(o),s=n.clone(e.center),l=e.radius,u=n.subtract(s,a),c=n.magnitudeSquared(u),h=l*l;if(h>c)return!1;var d=c-h,m=Math.sqrt(d),p=Math.sqrt(c),f=1/p,v=m*f,y=v*m;u=n.normalize(u);var g=n.add(a,n.multiplyByScalar(u,y)),_=Math.sqrt(d-y*y),w=this._rotationVector(s,t,r,a,i),C=new n(w.x*w.x*u.x+(w.x*w.y-w.z)*u.y+(w.x*w.z+w.y)*u.z,(w.x*w.y+w.z)*u.x+w.y*w.y*u.y+(w.y*w.z-w.x)*u.z,(w.x*w.z-w.y)*u.x+(w.y*w.z+w.x)*u.y+w.z*w.z*u.z);C=n.normalize(C);var x=n.multiplyByScalar(C,_);w=n.normalize(n.subtract(n.add(g,x),s));var S=n.dot(t,w);w=n.normalize(n.subtract(n.subtract(g,x),s));var E=n.dot(t,w);return E>S?S:E},l}),r("Core/Packable",["../Core/DeveloperError"],function(e){"use strict";function t(){throw new e("This type should not be instantiated directly.")}var r={packedLength:void 0,pack:t,unpack:t};return r}),r("Core/PackableForInterpolation",["../Core/DeveloperError"],function(e){"use strict";function t(){throw new e("This type should not be instantiated directly.")}var r={packedInterpolationLength:void 0,convertPackedArrayForInterpolation:t,unpackInterpolationResult:t};return r}),r("Core/PolygonGeometryLibrary",["./defaultValue","./defined","./Cartesian3","./Ellipsoid"],function(e,t,r,i){"use strict";function n(e,t,i,n){return r.subtract(t,e,a),r.multiplyByScalar(a,i/n,a),r.add(e,a,a),[a.x,a.y,a.z]}var o={},a=new r;o.subdivideLine=function(e,t,i){var o=r.distance(e,t),a=r.angleBetween(e,t),s=a/i,l=Math.ceil(Math.log(s)/Math.log(2));1>l&&(l=0);var u=Math.pow(2,l),c=o/u,h=new Array(3*u),d=0;h[d++]=e.x,h[d++]=e.y,h[d++]=e.z;for(var m=1;u>m;m++){var p=n(e,t,m*c,o);h[d++]=p[0],h[d++]=p[1],h[d++]=p[2]}return h};var s=new r,l=new r,u=new r,c=new r;return o.scaleToGeodeticHeightExtruded=function(n,o,a,h,d){h=e(h,i.WGS84);var m=s,p=l,f=u,v=c;if(t(n)&&t(n.attributes)&&t(n.attributes.position))for(var y=n.attributes.position.values,g=y.length/2,_=0;g>_;_+=3)r.fromArray(y,_,f),h.geodeticSurfaceNormal(f,m),v=h.scaleToGeodeticSurface(f,v),p=r.multiplyByScalar(m,a,p),p=r.add(v,p,p),y[_+g]=p.x,y[_+1+g]=p.y,y[_+2+g]=p.z,d&&(v=r.clone(f,v)),p=r.multiplyByScalar(m,o,p),p=r.add(v,p,p),y[_]=p.x,y[_+1]=p.y,y[_+2]=p.z;return n},o}),r("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3","./DeveloperError"],function(e,t){"use strict";var r=new t,i=function(t,i,n,o){return e(t,i,n,o,r),r.x>0&&r.y>0&&r.z>0};return i}),r("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this.length--,r},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),r("Core/WindingOrder",["./Enumeration"],function(e){"use strict";var t={CLOCKWISE:new e(2304,"CLOCKWISE"),COUNTER_CLOCKWISE:new e(2305,"COUNTER_CLOCKWISE"),validate:function(e){return e===t.CLOCKWISE||e===t.COUNTER_CLOCKWISE}};return t}),r("Core/PolygonPipeline",["./DeveloperError","./Math","./Cartesian2","./Cartesian3","./defined","./Geometry","./GeometryAttribute","./Ellipsoid","./EllipsoidTangentPlane","./defaultValue","./pointInsideTriangle","./ComponentDatatype","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p){"use strict";function f(e,t,i){var n=r.subtract(t,e),o=r.subtract(i,t);return n.x*o.y-n.y*o.x>=0}function v(e){for(var t=e[0].x,r=0,i=0;i<e.length;i++)e[i].x>t&&(t=e[i].x,r=i);return r}function y(e){for(var t=e[0][0].x,r=0,i=0;i<e.length;i++){var n=e[i][v(e[i])].x;n>t&&(t=n,r=i)}return r}function g(e){for(var t=[],r=0;r<e.length;r++){var i=e[(r-1+e.length)%e.length],n=e[r],o=e[(r+1)%e.length];f(i,n,o)||t.push(n)}return t}function _(e,t){for(var i=0;i<e.length;i++)if(r.equals(t,e[i]))return i;return-1}function w(e,t,n){n=u(n,[]);var o=Number.MAX_VALUE,a=v(t),s=new r(t[a].x,e.y);n.push(a),n.push((a+1)%t.length);for(var l=t[0].x,c=l,h=1;h<t.length;++h)t[h].x<l?l=t[h].x:t[h].x>c&&(c=t[h].x);c+=c-l;var d=new i(c,e.y,0);for(h=0;h<t.length;h++){var m=t[h],p=t[(h+1)%t.length];if((m.x>=e.x||p.x>=e.x)&&(m.y>=e.y&&p.y<=e.y||m.y<=e.y&&p.y>=e.y)){var f=(p.y-m.y)*(d.x-e.x)-(p.x-m.x)*(d.y-e.y);if(0!==f){f=1/f;var y=((p.x-m.x)*(e.y-m.y)-(p.y-m.y)*(e.x-m.x))*f,g=((d.x-e.x)*(e.y-m.y)-(d.y-e.y)*(e.x-m.x))*f;if(y>=0&&1>=y&&g>=0&&1>=g){var _=new r(e.x+y*(d.x-e.x),e.y+y*(d.y-e.y)),w=r.subtract(_,e);f=r.magnitudeSquared(w),o>f&&(s=_,o=f,n[0]=h,n[1]=(h+1)%t.length)}}}}return s}function C(e,t){var i=y(t),n=t[i],o=v(n),a=n[o],s=[],l=w(a,e,s),u=_(e,l);if(-1!==u)return u;var h=r.magnitudeSquared(r.subtract(e[s[0]],a)),d=r.magnitudeSquared(r.subtract(e[s[1]],a)),m=d>h?e[s[0]]:e[s[1]],p=g(e),f=p.indexOf(m);-1!==f&&p.splice(f,1);for(var C=[],x=0;x<p.length;x++){var S=p[x];c(S,a,l,m)&&C.push(S)}var E=Number.MAX_VALUE;if(C.length>0){var b=new r(1,0);for(x=0;x<C.length;x++){var T=r.subtract(C[x],a),A=r.magnitude(b)*r.magnitudeSquared(T);if(0!==A){var D=Math.abs(Math.acos(r.dot(b,T)/A));E>D&&(E=D,m=C[x])}}}return e.indexOf(m)}function x(e,t,r){for(var n=q.computeWindingOrder2D(e),o=0;o<t.length;o++){var a=t[o];i.equals(a[0],a[a.length-1])||a.push(a[0]);var s=q.computeWindingOrder2D(a);s===n&&a.reverse()}var u=l.fromPoints(e,r),c=u.projectPointsOntoPlane(e),h=[];for(o=0;o<t.length;o++)h.push(u.projectPointsOntoPlane(t[o]));var d=C(c,h),m=y(h),p=v(h[m]),f=t[m],g=[];for(o=0;o<e.length;o++)g.push(e[o]);var _,w=[];if(0!==p)for(_=0;_<=f.length;_++){var x=(_+p)%f.length;0!==x&&w.push(f[x])}else for(_=0;_<f.length;_++)w.push(f[(_+p)%f.length]);var S=g.lastIndexOf(e[d]);w.push(e[S]);var E=g.slice(0,S+1),b=g.slice(S+1);return g=E.concat(w,b),t.splice(m,1),g}function S(e){var t="0."+Math.sin(F).toString().substr(5);F+=.2;var r=Math.floor(t*e);return r===e&&r--,r}function E(e,t,i){return b(e,t,i)&&b(t,e,i)&&!L(i[e].position,i[t].position,i)&&!r.equals(i[e].position,i[t].position)}function b(e,t,n){D(e,n);var o=n[e],a=n[t],s=A(e,n,V),l=A(e,n,k),u=r.subtract(n[s].position,o.position),c=r.subtract(n[l].position,o.position),h=r.subtract(a.position,o.position);return u=new i(u.x,u.y,0),c=new i(c.x,c.y,0),h=new i(h.x,h.y,0),P(u,h)?T(u,h):P(c,h)?T(c,h):M(u,c)?R(u,c,h)?!0:!1:I(u,c)?O(u,c,h)?!1:!0:void 0}function T(e,t){return r.magnitude(t)<r.magnitude(e)}function A(e,t,r){var i=e+r;return 0>i&&(i=t.length-1),i===t.length&&(i=0),D(i,t),i}function D(t,n){var o=t-1,a=t+1;0>o&&(o=n.length-1),a===n.length&&(a=0);var s=r.subtract(n[o].position,n[t].position),l=r.subtract(n[a].position,n[t].position);if(s=new i(s.x,s.y,0),l=new i(l.x,l.y,0),P(s,l)){var u=new e("Superfluous vertex found.");throw u.vertexIndex=t,u}}function P(e,t){return 0===i.cross(e,t).z}function M(e,t){return i.cross(e,t).z<0}function I(e,t){return i.cross(e,t).z>0}function O(e,t,r){return i.cross(e,r).z>0&&i.cross(r,t).z>0}function R(e,t,r){return i.cross(e,r).z<0&&i.cross(r,t).z<0}function L(e,t,i){for(var n=0;n<i.length;n++){var o,a=i[n].position;if(o=n<i.length-1?i[n+1].position:i[0].position,!(r.equals(e,a)||r.equals(t,o)||r.equals(e,o)||r.equals(t,a))){var s=(t.y-e.y)/(t.x-e.x),l=(o.y-a.y)/(o.x-a.x);if(!(s===l||isNaN(s)&&isNaN(l))){var u;u=isNaN(s)?e.x:isNaN(l)?a.x:(e.y-a.y-s*e.x+l*a.x)/(l-s);var c=s*u+e.y-s*e.x,h=new r(u,c);if(!(r.equals(h,e)||r.equals(h,t)||r.equals(h,a)||r.equals(h,o))){var d=N(u,e.x,t.x)&&N(c,e.y,t.y)&&N(u,a.x,o.x)&&N(c,a.y,o.y);if(d)return!0}}}}return!1}function z(e){var t=e[0].position,n=e[1].position,o=e[2].position,a=r.subtract(n,t),s=r.subtract(o,t);return a=new i(a.x,a.y,0),s=new i(s.x,s.y,0),P(a,s)}function N(e,t,r){return(e>t||e>r)&&(t>e||r>e)||t===r&&t===e}function B(t){var r=t.length;if(3===r)return z(t)?[]:[t[0].index,t[1].index,t[2].index];if(t.length<3)throw new e("Invalid polygon: must have at least three vertices.");for(var i=!1,n=0;!i;){var o=10*t.length;if(n>o)return[];n++;for(var a=S(t.length),s=a+1;Math.abs(a-s)<2||Math.abs(a-s)>t.length-2;)s=S(t.length);if(a>s){var l=a;a=s,s=l}try{if(E(a,s,t)){var u=t.splice(a,s-a+1,t[a],t[s]);return B(t).concat(B(u))}}catch(c){if(c.hasOwnProperty("vertexIndex"))return t.splice(c.vertexIndex,1),B(t);throw c}}}var F=0,V=-1,k=1,U=new i,W=new i,q={removeDuplicates:function(t){if(!n(t))throw new e("positions is required.");var r=t.length;if(3>r)throw new e("At least three positions are required.");for(var o=[],a=r-1,s=0;r>s;a=s++){var l=t[a],u=t[s];i.equals(l,u)||o.push(u)}return o},computeArea2D:function(t){if(!n(t))throw new e("positions is required.");var r=t.length;if(3>r)throw new e("At least three positions are required.");for(var i=0,o=r-1,a=0;r>a;o=a++){var s=t[o],l=t[a];i+=s.x*l.y-l.x*s.y}return.5*i},computeWindingOrder2D:function(e){var t=q.computeArea2D(e);return t>=0?p.COUNTER_CLOCKWISE:p.CLOCKWISE},triangulate:function(t){if(!n(t))throw new e("positions is required.");var r=t.length;if(3>r)throw new e("At least three positions are required.");for(var i=[],o=0;r>o;++o)i[o]={position:t[o],index:o};return B(i)},resetSeed:function(e){F=u(e,0)},computeSubdivision:function(r,s,l){if(!n(r))throw new e("positions is required.");if(!n(s))throw new e("indices is required.");if(s.length<3)throw new e("At least three indices are required.");if(0!==s.length%3)throw new e("The number of indices must be divisable by three.");if(l=u(l,t.RADIANS_PER_DEGREE),0>=l)throw new e("granularity must be greater than zero.");for(var c=new m,p=s.length,f=0;p>f;f+=3)c.enqueue({i0:s[f],i1:s[f+1],i2:s[f+2]});for(var v,y=r.slice(0),g=[],_={};c.length>0;){var w,C,x=c.dequeue(),S=y[x.i0],E=y[x.i1],b=y[x.i2],T=i.angleBetween(S,E),A=i.angleBetween(E,b),D=i.angleBetween(b,S),P=Math.max(T,Math.max(A,D));P>l?T===P?(w=Math.min(x.i0,x.i1).toString()+" "+Math.max(x.i0,x.i1).toString(),v=_[w],v||(C=i.add(S,E),i.multiplyByScalar(C,.5,C),y.push(C),v=y.length-1,_[w]=v),c.enqueue({i0:x.i0,i1:v,i2:x.i2}),c.enqueue({i0:v,i1:x.i1,i2:x.i2})):A===P?(w=Math.min(x.i1,x.i2).toString()+" "+Math.max(x.i1,x.i2).toString(),v=_[w],v||(C=i.add(E,b),i.multiplyByScalar(C,.5,C),y.push(C),v=y.length-1,_[w]=v),c.enqueue({i0:x.i1,i1:v,i2:x.i0}),c.enqueue({i0:v,i1:x.i2,i2:x.i0})):D===P&&(w=Math.min(x.i2,x.i0).toString()+" "+Math.max(x.i2,x.i0).toString(),v=_[w],v||(C=i.add(b,S),i.multiplyByScalar(C,.5,C),y.push(C),v=y.length-1,_[w]=v),c.enqueue({i0:x.i2,i1:v,i2:x.i1}),c.enqueue({i0:v,i1:x.i0,i2:x.i1})):(g.push(x.i0),g.push(x.i1),g.push(x.i2))}var M=y.length,I=new Array(3*M),O=0;for(v=0;M>v;v++){var R=y[v];I[O++]=R.x,I[O++]=R.y,I[O++]=R.z}return new o({attributes:{position:new a({componentDatatype:h.DOUBLE,componentsPerAttribute:3,values:I})},indices:g,primitiveType:d.TRIANGLES})},scaleToGeodeticHeight:function(e,t,r,o){r=u(r,s.WGS84);var a=U,l=W;if(t=u(t,0),o=u(o,!0),n(e)&&n(e.attributes)&&n(e.attributes.position))for(var c=e.attributes.position.values,h=c.length,d=0;h>d;d+=3)i.fromArray(c,d,l),o&&(l=r.scaleToGeodeticSurface(l,l)),a=r.geodeticSurfaceNormal(l,a),i.multiplyByScalar(a,t,a),i.add(l,a,l),c[d]=l.x,c[d+1]=l.y,c[d+2]=l.z;return e},eliminateHoles:function(t,r,o){if(!n(t))throw new e("outerRing is required.");if(0===t.length)throw new e("outerRing must not be empty.");if(!n(r))throw new e("innerRings is required.");o=u(o,s.WGS84);for(var a=[],l=0;l<r.length;l++){for(var c=[],h=0;h<r[l].length;h++)c.push(i.clone(r[l][h]));a.push(c)}for(var d=t;a.length>0;)d=x(d,a,o);return d}};return q}),r("Core/PolygonGeometry",["./defaultValue","./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonGeometryLibrary","./PolygonPipeline","./PrimitiveType","./Quaternion","./Queue","./VertexFormat","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E){"use strict";function b(e,t,r,i){for(var o=C.fromAxisAngle(e._plane.normal,r,O),s=y.fromQuaternion(o,R),l=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY,h=Number.NEGATIVE_INFINITY,d=t.length,m=0;d>m;++m){var p=n.clone(t[m],I);y.multiplyByVector(s,p,p);var f=e.projectPointOntoPlane(p,M);a(f)&&(l=Math.min(l,f.x),u=Math.max(u,f.x),c=Math.min(c,f.y),h=Math.max(h,f.y))}return i.x=l,i.y=c,i.width=u-l,i.height=h-c,i}function T(e,t,r,i){var n=u.fromPoints(t,e),a=n.projectPointsOntoPlane(t,L),s=_.computeWindingOrder2D(a);s===E.CLOCKWISE&&(a.reverse(),t.reverse());var l=_.triangulate(a);l.length<3&&(l=[0,1,2]);var d;if(i){for(var p=t.length,f=new Array(3*p),v=0,y=0;p>y;y++){var g=t[y];f[v++]=g.x,f[v++]=g.y,f[v++]=g.z}d=new c({attributes:{position:new h({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:f})},indices:l,primitiveType:w.TRIANGLES})}else d=_.computeSubdivision(t,l,r);return new m({geometry:d})}function A(e,t,r,a,s,l,c){if(e.st||e.normal||e.tangent||e.binormal){var d=u.fromPoints(r,a),m=b(d,r,s,z),p=q;p.x=m.x,p.y=m.y;var f=t.attributes.position.values,g=f.length,_=e.st?new Float32Array(2*(g/3)):void 0,w=e.normal?new Float32Array(g):void 0,x=e.tangent?new Float32Array(g):void 0,S=e.binormal?new Float32Array(g):void 0,E=0,T=0,A=B,D=F,P=V,M=!0,I=C.fromAxisAngle(d._plane.normal,s,j),O=y.fromQuaternion(I,Y),R=g/2,L=g/3;l&&(g/=2);for(var k=0;g>k;k+=3){var X=n.fromArray(f,k,H);if(e.st){var Z=y.multiplyByVector(O,X,N),J=d.projectPointOntoPlane(Z,G);i.subtract(J,p,J),l&&(_[E+L]=J.x/m.width,_[E+1+L]=J.y/m.height),_[E]=J.x/m.width,_[E+1]=J.y/m.height,E+=2}if(e.normal||e.tangent||e.binormal){var K=T+1,Q=T+2;if(c){if(g>k+3){var $=n.fromArray(f,k+3,U);if(M){var et=n.fromArray(f,k+g,W);n.subtract($,X,$),n.subtract(et,X,et),A=n.normalize(n.cross(et,$,A),A),M=!1}n.equalsEpsilon($,X,v.EPSILON10)&&(M=!0)}(e.tangent||e.binormal)&&(P=a.geodeticSurfaceNormal(X,P),e.tangent&&(D=n.normalize(n.cross(P,A,D),D)))}else A=a.geodeticSurfaceNormal(X,A),(e.tangent||e.binormal)&&(D=n.cross(n.UNIT_Z,A,D),D=n.normalize(y.multiplyByVector(O,D,D),D),e.binormal&&(P=n.normalize(n.cross(A,D,P),P)));e.normal&&(l&&!c?(w[T+R]=-A.x,w[K+R]=-A.y,w[Q+R]=-A.z):(w[T+R]=A.x,w[K+R]=A.y,w[Q+R]=A.z),w[T]=A.x,w[K]=A.y,w[Q]=A.z),e.tangent&&(l&&!c?(x[T+R]=-D.x,x[K+R]=-D.y,x[Q+R]=-D.z):(x[T+R]=D.x,x[K+R]=D.y,x[Q+R]=D.z),x[T]=D.x,x[K]=D.y,x[Q]=D.z),e.binormal&&(l&&(S[T+R]=P.x,S[K+R]=P.y,S[Q+R]=P.z),S[T]=P.x,S[K]=P.y,S[Q]=P.z),T+=3}}e.st&&(t.attributes.st=new h({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:_})),e.normal&&(t.attributes.normal=new h({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:w})),e.tangent&&(t.attributes.tangent=new h({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:x})),e.binormal&&(t.attributes.binormal=new h({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:S}))}return t}function D(e,t,r){var i,a,s,l,u,m,p,y,_,C=[],x=e.length;if(r)for(p=0;x>p;p++)y=e[p],_=e[(p+1)%x],C.push(y.x,y.y,y.z,_.x,_.y,_.z);else for(p=0;x>p;p++)y=e[p],_=e[(p+1)%x],i=g.subdivideLine(y,_,t),i.push(_.x,_.y,_.z),C=C.concat(i);C=C.concat(C),x=C.length;var S=f.createTypedArray(x/3,x-6*e.length);for(a=0,x/=6,p=0;x>p;p++)s=p,l=s+1,y=n.fromArray(C,3*s,U),_=n.fromArray(C,3*l,W),n.equalsEpsilon(y,_,v.EPSILON6)||(u=s+x,m=u+1,S[a++]=s,S[a++]=u,S[a++]=l,S[a++]=l,S[a++]=u,S[a++]=m);return new c({attributes:new d({position:new h({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:C})}),indices:S,primitiveType:w.TRIANGLES})}function P(e,t,r,i,n){var a=T(e,t,r,n).geometry,s=a.attributes.position.values,l=a.indices,u=s.concat(s),p=u.length/3,v=f.createTypedArray(p,2*l.length);v.set(l);var y,g=l.length,w=p/2;for(y=0;g>y;y+=3){var C=v[y]+w,x=v[y+1]+w,S=v[y+2]+w;v[y+g]=S,v[y+1+g]=x,v[y+2+g]=C}var b=new c({attributes:new d({position:new h({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:u})}),indices:v,primitiveType:a.primitiveType}),A={topAndBottom:new m({geometry:b})};A.walls=[];var P=i.outerRing,M=_.computeWindingOrder2D(P);M===E.CLOCKWISE&&(P=P.reverse());var I=D(P,r,n);A.walls.push(new m({geometry:I}));var O=i.holes;for(y=0;y<O.length;y++){var R=O[y];M=_.computeWindingOrder2D(R),M!==E.CLOCKWISE&&(R=R.reverse()),I=D(R,r),A.walls.push(new m({geometry:I}))}return A}var M=new i,I=new n,O=new C,R=new y,L=[],z=new t,N=new n,B=new n,F=new n,V=new n,k=new r,U=new n,W=new n,q=new i,G=new i,H=new n,j=new C,Y=new y,X=function(t){t=e(t,e.EMPTY_OBJECT);var r=e(t.vertexFormat,S.DEFAULT),i=e(t.ellipsoid,l.WGS84),n=e(t.granularity,v.RADIANS_PER_DEGREE),o=e(t.stRotation,0),u=e(t.height,0),c=e(t.perPositionHeight,!1),h=t.extrudedHeight,d=a(h)&&(!v.equalsEpsilon(u,h,v.EPSILON6)||c);if(d){var m=h;h=Math.min(m,u),u=Math.max(m,u)}var p=t.polygonHierarchy;if(!a(p))throw new s("options.polygonHierarchy is required.");this._vertexFormat=r,this._ellipsoid=i,this._granularity=n,this._stRotation=o,this._height=u,this._extrudedHeight=h,this._extrude=d,this._polygonHierarchy=p,this._perPositionHeight=c,this._workerName="createPolygonGeometry"};return X.fromPositions=function(t){if(t=e(t,e.EMPTY_OBJECT),!a(t.positions))throw new s("options.positions is required.");var r={polygonHierarchy:{positions:t.positions},height:t.height,extrudedHeight:t.extrudedHeight,vertexFormat:t.vertexFormat,stRotation:t.stRotation,ellipsoid:t.ellipsoid,granularity:t.granularity,perPositionHeight:t.perPositionHeight};return new X(r)},X.createGeometry=function(e){var t,i,o,l,u=e._vertexFormat,h=e._ellipsoid,d=e._granularity,m=e._stRotation,v=e._height,y=e._extrudedHeight,w=e._extrude,C=e._polygonHierarchy,S=e._perPositionHeight,E=[],b=new x;b.enqueue(C),C=[];for(var D;0!==b.length;){var M=b.dequeue(),I=M.positions,O=M.holes;if(I=_.removeDuplicates(I),I.length<3)throw new s("At least three positions are required.");var R=O?O.length:0;if(0===R)C.push({outerRing:I,holes:[]}),E.push(I);else{var L=[];for(D=0;R>D;D++){var z=O[D];if(z.positions=_.removeDuplicates(z.positions),z.positions.length<3)throw new s("At least three positions are required.");L.push(z.positions);var F=0;a(z.holes)&&(F=z.holes.length);for(var V=0;F>V;V++)b.enqueue(z.holes[V])}C.push({outerRing:I,holes:L});var U=_.eliminateHoles(I,L);E.push(U)}}l=E[0],t=r.fromPoints(l);var W,q=[];if(w){for(D=0;D<E.length;D++)if(W=P(h,E[D],d,C[D],S),a(W)){o=W.topAndBottom,o.geometry=g.scaleToGeodeticHeightExtruded(o.geometry,v,y,h,S),o.geometry=A(u,o.geometry,l,h,m,!0,!1),q.push(o),i=W.walls;for(var G=0;G<i.length;G++){var H=i[G];H.geometry=g.scaleToGeodeticHeightExtruded(H.geometry,v,y,h,S),H.geometry=A(u,H.geometry,l,h,m,!0,!0),q.push(H)}}}else for(D=0;D<E.length;D++)W=T(h,E[D],d,S),a(W)&&(W.geometry=_.scaleToGeodeticHeight(W.geometry,v,h,!S),W.geometry=A(u,W.geometry,l,h,m,!1,!1),q.push(W));W=p.combine(q);var j=t.center;B=h.geodeticSurfaceNormal(j,B),N=n.multiplyByScalar(B,v,N),j=n.add(j,N,j),w&&(k=r.clone(t,k),j=k.center,N=n.multiplyByScalar(B,y,N),j=n.add(h.scaleToGeodeticSurface(j,j),N,j),t=r.union(t,k,t)),W.attributes.position.values=new Float64Array(W.attributes.position.values),W.indices=f.createTypedArray(W.attributes.position.values.length/3,W.indices);var Y=W.attributes;return u.position||delete Y.position,new c({attributes:Y,indices:W.indices,primitiveType:W.primitiveType,boundingSphere:t})},X}),r("Core/PolygonOutlineGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian3","./ComponentDatatype","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./PolygonGeometryLibrary","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_){"use strict";function w(e,t,r,i){var a=v.removeDuplicates(t);if(a.length<3)throw new o("Duplicate positions result in not enough positions to form a polygon.");var d=s.fromPoints(a,e),p=d.projectPointsOntoPlane(a,x),g=v.computeWindingOrder2D(p);g===_.CLOCKWISE&&(p.reverse(),a.reverse());var w,C=[],S=a.length;if(i)for(w=0;S>w;w++){var E=a[w],b=a[(w+1)%S];C.push(E.x,E.y,E.z,b.x,b.y,b.z)}else for(w=0;S>w;w++)C=C.concat(f.subdivideLine(a[w],a[(w+1)%S],r));S=C.length/3;var T=2*S,A=m.createTypedArray(C.length/3,T),D=0;for(w=0;S-1>w;w++)A[D++]=w,A[D++]=w+1;return A[D++]=S-1,A[D++]=0,new h({geometry:new l({attributes:new c({position:new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:new Float64Array(C)})}),indices:A,primitiveType:y.LINES})})}function C(e,t,r,i){var a=v.removeDuplicates(t);if(a.length<3)throw new o("Duplicate positions result in not enough positions to form a polygon.");var d=s.fromPoints(a,e),p=d.projectPointsOntoPlane(a,x),g=v.computeWindingOrder2D(p);g===_.CLOCKWISE&&(p.reverse(),a.reverse());var w,C=[],S=a.length,E=new Array(S);if(E[0]=0,i){var b,T;for(w=0;S-1>w;w++)b=a[w],T=a[(w+1)%S],C.push(b.x,b.y,b.z,T.x,T.y,T.z),E[w+1]=C.length/3;b=a[S-1],T=a[0],C.push(b.x,b.y,b.z,T.x,T.y,T.z)}else{for(w=0;S-1>w;w++)C=C.concat(f.subdivideLine(a[w],a[w+1],r)),E[w+1]=C.length/3;C=C.concat(f.subdivideLine(a[S-1],a[0],r))}S=C.length/3;var A=2*(2*S+E.length),D=m.createTypedArray(C.length/3,A),P=0;for(w=0;S-1>w;w++)D[P++]=w,D[P++]=w+1,D[P++]=w+S,D[P++]=w+1+S;for(D[P++]=S-1,D[P++]=0,D[P++]=S+S-1,D[P++]=S,w=0;w<E.length;w++){var M=E[w];D[P++]=M,D[P++]=M+S}return C=C.concat(C),new h({geometry:new l({attributes:new c({position:new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:new Float64Array(C)})}),indices:D,primitiveType:y.LINES})})}var x=[],S=new i,E=new i,b=new r,T=function(r){r=e(r,e.EMPTY_OBJECT);var i=e(r.ellipsoid,a.WGS84),n=e(r.granularity,p.RADIANS_PER_DEGREE),s=e(r.height,0),l=e(r.perPositionHeight,!1),u=r.extrudedHeight,c=t(u)&&(!p.equalsEpsilon(s,u,p.EPSILON6)||l);if(c){var h=u;u=Math.min(h,s),s=Math.max(h,s)}var d=r.polygonHierarchy;if(!t(d))throw new o("options.polygonHierarchy is required.");this._ellipsoid=i,this._granularity=n,this._height=s,this._extrudedHeight=u,this._extrude=c,this._polygonHierarchy=d,this._perPositionHeight=l,this._workerName="createPolygonOutlineGeometry"};return T.fromPositions=function(r){if(r=e(r,e.EMPTY_OBJECT),!t(r.positions))throw new o("options.positions is required.");var i={polygonHierarchy:{positions:r.positions},height:r.height,extrudedHeight:r.extrudedHeight,ellipsoid:r.ellipsoid,granularity:r.granularity,perPositionHeight:r.perPositionHeight};return new T(i)},T.createGeometry=function(e){var n,a,s=e._ellipsoid,u=e._granularity,c=e._height,h=e._extrudedHeight,m=e._extrude,p=e._polygonHierarchy,y=e._perPositionHeight,_=[],x=new g;x.enqueue(p);for(var T;0!==x.length;){var A=x.dequeue(),D=A.positions;if(D.length<3)throw new o("At least three positions are required.");var P=A.holes?A.holes.length:0;for(T=0;P>T;T++){var M=A.holes[T];_.push(M.positions);var I=0;t(M.holes)&&(I=M.holes.length);for(var O=0;I>O;O++)x.enqueue(M.holes[O])}_.push(D)}a=_[0],n=r.fromPoints(a);var R,L=[];if(m)for(T=0;T<_.length;T++)R=C(s,_[T],u,y),t(R)&&(R.geometry=f.scaleToGeodeticHeightExtruded(R.geometry,c,h,s,y),L.push(R));
else for(T=0;T<_.length;T++)R=w(s,_[T],u,y),t(R)&&(R.geometry=v.scaleToGeodeticHeight(R.geometry,c,s,!y),L.push(R));R=d.combine(L);var z=n.center;return E=s.geodeticSurfaceNormal(z,E),S=i.multiplyByScalar(E,c,S),z=i.add(z,S,z),m&&(b=r.clone(n,b),z=b.center,S=i.multiplyByScalar(E,h,S),z=i.add(z,S,z),n=r.union(n,b,n)),new l({attributes:R.attributes,indices:R.indices,primitiveType:R.primitiveType,boundingSphere:n})},T}),r("Core/PolylineGeometry",["./defined","./DeveloperError","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./defaultValue","./BoundingSphere","./Cartesian3","./PolylinePipeline","./VertexFormat","./Geometry","./GeometryAttribute","./GeometryAttributes","./Color"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m){"use strict";var p=function(r){r=o(r,o.EMPTY_OBJECT);var i=r.positions,n=r.colors,a=o(r.width,1),s=o(r.colorsPerVertex,!1);if(!e(i)||i.length<2)throw new t("At least two positions are required.");if(1>a)throw new t("width must be greater than or equal to one.");if(e(n)&&(s&&n.length<i.length||!s&&n.length<i.length-1))throw new t("colors has an invalid length.");this._positions=i,this._colors=n,this._width=a,this._perVertex=s,this._vertexFormat=o(r.vertexFormat,u.DEFAULT),this._workerName="createPolylineGeometry"},f=new s,v=new s,y=new s,g=new s;return p.createGeometry=function(t){var o,u,p,_=t._width,w=t._vertexFormat,C=t._colors,x=t._perVertex,S=l.wrapLongitude(t._positions),E=S.positions,b=S.lengths,T=0,A=b.length;for(o=0;A>o;++o)T+=4*b[o]-4;var D,P,M=new Float64Array(3*T),I=new Float64Array(3*T),O=new Float64Array(3*T),R=new Float32Array(2*T),L=w.st?new Float32Array(2*T):void 0,z=e(C)?new Uint8Array(4*T):void 0,N=0,B=0,F=0,V=0,k=0,U=0,W=E.length;for(u=0;W>u;++u){0===u?(P=f,s.subtract(E[0],E[1],P),s.add(E[0],P,P)):P=E[u-1],s.clone(P,y),s.clone(E[u],v),u===W-1?(P=f,s.subtract(E[W-1],E[W-2],P),s.add(E[W-1],P,P)):P=E[u+1],s.clone(P,g),D=b[k],u===U+D&&(U+=D,++k);var q,G,H=0===u-U,j=u===U+b[k]-1,Y=H?2:0,X=j?2:4;if(e(z)){var Z=u-k;q=H||x?C[Z]:C[Z-1],j||(G=C[Z])}for(p=Y;X>p;++p){s.pack(v,M,N),s.pack(y,I,N),s.pack(g,O,N),N+=3;var J=0>p-2?-1:1;if(R[B++]=2*(p%2)-1,R[B++]=J*_,w.st&&(L[F++]=u/(W-1),L[F++]=Math.max(R[B-2],0)),e(z)){var K=2>p?q:G;z[V++]=m.floatToByte(K.red),z[V++]=m.floatToByte(K.green),z[V++]=m.floatToByte(K.blue),z[V++]=m.floatToByte(K.alpha)}}}var Q=new d;Q.position=new h({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:M}),Q.prevPosition=new h({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:I}),Q.nextPosition=new h({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:O}),Q.expandAndWidth=new h({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:R}),w.st&&(Q.st=new h({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:L})),e(z)&&(Q.color=new h({componentDatatype:r.UNSIGNED_BYTE,componentsPerAttribute:4,values:z,normalize:!0})),A=b.length;var $=i.createTypedArray(T,6*E.length-6*A),et=0,tt=0;for(o=0;A>o;++o)for(D=b[o]-1,u=0;D>u;++u)$[tt++]=et,$[tt++]=et+2,$[tt++]=et+1,$[tt++]=et+1,$[tt++]=et+2,$[tt++]=et+3,et+=4;return new c({attributes:Q,indices:$,primitiveType:n.TRIANGLES,boundingSphere:a.fromPoints(E)})},p}),r("Core/PolylineVolumeGeometry",["./defined","./DeveloperError","./Cartesian3","./CornerType","./ComponentDatatype","./Ellipsoid","./Geometry","./GeometryPipeline","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./defaultValue","./BoundingSphere","./BoundingRectangle","./GeometryAttribute","./GeometryAttributes","./VertexFormat","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_){"use strict";function w(e,t,r,i){var o=new y;i.position&&(o.position=new v({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:e}));var u,h,m,f,g,_,w=t.length,C=e.length/3,x=(C-2*w)/(2*w),S=c.triangulate(t),E=6*(x-1)*w+2*S.length,b=l.createTypedArray(C,E),T=2*w,A=0;for(u=0;x-1>u;u++){for(h=0;w-1>h;h++)m=2*h+2*u*w,_=m+T,f=m+1,g=f+T,b[A++]=f,b[A++]=m,b[A++]=g,b[A++]=g,b[A++]=m,b[A++]=_;m=2*w-2+2*u*w,f=m+1,g=f+T,_=m+T,b[A++]=f,b[A++]=m,b[A++]=g,b[A++]=g,b[A++]=m,b[A++]=_}if(i.st||i.tangent||i.binormal){var D,P,M=new Float32Array(2*C),I=1/(x-1),O=1/r.height,R=r.height/2,L=0;for(u=0;x>u;u++){for(D=u*I,P=O*(t[0].y+R),M[L++]=D,M[L++]=P,h=1;w>h;h++)P=O*(t[h].y+R),M[L++]=D,M[L++]=P,M[L++]=D,M[L++]=P;P=O*(t[0].y+R),M[L++]=D,M[L++]=P}for(h=0;w>h;h++)D=0,P=O*(t[h].y+R),M[L++]=D,M[L++]=P;for(h=0;w>h;h++)D=(x-1)*I,P=O*(t[h].y+R),M[L++]=D,M[L++]=P;o.st=new v({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:new Float32Array(M)})}var z=C-2*w;for(u=0;u<S.length;u+=3){var N=S[u]+z,B=S[u+1]+z,F=S[u+2]+z;b[A++]=N,b[A++]=B,b[A++]=F,b[A++]=F+w,b[A++]=B+w,b[A++]=N+w}var V=new a({attributes:o,indices:b,boundingSphere:p.fromVertices(e),primitiveType:d.TRIANGLES});return i.normal&&(V=s.computeNormal(V)),(i.tangent||i.binormal)&&(V=s.computeBinormalAndTangent(V),i.tangent||(V.attributes.tangent=void 0),i.binormal||(V.attributes.binormal=void 0),i.st||(V.attributes.st=void 0)),V}var C=function(r){r=m(r,m.EMPTY_OBJECT);var n=r.polylinePositions;if(!e(n))throw new t("options.polylinePositions is required.");var a=r.shapePositions;if(!e(a))throw new t("options.shapePositions is required.");this._positions=n,this._shape=a,this._ellipsoid=m(r.ellipsoid,o.WGS84),this._height=m(r.height,0),this._cornerType=m(r.cornerType,i.ROUNDED),this._vertexFormat=m(r.vertexFormat,g.DEFAULT),this._granularity=m(r.granularity,u.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry"},x=new f;return C.createGeometry=function(e){var r=e._positions,i=h.removeDuplicatesFromPositions(r,e._ellipsoid);if(i.length<2)throw new t("Count of unique polyline positions must be greater than 1.");var n=e._shape;if(n=h.removeDuplicatesFromShape(n),n.length<3)throw new t("Count of unique shape positions must be at least 3.");c.computeWindingOrder2D(n).value===_.CLOCKWISE.value&&n.reverse();var o=f.fromPoints(n,x),a=h.computePositions(i,n,o,e,!0);return w(a,n,o,e._vertexFormat,e._ellipsoid)},C}),r("Core/PolylineVolumeOutlineGeometry",["./defined","./DeveloperError","./Cartesian3","./CornerType","./ComponentDatatype","./Ellipsoid","./Geometry","./GeometryPipeline","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./defaultValue","./BoundingSphere","./BoundingRectangle","./GeometryAttribute","./GeometryAttributes","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g){"use strict";function _(e,t){var r=new y;r.position=new v({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:e});var i,o,s=t.length,u=r.position.values.length/3,c=e.length/3,h=c/s,m=l.createTypedArray(u,2*s*(h+1)),f=0;i=0;var g=i*s;for(o=0;s-1>o;o++)m[f++]=o+g,m[f++]=o+g+1;for(m[f++]=s-1+g,m[f++]=g,i=h-1,g=i*s,o=0;s-1>o;o++)m[f++]=o+g,m[f++]=o+g+1;for(m[f++]=s-1+g,m[f++]=g,i=0;h-1>i;i++){var _=s*i,w=_+s;for(o=0;s>o;o++)m[f++]=o+_,m[f++]=o+w}var C=new a({attributes:r,indices:l.createTypedArray(u,m),boundingSphere:p.fromVertices(e),primitiveType:d.LINES});return C}var w=function(r){r=m(r,m.EMPTY_OBJECT);var n=r.polylinePositions;if(!e(n))throw new t("options.polylinePositions is required.");var a=r.shapePositions;if(!e(a))throw new t("options.shapePositions is required.");this._positions=n,this._shape=a,this._ellipsoid=m(r.ellipsoid,o.WGS84),this._cornerType=m(r.cornerType,i.ROUNDED),this._granularity=m(r.granularity,u.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry"},C=new f;return w.createGeometry=function(e){var r=e._positions,i=h.removeDuplicatesFromPositions(r,e._ellipsoid);if(i.length<2)throw new t("Count of unique polyline positions must be greater than 1.");var n=e._shape;if(n=h.removeDuplicatesFromShape(n),n.length<3)throw new t("Count of unique shape positions must be at least 3.");c.computeWindingOrder2D(n).value===g.CLOCKWISE.value&&n.reverse();var o=f.fromPoints(n,C),a=h.computePositions(i,n,o,e,!1);return _(a,n,o,e._ellipsoid)},w}),r("Core/QuaternionSpline",["./defaultValue","./defined","./DeveloperError","./Spline","./Quaternion"],function(e,t,r,i,n){"use strict";function o(e,r,i){var o=e.length,a=new Array(o);a[0]=t(r)?r:e[0],a[o-1]=t(i)?i:e[o-1];for(var s=1;o-1>s;++s)a[s]=n.innerQuadrangle(e[s-1],e[s],e[s+1]);return a}function a(e){var t=e.points,r=e.innerQuadrangles,i=e.times;if(t.length<3){var o=i[0],a=1/(i[1]-o),s=t[0],l=t[1];return function(e,t){var r=(e-o)*a;return n.slerp(s,l,r,t)}}return function(o,a){var s=e._lastTimeIndex=e.findTimeInterval(o,e._lastTimeIndex),l=(o-i[s])/(i[s+1]-i[s]),u=t[s],c=t[s+1],h=r[s],d=r[s+1];return n.squad(u,c,h,d,l,a)}}var s=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.points,s=i.times,l=i.firstInnerQuadrangle,u=i.lastInnerQuadrangle;if(!t(n))throw new r("points is required.");if(n.length<2)throw new r("points.length must be greater than or equal to 2.");if(!t(s))throw new r("times is required.");if(s.length!==n.length)throw new r("times.length must be equal to points.length.");var c=o(n,l,u);this.times=s,this.points=n,this.innerQuadrangles=c,this._evaluateFunction=a(this),this._lastTimeIndex=0};return s.prototype.findTimeInterval=i.prototype.findTimeInterval,s.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},s}),r("Core/ReferenceFrame",["./Enumeration"],function(e){"use strict";var t={FIXED:new e(0,"FIXED"),INERTIAL:new e(1,"INERTIAL")};return t}),r("Core/destroyObject",["./defaultValue","./DeveloperError"],function(e,t){"use strict";function r(){return!0}var i=function(i,n){function o(){throw new t(n)}n=e(n,"This object was destroyed, i.e., destroy() was called.");for(var a in i)"function"==typeof i[a]&&(i[a]=o);return i.isDestroyed=r,void 0};return i}),r("Core/ScreenSpaceEventType",["./Enumeration"],function(e){"use strict";var t={LEFT_DOWN:new e(0,"LEFT_DOWN"),LEFT_UP:new e(1,"LEFT_UP"),LEFT_CLICK:new e(2,"LEFT_CLICK"),LEFT_DOUBLE_CLICK:new e(3,"LEFT_DOUBLE_CLICK"),RIGHT_DOWN:new e(5,"RIGHT_DOWN"),RIGHT_UP:new e(6,"RIGHT_UP"),RIGHT_CLICK:new e(7,"RIGHT_CLICK"),RIGHT_DOUBLE_CLICK:new e(8,"RIGHT_DOUBLE_CLICK"),MIDDLE_DOWN:new e(10,"MIDDLE_DOWN"),MIDDLE_UP:new e(11,"MIDDLE_UP"),MIDDLE_CLICK:new e(12,"MIDDLE_CLICK"),MIDDLE_DOUBLE_CLICK:new e(13,"MIDDLE_DOUBLE_CLICK"),MOUSE_MOVE:new e(15,"MOUSE_MOVE"),WHEEL:new e(16,"WHEEL"),PINCH_START:new e(17,"PINCH_START"),PINCH_END:new e(18,"PINCH_END"),PINCH_MOVE:new e(19,"PINCH_MOVE")};return t}),r("Core/ScreenSpaceEventHandler",["./DeveloperError","./defined","./destroyObject","./Cartesian2","./ScreenSpaceEventType","./KeyboardEventModifier","./defaultValue"],function(e,t,r,i,n,o,a){"use strict";function s(e,t,r){if(e._element===document)return r.x=t.clientX,r.y=t.clientY,r;var i=e._element.getBoundingClientRect();return r.x=t.clientX-i.left,r.y=t.clientY-i.top,r}function l(e,r){var i=e.name;return t(r)&&(i+="+"+r.name),i}function u(e){return e.shiftKey?o.SHIFT:e.ctrlKey?o.CTRL:e.altKey?o.ALT:void 0}function c(e,r){var i=s(e,r,w.position);if(e._lastMousePosition.x=i.x,e._lastMousePosition.y=i.y,e._totalPixels=0,!e._seenAnyTouchEvents){var o,a=u(r);0===r.button?(e._leftMouseButtonDown=!0,o=e.getInputAction(n.LEFT_DOWN,a)):1===r.button?(e._middleMouseButtonDown=!0,o=e.getInputAction(n.MIDDLE_DOWN,a)):2===r.button&&(e._rightMouseButtonDown=!0,o=e.getInputAction(n.RIGHT_DOWN,a)),t(o)&&o(w),r.preventDefault()}}function h(e,r){var i,o,a=u(r);if(!e._seenAnyTouchEvents){0===r.button?(e._leftMouseButtonDown=!1,i=e.getInputAction(n.LEFT_UP,a),o=e.getInputAction(n.LEFT_CLICK,a)):1===r.button?(e._middleMouseButtonDown=!1,i=e.getInputAction(n.MIDDLE_UP,a),o=e.getInputAction(n.MIDDLE_CLICK,a)):2===r.button&&(e._rightMouseButtonDown=!1,i=e.getInputAction(n.RIGHT_UP,a),o=e.getInputAction(n.RIGHT_CLICK,a));var l=s(e,r,C.position),c=e._lastMousePosition.x-l.x,h=e._lastMousePosition.y-l.y;e._totalPixels+=Math.sqrt(c*c+h*h),t(i)&&i(C),t(o)&&e._totalPixels<e._clickPixelTolerance&&o(C)}}function d(e,r){var o=s(e,r,x.endPosition);if(!e._seenAnyTouchEvents){var a=e._lastMousePosition.x-o.x,l=e._lastMousePosition.y-o.y;e._totalPixels+=Math.sqrt(a*a+l*l),i.clone(e._lastMousePosition,x.startPosition);var c=u(r),h=e.getInputAction(n.MOUSE_MOVE,c);t(h)&&h(x),i.clone(x.endPosition,e._lastMousePosition),(e._leftMouseButtonDown||e._middleMouseButtonDown||e._rightMouseButtonDown)&&r.preventDefault()}}function m(e,r){var o=r.touches.length;e._seenAnyTouchEvents=!0;var a,l=u(r),c=s(e,r.touches[0],S.position);if(1===o?(i.clone(c,e._lastMousePosition),e._totalPixels=0,e._leftMouseButtonDown=!0,a=e.getInputAction(n.LEFT_DOWN,l),t(a)&&a(S),r.preventDefault()):e._leftMouseButtonDown&&(e._leftMouseButtonDown=!1,a=e.getInputAction(n.LEFT_UP,l),t(a)&&a(S)),2===o){e._isPinching=!0;var h=s(e,r.touches[1],E.position2);e._touchID1=r.touches[0].identifier,e._touchID2=r.touches[1].identifier,i.clone(c,e._lastMousePosition),i.clone(c,E.position1),i.clone(h,e._lastTouch2),a=e.getInputAction(n.PINCH_START,l),t(a)&&a(E)}else e._isPinching&&(e._isPinching=!1,a=e.getInputAction(n.PINCH_END,l),t(a)&&a())}function p(e,r){var i,o,a=r.touches.length,l=r.changedTouches.length,c=u(r);if(e._leftMouseButtonDown&&(e._leftMouseButtonDown=!1,i=e.getInputAction(n.LEFT_UP,c),o=e.getInputAction(n.LEFT_CLICK,c),l>0)){var h=s(e,r.changedTouches[0],b.position),d=e._lastMousePosition.x-h.x,p=e._lastMousePosition.y-h.y;e._totalPixels+=Math.sqrt(d*d+p*p),t(i)&&i(b),t(o)&&e._totalPixels<e._clickPixelTolerance&&o(b)}e._isPinching&&(e._isPinching=!1,i=e.getInputAction(n.PINCH_END,c),i&&i()),(1===a||2===a)&&m(e,r)}function f(e,r){var o,a,l,c=u(r);if(e._leftMouseButtonDown&&1===r.touches.length){o=s(e,r.touches[0],T.endPosition);var h=e._lastMouseX-o.x,d=e._lastMouseY-o.y;e._totalPixels+=Math.sqrt(h*h+d*d),i.clone(e._lastMousePosition,T.startPosition),l=e.getInputAction(n.MOUSE_MOVE,c),t(l)&&l(T),i.clone(T.endPosition,e._lastMousePosition),(e._leftMouseButtonDown||e._middleMouseButtonDown||e._rightMouseButtonDown)&&r.preventDefault()}if(e._isPinching&&2===r.touches.length){if(r.touches[0].identifier===e._touchID2?(o=s(e,r.touches[1],T.startPosition),a=s(e,r.touches[0],T.endPosition)):(o=s(e,r.touches[0],T.startPosition),a=s(e,r.touches[1],T.endPosition)),l=e.getInputAction(n.PINCH_MOVE,c),t(l)){var m=a.x-o.x,p=a.y-o.y,f=.25*Math.sqrt(m*m+p*p),v=e._lastTouch2.x-e._lastMousePosition.x,y=e._lastTouch2.y-e._lastMousePosition.y,g=.25*Math.sqrt(v*v+y*y),_=.125*(a.y+o.y),w=.125*(e._lastTouch2.y+e._lastMousePosition.y),C=Math.atan2(p,m),x=Math.atan2(y,v);i.fromElements(0,g,A.distance.startPosition),i.fromElements(0,f,A.distance.endPosition),i.fromElements(x,w,A.angleAndHeight.startPosition),i.fromElements(C,_,A.angleAndHeight.endPosition),l(A)}i.clone(o,e._lastMousePosition),i.clone(a,e._lastTouch2)}}function v(e,r){var i=r.detail?-120*r.detail:r.wheelDelta,o=u(r),a=n.WHEEL,s=e.getInputAction(a,o);t(s)&&(r.preventDefault(),s(i))}function y(e,r){var i,o=u(r);s(e,r,D.position),0===r.button?i=e.getInputAction(n.LEFT_DOUBLE_CLICK,o):1===r.button?i=e.getInputAction(n.MIDDLE_DOUBLE_CLICK,o):2===r.button&&(i=e.getInputAction(n.RIGHT_DOUBLE_CLICK,o)),t(i)&&i(D)}function g(e){var r=e,i=!0;e._callbacks=[],t(e._element.disableRootEvents)&&(i=!1),e._callbacks.push({name:"mousedown",onDoc:!1,action:function(e){c(r,e)}}),e._callbacks.push({name:"mouseup",onDoc:i,action:function(e){h(r,e)}}),e._callbacks.push({name:"mousemove",onDoc:i,action:function(e){d(r,e)}}),e._callbacks.push({name:"dblclick",onDoc:!1,action:function(e){y(r,e)}}),e._callbacks.push({name:"touchstart",onDoc:!1,action:function(e){m(r,e)}}),e._callbacks.push({name:"touchend",onDoc:i,action:function(e){p(r,e)}}),e._callbacks.push({name:"touchmove",onDoc:i,action:function(e){f(r,e)}}),e._callbacks.push({name:"mousewheel",onDoc:!1,action:function(e){v(r,e)}}),e._callbacks.push({name:"DOMMouseScroll",onDoc:!1,action:function(e){v(r,e)}});for(var n=0;n<e._callbacks.length;n++){var o=e._callbacks[n];o.onDoc?document.addEventListener(o.name,o.action,!1):e._element.addEventListener(o.name,o.action,!1)}}var _=function(e){this._mouseEvents={},this._leftMouseButtonDown=!1,this._middleMouseButtonDown=!1,this._rightMouseButtonDown=!1,this._isPinching=!1,this._seenAnyTouchEvents=!1,this._lastMousePosition=new i,this._lastTouch2=new i,this._totalPixels=0,this._touchID1=0,this._touchID2=0,this._clickPixelTolerance=5,this._element=a(e,document),g(this)};new i,_.prototype.setInputAction=function(r,i,n){if(!t(r))throw new e("action is required.");if(!t(i))throw new e("type is required.");var o=l(i,n);this._mouseEvents[o]=r},_.prototype.getInputAction=function(r,i){if(!t(r))throw new e("type is required.");var n=l(r,i);return this._mouseEvents[n]},_.prototype.removeInputAction=function(r,i){if(!t(r))throw new e("type is required.");var n=l(r,i);delete this._mouseEvents[n]};var w={position:new i},C={position:new i},x={startPosition:new i,endPosition:new i},S={position:new i},E={position1:new i,position2:new i},b={position:new i},T={startPosition:new i,endPosition:new i},A={distance:{startPosition:new i,endPosition:new i},angleAndHeight:{startPosition:new i,endPosition:new i}},D={position:new i};return _.prototype._unregister=function(){for(var e=0;e<this._callbacks.length;e++){var t=this._callbacks[e];t.onDoc?document.removeEventListener(t.name,t.action,!1):this._element.removeEventListener(t.name,t.action,!1)}},_.prototype.isDestroyed=function(){return!1},_.prototype.destroy=function(){return this._unregister(),r(this)},_}),r("Core/Shapes",["./defaultValue","./defined","./DeveloperError","./Math","./Cartesian2","./Cartesian3","./Quaternion","./Matrix3"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,t,r,i,n,l,u,c,h,d,m,p,f,v,y,g,_){for(var w,C,x,S,E,b,T,A,D=0;_>D;D++,p+=v,++g){C=v>0?m[p]+f:f-m[p],S=C+d,E=-Math.cos(S),T=o.multiplyByScalar(c,E),E=Math.sin(S),A=o.multiplyByScalar(h,E),T=o.add(T,A,T),E=Math.cos(C),E*=E,b=Math.sin(C),b*=b,x=n/Math.sqrt(i*E+r*b),w=x/t,E=Math.sin(w/2);var P=a.normalize(new a(T.x*E,T.y*E,T.z*E,Math.cos(w/2))),M=s.fromQuaternion(P),I=s.multiplyByVector(M,u),O=o.normalize(I);I=o.multiplyByScalar(O,t),y[g]=I}}var u={computeCircleBoundary:function(n,o,a,s){if(!t(n)||!t(o)||!t(a))throw new r("ellipsoid, center, and radius are required.");if(0>=a)throw new r("radius must be greater than zero.");if(s=e(s,i.RADIANS_PER_DEGREE),0>=s)throw new r("granularity must be greater than zero.");return this.computeEllipseBoundary(n,o,a,a,0,s)},computeEllipseBoundary:function(n,a,s,u,c,h){if(!(t(n)&&t(a)&&t(s)&&t(u)))throw new r("ellipsoid, center, semiMajorAxis, and semiMinorAxis are required.");if(0>=s||0>=u)throw new r("Semi-major and semi-minor axes must be greater than zero.");if(c=e(c,0),h=e(h,i.RADIANS_PER_DEGREE),0>=h)throw new r("granularity must be greater than zero.");if(u>s){var d=s;s=u,u=d}for(var m=2.31,p=s*s,f=u*u,v=s*u,y=1-f/p,g=Math.sqrt(y),_=o.clone(a),w=o.magnitude(_),C=new o(0,0,1),x=1/w,S=o.multiplyByScalar(_,x),E=o.normalize(o.cross(C,_)),b=o.cross(S,E),T=1+Math.ceil(i.PI_OVER_TWO/h),A=m/(T-1),D=[],P=0,M=0,I=0;T>I;I++,M+=A,++P)if(D[P]=M-g*Math.sin(M),D[P]>=i.PI_OVER_TWO){D[P]=i.PI_OVER_TWO,T=I+1;break}var O=[];return l(n,w,p,f,v,g,S,E,b,c,D,0,0,1,O,0,T-1),l(n,w,p,f,v,g,S,E,b,c,D,T-1,Math.PI,-1,O,T-1,T-1),l(n,w,p,f,v,g,S,E,b,c,D,0,Math.PI,1,O,2*T-2,T-1),l(n,w,p,f,v,g,S,E,b,c,D,T-1,i.TWO_PI,-1,O,3*T-3,T),O.push(o.clone(O[0])),O},compute2DCircle:function(t,r){t=e(t,1),r=e(r,2*i.RADIANS_PER_DEGREE);for(var o=[],a=i.toRadians(1),s=2*Math.PI/a,l=0;s>l;l++)o.push(new n(t*Math.cos(a*l),t*Math.sin(a*l)));return o}};return u}),r("Core/ShowGeometryInstanceAttribute",["./defaultValue","./defined","./ComponentDatatype","./DeveloperError"],function(e,t,r,i){"use strict";var n=function(t){t=e(t,!0),this.componentDatatype=r.UNSIGNED_BYTE,this.componentsPerAttribute=1,this.normalize=!0,this.value=n.toValue(t)};return n.toValue=function(e,r){if(!t(e))throw new i("show is required.");return t(r)?(r[0]=e,r):new Uint8Array([e])},n}),r("Core/Simon1994PlanetaryPositions",["./Cartesian3","./defined","./DeveloperError","./JulianDate","./Math","./Matrix3","./TimeConstants","./TimeStandard"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){var t=6.239996+.0172019696544*e;return.001657*Math.sin(t+.01671*Math.sin(t))}function u(e,t){t=e.addSeconds(w,t);var r=t.getTotalDays()-C;return t=t.addSeconds(l(r),t)}function c(i,a,s,l,u,c,m,p){if(0>s&&(s=-s,u+=n.PI),0>s||s>n.PI)throw new r("The inclination is out of range. Inclination must be greater than or equal to zero and less than or equal to Pi radians.");var v=i*(1-a),y=l-u,g=u,_=d(c-l,a),w=h(a,0);if("Hyperbolic"===w&&Math.abs(n.NegativePiToPi(_))>=Math.acos(-1/a))throw new r("The true anomaly of the hyperbolic orbit lies outside of the bounds of the hyperbola.");f(y,s,g,P);var C=v*(1+a),x=Math.cos(_),S=Math.sin(_),E=1+a*x;if(E<=n.Epsilon10)throw new r("elements cannot be converted to cartesian");var b=C/E;return t(p)?(p.x=b*x,p.y=b*S,p.z=0):p=new e(b*x,b*S,0),o.multiplyByVector(P,p,p)}function h(e,t){if(0>e)throw new r("eccentricity cannot be negative.");return t>=e?"Circular":1-t>e?"Elliptical":1+t>=e?"Parabolic":"Hyperbolic"}function d(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=m(e,t);return p(i,t)}function m(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=Math.floor(e/n.TWO_PI);e-=i*n.TWO_PI;var o,a=e+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),s=Number.MAX_VALUE;for(o=0;M>o&&Math.abs(s-a)>I;++o){s=a;var l=s-t*Math.sin(s)-e,u=1-t*Math.cos(s);a=s-l/u}if(o>=M)throw new r("Kepler equation did not converge");return s=a+i*n.TWO_PI}function p(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=Math.floor(e/n.TWO_PI);e-=i*n.TWO_PI;var o=Math.cos(e)-t,a=Math.sin(e)*Math.sqrt(1-t*t),s=Math.atan2(a,o);return s=n.zeroToTwoPi(s),0>e&&(s-=n.TWO_PI),s+=i*n.TWO_PI}function f(e,i,a,s){if(0>i||i>n.PI)throw new r("inclination out of range");var l=Math.cos(e),u=Math.sin(e),c=Math.cos(i),h=Math.sin(i),d=Math.cos(a),m=Math.sin(a);return t(s)?(s[0]=d*l-m*u*c,s[1]=m*l+d*u*c,s[2]=u*h,s[3]=-d*u-m*l*c,s[4]=-m*u+d*l*c,s[5]=l*h,s[6]=m*h,s[7]=-d*h,s[8]=c):s=new o(d*l-m*u*c,-d*u-m*l*c,m*h,m*l+d*u*c,-m*u+d*l*c,-d*h,u*h,l*h,c),s}function v(e,t){u(e,Pt);var r=Pt.getJulianDayNumber()-x.getJulianDayNumber()+(Pt.getSecondsOfDay()-x.getSecondsOfDay())/a.SECONDS_PER_DAY,i=r/(10*a.DAYS_PER_JULIAN_CENTURY),n=.3595362*i,o=O+q*Math.cos(z*n)+K*Math.sin(z*n)+G*Math.cos(N*n)+Q*Math.sin(N*n)+H*Math.cos(B*n)+$*Math.sin(B*n)+j*Math.cos(F*n)+et*Math.sin(F*n)+Y*Math.cos(V*n)+tt*Math.sin(V*n)+X*Math.cos(k*n)+rt*Math.sin(k*n)+Z*Math.cos(U*n)+it*Math.sin(U*n)+J*Math.cos(W*n)+nt*Math.sin(W*n),s=R+L*i+mt*Math.cos(ot*n)+Ct*Math.sin(ot*n)+pt*Math.cos(at*n)+xt*Math.sin(at*n)+ft*Math.cos(st*n)+St*Math.sin(st*n)+vt*Math.cos(lt*n)+Et*Math.sin(lt*n)+yt*Math.cos(ut*n)+bt*Math.sin(ut*n)+gt*Math.cos(ct*n)+Tt*Math.sin(ct*n)+_t*Math.cos(ht*n)+At*Math.sin(ht*n)+wt*Math.cos(dt*n)+Dt*Math.sin(dt*n),l=.0167086342-.0004203654*i,h=102.93734808*T+11612.3529*A*i,d=469.97289*A*i,m=174.87317577*T-8679.27034*A*i;return c(o,l,d,h,m,s,E,t)}function y(e,t){u(e,Pt);var r=Pt.getJulianDayNumber()-x.getJulianDayNumber()+(Pt.getSecondsOfDay()-x.getSecondsOfDay())/a.SECONDS_PER_DAY,i=r/a.DAYS_PER_JULIAN_CENTURY,n=i*i,o=n*i,s=o*i,l=383397.7725+.004*i,h=.055545526-1.6e-8*i,d=5.15668983*T,m=-8e-5*i+.02966*n-42e-6*o-1.3e-7*s,p=83.35324312*T,f=14643420.2669*i-38.2702*n-.045047*o+21301e-8*s,v=125.04455501*T,y=-6967919.3631*i+6.3602*n+.007625*o-3586e-8*s,g=218.31664563*T,_=1732559343.4847*i-6.391*n+.006588*o-3169e-8*s,w=297.85019547*T+A*(1602961601.209*i-6.3706*n+.006593*o-3169e-8*s),C=93.27209062*T+A*(1739527262.8478*i-12.7512*n-.001037*o+417e-8*s),E=134.96340251*T+A*(1717915923.2178*i+31.8792*n+.051635*o-2447e-7*s),D=357.52910918*T+A*(129596581.0481*i-.5532*n+136e-6*o-1149e-8*s),P=310.17137918*T-A*(6967051.436*i+6.2068*n+.007618*o-3219e-8*s),M=2*w,I=4*w,O=6*w,R=2*E,L=3*E,z=4*E,N=2*C;l+=3400.4*Math.cos(M)-635.6*Math.cos(M-E)-235.6*Math.cos(E)+218.1*Math.cos(M-D)+181*Math.cos(M+E),h+=.014216*Math.cos(M-E)+.008551*Math.cos(M-R)-.001383*Math.cos(E)+.001356*Math.cos(M+E)-.001147*Math.cos(I-L)-914e-6*Math.cos(I-R)+869e-6*Math.cos(M-D-E)-627e-6*Math.cos(M)-394e-6*Math.cos(I-z)+282e-6*Math.cos(M-D-R)-279e-6*Math.cos(w-E)-236e-6*Math.cos(R)+231e-6*Math.cos(I)+229e-6*Math.cos(O-z)-201e-6*Math.cos(R-N),m+=486.26*Math.cos(M-N)-40.13*Math.cos(M)+37.51*Math.cos(N)+25.73*Math.cos(R-N)+19.97*Math.cos(M-D-N),f+=-55609*Math.sin(M-E)-34711*Math.sin(M-R)-9792*Math.sin(E)+9385*Math.sin(I-L)+7505*Math.sin(I-R)+5318*Math.sin(M+E)+3484*Math.sin(I-z)-3417*Math.sin(M-D-E)-2530*Math.sin(O-z)-2376*Math.sin(M)-2075*Math.sin(M-L)-1883*Math.sin(R)-1736*Math.sin(O-5*E)+1626*Math.sin(D)-1370*Math.sin(O-L),y+=-5392*Math.sin(M-N)-540*Math.sin(D)-441*Math.sin(M)+423*Math.sin(N)-288*Math.sin(R-N),_+=-3332.9*Math.sin(M)+1197.4*Math.sin(M-E)-662.5*Math.sin(D)+396.3*Math.sin(E)-218*Math.sin(M-D);var B=2*P,F=3*P;m+=46.997*Math.cos(P)*i-.614*Math.cos(M-N+P)*i+.614*Math.cos(M-N-P)*i-.0297*Math.cos(B)*n-.0335*Math.cos(P)*n+.0012*Math.cos(M-N+B)*n-16e-5*Math.cos(P)*o+4e-5*Math.cos(F)*o+4e-5*Math.cos(B)*o;var V=2.116*Math.sin(P)*i-.111*Math.sin(M-N-P)*i-.0015*Math.sin(P)*n;f+=V,_+=V,y+=-520.77*Math.sin(P)*i+13.66*Math.sin(M-N+P)*i+1.12*Math.sin(M-P)*i-1.06*Math.sin(N-P)*i+.66*Math.sin(B)*n+.371*Math.sin(P)*n-.035*Math.sin(M-N+B)*n-.015*Math.sin(M-N+P)*n+.0014*Math.sin(P)*o-.0011*Math.sin(F)*o-9e-4*Math.sin(B)*o,l*=b;var k=d+m*A,U=p+f*A,W=g+_*A,q=v+y*A;return c(l,h,k,U,q,W,S,t)}function g(t,r){return r=y(t,r),e.multiplyByScalar(r,It,r)}var _={},w=32.184,C=2451545,x=i.fromTotalDays(2451545,s.TAI),S=398600435e6,E=328900.56*1.012300034*S,b=1e3,T=n.RADIANS_PER_DEGREE,A=n.RADIANS_PER_ARCSECOND,D=14959787e4,P=new o,M=50,I=n.EPSILON8,O=1.0000010178*D,R=100.46645683*T,L=1295977422.83429*A,z=16002,N=21863,B=32004,F=10931,V=14529,k=16368,U=15318,W=32794,q=64e-7*D,G=-152*1e-7*D,H=62e-7*D,j=-8e-7*D,Y=32e-7*D,X=-41*1e-7*D,Z=19e-7*D,J=-11*1e-7*D,K=-150*1e-7*D,Q=-46*1e-7*D,$=68*1e-7*D,et=54e-7*D,tt=14e-7*D,rt=24e-7*D,it=-28*1e-7*D,nt=22e-7*D,ot=10,at=16002,st=21863,lt=10931,ut=1473,ct=32004,ht=4387,dt=73,mt=-325*1e-7,pt=-322*1e-7,ft=-79*1e-7,vt=232*1e-7,yt=-52*1e-7,gt=97e-7,_t=55e-7,wt=-41*1e-7,Ct=-105*1e-7,xt=-137*1e-7,St=258e-7,Et=35e-7,bt=-116*1e-7,Tt=-88*1e-7,At=-112*1e-7,Dt=-80*1e-7,Pt=new i,Mt=.012300034,It=-1*(Mt/(Mt+1)),Ot=new o(1.0000000000000002,5.619723173785822e-16,4.690511510146299e-19,-5.154129427414611e-16,.9174820620691819,-.39777715593191376,-2.23970096136568e-16,.39777715593191376,.9174820620691819),Rt=new e;return _.ComputeSunPositionInEarthInertialFrame=function(r,n){return t(r)||(r=new i),Rt=v(r,Rt),n=e.negate(Rt,n),g(r,Rt),e.subtract(n,Rt,n),o.multiplyByVector(Ot,n,n),n},_.ComputeMoonPositionInEarthInertialFrame=function(e,r){return t(e)||(e=new i),r=y(e,r),o.multiplyByVector(Ot,r,r),r},_}),r("Core/SimplePolylineGeometry",["./defined","./DeveloperError","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./defaultValue","./BoundingSphere","./Geometry","./GeometryAttribute","./GeometryAttributes","./Color","./Cartesian3"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";var d=function(r){r=o(r,o.EMPTY_OBJECT);var i=r.positions,n=r.colors,a=o(r.colorsPerVertex,!1);if(!e(i)||i.length<2)throw new t("At least two positions are required.");if(e(n)&&(a&&n.length<i.length||!a&&n.length<i.length-1))throw new t("colors has an invalid length.");this._positions=i,this._colors=n,this._perVertex=a,this._workerName="createSimplePolylineGeometry"};return d.createGeometry=function(t){var o,d=t._positions,m=t._colors,p=t._perVertex,f=e(m)&&!p,v=0,y=0,g=d.length,_=f?2*d.length-2:d.length,w=new Float64Array(3*_),C=e(m)?new Uint8Array(4*_):void 0;for(o=0;g>o;++o){var x,S=d[o];if(f&&o>0&&(h.pack(S,w,v),v+=3,x=m[o-1],C[y++]=c.floatToByte(x.red),C[y++]=c.floatToByte(x.green),C[y++]=c.floatToByte(x.blue),C[y++]=c.floatToByte(x.alpha)),f&&o===g-1)break;h.pack(S,w,v),v+=3,e(m)&&(x=m[o],C[y++]=c.floatToByte(x.red),C[y++]=c.floatToByte(x.green),C[y++]=c.floatToByte(x.blue),C[y++]=c.floatToByte(x.alpha))}var E=new u;E.position=new l({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:w}),e(m)&&(E.color=new l({componentDatatype:r.UNSIGNED_BYTE,componentsPerAttribute:4,values:C,normalize:!0}));var b=f?_:2*(_-1),T=i.createTypedArray(_,b),A=f?2:1;for(v=0,o=0;_-1>o;o+=A)T[v++]=o,T[v++]=o+1;return new s({attributes:E,indices:T,primitiveType:n.LINES,boundingSphere:a.fromPoints(d)})},d}),r("Core/SphereGeometry",["./defaultValue","./Cartesian3","./EllipsoidGeometry"],function(e,t,r){"use strict";var i=function(i){var n=e(i.radius,1),o=new t(n,n,n),a={radii:o,stackPartitions:i.stackPartitions,slicePartitions:i.slicePartitions,vertexFormat:i.vertexFormat};this._ellipsoidGeometry=new r(a),this._workerName="createSphereGeometry"};return i.createGeometry=function(e){return r.createGeometry(e._ellipsoidGeometry)},i}),r("Core/SphereOutlineGeometry",["./defaultValue","./Cartesian3","./EllipsoidOutlineGeometry"],function(e,t,r){"use strict";var i=function(i){var n=e(i.radius,1),o=new t(n,n,n),a={radii:o,stackPartitions:i.stackPartitions,slicePartitions:i.slicePartitions,subdivisions:i.subdivisions};this._ellipsoidGeometry=new r(a),this._workerName="createSphereOutlineGeometry"};return i.createGeometry=function(e){return r.createGeometry(e._ellipsoidGeometry)},i}),r("Core/Spherical",["./DeveloperError","./defaultValue","./defined"],function(e,t,r){"use strict";var i=function(e,r,i){this.clock=t(e,0),this.cone=t(r,0),this.magnitude=t(i,1)};return i.fromCartesian3=function(t,n){if(!r(t))throw new e("cartesian3 is required");var o=t.x,a=t.y,s=t.z,l=o*o+a*a;return r(n)||(n=new i),n.clock=Math.atan2(a,o),n.cone=Math.atan2(Math.sqrt(l),s),n.magnitude=Math.sqrt(l+s*s),n},i.clone=function(e,t){return r(e)?r(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=e.magnitude,t):new i(e.clock,e.cone,e.magnitude):void 0},i.normalize=function(t,n){if(!r(t))throw new e("spherical is required");return r(n)?(n.clock=t.clock,n.cone=t.cone,n.magnitude=1,n):new i(t.clock,t.cone,1)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.clock===t.clock&&e.cone===t.cone&&e.magnitude===t.magnitude},i.equalsEpsilon=function(e,i,n){return n=t(n,0),e===i||r(e)&&r(i)&&Math.abs(e.clock-i.clock)<=n&&Math.abs(e.cone-i.cone)<=n&&Math.abs(e.magnitude-i.magnitude)<=n},i.toString=function(e){return"("+e.clock+", "+e.cone+", "+e.magnitude+")"},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.normalize=function(e){return i.normalize(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return i.toString(this)},i}),r("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";var t,r=function(r){e(t)||(t=document.createElement("a")),t.href=window.location.href;var i=t.host,n=t.protocol;return t.href=r,t.href=t.href,n!==t.protocol||i!==t.host};return r}),r("Core/TaskProcessor",["require","./buildModuleUrl","./defaultValue","./defined","./destroyObject","./isCrossOriginUrl","../ThirdParty/when","../ThirdParty/Uri"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,t){--e._activeTasks;var r=t.data,n=r.id,o=e._deferreds,a=o[n];i(r.error)?a.reject(r.error):a.resolve(r.result),delete o[n]}function u(){if(i(h))return h;if(h=t("Workers/cesiumWorkerBootstrapper.js"),o(h)){var e,r='importScripts("'+h+'");';try{e=new Blob([r],{type:"application/javascript"})}catch(n){var a=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,s=new a;s.append(r),e=s.getBlob("application/javascript")}var l=window.URL||window.webkitURL;h=l.createObjectURL(e)}return h}function c(n){var o=u(),a=new Worker(o);a.postMessage=r(a.webkitPostMessage,a.postMessage);var c={loaderConfig:{},workerModule:d._workerModulePrefix+n._workerName};if(i(d._loaderConfig))c.loaderConfig=d._loaderConfig;else if(i(e.toUrl)){var h=new s("..").resolve(new s(t("Workers/cesiumWorkerBootstrapper.js"))).toString();c.loaderConfig.baseUrl=h}else c.loaderConfig.paths={Workers:t("Workers")};a.postMessage(c),a.onmessage=function(e){l(n,e)},n._worker=a}var h,d=function(e,t){this._workerName=e,this._maximumActiveTasks=r(t,5),this._activeTasks=0,this._deferreds={},this._nextID=0
};return d.prototype.scheduleTask=function(e,t){if(i(this._worker)||c(this),this._activeTasks>=this._maximumActiveTasks)return void 0;++this._activeTasks;var r=this._nextID++,n=a.defer();return this._deferreds[r]=n,this._worker.postMessage({id:r,parameters:e},t),n.promise},d.prototype.isDestroyed=function(){return!1},d.prototype.destroy=function(){return i(this._worker)&&this._worker.terminate(),n(this)},d._defaultWorkerModulePrefix="Workers/",d._workerModulePrefix=d._defaultWorkerModulePrefix,d._loaderConfig=void 0,d}),r("Core/TimeIntervalCollection",["./defined","./DeveloperError","./binarySearch","./TimeInterval","./JulianDate"],function(e,t,r,i,n){"use strict";function o(e,t){return n.compare(e.start,t.start)}function a(t,r,i,n){for(var o=0,a=0,l=new s,u=t._intervals,c=r._intervals;o<u.length&&a<c.length;){var h=u[o],d=c[a];if(h.stop.lessThan(d.start))++o;else if(d.stop.lessThan(h.start))++a;else{if(e(n)||e(i)&&i(h,d)||!e(i)&&d.data===h.data){var m=h.intersect(d,n);m.isEmpty||l.addInterval(m,i)}h.stop.lessThan(d.stop)||h.stop.equals(d.stop)&&!h.isStopIncluded&&d.isStopIncluded?++o:++a}}return l}var s=function(){this._intervals=[]};return s.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof s))return!1;var r=this._intervals,n=e._intervals,o=r.length;if(o!==n.length)return!1;for(var a=0;o>a;a++)if(!i.equals(r[a],n[a],t))return!1;return!0},s.prototype.get=function(e){if(isNaN(e))throw new t("index must be a number.");return this._intervals[e]},s.prototype.getStart=function(){var e=this._intervals;return 0===e.length?void 0:e[0].start},s.prototype.getStop=function(){var e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop},s.prototype.getLength=function(){return this._intervals.length},s.prototype.clear=function(){this._intervals=[]},s.prototype.isEmpty=function(){return 0===this._intervals.length},s.prototype.findIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t]:void 0},s.prototype.findDataForIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t].data:void 0},s.prototype.contains=function(e){return this.indexOf(e)>=0},s.prototype.indexOf=function(n){if(!e(n))throw new t("date required");var a=this._intervals,s=r(a,new i(n,n,!0,!0),o);return s>=0?a[s].isStartIncluded?s:s>0&&a[s-1].stop.equals(n)&&a[s-1].isStopIncluded?s-1:~s:(s=~s,s>0&&s-1<a.length&&a[s-1].contains(n)?s-1:~s)},s.prototype.findInterval=function(t,r,i,n){for(var o,a=this._intervals,s=0,l=a.length;l>s;s++)if(o=a[s],!(e(t)&&!o.start.equals(t)||e(r)&&!o.stop.equals(r)||e(i)&&o.isStartIncluded!==i||e(n)&&o.isStopIncluded!==n))return a[s];return void 0},s.prototype.addInterval=function(a,s){if(!e(a))throw new t("interval is required");if(!a.isEmpty){var l,u,c=this._intervals;if(0===c.length||a.start.greaterThan(c[c.length-1].stop))return c.push(a),void 0;for(u=r(c,a,o),0>u?u=~u:u>0&&a.isStartIncluded&&c[u-1].isStartIncluded&&c[u-1].start.equals(a.start)?--u:u<c.length&&!a.isStartIncluded&&c[u].isStartIncluded&&c[u].start.equals(a.start)&&++u,u>0&&(l=n.compare(c[u-1].stop,a.start),(l>0||0===l&&(c[u-1].isStopIncluded||a.isStartIncluded))&&((e(s)?s(c[u-1].data,a.data):c[u-1].data===a.data)?(a=a.stop.greaterThan(c[u-1].stop)?new i(c[u-1].start,a.stop,c[u-1].isStartIncluded,a.isStopIncluded,a.data):new i(c[u-1].start,c[u-1].stop,c[u-1].isStartIncluded,c[u-1].isStopIncluded||a.stop.equals(c[u-1].stop)&&a.isStopIncluded,a.data),c.splice(u-1,1),--u):(l=n.compare(c[u-1].stop,a.stop),l>0||0===l&&c[u-1].isStopIncluded&&!a.isStopIncluded?c.splice(u-1,1,new i(c[u-1].start,a.start,c[u-1].isStartIncluded,!a.isStartIncluded,c[u-1].data),new i(a.stop,c[u-1].stop,!a.isStopIncluded,c[u-1].isStopIncluded,c[u-1].data)):c[u-1]=new i(c[u-1].start,a.start,c[u-1].isStartIncluded,!a.isStartIncluded,c[u-1].data))));u<c.length&&(l=n.compare(a.stop,c[u].start),l>0||0===l&&(a.isStopIncluded||c[u].isStartIncluded));)if(e(s)?s(c[u].data,a.data):c[u].data===a.data)a=new i(a.start,c[u].stop.greaterThan(a.stop)?c[u].stop:a.stop,a.isStartIncluded,c[u].stop.greaterThan(a.stop)?c[u].isStopIncluded:a.isStopIncluded,a.data),c.splice(u,1);else{if(c[u]=new i(a.stop,c[u].stop,!a.isStopIncluded,c[u].isStopIncluded,c[u].data),!c[u].isEmpty)break;c.splice(u,1)}c.splice(u,0,a)}},s.prototype.removeInterval=function(n){if(!e(n))throw new t("interval is required");if(n.isEmpty)return!1;var a=!1,s=this._intervals,l=r(s,n,o);0>l&&(l=~l);var u=n.start,c=n.stop,h=n.isStartIncluded,d=n.isStopIncluded;if(l>0){var m=s[l-1],p=m.stop;(p.greaterThan(u)||p.equals(u)&&m.isStopIncluded&&h)&&(a=!0,(p.greaterThan(c)||m.isStopIncluded&&!d&&p.equals(c))&&s.splice(l,0,new i(c,p,!d,m.isStopIncluded,m.data)),s[l-1]=new i(m.start,u,m.isStartIncluded,!h,m.data))}var f=s[l];for(l<s.length&&!h&&f.isStartIncluded&&u.equals(f.start)&&(a=!0,s.splice(l,0,new i(f.start,f.start,!0,!0,f.data)),++l,f=s[l]);l<s.length&&c.greaterThan(f.stop);)a=!0,s.splice(l,1);return l<s.length&&c.equals(f.stop)&&(a=!0,!d&&f.isStopIncluded?l+1<s.length&&s[l+1].start.equals(c)&&f.data===s[l+1].data?(s.splice(l,1),s[l]=f=new i(f.start,f.stop,!0,f.isStopIncluded,f.data)):s[l]=f=new i(c,c,!0,!0,f.data):s.splice(l,1)),l<s.length&&(c.greaterThan(f.start)||c.equals(f.start)&&d&&f.isStartIncluded)&&(a=!0,s[l]=new i(c,f.stop,!d,f.isStopIncluded,f.data)),a},s.prototype.intersect=function(r,i,n){if(!e(r))throw new t("timeIntervalCollection is required.");return a(this,r,i,n)},s.prototype.intersectInterval=function(r,i,n){if(!e(r))throw new t("interval is required.");var o=new s;return o.addInterval(r),a(this,o,i,n)},s}),r("Core/WallGeometryLibrary",["./defined","./Cartographic","./Cartesian3","./DeveloperError","./EllipsoidTangentPlane","./PolygonPipeline","./PolylinePipeline","./Math","./WindingOrder"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(e,t,i,n,o){var a,s=r.angleBetween(e,t),l=Math.ceil(s/o),u=new Array(l);if(i===n){for(a=0;l>a;a++)u[a]=i;return u}var c=n-i,h=c/l;for(a=1;l>a;a++){var d=i+a*h;u[a]=d}return u[0]=i,u}function c(e,t){return s.equalsEpsilon(e.latitude,t.latitude,s.EPSILON6)&&s.equalsEpsilon(e.longitude,t.longitude,s.EPSILON6)}function h(r,i,n,o){var a=e(o),s=e(n),l=[],u=[],h=a?[]:void 0,d=i.length;if(2>d)return i.slice(0);var f=i[0];l.push(f);var v=r.cartesianToCartographic(f,m);s&&(v.height=n[0]),u.push(v.height),a&&h.push(o[0]);for(var y=1;d>y;++y){var g=i[y],_=r.cartesianToCartographic(g,p);s&&(_.height=n[y]),c(v,_)?v.height<_.height&&(u[u.length-1]=_.height):(l.push(g),u.push(_.height),a&&h.push(o[y])),t.clone(_,v)}return{positions:l,topHeights:u,bottomHeights:h}}var d={},m=new t,p=new t;return d.computePositions=function(t,r,s,c,d,m){var p=h(t,r,s,c);if(r=p.positions,s=p.topHeights,c=p.bottomHeights,r.length<2)throw new i("unique positions must be greater than or equal to 2");var f=e(c);if(r.length>=3){var v=n.fromPoints(r,t),y=v.projectPointsOntoPlane(r);o.computeWindingOrder2D(y)===l.CLOCKWISE&&(r.reverse(),s.reverse(),f&&c.reverse())}var g,_=r.length,w=[],C=f?[]:void 0,x=[];for(g=0;_-1>g;g++){var S=r[g],E=r[g+1],b=s[g],T=s[g+1];w=w.concat(u(S,E,b,T,d)),m&&w.push(T),f&&(S=r[g],E=r[g+1],b=c[g],T=c[g+1],C=C.concat(u(S,E,b,T,d)),m&&C.push(T)),m&&(x=x.concat(a.scaleToSurface([S,E],d,t)))}m||(x=a.scaleToSurface(r,d,t),w.push(s[_-1]),f&&C.push(c[_-1]));var A=f?a.scaleToGeodeticHeight(x,C,t):x.slice(0),D=a.scaleToGeodeticHeight(x,w,t);return{newWallPositions:x,bottomPositions:A,topPositions:D}},d}),r("Core/WallGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian3","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./Math","./PrimitiveType","./VertexFormat","./WallGeometryLibrary"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p){"use strict";var f=new i,v=new i,y=new i,g=new i,_=new i,w=new i,C=new i,x=new i,S=function(r){r=e(r,e.EMPTY_OBJECT);var i=r.positions,n=r.maximumHeights,o=r.minimumHeights;if(!t(i))throw new a("positions is required.");if(t(n)&&n.length!==i.length)throw new a("positions and maximumHeights must have the same length.");if(t(o)&&o.length!==i.length)throw new a("positions and minimumHeights must have the same length.");var l=e(r.vertexFormat,m.DEFAULT),u=e(r.granularity,h.RADIANS_PER_DEGREE),c=e(r.ellipsoid,s.WGS84);this._positions=i,this._minimumHeights=o,this._maximumHeights=n,this._vertexFormat=l,this._granularity=u,this._ellipsoid=c,this._workerName="createWallGeometry"};return S.fromConstantHeights=function(r){r=e(r,e.EMPTY_OBJECT);var i=r.positions;if(!t(i))throw new a("options.positions is required.");var n,o,s=r.minimumHeight,l=r.maximumHeight,u=t(s),c=t(l);if(u||c){var h=i.length;n=u?new Array(h):void 0,o=c?new Array(h):void 0;for(var d=0;h>d;++d)u&&(n[d]=s),c&&(o[d]=l)}var m={positions:i,maximumHeights:o,minimumHeights:n,ellipsoid:r.ellipsoid,vertexFormat:r.vertexFormat};return new S(m)},S.createGeometry=function(e){var t=e._positions,a=e._minimumHeights,s=e._maximumHeights,m=e._vertexFormat,S=e._granularity,E=e._ellipsoid,b=p.computePositions(E,t,s,a,S,!0),T=b.newWallPositions,A=b.bottomPositions,D=b.topPositions,P=T.length,M=2*P,I=m.position?new Float64Array(M):void 0,O=m.normal?new Float32Array(M):void 0,R=m.tangent?new Float32Array(M):void 0,L=m.binormal?new Float32Array(M):void 0,z=m.st?new Float32Array(2*(M/3)):void 0,N=0,B=0,F=0,V=0,k=0,U=x,W=C,q=w,G=!0;P/=3;var H;for(H=0;P>H;++H){var j=3*H,Y=i.fromArray(D,j,f),X=i.fromArray(A,j,v);if(m.position&&(I[N++]=X.x,I[N++]=X.y,I[N++]=X.z,I[N++]=Y.x,I[N++]=Y.y,I[N++]=Y.z),m.normal||m.tangent||m.binormal){var Z,J=new i,K=i.fromArray(T,j,v);if(P>H+1&&(Z=i.fromArray(T,j+3,y),J=i.fromArray(D,j+3,_)),G){var Q=i.subtract(J,Y,g),$=i.subtract(K,Y,f);U=i.normalize(i.cross($,Q,U),U),G=!1}i.equalsEpsilon(Z,K,h.EPSILON6)?G=!0:(m.tangent&&(W=i.normalize(i.subtract(Z,K,W),W)),m.binormal&&(q=i.normalize(i.cross(U,W,q),q))),m.normal&&(O[B++]=U.x,O[B++]=U.y,O[B++]=U.z,O[B++]=U.x,O[B++]=U.y,O[B++]=U.z),m.tangent&&(R[V++]=W.x,R[V++]=W.y,R[V++]=W.z,R[V++]=W.x,R[V++]=W.y,R[V++]=W.z),m.binormal&&(L[F++]=q.x,L[F++]=q.y,L[F++]=q.z,L[F++]=q.x,L[F++]=q.y,L[F++]=q.z)}if(m.st){var et=H/(P-1);z[k++]=et,z[k++]=0,z[k++]=et,z[k++]=1}}var tt=new c;m.position&&(tt.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:I})),m.normal&&(tt.normal=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:O})),m.tangent&&(tt.tangent=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:R})),m.binormal&&(tt.binormal=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:L})),m.st&&(tt.st=new u({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:z}));var rt=M/3;M-=6;var it=o.createTypedArray(rt,M),nt=0;for(H=0;rt-2>H;H+=2){var ot=H,at=H+2,st=i.fromArray(I,3*ot,f),lt=i.fromArray(I,3*at,v);if(!i.equalsEpsilon(st,lt,h.EPSILON6)){var ut=H+1,ct=H+3;it[nt++]=ut,it[nt++]=ot,it[nt++]=ct,it[nt++]=ct,it[nt++]=ot,it[nt++]=at}}return new l({attributes:tt,indices:it,primitiveType:d.TRIANGLES,boundingSphere:new r.fromVertices(I)})},S}),r("Core/WallOutlineGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./Math","./PrimitiveType","./WallGeometryLibrary"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p){"use strict";var f=new i,v=new i,y=function(r){r=e(r,e.EMPTY_OBJECT);var i=r.positions,n=r.maximumHeights,o=r.minimumHeights;if(!t(i))throw new s("positions is required.");if(t(n)&&n.length!==i.length)throw new s("positions and maximumHeights must have the same length.");if(t(o)&&o.length!==i.length)throw new s("positions and minimumHeights must have the same length.");var a=e(r.granularity,d.RADIANS_PER_DEGREE),u=e(r.ellipsoid,l.WGS84);this._positions=i,this._minimumHeights=o,this._maximumHeights=n,this._granularity=a,this._ellipsoid=u,this._workerName="createWallOutlineGeometry"};return y.fromConstantHeights=function(r){r=e(r,e.EMPTY_OBJECT);var i=r.positions;if(!t(i))throw new s("options.positions is required.");var n,o,a=r.minimumHeight,l=r.maximumHeight,u=t(a),c=t(l);if(u||c){var h=i.length;n=u?new Array(h):void 0,o=c?new Array(h):void 0;for(var d=0;h>d;++d)u&&(n[d]=a),c&&(o[d]=l)}var m={positions:i,maximumHeights:o,minimumHeights:n,ellipsoid:r.ellipsoid};return new y(m)},y.createGeometry=function(e){var t=e._positions,n=e._minimumHeights,s=e._maximumHeights,l=e._granularity,y=e._ellipsoid,g=p.computePositions(y,t,s,n,l,!1),_=g.newWallPositions,w=g.bottomPositions,C=g.topPositions,x=_.length,S=2*x,E=new Float64Array(S),b=0;x/=3;var T;for(T=0;x>T;++T){var A=3*T,D=i.fromArray(C,A,f),P=i.fromArray(w,A,v);E[b++]=P.x,E[b++]=P.y,E[b++]=P.z,E[b++]=D.x,E[b++]=D.y,E[b++]=D.z}var M=new h({position:new c({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:E})}),I=S/3;S=2*I-4+I;var O=a.createTypedArray(I,S),R=0;for(T=0;I-2>T;T+=2){var L=T,z=T+2,N=i.fromArray(E,3*L,f),B=i.fromArray(E,3*z,v);if(!i.equalsEpsilon(N,B,d.EPSILON6)){var F=T+1,V=T+3;O[R++]=F,O[R++]=L,O[R++]=F,O[R++]=V,O[R++]=L,O[R++]=z}}return O[R++]=I-2,O[R++]=I-1,new u({attributes:M,indices:O,primitiveType:m.LINES,boundingSphere:new r.fromVertices(E)})},y}),r("Core/WebMercatorProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Math","./Ellipsoid"],function(e,t,r,i,n,o){"use strict";var a=function(t){this._ellipsoid=e(t,o.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return a.mercatorAngleToGeodeticLatitude=function(e){return n.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},a.geodeticLatitudeToMercatorAngle=function(e){e>a.MaximumLatitude?e=a.MaximumLatitude:e<-a.MaximumLatitude&&(e=-a.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},a.MaximumLatitude=a.mercatorAngleToGeodeticLatitude(Math.PI),a.prototype.getEllipsoid=function(){return this._ellipsoid},a.prototype.project=function(e,i){var n=this._semimajorAxis,o=e.longitude*n,s=a.geodeticLatitudeToMercatorAngle(e.latitude)*n,l=e.height;return t(i)?(i.x=o,i.y=s,i.z=l,i):new r(o,s,l)},a.prototype.unproject=function(e,r){var n=this._oneOverSemimajorAxis,o=e.x*n,s=a.mercatorAngleToGeodeticLatitude(e.y*n),l=e.z;return t(r)?(r.longitude=o,r.latitude=s,r.height=l,r):new i(o,s,l)},a}),r("Core/cancelAnimationFrame",["./defined"],function(e){"use strict";var t=window.cancelAnimationFrame;!function(){if(!e(t))for(var r=["webkit","moz","ms","o"],i=0,n=r.length;n>i&&!e(t);)t=window[r[i]+"CancelAnimationFrame"],e(t)||(t=window[r[i]+"CancelRequestAnimationFrame"]),++i;e(t)||(t=clearTimeout)}();var r=function(e){t(e)};return r}),r("Core/combine",["./DeveloperError","./defaultValue","./defined"],function(e,t,r){"use strict";var i=function(e,r,i){r=t(r,!0),i=t(i,!0);for(var o={},a=0;a<e.length;a++)n(o,e[a],r,i);return o},n=function(t,i,o,a){for(var s in i)if(i.hasOwnProperty(s))if(t.hasOwnProperty(s)&&r(t[s])){if(!a)throw new e("Duplicate member: "+s);o&&"object"==typeof t[s]&&"object"==typeof i[s]&&n(t[s],i[s],o,a)}else t[s]=i[s]};return i}),r("Core/createGuid",[],function(){"use strict";var e=function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=0|16*Math.random(),r="x"===e?t:8|3&t;return r.toString(16)})};return e}),r("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),r("Core/getFilenameFromUri",["./defined","./DeveloperError","../ThirdParty/Uri"],function(e,t,r){"use strict";var i=function(i){if(!e(i))throw new t("uri is required.");var n=new r(i);n.normalize();var o=n.path,a=o.lastIndexOf("/");return-1!==a&&(o=o.substr(a+1)),o};return i}),r("Core/getImagePixels",["./defined"],function(e){"use strict";var t={},r=function(r,i,n){e(i)||(i=r.width),e(n)||(n=r.height);var o=t[i];e(o)||(o={},t[i]=o);var a=o[n];if(!e(a)){var s=document.createElement("canvas");s.width=i,s.height=n,a=s.getContext("2d"),a.globalCompositeOperation="copy",o[n]=a}return a.drawImage(r,0,0,i,n),a.getImageData(0,0,i,n).data};return r}),r("Core/jsonp",["./defaultValue","./defined","./DeveloperError","../ThirdParty/when"],function(e,t,r,i){"use strict";function n(e,t,r){e.push(encodeURIComponent(t)+"="+encodeURIComponent(r))}var o=function(a,s){if(!t(a))throw new r("url is required.");s=e(s,e.EMPTY_OBJECT);var l,u=i.defer();do l="jsonp"+Math.random().toString().substring(2,8);while(t(window[l]));window[l]=function(e){u.resolve(e);try{delete window[l]}catch(t){window[l]=void 0}};var c=e(s.callbackParameterName,"callback"),h=[];n(h,c,l);var d=e(s.parameters,e.EMPTY_OBJECT);for(var m in d)d.hasOwnProperty(m)&&n(h,m,d[m]);h.length>0&&(a+=-1===a.indexOf("?")?"?":"&",a+=h.join("&"));var p=s.proxy;return t(p)&&(a=p.getURL(a)),o.loadAndExecuteScript(a,l,u),u.promise};return o.loadAndExecuteScript=function(e,t,r){var i=document.createElement("script");i.async=!0,i.src=e;var n=document.getElementsByTagName("head")[0];i.onload=function(){i.onload=void 0,n.removeChild(i)},i.onerror=function(e){r.reject(e)},n.appendChild(i)},o.defaultLoadAndExecuteScript=o.loadAndExecuteScript,o}),r("Core/loadArrayBuffer",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,responseType:"arraybuffer",headers:r})};return t}),r("Core/loadBlob",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,responseType:"blob",headers:r})};return t}),r("Core/loadImage",["./defaultValue","./defined","./DeveloperError","./isCrossOriginUrl","../ThirdParty/when"],function(e,t,r,i,n){"use strict";var o=/^data:/,a=function(s,l){if(!t(s))throw new r("url is required.");return l=e(l,!0),n(s,function(e){var t;t=o.test(e)||!l?!1:i(e);var r=n.defer();return a.createImage(e,t,r),r.promise})};return a.createImage=function(e,t,r){var i=new Image;i.onload=function(){r.resolve(i)},i.onerror=function(e){r.reject(e)},t&&(i.crossOrigin=""),i.src=e},a.defaultCreateImage=a.createImage,a}),r("Core/loadImageViaBlob",["./loadBlob","./loadImage"],function(e,t){"use strict";var r=/^data:/,i=function(i){return r.test(i)?t(i):e(i).then(function(e){var r=window.URL.createObjectURL(e);return t(r,!1).then(function(t){return t.blob=e,window.URL.revokeObjectURL(r),t},function(e){return window.URL.revokeObjectURL(r),e})})},n=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();return n?i:t}),r("Core/loadXML",["./defined","./DeveloperError","./RequestErrorEvent","../ThirdParty/when"],function(e,t,r,i){"use strict";var n=function(r,o){if(!e(r))throw new t("url is required.");return i(r,function(e){var t=i.defer();return n.loadXML(e,o,t),t.promise})};return n.loadXML=function(t,i,n){var o=new XMLHttpRequest;if(o.overrideMimeType("text/xml"),o.open("GET",t,!0),e(i))for(var a in i)i.hasOwnProperty(a)&&o.setRequestHeader(a,i[a]);o.onload=function(){200===o.status?n.resolve(o.responseXML):n.reject(new r(o.status,o.response))},o.onerror=function(){n.reject(new r)},o.send()},n.defaultLoadXML=n.loadXML,n}),r("Core/requestAnimationFrame",["./defined"],function(e){"use strict";var t=window.requestAnimationFrame;!function(){if(!e(t))for(var r=["webkit","moz","ms","o"],i=0,n=r.length;n>i&&!e(t);)t=window[r[i]+"RequestAnimationFrame"],++i;if(!e(t)){var o=0;t=function(e){var t=Date.now(),r=Math.max(16-(t-o),0);return o=t+r,setTimeout(function(){e(o)},r)}}}();var r=function(e){return t(e)};return r}),r("Core/throttleRequestByServer",["./defaultValue","./defined","../ThirdParty/when"],function(e,t,r){"use strict";function i(e){return t(o)||(o=document.createElement("a")),o.href=e,o.hostname+"%"+o.port}function n(t,n){var o=i(t),l=e(s[o],0);return l>a?void 0:(s[o]=l+1,r(n(t),function(e){return s[o]--,e},function(e){return s[o]--,r.reject(e)}))}var o,a=6,s={};return n}),r("Core/wrapFunction",["./DeveloperError"],function(e){"use strict";var t=function(t,r,i){if("function"!=typeof r)throw new e("oldFunction is required to be a function.");if("function"!=typeof i)throw new e("oldFunction is required to be a function.");return function(){i.apply(t,arguments),r.apply(t,arguments)}};return t}),r("ThirdParty/measureText",[],function(){var e=function(e,t){return document.defaultView.getComputedStyle(e,null).getPropertyValue(t)},t=function(t,r,i,n){var o=t.measureText(r),a=e(t.canvas,"font-family"),s=e(t.canvas,"font-size").replace("px",""),l=!/\S/.test(r);o.fontsize=s;var u=document.createElement("div");u.style.position="absolute",u.style.opacity=0,u.style.font=s+"px "+a,u.innerHTML=r+"<br/>"+r,document.body.appendChild(u),o.leading=1.2*s;var c=e(u,"height");if(c=c.replace("px",""),c>=2*s&&(o.leading=0|c/2),document.body.removeChild(u),l)o.ascent=0,o.descent=0,o.bounds={minx:0,maxx:o.width,miny:0,maxy:0},o.height=0;else{var h=document.createElement("canvas"),d=100;h.width=o.width+d,h.height=3*s,h.style.opacity=1,h.style.fontFamily=a,h.style.fontSize=s;var m=h.getContext("2d");m.font=s+"px "+a;var p=h.width,f=h.height,v=f/2;m.fillStyle="white",m.fillRect(-1,-1,p+2,f+2),i&&(m.strokeStyle="black",m.lineWidth=t.lineWidth,m.strokeText(r,d/2,v)),n&&(m.fillStyle="black",m.fillText(r,d/2,v));for(var y=m.getImageData(0,0,p,f).data,g=0,_=4*p,w=y.length;++g<w&&255===y[g];);var C=0|g/_;for(g=w-1;--g>0&&255===y[g];);var x=0|g/_;for(g=0;w>g&&255===y[g];)g+=_,g>=w&&(g=g-w+4);var S=0|g%_/4,E=1;for(g=w-3;g>=0&&255===y[g];)g-=_,0>g&&(g=w-3-4*E++);var b=0|g%_/4+1;o.ascent=v-C,o.descent=x-v,o.bounds={minx:S-d/2,maxx:b-d/2,miny:0,maxy:x-C},o.height=1+(x-C)}return o};return t}),r("Core/writeTextToCanvas",["./defaultValue","./defined","./DeveloperError","./Color","../ThirdParty/measureText"],function(e,t,r,i,n){"use strict";var o=function(o,a){if(!t(o))throw new r("text is required.");if(""===o)return void 0;a=e(a,e.EMPTY_OBJECT);var s=e(a.font,"10px sans-serif"),l=document.createElement("canvas");l.width=l.height=1,l.style.font=s;var u=l.getContext("2d");u.font=s,u.textBaseline=e(a.textBaseline,"bottom"),l.style.visibility="hidden",document.body.appendChild(l);var c=e(a.stroke,!1),h=e(a.fill,!0),d=2*e(a.strokeWidth,1);u.lineWidth=d;var m=n(u,o,c,h);l.dimensions=m,document.body.removeChild(l),l.style.visibility="";var p=m.height-m.ascent;l.width=m.width,l.height=m.height;var f=l.height-p;if(u.font=s,c){var v=e(a.strokeColor,i.BLACK);u.strokeStyle=v.toCssColorString(),u.lineWidth=d,u.strokeText(o,0,f)}if(h){var y=e(a.fillColor,i.WHITE);u.fillStyle=y.toCssColorString(),u.fillText(o,0,f)}return l};return o}),r("DynamicScene/ConstantProperty",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Enumeration"],function(e,t,r,i){"use strict";var n=function(e){if(!t(e))throw new r("value is required.");var n="object"!=typeof e||Array.isArray(e)||e instanceof i;if(!n){if("function"!=typeof e.clone)throw new r("clone is a required function.");if("function"!=typeof e.equals)throw new r("equals is a required function.")}this._value=e,this._simple=n};return n.prototype.getValue=function(e,t){return this._simple?this._value:this._value.clone(t)},n.prototype.equals=function(e){return this===e||e instanceof n&&(this._simple&&this._value===e._value||!this._simple&&this._value.equals(e._value))},n}),r("DynamicScene/Property",["../Core/defined","../Core/DeveloperError"],function(e,t){"use strict";function r(){throw new t("This type should not be instantiated directly.")}var i=r;return i.prototype.getValue=r,i.prototype.equals=r,i.equals=function(t,r){return t===r||e(t)&&t.equals(r)},i}),r("DynamicScene/ColorMaterialProperty",["../Core/Color","../Core/defined","./ConstantProperty","./Property"],function(e,t,r,i){"use strict";var n=function(){this.color=new r(e.WHITE)};return n.prototype.getType=function(){return"Color"},n.prototype.getValue=function(e,r){return t(r)||(r={}),r.color=t(this.color)?this.color.getValue(e,r.color):void 0,r},n.prototype.equals=function(e){return this===e||e instanceof n&&i.equals(this.color,e.color)},n}),r("DynamicScene/createDynamicPropertyDescriptor",["../Core/defaultValue"],function(e){"use strict";function t(t,r,i){return{configurable:e(i,!1),get:function(){return this[r]},set:function(e){var i=this[r];i!==e&&(this[r]=e,this._propertyChanged.raiseEvent(this,t,e,i))}}}return t}),r("DynamicScene/DynamicObject",["../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/JulianDate","../Core/TimeInterval","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o,a,s,l){"use strict";var u=["cachedAvailabilityDate","cachedAvailabilityValue","id","propertyChanged","propertyNames","isAvailable","clean","merge","addProperty","removeProperty"],c=function(t){this._cachedAvailabilityDate=void 0,this._cachedAvailabilityValue=void 0,r(t)||(t=e()),this._id=t,this._availability=void 0,this._position=void 0,this._orientation=void 0,this._billboard=void 0,this._cone=void 0,this._ellipsoid=void 0,this._ellipse=void 0,this._label=void 0,this._name=void 0,this._parent=void 0,this._path=void 0,this._point=void 0,this._polygon=void 0,this._polyline=void 0,this._pyramid=void 0,this._vertexPositions=void 0,this._vector=void 0,this._viewFrom=void 0,this._propertyChanged=new o,this._propertyNames=["parent","position","orientation","billboard","cone","ellipsoid","ellipse","label","path","point","polygon","polyline","pyramid","vertexPositions","vector","viewFrom"]};return i(c.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},propertyNames:{get:function(){return this._propertyNames}},id:{get:function(){return this._id}},name:{configurable:!1,get:function(){return this._name},set:function(e){var t=this._name;t!==e&&(this._name=e,this._propertyChanged.raiseEvent(this,"name",e,t))}},availability:l("availability","_availability"),position:l("position","_position"),orientation:l("orientation","_orientation"),viewFrom:l("viewFrom","_viewFrom"),billboard:l("billboard","_billboard"),cone:l("cone","_cone"),ellipsoid:l("ellipsoid","_ellipsoid"),ellipse:l("ellipse","_ellipse"),label:l("label","_label"),parent:l("parent","_parent"),path:l("path","_path"),point:l("point","_point"),polygon:l("polygon","_polygon"),polyline:l("polyline","_polyline"),pyramid:l("pyramid","_pyramid"),vertexPositions:l("vertexPositions","_vertexPositions"),vector:l("vector","_vector")}),c.prototype.isAvailable=function(e){if(!r(e))throw new n("time is required.");var t=this._availability;return!r(t)||t.contains(e)},c.prototype.addProperty=function(e){if(!r(e))throw new n("propertyName is required.");var t=this._propertyNames;if(-1!==t.indexOf(e))throw new n(e+" is already a registered property.");if(-1!==u.indexOf(e))throw new n(e+" is a reserved property name.");t.push(e),Object.defineProperty(this,e,l(e,"_"+e,!0))},c.prototype.removeProperty=function(e){if(!r(e))throw new n("propertyName is required.");var t=this._propertyNames;if(-1!==u.indexOf(e))throw new n(e+" is a reserved property name.");if(-1===t.indexOf(e))throw new n(e+" is not a registered property.");this._propertyNames.push(e),delete this[e]},c.prototype.merge=function(e){if(!r(e))throw new n("source is required.");this.name=t(this.name,e.name),this.availability=t(e.availability,this.availability);for(var i=this._propertyNames,o=i.length,a=0;o>a;a++){var s=i[a],l=this[s],u=e[s];r(u)&&(r(l)?r(l.merge)&&l.merge(u):this[s]=r(u.merge)&&r(u.clone)?u.clone():u)}},c}),r("DynamicScene/DynamicObjectCollection",["../Core/createGuid","../Core/defined","../Core/defineProperties","../Core/Event","../Core/TimeInterval","../Core/Iso8601","../Core/DeveloperError","../Core/RuntimeError","./DynamicObject"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(e){if(0===e._suspendCount){var t=e._added,r=e._removed;(0!==t.length||0!==r.length)&&(e._collectionChanged.raiseEvent(e,t,r),t.length=0,r.length=0,e._addedHash={},e._removedHash={})}}var c=function(){this._array=[],this._hash={},this._added=[],this._addedHash={},this._removed=[],this._removedHash={},this._suspendCount=0,this._collectionChanged=new i,this._id=e()};return c.prototype.suspendEvents=function(){this._suspendCount++},c.prototype.resumeEvents=function(){if(0===this._suspendCount)throw new a("resumeEvents can not be called before suspendEvents.");this._suspendCount--,u(this)},c.collectionChangedEventCallback=void 0,r(c.prototype,{collectionChanged:{get:function(){return this._collectionChanged}},id:{get:function(){return this._id}}}),c.prototype.computeAvailability=function(){for(var e=o.MAXIMUM_VALUE,r=o.MINIMUM_VALUE,i=this._array,a=0,s=i.length;s>a;a++){var l=i[a],u=l.availability;if(t(u)){var c=u.getStart(),h=u.getStop();c.lessThan(e)&&!c.equals(o.MINIMUM_VALUE)&&(e=c),h.greaterThan(r)&&!h.equals(o.MAXIMUM_VALUE)&&(r=h)}}return o.MAXIMUM_VALUE.equals(e)&&(e=o.MINIMUM_VALUE),o.MINIMUM_VALUE.equals(r)&&(r=o.MAXIMUM_VALUE),new n(e,r,!0,!0)},c.prototype.add=function(e){if(!t(e))throw new a("dynamicObject is required.");var r=e.id,i=this._hash;if(t(i[r]))throw new s("An object with id "+r+" already exists in this collection.");i[r]=e,this._array.push(e);var n=this._removed,o=-1,l=this._removedHash[r];t(l)&&(o=n.indexOf(l)),-1!==o?(n.splice(o,1),this._removedHash[r]=void 0):(this._added.push(e),this._addedHash[r]=e),u(this)},c.prototype.remove=function(e){if(!t(e))throw new a("dynamicObject is required");return this.removeById(e.id)},c.prototype.removeById=function(e){if(!t(e))throw new a("id is required.");var r=this._hash,i=this._array,n=r[e],o=t(n);if(o){r[e]=void 0,i.splice(i.indexOf(n),1);var s=this._added,l=-1,c=this._addedHash[e];t(c)&&(l=s.indexOf(c)),-1!==l?(s.splice(l,1),this._addedHash[e]=void 0):(this._removed.push(n),this._removedHash[e]=n),u(this)}return o},c.prototype.removeAll=function(){for(var e=this._array,r=e.length,i=this._removed,n=this._removedHash,o=this._addedHash,a=0;r>a;a++){var s=e[a],l=s.id,c=o[l];t(c)||(i.push(s),n[l]=s)}this._addedHash={},this._added.length=0,e.length=0,this._hash={},u(this)},c.prototype.getById=function(e){if(!t(e))throw new a("id is required.");return this._hash[e]},c.prototype.getObjects=function(){return this._array},c.prototype.getOrCreateObject=function(e){if(!t(e))throw new a("id is required.");var r=this._hash[e];return t(r)||(r=new l(e),this.add(r)),r},c}),r("DynamicScene/CompositeDynamicObjectCollection",["../Core/createGuid","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Math","./DynamicObject","./DynamicObjectCollection"],function(e,t,r,i,n,o,a){"use strict";function s(e){for(var t=e.propertyNames,r=t.length,i=0;r>i;i++)e[t[i]]=void 0}function l(e,r,i){return function(n,o){for(var a=r.id,s=e._composite,l=s.getById(a),u=l[i],c=e._collectionsCopy,h=c.length,d=h-1;d>=0;d--){var m=c[d].getById(r.id);if(t(m)){var p=m[i];if(t(p)){var f=p[o];if(t(f))return u[o]=f,void 0}}}u[o]=void 0}}function u(e,r){var i=e._composite,n=e._eventHash;return function(o,a){var s=o.id,l=i.getById(s),u=l[a];h(n,r,o,a),c(e,n,r,o,a,o[a]);for(var d=e._collectionsCopy,m=d.length,p=!0,f=m-1;f>=0;f--){var v=d[f].getById(o.id);if(t(v)){var y=v[a];if(t(y)){if(p){if(p=!1,!t(y.merge)||!t(y.clone)){u=y;break}u=y.clone(u)}u.merge(y)}}}l[a]=u}}function c(e,r,i,n,o,a){if(t(a)&&t(a.propertyChanged)){var s=l(e,n,o);y[0]=i,y[1]=n.id,y[2]=o,r[JSON.stringify(y)]=a.propertyChanged.addEventListener(s)}}function h(e,r,i,n){y[0]=r,y[1]=i.id,y[2]=n;var o=JSON.stringify(y),a=e[o];t(a)&&(a(),e[o]=void 0)}function d(e,t,r,i){g[0]=r,g[1]=i.id,t[JSON.stringify(g)]=i.propertyChanged.addEventListener(u(e,r));for(var n=i.propertyNames,o=n.length,a=0;o>a;a++){var s=n[a];c(e,t,r,i,s,i[s])}}function m(e,t,r,i){g[0]=r,g[1]=i.id;var n=JSON.stringify(g);t[n](),t[n]=void 0;for(var o=i.propertyNames,a=o.length,s=0;a>s;s++){var l=o[s];h(t,r,i,l)}}function p(e){var r,i,n,l,u,c,h=e._collections,p=h.length,f=e._collectionsCopy,v=f.length,y=e._composite,g=new a,w=e._eventHash;for(r=0;v>r;r++)for(u=f[r],u.collectionChanged.removeEventListener(_.prototype._onCollectionChanged,e),n=u.getObjects(),c=u.id,l=n.length-1;l>-1;l--)i=n[l],m(e,w,c,i);
for(r=p-1;r>=0;r--)for(u=h[r],u.collectionChanged.addEventListener(_.prototype._onCollectionChanged,e),n=u.getObjects(),c=u.id,l=n.length-1;l>-1;l--){i=n[l],d(e,w,c,i);var C=g.getById(i.id);t(C)||(C=y.getById(i.id),t(C)?s(C):C=new o(i.id),g.add(C)),C.merge(i)}e._collectionsCopy=h.slice(0),y.suspendEvents(),y.removeAll();var x=g.getObjects();for(r=0;r<x.length;r++)y.add(x[r]);return y.resumeEvents(),!0}function f(e,r){if(!t(r))throw new i("collection is required.");var n=e.indexOf(r);if(-1===n)throw new i("collection is not in this composite.");return n}function v(e,t,r){var i=e._collections;if(t=n.clamp(t,0,i.length-1),r=n.clamp(r,0,i.length-1),t!==r){var o=i[t];i[t]=i[r],i[r]=o,p(e)}}var y=new Array(3),g=new Array(2),_=function(r){this._composite=new a,this._collections=t(r)?r.slice():[],this._collectionsCopy=[],this._id=e(),this._eventHash={},p(this)};return r(_.prototype,{collectionChanged:{get:function(){return this._composite._collectionChanged}},id:{get:function(){return this._id}}}),_.prototype.addCollection=function(e,r){if(!t(e))throw new i("collection is required.");if(t(r)){if(0>r)throw new i("index must be greater than or equal to zero.");if(r>this._collections.length)throw new i("index must be less than or equal to the number of collections.");this._collections.splice(r,0,e)}else r=this._collections.length,this._collections.push(e);p(this)},_.prototype.removeCollection=function(e){var t=this._collections.indexOf(e);return-1!==t?(this._collections.splice(t,1),p(this),!0):!1},_.prototype.removeAllCollections=function(){this._collections.length=[],p(this)},_.prototype.containsCollection=function(e){return-1!==this._collections.indexOf(e)},_.prototype.indexOfCollection=function(e){return this._collections.indexOf(e)},_.prototype.getCollection=function(e){if(!t(e))throw new i("index is required.","index");return this._collections[e]},_.prototype.getCollectionsLength=function(){return this._collections.length},_.prototype.raiseCollection=function(e){var t=f(this._collections,e);v(this,t,t+1)},_.prototype.lowerCollection=function(e){var t=f(this._collections,e);v(this,t,t-1)},_.prototype.raiseCollectionToTop=function(e){var t=f(this._collections,e);t!==this._collections.length-1&&(this._collections.splice(t,1),this._collections.push(e),p(this))},_.prototype.lowerCollectionToBottom=function(e){var t=f(this._collections,e);0!==t&&(this._collections.splice(t,1),this._collections.splice(0,0,e),p(this))},_.prototype.suspendEvents=function(){this._composite.suspendEvents()},_.prototype.resumeEvents=function(){this._composite.resumeEvents()},_.prototype.computeAvailability=function(){return this._composite.computeAvailability()},_.prototype.getById=function(e){return this._composite.getById(e)},_.prototype.getObjects=function(){return this._composite.getObjects()},_.prototype._onCollectionChanged=function(e,r,i){var n=this._collectionsCopy,a=n.length,l=this._composite;l.suspendEvents();var u,c,h,p,f=i.length,v=this._eventHash,y=e.id;for(u=0;f>u;u++){var g=i[u];m(this,v,y,g);var _=g.id;for(c=a-1;c>=0;c--)h=n[c].getById(_),t(h)&&(t(p)||(p=l.getById(_),s(p)),p.merge(h));t(p)||l.removeById(_)}var w=r.length;for(u=0;w>u;u++){var C=r[u];d(this,v,y,C);var x=C.id;for(c=a-1;c>=0;c--)h=n[c].getById(x),t(h)&&(t(p)||(p=l.getById(x),t(p)?s(p):(p=new o(x),l.add(p))),p.merge(h))}l.resumeEvents()},_}),r("DynamicScene/CompositeMaterialProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/TimeIntervalCollection","./Property"],function(e,t,r,i,n){"use strict";var o=function(){this._intervals=new i};return t(o.prototype,{intervals:{get:function(){return this._intervals}}}),o.prototype.getType=function(t){if(!e(t))throw new r("time is required");var i=this._intervals.findDataForIntervalContainingDate(t);return e(i)?i.getType(t):void 0},o.prototype.getValue=function(t,i){if(!e(t))throw new r("time is required");var n=this._intervals.findDataForIntervalContainingDate(t);return e(n)?n.getValue(t,i):void 0},o.prototype.equals=function(e){return this===e||e instanceof o&&this._intervals.equals(e._intervals,n.equals)},o}),r("DynamicScene/CompositePositionProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/TimeIntervalCollection","../Core/ReferenceFrame","./Property"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._intervals=new n,this._referenceFrame=e(t,o.FIXED)};return r(s.prototype,{intervals:{get:function(){return this._intervals}},referenceFrame:{get:function(){return this._referenceFrame},set:function(e){this._referenceFrame=e}}}),s.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},s.prototype.getValueInReferenceFrame=function(e,r,n){if(!t(e))throw new i("time is required.");if(!t(r))throw new i("referenceFrame is required.");var o=this._intervals.findDataForIntervalContainingDate(e);return t(o)?o.getValueInReferenceFrame(e,r,n):void 0},s.prototype.equals=function(e){return this===e||e instanceof s&&this._referenceFrame===e._referenceFrame&&this._intervals.equals(e._intervals,a.equals)},s}),r("DynamicScene/CompositeProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/TimeIntervalCollection","./Property"],function(e,t,r,i,n){"use strict";var o=function(){this._intervals=new i};return t(o.prototype,{intervals:{get:function(){return this._intervals}}}),o.prototype.getValue=function(t,i){if(!e(t))throw new r("time is required");var n=this._intervals.findDataForIntervalContainingDate(t);return e(n)?n.getValue(t,i):void 0},o.prototype.equals=function(e){return this===e||e instanceof o&&this._intervals.equals(e._intervals,n.equals)},o}),r("DynamicScene/PositionProperty",["../Core/Cartesian3","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix3","../Core/ReferenceFrame","../Core/Transforms"],function(e,t,r,i,n,o,a){"use strict";function s(){throw new i("This type should not be instantiated directly.")}var l=s;r(l.prototype,{referenceFrame:{get:s}}),l.prototype.getValue=s,l.prototype.getValueInReferenceFrame=s,l.prototype.equals=s;var u=new n;return l.convertToReferenceFrame=function(r,i,s,l,c){if(s===l)return e.clone(i,c);var h=a.computeIcrfToFixedMatrix(r,u);return t(h)||(h=a.computeTemeToPseudoFixedMatrix(r,u)),s===o.INERTIAL?n.multiplyByVector(h,i,c):s===o.FIXED?n.multiplyByVector(n.transpose(h,u),i,c):void 0},l}),r("DynamicScene/ConstantPositionProperty",["./ConstantProperty","./PositionProperty","../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/ReferenceFrame","./Property"],function(e,t,r,i,n,o,a,s,l){"use strict";var u=function(t,r){this._property=new e(t),this._referenceFrame=i(r,s.FIXED)};return o(u.prototype,{referenceFrame:{get:function(){return this._referenceFrame}}}),u.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,s.FIXED,t)},u.prototype.getValueInReferenceFrame=function(e,r,i){if(!n(e))throw new a("time is required.");if(!n(r))throw new a("referenceFrame is required.");var o=this._property.getValue(e,i);return t.convertToReferenceFrame(e,o,this._referenceFrame,r,o)},u.prototype.equals=function(e){return this===e||e instanceof u&&l.equals(this._property,e._property)&&this._referenceFrame===e._referenceFrame},u}),r("Scene/HorizontalOrigin",["../Core/Enumeration"],function(e){"use strict";var t={CENTER:new e(0,"CENTER"),LEFT:new e(1,"LEFT"),RIGHT:new e(-1,"RIGHT")};return t}),r("Scene/LabelStyle",["../Core/Enumeration"],function(e){"use strict";var t={FILL:new e(0,"FILL"),OUTLINE:new e(1,"OUTLINE"),FILL_AND_OUTLINE:new e(2,"FILL_AND_OUTLINE")};return t}),r("Scene/VerticalOrigin",["../Core/Enumeration"],function(e){"use strict";var t={CENTER:new e(0,"CENTER"),BOTTOM:new e(1,"BOTTOM"),TOP:new e(-1,"TOP")};return t}),r("DynamicScene/DynamicBillboard",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._image=void 0,this._width=void 0,this._height=void 0,this._scale=void 0,this._rotation=void 0,this._alignedAxis=void 0,this._horizontalOrigin=void 0,this._verticalOrigin=void 0,this._color=void 0,this._eyeOffset=void 0,this._pixelOffset=void 0,this._show=void 0,this._scaleByDistance=void 0,this._translucencyByDistance=void 0,this._pixelOffsetScaleByDistance=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},image:o("image","_image"),scale:o("scale","_scale"),rotation:o("rotation","_rotation"),alignedAxis:o("alignedAxis","_alignedAxis"),horizontalOrigin:o("horizontalOrigin","_horizontalOrigin"),verticalOrigin:o("verticalOrigin","_verticalOrigin"),color:o("color","_color"),eyeOffset:o("eyeOffset","_eyeOffset"),pixelOffset:o("pixelOffset","_pixelOffset"),show:o("show","_show"),width:o("width","_width"),height:o("height","_height"),scaleByDistance:o("scaleByDistance","_scaleByDistance"),translucencyByDistance:o("translucencyByDistance","_translucencyByDistance"),pixelOffsetScaleByDistance:o("pixelOffsetScaleByDistance","_pixelOffsetScaleByDistance")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.color=this._color,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.image=this._image,e.pixelOffset=this._pixelOffset,e.scale=this._scale,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.show=this._show,e.verticalOrigin=this._verticalOrigin,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.color=e(this._color,r._color),this.eyeOffset=e(this._eyeOffset,r._eyeOffset),this.horizontalOrigin=e(this._horizontalOrigin,r._horizontalOrigin),this.image=e(this._image,r._image),this.pixelOffset=e(this._pixelOffset,r._pixelOffset),this.scale=e(this._scale,r._scale),this.rotation=e(this._rotation,r._rotation),this.alignedAxis=e(this._alignedAxis,r._alignedAxis),this.show=e(this._show,r._show),this.verticalOrigin=e(this._verticalOrigin,r._verticalOrigin),this.width=e(this._width,r._width),this.height=e(this._height,r._height),this.scaleByDistance=e(this._scaleByDistance,r._scaleByDistance),this.translucencyByDistance=e(this._translucencyByDistance,r._translucencyByDistance),this.pixelOffsetScaleByDistance=e(this._pixelOffsetScaleByDistance,r._pixelOffsetScaleByDistance)},a}),r("DynamicScene/DynamicClock",["../Core/Clock","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(){this._startTime=void 0,this._stopTime=void 0,this._currentTime=void 0,this._clockRange=void 0,this._clockStep=void 0,this._multiplier=void 0,this._propertyChanged=new o};return i(s.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},startTime:a("startTime","_startTime"),stopTime:a("stopTime","_stopTime"),currentTime:a("currentTime","_currentTime"),clockRange:a("clockRange","_clockRange"),clockStep:a("clockStep","_clockStep"),multiplier:a("multiplier","_multiplier")}),s.prototype.clone=function(e){return r(e)||(e=new s),e.startTime=this.startTime,e.stopTime=this.stopTime,e.currentTime=this.currentTime,e.clockRange=this.clockRange,e.clockStep=this.clockStep,e.multiplier=this.multiplier,e},s.prototype.merge=function(e){if(!r(e))throw new n("source is required.");this.startTime=t(this.startTime,e.startTime),this.stopTime=t(this.stopTime,e.stopTime),this.currentTime=t(this.currentTime,e.currentTime),this.clockRange=t(this.clockRange,e.clockRange),this.clockStep=t(this.clockStep,e.clockStep),this.multiplier=t(this.multiplier,e.multiplier)},s.prototype.getValue=function(t){return r(t)||(t=new e),t.startTime=this.startTime,t.stopTime=this.stopTime,t.clockRange=this.clockRange,t.clockStep=this.clockStep,t.multiplier=this.multiplier,t.currentTime=this.currentTime,t},s}),r("DynamicScene/PolylineOutlineMaterialProperty",["../Core/Color","../Core/defined","./ConstantProperty","./Property"],function(e,t,r,i){"use strict";var n=function(){this.color=new r(e.WHITE),this.outlineColor=new r(e.BLACK),this.outlineWidth=new r(0)};return n.prototype.getType=function(){return"PolylineOutline"},n.prototype.getValue=function(e,r){return t(r)||(r={}),r.color=t(this.color)?this.color.getValue(e,r.color):void 0,r.outlineColor=t(this.outlineColor)?this.outlineColor.getValue(e,r.outlineColor):void 0,r.outlineWidth=t(this.outlineWidth)?this.outlineWidth.getValue(e):void 0,r},n.prototype.equals=function(e){return this===e||e instanceof n&&i.equals(this.color,e.color)&&i.equals(this.outlineColor,e.outlineColor)&&i.equals(this.outlineWidth,e.outlineWidth)},n}),r("DynamicScene/DynamicCone",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._minimumClockAngle=void 0,this._maximumClockAngle=void 0,this._innerHalfAngle=void 0,this._outerHalfAngle=void 0,this._capMaterial=void 0,this._innerMaterial=void 0,this._outerMaterial=void 0,this._silhouetteMaterial=void 0,this._intersectionColor=void 0,this._intersectionWidth=void 0,this._showIntersection=void 0,this._radius=void 0,this._show=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},minimumClockAngle:o("minimumClockAngle","_minimumClockAngle"),maximumClockAngle:o("maximumClockAngle","_maximumClockAngle"),innerHalfAngle:o("innerHalfAngle","_innerHalfAngle"),outerHalfAngle:o("outerHalfAngle","_outerHalfAngle"),capMaterial:o("capMaterial","_capMaterial"),innerMaterial:o("innerMaterial","_innerMaterial"),outerMaterial:o("outerMaterial","_outerMaterial"),silhouetteMaterial:o("silhouetteMaterial","_silhouetteMaterial"),intersectionColor:o("intersectionColor","_intersectionColor"),intersectionWidth:o("intersectionWidth","_intersectionWidth"),showIntersection:o("showIntersection","_showIntersection"),radius:o("radius","_radius"),show:o("show","_show")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.show=this.show,e.innerHalfAngle=this.innerHalfAngle,e.outerHalfAngle=this.outerHalfAngle,e.minimumClockAngle=this.minimumClockAngle,e.maximumClockAngle=this.maximumClockAngle,e.radius=this.radius,e.showIntersection=this.showIntersection,e.intersectionColor=this.intersectionColor,e.intersectionWidth=this.intersectionWidth,e.capMaterial=this.capMaterial,e.innerMaterial=this.innerMaterial,e.outerMaterial=this.outerMaterial,e.silhouetteMaterial=this.silhouetteMaterial,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.innerHalfAngle=e(this.innerHalfAngle,r.innerHalfAngle),this.outerHalfAngle=e(this.outerHalfAngle,r.outerHalfAngle),this.minimumClockAngle=e(this.minimumClockAngle,r.minimumClockAngle),this.maximumClockAngle=e(this.maximumClockAngle,r.maximumClockAngle),this.radius=e(this.radius,r.radius),this.showIntersection=e(this.showIntersection,r.showIntersection),this.intersectionColor=e(this.intersectionColor,r.intersectionColor),this.intersectionWidth=e(this.intersectionWidth,r.intersectionWidth),this.capMaterial=e(this.capMaterial,r.capMaterial),this.innerMaterial=e(this.innerMaterial,r.innerMaterial),this.outerMaterial=e(this.outerMaterial,r.outerMaterial),this.silhouetteMaterial=e(this.silhouetteMaterial,r.silhouetteMaterial)},a}),r("DynamicScene/DynamicLabel",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._text=void 0,this._font=void 0,this._style=void 0,this._fillColor=void 0,this._outlineColor=void 0,this._outlineWidth=void 0,this._horizontalOrigin=void 0,this._verticalOrigin=void 0,this._eyeOffset=void 0,this._pixelOffset=void 0,this._scale=void 0,this._show=void 0,this._translucencyByDistance=void 0,this._pixelOffsetScaleByDistance=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},text:o("text","_text"),font:o("font","_font"),style:o("style","_style"),fillColor:o("fillColor","_fillColor"),outlineColor:o("outlineColor","_outlineColor"),outlineWidth:o("outlineWidth","_outlineWidth"),horizontalOrigin:o("horizontalOrigin","_horizontalOrigin"),verticalOrigin:o("verticalOrigin","_verticalOrigin"),eyeOffset:o("eyeOffset","_eyeOffset"),pixelOffset:o("pixelOffset","_pixelOffset"),scale:o("scale","_scale"),show:o("show","_show"),translucencyByDistance:o("translucencyByDistance","_translucencyByDistance"),pixelOffsetScaleByDistance:o("pixelOffsetScaleByDistance","_pixelOffsetScaleByDistance")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.text=this.text,e.font=this.font,e.show=this.show,e.style=this.style,e.fillColor=this.fillColor,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.scale=this.scale,e.horizontalOrigin=this.horizontalOrigin,e.verticalOrigin=this.verticalOrigin,e.eyeOffset=this.eyeOffset,e.pixelOffset=this.pixelOffset,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.text=e(this.text,r.text),this.font=e(this.font,r.font),this.show=e(this.show,r.show),this.style=e(this.style,r.style),this.fillColor=e(this.fillColor,r.fillColor),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.scale=e(this.scale,r.scale),this.horizontalOrigin=e(this.horizontalOrigin,r.horizontalOrigin),this.verticalOrigin=e(this.verticalOrigin,r.verticalOrigin),this.eyeOffset=e(this.eyeOffset,r.eyeOffset),this.pixelOffset=e(this.pixelOffset,r.pixelOffset),this.translucencyByDistance=e(this._translucencyByDistance,r._translucencyByDistance),this.pixelOffsetScaleByDistance=e(this._pixelOffsetScaleByDistance,r._pixelOffsetScaleByDistance)},a}),r("DynamicScene/DynamicDirectionsProperty",["../Core/defined","../Core/TimeInterval","../Core/TimeIntervalCollection","../Core/Cartesian3","../Core/Spherical","../Core/Iso8601"],function(e,t,r,i,n,o){"use strict";function a(t){var r,o,a=[],s=t.unitSpherical;if(e(s)){for(r=0,o=s.length;o>r;r+=2)a.push(new n(s[r],s[r+1]));this.spherical=a}if(s=t.unitCartesian,e(s)){for(r=0,o=s.length;o>r;r+=3)a.push(new i(s[r],s[r+1],s[r+2],!0));this.cartesian=a}}function s(r,i,n){var s=i.interval;s=e(s)?t.fromIso8601(s):o.MAXIMUM_INTERVAL.clone(),e(n)&&(s=s.intersect(n));var l=r._propertyIntervals,u=l.findInterval(s.start,s.stop);e(u)||(u=s,l.addInterval(u)),u.data=new a(i)}a.prototype.getValue=function(){var t=this.spherical;if(!e(t)){t=[],this.spherical=t;for(var r=this.cartesian,i=0,o=r.length;o>i;i++)t.push(n.fromCartesian3(r[i]))}return t};var l=function(){this._propertyIntervals=new r};return l.prototype.processCzmlIntervals=function(e,t,r){if(Array.isArray(e))for(var i=0,n=e.length;n>i;i++)s(this,e[i],t,r);else s(this,e,t,r)},l.prototype.getValue=function(t){var r=this._propertyIntervals.findIntervalContainingDate(t);return e(r)?r.data.getValue():void 0},l}),r("DynamicScene/DynamicEllipse",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/Shapes","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o,a,s,l){"use strict";var u=function(){this._semiMajorAxis=void 0,this._semiMinorAxis=void 0,this._rotation=void 0,this._lastPosition=void 0,this._lastSemiMajorAxis=void 0,this._lastSemiMinorAxis=void 0,this._lastRotation=void 0,this._cachedVertexPositions=void 0,this._propertyChanged=new a};return i(u.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},semiMajorAxis:l("semiMajorAxis","_semiMajorAxis"),semiMinorAxis:l("semiMinorAxis","_semiMinorAxis"),rotation:l("rotation","_rotation")}),u.prototype.clone=function(e){return r(e)||(e=new u),e.rotation=this.rotation,e.semiMajorAxis=this.semiMajorAxis,e.semiMinorAxis=this.semiMinorAxis,e},u.prototype.merge=function(e){if(!r(e))throw new n("source is required.");this.rotation=t(this.rotation,e.rotation),this.semiMajorAxis=t(this.semiMajorAxis,e.semiMajorAxis),this.semiMinorAxis=t(this.semiMinorAxis,e.semiMinorAxis)},u.prototype.getValue=function(t,i){var n=this._semiMajorAxis,a=this._semiMinorAxis;if(!r(i)||!r(n)||!r(a))return void 0;var l=n.getValue(t),u=a.getValue(t),c=0,h=this._rotation;if(r(h)&&(c=h.getValue(t)),!r(l)||!r(u)||0===l||0===u)return void 0;var d=this._lastPosition,m=this._lastSemiMajorAxis,p=this._lastSemiMinorAxis,f=this._lastRotation;return c===f&&m===l&&p===u&&e.equals(d,i)||(this._cachedVertexPositions=s.computeEllipseBoundary(o.WGS84,i,l,u,c),this._lastPosition=e.clone(i,this._lastPosition),this._lastRotation=c,this._lastSemiMajorAxis=l,this._lastSemiMinorAxis=u),this._cachedVertexPositions},u}),r("DynamicScene/DynamicEllipsoid",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._show=void 0,this._radii=void 0,this._material=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},show:o("show","_show"),radii:o("radii","_radii"),material:o("material","_material")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.show=this.show,e.radii=this.radii,e.material=this.material,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.radii=e(this.radii,r.radii),this.material=e(this.material,r.material)},a}),r("DynamicScene/GridMaterialProperty",["../Core/Cartesian2","../Core/Color","../Core/defined","./ConstantProperty","./Property"],function(e,t,r,i,n){"use strict";var o=function(){this.color=new i(t.WHITE),this.cellAlpha=new i(.1),this.lineCount=new i(new e(8,8)),this.lineThickness=new i(new e(1,1))};return o.prototype.getType=function(){return"Grid"},o.prototype.getValue=function(e,t){return r(t)||(t={}),t.color=r(this.color)?this.color.getValue(e,t.color):void 0,t.cellAlpha=r(this.cellAlpha)?this.cellAlpha.getValue(e):void 0,t.lineCount=r(this.lineCount)?this.lineCount.getValue(e,t.lineCount):void 0,t.lineThickness=r(this.lineThickness)?this.lineThickness.getValue(e,t.lineThickness):void 0,t},o.prototype.equals=function(e){return this===e||e instanceof o&&n.equals(this.color,e.color)&&n.equals(this.cellAlpha,e.cellAlpha)&&n.equals(this.lineCount,e.lineCount)&&n.equals(this.lineThickness,e.lineThickness)},o}),r("DynamicScene/ImageMaterialProperty",["../Core/Cartesian2","../Core/defined","./ConstantProperty","./Property"],function(e,t,r,i){"use strict";var n=function(){this.image=void 0,this.repeat=new r(new e(1,1))};return n.prototype.getType=function(){return"Image"},n.prototype.getValue=function(e,r){return t(r)||(r={}),r.image=t(this.image)?this.image.getValue(e):void 0,r.repeat=t(this.repeat)?this.repeat.getValue(e,r.repeat):void 0,r},n.prototype.equals=function(e){return this===e||e instanceof n&&i.equals(this.image,e.image)&&i.equals(this.repeat,e.repeat)},n}),r("DynamicScene/DynamicPath",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._color=void 0,this._outlineColor=void 0,this._outlineWidth=void 0,this._show=void 0,this._width=void 0,this._resolution=void 0,this._leadTime=void 0,this._trailTime=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},color:o("color","_color"),outlineColor:o("outlineColor","_outlineColor"),outlineWidth:o("outlineWidth","_outlineWidth"),show:o("show","_show"),width:o("width","_width"),resolution:o("resolution","_resolution"),leadTime:o("leadTime","_leadTime"),trailTime:o("trailTime","_trailTime")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.color=this.color,e.width=this.width,e.resolution=this.resolution,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.show=this.show,e.leadTime=this.leadTime,e.trailTime=this.trailTime,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.color=e(this.color,r.color),this.width=e(this.width,r.width),this.resolution=e(this.resolution,r.resolution),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.show=e(this.show,r.show),this.leadTime=e(this.leadTime,r.leadTime),this.trailTime=e(this.trailTime,r.trailTime)},a}),r("DynamicScene/DynamicPoint",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._color=void 0,this._pixelSize=void 0,this._outlineColor=void 0,this._outlineWidth=void 0,this._show=void 0,this._scaleByDistance=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},color:o("color","_color"),pixelSize:o("pixelSize","_pixelSize"),outlineColor:o("outlineColor","_outlineColor"),outlineWidth:o("outlineWidth","_outlineWidth"),show:o("show","_show"),scaleByDistance:o("scaleByDistance","_scaleByDistance")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.color=this.color,e.pixelSize=this.pixelSize,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.show=this.show,e.scaleByDistance=this.scaleByDistance,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.color=e(this.color,r.color),this.pixelSize=e(this.pixelSize,r.pixelSize),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.show=e(this.show,r.show),this.scaleByDistance=e(this.scaleByDistance,r.scaleByDistance)},a}),r("DynamicScene/DynamicPolyline",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._show=void 0,this._material=void 0,this._width=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},show:o("show","_show"),material:o("material","_material"),width:o("width","_width")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.show=this.show,e.material=this.material,e.width=this.width,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.width=e(this.width,r.width)},a}),r("DynamicScene/DynamicPolygon",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._show=void 0,this._material=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},show:o("show","_show"),material:o("material","_material")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.show=this.show,e.material=this.material,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.material=e(this.material,r.material)},a}),r("DynamicScene/DynamicPyramid",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._show=void 0,this._directions=void 0,this._radius=void 0,this._showIntersection=void 0,this._intersectionColor=void 0,this._intersectionWidth=void 0,this._material=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},show:o("show","_show"),directions:o("directions","_directions"),radius:o("radius","_radius"),showIntersection:o("showIntersection","_showIntersection"),intersectionColor:o("intersectionColor","_intersectionColor"),intersectionWidth:o("intersectionWidth","_intersectionWidth"),material:o("material","_material")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.show=this.show,e.directions=this.directions,e.radius=this.radius,e.showIntersection=this.showIntersection,e.intersectionColor=this.intersectionColor,e.intersectionWidth=this.intersectionWidth,e.material=this.material,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.directions=e(this.directions,r.directions),this.radius=e(this.radius,r.radius),this.showIntersection=e(this.showIntersection,r.showIntersection),this.intersectionColor=e(this.intersectionColor,r.intersectionColor),this.intersectionWidth=e(this.intersectionWidth,r.intersectionWidth),this.material=e(this.material,r.material)},a}),r("DynamicScene/DynamicVector",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createDynamicPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(){this._color=void 0,this._show=void 0,this._width=void 0,this._direction=void 0,this._length=void 0,this._propertyChanged=new n};return r(a.prototype,{propertyChanged:{get:function(){return this._propertyChanged}},color:o("color","_color"),show:o("show","_show"),width:o("width","_width"),direction:o("direction","_direction"),length:o("length","_length")}),a.prototype.clone=function(e){return t(e)||(e=new a),e.color=this.color,e.width=this.width,e.direction=this.direction,e.length=this.length,e.show=this.show,e},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.color=e(this.color,r.color),this.width=e(this.width,r.width),this.direction=e(this.direction,r.direction),this.length=e(this.length,r.length),this.show=e(this.show,r.show)},a}),r("DynamicScene/ReferenceProperty",["../Core/defaultValue","../Core/defined","../Core/DeveloperError"],function(e,t,r){"use strict";function i(e){var r=e._targetProperty;if(!t(r)){var i=e._dynamicObjectCollection,n=i.getById(e._targetObjectId);t(n)&&(r=n[e._targetPropertyName],e._targetProperty=r,e._targetObject=n)}return r}var n=function(e,i,n){if(!t(e))throw new r("dynamicObjectCollection is required.");if(!t(i))throw new r("targetObjectId is required.");if(!t(n))throw new r("targetPropertyName is required.");this._targetProperty=void 0,this._dynamicObjectCollection=e,this._targetObjectId=i,this._targetObject=void 0,this._targetPropertyName=n};return n.fromString=function(e,i){if(!t(e))throw new r("dynamicObjectCollection is required.");if(!t(i))throw new r("referenceString is required.");var o=i.split(".");if(2!==o.length)throw new r("referenceString must contain a single . delineating the target object ID and property name.");return new n(e,o[0],o[1])},n.prototype.getValue=function(e,n){if(!t(e))throw new r("time is required.");var o=i(this);return t(o)&&this._targetObject.isAvailable(e)?o.getValue(e,n):void 0},n.prototype.equals=function(e){return this===e||this._dynamicObjectCollection===e._dynamicObjectCollection&&this._targetObjectId===e._targetObjectId&&this._targetPropertyName===e._targetPropertyName},n}),r("DynamicScene/DynamicVertexPositionsProperty",["../Core/defined","../Core/TimeInterval","../Core/TimeIntervalCollection","../Core/Cartesian3","../Core/Cartographic","../Core/Iso8601","../Core/Ellipsoid","./ReferenceProperty"],function(e,t,r,i,n,o,a,s){"use strict";function l(t){var r,o,a,s=[];if(a=t.cartesian,e(a)){for(r=0,o=a.length;o>r;r+=3)s.push(new i(a[r],a[r+1],a[r+2]));
this.cartesian=s}else if(a=t.cartographicRadians,e(a)){for(r=0,o=a.length;o>r;r+=3)s.push(new n(a[r],a[r+1],a[r+2]));this.cartographic=s}else if(a=t.cartographicDegrees,e(a)){for(r=0,o=a.length;o>r;r+=3)s.push(n.fromDegrees(a[r],a[r+1],a[r+2]));this.cartographic=s}}var u=a.WGS84;l.prototype.getValue=function(){return e(this.cartesian)||(this.cartesian=u.cartographicArrayToCartesianArray(this.cartographic)),this.cartesian};var c=function(){this._propertyIntervals=new r};return c.prototype.processCzmlIntervals=function(e,t,r){if(Array.isArray(e))for(var i=0,n=e.length;n>i;i++)this._addCzmlInterval(e[i],t,r);else this._addCzmlInterval(e,t,r)},c.prototype.getValue=function(t){var r=this._propertyIntervals.findIntervalContainingDate(t);if(!e(r))return void 0;var i=r.data;if(Array.isArray(i)){for(var n=[],o=0,a=i.length;a>o;o++){var s=i[o].getValue(t);e(s)&&n.push(s)}return n}return i.getValue()},c.prototype._addCzmlInterval=function(r,i,n){var a=r.interval;a=e(a)?t.fromIso8601(a):o.MAXIMUM_INTERVAL.clone(),e(i)&&(a=a.intersect(i));var u=this._propertyIntervals,c=u.findInterval(a.start,a.stop);e(c)||(c=a,u.addInterval(c));var h=r.references;if(e(h)){for(var d=[],m=0,p=h.length;p>m;m++)d.push(s.fromString(n,h[m]));c.data=d}else c.data=new l(r)},c}),r("DynamicScene/SampledProperty",["../Core/binarySearch","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/JulianDate","../Core/LinearApproximation"],function(e,t,r,i,n,o,a){"use strict";function s(e,t,r){var i,n=e.length,o=r.length,a=n+o;if(e.length=a,n!==t){var s=n-1;for(i=a-1;i>=t;i--)e[i]=e[s--]}for(i=0;o>i;i++)e[t++]=r[i]}function l(e,t){return e instanceof o?e:"string"==typeof e?o.fromIso8601(e):t.addSeconds(e)}var u={packedLength:1,pack:function(e,r,i){i=t(i,0),r[i]=e},unpack:function(e,r){return r=t(r,0),e[r]}},c=[],h=[],d=function(t,i,n,a,u){for(var d,m,p,f,v,y,g=0;g<a.length;){v=l(a[g],t),p=e(i,v,o.compare);var _=0,w=0;if(0>p){for(p=~p,f=p*u,m=void 0,y=i[p];g<a.length&&(v=l(a[g],t),!(r(m)&&o.compare(m,v)>=0||r(y)&&o.compare(v,y)>=0));){for(c[_++]=v,g+=1,d=0;u>d;d++)h[w++]=a[g],g+=1;m=v}_>0&&(h.length=w,s(n,f,h),c.length=_,s(i,p,c))}else{for(d=0;u>d;d++)g++,n[p*u+d]=a[g];g++}}},m=function(e){if(!r(e))throw new n("type is required.");var i=e;i===Number&&(i=u);var o=t(i.packedInterpolationLength,i.packedLength);this._type=e,this._innerType=i,this._interpolationDegree=1,this._interpolationAlgorithm=a,this._numberOfPoints=0,this._times=[],this._values=[],this._xTable=[],this._yTable=[],this._packedInterpolationLength=o,this._updateTableLength=!0,this._interpolationResult=new Array(o)};return i(m.prototype,{type:{get:function(){return this._type}},interpolationDegree:{get:function(){return this._interpolationDegree},set:function(e){this._interpolationDegree=e,this._updateTableLength=!0}},interpolationAlgorithm:{get:function(){return this._interpolationAlgorithm},set:function(e){this._interpolationAlgorithm=e,this._updateTableLength=!0}}}),m.prototype.getValue=function(t,i){if(!r(t))throw new n("time is required.");var a=this._innerType,s=this._times,l=this._values,u=e(s,t,o.compare);if(0>u){var c=this._xTable,h=this._yTable,d=this._interpolationAlgorithm,m=this._packedInterpolationLength;if(this._updateTableLength){this._updateTableLength=!1;var p=Math.min(d.getRequiredDataPoints(this._interpolationDegree),s.length);p!==this._numberOfPoints&&(this._numberOfPoints=p,c.length=p,h.length=p*m)}var f=this._numberOfPoints-1;if(1>f)return void 0;u=~u,u>=s.length&&(u=s.length-1);var v=0,y=s.length-1,g=y-v+1;if(f+1>g);else{var _=u-(0|f/2)-1;v>_&&(_=v);var w=_+f;w>y&&(w=y,_=w-f,v>_&&(_=v)),v=_,y=w}for(var C=y-v+1,x=0;C>x;++x)c[x]=s[y].getSecondsDifference(s[v+x]);if(r(a.convertPackedArrayForInterpolation))a.convertPackedArrayForInterpolation(l,v,y,h);else for(var S=0,E=a.packedLength,b=v*E,T=(y+1)*E;T>b;)h[S]=l[b],b++,S++;var A=s[y].getSecondsDifference(t),D=d.interpolateOrderZero(A,c,h,m,this._interpolationResult);return r(a.unpackInterpolationResult)?a.unpackInterpolationResult(D,l,v,y,i):a.unpack(D,0,i)}return a.unpack(this._values,u*a.packedLength,i)},m.prototype.addSample=function(e,t){if(!r(e))throw new n("time is required.");if(!r(t))throw new n("value is required.");var i=this._innerType,o=[e];i.pack(t,o,1),d(void 0,this._times,this._values,o,i.packedLength),this._updateTableLength=!0},m.prototype.addSamples=function(e,t){if(!r(e))throw new n("times is required.");if(!r(t))throw new n("values is required.");if(e.length!==t.length)throw new n("times and values must be the same length.");for(var i=this._innerType,o=e.length,a=[],s=0;o>s;s++)a.push(e[s]),i.pack(t[s],a,a.length);d(void 0,this._times,this._values,a,i.packedLength),this._updateTableLength=!0},m.prototype.addSamplesPackedArray=function(e,t){if(!r(e))throw new n("packedSamples is required.");d(t,this._times,this._values,e,this._innerType.packedLength),this._updateTableLength=!0},m.prototype.equals=function(e){if(this===e)return!0;if(!r(e))return!1;var t=this._times,i=e._times,n=t.length;if(n!==i.length)return!1;var a;for(a=0;n>a;a++)if(!o.equals(t[a],i[a]))return!1;var s=this._values,l=e._values;for(a=0;n>a;a++)if(s[a]!==l[a])return!1;return this._type===e._type&&this._interpolationDegree===e._interpolationDegree&&this._interpolationAlgorithm===e._interpolationAlgorithm},m._mergeNewSamples=d,m}),r("DynamicScene/SampledPositionProperty",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/ReferenceFrame","./PositionProperty","./Property","./SampledProperty"],function(e,t,r,i,n,o,a,s,l){"use strict";var u=function(r){this._property=new l(e),this._referenceFrame=t(r,o.FIXED)};return i(u.prototype,{referenceFrame:{get:function(){return this._referenceFrame}},interpolationDegree:{get:function(){return this._property.interpolationDegree},set:function(e){this._property.interpolationDegree=e}},interpolationAlgorithm:{get:function(){return this._property.interpolationAlgorithm},set:function(e){this._property.interpolationAlgorithm=e}}}),u.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},u.prototype.getValueInReferenceFrame=function(e,t,i){if(!r(e))throw new n("time is required.");if(!r(t))throw new n("referenceFrame is required.");return i=this._property.getValue(e,i),r(i)?a.convertToReferenceFrame(e,i,this._referenceFrame,t,i):i},u.prototype.addSample=function(e,t){this._property.addSample(e,t)},u.prototype.addSamples=function(e,t){this._property.addSamples(e,t)},u.prototype.addSamplesPackedArray=function(e,t){this._property.addSamplesPackedArray(e,t)},u.prototype.equals=function(e){return this===e||s.equals(this._property,e._property)&&this._referenceFrame===e._referenceFrame},u}),r("DynamicScene/TimeIntervalCollectionPositionProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/ReferenceFrame","../Core/TimeIntervalCollection","./PositionProperty","./Property"],function(e,t,r,i,n,o,a,s){"use strict";var l=function(t){this._intervals=new o,this._referenceFrame=e(t,n.FIXED)};return r(l.prototype,{intervals:{get:function(){return this._intervals}},referenceFrame:{get:function(){return this._referenceFrame}}}),l.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,n.FIXED,t)},l.prototype.getValueInReferenceFrame=function(e,r,n){if(!t(e))throw new i("time is required.");if(!t(r))throw new i("referenceFrame is required.");var o=this._intervals.findDataForIntervalContainingDate(e);return t(o)?a.convertToReferenceFrame(e,o,this._referenceFrame,r,n):void 0},l.prototype.equals=function(e){return this===e||e instanceof l&&this._intervals.equals(e._intervals,s.equals)&&this._referenceFrame===e._referenceFrame},l}),r("DynamicScene/TimeIntervalCollectionProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Enumeration","../Core/TimeIntervalCollection","./Property"],function(e,t,r,i,n,o){"use strict";var a=function(){this._intervals=new n};return t(a.prototype,{intervals:{get:function(){return this._intervals}}}),a.prototype.getValue=function(t,n){if(!e(t))throw new r("time is required");var o=this._intervals.findDataForIntervalContainingDate(t);return!e(o)||"object"!=typeof o||Array.isArray(o)||o instanceof i?o:o.clone(n)},a.prototype.equals=function(e){return this===e||e instanceof a&&this._intervals.equals(e._intervals,o.equals)},a}),r("DynamicScene/CzmlDataSource",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/Color","../Core/ClockRange","../Core/ClockStep","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/getFilenameFromUri","../Core/HermitePolynomialApproximation","../Core/Iso8601","../Core/JulianDate","../Core/LagrangePolynomialApproximation","../Core/LinearApproximation","../Core/loadJson","../Core/Math","../Core/Quaternion","../Core/ReferenceFrame","../Core/RuntimeError","../Core/Spherical","../Core/TimeInterval","../Core/TimeIntervalCollection","../Scene/HorizontalOrigin","../Scene/LabelStyle","../Scene/VerticalOrigin","./CompositeMaterialProperty","./CompositePositionProperty","./CompositeProperty","./ConstantPositionProperty","./ConstantProperty","./DynamicBillboard","./DynamicClock","./ColorMaterialProperty","./PolylineOutlineMaterialProperty","./DynamicCone","./DynamicLabel","./DynamicDirectionsProperty","./DynamicEllipse","./DynamicEllipsoid","./GridMaterialProperty","./ImageMaterialProperty","./DynamicObject","./DynamicObjectCollection","./DynamicPath","./DynamicPoint","./DynamicPolyline","./DynamicPolygon","./DynamicPyramid","./DynamicVector","./DynamicVertexPositionsProperty","./SampledPositionProperty","./SampledProperty","./TimeIntervalCollectionPositionProperty","./TimeIntervalCollectionProperty","../ThirdParty/Uri","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E,b,T,A,D,P,M,I,O,R,L,z,N,B,F,V,k,U,W,q,G,H,j,Y,X,Z,J,K,Q,$,et,tt,rt,it,nt,ot){"use strict";function at(e){var t=e.rgbaf;if(l(t))return t;var r=e.rgba;if(!l(r))return void 0;if(r.length===i.length)return[i.byteToFloat(r[0]),i.byteToFloat(r[1]),i.byteToFloat(r[2]),i.byteToFloat(r[3])];var n=r.length;t=new Array(n);for(var o=0;n>o;o+=5)t[o]=r[o],t[o+1]=i.byteToFloat(r[o+1]),t[o+2]=i.byteToFloat(r[o+2]),t[o+3]=i.byteToFloat(r[o+3]),t[o+4]=i.byteToFloat(r[o+4]);return t}function st(e,t){var r=s(e.image,e);if(l(t)){var i=new nt(document.location.href);t=new nt(t),r=new nt(r).resolve(t.resolve(i)).toString()}return r}function lt(e){if(l(e.cartesian))return e.cartesian;if(l(e.unitCartesian))return e.unitCartesian;var r,i,n,o=e.unitSpherical;if(l(o)){if(i=o.length,2===i)Vt.clock=o[0],Vt.cone=o[1],t.fromSpherical(Vt,Ft),n=[Ft.x,Ft.y,Ft.z];else{var a=0;for(n=new Array(4*(i/3)),r=0;i>r;r+=4)n[r]=o[a++],Vt.clock=o[a++],Vt.cone=o[a++],t.fromSpherical(Vt,Ft),n[r+1]=Ft.x,n[r+2]=Ft.y,n[r+3]=Ft.z}return n}var s=e.cartographicRadians;if(l(s)){if(3===s.length)kt.longitude=s[0],kt.latitude=s[1],kt.height=s[2],c.WGS84.cartographicToCartesian(kt,Ft),n=[Ft.x,Ft.y,Ft.z];else for(i=s.length,n=new Array(i),r=0;i>r;r+=4)kt.longitude=s[r+1],kt.latitude=s[r+2],kt.height=s[r+3],c.WGS84.cartographicToCartesian(kt,Ft),n[r]=s[r],n[r+1]=Ft.x,n[r+2]=Ft.y,n[r+3]=Ft.z;return n}var u=e.cartographicDegrees;if(!l(u))throw new x(JSON.stringify(e)+" is not a valid CZML interval.");if(3===u.length)kt.longitude=_.toRadians(u[0]),kt.latitude=_.toRadians(u[1]),kt.height=u[2],c.WGS84.cartographicToCartesian(kt,Ft),n=[Ft.x,Ft.y,Ft.z];else for(i=u.length,n=new Array(i),r=0;i>r;r+=4)kt.longitude=_.toRadians(u[r+1]),kt.latitude=_.toRadians(u[r+2]),kt.height=u[r+3],c.WGS84.cartographicToCartesian(kt,Ft),n[r]=u[r],n[r+1]=Ft.x,n[r+2]=Ft.y,n[r+3]=Ft.z;return n}function ut(r,n,o){switch(r){case Boolean:return s(n["boolean"],n);case e:return n.cartesian2;case t:return lt(n);case i:return at(n);case T:return T[s(n.horizontalOrigin,n)];case Image:return st(n,o);case f:return f.fromIso8601(s(n.date,n));case A:return A[s(n.labelStyle,n)];case Number:return s(n.number,n);case String:return s(n.string,n);case Array:return n.array;case w:var a=n.unitQuaternion;if(l(a)){if(4===a.length)return[-a[0],-a[1],-a[2],a[3]];a=a.slice(0);for(var c=0;c<a.length;c+=5)a[c+1]=-a[c+1],a[c+2]=-a[c+2],a[c+3]=-a[c+3]}return a;case D:return D[s(n.verticalOrigin,n)];default:throw new u(r)}}function ct(e,t){var r=Ut[e.interpolationAlgorithm];l(r)&&(t.interpolationAlgorithm=r),l(e.interpolationDegree)&&(t.interpolationDegree=e.interpolationDegree)}function ht(e,t,r,i,n,o){var a,u=i.interval;l(u)?(a=E.fromIso8601(u),l(n)&&(a=a.intersect(n))):l(n)&&(a=n);var c=ut(e,i,o),h=l(a)&&!a.equals(p.MAXIMUM_INTERVAL),d=s(e.packedLength,1),m=s(c.length,1),v=!l(i.array)&&"string"!=typeof c&&m>d;if(!v&&!h)return t[r]=l(e.unpack)?new R(e.unpack(c,0)):new R(c),!0;var y=!1,g=t[r];if(v&&!h){g instanceof tt||(g=new tt(e),t[r]=g,y=!0);var _,w=i.epoch;return l(w)&&(_=f.fromIso8601(w)),g.addSamplesPackedArray(c,_),ct(i,g),y}var C;if(!v&&h)return a=a.clone(),a.data=l(e.unpack)?e.unpack(c,0):c,l(g)||(g=new it,t[r]=g,y=!0),g instanceof it?g.intervals.addInterval(a):g instanceof I?(a.data=new R(a.data),g.intervals.addInterval(a)):(C=p.MAXIMUM_INTERVAL.clone(),C.data=g,y=!0,g=new I,t[r]=g,g.intervals.addInterval(C),a.data=new R(a.data),g.intervals.addInterval(a)),y;l(g)||(y=!0,g=new I,t[r]=g),g instanceof I||(C=p.MAXIMUM_INTERVAL.clone(),C.data=g,y=!0,g=new I,t[r]=g,g.intervals.addInterval(C));var x=g.intervals;return C=x.findInterval(a.start,a.stop,a.isStartIncluded,a.isStopIncluded),l(C)&&C.data instanceof tt||(C=a.clone(),C.data=new tt(e),x.addInterval(C)),C.data.addSamplesPackedArray(c,f.fromIso8601(i.epoch)),ct(i,C.data),y}function dt(e,t,r,i,n,o){if(l(i))if(Array.isArray(i))for(var a=0,s=i.length;s>a;a++)ht(e,t,r,i[a],n,o);else ht(e,t,r,i,n,o)}function mt(e,r,i,n){var o,a=i.interval;l(a)?(o=E.fromIso8601(a),l(n)&&(o=o.intersect(n))):l(n)&&(o=n);var u=C[s(i.referenceFrame,"FIXED")],c=lt(i),h=l(o)&&!o.equals(p.MAXIMUM_INTERVAL),d=t.packedLength,m=s(c.length,1),v="string"!=typeof c&&m>d;if(!v&&!h)return e[r]=new O(t.unpack(c),u),!0;var y=!1,g=e[r];if(v&&!h){g instanceof et&&g.referenceFrame===u||(g=new et(u),e[r]=g,y=!0);var _,w=i.epoch;return l(w)&&(_=f.fromIso8601(w)),g.addSamplesPackedArray(c,_),ct(i,g),y}var x;if(!v&&h)return o=o.clone(),o.data=t.unpack(c),l(g)||(g=new rt(u),e[r]=g,y=!0),g instanceof rt&&g.referenceFrame===u?g.intervals.addInterval(o):g instanceof M?(o.data=new O(o.data,u),g.intervals.addInterval(o)):(x=p.MAXIMUM_INTERVAL.clone(),x.data=g,y=!0,g=new M(g.referenceFrame),e[r]=g,g.intervals.addInterval(x),o.data=new O(o.data,u),g.intervals.addInterval(o)),y;l(g)?g instanceof M||(x=p.MAXIMUM_INTERVAL.clone(),x.data=g,y=!0,g=new M(g.referenceFrame),e[r]=g,g.intervals.addInterval(x)):(y=!0,g=new M(u),e[r]=g);var S=g.intervals;return x=S.findInterval(o.start,o.stop,o.isStartIncluded,o.isStopIncluded),l(x)&&x.data instanceof et&&x.data.referenceFrame===u||(x=o.clone(),x.data=new et(u),S.addInterval(x)),x.data.addSamplesPackedArray(c,f.fromIso8601(i.epoch)),ct(i,x.data),y}function pt(e,t,r,i,n){if(l(r))if(Array.isArray(r))for(var o=0,a=r.length;a>o;o++)mt(e,t,r[o],i,n);else mt(e,t,r,i,n)}function ft(e,t,r){return l(t)||l(r)?(e instanceof Wt||(e=new Wt),dt(Number,e,"_x",t),dt(Number,e,"_y",r),e):e}function vt(e,t,r,n,o){var a,u=r.interval;l(u)?(a=E.fromIso8601(u),l(n)&&(a=a.intersect(n))):l(n)&&(a=n),a=s(a,p.MAXIMUM_INTERVAL);var c=!1,h=e[t];l(h)||(h=new P,e[t]=h,c=!0);var d,m=h.intervals,f=m.findInterval(a.start,a.stop);l(f)?d=f.data:(f=a.clone(),m.addInterval(f));var v;return l(r.solidColor)?(d instanceof N||(d=new N),v=r.solidColor,dt(i,d,"color",v.color)):l(r.grid)?(d instanceof q||(d=new q),v=r.grid,dt(i,d,"color",v.color,void 0,o),dt(Number,d,"cellAlpha",v.cellAlpha,void 0,o),d.lineThickness=ft(d.lineThickness,v.rowThickness,v.columnThickness),d.lineCount=ft(d.lineCount,v.rowCount,v.columnCount)):l(r.image)&&(d instanceof G||(d=new G),v=r.image,dt(Image,d,"image",v.image,void 0,o),d.repeat=ft(d.repeat,v.horizontalRepeat,v.verticalRepeat)),f.data=d,c}function yt(e,t,r,i,n){if(l(r))if(Array.isArray(r))for(var o=0,a=r.length;a>o;o++)vt(e,t,r[o],i,n);else vt(e,t,r,i,n)}function gt(e,t){e.name=s(t.name,e.name)}function _t(e,t,r,i){var n=t.position;l(n)&&pt(e,"position",n,void 0,i)}function wt(e,r,i,n){var o=r.viewFrom;l(o)&&dt(t,e,"viewFrom",o,void 0,n)}function Ct(e,t,r,i){var n=t.orientation;l(n)&&dt(w,e,"orientation",n,void 0,i)}function xt(e,t,r){var i=t.vertexPositions;if(l(i)){var n=e.vertexPositions;l(n)||(e.vertexPositions=n=new $),n.processCzmlIntervals(i,void 0,r)}}function St(e,t){var r,i=t.availability;if(l(i)){var n;if(Array.isArray(i))for(var o=i.length,a=0;o>a;a++)l(n)||(n=new b),r=E.fromIso8601(i[a]),n.addInterval(r);else r=E.fromIso8601(i),n=new b,n.addInterval(r);e.availability=n}}function Et(r,n,o,a){var s=n.billboard;if(l(s)){var u=s.interval;l(u)&&(u=E.fromIso8601(u));var c=r.billboard;l(c)||(r.billboard=c=new L),dt(i,c,"color",s.color,u,a),dt(t,c,"eyeOffset",s.eyeOffset,u,a),dt(T,c,"horizontalOrigin",s.horizontalOrigin,u,a),dt(Image,c,"image",s.image,u,a),dt(e,c,"pixelOffset",s.pixelOffset,u,a),dt(Number,c,"scale",s.scale,u,a),dt(Number,c,"rotation",s.rotation,u,a),dt(t,c,"alignedAxis",s.alignedAxis,u,a),dt(Boolean,c,"show",s.show,u,a),dt(D,c,"verticalOrigin",s.verticalOrigin,u,a)}}function bt(e,t){var r=t.clock;if(l(r)&&"document"===e.id){var i=e.clock;if(l(i)||(i=new z,i.startTime=p.MAXIMUM_INTERVAL.start,i.stopTime=p.MAXIMUM_INTERVAL.stop,i.clockRange=n.LOOP_STOP,i.clockStep=o.SYSTEM_CLOCK_MULTIPLIER,i.multiplier=1,e.clock=i),l(r.interval)){var a=E.fromIso8601(r.interval);i.startTime=a.start,i.stopTime=a.stop}l(r.currentTime)&&(i.currentTime=f.fromIso8601(r.currentTime)),l(r.range)&&(i.clockRange=n[r.range]),l(r.step)&&(i.clockStep=o[r.step]),l(r.multiplier)&&(i.multiplier=r.multiplier)}}function Tt(e,t,r,n){var o=t.cone;if(l(o)){var a=o.interval;l(a)&&(a=E.fromIso8601(a));var s=e.cone;l(s)||(e.cone=s=new F),dt(Boolean,s,"show",o.show,a,n),dt(Number,s,"radius",o.radius,a,n),dt(Boolean,s,"showIntersection",o.showIntersection,a,n),dt(i,s,"intersectionColor",o.intersectionColor,a,n),dt(Number,s,"intersectionWidth",o.intersectionWidth,a,n),dt(Number,s,"innerHalfAngle",o.innerHalfAngle,a,n),dt(Number,s,"outerHalfAngle",o.outerHalfAngle,a,n),dt(Number,s,"minimumClockAngle",o.minimumClockAngle,a,n),dt(Number,s,"maximumClockAngle",o.maximumClockAngle,a,n),yt(s,"capMaterial",o.capMaterial,a,n),yt(s,"innerMaterial",o.innerMaterial,a,n),yt(s,"outerMaterial",o.outerMaterial,a,n),yt(s,"silhouetteMaterial",o.silhouetteMaterial,a,n)}}function At(e,t,r,i){var n=t.ellipse;if(l(n)){var o=n.interval;l(o)&&(o=E.fromIso8601(o));var a=e.ellipse;l(a)||(e.ellipse=a=new U),dt(Number,a,"rotation",n.rotation,o,i),dt(Number,a,"semiMajorAxis",n.semiMajorAxis,o,i),dt(Number,a,"semiMinorAxis",n.semiMinorAxis,o,i)}}function Dt(e,r,i,n){var o=r.ellipsoid;if(l(o)){var a=o.interval;l(a)&&(a=E.fromIso8601(a));var s=e.ellipsoid;l(s)||(e.ellipsoid=s=new W),dt(Boolean,s,"show",o.show,a,n),dt(t,s,"radii",o.radii,a,n),yt(s,"material",o.material,a,n)}}function Pt(r,n,o,a){var s=n.label;if(l(s)){var u=s.interval;l(u)&&(u=E.fromIso8601(u));var c=r.label;l(c)||(r.label=c=new V),dt(i,c,"fillColor",s.fillColor,u,a),dt(i,c,"outlineColor",s.outlineColor,u,a),dt(Number,c,"outlineWidth",s.outlineWidth,u,a),dt(t,c,"eyeOffset",s.eyeOffset,u,a),dt(T,c,"horizontalOrigin",s.horizontalOrigin,u,a),dt(String,c,"text",s.text,u,a),dt(e,c,"pixelOffset",s.pixelOffset,u,a),dt(Number,c,"scale",s.scale,u,a),dt(Boolean,c,"show",s.show,u,a),dt(D,c,"verticalOrigin",s.verticalOrigin,u,a),dt(String,c,"font",s.font,u,a),dt(A,c,"style",s.style,u,a)}}function Mt(e,t,r,n){var o=t.path;if(l(o)){var a=o.interval;l(a)&&(a=E.fromIso8601(a));var s=e.path;l(s)||(e.path=s=new Y),dt(i,s,"color",o.color,a,n),dt(Number,s,"width",o.width,a,n),dt(i,s,"outlineColor",o.outlineColor,a,n),dt(Number,s,"outlineWidth",o.outlineWidth,a,n),dt(Boolean,s,"show",o.show,a,n),dt(Number,s,"resolution",o.resolution,a,n),dt(Number,s,"leadTime",o.leadTime,a,n),dt(Number,s,"trailTime",o.trailTime,a,n)}}function It(e,t,r,n){var o=t.point;if(l(o)){var a=o.interval;l(a)&&(a=E.fromIso8601(a));var s=e.point;l(s)||(e.point=s=new X),dt(i,s,"color",o.color,a,n),dt(Number,s,"pixelSize",o.pixelSize,a,n),dt(i,s,"outlineColor",o.outlineColor,a,n),dt(Number,s,"outlineWidth",o.outlineWidth,a,n),dt(Boolean,s,"show",o.show,a,n)}}function Ot(e,t,r,i){var n=t.polygon;if(l(n)){var o=n.interval;l(o)&&(o=E.fromIso8601(o));var a=e.polygon;l(a)||(e.polygon=a=new J),dt(Boolean,a,"show",n.show,o,i),yt(a,"material",n.material,o,i)}}function Rt(e,t,r,n){var o=t.polyline;if(l(o)){var a=o.interval;l(a)&&(a=E.fromIso8601(a));var s=e.polyline;l(s)||(e.polyline=s=new Z);var u=s.material;if(l(a)){var c,h=u;h instanceof P||(h=new P,s.material=h,l(u)&&(c=p.MAXIMUM_INTERVAL.clone(),c.data=u,h.intervals.addInterval(c))),c=h.intervals.findInterval(a.start,a.stop,a.isStartIncluded,a.isStopIncluded),l(c)?u=c.data:(u=new B,c=a.clone(),c.data=u,h.intervals.addInterval(c))}else u instanceof B||(u=new B,s.material=u);dt(Boolean,s,"show",o.show,a,n),dt(Number,s,"width",o.width,a,n),dt(i,u,"color",o.color,a,n),dt(i,u,"outlineColor",o.outlineColor,a,n),dt(Number,u,"outlineWidth",o.outlineWidth,a,n)}}function Lt(e,t,r,n){var o=t.pyramid;if(l(o)){var a=o.interval;l(a)&&(a=E.fromIso8601(a));var s=e.pyramid;if(l(s)||(e.pyramid=s=new K),dt(Boolean,s,"show",o.show,a,n),dt(Number,s,"radius",o.radius,a,n),dt(Boolean,s,"showIntersection",o.showIntersection,a,n),dt(i,s,"intersectionColor",o.intersectionColor,a,n),dt(Number,s,"intersectionWidth",o.intersectionWidth,a,n),yt(s,"material",o.material,a,n),l(o.directions)){var u=s.directions;l(u)||(s.directions=u=new k),u.processCzmlIntervals(o.directions,a)}}}function zt(e,r,n,o){var a=r.vector;if(l(a)){var s=a.interval;l(s)&&(s=E.fromIso8601(s));var u=e.vector;l(u)||(e.vector=u=new Q),dt(i,u,"color",a.color,s,o),dt(Boolean,u,"show",a.show,s,o),dt(Number,u,"width",a.width,s,o),dt(t,u,"direction",a.direction,s,o),dt(Number,u,"length",a.length,s,o)}}function Nt(e,t,r,i,n){var o=e.id;if(l(o)||(o=a()),e["delete"]===!0)t.removeById(o);else{var s;s="document"===o?n._document:t.getOrCreateObject(o);var u=e.parent;l(u)&&(s.parent=t.getOrCreateObject(u));for(var c=r.length-1;c>-1;c--)r[c](s,e,t,i)}}function Bt(e,t,r){var i=e._dynamicObjectCollection;qt._processCzml(t,i,r,void 0,e);var a,s=i.computeAvailability(),u=e._document;if(l(u)&&l(u.clock))a=new z,a.startTime=u.clock.startTime,a.stopTime=u.clock.stopTime,a.clockRange=u.clock.clockRange,a.clockStep=u.clock.clockStep,a.multiplier=u.clock.multiplier,a.currentTime=u.clock.currentTime;else if(!s.start.equals(p.MINIMUM_VALUE)){a=new z,a.startTime=s.start,a.stopTime=s.stop,a.clockRange=n.LOOP_STOP;var c=a.startTime.getSecondsDifference(a.stopTime),h=Math.round(c/120);a.multiplier=h,a.currentTime=a.startTime,a.clockStep=o.SYSTEM_CLOCK_MULTIPLIER}var m;return l(u)&&l(u.name)&&(m=u.name),!l(m)&&l(r)&&(m=d(r)),e._name=m,a}var Ft=new t,Vt=new S,kt=new r,Ut={HERMITE:m,LAGRANGE:v,LINEAR:y},Wt=function(){this._x=new R(0),this._y=new R(0)};Wt.prototype.getValue=function(t,r){return l(r)||(r=new e),r.x=this._x.getValue(t),r.y=this._y.getValue(t),r};var qt=function(e){this._name=e,this._changed=new h,this._error=new h,this._clock=void 0,this._dynamicObjectCollection=new j,this._timeVarying=!0,this._document=new H};return qt.updaters=[bt,Et,At,Dt,Tt,Pt,gt,Mt,It,Ot,Rt,Lt,zt,_t,wt,Ct,xt,St],qt.prototype.getName=function(){return this._name},qt.prototype.getChangedEvent=function(){return this._changed},qt.prototype.getErrorEvent=function(){return this._error},qt.prototype.getClock=function(){return this._clock},qt.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},qt.prototype.getIsTimeVarying=function(){return this._timeVarying},qt.prototype.process=function(e,t){if(!l(e))throw new u("czml is required.");this._clock=Bt(this,e,t)},qt.prototype.load=function(e,t){if(!l(e))throw new u("czml is required.");this._document=new H("document"),this._dynamicObjectCollection.removeAll(),this._clock=Bt(this,e,t)},qt.prototype.processUrl=function(e){if(!l(e))throw new u("url is required.");var t=this;return ot(g(e),function(r){t.process(r,e)},function(e){return t._error.raiseEvent(t,e),ot.reject(e)})},qt.prototype.loadUrl=function(e){if(!l(e))throw new u("url is required.");var t=this;return ot(g(e),function(r){t.load(r,e)},function(e){return t._error.raiseEvent(t,e),ot.reject(e)})},qt.processPacketData=dt,qt.processPositionPacketData=pt,qt.processMaterialPacketData=yt,qt._processCzml=function(e,t,r,i,n){if(i=l(i)?i:qt.updaters,Array.isArray(e))for(var o=0,a=e.length;a>o;o++)Nt(e[o],t,i,r,n);else Nt(e,t,i,r,n)},qt}),r("DynamicScene/DataSource",["../Core/DeveloperError"],function(e){"use strict";function t(){throw new e("This type should not be instantiated directly.")}var r=t;return r.prototype.getName=t,r.prototype.getChangedEvent=t,r.prototype.getErrorEvent=t,r.prototype.getClock=t,r.prototype.getDynamicObjectCollection=t,r.prototype.getIsTimeVarying=t,r}),r("DynamicScene/DataSourceCollection",["../Core/DeveloperError","../Core/defined","../Core/destroyObject","../Core/Event"],function(e,t,r,i){"use strict";var n=function(){this._dataSources=[],this.dataSourceAdded=new i,this.dataSourceRemoved=new i};return n.prototype.add=function(r){if(!t(r))throw new e("dataSource is required.");this._dataSources.push(r),this.dataSourceAdded.raiseEvent(this,r)},n.prototype.remove=function(e,t){var r=this._dataSources.indexOf(e);return-1!==r?(this._dataSources.splice(r,1),this.dataSourceRemoved.raiseEvent(this,e),"function"==typeof e.destroy&&t&&e.destroy(),!0):!1},n.prototype.removeAll=function(e){for(var t=this._dataSources,r=t.length-1;r>=0;r--)this.remove(t[r],e)},n.prototype.contains=function(e){return-1!==this.indexOf(e)},n.prototype.indexOf=function(e){return this._dataSources.indexOf(e)},n.prototype.get=function(r){if(!t(r))throw new e("index is required.");return this._dataSources[r]},n.prototype.getLength=function(){return this._dataSources.length},n.prototype.isDestroyed=function(){return!1},n.prototype.destroy=function(){return this.removeAll(!0),r(this)},n}),r("Renderer/BlendEquation",["../Core/Enumeration"],function(e){"use strict";var t={ADD:new e(32774,"ADD"),SUBTRACT:new e(32778,"SUBTRACT"),REVERSE_SUBTRACT:new e(32779,"REVERSE_SUBTRACT"),validate:function(e){return e===t.ADD||e===t.SUBTRACT||e===t.REVERSE_SUBTRACT}};return t}),r("Renderer/BlendFunction",["../Core/Enumeration"],function(e){"use strict";var t={ZERO:new e(0,"ZERO"),ONE:new e(1,"ONE"),SOURCE_COLOR:new e(768,"SOURCE_COLOR"),ONE_MINUS_SOURCE_COLOR:new e(769,"ONE_MINUS_SOURCE_COLOR"),DESTINATION_COLOR:new e(774,"DESTINATION_COLOR"),ONE_MINUS_DESTINATION_COLOR:new e(775,"ONE_MINUS_DESTINATION_COLOR"),SOURCE_ALPHA:new e(770,"SOURCE_ALPHA"),ONE_MINUS_SOURCE_ALPHA:new e(771,"ONE_MINUS_SOURCE_ALPHA"),DESTINATION_ALPHA:new e(772,"DESTINATION_ALPHA"),ONE_MINUS_DESTINATION_ALPHA:new e(773,"ONE_MINUS_DESTINATION_ALPHA"),CONSTANT_COLOR:new e(32769,"CONSTANT_COLOR"),ONE_MINUS_CONSTANT_COLOR:new e(32770,"ONE_MINUS_CONSTANT_COLOR"),CONSTANT_ALPHA:new e(32771,"CONSTANT_ALPHA"),ONE_MINUS_CONSTANT_ALPHA:new e(32772,"ONE_MINUS_CONSTANT_ALPHA"),SOURCE_ALPHA_SATURATE:new e(776,"SOURCE_ALPHA_SATURATE"),validate:function(e){return e===t.ZERO||e===t.ONE||e===t.SOURCE_COLOR||e===t.ONE_MINUS_SOURCE_COLOR||e===t.DESTINATION_COLOR||e===t.ONE_MINUS_DESTINATION_COLOR||e===t.SOURCE_ALPHA||e===t.ONE_MINUS_SOURCE_ALPHA||e===t.DESTINATION_ALPHA||e===t.ONE_MINUS_DESTINATION_ALPHA||e===t.CONSTANT_COLOR||e===t.ONE_MINUS_CONSTANT_COLOR||e===t.CONSTANT_ALPHA||e===t.ONE_MINUS_CONSTANT_ALPHA||e===t.SOURCE_ALPHA_SATURATE}};return t}),r("Renderer/BlendingState",["./BlendEquation","./BlendFunction"],function(e,t){"use strict";var r={DISABLED:{enabled:!1},ALPHA_BLEND:{enabled:!0,equationRgb:e.ADD,equationAlpha:e.ADD,functionSourceRgb:t.SOURCE_ALPHA,functionSourceAlpha:t.SOURCE_ALPHA,functionDestinationRgb:t.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:t.ONE_MINUS_SOURCE_ALPHA},PRE_MULTIPLIED_ALPHA_BLEND:{enabled:!0,equationRgb:e.ADD,equationAlpha:e.ADD,functionSourceRgb:t.ONE,functionSourceAlpha:t.ONE,functionDestinationRgb:t.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:t.ONE_MINUS_SOURCE_ALPHA},ADDITIVE_BLEND:{enabled:!0,equationRgb:e.ADD,equationAlpha:e.ADD,functionSourceRgb:t.SOURCE_ALPHA,functionSourceAlpha:t.SOURCE_ALPHA,functionDestinationRgb:t.ONE,functionDestinationAlpha:t.ONE}};return r}),r("Renderer/BufferUsage",["../Core/Enumeration"],function(e){"use strict";var t={STREAM_DRAW:new e(35040,"STREAM_DRAW"),STATIC_DRAW:new e(35044,"STATIC_DRAW"),DYNAMIC_DRAW:new e(35048,"DYNAMIC_DRAW"),validate:function(e){return e===t.STREAM_DRAW||e===t.STATIC_DRAW||e===t.DYNAMIC_DRAW}};return t}),r("Renderer/DrawCommand",[],function(){"use strict";var e=function(){this.boundingVolume=void 0,this.cull=!0,this.modelMatrix=void 0,this.primitiveType=void 0,this.vertexArray=void 0,this.count=void 0,this.offset=0,this.shaderProgram=void 0,this.uniformMap=void 0,this.renderState=void 0,this.framebuffer=void 0,this.pass=void 0,this.executeInClosestFrustum=!1,this.owner=void 0,this.debugShowBoundingVolume=!1,this.debugOverlappingFrustums=0};return e.prototype.execute=function(e,t){e.draw(this,t)},e}),r("Renderer/Pass",[],function(){"use strict";var e={OPAQUE:0,TRANSLUCENT:1,OVERLAY:2};return e}),r("Renderer/VertexArrayFacade",["../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Math","./BufferUsage"],function(e,t,r,i,n,o,a){"use strict";function s(e,t){if(t.needsCommit&&t.vertexSizeInBytes>0){t.needsCommit=!1;var i=t.vertexBuffer,n=e._size*t.vertexSizeInBytes,o=r(i);if(!o||i.getSizeInBytes()<n)return o&&i.destroy(),t.vertexBuffer=e._context.createVertexBuffer(t.arrayBuffer,t.usage),t.vertexBuffer.setVertexArrayDestroyable(!1),!0;t.vertexBuffer.copyFromArrayView(t.arrayBuffer)}return!1}function l(e,t,r){if(e.needsCommit&&e.vertexSizeInBytes>0){var i=e.vertexSizeInBytes*t,n=e.vertexSizeInBytes*r;e.vertexBuffer.copyFromArrayView(new Uint8Array(e.arrayBuffer,i,n),i)}}function u(e){var t=e.vaByPurpose;if(r(t)){for(var i in t)if(t.hasOwnProperty(i))for(var n=t[i],o=n.length,a=0;o>a;++a)n[a].va.destroy();e.vaByPurpose=void 0}}var c=function(e,t,i){function o(e,t){return t.componentDatatype.sizeInBytes-e.componentDatatype.sizeInBytes}if(!e)throw new n("context is required.");if(!t||0===t.length)throw new n("At least one attribute is required.");var s=c._verifyAttributes(t);i=i||0;for(var l,u,h,d,m={},p=[],f=s.length,v=0;f>v;++v){var y=s[v];y.vertexBuffer?p.push(y):(h=y.purpose,l=m[h],r(l)||(l=m[h]={}),d=y.usage.toString(),u=l[d],r(u)||(u=l[d]=[]),u.push(y))}this._buffersByPurposeAndUsage={},this._allBuffers=[];for(h in m)if(m.hasOwnProperty(h)){l=m[h];var g=this._buffersByPurposeAndUsage[h];r(g)||(g=this._buffersByPurposeAndUsage[h]={});for(d in l)if(l.hasOwnProperty(d)){u=l[d],u.sort(o);var _,w=c._vertexSizeInBytes(u);switch(d){case a.STATIC_DRAW.toString():_=a.STATIC_DRAW;break;case a.STREAM_DRAW.toString():_=a.STREAM_DRAW;break;case a.DYNAMIC_DRAW.toString():_=a.DYNAMIC_DRAW}var C={purpose:h,vertexSizeInBytes:w,vertexBuffer:void 0,usage:_,needsCommit:!1,arrayBuffer:void 0,arrayViews:c._createArrayViews(u,w)};g[d]=C,this._allBuffers.push(C)}}this._size=0,this._precreated=p,this._context=e,this.writers=void 0,this.vaByPurpose=void 0,this.resize(i)};c._verifyAttributes=function(i){for(var o=[],s=0;s<i.length;++s){var l=i[s],u={index:t(l.index,s),enabled:t(l.enabled,!0),componentsPerAttribute:l.componentsPerAttribute,componentDatatype:l.componentDatatype||e.FLOAT,normalize:l.normalize||!1,purpose:t(l.purpose,"all"),vertexBuffer:l.vertexBuffer,usage:l.usage||a.STATIC_DRAW};if(o.push(u),1!==u.componentsPerAttribute&&2!==u.componentsPerAttribute&&3!==u.componentsPerAttribute&&4!==u.componentsPerAttribute)throw new n("attribute.componentsPerAttribute must be in the range [1, 4].");
var c=u.componentDatatype;if(!e.validate(c))throw new n("Attribute must have a valid componentDatatype or not specify it.");if(!a.validate(u.usage))throw new n("Attribute must have a valid usage or not specify it.")}for(var h=new Array(o.length),d=0;d<o.length;++d){var m=o[d],p=m.index,f=m.purpose;if("all"!==f){var v=h[p];if(v===!0)throw new n("Index "+p+" is used by more than one attribute.");if(r(v)){if(v[f])throw new n("Index "+p+" is used by more than one attribute with the same purpose.")}else v=h[p]={};v[f]=!0}else{if(h[p])throw new n("Index "+p+" is used by more than one attribute.");h[p]=!0}}return o},c._vertexSizeInBytes=function(e){for(var t=0,r=e.length,i=0;r>i;++i){var n=e[i];t+=n.componentsPerAttribute*n.componentDatatype.sizeInBytes}var o=r>0?e[0].componentDatatype.sizeInBytes:0,a=o>0?t%o:0,s=0===a?0:o-a;return t+=s},c._createArrayViews=function(e,t){for(var r=[],i=0,n=e.length,o=0;n>o;++o){var a=e[o],s=a.componentDatatype;r.push({index:a.index,enabled:a.enabled,componentsPerAttribute:a.componentsPerAttribute,componentDatatype:s,normalize:a.normalize,offsetInBytes:i,vertexSizeInComponentType:t/s.sizeInBytes,view:void 0}),i+=a.componentsPerAttribute*s.sizeInBytes}return r},c.prototype.resize=function(e){this._size=e;var t=this._allBuffers;this.writers={};for(var i=0,n=t.length;n>i;++i){var o=t[i];c._resize(o,this._size);var a=this.writers[o.purpose];r(a)||(a=this.writers[o.purpose]=[]),c._appendWriters(a,o)}u(this)},c._resize=function(t,r){if(t.vertexSizeInBytes>0){var i=new ArrayBuffer(r*t.vertexSizeInBytes);if(t.arrayBuffer)for(var n=new Uint8Array(i),o=new Uint8Array(t.arrayBuffer),a=o.length,s=0;a>s;++s)n[s]=o[s];for(var l=t.arrayViews,u=l.length,c=0;u>c;++c){var h=l[c];h.view=e.createArrayBufferView(h.componentDatatype,i,h.offsetInBytes)}t.arrayBuffer=i}};var h=[function(e,t,r){return function(i,n){t[i*r]=n,e.needsCommit=!0}},function(e,t,r){return function(i,n,o){var a=i*r;t[a]=n,t[a+1]=o,e.needsCommit=!0}},function(e,t,r){return function(i,n,o,a){var s=i*r;t[s]=n,t[s+1]=o,t[s+2]=a,e.needsCommit=!0}},function(e,t,r){return function(i,n,o,a,s){var l=i*r;t[l]=n,t[l+1]=o,t[l+2]=a,t[l+3]=s,e.needsCommit=!0}}];return c._appendWriters=function(e,t){for(var r=t.arrayViews,i=r.length,n=0;i>n;++n){var o=r[n];e[o.index]=h[o.componentsPerAttribute-1](t,o.view,o.vertexSizeInComponentType)}},c.prototype.commit=function(e){for(var t,i=!1,n=this._allBuffers,a=0,l=n.length;l>a;++a)t=n[a],i=s(this,t)||i;if(i||!r(this.vaByPurpose)){var h=this._buffersByPurposeAndUsage;u(this),this.vaByPurpose={};for(var d in h)if(h.hasOwnProperty(d)){for(var m=h[d],p=[],f=Math.ceil(this._size/o.SIXTY_FOUR_KILOBYTES),v=0;f>v;++v){var y=[],g=h.all;if(g!==m)for(var _ in g)if(g.hasOwnProperty(_)){var w=g[_];c._appendAttributes(y,w,v*w.vertexSizeInBytes*o.SIXTY_FOUR_KILOBYTES)}for(var C in m)m.hasOwnProperty(C)&&(t=m[C],c._appendAttributes(y,t,v*t.vertexSizeInBytes*o.SIXTY_FOUR_KILOBYTES));y=y.concat(this._precreated),p.push({va:this._context.createVertexArray(y,e),indicesCount:1.5*(v!==f-1?o.SIXTY_FOUR_KILOBYTES:this._size%o.SIXTY_FOUR_KILOBYTES)})}this.vaByPurpose[d]=p}}},c._appendAttributes=function(e,t,r){for(var i=t.arrayViews,n=i.length,o=0;n>o;++o){var a=i[o];e.push({index:a.index,enabled:a.enabled,componentsPerAttribute:a.componentsPerAttribute,componentDatatype:a.componentDatatype,normalize:a.normalize,vertexBuffer:t.vertexBuffer,offsetInBytes:r+a.offsetInBytes,strideInBytes:t.vertexSizeInBytes})}},c.prototype.subCommit=function(e,t){if(0>e||e>=this._size)throw new n("offsetInVertices must be greater than or equal to zero and less than the vertex array size.");if(e+t>this._size)throw new n("offsetInVertices + lengthInVertices cannot exceed the vertex array size.");for(var r=this._allBuffers,i=0,o=r.length;o>i;++i)l(r[i],e,t)},c.prototype.endSubCommits=function(){for(var e=this._allBuffers,t=0,r=e.length;r>t;++t)e[t].needsCommit=!1},c.prototype.isDestroyed=function(){return!1},c.prototype.destroy=function(){for(var e=this._allBuffers,t=0,r=e.length;r>t;++t){var n=e[t];n.vertexBuffer=n.vertexBuffer&&n.vertexBuffer.destroy()}return u(this),i(this)},c}),r("Renderer/createShaderSource",["../Core/defaultValue","../Core/defined","../Core/DeveloperError"],function(e,t,r){"use strict";function i(i){i=e(i,e.EMPTY_OBJECT);var n=i.defines,o=i.sources,a=i.pickColorQualifier;if(t(a)&&"uniform"!==a&&"varying"!==a)throw new r("options.pickColorQualifier must be 'uniform' or 'varying'.");var s,l,u="";if(t(n)&&n.length>0)for(l=n.length,s=0;l>s;++s)0!==n[s].length&&(u+="#define "+n[s]+"\n");if(t(o)&&o.length>0)for(l=o.length,s=0;l>s;++s)u+="\n#line 0\n"+o[s];if(t(a)){var c=u.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,"void czm_old_main()"),h=a+" vec4 czm_pickColor; \n"+"void main() \n"+"{ \n"+"    czm_old_main(); \n"+"    if (gl_FragColor.a == 0.0) { \n"+"        discard; \n"+"    } \n"+"    gl_FragColor = czm_pickColor; \n"+"}";u=c+"\n"+h}return u}return i}),r("Scene/SceneMode",["../Core/Enumeration"],function(e){"use strict";var t={SCENE2D:new e(0,"SCENE2D",{morphTime:0}),COLUMBUS_VIEW:new e(1,"COLUMBUS_VIEW",{morphTime:0}),SCENE3D:new e(2,"SCENE3D",{morphTime:1}),MORPHING:new e(3,"MORPHING")};return t}),r("Scene/SceneTransforms",["../Core/defined","../Core/DeveloperError","../Core/Cartographic","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Matrix4","../Core/BoundingRectangle","../Core/Math","./SceneMode"],function(e,t,r,i,n,o,a,s,l,u){"use strict";var c={},h=new o(0,0,0,1),d=new o;c.wgs84ToWindowCoordinates=function(r,i,n){if(!e(r))throw new t("scene is required.");if(!e(i))throw new t("position is required.");if(c.computeActualWgs84Position(r.getFrameState(),i,h),!e(h))return n=void 0,void 0;var o=r.getUniformState().getViewProjection();return a.multiplyByVector(o,h,d),c.clipToWindowCoordinates(r.getContext(),d,n)},c.wgs84ToDrawingBufferCoordinates=function(r,i,n){if(!e(r))throw new t("scene is required.");if(!e(i))throw new t("position is required.");if(c.computeActualWgs84Position(r.getFrameState(),i,h),!e(h))return void 0;var s=r.getUniformState().getViewProjection();return a.multiplyByVector(s,o.fromElements(h.x,h.y,h.z,1,d),d),c.clipToDrawingBufferCoordinates(r.getContext(),d,n)};var m=new n,p=new r;c.computeActualWgs84Position=function(t,r,i){var o=t.mode;if(o===u.SCENE3D)return n.clone(r,i);var a=t.scene2D.projection;if(a.getEllipsoid().cartesianToCartographic(r,p),!e(p))return i=void 0;if(a.project(p,m),o===u.COLUMBUS_VIEW)return n.fromElements(m.z,m.x,m.y,i);if(o===u.SCENE2D)return n.fromElements(0,m.x,m.y,i);var s=t.morphTime;return n.fromElements(l.lerp(m.z,r.x,s),l.lerp(m.x,r.y,s),l.lerp(m.y,r.z,s),i)};var f=new n,v=new n,y=new s,g=new a;return c.clipToWindowCoordinates=function(e,t,r){var o=e.getCanvas();return n.divideByScalar(t,t.w,f),y.width=o.clientWidth,y.height=o.clientHeight,a.computeViewportTransformation(y,0,1,g),a.multiplyByPoint(g,f,v),i.fromCartesian3(v,r)},c.clipToDrawingBufferCoordinates=function(e,t,r){return n.divideByScalar(t,t.w,f),y.width=e.getDrawingBufferWidth(),y.height=e.getDrawingBufferHeight(),a.computeViewportTransformation(y,0,1,g),a.multiplyByPoint(g,f,v),i.fromCartesian3(v,r)},c.transformWindowToDrawingBuffer=function(e,t,r){var n=e.getCanvas(),o=e.getDrawingBufferWidth()/n.clientWidth,a=e.getDrawingBufferHeight()/n.clientHeight;return i.fromElements(t.x*o,t.y*a,r)},c}),r("Scene/Billboard",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Color","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/NearFarScalar","../Core/Matrix4","./HorizontalOrigin","./VerticalOrigin","./SceneMode","./SceneTransforms"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function m(e,r){var i=e._billboardCollection;t(i)&&(i._updateBillboard(e,r),e._dirty=!0)}var p={},f=function(a,s){if(a=e(a,p),t(a.scaleByDistance)&&a.scaleByDistance.far<=a.scaleByDistance.near)throw new r("scaleByDistance.far must be greater than scaleByDistance.near.");if(t(a.translucencyByDistance)&&a.translucencyByDistance.far<=a.translucencyByDistance.near)throw new r("translucencyByDistance.far must be greater than translucencyByDistance.near.");if(t(a.pixelOffsetScaleByDistance)&&a.pixelOffsetScaleByDistance.far<=a.pixelOffsetScaleByDistance.near)throw new r("pixelOffsetScaleByDistance.far must be greater than pixelOffsetScaleByDistance.near.");this._show=e(a.show,!0),this._position=o.clone(e(a.position,o.ZERO)),this._actualPosition=o.clone(this._position),this._pixelOffset=n.clone(e(a.pixelOffset,n.ZERO)),this._translate=new n(0,0),this._eyeOffset=o.clone(e(a.eyeOffset,o.ZERO)),this._verticalOrigin=e(a.verticalOrigin,c.CENTER),this._horizontalOrigin=e(a.horizontalOrigin,u.CENTER),this._scale=e(a.scale,1),this._imageIndex=e(a.imageIndex,-1),this._color=i.clone(e(a.color,i.WHITE)),this._rotation=e(a.rotation,0),this._alignedAxis=o.clone(e(a.alignedAxis,o.ZERO)),this._width=a.width,this._height=a.height,this._scaleByDistance=a.scaleByDistance,this._translucencyByDistance=a.translucencyByDistance,this._pixelOffsetScaleByDistance=a.pixelOffsetScaleByDistance,this._id=a.id,this._pickId=void 0,this._pickIdThis=a._pickIdThis,this._billboardCollection=s,this._dirty=!1,this._index=-1},v=f.SHOW_INDEX=0,y=f.POSITION_INDEX=1,g=f.PIXEL_OFFSET_INDEX=2,_=f.EYE_OFFSET_INDEX=3,w=f.HORIZONTAL_ORIGIN_INDEX=4,C=f.VERTICAL_ORIGIN_INDEX=5,x=f.SCALE_INDEX=6,S=f.IMAGE_INDEX_INDEX=7,E=f.COLOR_INDEX=8,b=f.ROTATION_INDEX=9,T=f.ALIGNED_AXIS_INDEX=10,A=f.SCALE_BY_DISTANCE_INDEX=11,D=f.TRANSLUCENCY_BY_DISTANCE_INDEX=12,P=f.PIXEL_OFFSET_SCALE_BY_DISTANCE_INDEX=13;f.NUMBER_OF_PROPERTIES=14,f.prototype.getPickId=function(r){return t(this._pickId)||(this._pickId=r.createPickId({primitive:e(this._pickIdThis,this),id:this._id})),this._pickId},f.prototype.getShow=function(){return this._show},f.prototype.setShow=function(e){if(!t(e))throw new r("value is required.");e!==this._show&&(this._show=e,m(this,v))},f.prototype.getPosition=function(){return this._position},f.prototype.setPosition=function(e){if(!t(e))throw new r("value is required.");var i=this._position;o.equals(i,e)||(o.clone(e,i),o.clone(e,this._actualPosition),m(this,y))},f.prototype._getActualPosition=function(){return this._actualPosition},f.prototype._setActualPosition=function(e){o.clone(e,this._actualPosition),m(this,y)},f.prototype.getPixelOffset=function(){return this._pixelOffset},f.prototype.setPixelOffset=function(e){if(!t(e))throw new r("value is required.");var i=this._pixelOffset;n.equals(i,e)||(n.clone(e,i),m(this,g))},f.prototype._setTranslate=function(e){if(!t(e))throw new r("value is required.");var i=this._translate;n.equals(i,e)||(n.clone(e,i),m(this,g))},f.prototype.getScaleByDistance=function(){return this._scaleByDistance},f.prototype.setScaleByDistance=function(e){if(!s.equals(this._scaleByDistance,e)){if(e.far<=e.near)throw new r("far distance must be greater than near distance.");m(this,A),this._scaleByDistance=s.clone(e,this._scaleByDistance)}},f.prototype.getTranslucencyByDistance=function(){return this._translucencyByDistance},f.prototype.setTranslucencyByDistance=function(e){if(!s.equals(this._translucencyByDistance,e)){if(e.far<=e.near)throw new r("far distance must be greater than near distance.");m(this,D),this._translucencyByDistance=s.clone(e,this._translucencyByDistance)}},f.prototype.getPixelOffsetScaleByDistance=function(){return this._pixelOffsetScaleByDistance},f.prototype.setPixelOffsetScaleByDistance=function(e){if(!s.equals(this._pixelOffsetScaleByDistance,e)){if(e.far<=e.near)throw new r("far distance must be greater than near distance.");m(this,P),this._pixelOffsetScaleByDistance=s.clone(e,this._pixelOffsetScaleByDistance)}},f.prototype.getEyeOffset=function(){return this._eyeOffset},f.prototype.setEyeOffset=function(e){if(!t(e))throw new r("value is required.");var i=this._eyeOffset;o.equals(i,e)||(o.clone(e,i),m(this,_))},f.prototype.getHorizontalOrigin=function(){return this._horizontalOrigin},f.prototype.setHorizontalOrigin=function(e){if(!t(e))throw new r("value is required.");this._horizontalOrigin!==e&&(this._horizontalOrigin=e,m(this,w))},f.prototype.getVerticalOrigin=function(){return this._verticalOrigin},f.prototype.setVerticalOrigin=function(e){if(!t(e))throw new r("value is required.");this._verticalOrigin!==e&&(this._verticalOrigin=e,m(this,C))},f.prototype.getScale=function(){return this._scale},f.prototype.setScale=function(e){if(!t(e))throw new r("value is required.");this._scale!==e&&(this._scale=e,m(this,x))},f.prototype.getImageIndex=function(){return this._imageIndex},f.prototype.setImageIndex=function(e){if("number"!=typeof e)throw new r("value is required and must be a number.");this._imageIndex!==e&&(this._imageIndex=e,m(this,S))},f.prototype.getColor=function(){return this._color},f.prototype.setColor=function(e){if(!t(e))throw new r("value is required.");var n=this._color;i.equals(n,e)||(i.clone(e,n),m(this,E))},f.prototype.getRotation=function(){return this._rotation},f.prototype.setRotation=function(e){if(!t(e))throw new r("value is required.");this._rotation!==e&&(this._rotation=e,m(this,b))},f.prototype.getAlignedAxis=function(){return this._alignedAxis},f.prototype.setAlignedAxis=function(e){if(!t(e))throw new r("value is required.");var i=this._alignedAxis;o.equals(i,e)||(o.clone(e,i),m(this,T))},f.prototype.getWidth=function(){return this._width},f.prototype.setWidth=function(e){this._width!==e&&(this._width=e,m(this,S))},f.prototype.getHeight=function(){return this._height},f.prototype.setHeight=function(e){this._height!==e&&(this._height=e,m(this,S))},f.prototype.getId=function(){return this._id};var M=new a;f._computeActualPosition=function(e,t,r){return t.mode===h.SCENE3D?e:(l.multiplyByPoint(r,e,M),d.computeActualWgs84Position(t,M))};var I=new l,O=new a,R=new o,L=new n;f._computeScreenSpacePosition=function(e,t,r,i,s,u){var c=u.camera,h=c.viewMatrix,m=c.frustum.projectionMatrix,p=l.multiplyTransformation(h,e,I),f=l.multiplyByVector(p,a.fromElements(t.x,t.y,t.z,1,O),O),v=o.multiplyComponents(r,o.normalize(f,R),R);f.x+=r.x+v.x,f.y+=r.y+v.y,f.z+=v.z;var y=l.multiplyByVector(m,f,O),g=d.clipToWindowCoordinates(s,y,new n),_=s.getUniformState(),w=n.multiplyByScalar(i,_.getHighResolutionSnapScale(),L);return g.x+=w.x,g.y+=w.y,g};var z=new n(0,0);return f.prototype.computeScreenSpacePosition=function(e,i){var o=this._billboardCollection;if(!t(o))throw new r("Billboard must be in a collection.  Was it removed?");if(!t(e))throw new r("context is required.");if(!t(i))throw new r("frameState is required.");n.clone(this._pixelOffset,z),n.add(z,this._translate,z);var a=o.modelMatrix;return f._computeScreenSpacePosition(a,this._actualPosition,this._eyeOffset,z,e,i)},f.prototype.equals=function(e){return this===e||t(e)&&this._show===e._show&&this._imageIndex===e._imageIndex&&this._scale===e._scale&&this._verticalOrigin===e._verticalOrigin&&this._horizontalOrigin===e._horizontalOrigin&&o.equals(this._position,e._position)&&i.equals(this._color,e._color)&&n.equals(this._pixelOffset,e._pixelOffset)&&n.equals(this._translate,e._translate)&&o.equals(this._eyeOffset,e._eyeOffset)&&s.equals(this._scaleByDistance,e._scaleByDistance)&&s.equals(this._translucencyByDistance,e._translucencyByDistance)&&s.equals(this._pixelOffsetScaleByDistance,e._pixelOffsetScaleByDistance)&&this._id===e._id},f.prototype._destroy=function(){this._pickId=this._pickId&&this._pickId.destroy(),this._billboardCollection=void 0},f}),r("Shaders/BillboardCollectionVS",[],function(){"use strict";return"attribute vec3 positionHigh;\nattribute vec3 positionLow;\nattribute vec2 direction;\nattribute vec4 textureCoordinatesAndImageSize;\nattribute vec3 originAndShow;\nattribute vec4 pixelOffsetAndTranslate;\nattribute vec4 eyeOffsetAndScale;\nattribute vec4 rotationAndAlignedAxis;\nattribute vec4 scaleByDistance;\nattribute vec4 translucencyByDistance;\nattribute vec4 pixelOffsetScaleByDistance;\n#ifdef RENDER_FOR_PICK\nattribute vec4 pickColor;\n#else\nattribute vec4 color;\n#endif\nconst vec2 czm_highResolutionSnapScale = vec2(1.0, 1.0);\nvarying vec2 v_textureCoordinates;\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#else\nvarying vec4 v_color;\n#endif\nfloat getNearFarScalar(vec4 nearFarScalar, float cameraDistSq)\n{\nfloat valueAtMin = nearFarScalar.y;\nfloat valueAtMax = nearFarScalar.w;\nfloat nearDistanceSq = nearFarScalar.x * nearFarScalar.x;\nfloat farDistanceSq = nearFarScalar.z * nearFarScalar.z;\ncameraDistSq = clamp(cameraDistSq, nearDistanceSq, farDistanceSq);\nfloat t = (cameraDistSq - nearDistanceSq) / (farDistanceSq - nearDistanceSq);\nt = pow(t, 0.15);\nreturn mix(valueAtMin, valueAtMax, t);\n}\nvoid main()\n{\nvec3 eyeOffset = eyeOffsetAndScale.xyz;\nfloat scale = eyeOffsetAndScale.w;\nvec2 textureCoordinates = textureCoordinatesAndImageSize.xy;\nvec2 imageSize = textureCoordinatesAndImageSize.zw;\nvec2 origin = originAndShow.xy;\nfloat show = originAndShow.z;\nvec2 pixelOffset = pixelOffsetAndTranslate.xy;\nvec2 translate = pixelOffsetAndTranslate.zw;\nvec4 p = czm_translateRelativeToEye(positionHigh, positionLow);\nvec4 positionEC = czm_modelViewRelativeToEye * p;\npositionEC = czm_eyeOffset(positionEC, eyeOffset);\npositionEC.xyz *= show;\n#if defined(EYE_DISTANCE_SCALING) || defined(EYE_DISTANCE_TRANSLUCENCY) || defined(EYE_DISTANCE_PIXEL_OFFSET)\nfloat lengthSq;\nif (czm_sceneMode == czm_sceneMode2D)\n{\nlengthSq = czm_eyeHeight2D.y;\n}\nelse\n{\nlengthSq = dot(positionEC.xyz, positionEC.xyz);\n}\n#endif\n#ifdef EYE_DISTANCE_SCALING\nscale *= getNearFarScalar(scaleByDistance, lengthSq);\nif (scale == 0.0)\n{\npositionEC.xyz = vec3(0.0);\n}\n#endif\nfloat translucency = 1.0;\n#ifdef EYE_DISTANCE_TRANSLUCENCY\ntranslucency = getNearFarScalar(translucencyByDistance, lengthSq);\nif (translucency == 0.0)\n{\npositionEC.xyz = vec3(0.0);\n}\n#endif\n#ifdef EYE_DISTANCE_PIXEL_OFFSET\nfloat pixelOffsetScale = getNearFarScalar(pixelOffsetScaleByDistance, lengthSq);\npixelOffset *= pixelOffsetScale;\n#endif\nvec4 positionWC = czm_eyeToWindowCoordinates(positionEC);\nvec2 halfSize = imageSize * scale * czm_highResolutionSnapScale;\nhalfSize *= ((direction * 2.0) - 1.0);\npositionWC.xy += (origin * abs(halfSize));\n#ifdef ROTATION\nfloat rotation = rotationAndAlignedAxis.x;\nvec3 alignedAxis = rotationAndAlignedAxis.yzw;\nif (!all(equal(rotationAndAlignedAxis, vec4(0.0))))\n{\nfloat angle = rotation;\nif (!all(equal(alignedAxis, vec3(0.0))))\n{\nvec3 pos = positionEC.xyz + czm_encodedCameraPositionMCHigh + czm_encodedCameraPositionMCLow;\nvec3 normal = normalize(cross(alignedAxis, pos));\nvec4 tangent = vec4(normalize(cross(pos, normal)), 0.0);\ntangent = czm_modelViewProjection * tangent;\nangle += sign(-tangent.x) * acos(tangent.y / length(tangent.xy));\n}\nfloat cosTheta = cos(angle);\nfloat sinTheta = sin(angle);\nmat2 rotationMatrix = mat2(cosTheta, sinTheta, -sinTheta, cosTheta);\nhalfSize = rotationMatrix * halfSize;\n}\n#endif\npositionWC.xy += halfSize;\npositionWC.xy += translate;\npositionWC.xy += (pixelOffset * czm_highResolutionSnapScale);\ngl_Position = czm_viewportOrthographic * vec4(positionWC.xy, -positionWC.z, 1.0);\nv_textureCoordinates = textureCoordinates;\n#ifdef RENDER_FOR_PICK\nv_pickColor = pickColor;\n#else\nv_color = color;\nv_color.a *= translucency;\n#endif\n}\n"}),r("Shaders/BillboardCollectionFS",[],function(){"use strict";return"uniform sampler2D u_atlas;\nvarying vec2 v_textureCoordinates;\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#else\nvarying vec4 v_color;\n#endif\nvoid main()\n{\n#ifdef RENDER_FOR_PICK\nvec4 vertexColor = vec4(1.0, 1.0, 1.0, 1.0);\n#else\nvec4 vertexColor = v_color;\n#endif\nvec4 color = texture2D(u_atlas, v_textureCoordinates) * vertexColor;\nif (color.a == 0.0)\n{\ndiscard;\n}\n#ifdef RENDER_FOR_PICK\ngl_FragColor = v_pickColor;\n#else\ngl_FragColor = color;\n#endif\n}\n"}),r("Scene/BillboardCollection",["../Core/defined","../Core/DeveloperError","../Core/Color","../Core/defaultValue","../Core/destroyObject","../Core/Cartesian2","../Core/Cartesian3","../Core/EncodedCartesian3","../Core/Matrix4","../Core/ComponentDatatype","../Core/IndexDatatype","../Core/PrimitiveType","../Core/BoundingSphere","../Renderer/BlendingState","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/Pass","../Renderer/VertexArrayFacade","../Renderer/createShaderSource","./SceneMode","./Billboard","./HorizontalOrigin","../Shaders/BillboardCollectionVS","../Shaders/BillboardCollectionFS"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S){"use strict";function E(e){if(e._billboardsRemoved){e._billboardsRemoved=!1;for(var t=[],r=e._billboards,i=r.length,n=0,o=0;i>n;++n){var a=r[n];a&&(a._index=o++,t.push(a))}e._billboards=t}}function b(t){var r=16384,i=t.cache.billboardCollection_directionsVertexBuffer;if(e(i))return i;for(var n=new Uint8Array(2*4*r),o=0,a=0;r>o;++o)n[a++]=0,n[a++]=0,n[a++]=255,n[a++]=0,n[a++]=255,n[a++]=255,n[a++]=0,n[a++]=255;return i=t.createVertexBuffer(n,p.STATIC_DRAW),i.setVertexArrayDestroyable(!1),t.cache.billboardCollection_directionsVertexBuffer=i,i}function T(t){var r=16384,i=t.cache.billboardCollection_indexBuffer;if(e(i))return i;for(var n=6*r,o=new Uint16Array(n),a=0,s=0;n>a;a+=6,s+=4)o[a]=s,o[a+1]=s+1,o[a+2]=s+2,o[a+3]=s+0,o[a+4]=s+2,o[a+5]=s+3;return i=t.createIndexBuffer(o,p.STATIC_DRAW,c.UNSIGNED_SHORT),i.setVertexArrayDestroyable(!1),t.cache.billboardCollection_indexBuffer=i,i}function A(e,t,r){var i=b(e);return new y(e,[{index:nt.positionHigh,componentsPerAttribute:3,componentDatatype:u.FLOAT,usage:r[G]},{index:nt.positionLow,componentsPerAttribute:3,componentDatatype:u.FLOAT,usage:r[G]},{index:nt.pixelOffsetAndTranslate,componentsPerAttribute:4,componentDatatype:u.FLOAT,usage:r[H]},{index:nt.eyeOffsetAndScale,componentsPerAttribute:4,componentDatatype:u.FLOAT,usage:r[Z]},{index:nt.textureCoordinatesAndImageSize,componentsPerAttribute:4,componentDatatype:u.FLOAT,usage:r[J]},{index:nt.pickColor,componentsPerAttribute:4,normalize:!0,componentDatatype:u.UNSIGNED_BYTE,usage:p.STATIC_DRAW,purpose:st},{index:nt.color,componentsPerAttribute:4,normalize:!0,componentDatatype:u.UNSIGNED_BYTE,usage:r[K],purpose:at},{index:nt.originAndShow,componentsPerAttribute:3,componentDatatype:u.BYTE,usage:r[q]},{index:nt.direction,vertexBuffer:i,componentsPerAttribute:2,normalize:!0,componentDatatype:u.UNSIGNED_BYTE},{index:nt.rotationAndAlignedAxis,componentsPerAttribute:4,componentDatatype:u.FLOAT,usage:r[Q]},{index:nt.scaleByDistance,componentsPerAttribute:4,componentDatatype:u.FLOAT,usage:r[et]},{index:nt.translucencyByDistance,componentsPerAttribute:4,componentDatatype:u.FLOAT,usage:r[tt]},{index:nt.pixelOffsetScaleByDistance,componentsPerAttribute:4,componentDatatype:u.FLOAT,usage:r[rt]}],4*t)}function D(e,t,r,i,n){var o=4*n._index,a=n._getActualPosition();e._mode===_.SCENE3D&&(e._baseVolume.expand(a,e._baseVolume),e._boundingVolumeDirty=!0),s.fromCartesian(a,ut);var l=i[ot],u=l[nt.positionHigh],c=ut.high;u(o+0,c.x,c.y,c.z),u(o+1,c.x,c.y,c.z),u(o+2,c.x,c.y,c.z),u(o+3,c.x,c.y,c.z);var h=l[nt.positionLow],d=ut.low;h(o+0,d.x,d.y,d.z),h(o+1,d.x,d.y,d.z),h(o+2,d.x,d.y,d.z),h(o+3,d.x,d.y,d.z)}function P(e,t,r,i,n){var o=4*n._index,a=n.getPixelOffset(),s=n._translate;e._maxPixelOffset=Math.max(e._maxPixelOffset,a.x+s.x,a.y+s.y);var l=i[ot],u=l[nt.pixelOffsetAndTranslate];u(o+0,a.x,a.y,s.x,s.y),u(o+1,a.x,a.y,s.x,s.y),u(o+2,a.x,a.y,s.x,s.y),u(o+3,a.x,a.y,s.x,s.y)}function M(e,t,r,i,n){var o=4*n._index,a=n.getEyeOffset(),s=n.getScale();e._maxEyeOffset=Math.max(e._maxEyeOffset,Math.abs(a.x),Math.abs(a.y),Math.abs(a.z)),e._maxScale=Math.max(e._maxScale,s);var l=i[ot],u=l[nt.eyeOffsetAndScale];u(o+0,a.x,a.y,a.z,s),u(o+1,a.x,a.y,a.z,s),u(o+2,a.x,a.y,a.z,s),u(o+3,a.x,a.y,a.z,s)}function I(e,t,i,n,o){var a=4*o._index,s=n[st],l=s[nt.pickColor],u=o.getPickId(t).color,c=r.floatToByte(u.red),h=r.floatToByte(u.green),d=r.floatToByte(u.blue),m=r.floatToByte(u.alpha);l(a+0,c,h,d,m),l(a+1,c,h,d,m),l(a+2,c,h,d,m),l(a+3,c,h,d,m)}function O(e,t,i,n,o){var a=4*o._index,s=n[at],l=s[nt.color],u=o.getColor(),c=r.floatToByte(u.red),h=r.floatToByte(u.green),d=r.floatToByte(u.blue),m=r.floatToByte(u.alpha);l(a+0,c,h,d,m),l(a+1,c,h,d,m),l(a+2,c,h,d,m),l(a+3,c,h,d,m)}function R(e,t,r,i,n){var o=4*n._index,a=n.getHorizontalOrigin().value,s=n.getVerticalOrigin().value,l=n.getShow();0===n.getColor().alpha&&(l=!1),e._allHorizontalCenter=e._allHorizontalCenter&&a===C.CENTER.value;var u=i[ot],c=u[nt.originAndShow];c(o+0,a,s,l),c(o+1,a,s,l),c(o+2,a,s,l),c(o+3,a,s,l)}function L(r,n,o,a,s){var l=4*s._index,u=0,c=0,h=0,d=0,m=s.getImageIndex();if(-1!==m){var p=o[m];if(!e(p))throw new t("Invalid billboard image index: "+m);u=p.x,c=p.y,h=p.width,d=p.height}var f=u+h,v=c+d,y=r._textureAtlas.getTexture().getDimensions(),g=.5*i(s.getWidth(),y.x*h),_=.5*i(s.getHeight(),y.y*d);r._maxSize=Math.max(r._maxSize,g,_);var w=a[ot],C=w[nt.textureCoordinatesAndImageSize];C(l+0,u,c,g,_),C(l+1,f,c,g,_),C(l+2,f,v,g,_),C(l+3,u,v,g,_)}function z(e,t,r,i,n){var o=4*n._index,s=n.getRotation(),l=n.getAlignedAxis();0===s&&a.equals(l,a.ZERO)||(e._shaderRotation=!0);var u=l.x,c=l.y,h=l.z,d=i[ot],m=d[nt.rotationAndAlignedAxis];m(o+0,s,u,c,h),m(o+1,s,u,c,h),m(o+2,s,u,c,h),m(o+3,s,u,c,h)}function N(t,r,i,n,o){var a=4*o._index,s=n[ot],l=s[nt.scaleByDistance],u=0,c=1,h=1,d=1,m=o.getScaleByDistance();e(m)&&(u=m.near,c=m.nearValue,h=m.far,d=m.farValue,(1!==c||1!==d)&&(t._shaderScaleByDistance=!0)),l(a+0,u,c,h,d),l(a+1,u,c,h,d),l(a+2,u,c,h,d),l(a+3,u,c,h,d)}function B(t,r,i,n,o){var a=4*o._index,s=n[ot],l=s[nt.translucencyByDistance],u=0,c=1,h=1,d=1,m=o.getTranslucencyByDistance();e(m)&&(u=m.near,c=m.nearValue,h=m.far,d=m.farValue,(1!==c||1!==d)&&(t._shaderTranslucencyByDistance=!0)),l(a+0,u,c,h,d),l(a+1,u,c,h,d),l(a+2,u,c,h,d),l(a+3,u,c,h,d)}function F(t,r,i,n,o){var a=4*o._index,s=n[ot],l=s[nt.pixelOffsetScaleByDistance],u=0,c=1,h=1,d=1,m=o.getPixelOffsetScaleByDistance();e(m)&&(u=m.near,c=m.nearValue,h=m.far,d=m.farValue,(1!==c||1!==d)&&(t._shaderPixelOffsetScaleByDistance=!0)),l(a+0,u,c,h,d),l(a+1,u,c,h,d),l(a+2,u,c,h,d),l(a+3,u,c,h,d)}function V(e,t,r,i,n){D(e,t,r,i,n),P(e,t,r,i,n),M(e,t,r,i,n),I(e,t,r,i,n),O(e,t,r,i,n),R(e,t,r,i,n),L(e,t,r,i,n),z(e,t,r,i,n),N(e,t,r,i,n),B(e,t,r,i,n),F(e,t,r,i,n)}function k(t,r,i,n,o,a){var s;n.mode===_.SCENE3D?(s=t._baseVolume,t._boundingVolumeDirty=!0):s=t._baseVolume2D;for(var l=[],u=0;i>u;++u){var c=r[u],h=c.getPosition(),m=w._computeActualPosition(h,n,o);e(m)&&(c._setActualPosition(m),a?l.push(m):s.expand(m,s))}a&&d.fromPoints(l,s)}function U(e,t){var r=t.mode,i=t.scene2D.projection,n=e._billboards,o=e._billboardsToUpdate,a=e._modelMatrix;e._mode!==r||e._projection!==i||r!==_.SCENE3D&&!l.equals(a,e.modelMatrix)?(e._mode=r,e._projection=i,l.clone(e.modelMatrix,a),e._createVertexArray=!0,(r===_.SCENE3D||r===_.SCENE2D||r===_.COLUMBUS_VIEW)&&k(e,n,n.length,t,a,!0)):r===_.MORPHING?k(e,n,n.length,t,a,!0):(r===_.SCENE2D||r===_.COLUMBUS_VIEW)&&k(e,o,e._billboardsToUpdateIndex,t,a,!1)}function W(e,t,r,i){var n,o,s,l=r.camera,u=l.frustum,c=a.subtract(l.positionWC,i.center,ht),h=a.multiplyByScalar(l.directionWC,a.dot(c,l.directionWC),dt),d=Math.max(0,a.magnitude(h)-i.radius);ct.x=t.getDrawingBufferWidth(),ct.y=t.getDrawingBufferHeight();var m=u.getPixelSize(ct,d);n=Math.max(m.x,m.y),o=2*n*e._maxScale*e._maxSize,e._allHorizontalCenter&&(o*=.5),s=n*e._maxPixelOffset+e._maxEyeOffset,i.radius+=o+s}var q=w.SHOW_INDEX,G=w.POSITION_INDEX,H=w.PIXEL_OFFSET_INDEX,j=w.EYE_OFFSET_INDEX,Y=w.HORIZONTAL_ORIGIN_INDEX,X=w.VERTICAL_ORIGIN_INDEX,Z=w.SCALE_INDEX,J=w.IMAGE_INDEX_INDEX,K=w.COLOR_INDEX,Q=w.ROTATION_INDEX,$=w.ALIGNED_AXIS_INDEX,et=w.SCALE_BY_DISTANCE_INDEX,tt=w.TRANSLUCENCY_BY_DISTANCE_INDEX,rt=w.PIXEL_OFFSET_SCALE_BY_DISTANCE_INDEX,it=w.NUMBER_OF_PROPERTIES,nt={positionHigh:0,positionLow:1,pixelOffsetAndTranslate:2,eyeOffsetAndScale:3,textureCoordinatesAndImageSize:4,originAndShow:5,direction:6,pickColor:7,color:7,rotationAndAlignedAxis:8,scaleByDistance:9,translucencyByDistance:10,pixelOffsetScaleByDistance:11},ot="all",at="color",st="pick",lt=function(e){e=i(e,i.EMPTY_OBJECT),this._textureAtlas=void 0,this._textureAtlasGUID=void 0,this._destroyTextureAtlas=!0,this._sp=void 0,this._rs=void 0,this._vaf=void 0,this._spPick=void 0,this._billboards=[],this._billboardsToUpdate=[],this._billboardsToUpdateIndex=0,this._billboardsRemoved=!1,this._createVertexArray=!1,this._shaderRotation=!1,this._compiledShaderRotation=!1,this._compiledShaderRotationPick=!1,this._shaderScaleByDistance=!1,this._compiledShaderScaleByDistance=!1,this._compiledShaderScaleByDistancePick=!1,this._shaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistancePick=!1,this._shaderPixelOffsetScaleByDistance=!1,this._compiledShaderPixelOffsetScaleByDistance=!1,this._compiledShaderPixelOffsetScaleByDistancePick=!1,this._propertiesChanged=new Uint32Array(it),this._maxSize=0,this._maxEyeOffset=0,this._maxScale=1,this._maxPixelOffset=0,this._allHorizontalCenter=!0,this._baseVolume=new d,this._baseVolumeWC=new d,this._baseVolume2D=new d,this._boundingVolume=new d,this._boundingVolumeDirty=!1,this._colorCommands=[],this._pickCommands=[],this.modelMatrix=l.clone(i(e.modelMatrix,l.IDENTITY)),this._modelMatrix=l.clone(l.IDENTITY),this.debugShowBoundingVolume=i(e.debugShowBoundingVolume,!1),this._mode=_.SCENE3D,this._projection=void 0,this._buffersUsage=[p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW,p.STATIC_DRAW];var t=this;this._uniforms={u_atlas:function(){return t._textureAtlas.getTexture()}}};lt.prototype.add=function(e){var t=new w(e,this);return t._index=this._billboards.length,this._billboards.push(t),this._createVertexArray=!0,t},lt.prototype.remove=function(e){return this.contains(e)?(this._billboards[e._index]=null,this._billboardsRemoved=!0,this._createVertexArray=!0,e._destroy(),!0):!1},lt.prototype.removeAll=function(){this._destroyBillboards(),this._billboards=[],this._billboardsToUpdate=[],this._billboardsToUpdateIndex=0,this._billboardsRemoved=!1,this._createVertexArray=!0},lt.prototype._updateBillboard=function(e,t){e._dirty||(this._billboardsToUpdate[this._billboardsToUpdateIndex++]=e),++this._propertiesChanged[t]},lt.prototype.contains=function(t){return e(t)&&t._billboardCollection===this},lt.prototype.get=function(r){if(!e(r))throw new t("index is required.");return E(this),this._billboards[r]},lt.prototype.getLength=function(){return E(this),this._billboards.length},lt.prototype.getTextureAtlas=function(){return this._textureAtlas},lt.prototype.setTextureAtlas=function(e){this._textureAtlas!==e&&(this._textureAtlas=this._destroyTextureAtlas&&this._textureAtlas&&this._textureAtlas.destroy(),this._textureAtlas=e,this._createVertexArray=!0)},lt.prototype.getDestroyTextureAtlas=function(){return this._destroyTextureAtlas},lt.prototype.setDestroyTextureAtlas=function(e){this._destroyTextureAtlas=e},lt.prototype.computeNewBuffersUsage=function(){for(var e=this._buffersUsage,t=!1,r=this._propertiesChanged,i=0;it>i;++i){var n=0===r[i]?p.STATIC_DRAW:p.STREAM_DRAW;t=t||e[i]!==n,e[i]=n}return t};var ut=new s,ct=new o,ht=new a,dt=new a;return lt.prototype.update=function(t,r,i){var n=this._textureAtlas;if(e(n)){var o=n.getTextureCoordinates();if(0!==o.length){E(this),U(this,r);var a=this._billboards,s=a.length,u=this._billboardsToUpdate,c=this._billboardsToUpdateIndex,p=this._propertiesChanged,y=n.getGUID(),w=this._createVertexArray||this._textureAtlasGUID!==y;this._textureAtlasGUID=y;var C,b=r.passes,I=b.pick;if(w||!I&&this.computeNewBuffersUsage()){this._createVertexArray=!1;for(var k=0;it>k;++k)p[k]=0;if(this._vaf=this._vaf&&this._vaf.destroy(),s>0){this._vaf=A(t,s,this._buffersUsage),C=this._vaf.writers;for(var ot=0;s>ot;++ot){var lt=this._billboards[ot];lt._dirty=!1,V(this,t,o,C,lt)}this._vaf.commit(T(t))}this._billboardsToUpdateIndex=0}else if(c>0){var ut=[];if(p[G]&&ut.push(D),p[H]&&ut.push(P),(p[j]||p[Z])&&ut.push(M),p[J]&&ut.push(L),p[K]&&ut.push(O),(p[Y]||p[X]||p[q])&&ut.push(R),(p[Q]||p[$])&&ut.push(z),p[et]&&ut.push(N),p[tt]&&ut.push(B),p[rt]&&ut.push(F),C=this._vaf.writers,c/s>.1){for(var ct=0;c>ct;++ct){var ht=u[ct];
ht._dirty=!1;for(var dt=0;dt<ut.length;++dt)ut[dt](this,t,o,C,ht)}this._vaf.commit(T(t))}else{for(var mt=0;c>mt;++mt){var pt=u[mt];pt._dirty=!1;for(var ft=0;ft<ut.length;++ft)ut[ft](this,t,o,C,pt);this._vaf.subCommit(4*pt._index,4)}this._vaf.endSubCommits()}this._billboardsToUpdateIndex=0}if(c>1.5*s&&(u.length=s),e(this._vaf)&&e(this._vaf.vaByPurpose)){this._boundingVolumeDirty&&(this._boundingVolumeDirty=!1,d.transform(this._baseVolume,this.modelMatrix,this._baseVolumeWC));var vt,yt=l.IDENTITY;r.mode===_.SCENE3D?(yt=this.modelMatrix,vt=d.clone(this._baseVolumeWC,this._boundingVolume)):vt=d.clone(this._baseVolume2D,this._boundingVolume),W(this,t,r,vt);var gt,_t,wt,Ct;if(b.render){var xt=this._colorCommands;for(e(this._rs)||(this._rs=t.createRenderState({depthTest:{enabled:!0},blending:m.ALPHA_BLEND})),(!e(this._sp)||this._shaderRotation&&!this._compiledShaderRotation||this._shaderScaleByDistance&&!this._compiledShaderScaleByDistance||this._shaderTranslucencyByDistance&&!this._compiledShaderTranslucencyByDistance||this._shaderPixelOffsetScaleByDistance&&!this._compiledShaderPixelOffsetScaleByDistance)&&(this._sp=t.getShaderCache().replaceShaderProgram(this._sp,g({defines:[this._shaderRotation?"ROTATION":"",this._shaderScaleByDistance?"EYE_DISTANCE_SCALING":"",this._shaderTranslucencyByDistance?"EYE_DISTANCE_TRANSLUCENCY":"",this._shaderPixelOffsetScaleByDistance?"EYE_DISTANCE_PIXEL_OFFSET":""],sources:[x]}),S,nt),this._compiledShaderRotation=this._shaderRotation,this._compiledShaderScaleByDistance=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistance=this._shaderTranslucencyByDistance,this._compiledShaderPixelOffsetScaleByDistance=this._shaderPixelOffsetScaleByDistance),gt=this._vaf.vaByPurpose[at],_t=gt.length,xt.length=_t,Ct=0;_t>Ct;++Ct)wt=xt[Ct],e(wt)||(wt=xt[Ct]=new f),wt.boundingVolume=vt,wt.modelMatrix=yt,wt.primitiveType=h.TRIANGLES,wt.count=gt[Ct].indicesCount,wt.shaderProgram=this._sp,wt.uniformMap=this._uniforms,wt.vertexArray=gt[Ct].va,wt.renderState=this._rs,wt.pass=v.OPAQUE,wt.owner=this,wt.debugShowBoundingVolume=this.debugShowBoundingVolume,i.push(wt)}if(I){var St=this._pickCommands;for((!e(this._spPick)||this._shaderRotation&&!this._compiledShaderRotationPick||this._shaderScaleByDistance&&!this._compiledShaderScaleByDistancePick||this._shaderTranslucencyByDistance&&!this._compiledShaderTranslucencyByDistancePick||this._shaderPixelOffsetScaleByDistance&&!this._compiledShaderPixelOffsetScaleByDistancePick)&&(this._spPick=t.getShaderCache().replaceShaderProgram(this._spPick,g({defines:["RENDER_FOR_PICK",this._shaderRotation?"ROTATION":"",this._shaderScaleByDistance?"EYE_DISTANCE_SCALING":"",this._shaderTranslucencyByDistance?"EYE_DISTANCE_TRANSLUCENCY":"",this._shaderPixelOffsetScaleByDistance?"EYE_DISTANCE_PIXEL_OFFSET":""],sources:[x]}),g({defines:["RENDER_FOR_PICK"],sources:[S]}),nt),this._compiledShaderRotationPick=this._shaderRotation,this._compiledShaderScaleByDistancePick=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistancePick=this._shaderTranslucencyByDistance,this._compiledShaderPixelOffsetScaleByDistancePick=this._shaderPixelOffsetScaleByDistance),gt=this._vaf.vaByPurpose[st],_t=gt.length,St.length=_t,Ct=0;_t>Ct;++Ct)wt=St[Ct],e(wt)||(wt=St[Ct]=new f),wt.boundingVolume=vt,wt.modelMatrix=yt,wt.primitiveType=h.TRIANGLES,wt.count=gt[Ct].indicesCount,wt.shaderProgram=this._spPick,wt.uniformMap=this._uniforms,wt.vertexArray=gt[Ct].va,wt.renderState=this._rs,wt.pass=v.OPAQUE,wt.owner=this,i.push(wt)}}}}},lt.prototype.isDestroyed=function(){return!1},lt.prototype.destroy=function(){return this._textureAtlas=this._destroyTextureAtlas&&this._textureAtlas&&this._textureAtlas.destroy(),this._sp=this._sp&&this._sp.release(),this._spPick=this._spPick&&this._spPick.release(),this._vaf=this._vaf&&this._vaf.destroy(),this._destroyBillboards(),n(this)},lt.prototype._destroyBillboards=function(){for(var e=this._billboards,t=e.length,r=0;t>r;++r)e[r]&&e[r]._destroy()},lt}),r("Renderer/TextureAtlasBuilder",["../Core/Event","../Core/defined","../Core/DeveloperError","../Core/loadImage"],function(e,t,r,i){"use strict";function n(){this.imageLoaded=new e,this.index=-1,this.loaded=!1}var o=function(e){if(!t(e))throw new r("textureAtlas is required.");this.textureAtlas=e,this._idHash={}};return o.prototype.addTextureFromUrl=function(e,n){if(!t(e))throw new r("url is required.");if(!t(n))throw new r("textureAvailableCallback is required.");this.addTextureFromFunction(e,function(e,t){i(e).then(t)},n)},o.prototype.addTextureFromFunction=function(e,i,o){if(!t(e))throw new r("id is required.");if(!t(i))throw new r("getImageCallback is required.");if(!t(o))throw new r("textureAvailableCallback is required.");var a=this._idHash[e];if(t(a))return a.loaded?o(a.index):a.imageLoaded.addEventListener(o),void 0;this._idHash[e]=a=new n,a.imageLoaded.addEventListener(o);var s=this;i(e,function(t){if(!s.textureAtlas.isDestroyed()){var r=a.index=s.textureAtlas.addImage(t);a.loaded=!0,a.imageLoaded.raiseEvent(r,e),a.imageLoaded=void 0}})},o}),r("DynamicScene/DynamicBillboardVisualizer",["../Core/DeveloperError","../Core/defined","../Core/destroyObject","../Core/Color","../Core/Cartesian2","../Core/Cartesian3","../Scene/BillboardCollection","../Scene/HorizontalOrigin","../Scene/VerticalOrigin","../Renderer/TextureAtlasBuilder"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e,r,i){return function(n){var o=e._billboardVisualizerIndex;if(t(o)){var a=r.get(o);a._visualizerUrl===i&&(a._visualizerTextureAvailable=!0,a.setImageIndex(n))}}}function h(e,r,a){var u=a._billboard;if(t(u)){var h=a._position;if(t(h)){var d=u._image;if(t(d)){var y,g=u._show,_=a._billboardVisualizerIndex,w=a.isAvailable(r)&&(!t(g)||g.getValue(r));if(!w)return t(_)&&(y=e._billboardCollection.get(_),y.setShow(!1),y.setImageIndex(-1),y._visualizerUrl=void 0,y._visualizerTextureAvailable=!1,a._billboardVisualizerIndex=void 0,e._unusedIndexes.push(_)),void 0;if(t(_))y=e._billboardCollection.get(_);else{var C=e._unusedIndexes,x=C.length;x>0?(_=C.pop(),y=e._billboardCollection.get(_)):(_=e._billboardCollection.getLength(),y=e._billboardCollection.add()),a._billboardVisualizerIndex=_,y.dynamicObject=a,y._visualizerUrl=void 0,y._visualizerTextureAvailable=!1,y.setColor(i.WHITE),y.setEyeOffset(o.ZERO),y.setPixelOffset(n.ZERO),y.setScale(1),y.setHorizontalOrigin(s.CENTER),y.setVerticalOrigin(l.CENTER)}var S=d.getValue(r);if(S!==y._visualizerUrl&&(y._visualizerUrl=S,y._visualizerTextureAvailable=!1,e._textureAtlasBuilder.addTextureFromUrl(S,c(a,e._billboardCollection,S))),y.setShow(y._visualizerTextureAvailable),y._visualizerTextureAvailable){m=h.getValue(r,m),t(m)&&y.setPosition(m);var E=u._color;if(t(E)&&(p=E.getValue(r,p),t(p)&&y.setColor(p)),E=u._eyeOffset,t(E)&&(f=E.getValue(r,f),t(f)&&y.setEyeOffset(f)),E=u._pixelOffset,t(E)&&(v=E.getValue(r,v),t(v)&&y.setPixelOffset(v)),E=u._scale,t(E)){var b=E.getValue(r);t(b)&&y.setScale(b)}if(E=u._rotation,t(E)){var T=E.getValue(r);t(T)&&y.setRotation(T)}if(E=u._alignedAxis,t(E)){var A=E.getValue(r);t(A)&&y.setAlignedAxis(A)}if(E=u._horizontalOrigin,t(E)){var D=E.getValue(r);t(D)&&y.setHorizontalOrigin(D)}if(E=u._verticalOrigin,t(E)){var P=E.getValue(r);t(P)&&y.setVerticalOrigin(P)}E=u._width,t(E)&&y.setWidth(E.getValue(r)),E=u._height,t(E)&&y.setHeight(E.getValue(r)),E=u._scaleByDistance,t(E)&&y.setScaleByDistance(E.getValue(r)),E=u._translucencyByDistance,t(E)&&y.setTranslucencyByDistance(E.getValue(r)),E=u._pixelOffsetScaleByDistance,t(E)&&y.setPixelOffsetScaleByDistance(E.getValue(r))}}}}}var d=function(r,i){if(!t(r))throw new e("scene is required.");this._scene=r,this._unusedIndexes=[],this._dynamicObjectCollection=void 0;var n=this._billboardCollection=new a,o=this._textureAtlas=r.getContext().createTextureAtlas();this._textureAtlasBuilder=new u(o),n.setTextureAtlas(o),r.getPrimitives().add(n),this.setDynamicObjectCollection(i)};d.prototype.getScene=function(){return this._scene},d.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},d.prototype.setDynamicObjectCollection=function(e){var r=this._dynamicObjectCollection;r!==e&&(t(r)&&(r.collectionChanged.removeEventListener(d.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,t(e)&&e.collectionChanged.addEventListener(d.prototype._onObjectsRemoved,this))},d.prototype.update=function(r){if(!t(r))throw new e("time is requied.");if(t(this._dynamicObjectCollection))for(var i=this._dynamicObjectCollection.getObjects(),n=0,o=i.length;o>n;n++)h(this,r,i[n])},d.prototype.removeAllPrimitives=function(){if(t(this._dynamicObjectCollection)){this._unusedIndexes=[],this._billboardCollection.removeAll();for(var e=this._dynamicObjectCollection.getObjects(),r=e.length-1;r>-1;r--)e[r]._billboardVisualizerIndex=void 0}},d.prototype.isDestroyed=function(){return!1},d.prototype.destroy=function(){return this.removeAllPrimitives(),this._scene.getPrimitives().remove(this._billboardCollection),r(this)};var m,p,f,v;return d.prototype._onObjectsRemoved=function(e,r,i){for(var n=this._billboardCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._billboardVisualizerIndex;if(t(l)){var u=n.get(l);u.setShow(!1),u.setImageIndex(-1),u._visualizerUrl=void 0,u._visualizerTextureAvailable=!1,s._billboardVisualizerIndex=void 0,o.push(l)}}},d}),r("Renderer/CullFace",["../Core/Enumeration"],function(e){"use strict";var t={FRONT:new e(1028,"FRONT"),BACK:new e(1029,"BACK"),FRONT_AND_BACK:new e(1032,"FRONT_AND_BACK"),validate:function(e){return e===t.FRONT||e===t.BACK||e===t.FRONT_AND_BACK}};return t}),r("Renderer/MipmapHint",["../Core/Enumeration"],function(e){"use strict";var t={DONT_CARE:new e(4352,"DONT_CARE"),FASTEST:new e(4353,"FASTEST"),NICEST:new e(4354,"NICEST"),validate:function(e){return e===t.DONT_CARE||e===t.FASTEST||e===t.NICEST}};return t}),r("Renderer/PixelDatatype",["../Core/Enumeration"],function(e){"use strict";var t={UNSIGNED_BYTE:new e(5121,"UNSIGNED_BYTE"),UNSIGNED_SHORT:new e(5123,"UNSIGNED_SHORT"),UNSIGNED_INT:new e(5125,"UNSIGNED_INT"),FLOAT:new e(5126,"FLOAT"),UNSIGNED_INT_24_8_WEBGL:new e(34042,"UNSIGNED_INT_24_8_WEBGL"),UNSIGNED_SHORT_4_4_4_4:new e(32819,"UNSIGNED_SHORT_4_4_4_4"),UNSIGNED_SHORT_5_5_5_1:new e(32820,"UNSIGNED_SHORT_5_5_5_1"),UNSIGNED_SHORT_5_6_5:new e(33635,"UNSIGNED_SHORT_5_6_5"),validate:function(e){return e===t.UNSIGNED_BYTE||e===t.UNSIGNED_SHORT||e===t.UNSIGNED_INT||e===t.FLOAT||e===t.UNSIGNED_INT_24_8_WEBGL||e===t.UNSIGNED_SHORT_4_4_4_4||e===t.UNSIGNED_SHORT_5_5_5_1||e===t.UNSIGNED_SHORT_5_6_5}};return t}),r("Renderer/PixelFormat",[],function(){"use strict";var e={DEPTH_COMPONENT:6402,DEPTH_STENCIL:34041,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,validate:function(t){return t===e.DEPTH_COMPONENT||t===e.DEPTH_STENCIL||t===e.ALPHA||t===e.RGB||t===e.RGBA||t===e.LUMINANCE||t===e.LUMINANCE_ALPHA},isColorFormat:function(t){return t===e.ALPHA||t===e.RGB||t===e.RGBA||t===e.LUMINANCE||t===e.LUMINANCE_ALPHA},isDepthFormat:function(t){return t===e.DEPTH_COMPONENT||t===e.DEPTH_STENCIL}};return e}),r("Renderer/TextureMagnificationFilter",[],function(){"use strict";var e={NEAREST:9728,LINEAR:9729,validate:function(t){return t===e.NEAREST||t===e.LINEAR}};return e}),r("Renderer/TextureMinificationFilter",[],function(){"use strict";var e={NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,validate:function(t){return t===e.NEAREST||t===e.LINEAR||t===e.NEAREST_MIPMAP_NEAREST||t===e.LINEAR_MIPMAP_NEAREST||t===e.NEAREST_MIPMAP_LINEAR||t===e.LINEAR_MIPMAP_LINEAR}};return e}),r("Renderer/TextureWrap",[],function(){"use strict";var e={CLAMP_TO_EDGE:33071,REPEAT:10497,MIRRORED_REPEAT:33648,validate:function(t){return t===e.CLAMP_TO_EDGE||t===e.REPEAT||t===e.MIRRORED_REPEAT}};return e}),r("Renderer/Texture",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Math","./MipmapHint","./PixelDatatype","./PixelFormat","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";var d=function(t,r,i,n,o,a,s,l,u,c){this._gl=t,this._textureFilterAnisotropic=r,this._textureTarget=i,this._texture=n,this._pixelFormat=o,this._pixelDatatype=a,this._width=s,this._height=l,this._dimensions=new e(s,l),this._preMultiplyAlpha=u,this._flipY=c,this._sampler=void 0,this.setSampler()};return d.prototype.copyFrom=function(e,i,o){if(!r(e))throw new n("source is required.");if(l.isDepthFormat(this._pixelFormat))throw new n("Cannot call copyFrom when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(i=t(i,0),o=t(o,0),0>i)throw new n("xOffset must be greater than or equal to zero.");if(0>o)throw new n("yOffset must be greater than or equal to zero.");var a=e.width,s=e.height;if(i+a>this._width)throw new n("xOffset + source.width must be less than or equal to getWidth().");if(o+s>this._height)throw new n("yOffset + source.height must be less than or equal to getHeight().");var u=this._gl,c=this._textureTarget;u.pixelStorei(u.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this._preMultiplyAlpha),u.pixelStorei(u.UNPACK_FLIP_Y_WEBGL,this._flipY),u.activeTexture(u.TEXTURE0),u.bindTexture(c,this._texture),e.arrayBufferView?u.texSubImage2D(c,0,i,o,a,s,this._pixelFormat,+this._pixelDatatype,e.arrayBufferView):u.texSubImage2D(c,0,i,o,this._pixelFormat,this._pixelDatatype,e),u.bindTexture(c,null)},d.prototype.copyFromFramebuffer=function(e,r,i,o,a,u){if(l.isDepthFormat(this._pixelFormat))throw new n("Cannot call copyFromFramebuffer when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(this._pixelDatatype===s.FLOAT)throw new n("Cannot call copyFromFramebuffer when the texture pixel data type is FLOAT.");if(e=t(e,0),r=t(r,0),i=t(i,0),o=t(o,0),a=t(a,this._width),u=t(u,this._height),0>e)throw new n("xOffset must be greater than or equal to zero.");if(0>r)throw new n("yOffset must be greater than or equal to zero.");if(0>i)throw new n("framebufferXOffset must be greater than or equal to zero.");if(0>o)throw new n("framebufferYOffset must be greater than or equal to zero.");if(e+a>this._width)throw new n("xOffset + width must be less than or equal to getWidth().");if(r+u>this._height)throw new n("yOffset + height must be less than or equal to getHeight().");var c=this._gl,h=this._textureTarget;c.activeTexture(c.TEXTURE0),c.bindTexture(h,this._texture),c.copyTexSubImage2D(h,0,e,r,i,o,a,u),c.bindTexture(h,null)},d.prototype.generateMipmap=function(e){if(l.isDepthFormat(this._pixelFormat))throw new n("Cannot call generateMipmap when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(this._width>1&&!o.isPowerOfTwo(this._width))throw new n("width must be a power of two to call generateMipmap().");if(this._height>1&&!o.isPowerOfTwo(this._height))throw new n("height must be a power of two to call generateMipmap().");if(e=t(e,a.DONT_CARE),!a.validate(e))throw new n("hint is invalid.");var r=this._gl,i=this._textureTarget;r.hint(r.GENERATE_MIPMAP_HINT,e),r.activeTexture(r.TEXTURE0),r.bindTexture(i,this._texture),r.generateMipmap(i),r.bindTexture(i,null)},d.prototype.getSampler=function(){return this._sampler},d.prototype.setSampler=function(e){if(!r(e)){var t=c.LINEAR,i=u.LINEAR;this._pixelDatatype===s.FLOAT&&(t=c.NEAREST,i=u.NEAREST),e={wrapS:h.CLAMP_TO_EDGE,wrapT:h.CLAMP_TO_EDGE,minificationFilter:t,magnificationFilter:i,maximumAnisotropy:1}}if(this._pixelDatatype===s.FLOAT){if(e.minificationFilter!==c.NEAREST&&e.minificationFilter!==c.NEAREST_MIPMAP_NEAREST)throw new n("Only NEAREST and NEAREST_MIPMAP_NEAREST minification filters are supported for floating point textures.");if(e.magnificationFilter!==u.NEAREST)throw new n("Only the NEAREST magnification filter is supported for floating point textures.")}var o=this._gl,a=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(a,this._texture),o.texParameteri(a,o.TEXTURE_MIN_FILTER,e.minificationFilter),o.texParameteri(a,o.TEXTURE_MAG_FILTER,e.magnificationFilter),o.texParameteri(a,o.TEXTURE_WRAP_S,e.wrapS),o.texParameteri(a,o.TEXTURE_WRAP_T,e.wrapT),r(this._textureFilterAnisotropic)&&o.texParameteri(a,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),o.bindTexture(a,null),this._sampler={wrapS:e.wrapS,wrapT:e.wrapT,minificationFilter:e.minificationFilter,magnificationFilter:e.magnificationFilter,maximumAnisotropy:e.maximumAnisotropy}},d.prototype.getPixelFormat=function(){return this._pixelFormat},d.prototype.getPixelDatatype=function(){return this._pixelDatatype},d.prototype.getDimensions=function(){return this._dimensions},d.prototype.getPreMultiplyAlpha=function(){return this._preMultiplyAlpha},d.prototype.getFlipY=function(){return this._flipY},d.prototype.getWidth=function(){return this._width},d.prototype.getHeight=function(){return this._height},d.prototype._getTexture=function(){return this._texture},d.prototype._getTarget=function(){return this._textureTarget},d.prototype.isDestroyed=function(){return!1},d.prototype.destroy=function(){return this._gl.deleteTexture(this._texture),i(this)},d}),r("Renderer/CubeMapFace",["../Core/defaultValue","../Core/DeveloperError","./PixelDatatype"],function(e,t,r){"use strict";var i=function(e,t,r,i,n,o,a,s,l){this._gl=e,this._texture=t,this._textureTarget=r,this._targetFace=i,this._pixelFormat=n,this._pixelDatatype=o,this._size=a,this._preMultiplyAlpha=s,this._flipY=l};return i.prototype.copyFrom=function(r,i,n){if(!r)throw new t("source is required.");i=e(i,0),n=e(n,0);var o=r.width,a=r.height;if(0>i)throw new t("xOffset must be greater than or equal to zero.");if(0>n)throw new t("yOffset must be greater than or equal to zero.");if(i+o>this._size)throw new t("xOffset + source.width must be less than or equal to getWidth().");if(n+a>this._size)throw new t("yOffset + source.height must be less than or equal to getHeight().");var s=this._gl,l=this._textureTarget;s.pixelStorei(s.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this._preMultiplyAlpha),s.pixelStorei(s.UNPACK_FLIP_Y_WEBGL,this._flipY),s.activeTexture(s.TEXTURE0),s.bindTexture(l,this._texture),r.arrayBufferView?s.texSubImage2D(this._targetFace,0,i,n,o,a,this._pixelFormat,+this._pixelDatatype,r.arrayBufferView):s.texSubImage2D(this._targetFace,0,i,n,this._pixelFormat,+this._pixelDatatype,r),s.bindTexture(l,null)},i.prototype.copyFromFramebuffer=function(i,n,o,a,s,l){if(i=e(i,0),n=e(n,0),o=e(o,0),a=e(a,0),s=e(s,this._size),l=e(l,this._size),0>i)throw new t("xOffset must be greater than or equal to zero.");if(0>n)throw new t("yOffset must be greater than or equal to zero.");if(0>o)throw new t("framebufferXOffset must be greater than or equal to zero.");if(0>a)throw new t("framebufferYOffset must be greater than or equal to zero.");if(i+s>this._size)throw new t("xOffset + source.width must be less than or equal to getWidth().");if(n+l>this._size)throw new t("yOffset + source.height must be less than or equal to getHeight().");if(this._pixelDatatype===r.FLOAT)throw new t("Cannot call copyFromFramebuffer when the texture pixel data type is FLOAT.");var u=this._gl,c=this._textureTarget;u.activeTexture(u.TEXTURE0),u.bindTexture(c,this._texture),u.copyTexSubImage2D(this._targetFace,0,i,n,o,a,s,l),u.bindTexture(c,null)},i.prototype.getPixelFormat=function(){return this._pixelFormat},i.prototype.getPixelDatatype=function(){return this._pixelDatatype},i.prototype._getTexture=function(){return this._texture},i.prototype._getTarget=function(){return this._targetFace},i}),r("Renderer/CubeMap",["../Core/defined","../Core/DeveloperError","../Core/destroyObject","../Core/Math","./MipmapHint","./PixelDatatype","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap","./CubeMapFace"],function(e,t,r,i,n,o,a,s,l,u){"use strict";var c=function(e,t,r,i,n,o,a,s,l){this._gl=e,this._textureFilterAnisotropic=t,this._textureTarget=r,this._texture=i,this._pixelFormat=n,this._pixelDatatype=o,this._size=a,this._preMultiplyAlpha=s,this._flipY=l,this._sampler=void 0,this._positiveX=new u(e,i,r,e.TEXTURE_CUBE_MAP_POSITIVE_X,n,o,a,s,l),this._negativeX=new u(e,i,r,e.TEXTURE_CUBE_MAP_NEGATIVE_X,n,o,a,s,l),this._positiveY=new u(e,i,r,e.TEXTURE_CUBE_MAP_POSITIVE_Y,n,o,a,s,l),this._negativeY=new u(e,i,r,e.TEXTURE_CUBE_MAP_NEGATIVE_Y,n,o,a,s,l),this._positiveZ=new u(e,i,r,e.TEXTURE_CUBE_MAP_POSITIVE_Z,n,o,a,s,l),this._negativeZ=new u(e,i,r,e.TEXTURE_CUBE_MAP_NEGATIVE_Z,n,o,a,s,l),this.setSampler()};return c.prototype.getPositiveX=function(){return this._positiveX},c.prototype.getNegativeX=function(){return this._negativeX},c.prototype.getPositiveY=function(){return this._positiveY},c.prototype.getNegativeY=function(){return this._negativeY},c.prototype.getPositiveZ=function(){return this._positiveZ},c.prototype.getNegativeZ=function(){return this._negativeZ},c.prototype.generateMipmap=function(e){if(this._size>1&&!i.isPowerOfTwo(this._size))throw new t("width and height must be a power of two to call generateMipmap().");if(e=e||n.DONT_CARE,!n.validate(e))throw new t("hint is invalid.");var r=this._gl,o=this._textureTarget;r.hint(r.GENERATE_MIPMAP_HINT,e),r.activeTexture(r.TEXTURE0),r.bindTexture(o,this._texture),r.generateMipmap(o),r.bindTexture(o,null)},c.prototype.setSampler=function(r){if(!e(r)){var i=s.LINEAR,n=a.LINEAR;this._pixelDatatype===o.FLOAT&&(i=s.NEAREST,n=a.NEAREST),r={wrapS:l.CLAMP_TO_EDGE,wrapT:l.CLAMP_TO_EDGE,minificationFilter:i,magnificationFilter:n,maximumAnisotropy:1}}if(this._pixelDatatype===o.FLOAT){if(r.minificationFilter!==s.NEAREST&&r.minificationFilter!==s.NEAREST_MIPMAP_NEAREST)throw new t("Only NEAREST and NEAREST_MIPMAP_NEAREST minification filters are supported for floating point textures.");if(r.magnificationFilter!==a.NEAREST)throw new t("Only the NEAREST magnification filter is supported for floating point textures.")}var u=this._gl,c=this._textureTarget;u.activeTexture(u.TEXTURE0),u.bindTexture(c,this._texture),u.texParameteri(c,u.TEXTURE_MIN_FILTER,r.minificationFilter),u.texParameteri(c,u.TEXTURE_MAG_FILTER,r.magnificationFilter),u.texParameteri(c,u.TEXTURE_WRAP_S,r.wrapS),u.texParameteri(c,u.TEXTURE_WRAP_T,r.wrapT),e(this._textureFilterAnisotropic)&&u.texParameteri(c,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,r.maximumAnisotropy),u.bindTexture(c,null),this._sampler={wrapS:r.wrapS,wrapT:r.wrapT,minificationFilter:r.minificationFilter,magnificationFilter:r.magnificationFilter,maximumAnisotropy:r.maximumAnisotropy}},c.prototype.getSampler=function(){return this._sampler},c.prototype.getPixelFormat=function(){return this._pixelFormat},c.prototype.getPixelDatatype=function(){return this._pixelDatatype},c.prototype.getWidth=function(){return this._size},c.prototype.getHeight=function(){return this._size},c.prototype.getPreMultiplyAlpha=function(){return this._preMultiplyAlpha},c.prototype.getFlipY=function(){return this._flipY},c.prototype._getTexture=function(){return this._texture},c.prototype._getTarget=function(){return this._textureTarget},c.prototype.isDestroyed=function(){return!1},c.prototype.destroy=function(){return this._gl.deleteTexture(this._texture),this._positiveX=r(this._positiveX),this._negativeX=r(this._negativeX),this._positiveY=r(this._positiveY),this._negativeY=r(this._negativeY),this._positiveZ=r(this._positiveZ),this._negativeZ=r(this._negativeZ),r(this)},c}),r("Shaders/Materials/AsphaltMaterial",[],function(){"use strict";return"uniform vec4 asphaltColor;\nuniform float bumpSize;\nuniform float roughness;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 color = asphaltColor;\nvec2 st = materialInput.st;\nvec2 F = czm_cellular(st / bumpSize);\ncolor.rgb -= (F.x / F.y) * 0.1;\nfloat noise = czm_snoise(st / bumpSize);\nnoise = pow(noise, 5.0) * roughness;\ncolor.rgb += noise;\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/BlobMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform float frequency;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 F = czm_cellular(materialInput.st * frequency);\nfloat t = 1.0 - F.x * F.x;\nvec4 color = mix(lightColor, darkColor, t);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/BrickMaterial",[],function(){"use strict";return"uniform vec4 brickColor;\nuniform vec4 mortarColor;\nuniform vec2 brickSize;\nuniform vec2 brickPct;\nuniform float brickRoughness;\nuniform float mortarRoughness;\n#define Integral(x, p) ((floor(x) * p) + max(fract(x) - (1.0 - p), 0.0))\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 position = st / brickSize;\nif(fract(position.y * 0.5) > 0.5) {\nposition.x += 0.5;\n}\nvec2 filterWidth = vec2(0.02);\nvec2 useBrick = (Integral(position + filterWidth, brickPct) -\nIntegral(position, brickPct)) / filterWidth;\nfloat useBrickFinal = useBrick.x * useBrick.y;\nvec4 color = mix(mortarColor, brickColor, useBrickFinal);\nvec2 brickScaled = vec2(st.x / 0.1, st.y / 0.006);\nfloat brickNoise = abs(czm_snoise(brickScaled) * brickRoughness / 5.0);\ncolor.rg += brickNoise * useBrickFinal;\nvec2 mortarScaled = st / 0.005;\nfloat mortarNoise = max(czm_snoise(mortarScaled) * mortarRoughness, 0.0);\ncolor.rgb += mortarNoise * (1.0 - useBrickFinal);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/BumpMapMaterial",[],function(){"use strict";return"uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 centerPixel = fract(repeat * st);\nfloat centerBump = texture2D(image, centerPixel).channel;\nfloat imageWidth = float(imageDimensions.x);\nvec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\nfloat rightBump = texture2D(image, rightPixel).channel;\nfloat imageHeight = float(imageDimensions.y);\nvec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\nfloat topBump = texture2D(image, leftPixel).channel;\nvec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nmaterial.diffuse = vec3(0.01);\nreturn material;\n}\n"}),r("Shaders/Materials/CementMaterial",[],function(){"use strict";return"uniform vec4 cementColor;\nuniform float grainScale;\nuniform float roughness;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat noise = czm_snoise(materialInput.st / grainScale);\nnoise = pow(noise, 5.0) * roughness;\nvec4 color = cementColor;\ncolor.rgb += noise;\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/CheckerboardMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);\nfloat scaledWidth = fract(repeat.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(repeat.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value = min(scaledWidth, scaledHeight);\nvec4 currentColor = mix(lightColor, darkColor, b);\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/DotMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));\nvec4 color = mix(lightColor, darkColor, b);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/FacetMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform float frequency;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 F = czm_cellular(materialInput.st * frequency);\nfloat t = 0.1 + (F.y - F.x);\nvec4 color = mix(lightColor, darkColor, t);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/FresnelMaterial",[],function(){"use strict";return"czm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec3 normalWC = normalize(czm_inverseViewRotation * material.normal);\nvec3 positionWC = normalize(czm_inverseViewRotation * materialInput.positionToEyeEC);\nfloat cosAngIncidence = max(dot(normalWC, positionWC), 0.0);\nmaterial.diffuse = mix(reflection.diffuse, refraction.diffuse, cosAngIncidence);\nreturn material;\n}\n"}),r("Shaders/Materials/GrassMaterial",[],function(){"use strict";return"uniform vec4 grassColor;\nuniform vec4 dirtColor;\nuniform float patchiness;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat noise1 = (czm_snoise(st * patchiness * 1.0)) * 1.0;\nfloat noise2 = (czm_snoise(st * patchiness * 2.0)) * 0.5;\nfloat noise3 = (czm_snoise(st * patchiness * 4.0)) * 0.25;\nfloat noise = sin(noise1 + noise2 + noise3) * 0.1;\nvec4 color = mix(grassColor, dirtColor, noise);\nfloat verticalNoise = czm_snoise(vec2(st.x * 100.0, st.y * 20.0)) * 0.02;\nfloat horizontalNoise = czm_snoise(vec2(st.x * 20.0, st.y * 100.0)) * 0.02;\nfloat stripeNoise = min(verticalNoise, horizontalNoise);\ncolor.rgb += stripeNoise;\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/GridMaterial",[],function(){"use strict";return"#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat scaledWidth = fract(lineCount.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(lineCount.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value;\n#ifdef GL_OES_standard_derivatives\nconst float fuzz = 1.2;\nvec2 thickness = lineThickness - 1.0;\nvec2 dx = abs(dFdx(st));\nvec2 dy = abs(dFdy(st));\nvec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\nvalue = min(\nsmoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\nsmoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\nconst float fuzz = 0.05;\nvec2 range = 0.5 - (lineThickness * 0.05);\nvalue = min(\n1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\nfloat dRim = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat sRim = smoothstep(0.8, 1.0, dRim);\nvalue *= (1.0 - sRim);\nvec3 halfColor = color.rgb * 0.5;\nmaterial.diffuse = halfColor;\nmaterial.emission = halfColor;\nmaterial.alpha = color.a * (1.0 - ((1.0 - cellAlpha) * value));\nreturn material;\n}\n"
}),r("Shaders/Materials/NormalMapMaterial",[],function(){"use strict";return"uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\nvec3 normalTangentSpace = textureValue.channels;\nnormalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\nnormalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\nnormalTangentSpace = normalize(normalTangentSpace);\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nreturn material;\n}\n"}),r("Shaders/Materials/ReflectionMaterial",[],function(){"use strict";return"uniform samplerCube cubeMap;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec3 normalWC = normalize(czm_inverseViewRotation * material.normal);\nvec3 positionWC = normalize(czm_inverseViewRotation * materialInput.positionToEyeEC);\nvec3 reflectedWC = reflect(positionWC, normalWC);\nmaterial.diffuse = textureCube(cubeMap, reflectedWC).channels;\nreturn material;\n}\n"}),r("Shaders/Materials/RefractionMaterial",[],function(){"use strict";return"uniform samplerCube cubeMap;\nuniform float indexOfRefractionRatio;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec3 normalWC = normalize(czm_inverseViewRotation * material.normal);\nvec3 positionWC = normalize(czm_inverseViewRotation * materialInput.positionToEyeEC);\nvec3 refractedWC = refract(positionWC, -normalWC, indexOfRefractionRatio);\nmaterial.diffuse = textureCube(cubeMap, refractedWC).channels;\nreturn material;\n}\n"}),r("Shaders/Materials/StripeMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\nfloat value = fract((coord - offset) * (repeat * 0.5));\nfloat dist = min(value, min(abs(value - 0.5), 1.0 - value));\nvec4 currentColor = mix(lightColor, darkColor, step(0.5, value));\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, dist);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/TieDyeMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform float frequency;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec3 scaled = materialInput.str * frequency;\nfloat t = abs(czm_snoise(scaled));\nvec4 color = mix(lightColor, darkColor, t);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/Water",[],function(){"use strict";return"uniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat time = czm_frameNumber * animationSpeed;\nfloat fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\nfloat specularMapValue = texture2D(specularMap, materialInput.st).r;\nvec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\nnormalTangentSpace.xy /= fade;\nnormalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\nnormalTangentSpace = normalize(normalTangentSpace);\nfloat tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\nmaterial.alpha = specularMapValue;\nmaterial.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\nmaterial.diffuse += (0.1 * tsPerturbationRatio);\nmaterial.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\nmaterial.specular = specularIntensity;\nmaterial.shininess = 10.0;\nreturn material;\n}\n"}),r("Shaders/Materials/WoodMaterial",[],function(){"use strict";return"uniform vec4 lightWoodColor;\nuniform vec4 darkWoodColor;\nuniform float ringFrequency;\nuniform vec2 noiseScale;\nuniform float grainFrequency;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 noisevec;\nnoisevec.x = czm_snoise(st * noiseScale.x);\nnoisevec.y = czm_snoise(st * noiseScale.y);\nvec2 location = st + noisevec;\nfloat dist = sqrt(location.x * location.x + location.y * location.y);\ndist *= ringFrequency;\nfloat r = fract(dist + noisevec[0] + noisevec[1]) * 2.0;\nif(r > 1.0)\nr = 2.0 - r;\nvec4 color = mix(lightWoodColor, darkWoodColor, r);\nr = abs(czm_snoise(vec2(st.x * grainFrequency, st.y * grainFrequency * 0.02))) * 0.2;\ncolor.rgb += lightWoodColor.rgb * r;\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/RimLightingMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat s = smoothstep(1.0 - width, 1.0, d);\nmaterial.diffuse = color.rgb;\nmaterial.emission = rimColor.rgb * s;\nmaterial.alpha = mix(color.a, rimColor.a, s);\nreturn material;\n}\n"}),r("Shaders/Materials/ErosionMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform float time;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat alpha = 1.0;\nif (time != 1.0)\n{\nfloat t = 0.5 + (0.5 * czm_snoise(materialInput.str / (1.0 / 10.0)));\nif (t > time)\n{\nalpha = 0.0;\n}\n}\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a * alpha;\nreturn material;\n}\n"}),r("Shaders/Materials/FadeMaterial",[],function(){"use strict";return"uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\nfloat getTime(float t, float coord)\n{\nfloat scalar = 1.0 / maximumDistance;\nfloat q  = distance(t, coord) * scalar;\nif (repeat)\n{\nfloat r = distance(t, coord + 1.0) * scalar;\nfloat s = distance(t, coord - 1.0) * scalar;\nq = min(min(r, s), q);\n}\nreturn clamp(q, 0.0, 1.0);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat s = getTime(time.x, st.s) * fadeDirection.s;\nfloat t = getTime(time.y, st.t) * fadeDirection.t;\nfloat u = length(vec2(s, t));\nvec4 color = mix(fadeInColor, fadeOutColor, u);\nmaterial.emission = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineArrowMaterial",[],function(){"use strict";return"#extension GL_OES_standard_derivatives : enable\nuniform vec4 color;\nvarying float v_width;\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\nfloat slope = (p0.y - p1.y) / (p0.x - p1.x);\nreturn slope * (x - p0.x) + p0.y;\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat base = 1.0 - abs(fwidth(st.s)) * 10.0;\nvec2 center = vec2(1.0, 0.5);\nfloat ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\nfloat ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\nfloat halfWidth = 0.15;\nfloat s = step(0.5 - halfWidth, st.t);\ns *= 1.0 - step(0.5 + halfWidth, st.t);\ns *= 1.0 - step(base, st.s);\nfloat t = step(base, materialInput.st.s);\nt *= 1.0 - step(ptOnUpperLine, st.t);\nt *= step(ptOnLowerLine, st.t);\nfloat dist;\nif (st.s < base)\n{\nfloat d1 = abs(st.t - (0.5 - halfWidth));\nfloat d2 = abs(st.t - (0.5 + halfWidth));\ndist = min(d1, d2);\n}\nelse\n{\nfloat d1 = czm_infinity;\nif (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n{\nd1 = abs(st.s - base);\n}\nfloat d2 = abs(st.t - ptOnUpperLine);\nfloat d3 = abs(st.t - ptOnLowerLine);\ndist = min(min(d1, d2), d3);\n}\nvec4 outsideColor = vec4(0.0);\nvec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\nvec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineGlowMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform float glowPower;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat glow = glowPower / abs(st.t - 0.5);\nmaterial.emission = max(vec3(glow - 1.0 + color.rgb), color.rgb);\nmaterial.alpha = clamp(0.0, 1.0, glow) * color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineOutlineMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\nfloat b = step(0.5 - halfInteriorWidth, st.t);\nb *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\nfloat d1 = abs(st.t - (0.5 - halfInteriorWidth));\nfloat d2 = abs(st.t - (0.5 + halfInteriorWidth));\nfloat dist = min(d1, d2);\nvec4 currentColor = mix(outlineColor, color, b);\nvec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n"}),r("Scene/Material",["../ThirdParty/when","../Core/loadImage","../Core/DeveloperError","../Core/createGuid","../Core/clone","../Core/Color","../Core/combine","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/Cartesian2","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Renderer/Texture","../Renderer/CubeMap","../Shaders/Materials/AsphaltMaterial","../Shaders/Materials/BlobMaterial","../Shaders/Materials/BrickMaterial","../Shaders/Materials/BumpMapMaterial","../Shaders/Materials/CementMaterial","../Shaders/Materials/CheckerboardMaterial","../Shaders/Materials/DotMaterial","../Shaders/Materials/FacetMaterial","../Shaders/Materials/FresnelMaterial","../Shaders/Materials/GrassMaterial","../Shaders/Materials/GridMaterial","../Shaders/Materials/NormalMapMaterial","../Shaders/Materials/ReflectionMaterial","../Shaders/Materials/RefractionMaterial","../Shaders/Materials/StripeMaterial","../Shaders/Materials/TieDyeMaterial","../Shaders/Materials/Water","../Shaders/Materials/WoodMaterial","../Shaders/Materials/RimLightingMaterial","../Shaders/Materials/ErosionMaterial","../Shaders/Materials/FadeMaterial","../Shaders/Materials/PolylineArrowMaterial","../Shaders/Materials/PolylineGlowMaterial","../Shaders/Materials/PolylineOutlineMaterial"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E,b,T,A,D,P,M,I,O,R,L,z,N,B,F,V,k){"use strict";function U(e,t){e=s(e,s.EMPTY_OBJECT),t._strict=s(e.strict,!1),t._count=s(e.count,0),t._template=n(s(e.fabric,s.EMPTY_OBJECT)),t._template.uniforms=n(s(t._template.uniforms,s.EMPTY_OBJECT)),t._template.materials=n(s(t._template.materials,s.EMPTY_OBJECT)),t.type=l(t._template.type)?t._template.type:i(),t.shaderSource="",t.materials={},t.uniforms={},t._uniforms={},t._translucentFunctions=[];var r,o=tt._materialCache.getMaterial(t.type);if(l(o)){var u=n(o.fabric,!0);t._template=a([t._template,u]),r=o.translucent}H(t),l(o)||tt._materialCache.addMaterial(t.type,t),j(t),Z(t),Q(t);var c=0===t._translucentFunctions.length?!0:void 0;if(r=s(r,c),r=s(e.translucent,r),l(r))if("function"==typeof r){var h=function(){return r(t)};t._translucentFunctions.push(h)}else t._translucentFunctions.push(r)}function W(e,t,r,i){if(l(e))for(var n in e)if(e.hasOwnProperty(n)){var o=-1!==t.indexOf(n);(i&&!o||!i&&o)&&r(n,t)}}function q(e,t){for(var i="fabric: property name '"+e+"' is not valid. It should be ",n=0;n<t.length;n++){var o="'"+t[n]+"'";i+=n===t.length-1?"or "+o+".":o+", "}throw new r(i)}function G(e){var t="fabric: uniforms and materials cannot share the same property '"+e+"'";throw new r(t)}function H(e){var t=e._template,i=t.uniforms,n=t.materials,o=t.components;if(l(o)&&l(t.source))throw new r("fabric: cannot have source and components in the same template.");W(t,rt,q,!0),W(o,it,q,!0);var a=[];for(var s in n)n.hasOwnProperty(s)&&a.push(s);W(i,a,G,!1)}function j(e){var t=e._template.components,r=e._template.source;if(l(r))e.shaderSource+=r+"\n";else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",l(t))for(var i in t)t.hasOwnProperty(i)&&(e.shaderSource+="material."+i+" = "+t[i]+";\n");e.shaderSource+="return material;\n}\n"}}function Y(r){return function(i,n){var o,a,s=i.uniforms,u=s[r],c=i._textures[r];if(u instanceof f&&u!==c)return tt._textureCache.releaseTexture(i._texturePaths[r]),i._texturePaths[r]=void 0,i._textures[r]=u,o=r+"Dimensions",s.hasOwnProperty(o)&&(a=s[o],a.x=u._width,a.y=u._height),void 0;if(l(c)||(i._texturePaths[r]=void 0,c=i._textures[r]=n.getDefaultTexture(),o=r+"Dimensions",s.hasOwnProperty(o)&&(a=s[o],a.x=c._width,a.y=c._height)),u!==tt.DefaultImageId&&u!==i._texturePaths[r]){var h=tt._textureCache.getTexture(u);l(h)?(tt._textureCache.releaseTexture(i._texturePaths[r]),i._textures[r]=h):e(t(u),function(e){i._loadedImages.push({id:r,image:e})}),i._texturePaths[r]=u}}}function X(r){return function(i,n){var o=i.uniforms[r];if(o instanceof v)return tt._textureCache.releaseTexture(i._texturePaths[r]),i._texturePaths[r]=void 0,i._textures[r]=o,void 0;if(l(i._textures[r])||(i._texturePaths[r]=void 0,i._textures[r]=n.getDefaultCubeMap()),o!==tt.DefaultCubeMapId){var a=o.positiveX+o.negativeX+o.positiveY+o.negativeY+o.positiveZ+o.negativeZ;if(a!==i._texturePaths[r]){var s=tt._textureCache.getTexture(a);if(l(s))tt._textureCache.releaseTexture(i._texturePaths[r]),i._textures[r]=s;else{var u=[t(o.positiveX),t(o.negativeX),t(o.positiveY),t(o.negativeY),t(o.positiveZ),t(o.negativeZ)];e.all(u).then(function(e){i._loadedCubeMaps.push({id:r,images:e})})}i._texturePaths[r]=a}}}}function Z(e){var t=e._template.uniforms;for(var r in t)t.hasOwnProperty(r)&&J(e,r)}function J(e,t){var i=e._strict,n=e._template.uniforms,o=n[t],a=K(o);if(!l(a))throw new r("fabric: uniform '"+t+"' has invalid type.");if("channels"===a){if(0===$(e,t,o,!1)&&i)throw new r("strict: shader source does not use channels '"+t+"'.")}else{if("sampler2D"===a){var s=t+"Dimensions";et(e,s)>0&&(n[s]={type:"ivec3",x:1,y:1},J(e,s))}var u="uniform "+a+" "+t+";\n";-1===e.shaderSource.indexOf(u)&&(e.shaderSource=u+e.shaderSource);var c=t+"_"+e._count++;if(1===$(e,t,c)&&i)throw new r("strict: shader source does not use uniform '"+t+"'.");if(e.uniforms[t]=o,"sampler2D"===a)e._uniforms[c]=function(){return e._textures[t]},e._updateFunctions.push(Y(t));else if("samplerCube"===a)e._uniforms[c]=function(){return e._textures[t]},e._updateFunctions.push(X(t));else if(-1!==a.indexOf("mat")){var h=new nt[a];e._uniforms[c]=function(){return nt[a].fromColumnMajorArray(e.uniforms[t],h)}}else e._uniforms[c]=function(){return e.uniforms[t]}}}function K(e){var t=e.type;if(!l(t)){var r=typeof e;if("number"===r)t="float";else if("boolean"===r)t="bool";else if("string"===r)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===tt.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"===r)if(Array.isArray(e))(4===e.length||9===e.length||16===e.length)&&(t="mat"+Math.sqrt(e.length));else{var i=0;for(var n in e)e.hasOwnProperty(n)&&(i+=1);i>=2&&4>=i?t="vec"+i:6===i&&(t="samplerCube")}}return t}function Q(e){var t=e._strict,i=e._template.materials;for(var n in i)if(i.hasOwnProperty(n)){var o=new tt({strict:t,fabric:i[n],count:e._count});e._count=o._count,e._uniforms=a([e._uniforms,o._uniforms]),e.materials[n]=o,e._translucentFunctions=e._translucentFunctions.concat(o._translucentFunctions);var s="czm_getMaterial",l=s+"_"+e._count++;$(o,s,l),e.shaderSource=o.shaderSource+e.shaderSource;var u=l+"(materialInput)";if(0===$(e,n,u)&&t)throw new r("strict: shader source does not use material '"+n+"'.")}}function $(e,t,r,i){i=s(i,!0);var n=0,o="a-zA-Z0-9_",a="(["+o+"])?",l="(["+o+(i?".":"")+"])?",u=new RegExp(l+t+a,"g");return e.shaderSource=e.shaderSource.replace(u,function(e,t,i){return t||i?e:(n+=1,r)}),n}function et(e,t,r){return $(e,t,t,r)}var tt=function(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],U(e,this),u(this,{type:{value:this.type,writable:!1}}),l(tt._uniformList[this.type])||(tt._uniformList[this.type]=Object.keys(this._uniforms))};tt._uniformList={},tt.fromType=function(e){if(!l(tt._materialCache.getMaterial(e)))throw new r("material with type '"+e+"' does not exist.");return new tt({fabric:{type:e}})},tt.prototype.isTranslucent=function(){if(l(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;for(var e=!0,t=this._translucentFunctions,r=t.length,i=0;r>i;++i){var n=t[i];if(e="function"==typeof n?e&&n():e&&n,!e)break}return e},tt.prototype.update=function(e){var t,r,i=this._loadedImages,n=i.length;for(t=0;n>t;++t){var o=i[t];r=o.id;var a=o.image,s=tt._textureCache.getTexture(this._texturePaths[r]);l(s)||(s=e.createTexture2D({source:a}),tt._textureCache.addTexture(this._texturePaths[r],s)),this._textures[r]=s;var u=r+"Dimensions";if(this.uniforms.hasOwnProperty(u)){var c=this.uniforms[u];c.x=s._width,c.y=s._height}}i.length=0;var h=this._loadedCubeMaps;for(n=h.length,t=0;n>t;++t){var d=h[t];r=d.id;var m=d.images,p=tt._textureCache.getTexture(this._texturePaths[r]);l(p)||(p=e.createCubeMap({source:{positiveX:m[0],negativeX:m[1],positiveY:m[2],negativeY:m[3],positiveZ:m[4],negativeZ:m[5]}}),tt._textureCache.addTexture(this._texturePaths[r],p)),this._textures[r]=p}h.length=0;var f=this._updateFunctions;for(n=f.length,t=0;n>t;++t)f[t](this,e);var v=this.materials;for(var y in v)v.hasOwnProperty(y)&&v[y].update(e)},tt.prototype.isDestroyed=function(){return!1},tt.prototype.destroy=function(){var e=this.materials,t=this.uniforms;for(var r in t)if(t.hasOwnProperty(r)){var i=this._texturePaths[r];tt._textureCache.releaseTexture(i)}for(var n in e)e.hasOwnProperty(n)&&e[n].destroy();return c(this)};var rt=["type","materials","uniforms","components","source"],it=["diffuse","specular","shininess","normal","emission","alpha"],nt={mat2:d,mat3:m,mat4:p};return tt._textureCache={_textures:{},addTexture:function(e,t){this._textures[e]={texture:t,count:1}},getTexture:function(e){var t=this._textures[e];return l(t)?(t.count++,t.texture):void 0},releaseTexture:function(e){var t=this._textures[e];l(t)&&0===--t.count&&(t.texture=t.texture&&t.texture.destroy(),this._textures[e]=void 0)}},tt._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},tt.DefaultImageId="czm_defaultImage",tt.DefaultCubeMapId="czm_defaultCubeMap",tt.ColorType="Color",tt._materialCache.addMaterial(tt.ColorType,{fabric:{type:tt.ColorType,uniforms:{color:new o(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),tt.ImageType="Image",tt._materialCache.addMaterial(tt.ImageType,{fabric:{type:tt.ImageType,uniforms:{image:tt.DefaultImageId,repeat:new h(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a"}},translucent:!0}),tt.DiffuseMapType="DiffuseMap",tt._materialCache.addMaterial(tt.DiffuseMapType,{fabric:{type:tt.DiffuseMapType,uniforms:{image:tt.DefaultImageId,channels:"rgb",repeat:new h(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),tt.AlphaMapType="AlphaMap",tt._materialCache.addMaterial(tt.AlphaMapType,{fabric:{type:tt.AlphaMapType,uniforms:{image:tt.DefaultImageId,channel:"a",repeat:new h(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),tt.SpecularMapType="SpecularMap",tt._materialCache.addMaterial(tt.SpecularMapType,{fabric:{type:tt.SpecularMapType,uniforms:{image:tt.DefaultImageId,channel:"r",repeat:new h(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),tt.EmissionMapType="EmissionMap",tt._materialCache.addMaterial(tt.EmissionMapType,{fabric:{type:tt.EmissionMapType,uniforms:{image:tt.DefaultImageId,channels:"rgb",repeat:new h(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),tt.BumpMapType="BumpMap",tt._materialCache.addMaterial(tt.BumpMapType,{fabric:{type:tt.BumpMapType,uniforms:{image:tt.DefaultImageId,channel:"r",strength:.8,repeat:new h(1,1)},source:w},translucent:!1}),tt.NormalMapType="NormalMap",tt._materialCache.addMaterial(tt.NormalMapType,{fabric:{type:tt.NormalMapType,uniforms:{image:tt.DefaultImageId,channels:"rgb",strength:.8,repeat:new h(1,1)},source:D},translucent:!1}),tt.ReflectionType="Reflection",tt._materialCache.addMaterial(tt.ReflectionType,{fabric:{type:tt.ReflectionType,uniforms:{cubeMap:tt.DefaultCubeMapId,channels:"rgb"},source:P},translucent:!1}),tt.RefractionType="Refraction",tt._materialCache.addMaterial(tt.RefractionType,{fabric:{type:tt.RefractionType,uniforms:{cubeMap:tt.DefaultCubeMapId,channels:"rgb",indexOfRefractionRatio:.9},source:M},translucent:!1}),tt.FresnelType="Fresnel",tt._materialCache.addMaterial(tt.FresnelType,{fabric:{type:tt.FresnelType,materials:{reflection:{type:tt.ReflectionType},refraction:{type:tt.RefractionType}},source:b},translucent:!1}),tt.BrickType="Brick",tt._materialCache.addMaterial(tt.BrickType,{fabric:{type:tt.BrickType,uniforms:{brickColor:new o(.6,.3,.1,1),mortarColor:new o(.8,.8,.7,1),brickSize:new h(.3,.15),brickPct:new h(.9,.85),brickRoughness:.2,mortarRoughness:.1},source:_},translucent:function(e){var t=e.uniforms;return t.brickColor.alpha<1||t.mortarColor.alpha<1}}),tt.WoodType="Wood",tt._materialCache.addMaterial(tt.WoodType,{fabric:{type:tt.WoodType,uniforms:{lightWoodColor:new o(.6,.3,.1,1),darkWoodColor:new o(.4,.2,.07,1),ringFrequency:3,noiseScale:new h(.7,.5),grainFrequency:27},source:L},translucent:function(e){var t=e.uniforms;return t.lightWoodColor.alpha<1||t.darkWoodColor.alpha<1}}),tt.AsphaltType="Asphalt",tt._materialCache.addMaterial(tt.AsphaltType,{fabric:{type:tt.AsphaltType,uniforms:{asphaltColor:new o(.15,.15,.15,1),bumpSize:.02,roughness:.2},source:y},translucent:function(e){return e.uniforms.asphaltColor.alpha<1}}),tt.CementType="Cement",tt._materialCache.addMaterial(tt.CementType,{fabric:{type:tt.CementType,uniforms:{cementColor:new o(.95,.95,.85,1),grainScale:.01,roughness:.3},source:C},translucent:function(e){return e.uniforms.cementColor.alpha<1}}),tt.GrassType="Grass",tt._materialCache.addMaterial(tt.GrassType,{fabric:{type:tt.GrassType,uniforms:{grassColor:new o(.25,.4,.1,1),dirtColor:new o(.1,.1,.1,1),patchiness:1.5},source:T},translucent:function(e){var t=e.uniforms;return t.grassColor.alpha<1||t.dirtColor.alpha<1}}),tt.GridType="Grid",tt._materialCache.addMaterial(tt.GridType,{fabric:{type:tt.GridType,uniforms:{color:new o(0,1,0,1),cellAlpha:.1,lineCount:new h(8,8),lineThickness:new h(1,1)},source:A},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.cellAlpha<1}}),tt.StripeType="Stripe",tt._materialCache.addMaterial(tt.StripeType,{fabric:{type:tt.StripeType,uniforms:{horizontal:!0,lightColor:new o(1,1,1,.5),darkColor:new o(0,0,1,.5),offset:0,repeat:5},source:I},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),tt.CheckerboardType="Checkerboard",tt._materialCache.addMaterial(tt.CheckerboardType,{fabric:{type:tt.CheckerboardType,uniforms:{lightColor:new o(1,1,1,.5),darkColor:new o(0,0,0,.5),repeat:new h(5,5)},source:x},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),tt.DotType="Dot",tt._materialCache.addMaterial(tt.DotType,{fabric:{type:tt.DotType,uniforms:{lightColor:new o(1,1,0,.75),darkColor:new o(0,1,1,.75),repeat:new h(5,5)},source:S},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),tt.TyeDyeType="TieDye",tt._materialCache.addMaterial(tt.TyeDyeType,{fabric:{type:tt.TyeDyeType,uniforms:{lightColor:new o(1,1,0,.75),darkColor:new o(1,0,0,.75),frequency:5},source:O},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),tt.FacetType="Facet",tt._materialCache.addMaterial(tt.FacetType,{fabric:{type:tt.FacetType,uniforms:{lightColor:new o(.25,.25,.25,.75),darkColor:new o(.75,.75,.75,.75),frequency:10},source:E},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),tt.BlobType="Blob",tt._materialCache.addMaterial(tt.BlobType,{fabric:{type:tt.BlobType,uniforms:{lightColor:new o(1,1,1,.5),darkColor:new o(0,0,1,.5),frequency:10},source:g},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),tt.WaterType="Water",tt._materialCache.addMaterial(tt.WaterType,{fabric:{type:tt.WaterType,uniforms:{baseWaterColor:new o(.2,.3,.6,1),blendColor:new o(0,1,.699,1),specularMap:tt.DefaultImageId,normalMap:tt.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:R},translucent:function(e){var t=e.uniforms;return t.baseWaterColor.alpha<1||t.blendColor.alpha<0}}),tt.RimLightingType="RimLighting",tt._materialCache.addMaterial(tt.RimLightingType,{fabric:{type:tt.RimLightingType,uniforms:{color:new o(1,0,0,.7),rimColor:new o(1,1,1,.4),width:.3},source:z},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.rimColor.alpha<0}}),tt.ErosionType="Erosion",tt._materialCache.addMaterial(tt.ErosionType,{fabric:{type:tt.ErosionType,uniforms:{color:new o(1,0,0,.5),time:1},source:N},translucent:function(e){return e.uniforms.color.alpha<1}}),tt.FadeType="Fade",tt._materialCache.addMaterial(tt.FadeType,{fabric:{type:tt.FadeType,uniforms:{fadeInColor:new o(1,0,0,1),fadeOutColor:new o(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new h(.5,.5)},source:B},translucent:function(e){var t=e.uniforms;return t.fadeInColor.alpha<1||t.fadeOutColor.alpha<0}}),tt.PolylineArrowType="PolylineArrow",tt._materialCache.addMaterial(tt.PolylineArrowType,{fabric:{type:tt.PolylineArrowType,uniforms:{color:new o(1,1,1,1)},source:F},translucent:!0}),tt.PolylineGlowType="PolylineGlow",tt._materialCache.addMaterial(tt.PolylineGlowType,{fabric:{type:tt.PolylineGlowType,uniforms:{color:new o(0,.5,1,1),glowPower:.1},source:V},translucent:!0}),tt.PolylineOutlineType="PolylineOutline",tt._materialCache.addMaterial(tt.PolylineOutlineType,{fabric:{type:tt.PolylineOutlineType,uniforms:{color:new o(1,1,1,1),outlineColor:new o(1,0,0,1),outlineWidth:1},source:k},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.outlineColor.alpha<1}}),tt}),r("Shaders/EllipsoidVS",[],function(){"use strict";return"attribute vec3 position;\nuniform vec3 u_radii;\nvarying vec3 v_positionEC;\nvoid main()\n{\nvec4 p = vec4(u_radii * position, 1.0);\nv_positionEC = (czm_modelView * p).xyz;\ngl_Position = czm_modelViewProjection * p;\ngl_Position.z = clamp(gl_Position.z, gl_DepthRange.near, gl_DepthRange.far);\n}\n"}),r("Shaders/EllipsoidFS",[],function(){"use strict";return"#ifdef WRITE_DEPTH\n#ifdef GL_EXT_frag_depth\n#extension GL_EXT_frag_depth : enable\n#endif\n#endif\nuniform vec3 u_radii;\nuniform vec3 u_oneOverEllipsoidRadiiSquared;\nvarying vec3 v_positionEC;\nvec4 computeEllipsoidColor(czm_ray ray, float intersection, float side)\n{\nvec3 positionEC = czm_pointAlongRay(ray, intersection);\nvec3 positionMC = (czm_inverseModelView * vec4(positionEC, 1.0)).xyz;\nvec3 geodeticNormal = normalize(czm_geodeticSurfaceNormal(positionMC, vec3(0.0), u_oneOverEllipsoidRadiiSquared));\nvec3 sphericalNormal = normalize(positionMC / u_radii);\nvec3 normalMC = geodeticNormal * side;\nvec3 normalEC = normalize(czm_normal * normalMC);\nvec2 st = czm_ellipsoidWgs84TextureCoordinates(sphericalNormal);\nvec3 positionToEyeEC = -positionEC;\nczm_materialInput materialInput;\nmaterialInput.s = st.s;\nmaterialInput.st = st;\nmaterialInput.str = (positionMC + u_radii) / u_radii;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = czm_eastNorthUpToEyeCoordinates(positionMC, normalEC);\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef ONLY_SUN_LIGHTING\nreturn czm_private_phong(normalize(positionToEyeEC), material);\n#else\nreturn czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\nvoid main()\n{\nfloat maxRadius = max(u_radii.x, max(u_radii.y, u_radii.z)) * 1.5;\nvec3 direction = normalize(v_positionEC);\nvec3 ellipsoidCenter = czm_modelView[3].xyz;\nfloat t1 = -1.0;\nfloat t2 = -1.0;\nfloat b = -2.0 * dot(direction, ellipsoidCenter);\nfloat c = dot(ellipsoidCenter, ellipsoidCenter) - maxRadius * maxRadius;\nfloat discriminant = b * b - 4.0 * c;\nif (discriminant >= 0.0) {\nt1 = (-b - sqrt(discriminant)) * 0.5;\nt2 = (-b + sqrt(discriminant)) * 0.5;\n}\nif (t1 < 0.0 && t2 < 0.0) {\ndiscard;\n}\nfloat t = min(t1, t2);\nif (t < 0.0) {\nt = 0.0;\n}\nczm_ellipsoid ellipsoid = czm_ellipsoidNew(ellipsoidCenter, u_radii);\nczm_ray ray = czm_ray(t * direction, direction);\nczm_raySegment intersection = czm_rayEllipsoidIntersectionInterval(ray, ellipsoid);\nif (czm_isEmpty(intersection))\n{\ndiscard;\n}\nvec4 outsideFaceColor = (intersection.start != 0.0) ? computeEllipsoidColor(ray, intersection.start, 1.0) : vec4(0.0);\nvec4 insideFaceColor = (outsideFaceColor.a < 1.0) ? computeEllipsoidColor(ray, intersection.stop, -1.0) : vec4(0.0);\ngl_FragColor = mix(insideFaceColor, outsideFaceColor, outsideFaceColor.a);\ngl_FragColor.a = 1.0 - (1.0 - insideFaceColor.a) * (1.0 - outsideFaceColor.a);\n#ifdef WRITE_DEPTH\n#ifdef GL_EXT_frag_depth\nt = (intersection.start != 0.0) ? intersection.start : intersection.stop;\nvec3 positionEC = czm_pointAlongRay(ray, t);\nvec4 positionCC = czm_projection * vec4(positionEC, 1.0);\nfloat z = positionCC.z / positionCC.w;\nfloat n = gl_DepthRange.near;\nfloat f = gl_DepthRange.far;\ngl_FragDepthEXT = (z * (f - n) + f + n) * 0.5;\n#endif\n#endif\n}\n"}),r("Scene/EllipsoidPrimitive",["../Core/defaultValue","../Core/BoxGeometry","../Core/Cartesian3","../Core/combine","../Core/defined","../Core/DeveloperError","../Core/destroyObject","../Core/Matrix4","../Core/BoundingSphere","../Core/PrimitiveType","../Renderer/CullFace","../Renderer/BlendingState","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/createShaderSource","../Renderer/Pass","./Material","./SceneMode","../Shaders/EllipsoidVS","../Shaders/EllipsoidFS"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_){"use strict";function w(e){var i=e.cache.ellipsoidPrimitive_vertexArray;if(n(i))return i;
var o=t.createGeometry(t.fromDimensions({dimensions:new r(2,2,2)}));return i=e.createVertexArrayFromGeometry({geometry:o,attributeIndices:C,bufferUsage:d.STATIC_DRAW}),e.cache.ellipsoidPrimitive_vertexArray=i,i}var C={position:0},x=function(t){t=e(t,e.EMPTY_OBJECT),this.center=r.clone(e(t.center,r.ZERO)),this._center=new r,this.radii=r.clone(t.radii),this._radii=new r,this._oneOverEllipsoidRadiiSquared=new r,this._boundingSphere=new l,this.modelMatrix=s.clone(e(t.modelMatrix,s.IDENTITY)),this._modelMatrix=new s,this._computedModelMatrix=new s,this.show=e(t.show,!0),this.material=e(t.material,v.fromType(v.ColorType)),this._material=void 0,this._translucent=void 0,this.id=t.id,this._id=void 0,this.debugShowBoundingVolume=e(t.debugShowBoundingVolume,!1),this.onlySunLighting=e(t.onlySunLighting,!1),this._onlySunLighting=!1,this._owner=t._owner,this._sp=void 0,this._rs=void 0,this._va=void 0,this._pickSP=void 0,this._pickId=void 0,this._colorCommand=new m,this._colorCommand.owner=this,this._pickCommand=new m,this._pickCommand.owner=this;var i=this;this._uniforms={u_radii:function(){return i.radii},u_oneOverEllipsoidRadiiSquared:function(){return i._oneOverEllipsoidRadiiSquared}},this._pickUniforms={czm_pickColor:function(){return i._pickId.color}}};return x.prototype.update=function(t,a,d){if(this.show&&a.mode===y.SCENE3D&&n(this.center)&&n(this.radii)){if(!n(this.material))throw new o("this.material must be defined.");var m=this.material.isTranslucent(),v=this._translucent!==m;(!n(this._rs)||v)&&(this._translucent=m,this._rs=t.createRenderState({cull:{enabled:!0,face:c.FRONT},depthTest:{enabled:!0},depthMask:!m&&t.getFragmentDepth(),blending:m?h.ALPHA_BLEND:void 0})),n(this._va)||(this._va=w(t));var x=!1,S=this.radii;if(!r.equals(this._radii,S)){r.clone(S,this._radii);var E=this._oneOverEllipsoidRadiiSquared;E.x=1/(S.x*S.x),E.y=1/(S.y*S.y),E.z=1/(S.z*S.z),x=!0}s.equals(this.modelMatrix,this._modelMatrix)&&r.equals(this.center,this._center)||(s.clone(this.modelMatrix,this._modelMatrix),r.clone(this.center,this._center),s.multiplyByTranslation(this.modelMatrix,this.center,this._computedModelMatrix),x=!0),x&&(r.clone(r.ZERO,this._boundingSphere.center),this._boundingSphere.radius=r.getMaximumComponent(S),l.transform(this._boundingSphere,this._computedModelMatrix,this._boundingSphere));var b=this._material!==this.material;this._material=this.material,this._material.update(t);var T=this.onlySunLighting!==this._onlySunLighting;this._onlySunLighting=this.onlySunLighting;var A=this._colorCommand;if(b||T||v){var D=p({defines:[this.onlySunLighting?"ONLY_SUN_LIGHTING":"",!m&&t.getFragmentDepth()?"WRITE_DEPTH":""],sources:[this.material.shaderSource,_]});this._sp=t.getShaderCache().replaceShaderProgram(this._sp,g,D,C),A.primitiveType=u.TRIANGLES,A.vertexArray=this._va,A.renderState=this._rs,A.shaderProgram=this._sp,A.uniformMap=i([this._uniforms,this.material._uniforms],!1,!1),A.executeInClosestFrustum=m,A.owner=e(this._owner,this)}var P=a.passes;if(P.render&&(A.boundingVolume=this._boundingSphere,A.debugShowBoundingVolume=this.debugShowBoundingVolume,A.modelMatrix=this._computedModelMatrix,A.pass=m?f.TRANSLUCENT:f.OPAQUE,d.push(A)),P.pick){var M=this._pickCommand;if(n(this._pickId)&&this._id===this.id||(this._id=this.id,this._pickId=this._pickId&&this._pickId.destroy(),this._pickId=t.createPickId({primitive:this,id:this.id})),b||T||!n(this._pickSP)){var I=p({defines:[this.onlySunLighting?"ONLY_SUN_LIGHTING":"",!m&&t.getFragmentDepth()?"WRITE_DEPTH":""],sources:[this.material.shaderSource,_],pickColorQualifier:"uniform"});this._pickSP=t.getShaderCache().replaceShaderProgram(this._pickSP,g,I,C),M.primitiveType=u.TRIANGLES,M.vertexArray=this._va,M.renderState=this._rs,M.shaderProgram=this._pickSP,M.uniformMap=i([this._uniforms,this._pickUniforms,this.material._uniforms],!1,!1),M.executeInClosestFrustum=m,M.owner=e(this._owner,this)}M.boundingVolume=this._boundingSphere,M.modelMatrix=this._computedModelMatrix,M.pass=m?f.TRANSLUCENT:f.OPAQUE,d.push(M)}}},x.prototype.isDestroyed=function(){return!1},x.prototype.destroy=function(){return this._sp=this._sp&&this._sp.release(),this._pickSP=this._pickSP&&this._pickSP.release(),this._pickId=this._pickId&&this._pickId.destroy(),a(this)},x}),r("DynamicScene/MaterialProperty",["../Core/defined","../Core/DeveloperError","../Scene/Material"],function(e,t,r){"use strict";function i(){throw new t("This type should not be instantiated directly.")}var n=i;return n.prototype.getType=i,n.prototype.getValue=i,n.prototype.equals=i,n.getValue=function(t,i,n){if(e(i)){var o=i.getType(t);e(o)&&(e(n)&&n.type===o||(n=r.fromType(o)),i.getValue(t,n.uniforms))}return n},n}),r("DynamicScene/DynamicEllipsoidVisualizer",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/destroyObject","../Core/Cartesian3","../Core/Matrix3","../Core/Matrix4","../Core/Quaternion","../Scene/EllipsoidPrimitive","../Scene/Material","./MaterialProperty"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";function h(r,i,h){var m=h._ellipsoid;if(t(m)){var v=m._radii;if(t(v)){var y=h._position;if(t(y)){var g=h._orientation;if(t(g)){var _,w=m._show,C=h._ellipsoidVisualizerIndex,x=h.isAvailable(i)&&(!t(w)||w.getValue(i));if(!x)return t(C)&&(_=r._ellipsoidCollection[C],_.show=!1,h._ellipsoidVisualizerIndex=void 0,r._unusedIndexes.push(C)),void 0;if(t(C))_=r._ellipsoidCollection[C];else{var S=r._unusedIndexes,E=S.length;E>0?(C=S.pop(),_=r._ellipsoidCollection[C]):(C=r._ellipsoidCollection.length,_=new l,r._ellipsoidCollection.push(_),r._primitives.add(_)),h._ellipsoidVisualizerIndex=C,_.dynamicObject=h,_.material=u.fromType(u.ColorType)}_.show=!0,_.radii=v.getValue(i,_.radii),p=e(y.getValue(i,p),_._visualizerPosition),f=e(g.getValue(i,f),_._visualizerOrientation),!t(p)||!t(f)||n.equals(p,_._visualizerPosition)&&s.equals(f,_._visualizerOrientation)||(a.fromRotationTranslation(o.fromQuaternion(f,d),p,_.modelMatrix),_._visualizerPosition=n.clone(p,_._visualizerPosition),_._visualizerOrientation=s.clone(f,_._visualizerOrientation)),_.material=c.getValue(i,m._material,_.material)}}}}}var d=new o,m=function(e,i){if(!t(e))throw new r("scene is required.");this._scene=e,this._unusedIndexes=[],this._primitives=e.getPrimitives(),this._ellipsoidCollection=[],this._dynamicObjectCollection=void 0,this.setDynamicObjectCollection(i)};m.prototype.getScene=function(){return this._scene},m.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},m.prototype.setDynamicObjectCollection=function(e){var r=this._dynamicObjectCollection;r!==e&&(t(r)&&(r.collectionChanged.removeEventListener(m.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,t(e)&&e.collectionChanged.addEventListener(m.prototype._onObjectsRemoved,this))},m.prototype.update=function(e){if(!t(e))throw new r("time is requied.");if(t(this._dynamicObjectCollection))for(var i=this._dynamicObjectCollection.getObjects(),n=0,o=i.length;o>n;n++)h(this,e,i[n])},m.prototype.removeAllPrimitives=function(){var e,r;for(e=0,r=this._ellipsoidCollection.length;r>e;e++)this._primitives.remove(this._ellipsoidCollection[e]);if(t(this._dynamicObjectCollection)){var i=this._dynamicObjectCollection.getObjects();for(e=i.length-1;e>-1;e--)i[e]._ellipsoidVisualizerIndex=void 0}this._unusedIndexes=[],this._ellipsoidCollection=[]},m.prototype.isDestroyed=function(){return!1},m.prototype.destroy=function(){return this.removeAllPrimitives(),i(this)};var p,f;return m.prototype._onObjectsRemoved=function(e,r,i){for(var n=this._ellipsoidCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._ellipsoidVisualizerIndex;if(t(l)){var u=n[l];u.show=!1,o.push(l),s._ellipsoidVisualizerIndex=void 0}}},m}),r("Shaders/SensorVolume",[],function(){"use strict";return"uniform vec4 u_intersectionColor;\nuniform float u_intersectionWidth;\nbool inSensorShadow(vec3 coneVertexWC, czm_ellipsoid ellipsoidEC, vec3 pointWC)\n{\nvec3 D = ellipsoidEC.inverseRadii;\nvec3 q = D * coneVertexWC;\nfloat qMagnitudeSquared = dot(q, q);\nfloat test = qMagnitudeSquared - 1.0;\nvec3 temp = D * pointWC - q;\nfloat d = dot(temp, q);\nreturn (d < -test) && (d / length(temp) < -sqrt(test));\n}\nvec4 getIntersectionColor()\n{\nreturn u_intersectionColor;\n}\nfloat getIntersectionWidth()\n{\nreturn u_intersectionWidth;\n}\nvec2 sensor2dTextureCoordinates(float sensorRadius, vec3 pointMC)\n{\nfloat t = pointMC.z / sensorRadius;\nfloat s = 1.0 + (atan(pointMC.y, pointMC.x) / czm_twoPi);\ns = s - floor(s);\nreturn vec2(s, t);\n}\n"}),r("Shaders/CustomSensorVolumeVS",[],function(){"use strict";return"attribute vec4 position;\nattribute vec3 normal;\nvarying vec3 v_positionWC;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\ngl_Position = czm_modelViewProjection * position;\nv_positionWC = (czm_model * position).xyz;\nv_positionEC = (czm_modelView * position).xyz;\nv_normalEC = czm_normal * normal;\n}\n"}),r("Shaders/CustomSensorVolumeFS",[],function(){"use strict";return"#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform bool u_showIntersection;\nuniform bool u_showThroughEllipsoid;\nuniform float u_sensorRadius;\nuniform float u_normalDirection;\nvarying vec3 v_positionWC;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvec4 getColor(float sensorRadius, vec3 pointEC)\n{\nczm_materialInput materialInput;\nvec3 pointMC = (czm_inverseModelView * vec4(pointEC, 1.0)).xyz;\nmaterialInput.st = sensor2dTextureCoordinates(sensorRadius, pointMC);\nmaterialInput.str = pointMC / sensorRadius;\nvec3 positionToEyeEC = -v_positionEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nvec3 normalEC = normalize(v_normalEC);\nmaterialInput.normalEC = u_normalDirection * normalEC;\nczm_material material = czm_getMaterial(materialInput);\nreturn mix(czm_phong(normalize(positionToEyeEC), material), vec4(material.diffuse, material.alpha), 0.4);\n}\nbool isOnBoundary(float value, float epsilon)\n{\nfloat width = getIntersectionWidth();\nfloat tolerance = width * epsilon;\n#ifdef GL_OES_standard_derivatives\nfloat delta = max(abs(dFdx(value)), abs(dFdy(value)));\nfloat pixels = width * delta;\nfloat temp = abs(value);\nreturn temp < tolerance && temp < pixels || (delta < 10.0 * tolerance && temp - delta < tolerance && temp < pixels);\n#else\nreturn abs(value) < tolerance;\n#endif\n}\nvec4 shade(bool isOnBoundary)\n{\nif (u_showIntersection && isOnBoundary)\n{\nreturn getIntersectionColor();\n}\nreturn getColor(u_sensorRadius, v_positionEC);\n}\nfloat ellipsoidSurfaceFunction(czm_ellipsoid ellipsoid, vec3 point)\n{\nvec3 scaled = ellipsoid.inverseRadii * point;\nreturn dot(scaled, scaled) - 1.0;\n}\nvoid main()\n{\nvec3 sensorVertexWC = czm_model[3].xyz;\nvec3 sensorVertexEC = czm_modelView[3].xyz;\nczm_ellipsoid ellipsoid = czm_getWgs84EllipsoidEC();\nfloat ellipsoidValue = ellipsoidSurfaceFunction(ellipsoid, v_positionWC);\nif (!u_showThroughEllipsoid)\n{\nif (ellipsoidValue < 0.0)\n{\ndiscard;\n}\nif (inSensorShadow(sensorVertexWC, ellipsoid, v_positionWC))\n{\ndiscard;\n}\n}\nif (distance(v_positionEC, sensorVertexEC) > u_sensorRadius)\n{\ndiscard;\n}\nbool isOnEllipsoid = isOnBoundary(ellipsoidValue, czm_epsilon3);\ngl_FragColor = shade(isOnEllipsoid);\n}\n"}),r("Scene/CustomSensorVolume",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Color","../Core/combine","../Core/destroyObject","../Core/FAR","../Core/Cartesian3","../Core/Matrix4","../Core/ComponentDatatype","../Core/PrimitiveType","../Core/BoundingSphere","../Renderer/BufferUsage","../Renderer/BlendingState","../Renderer/DrawCommand","../Renderer/createShaderSource","../Renderer/CullFace","../Renderer/Pass","./Material","../Shaders/SensorVolume","../Shaders/CustomSensorVolumeVS","../Shaders/CustomSensorVolumeFS","./SceneMode"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x){"use strict";function S(e){for(var t=e._directions,r=t.length,i=new Float32Array(3*r),n=isFinite(e.radius)?e.radius:a,o=[s.ZERO],l=r-2,u=r-1,c=0;r>c;l=u++,u=c++){var d=s.fromSpherical(t[l]),m=s.fromSpherical(t[u]),p=s.fromSpherical(t[c]),f=Math.max(s.angleBetween(d,m),s.angleBetween(m,p)),v=n/Math.cos(.5*f),y=s.multiplyByScalar(m,v);i[3*u]=y.x,i[3*u+1]=y.y,i[3*u+2]=y.z,o.push(y)}return h.fromPoints(o,e._boundingSphere),i}function E(e,t){for(var r=S(e),i=e._directions.length,n=new Float32Array(18*i),o=0,a=i-1,l=0;i>l;a=l++){var c=new s(r[3*a],r[3*a+1],r[3*a+2]),h=new s(r[3*l],r[3*l+1],r[3*l+2]),d=s.normalize(s.cross(h,c));n[o++]=0,n[o++]=0,n[o++]=0,n[o++]=d.x,n[o++]=d.y,n[o++]=d.z,n[o++]=h.x,n[o++]=h.y,n[o++]=h.z,n[o++]=d.x,n[o++]=d.y,n[o++]=d.z,n[o++]=c.x,n[o++]=c.y,n[o++]=c.z,n[o++]=d.x,n[o++]=d.y,n[o++]=d.z}var m=t.createVertexBuffer(new Float32Array(n),e.bufferUsage),p=6*Float32Array.BYTES_PER_ELEMENT,f=[{index:b.position,vertexBuffer:m,componentsPerAttribute:3,componentDatatype:u.FLOAT,offsetInBytes:0,strideInBytes:p},{index:b.normal,vertexBuffer:m,componentsPerAttribute:3,componentDatatype:u.FLOAT,offsetInBytes:3*Float32Array.BYTES_PER_ELEMENT,strideInBytes:p}];return t.createVertexArray(f)}var b={position:0,normal:1},T=function(r){r=e(r,e.EMPTY_OBJECT),this._pickId=void 0,this._pickIdThis=e(r._pickIdThis,this),this._frontFaceColorCommand=new p,this._backFaceColorCommand=new p,this._pickCommand=new p,this._boundingSphere=new h,this._boundingSphereWC=new h,this._frontFaceColorCommand.primitiveType=c.TRIANGLES,this._frontFaceColorCommand.boundingVolume=this._boundingSphereWC,this._frontFaceColorCommand.owner=this,this._backFaceColorCommand.primitiveType=this._frontFaceColorCommand.primitiveType,this._backFaceColorCommand.boundingVolume=this._frontFaceColorCommand.boundingVolume,this._backFaceColorCommand.owner=this,this._pickCommand.primitiveType=this._frontFaceColorCommand.primitiveType,this._pickCommand.boundingVolume=this._frontFaceColorCommand.boundingVolume,this._pickCommand.owner=this,this.show=e(r.show,!0),this.showIntersection=e(r.showIntersection,!0),this.showThroughEllipsoid=e(r.showThroughEllipsoid,!1),this._showThroughEllipsoid=this.showThroughEllipsoid,this.modelMatrix=l.clone(e(r.modelMatrix,l.IDENTITY)),this._modelMatrix=new l,this.bufferUsage=e(r.bufferUsage,d.STATIC_DRAW),this._bufferUsage=this.bufferUsage,this.radius=e(r.radius,Number.POSITIVE_INFINITY),this._directions=void 0,this._directionsDirty=!1,this.setDirections(r.directions),this.material=t(r.material)?r.material:g.fromType(g.ColorType),this._material=void 0,this._translucent=void 0,this.intersectionColor=i.clone(e(r.intersectionColor,i.WHITE)),this.intersectionWidth=e(r.intersectionWidth,5),this.id=r.id,this._id=void 0;var n=this;this._uniforms={u_showThroughEllipsoid:function(){return n.showThroughEllipsoid},u_showIntersection:function(){return n.showIntersection},u_sensorRadius:function(){return isFinite(n.radius)?n.radius:a},u_intersectionColor:function(){return n.intersectionColor},u_intersectionWidth:function(){return n.intersectionWidth},u_normalDirection:function(){return 1}},this._mode=x.SCENE3D};return T.prototype.setDirections=function(e){this._directions=e,this._directionsDirty=!0},T.prototype.getDirections=function(){return this._directions},T.prototype.update=function(e,i,o){if(this._mode=i.mode,this.show&&this._mode===x.SCENE3D){if(this.radius<0)throw new r("this.radius must be greater than or equal to zero.");if(!t(this.material))throw new r("this.material must be defined.");var a=this.material.isTranslucent();if(this._showThroughEllipsoid!==this.showThroughEllipsoid||!t(this._frontFaceColorCommand.renderState)||this._translucent!==a){this._showThroughEllipsoid=this.showThroughEllipsoid,this._translucent=a;var s;a?(s=e.createRenderState({depthTest:{enabled:!this.showThroughEllipsoid},depthMask:!1,blending:m.ALPHA_BLEND,cull:{enabled:!0,face:v.BACK}}),this._frontFaceColorCommand.renderState=s,this._frontFaceColorCommand.pass=y.TRANSLUCENT,s=e.createRenderState({depthTest:{enabled:!this.showThroughEllipsoid},depthMask:!1,blending:m.ALPHA_BLEND,cull:{enabled:!0,face:v.FRONT}}),this._backFaceColorCommand.renderState=s,this._backFaceColorCommand.pass=y.TRANSLUCENT,s=e.createRenderState({depthTest:{enabled:!this.showThroughEllipsoid},depthMask:!1,blending:m.ALPHA_BLEND}),this._pickCommand.renderState=s):(s=e.createRenderState({depthTest:{enabled:!0},depthMask:!0}),this._frontFaceColorCommand.renderState=s,this._frontFaceColorCommand.pass=y.OPAQUE,s=e.createRenderState({depthTest:{enabled:!0},depthMask:!0}),this._pickCommand.renderState=s)}var u=this._directionsDirty||this._bufferUsage!==this.bufferUsage;if(u){this._directionsDirty=!1,this._bufferUsage=this.bufferUsage,this._va=this._va&&this._va.destroy();var c=this._directions;c&&c.length>=3&&(this._frontFaceColorCommand.vertexArray=E(this,e),this._backFaceColorCommand.vertexArray=this._frontFaceColorCommand.vertexArray,this._pickCommand.vertexArray=this._frontFaceColorCommand.vertexArray)}if(t(this._frontFaceColorCommand.vertexArray)){var d=i.passes,p=!l.equals(this.modelMatrix,this._modelMatrix);p&&l.clone(this.modelMatrix,this._modelMatrix),(u||p)&&h.transform(this._boundingSphere,this.modelMatrix,this._boundingSphereWC),this._frontFaceColorCommand.modelMatrix=this.modelMatrix,this._backFaceColorCommand.modelMatrix=this._frontFaceColorCommand.modelMatrix,this._pickCommand.modelMatrix=this._frontFaceColorCommand.modelMatrix;var g=this._material!==this.material;if(this._material=this.material,this._material.update(e),d.render){var S=this._frontFaceColorCommand,T=this._backFaceColorCommand;if(g||!t(S.shaderProgram)){var A=f({sources:[_,this._material.shaderSource,C]});S.shaderProgram=e.getShaderCache().replaceShaderProgram(S.shaderProgram,w,A,b),S.uniformMap=n([this._uniforms,this._material._uniforms],!1,!1),T.shaderProgram=S.shaderProgram,T.uniformMap=n([this._uniforms,this._material._uniforms],!1,!1),T.uniformMap.u_normalDirection=function(){return-1}}a?o.push(this._backFaceColorCommand,this._frontFaceColorCommand):o.push(this._frontFaceColorCommand)}if(d.pick){var D=this._pickCommand;if(t(this._pickId)&&this._id===this.id||(this._id=this.id,this._pickId=this._pickId&&this._pickId.destroy(),this._pickId=e.createPickId({primitive:this._pickIdThis,id:this.id})),g||!t(D.shaderProgram)){var P=f({sources:[_,this._material.shaderSource,C],pickColorQualifier:"uniform"});D.shaderProgram=e.getShaderCache().replaceShaderProgram(D.shaderProgram,w,P,b);var M=this;D.uniformMap=n([this._uniforms,this._material._uniforms,{czm_pickColor:function(){return M._pickId.color}}],!1,!1)}D.pass=a?y.TRANSLUCENT:y.OPAQUE,o.push(D)}}}},T.prototype.isDestroyed=function(){return!1},T.prototype.destroy=function(){return this._frontFaceColorCommand.vertexArray=this._frontFaceColorCommand.vertexArray&&this._frontFaceColorCommand.vertexArray.destroy(),this._frontFaceColorCommand.shaderProgram=this._frontFaceColorCommand.shaderProgram&&this._frontFaceColorCommand.shaderProgram.release(),this._pickCommand.shaderProgram=this._pickCommand.shaderProgram&&this._pickCommand.shaderProgram.release(),this._pickId=this._pickId&&this._pickId.destroy(),o(this)},T}),r("DynamicScene/DynamicConeVisualizerUsingCustomSensor",["../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Quaternion","../Core/Math","../Core/Matrix3","../Core/Matrix4","../Core/Spherical","../Scene/CustomSensorVolume","../Scene/Material","./MaterialProperty"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function m(e,t,i,n){var o=t[e];r(o)||(t[e]=o=new u),o.clock=i,o.cone=n,o.magnitude=1}function p(e,t,r,i,n){var o,s=0,l=a.toRadians(2);if(0===e&&t===a.TWO_PI)for(o=0;o<a.TWO_PI;o+=l)m(s++,n,o,i);else{for(o=e;t>o;o+=l)m(s++,n,o,i);if(m(s++,n,t,i),r){for(o=t;o>e;o-=l)m(s++,n,o,r);m(s++,n,e,r)}else m(s++,n,t,0)}return n.length=s,n}function f(i,n,u){var m=u._cone;if(r(m)){var f=u._position;if(r(f)){var y=u._orientation;if(r(y)){var w,C=m._show,x=u._coneVisualizerIndex,S=u.isAvailable(n)&&(!r(C)||C.getValue(n));if(!S)return r(x)&&(w=i._coneCollection[x],w.show=!1,u._coneVisualizerIndex=void 0,i._unusedIndexes.push(x)),void 0;if(r(x))w=i._coneCollection[x];else{var E=i._unusedIndexes,b=E.length;b>0?(x=E.pop(),w=i._coneCollection[x]):(x=i._coneCollection.length,w=new c,w._directionsScratch=[],i._coneCollection.push(w),i._primitives.add(w)),u._coneVisualizerIndex=x,w.dynamicObject=u,w.material=h.fromType(h.ColorType),w.intersectionColor=t.clone(t.YELLOW),w.intersectionWidth=5,w.radius=Number.POSITIVE_INFINITY,w.showIntersection=!0}w.show=!0;var T,A=m._minimumClockAngle;r(A)&&(T=A.getValue(n)),r(T)||(T=0);var D;A=m._maximumClockAngle,r(A)&&(D=A.getValue(n)),r(D)||(D=a.TWO_PI);var P;A=m._innerHalfAngle,r(A)&&(P=A.getValue(n)),r(P)||(P=0);var M;if(A=m._outerHalfAngle,r(A)&&(M=A.getValue(n)),r(M)||(M=Math.PI),(T!==w.minimumClockAngle||D!==w.maximumClockAngle||P!==w.innerHalfAngle||M!==w.outerHalfAngle)&&(w.setDirections(p(T,D,P,M,w._directionsScratch)),w.innerHalfAngle=P,w.maximumClockAngle=D,w.outerHalfAngle=M,w.minimumClockAngle=T),A=m._radius,r(A)){var I=A.getValue(n);r(I)&&(w.radius=I)}var O=f.getValue(n,g),R=y.getValue(n,_);if(!r(O)||!r(R)||e.equals(O,w._visualizerPosition)&&o.equals(R,w._visualizerOrientation)||(l.fromRotationTranslation(s.fromQuaternion(R,v),O,w.modelMatrix),w._visualizerPosition=e.clone(O,w._visualizerPosition),w._visualizerOrientation=o.clone(R,w._visualizerOrientation)),w.material=d.getValue(n,m._outerMaterial,w.material),A=m._intersectionColor,r(A)&&A.getValue(n,w.intersectionColor),A=m._intersectionWidth,r(A)){var L=A.getValue(n);r(L)&&(w.intersectionWidth=L)}}}}}var v=new s,y=function(e,t){if(!r(e))throw new n("scene is required.");this._scene=e,this._unusedIndexes=[],this._primitives=e.getPrimitives(),this._coneCollection=[],this._dynamicObjectCollection=void 0,this.setDynamicObjectCollection(t)};y.prototype.getScene=function(){return this._scene},y.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},y.prototype.setDynamicObjectCollection=function(e){var t=this._dynamicObjectCollection;t!==e&&(r(t)&&(t.collectionChanged.removeEventListener(y.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,r(e)&&e.collectionChanged.addEventListener(y.prototype._onObjectsRemoved,this))},y.prototype.update=function(e){if(!r(e))throw new n("time is requied.");if(r(this._dynamicObjectCollection))for(var t=this._dynamicObjectCollection.getObjects(),i=0,o=t.length;o>i;i++)f(this,e,t[i])},y.prototype.removeAllPrimitives=function(){var e,t;for(e=0,t=this._coneCollection.length;t>e;e++)this._primitives.remove(this._coneCollection[e]);if(r(this._dynamicObjectCollection)){var i=this._dynamicObjectCollection.getObjects();for(e=i.length-1;e>-1;e--)i[e]._coneVisualizerIndex=void 0}this._unusedIndexes=[],this._coneCollection=[]},y.prototype.isDestroyed=function(){return!1},y.prototype.destroy=function(){return this.removeAllPrimitives(),i(this)};var g=new e,_=new o;return y.prototype._onObjectsRemoved=function(e,t,i){for(var n=this._coneCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._coneVisualizerIndex;if(r(l)){var u=n[l];u.show=!1,o.push(l),s._coneVisualizerIndex=void 0}}},y}),r("Scene/Label",["../Core/defaultValue","../Core/DeveloperError","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/NearFarScalar","./Billboard","./LabelStyle","./HorizontalOrigin","./VerticalOrigin"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";function h(e){e._rebindAllGlyphs||e._repositionAllGlyphs||e._labelCollection._labelsToUpdate.push(e),e._rebindAllGlyphs=!0}function d(e){e._rebindAllGlyphs||e._repositionAllGlyphs||e._labelCollection._labelsToUpdate.push(e),e._repositionAllGlyphs=!0}var m=function(a,s){if(a=e(a,e.EMPTY_OBJECT),o(a.translucencyByDistance)&&a.translucencyByDistance.far<=a.translucencyByDistance.near)throw new t("translucencyByDistance.far must be greater than translucencyByDistance.near.");if(o(a.pixelOffsetScaleByDistance)&&a.pixelOffsetScaleByDistance.far<=a.pixelOffsetScaleByDistance.near)throw new t("pixelOffsetScaleByDistance.far must be greater than pixelOffsetScaleByDistance.near.");this._text=e(a.text,""),this._show=e(a.show,!0),this._font=e(a.font,"30px sans-serif"),this._fillColor=n.clone(e(a.fillColor,n.WHITE)),this._outlineColor=n.clone(e(a.outlineColor,n.BLACK)),this._outlineWidth=e(a.outlineWidth,1),this._style=e(a.style,l.FILL),this._verticalOrigin=e(a.verticalOrigin,c.BOTTOM),this._horizontalOrigin=e(a.horizontalOrigin,u.LEFT),this._pixelOffset=r.clone(e(a.pixelOffset,r.ZERO)),this._eyeOffset=i.clone(e(a.eyeOffset,i.ZERO)),this._position=i.clone(e(a.position,i.ZERO)),this._scale=e(a.scale,1),this._id=a.id,this._translucencyByDistance=a.translucencyByDistance,this._pixelOffsetScaleByDistance=a.pixelOffsetScaleByDistance,this._labelCollection=s,this._glyphs=[],this._rebindAllGlyphs=!0,this._repositionAllGlyphs=!0};return m.prototype.getShow=function(){return this._show},m.prototype.setShow=function(e){if(!o(e))throw new t("value is required.");if(e!==this._show){this._show=e;for(var r=this._glyphs,i=0,n=r.length;n>i;i++){var a=r[i];o(a.billboard)&&a.billboard.setShow(e)}}},m.prototype.getPosition=function(){return this._position},m.prototype.setPosition=function(e){if(!o(e))throw new t("value is required.");var r=this._position;if(!i.equals(r,e)){i.clone(e,r);for(var n=this._glyphs,a=0,s=n.length;s>a;a++){var l=n[a];o(l.billboard)&&l.billboard.setPosition(e)}}},m.prototype.getText=function(){return this._text},m.prototype.setText=function(e){if(!o(e))throw new t("value is required.");e!==this._text&&(this._text=e,h(this))},m.prototype.getFont=function(){return this._font},m.prototype.setFont=function(e){if(!o(e))throw new t("value is required.");this._font!==e&&(this._font=e,h(this))},m.prototype.getFillColor=function(){return this._fillColor},m.prototype.setFillColor=function(e){if(!o(e))throw new t("value is required.");var r=this._fillColor;n.equals(r,e)||(n.clone(e,r),h(this))},m.prototype.getOutlineColor=function(){return this._outlineColor},m.prototype.setOutlineColor=function(e){if(!o(e))throw new t("value is required.");var r=this._outlineColor;n.equals(r,e)||(n.clone(e,r),h(this))},m.prototype.getOutlineWidth=function(){return this._outlineWidth},m.prototype.setOutlineWidth=function(e){if(!o(e))throw new t("value is required.");this._outlineWidth!==e&&(this._outlineWidth=e,h(this))},m.prototype.getStyle=function(){return this._style},m.prototype.setStyle=function(e){if(!o(e))throw new t("value is required.");this._style!==e&&(this._style=e,h(this))},m.prototype.getPixelOffset=function(){return this._pixelOffset},m.prototype.setPixelOffset=function(e){if(!o(e))throw new t("value is required.");var i=this._pixelOffset;r.equals(i,e)||(r.clone(e,i),d(this))},m.prototype.getTranslucencyByDistance=function(){return this._translucencyByDistance},m.prototype.setTranslucencyByDistance=function(e){if(!a.equals(this._translucencyByDistance,e)){if(e.far<=e.near)throw new t("far distance must be greater than near distance.");this._translucencyByDistance=a.clone(e,this._translucencyByDistance),h(this)}},m.prototype.getPixelOffsetScaleByDistance=function(){return this._pixelOffsetScaleByDistance},m.prototype.setPixelOffsetScaleByDistance=function(e){if(!a.equals(this._pixelOffsetScaleByDistance,e)){if(e.far<=e.near)throw new t("far distance must be greater than near distance.");this._pixelOffsetScaleByDistance=a.clone(e,this._pixelOffsetScaleByDistance),h(this)}},m.prototype.getEyeOffset=function(){return this._eyeOffset},m.prototype.setEyeOffset=function(e){if(!o(e))throw new t("value is required.");var r=this._eyeOffset;if(!i.equals(r,e)){i.clone(e,r);for(var n=this._glyphs,a=0,s=n.length;s>a;a++){var l=n[a];o(l.billboard)&&l.billboard.setEyeOffset(e)}}},m.prototype.getHorizontalOrigin=function(){return this._horizontalOrigin},m.prototype.setHorizontalOrigin=function(e){if(!o(e))throw new t("value is required.");this._horizontalOrigin!==e&&(this._horizontalOrigin=e,d(this))},m.prototype.getVerticalOrigin=function(){return this._verticalOrigin},m.prototype.setVerticalOrigin=function(e){if(!o(e))throw new t("value is required.");this._verticalOrigin!==e&&(this._verticalOrigin=e,d(this))},m.prototype.getScale=function(){return this._scale},m.prototype.getId=function(){return this._id},m.prototype.setScale=function(e){if(!o(e))throw new t("value is required.");if(this._scale!==e){this._scale=e;for(var r=this._glyphs,i=0,n=r.length;n>i;i++){var a=r[i];o(a.billboard)&&a.billboard.setScale(e)}d(this)}},m.prototype.computeScreenSpacePosition=function(e,r){if(!o(e))throw new t("context is required.");if(!o(r))throw new t("frameState is required.");var i=this._labelCollection,n=i.modelMatrix,a=s._computeActualPosition(this._position,r,n);return s._computeScreenSpacePosition(n,a,this._eyeOffset,this._pixelOffset,e,r)},m.prototype.equals=function(e){return this===e||o(e)&&this._show===e._show&&this._scale===e._scale&&this._style===e._style&&this._verticalOrigin===e._verticalOrigin&&this._horizontalOrigin===e._horizontalOrigin&&this._text===e._text&&this._font===e._font&&i.equals(this._position,e._position)&&n.equals(this._fillColor,e._fillColor)&&n.equals(this._outlineColor,e._outlineColor)&&r.equals(this._pixelOffset,e._pixelOffset)&&i.equals(this._eyeOffset,e._eyeOffset)&&a.equals(this._translucencyByDistance,e._translucencyByDistance)&&a.equals(this._pixelOffsetScaleByDistance,e._pixelOffsetScaleByDistance)&&this._id===e._id},m.prototype.isDestroyed=function(){return!1},m}),r("Scene/LabelCollection",["../Core/defaultValue","../Core/DeveloperError","../Core/defined","../Core/destroyObject","../Core/Cartesian2","../Core/Matrix4","../Core/writeTextToCanvas","./BillboardCollection","./Label","./LabelStyle","./HorizontalOrigin","./VerticalOrigin"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";function d(){this.textureInfo=void 0,this.dimensions=void 0,this.billboard=void 0}function m(e,t,r){this.labelCollection=e,this.index=t,this.dimensions=r}function p(e,t,r,i,n,o,s){return _.font=t,_.fillColor=r,_.strokeColor=i,_.strokeWidth=n,_.textBaseline=s===h.BOTTOM?"bottom":s===h.TOP?"top":"middle",_.fill=o===u.FILL||o===u.FILL_AND_OUTLINE,_.stroke=o===u.OUTLINE||o===u.FILL_AND_OUTLINE,a(e,_)}function f(e,t){t.textureInfo=void 0,t.dimensions=void 0;var i=t.billboard;r(i)&&(i.setShow(!1),i.setImageIndex(-1),i._pickId=i._pickId&&i._pickId.destroy(),e._spareBillboards.push(i),t.billboard=void 0)}function v(e,t){var i,n,o,a=t._text,s=a.length,l=t._glyphs,u=l.length;if(u>s)for(n=s;u>n;++n)f(e,l[n]);l.length=s;var h=e._glyphTextureCache,v=e._textureAtlas;for(o=0;s>o;++o){var y=a.charAt(o),g=t._font,_=t._fillColor,w=t._outlineColor,C=t._outlineWidth,x=t._style,S=t._verticalOrigin,E=JSON.stringify([y,g,_.toRgba(),w.toRgba(),C,+x,+S]),b=h[E];if(!r(b)){var T=p(y,g,_,w,C,x,S),A=-1;T.width>0&&T.height>0&&(A=v.addImage(T)),b=new m(e,A,T.dimensions),h[E]=b}if(i=l[o],r(i)?-1===b.index?f(e,i):r(i.textureInfo)&&(i.textureInfo=void 0):(i=new d,l[o]=i),i.textureInfo=b,i.dimensions=b.dimensions,-1!==b.index){var D=i.billboard;r(D)||(i.billboard=D=e._spareBillboards.length>0?e._spareBillboards.pop():e._billboardCollection.add(),D.setShow(t._show),D.setPosition(t._position),D.setEyeOffset(t._eyeOffset),D.setPixelOffset(t._pixelOffset),D.setHorizontalOrigin(c.LEFT),D.setVerticalOrigin(t._verticalOrigin),D.setScale(t._scale),D._pickIdThis=t,D._id=t._id),i.billboard.setImageIndex(b.index),i.billboard.setTranslucencyByDistance(t._translucencyByDistance),i.billboard.setPixelOffsetScaleByDistance(t._pixelOffsetScaleByDistance)}}t._repositionAllGlyphs=!0}function y(e){var t,i,n=e._glyphs,o=0,a=0,s=0,l=n.length;for(s=0;l>s;++s)t=n[s],i=t.dimensions,o+=i.width,a=Math.max(a,i.height);var u=e._scale,d=e._horizontalOrigin,m=0;d===c.CENTER?m-=o/2*u:d===c.RIGHT&&(m-=o*u),w.x=m,w.y=0;var p=e._verticalOrigin;for(s=0;l>s;++s)t=n[s],i=t.dimensions,p===h.BOTTOM||i.height===a?w.y=-i.descent*u:p===h.TOP?w.y=-(a-i.height)*u-i.descent*u:p===h.CENTER&&(w.y=-(a-i.height)/2*u-i.descent*u),r(t.billboard)&&t.billboard._setTranslate(w),w.x+=i.width*u
}function g(e,t){for(var r=t._glyphs,n=0,o=r.length;o>n;++n)f(e,r[n]);t._labelCollection=void 0,i(t)}var _={},w=new n,C=function(t){t=e(t,e.EMPTY_OBJECT),this._textureAtlas=void 0,this._billboardCollection=new s,this._billboardCollection.setDestroyTextureAtlas(!1),this._spareBillboards=[],this._glyphTextureCache={},this._labels=[],this._labelsToUpdate=[],this._totalGlyphCount=0,this.modelMatrix=o.clone(e(t.modelMatrix,o.IDENTITY)),this.debugShowBoundingVolume=e(t.debugShowBoundingVolume,!1)};return C.prototype.add=function(e){var t=new l(e,this);return this._labels.push(t),this._labelsToUpdate.push(t),t},C.prototype.remove=function(e){if(r(e)&&e._labelCollection===this){var t=this._labels.indexOf(e);if(-1!==t)return this._labels.splice(t,1),g(this,e),!0}return!1},C.prototype.removeAll=function(){for(var e=this._labels,t=0,r=e.length;r>t;++t)g(this,e[t]);e.length=0},C.prototype.contains=function(e){return r(e)&&e._labelCollection===this},C.prototype.get=function(e){if(!r(e))throw new t("index is required.");return this._labels[e]},C.prototype.getLength=function(){return this._labels.length},C.prototype.update=function(e,t,i){var n=this._billboardCollection;n.modelMatrix=this.modelMatrix,n.debugShowBoundingVolume=this.debugShowBoundingVolume,r(this._textureAtlas)||(this._textureAtlas=e.createTextureAtlas(),n.setTextureAtlas(this._textureAtlas));for(var o=this._labelsToUpdate,a=0,s=o.length;s>a;++a){var l=o[a];if(!l.isDestroyed()){var u=l._glyphs.length;l._rebindAllGlyphs&&(v(this,l),l._rebindAllGlyphs=!1),l._repositionAllGlyphs&&(y(l),l._repositionAllGlyphs=!1);var c=l._glyphs.length-u;this._totalGlyphCount+=c}}o.length=0,n.update(e,t,i)},C.prototype.isDestroyed=function(){return!1},C.prototype.destroy=function(){return this.removeAll(),this._billboardCollection=this._billboardCollection.destroy(),this._textureAtlas=this._textureAtlas&&this._textureAtlas.destroy(),i(this)},C}),r("DynamicScene/DynamicLabelVisualizer",["../Core/DeveloperError","../Core/defined","../Core/destroyObject","../Core/Color","../Core/Cartesian2","../Core/Cartesian3","../Scene/LabelCollection","../Scene/LabelStyle","../Scene/HorizontalOrigin","../Scene/VerticalOrigin"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e,r,a){var c=a._label;if(t(c)){var h=c._text;if(t(h)){var y=a._position;if(t(y)){var g,_=c._show,w=a._labelVisualizerIndex,C=a.isAvailable(r)&&(!t(_)||_.getValue(r));if(!C)return t(w)&&(g=e._labelCollection.get(w),g.setShow(!1),e._unusedIndexes.push(w),a._labelVisualizerIndex=void 0),void 0;if(t(w))g=e._labelCollection.get(w);else{var x=e._unusedIndexes,S=x.length;S>0?(w=x.pop(),g=e._labelCollection.get(w)):(w=e._labelCollection.getLength(),g=e._labelCollection.add()),a._labelVisualizerIndex=w,g.dynamicObject=a,g.setText(""),g.setScale(1),g.setFont("30px sans-serif"),g.setFillColor(i.WHITE),g.setOutlineColor(i.BLACK),g.setOutlineWidth(1),g.setStyle(s.FILL),g.setPixelOffset(n.ZERO),g.setEyeOffset(o.ZERO),g.setHorizontalOrigin(l.CENTER),g.setVerticalOrigin(u.CENTER)}g.setShow(C);var E=h.getValue(r);t(E)&&g.setText(E),d=y.getValue(r,d),t(d)&&g.setPosition(d);var b=c._scale;if(t(b)){var T=b.getValue(r);t(T)&&g.setScale(T)}if(b=c._font,t(b)){var A=b.getValue(r);t(A)&&g.setFont(A)}if(b=c._fillColor,t(b)&&(m=b.getValue(r,m),t(m)&&g.setFillColor(m)),b=c._outlineColor,t(b)&&(p=b.getValue(r,p),t(p)&&g.setOutlineColor(p)),b=c._outlineWidth,t(b)){var D=b.getValue(r);t(D)&&g.setOutlineWidth(D)}if(b=c._style,t(b)){var P=b.getValue(r);t(P)&&g.setStyle(P)}if(b=c._pixelOffset,t(b)&&(v=b.getValue(r,v),t(v)&&g.setPixelOffset(v)),b=c._eyeOffset,t(b)&&(f=b.getValue(r,f),t(f)&&g.setEyeOffset(f)),b=c._horizontalOrigin,t(b)){var M=b.getValue(r);t(M)&&g.setHorizontalOrigin(M)}if(b=c._verticalOrigin,t(b)){var I=b.getValue(r);t(I)&&g.setVerticalOrigin(I)}b=c._translucencyByDistance,t(b)&&g.setTranslucencyByDistance(b.getValue(r)),b=c._pixelOffsetScaleByDistance,t(b)&&g.setPixelOffsetScaleByDistance(b.getValue(r))}}}}var h=function(r,i){if(!t(r))throw new e("scene is required.");this._scene=r,this._unusedIndexes=[],this._dynamicObjectCollection=void 0;var n=this._labelCollection=new a;r.getPrimitives().add(n),this.setDynamicObjectCollection(i)};h.prototype.getScene=function(){return this._scene},h.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},h.prototype.setDynamicObjectCollection=function(e){var r=this._dynamicObjectCollection;r!==e&&(t(r)&&(r.collectionChanged.removeEventListener(h.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,t(e)&&e.collectionChanged.addEventListener(h.prototype._onObjectsRemoved,this))},h.prototype.update=function(r){if(!t(r))throw new e("time is requied.");if(t(this._dynamicObjectCollection))for(var i=this._dynamicObjectCollection.getObjects(),n=0,o=i.length;o>n;n++)c(this,r,i[n])},h.prototype.removeAllPrimitives=function(){if(this._unusedIndexes=[],this._labelCollection.removeAll(),t(this._dynamicObjectCollection))for(var e=this._dynamicObjectCollection.getObjects(),r=e.length-1;r>-1;r--)e[r]._labelVisualizerIndex=void 0},h.prototype.isDestroyed=function(){return!1},h.prototype.destroy=function(){return this.removeAllPrimitives(),this._scene.getPrimitives().remove(this._labelCollection),r(this)};var d,m,p,f,v;return h.prototype._onObjectsRemoved=function(e,r,i){for(var n=this._labelCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._labelVisualizerIndex;if(t(l)){var u=n.get(l);u.setShow(!1),o.push(l),s._labelVisualizerIndex=void 0}}},h}),r("Scene/Polyline",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/BoundingSphere","../Core/Color","../Core/PolylinePipeline","../Core/Matrix4","./Material"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,r){++e._propertiesChanged[r];var i=e._polylineCollection;t(i)&&(i._updatePolyline(e,r),e._dirty=!0)}var u={},c=function(r,l){r=e(r,u),this._show=e(r.show,!0),this._width=e(r.width,1),this._material=r.material,t(this._material)||(this._material=s.fromType(s.ColorType),this._material.uniforms.color=new n(1,1,1,1));var c=r.positions;t(c)||(c=[]),this._positions=c,this._length=c.length,this._id=r.id;var h;t(l)&&(h=a.clone(l.modelMatrix)),this._modelMatrix=h,this._segments=o.wrapLongitude(c,h),this._actualLength=void 0,this._propertiesChanged=new Uint32Array(v),this._polylineCollection=l,this._dirty=!1,this._pickId=void 0,this._pickIdThis=r._pickIdThis,this._boundingVolume=i.fromPoints(this._positions),this._boundingVolumeWC=i.transform(this._boundingVolume,this._modelMatrix),this._boundingVolume2D=new i},h=c.SHOW_INDEX=0,d=c.WIDTH_INDEX=1,m=c.POSITION_INDEX=2,p=c.MATERIAL_INDEX=3,f=c.POSITION_SIZE_INDEX=4,v=c.NUMBER_OF_PROPERTIES=5;return c.prototype.getShow=function(){return this._show},c.prototype.setShow=function(e){if(!t(e))throw new r("value is required.");e!==this._show&&(this._show=e,l(this,h))},c.prototype.getPositions=function(){return this._positions},c.prototype.setPositions=function(e){if(!t(e))throw new r("value is required.");(this._positions.length!==e.length||this._positions.length!==this._length)&&l(this,f),this._positions=e,this._length=e.length,this._boundingVolume=i.fromPoints(this._positions,this._boundingVolume),this._boundingVolumeWC=i.transform(this._boundingVolume,this._modelMatrix,this._boundingVolumeWC),l(this,m),this.update()},c.prototype.update=function(){var e=a.IDENTITY;t(this._polylineCollection)&&(e=this._polylineCollection.modelMatrix);var r=this._segments.positions.length,n=this._segments.lengths,s=this._propertiesChanged[m]>0||this._propertiesChanged[f]>0;if((!a.equals(e,this._modelMatrix)||s)&&(this._segments=o.wrapLongitude(this._positions,e),this._boundingVolumeWC=i.transform(this._boundingVolume,e,this._boundingVolumeWC)),this._modelMatrix=e,this._segments.positions.length!==r)l(this,f);else for(var u=n.length,c=0;u>c;++c)if(n[c]!==this._segments.lengths[c]){l(this,f);break}},c.prototype.getMaterial=function(){return this._material},c.prototype.setMaterial=function(e){if(!t(e))throw new r("material is required.");this._material!==e&&(this._material=e,l(this,p))},c.prototype.getWidth=function(){return this._width},c.prototype.setWidth=function(e){if(!t(e))throw new r("value is required.");var i=this._width;e!==i&&(this._width=e,l(this,d))},c.prototype.getId=function(){return this._id},c.prototype.getPickId=function(r){return t(this._pickId)||(this._pickId=r.createPickId({primitive:e(this._pickIdThis,this),id:this._id})),this._pickId},c.prototype._clean=function(){this._dirty=!1;for(var e=this._propertiesChanged,t=0;v-1>t;++t)e[t]=0},c.prototype._destroy=function(){this._pickId=this._pickId&&this._pickId.destroy(),this._material=this._material&&this._material.destroy(),this._polylineCollection=void 0},c}),r("Shaders/PolylineCommon",[],function(){"use strict";return"const vec2 czm_highResolutionSnapScale = vec2(1.0, 1.0);\nvoid clipLineSegmentToNearPlane(\nvec3 p0,\nvec3 p1,\nout vec4 positionWC,\nout bool clipped,\nout bool culledByNearPlane)\n{\nculledByNearPlane = false;\nclipped = false;\nvec3 p1ToP0 = p1 - p0;\nfloat magnitude = length(p1ToP0);\nvec3 direction = normalize(p1ToP0);\nfloat endPoint0Distance =  -(czm_currentFrustum.x + p0.z);\nfloat denominator = -direction.z;\nif (endPoint0Distance < 0.0 && abs(denominator) < czm_epsilon7)\n{\nculledByNearPlane = true;\n}\nelse if (endPoint0Distance < 0.0 && abs(denominator) > czm_epsilon7)\n{\nfloat t = (czm_currentFrustum.x + p0.z) / denominator;\nif (t < 0.0 || t > magnitude)\n{\nculledByNearPlane = true;\n}\nelse\n{\np0 = p0 + t * direction;\nclipped = true;\n}\n}\npositionWC = czm_eyeToWindowCoordinates(vec4(p0, 1.0));\n}\nvec4 getPolylineWindowCoordinates(vec4 position, vec4 previous, vec4 next, float expandDirection, float width, bool usePrevious) {\nvec4 endPointWC, p0, p1;\nbool culledByNearPlane, clipped;\nvec4 positionEC = czm_modelViewRelativeToEye * position;\nvec4 prevEC = czm_modelViewRelativeToEye * previous;\nvec4 nextEC = czm_modelViewRelativeToEye * next;\nclipLineSegmentToNearPlane(prevEC.xyz, positionEC.xyz, p0, clipped, culledByNearPlane);\nclipLineSegmentToNearPlane(nextEC.xyz, positionEC.xyz, p1, clipped, culledByNearPlane);\nclipLineSegmentToNearPlane(positionEC.xyz, usePrevious ? prevEC.xyz : nextEC.xyz, endPointWC, clipped, culledByNearPlane);\nif (culledByNearPlane)\n{\nreturn vec4(0.0, 0.0, 0.0, 1.0);\n}\nvec2 prevWC = normalize(p0.xy - endPointWC.xy);\nvec2 nextWC = normalize(p1.xy - endPointWC.xy);\nfloat expandWidth = width * 0.5;\nvec2 direction;\nif (czm_equalsEpsilon(normalize(previous.xyz - position.xyz), vec3(0.0), czm_epsilon1) || czm_equalsEpsilon(prevWC, -nextWC, czm_epsilon1))\n{\ndirection = vec2(-nextWC.y, nextWC.x);\n}\nelse if (czm_equalsEpsilon(normalize(next.xyz - position.xyz), vec3(0.0), czm_epsilon1) || clipped)\n{\ndirection = vec2(prevWC.y, -prevWC.x);\n}\nelse\n{\nvec2 normal = vec2(-nextWC.y, nextWC.x);\ndirection = normalize((nextWC + prevWC) * 0.5);\nif (dot(direction, normal) < 0.0)\n{\ndirection = -direction;\n}\nfloat sinAngle = abs(direction.x * nextWC.y - direction.y * nextWC.x);\nexpandWidth = clamp(expandWidth / sinAngle, 0.0, width * 2.0);\n}\nvec2 offset = direction * expandDirection * expandWidth * czm_highResolutionSnapScale;\nreturn vec4(endPointWC.xy + offset, -endPointWC.z, 1.0);\n}\n"}),r("Shaders/PolylineVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 position2DHigh;\nattribute vec3 position2DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 prevPosition2DHigh;\nattribute vec3 prevPosition2DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec3 nextPosition2DHigh;\nattribute vec3 nextPosition2DLow;\nattribute vec4 texCoordExpandWidthAndShow;\nattribute vec4 pickColor;\nvarying vec2  v_st;\nvarying float v_width;\nvarying vec4  czm_pickColor;\nvoid main()\n{\nfloat texCoord = texCoordExpandWidthAndShow.x;\nfloat expandDir = texCoordExpandWidthAndShow.y;\nfloat width = abs(texCoordExpandWidthAndShow.z) + 0.5;\nbool usePrev = texCoordExpandWidthAndShow.z < 0.0;\nfloat show = texCoordExpandWidthAndShow.w;\nvec4 p, prev, next;\nif (czm_morphTime == 1.0)\n{\np = czm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz);\nprev = czm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz);\nnext = czm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz);\n}\nelse if (czm_morphTime == 0.0)\n{\np = czm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy);\nprev = czm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy);\nnext = czm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy);\n}\nelse\n{\np = czm_columbusViewMorph(\nczm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy),\nczm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz),\nczm_morphTime);\nprev = czm_columbusViewMorph(\nczm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy),\nczm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz),\nczm_morphTime);\nnext = czm_columbusViewMorph(\nczm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy),\nczm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz),\nczm_morphTime);\n}\nvec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\ngl_Position = czm_viewportOrthographic * positionWC * show;\nv_st = vec2(texCoord, clamp(expandDir, 0.0, 1.0));\nv_width = width;\nczm_pickColor = pickColor;\n}\n"}),r("Shaders/PolylineFS",[],function(){"use strict";return"varying vec2 v_st;\nvoid main()\n{\nczm_materialInput materialInput;\nmaterialInput.s = v_st.s;\nmaterialInput.st = v_st;\nmaterialInput.str = vec3(v_st, 0.0);\nczm_material material = czm_getMaterial(materialInput);\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n}\n"}),r("Scene/PolylineCollection",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Color","../Core/destroyObject","../Core/Cartesian3","../Core/Cartesian4","../Core/EncodedCartesian3","../Core/Matrix4","../Core/Math","../Core/ComponentDatatype","../Core/IndexDatatype","../Core/PrimitiveType","../Core/BoundingSphere","../Core/Intersect","../Renderer/BlendingState","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/createShaderSource","../Renderer/Pass","./Material","./SceneMode","./Polyline","../Shaders/PolylineCommon","../Shaders/PolylineVS","../Shaders/PolylineFS"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E,b){"use strict";function T(e,r,i,n,o,a,s){for(var l=n.length,u=0,c=!0,h=e._vertexArrays,p=e.debugShowBoundingVolume,f=h.length,v=0;f>v;++v)for(var g=h[v],w=g.buckets,x=w.length,S=0;x>S;++S){for(var E,b,T,A=w[S],D=A.offset,M=s?A.bucket.shaderProgram:A.bucket.pickShaderProgram,I=A.bucket.polylines,O=I.length,R=0,L=0;O>L;++L){var z=I[L],N=P(z._material);if(N!==E){if(t(E)&&R>0){var B=b.isTranslucent();u>=l?(T=new y,T.owner=e,n.push(T)):T=n[u],++u,T.boundingVolume=m.clone(j,T.boundingVolume),T.modelMatrix=a,T.primitiveType=d.TRIANGLES,T.shaderProgram=M,T.vertexArray=g.va,T.renderState=B?e._translucentRS:e._opaqueRS,T.pass=B?_.TRANSLUCENT:_.OPAQUE,T.debugShowBoundingVolume=s?p:!1,T.uniformMap=b._uniforms,T.count=R,T.offset=D,D+=R,R=0,c=!0,o.push(T)}b=z._material,b.update(r),E=N}for(var F=z._locatorBuckets,V=F.length,k=0;V>k;++k){var U=F[k];U.locator===A&&(R+=U.count)}var W;i.mode===C.SCENE3D?W=z._boundingVolumeWC:i.mode===C.COLUMBUS_VIEW?W=z._boundingVolume2D:i.mode===C.SCENE2D?t(z._boundingVolume2D)&&(W=m.clone(z._boundingVolume2D,Y),W.center.x=0):t(z._boundingVolumeWC)&&t(z._boundingVolume2D)&&(W=m.union(z._boundingVolumeWC,z._boundingVolume2D,Y)),c?(c=!1,m.clone(W,j)):m.union(W,j,j)}t(E)&&R>0&&(u>=l?(T=new y,T.owner=e,n.push(T)):T=n[u],++u,T.boundingVolume=m.clone(j,T.boundingVolume),T.modelMatrix=a,T.primitiveType=d.TRIANGLES,T.shaderProgram=M,T.vertexArray=g.va,T.renderState=b.isTranslucent()?e._translucentRS:e._opaqueRS,T.pass=b.isTranslucent()?_.TRANSLUCENT:_.OPAQUE,T.debugShowBoundingVolume=s?p:!1,T.uniformMap=b._uniforms,T.count=R,T.offset=D,c=!0,o.push(T)),E=void 0}n.length=u}function A(e){for(var t=e._buffersUsage,r=!1,i=e._propertiesChanged,n=0;q-2>n;++n){var o=t[n];i[n]?o.bufferUsage!==v.STREAM_DRAW?(r=!0,o.bufferUsage=v.STREAM_DRAW,o.frameCount=100):o.frameCount=100:o.bufferUsage!==v.STATIC_DRAW&&(0===o.frameCount?(r=!0,o.bufferUsage=v.STATIC_DRAW):o.frameCount--)}return r}function D(e,r){e._createVertexArray=!1,R(e),L(e),M(e);var i,n,o=[[]],a=o[0],s=[0],l=0,d=[[]],m=0,p=e._polylineBuckets;for(i in p)p.hasOwnProperty(i)&&(n=p[i],n.updateShader(r),m+=n.lengthOfPositions);if(m>0){var f,y=e._mode,g=new Float32Array(3*6*m),_=new Uint8Array(4*m),w=new Float32Array(4*m),x=0,S=0,E=0;for(i in p)if(p.hasOwnProperty(i)){n=p[i],n.write(g,_,w,x,S,E,r),y===C.MORPHING&&(t(f)||(f=new Float32Array(3*6*m)),n.writeForMorph(f,x));var b=n.lengthOfPositions;x+=3*6*b,S+=4*b,E+=4*b,l=n.updateIndices(o,s,d,l)}var T=e._buffersUsage[k].bufferUsage,A=e._buffersUsage[F].bufferUsage,D=e._buffersUsage[V].bufferUsage,P=A===v.STREAM_DRAW||D===v.STREAM_DRAW?v.STREAM_DRAW:v.STATIC_DRAW;e._positionBuffer=r.createVertexBuffer(g,T);var I;t(f)&&(I=r.createVertexBuffer(f,T)),e._pickColorBuffer=r.createVertexBuffer(_,v.STATIC_DRAW),e._texCoordExpandWidthAndShowBuffer=r.createVertexBuffer(w,P);for(var O=4*Uint8Array.BYTES_PER_ELEMENT,z=3*Float32Array.BYTES_PER_ELEMENT,N=4*Float32Array.BYTES_PER_ELEMENT,B=0,U=o.length,W=0;U>W;++W)if(a=o[W],a.length>0){var q=new Uint16Array(a),H=r.createIndexBuffer(q,v.STATIC_DRAW,h.UNSIGNED_SHORT);B+=s[W];var j,Y,Z,J,K=6*(W*z*u.SIXTY_FOUR_KILOBYTES-B*z),Q=z+K,$=z+Q,et=z+$,tt=z+et,rt=z+tt,it=W*O*u.SIXTY_FOUR_KILOBYTES-B*O,nt=W*N*u.SIXTY_FOUR_KILOBYTES-B*N,ot=[{index:G.position3DHigh,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:K,strideInBytes:6*z},{index:G.position3DLow,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:Q,strideInBytes:6*z},{index:G.position2DHigh,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:K,strideInBytes:6*z},{index:G.position2DLow,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:Q,strideInBytes:6*z},{index:G.prevPosition3DHigh,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:$,strideInBytes:6*z},{index:G.prevPosition3DLow,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:et,strideInBytes:6*z},{index:G.prevPosition2DHigh,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:$,strideInBytes:6*z},{index:G.prevPosition2DLow,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:et,strideInBytes:6*z},{index:G.nextPosition3DHigh,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:tt,strideInBytes:6*z},{index:G.nextPosition3DLow,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:rt,strideInBytes:6*z},{index:G.nextPosition2DHigh,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:tt,strideInBytes:6*z},{index:G.nextPosition2DLow,componentsPerAttribute:3,componentDatatype:c.FLOAT,offsetInBytes:rt,strideInBytes:6*z},{index:G.texCoordExpandWidthAndShow,componentsPerAttribute:4,componentDatatype:c.FLOAT,vertexBuffer:e._texCoordExpandWidthAndShowBuffer,offsetInBytes:nt},{index:G.pickColor,componentsPerAttribute:4,componentDatatype:c.UNSIGNED_BYTE,vertexBuffer:e._pickColorBuffer,offsetInBytes:it,normalize:!0}];y===C.SCENE3D?(j=e._positionBuffer,Y="vertexBuffer",Z=X,J="value"):y===C.SCENE2D||y===C.COLUMBUS_VIEW?(j=X,Y="value",Z=e._positionBuffer,J="vertexBuffer"):(j=I,Y="vertexBuffer",Z=e._positionBuffer,J="vertexBuffer"),ot[0][Y]=j,ot[1][Y]=j,ot[2][J]=Z,ot[3][J]=Z,ot[4][Y]=j,ot[5][Y]=j,ot[6][J]=Z,ot[7][J]=Z,ot[8][Y]=j,ot[9][Y]=j,ot[10][J]=Z,ot[11][J]=Z;var at=r.createVertexArray(ot,H);e._vertexArrays.push({va:at,buckets:d[W]})}}}function P(e){var t=w._uniformList[e.type],r=t.length;Z.length=2*r;for(var i=0,n=0;r>n;++n){var o=t[n];Z[i]=o,Z[i+1]=e._uniforms[o](),i+=2}return e.type+":"+JSON.stringify(Z)}function M(e){for(var r=e._mode,i=e._projection,n=e._modelMatrix,o=e._polylineBuckets={},a=e._polylines,s=a.length,l=0;s>l;++l){var u=a[l];if(u.getPositions().length>1){u.update();var c=u.getMaterial(),h=o[c.type];t(h)||(h=o[c.type]=new J(c,r,i,n)),h.addPolyline(u)}}}function I(e,t){var r=t.mode,i=t.scene2D.projection;e._mode===r&&e._projection===i&&l.equals(e._modelMatrix,e.modelMatrix)||(e._mode=r,e._projection=i,e._modelMatrix=l.clone(e.modelMatrix),e._createVertexArray=!0)}function O(e){if(e._polylinesRemoved){e._polylinesRemoved=!1;for(var r=[],i=e._polylines.length,n=0,o=0;i>n;++n){var a=e._polylines[n];t(a)&&(a._index=o++,r.push(a))}e._polylines=r}}function R(e){for(var r=e._polylines,i=r.length,n=0;i>n;++n)if(t(r[n])){var o=r[n]._bucket;t(o)&&(o.shaderProgram=o.shaderProgram&&o.shaderProgram.release())}}function L(e){for(var t=e._vertexArrays.length,r=0;t>r;++r)e._vertexArrays[r].va.destroy();e._vertexArrays.length=0}function z(e){for(var r=e._polylines,i=r.length,n=0;i>n;++n)t(r[n])&&r[n]._destroy()}function N(e,t,r){this.count=e,this.offset=t,this.bucket=r}function B(e){return o.dot(o.UNIT_X,e._boundingVolume.center)<0||e._boundingVolume.intersect(a.UNIT_Y)===p.INTERSECTING}var F=x.SHOW_INDEX,V=x.WIDTH_INDEX,k=x.POSITION_INDEX,U=x.MATERIAL_INDEX,W=x.POSITION_SIZE_INDEX,q=x.NUMBER_OF_PROPERTIES,G={texCoordExpandWidthAndShow:0,position3DHigh:1,position3DLow:2,position2DHigh:3,position2DLow:4,prevPosition3DHigh:5,prevPosition3DLow:6,prevPosition2DHigh:7,prevPosition2DLow:8,nextPosition3DHigh:9,nextPosition3DLow:10,nextPosition2DHigh:11,nextPosition2DLow:12,pickColor:13},H=function(t){t=e(t,e.EMPTY_OBJECT),this.modelMatrix=l.clone(e(t.modelMatrix,l.IDENTITY)),this._modelMatrix=l.clone(l.IDENTITY),this.debugShowBoundingVolume=e(t.debugShowBoundingVolume,!1),this._opaqueRS=void 0,this._translucentRS=void 0,this._colorCommands=[],this._pickCommands=[],this._polylinesUpdated=!1,this._polylinesRemoved=!1,this._createVertexArray=!1,this._propertiesChanged=new Uint32Array(q),this._polylines=[],this._polylineBuckets={},this._buffersUsage=[{bufferUsage:v.STATIC_DRAW,frameCount:0},{bufferUsage:v.STATIC_DRAW,frameCount:0},{bufferUsage:v.STATIC_DRAW,frameCount:0}],this._mode=void 0,this._polylinesToUpdate=[],this._vertexArrays=[],this._positionBuffer=void 0,this._pickColorBuffer=void 0,this._texCoordExpandWidthAndShowBuffer=void 0};H.prototype.add=function(e){var t=new x(e,this);return t._index=this._polylines.length,this._polylines.push(t),this._createVertexArray=!0,t},H.prototype.remove=function(e){if(this.contains(e)){if(this._polylines[e._index]=void 0,this._polylinesRemoved=!0,this._createVertexArray=!0,t(e._bucket)){var r=e._bucket;r.shaderProgram=r.shaderProgram&&r.shaderProgram.release(),r.pickShaderProgram=r.pickShaderProgram&&r.pickShaderProgram.release()}return e._destroy(),!0}return!1},H.prototype.removeAll=function(){R(this),z(this),this._polylineBuckets={},this._polylinesRemoved=!1,this._polylines.length=0,this._polylinesToUpdate.length=0,this._createVertexArray=!0},H.prototype.contains=function(e){return t(e)&&e._polylineCollection===this},H.prototype.get=function(e){if(!t(e))throw new r("index is required.");return O(this),this._polylines[e]},H.prototype.getLength=function(){return O(this),this._polylines.length},H.prototype.update=function(e,r,i){if(O(this),0!==this._polylines.length){I(this,r);var n,o=this._propertiesChanged;if(this._createVertexArray||A(this))D(this,e);else if(this._polylinesUpdated){var a=this._polylinesToUpdate;if(this._mode!==C.SCENE3D)for(var s=a.length,u=0;s>u;++u)n=a[u],n.update();if(o[W]||o[U])D(this,e);else for(var c=a.length,h=this._polylineBuckets,d=0;c>d;++d){n=a[d],o=n._propertiesChanged;var m=n._bucket,p=0;for(var v in h)if(h.hasOwnProperty(v)){if(h[v]===m){(o[k]||o[F]||o[V])&&m.writeUpdate(p,n,this._positionBuffer,this._texCoordExpandWidthAndShowBuffer);break}p+=h[v].lengthOfPositions}n._clean()}a.length=0,this._polylinesUpdated=!1}o=this._propertiesChanged;for(var y=0;q>y;++y)o[y]=0;var g=l.IDENTITY;r.mode===C.SCENE3D&&(g=this.modelMatrix);var _=r.passes,w=0!==r.morphTime;if(t(this._opaqueRS)&&this._opaqueRS.depthTest.enabled===w||(this._opaqueRS=e.createRenderState({depthMask:w,depthTest:{enabled:w}})),t(this._translucentRS)&&this._translucentRS.depthTest.enabled===w||(this._translucentRS=e.createRenderState({blending:f.ALPHA_BLEND,depthMask:!w,depthTest:{enabled:w}})),_.render){var x=this._colorCommands;T(this,e,r,x,i,g,!0)}if(_.pick){var S=this._pickCommands;T(this,e,r,S,i,g,!1)}}};var j=new m,Y=new m;H.prototype.isDestroyed=function(){return!1},H.prototype.destroy=function(){return L(this),R(this),z(this),n(this)};var X=[0,0,0],Z=[];H.prototype._updatePolyline=function(e,t){this._polylinesUpdated=!0,this._polylinesToUpdate.push(e),++this._propertiesChanged[t]};var J=function(e,t,r,i){this.polylines=[],this.lengthOfPositions=0,this.material=e,this.shaderProgram=void 0,this.pickShaderProgram=void 0,this.mode=t,this.projection=r,this.ellipsoid=r.getEllipsoid(),this.modelMatrix=i};J.prototype.addPolyline=function(e){var t=this.polylines;t.push(e),e._actualLength=this.getPolylinePositionsLength(e),this.lengthOfPositions+=e._actualLength,e._bucket=this},J.prototype.updateShader=function(e){if(!t(this.shaderProgram)){var r=g({sources:[S,E]}),i=g({sources:[this.material.shaderSource,b]}),n=g({sources:[i],pickColorQualifier:"varying"});this.shaderProgram=e.getShaderCache().getShaderProgram(r,i,G),this.pickShaderProgram=e.getShaderCache().getShaderProgram(r,n,G)}},J.prototype.getPolylinePositionsLength=function(e){var t;if(this.mode===C.SCENE3D||!B(e))return t=e.getPositions().length,4*t-4;var r=0,i=e._segments.lengths;t=i.length;for(var n=0;t>n;++n)r+=4*i[n]-4;return r};var K=new o,Q=new o,$=new o,et=new o;J.prototype.write=function(e,t,r,n,a,l,u){for(var c=this.mode,h=this.polylines,d=h.length,m=0;d>m;++m)for(var p,f=h[m],v=f.getWidth(),y=f.getShow()&&v>0,g=this.getSegments(f),_=g.positions,w=g.lengths,x=_.length,S=f.getPickId(u).color,E=0,b=0,T=0;x>T;++T){0===T?(p=et,o.subtract(_[0],_[1],p),o.add(_[0],p,p)):p=_[T-1],Q.x=p.x,Q.y=p.y,Q.z=c!==C.SCENE2D?p.z:0,p=_[T],K.x=p.x,K.y=p.y,K.z=c!==C.SCENE2D?p.z:0,T===x-1?(p=et,o.subtract(_[x-1],_[x-2],p),o.add(_[x-1],p,p)):p=_[T+1],$.x=p.x,$.y=p.y,$.z=c!==C.SCENE2D?p.z:0;var A=w[E];T===b+A&&(b+=A,++E);for(var D=0===T-b,P=T===b+w[E]-1,M=D?2:0,I=P?2:4,O=M;I>O;++O){s.writeElements(K,e,n),s.writeElements(Q,e,n+6),s.writeElements($,e,n+12),t[a]=i.floatToByte(S.red),t[a+1]=i.floatToByte(S.green),t[a+2]=i.floatToByte(S.blue),t[a+3]=i.floatToByte(S.alpha);var R=0>O-2?-1:1;r[l]=T/(x-1),r[l+1]=2*(O%2)-1,r[l+2]=R*v,r[l+3]=y,n+=18,a+=4,l+=4}}};var tt=new o,rt=new o,it=new o,nt=new o;J.prototype.writeForMorph=function(e,t){for(var r=this.modelMatrix,i=this.polylines,n=i.length,a=0;n>a;++a)for(var u=i[a],c=u._segments.positions,h=u._segments.lengths,d=c.length,m=0,p=0,f=0;d>f;++f){var v;0===f?(v=nt,o.subtract(c[0],c[1],v),o.add(c[0],v,v)):v=c[f-1],v=l.multiplyByPoint(r,v,rt);var y,g=l.multiplyByPoint(r,c[f],tt);f===d-1?(y=nt,o.subtract(c[d-1],c[d-2],y),o.add(c[d-1],y,y)):y=c[f+1],y=l.multiplyByPoint(r,y,it);var _=h[m];f===p+_&&(p+=_,++m);for(var w=0===f-p,C=f===p+h[m]-1,x=w?2:0,S=C?2:4,E=x;S>E;++E)s.writeElements(g,e,t),s.writeElements(v,e,t+6),s.writeElements(y,e,t+12),t+=18}};var ot=new Array(1);J.prototype.updateIndices=function(e,t,r,i){var n=r.length-1,o=new N(0,i,this);r[n].push(o);var a=0,s=e[e.length-1],l=0;s.length>0&&(l=s[s.length-1]+1);for(var c=this.polylines,h=c.length,d=0;h>d;++d){var m=c[d];m._locatorBuckets=[];var p;if(this.mode===C.SCENE3D){p=ot;var f=m.getPositions().length;if(!(f>0))continue;p[0]=f}else p=m._segments.lengths;var v=p.length;if(v>0){for(var y=0,g=0;v>g;++g)for(var _=p[g]-1,w=0;_>w;++w)l+4>=u.SIXTY_FOUR_KILOBYTES-1&&(m._locatorBuckets.push({locator:o,count:y}),y=0,t.push(4),s=[],e.push(s),l=0,o.count=a,a=0,i=0,o=new N(0,0,this),r[++n]=[o]),s.push(l,l+2,l+1),s.push(l+1,l+2,l+3),y+=6,a+=6,i+=6,l+=4;m._locatorBuckets.push({locator:o,count:y}),l+4>=u.SIXTY_FOUR_KILOBYTES-1&&(t.push(0),s=[],e.push(s),l=0,o.count=a,i=0,a=0,o=new N(0,0,this),r[++n]=[o])}m._clean()}return o.count=a,i},J.prototype.getPolylineStartIndex=function(e){for(var t=this.polylines,r=0,i=t.length,n=0;i>n;++n){var o=t[n];if(o===e)break;r+=o._actualLength}return r};var at={positions:void 0,lengths:void 0},st=new Array(1);return J.prototype.getSegments=function(e){var t=e.getPositions();if(this.mode===C.SCENE3D)return st[0]=t.length,at.positions=t,at.lengths=st,at;B(e)&&(t=e._segments.positions);for(var r,i,n=this.ellipsoid,a=this.projection,s=[],u=this.modelMatrix,c=t.length,h=0;c>h;++h)r=t[h],i=l.multiplyByPoint(u,r),s.push(a.project(n.cartesianToCartographic(i)));if(s.length>0){e._boundingVolume2D=m.fromPoints(s,e._boundingVolume2D);var d=e._boundingVolume2D.center;e._boundingVolume2D.center=new o(d.z,d.x,d.y)}return at.positions=s,at.lengths=e._segments.lengths,at},J.prototype.writeUpdate=function(e,t,r,i){var n=this.mode,a=t._actualLength;if(a){e+=this.getPolylineStartIndex(t);var l,u=new Float32Array(3*6*a),c=new Float32Array(4*a),h=0,d=0,m=this.getSegments(t),p=m.positions,f=m.lengths,v=0,y=0,g=t.getWidth(),_=t.getShow()&&g>0;a=p.length;for(var w=0;a>w;++w){0===w?(l=et,o.subtract(p[0],p[1],l),o.add(p[0],l,l)):l=p[w-1],Q.x=l.x,Q.y=l.y,Q.z=n!==C.SCENE2D?l.z:0,l=p[w],K.x=l.x,K.y=l.y,K.z=n!==C.SCENE2D?l.z:0,w===a-1?(l=et,o.subtract(p[a-1],p[a-2],l),o.add(p[a-1],l,l)):l=p[w+1],$.x=l.x,$.y=l.y,$.z=n!==C.SCENE2D?l.z:0;var x=f[v];w===y+x&&(y+=x,++v);for(var S=0===w-y,E=w===y+f[v]-1,b=S?2:0,T=E?2:4,A=b;T>A;++A){s.writeElements(K,u,h),s.writeElements(Q,u,h+6),s.writeElements($,u,h+12);var D=0>A-2?-1:1;c[d]=w/(a-1),c[d+1]=2*(A%2)-1,c[d+2]=D*g,c[d+3]=_,h+=18,d+=4}}r.copyFromArrayView(u,18*Float32Array.BYTES_PER_ELEMENT*e),i.copyFromArrayView(c,4*Float32Array.BYTES_PER_ELEMENT*e)}},H}),r("DynamicScene/DynamicPathVisualizer",["../Core/defined","../Core/DeveloperError","../Core/destroyObject","../Core/Cartesian3","../Core/Matrix3","../Core/Matrix4","../Core/Color","../Core/Transforms","../Core/ReferenceFrame","./SampledPositionProperty","./CompositePositionProperty","./TimeIntervalCollectionPositionProperty","../Scene/Material","../Scene/SceneMode","../Scene/PolylineCollection"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p){"use strict";function f(t,r,i,n,o,a,s,l){var u,c=t._property._times,h=s;u=t.getValueInReferenceFrame(r,o,l[h]),e(u)&&(l[h++]=u);for(var d,m,p,f=!e(n)||n.lessThanOrEquals(r)||n.greaterThanOrEquals(i),v=0,y=c.length,g=c[v],_=i,w=!1;y>v;){if(!f&&g.greaterThanOrEquals(n)&&(u=t.getValueInReferenceFrame(n,o,l[h]),e(u)&&(l[h++]=u),f=!0),g.greaterThan(r)&&g.lessThan(_)&&!g.equals(n)&&(u=t.getValueInReferenceFrame(g,o,l[h]),e(u)&&(l[h++]=u)),y-1>v){if(!w){var C=c[v+1],x=g.getSecondsDifference(C);w=x>a,w&&(d=Math.floor(x/a),m=0,p=x/Math.max(d,2),d=Math.max(d-2,1))}if(w&&d>m){g=g.addSeconds(p),m++;continue}}w=!1,v++,g=c[v]}return u=t.getValueInReferenceFrame(i,o,l[h]),e(u)&&(l[h++]=u),h}function v(t,r,i,n,o,a,s,l){for(var u,c=0,h=s,d=r,m=!e(n)||n.lessThanOrEquals(r)||n.greaterThanOrEquals(i);d.lessThan(i);)!m&&d.greaterThanOrEquals(n)&&(m=!0,u=t.getValueInReferenceFrame(n,o,l[h]),e(u)&&(l[h]=u,h++)),u=t.getValueInReferenceFrame(d,o,l[h]),e(u)&&(l[h]=u,h++),c++,d=r.addSeconds(a*c);return u=t.getValueInReferenceFrame(i,o,l[h]),e(u)&&(l[h]=u,h++),h}function y(t,r,i,n,o,a,s,l){for(var u=s,c=t.getIntervals(),h=0;h<c.getLength();h++){var d=c.get(0);if(d.start.lessThanOrEquals(i)){var m=t.getValueInReferenceFrame(i,o,l[u]);e(m)&&(l[u]=m,u++)}}return u}function g(e,t,r,i,n,o,a,s){for(var l=a,d=e.getIntervals(),m=0;m<d.getLength();m++){var p=d.get(0);if(p.start.lessThanOrEquals(r)){var _=p.data;l=_ instanceof u?f(_,p.start,p.stop,i,n,o,l,s):_ instanceof c?g(_,p.start,p.stop,i,n,o,l,s):_ instanceof h?y(_,p.start,p.stop,i,n,o,l,s):v(_,p.start,p.stop,i,n,o,l,s)}}return l}function _(t,r,i,n,o,a,s){e(s)||(s=[]);var l=0;return l=t instanceof u?f(t,r,i,n,o,a,0,s):t instanceof c?g(t,r,i,n,o,a,0,s):t instanceof h?g(t,r,i,n,o,a,0,s):v(t,r,i,n,o,a,0,s),s.length=l,s
}var w=new n,C=function(e,t){this._unusedIndexes=[],this._polylineCollection=new p,this._scene=e,this._referenceFrame=t,e.getPrimitives().add(this._polylineCollection)};C.prototype.update=function(t){if(this._referenceFrame===l.INERTIAL){var r=s.computeIcrfToFixedMatrix(t,w);e(r)||(r=s.computeTemeToPseudoFixedMatrix(t,w)),o.fromRotationTranslation(r,i.ZERO,this._polylineCollection.modelMatrix)}},C.prototype.updateObject=function(t,r){var i=r._path;if(e(i)){var n=r._position;if(e(n)){var o,s,l,u,c=i._show,h=r._pathVisualizerIndex,m=!e(c)||c.getValue(t);if(m){s=i._leadTime;var p;e(s)&&(p=s.getValue(t)),s=i._trailTime;var f;e(s)&&(f=s.getValue(t));var v=r._availability,y=e(v),g=e(p),w=e(f);if(m=y||g&&w){if(w&&(l=t.addSeconds(-f)),g&&(u=t.addSeconds(p)),y){var C=v.getStart(),x=v.getStop();(!w||C.greaterThan(l))&&(l=C),(!g||x.lessThan(u))&&(u=x)}m=l.lessThan(u)}}if(!m)return e(h)&&(o=this._polylineCollection.get(h),o.setShow(!1),r._pathVisualizerIndex=void 0,this._unusedIndexes.push(h)),void 0;var S;if(e(h))o=this._polylineCollection.get(h),S=o.getMaterial().uniforms;else{var E=this._unusedIndexes,b=E.length;b>0?(h=E.pop(),o=this._polylineCollection.get(h)):(h=this._polylineCollection.getLength(),o=this._polylineCollection.add()),r._pathVisualizerIndex=h,o.dynamicObject=r,o.setWidth(1);var T=o.getMaterial();e(T)&&T.type===d.PolylineOutlineType||(T=d.fromType(d.PolylineOutlineType),o.setMaterial(T)),S=T.uniforms,a.clone(a.WHITE,S.color),a.clone(a.BLACK,S.outlineColor),S.outlineWidth=0}o.setShow(!0);var A=60;if(s=i._resolution,e(s)&&(A=s.getValue(t)),o.setPositions(_(n,l,u,t,this._referenceFrame,A,o.getPositions())),s=i._color,e(s)&&(S.color=s.getValue(t,S.color)),s=i._outlineColor,e(s)&&(S.outlineColor=s.getValue(t,S.outlineColor)),s=i._outlineWidth,e(s)&&(S.outlineWidth=s.getValue(t)),s=i._width,e(s)){var D=s.getValue(t);e(D)&&o.setWidth(D)}}}},C.prototype.removeObject=function(t){var r=t._pathVisualizerIndex;if(e(r)){var i=this._polylineCollection.get(r);i.setShow(!1),this._unusedIndexes.push(r),t._pathVisualizerIndex=void 0}},C.prototype.destroy=function(){return this._scene.getPrimitives().remove(this._polylineCollection),r(this)};var x=function(r,i){if(!e(r))throw new t("scene is required.");this._scene=r,this._updaters={},this._dynamicObjectCollection=void 0,this.setDynamicObjectCollection(i)};return x.prototype.getScene=function(){return this._scene},x.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},x.prototype.setDynamicObjectCollection=function(t){var r=this._dynamicObjectCollection;r!==t&&(e(r)&&(r.collectionChanged.removeEventListener(x.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=t,e(t)&&t.collectionChanged.addEventListener(x.prototype._onObjectsRemoved,this))},x.prototype.update=function(r){if(!e(r))throw new t("time is requied.");if(e(this._dynamicObjectCollection)){var i=this._updaters;for(var n in i)i.hasOwnProperty(n)&&i[n].update(r);for(var o=this._dynamicObjectCollection.getObjects(),a=0,s=o.length;s>a;a++){var u=o[a];if(e(u._path)){var c=u._position;if(e(c)){var h=u._pathUpdater,d=l.FIXED;this._scene.mode===m.SCENE3D&&(d=c._referenceFrame);var p=this._updaters[d];h===p&&e(p)?p.updateObject(r,u):(e(h)&&h.removeObject(u),e(p)||(p=new C(this._scene,d),p.update(r),this._updaters[d]=p),u._pathUpdater=p,e(p)&&p.updateObject(r,u))}}}}},x.prototype.removeAllPrimitives=function(){var t=this._updaters;for(var r in t)t.hasOwnProperty(r)&&t[r].destroy();if(this._updaters={},e(this._dynamicObjectCollection))for(var i=this._dynamicObjectCollection.getObjects(),n=i.length-1;n>-1;n--)i[n]._pathUpdater=void 0,i[n]._pathVisualizerIndex=void 0},x.prototype.isDestroyed=function(){return!1},x.prototype.destroy=function(){return this.removeAllPrimitives(),r(this)},x.prototype._onObjectsRemoved=function(t,r,i){for(var n=i.length-1;n>-1;n--){var o=i[n],a=o._pathUpdater;e(a)&&a.removeObject(o)}},x}),r("DynamicScene/DynamicPointVisualizer",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Scene/BillboardCollection","../Renderer/TextureAtlasBuilder"],function(e,t,r,i,n,o,a){"use strict";function s(i,n,o){var a=o._point;if(r(a)){var s=o._position;if(r(s)){var l,m=a._show,p=o._pointVisualizerIndex,f=o.isAvailable(n)&&(!r(m)||m.getValue(n));if(!f)return r(p)&&(l=i._billboardCollection.get(p),l.setShow(!1),l.setImageIndex(-1),o._pointVisualizerIndex=void 0,i._unusedIndexes.push(p)),void 0;var v=!1;if(r(p))l=i._billboardCollection.get(p);else{var y=i._unusedIndexes,g=y.length;g>0?(p=y.pop(),l=i._billboardCollection.get(p)):(p=i._billboardCollection.getLength(),l=i._billboardCollection.add()),o._pointVisualizerIndex=p,l.dynamicObject=o,l._visualizerColor=e.clone(e.WHITE,l._visualizerColor),l._visualizerOutlineColor=e.clone(e.BLACK,l._visualizerOutlineColor),l._visualizerOutlineWidth=0,l._visualizerPixelSize=1,v=!0}l.setShow(!0),c=s.getValue(n,c),r(c)&&l.setPosition(c);var _=a._color;if(r(_)&&(u=_.getValue(n,u),e.equals(l._visualizerColor,u)||(e.clone(u,l._visualizerColor),v=!0)),_=a._outlineColor,r(_)&&(h=_.getValue(n,h),e.equals(l._visualizerOutlineColor,h)||(e.clone(h,l._visualizerOutlineColor),v=!0)),_=a._outlineWidth,r(_)){var w=_.getValue(n);l._visualizerOutlineWidth!==w&&(l._visualizerOutlineWidth=w,v=!0)}if(_=a._pixelSize,r(_)){var C=_.getValue(n);l._visualizerPixelSize!==C&&(l._visualizerPixelSize=C,v=!0)}if(_=a._scaleByDistance,r(_)&&(d=_.getValue(n,d),r(d)&&l.setScaleByDistance(d)),v){var x=t(l._visualizerColor,e.WHITE).toCssColorString(),S=t(l._visualizerOutlineColor,e.BLACK).toCssColorString(),E=t(l._visualizerPixelSize,3),b=t(l._visualizerOutlineWidth,2),T=JSON.stringify([x,E,S,b]);i._textureAtlasBuilder.addTextureFromFunction(T,function(e,t){var r=document.createElement("canvas"),i=E+2*b;r.height=r.width=i;var n=r.getContext("2d");n.clearRect(0,0,i,i),0!==b&&(n.beginPath(),n.arc(i/2,i/2,i/2,0,2*Math.PI,!0),n.closePath(),n.fillStyle=S,n.fill()),n.beginPath(),n.arc(i/2,i/2,E/2,0,2*Math.PI,!0),n.closePath(),n.fillStyle=x,n.fill(),t(r)},function(e){l.setImageIndex(e)})}}}}var l=function(e,t){if(!r(e))throw new n("scene is required.");this._scene=e,this._unusedIndexes=[],this._dynamicObjectCollection=void 0;var i=this._billboardCollection=new o,s=this._textureAtlas=e.getContext().createTextureAtlas();this._textureAtlasBuilder=new a(s),i.setTextureAtlas(s),e.getPrimitives().add(i),this.setDynamicObjectCollection(t)};l.prototype.getScene=function(){return this._scene},l.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},l.prototype.setDynamicObjectCollection=function(e){var t=this._dynamicObjectCollection;t!==e&&(r(t)&&(t.collectionChanged.removeEventListener(l.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,r(e)&&e.collectionChanged.addEventListener(l.prototype._onObjectsRemoved,this))},l.prototype.update=function(e){if(!r(e))throw new n("time is requied.");if(r(this._dynamicObjectCollection))for(var t=this._dynamicObjectCollection.getObjects(),i=0,o=t.length;o>i;i++)s(this,e,t[i])},l.prototype.removeAllPrimitives=function(){if(this._unusedIndexes=[],this._billboardCollection.removeAll(),r(this._dynamicObjectCollection))for(var e=this._dynamicObjectCollection.getObjects(),t=e.length-1;t>-1;t--)e[t]._pointVisualizerIndex=void 0},l.prototype.isDestroyed=function(){return!1},l.prototype.destroy=function(){return this.removeAllPrimitives(),this._scene.getPrimitives().remove(this._billboardCollection),i(this)};var u,c,h,d;return l.prototype._onObjectsRemoved=function(e,t,i){for(var n=this._billboardCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._pointVisualizerIndex;if(r(l)){var u=n.get(l);u.setShow(!1),u.setImageIndex(-1),s._pointVisualizerIndex=void 0,o.push(l)}}},l}),r("Scene/Appearance",["../Core/clone","../Core/defaultValue","../Core/defined","../Renderer/BlendingState","../Renderer/CullFace","../Renderer/createShaderSource"],function(e,t,r,i,n,o){"use strict";var a=function(e){e=t(e,t.EMPTY_OBJECT),this.material=e.material,this.vertexShaderSource=e.vertexShaderSource,this.fragmentShaderSource=e.fragmentShaderSource,this.renderState=e.renderState,this.translucent=t(e.translucent,!0),this.closed=t(e.closed,!1)};return a.prototype.getFragmentShaderSource=function(){return o({defines:[this.flat?"FLAT":"",this.faceForward?"FACE_FORWARD":""],sources:[r(this.material)?this.material.shaderSource:"",this.fragmentShaderSource]})},a.prototype.isTranslucent=function(){return r(this.material)&&this.material.isTranslucent()||!r(this.material)&&this.translucent},a.prototype.getRenderState=function(){var t=this.isTranslucent(),r=e(this.renderState,!1);return t?(r.depthMask=!1,r.blending=i.ALPHA_BLEND):r.depthMask=!0,r},a.getDefaultRenderState=function(e,t){var r={depthTest:{enabled:!0}};return e&&(r.depthMask=!1,r.blending=i.ALPHA_BLEND),t&&(r.cull={enabled:!0,face:n.BACK}),r},a}),r("Shaders/Appearances/EllipsoidSurfaceAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec2 st;\nvarying vec3 v_positionMC;\nvarying vec3 v_positionEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionMC = position3DHigh + position3DLow;\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/EllipsoidSurfaceAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionMC;\nvarying vec3 v_positionEC;\nvarying vec2 v_st;\nvoid main()\n{\nczm_materialInput materialInput;\nvec3 normalEC = czm_normal3D * czm_geodeticSurfaceNormal(v_positionMC, vec3(0.0), vec3(1.0));\n#ifdef FACE_FORWARD\nnormalEC = normalize(faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC));\n#else\nnormalEC = normalize(normalEC);\n#endif\nmaterialInput.s = v_st.s;\nmaterialInput.st = v_st;\nmaterialInput.str = vec3(v_st, 0.0);\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = czm_eastNorthUpToEyeCoordinates(v_positionMC, materialInput.normalEC);\nvec3 positionToEyeEC = -v_positionEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Scene/EllipsoidSurfaceAppearance",["../Core/defaultValue","../Core/defined","../Core/VertexFormat","./Material","./Appearance","../Shaders/Appearances/EllipsoidSurfaceAppearanceVS","../Shaders/Appearances/EllipsoidSurfaceAppearanceFS"],function(e,t,r,i,n,o,a){"use strict";var s=function(r){r=e(r,e.EMPTY_OBJECT);var l=e(r.translucent,!0),u=e(r.aboveGround,!1);this.material=t(r.material)?r.material:i.fromType(i.ColorType),this.vertexShaderSource=e(r.vertexShaderSource,o),this.fragmentShaderSource=e(r.fragmentShaderSource,a),this.renderState=e(r.renderState,n.getDefaultRenderState(l,!u)),this.vertexFormat=s.VERTEX_FORMAT,this.flat=e(r.flat,!1),this.faceForward=e(r.faceForward,!1),this.translucent=l,this.closed=!1,this.aboveGround=u};return s.VERTEX_FORMAT=r.POSITION_AND_ST,s.prototype.getFragmentShaderSource=n.prototype.getFragmentShaderSource,s.prototype.isTranslucent=n.prototype.isTranslucent,s.prototype.getRenderState=n.prototype.getRenderState,s}),r("Renderer/VertexLayout",["../Core/Enumeration"],function(e){"use strict";var t={SEPARATE:new e(0,"SEPARATE"),INTERLEAVED:new e(1,"INTERLEAVED"),validate:function(e){return e===t.SEPARATE||e===t.INTERLEAVED}};return t}),r("Scene/PrimitivePipeline",["../Core/defined","../Core/defaultValue","../Core/Color","../Core/ComponentDatatype","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryPipeline","../Core/Matrix4"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e,t,r){var i,n=!r,o=e.length;if(!n&&o>1){var a=e[0].modelMatrix;for(i=1;o>i;++i)if(!u.equals(a,e[i].modelMatrix)){n=!0;break}}if(n)for(i=0;o>i;++i)l.transformToWorldCoordinates(e[i]);else u.clone(e[0].modelMatrix,t)}function h(e,t){for(var n=e.length,o=0;n>o;++o){var a=e[o],l=a.geometry,u=l.attributes,c=u.position,h=4*(c.values.length/c.componentsPerAttribute);u.pickColor=new s({componentDatatype:i.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(h)});for(var d=t[o],m=r.floatToByte(d.red),p=r.floatToByte(d.green),f=r.floatToByte(d.blue),v=r.floatToByte(d.alpha),y=u.pickColor.values,g=0;h>g;g+=4)y[g]=m,y[g+1]=p,y[g+2]=f,y[g+3]=v}}function d(t){var r,i=t.length,n=[],o=t[0].attributes;for(r in o)if(o.hasOwnProperty(r)){for(var a=o[r],s=!0,l=1;i>l;++l){var u=t[l].attributes[r];if(!e(u)||a.componentDatatype.value!==u.componentDatatype.value||a.componentsPerAttribute!==u.componentsPerAttribute||a.normalize!==u.normalize){s=!1;break}}s&&n.push(r)}return n}function m(e,t){for(var r=e.length,n=0;r>n;++n)for(var o=e[n],l=o.attributes,u=o.geometry,c=a.computeNumberOfVertices(u),h=t.length,d=0;h>d;++d){for(var m=t[d],p=l[m],f=p.componentDatatype,v=p.value,y=v.length,g=i.createTypedArray(f,c*y),_=0;c>_;++_)g.set(v,_*y);u.attributes[m]=new s({componentDatatype:f,componentsPerAttribute:y,normalize:p.normalize,values:g})}}function p(e){var t,r=e.instances,o=e.pickIds,a=e.projection,s=e.elementIndexUintSupported,u=e.allow3DOnly,p=e.allowPicking,f=e.vertexCacheOptimize,v=e.modelMatrix,y=r.length,g=r[0].geometry.primitiveType;for(t=1;y>t;++t)if(r[t].geometry.primitiveType!==g)throw new n("All instance geometries must have the same primitiveType.");if(c(r,v,u),!u)for(t=0;y>t;++t)l.wrapLongitude(r[t].geometry);p&&h(r,o);var _=d(r);if(m(r,_),f)for(t=0;y>t;++t)l.reorderForPostVertexCache(r[t].geometry),l.reorderForPreVertexCache(r[t].geometry);var w,C=l.combine(r),x=C.attributes;if(u)for(w in x)x.hasOwnProperty(w)&&x[w].componentDatatype.value===i.DOUBLE.value&&l.encodeAttribute(C,w,w+"3DHigh",w+"3DLow");else for(w in x)if(x.hasOwnProperty(w)&&x[w].componentDatatype.value===i.DOUBLE.value){var S=w+"3D",E=w+"2D";l.projectTo2D(C,w,S,E,a),l.encodeAttribute(C,S,S+"High",S+"Low"),l.encodeAttribute(C,E,E+"High",E+"Low")}return s?[C]:l.fitToUnsignedShortIndices(C)}function f(e,t,r){for(var n=[],o=e.attributes,a=r.length,s=0;a>s;++s){var l=r[s],u=o[l],c=u.componentDatatype;c.value===i.DOUBLE.value&&(c=i.FLOAT);var h=i.createTypedArray(c,u.values);n.push({index:t[l],componentDatatype:c,componentsPerAttribute:u.componentsPerAttribute,normalize:u.normalize,values:h}),delete o[l]}return n}function v(r,i,n){for(var o=[],s=d(r),l=r.length,u={},c={},h=0;l>h;++h)for(var m=r[h],p=a.computeNumberOfVertices(m.geometry),f=s.length,v=0;f>v;++v)for(var y=s[v],g=n[y],_=p;_>0;){for(var w,C=t(c[y],0),x=i[C],S=x.length,E=0;S>E&&(w=x[E],w.index!==g);++E);e(o[h])||(o[h]={}),e(o[h][y])||(o[h][y]={dirty:!1,value:m.attributes[y].value,indices:[]});var b,T=w.values.length/w.componentsPerAttribute,A=t(u[y],0);T>A+_?(b=_,o[h][y].indices.push({attribute:w,offset:A,count:b}),u[y]=A+_):(b=T-A,o[h][y].indices.push({attribute:w,offset:A,count:b}),u[y]=0,c[y]=C+1),_-=b}return o}function y(e){return{type:e.constructor.name,buffer:e.buffer}}function g(e){return new w[e.type](e.buffer)}if(!o.supportsTypedArrays())return{};var _={};_.combineGeometry=function(e){for(var t={instances:e.instances,pickIds:e.pickIds,ellipsoid:e.ellipsoid,projection:e.projection,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:u.clone(e.modelMatrix)},r=p(t),i=l.createAttributeIndices(r[0]),n=t.instances,o=d(n),a=[],s=r.length,c=0;s>c;++c){var h=r[c];a.push(f(h,i,o))}var m=v(n,a,i);return{geometries:r,modelMatrix:t.modelMatrix,attributeIndices:i,vaAttributes:a,vaAttributeIndices:m}};var w={Int8Array:Int8Array,Uint8Array:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};return _.transferGeometry=function(t,r){var i,n=t.attributes;for(var o in n)n.hasOwnProperty(o)&&e(n[o])&&e(n[o].values)&&(i=n[o].values,r.indexOf(n[o].values.buffer)<0&&r.push(i.buffer),e(i.type)||(n[o].values=y(i)));e(t.indices)&&(i=t.indices,r.push(i.buffer),e(i.type)||(t.indices=y(t.indices)))},_.transferGeometries=function(e,t){for(var r=e.length,i=0;r>i;++i)_.transferGeometry(e[i],t)},_.transferPerInstanceAttributes=function(e,t){for(var r=e.length,i=0;r>i;++i)for(var n=e[i],o=n.length,a=0;o>a;++a){var s=n[a].values;t.push(s.buffer),n[a].values=y(s)}},_.transferInstances=function(e,t){for(var r=e.length,i=0;r>i;++i){var n=e[i];_.transferGeometry(n.geometry,t)}},_.receiveGeometry=function(t){var r=t.attributes;for(var i in r)r.hasOwnProperty(i)&&e(r[i])&&e(r[i].values)&&(r[i].values=g(r[i].values));e(t.indices)&&(t.indices=g(t.indices))},_.receiveGeometries=function(e){for(var t=e.length,r=0;t>r;++r)_.receiveGeometry(e[r])},_.receivePerInstanceAttributes=function(e){for(var t=e.length,r=0;t>r;++r)for(var i=e[r],n=i.length,o=0;n>o;++o)i[o].values=g(i[o].values)},_.receiveInstances=function(e){for(var t=e.length,r=0;t>r;++r){var i=e[r];_.receiveGeometry(i.geometry)}},_}),r("Scene/PrimitiveState",["../Core/Enumeration"],function(e){"use strict";var t={READY:new e(0,"READY"),CREATING:new e(1,"CREATING"),CREATED:new e(2,"CREATED"),COMBINING:new e(3,"COMBINING"),COMBINED:new e(4,"COMBINED"),COMPLETE:new e(5,"COMPLETE"),FAILED:new e(6,"FAILED")};return t}),r("Scene/Primitive",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/destroyObject","../Core/Matrix4","../Core/BoundingSphere","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryInstance","../Core/GeometryInstanceAttribute","../Core/ComponentDatatype","../Core/TaskProcessor","../Core/GeographicProjection","../Core/clone","../Renderer/BufferUsage","../Renderer/VertexLayout","../Renderer/DrawCommand","../Renderer/createShaderSource","../Renderer/CullFace","../Renderer/Pass","./PrimitivePipeline","./PrimitiveState","./SceneMode","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E,b){"use strict";function T(e){return new l({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,values:new e.values.constructor(e.values)})}function A(e){var r=e.attributes,i=new u;for(var n in r)r.hasOwnProperty(n)&&t(r[n])&&(i[n]=T(r[n]));var o;if(t(e.indices)){var l=e.indices;o=new l.constructor(l)}return new s({attributes:i,indices:o,primitiveType:e.primitiveType,boundingSphere:a.clone(e.boundingSphere)})}function D(e){return new h({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,value:new e.value.constructor(e.value)})}function P(e,t){var r=e.attributes,i={};for(var n in r)r.hasOwnProperty(n)&&(i[n]=D(r[n]));return new c({geometry:t,modelMatrix:o.clone(e.modelMatrix),attributes:i})}function M(e,t){for(var r,i="",n="",o="";null!==(r=F.exec(t));){var a=r[1],s="vec4 czm_compute"+a[0].toUpperCase()+a.substr(1)+"()";i+=s+";\n",e.allow3DOnly?o+=s+"\n"+"{\n"+"    return czm_translateRelativeToEye("+a+"3DHigh, "+a+"3DLow);\n"+"}\n\n":(n+="attribute vec3 "+a+"2DHigh;\n"+"attribute vec3 "+a+"2DLow;\n",o+=s+"\n"+"{\n"+"    vec4 p;\n"+"    if (czm_morphTime == 1.0)\n"+"    {\n"+"        p = czm_translateRelativeToEye("+a+"3DHigh, "+a+"3DLow);\n"+"    }\n"+"    else if (czm_morphTime == 0.0)\n"+"    {\n"+"        p = czm_translateRelativeToEye("+a+"2DHigh.zxy, "+a+"2DLow.zxy);\n"+"    }\n"+"    else\n"+"    {\n"+"        p = czm_columbusViewMorph(\n"+"                czm_translateRelativeToEye("+a+"2DHigh.zxy, "+a+"2DLow.zxy),\n"+"                czm_translateRelativeToEye("+a+"3DHigh, "+a+"3DLow),\n"+"                czm_morphTime);\n"+"    }\n"+"    return p;\n"+"}\n\n")}return _({sources:[i,n,t,o]})}function I(e){var t=e.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,"void czm_old_main()"),r="attribute vec4 pickColor; \nvarying vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    czm_pickColor = pickColor; \n}";return t+"\n"+r}function O(e,r){if(!t(e._attributeIndices.show))return r;var i=r.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,"void czm_non_show_main()"),n="attribute float show;\nvoid main() \n{ \n    czm_non_show_main(); \n    gl_Position *= show; \n}";return i+"\n"+n}function R(e,r){var n=e.getVertexAttributes();for(var o in n)if(n.hasOwnProperty(o)&&!t(r[o]))throw new i("Appearance/Geometry mismatch.  The appearance requires vertex shader attribute input '"+o+"', which was not computed as part of the Geometry.  Use the appearance's vertexFormat property when constructing the geometry.")}function L(r,i,n){for(var o=[],a=n.length,s=0;a>s;++s){var l={primitive:e(n[s].pickPrimitive,i)};t(n[s].id)&&(l.id=n[s].id);var u=r.createPickId(l);i._pickIds.push(u),o.push(u.color)}return o}function z(e,t){return function(){return t[e].value}}function N(e,r,n){return function(o){if(!t(o)||!t(o.length)||o.length<1||o.length>4)throw new i("value must be and array with length between 1 and 4.");var a=r[e];a.value=o,a.dirty||(n.push(a),a.dirty=!0)}}var B=function(t){t=e(t,e.EMPTY_OBJECT),this.geometryInstances=t.geometryInstances,this.appearance=t.appearance,this._appearance=void 0,this._material=void 0,this.modelMatrix=o.clone(o.IDENTITY),this._modelMatrix=new o,this.show=e(t.show,!0),this.vertexCacheOptimize=e(t.vertexCacheOptimize,!1),this.releaseGeometryInstances=e(t.releaseGeometryInstances,!0),this.allow3DOnly=e(t.allow3DOnly,!1),this.allowPicking=e(t.allowPicking,!0),this.asynchronous=e(t.asynchronous,!0),this.debugShowBoundingVolume=e(t.debugShowBoundingVolume,!1),this._translucent=void 0,this._state=S.READY,this._createdGeometries=[],this._geometries=[],this._vaAttributes=void 0,this._error=void 0,this._boundingSphere=void 0,this._boundingSphereWC=void 0,this._boundingSphereCV=void 0,this._boundingSphere2D=void 0,this._perInstanceAttributeIndices=void 0,this._instanceIds=[],this._lastPerInstanceAttributeIndex=0,this._dirtyAttributes=[],this._va=[],this._attributeIndices=void 0,this._primitiveType=void 0,this._frontFaceRS=void 0,this._backFaceRS=void 0,this._sp=void 0,this._pickRS=void 0,this._pickSP=void 0,this._pickIds=[],this._colorCommands=[],this._pickCommands=[]},F=/attribute\s+vec(?:3|4)\s+(.*)3DHigh;/g,V=new m("taskDispatcher",Number.POSITIVE_INFINITY);return B.prototype.update=function(e,r,i){if(!(!this.show||!t(this.geometryInstances)&&0===this._va.length||t(this.geometryInstances)&&Array.isArray(this.geometryInstances)&&0===this.geometryInstances.length||!t(this.appearance)||r.mode!==E.SCENE3D&&this.allow3DOnly||!r.passes.render&&!r.passes.pick)){var n,s,l,u,c,h,m,T,D,z,N,B,F,k=r.scene2D.projection,U=this.allowPicking,W=this;if(this._state!==S.COMPLETE&&this._state!==S.COMBINED)if(this.asynchronous){if(this._state===S.FAILED)throw this._error;if(this._state===S.READY){N=Array.isArray(this.geometryInstances)?this.geometryInstances:[this.geometryInstances],h=N.length;var q=[];for(m=0;h>m;++m)l=N[m].geometry,this._instanceIds.push(N[m].id),t(l.attributes)&&t(l.primitiveType)?this._createdGeometries.push({geometry:A(l),index:m}):q.push(V.scheduleTask({task:l._workerName,geometry:l,index:m}));this._state=S.CREATING,b.all(q,function(e){W._geometries=e,W._state=S.CREATED},function(e){W._error=e,W._state=S.FAILED})}else if(this._state===S.CREATED){for(N=Array.isArray(this.geometryInstances)?this.geometryInstances:[this.geometryInstances],B=new Array(N.length),F=this._geometries.concat(this._createdGeometries),h=F.length,m=0;h>m;++m)l=F[m],D=l.index,B[D]=P(N[D],l.geometry);h=B.length;var G=[];x.transferInstances(B,G),z=V.scheduleTask({task:"combineGeometry",instances:B,pickIds:U?L(e,this,N):void 0,ellipsoid:k.getEllipsoid(),isGeographic:k instanceof p,elementIndexUintSupported:e.getElementIndexUint(),allow3DOnly:this.allow3DOnly,allowPicking:U,vertexCacheOptimize:this.vertexCacheOptimize,modelMatrix:this.modelMatrix},G),this._state=S.COMBINING,b(z,function(e){x.receiveGeometries(e.geometries),x.receivePerInstanceAttributes(e.vaAttributes),W._geometries=e.geometries,W._attributeIndices=e.attributeIndices,W._vaAttributes=e.vaAttributes,W._perInstanceAttributeIndices=e.vaAttributeIndices,o.clone(e.modelMatrix,W.modelMatrix),W._state=S.COMBINED},function(e){W._error=e,W._state=S.FAILED})}}else{for(N=Array.isArray(this.geometryInstances)?this.geometryInstances:[this.geometryInstances],h=N.length,F=this._createdGeometries,m=0;h>m;++m)l=N[m].geometry,this._instanceIds.push(N[m].id),t(l.attributes)&&t(l.primitiveType)?F.push({geometry:A(l),index:m}):F.push({geometry:l.constructor.createGeometry(l),index:m});for(B=new Array(N.length),h=F.length,m=0;h>m;++m)l=F[m],D=l.index,B[D]=P(N[D],l.geometry);var H=x.combineGeometry({instances:B,pickIds:U?L(e,this,N):void 0,ellipsoid:k.getEllipsoid(),projection:k,elementIndexUintSupported:e.getElementIndexUint(),allow3DOnly:this.allow3DOnly,allowPicking:U,vertexCacheOptimize:this.vertexCacheOptimize,modelMatrix:this.modelMatrix});this._geometries=H.geometries,this._attributeIndices=H.attributeIndices,this._vaAttributes=H.vaAttributes,this._perInstanceAttributeIndices=H.vaAttributeIndices,o.clone(H.modelMatrix,this.modelMatrix),this._state=S.COMBINED}var j=this._attributeIndices;if(this._state===S.COMBINED){F=this._geometries;var Y=this._vaAttributes;this._boundingSphere=a.clone(F[0].boundingSphere);var X=[];for(h=F.length,m=0;h>m;++m){l=F[m],u=Y[m];var Z=u.length;for(T=0;Z>T;++T)c=u[T],c.vertexBuffer=e.createVertexBuffer(c.values,v.DYNAMIC_DRAW),delete c.values;X.push(e.createVertexArrayFromGeometry({geometry:l,attributeIndices:j,bufferUsage:v.STATIC_DRAW,vertexLayout:y.INTERLEAVED,vertexArrayAttributes:u}))}this._va=X,this._primitiveType=F[0].primitiveType,this.releaseGeometryInstances&&(this.geometryInstances=void 0),this._geomtries=void 0,this._createdGeometries=void 0,this._state=S.COMPLETE}if(this._state===S.COMPLETE){var J=this.appearance,K=J.material,Q=!1,$=!1;this._appearance!==J?(this._appearance=J,this._material=K,Q=!0,$=!0):this._material!==K&&(this._material=K,$=!0);var et=this._appearance.isTranslucent();this._translucent!==et&&(this._translucent=et,Q=!0),t(this._material)&&this._material.update(e);var tt=J.closed&&et;if(Q){var rt=J.getRenderState();if(tt){var it=f(rt,!1);it.cull={enabled:!0,face:w.BACK},this._frontFaceRS=e.createRenderState(it),it.cull.face=w.FRONT,this._backFaceRS=e.createRenderState(it)}else this._frontFaceRS=e.createRenderState(rt),this._backFaceRS=this._frontFaceRS;if(U)this._pickRS=this._backFaceRS;else{var nt=f(rt,!1);nt.colorMask={red:!1,green:!1,blue:!1,alpha:!1},this._pickRS=e.createRenderState(nt)}}if($){var ot=e.getShaderCache(),at=M(this,J.vertexShaderSource);at=O(this,at);var st=J.getFragmentShaderSource();if(this._sp=ot.replaceShaderProgram(this._sp,at,st,j),R(this._sp,j),U){var lt=_({sources:[st],pickColorQualifier:"varying"});this._pickSP=ot.replaceShaderProgram(this._pickSP,I(at),lt,j)}else this._pickSP=ot.getShaderProgram(at,st,j);R(this._pickSP,j)}var ut=this._colorCommands,ct=this._pickCommands;if(Q||$){var ht=t(K)?K._uniforms:void 0,dt=et?C.TRANSLUCENT:C.OPAQUE;ut.length=this._va.length*(tt?2:1),ct.length=this._va.length,h=ut.length;var mt=0,pt=0;for(m=0;h>m;++m)tt&&(n=ut[m],t(n)||(n=ut[m]=new g),n.owner=this,n.primitiveType=this._primitiveType,n.vertexArray=this._va[mt],n.renderState=this._backFaceRS,n.shaderProgram=this._sp,n.uniformMap=ht,n.pass=dt,++m),n=ut[m],t(n)||(n=ut[m]=new g),n.owner=this,n.primitiveType=this._primitiveType,n.vertexArray=this._va[mt],n.renderState=this._frontFaceRS,n.shaderProgram=this._sp,n.uniformMap=ht,n.pass=dt,s=ct[pt],t(s)||(s=ct[pt]=new g),s.owner=this,s.primitiveType=this._primitiveType,s.vertexArray=this._va[mt],s.renderState=this._pickRS,s.shaderProgram=this._pickSP,s.uniformMap=ht,s.pass=dt,++pt,++mt}if(this._dirtyAttributes.length>0){for(u=this._dirtyAttributes,h=u.length,m=0;h>m;++m){c=u[m];var ft=c.value,vt=c.indices,yt=vt.length;for(T=0;yt>T;++T){D=vt[T];for(var gt=D.offset,_t=D.count,wt=D.attribute,Ct=wt.componentDatatype,xt=wt.componentsPerAttribute,St=d.createTypedArray(Ct,_t*xt),Et=0;_t>Et;++Et)St.set(ft,Et*xt);var bt=gt*xt*Ct.sizeInBytes;wt.vertexBuffer.copyFromArrayView(St,bt)}c.dirty=!1}u.length=0}o.equals(this.modelMatrix,this._modelMatrix)||(o.clone(this.modelMatrix,this._modelMatrix),this._boundingSphereWC=a.transform(this._boundingSphere,this.modelMatrix,this._boundingSphereWC),!this.allow3DOnly&&t(this._boundingSphere)&&(this._boundingSphereCV=a.projectTo2D(this._boundingSphereWC,k,this._boundingSphereCV),this._boundingSphere2D=a.clone(this._boundingSphereCV,this._boundingSphere2D),this._boundingSphere2D.center.x=0));var Tt;r.mode===E.SCENE3D?Tt=this._boundingSphereWC:r.mode===E.COLUMBUS_VIEW?Tt=this._boundingSphereCV:r.mode===E.SCENE2D&&t(this._boundingSphere2D)?Tt=this._boundingSphere2D:t(this._boundingSphereWC)&&t(this._boundingSphereCV)&&(Tt=a.union(this._boundingSphereWC,this._boundingSphereCV));var At=r.passes;if(At.render)for(h=ut.length,m=0;h>m;++m)ut[m].modelMatrix=this.modelMatrix,ut[m].boundingVolume=Tt,ut[m].debugShowBoundingVolume=this.debugShowBoundingVolume,i.push(ut[m]);if(At.pick)for(h=ct.length,m=0;h>m;++m)ct[m].modelMatrix=this.modelMatrix,ct[m].boundingVolume=Tt,i.push(ct[m])}}},B.prototype.getGeometryInstanceAttributes=function(e){if(!t(e))throw new i("id is required");if(!t(this._perInstanceAttributeIndices))throw new i("must call update before calling getGeometryInstanceAttributes");for(var n=-1,o=this._lastPerInstanceAttributeIndex,a=this._instanceIds,s=a.length,l=0;s>l;++l){var u=(o+l)%s;if(e===a[u]){n=u;break}}if(-1===n)return void 0;var c=this._perInstanceAttributeIndices[n],h={},d={},m=!1;for(var p in c)c.hasOwnProperty(p)&&(m=!0,d[p]={get:z(p,c),set:N(p,c,this._dirtyAttributes)});return m&&r(h,d),this._lastPerInstanceAttributeIndex=n,h},B.prototype.isDestroyed=function(){return!1},B.prototype.destroy=function(){var e,t;this._sp=this._sp&&this._sp.release(),this._pickSP=this._pickSP&&this._pickSP.release();var r=this._va;for(e=r.length,t=0;e>t;++t)r[t].destroy();this._va=void 0;var i=this._pickIds;for(e=i.length,t=0;e>t;++t)i[t].destroy();return this._pickIds=void 0,n(this)},B}),r("Scene/Polygon",["../Core/DeveloperError","../Core/defaultValue","../Core/defined","../Core/Color","../Core/destroyObject","../Core/Math","../Core/Ellipsoid","../Core/GeometryInstance","../Core/PolygonGeometry","./EllipsoidSurfaceAppearance","./Primitive","./Material"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";var d=function(n){n=t(n,t.EMPTY_OBJECT),this.ellipsoid=t(n.ellipsoid,a.WGS84),this._ellipsoid=void 0,this.granularity=t(n.granularity,o.RADIANS_PER_DEGREE),this._granularity=void 0,this.height=t(n.height,0),this._height=void 0,this.textureRotationAngle=t(n.textureRotationAngle,0),this._textureRotationAngle=void 0,this.show=t(n.show,!0);var s=h.fromType(h.ColorType);if(s.uniforms.color=new i(1,1,0,.5),this.material=t(n.material,s),this.id=n.id,this._id=void 0,this.asynchronous=t(n.asynchronous,!0),this.debugShowBoundingVolume=t(n.debugShowBoundingVolume,!1),this._positions=void 0,this._polygonHierarchy=void 0,this._createPrimitive=!1,this._primitive=void 0,r(n.positions)&&r(n.polygonHierarchy))throw new e("Either options.positions or options.polygonHierarchy can be provided, but not both.");r(n.positions)?this.setPositions(n.positions):r(n.polygonHierarchy)&&this.configureFromPolygonHierarchy(n.polygonHierarchy)};return d.prototype.getPositions=function(){return this._positions},d.prototype.setPositions=function(t){if(r(t)&&t.length<3)throw new e("At least three positions are required.");this._positions=t,this._polygonHierarchy=void 0,this._createPrimitive=!0},d.prototype.configureFromPolygonHierarchy=function(e){this._positions=void 0,this._polygonHierarchy=e,this._createPrimitive=!0},d.prototype.update=function(t,i,n){if(!r(this.ellipsoid))throw new e("this.ellipsoid must be defined.");
if(!r(this.material))throw new e("this.material must be defined.");if(this.granularity<0)throw new e("this.granularity and scene2D/scene3D overrides must be greater than zero.");if(this.show&&(this._createPrimitive||r(this._primitive))){if(this._createPrimitive||this._ellipsoid!==this.ellipsoid||this._granularity!==this.granularity||this._height!==this.height||this._textureRotationAngle!==this.textureRotationAngle||this._id!==this.id){if(this._createPrimitive=!1,this._ellipsoid=this.ellipsoid,this._granularity=this.granularity,this._height=this.height,this._textureRotationAngle=this.textureRotationAngle,this._id=this.id,this._primitive=this._primitive&&this._primitive.destroy(),!r(this._positions)&&!r(this._polygonHierarchy))return;var o;o=r(this._positions)?new s({geometry:l.fromPositions({positions:this._positions,height:this.height,vertexFormat:u.VERTEX_FORMAT,stRotation:this.textureRotationAngle,ellipsoid:this.ellipsoid,granularity:this.granularity}),id:this.id,pickPrimitive:this}):new s({geometry:new l({polygonHierarchy:this._polygonHierarchy,height:this.height,vertexFormat:u.VERTEX_FORMAT,stRotation:this.textureRotationAngle,ellipsoid:this.ellipsoid,granularity:this.granularity}),id:this.id,pickPrimitive:this}),this._primitive=new c({geometryInstances:o,appearance:new u({aboveGround:this.height>0}),asynchronous:this.asynchronous})}var a=this._primitive;a.debugShowBoundingVolume=this.debugShowBoundingVolume,a.appearance.material=this.material,a.update(t,i,n)}},d.prototype.isDestroyed=function(){return!1},d.prototype.destroy=function(){return this._primitive=this._primitive&&this._primitive.destroy(),n(this)},d}),r("DynamicScene/DynamicPolygonVisualizer",["../Core/Cartesian3","../Core/defined","../Core/DeveloperError","../Core/destroyObject","../Scene/Polygon","../Scene/Material","./MaterialProperty"],function(e,t,r,i,n,o,a){"use strict";function s(e,r,i){var s=i._polygon;if(t(s)){var l,c=s._show,h=i._ellipse,d=i._position,m=i._vertexPositions,p=i._polygonVisualizerIndex,f=i.isAvailable(r)&&(!t(c)||c.getValue(r)),v=t(m);if(!(f&&(v||t(h)&&t(d))))return t(p)&&(l=e._polygonCollection[p],l.show=!1,i._polygonVisualizerIndex=void 0,e._unusedIndexes.push(p)),void 0;if(t(p))l=e._polygonCollection[p];else{var y=e._unusedIndexes,g=y.length;g>0?(p=y.pop(),l=e._polygonCollection[p]):(p=e._polygonCollection.length,l=new n,l.asynchronous=!1,e._polygonCollection.push(l),e._primitives.add(l)),i._polygonVisualizerIndex=p,l.dynamicObject=i,l.material=o.fromType(o.ColorType)}l.show=!0;var _;_=v?m.getValue(r):h.getValue(r,d.getValue(r,u)),l._visualizerPositions!==_&&t(_)&&_.length>3&&(l.setPositions(_),l._visualizerPositions=_),l.material=a.getValue(r,s._material,l.material)}}var l=function(e,i){if(!t(e))throw new r("scene is required.");this._scene=e,this._unusedIndexes=[],this._primitives=e.getPrimitives(),this._polygonCollection=[],this._dynamicObjectCollection=void 0,this.setDynamicObjectCollection(i)};l.prototype.getScene=function(){return this._scene},l.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},l.prototype.setDynamicObjectCollection=function(e){var r=this._dynamicObjectCollection;r!==e&&(t(r)&&(r.collectionChanged.removeEventListener(l.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,t(e)&&e.collectionChanged.addEventListener(l.prototype._onObjectsRemoved,this))},l.prototype.update=function(e){if(!t(e))throw new r("time is requied.");if(t(this._dynamicObjectCollection))for(var i=this._dynamicObjectCollection.getObjects(),n=0,o=i.length;o>n;n++)s(this,e,i[n])},l.prototype.removeAllPrimitives=function(){var e,r;for(e=0,r=this._polygonCollection.length;r>e;e++)this._primitives.remove(this._polygonCollection[e]);if(t(this._dynamicObjectCollection)){var i=this._dynamicObjectCollection.getObjects();for(e=i.length-1;e>-1;e--)i[e]._polygonVisualizerIndex=void 0}this._unusedIndexes=[],this._polygonCollection=[]},l.prototype.isDestroyed=function(){return!1},l.prototype.destroy=function(){return this.removeAllPrimitives(),i(this)};var u=new e;return l.prototype._onObjectsRemoved=function(e,r,i){for(var n=this._polygonCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._polygonVisualizerIndex;if(t(l)){var u=n[l];u.show=!1,o.push(l),s._polygonVisualizerIndex=void 0}}},l}),r("DynamicScene/DynamicPolylineVisualizer",["../Core/DeveloperError","../Core/defined","../Core/destroyObject","../Core/Cartesian3","./MaterialProperty","../Scene/Material","../Scene/PolylineCollection"],function(e,t,r,i,n,o,a){"use strict";function s(e,r,i){var a=i._polyline;if(t(a)){var s,l=a._show,c=i._ellipse,h=i._position,d=i._vertexPositions,m=i._polylineVisualizerIndex,p=i.isAvailable(r)&&(!t(l)||l.getValue(r));if(e._scene.getContext(),!(p&&(t(d)||t(c)&&t(h))))return t(m)&&(s=e._polylineCollection.get(m),s.setShow(!1),i._polylineVisualizerIndex=void 0,e._unusedIndexes.push(m)),void 0;if(t(m))s=e._polylineCollection.get(m);else{var f=e._unusedIndexes,v=f.length;v>0?(m=f.pop(),s=e._polylineCollection.get(m)):(m=e._polylineCollection.getLength(),s=e._polylineCollection.add()),i._polylineVisualizerIndex=m,s.dynamicObject=i,s.setWidth(1);var y=s.getMaterial();t(y)&&y.type===o.PolylineOutlineType||(y=o.fromType(o.PolylineOutlineType),s.setMaterial(y))}s.setShow(!0);var g;g=t(c)?c.getValue(r,h.getValue(r,u)):d.getValue(r),t(g)&&s._visualizerPositions!==g&&(s.setPositions(g),s._visualizerPositions=g);var _=a._material;if(t(_)&&s.setMaterial(n.getValue(r,_,s.getMaterial())),_=a._width,t(_)){var w=_.getValue(r);t(w)&&s.setWidth(w)}}}var l=function(r,i){if(!t(r))throw new e("scene is required.");this._scene=r,this._unusedIndexes=[],this._primitives=r.getPrimitives();var n=this._polylineCollection=new a;r.getPrimitives().add(n),this._dynamicObjectCollection=void 0,this.setDynamicObjectCollection(i)};l.prototype.getScene=function(){return this._scene},l.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},l.prototype.setDynamicObjectCollection=function(e){var r=this._dynamicObjectCollection;r!==e&&(t(r)&&(r.collectionChanged.removeEventListener(l.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,t(e)&&e.collectionChanged.addEventListener(l.prototype._onObjectsRemoved,this))},l.prototype.update=function(r){if(!t(r))throw new e("time is requied.");if(t(this._dynamicObjectCollection))for(var i=this._dynamicObjectCollection.getObjects(),n=0,o=i.length;o>n;n++)s(this,r,i[n])},l.prototype.removeAllPrimitives=function(){var e;if(this._polylineCollection.removeAll(),t(this._dynamicObjectCollection)){var r=this._dynamicObjectCollection.getObjects();for(e=r.length-1;e>-1;e--)r[e]._polylineVisualizerIndex=void 0}this._unusedIndexes=[]},l.prototype.isDestroyed=function(){return!1},l.prototype.destroy=function(){return this.removeAllPrimitives(),this._scene.getPrimitives().remove(this._polylineCollection),r(this)};var u=new i;return l.prototype._onObjectsRemoved=function(e,r,i){for(var n=this._polylineCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._polylineVisualizerIndex;if(t(l)){var u=n.get(l);u.setShow(!1),o.push(l),s._polylineVisualizerIndex=void 0}}},l}),r("DynamicScene/DynamicPyramidVisualizer",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/destroyObject","../Core/Cartesian3","../Core/Color","../Core/Matrix3","../Core/Matrix4","../Core/Quaternion","../Scene/CustomSensorVolume","../Scene/Material","./MaterialProperty"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";function d(r,i,d){var p=d._pyramid;if(t(p)){var y=p._directions;if(t(y)){var g=d._position;if(t(g)){var _=d._orientation;if(t(_)){var w,C=p._show,x=d._pyramidVisualizerIndex,S=d.isAvailable(i)&&(!t(C)||C.getValue(i));if(!S)return t(x)&&(w=r._pyramidCollection[x],w.show=!1,d._pyramidVisualizerIndex=void 0,r._unusedIndexes.push(x)),void 0;if(t(x))w=r._pyramidCollection[x];else{var E=r._unusedIndexes,b=E.length;b>0?(x=E.pop(),w=r._pyramidCollection[x]):(x=r._pyramidCollection.length,w=new u,r._pyramidCollection.push(w),r._primitives.add(w)),d._pyramidVisualizerIndex=x,w.dynamicObject=d,w.radius=Number.POSITIVE_INFINITY,w.showIntersection=!0,w.intersectionColor=o.YELLOW,w.intersectionWidth=5,w.material=c.fromType(c.ColorType)}w.show=!0;var T=y.getValue(i);t(T)&&w._visualizerDirections!==T&&(w.setDirections(T),w._visualizerDirections=T),f=e(g.getValue(i,f),w._visualizerPosition),v=e(_.getValue(i,v),w._visualizerOrientation),!t(f)||!t(v)||n.equals(f,w._visualizerPosition)&&l.equals(v,w._visualizerOrientation)||(s.fromRotationTranslation(a.fromQuaternion(v,m),f,w.modelMatrix),n.clone(f,w._visualizerPosition),l.clone(v,w._visualizerOrientation)),w.material=h.getValue(i,p._material,w.material);var A=p._intersectionColor;if(t(A)){var D=A.getValue(i,D);t(D)&&(w.intersectionColor=D)}if(A=p._intersectionWidth,t(A)){var P=A.getValue(i,P);t(P)&&(w.intersectionWidth=P)}if(A=p._radius,t(A)){var M=A.getValue(i,M);t(M)&&(w.radius=M)}}}}}}var m=new a,p=function(e,i){if(!t(e))throw new r("scene is required.");this._scene=e,this._unusedIndexes=[],this._primitives=e.getPrimitives(),this._pyramidCollection=[],this._dynamicObjectCollection=void 0,this.setDynamicObjectCollection(i)};p.prototype.getScene=function(){return this._scene},p.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},p.prototype.setDynamicObjectCollection=function(e){var r=this._dynamicObjectCollection;r!==e&&(t(r)&&(r.collectionChanged.removeEventListener(p.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,t(e)&&e.collectionChanged.addEventListener(p.prototype._onObjectsRemoved,this))},p.prototype.update=function(e){if(!t(e))throw new r("time is requied.");if(t(this._dynamicObjectCollection))for(var i=this._dynamicObjectCollection.getObjects(),n=0,o=i.length;o>n;n++)d(this,e,i[n])},p.prototype.removeAllPrimitives=function(){var e,r;for(e=0,r=this._pyramidCollection.length;r>e;e++)this._primitives.remove(this._pyramidCollection[e]);if(t(this._dynamicObjectCollection)){var i=this._dynamicObjectCollection.getObjects();for(e=i.length-1;e>-1;e--)i[e]._pyramidVisualizerIndex=void 0}this._unusedIndexes=[],this._pyramidCollection=[]},p.prototype.isDestroyed=function(){return!1},p.prototype.destroy=function(){return this.removeAllPrimitives(),i(this)};var f,v;return p.prototype._onObjectsRemoved=function(e,r,i){for(var n=this._pyramidCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._pyramidVisualizerIndex;if(t(l)){var u=n[l];u.show=!1,o.push(l),s._pyramidVisualizerIndex=void 0}}},p}),r("DynamicScene/DynamicVectorVisualizer",["../Core/DeveloperError","../Core/defined","../Core/destroyObject","../Core/Cartesian3","../Core/Color","../Scene/Material","../Scene/PolylineCollection"],function(e,t,r,i,n,o,a){"use strict";function s(e,r,a){var s=a._vector;if(t(s)){var l,u=s._show,c=a._position,h=s._direction,d=s._length,m=a._vectorVisualizerIndex,p=a.isAvailable(r)&&(!t(u)||u.getValue(r));if(!(p&&t(h)&&t(c)&&t(d)))return t(m)&&(l=e._polylineCollection.get(m),l.setShow(!1),a._vectorVisualizerIndex=void 0,e._unusedIndexes.push(m)),void 0;var f;if(t(m))l=e._polylineCollection.get(m),f=l.getMaterial().uniforms;else{var v=e._unusedIndexes;v.length>0?(m=v.pop(),l=e._polylineCollection.get(m)):(m=e._polylineCollection.getLength(),l=e._polylineCollection.add(),l._visualizerPositions=[new i,new i]),a._vectorVisualizerIndex=m,l.dynamicObject=a,l.setWidth(1);var y=l.getMaterial();t(y)&&y.type===o.PolylineArrowType||(y=o.fromType(o.PolylineArrowType),l.setMaterial(y)),f=y.uniforms,n.clone(n.WHITE,f.color)}l.setShow(!0);var g=l._visualizerPositions,_=c.getValue(r,g[0]),w=h.getValue(r,g[1]),C=d.getValue(r);t(_)&&t(w)&&t(C)&&(i.add(_,i.multiplyByScalar(i.normalize(w,w),C,w),w),l.setPositions(g));var x=s._color;if(t(x)&&(f.color=x.getValue(r,f.color)),x=s._width,t(x)){var S=x.getValue(r);t(S)&&l.setWidth(S)}}}var l=function(r,i){if(!t(r))throw new e("scene is required.");this._scene=r,this._unusedIndexes=[],this._primitives=r.getPrimitives();var n=this._polylineCollection=new a;r.getPrimitives().add(n),this._dynamicObjectCollection=void 0,this.setDynamicObjectCollection(i)};return l.prototype.getScene=function(){return this._scene},l.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},l.prototype.setDynamicObjectCollection=function(e){var r=this._dynamicObjectCollection;r!==e&&(t(r)&&(r.collectionChanged.removeEventListener(l.prototype._onObjectsRemoved,this),this.removeAllPrimitives()),this._dynamicObjectCollection=e,t(e)&&e.collectionChanged.addEventListener(l.prototype._onObjectsRemoved,this))},l.prototype.update=function(r){if(!t(r))throw new e("time is requied.");if(t(this._dynamicObjectCollection))for(var i=this._dynamicObjectCollection.getObjects(),n=0,o=i.length;o>n;n++)s(this,r,i[n])},l.prototype.removeAllPrimitives=function(){var e;if(this._polylineCollection.removeAll(),t(this._dynamicObjectCollection)){var r=this._dynamicObjectCollection.getObjects();for(e=r.length-1;e>-1;e--)r[e]._vectorVisualizerIndex=void 0}this._unusedIndexes=[]},l.prototype.isDestroyed=function(){return!1},l.prototype.destroy=function(){return this.removeAllPrimitives(),this._scene.getPrimitives().remove(this._polylineCollection),r(this)},l.prototype._onObjectsRemoved=function(e,r,i){for(var n=this._polylineCollection,o=this._unusedIndexes,a=i.length-1;a>-1;a--){var s=i[a],l=s._vectorVisualizerIndex;if(t(l)){var u=n.get(l);u.setShow(!1),o.push(l),s._vectorVisualizerIndex=void 0}}},l}),r("DynamicScene/VisualizerCollection",["../Core/defaultValue","../Core/defined","../Core/destroyObject"],function(e,t,r){"use strict";var i=function(e,r){this._visualizers=t(e)?e:[],this._dynamicObjectCollection=void 0,this.setDynamicObjectCollection(r)};return i.prototype.getVisualizers=function(){return this._visualizers.slice(0)},i.prototype.setVisualizers=function(r,i){i=e(i,!0);var n,o=this._visualizers;if(i)for(n=o.length-1;n>-1;n--){var a=o[n];-1===r.indexOf(a)&&a.destroy()}t(r)||(r=[]),this._visualizers=r;var s=this._dynamicObjectCollection;for(n=r.length-1;n>-1;n--)r[n].setDynamicObjectCollection(s)},i.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},i.prototype.setDynamicObjectCollection=function(e){var t=this._dynamicObjectCollection;if(t!==e){this._dynamicObjectCollection=e;for(var r=this._visualizers,i=r.length-1;i>-1;i--)r[i].setDynamicObjectCollection(e)}},i.prototype.update=function(e){for(var t=this._visualizers,r=t.length-1;r>-1;r--)t[r].update(e)},i.prototype.removeAllPrimitives=function(){for(var e=this._visualizers,t=e.length-1;t>-1;t--)e[t].removeAllPrimitives()},i.prototype.isDestroyed=function(){return!1},i.prototype.destroy=function(t){if(t=e(t,!0),this.removeAllPrimitives(),t)for(var i=this._visualizers,n=i.length-1;n>-1;n--)i[n].destroy();return r(this)},i}),r("DynamicScene/DataSourceDisplay",["../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/EventHelper","./DynamicBillboardVisualizer","./DynamicEllipsoidVisualizer","./DynamicConeVisualizerUsingCustomSensor","./DynamicLabelVisualizer","./DynamicPathVisualizer","./DynamicPointVisualizer","./DynamicPolygonVisualizer","./DynamicPolylineVisualizer","./DynamicPyramidVisualizer","./DynamicVectorVisualizer","./VisualizerCollection"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f){"use strict";var v=[o,a,s,l,c,h,d,m,u,p],y=function(r,o,a){if(!t(r))throw new i("scene is required.");if(!t(o))throw new i("dataSourceCollection is required.");this._eventHelper=new n,this._eventHelper.add(o.dataSourceAdded,this._onDataSourceAdded,this),this._eventHelper.add(o.dataSourceRemoved,this._onDataSourceRemoved,this),this._dataSourceCollection=o,this._scene=r,this._timeVaryingSources=[],this._staticSourcesToUpdate=[],this._visualizersTypes=e(a,v).slice(0);for(var s=0,l=o.getLength();l>s;s++)this._onDataSourceAdded(o,o.get(s))};return y.prototype.getScene=function(){return this._scene},y.prototype.getVisualizerTypes=function(){return this._visualizersTypes.slice(0)},y.prototype.getDataSources=function(){return this._dataSourceCollection},y.prototype.isDestroyed=function(){return!1},y.prototype.destroy=function(){this._eventHelper.removeAll();for(var e=this._dataSourceCollection,t=0,i=e.getLength();i>t;++t)this._onDataSourceRemoved(this._dataSourceCollection,e.get(t));return r(this)},y.prototype.update=function(e){if(!t(e))throw new i("time is required.");var r,n=this._timeVaryingSources,o=n.length;for(r=0;o>r;r++)n[r]._visualizerCollection.update(e);var a=this._staticSourcesToUpdate;if(o=a.length,o>0){for(r=0;o>r;r++)a[r]._visualizerCollection.update(e);a.length=0}},y.prototype._onDataSourceAdded=function(e,t){for(var r=this._visualizersTypes,i=r.length,n=new Array(i),o=this._scene,a=0;i>a;a++)n[a]=new r[a](o);var s=new f(n,t.getDynamicObjectCollection());t._visualizerCollection=s,t.getChangedEvent().addEventListener(this._onDataSourceChanged,this),this._onDataSourceChanged(t)},y.prototype._onDataSourceRemoved=function(e,t){t.getChangedEvent().removeEventListener(this._onDataSourceChanged,this);var r=this._timeVaryingSources.indexOf(t);-1!==r&&this._timeVaryingSources.splice(r,1);var i=this._staticSourcesToUpdate.indexOf(t);-1!==i&&this._staticSourcesToUpdate.splice(i,1),t._visualizerCollection.destroy(),t._visualizerCollection=void 0},y.prototype._onDataSourceChanged=function(e){var t=this._timeVaryingSources.indexOf(e),r=this._staticSourcesToUpdate.indexOf(e);e.getIsTimeVarying()?(-1===t&&this._timeVaryingSources.push(e),-1!==r&&this._staticSourcesToUpdate.splice(r,1)):(-1===r&&this._staticSourcesToUpdate.push(e),-1!==t&&this._timeVaryingSources.splice(r,1))},y}),r("Scene/CameraColumbusViewMode",["../Core/Enumeration"],function(e){"use strict";var t={FREE:new e(0,"FREE"),LOCKED:new e(1,"LOCKED")};return t}),r("DynamicScene/DynamicObjectView",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Math","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/Quaternion","../Core/Matrix3","../Core/Matrix4","../Core/Ellipsoid","../Core/Transforms","../Scene/CameraColumbusViewMode","../Scene/SceneMode"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p){"use strict";function f(e,r,i,a,s,l,u,c){var h,d=e.scene,m=d.mode!==e._mode;m?(e._mode=d.mode,e._screenSpaceCameraController.enableTranslate=!1,h=o.magnitude(a)):h=i?o.magnitude(a):r.position.z;var p=s.getValue(l,e._lastCartesian);if(t(p)){var f=u.cartesianToCartographic(p,e._lastCartographic);f.height=h,i||m?(r.controller.setPositionCartographic(f),r.up.z=0,o.normalize(r.up,r.up),r.right.z=0,o.normalize(r.right,r.right),n.clone(r.right,e._first2dUp)):r.position=c.project(f),e._lastDistance=r.frustum.right-r.frustum.left,n.clone(r.right,e._last2dUp)}}function v(e,r,n,a,s,l,c){g(e,r,n,a);var m=s.getValue(l,e._lastCartesian);if(t(m)){var p=!1,f=l.addSeconds(.01),v=s.getValue(f,S);if(t(v)&&!o.equalsEpsilon(m,v,i.EPSILON6)){var y,T=d.computeFixedToIcrfMatrix(l,w),A=d.computeFixedToIcrfMatrix(f,C);t(T)&&t(A)?y=u.transpose(T,x):(y=d.computeTemeToPseudoFixedMatrix(l,x),T=u.transpose(y,w),A=d.computeTemeToPseudoFixedMatrix(f,C),u.transpose(A,A));var D=E;o.normalize(m,D),o.normalize(v,v),u.multiplyByVector(T,D,D),u.multiplyByVector(A,v,v);var P=o.cross(D,v,b);if(!o.equalsEpsilon(P,o.ZERO,i.EPSILON6)){var M=o.cross(P,D,S);u.multiplyByVector(y,M,M),u.multiplyByVector(y,P,P),u.multiplyByVector(y,D,D),o.normalize(M,M),o.normalize(P,P),o.normalize(D,D);var I=_;I[0]=M.x,I[1]=M.y,I[2]=M.z,I[3]=0,I[4]=P.x,I[5]=P.y,I[6]=P.z,I[7]=0,I[8]=D.x,I[9]=D.y,I[10]=D.z,I[11]=0,I[12]=m.x,I[13]=m.y,I[14]=m.z,I[15]=0,r.transform=I,p=!0}}p||(r.transform=d.eastNorthUpToFixedFrame(m,c,_)),e._screenSpaceCameraController.setEllipsoid(h.UNIT_SPHERE);var O=r.position;o.clone(O,e._lastOffset),e._lastDistance=o.magnitude(O)}}function y(e,r,i,n,a,s,l,u){g(e,r,i,n);var d=a.getValue(s,e._lastCartesian);if(t(d)){var p=l.cartesianToCartographic(d,e._lastCartographic),f=u.project(p);T.x=f.z,T.y=f.x,T.z=f.y;var v=r.transform;c.setColumn(v,3,T,v);var y=e._screenSpaceCameraController;y.enableTranslate=!1,y.setEllipsoid(h.UNIT_SPHERE),y.columbusViewMode=m.LOCKED,r.controller.constrainedAxis=o.UNIT_Z;var _=r.position;o.clone(_,e._lastOffset),e._lastDistance=o.magnitude(_)}}function g(e,t,r,a){var s=e.scene;if(t.controller.constrainedAxis=o.UNIT_Z,r)t.controller.lookAt(a,o.ZERO,o.UNIT_Z);else if(s.mode!==e._mode){e._mode=s.mode;var c=e._first2dUp,h=e._last2dUp;if(!n.equals(c,h)){var d=Math.acos(c.x);c.y<0&&(d=i.TWO_PI-d);var m=Math.acos(h.x);h.y<0&&(m=i.TWO_PI-m),h.x=0,h.y=0,c.x=0,c.y=0;var p=m-d,f=l.fromAxisAngle(o.UNIT_Z,p,A);u.multiplyByVector(u.fromQuaternion(f,D),a,a)}o.multiplyByScalar(o.normalize(a,a),e._lastDistance,a),t.controller.lookAt(a,o.ZERO,o.UNIT_Z)}}var _=new c,w=new u,C=new u,x=new u,S=new o,E=new o,b=new o,T=new a(0,0,0,1),A=new l,D=new u,P=new o(1e4,-1e4,1e4),M=new o,I=function(t,r,i){this.dynamicObject=t,this.scene=r,this._lastScene=void 0,this.ellipsoid=e(i,h.WGS84),this._lastDynamicObject=void 0,this._mode=void 0,this._lastCartesian=new o,this._lastCartographic=new s,this._lastDistance=void 0,this._lastOffset=new o,this._offsetScratch=new o,this._first2dUp=new n,this._last2dUp=new n};return I.prototype.update=function(e){if(!t(e))throw new r("time is required.");var i=this.scene;if(!t(i))throw new r("DynamicObjectView.scene is required.");i!==this._lastScene&&(this._lastScene=i,this._screenSpaceCameraController=i.getScreenSpaceCameraController());var n=this.dynamicObject;if(!t(n))throw new r("DynamicObjectView.dynamicObject is required.");var a=this.ellipsoid;if(!t(a))throw new r("DynamicObjectView.ellipsoid is required.");var s=this.dynamicObject.position;if(!t(s))throw new r("dynamicObject.position is required.");var l=n!==this._lastDynamicObject,u=this._offsetScratch;if(l){this._lastDynamicObject=n;var c=this.dynamicObject.viewFrom;t(c)&&t(c.getValue(e,u))||o.clone(P,u);var h=this._first2dUp,d=this._last2dUp;h.x=h.y=0,d.x=d.y=0,o.clone(u,this._lastOffset),this._lastDistance=o.magnitude(u),o.equals(o.normalize(u,M),o.UNIT_Z)&&(u.y-=.01)}else t(this._lastOffset)?u=this._lastOffset:o.clone(P,u);var m=i.mode;m===p.SCENE2D?f(this,i.getCamera(),l,u,s,e,a,i.scene2D.projection):m===p.SCENE3D?v(this,i.getCamera(),l,u,s,e,a):m===p.COLUMBUS_VIEW&&y(this,i.getCamera(),l,u,s,e,a,i.scene2D.projection)},I}),r("ThirdParty/topojson",[],function(){var e=function(){function e(e,t){function r(t){var r=e.arcs[t],i=r[0],n=[0,0];return r.forEach(function(e){n[0]+=e[0],n[1]+=e[1]}),[i,n]}var i={},n={},o={};t.forEach(function(e){var t=r(e);(i[t[0]]||(i[t[0]]=[])).push(e),(i[t[1]]||(i[t[1]]=[])).push(~e)}),t.forEach(function(e){var t,i,a=r(e),s=a[0],l=a[1];if(t=o[s])if(delete o[t.end],t.push(e),t.end=l,i=n[l]){delete n[i.start];var u=i===t?t:t.concat(i);n[u.start=t.start]=o[u.end=i.end]=u}else if(i=o[l]){delete n[i.start],delete o[i.end];var u=t.concat(i.map(function(e){return~e}).reverse());n[u.start=t.start]=o[u.end=i.start]=u}else n[t.start]=o[t.end]=t;else if(t=n[l])if(delete n[t.start],t.unshift(e),t.start=s,i=o[s]){delete o[i.end];var c=i===t?t:i.concat(t);n[c.start=i.start]=o[c.end=t.end]=c}else if(i=n[s]){delete n[i.start],delete o[i.end];var c=i.map(function(e){return~e}).reverse().concat(t);n[c.start=i.end]=o[c.end=t.end]=c}else n[t.start]=o[t.end]=t;else if(t=n[s])if(delete n[t.start],t.unshift(~e),t.start=l,i=o[l]){delete o[i.end];var c=i===t?t:i.concat(t);n[c.start=i.start]=o[c.end=t.end]=c}else if(i=n[l]){delete n[i.start],delete o[i.end];var c=i.map(function(e){return~e}).reverse().concat(t);n[c.start=i.end]=o[c.end=t.end]=c}else n[t.start]=o[t.end]=t;else if(t=o[l])if(delete o[t.end],t.push(~e),t.end=s,i=o[s]){delete n[i.start];var u=i===t?t:t.concat(i);n[u.start=t.start]=o[u.end=i.end]=u}else if(i=n[s]){delete n[i.start],delete o[i.end];var u=t.concat(i.map(function(e){return~e}).reverse());n[u.start=t.start]=o[u.end=i.start]=u}else n[t.start]=o[t.end]=t;else t=[e],n[t.start=s]=o[t.end=l]=t});var a=[];for(var s in o)a.push(o[s]);return a}function t(t,r,i){function o(e){0>e&&(e=~e),(h[e]||(h[e]=[])).push(c)}function a(e){e.forEach(o)}function s(e){e.forEach(a)}function l(e){"GeometryCollection"===e.type?e.geometries.forEach(l):e.type in d&&(c=e,d[e.type](e.arcs))}var u=[];if(arguments.length>1){var c,h=[],d={LineString:a,MultiLineString:s,Polygon:s,MultiPolygon:function(e){e.forEach(s)}};l(r),h.forEach(arguments.length<3?function(e,t){u.push(t)}:function(e,t){i(e[0],e[e.length-1])&&u.push(t)})}else for(var m=0,p=t.arcs.length;p>m;++m)u.push(m);return n(t,{type:"MultiLineString",arcs:e(t,u)})}function r(e,t){return"GeometryCollection"===t.type?{type:"FeatureCollection",features:t.geometries.map(function(t){return i(e,t)})}:i(e,t)}function i(e,t){var r={type:"Feature",id:t.id,properties:t.properties||{},geometry:n(e,t)};return null==t.id&&delete r.id,r}function n(e,t){function r(e,t){t.length&&t.pop();for(var r,i=p[0>e?~e:e],n=0,a=i.length,s=0,l=0;a>n;++n)t.push([(s+=(r=i[n])[0])*c+d,(l+=r[1])*h+m]);0>e&&o(t,a)}function i(e){return[e[0]*c+d,e[1]*h+m]}function n(e){for(var t=[],i=0,n=e.length;n>i;++i)r(e[i],t);return t.length<2&&t.push(t[0]),t}function a(e){for(var t=n(e);t.length<4;)t.push(t[0]);return t}function s(e){return e.map(a)}function l(e){var t=e.type;return"GeometryCollection"===t?{type:t,geometries:e.geometries.map(l)}:t in f?{type:t,coordinates:f[t](e)}:null}var u=e.transform,c=u.scale[0],h=u.scale[1],d=u.translate[0],m=u.translate[1],p=e.arcs,f={Point:function(e){return i(e.coordinates)},MultiPoint:function(e){return e.coordinates.map(i)},LineString:function(e){return n(e.arcs)},MultiLineString:function(e){return e.arcs.map(n)},Polygon:function(e){return s(e.arcs)},MultiPolygon:function(e){return e.arcs.map(s)}};return l(t)}function o(e,t){for(var r,i=e.length,n=i-t;n<--i;)r=e[n],e[n++]=e[i],e[i]=r}function a(e,t){for(var r=0,i=e.length;i>r;){var n=r+i>>>1;e[n]<t?r=n+1:i=n}return r}function s(e){function t(e,t){e.forEach(function(e){0>e&&(e=~e);var r=n[e];r?r.push(t):n[e]=[t]})}function r(e,r){e.forEach(function(e){t(e,r)})}function i(e,t){"GeometryCollection"===e.type?e.geometries.forEach(function(e){i(e,t)}):e.type in s&&s[e.type](e.arcs,t)}var n={},o=e.map(function(){return[]}),s={LineString:t,MultiLineString:r,Polygon:r,MultiPolygon:function(e,t){e.forEach(function(e){r(e,t)})}};e.forEach(i);for(var l in n)for(var u=n[l],c=u.length,h=0;c>h;++h)for(var d=h+1;c>d;++d){var m,p=u[h],f=u[d];(m=o[p])[l=a(m,f)]!==f&&m.splice(l,0,f),(m=o[f])[l=a(m,p)]!==p&&m.splice(l,0,p)}return o}return{version:"1.1.4",mesh:t,feature:r,neighbors:s}}();return e}),r("DynamicScene/GeoJsonDataSource",["../Core/createGuid","../Core/Cartographic","../Core/Color","../Core/defined","../Core/DeveloperError","../Core/getFilenameFromUri","../Core/RuntimeError","../Core/Ellipsoid","../Core/Event","../Core/loadJson","./ConstantProperty","./DynamicObject","./DynamicPoint","./DynamicPolyline","./DynamicPolygon","./ColorMaterialProperty","./DynamicObjectCollection","../ThirdParty/when","../ThirdParty/topojson"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g){"use strict";function _(t,r){var n=t.id;if(i(n)&&"Feature"===t.type){for(var o=2,a=n;i(r.getById(a));)a=n+"_"+o,o++;n=a}else n=e();var s=r.getOrCreateObject(n);return s.geoJson=t,s}function w(e,t){for(var r=new Array(e.length),i=0;i<e.length;i++)r[i]=t(e[i]);return r}function C(e,t,r,n,o){if(!i(t.geometry))throw new a("feature.geometry is required.");if(null===t.geometry)_(t,e._dynamicObjectCollection);else{var s=t.geometry.type,l=R[s];if(!i(l))throw new a("Unknown geometry type: "+s);l(e,t,t.geometry,n,o)}}function x(e,t,r,i,n){for(var o=t.features,a=0,s=o.length;s>a;a++)C(e,o[a],void 0,i,n)}function S(e,t,r,n,o){for(var s=r.geometries,l=0,u=s.length;u>l;l++){var c=s[l],h=c.type,d=R[h];if(!i(d))throw new a("Unknown geometry type: "+h);d(e,t,c,n,o)}}function E(e,t,r,i){var n=_(t,e._dynamicObjectCollection);n.merge(e.defaultPoint),n.position=new c(i(r.coordinates))}function b(e,t,r,i){for(var n=r.coordinates,o=0;o<n.length;o++){var a=_(t,e._dynamicObjectCollection);a.merge(e.defaultPoint),a.position=new c(i(n[o]))}}function T(e,t,r,i){var n=_(t,e._dynamicObjectCollection);n.merge(e.defaultLine),n.vertexPositions=new c(w(r.coordinates,i))}function A(e,t,r,i){for(var n=r.coordinates,o=0;o<n.length;o++){var a=_(t,e._dynamicObjectCollection);a.merge(e.defaultLine),a.vertexPositions=new c(w(n[o],i))}}function D(e,t,r,i){var n=_(t,e._dynamicObjectCollection);n.merge(e.defaultPolygon),n.vertexPositions=new c(w(r.coordinates[0],i))}function P(e,t,r,i,n){for(var o in r.objects)if(r.objects.hasOwnProperty(o)){var a=g.feature(r,r.objects[o]),s=O[a.type];s(e,a,a,i,n)}}function M(e,t,r,i){for(var n=r.coordinates,o=0;o<n.length;o++){var a=n[o],s=_(t,e._dynamicObjectCollection);s.merge(e.defaultPolygon),s.vertexPositions=new c(w(a[0],i))}}function I(e){var r=t.fromDegrees(e[0],e[1],e[2]);return s.WGS84.cartographicToCartesian(r)}var O={Feature:C,FeatureCollection:x,GeometryCollection:S,LineString:T,MultiLineString:A,MultiPoint:b,MultiPolygon:M,Point:E,Polygon:D,Topology:P},R={GeometryCollection:S,LineString:T,MultiLineString:A,MultiPoint:b,MultiPolygon:M,Point:E,Polygon:D,Topology:P},L=function(){var e=new h("GeoJsonDataSource.defaultPoint"),t=new d;t.color=new c(r.YELLOW),t.pixelSize=new c(10),t.outlineColor=new c(r.BLACK),t.outlineWidth=new c(1),e.point=t;var i=new h("GeoJsonDataSource.defaultLine"),n=new m,o=new f;o.color=new c(r.YELLOW),n.material=o,n.width=new c(2),i.polyline=n;var a=new h("GeoJsonDataSource.defaultPolygon");n=new m,o=new f,o.color=new c(r.YELLOW),n.material=o,n.width=new c(1),a.polyline=n;var s=new p;a.polygon=s,o=new f,o.color=new c(new r(1,1,0,.1)),s.material=o,this._changed=new l,this._error=new l,this._dynamicObjectCollection=new v,this.defaultPoint=e,this.defaultLine=i,this.defaultPolygon=a,this._name=void 0};return L.prototype.getName=function(){return this._name},L.prototype.getChangedEvent=function(){return this._changed},L.prototype.getErrorEvent=function(){return this._error},L.prototype.getClock=function(){return void 0},L.prototype.getDynamicObjectCollection=function(){return this._dynamicObjectCollection},L.prototype.getIsTimeVarying=function(){return!1},L.prototype.loadUrl=function(e){if(!i(e))throw new n("url is required.");var t=this;return y(u(e),function(r){return t.load(r,e)},function(e){return t._error.raiseEvent(t,e),y.reject(e)})},L.prototype.load=function(e,t){if(!i(e))throw new n("geoJson is required.");this._name=void 0,i(t)&&(this._name=o(t));var r=O[e.type];if(!i(r))throw new n("Unsupported GeoJSON object type: "+e.type);var s=I,l=e.crs;if(i(l)){if(null===l)throw new a("crs is null.");if(!i(l.properties))throw new a("crs.properties is undefined.");var u=l.properties;if("name"===l.type){if(s=L.crsNames[u.name],!i(s))throw new a("Unknown crs name: "+u.name)}else if("link"===l.type){var c=L.crsLinkHrefs[u.href];if(i(c)||(c=L.crsLinkTypes[u.type]),!i(c))throw new a("Unable to resolve crs link: "+JSON.stringify(u));s=c(u)}else{if("EPSG"!==l.type)throw new a("Unknown crs type: "+l.type);if(s=L.crsNames["EPSG:"+u.code],!i(s))throw new a("Unknown crs EPSG code: "+u.code)}}this._dynamicObjectCollection.removeAll();var h=this;return y(s,function(i){r(h,e,e,i,t),h._changed.raiseEvent(h)},function(e){return h._error.raiseEvent(h,e),y.reject(e)})},L.crsNames={"urn:ogc:def:crs:OGC:1.3:CRS84":I,"EPSG:4326":I},L.crsLinkHrefs={},L.crsLinkTypes={},L}),r("Renderer/UniformDatatype",["../Core/Enumeration"],function(e){"use strict";var t={FLOAT:new e(5126,"FLOAT",{getGLSL:function(){return"float"}}),FLOAT_VEC2:new e(35664,"FLOAT_VEC2",{getGLSL:function(){return"vec2"}}),FLOAT_VEC3:new e(35665,"FLOAT_VEC3",{getGLSL:function(){return"vec3"}}),FLOAT_VEC4:new e(35666,"FLOAT_VEC4",{getGLSL:function(){return"vec4"}}),INT:new e(5124,"INT",{getGLSL:function(){return"int"}}),INT_VEC2:new e(35667,"INT_VEC2",{getGLSL:function(){return"ivec2"
}}),INT_VEC3:new e(35668,"INT_VEC3",{getGLSL:function(){return"ivec3"}}),INT_VEC4:new e(35669,"INT_VEC4",{getGLSL:function(){return"ivec4"}}),BOOL:new e(35670,"BOOL",{getGLSL:function(){return"bool"}}),BOOL_VEC2:new e(35671,"BOOL_VEC2",{getGLSL:function(){return"bvec2"}}),BOOL_VEC3:new e(35672,"BOOL_VEC3",{getGLSL:function(){return"bvec3"}}),BOOL_VEC4:new e(35673,"BOOL_VEC4",{getGLSL:function(){return"bvec4"}}),FLOAT_MAT2:new e(35674,"FLOAT_MAT2",{getGLSL:function(){return"mat2"}}),FLOAT_MAT3:new e(35675,"FLOAT_MAT3",{getGLSL:function(){return"mat3"}}),FLOAT_MAT4:new e(35676,"FLOAT_MAT4",{getGLSL:function(){return"mat4"}}),SAMPLER_2D:new e(35678,"SAMPLER_2D",{getGLSL:function(){return"sampler2D"}}),SAMPLER_CUBE:new e(35680,"SAMPLER_CUBE",{getGLSL:function(){return"samplerCube"}})};return t}),r("Renderer/AutomaticUniforms",["../Core/Cartesian3","../Core/Matrix4","./UniformDatatype"],function(e,t,r){"use strict";var i=new e,n=function(e){this.getSize=e.getSize,this.getDatatype=e.getDatatype,this.getValue=e.getValue};n.prototype.getDeclaration=function(e){var t="uniform "+this.getDatatype().getGLSL()+" "+e,r=this.getSize();return t+=1===r?";":"["+r.toString()+"];"};var o={czm_viewport:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC4},getValue:function(e){var t=e.getViewport();return{x:t.x,y:t.y,z:t.width,w:t.height}}}),czm_viewportOrthographic:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getViewportOrthographic()}}),czm_viewportTransformation:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getViewportTransformation()}}),czm_model:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getModel()}}),czm_inverseModel:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getInverseModel()}}),czm_view:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getView()}}),czm_view3D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getView3D()}}),czm_viewRotation:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getViewRotation()}}),czm_viewRotation3D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getViewRotation3D()}}),czm_inverseView:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getInverseView()}}),czm_inverseView3D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getInverseView3D()}}),czm_inverseViewRotation:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getInverseViewRotation()}}),czm_inverseViewRotation3D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getInverseViewRotation3D()}}),czm_projection:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getProjection()}}),czm_inverseProjection:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getInverseProjection()}}),czm_infiniteProjection:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getInfiniteProjection()}}),czm_modelView:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getModelView()}}),czm_modelView3D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getModelView3D()}}),czm_modelViewRelativeToEye:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getModelViewRelativeToEye()}}),czm_inverseModelView:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getInverseModelView()}}),czm_inverseModelView3D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getInverseModelView3D()}}),czm_viewProjection:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getViewProjection()}}),czm_modelViewProjection:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getModelViewProjection()}}),czm_modelViewProjectionRelativeToEye:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getModelViewProjectionRelativeToEye()}}),czm_modelViewInfiniteProjection:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT4},getValue:function(e){return e.getModelViewInfiniteProjection()}}),czm_normal:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getNormal()}}),czm_normal3D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getNormal3D()}}),czm_inverseNormal:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getInverseNormal()}}),czm_inverseNormal3D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getInverseNormal3D()}}),czm_eyeHeight2D:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC2},getValue:function(e){return e.getEyeHeight2D()}}),czm_entireFrustum:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC2},getValue:function(e){return e.getEntireFrustum()}}),czm_currentFrustum:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC2},getValue:function(e){return e.getCurrentFrustum()}}),czm_pixelSizeInMeters:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT},getValue:function(e){return e.getPixelSize()}}),czm_sunPositionWC:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC3},getValue:function(e){return e.getSunPositionWC()}}),czm_sunPositionColumbusView:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC3},getValue:function(e){return e.getSunPositionColumbusView()}}),czm_sunDirectionEC:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC3},getValue:function(e){return e.getSunDirectionEC()}}),czm_sunDirectionWC:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC3},getValue:function(e){return e.getSunDirectionWC()}}),czm_moonDirectionEC:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC3},getValue:function(e){return e.getMoonDirectionEC()}}),czm_encodedCameraPositionMCHigh:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC3},getValue:function(e){return e.getEncodedCameraPositionMCHigh()}}),czm_encodedCameraPositionMCLow:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC3},getValue:function(e){return e.getEncodedCameraPositionMCLow()}}),czm_viewerPositionWC:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_VEC3},getValue:function(e){return t.getTranslation(e.getInverseView(),i)}}),czm_frameNumber:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT},getValue:function(e){return e.getFrameState().frameNumber}}),czm_morphTime:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT},getValue:function(e){return e.getFrameState().morphTime}}),czm_sceneMode:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT},getValue:function(e){return e.getFrameState().mode.value}}),czm_temeToPseudoFixed:new n({getSize:function(){return 1},getDatatype:function(){return r.FLOAT_MAT3},getValue:function(e){return e.getTemeToPseudoFixedMatrix()}})};return o}),r("Renderer/Buffer",["../Core/DeveloperError","../Core/destroyObject"],function(e,t){"use strict";var r=function(e,t,r,i,n){this._gl=e,this._bufferTarget=t,this._sizeInBytes=r,this._usage=i,this._buffer=n,this._vertexArrayDestroyable=!0};return r.prototype.copyFromArrayView=function(t,r){if(!t)throw new e("arrayView is required.");if(r=r||0,r+t.byteLength>this._sizeInBytes)throw new e("This buffer is not large enough.");var i=this._gl,n=this._bufferTarget;i.bindBuffer(n,this._buffer),i.bufferSubData(n,r,t),i.bindBuffer(n,null)},r.prototype._getBuffer=function(){return this._buffer},r.prototype.getSizeInBytes=function(){return this._sizeInBytes},r.prototype.getUsage=function(){return this._usage},r.prototype.getVertexArrayDestroyable=function(){return this._vertexArrayDestroyable},r.prototype.setVertexArrayDestroyable=function(e){this._vertexArrayDestroyable=e},r.prototype.isDestroyed=function(){return!1},r.prototype.destroy=function(){return this._gl.deleteBuffer(this._buffer),t(this)},r}),r("Renderer/ClearCommand",["../Core/Color","../Core/freezeObject"],function(e,t){"use strict";var r=function(){this.color=void 0,this.depth=void 0,this.stencil=void 0,this.renderState=void 0,this.framebuffer=void 0,this.owner=void 0},i=new r;return i.color=new e(0,0,0,0),i.depth=1,i.stencil=0,r.ALL=t(i),r.prototype.execute=function(e,t){e.clear(this,t)},r}),r("Renderer/Framebuffer",["../Core/DeveloperError","../Core/destroyObject","./PixelFormat"],function(e,t,r){"use strict";function i(e,t,r){e._bind();var i=e._gl;r?i.framebufferTexture2D(i.FRAMEBUFFER,t,r._getTarget(),r._getTexture(),0):i.framebufferTexture2D(i.FRAMEBUFFER,t,i.TEXTURE_2D,null,0),e._unBind()}function n(e,t,r){e._bind();var i=e._gl;r?i.framebufferRenderbuffer(i.FRAMEBUFFER,t,i.RENDERBUFFER,r._getRenderbuffer()):i.framebufferRenderbuffer(i.FRAMEBUFFER,t,i.RENDERBUFFER,null),e._unBind()}function o(e,t){e.destroyAttachments&&t&&t.destroy&&t.destroy()}var a=function(t,r){if(this._gl=t,this._framebuffer=t.createFramebuffer(),this._colorTexture=void 0,this._colorRenderbuffer=void 0,this._depthTexture=void 0,this._depthRenderbuffer=void 0,this._stencilRenderbuffer=void 0,this._depthStencilTexture=void 0,this._depthStencilRenderbuffer=void 0,this.destroyAttachments=!0,r){if(r.colorTexture&&r.colorRenderbuffer)throw new e("Cannot have both a color texture and color renderbuffer attachment.");if(r.depthTexture&&r.depthRenderbuffer)throw new e("Cannot have both a depth texture and depth renderbuffer attachment.");if(r.depthStencilTexture&&r.depthStencilRenderbuffer)throw new e("Cannot have both a depth-stencil texture and depth-stencil renderbuffer attachment.");var i=r.depthTexture||r.depthRenderbuffer,n=r.depthStencilTexture||r.depthStencilRenderbuffer;if(i&&n)throw new e("Cannot have both a depth and depth-stencil attachment.");if(r.stencilRenderbuffer&&n)throw new e("Cannot have both a stencil and depth-stencil attachment.");if(i&&r.stencilRenderbuffer)throw new e("Cannot have both a depth and stencil attachment.");r.colorTexture&&this.setColorTexture(r.colorTexture),r.colorRenderbuffer&&this.setColorRenderbuffer(r.colorRenderbuffer),r.depthTexture&&this.setDepthTexture(r.depthTexture),r.depthRenderbuffer&&this.setDepthRenderbuffer(r.depthRenderbuffer),r.stencilRenderbuffer&&this.setStencilRenderbuffer(r.stencilRenderbuffer),r.depthStencilTexture&&this.setDepthStencilTexture(r.depthStencilTexture),r.depthStencilRenderbuffer&&this.setDepthStencilRenderbuffer(r.depthStencilRenderbuffer)}};return a.prototype._bind=function(){var e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,this._framebuffer)},a.prototype._unBind=function(){var e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,null)},a.prototype.setColorTexture=function(t){if(t&&!r.isColorFormat(t.getPixelFormat()))throw new e("The color-texture pixel-format must be a color format.");i(this,this._gl.COLOR_ATTACHMENT0,t),o(this,this._colorTexture),this._colorTexture=t},a.prototype.getColorTexture=function(){return this._colorTexture},a.prototype.setColorRenderbuffer=function(e){n(this,this._gl.COLOR_ATTACHMENT0,e),o(this,this._colorRenderbuffer),this._colorRenderbuffer=e},a.prototype.getColorRenderbuffer=function(){return this._colorRenderbuffer},a.prototype.setDepthTexture=function(t){if(t&&t.getPixelFormat()!==r.DEPTH_COMPONENT)throw new e("The depth-texture pixel-format must be DEPTH_COMPONENT.");i(this,this._gl.DEPTH_ATTACHMENT,t),o(this,this._depthTexture),this._depthTexture=t},a.prototype.getDepthTexture=function(){return this._depthTexture},a.prototype.setDepthRenderbuffer=function(e){n(this,this._gl.DEPTH_ATTACHMENT,e),o(this,this._depthRenderbuffer),this._depthRenderbuffer=e},a.prototype.getDepthRenderbuffer=function(){return this._depthRenderbuffer},a.prototype.setStencilRenderbuffer=function(e){n(this,this._gl.STENCIL_ATTACHMENT,e),o(this,this._stencilRenderbuffer),this._stencilRenderbuffer=e},a.prototype.getStencilRenderbuffer=function(){return this._stencilRenderbuffer},a.prototype.setDepthStencilTexture=function(t){if(t&&t.getPixelFormat()!==r.DEPTH_STENCIL)throw new e("The depth-stencil pixel-format must be DEPTH_STENCIL.");i(this,this._gl.DEPTH_STENCIL_ATTACHMENT,t),o(this,this._depthStencilTexture),this._depthStencilTexture=t},a.prototype.getDepthStencilTexture=function(){return this._depthStencilTexture},a.prototype.setDepthStencilRenderbuffer=function(e){n(this,this._gl.DEPTH_STENCIL_ATTACHMENT,e),o(this,this._depthStencilRenderbuffer),this._depthStencilRenderbuffer=e},a.prototype.getDepthStencilRenderbuffer=function(){return this._depthStencilRenderbuffer},a.prototype.hasDepthAttachment=function(){return!!(this.getDepthTexture()||this.getDepthRenderbuffer()||this.getDepthStencilTexture()||this.getDepthStencilRenderbuffer())},a.prototype.isDestroyed=function(){return!1},a.prototype.destroy=function(){return this.destroyAttachments&&(this._colorTexture=this._colorTexture&&this._colorTexture.destroy&&this._colorTexture.destroy(),this._colorRenderbuffer=this._colorRenderbuffer&&this._colorRenderbuffer.destroy(),this._depthTexture=this._depthTexture&&this._depthTexture.destroy(),this._depthRenderbuffer=this._depthRenderbuffer&&this._depthRenderbuffer.destroy(),this._stencilRenderbuffer=this._stencilRenderbuffer&&this._stencilRenderbuffer.destroy(),this._depthStencilTexture=this._depthStencilTexture&&this._depthStencilTexture.destroy(),this._depthStencilRenderbuffer=this._depthStencilRenderbuffer&&this._depthStencilRenderbuffer.destroy()),this._gl.deleteFramebuffer(this._framebuffer),t(this)},a}),r("Renderer/PassState",[],function(){"use strict";var e=function(e){this.context=e,this.framebuffer=void 0,this.blendingEnabled=void 0,this.scissorTest=void 0};return e}),r("Renderer/RenderbufferFormat",["../Core/Enumeration"],function(e){"use strict";var t={RGBA4:new e(32854,"RGBA4"),RGB5_A1:new e(32855,"RGB5_A1"),RGB565:new e(36194,"RGB565"),DEPTH_COMPONENT16:new e(33189,"DEPTH_COMPONENT16"),STENCIL_INDEX8:new e(36168,"STENCIL_INDEX8"),DEPTH_STENCIL:new e(34041,"DEPTH_STENCIL"),validate:function(e){return e===t.RGBA4||e===t.RGB5_A1||e===t.RGB565||e===t.DEPTH_COMPONENT16||e===t.STENCIL_INDEX8||e===t.DEPTH_STENCIL}};return t}),r("Renderer/PickFramebuffer",["../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/Color","../Core/BoundingRectangle","./PassState","./RenderbufferFormat"],function(e,t,r,i,n,o,a){"use strict";var s=function(e){var t=new o(e);t.blendingEnabled=!1,t.scissorTest={enabled:!0,rectangle:new n},this._context=e,this._fb=void 0,this._passState=t,this._width=0,this._height=0};s.prototype.begin=function(e){var r=this._context,i=r.getDrawingBufferWidth(),o=r.getDrawingBufferHeight();return n.clone(e,this._passState.scissorTest.rectangle),t(this._fb)&&this._width===i&&this._height===o||(this._width=i,this._height=o,this._fb=this._fb&&this._fb.destroy(),this._fb=r.createFramebuffer({colorTexture:r.createTexture2D({width:i,height:o}),depthRenderbuffer:r.createRenderbuffer({format:a.DEPTH_COMPONENT16})}),this._passState.framebuffer=this._fb),this._passState};var l=new i;return s.prototype.end=function(r){for(var n=e(r.width,1),o=e(r.height,1),a=this._context,s=a.readPixels({x:r.x,y:r.y,width:n,height:o,framebuffer:this._fb}),u=Math.max(n,o),c=u*u,h=Math.floor(.5*n),d=Math.floor(.5*o),m=0,p=0,f=0,v=-1,y=0;c>y;++y){if(m>=-h&&h>=m&&p>=-d&&d>=p){var g=4*((d-p)*n+m+h);l.red=i.byteToFloat(s[g]),l.green=i.byteToFloat(s[g+1]),l.blue=i.byteToFloat(s[g+2]),l.alpha=i.byteToFloat(s[g+3]);var _=a.getObjectByPickColor(l);if(t(_))return _}if(m===p||0>m&&-m===p||m>0&&m===1-p){var w=f;f=-v,v=w}m+=f,p+=v}return void 0},s.prototype.isDestroyed=function(){return!1},s.prototype.destroy=function(){return this._fb=this._fb&&this._fb.destroy(),r(this)},s}),r("Renderer/Renderbuffer",["../Core/destroyObject"],function(e){"use strict";function t(t,r,i,n){var o=t.createRenderbuffer();t.bindRenderbuffer(t.RENDERBUFFER,o),t.renderbufferStorage(t.RENDERBUFFER,r,i,n),t.bindRenderbuffer(t.RENDERBUFFER,null),this.getFormat=function(){return r},this.getWidth=function(){return i},this.getHeight=function(){return n},this._getRenderbuffer=function(){return o},this.isDestroyed=function(){return!1},this.destroy=function(){return t.deleteRenderbuffer(o),e(this)}}return t}),r("Renderer/DepthFunction",["../Core/Enumeration"],function(e){"use strict";var t={NEVER:new e(512,"NEVER"),LESS:new e(513,"LESS"),EQUAL:new e(514,"EQUAL"),LESS_OR_EQUAL:new e(515,"LEQUAL"),GREATER:new e(516,"GREATER"),NOT_EQUAL:new e(517,"NOTEQUAL"),GREATER_OR_EQUAL:new e(518,"GEQUAL"),ALWAYS:new e(519,"ALWAYS"),validate:function(e){return e===t.NEVER||e===t.LESS||e===t.EQUAL||e===t.LESS_OR_EQUAL||e===t.GREATER||e===t.NOT_EQUAL||e===t.GREATER_OR_EQUAL||e===t.ALWAYS}};return t}),r("Renderer/StencilFunction",["../Core/Enumeration"],function(e){"use strict";var t={NEVER:new e(512,"NEVER"),LESS:new e(513,"LESS"),EQUAL:new e(514,"EQUAL"),LESS_OR_EQUAL:new e(515,"LESS_OR_EQUAL"),GREATER:new e(516,"GREATER"),NOT_EQUAL:new e(517,"NOT_EQUAL"),GREATER_OR_EQUAL:new e(518,"GREATER_OR_EQUAL"),ALWAYS:new e(519,"ALWAYS"),validate:function(e){return e===t.NEVER||e===t.LESS||e===t.EQUAL||e===t.LESS_OR_EQUAL||e===t.GREATER||e===t.NOT_EQUAL||e===t.GREATER_OR_EQUAL||e===t.ALWAYS}};return t}),r("Renderer/StencilOperation",["../Core/Enumeration"],function(e){"use strict";var t={ZERO:new e(0,"ZERO"),KEEP:new e(7680,"KEEP"),REPLACE:new e(7681,"REPLACE"),INCREMENT:new e(7682,"INCREMENT"),DECREMENT:new e(7683,"DECREMENT"),INVERT:new e(5386,"INVERT"),INCREMENT_WRAP:new e(34055,"INCREMENT_WRAP"),DECREMENT_WRAP:new e(34056,"DECREMENT_WRAP"),validate:function(e){return e===t.ZERO||e===t.KEEP||e===t.REPLACE||e===t.INCREMENT||e===t.DECREMENT||e===t.INVERT||e===t.INCREMENT_WRAP||e===t.DECREMENT_WRAP}};return t}),r("Renderer/RenderState",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/BoundingRectangle","../Core/RuntimeError","../Core/WindingOrder","./CullFace","./DepthFunction","./BlendEquation","./BlendFunction","./StencilFunction","./StencilOperation"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function m(e,t,r){r?e.enable(t):e.disable(t)}function p(e,t){e.frontFace(t.frontFace)}function f(e,t){var r=t.cull,i=r.enabled;m(e,e.CULL_FACE,i),i&&e.cullFace(r.face)}function v(e,t){e.lineWidth(t.lineWidth)}function y(e,t){var r=t.polygonOffset,i=r.enabled;m(e,e.POLYGON_OFFSET_FILL,i),i&&e.polygonOffset(r.factor,r.units)}function g(e,t,i){var n=t.scissorTest,o=r(i.scissorTest)?i.scissorTest.enabled:n.enabled;if(m(e,e.SCISSOR_TEST,o),o){var a=r(i.scissorTest)?i.scissorTest.rectangle:n.rectangle;e.scissor(a.x,a.y,a.width,a.height)}}function _(e,t){var r=t.depthRange;e.depthRange(r.near,r.far)}function w(e,t){var r=t.depthTest,i=r.enabled;m(e,e.DEPTH_TEST,i),i&&e.depthFunc(r.func)}function C(e,t){var r=t.colorMask;e.colorMask(r.red,r.green,r.blue,r.alpha)}function x(e,t){e.depthMask(t.depthMask)}function S(e,t){e.stencilMask(t.stencilMask)}function E(e,t,i){var n=t.blending,o=r(i.blendingEnabled)?i.blendingEnabled:n.enabled;if(m(e,e.BLEND,o),o){var a=n.color,s=n.equationRgb,l=n.equationAlpha,u=n.functionSourceRgb,c=n.functionDestinationRgb,h=n.functionSourceAlpha,d=n.functionDestinationAlpha;e.blendColor(a.red,a.green,a.blue,a.alpha),e.blendEquationSeparate(s,l),e.blendFuncSeparate(u,c,h,d)}}function b(e,t){var r=t.stencilTest,i=r.enabled;if(m(e,e.STENCIL_TEST,i),i){var n=r.frontFunction,o=r.backFunction,a=r.reference,s=r.mask;e.stencilFunc(r.frontFunction,r.reference,r.mask),e.stencilFuncSeparate(e.BACK,o,a,s),e.stencilFuncSeparate(e.FRONT,n,a,s);var l=r.frontOperation,u=l.fail,c=l.zFail,h=l.zPass;e.stencilOpSeparate(e.FRONT,u,c,h);var d=r.backOperation,p=d.fail,f=d.zFail,v=d.zPass;e.stencilOpSeparate(e.BACK,p,f,v)}}function T(e,t){var r=t.sampleCoverage,i=r.enabled;m(e,e.SAMPLE_COVERAGE,i),i&&e.sampleCoverage(r.value,r.invert)}function A(e,t){m(e,e.DITHER,t.dither)}function D(e,t,i){var n=t.viewport;r(n)||(n=I,n.width=i.context.getDrawingBufferWidth(),n.height=i.context.getDrawingBufferHeight()),i.context.getUniformState().setViewport(n),e.viewport(n.x,n.y,n.width,n.height)}function P(e,t){var r=[];return e.frontFace!==t.frontFace&&r.push(p),(e.cull.enabled!==t.cull.enabled||e.cull.face!==t.cull.face)&&r.push(f),e.lineWidth!==t.lineWidth&&r.push(v),(e.polygonOffset.enabled!==t.polygonOffset.enabled||e.polygonOffset.factor!==t.polygonOffset.factor||e.polygonOffset.units!==t.polygonOffset.units)&&r.push(y),r.push(g),(e.depthRange.near!==t.depthRange.near||e.depthRange.far!==t.depthRange.far)&&r.push(_),(e.depthTest.enabled!==t.depthTest.enabled||e.depthTest.func!==t.depthTest.func)&&r.push(w),(e.colorMask.red!==t.colorMask.red||e.colorMask.green!==t.colorMask.green||e.colorMask.blue!==t.colorMask.blue||e.colorMask.alpha!==t.colorMask.alpha)&&r.push(C),e.depthMask!==t.depthMask&&r.push(x),r.push(E),e.stencilMask!==t.stencilMask&&r.push(S),(e.stencilTest.enabled!==t.stencilTest.enabled||e.stencilTest.frontFunction!==t.stencilTest.frontFunction||e.stencilTest.backFunction!==t.stencilTest.backFunction||e.stencilTest.reference!==t.stencilTest.reference||e.stencilTest.mask!==t.stencilTest.mask||e.stencilTest.frontOperation.fail!==t.stencilTest.frontOperation.fail||e.stencilTest.frontOperation.zFail!==t.stencilTest.frontOperation.zFail||e.stencilTest.backOperation.fail!==t.stencilTest.backOperation.fail||e.stencilTest.backOperation.zFail!==t.stencilTest.backOperation.zFail||e.stencilTest.backOperation.zPass!==t.stencilTest.backOperation.zPass)&&r.push(b),(e.sampleCoverage.enabled!==t.sampleCoverage.enabled||e.sampleCoverage.value!==t.sampleCoverage.value||e.sampleCoverage.invert!==t.sampleCoverage.invert)&&r.push(T),e.dither!==t.dither&&r.push(A),r.push(D),r}var M=function(m,p){var f=t(p,{}),v=t(f.cull,{}),y=t(f.polygonOffset,{}),g=t(f.scissorTest,{}),_=t(g.rectangle,{}),w=t(f.depthRange,{}),C=t(f.depthTest,{}),x=t(f.colorMask,{}),S=t(f.blending,{}),E=t(S.color,{}),b=t(f.stencilTest,{}),T=t(b.frontOperation,{}),A=t(b.backOperation,{}),D=t(f.sampleCoverage,{}),P=f.viewport;if(this.frontFace=t(f.frontFace,a.COUNTER_CLOCKWISE),this.cull={enabled:t(v.enabled,!1),face:t(v.face,s.BACK)},this.lineWidth=t(f.lineWidth,1),this.polygonOffset={enabled:t(y.enabled,!1),factor:t(y.factor,0),units:t(y.units,0)},this.scissorTest={enabled:t(g.enabled,!1),rectangle:n.clone(_)},this.depthRange={near:t(w.near,0),far:t(w.far,1)},this.depthTest={enabled:t(C.enabled,!1),func:t(C.func,l.LESS)},this.colorMask={red:t(x.red,!0),green:t(x.green,!0),blue:t(x.blue,!0),alpha:t(x.alpha,!0)},this.depthMask=t(f.depthMask,!0),this.stencilMask=t(f.stencilMask,-1),this.blending={enabled:t(S.enabled,!1),color:new e(t(E.red,0),t(E.green,0),t(E.blue,0),t(E.alpha,0)),equationRgb:t(S.equationRgb,u.ADD),equationAlpha:t(S.equationAlpha,u.ADD),functionSourceRgb:t(S.functionSourceRgb,c.ONE),functionSourceAlpha:t(S.functionSourceAlpha,c.ONE),functionDestinationRgb:t(S.functionDestinationRgb,c.ZERO),functionDestinationAlpha:t(S.functionDestinationAlpha,c.ZERO)},this.stencilTest={enabled:t(b.enabled,!1),frontFunction:t(b.frontFunction,h.ALWAYS),backFunction:t(b.backFunction,h.ALWAYS),reference:t(b.reference,0),mask:t(b.mask,-1),frontOperation:{fail:t(T.fail,d.KEEP),zFail:t(T.zFail,d.KEEP),zPass:t(T.zPass,d.KEEP)},backOperation:{fail:t(A.fail,d.KEEP),zFail:t(A.zFail,d.KEEP),zPass:t(A.zPass,d.KEEP)}},this.sampleCoverage={enabled:t(D.enabled,!1),value:t(D.value,1),invert:t(D.invert,!1)},this.dither=t(f.dither,!0),this.viewport=r(P)?new n(P.x,P.y,r(P.width)?P.width:m.getDrawingBufferWidth(),r(P.height)?P.height:m.getDrawingBufferHeight()):void 0,!a.validate(this.frontFace))throw new i("Invalid renderState.frontFace.");if(!s.validate(this.cull.face))throw new i("Invalid renderState.cull.face.");if(this.lineWidth<m.getMinimumAliasedLineWidth()||this.lineWidth>m.getMaximumAliasedLineWidth())throw new o("renderState.lineWidth is out of range.  Check getMinimumAliasedLineWidth() and getMaximumAliasedLineWidth().");if(this.scissorTest.rectangle.width<0||this.scissorTest.rectangle.height<0)throw new i("renderState.scissorTest.rectangle.width and renderState.scissorTest.rectangle.height must be greater than or equal to zero.");if(this.depthRange.near>this.depthRange.far)throw new i("renderState.depthRange.near can not be greater than renderState.depthRange.far.");if(this.depthRange.near<0)throw new i("renderState.depthRange.near must be greater than or equal to zero.");if(this.depthRange.far>1)throw new i("renderState.depthRange.far must be less than or equal to one.");if(!l.validate(this.depthTest.func))throw new i("Invalid renderState.depthTest.func.");if(this.blending.color.red<0||this.blending.color.red>1||this.blending.color.green<0||this.blending.color.green>1||this.blending.color.blue<0||this.blending.color.blue>1||this.blending.color.alpha<0||this.blending.color.alpha>1)throw new i("renderState.blending.color components must be greater than or equal to zero and less than or equal to one.");if(!u.validate(this.blending.equationRgb))throw new i("Invalid renderState.blending.equationRgb.");if(!u.validate(this.blending.equationAlpha))throw new i("Invalid renderState.blending.equationAlpha.");if(!c.validate(this.blending.functionSourceRgb))throw new i("Invalid renderState.blending.functionSourceRgb.");if(!c.validate(this.blending.functionSourceAlpha))throw new i("Invalid renderState.blending.functionSourceAlpha.");if(!c.validate(this.blending.functionDestinationRgb))throw new i("Invalid renderState.blending.functionDestinationRgb.");if(!c.validate(this.blending.functionDestinationAlpha))throw new i("Invalid renderState.blending.functionDestinationAlpha.");if(!h.validate(this.stencilTest.frontFunction))throw new i("Invalid renderState.stencilTest.frontFunction.");if(!h.validate(this.stencilTest.backFunction))throw new i("Invalid renderState.stencilTest.backFunction.");if(!d.validate(this.stencilTest.frontOperation.fail))throw new i("Invalid renderState.stencilTest.frontOperation.fail.");if(!d.validate(this.stencilTest.frontOperation.zFail))throw new i("Invalid renderState.stencilTest.frontOperation.zFail.");if(!d.validate(this.stencilTest.frontOperation.zPass))throw new i("Invalid renderState.stencilTest.frontOperation.zPass.");if(!d.validate(this.stencilTest.backOperation.fail))throw new i("Invalid renderState.stencilTest.backOperation.fail.");if(!d.validate(this.stencilTest.backOperation.zFail))throw new i("Invalid renderState.stencilTest.backOperation.zFail.");if(!d.validate(this.stencilTest.backOperation.zPass))throw new i("Invalid renderState.stencilTest.backOperation.zPass.");if(r(this.viewport)){if(this.viewport.width<0)throw new i("renderState.viewport.width must be greater than or equal to zero.");if(this.viewport.width>m.getMaximumViewportWidth())throw new o("renderState.viewport.width must be less than or equal to the maximum viewport width ("+this.getMaximumViewportWidth().toString()+").  Check getMaximumViewportWidth().");if(this.viewport.height<0)throw new i("renderState.viewport.height must be greater than or equal to zero.");if(this.viewport.height>m.getMaximumViewportHeight())throw new o("renderState.viewport.height must be less than or equal to the maximum viewport height ("+this.getMaximumViewportHeight().toString()+").  Check getMaximumViewportHeight().")}this.id=0,this._applyFunctions=[]},I=new n;return M.apply=function(e,t,r){p(e,t),f(e,t),v(e,t),y(e,t),g(e,t,r),_(e,t),w(e,t),C(e,t),x(e,t),S(e,t),E(e,t,r),b(e,t),T(e,t),A(e,t),D(e,t,r)},M.partialApply=function(e,t,i,n){var o=i._applyFunctions[t.id];r(o)||(o=P(t,i),i._applyFunctions[t.id]=o);for(var a=o.length,s=0;a>s;++s)o[s](e,i,n)},M}),r("Renderer/ShaderCache",["../Core/defined","../Core/destroyObject"],function(e,t){"use strict";var r=function(e){this._context=e,this._shaders={},this._shadersToRelease={}};return r.prototype.replaceShaderProgram=function(t,r,i,n){return e(t)&&t.release(),this.getShaderProgram(r,i,n)},r.prototype.getShaderProgram=function(e,t,r){var i,n=e+t+JSON.stringify(r);if(this._shaders[n])i=this._shaders[n],delete this._shadersToRelease[n];else{var o=this._context.createShaderProgram(e,t,r);i={cache:this,shaderProgram:o,keyword:n,count:0},o._cachedShader=i,this._shaders[n]=i}return++i.count,i.shaderProgram},r.prototype.destroyReleasedShaderPrograms=function(){var e=this._shadersToRelease;for(var t in e)if(e.hasOwnProperty(t)){var r=e[t];delete this._shaders[r.keyword],r.shaderProgram.destroy()}this._shadersToRelease={}},r.prototype.releaseShaderProgram=function(e){if(e){var t=e._cachedShader;t&&0===--t.count&&(this._shadersToRelease[t.keyword]=t)}return void 0},r.prototype.isDestroyed=function(){return!1},r.prototype.destroy=function(){var e=this._shaders;for(var r in e)e.hasOwnProperty(r)&&e[r].shaderProgram.destroy();return t(this)},r}),r("Shaders/Builtin/Constants/degreesPerRadian",[],function(){"use strict";return"const float czm_degreesPerRadian = 57.29577951308232;\n"}),r("Shaders/Builtin/Constants/epsilon1",[],function(){"use strict";return"const float czm_epsilon1 = 0.1;\n"}),r("Shaders/Builtin/Constants/epsilon2",[],function(){"use strict";return"const float czm_epsilon2 = 0.01;\n"}),r("Shaders/Builtin/Constants/epsilon3",[],function(){"use strict";return"const float czm_epsilon3 = 0.001;\n"}),r("Shaders/Builtin/Constants/epsilon4",[],function(){"use strict";return"const float czm_epsilon4 = 0.0001;\n"}),r("Shaders/Builtin/Constants/epsilon5",[],function(){"use strict";return"const float czm_epsilon5 = 0.00001;\n"}),r("Shaders/Builtin/Constants/epsilon6",[],function(){"use strict";return"const float czm_epsilon6 = 0.000001;\n"}),r("Shaders/Builtin/Constants/epsilon7",[],function(){"use strict";return"const float czm_epsilon7 = 0.0000001;\n"}),r("Shaders/Builtin/Constants/infinity",[],function(){"use strict";return"const float czm_infinity = 5906376272000.0;\n"}),r("Shaders/Builtin/Constants/oneOverPi",[],function(){"use strict";return"const float czm_oneOverPi = 0.3183098861837907;\n"}),r("Shaders/Builtin/Constants/oneOverTwoPi",[],function(){"use strict";return"const float czm_oneOverTwoPi = 0.15915494309189535;\n"}),r("Shaders/Builtin/Constants/pi",[],function(){"use strict";return"const float czm_pi = 3.141592653589793;\n"}),r("Shaders/Builtin/Constants/piOverFour",[],function(){"use strict";return"const float czm_piOverFour = 0.7853981633974483;\n"}),r("Shaders/Builtin/Constants/piOverSix",[],function(){"use strict";return"const float czm_piOverSix = 0.5235987755982988;\n"}),r("Shaders/Builtin/Constants/piOverThree",[],function(){"use strict";return"const float czm_piOverThree = 1.0471975511965976;\n"}),r("Shaders/Builtin/Constants/piOverTwo",[],function(){"use strict";return"const float czm_piOverTwo = 1.5707963267948966;\n"}),r("Shaders/Builtin/Constants/radiansPerDegree",[],function(){"use strict";return"const float czm_radiansPerDegree = 0.017453292519943295;\n"
}),r("Shaders/Builtin/Constants/sceneMode2D",[],function(){"use strict";return"const float czm_sceneMode2D = 0.0;\n"}),r("Shaders/Builtin/Constants/sceneMode3D",[],function(){"use strict";return"const float czm_sceneMode3D = 2.0;\n"}),r("Shaders/Builtin/Constants/sceneModeColumbusView",[],function(){"use strict";return"const float czm_sceneModeColumbusView = 1.0;\n"}),r("Shaders/Builtin/Constants/sceneModeMorphing",[],function(){"use strict";return"const float czm_sceneModeMorphing = 3.0;\n"}),r("Shaders/Builtin/Constants/solarRadius",[],function(){"use strict";return"const float czm_solarRadius = 695500000.0;\n"}),r("Shaders/Builtin/Constants/threePiOver2",[],function(){"use strict";return"const float czm_threePiOver2 = 4.71238898038469;\n"}),r("Shaders/Builtin/Constants/twoPi",[],function(){"use strict";return"const float czm_twoPi = 6.283185307179586;\n"}),r("Shaders/Builtin/Constants/webMercatorMaxLatitude",[],function(){"use strict";return"const float czm_webMercatorMaxLatitude = 1.4844222297453324;\n"}),r("Shaders/Builtin/Structs/ellipsoid",[],function(){"use strict";return"struct czm_ellipsoid\n{\nvec3 center;\nvec3 radii;\nvec3 inverseRadii;\nvec3 inverseRadiiSquared;\n};\n"}),r("Shaders/Builtin/Structs/material",[],function(){"use strict";return"struct czm_material\n{\nvec3 diffuse;\nfloat specular;\nfloat shininess;\nvec3 normal;\nvec3 emission;\nfloat alpha;\n};\n"}),r("Shaders/Builtin/Structs/materialInput",[],function(){"use strict";return"struct czm_materialInput\n{\nfloat s;\nvec2 st;\nvec3 str;\nvec3 normalEC;\nmat3 tangentToEyeMatrix;\nvec3 positionToEyeEC;\n};\n"}),r("Shaders/Builtin/Structs/ray",[],function(){"use strict";return"struct czm_ray\n{\nvec3 origin;\nvec3 direction;\n};\n"}),r("Shaders/Builtin/Structs/raySegment",[],function(){"use strict";return"struct czm_raySegment\n{\nfloat start;\nfloat stop;\n};\nconst czm_raySegment czm_emptyRaySegment = czm_raySegment(-czm_infinity, -czm_infinity);\nconst czm_raySegment czm_fullRaySegment = czm_raySegment(0.0, czm_infinity);\n"}),r("Shaders/Builtin/Functions/RGBToXYZ",[],function(){"use strict";return"vec3 czm_RGBToXYZ(vec3 rgb)\n{\nconst mat3 RGB2XYZ = mat3(0.4124, 0.2126, 0.0193,\n0.3576, 0.7152, 0.1192,\n0.1805, 0.0722, 0.9505);\nvec3 xyz = RGB2XYZ * rgb;\nvec3 Yxy;\nYxy.r = xyz.g;\nfloat temp = dot(vec3(1.0), xyz);\nYxy.gb = xyz.rg / temp;\nreturn Yxy;\n}\n"}),r("Shaders/Builtin/Functions/XYZToRGB",[],function(){"use strict";return"vec3 czm_XYZToRGB(vec3 Yxy)\n{\nconst mat3 XYZ2RGB = mat3( 3.2405, -0.9693,  0.0556,\n-1.5371,  1.8760, -0.2040,\n-0.4985,  0.0416,  1.0572);\nvec3 xyz;\nxyz.r = Yxy.r * Yxy.g / Yxy.b;\nxyz.g = Yxy.r;\nxyz.b = Yxy.r * (1.0 - Yxy.g - Yxy.b) / Yxy.b;\nreturn XYZ2RGB * xyz;\n}\n"}),r("Shaders/Builtin/Functions/antialias",[],function(){"use strict";return"vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor)\n{\nfloat val1 = clamp(dist / fuzzFactor, 0.0, 1.0);\nfloat val2 = clamp((dist - 0.5) / fuzzFactor, 0.0, 1.0);\nval1 = val1 * (1.0 - val2);\nval1 = val1 * val1 * (3.0 - (2.0 * val1));\nval1 = pow(val1, 0.5);\nvec4 midColor = (color1 + color2) * 0.5;\nreturn mix(midColor, currentColor, val1);\n}\nvec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist)\n{\nreturn czm_antialias(color1, color2, currentColor, dist, 0.1);\n}\n"}),r("Shaders/Builtin/Functions/cellular",[],function(){"use strict";return"vec3 _czm_permute289(vec3 x)\n{\nreturn mod((34.0 * x + 1.0) * x, 289.0);\n}\nvec2 czm_cellular(vec2 P)\n{\n#define K 0.142857142857\n#define Ko 0.428571428571\n#define jitter 1.0\nvec2 Pi = mod(floor(P), 289.0);\nvec2 Pf = fract(P);\nvec3 oi = vec3(-1.0, 0.0, 1.0);\nvec3 of = vec3(-0.5, 0.5, 1.5);\nvec3 px = _czm_permute289(Pi.x + oi);\nvec3 p = _czm_permute289(px.x + Pi.y + oi);\nvec3 ox = fract(p*K) - Ko;\nvec3 oy = mod(floor(p*K),7.0)*K - Ko;\nvec3 dx = Pf.x + 0.5 + jitter*ox;\nvec3 dy = Pf.y - of + jitter*oy;\nvec3 d1 = dx * dx + dy * dy;\np = _czm_permute289(px.y + Pi.y + oi);\nox = fract(p*K) - Ko;\noy = mod(floor(p*K),7.0)*K - Ko;\ndx = Pf.x - 0.5 + jitter*ox;\ndy = Pf.y - of + jitter*oy;\nvec3 d2 = dx * dx + dy * dy;\np = _czm_permute289(px.z + Pi.y + oi);\nox = fract(p*K) - Ko;\noy = mod(floor(p*K),7.0)*K - Ko;\ndx = Pf.x - 1.5 + jitter*ox;\ndy = Pf.y - of + jitter*oy;\nvec3 d3 = dx * dx + dy * dy;\nvec3 d1a = min(d1, d2);\nd2 = max(d1, d2);\nd2 = min(d2, d3);\nd1 = min(d1a, d2);\nd2 = max(d1a, d2);\nd1.xy = (d1.x < d1.y) ? d1.xy : d1.yx;\nd1.xz = (d1.x < d1.z) ? d1.xz : d1.zx;\nd1.yz = min(d1.yz, d2.yz);\nd1.y = min(d1.y, d1.z);\nd1.y = min(d1.y, d2.x);\nreturn sqrt(d1.xy);\n}\n"}),r("Shaders/Builtin/Functions/columbusViewMorph",[],function(){"use strict";return"vec4 czm_columbusViewMorph(vec4 position2D, vec4 position3D, float time)\n{\nvec3 p = mix(position2D.xyz, position3D.xyz, time);\nreturn vec4(p, 1.0);\n}\n"}),r("Shaders/Builtin/Functions/computePosition",[],function(){"use strict";return"vec4 czm_computePosition();\n"}),r("Shaders/Builtin/Functions/eastNorthUpToEyeCoordinates",[],function(){"use strict";return"mat3 czm_eastNorthUpToEyeCoordinates(vec3 positionMC, vec3 normalEC)\n{\nvec3 tangentMC = normalize(vec3(-positionMC.y, positionMC.x, 0.0));\nvec3 tangentEC = normalize(czm_normal3D * tangentMC);\nvec3 bitangentEC = normalize(cross(normalEC, tangentEC));\nreturn mat3(\ntangentEC.x,   tangentEC.y,   tangentEC.z,\nbitangentEC.x, bitangentEC.y, bitangentEC.z,\nnormalEC.x,    normalEC.y,    normalEC.z);\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidContainsPoint",[],function(){"use strict";return"bool czm_ellipsoidContainsPoint(czm_ellipsoid ellipsoid, vec3 point)\n{\nvec3 scaled = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(point, 1.0)).xyz;\nreturn (dot(scaled, scaled) <= 1.0);\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidNew",[],function(){"use strict";return"czm_ellipsoid czm_ellipsoidNew(vec3 center, vec3 radii)\n{\nvec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);\nvec3 inverseRadiiSquared = inverseRadii * inverseRadii;\nczm_ellipsoid temp = czm_ellipsoid(center, radii, inverseRadii, inverseRadiiSquared);\nreturn temp;\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidWgs84TextureCoordinates",[],function(){"use strict";return"vec2 czm_ellipsoidWgs84TextureCoordinates(vec3 normal)\n{\nreturn vec2(atan(normal.y, normal.x) * czm_oneOverTwoPi + 0.5, asin(normal.z) * czm_oneOverPi + 0.5);\n}\n"}),r("Shaders/Builtin/Functions/equalsEpsilon",[],function(){"use strict";return"bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec4(epsilon)));\n}\nbool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec3(epsilon)));\n}\nbool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec2(epsilon)));\n}\nbool czm_equalsEpsilon(float left, float right, float epsilon) {\nreturn (abs(left - right) <= epsilon);\n}\n"}),r("Shaders/Builtin/Functions/eyeOffset",[],function(){"use strict";return"vec4 czm_eyeOffset(vec4 positionEC, vec3 eyeOffset)\n{\nvec4 p = positionEC;\nvec4 zEyeOffset = normalize(p) * eyeOffset.z;\np.xy += eyeOffset.xy + zEyeOffset.xy;\np.z += zEyeOffset.z;\nreturn p;\n}\n"}),r("Shaders/Builtin/Functions/eyeToWindowCoordinates",[],function(){"use strict";return"vec4 czm_eyeToWindowCoordinates(vec4 positionEC)\n{\nvec4 q = czm_projection * positionEC;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n"}),r("Shaders/Builtin/Functions/geodeticSurfaceNormal",[],function(){"use strict";return"vec3 czm_geodeticSurfaceNormal(vec3 positionOnEllipsoid, vec3 ellipsoidCenter, vec3 oneOverEllipsoidRadiiSquared)\n{\nreturn normalize((positionOnEllipsoid - ellipsoidCenter) * oneOverEllipsoidRadiiSquared);\n}\n"}),r("Shaders/Builtin/Functions/getDefaultMaterial",[],function(){"use strict";return"czm_material czm_getDefaultMaterial(czm_materialInput materialInput)\n{\nczm_material material;\nmaterial.diffuse = vec3(0.0);\nmaterial.specular = 0.0;\nmaterial.shininess = 1.0;\nmaterial.normal = materialInput.normalEC;\nmaterial.emission = vec3(0.0);\nmaterial.alpha = 1.0;\nreturn material;\n}\n"}),r("Shaders/Builtin/Functions/getLambertDiffuse",[],function(){"use strict";return"float czm_getLambertDiffuse(vec3 lightDirectionEC, vec3 normalEC)\n{\nreturn max(dot(lightDirectionEC, normalEC), 0.0);\n}\n"}),r("Shaders/Builtin/Functions/getSpecular",[],function(){"use strict";return"float czm_getSpecular(vec3 lightDirectionEC, vec3 toEyeEC, vec3 normalEC, float shininess)\n{\nvec3 toReflectedLight = reflect(-lightDirectionEC, normalEC);\nfloat specular = max(dot(toReflectedLight, toEyeEC), 0.0);\nreturn pow(specular, shininess);\n}\n"}),r("Shaders/Builtin/Functions/getWaterNoise",[],function(){"use strict";return"vec4 czm_getWaterNoise(sampler2D normalMap, vec2 uv, float time, float angleInRadians)\n{\nfloat cosAngle = cos(angleInRadians);\nfloat sinAngle = sin(angleInRadians);\nvec2 s0 = vec2(1.0/17.0, 0.0);\nvec2 s1 = vec2(-1.0/29.0, 0.0);\nvec2 s2 = vec2(1.0/101.0, 1.0/59.0);\nvec2 s3 = vec2(-1.0/109.0, -1.0/57.0);\ns0 = vec2((cosAngle * s0.x) - (sinAngle * s0.y), (sinAngle * s0.x) + (cosAngle * s0.y));\ns1 = vec2((cosAngle * s1.x) - (sinAngle * s1.y), (sinAngle * s1.x) + (cosAngle * s1.y));\ns2 = vec2((cosAngle * s2.x) - (sinAngle * s2.y), (sinAngle * s2.x) + (cosAngle * s2.y));\ns3 = vec2((cosAngle * s3.x) - (sinAngle * s3.y), (sinAngle * s3.x) + (cosAngle * s3.y));\nvec2 uv0 = (uv/103.0) + (time * s0);\nvec2 uv1 = uv/107.0 + (time * s1) + vec2(0.23);\nvec2 uv2 = uv/vec2(897.0, 983.0) + (time * s2) + vec2(0.51);\nvec2 uv3 = uv/vec2(991.0, 877.0) + (time * s3) + vec2(0.71);\nuv0 = fract(uv0);\nuv1 = fract(uv1);\nuv2 = fract(uv2);\nuv3 = fract(uv3);\nvec4 noise = (texture2D(normalMap, uv0)) +\n(texture2D(normalMap, uv1)) +\n(texture2D(normalMap, uv2)) +\n(texture2D(normalMap, uv3));\nreturn ((noise / 4.0) - 0.5) * 2.0;\n}\n"}),r("Shaders/Builtin/Functions/getWgs84EllipsoidEC",[],function(){"use strict";return"czm_ellipsoid czm_getWgs84EllipsoidEC()\n{\nvec3 radii = vec3(6378137.0, 6378137.0, 6356752.314245);\nvec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);\nvec3 inverseRadiiSquared = inverseRadii * inverseRadii;\nczm_ellipsoid temp = czm_ellipsoid(czm_view[3].xyz, radii, inverseRadii, inverseRadiiSquared);\nreturn temp;\n}\n"}),r("Shaders/Builtin/Functions/hue",[],function(){"use strict";return"vec3 czm_hue(vec3 rgb, float adjustment)\n{\nconst mat3 toYIQ = mat3(0.299,     0.587,     0.114,\n0.595716, -0.274453, -0.321263,\n0.211456, -0.522591,  0.311135);\nconst mat3 toRGB = mat3(1.0,  0.9563,  0.6210,\n1.0, -0.2721, -0.6474,\n1.0, -1.107,   1.7046);\nvec3 yiq = toYIQ * rgb;\nfloat hue = atan(yiq.z, yiq.y) + adjustment;\nfloat chroma = sqrt(yiq.z * yiq.z + yiq.y * yiq.y);\nvec3 color = vec3(yiq.x, chroma * cos(hue), chroma * sin(hue));\nreturn toRGB * color;\n}\n"}),r("Shaders/Builtin/Functions/isEmpty",[],function(){"use strict";return"bool czm_isEmpty(czm_raySegment interval)\n{\nreturn (interval.stop < 0.0);\n}\n"}),r("Shaders/Builtin/Functions/isFull",[],function(){"use strict";return"bool czm_isFull(czm_raySegment interval)\n{\nreturn (interval.start == 0.0 && interval.stop == czm_infinity);\n}\n"}),r("Shaders/Builtin/Functions/latitudeToWebMercatorFraction",[],function(){"use strict";return"float czm_latitudeToWebMercatorFraction(float latitude, float southMercatorYLow, float southMercatorYHigh, float oneOverMercatorHeight)\n{\nfloat sinLatitude = sin(latitude);\nfloat mercatorY = 0.5 * log((1.0 + sinLatitude) / (1.0 - sinLatitude));\nfloat t1 = 0.0 - southMercatorYLow;\nfloat e = t1 - 0.0;\nfloat t2 = ((-southMercatorYLow - e) + (0.0 - (t1 - e))) + mercatorY - southMercatorYHigh;\nfloat highDifference = t1 + t2;\nfloat lowDifference = t2 - (highDifference - t1);\nreturn highDifference * oneOverMercatorHeight + lowDifference * oneOverMercatorHeight;\n}\n"}),r("Shaders/Builtin/Functions/luminance",[],function(){"use strict";return"float czm_luminance(vec3 rgb)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nreturn dot(rgb, W);\n}\n"}),r("Shaders/Builtin/Functions/modelToWindowCoordinates",[],function(){"use strict";return"vec4 czm_modelToWindowCoordinates(vec4 position)\n{\nvec4 q = czm_modelViewProjection * position;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n"}),r("Shaders/Builtin/Functions/multiplyWithColorBalance",[],function(){"use strict";return"vec3 czm_multiplyWithColorBalance(vec3 left, vec3 right)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 target = left * right;\nfloat leftLuminance = dot(left, W);\nfloat rightLuminance = dot(right, W);\nfloat targetLuminance = dot(target, W);\nreturn ((leftLuminance + rightLuminance) / (2.0 * targetLuminance)) * target;\n}\n"}),r("Shaders/Builtin/Functions/phong",[],function(){"use strict";return"float czm_private_getLambertDiffuseOfMaterial(vec3 lightDirectionEC, czm_material material)\n{\nreturn czm_getLambertDiffuse(lightDirectionEC, material.normal);\n}\nfloat czm_private_getSpecularOfMaterial(vec3 lightDirectionEC, vec3 toEyeEC, czm_material material)\n{\nreturn czm_getSpecular(lightDirectionEC, toEyeEC, material.normal, material.shininess);\n}\nvec4 czm_phong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 0.0, 1.0), material) + czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 1.0, 0.0), material);\nfloat specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material) + czm_private_getSpecularOfMaterial(czm_moonDirectionEC, toEye, material);\nvec3 ambient = vec3(0.0);\nvec3 color = ambient + material.emission;\ncolor += material.diffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\nvec4 czm_private_phong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(czm_sunDirectionEC, material);\nfloat specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material);\nvec3 ambient = vec3(0.0);\nvec3 color = ambient + material.emission;\ncolor += material.diffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\n"}),r("Shaders/Builtin/Functions/pointAlongRay",[],function(){"use strict";return"vec3 czm_pointAlongRay(czm_ray ray, float time)\n{\nreturn ray.origin + (time * ray.direction);\n}\n"}),r("Shaders/Builtin/Functions/rayEllipsoidIntersectionInterval",[],function(){"use strict";return"czm_raySegment czm_rayEllipsoidIntersectionInterval(czm_ray ray, czm_ellipsoid ellipsoid)\n{\nvec3 q = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ray.origin, 1.0)).xyz;\nvec3 w = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ray.direction, 0.0)).xyz;\nq = q - ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ellipsoid.center, 1.0)).xyz;\nfloat q2 = dot(q, q);\nfloat qw = dot(q, w);\nif (q2 > 1.0)\n{\nif (qw >= 0.0)\n{\nreturn czm_emptyRaySegment;\n}\nelse\n{\nfloat qw2 = qw * qw;\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nif (qw2 < product)\n{\nreturn czm_emptyRaySegment;\n}\nelse if (qw2 > product)\n{\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nfloat root0 = temp / w2;\nfloat root1 = difference / temp;\nif (root0 < root1)\n{\nczm_raySegment i = czm_raySegment(root0, root1);\nreturn i;\n}\nelse\n{\nczm_raySegment i = czm_raySegment(root1, root0);\nreturn i;\n}\n}\nelse\n{\nfloat root = sqrt(difference / w2);\nczm_raySegment i = czm_raySegment(root, root);\nreturn i;\n}\n}\n}\nelse if (q2 < 1.0)\n{\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nczm_raySegment i = czm_raySegment(0.0, temp / w2);\nreturn i;\n}\nelse\n{\nif (qw < 0.0)\n{\nfloat w2 = dot(w, w);\nczm_raySegment i = czm_raySegment(0.0, -qw / w2);\nreturn i;\n}\nelse\n{\nreturn czm_emptyRaySegment;\n}\n}\n}\n"}),r("Shaders/Builtin/Functions/saturation",[],function(){"use strict";return"vec3 czm_saturation(vec3 rgb, float adjustment)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 intensity = vec3(dot(rgb, W));\nreturn mix(intensity, rgb, adjustment);\n}\n"}),r("Shaders/Builtin/Functions/snoise",[],function(){"use strict";return"vec4 _czm_mod289(vec4 x)\n{\nreturn x - floor(x * (1.0 / 289.0)) * 289.0;\n}\nvec3 _czm_mod289(vec3 x)\n{\nreturn x - floor(x * (1.0 / 289.0)) * 289.0;\n}\nvec2 _czm_mod289(vec2 x)\n{\nreturn x - floor(x * (1.0 / 289.0)) * 289.0;\n}\nfloat _czm_mod289(float x)\n{\nreturn x - floor(x * (1.0 / 289.0)) * 289.0;\n}\nvec4 _czm_permute(vec4 x)\n{\nreturn _czm_mod289(((x*34.0)+1.0)*x);\n}\nvec3 _czm_permute(vec3 x)\n{\nreturn _czm_mod289(((x*34.0)+1.0)*x);\n}\nfloat _czm_permute(float x)\n{\nreturn _czm_mod289(((x*34.0)+1.0)*x);\n}\nvec4 _czm_taylorInvSqrt(vec4 r)\n{\nreturn 1.79284291400159 - 0.85373472095314 * r;\n}\nfloat _czm_taylorInvSqrt(float r)\n{\nreturn 1.79284291400159 - 0.85373472095314 * r;\n}\nvec4 _czm_grad4(float j, vec4 ip)\n{\nconst vec4 ones = vec4(1.0, 1.0, 1.0, -1.0);\nvec4 p,s;\np.xyz = floor( fract (vec3(j) * ip.xyz) * 7.0) * ip.z - 1.0;\np.w = 1.5 - dot(abs(p.xyz), ones.xyz);\ns = vec4(lessThan(p, vec4(0.0)));\np.xyz = p.xyz + (s.xyz*2.0 - 1.0) * s.www;\nreturn p;\n}\nfloat czm_snoise(vec2 v)\n{\nconst vec4 C = vec4(0.211324865405187,\n0.366025403784439,\n-0.577350269189626,\n0.024390243902439);\nvec2 i  = floor(v + dot(v, C.yy) );\nvec2 x0 = v -   i + dot(i, C.xx);\nvec2 i1;\ni1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);\nvec4 x12 = x0.xyxy + C.xxzz;\nx12.xy -= i1;\ni = _czm_mod289(i);\nvec3 p = _czm_permute( _czm_permute( i.y + vec3(0.0, i1.y, 1.0 )) + i.x + vec3(0.0, i1.x, 1.0 ));\nvec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);\nm = m*m ;\nm = m*m ;\nvec3 x = 2.0 * fract(p * C.www) - 1.0;\nvec3 h = abs(x) - 0.5;\nvec3 ox = floor(x + 0.5);\nvec3 a0 = x - ox;\nm *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );\nvec3 g;\ng.x  = a0.x  * x0.x  + h.x  * x0.y;\ng.yz = a0.yz * x12.xz + h.yz * x12.yw;\nreturn 130.0 * dot(m, g);\n}\nfloat czm_snoise(vec3 v)\n{\nconst vec2  C = vec2(1.0/6.0, 1.0/3.0) ;\nconst vec4  D = vec4(0.0, 0.5, 1.0, 2.0);\nvec3 i  = floor(v + dot(v, C.yyy) );\nvec3 x0 =   v - i + dot(i, C.xxx) ;\nvec3 g = step(x0.yzx, x0.xyz);\nvec3 l = 1.0 - g;\nvec3 i1 = min( g.xyz, l.zxy );\nvec3 i2 = max( g.xyz, l.zxy );\nvec3 x1 = x0 - i1 + C.xxx;\nvec3 x2 = x0 - i2 + C.yyy;\nvec3 x3 = x0 - D.yyy;\ni = _czm_mod289(i);\nvec4 p = _czm_permute( _czm_permute( _czm_permute(\ni.z + vec4(0.0, i1.z, i2.z, 1.0 ))\n+ i.y + vec4(0.0, i1.y, i2.y, 1.0 ))\n+ i.x + vec4(0.0, i1.x, i2.x, 1.0 ));\nfloat n_ = 0.142857142857;\nvec3  ns = n_ * D.wyz - D.xzx;\nvec4 j = p - 49.0 * floor(p * ns.z * ns.z);\nvec4 x_ = floor(j * ns.z);\nvec4 y_ = floor(j - 7.0 * x_ );\nvec4 x = x_ *ns.x + ns.yyyy;\nvec4 y = y_ *ns.x + ns.yyyy;\nvec4 h = 1.0 - abs(x) - abs(y);\nvec4 b0 = vec4( x.xy, y.xy );\nvec4 b1 = vec4( x.zw, y.zw );\nvec4 s0 = floor(b0)*2.0 + 1.0;\nvec4 s1 = floor(b1)*2.0 + 1.0;\nvec4 sh = -step(h, vec4(0.0));\nvec4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;\nvec4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;\nvec3 p0 = vec3(a0.xy,h.x);\nvec3 p1 = vec3(a0.zw,h.y);\nvec3 p2 = vec3(a1.xy,h.z);\nvec3 p3 = vec3(a1.zw,h.w);\nvec4 norm = _czm_taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));\np0 *= norm.x;\np1 *= norm.y;\np2 *= norm.z;\np3 *= norm.w;\nvec4 m = max(0.6 - vec4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);\nm = m * m;\nreturn 42.0 * dot( m*m, vec4( dot(p0,x0), dot(p1,x1),\ndot(p2,x2), dot(p3,x3) ) );\n}\nfloat czm_snoise(vec4 v)\n{\nconst vec4  C = vec4( 0.138196601125011,\n0.276393202250021,\n0.414589803375032,\n-0.447213595499958);\n#define F4 0.309016994374947451\nvec4 i  = floor(v + dot(v, vec4(F4)) );\nvec4 x0 = v -   i + dot(i, C.xxxx);\nvec4 i0;\nvec3 isX = step( x0.yzw, x0.xxx );\nvec3 isYZ = step( x0.zww, x0.yyz );\ni0.x = isX.x + isX.y + isX.z;\ni0.yzw = 1.0 - isX;\ni0.y += isYZ.x + isYZ.y;\ni0.zw += 1.0 - isYZ.xy;\ni0.z += isYZ.z;\ni0.w += 1.0 - isYZ.z;\nvec4 i3 = clamp( i0, 0.0, 1.0 );\nvec4 i2 = clamp( i0-1.0, 0.0, 1.0 );\nvec4 i1 = clamp( i0-2.0, 0.0, 1.0 );\nvec4 x1 = x0 - i1 + C.xxxx;\nvec4 x2 = x0 - i2 + C.yyyy;\nvec4 x3 = x0 - i3 + C.zzzz;\nvec4 x4 = x0 + C.wwww;\ni = _czm_mod289(i);\nfloat j0 = _czm_permute( _czm_permute( _czm_permute( _czm_permute(i.w) + i.z) + i.y) + i.x);\nvec4 j1 = _czm_permute( _czm_permute( _czm_permute( _czm_permute (\ni.w + vec4(i1.w, i2.w, i3.w, 1.0 ))\n+ i.z + vec4(i1.z, i2.z, i3.z, 1.0 ))\n+ i.y + vec4(i1.y, i2.y, i3.y, 1.0 ))\n+ i.x + vec4(i1.x, i2.x, i3.x, 1.0 ));\nvec4 ip = vec4(1.0/294.0, 1.0/49.0, 1.0/7.0, 0.0) ;\nvec4 p0 = _czm_grad4(j0,   ip);\nvec4 p1 = _czm_grad4(j1.x, ip);\nvec4 p2 = _czm_grad4(j1.y, ip);\nvec4 p3 = _czm_grad4(j1.z, ip);\nvec4 p4 = _czm_grad4(j1.w, ip);\nvec4 norm = _czm_taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));\np0 *= norm.x;\np1 *= norm.y;\np2 *= norm.z;\np3 *= norm.w;\np4 *= _czm_taylorInvSqrt(dot(p4,p4));\nvec3 m0 = max(0.6 - vec3(dot(x0,x0), dot(x1,x1), dot(x2,x2)), 0.0);\nvec2 m1 = max(0.6 - vec2(dot(x3,x3), dot(x4,x4)            ), 0.0);\nm0 = m0 * m0;\nm1 = m1 * m1;\nreturn 49.0 * ( dot(m0*m0, vec3( dot( p0, x0 ), dot( p1, x1 ), dot( p2, x2 )))\n+ dot(m1*m1, vec2( dot( p3, x3 ), dot( p4, x4 ) ) ) ) ;\n}\n"}),r("Shaders/Builtin/Functions/tangentToEyeSpaceMatrix",[],function(){"use strict";return"mat3 czm_tangentToEyeSpaceMatrix(vec3 normalEC, vec3 tangentEC, vec3 binormalEC)\n{\nvec3 normal = normalize(normalEC);\nvec3 tangent = normalize(tangentEC);\nvec3 binormal = normalize(binormalEC);\nreturn mat3(tangent.x,  tangent.y,  tangent.z,\nbinormal.x, binormal.y, binormal.z,\nnormal.x,   normal.y,   normal.z);\n}\n"}),r("Shaders/Builtin/Functions/translateRelativeToEye",[],function(){"use strict";return"vec4 czm_translateRelativeToEye(vec3 high, vec3 low)\n{\nvec3 highDifference = high - czm_encodedCameraPositionMCHigh;\nvec3 lowDifference = low - czm_encodedCameraPositionMCLow;\nreturn vec4(highDifference + lowDifference, 1.0);\n}\n"}),r("Shaders/Builtin/Functions/transpose",[],function(){"use strict";return"mat2 czm_transpose(mat2 matrix)\n{\nreturn mat2(\nmatrix[0][0], matrix[1][0],\nmatrix[0][1], matrix[1][1]);\n}\nmat3 czm_transpose(mat3 matrix)\n{\nreturn mat3(\nmatrix[0][0], matrix[1][0], matrix[2][0],\nmatrix[0][1], matrix[1][1], matrix[2][1],\nmatrix[0][2], matrix[1][2], matrix[2][2]);\n}\nmat4 czm_transpose(mat4 matrix)\n{\nreturn mat4(\nmatrix[0][0], matrix[1][0], matrix[2][0], matrix[3][0],\nmatrix[0][1], matrix[1][1], matrix[2][1], matrix[3][1],\nmatrix[0][2], matrix[1][2], matrix[2][2], matrix[3][2],\nmatrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]);\n}\n"}),r("Shaders/Builtin/Functions/windowToEyeCoordinates",[],function(){"use strict";return"vec4 czm_windowToEyeCoordinates(vec4 fragmentCoordinate)\n{\nfloat x = 2.0 * (fragmentCoordinate.x - czm_viewport.x) / czm_viewport.z - 1.0;\nfloat y = 2.0 * (fragmentCoordinate.y - czm_viewport.y) / czm_viewport.w - 1.0;\nfloat z = (fragmentCoordinate.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nvec4 q = vec4(x, y, z, 1.0);\nq /= fragmentCoordinate.w;\nq = czm_inverseProjection * q;\nreturn q;\n}\n"}),r("Shaders/Builtin/CzmBuiltins",["./Constants/degreesPerRadian","./Constants/epsilon1","./Constants/epsilon2","./Constants/epsilon3","./Constants/epsilon4","./Constants/epsilon5","./Constants/epsilon6","./Constants/epsilon7","./Constants/infinity","./Constants/oneOverPi","./Constants/oneOverTwoPi","./Constants/pi","./Constants/piOverFour","./Constants/piOverSix","./Constants/piOverThree","./Constants/piOverTwo","./Constants/radiansPerDegree","./Constants/sceneMode2D","./Constants/sceneMode3D","./Constants/sceneModeColumbusView","./Constants/sceneModeMorphing","./Constants/solarRadius","./Constants/threePiOver2","./Constants/twoPi","./Constants/webMercatorMaxLatitude","./Structs/ellipsoid","./Structs/material","./Structs/materialInput","./Structs/ray","./Structs/raySegment","./Functions/RGBToXYZ","./Functions/XYZToRGB","./Functions/antialias","./Functions/cellular","./Functions/columbusViewMorph","./Functions/computePosition","./Functions/eastNorthUpToEyeCoordinates","./Functions/ellipsoidContainsPoint","./Functions/ellipsoidNew","./Functions/ellipsoidWgs84TextureCoordinates","./Functions/equalsEpsilon","./Functions/eyeOffset","./Functions/eyeToWindowCoordinates","./Functions/geodeticSurfaceNormal","./Functions/getDefaultMaterial","./Functions/getLambertDiffuse","./Functions/getSpecular","./Functions/getWaterNoise","./Functions/getWgs84EllipsoidEC","./Functions/hue","./Functions/isEmpty","./Functions/isFull","./Functions/latitudeToWebMercatorFraction","./Functions/luminance","./Functions/modelToWindowCoordinates","./Functions/multiplyWithColorBalance","./Functions/phong","./Functions/pointAlongRay","./Functions/rayEllipsoidIntersectionInterval","./Functions/saturation","./Functions/snoise","./Functions/tangentToEyeSpaceMatrix","./Functions/translateRelativeToEye","./Functions/transpose","./Functions/windowToEyeCoordinates"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E,b,T,A,D,P,M,I,O,R,L,z,N,B,F,V,k,U,W,q,G,H,j,Y,X,Z,J,K,Q,$,et,tt,rt,it,nt,ot,at,st,lt,ut,ct){"use strict";return{czm_degreesPerRadian:e,czm_epsilon1:t,czm_epsilon2:r,czm_epsilon3:i,czm_epsilon4:n,czm_epsilon5:o,czm_epsilon6:a,czm_epsilon7:s,czm_infinity:l,czm_oneOverPi:u,czm_oneOverTwoPi:c,czm_pi:h,czm_piOverFour:d,czm_piOverSix:m,czm_piOverThree:p,czm_piOverTwo:f,czm_radiansPerDegree:v,czm_sceneMode2D:y,czm_sceneMode3D:g,czm_sceneModeColumbusView:_,czm_sceneModeMorphing:w,czm_solarRadius:C,czm_threePiOver2:x,czm_twoPi:S,czm_webMercatorMaxLatitude:E,czm_ellipsoid:b,czm_material:T,czm_materialInput:A,czm_ray:D,czm_raySegment:P,czm_RGBToXYZ:M,czm_XYZToRGB:I,czm_antialias:O,czm_cellular:R,czm_columbusViewMorph:L,czm_computePosition:z,czm_eastNorthUpToEyeCoordinates:N,czm_ellipsoidContainsPoint:B,czm_ellipsoidNew:F,czm_ellipsoidWgs84TextureCoordinates:V,czm_equalsEpsilon:k,czm_eyeOffset:U,czm_eyeToWindowCoordinates:W,czm_geodeticSurfaceNormal:q,czm_getDefaultMaterial:G,czm_getLambertDiffuse:H,czm_getSpecular:j,czm_getWaterNoise:Y,czm_getWgs84EllipsoidEC:X,czm_hue:Z,czm_isEmpty:J,czm_isFull:K,czm_latitudeToWebMercatorFraction:Q,czm_luminance:$,czm_modelToWindowCoordinates:et,czm_multiplyWithColorBalance:tt,czm_phong:rt,czm_pointAlongRay:it,czm_rayEllipsoidIntersectionInterval:nt,czm_saturation:ot,czm_snoise:at,czm_tangentToEyeSpaceMatrix:st,czm_translateRelativeToEye:lt,czm_transpose:ut,czm_windowToEyeCoordinates:ct}}),r("Renderer/ShaderProgram",["../Core/defined","../Core/DeveloperError","../Core/FeatureDetection","../Core/RuntimeError","../Core/destroyObject","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","./AutomaticUniforms","./UniformDatatype","../Shaders/Builtin/CzmBuiltins"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";function h(e,t){switch(t){case e.FLOAT:return function(){return u.FLOAT};case e.FLOAT_VEC2:return function(){return u.FLOAT_VEC2};case e.FLOAT_VEC3:return function(){return u.FLOAT_VEC3};case e.FLOAT_VEC4:return function(){return u.FLOAT_VEC4};case e.INT:return function(){return u.INT};case e.INT_VEC2:return function(){return u.INT_VEC2};case e.INT_VEC3:return function(){return u.INT_VEC3};case e.INT_VEC4:return function(){return u.INT_VEC4};case e.BOOL:return function(){return u.BOOL};case e.BOOL_VEC2:return function(){return u.BOOL_VEC2};case e.BOOL_VEC3:return function(){return u.BOOL_VEC3};case e.BOOL_VEC4:return function(){return u.BOOL_VEC4};case e.FLOAT_MAT2:return function(){return u.FLOAT_MAT2};case e.FLOAT_MAT3:return function(){return u.FLOAT_MAT3};case e.FLOAT_MAT4:return function(){return u.FLOAT_MAT4};case e.SAMPLER_2D:return function(){return u.SAMPLER_2D};case e.SAMPLER_CUBE:return function(){return u.SAMPLER_CUBE};default:throw new i("Unrecognized uniform type: "+t)}}function d(e,t,r){e.useProgram(t);for(var i=0,n=r.length,o=0;n>o;++o)i=r[o]._setSampler(i);return e.useProgram(null),i}function m(e){var t=e.indexOf("#version");if(-1!==t){var r=e.indexOf("\n",t);if(-1!==t){var i=e.substring(t,r+1),n=e.substring(0,t)+"//"+e.substring(t);return{version:i,source:n}}}return{version:"",source:e}}function p(t,r,i){for(var n,o=0;o<i.length;++o)i[o].name===t&&(n=i[o]);if(!e(n)){var a=r.match(/\/\*\*[\s\S]*?\*\//gm);if(e(a)&&null!==a)for(o=0;o<a.length;++o){for(var s=a[o],l=s.match(/\n/gm).length,u="",c=0;l>c;++c)u+=0===c?"// Comment replaced to prevent problems when determining dependencies on built-in functions\n":"//\n";r=r.replace(s,u)}n={name:t,glslSource:r,dependsOn:[],requiredBy:[],evaluated:!1},i.push(n)}return n}function f(t,r){if(!t.evaluated){t.evaluated=!0;var i=t.glslSource.match(/\bczm_[a-zA-Z0-9_]*/g);e(i)&&null!==i&&(i=i.filter(function(e,t){return i.indexOf(e)===t}),i.forEach(function(e){if(e!==t.name&&D._czmBuiltinsAndUniforms.hasOwnProperty(e)){var i=p(e,D._czmBuiltinsAndUniforms[e],r);t.dependsOn.push(i),i.requiredBy.push(t),f(i,r)}}))}}function v(e){for(var r=[],i=[];e.length>0;){var n=e.pop();i.push(n),0===n.requiredBy.length&&r.push(n)}for(;r.length>0;){var o=r.shift();e.push(o);for(var a=0;a<o.dependsOn.length;++a){var s=o.dependsOn[a],l=s.requiredBy.indexOf(o);s.requiredBy.splice(l,1),0===s.requiredBy.length&&r.push(s)}}for(var u=[],c=0;c<i.length;++c)0!==i[c].requiredBy.length&&u.push(i[c]);if(0!==u.length){var h="A circular dependency was found in the following built-in functions/structs/constants: \n";for(c=0;c<u.length;++c)h=h+u[c].name+"\n";throw new t(h)}}function y(e){var t=[],r=p("main",e,t);f(r,t),v(t);for(var i="",n=t.length-1;n>=0;--n)i=i+t[n].glslSource+"\n";return i.replace(r.glslSource,"")}function g(){return"#ifdef GL_FRAGMENT_PRECISION_HIGH \n  precision highp float; \n#else \n  precision mediump float; \n#endif \n\n"}function _(t,r,n,o,a){var s,l=m(n),u=m(o),c=l.version+y(l.source)+"\n#line 0\n"+l.source,h=u.version+g()+y(u.source)+"\n#line 0\n"+u.source,d=t.createShader(t.VERTEX_SHADER);t.shaderSource(d,c),t.compileShader(d);var p=t.createShader(t.FRAGMENT_SHADER);t.shaderSource(p,h),t.compileShader(p);var f=t.createProgram();if(t.attachShader(f,d),t.attachShader(f,p),t.deleteShader(d),t.deleteShader(p),e(a))for(var v in a)a.hasOwnProperty(v)&&t.bindAttribLocation(f,a[v],v);if(t.linkProgram(f),!t.getProgramParameter(f,t.LINK_STATUS)){if(!t.getShaderParameter(p,t.COMPILE_STATUS))throw s=t.getShaderInfoLog(p),t.deleteProgram(f),console.error("[GL] Fragment shader compile log: "+s),new i("Fragment shader failed to compile.  Compile log: "+s);if(!t.getShaderParameter(d,t.COMPILE_STATUS))throw s=t.getShaderInfoLog(d),t.deleteProgram(f),console.error("[GL] Vertex shader compile log: "+s),new i("Vertex shader failed to compile.  Compile log: "+s);throw s=t.getProgramInfoLog(f),t.deleteProgram(f),console.error("[GL] Shader program link log: "+s),new i("Program failed to link.  Link log: "+s)}return r&&(s=t.getShaderInfoLog(d),e(s)&&s.length>0&&console.log("[GL] Vertex shader compile log: "+s)),r&&(s=t.getShaderInfoLog(p),e(s)&&s.length>0&&console.log("[GL] Fragment shader compile log: "+s)),r&&(s=t.getProgramInfoLog(f),e(s)&&s.length>0&&console.log("[GL] Shader program link log: "+s)),f}function w(e,t,r){for(var i={},n=0;r>n;++n){var o=e.getActiveAttrib(t,n),a=e.getAttribLocation(t,o.name);i[o.name]={name:o.name,type:o.type,index:a}}return i}function C(e,t){for(var r={},i=[],n=[],o=e.getProgramParameter(t,e.ACTIVE_UNIFORMS),a=0;o>a;++a){var s=e.getActiveUniform(t,a),l="[0]",u=-1!==s.name.indexOf(l,s.name.length-l.length)?s.name.slice(0,s.name.length-3):s.name;if(0!==u.indexOf("gl_"))if(s.name.indexOf("[")<0){var c=e.getUniformLocation(t,u),h=e.getUniform(t,c),d=new T(e,s,u,c,h);r[u]=d,i.push(d),d._setSampler&&n.push(d)}else{var m,p,f,v,y=u.indexOf("[");if(y>=0){if(m=r[u.slice(0,y)],"undefined"==typeof m)continue;
p=m._getLocations(),p.length<=1&&(f=m.value,v=e.getUniformLocation(t,u),p.push(v),f.push(e.getUniform(t,v)))}else{p=[],f=[];for(var g=0;g<s.size;++g)v=e.getUniformLocation(t,u+"["+g+"]"),p.push(v),f.push(e.getUniform(t,v));m=new A(e,s,u,p,f),r[u]=m,i.push(m),m._setSampler&&n.push(m)}}}return{uniformsByName:r,uniforms:i,samplerUniforms:n}}function x(e){var t=[],r={};for(var i in e)if(e.hasOwnProperty(i)){var n=l[i];n?t.push({uniform:e[i],automaticUniform:n}):r[i]=e[i]}return{automaticUniforms:t,manualUniforms:r}}var S,E,b;r.supportsTypedArrays()&&(S=new Float32Array(4),E=new Float32Array(9),b=new Float32Array(16));var T=function(r,n,l,u,c){this.value=c,this.getName=function(){return l},this.getDatatype=h(r,n.type),this._getLocation=function(){return u},this.textureUnitIndex=void 0,this._set=function(){switch(n.type){case r.FLOAT:return function(){r.uniform1f(u,this.value)};case r.FLOAT_VEC2:return function(){var e=this.value;r.uniform2f(u,e.x,e.y)};case r.FLOAT_VEC3:return function(){var e=this.value;r.uniform3f(u,e.x,e.y,e.z)};case r.FLOAT_VEC4:return function(){var i=this.value;if(e(i.red))r.uniform4f(u,i.red,i.green,i.blue,i.alpha);else{if(!e(i.x))throw new t('Invalid vec4 value for uniform "'+n.name+'".');r.uniform4f(u,i.x,i.y,i.z,i.w)}};case r.SAMPLER_2D:case r.SAMPLER_CUBE:return function(){r.activeTexture(r.TEXTURE0+this.textureUnitIndex),r.bindTexture(this.value._getTarget(),this.value._getTexture())};case r.INT:case r.BOOL:return function(){r.uniform1i(u,this.value)};case r.INT_VEC2:case r.BOOL_VEC2:return function(){var e=this.value;r.uniform2i(u,e.x,e.y)};case r.INT_VEC3:case r.BOOL_VEC3:return function(){var e=this.value;r.uniform3i(u,e.x,e.y,e.z)};case r.INT_VEC4:case r.BOOL_VEC4:return function(){var e=this.value;r.uniform4i(u,e.x,e.y,e.z,e.w)};case r.FLOAT_MAT2:return function(){r.uniformMatrix2fv(u,!1,o.toArray(this.value,S))};case r.FLOAT_MAT3:return function(){r.uniformMatrix3fv(u,!1,a.toArray(this.value,E))};case r.FLOAT_MAT4:return function(){r.uniformMatrix4fv(u,!1,s.toArray(this.value,b))};default:throw new i("Unrecognized uniform type: "+n.type+' for uniform "'+n.name+'".')}}(),(n.type===r.SAMPLER_2D||n.type===r.SAMPLER_CUBE)&&(this._setSampler=function(e){return this.textureUnitIndex=e,r.uniform1i(u,e),e+1})},A=function(r,n,l,u,c){this.value=c;var d=u;this.getName=function(){return l},this.getDatatype=h(r,n.type),this._getLocations=function(){return d},this.textureUnitIndex=void 0,this._set=function(){switch(n.type){case r.FLOAT:return function(){for(var e=0;e<d.length;++e)r.uniform1f(d[e],this.value[e])};case r.FLOAT_VEC2:return function(){for(var e=0;e<d.length;++e){var t=this.value[e];r.uniform2f(d[e],t.x,t.y)}};case r.FLOAT_VEC3:return function(){for(var e=0;e<d.length;++e){var t=this.value[e];r.uniform3f(d[e],t.x,t.y,t.z)}};case r.FLOAT_VEC4:return function(){for(var i=0;i<d.length;++i){var n=this.value[i];if(e(n.red))r.uniform4f(d[i],n.red,n.green,n.blue,n.alpha);else{if(!e(n.x))throw new t("Invalid vec4 value.");r.uniform4f(d[i],n.x,n.y,n.z,n.w)}}};case r.SAMPLER_2D:case r.SAMPLER_CUBE:return function(){for(var e=0;e<d.length;++e){var t=this.value[e],i=this.textureUnitIndex+e;r.activeTexture(r.TEXTURE0+i),r.bindTexture(t._getTarget(),t._getTexture())}};case r.INT:case r.BOOL:return function(){for(var e=0;e<d.length;++e)r.uniform1i(d[e],this.value[e])};case r.INT_VEC2:case r.BOOL_VEC2:return function(){for(var e=0;e<d.length;++e){var t=this.value[e];r.uniform2i(d[e],t.x,t.y)}};case r.INT_VEC3:case r.BOOL_VEC3:return function(){for(var e=0;e<d.length;++e){var t=this.value[e];r.uniform3i(d[e],t.x,t.y,t.z)}};case r.INT_VEC4:case r.BOOL_VEC4:return function(){for(var e=0;e<d.length;++e){var t=this.value[e];r.uniform4i(d[e],t.x,t.y,t.z,t.w)}};case r.FLOAT_MAT2:return function(){for(var e=0;e<d.length;++e)r.uniformMatrix2fv(d[e],!1,o.toArray(this.value[e],S))};case r.FLOAT_MAT3:return function(){for(var e=0;e<d.length;++e)r.uniformMatrix3fv(d[e],!1,a.toArray(this.value[e],E))};case r.FLOAT_MAT4:return function(){for(var e=0;e<d.length;++e)r.uniformMatrix4fv(d[e],!1,s.toArray(this.value[e],b))};default:throw new i("Unrecognized uniform type: "+n.type)}}(),(n.type===r.SAMPLER_2D||n.type===r.SAMPLER_CUBE)&&(this._setSampler=function(e){this.textureUnitIndex=e;for(var t=0;t<d.length;++t){var i=e+t;r.uniform1i(d[t],i)}return e+d.length})},D=function(e,t,r,i,n){var o=_(e,t,r,i,n),a=e.getProgramParameter(o,e.ACTIVE_ATTRIBUTES),s=C(e,o),l=x(s.uniformsByName);this._gl=e,this._program=o,this._numberOfVertexAttributes=a,this._vertexAttributes=w(e,o,a),this._uniformsByName=s.uniformsByName,this._uniforms=s.uniforms,this._automaticUniforms=l.automaticUniforms,this._manualUniforms=l.manualUniforms,this.maximumTextureUnitIndex=d(e,o,s.samplerUniforms),this.vertexShaderSource=r,this.fragmentShaderSource=i};D._czmBuiltinsAndUniforms={};for(var P in c)c.hasOwnProperty(P)&&(D._czmBuiltinsAndUniforms[P]=c[P]);for(var M in l)if(l.hasOwnProperty(M)){var I=l[M];"function"==typeof I.getDeclaration&&(D._czmBuiltinsAndUniforms[M]=I.getDeclaration(M))}return D.prototype.getVertexAttributes=function(){return this._vertexAttributes},D.prototype.getNumberOfVertexAttributes=function(){return this._numberOfVertexAttributes},D.prototype.getAllUniforms=function(){return this._uniformsByName},D.prototype.getManualUniforms=function(){return this._manualUniforms},D.prototype._bind=function(){this._gl.useProgram(this._program)},D.prototype._setUniforms=function(e,r,i){var n,o,a=this._uniforms,s=this._manualUniforms,l=this._automaticUniforms;if(e)for(var u in s)s.hasOwnProperty(u)&&(s[u].value=e[u]());for(n=l.length,o=0;n>o;++o)l[o].uniform.value=l[o].automaticUniform.getValue(r);for(n=a.length,o=0;n>o;++o)a[o]._set();if(i){var c=this._gl,h=this._program;if(c.validateProgram(h),!c.getProgramParameter(h,c.VALIDATE_STATUS))throw new t("Program validation failed.  Link log: "+c.getProgramInfoLog(h))}},D.prototype.isDestroyed=function(){return!1},D.prototype.destroy=function(){return this._gl.deleteProgram(this._program),n(this)},D.prototype.release=function(){return this._cachedShader?this._cachedShader.cache.releaseShaderProgram(this):this.destroy()},D}),r("Renderer/TextureAtlas",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","./PixelFormat"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,r,n,o,a){this.bottomLeft=i(e,t.ZERO),this.topRight=i(r,t.ZERO),this.childNode1=n,this.childNode2=o,this.imageIndex=a}function u(e,r){var i=e.getNumberOfImages(),o=2;if(i>0){var a=e._texture.getWidth(),s=e._texture.getHeight(),u=o*(a+r.width+e._borderWidthInPixels),c=o*(s+r.height+e._borderWidthInPixels),h=a/u,d=s/c,m=new l(new t(a+e._borderWidthInPixels,0),new t(u,s)),p=new l(new t,new t(u,s),e._root,m),f=new l(new t(0,s+e._borderWidthInPixels),new t(u,c)),v=new l(new t,new t(u,c),p,f);e._root=v;for(var y=0;y<e._textureCoordinates.length;y++){var g=e._textureCoordinates[y];n(g)&&(g.x*=h,g.y*=d,g.width*=h,g.height*=d)}var _=e._context.createTexture2D({width:u,height:c,pixelFormat:e._pixelFormat}),w=e._context.createFramebuffer({colorTexture:e._texture});w._bind(),_.copyFromFramebuffer(0,0,0,0,a,s),w._unBind(),w.destroy(),e._texture=_}else{var C=o*(r.width+e._borderWidthInPixels),x=o*(r.height+e._borderWidthInPixels);e._texture=e._texture&&e._texture.destroy(),e._texture=e._context.createTexture2D({width:C,height:x,pixelFormat:e._pixelFormat}),e._root=new l(new t,new t(C,x))}}function c(e,r,i){if(!n(r))return void 0;if(!n(r.childNode1)&&!n(r.childNode2)){if(n(r.imageIndex))return void 0;var o=r.topRight.x-r.bottomLeft.x,a=r.topRight.y-r.bottomLeft.y,s=o-i.width,u=a-i.height;if(0>s||0>u)return void 0;if(0===s&&0===u)return r;if(s>u){r.childNode1=new l(new t(r.bottomLeft.x,r.bottomLeft.y),new t(r.bottomLeft.x+i.width,r.topRight.y));var h=r.bottomLeft.x+i.width+e._borderWidthInPixels;h<r.topRight.x&&(r.childNode2=new l(new t(h,r.bottomLeft.y),new t(r.topRight.x,r.topRight.y)))}else{r.childNode1=new l(new t(r.bottomLeft.x,r.bottomLeft.y),new t(r.topRight.x,r.bottomLeft.y+i.height));var d=r.bottomLeft.y+i.height+e._borderWidthInPixels;d<r.topRight.y&&(r.childNode2=new l(new t(r.bottomLeft.x,d),new t(r.topRight.x,r.topRight.y)))}return c(e,r.childNode1,i)}return c(e,r.childNode1,i)||c(e,r.childNode2,i)}function h(t,r,i){if(!n(r))throw new a("image is required.");var o=c(t,t._root,r);if(n(o)){o.imageIndex=i;var s=t._texture.getWidth(),l=t._texture.getHeight(),d=o.topRight.x-o.bottomLeft.x,m=o.topRight.y-o.bottomLeft.y;t._textureCoordinates[i]=new e(o.bottomLeft.x/s,o.bottomLeft.y/l,d/s,m/l),t._texture.copyFrom(r,o.bottomLeft.x,o.bottomLeft.y)}else u(t,r),h(t,r,i)}var d=new t(16,16),m=function(e){e=i(e,i.EMPTY_OBJECT);var o=e.context;if(!n(o))throw new a("context is required.");var u=i(e.borderWidthInPixels,1);if(0>u)throw new a("borderWidthInPixels must be greater than or equal to zero.");var c=i(e.initialSize,d);if(c.x<1||c.y<1)throw new a("initialSize must be greater than zero.");this._context=o,this._pixelFormat=i(e.pixelFormat,s.RGBA),this._borderWidthInPixels=u,this._textureCoordinates=[],this._guid=r(),this._texture=this._context.createTexture2D({width:c.x,height:c.y,pixelFormat:this._pixelFormat}),this._root=new l(new t,new t(c.x,c.y));var h=e.images;n(h)&&h.length>0&&this.addImages(h);var m=e.image;n(m)&&this.addImage(m)};return m.prototype.addImage=function(e){var t=this.getNumberOfImages();return h(this,e,t),this._guid=r(),t},m.prototype.addImages=function(e){if(!n(e)||e.length<1)throw new a("images is required and must have length greater than zero.");var t,i=[],o=e.length,s=this.getNumberOfImages();for(t=0;o>t;++t)i.push({image:e[t],index:t+s});for(i.sort(function(e,t){return Math.max(t.image.height,t.image.width)-Math.max(e.image.height,e.image.width)}),t=0;o>t;++t){var l=i[t];h(this,l.image,l.index)}return this._guid=r(),s},m.prototype.addSubRegions=function(t,i){for(var n=this.addImage(t),o=this._texture.getWidth(),a=this._texture.getHeight(),s=this.getNumberOfImages(),l=i.length,u=this._textureCoordinates[n],c=0;l>c;++c){var h=i[c];this._textureCoordinates.push(new e(u.x+h.x/o,u.y+h.y/a,h.width/o,h.height/a))}return this._guid=r(),s},m.prototype.getBorderWidthInPixels=function(){return this._borderWidthInPixels},m.prototype.getTextureCoordinates=function(){return this._textureCoordinates},m.prototype.getTexture=function(){return this._texture},m.prototype.getNumberOfImages=function(){return this._textureCoordinates.length},m.prototype.getGUID=function(){return this._guid},m.prototype.isDestroyed=function(){return!1},m.prototype.destroy=function(){return this._texture=this._texture&&this._texture.destroy(),o(this)},m}),r("Renderer/UniformState",["../Core/Matrix3","../Core/Matrix4","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/defined","../Core/Math","../Core/EncodedCartesian3","../Core/BoundingRectangle","../Core/Transforms","../Core/Simon1994PlanetaryPositions","../Scene/SceneMode"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function m(e,r){t.clone(r,e._view),t.getRotation(r,e._viewRotation),e._view3DDirty=!0,e._inverseView3DDirty=!0,e._modelViewDirty=!0,e._modelView3DDirty=!0,e._modelViewRelativeToEyeDirty=!0,e._inverseModelViewDirty=!0,e._inverseModelView3DDirty=!0,e._viewProjectionDirty=!0,e._modelViewProjectionDirty=!0,e._modelViewProjectionRelativeToEyeDirty=!0,e._modelViewInfiniteProjectionDirty=!0,e._normalDirty=!0,e._inverseNormalDirty=!0,e._normal3DDirty=!0,e._inverseNormal3DDirty=!0}function p(e,r){t.clone(r,e._inverseView),t.getRotation(r,e._inverseViewRotation)}function f(e,r){t.clone(r,e._projection),e._inverseProjectionDirty=!0,e._viewProjectionDirty=!0,e._modelViewProjectionDirty=!0,e._modelViewProjectionRelativeToEyeDirty=!0}function v(e,r){t.clone(r,e._infiniteProjection),e._modelViewInfiniteProjectionDirty=!0}function y(e,t){i.clone(t.positionWC,e._cameraPosition),i.clone(t.directionWC,e._cameraDirection),i.clone(t.rightWC,e._cameraRight),i.clone(t.upWC,e._cameraUp),e._encodedCameraPositionMCDirty=!0}function g(t,r){a(c.computeIcrfToFixedMatrix(r.time,B))||(B=c.computeTemeToPseudoFixedMatrix(r.time,B));var n=h.ComputeSunPositionInEarthInertialFrame(r.time,t._sunPositionWC);e.multiplyByVector(B,n,n),i.normalize(n,t._sunDirectionWC),n=e.multiplyByVector(t.getViewRotation3D(),n,t._sunDirectionEC),i.normalize(n,n),n=h.ComputeMoonPositionInEarthInertialFrame(r.time,t._moonDirectionEC),e.multiplyByVector(B,n,n),e.multiplyByVector(t.getViewRotation3D(),n,n),i.normalize(n,n);var o=r.scene2D.projection,s=o.getEllipsoid(),l=s.cartesianToCartographic(t._sunPositionWC,F);o.project(l,t._sunPositionColumbusView)}function _(e){if(e._viewportDirty){var r=e._viewport;t.computeOrthographicOffCenter(r.x,r.x+r.width,r.y,r.y+r.height,0,1,e._viewportOrthographicMatrix),t.computeViewportTransformation(r,0,1,e._viewportTransformation),e._viewportDirty=!1}}function w(e){e._inverseProjectionDirty&&(e._inverseProjectionDirty=!1,t.inverse(e._projection,e._inverseProjection))}function C(e){e._modelViewDirty&&(e._modelViewDirty=!1,t.multiplyTransformation(e._view,e._model,e._modelView))}function x(e){e._modelView3DDirty&&(e._modelView3DDirty=!1,t.multiplyTransformation(e.getView3D(),e._model,e._modelView3D))}function S(e){if(e._modelViewRelativeToEyeDirty){e._modelViewRelativeToEyeDirty=!1;var t=e.getModelView(),r=e._modelViewRelativeToEye;r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=0,r[13]=0,r[14]=0,r[15]=t[15]}}function E(e){e._inverseModelViewDirty&&(e._inverseModelViewDirty=!1,t.inverse(e.getModelView(),e._inverseModelView))}function b(e){e._inverseModelView3DDirty&&(e._inverseModelView3DDirty=!1,t.inverse(e.getModelView3D(),e._inverseModelView3D))}function T(e){e._viewProjectionDirty&&(e._viewProjectionDirty=!1,t.multiply(e._projection,e._view,e._viewProjection))}function A(e){e._modelViewProjectionDirty&&(e._modelViewProjectionDirty=!1,t.multiply(e._projection,e.getModelView(),e._modelViewProjection))}function D(e){e._modelViewProjectionRelativeToEyeDirty&&(e._modelViewProjectionRelativeToEyeDirty=!1,t.multiply(e._projection,e.getModelViewRelativeToEye(),e._modelViewProjectionRelativeToEye))}function P(e){e._modelViewInfiniteProjectionDirty&&(e._modelViewInfiniteProjectionDirty=!1,t.multiply(e._infiniteProjection,e.getModelView(),e._modelViewInfiniteProjection))}function M(e){e._normalDirty&&(e._normalDirty=!1,t.transpose(e.getInverseModelView(),U),t.getRotation(U,e._normal))}function I(e){e._normal3DDirty&&(e._normal3DDirty=!1,t.transpose(e.getInverseModelView3D(),U),t.getRotation(U,e._normal3D))}function O(e){e._inverseNormalDirty&&(e._inverseNormalDirty=!1,t.getRotation(e.getInverseModelView(),e._inverseNormal))}function R(e){e._inverseNormal3DDirty&&(e._inverseNormal3DDirty=!1,t.getRotation(e.getInverseModelView3D(),e._inverseNormal3D))}function L(e){e._encodedCameraPositionMCDirty&&(e._encodedCameraPositionMCDirty=!1,t.multiplyByPoint(e.getInverseModel(),e._cameraPosition,W),l.fromCartesian(W,e._encodedCameraPositionMC))}function z(e,r,n,o,l,u,h,m){var p=q;p.x=e.y,p.y=e.z,p.z=e.x;var f=G;f.x=n.y,f.y=n.z,f.z=n.x;var v=H;v.x=o.y,v.y=o.z,v.z=o.x;var y=j;y.x=r.y,y.y=r.z,y.z=r.x,u===d.SCENE2D&&(p.z=.5*l);var g=h.unproject(p,Y);g.longitude=s.clamp(g.longitude,-Math.PI,Math.PI),g.latitude=s.clamp(g.latitude,-s.PI_OVER_TWO,s.PI_OVER_TWO);var _=h.getEllipsoid(),w=_.cartographicToCartesian(g,X),C=c.eastNorthUpToFixedFrame(w,_,Z);return t.multiplyByPointAsVector(C,f,f),t.multiplyByPointAsVector(C,v,v),t.multiplyByPointAsVector(C,y,y),a(m)||(m=new t),m[0]=f.x,m[1]=v.x,m[2]=-y.x,m[3]=0,m[4]=f.y,m[5]=v.y,m[6]=-y.y,m[7]=0,m[8]=f.z,m[9]=v.z,m[10]=-y.z,m[11]=0,m[12]=-i.dot(f,w),m[13]=-i.dot(v,w),m[14]=i.dot(y,w),m[15]=1,m}var N=function(){this._viewport=new u,this._viewportDirty=!1,this._viewportOrthographicMatrix=t.clone(t.IDENTITY),this._viewportTransformation=t.clone(t.IDENTITY),this._model=t.clone(t.IDENTITY),this._view=t.clone(t.IDENTITY),this._inverseView=t.clone(t.IDENTITY),this._projection=t.clone(t.IDENTITY),this._infiniteProjection=t.clone(t.IDENTITY),this._entireFrustum=new r,this._currentFrustum=new r,this._pixelSize=0,this._frameState=void 0,this._temeToPseudoFixed=e.clone(t.IDENTITY),this._view3DDirty=!0,this._view3D=new t,this._inverseView3DDirty=!0,this._inverseView3D=new t,this._inverseModelDirty=!0,this._inverseModel=new t,this._viewRotation=new e,this._inverseViewRotation=new e,this._viewRotation3D=new e,this._inverseViewRotation3D=new e,this._inverseProjectionDirty=!0,this._inverseProjection=new t,this._modelViewDirty=!0,this._modelView=new t,this._modelView3DDirty=!0,this._modelView3D=new t,this._modelViewRelativeToEyeDirty=!0,this._modelViewRelativeToEye=new t,this._inverseModelViewDirty=!0,this._inverseModelView=new t,this._inverseModelView3DDirty=!0,this._inverseModelView3D=new t,this._viewProjectionDirty=!0,this._viewProjection=new t,this._modelViewProjectionDirty=!0,this._modelViewProjection=new t,this._modelViewProjectionRelativeToEyeDirty=!0,this._modelViewProjectionRelativeToEye=new t,this._modelViewInfiniteProjectionDirty=!0,this._modelViewInfiniteProjection=new t,this._normalDirty=!0,this._normal=new e,this._normal3DDirty=!0,this._normal3D=new e,this._inverseNormalDirty=!0,this._inverseNormal=new e,this._inverseNormal3DDirty=!0,this._inverseNormal3D=new e,this._encodedCameraPositionMCDirty=!0,this._encodedCameraPositionMC=new l,this._cameraPosition=new i,this._sunPositionWC=new i,this._sunPositionColumbusView=new i,this._sunDirectionWC=new i,this._sunDirectionEC=new i,this._moonDirectionEC=new i,this._mode=void 0,this._mapProjection=void 0,this._cameraDirection=new i,this._cameraRight=new i,this._cameraUp=new i,this._frustum2DWidth=0,this._eyeHeight2D=new r},B=new e,F=new o;N.prototype.updateFrustum=function(e){f(this,e.projectionMatrix),a(e.infiniteProjectionMatrix)&&v(this,e.infiniteProjectionMatrix),this._currentFrustum.x=e.near,this._currentFrustum.y=e.far};var V=new r,k=new r;N.prototype.update=function(e,t){this._mode=t.mode,this._mapProjection=t.scene2D.projection;var r=t.camera;m(this,r.viewMatrix),p(this,r.inverseViewMatrix),y(this,r),t.mode===d.SCENE2D?(this._frustum2DWidth=r.frustum.right-r.frustum.left,this._eyeHeight2D.x=.5*this._frustum2DWidth,this._eyeHeight2D.y=this._eyeHeight2D.x*this._eyeHeight2D.x):(this._frustum2DWidth=0,this._eyeHeight2D.x=0,this._eyeHeight2D.y=0),g(this,t),V.x=e.getDrawingBufferWidth(),V.y=e.getDrawingBufferHeight();var i=r.frustum.getPixelSize(V,void 0,k);this._pixelSize=Math.max(i.x,i.y),this._entireFrustum.x=r.frustum.near,this._entireFrustum.y=r.frustum.far,this.updateFrustum(r.frustum),this._frameState=t,this._temeToPseudoFixed=c.computeTemeToPseudoFixedMatrix(t.time,this._temeToPseudoFixed)},N.prototype.setViewport=function(e){u.equals(e,this._viewport)||(u.clone(e,this._viewport),this._viewportDirty=!0)},N.prototype.getViewport=function(){return this._viewport},N.prototype.getViewportOrthographic=function(){return _(this),this._viewportOrthographicMatrix},N.prototype.getViewportTransformation=function(){return _(this),this._viewportTransformation},N.prototype.setModel=function(e){t.clone(e,this._model),this._modelView3DDirty=!0,this._inverseModelView3DDirty=!0,this._inverseModelDirty=!0,this._modelViewDirty=!0,this._modelViewRelativeToEyeDirty=!0,this._inverseModelViewDirty=!0,this._modelViewProjectionDirty=!0,this._modelViewProjectionRelativeToEyeDirty=!0,this._modelViewInfiniteProjectionDirty=!0,this._normalDirty=!0,this._inverseNormalDirty=!0,this._normal3DDirty=!0,this._inverseNormal3DDirty=!0,this._encodedCameraPositionMCDirty=!0},N.prototype.getModel=function(){return this._model},N.prototype.getInverseModel=function(){return this._inverseModelDirty&&(this._inverseModelDirty=!1,t.inverse(this._model,this._inverseModel)),this._inverseModel},N.prototype.getView=function(){return this._view},N.prototype.getView3D=function(){return this._view3DDirty&&(this._mode===d.SCENE3D?t.clone(this._view,this._view3D):z(this._cameraPosition,this._cameraDirection,this._cameraRight,this._cameraUp,this._frustum2DWidth,this._mode,this._mapProjection,this._view3D),t.getRotation(this._view3D,this._viewRotation3D),this._view3DDirty=!1),this._view3D},N.prototype.getViewRotation=function(){return this._viewRotation},N.prototype.getViewRotation3D=function(){return this.getView3D(),this._viewRotation3D},N.prototype.getInverseView=function(){return this._inverseView},N.prototype.getInverseView3D=function(){return this._inverseView3DDirty&&(t.inverseTransformation(this.getView3D(),this._inverseView3D),t.getRotation(this._inverseView3D,this._inverseViewRotation3D),this._inverseView3DDirty=!1),this._inverseView3D},N.prototype.getInverseViewRotation=function(){return this._inverseViewRotation},N.prototype.getInverseViewRotation3D=function(){return this.getInverseView3D(),this._inverseViewRotation3D},N.prototype.getProjection=function(){return this._projection},N.prototype.getInverseProjection=function(){return w(this),this._inverseProjection},N.prototype.getInfiniteProjection=function(){return this._infiniteProjection},N.prototype.getModelView=function(){return C(this),this._modelView},N.prototype.getModelView3D=function(){return x(this),this._modelView3D},N.prototype.getModelViewRelativeToEye=function(){return S(this),this._modelViewRelativeToEye},N.prototype.getInverseModelView=function(){return E(this),this._inverseModelView},N.prototype.getInverseModelView3D=function(){return b(this),this._inverseModelView3D},N.prototype.getViewProjection=function(){return T(this),this._viewProjection},N.prototype.getModelViewProjection=function(){return A(this),this._modelViewProjection},N.prototype.getModelViewProjectionRelativeToEye=function(){return D(this),this._modelViewProjectionRelativeToEye},N.prototype.getModelViewInfiniteProjection=function(){return P(this),this._modelViewInfiniteProjection};var U=new t;N.prototype.getNormal=function(){return M(this),this._normal},N.prototype.getNormal3D=function(){return I(this),this._normal3D},N.prototype.getInverseNormal=function(){return O(this),this._inverseNormal},N.prototype.getInverseNormal3D=function(){return R(this),this._inverseNormal3D},N.prototype.getEntireFrustum=function(){return this._entireFrustum},N.prototype.getCurrentFrustum=function(){return this._currentFrustum},N.prototype.getEyeHeight2D=function(){return this._eyeHeight2D},N.prototype.getPixelSize=function(){return this._pixelSize},N.prototype.getSunPositionWC=function(){return this._sunPositionWC},N.prototype.getSunPositionColumbusView=function(){return this._sunPositionColumbusView},N.prototype.getSunDirectionWC=function(){return this._sunDirectionWC},N.prototype.getSunDirectionEC=function(){return this._sunDirectionEC},N.prototype.getMoonDirectionEC=function(){return this._moonDirectionEC};var W=new i;N.prototype.getEncodedCameraPositionMCHigh=function(){return L(this),this._encodedCameraPositionMC.high},N.prototype.getEncodedCameraPositionMCLow=function(){return L(this),this._encodedCameraPositionMC.low},N.prototype.getFrameState=function(){return this._frameState},N.prototype.getTemeToPseudoFixedMatrix=function(){return this._temeToPseudoFixed},N.prototype.getHighResolutionSnapScale=function(){return 1};var q=new i,G=new i,H=new i,j=new i,Y=new o,X=new i,Z=new t;return N}),r("Renderer/VertexArray",["../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/ComponentDatatype"],function(e,t,r,i,n){"use strict";function o(r,o,a){var s=t(o.vertexBuffer),l=t(o.value);if(!s&&!l)throw new i("attribute must have a vertexBuffer or a value.");if(s&&l)throw new i("attribute cannot have both a vertexBuffer and a value.  It must have either a vertexBuffer property defining per-vertex data or a value property defining data for all vertices.");var u=o.value?o.value.length:o.componentsPerAttribute;if(1!==u&&2!==u&&3!==u&&4!==u){if(l)throw new i("attribute.value.length must be in the range [1, 4].");throw new i("attribute.componentsPerAttribute must be in the range [1, 4].")}if(t(o.componentDatatype)&&!n.validate(o.componentDatatype))throw new i("attribute must have a valid componentDatatype or not specify it.");if(t(o.strideInBytes)&&o.strideInBytes>255)throw new i("attribute must have a strideInBytes less than or equal to 255 or not specify it.");var c={index:e(o.index,a),enabled:e(o.enabled,!0),vertexBuffer:o.vertexBuffer,value:l?o.value.slice(0):void 0,componentsPerAttribute:u,componentDatatype:e(o.componentDatatype,n.FLOAT),normalize:e(o.normalize,!1),offsetInBytes:e(o.offsetInBytes,0),strideInBytes:e(o.strideInBytes,0)};if(s)c.vertexAttrib=function(e){e.bindBuffer(e.ARRAY_BUFFER,this.vertexBuffer._getBuffer()),e.vertexAttribPointer(this.index,this.componentsPerAttribute,this.componentDatatype.value,this.normalize,this.strideInBytes,this.offsetInBytes),e.enableVertexAttribArray(this.index)},c.disableVertexAttribArray=function(e){e.disableVertexAttribArray(this.index)};else{switch(c.componentsPerAttribute){case 1:c.vertexAttrib=function(e){e.vertexAttrib1fv(this.index,this.value)};break;case 2:c.vertexAttrib=function(e){e.vertexAttrib2fv(this.index,this.value)};break;case 3:c.vertexAttrib=function(e){e.vertexAttrib3fv(this.index,this.value)};break;case 4:c.vertexAttrib=function(e){e.vertexAttrib4fv(this.index,this.value)}}c.disableVertexAttribArray=function(){}}r.push(c)}function a(e,r,i){for(var n=0;n<r.length;++n){var o=r[n];o.enabled&&o.vertexAttrib(e)}t(i)&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,i._getBuffer())}var s=function(e,r,n,s){if(!t(n))throw new i("attributes is required.");var l,u=[],c=1;for(l=0;l<n.length;++l)o(u,n[l],l);for(l=0;l<u.length;++l){var h=u[l];if(t(h.vertexBuffer)){var d=h.strideInBytes||h.componentsPerAttribute*h.componentDatatype.sizeInBytes;c=h.vertexBuffer.getSizeInBytes()/d;break}}for(var m={},p=0;p<u.length;++p){var f=u[p].index;if(m[f])throw new i("Index "+f+" is used by more than one attribute.");m[f]=!0}var v;t(r)&&(v=r.createVertexArrayOES(),r.bindVertexArrayOES(v),a(e,u,s),r.bindVertexArrayOES(null)),this.numberOfVertices=c,this._gl=e,this._vaoExtension=r,this._vao=v,this._attributes=u,this._indexBuffer=s};return s.prototype.getAttribute=function(e){if(!t(e))throw new i("index is required.");return this._attributes[e]},s.prototype.getNumberOfAttributes=function(){return this._attributes.length},s.prototype.getIndexBuffer=function(){return this._indexBuffer},s.prototype._bind=function(){t(this._vao)?this._vaoExtension.bindVertexArrayOES(this._vao):a(this._gl,this._attributes,this._indexBuffer)},s.prototype._unBind=function(){if(t(this._vao))this._vaoExtension.bindVertexArrayOES(null);else{for(var e=this._attributes,r=this._gl,i=0;i<e.length;++i){var n=e[i];n.enabled&&n.disableVertexAttribArray(r)}this._indexBuffer&&r.bindBuffer(r.ELEMENT_ARRAY_BUFFER,null)}},s.prototype.isDestroyed=function(){return!1},s.prototype.destroy=function(){for(var e=this._attributes,i=0;i<e.length;++i){var n=e[i].vertexBuffer;t(n)&&!n.isDestroyed()&&n.getVertexArrayDestroyable()&&n.destroy()}var o=this._indexBuffer;return t(o)&&!o.isDestroyed()&&o.getVertexArrayDestroyable()&&o.destroy(),t(this._vao)&&this._vaoExtension.deleteVertexArrayOES(this._vao),r(this)},s}),r("Renderer/Context",["../Core/clone","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/destroyObject","../Core/Color","../Core/ComponentDatatype","../Core/IndexDatatype","../Core/RuntimeError","../Core/PrimitiveType","../Core/Geometry","../Core/createGuid","../Core/Matrix4","../Core/Math","./Buffer","./BufferUsage","./CubeMap","./Framebuffer","./PixelDatatype","./PixelFormat","./PickFramebuffer","./Renderbuffer","./RenderbufferFormat","./RenderState","./ShaderCache","./ShaderProgram","./Texture","./TextureAtlas","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap","./UniformState","./VertexArray","./VertexLayout","./ClearCommand","./PassState"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E,b,T,A,D,P,M,I,O,R,L,z){"use strict";function N(e,t){var r="OpenGL Error:  ";switch(t){case e.INVALID_ENUM:r+="Invalid enumeration";break;case e.INVALID_VALUE:r+="Invalid value";break;case e.INVALID_OPERATION:r+="Invalid operation";break;case e.OUT_OF_MEMORY:r+="Out of memory";break;case e.CONTEXT_LOST_WEBGL:r+="Context lost";break;default:r+="Unknown"}return r}function B(e,t,r,i){for(var n=N(e,i)+": "+t.name+"(",o=0;o<r.length;++o)0!==o&&(n+=", "),n+=r[o];return n+=");"}function F(e,t,r){var i=e.getError();if(i!==e.NO_ERROR)throw new l(B(e,t,r,i))}function V(e,t,r){return{get:function(){var i=e[t];return r(e,"get: "+t,i),e[t]},set:function(i){e[t]=i,r(e,"set: "+t,i)}}}function k(e,t){function r(r){return function(){var i=r.apply(e,arguments);return t(e,r,arguments),i}}if(!t)return e;var i={};for(var n in e){var o=e[n];"function"==typeof o?i[n]=r(o):Object.defineProperty(i,n,V(e,n,t))}return i}function U(e,t){for(var r=t.length,i=0;r>i;++i){var n=e.getExtension(t[i]);if(n)return n}return void 0}function W(e,t,r,i){var n;"number"==typeof r?n=r:"object"==typeof r&&"number"==typeof r.byteLength&&(n=r.byteLength);var o=e.createBuffer();return e.bindBuffer(t,o),e.bufferData(t,r,i),e.bindBuffer(t,null),new p(e,t,n,i,o)}function q(e){if(e._validateFB){var t=e._gl,r=t.checkFramebufferStatus(t.FRAMEBUFFER);if(r!==t.FRAMEBUFFER_COMPLETE){var n;switch(r){case t.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:n="Framebuffer is not complete.  Incomplete attachment: at least one attachment point with a renderbuffer or texture attached has its attached object no longer in existence or has an attached image with a width or height of zero, or the color attachment point has a non-color-renderable image attached, or the depth attachment point has a non-depth-renderable image attached, or the stencil attachment point has a non-stencil-renderable image attached.  Color-renderable formats include GL_RGBA4, GL_RGB5_A1, and GL_RGB565. GL_DEPTH_COMPONENT16 is the only depth-renderable format. GL_STENCIL_INDEX8 is the only stencil-renderable format.";break;case t.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:n="Framebuffer is not complete.  Incomplete dimensions: not all attached images have the same width and height.";break;case t.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:n="Framebuffer is not complete.  Missing attachment: no images are attached to the framebuffer.";break;case t.FRAMEBUFFER_UNSUPPORTED:n="Framebuffer is not complete.  Unsupported: the combination of internal formats of the attached images violates an implementation-dependent set of restrictions."}throw new i(n)}}}function G(e,t,r){var i=e._currentRenderState;i!==t&&(e._currentRenderState=t,S.partialApply(e._gl,i,t,r))}function H(e,t,i,n){var o=r(i.renderState)?i.renderState:e._defaultRenderState;r(t)&&(t._bind(),q(e,t));var a=i.shaderProgram;a._bind(),e._maxFrameTextureUnitIndex=Math.max(e._maxFrameTextureUnitIndex,a.maximumTextureUnitIndex),G(e,o,n)}function j(e,i){var n=i.primitiveType,o=i.vertexArray,a=i.offset,s=i.count;e._us.setModel(t(i.modelMatrix,d.IDENTITY)),i.shaderProgram._setUniforms(i.uniformMap,e._us,e._validateSP);var l=o.getIndexBuffer();r(l)?(a*=l.getBytesPerIndex(),s=t(s,l.getNumberOfIndices()),o._bind(),e._gl.drawElements(n,s,l.getIndexDatatype(),a),o._unBind()):(s=t(s,o.numberOfVertices),o._bind(),e._gl.drawArrays(n,a,s),o._unBind())}function Y(e){r(e)&&e._unBind()}function X(e){return e.values.length/e.componentsPerAttribute}function Z(e){return e.componentDatatype.sizeInBytes*e.componentsPerAttribute}function J(e){var t,i,n,o=[];for(i in e)e.hasOwnProperty(i)&&r(e[i])&&r(e[i].values)&&(o.push(i),e[i].componentDatatype.value===a.DOUBLE.value&&(e[i].componentDatatype=a.FLOAT,e[i].values=a.createTypedArray(a.FLOAT,e[i].values)));var s,u=o.length;if(u>0)for(s=X(e[o[0]]),t=1;u>t;++t){var c=X(e[o[t]]);if(c!==s)throw new l("Each attribute list must have the same number of vertices.  Attribute "+o[t]+" has a different number of vertices "+"("+c.toString()+")"+" than attribute "+o[0]+" ("+s.toString()+").")
}o.sort(function(t,r){return e[r].componentDatatype.sizeInBytes-e[t].componentDatatype.sizeInBytes});var h=0,d={};for(t=0;u>t;++t)i=o[t],n=e[i],d[i]=h,h+=Z(n);if(h>0){var m=e[o[0]].componentDatatype.sizeInBytes,p=h%m;0!==p&&(h+=m-p);var f=s*h,v=new ArrayBuffer(f),y={};for(t=0;u>t;++t){i=o[t];var g=e[i].componentDatatype.sizeInBytes;y[i]={pointer:a.createTypedArray(e[i].componentDatatype,v),index:d[i]/g,strideInComponentType:h/g}}for(t=0;s>t;++t)for(var _=0;u>_;++_){i=o[_],n=e[i];for(var w=n.values,C=y[i],x=C.pointer,S=n.componentsPerAttribute,E=0;S>E;++E)x[C.index+E]=w[t*S+E];C.index+=C.strideInComponentType}return{buffer:v,offsetsInBytes:d,vertexSizeInBytes:h}}return void 0}function K(e,t,r){this._pickObjects=e,this.key=t,this.color=r}var Q=function(i,n){if(!window.WebGLRenderingContext)throw new l("The browser does not support WebGL.  Visit http://get.webgl.org.");this._canvas=i,n=e(n,!0),n=t(n,{}),n.allowTextureFilterAnisotropic=t(n.allowTextureFilterAnisotropic,!0);var a=t(n.webgl,{});if(a.alpha=t(a.alpha,!1),a.failIfMajorPerformanceCaveat=t(a.failIfMajorPerformanceCaveat,!0),this._originalGLContext=i.getContext("webgl",a)||i.getContext("experimental-webgl",a)||void 0,!r(this._originalGLContext))throw new l("The browser supports WebGL, but initialization failed.");this._id=h(),this._validateFB=!1,this._validateSP=!1,this._logShaderCompilation=!1,this._throwOnWebGLError=!1,this._shaderCache=new E(this);var s=this._gl=this._originalGLContext;this._version=s.getParameter(s.VERSION),this._shadingLanguageVersion=s.getParameter(s.SHADING_LANGUAGE_VERSION),this._vendor=s.getParameter(s.VENDOR),this._renderer=s.getParameter(s.RENDERER),this._redBits=s.getParameter(s.RED_BITS),this._greenBits=s.getParameter(s.GREEN_BITS),this._blueBits=s.getParameter(s.BLUE_BITS),this._alphaBits=s.getParameter(s.ALPHA_BITS),this._depthBits=s.getParameter(s.DEPTH_BITS),this._stencilBits=s.getParameter(s.STENCIL_BITS),this._maximumCombinedTextureImageUnits=s.getParameter(s.MAX_COMBINED_TEXTURE_IMAGE_UNITS),this._maximumCubeMapSize=s.getParameter(s.MAX_CUBE_MAP_TEXTURE_SIZE),this._maximumFragmentUniformVectors=s.getParameter(s.MAX_FRAGMENT_UNIFORM_VECTORS),this._maximumTextureImageUnits=s.getParameter(s.MAX_TEXTURE_IMAGE_UNITS),this._maximumRenderbufferSize=s.getParameter(s.MAX_RENDERBUFFER_SIZE),this._maximumTextureSize=s.getParameter(s.MAX_TEXTURE_SIZE),this._maximumVaryingVectors=s.getParameter(s.MAX_VARYING_VECTORS),this._maximumVertexAttributes=s.getParameter(s.MAX_VERTEX_ATTRIBS),this._maximumVertexTextureImageUnits=s.getParameter(s.MAX_VERTEX_TEXTURE_IMAGE_UNITS),this._maximumVertexUniformVectors=s.getParameter(s.MAX_VERTEX_UNIFORM_VECTORS),this._aliasedLineWidthRange=s.getParameter(s.ALIASED_LINE_WIDTH_RANGE),this._aliasedPointSizeRange=s.getParameter(s.ALIASED_POINT_SIZE_RANGE),this._maximumViewportDimensions=s.getParameter(s.MAX_VIEWPORT_DIMS),this._antialias=s.getContextAttributes().antialias,this._standardDerivatives=U(s,["OES_standard_derivatives"]),this._elementIndexUint=U(s,["OES_element_index_uint"]),this._depthTexture=U(s,["WEBGL_depth_texture","WEBKIT_WEBGL_depth_texture"]),this._textureFloat=U(s,["OES_texture_float"]);var u=n.allowTextureFilterAnisotropic?U(s,["EXT_texture_filter_anisotropic","WEBKIT_EXT_texture_filter_anisotropic"]):void 0;this._textureFilterAnisotropic=u,this._maximumTextureFilterAnisotropy=r(u)?s.getParameter(u.MAX_TEXTURE_MAX_ANISOTROPY_EXT):1,this._vertexArrayObject=U(s,["OES_vertex_array_object"]),this._fragDepth=U(s,["EXT_frag_depth"]);var c=s.getParameter(s.COLOR_CLEAR_VALUE);this._clearColor=new o(c[0],c[1],c[2],c[3]),this._clearDepth=s.getParameter(s.DEPTH_CLEAR_VALUE),this._clearStencil=s.getParameter(s.STENCIL_CLEAR_VALUE);var d=new I,m=new z(this),p=this.createRenderState();this._defaultPassState=m,this._defaultRenderState=p,this._defaultTexture=void 0,this._defaultCubeMap=void 0,this._us=d,this._currentRenderState=p,this._maxFrameTextureUnitIndex=0,this._pickObjects={},this._nextPickColor=new Uint32Array(1),this.options=n,this.cache={},S.apply(s,p,m)};Q.prototype.getId=function(){return this._id},Q.prototype.getCanvas=function(){return this._canvas},Q.prototype.getShaderCache=function(){return this._shaderCache},Q.prototype.getUniformState=function(){return this._us},Q.prototype.getVersion=function(){return this._version},Q.prototype.getShadingLanguageVersion=function(){return this._shadingLanguageVersion},Q.prototype.getVendor=function(){return this._vendor},Q.prototype.getRenderer=function(){return this._renderer},Q.prototype.getRedBits=function(){return this._redBits},Q.prototype.getGreenBits=function(){return this._greenBits},Q.prototype.getBlueBits=function(){return this._blueBits},Q.prototype.getAlphaBits=function(){return this._alphaBits},Q.prototype.getDepthBits=function(){return this._depthBits},Q.prototype.getStencilBits=function(){return this._stencilBits},Q.prototype.getMaximumCombinedTextureImageUnits=function(){return this._maximumCombinedTextureImageUnits},Q.prototype.getMaximumCubeMapSize=function(){return this._maximumCubeMapSize},Q.prototype.getMaximumFragmentUniformVectors=function(){return this._maximumFragmentUniformVectors},Q.prototype.getMaximumTextureImageUnits=function(){return this._maximumTextureImageUnits},Q.prototype.getMaximumRenderbufferSize=function(){return this._maximumRenderbufferSize},Q.prototype.getMaximumTextureSize=function(){return this._maximumTextureSize},Q.prototype.getMaximumVaryingVectors=function(){return this._maximumVaryingVectors},Q.prototype.getMaximumVertexAttributes=function(){return this._maximumVertexAttributes},Q.prototype.getMaximumVertexTextureImageUnits=function(){return this._maximumVertexTextureImageUnits},Q.prototype.getMaximumVertexUniformVectors=function(){return this._maximumVertexUniformVectors},Q.prototype.getMinimumAliasedLineWidth=function(){return this._aliasedLineWidthRange[0]},Q.prototype.getMaximumAliasedLineWidth=function(){return this._aliasedLineWidthRange[1]},Q.prototype.getMinimumAliasedPointSize=function(){return this._aliasedPointSizeRange[0]},Q.prototype.getMaximumAliasedPointSize=function(){return this._aliasedPointSizeRange[1]},Q.prototype.getMaximumViewportWidth=function(){return this._maximumViewportDimensions[0]},Q.prototype.getMaximumViewportHeight=function(){return this._maximumViewportDimensions[1]},Q.prototype.getAntialias=function(){return this._antialias},Q.prototype.getStandardDerivatives=function(){return!!this._standardDerivatives},Q.prototype.getElementIndexUint=function(){return!!this._elementIndexUint},Q.prototype.getDepthTexture=function(){return!!this._depthTexture},Q.prototype.getFloatingPointTexture=function(){return!!this._textureFloat},Q.prototype.getTextureFilterAnisotropic=function(){return!!this._textureFilterAnisotropic},Q.prototype.getMaximumTextureFilterAnisotropy=function(){return this._maximumTextureFilterAnisotropy},Q.prototype.getVertexArrayObject=function(){return!!this._vertexArrayObject},Q.prototype.getFragmentDepth=function(){return!!this._fragDepth},Q.prototype.getValidateFramebuffer=function(){return this._validateFB},Q.prototype.setValidateFramebuffer=function(e){this._validateFB=e},Q.prototype.getValidateShaderProgram=function(){return this._validateSP},Q.prototype.setValidateShaderProgram=function(e){this._validateSP=e},Q.prototype.getThrowOnWebGLError=function(){return this._throwOnWebGLError},Q.prototype.setThrowOnWebGLError=function(e){this._throwOnWebGLError=e,this._gl=k(this._originalGLContext,e?F:null)},Q.prototype.getLogShaderCompilation=function(){return this._logShaderCompilation},Q.prototype.setLogShaderCompilation=function(e){this._logShaderCompilation=e},Q.prototype.getDefaultTexture=function(){return void 0===this._defaultTexture&&(this._defaultTexture=this.createTexture2D({source:{width:1,height:1,arrayBufferView:new Uint8Array([255,255,255,255])}})),this._defaultTexture},Q.prototype.getDefaultCubeMap=function(){if(void 0===this._defaultCubeMap){var e={width:1,height:1,arrayBufferView:new Uint8Array([255,255,255,255])};this._defaultCubeMap=this.createCubeMap({source:{positiveX:e,negativeX:e,positiveY:e,negativeY:e,positiveZ:e,negativeZ:e}})}return this._defaultCubeMap},Q.prototype.getDrawingBufferHeight=function(){return this._gl.drawingBufferHeight},Q.prototype.getDrawingBufferWidth=function(){return this._gl.drawingBufferWidth},Q.prototype.createShaderProgram=function(e,t,r){return new b(this._gl,this._logShaderCompilation,e,t,r)},Q.prototype.createVertexBuffer=function(e,t){return W(this._gl,this._gl.ARRAY_BUFFER,e,t)},Q.prototype.createIndexBuffer=function(e,t,r){if(r===s.UNSIGNED_INT&&!this.getElementIndexUint())throw new l("IndexDatatype.UNSIGNED_INT requires OES_element_index_uint, which is not supported on this system.");var i=s.getSizeInBytes(r),n=this._gl,o=W(n,n.ELEMENT_ARRAY_BUFFER,e,t),a=o.getSizeInBytes()/i;return o.getIndexDatatype=function(){return r},o.getBytesPerIndex=function(){return i},o.getNumberOfIndices=function(){return a},o},Q.prototype.createVertexArray=function(e,t){return new O(this._gl,this._vertexArrayObject,e,t)},Q.prototype.createTexture2D=function(e){e=t(e,t.EMPTY_OBJECT);var i=e.source,n=r(i)?i.width:e.width,o=r(i)?i.height:e.height,a=t(e.pixelFormat,_.RGBA),s=t(e.pixelDatatype,g.UNSIGNED_BYTE);if(s===g.FLOAT&&!this.getFloatingPointTexture())throw new l("When options.pixelDatatype is FLOAT, this WebGL implementation must support the OES_texture_float extension.");if(_.isDepthFormat(a)&&!this.getDepthTexture())throw new l("When options.pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, this WebGL implementation must support WEBGL_depth_texture.  Check getDepthTexture().");var u=e.preMultiplyAlpha||a===_.RGB||a===_.LUMINANCE,c=t(e.flipY,!0),h=this._gl,d=h.TEXTURE_2D,m=h.createTexture();return h.activeTexture(h.TEXTURE0),h.bindTexture(d,m),r(i)?(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,u),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,c),r(i.arrayBufferView)?h.texImage2D(d,0,a,n,o,0,a,s,i.arrayBufferView):h.texImage2D(d,0,a,a,s,i)):h.texImage2D(d,0,a,n,o,0,a,s,null),h.bindTexture(d,null),new T(h,this._textureFilterAnisotropic,d,m,a,s,n,o,u,c)},Q.prototype.createTexture2DFromFramebuffer=function(e,r,i,n,o){var a=this._gl;e=t(e,_.RGB),r=t(r,0),i=t(i,0),n=t(n,a.drawingBufferWidth),o=t(o,a.drawingBufferHeight);var s=a.TEXTURE_2D,l=a.createTexture();return a.activeTexture(a.TEXTURE0),a.bindTexture(s,l),a.copyTexImage2D(s,0,e,r,i,n,o,0),a.bindTexture(s,null),new T(a,this._textureFilterAnisotropic,s,l,e,void 0,n,o)},Q.prototype.createTextureAtlas=function(e){return e=t(e,{}),e.context=this,new A(e)},Q.prototype.createCubeMap=function(e){function i(e,t){t.arrayBufferView?p.texImage2D(e,0,c,u,u,0,c,h,t.arrayBufferView):p.texImage2D(e,0,c,c,h,t)}e=t(e,t.EMPTY_OBJECT);var n,o,a=e.source;if(r(a)){var s=[a.positiveX,a.negativeX,a.positiveY,a.negativeY,a.positiveZ,a.negativeZ];n=s[0].width,o=s[0].height}else n=e.width,o=e.height;var u=n,c=t(e.pixelFormat,_.RGBA),h=t(e.pixelDatatype,g.UNSIGNED_BYTE);if(h===g.FLOAT&&!this.getFloatingPointTexture())throw new l("When options.pixelDatatype is FLOAT, this WebGL implementation must support the OES_texture_float extension.");var d=e.preMultiplyAlpha||c===_.RGB||c===_.LUMINANCE,m=t(e.flipY,!0),p=this._gl,f=p.TEXTURE_CUBE_MAP,y=p.createTexture();return p.activeTexture(p.TEXTURE0),p.bindTexture(f,y),r(a)?(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,d),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,m),i(p.TEXTURE_CUBE_MAP_POSITIVE_X,a.positiveX),i(p.TEXTURE_CUBE_MAP_NEGATIVE_X,a.negativeX),i(p.TEXTURE_CUBE_MAP_POSITIVE_Y,a.positiveY),i(p.TEXTURE_CUBE_MAP_NEGATIVE_Y,a.negativeY),i(p.TEXTURE_CUBE_MAP_POSITIVE_Z,a.positiveZ),i(p.TEXTURE_CUBE_MAP_NEGATIVE_Z,a.negativeZ)):(p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_X,0,c,u,u,0,c,h,null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_X,0,c,u,u,0,c,h,null),p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_Y,0,c,u,u,0,c,h,null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,c,u,u,0,c,h,null),p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_Z,0,c,u,u,0,c,h,null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,c,u,u,0,c,h,null)),p.bindTexture(f,null),new v(p,this._textureFilterAnisotropic,f,y,c,h,u,d,m)},Q.prototype.createFramebuffer=function(e){return new y(this._gl,e)},Q.prototype.createRenderbuffer=function(e){var i=this._gl;e=t(e,t.EMPTY_OBJECT);var n=t(e.format,x.RGBA4),o=r(e.width)?e.width:i.drawingBufferWidth,a=r(e.height)?e.height:i.drawingBufferHeight;return new C(i,n,o,a)};var $=0,et={};Q.prototype.createRenderState=function(e){var t=JSON.stringify(e),i=et[t];if(r(i))return i;var n=new S(this,e),o=JSON.stringify(n);return i=et[o],r(i)||(n.id=$++,i=n,et[o]=i),et[t]=i,i},Q.prototype.createSampler=function(e){var i={wrapS:t(e.wrapS,M.CLAMP_TO_EDGE),wrapT:t(e.wrapT,M.CLAMP_TO_EDGE),minificationFilter:t(e.minificationFilter,P.LINEAR),magnificationFilter:t(e.magnificationFilter,D.LINEAR),maximumAnisotropy:r(e.maximumAnisotropy)?e.maximumAnisotropy:1};return i};var tt=new L;return Q.prototype.clear=function(e,i){e=t(e,tt),i=t(i,this._defaultPassState);var n=this._gl,a=0,s=e.color,l=e.depth,u=e.stencil;r(s)&&(o.equals(this._clearColor,s)||(o.clone(s,this._clearColor),n.clearColor(s.red,s.green,s.blue,s.alpha)),a|=n.COLOR_BUFFER_BIT),r(l)&&(l!==this._clearDepth&&(this._clearDepth=l,n.clearDepth(l)),a|=n.DEPTH_BUFFER_BIT),r(u)&&(u!==this._clearStencil&&(this._clearStencil=u,n.clearStencil(u)),a|=n.STENCIL_BUFFER_BIT);var c=t(e.renderState,this._defaultRenderState);G(this,c,i);var h=t(e.framebuffer,i.framebuffer);r(h)&&(h._bind(),q(this,h)),n.clear(a),r(h)&&h._unBind()},Q.prototype.draw=function(e,r){r=t(r,this._defaultPassState);var i=t(e.framebuffer,r.framebuffer);H(this,i,e,r),j(this,e),Y(i)},Q.prototype.endFrame=function(){var e=this._gl;e.useProgram(null);var t=this._maxFrameTextureUnitIndex;this._maxFrameTextureUnitIndex=0;for(var r=0;t>r;++r)e.activeTexture(e.TEXTURE0+r),e.bindTexture(e.TEXTURE_2D,null),e.bindTexture(e.TEXTURE_CUBE_MAP,null)},Q.prototype.readPixels=function(e){var t=this._gl;e=e||{};var r=Math.max(e.x||0,0),i=Math.max(e.y||0,0),n=e.width||t.drawingBufferWidth,o=e.height||t.drawingBufferHeight,a=e.framebuffer||null,s=new Uint8Array(4*n*o);return a&&(a._bind(),q(this,a)),t.readPixels(r,i,n,o,t.RGBA,t.UNSIGNED_BYTE,s),a&&a._unBind(),s},Q.prototype.createVertexArrayFromGeometry=function(e){var i,n,o,l=t(e,t.EMPTY_OBJECT),u=t(l.geometry,t.EMPTY_OBJECT),h=t(l.bufferUsage,f.DYNAMIC_DRAW),d=t(l.attributeIndices,t.EMPTY_OBJECT),p=r(l.vertexLayout)&&l.vertexLayout===R.INTERLEAVED,v=l.vertexArrayAttributes,y=r(v)?v:[],g=u.attributes;if(p){var _=J(g);if(r(_)){o=this.createVertexBuffer(_.buffer,h);var w=_.offsetsInBytes,C=_.vertexSizeInBytes;for(i in g)g.hasOwnProperty(i)&&r(g[i])&&(n=g[i],r(n.values)?y.push({index:d[i],vertexBuffer:o,componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,offsetInBytes:w[i],strideInBytes:C}):y.push({index:d[i],value:n.value,componentDatatype:n.componentDatatype,normalize:n.normalize}))}}else for(i in g)if(g.hasOwnProperty(i)&&r(g[i])){n=g[i];var x=n.componentDatatype;x.value===a.DOUBLE.value&&(x=a.FLOAT),o=void 0,r(n.values)&&(o=this.createVertexBuffer(a.createTypedArray(x,n.values),h)),y.push({index:d[i],vertexBuffer:o,value:n.value,componentDatatype:x,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize})}var S,E=u.indices;return r(E)&&(S=c.computeNumberOfVertices(u)>m.SIXTY_FOUR_KILOBYTES&&this.getElementIndexUint()?this.createIndexBuffer(new Uint32Array(E),h,s.UNSIGNED_INT):this.createIndexBuffer(new Uint16Array(E),h,s.UNSIGNED_SHORT)),this.createVertexArray(y,S)},Q.prototype.createPickFramebuffer=function(){return new w(this)},Q.prototype.getObjectByPickColor=function(e){return this._pickObjects[e.toRgba()]},K.prototype.destroy=function(){return delete this._pickObjects[this.key],void 0},Q.prototype.createPickId=function(e){++this._nextPickColor[0];var t=this._nextPickColor[0];if(0===t)throw new l("Out of unique Pick IDs.");return this._pickObjects[t]=e,new K(this._pickObjects,t,o.fromRgba(t))},Q.prototype.isDestroyed=function(){return!1},Q.prototype.destroy=function(){var e=this.cache;for(var t in e)if(e.hasOwnProperty(t)){var i=e[t];r(i.destroy)&&i.destroy()}return this._shaderCache=this._shaderCache.destroy(),this._defaultTexture=this._defaultTexture&&this._defaultTexture.destroy(),this._defaultCubeMap=this._defaultCubeMap&&this._defaultCubeMap.destroy(),n(this)},Q}),r("Renderer/loadCubeMap",["../Core/defined","../Core/DeveloperError","../Core/loadImage","../ThirdParty/when"],function(e,t,r,i){"use strict";var n=function(n,o,a){if(!e(n))throw new t("context is required.");if(!(e(o)&&e(o.positiveX)&&e(o.negativeX)&&e(o.positiveY)&&e(o.negativeY)&&e(o.positiveZ)&&e(o.negativeZ)))throw new t("urls is required and must have positiveX, negativeX, positiveY, negativeY, positiveZ, and negativeZ properties.");var s=[r(o.positiveX,a),r(o.negativeX,a),r(o.positiveY,a),r(o.negativeY,a),r(o.positiveZ,a),r(o.negativeZ,a)];return i.all(s,function(e){return n.createCubeMap({source:{positiveX:e[0],negativeX:e[1],positiveY:e[2],negativeY:e[3],positiveZ:e[4],negativeZ:e[5]}})})};return n}),r("ThirdParty/Tween",[],function(){var e=e||function(){var e=[];return{REVISION:"7",getAll:function(){return e},removeAll:function(){e=[]},add:function(t){e.push(t)},remove:function(t){var r=e.indexOf(t);-1!==r&&e.splice(r,1)},update:function(t){if(0===e.length)return!1;var r=0,i=e.length;for(t=void 0!==t?t:Date.now();i>r;)e[r].update(t)?r++:(e.splice(r,1),i--);return!0}}}();return e.Tween=function(t){var r=t,i={},n={},o=1e3,a=0,s=null,l=e.Easing.Linear.None,u=e.Interpolation.Linear,c=[],h=null,d=!1,m=null,p=null;this.to=function(e,t){return void 0!==t&&(o=t),n=e,this},this.start=function(t){e.add(this),d=!1,s=void 0!==t?t:Date.now(),s+=a;for(var o in n)if(null!==r[o]){if(n[o]instanceof Array){if(0===n[o].length)continue;n[o]=[r[o]].concat(n[o])}i[o]=r[o]}return this},this.stop=function(){return e.remove(this),this},this.delay=function(e){return a=e,this},this.easing=function(e){return l=e,this},this.interpolation=function(e){return u=e,this},this.chain=function(){return c=arguments,this},this.onStart=function(e){return h=e,this},this.onUpdate=function(e){return m=e,this},this.onComplete=function(e){return p=e,this},this.update=function(e){if(s>e)return!0;d===!1&&(null!==h&&h.call(r),d=!0);var t=(e-s)/o;t=t>1?1:t;var a=l(t);for(var f in i){var v=i[f],y=n[f];r[f]=y instanceof Array?u(y,a):v+(y-v)*a}if(null!==m&&m.call(r,a),1==t){null!==p&&p.call(r);for(var g=0,_=c.length;_>g;g++)c[g].start(e);return!1}return!0}},e.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(-Math.pow(2,-10*(e-1))+2)}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),-(r*Math.pow(2,10*(e-=1))*Math.sin((e-t)*2*Math.PI/i)))},Out:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),r*Math.pow(2,-10*e)*Math.sin((e-t)*2*Math.PI/i)+1)},InOut:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),(e*=2)<1?-.5*r*Math.pow(2,10*(e-=1))*Math.sin((e-t)*2*Math.PI/i):.5*r*Math.pow(2,-10*(e-=1))*Math.sin((e-t)*2*Math.PI/i)+1)}},Back:{In:function(e){var t=1.70158;return e*e*((t+1)*e-t)},Out:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?.5*e*e*((t+1)*e-t):.5*((e-=2)*e*((t+1)*e+t)+2)}},Bounce:{In:function(t){return 1-e.Easing.Bounce.Out(1-t)},Out:function(e){return 1/2.75>e?7.5625*e*e:2/2.75>e?7.5625*(e-=1.5/2.75)*e+.75:2.5/2.75>e?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(t){return.5>t?.5*e.Easing.Bounce.In(2*t):.5*e.Easing.Bounce.Out(2*t-1)+.5}}},e.Interpolation={Linear:function(t,r){var i=t.length-1,n=i*r,o=Math.floor(n),a=e.Interpolation.Utils.Linear;return 0>r?a(t[0],t[1],n):r>1?a(t[i],t[i-1],i-n):a(t[o],t[o+1>i?i:o+1],n-o)},Bezier:function(t,r){var i,n=0,o=t.length-1,a=Math.pow,s=e.Interpolation.Utils.Bernstein;for(i=0;o>=i;i++)n+=a(1-r,o-i)*a(r,i)*t[i]*s(o,i);return n},CatmullRom:function(t,r){var i=t.length-1,n=i*r,o=Math.floor(n),a=e.Interpolation.Utils.CatmullRom;return t[0]===t[i]?(0>r&&(o=Math.floor(n=i*(1+r))),a(t[(o-1+i)%i],t[o],t[(o+1)%i],t[(o+2)%i],n-o)):0>r?t[0]-(a(t[0],t[0],t[1],t[1],-n)-t[0]):r>1?t[i]-(a(t[i],t[i],t[i-1],t[i-1],n-i)-t[i]):a(t[o?o-1:0],t[o],t[o+1>i?i:o+1],t[o+2>i?i:o+2],n-o)},Utils:{Linear:function(e,t,r){return(t-e)*r+e},Bernstein:function(t,r){var i=e.Interpolation.Utils.Factorial;return i(t)/i(r)/i(t-r)},Factorial:function(){var e=[1];return function(t){var r,i=1;if(e[t])return e[t];for(r=t;r>1;r--)i*=r;return e[t]=i}}(),CatmullRom:function(e,t,r,i,n){var o=.5*(r-e),a=.5*(i-t),s=n*n,l=n*s;return(2*t-2*r+o+a)*l+(-3*t+3*r-2*o-a)*s+o*n+t}}},e}),r("Scene/AnimationCollection",["../Core/defined","../Core/DeveloperError","../Core/clone","../ThirdParty/Tween","../Core/defaultValue"],function(e,t,r,i,n){"use strict";var o=function(){};return o.prototype.add=function(o){if(o=n(o,n.EMPTY_OBJECT),!e(o.duration))throw new t("duration is required.");if(o.duration>0){var a=n(o.delayDuration,0),s=n(o.easingFunction,i.Easing.Linear.None),l=r(o.startValue),u=new i.Tween(l);return u.onCancel=o.onCancel,u.to(o.stopValue,o.duration),u.delay(a),u.easing(s),"function"==typeof o.onUpdate&&u.onUpdate(function(){o.onUpdate(l)}),u.onComplete(n(o.onComplete,null)),u.start(),{_tween:u}}"function"==typeof o.onComplete&&o.onComplete()},o.prototype.addAlpha=function(r,o,a,s){if(!e(r))throw new t("material is required.");var l=[];for(var u in r.uniforms)r.uniforms.hasOwnProperty(u)&&e(r.uniforms[u])&&e(r.uniforms[u].alpha)&&l.push(u);if(0===l.length)throw new t("material has no properties with alpha components.");o=n(o,0),a=n(a,1),s=n(s,n.EMPTY_OBJECT);var c=n(s.duration,3e3),h=n(s.delayDuration,0),d=n(s.easingFunction,i.Easing.Linear.None),m={alpha:o},p=new i.Tween(m);return p.to({alpha:a},c),p.delay(h),p.easing(d),p.onUpdate(function(){for(var e=l.length,t=0;e>t;++t)r.uniforms[l[t]].alpha=m.alpha}),p.onComplete(n(s.onComplete,null)),p.start(),{_tween:p}},o.prototype.addProperty=function(r,o,a,s,l){if(!e(r))throw new t("object is required.");if(!e(o))throw new t("property is required.");if(!e(r[o]))throw new t("object must have the specified property.");l=n(l,n.EMPTY_OBJECT);var u=n(l.duration,3e3),c=n(l.delayDuration,0),h=n(l.easingFunction,i.Easing.Linear.None),d={value:a},m=new i.Tween(d);return m.to({value:s},u),m.delay(c),m.easing(h),m.onUpdate(function(){r[o]=d.value}),m.onComplete(n(l.onComplete,null)),m.start(),{_tween:m}},o.prototype.addOffsetIncrement=function(r,o){if(!e(r))throw new t("material is required.");if(!e(r.uniforms.offset))throw new t("material must have an offset property.");o=n(o,n.EMPTY_OBJECT);var a=n(o.duration,3e3),s=n(o.delayDuration,0),l=n(o.easingFunction,i.Easing.Linear.None),u={offset:r.uniforms.offset},c=new i.Tween(u);return c.to({offset:r.uniforms.offset+1},a),c.delay(s),c.easing(l),c.onUpdate(function(){r.uniforms.offset=u.offset}),c.onComplete(function(){c.to({offset:r.uniforms.offset+1},a),c.start()}),c.start(),{_tween:c}},o.prototype.remove=function(t){if(e(t)){var r=i.getAll().length;return i.remove(t._tween),i.getAll().length===r-1}return!1},o.prototype.removeAll=function(){for(var e=i.getAll(),t=e.length,r=-1;++r<t;){var n=e[r];"function"==typeof n.onCancel&&n.onCancel()}i.removeAll()},o.prototype.contains=function(t){return e(t)?-1!==i.getAll().indexOf(t._tween):!1},o.prototype.update=function(){i.update()},o}),r("Scene/Credit",["../Core/defined","../Core/DeveloperError"],function(e,t){"use strict";var r=function(r,i,n){var o=e(n),a=e(i),s=e(r);if(!s&&!a&&!o)throw new t("text, imageUrl or link is required");s||a||(r=n),this._text=r,this._imageUrl=i,this._link=n,this._hasLink=o,this._hasImage=a};return r.prototype.hasImage=function(){return this._hasImage},r.prototype.hasLink=function(){return this._hasLink},r.prototype.getText=function(){return this._text},r.prototype.getImageUrl=function(){return this._imageUrl},r.prototype.getLink=function(){return this._link},r.equals=function(t,r){var i=!e(t),n=!e(r);return t===r||(i&&n||!i&&!n)&&t._text===r._text&&t._imageUrl===r._imageUrl&&t._link===r._link},r.prototype.equals=function(e){return r.equals(this,e)},r}),r("Scene/TerrainProvider",["../Core/defined","../Core/DeveloperError","../Core/ComponentDatatype","../Renderer/BufferUsage","../Core/IndexDatatype"],function(e,t,r,i,n){"use strict";function o(e,t,r,i,n){return e[t++]=r,e[t++]=i,e[t++]=i,e[t++]=n,e[t++]=n,e[t++]=r,t}function a(e){for(var t=e.length,r=new Uint16Array(2*t),i=0,n=0;t>n;n+=3)i=o(r,i,e[n],e[n+1],e[n+2]);return r}var s=function(){throw new t("This type should not be instantiated directly.")};s.attributeIndices={position3DAndHeight:0,textureCoordinates:1};var l=[];return s.getRegularGridIndices=function(t,r){var i=l[t];e(i)||(l[t]=i=[]);var n=i[r];if(!e(n)){n=i[r]=new Uint16Array(6*(t-1)*(r-1));for(var o=0,a=0,s=0;r-1>s;++s){for(var u=0;t-1>u;++u){var c=o,h=c+t,d=h+1,m=c+1;n[a++]=c,n[a++]=h,n[a++]=m,n[a++]=m,n[a++]=h,n[a++]=d,++o}++o}}return n},s.createTileEllipsoidGeometryFromBuffers=function(t,o,a,l){var u=r.FLOAT,c=o.vertices,h=t.createVertexBuffer(c,i.STATIC_DRAW),d=5*u.sizeInBytes,m=3;l&&(d+=u.sizeInBytes,++m);var p=[{index:s.attributeIndices.position3DAndHeight,vertexBuffer:h,componentDatatype:u,componentsPerAttribute:m,offsetInBytes:0,strideInBytes:d},{index:s.attributeIndices.textureCoordinates,vertexBuffer:h,componentDatatype:u,componentsPerAttribute:2,offsetInBytes:m*u.sizeInBytes,strideInBytes:d}],f=o.indices.indexBuffers||{},v=f[t.getId()];if(!e(v)||v.isDestroyed()){var y=o.indices;v=t.createIndexBuffer(y,i.STATIC_DRAW,n.UNSIGNED_SHORT),v.setVertexArrayDestroyable(!1),v.referenceCount=1,f[t.getId()]=v,o.indices.indexBuffers=f}else++v.referenceCount;a.vertexArray=t.createVertexArray(p,v)},s.createWireframeVertexArray=function(e,t,r){var o=a(r.indices),s=e.createIndexBuffer(o,i.STATIC_DRAW,n.UNSIGNED_SHORT);return e.createVertexArray(t._attributes,s)},s.heightmapTerrainQuality=.25,s.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,r){return 2*e.getMaximumRadius()*Math.PI*s.heightmapTerrainQuality/(t*r)},s.prototype.requestTileGeometry=function(){throw new t("This type should not be instantiated directly.")},s.prototype.getErrorEvent=function(){throw new t("This type should not be instantiated directly.")},s.prototype.getLevelMaximumGeometricError=function(){throw new t("This type should not be instantiated directly.")},s.prototype.getCredit=function(){throw new t("This type should not be instantiated directly.")},s.prototype.getTilingScheme=function(){throw new t("This type should not be instantiated directly.")},s.prototype.hasWaterMask=function(){throw new t("This type should not be instantiated directly.")},s.prototype.isReady=function(){throw new t("This type should not be instantiated directly.")},s}),r("Scene/ImageryState",["../Core/Enumeration"],function(e){"use strict";var t={UNLOADED:new e(0,"UNLOADED"),TRANSITIONING:new e(1,"TRANSITIONING"),RECEIVED:new e(2,"RECEIVED"),TEXTURE_LOADED:new e(3,"TEXTURE_LOADED"),READY:new e(4,"READY"),FAILED:new e(5,"FAILED"),INVALID:new e(6,"INVALID"),PLACEHOLDER:new e(7,"PLACEHOLDER")};return t}),r("Scene/TerrainState",["../Core/Enumeration"],function(e){"use strict";var t={FAILED:new e(0,"FAILED"),UNLOADED:new e(1,"UNLOADED"),RECEIVING:new e(2,"RECEIVING"),RECEIVED:new e(3,"RECEIVED"),TRANSFORMING:new e(4,"TRANSFORMING"),TRANSFORMED:new e(5,"TRANSFORMED"),READY:new e(6,"READY")};return t}),r("Scene/TileState",["../Core/Enumeration"],function(e){"use strict";var t={START:new e(0,"START"),LOADING:new e(1,"LOADING"),READY:new e(2,"READY")};return t}),r("Scene/TileProviderError",["../Core/defaultValue","../Core/defined"],function(e,t){"use strict";var r=function(t,r,i,n,o,a){this.provider=t,this.message=r,this.x=i,this.y=n,this.level=o,this.timesRetried=e(a,0),this.retry=!1};return r.handleError=function(e,i,n,o,a,s,l,u){var c=e;return t(e)?(c.provider=i,c.message=o,c.x=a,c.y=s,c.level=l,c.retry=!1,++c.timesRetried):c=new r(i,o,a,s,l,0),n.getNumberOfListeners()>0?n.raiseEvent(c):(console.log('An error occurred in "'+i.constructor.name+'":'),console.log(o)),c.retry&&t(u)&&u(),c},r.handleSuccess=function(e){t(e)&&(e.timesRetried=-1)},r}),r("Scene/TileTerrain",["../Core/BoundingSphere","../Core/Cartesian3","../Core/defined","../Core/DeveloperError","./TerrainProvider","./TerrainState","./TileProviderError","../ThirdParty/when"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,t,i,n,l){function u(t){e.data=t,e.state=o.RECEIVED}function c(){e.state=o.FAILED;var r="Failed to obtain terrain tile X: "+i+" Y: "+n+" Level: "+l+".";t._requestError=a.handleError(t._requestError,t,t.getErrorEvent(),r,i,n,l,h)}function h(){e.data=t.requestTileGeometry(i,n,l),r(e.data)?(e.state=o.RECEIVING,s(e.data,u,c)):e.state=o.UNLOADED}h()}function u(e,t,i,n,a,l){var u=i.getTilingScheme(),c=e.data,h=c.createMesh(u,n,a,l);r(h)&&(e.state=o.TRANSFORMING,s(h,function(t){e.mesh=t,e.state=o.TRANSFORMED},function(){e.state=o.FAILED}))}function c(e,t){n.createTileEllipsoidGeometryFromBuffers(t,e.mesh,e,!0),e.state=o.READY}var h=function(e){this.state=o.UNLOADED,this.data=void 0,this.mesh=void 0,this.vertexArray=void 0,this.upsampleDetails=e};return h.prototype.freeResources=function(){if(this.state=o.UNLOADED,this.data=void 0,this.mesh=void 0,r(this.vertexArray)){var e=this.vertexArray.getIndexBuffer();this.vertexArray.destroy(),this.vertexArray=void 0,!e.isDestroyed()&&r(e.referenceCount)&&(--e.referenceCount,0===e.referenceCount&&e.destroy())}},h.prototype.publishToTile=function(r){var i=this.mesh;t.clone(i.center,r.center),r.minimumHeight=i.minimumHeight,r.maximumHeight=i.maximumHeight,e.clone(i.boundingSphere3D,r.boundingSphere3D),t.clone(i.occludeePointInScaledSpace,r.occludeePointInScaledSpace),r.freeVertexArray(),r.vertexArray=this.vertexArray,this.vertexArray=void 0},h.prototype.processLoadStateMachine=function(e,t,r,i,n){this.state===o.UNLOADED&&l(this,t,r,i,n),this.state===o.RECEIVED&&u(this,e,t,r,i,n),this.state===o.TRANSFORMED&&c(this,e,t,r,i,n)},h.prototype.processUpsampleStateMachine=function(e,t,n,a,l){if(this.state===o.UNLOADED){var h=this.upsampleDetails;if(!r(h))throw new i("TileTerrain cannot upsample unless provided upsampleDetails.");var d=h.data,m=h.x,p=h.y,f=h.level;if(this.data=d.upsample(t.getTilingScheme(),m,p,f,n,a,l),!r(this.data))return;this.state=o.RECEIVING;var v=this;s(this.data,function(e){v.data=e,v.state=o.RECEIVED},function(){v.state=o.FAILED})}this.state===o.RECEIVED&&u(this,e,t,n,a,l),this.state===o.TRANSFORMED&&c(this,e,t,n,a,l)},h}),r("Scene/Tile",["../Core/BoundingSphere","../Core/Cartesian3","../Core/Cartesian4","../Core/defined","../Core/DeveloperError","./ImageryState","./TerrainState","./TileState","./TileTerrain","../Renderer/PixelDatatype","../Renderer/PixelFormat","../Renderer/TextureMagnificationFilter","../Renderer/TextureMinificationFilter","../Renderer/TextureWrap"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m){"use strict";
function p(e,r,n){var o=v(e);i(o)&&(e.upsampledTerrain=new l(o)),_(e)&&(e.loadedTerrain=new l);for(var a=0,s=n.getLength();s>a;++a){var u=n.get(a);u.show&&u._createTileImagerySkeletons(e,r)}var c=e.tilingScheme.getEllipsoid(),h=e.extent;c.cartographicToCartesian(h.getSouthwest(),e.southwestCornerCartesian);var d=c.cartographicToCartesian(h.getSoutheast(),b);c.cartographicToCartesian(h.getNortheast(),e.northeastCornerCartesian);var m=c.cartographicToCartesian(h.getNorthwest(),T);t.negate(e.southwestCornerCartesian,S),t.cross(t.UNIT_Z,S,S),t.normalize(S,e.westNormal),t.negate(e.northeastCornerCartesian,S),t.cross(S,t.UNIT_Z,S),t.normalize(S,e.eastNormal),c.geodeticSurfaceNormal(d,E),t.subtract(e.southwestCornerCartesian,d,S),t.cross(E,S,S),t.normalize(S,e.southNormal),c.geodeticSurfaceNormal(m,E),t.subtract(e.northeastCornerCartesian,m,S),t.cross(E,S,S),t.normalize(S,e.northNormal)}function f(e,t,r){var n=e.loadedTerrain,o=e.upsampledTerrain,s=!1;if(i(n)){if(n.processLoadStateMachine(t,r,e.x,e.y,e.level),n.state.value>=a.RECEIVED.value){if(e.terrainData!==n.data){e.terrainData=n.data;var l=e.terrainData.getWaterMask();i(l)&&(i(e.waterMaskTexture)&&(--e.waterMaskTexture.referenceCount,0===e.waterMaskTexture.referenceCount&&e.waterMaskTexture.destroy()),e.waterMaskTexture=w(t,l),e.waterMaskTranslationAndScale.x=0,e.waterMaskTranslationAndScale.y=0,e.waterMaskTranslationAndScale.z=1,e.waterMaskTranslationAndScale.w=1),g(e)}s=!0}n.state===a.READY?(n.publishToTile(e),e.loadedTerrain=void 0,e.upsampledTerrain=void 0):n.state===a.FAILED&&(e.loadedTerrain=void 0)}!s&&i(o)&&(o.processUpsampleStateMachine(t,r,e.x,e.y,e.level),o.state.value>=a.RECEIVED.value&&e.terrainData!==o.data&&(e.terrainData=o.data,r.hasWaterMask()&&C(e,t),y(e)),o.state===a.READY?(o.publishToTile(e),e.upsampledTerrain=void 0):o.state===a.FAILED&&(e.upsampledTerrain=void 0))}function v(e){for(var t=e.parent;i(t)&&!i(t.terrainData);)t=t.parent;return i(t)?{data:t.terrainData,x:t.x,y:t.y,level:t.level}:void 0}function y(e){if(i(e.children))for(var t=0;4>t;++t){var r=e.children[t];if(r.state!==s.START){if(i(r.terrainData)&&!r.terrainData.wasCreatedByUpsampling())continue;i(r.upsampledTerrain)&&r.upsampledTerrain.freeResources(),r.upsampledTerrain=new l({data:e.terrainData,x:e.x,y:e.y,level:e.level}),r.state=s.LOADING}}}function g(e){if(i(e.children))for(var t=0;4>t;++t){var r=e.children[t];if(r.state!==s.START){if(i(r.terrainData)&&!r.terrainData.wasCreatedByUpsampling())continue;i(r.upsampledTerrain)&&r.upsampledTerrain.freeResources(),r.upsampledTerrain=new l({data:e.terrainData,x:e.x,y:e.y,level:e.level}),e.terrainData.isChildAvailable(e.x,e.y,r.x,r.y)&&(i(r.loadedTerrain)||(r.loadedTerrain=new l)),r.state=s.LOADING}}}function _(e){var t=e.parent;return i(t)?i(t.terrainData)?t.terrainData.isChildAvailable(t.x,t.y,e.x,e.y):!1:!0}function w(e,t){var r,n=e.cache.tile_waterMaskData;i(n)||(n=e.cache.tile_waterMaskData={allWaterTexture:void 0,allLandTexture:void 0,sampler:void 0,destroy:function(){i(this.allWaterTexture)&&this.allWaterTexture.destroy(),i(this.allLandTexture)&&this.allLandTexture.destroy()}});var o=Math.sqrt(t.length);return 1!==o||0!==t[0]&&255!==t[0]?(r=e.createTexture2D({pixelFormat:c.LUMINANCE,pixelDatatype:u.UNSIGNED_BYTE,source:{width:o,height:o,arrayBufferView:t}}),r.referenceCount=0,i(n.sampler)||(n.sampler=e.createSampler({wrapS:m.CLAMP_TO_EDGE,wrapT:m.CLAMP_TO_EDGE,minificationFilter:d.LINEAR,magnificationFilter:h.LINEAR})),r.setSampler(n.sampler)):(i(n.allWaterTexture)||(n.allWaterTexture=e.createTexture2D({pixelFormat:c.LUMINANCE,pixelDatatype:u.UNSIGNED_BYTE,source:{arrayBufferView:new Uint8Array([255]),width:1,height:1}}),n.allWaterTexture.referenceCount=1,n.allLandTexture=e.createTexture2D({pixelFormat:c.LUMINANCE,pixelDatatype:u.UNSIGNED_BYTE,source:{arrayBufferView:new Uint8Array([0]),width:1,height:1}}),n.allLandTexture.referenceCount=1),r=0===t[0]?n.allLandTexture:n.allWaterTexture),++r.referenceCount,r}function C(e){for(var t=e.parent;i(t)&&!i(t.terrainData)||t.terrainData.wasCreatedByUpsampling();)t=t.parent;if(i(t)&&i(t.waterMaskTexture)){e.waterMaskTexture=t.waterMaskTexture,++e.waterMaskTexture.referenceCount;var r=t.extent,n=e.extent,o=n.east-n.west,a=n.north-n.south,s=o/(r.east-r.west),l=a/(r.north-r.south);e.waterMaskTranslationAndScale.x=s*(n.west-r.west)/o,e.waterMaskTranslationAndScale.y=l*(n.south-r.south)/a,e.waterMaskTranslationAndScale.z=s,e.waterMaskTranslationAndScale.w=l}}var x=function(o){if(!i(o))throw new n("description is required.");if(i(o.x)&&i(o.y)){if(o.x<0||o.y<0)throw new n("description.x and description.y must be greater than or equal to zero.")}else if(!i(o.extent))throw new n("Either description.extent is required or description.x and description.y are required.");if(!i(o.level)||o.zoom<0)throw new n("description.level is required and must be greater than or equal to zero.");if(!i(o.tilingScheme))throw new n("description.tilingScheme is required.");this.tilingScheme=o.tilingScheme,this.x=o.x,this.y=o.y,this.level=o.level,this.parent=o.parent,this.children=void 0,this.extent=this.tilingScheme.tileXYToExtent(this.x,this.y,this.level),this.state=s.START,this.replacementPrevious=void 0,this.replacementNext=void 0,this.imagery=[],this.distance=0,this.southwestCornerCartesian=new t,this.northeastCornerCartesian=new t,this.westNormal=new t,this.southNormal=new t,this.eastNormal=new t,this.northNormal=new t,this.waterMaskTexture=void 0,this.waterMaskTranslationAndScale=new r(0,0,1,1),this.terrainData=void 0,this.center=new t,this.vertexArray=void 0,this.minimumHeight=0,this.maximumHeight=0,this.boundingSphere3D=new e,this.boundingSphere2D=new e,this.occludeePointInScaledSpace=new t,this.isRenderable=!1,this.loadedTerrain=void 0,this.upsampledTerrain=void 0};x.prototype.getChildren=function(){if(!i(this.children)){var e=this.tilingScheme,t=this.level+1,r=2*this.x,n=2*this.y;this.children=[new x({tilingScheme:e,x:r,y:n,level:t,parent:this}),new x({tilingScheme:e,x:r+1,y:n,level:t,parent:this}),new x({tilingScheme:e,x:r,y:n+1,level:t,parent:this}),new x({tilingScheme:e,x:r+1,y:n+1,level:t,parent:this})]}return this.children},x.prototype.freeResources=function(){i(this.waterMaskTexture)&&(--this.waterMaskTexture.referenceCount,0===this.waterMaskTexture.referenceCount&&this.waterMaskTexture.destroy(),this.waterMaskTexture=void 0),this.state=s.START,this.isRenderable=!1,this.terrainData=void 0,i(this.loadedTerrain)&&(this.loadedTerrain.freeResources(),this.loadedTerrain=void 0),i(this.upsampledTerrain)&&(this.upsampledTerrain.freeResources(),this.upsampledTerrain=void 0);var e,t,r=this.imagery;for(e=0,t=r.length;t>e;++e)r[e].freeResources();if(this.imagery.length=0,i(this.children)){for(e=0,t=this.children.length;t>e;++e)this.children[e].freeResources();this.children=void 0}this.freeVertexArray()},x.prototype.freeVertexArray=function(){var e;i(this.vertexArray)&&(e=this.vertexArray.getIndexBuffer(),this.vertexArray.destroy(),this.vertexArray=void 0,!e.isDestroyed()&&i(e.referenceCount)&&(--e.referenceCount,0===e.referenceCount&&e.destroy())),"undefined"!=typeof this.wireframeVertexArray&&(e=this.wireframeVertexArray.getIndexBuffer(),this.wireframeVertexArray.destroy(),this.wireframeVertexArray=void 0,e.isDestroyed()||"undefined"==typeof e.referenceCount||(--e.referenceCount,0===e.referenceCount&&e.destroy()))},x.prototype.processStateMachine=function(e,t,r){this.state===s.START&&(p(this,t,r),this.state=s.LOADING),this.state===s.LOADING&&f(this,e,t);for(var n=i(this.vertexArray),a=!i(this.loadedTerrain)&&!i(this.upsampledTerrain),l=this.imagery,u=0,c=l.length;c>u;++u){var h=l[u];if(i(h.loadingImagery)){if(h.loadingImagery.state===o.PLACEHOLDER){var d=h.loadingImagery.imageryLayer;if(d.getImageryProvider().isReady()){h.freeResources(),l.splice(u,1),d._createTileImagerySkeletons(this,t,u),--u,c=l.length;continue}}var m=h.processStateMachine(this,e);a=a&&m,n=n&&(m||i(h.readyImagery))}}u===c&&(n&&(this.isRenderable=!0),a&&(this.state=s.READY))};var S=new t,E=new t,b=new t,T=new t;return x}),r("Scene/TilingScheme",["../Core/defined","../Core/DeveloperError","./Tile"],function(e,t,r){"use strict";var i=function(){throw new t("This type should not be instantiated directly.  Instead, use WebMercatorTilingScheme or GeographicTilingScheme.")};return i.prototype.getEllipsoid=function(){throw new t("This type should not be instantiated directly.")},i.prototype.getExtent=function(){throw new t("This type should not be instantiated directly.")},i.prototype.getProjection=function(){throw new t("This type should not be instantiated directly.")},i.prototype.getNumberOfXTilesAtLevel=function(){throw new t("This type should not be instantiated directly.")},i.prototype.getNumberOfYTilesAtLevel=function(){throw new t("This type should not be instantiated directly.")},i.prototype.createLevelZeroTiles=function(){throw new t("This type should not be instantiated directly.")},i.prototype.extentToNativeExtent=function(){throw new t("This type should not be instantiated directly.")},i.prototype.tileXYToNativeExtent=function(){throw new t("This type should not be instantiated directly.")},i.prototype.tileXYToExtent=function(){throw new t("This type should not be instantiated directly.")},i.prototype.positionToTileXY=function(){throw new t("This type should not be instantiated directly.")},i.createRectangleOfLevelZeroTiles=function(i,n,o){if(!e(i))throw new t("tilingScheme is required.");if(!e(n))throw new t("numberOfLevelZeroTilesX is required.");if(!e(o))throw new t("numberOfLevelZeroTilesY is required.");for(var a=new Array(n*o),s=0,l=0;o>l;++l)for(var u=0;n>u;++u)a[s++]=new r({tilingScheme:i,x:u,y:l,level:0});return a},i}),r("Scene/GeographicTilingScheme",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Math","../Core/Cartesian2","../Core/Ellipsoid","../Core/Extent","../Core/GeographicProjection","./TilingScheme"],function(e,t,r,i,n,o,a,s,l){"use strict";var u=function(t){t=e(t,{}),this._ellipsoid=e(t.ellipsoid,o.WGS84),this._extent=e(t.extent,a.MAX_VALUE),this._projection=new s(this._ellipsoid),this._numberOfLevelZeroTilesX=e(t.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=e(t.numberOfLevelZeroTilesY,1)};return u.prototype.getEllipsoid=function(){return this._ellipsoid},u.prototype.getExtent=function(){return this._extent},u.prototype.getProjection=function(){return this._projection},u.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},u.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},u.prototype.createLevelZeroTiles=function(){return l.createRectangleOfLevelZeroTiles(this,this._numberOfLevelZeroTilesX,this._numberOfLevelZeroTilesY)},u.prototype.extentToNativeExtent=function(e,n){if(!t(e))throw new r("extent is required.");var o=i.toDegrees(e.west),s=i.toDegrees(e.south),l=i.toDegrees(e.east),u=i.toDegrees(e.north);return t(n)?(n.west=o,n.south=s,n.east=l,n.north=u,n):new a(o,s,l,u)},u.prototype.tileXYToNativeExtent=function(e,t,r,n){var o=this.tileXYToExtent(e,t,r,n);return o.west=i.toDegrees(o.west),o.south=i.toDegrees(o.south),o.east=i.toDegrees(o.east),o.north=i.toDegrees(o.north),o},u.prototype.tileXYToExtent=function(e,r,i,n){var o=this._extent,s=this.getNumberOfXTilesAtLevel(i),l=this.getNumberOfYTilesAtLevel(i),u=(o.east-o.west)/s,c=e*u+o.west,h=(e+1)*u+o.west,d=(o.north-o.south)/l,m=o.north-r*d,p=o.north-(r+1)*d;return t(n)||(n=new a(c,p,h,m)),n.west=c,n.south=p,n.east=h,n.north=m,n},u.prototype.positionToTileXY=function(e,r,i){var o=this._extent;if(e.latitude>o.north||e.latitude<o.south||e.longitude<o.west||e.longitude>o.east)return void 0;var a=this.getNumberOfXTilesAtLevel(r),s=this.getNumberOfYTilesAtLevel(r),l=(o.east-o.west)/a,u=(o.north-o.south)/s,c=0|(e.longitude-o.west)/l;c>=a&&(c=a-1);var h=0|(o.north-e.latitude)/u;return h>=s&&(h=s-1),t(i)?(i.x=c,i.y=h,i):new n(c,h)},u}),r("Scene/TerrainMesh",[],function(){"use strict";var e=function(e,t,r,i,n,o,a){this.center=e,this.vertices=t,this.indices=r,this.minimumHeight=i,this.maximumHeight=n,this.boundingSphere3D=o,this.occludeePointInScaledSpace=a};return e}),r("Scene/HeightmapTerrainData",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/HeightmapTessellator","../Core/Math","../Core/TaskProcessor","./GeographicTilingScheme","./TerrainMesh","./TerrainProvider","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e,t,r,i,n,o,a){var s=1,l=e._width,u=e._height,c=o*(l-1),h=c+l-1,d=a*(u-1),m=d+u-1,p=1<<s;c/=p,h/=p,d/=p,m/=p;var f=r*(l-1),v=i*(u-1);c-=f,h-=f,d-=v,m-=v;var g,_,w=0|c,C=0|h,x=0|d,S=0|m,E=C-w+1,b=S-x+1,T=e._buffer,A=e._structure,D=E*b,P=D*A.stride,M=new T.constructor(P),I=0,O=A.stride;if(O>1)for(_=x;S>=_;++_)for(g=w;C>=g;++g)for(var R=(_*l+g)*O,L=0;O>L;++L)M[I++]=T[R+L];else for(_=x;S>=_;++_)for(g=w;C>=g;++g)M[I++]=T[_*l+g];return new y({buffer:M,width:E,height:b,childTileMask:0,structure:e._structure,createdByUpsampling:!0})}function h(e,t,r,i,o,a,s,l){var u,c,h,p,f=e._width,g=e._height,_=e._structure,w=_.stride,C=e._buffer,x=new C.constructor(f*g*w),S=t.tileXYToExtent(r,i,o),E=t.tileXYToExtent(a,s,l);if(w>1){var b=_.elementsPerHeight,T=_.elementMultiplier,A=_.isBigEndian,D=Math.pow(T,b-1);for(c=0;g>c;++c)for(h=n.lerp(E.north,E.south,c/(g-1)),u=0;f>u;++u){p=n.lerp(E.west,E.east,u/(f-1));var P=m(C,b,T,w,A,S,f,g,p,h);v(x,b,T,D,w,A,c*f+u,P)}}else for(c=0;g>c;++c)for(h=n.lerp(E.north,E.south,c/(g-1)),u=0;f>u;++u)p=n.lerp(E.west,E.east,u/(f-1)),x[c*f+u]=d(C,S,f,g,p,h);return new y({buffer:x,width:f,height:g,childTileMask:0,structure:e._structure,createdByUpsampling:!0})}function d(e,t,r,i,n,o){var a=(n-t.west)*(r-1)/(t.east-t.west),s=(o-t.south)*(i-1)/(t.north-t.south),l=0|a,u=l+1;u>=r&&(u=r-1,l=r-2);var c=0|s,h=c+1;h>=i&&(h=i-1,c=i-2);var d=a-l,m=s-c;c=i-1-c,h=i-1-h;var f=e[c*r+l],v=e[c*r+u],y=e[h*r+l],g=e[h*r+u];return p(d,m,f,v,y,g)}function m(e,t,r,i,n,o,a,s,l,u){var c=(l-o.west)*(a-1)/(o.east-o.west),h=(u-o.south)*(s-1)/(o.north-o.south),d=0|c,m=d+1;m>=a&&(m=a-1,d=a-2);var v=0|h,y=v+1;y>=s&&(y=s-1,v=s-2);var g=c-d,_=h-v;v=s-1-v,y=s-1-y;var w=f(e,t,r,i,n,v*a+d),C=f(e,t,r,i,n,v*a+m),x=f(e,t,r,i,n,y*a+d),S=f(e,t,r,i,n,y*a+m);return p(g,_,w,C,x,S)}function p(e,t,r,i,n,o){return e>t?r+e*(i-r)+t*(o-i):r+e*(o-n)+t*(n-r)}function f(e,t,r,i,n,o){o*=i;var a,s=0;if(n)for(a=0;t>a;++a)s=s*r+e[o+a];else for(a=t-1;a>=0;--a)s=s*r+e[o+a];return s}function v(e,t,r,i,n,o,a,s){a*=n;var l;if(o)for(l=0;t>l;++l)e[a+l]=0|s/i,s-=e[a+l]*i,i/=r;else for(l=t-1;l>=0;--l)e[a+l]=0|s/i,s-=e[a+l]*i,i/=r}var y=function(n){if(!t(n)||!t(n.buffer))throw new r("description.buffer is required.");if(!t(n.width))throw new r("description.width is required.");if(!t(n.height))throw new r("description.height is required.");this._buffer=n.buffer,this._width=n.width,this._height=n.height,this._childTileMask=e(n.childTileMask,15);var o=i.DEFAULT_STRUCTURE,a=n.structure;t(a)?a!==o&&(a.heightScale=e(a.heightScale,o.heightScale),a.heightOffset=e(a.heightOffset,o.heightOffset),a.elementsPerHeight=e(a.elementsPerHeight,o.elementsPerHeight),a.stride=e(a.stride,o.stride),a.elementMultiplier=e(a.elementMultiplier,o.elementMultiplier),a.isBigEndian=e(a.isBigEndian,o.isBigEndian)):a=o,this._structure=a,this._createdByUpsampling=e(n.createdByUpsampling,!1),this._waterMask=n.waterMask},g=new o("createVerticesFromHeightmap");return y.prototype.createMesh=function(e,i,n,o){if(!t(e))throw new r("tilingScheme is required.");if(!t(i))throw new r("x is required.");if(!t(n))throw new r("y is required.");if(!t(o))throw new r("level is required.");var c=e.getEllipsoid(),h=e.tileXYToNativeExtent(i,n,o),d=e.tileXYToExtent(i,n,o),m=c.cartographicToCartesian(d.getCenter()),p=this._structure,f=l.getEstimatedLevelZeroGeometricErrorForAHeightmap(c,this._width,e.getNumberOfXTilesAtLevel(0)),v=f/(1<<o),y=g.scheduleTask({heightmap:this._buffer,structure:p,width:this._width,height:this._height,nativeExtent:h,extent:d,relativeToCenter:m,ellipsoid:c,skirtHeight:Math.min(4*v,1e3),isGeographic:e instanceof a});return t(y)?u(y,function(e){return new s(m,new Float32Array(e.vertices),l.getRegularGridIndices(e.gridWidth,e.gridHeight),e.minimumHeight,e.maximumHeight,e.boundingSphere3D,e.occludeePointInScaledSpace)}):void 0},y.prototype.interpolateHeight=function(e,t,r){var i,n=this._width,o=this._height,a=this._structure,s=a.stride;if(s>1){var l=a.elementsPerHeight,u=a.elementMultiplier,c=a.isBigEndian;i=m(this._buffer,l,u,s,c,e,n,o,t,r)}else i=d(this._buffer,e,n,o,t,r);return i*a.heightScale+a.heightOffset},y.prototype.upsample=function(e,i,n,o,a,s,l){if(!t(e))throw new r("tilingScheme is required.");if(!t(i))throw new r("thisX is required.");if(!t(n))throw new r("thisY is required.");if(!t(o))throw new r("thisLevel is required.");if(!t(a))throw new r("descendantX is required.");if(!t(s))throw new r("descendantY is required.");if(!t(l))throw new r("descendantLevel is required.");var u=l-o;if(u>1)throw new r("Upsampling through more than one level at a time is not currently supported.");var d;return d=1===this._width%2&&1===this._height%2?c(this,e,i,n,o,a,s,l):h(this,e,i,n,o,a,s,l)},y.prototype.isChildAvailable=function(e,i,n,o){if(!t(e))throw new r("thisX is required.");if(!t(i))throw new r("thisY is required.");if(!t(n))throw new r("childX is required.");if(!t(o))throw new r("childY is required.");var a=2;return n!==2*e&&++a,o!==2*i&&(a-=2),0!==(this._childTileMask&1<<a)},y.prototype.getWaterMask=function(){return this._waterMask},y.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling},y}),r("Scene/ArcGisImageServerTerrainProvider",["../Core/defaultValue","../Core/defined","../Core/loadImage","../Core/getImagePixels","../Core/throttleRequestByServer","../Core/writeTextToCanvas","../Core/DeveloperError","../Core/Math","../Core/Ellipsoid","../Core/Event","./Credit","./TerrainProvider","./GeographicTilingScheme","./HeightmapTerrainData","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p){"use strict";var f=function(r){if(!t(r)||!t(r.url))throw new a("description.url is required.");this._url=r.url,this._token=r.token,this._tilingScheme=r.tilingScheme,t(this._tilingScheme)||(this._tilingScheme=new d({ellipsoid:e(r.ellipsoid,l.WGS84)})),this._heightmapWidth=65,this._levelZeroMaximumGeometricError=h.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.getEllipsoid(),this._heightmapWidth,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._proxy=r.proxy,this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0},this._errorEvent=new u;var i=r.credit;"string"==typeof i&&(i=new c(i)),this._credit=i};return f.prototype.requestTileGeometry=function(e,o,a){var l=this._tilingScheme.tileXYToExtent(e,o,a),u=(l.east-l.west)/(this._heightmapWidth-1),c=(l.north-l.south)/(this._heightmapWidth-1);l.west-=.5*u,l.east+=.5*u,l.south-=.5*c,l.north+=.5*c;var h=s.toDegrees(l.west)+"%2C"+s.toDegrees(l.south)+"%2C"+s.toDegrees(l.east)+"%2C"+s.toDegrees(l.north),d=this._url+"/exportImage?interpolation=RSP_BilinearInterpolation&format=tiff&f=image&size="+this._heightmapWidth+"%2C"+this._heightmapWidth+"&bboxSR=4326&imageSR=4326&bbox="+h;this._token&&(d+="&token="+this._token);var f=this._proxy;t(f)&&(d=f.getURL(d));var v=n(d,r);if(!t(v))return void 0;var y=this;return p(v,function(e){return new m({buffer:i(e),width:y._heightmapWidth,height:y._heightmapWidth,childTileMask:15,structure:y._terrainDataStructure})})},f.prototype.getErrorEvent=function(){return this._errorEvent},f.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},f.prototype.getCredit=function(){return this._credit},f.prototype.getTilingScheme=function(){return this._tilingScheme},f.prototype.hasWaterMask=function(){return!1},f.prototype.isReady=function(){return!0},f}),r("Scene/DiscardMissingTileImagePolicy",["../Core/defaultValue","../Core/defined","../Core/loadImageViaBlob","../Core/getImagePixels","../Core/DeveloperError","../ThirdParty/when"],function(e,t,r,i,n,o){"use strict";var a=function(a){function s(e){t(e.blob)&&(u._missingImageByteLength=e.blob.size);var r=i(e);if(a.disableCheckIfAllPixelsAreTransparent){for(var n=!0,o=e.width,s=a.pixelsToCheck,l=0,c=s.length;n&&c>l;++l){var h=s[l],d=4*h.x+h.y*o,m=r[d+3];m>0&&(n=!1)}n&&(r=void 0)}u._missingImagePixels=r,u._isReady=!0}function l(){u._missingImagePixels=void 0,u._isReady=!0}if(a=e(a,{}),!t(a.missingImageUrl))throw new n("description.missingImageUrl is required.");if(!t(a.pixelsToCheck))throw new n("description.pixelsToCheck is required.");this._pixelsToCheck=a.pixelsToCheck,this._missingImagePixels=void 0,this._missingImageByteLength=void 0,this._isReady=!1;var u=this;o(r(a.missingImageUrl),s,l)};return a.prototype.isReady=function(){return this._isReady},a.prototype.shouldDiscardImage=function(e){if(!this._isReady)throw new n("shouldDiscardImage must not be called before the discard policy is ready.");var r=this._pixelsToCheck,o=this._missingImagePixels;if(!t(o))return!1;if(t(e.blob)&&e.blob.size!==this._missingImageByteLength)return!1;for(var a=i(e),s=e.width,l=0,u=r.length;u>l;++l)for(var c=r[l],h=4*c.x+c.y*s,d=0;4>d;++d){var m=h+d;if(a[m]!==o[m])return!1}return!0},a}),r("Scene/ImageryProvider",["../Core/defined","../Core/loadImage","../Core/loadImageViaBlob","../Core/DeveloperError","../Core/throttleRequestByServer"],function(e,t,r,i,n){"use strict";var o=function(){throw this.defaultAlpha=void 0,this.defaultBrightness=void 0,this.defaultContrast=void 0,this.defaultHue=void 0,this.defaultSaturation=void 0,this.defaultGamma=void 0,new i("This type should not be instantiated directly.")};return o.prototype.isReady=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getExtent=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getTileWidth=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getTileHeight=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getMaximumLevel=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getMinimumLevel=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getTilingScheme=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getTileDiscardPolicy=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getErrorEvent=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getCredit=function(){throw new i("This type should not be instantiated directly.")},o.prototype.getProxy=function(){throw new i("This type should not be instantiated directly.")},o.prototype.requestImage=function(){throw new i("This type should not be instantiated directly.")},o.loadImage=function(i,o){return e(i.getTileDiscardPolicy())?n(o,r):n(o,t)},o}),r("Scene/WebMercatorTilingScheme",["../Core/defaultValue","../Core/defined","../Core/Ellipsoid","../Core/Extent","../Core/Cartesian2","../Core/WebMercatorProjection","./TilingScheme"],function(e,t,r,i,n,o,a){"use strict";var s=function(a){if(a=e(a,{}),this._ellipsoid=e(a.ellipsoid,r.WGS84),this._numberOfLevelZeroTilesX=e(a.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=e(a.numberOfLevelZeroTilesY,1),this._projection=new o(this._ellipsoid),t(a.extentSouthwestInMeters)&&t(a.extentNortheastInMeters))this._extentSouthwestInMeters=a.extentSouthwestInMeters,this._extentNortheastInMeters=a.extentNortheastInMeters;else{var s=this._ellipsoid.getMaximumRadius()*Math.PI;this._extentSouthwestInMeters=new n(-s,-s),this._extentNortheastInMeters=new n(s,s)}var l=this._projection.unproject(this._extentSouthwestInMeters),u=this._projection.unproject(this._extentNortheastInMeters);this._extent=new i(l.longitude,l.latitude,u.longitude,u.latitude)};return s.prototype.getEllipsoid=function(){return this._ellipsoid},s.prototype.getExtent=function(){return this._extent},s.prototype.getProjection=function(){return this._projection},s.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},s.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},s.prototype.createLevelZeroTiles=function(){return a.createRectangleOfLevelZeroTiles(this,this._numberOfLevelZeroTilesX,this._numberOfLevelZeroTilesY)},s.prototype.extentToNativeExtent=function(e,r){var n=this._projection,o=n.project(e.getSouthwest()),a=n.project(e.getNortheast());return t(r)?(r.west=o.x,r.south=o.y,r.east=a.x,r.north=a.y,r):new i(o.x,o.y,a.x,a.y)},s.prototype.tileXYToNativeExtent=function(e,r,n,o){var a=this.getNumberOfXTilesAtLevel(n),s=this.getNumberOfYTilesAtLevel(n),l=(this._extentNortheastInMeters.x-this._extentSouthwestInMeters.x)/a,u=this._extentSouthwestInMeters.x+e*l,c=this._extentSouthwestInMeters.x+(e+1)*l,h=(this._extentNortheastInMeters.y-this._extentSouthwestInMeters.y)/s,d=this._extentNortheastInMeters.y-r*h,m=this._extentNortheastInMeters.y-(r+1)*h;return t(o)?(o.west=u,o.south=m,o.east=c,o.north=d,o):new i(u,m,c,d)},s.prototype.tileXYToExtent=function(e,t,r,i){var o=this.tileXYToNativeExtent(e,t,r,i),a=this._projection,s=a.unproject(new n(o.west,o.south)),l=a.unproject(new n(o.east,o.north));return o.west=s.longitude,o.south=s.latitude,o.east=l.longitude,o.north=l.latitude,o},s.prototype.positionToTileXY=function(e,r,i){var o=this._extent;if(e.latitude>o.north||e.latitude<o.south||e.longitude<o.west||e.longitude>o.east)return void 0;var a=this.getNumberOfXTilesAtLevel(r),s=this.getNumberOfYTilesAtLevel(r),l=this._extentNortheastInMeters.x-this._extentSouthwestInMeters.x,u=l/a,c=this._extentNortheastInMeters.y-this._extentSouthwestInMeters.y,h=c/s,d=this._projection,m=d.project(e),p=m.x-this._extentSouthwestInMeters.x,f=this._extentNortheastInMeters.y-m.y,v=0|p/u;v>=a&&(v=a-1);var y=0|f/h;return y>=s&&(y=s-1),t(i)?(i.x=v,i.y=y,i):new n(v,y)},s}),r("Scene/ArcGisMapServerImageryProvider",["../Core/defaultValue","../Core/defined","../Core/jsonp","../Core/Cartesian2","../Core/DeveloperError","../Core/Event","./DiscardMissingTileImagePolicy","./GeographicTilingScheme","./ImageryProvider","./TileProviderError","./WebMercatorTilingScheme","./Credit","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function m(e,r,i,n){var o;if(e._useTiles)o=e._url+"/tile/"+n+"/"+i+"/"+r;else{var a=e._tilingScheme.tileXYToNativeExtent(r,i,n),s=a.west+"%2C"+a.south+"%2C"+a.east+"%2C"+a.north;o=e._url+"/export?",o+="bbox="+s,o+="&bboxSR=4326&size=256%2C256&imageSR=4326&format=png&transparent=true&f=image"}var l=e._proxy;return t(l)&&(o=l.getURL(o)),o}var p=function(l){function p(e){var r=e.tileInfo;if(g._useTiles&&t(r)){if(g._tileWidth=r.rows,g._tileHeight=r.cols,102100===r.spatialReference.wkid)g._tilingScheme=new c;else{if(4326!==e.tileInfo.spatialReference.wkid){var n="Tile spatial reference WKID "+e.tileInfo.spatialReference.wkid+" is not supported.";return y=u.handleError(y,g,g._errorEvent,n,void 0,void 0,void 0,v),void 0}g._tilingScheme=new s}g._maximumLevel=e.tileInfo.lods.length-1,t(g._tileDiscardPolicy)||(g._tileDiscardPolicy=new a({missingImageUrl:m(g,0,0,g._maximumLevel),pixelsToCheck:[new i(0,0),new i(200,20),new i(20,200),new i(80,110),new i(160,130)],disableCheckIfAllPixelsAreTransparent:!0})),g._useTiles=!0}else g._tileWidth=256,g._tileHeight=256,g._tilingScheme=new s,g._useTiles=!1;t(e.copyrightText)&&e.copyrightText.length>0&&(g._credit=new h(e.copyrightText)),g._ready=!0,u.handleSuccess(y)}function f(){var e="An error occurred while accessing "+g._url+".";y=u.handleError(y,g,g._errorEvent,e,void 0,void 0,void 0,v)}function v(){var e=r(g._url,{parameters:{f:"json"},proxy:g._proxy});d(e,p,f)}if(l=e(l,{}),!t(l.url))throw new n("description.url is required.");this._url=l.url,this._tileDiscardPolicy=l.tileDiscardPolicy,this._proxy=l.proxy,this._tileWidth=void 0,this._tileHeight=void 0,this._maximumLevel=void 0,this._tilingScheme=void 0,this._credit=void 0,this._useTiles=e(l.usePreCachedTilesIfAvailable,!0),this._errorEvent=new o,this._ready=!1;var y,g=this;v()};return p.prototype.isUsingPrecachedTiles=function(){return this._useTiles},p.prototype.getUrl=function(){return this._url},p.prototype.getProxy=function(){return this._proxy},p.prototype.getTileWidth=function(){if(!this._ready)throw new n("getTileWidth must not be called before the imagery provider is ready.");return this._tileWidth},p.prototype.getTileHeight=function(){if(!this._ready)throw new n("getTileHeight must not be called before the imagery provider is ready.");return this._tileHeight},p.prototype.getMaximumLevel=function(){if(!this._ready)throw new n("getMaximumLevel must not be called before the imagery provider is ready.");return this._maximumLevel},p.prototype.getMinimumLevel=function(){if(!this._ready)throw new n("getMinimumLevel must not be called before the imagery provider is ready.");return 0},p.prototype.getTilingScheme=function(){if(!this._ready)throw new n("getTilingScheme must not be called before the imagery provider is ready.");return this._tilingScheme},p.prototype.getExtent=function(){if(!this._ready)throw new n("getExtent must not be called before the imagery provider is ready.");return this._tilingScheme.getExtent()},p.prototype.getTileDiscardPolicy=function(){if(!this._ready)throw new n("getTileDiscardPolicy must not be called before the imagery provider is ready.");return this._tileDiscardPolicy},p.prototype.getErrorEvent=function(){return this._errorEvent},p.prototype.isReady=function(){return this._ready},p.prototype.requestImage=function(e,t,r){if(!this._ready)throw new n("requestImage must not be called before the imagery provider is ready.");var i=m(this,e,t,r);return l.loadImage(this,i)},p.prototype.getCredit=function(){return this._credit},p}),r("Scene/BingMapsStyle",["../Core/Enumeration"],function(e){"use strict";var t={AERIAL:new e(0,"AERIAL",{imagerySetName:"Aerial"}),AERIAL_WITH_LABELS:new e(1,"AERIAL_WITH_LABELS",{imagerySetName:"AerialWithLabels"}),ROAD:new e(2,"ROAD",{imagerySetName:"Road"}),ORDNANCE_SURVEY:new e(3,"ORDNANCE_SURVEY",{imagerySetName:"OrdnanceSurvey"}),COLLINS_BART:new e(4,"COLLINS_BART",{imagerySetName:"CollinsBart"})};return t}),r("Scene/BingMapsImageryProvider",["../Core/defaultValue","../Core/defined","../Core/jsonp","../Core/BingMapsApi","../Core/Cartesian2","../Core/DeveloperError","../Core/Event","./BingMapsStyle","./DiscardMissingTileImagePolicy","./ImageryProvider","./TileProviderError","./WebMercatorTilingScheme","./Credit","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m){"use strict";function p(e,r,i,n){var o=e._imageUrlTemplate,a=f.tileXYToQuadKey(r,i,n);o=o.replace("{quadkey}",a);var s=e._imageUrlSubdomains,l=(r+i+n)%s.length;o=o.replace("{subdomain}",s[l]);var u=e._proxy;return t(u)&&(o=u.getURL(o)),o}var f=function v(u){function f(e){var r=e.resourceSets[0].resources[0];C._tileWidth=r.imageWidth,C._tileHeight=r.imageHeight,C._maximumLevel=r.zoomMax-1,C._imageUrlSubdomains=r.imageUrlSubdomains,C._imageUrlTemplate=r.imageUrl.replace("{culture}",""),t(C._tileDiscardPolicy)||(C._tileDiscardPolicy=new l({missingImageUrl:p(C,0,0,C._maximumLevel),pixelsToCheck:[new n(0,0),new n(120,140),new n(130,160),new n(200,50),new n(200,200)],disableCheckIfAllPixelsAreTransparent:!0})),C._ready=!0,c.handleSuccess(_)}function y(){var e="An error occurred while accessing "+w+".";_=c.handleError(_,C,C._errorEvent,e,void 0,void 0,void 0,g)}function g(){var e=r(w,{callbackParameterName:"jsonp",proxy:C._proxy});m(e,f,y)}if(u=e(u,{}),!t(u.url))throw new o("description.url is required.");this._key=i.getKey(u.key),this._url=u.url,this._mapStyle=e(u.mapStyle,s.AERIAL),this._tileDiscardPolicy=u.tileDiscardPolicy,this._proxy=u.proxy,this._credit=new d("Bing Imagery",v._logoData,"http://www.bing.com"),this.defaultGamma=1,(this._mapStyle===s.AERIAL||this._mapStyle===s.AERIAL_WITH_LABELS)&&(this.defaultGamma=1.3),this._tilingScheme=new h({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:2}),this._tileWidth=void 0,this._tileHeight=void 0,this._maximumLevel=void 0,this._imageUrlTemplate=void 0,this._imageUrlSubdomains=void 0,this._errorEvent=new a,this._ready=!1;
var _,w=this._url+"/REST/v1/Imagery/Metadata/"+this._mapStyle.imagerySetName+"?key="+this._key,C=this;g()};return f.prototype.getUrl=function(){return this._url},f.prototype.getProxy=function(){return this._proxy},f.prototype.getKey=function(){return this._key},f.prototype.getMapStyle=function(){return this._mapStyle},f.prototype.getTileWidth=function(){if(!this._ready)throw new o("getTileWidth must not be called before the imagery provider is ready.");return this._tileWidth},f.prototype.getTileHeight=function(){if(!this._ready)throw new o("getTileHeight must not be called before the imagery provider is ready.");return this._tileHeight},f.prototype.getMaximumLevel=function(){if(!this._ready)throw new o("getMaximumLevel must not be called before the imagery provider is ready.");return this._maximumLevel},f.prototype.getMinimumLevel=function(){if(!this._ready)throw new o("getMinimumLevel must not be called before the imagery provider is ready.");return 0},f.prototype.getTilingScheme=function(){if(!this._ready)throw new o("getTilingScheme must not be called before the imagery provider is ready.");return this._tilingScheme},f.prototype.getExtent=function(){if(!this._ready)throw new o("getExtent must not be called before the imagery provider is ready.");return this._tilingScheme.getExtent()},f.prototype.getTileDiscardPolicy=function(){if(!this._ready)throw new o("getTileDiscardPolicy must not be called before the imagery provider is ready.");return this._tileDiscardPolicy},f.prototype.getErrorEvent=function(){return this._errorEvent},f.prototype.isReady=function(){return this._ready},f.prototype.requestImage=function(e,t,r){if(!this._ready)throw new o("requestImage must not be called before the imagery provider is ready.");var i=p(this,e,t,r);return u.loadImage(this,i)},f.prototype.getCredit=function(){return this._credit},f._logoData="data:image/png;base64,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",f.tileXYToQuadKey=function(e,t,r){for(var i="",n=r;n>=0;--n){var o=1<<n,a=0;0!==(e&o)&&(a|=1),0!==(t&o)&&(a|=2),i+=a}return i},f.quadKeyToTileXY=function(e){for(var t=0,r=0,i=e.length-1,n=i;n>=0;--n){var o=1<<n,a=+e[i-n];0!==(1&a)&&(t|=o),0!==(2&a)&&(r|=o)}return{x:t,y:r,level:i}},f}),r("Scene/CameraController",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/DeveloperError","../Core/Ellipsoid","../Core/GeographicProjection","../Core/IntersectionTests","../Core/Math","../Core/Matrix3","../Core/Matrix4","../Core/Quaternion","../Core/Ray","../Core/Transforms","./SceneMode","../ThirdParty/Tween"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g){"use strict";function _(e,t){var r=e._maxCoord.x*e.maximumTranslateFactor;t.x>r&&(t.x=r),t.x<-r&&(t.x=-r);var i=e._maxCoord.y*e.maximumTranslateFactor;t.y>i&&(t.y=i),t.y<-i&&(t.y=-i)}function w(e,r){var i,o=e._camera;if(t(r)){var a=n.clone(o.positionWC,K),s=n.clone(o.upWC,Q),l=n.clone(o.rightWC,$),u=n.clone(o.directionWC,et);i=o.transform,o.transform=m.multiplyTransformation(r,i,tt);var c=o.inverseTransform;m.multiplyByPoint(c,a,o.position),m.multiplyByPointAsVector(c,s,o.up),m.multiplyByPointAsVector(c,l,o.right),m.multiplyByPointAsVector(c,u,o.direction)}return i}function C(e,r){if(t(r)){var i=e._camera,o=n.clone(i.positionWC,rt),a=n.clone(i.upWC,it),s=n.clone(i.rightWC,nt),l=n.clone(i.directionWC,ot);i.transform=r,r=i.inverseTransform,m.multiplyByPoint(r,o,i.position),m.multiplyByPointAsVector(r,a,i.up),m.multiplyByPointAsVector(r,s,i.right),m.multiplyByPointAsVector(r,l,i.direction)}}function x(e,r,i){var o=e._camera,a=w(e,i),s=o.position,l=n.normalize(s,lt);if(t(e.constrainedAxis)){var u=n.equalsEpsilon(l,e.constrainedAxis,h.EPSILON2),c=n.equalsEpsilon(l,n.negate(e.constrainedAxis,ht),h.EPSILON2);if(u||c)(u&&0>r||c&&r>0)&&e.rotate(o.right,r);else{var d=n.normalize(e.constrainedAxis,ut),m=n.dot(l,d),p=Math.acos(m);r>0&&r>p&&(r=p),m=n.dot(l,n.negate(d,ht)),p=Math.acos(m),0>r&&-r>p&&(r=-p);var f=n.cross(d,l,ct);e.rotate(f,r)}}else e.rotate(o.right,r);C(e,a)}function S(e,r,i){t(e.constrainedAxis)?e.rotate(e.constrainedAxis,r,i):e.rotate(e._camera.up,r,i)}function E(e,r){var i=e._camera.frustum;if(!(t(i.left)&&t(i.right)&&t(i.top)&&t(i.bottom)))throw new s("The camera frustum is expected to be orthographic for 2D camera control.");r=.5*r;var n=i.right-r,o=i.left+r,a=e._maxCoord.x*e.maximumZoomFactor;n>a&&(n=a,o=-a);var l=i.top/i.right;i.right=n,i.left=o,i.top=i.right*l,i.bottom=-i.top}function b(e,t){var r=e._camera;e.move(r.direction,t)}function T(e,t){var r=e._camera,o=.5*-t.height,a=-o,s=r.frustum;if(a>o){var l=s.top/s.right;s.right=a,s.left=o,s.top=s.right*l,s.bottom=-s.top}i.clone(e._projection.project(t),r.position),n.negate(n.UNIT_Z,r.direction),n.clone(n.UNIT_Y,r.up),n.clone(n.UNIT_X,r.right)}function A(e,t){var r=e._camera,i=e._projection;r.position=i.project(t),n.negate(n.UNIT_Z,r.direction),n.clone(n.UNIT_Y,r.up),n.clone(n.UNIT_X,r.right)}function D(e,t){var r=e._camera,i=e._projection.getEllipsoid();i.cartographicToCartesian(t,r.position),n.negate(r.position,r.direction),n.normalize(r.direction,r.direction),n.cross(r.direction,n.UNIT_Z,r.right),n.cross(r.right,r.direction,r.up),n.cross(r.direction,r.up,r.right)}function P(e){var t=e._camera;return Math.atan2(t.right.y,t.right.x)}function M(e){var t=e._camera,r=e._projection.getEllipsoid(),i=v.eastNorthUpToFixedFrame(t.position,r,dt),n=m.getRotation(i,mt);d.transpose(n,n);var o=d.multiplyByVector(n,t.right,pt);return Math.atan2(o.y,o.x)}function I(e,t){var r=P(e);t=r-t,e.look(n.UNIT_Z,t)}function O(e,t){var r=e._camera,i=n.normalize(r.position,ft),o=M(e);t=o-t,e.look(i,t)}function R(e){var t=e._camera;return h.PI_OVER_TWO-Math.acos(-t.direction.z)}function L(e){var t=e._camera,r=n.normalize(t.position,vt);return n.negate(r,r),h.PI_OVER_TWO-Math.acos(n.dot(t.direction,r))}function z(e,t,r,i,o){var a=e;o&&(a=St);var s=t.north,l=t.south,u=t.east,c=t.west;c>u&&(u+=h.TWO_PI);var d=yt;d.longitude=u,d.latitude=s;var m=r.cartographicToCartesian(d,gt);d.latitude=l;var p=r.cartographicToCartesian(d,Ct);d.longitude=c;var f=r.cartographicToCartesian(d,_t);d.latitude=s;var v=r.cartographicToCartesian(d,wt),y=n.subtract(m,f,xt);n.multiplyByScalar(y,.5,y),n.add(f,y,y),n.subtract(v,y,v),n.subtract(p,y,p),n.subtract(m,y,m),n.subtract(f,y,f);var g=r.geodeticSurfaceNormal(y,a.direction);n.negate(g,g),n.normalize(g,g);var _=n.cross(g,n.UNIT_Z,a.right);n.normalize(_,_);var w=n.cross(_,g,a.up),C=Math.max(Math.abs(n.dot(w,v)),Math.abs(n.dot(w,p)),Math.abs(n.dot(w,m)),Math.abs(n.dot(w,f))),x=Math.max(Math.abs(n.dot(_,v)),Math.abs(n.dot(_,p)),Math.abs(n.dot(_,m)),Math.abs(n.dot(_,f))),S=Math.tan(.5*e.frustum.fovy),E=e.frustum.aspectRatio*S,b=Math.max(x/E,C/S),T=n.magnitude(y)+b;return n.normalize(y,y),n.multiplyByScalar(y,T,i)}function N(e,r,i,o,a){var s=r.north,l=r.south,u=r.east,c=r.west,h=e.inverseTransform,d=Et;d.longitude=u,d.latitude=s;var p=i.project(d,bt);m.multiplyByPoint(e.transform,p,p),m.multiplyByPoint(h,p,p),d.longitude=c,d.latitude=l;var f=i.project(d,Tt);m.multiplyByPoint(e.transform,f,f),m.multiplyByPoint(h,f,f);var v=Math.tan(.5*e.frustum.fovy),y=e.frustum.aspectRatio*v;if(t(o)||(o=new n),o.x=.5*(p.x-f.x)+f.x,o.y=.5*(p.y-f.y)+f.y,o.z=.5*Math.max((p.x-f.x)/y,(p.y-f.y)/v),!a){var g=n.clone(n.UNIT_Z,e.direction);n.negate(g,g),n.clone(n.UNIT_X,e.right),n.clone(n.UNIT_Y,e.up)}return o}function B(e,r,i,o,a){var s=r.north,l=r.south,u=r.east,c=r.west,h=At;h.longitude=u,h.latitude=s;var d=i.project(h,Dt);h.longitude=c,h.latitude=l;var m,p,f=i.project(h,Pt),v=.5*Math.abs(d.x-f.x),y=.5*Math.abs(d.y-f.y),g=e.frustum.right/e.frustum.top,_=y*g;if(v>_?(m=v,p=m/g):(p=y,m=_),y=Math.max(2*m,2*p),t(o)||(o=new n),o.x=.5*(d.x-f.x)+f.x,o.y=.5*(d.y-f.y)+f.y,a)h=i.unproject(o,h),h.height=y,o=i.project(h,o);else{var w=e.frustum;w.right=m,w.left=-m,w.top=p,w.bottom=-p;var C=n.clone(n.UNIT_Z,e.direction);n.negate(C,C),n.clone(n.UNIT_X,e.right),n.clone(n.UNIT_Y,e.up)}return o}function F(t,r,i,n){i=e(i,l.WGS84);var o=t.getPickRay(r,Mt),a=c.rayEllipsoid(o,i);return a?o.getPoint(a.start,n):void 0}function V(e,t,r,i){var n=e.getPickRay(t,It),o=n.origin;o.z=0;var a=r.unproject(o);return a.latitude<-h.PI_OVER_TWO||a.latitude>h.PI_OVER_TWO||a.longitude<-Math.PI||a.longitude>Math.PI?void 0:r.getEllipsoid().cartographicToCartesian(a,i)}function k(e,t,r,i){var o=e.getPickRay(t,Ot),a=-o.origin.x/o.direction.x;o.getPoint(a,i);var s=r.unproject(new n(i.y,i.z,0));return s.latitude<-h.PI_OVER_TWO||s.latitude>h.PI_OVER_TWO||s.longitude<-Math.PI||s.longitude>Math.PI?void 0:r.getEllipsoid().cartographicToCartesian(s,i)}function U(e,t,r){var i=e._context._canvas.clientWidth,o=e._context._canvas.clientHeight,a=Math.tan(.5*e.frustum.fovy),s=e.frustum.aspectRatio*a,l=e.frustum.near,u=2/i*t.x-1,c=2/o*(o-t.y)-1,h=e.positionWC;n.clone(h,r.origin);var d=n.multiplyByScalar(e.directionWC,l,Rt);n.add(h,d,d);var m=n.multiplyByScalar(e.rightWC,u*l*s,Lt),p=n.multiplyByScalar(e.upWC,c*l*a,zt),f=n.add(d,m,r.direction);return n.add(f,p,f),n.subtract(f,h,f),n.normalize(f,f),r}function W(e,t,r){var i=e._context._canvas.clientWidth,o=e._context._canvas.clientHeight,a=2/i*t.x-1;a*=.5*(e.frustum.right-e.frustum.left);var s=2/o*(o-t.y)-1;s*=.5*(e.frustum.top-e.frustum.bottom);var l=r.origin;return n.clone(e.position,l),l.x+=a,l.y+=s,n.clone(e.directionWC,r.direction),r}function q(e,t){var r=e._camera,i=r.position,o=i.x<-e._maxCoord.x||i.x>e._maxCoord.x,a=i.y<-e._maxCoord.y||i.y>e._maxCoord.y,s=o||a,l=r.frustum,u=l.top,c=l.bottom,d=l.right,m=l.left,p=e._frustum,f=d>e._frustum.right;if(s||f){var v=n.clone(i);v.x>e._maxCoord.x?v.x=e._maxCoord.x:v.x<-e._maxCoord.x&&(v.x=-e._maxCoord.x),v.y>e._maxCoord.y?v.y=e._maxCoord.y:v.y<-e._maxCoord.y&&(v.y=-e._maxCoord.y);var y=function(e){s&&(r.position=n.lerp(i,v,e.time)),f&&(r.frustum.top=h.lerp(u,p.top,e.time),r.frustum.bottom=h.lerp(c,p.bottom,e.time),r.frustum.right=h.lerp(d,p.right,e.time),r.frustum.left=h.lerp(m,p.left,e.time))};return{easingFunction:g.Easing.Exponential.Out,startValue:{time:0},stopValue:{time:1},duration:t,onUpdate:y}}return void 0}function G(e,t,r,i,o,a){var s=n.clone(t);r.y>i?s.y-=r.y-i:r.y<-i&&(s.y+=-i-r.y),r.z>o?s.z-=r.z-o:r.z<-o&&(s.z+=-o-r.z);var l=e._camera,u=function(e){var r=n.lerp(t,s,e.time);l.position=m.multiplyByPoint(l.inverseTransform,r,l.position)};return{easingFunction:g.Easing.Exponential.Out,startValue:{time:0},stopValue:{time:1},duration:a,onUpdate:u}}function H(e,t){var r=e._camera,i=r.position,o=r.direction,a=m.multiplyByPointAsVector(r.inverseTransform,n.UNIT_X,Nt),s=-n.dot(a,i)/n.dot(a,o),l=n.add(i,n.multiplyByScalar(o,s,Bt),Bt);l=m.multiplyByPoint(r.transform,l,l),i=m.multiplyByPoint(r.transform,r.position,Ft);var u=Math.tan(.5*e._camera.frustum.fovy),c=e._camera.frustum.aspectRatio*u,h=n.magnitude(n.subtract(i,l,Vt)),d=c*h,p=u*h,f=e._maxCoord.x,v=e._maxCoord.y,y=Math.max(d-f,f),g=Math.max(p-v,v);if(i.z<-y||i.z>y||i.y<-g||i.y>g){var _=l.y<-y||l.y>y,w=l.z<-g||l.z>g;if(_||w)return G(e,i,l,y,g,t)}return void 0}var j=function(e){if(!t(e))throw new s("camera is required.");this._camera=e,this._mode=y.SCENE3D,this._projection=new u,this.defaultMoveAmount=1e5,this.defaultLookAmount=Math.PI/60,this.defaultRotateAmount=Math.PI/3600,this.defaultZoomAmount=1e5,this.constrainedAxis=void 0,this.maximumTranslateFactor=1.5,this.maximumZoomFactor=2.5,this._maxCoord=new n,this._frustum=void 0},Y=new a(Math.PI,h.PI_OVER_TWO);j.prototype.update=function(e,r){var i=!1;e!==this._mode&&(this._mode=e,i=this._mode===y.SCENE2D);var n=r.projection;if(t(n)&&n!==this._projection&&(this._projection=n,this._maxCoord=n.project(Y,this._maxCoord)),i){var o=this._frustum=this._camera.frustum.clone();if(!(t(o.left)&&t(o.right)&&t(o.top)&&t(o.bottom)))throw new s("The camera frustum is expected to be orthographic for 2D camera control.");var a=2,l=o.top/o.right;o.right=this._maxCoord.x*a,o.left=-o.right,o.top=l*o.right,o.bottom=-o.top}};var X=new n;j.prototype.move=function(e,r){if(!t(e))throw new s("direction is required.");var i=this._camera.position;n.multiplyByScalar(e,r,X),n.add(i,X,i),this._mode===y.SCENE2D&&_(this,i)},j.prototype.moveForward=function(t){t=e(t,this.defaultMoveAmount),this.move(this._camera.direction,t)},j.prototype.moveBackward=function(t){t=e(t,this.defaultMoveAmount),this.move(this._camera.direction,-t)},j.prototype.moveUp=function(t){t=e(t,this.defaultMoveAmount),this.move(this._camera.up,t)},j.prototype.moveDown=function(t){t=e(t,this.defaultMoveAmount),this.move(this._camera.up,-t)},j.prototype.moveRight=function(t){t=e(t,this.defaultMoveAmount),this.move(this._camera.right,t)},j.prototype.moveLeft=function(t){t=e(t,this.defaultMoveAmount),this.move(this._camera.right,-t)},j.prototype.lookLeft=function(t){t=e(t,this.defaultLookAmount),this.look(this._camera.up,-t)},j.prototype.lookRight=function(t){t=e(t,this.defaultLookAmount),this.look(this._camera.up,t)},j.prototype.lookUp=function(t){t=e(t,this.defaultLookAmount),this.look(this._camera.right,-t)},j.prototype.lookDown=function(t){t=e(t,this.defaultLookAmount),this.look(this._camera.right,t)};var Z=new p,J=new d;j.prototype.look=function(r,i){if(!t(r))throw new s("axis is required.");var n=e(i,this.defaultLookAmount),o=p.fromAxisAngle(r,-n,Z),a=d.fromQuaternion(o,J),l=this._camera.direction,u=this._camera.up,c=this._camera.right;d.multiplyByVector(a,l,l),d.multiplyByVector(a,u,u),d.multiplyByVector(a,c,c)},j.prototype.twistLeft=function(t){t=e(t,this.defaultLookAmount),this.look(this._camera.direction,t)},j.prototype.twistRight=function(t){t=e(t,this.defaultLookAmount),this.look(this._camera.direction,-t)};var K=new n,Q=new n,$=new n,et=new n,tt=new m,rt=new n,it=new n,nt=new n,ot=new n,at=new p,st=new d;j.prototype.rotate=function(r,i,o){if(!t(r))throw new s("axis is required.");var a=this._camera,l=e(i,this.defaultRotateAmount),u=p.fromAxisAngle(r,-l,at),c=d.fromQuaternion(u,st),h=w(this,o);d.multiplyByVector(c,a.position,a.position),d.multiplyByVector(c,a.direction,a.direction),d.multiplyByVector(c,a.up,a.up),n.cross(a.direction,a.up,a.right),n.cross(a.right,a.direction,a.up),C(this,h)},j.prototype.rotateDown=function(t,r){t=e(t,this.defaultRotateAmount),x(this,t,r)},j.prototype.rotateUp=function(t,r){t=e(t,this.defaultRotateAmount),x(this,-t,r)};var lt=new n,ut=new n,ct=new n,ht=new n;j.prototype.rotateRight=function(t,r){t=e(t,this.defaultRotateAmount),S(this,-t,r)},j.prototype.rotateLeft=function(t,r){t=e(t,this.defaultRotateAmount),S(this,t,r)},j.prototype.zoomIn=function(t){t=e(t,this.defaultZoomAmount),this._mode===y.SCENE2D?E(this,t):b(this,t)},j.prototype.zoomOut=function(t){t=e(t,this.defaultZoomAmount),this._mode===y.SCENE2D?E(this,-t):b(this,-t)},j.prototype.getMagnitude=function(){var e=this._camera;return this._mode===y.SCENE3D?n.magnitude(e.position):this._mode===y.COLUMBUS_VIEW?Math.abs(e.position.z):this._mode===y.SCENE2D?Math.max(e.frustum.right-e.frustum.left,e.frustum.top-e.frustum.bottom):void 0},j.prototype.setPositionCartographic=function(e){if(!t(e))throw new s("cartographic is required.");this._mode===y.SCENE2D?T(this,e):this._mode===y.COLUMBUS_VIEW?A(this,e):this._mode===y.SCENE3D&&D(this,e)};var dt=new m,mt=new d,pt=new n,ft=new n,vt=new n;r(j.prototype,{heading:{get:function(){return this._mode===y.SCENE2D||this._mode===y.COLUMBUS_VIEW?P(this):this._mode===y.SCENE3D?M(this):void 0},set:function(e){if(!t(e))throw new s("angle is required.");this._mode===y.SCENE2D||this._mode===y.COLUMBUS_VIEW?I(this,e):this._mode===y.SCENE3D&&O(this,e)}},tilt:{get:function(){return this._mode===y.COLUMBUS_VIEW?R(this):this._mode===y.SCENE3D?L(this):void 0},set:function(e){if(!t(e))throw new s("angle is required.");if(this._mode===y.COLUMBUS_VIEW||this._mode===y.SCENE3D){var r=this._camera;e=h.clamp(e,0,h.PI_OVER_TWO),e-=this.tilt,this.look(r.right,e)}}}}),j.prototype.lookAt=function(e,r,i){if(!t(e))throw new s("eye is required");if(!t(r))throw new s("target is required");if(!t(i))throw new s("up is required");if(this._mode===y.SCENE2D)throw new s("lookAt is not supported in 2D mode because there is only one direction to look.");if(this._mode===y.MORPHING)throw new s("lookAt is not supported while morphing.");var o=this._camera;o.position=n.clone(e,o.position),o.direction=n.normalize(n.subtract(r,e,o.direction),o.direction),o.right=n.normalize(n.cross(o.direction,i,o.right),o.right),o.up=n.cross(o.right,o.direction,o.up)};var yt=new a,gt=new n,_t=new n,wt=new n,Ct=new n,xt=new n,St={direction:new n,right:new n,up:new n},Et=new a,bt=new n,Tt=new n,At=new a,Dt=new n,Pt=new n;j.prototype.getExtentCameraCoordinates=function(e,r){if(!t(e))throw new s("extent is required");return this._mode===y.SCENE3D?z(this._camera,e,this._projection.getEllipsoid(),r,!0):this._mode===y.COLUMBUS_VIEW?N(this._camera,e,this._projection,r,!0):this._mode===y.SCENE2D?B(this._camera,e,this._projection,r,!0):void 0},j.prototype.viewExtent=function(r,i){if(!t(r))throw new s("extent is required.");i=e(i,l.WGS84),this._mode===y.SCENE3D?z(this._camera,r,i,this._camera.position):this._mode===y.COLUMBUS_VIEW?N(this._camera,r,this._projection,this._camera.position):this._mode===y.SCENE2D&&B(this._camera,r,this._projection,this._camera.position)};var Mt=new f,It=new f,Ot=new f;j.prototype.pickEllipsoid=function(r,i,o){if(!t(r))throw new s("windowPosition is required.");return t(o)||(o=new n),i=e(i,l.WGS84),this._mode===y.SCENE3D?o=F(this,r,i,o):this._mode===y.SCENE2D?o=V(this,r,this._projection,o):this._mode===y.COLUMBUS_VIEW&&(o=k(this,r,this._projection,o)),o};var Rt=new n,Lt=new n,zt=new n;j.prototype.getPickRay=function(e,r){if(!t(e))throw new s("windowPosition is required.");t(r)||(r=new f);var i=this._camera,n=i.frustum;return t(n.aspectRatio)&&t(n.fovy)&&t(n.near)?U(i,e,r):W(i,e,r)};var Nt=new n,Bt=new n,Ft=new n,Vt=new n;return j.prototype.createCorrectPositionAnimation=function(e){if(!t(e))throw new s("duration is required.");return this._mode===y.SCENE2D?q(this,e):this._mode===y.COLUMBUS_VIEW?H(this,e):void 0},j}),r("Scene/CullingVolume",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Intersect"],function(e,t,r,i){"use strict";var n=function(t){this.planes=e(t,[])};return n.prototype.getVisibility=function(e){if(!t(e))throw new r("boundingVolume is required.");for(var n=this.planes,o=!1,a=0,s=n.length;s>a;++a){var l=e.intersect(n[a]);if(l===i.OUTSIDE)return i.OUTSIDE;l===i.INTERSECTING&&(o=!0)}return o?i.INTERSECTING:i.INSIDE},n}),r("Scene/PerspectiveOffCenterFrustum",["../Core/DeveloperError","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Matrix4","../Scene/CullingVolume"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(e){var t=e.top,r=e.bottom,i=e.right,n=e.left,o=e.near,a=e.far;(t!==e._top||r!==e._bottom||n!==e._left||i!==e._right||o!==e._near||a!==e._far)&&(e._left=n,e._right=i,e._top=t,e._bottom=r,e._near=o,e._far=a,e._perspectiveMatrix=s.computePerspectiveOffCenter(n,i,r,t,o,a,e._perspectiveMatrix),e._infinitePerspective=s.computeInfinitePerspectiveOffCenter(n,i,r,t,o,e._infinitePerspective))}var c=function(){this.left=void 0,this._left=void 0,this.right=void 0,this._right=void 0,this.top=void 0,this._top=void 0,this.bottom=void 0,this._bottom=void 0,this.near=1,this._near=this.near,this.far=5e8,this._far=this.far,this._cullingVolume=new l,this._perspectiveMatrix=void 0,this._infinitePerspective=void 0};i(c.prototype,{projectionMatrix:{get:function(){return u(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return u(this),this._infinitePerspective}}});var h=new o,d=new o,m=new o,p=new o;return c.prototype.computeCullingVolume=function(e,t,i){var n=this._cullingVolume.planes,s=this.top,l=this.bottom,u=this.right,c=this.left,f=this.near,v=this.far,y=o.cross(t,i,h),g=d;o.multiplyByScalar(t,f,g),o.add(e,g,g);var _=m;o.multiplyByScalar(t,v,_),o.add(e,_,_);var w=p;o.multiplyByScalar(y,c,w),o.add(g,w,w),o.subtract(w,e,w),o.normalize(w,w),o.cross(w,i,w);var C=n[0];return r(C)||(C=n[0]=new a),C.x=w.x,C.y=w.y,C.z=w.z,C.w=-o.dot(w,e),o.multiplyByScalar(y,u,w),o.add(g,w,w),o.subtract(w,e,w),o.normalize(w,w),o.cross(i,w,w),C=n[1],r(C)||(C=n[1]=new a),C.x=w.x,C.y=w.y,C.z=w.z,C.w=-o.dot(w,e),o.multiplyByScalar(i,l,w),o.add(g,w,w),o.subtract(w,e,w),o.normalize(w,w),o.cross(y,w,w),C=n[2],r(C)||(C=n[2]=new a),C.x=w.x,C.y=w.y,C.z=w.z,C.w=-o.dot(w,e),o.multiplyByScalar(i,s,w),o.add(g,w,w),o.subtract(w,e,w),o.normalize(w,w),o.cross(w,y,w),C=n[3],r(C)||(C=n[3]=new a),C.x=w.x,C.y=w.y,C.z=w.z,C.w=-o.dot(w,e),C=n[4],r(C)||(C=n[4]=new a),C.x=t.x,C.y=t.y,C.z=t.z,C.w=-o.dot(t,g),o.negate(t,w),C=n[5],r(C)||(C=n[5]=new a),C.x=w.x,C.y=w.y,C.z=w.z,C.w=-o.dot(w,_),this._cullingVolume},c.prototype.getPixelSize=function(e,i,o){u(this);var a=e.x,s=e.y;i=t(i,this.near);var l=1/this.near,c=this.top*l,h=2*i*c/s;c=this.right*l;var d=2*i*c/a;return r(o)?(o.x=d,o.y=h,o):new n(d,h)},c.prototype.clone=function(e){return r(e)||(e=new c),e.right=this.right,e.left=this.left,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},c.prototype.equals=function(e){return r(e)&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},c}),r("Scene/PerspectiveFrustum",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Scene/PerspectiveOffCenterFrustum"],function(e,t,r,i){"use strict";function n(e){var t=e._offCenterFrustum;(e.fovy!==e._fovy||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far)&&(e._fovy=e.fovy,e._aspectRatio=e.aspectRatio,e._near=e.near,e._far=e.far,t.top=e.near*Math.tan(.5*e.fovy),t.bottom=-t.top,t.right=e.aspectRatio*t.top,t.left=-t.right,t.near=e.near,t.far=e.far)}var o=function(){this._offCenterFrustum=new i,this.fovy=void 0,this._fovy=void 0,this.aspectRatio=void 0,this._aspectRatio=void 0,this.near=1,this._near=this.near,this.far=5e8,this._far=this.far};return t(o.prototype,{projectionMatrix:{get:function(){return n(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return n(this),this._offCenterFrustum.infiniteProjectionMatrix}}}),o.prototype.computeCullingVolume=function(e,t,r){return n(this),this._offCenterFrustum.computeCullingVolume(e,t,r)},o.prototype.getPixelSize=function(e,t,r){return n(this),this._offCenterFrustum.getPixelSize(e,t,r)},o.prototype.clone=function(t){return e(t)||(t=new o),t.fovy=this.fovy,t.aspectRatio=this.aspectRatio,t.near=this.near,t.far=this.far,t._fovy=void 0,t._aspectRatio=void 0,t._near=void 0,t._far=void 0,this._offCenterFrustum.clone(t._offCenterFrustum),t},o.prototype.equals=function(t){return e(t)?(n(this),n(t),this.fovy===t.fovy&&this.aspectRatio===t.aspectRatio&&this.near===t.near&&this.far===t.far&&this._offCenterFrustum.equals(t._offCenterFrustum)):!1},o}),r("Scene/Camera",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Math","../Core/Ellipsoid","../Core/Cartesian3","../Core/Cartesian4","../Core/Matrix4","./CameraController","./PerspectiveFrustum"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e){var t=e._right,r=e._up,i=e._direction,n=e._position,a=e._viewMatrix;a[0]=t.x,a[1]=r.x,a[2]=-i.x,a[3]=0,a[4]=t.y,a[5]=r.y,a[6]=-i.y,a[7]=0,a[8]=t.z,a[9]=r.z,a[10]=-i.z,a[11]=0,a[12]=-o.dot(t,n),a[13]=-o.dot(r,n),a[14]=o.dot(i,n),a[15]=1,s.multiply(a,e._invTransform,e._viewMatrix),s.inverseTransformation(e._viewMatrix,e._invViewMatrix)}function h(e){var t=e._position,r=!o.equals(t,e.position);r&&(t=o.clone(e.position,e._position));var n=e._direction,a=!o.equals(n,e.direction);a&&(n=o.clone(e.direction,e._direction));var l=e._up,u=!o.equals(l,e.up);u&&(l=o.clone(e.up,e._up));var h=e._right,d=!o.equals(h,e.right);d&&(h=o.clone(e.right,e._right));var p=e._transform,f=!s.equals(p,e.transform);if(f&&(p=s.clone(e.transform,e._transform),s.inverseTransformation(e._transform,e._invTransform)),(r||f)&&(e._positionWC=s.multiplyByPoint(p,t,e._positionWC)),a||u||d){var v=o.dot(n,o.cross(l,h,m));if(Math.abs(1-v)>i.EPSILON2){n=o.normalize(n,e._direction),o.clone(n,e.direction);var y=1/o.magnitudeSquared(l),g=o.dot(l,n)*y,_=o.multiplyByScalar(n,g,m);l=o.normalize(o.subtract(l,_,e._up),e._up),o.clone(l,e.up),h=o.cross(n,l,e._right),o.clone(h,e.right)}}(a||f)&&(e._directionWC=s.multiplyByPointAsVector(p,n,e._directionWC)),(u||f)&&(e._upWC=s.multiplyByPointAsVector(p,l,e._upWC)),(d||f)&&(e._rightWC=s.multiplyByPointAsVector(p,h,e._rightWC)),(r||a||u||d||f)&&c(e)}var d=function(t){if(!e(t))throw new r("context is required.");this.transform=s.clone(s.IDENTITY),this._transform=s.clone(s.IDENTITY),this._invTransform=s.clone(s.IDENTITY);var a=n.WGS84.getMaximumRadius(),h=o.multiplyByScalar(o.normalize(new o(0,-2,1)),2.5*a);this.position=h,this._position=o.clone(h),this._positionWC=o.clone(h);var d=o.normalize(o.negate(h));this.direction=d,this._direction=o.clone(d),this._directionWC=o.clone(d);var m=o.normalize(o.cross(d,o.UNIT_Z)),p=o.cross(m,d);this.up=p,this._up=o.clone(p),this._upWC=o.clone(p),m=o.cross(d,p),this.right=m,this._right=o.clone(m),this._rightWC=o.clone(m),this.frustum=new u,this.frustum.fovy=i.toRadians(60),this.frustum.aspectRatio=t.getDrawingBufferWidth()/t.getDrawingBufferHeight(),this.controller=new l(this),this._viewMatrix=new s,this._invViewMatrix=new s,c(this),this._context=t},m=new o;return t(d.prototype,{inverseTransform:{get:function(){return h(this),this._invTransform}},viewMatrix:{get:function(){return h(this),this._viewMatrix}},inverseViewMatrix:{get:function(){return h(this),this._invViewMatrix}},positionWC:{get:function(){return h(this),this._positionWC}},directionWC:{get:function(){return h(this),this._directionWC}},upWC:{get:function(){return h(this),this._upWC}},rightWC:{get:function(){return h(this),this._rightWC}}}),d.prototype.clone=function(){var e=new d(this._context);return e.position=o.clone(this.position),e.direction=o.clone(this.direction),e.up=o.clone(this.up),e.right=o.clone(this.right),e.transform=s.clone(this.transform),e.frustum=this.frustum.clone(),e},d.prototype.worldToCameraCoordinates=function(t,i){if(!e(t))throw new r("cartesian is required.");return s.multiplyByVector(this.inverseTransform,t,i)},d.prototype.cameraToWorldCoordinates=function(t,i){if(!e(t))throw new r("cartesian is required.");return s.multiplyByVector(this.transform,t,i)},d}),r("Scene/CameraEventType",["../Core/Enumeration"],function(e){"use strict";var t={LEFT_DRAG:new e(0,"LEFT_DRAG"),RIGHT_DRAG:new e(1,"RIGHT_DRAG"),MIDDLE_DRAG:new e(2,"MIDDLE_DRAG"),WHEEL:new e(3,"WHEEL"),PINCH:new e(4,"PINCH")};return t}),r("Scene/CameraEventAggregator",["../Core/defined","../Core/defaultValue","../Core/DeveloperError","../Core/destroyObject","../Core/Math","../Core/ScreenSpaceEventHandler","../Core/ScreenSpaceEventType","../Core/Cartesian2","../Core/KeyboardEventModifier","./CameraEventType"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(t,r){var i=t.name;return e(r)&&(i+="+"+r.name),i}function h(e,t){s.clone(e.distance.startPosition,t.distance.startPosition),s.clone(e.distance.endPosition,t.distance.endPosition),s.clone(e.angleAndHeight.startPosition,t.angleAndHeight.startPosition),s.clone(e.angleAndHeight.endPosition,t.angleAndHeight.endPosition)}function d(t,r,i){var n=c(u.PINCH,r),o=t._update,l=t._isDown,d=t._pressTime,m=t._releaseTime;o[n]=!0,l[n]=!1;var p=t._movement[n];e(p)||(p=t._movement[n]={}),p.distance={startPosition:new s,endPosition:new s},p.angleAndHeight={startPosition:new s,endPosition:new s},p.prevAngle=0,t._eventHandler.setInputAction(function(){t._buttonsDown++,l[n]=!0,d[n]=new Date},a.PINCH_START,r),t._eventHandler.setInputAction(function(){t._buttonsDown=Math.max(t._buttonsDown-1,0),l[n]=!1,m[n]=new Date
},a.PINCH_END,r),t._eventHandler.setInputAction(function(e){if(l[n]){o[n]?(h(e,p),o[n]=!1,p.prevAngle=p.angleAndHeight.startPosition.x):(s.clone(e.distance.endPosition,p.distance.endPosition),s.clone(e.angleAndHeight.endPosition,p.angleAndHeight.endPosition));for(var t=p.angleAndHeight.endPosition.x,r=p.prevAngle,a=2*Math.PI;t>=r+Math.PI;)t-=a;for(;t<r-Math.PI;)t+=a;p.angleAndHeight.endPosition.x=-t*i.clientWidth/12,p.angleAndHeight.startPosition.x=-r*i.clientWidth/12}},a.PINCH_MOVE,r)}function m(t,r){var i=c(u.WHEEL,r),o=t._update;o[i]=!0;var l=t._movement[i];e(l)||(l=t._movement[i]={}),l.startPosition=new s,l.endPosition=new s,t._eventHandler.setInputAction(function(e){var t=15*n.toRadians(e);o[i]?(s.clone(s.ZERO,l.startPosition),l.endPosition.x=0,l.endPosition.y=t,o[i]=!1):l.endPosition.y=l.endPosition.y+t},a.WHEEL,r)}function p(t,r,i){var n=c(i,r),o=t._isDown,l=t._pressTime,h=t._releaseTime;o[n]=!1;var d=t._lastMovement[n];e(d)||(d=t._lastMovement[n]={startPosition:new s,endPosition:new s,valid:!1});var m,p;i===u.LEFT_DRAG?(m=a.LEFT_DOWN,p=a.LEFT_UP):i===u.RIGHT_DRAG?(m=a.RIGHT_DOWN,p=a.RIGHT_UP):i===u.MIDDLE_DRAG&&(m=a.MIDDLE_DOWN,p=a.MIDDLE_UP),t._eventHandler.setInputAction(function(){t._buttonsDown++,d.valid=!1,o[n]=!0,l[n]=new Date},m,r),t._eventHandler.setInputAction(function(){t._buttonsDown=Math.max(t._buttonsDown-1,0),o[n]=!1,h[n]=new Date},p,r)}function f(e,t){s.clone(e.startPosition,t.startPosition),s.clone(e.endPosition,t.endPosition)}function v(t,r){var i=t._update,n=t._movement,o=t._lastMovement,l=t._isDown;for(var h in u)if(u.hasOwnProperty(h)){var d=u[h];if(e(d.name)){var m=c(d,r);i[m]=!0,e(t._lastMovement[m])||(t._lastMovement[m]={startPosition:new s,endPosition:new s,valid:!1}),e(t._movement[m])||(t._movement[m]={startPosition:new s,endPosition:new s})}}t._eventHandler.setInputAction(function(t){for(var a in u)if(u.hasOwnProperty(a)){var h=u[a];if(e(h.name)){var d=c(h,r);l[d]&&(i[d]?(f(n[d],o[d]),o[d].valid=!0,f(t,n[d]),i[d]=!1):s.clone(t.endPosition,n[d].endPosition))}}},a.MOUSE_MOVE,r)}var y=function(t){if(!e(t))throw new r("canvas is required.");this._eventHandler=new o(t),this._update={},this._movement={},this._lastMovement={},this._isDown={},this._pressTime={},this._releaseTime={},this._buttonsDown=0,m(this,void 0),d(this,void 0,t),p(this,void 0,u.LEFT_DRAG),p(this,void 0,u.RIGHT_DRAG),p(this,void 0,u.MIDDLE_DRAG),v(this,void 0);for(var i in l)if(l.hasOwnProperty(i)){var n=l[i];e(n.name)&&(m(this,n),d(this,n,t),p(this,n,u.LEFT_DRAG),p(this,n,u.RIGHT_DRAG),p(this,n,u.MIDDLE_DRAG),v(this,n))}};return y.prototype.isMoving=function(t,i){if(!e(t))throw new r("type is required.");var n=c(t,i);return!this._update[n]},y.prototype.getMovement=function(t,i){if(!e(t))throw new r("type is required.");var n=c(t,i),o=this._movement[n];return o},y.prototype.getLastMovement=function(t,i){if(!e(t))throw new r("type is required.");var n=c(t,i),o=this._lastMovement[n];return o.valid?o:void 0},y.prototype.isButtonDown=function(t,i){if(!e(t))throw new r("type is required.");var n=c(t,i);return this._isDown[n]},y.prototype.anyButtonDown=function(){return this._buttonsDown>0},y.prototype.getButtonPressTime=function(t,i){if(!e(t))throw new r("type is required.");var n=c(t,i);return this._pressTime[n]},y.prototype.getButtonReleaseTime=function(t,i){if(!e(t))throw new r("type is required.");var n=c(t,i);return this._releaseTime[n]},y.prototype.reset=function(){for(var e in this._update)this._update.hasOwnProperty(e)&&(this._update[e]=!0)},y.prototype.isDestroyed=function(){return!1},y.prototype.destroy=function(){return this._eventHandler=this._eventHandler&&this._eventHandler.destroy(),i(this)},y}),r("Scene/CameraFlightPath",["../Core/Cartesian2","../Core/Cartesian3","../Core/clone","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/HermiteSpline","../Core/Math","../Core/Matrix3","../Core/Quaternion","../Core/QuaternionSpline","../Scene/PerspectiveFrustum","../Scene/PerspectiveOffCenterFrustum","../Scene/SceneMode","../ThirdParty/Tween"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p){"use strict";function f(e,r,i){return t.cross(e,r,M),t.cross(M,e,I),P[0]=M.x,P[1]=I.x,P[2]=-e.x,P[3]=M.y,P[4]=I.y,P[5]=-e.y,P[6]=M.z,P[7]=I.z,P[8]=-e.z,u.fromRotationMatrix(P,i)}function v(e,t,r){var i,n,o;if(e instanceof h){var a=Math.tan(.5*e.fovy);return i=e.near,n=e.near*a,o=e.aspectRatio*n,Math.max(t*i/o,r*i/n)}return e instanceof d?(i=e.near,n=e.top,o=e.right,Math.max(t*i/o,r*i/n)):Math.max(t,r)}function y(e,r,i,n,o){var c,h,d,m=r.getMaximumRadius(),p=e.frustum,f=v(p,m,m),y=t.dot(t.normalize(i),t.normalize(n));if(t.magnitude(i)>f)h=m+.6*(f-m),d=.35;else{var g=t.subtract(i,n);h=t.magnitude(t.add(t.multiplyByScalar(g,.5),n));var _=t.magnitude(t.multiplyByScalar(e.up,t.dot(g,e.up))),w=t.magnitude(t.multiplyByScalar(e.right,t.dot(g,e.right)));h+=v(p,_,w),d=s.clamp(y+1,.25,.5)}var C,x,S,E,b=t.multiplyByScalar(t.normalize(n),h),T=t.multiplyByScalar(t.normalize(i),h);if(t.magnitude(n)>f&&y>.75)E=t.add(t.multiplyByScalar(t.subtract(i,n),.5),n),c=[i,E,n];else if(t.magnitude(i)>f&&y>0)E=t.add(t.multiplyByScalar(t.subtract(i,b),.5),b),c=[i,E,n];else{c=[i],x=Math.acos(t.dot(t.normalize(T),t.normalize(b))),C=t.cross(b,T),t.equalsEpsilon(C,t.ZERO,s.EPSILON6)&&(C=t.UNIT_Z);for(var A=d*x,D=x-A,P=D;P>0;P-=A)S=l.fromQuaternion(u.fromAxisAngle(C,P)),c.push(l.multiplyByVector(S,b));c.push(n)}for(var M=new Array(c.length),I=o/(c.length-1),O=0;O<c.length;++O)M[O]=O*I;return new a({points:c,times:M})}function g(e,r,i,o){var a=r.points,s=new Array(a.length);s[0]=f(e.direction,e.up);for(var l,u=a.length-1,h=1;u>h;++h)l=a[h],t.normalize(t.negate(l,O),O),t.normalize(t.cross(O,t.UNIT_Z,R),R),t.cross(R,O,L),s[h]=f(O,L,z);return l=a[u],n(i)&&n(o)?s[u]=f(i,o):(t.normalize(t.negate(l,O),O),t.normalize(t.cross(O,t.UNIT_Z,R),R),t.cross(R,O,L),s[u]=f(O,L,z)),new c({points:s,times:r.times})}function _(e,r,i,n,o){var a=e.camera,s=e.scene2D.projection.getEllipsoid(),u=y(a,s,a.position,r,i),c=g(a,u,n,o),h=function(e){var r=e.time,i=c.evaluate(r);l.fromQuaternion(i,D),a.position=u.evaluate(r),a.right=l.getRow(D,0,a.right),a.up=l.getRow(D,1,a.up),a.direction=t.negate(l.getRow(D,2,a.direction),a.direction)};return h}function w(e,r,i,n,o){var l,u,c=r.getMaximumRadius(),h=e.frustum,d=v(h,Math.PI*c,s.PI_OVER_TWO*c),m=.5;if(i.z>d)u=.6*d;else{var p=t.subtract(i,n);u=v(h,Math.abs(p.y),Math.abs(p.x))}var f=t.clone(n);f.z=u;var y=t.clone(i);y.z=u;var g;if(n.z>d)g=t.add(t.multiplyByScalar(t.subtract(i,n),.5),n),l=[i,g,n];else if(i.z>d)g=t.add(t.multiplyByScalar(t.subtract(i,f),.5),f),l=[i,g,n];else{l=[i];var _=t.subtract(y,f),w=t.magnitude(_);t.normalize(_,_);for(var C=m*w,x=w-C,S=x;S>0;S-=C)l.push(t.add(t.multiplyByScalar(_,S),f));l.push(n)}for(var E=new Array(l.length),b=o/(l.length-1),T=0;T<l.length;++T)E[T]=T*b;return new a({points:l,times:E})}function C(e,t,r,i){var o=t.points,a=new Array(o.length);a[0]=f(e.direction,e.up);for(var s=o.length-1,l=1;s>l;++l)a[l]=V;return a[s]=n(r)&&n(i)?f(r,i):V,new c({points:a,times:t.times})}function x(e,r,i,n,o){var a=e.camera,s=e.scene2D.projection.getEllipsoid(),u=w(a,s,t.clone(a.position),r,i),c=C(a,u,n,o),h=function(e){var r=e.time,i=c.evaluate(r);l.fromQuaternion(i,D),a.position=u.evaluate(r,a.position),a.right=l.getRow(D,0,a.right),a.up=l.getRow(D,1,a.up),a.direction=t.negate(l.getRow(D,2,a.direction),a.direction)};return h}function S(e,r,i,n,o){var a=e.camera,s=e.scene2D.projection.getEllipsoid(),u=t.clone(a.position);u.z=a.frustum.right-a.frustum.left;var c=w(a,s,u,r,i),h=C(a,c,t.negate(t.UNIT_Z),o),d=a.position.z,m=function(e){var r=e.time,i=h.evaluate(r);l.fromQuaternion(i,D),a.position=c.evaluate(r);var n=a.position.z;a.position.z=d,a.right=l.getRow(D,0,a.right),a.up=l.getRow(D,1,a.up),a.direction=t.negate(l.getRow(D,2,a.direction),a.direction);var o=a.frustum,s=o.top/o.right,u=.5*(n-(o.right-o.left));o.right+=u,o.left-=u,o.top=s*o.right,o.bottom=-o.top};return m}function E(e){var t={enableTranslate:e.enableTranslate,enableZoom:e.enableZoom,enableRotate:e.enableRotate,enableTilt:e.enableTilt,enableLook:e.enableLook};return e.enableTranslate=!1,e.enableZoom=!1,e.enableRotate=!1,e.enableTilt=!1,e.enableLook=!1,t}function b(e,t){e.enableTranslate=t.enableTranslate,e.enableZoom=t.enableZoom,e.enableRotate=t.enableRotate,e.enableTilt=t.enableTilt,e.enableLook=t.enableLook}var T={},A=new t,D=new l,P=new l,M=new t,I=new t,O=new t,R=new t,L=new t,z=new u,N=t.negate(t.UNIT_Z),B=t.normalize(t.cross(N,t.UNIT_Y)),F=t.cross(B,N),V=f(N,F),k=new t,U=new t,W=new t;return T.createAnimation=function(r,a){a=i(a,i.EMPTY_OBJECT);var l=a.destination,u=a.direction,c=a.up;if(!n(r))throw new o("scene is required.");if(!n(l))throw new o("destination is required.");if(n(u)&&!n(c)||n(c)&&!n(u))throw new o("If either direction or up is given, then both are required.");var h=r.getFrameState();if(h.mode===m.MORPHING)throw new o("frameState.mode cannot be SceneMode.MORPHING");var d=i(a.duration,3e3),f=r.getScreenSpaceCameraController(),v=E(f),y=function(e){var t=function(){"function"==typeof e&&e(),b(f,v)};return t},g=y(a.onComplete),w=y(a.onCancel),C=h.camera.frustum;if(h.mode===m.SCENE2D){if(e.equalsEpsilon(h.camera.position,l,s.EPSILON6)&&s.equalsEpsilon(Math.max(C.right-C.left,C.top-C.bottom),l.z,s.EPSILON6))return{duration:0,onComplete:g,onCancel:w}}else if(t.equalsEpsilon(l,h.camera.position,s.EPSILON6))return{duration:0,onComplete:g,onCancel:w};if(0>=d){var T=function(){var e=l;if(h.mode===m.SCENE3D?(n(a.direction)||n(a.up)?(k=a.direction,U=t.normalize(t.cross(k,a.up,U),U)):(k=t.normalize(t.negate(e,k),k),U=t.normalize(t.cross(k,t.UNIT_Z,U),U)),W=i(a.up,t.cross(U,k,W))):(n(a.direction)||n(a.up)?(k=a.direction,U=t.normalize(t.cross(k,a.up,U),U)):(k=t.negate(t.UNIT_Z,k),U=t.normalize(t.cross(k,t.UNIT_Y,U),U)),W=i(a.up,t.cross(U,k,W))),t.clone(e,h.camera.position),t.clone(k,h.camera.direction),t.clone(W,h.camera.up),t.clone(U,h.camera.right),h.mode===m.SCENE2D){var r=h.camera.position.z,o=C.top/C.right,s=.5*(r-(C.right-C.left));C.right+=s,C.left-=s,C.top=o*C.right,C.bottom=-C.top}"function"==typeof g&&g()};return{duration:0,onComplete:T,onCancel:w}}var A;return A=h.mode===m.SCENE3D?_(h,l,d,u,c):h.mode===m.SCENE2D?S(h,l,d,u,c):x(h,l,d,u,c),{duration:d,easingFunction:p.Easing.Sinusoidal.InOut,startValue:{time:0},stopValue:{time:d},onUpdate:A,onComplete:g,onCancel:w}},T.createAnimationCartographic=function(e,t){t=i(t,i.EMPTY_OBJECT);var a=t.destination;if(!n(e))throw new o("scene is required.");if(!n(a))throw new o("description.destination is required.");var s=e.getFrameState(),l=s.scene2D.projection;if(s.mode===m.SCENE3D){var u=l.getEllipsoid();u.cartographicToCartesian(a,A)}else{if(s.mode!==m.COLUMBUS_VIEW&&s.mode!==m.SCENE2D)throw new o("frameState.mode cannot be SceneMode.MORPHING");l.project(a,A)}var c=r(t);return c.destination=A,this.createAnimation(e,c)},T.createAnimationExtent=function(e,t){t=i(t,i.EMPTY_OBJECT);var a=t.destination,s=e.getFrameState();if(!n(s))throw new o("frameState is required.");if(!n(a))throw new o("description.destination is required.");if(s.mode===m.MORPHING)throw new o("frameState.mode cannot be SceneMode.MORPHING");var l=r(t),u=s.camera;return u.controller.getExtentCameraCoordinates(a,A),l.destination=A,this.createAnimation(e,l)},T}),r("Scene/Imagery",["../Core/defined","../Core/destroyObject","./ImageryState"],function(e,t,r){"use strict";var i=function(t,i,n,o,a){if(this.imageryLayer=t,this.x=i,this.y=n,this.level=o,0!==o){var s=0|i/2,l=0|n/2,u=o-1;this.parent=t.getImageryFromCache(s,l,u)}if(this.state=r.UNLOADED,this.imageUrl=void 0,this.image=void 0,this.texture=void 0,this.referenceCount=0,!e(a)&&t.getImageryProvider().isReady()){var c=t.getImageryProvider().getTilingScheme();a=c.tileXYToExtent(i,n,o)}this.extent=a};return i.createPlaceholder=function(e){var t=new i(e,0,0,0);return t.addReference(),t.state=r.PLACEHOLDER,t},i.prototype.addReference=function(){++this.referenceCount},i.prototype.releaseReference=function(){return--this.referenceCount,0===this.referenceCount?(this.imageryLayer.removeImageryFromCache(this),e(this.parent)&&this.parent.releaseReference(),e(this.image)&&e(this.image.destroy)&&this.image.destroy(),e(this.texture)&&e(this.texture.destroy)&&this.texture.destroy(),t(this),0):this.referenceCount},i}),r("Scene/TileImagery",["../Core/defined","./ImageryState"],function(e,t){"use strict";var r=function(e,t){this.readyImagery=void 0,this.loadingImagery=e,this.textureCoordinateExtent=t,this.textureTranslationAndScale=void 0};return r.prototype.freeResources=function(){e(this.readyImagery)&&this.readyImagery.releaseReference(),e(this.loadingImagery)&&this.loadingImagery.releaseReference()},r.prototype.processStateMachine=function(r,i){var n=this.loadingImagery,o=n.imageryLayer;if(n.state===t.UNLOADED&&(n.state=t.TRANSITIONING,o._requestImagery(n)),n.state===t.RECEIVED&&(n.state=t.TRANSITIONING,o._createTexture(i,n)),n.state===t.TEXTURE_LOADED&&(n.state=t.TRANSITIONING,o._reprojectTexture(i,n)),n.state===t.READY)return e(this.readyImagery)&&this.readyImagery.releaseReference(),this.readyImagery=this.loadingImagery,this.loadingImagery=void 0,this.textureTranslationAndScale=o._calculateTextureTranslationAndScale(r,this),!0;for(var a=n.parent,s=!1;e(a)&&a.state!==t.READY;)s=s||a.state!==t.FAILED&&a.state!==t.INVALID,a=a.parent;return this.readyImagery!==a&&(e(this.readyImagery)&&this.readyImagery.releaseReference(),this.readyImagery=a,e(a)&&(a.addReference(),this.textureTranslationAndScale=o._calculateTextureTranslationAndScale(r,this))),s||n.state!==t.FAILED&&n.state!==t.INVALID?!1:!0},r}),r("Scene/TexturePool",["../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Renderer/PixelDatatype","../Renderer/PixelFormat","../Renderer/Texture"],function(e,t,r,i,n,o){"use strict";function a(t,r,i){return e(s)||(s=function(e,t,r){this._texture=e,this._textureTypeKey=t,this._pool=r},Object.keys(o.prototype).forEach(function(e){s.prototype[e]=function(){var t=this._texture;return t[e].apply(t,arguments)}}),s.prototype.destroy=function(){var t=this._pool._free[this._textureTypeKey];e(t)||(t=this._pool._free[this._textureTypeKey]=[]),t.length>=8?this._texture.destroy():t.push(this)}),new s(t,r,i)}var s,l=function(){this._free={}};return l.prototype.createTexture2D=function(t,o){if(!o)throw new r("description is required.");var s=o.source,l=e(s)?s.width:o.width,u=e(s)?s.height:o.height,c=o.pixelFormat||n.RGBA,h=+(o.pixelDatatype||i.UNSIGNED_BYTE),d=+(o.preMultiplyAlpha||c===n.RGB||c===n.LUMINANCE),m=JSON.stringify([l,u,c,h,d]),p=this._free[m];if(e(p)&&p.length>0){var f=p.pop();return e(s)&&f.copyFrom(s),f}return a(t.createTexture2D(o),m,this)},l.prototype.isDestroyed=function(){return!1},l.prototype.destroy=function(){var e=this._free;return Object.keys(e).forEach(function(t){e[t].forEach(function(e){e._texture.destroy()})}),t(this)},l}),r("Shaders/ReprojectWebMercatorFS",[],function(){"use strict";return"uniform sampler2D u_texture;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\ngl_FragColor = texture2D(u_texture, v_textureCoordinates);\n}\n"}),r("Shaders/ReprojectWebMercatorVS",[],function(){"use strict";return"attribute vec4 position;\nuniform vec2 u_textureDimensions;\nuniform float u_northLatitude;\nuniform float u_southLatitude;\nuniform float u_southMercatorYHigh;\nuniform float u_southMercatorYLow;\nuniform float u_oneOverMercatorHeight;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\nfloat currentLatitude = mix(u_southLatitude, u_northLatitude, position.y);\nfloat fraction = czm_latitudeToWebMercatorFraction(currentLatitude, u_southMercatorYLow, u_southMercatorYHigh, u_oneOverMercatorHeight);\nv_textureCoordinates = vec2(position.x, fraction);\ngl_Position = czm_viewportOrthographic * (position * vec4(u_textureDimensions, 1.0, 1.0));\n}\n"}),r("Scene/ImageryLayer",["../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/BoundingRectangle","../Core/ComponentDatatype","../Core/Cartesian2","../Core/Cartesian4","../Core/Color","../Core/Extent","../Core/FeatureDetection","../Core/Math","../Core/PrimitiveType","../Core/Geometry","../Core/GeometryAttribute","../Renderer/BufferUsage","../Renderer/MipmapHint","../Renderer/TextureMagnificationFilter","../Renderer/TextureMinificationFilter","../Renderer/TextureWrap","../Renderer/ClearCommand","./GeographicTilingScheme","./Imagery","./TileProviderError","./ImageryState","./TileImagery","./TerrainProvider","./TexturePool","../ThirdParty/when","../Shaders/ReprojectWebMercatorFS","../Shaders/ReprojectWebMercatorVS"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E,b,T,A,D,P){"use strict";function M(e,t,r){return JSON.stringify([e,t,r])}function I(r,o,a,l){var u=o.cache.imageryLayer_reproject;if(!t(u)){u=o.cache.imageryLayer_reproject={framebuffer:void 0,vertexArray:void 0,shaderProgram:void 0,renderState:void 0,sampler:void 0,destroy:function(){t(this.framebuffer)&&this.framebuffer.destroy(),t(this.vertexArray)&&this.vertexArray.destroy(),t(this.shaderProgram)&&this.shaderProgram.release()}},u.framebuffer=o.createFramebuffer(),u.framebuffer.destroyAttachments=!1;for(var c=new Array(131072),w=0,C=0;256>C;++C)for(var x=C/255,S=0;256>S;++S){var E=S/255;c[w++]=E,c[w++]=x}var T=new d({attributes:{position:new m({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:c})},indices:b.getRegularGridIndices(256,256),primitiveType:h.TRIANGLES}),A={position:0};u.vertexArray=o.createVertexArrayFromGeometry({geometry:T,attributeIndices:A,bufferUsage:p.STATIC_DRAW}),u.shaderProgram=o.getShaderCache().getShaderProgram(P,D,A);var M=o.getMaximumTextureFilterAnisotropy();u.sampler=o.createSampler({wrapS:g.CLAMP_TO_EDGE,wrapT:g.CLAMP_TO_EDGE,minificationFilter:y.LINEAR,magnificationFilter:v.LINEAR,maximumAnisotropy:Math.min(M,e(r._maximumAnisotropy,M))})}a.setSampler(u.sampler);var I=a.getWidth(),O=a.getHeight();L.textureDimensions.x=I,L.textureDimensions.y=O,L.texture=a,L.northLatitude=l.north,L.southLatitude=l.south;var R=Math.sin(l.south),N=.5*Math.log((1+R)/(1-R));z[0]=N,L.southMercatorYHigh=z[0],L.southMercatorYLow=N-z[0],R=Math.sin(l.north);var B=.5*Math.log((1+R)/(1-R));L.oneOverMercatorHeight=1/(B-N);var F=r._texturePool.createTexture2D(o,{width:I,height:O,pixelFormat:a.getPixelFormat(),pixelDatatype:a.getPixelDatatype(),preMultiplyAlpha:a.getPreMultiplyAlpha()});F.generateMipmap(f.NICEST),u.framebuffer.setColorTexture(F);var V=new _;return V.color=s.BLACK,V.framebuffer=u.framebuffer,V.execute(o),t(u.renderState)&&u.renderState.viewport.width===I&&u.renderState.viewport.height===O||(u.renderState=o.createRenderState({viewport:new i(0,0,I,O)})),o.draw({framebuffer:u.framebuffer,shaderProgram:u.shaderProgram,renderState:u.renderState,primitiveType:h.TRIANGLES,vertexArray:u.vertexArray,uniformMap:L}),F}function O(e,t,r){var i=e._imageryProvider,n=i.getTilingScheme(),o=n.getEllipsoid(),a=Math.cos(r),s=n.getExtent(),l=o.getMaximumRadius()*(s.east-s.west)*a/(i.getTileWidth()*n.getNumberOfXTilesAtLevel(0)),u=l/t,c=Math.log(u)/Math.log(2),h=Math.round(c);return 0|h}var R=function N(t,r){this._imageryProvider=t,r=e(r,{}),this.alpha=e(r.alpha,e(t.defaultAlpha,1)),this.brightness=e(r.brightness,e(t.defaultBrightness,N.DEFAULT_BRIGHTNESS)),this.contrast=e(r.contrast,e(t.defaultContrast,N.DEFAULT_CONTRAST)),this.hue=e(r.hue,e(t.defaultHue,N.DEFAULT_HUE)),this.saturation=e(r.saturation,e(t.defaultSaturation,N.DEFAULT_SATURATION)),this.gamma=e(r.gamma,e(t.defaultGamma,N.DEFAULT_GAMMA)),this.show=e(r.show,!0),this._minimumTerrainLevel=r.minimumTerrainLevel,this._maximumTerrainLevel=r.maximumTerrainLevel,this._extent=e(r.extent,l.MAX_VALUE),this._maximumAnisotropy=r.maximumAnisotropy,this._imageryCache={},this._texturePool=new T,this._skeletonPlaceholder=new E(C.createPlaceholder(this)),this._show=!1,this._layerIndex=-1,this._isBaseLayer=!1,this._requestImageError=void 0};R.DEFAULT_BRIGHTNESS=1,R.DEFAULT_CONTRAST=1,R.DEFAULT_HUE=0,R.DEFAULT_SATURATION=1,R.DEFAULT_GAMMA=1,R.prototype.getImageryProvider=function(){return this._imageryProvider},R.prototype.getExtent=function(){return this._extent},R.prototype.isBaseLayer=function(){return this._isBaseLayer},R.prototype.isDestroyed=function(){return!1},R.prototype.destroy=function(){return this._texturePool=this._texturePool&&this._texturePool.destroy(),r(this)},R.prototype._createTileImagerySkeletons=function(e,r,i){if(t(this._minimumTerrainLevel)&&e.level<this._minimumTerrainLevel)return!1;if(t(this._maximumTerrainLevel)&&e.level>this._maximumTerrainLevel)return!1;var n=this._imageryProvider;if(t(i)||(i=e.imagery.length),!n.isReady())return this._skeletonPlaceholder.loadingImagery.addReference(),e.imagery.splice(i,0,this._skeletonPlaceholder),!0;var o=e.extent.intersectWith(n.getExtent());if(o=o.intersectWith(this._extent),o.east<=o.west||o.north<=o.south){if(!this.isBaseLayer())return!1;var s=n.getExtent().intersectWith(this._extent),l=e.extent;l.south>=s.north?o.north=o.south=s.north:l.north<=s.south&&(o.north=o.south=s.south),l.west>=s.east?o.west=o.east=s.east:l.east<=s.west&&(o.west=o.east=s.west)}var u=0;o.south>0?u=o.south:o.north<0&&(u=o.north);var c=1,h=c*r.getLevelMaximumGeometricError(e.level),d=O(this,h,u);d=Math.max(0,d);var m=n.getMaximumLevel();if(d>m&&(d=m),t(n.getMinimumLevel)){var p=n.getMinimumLevel();p>d&&(d=p)}var f=n.getTilingScheme(),v=f.positionToTileXY(o.getNorthwest(),d),y=f.positionToTileXY(o.getSoutheast(),d),g=(e.extent.north-e.extent.south)/512,_=(e.extent.east-e.extent.west)/512,w=f.tileXYToExtent(v.x,v.y,d);Math.abs(w.south-e.extent.north)<_&&v.y<y.y&&++v.y,Math.abs(w.east-e.extent.west)<g&&v.x<y.x&&++v.x;var C=f.tileXYToExtent(y.x,y.y,d);Math.abs(C.north-e.extent.south)<_&&y.y>v.y&&--y.y,Math.abs(C.west-e.extent.east)<g&&y.x>v.x&&--y.x;var x,S,b=e.extent,T=f.tileXYToExtent(v.x,v.y,d),A=0,D=1;!this.isBaseLayer()&&Math.abs(T.west-e.extent.west)>=g&&(A=Math.min(1,(T.west-b.west)/(b.east-b.west))),!this.isBaseLayer()&&Math.abs(T.north-e.extent.north)>=_&&(D=Math.max(0,(T.north-b.south)/(b.north-b.south)));for(var P=D,M=v.x;M<=y.x;M++){x=A,T=f.tileXYToExtent(M,v.y,d),A=Math.min(1,(T.east-b.west)/(b.east-b.west)),M===y.x&&(this.isBaseLayer()||Math.abs(T.east-e.extent.east)<g)&&(A=1),D=P;for(var I=v.y;I<=y.y;I++){S=D,T=f.tileXYToExtent(M,I,d),D=Math.max(0,(T.south-b.south)/(b.north-b.south)),I===y.y&&(this.isBaseLayer()||Math.abs(T.south-e.extent.south)<_)&&(D=0);var R=new a(x,D,A,S),L=this.getImageryFromCache(M,I,d,T);e.imagery.splice(i,0,new E(L,R)),++i}}return!0},R.prototype._calculateTextureTranslationAndScale=function(e,t){var r=t.readyImagery.extent,i=e.extent,n=i.east-i.west,o=i.north-i.south,s=n/(r.east-r.west),l=o/(r.north-r.south);return new a(s*(i.west-r.west)/n,l*(i.south-r.south)/o,s,l)},R.prototype._requestImagery=function(e){function r(r){return t(r)?(e.image=r,e.state=S.RECEIVED,x.handleSuccess(a._requestImageError),void 0):i()}function i(){e.state=S.FAILED;var t="Failed to obtain image tile X: "+e.x+" Y: "+e.y+" Level: "+e.level+".";a._requestImageError=x.handleError(a._requestImageError,o,o.getErrorEvent(),t,e.x,e.y,e.level,n)}function n(){e.state=S.TRANSITIONING;var n=o.requestImage(e.x,e.y,e.level);return t(n)?(A(n,r,i),void 0):(e.state=S.UNLOADED,void 0)}var o=this._imageryProvider,a=this;n()},R.prototype._createTexture=function(e,r){var i=this._imageryProvider;if(t(i.getTileDiscardPolicy)){var n=i.getTileDiscardPolicy();if(t(n)){if(!n.isReady())return r.state=S.RECEIVED,void 0;if(n.shouldDiscardImage(r.image))return r.state=S.INVALID,void 0}}var o=this._texturePool.createTexture2D(e,{source:r.image});r.texture=o,r.image=void 0,r.state=S.TEXTURE_LOADED},R.prototype._reprojectTexture=function(r,i){var n=i.texture,o=i.extent;if(!(this._imageryProvider.getTilingScheme()instanceof w)&&(o.east-o.west)/n.getWidth()>1e-5){var a=I(this,r,n,i.extent);n.destroy(),i.texture=n=a}if(c.isPowerOfTwo(n.getWidth())&&c.isPowerOfTwo(n.getHeight())){var s=r.cache.imageryLayer_mipmapSampler;if(!t(s)){var l=r.getMaximumTextureFilterAnisotropy();s=r.cache.imageryLayer_mipmapSampler=r.createSampler({wrapS:g.CLAMP_TO_EDGE,wrapT:g.CLAMP_TO_EDGE,minificationFilter:y.LINEAR_MIPMAP_LINEAR,magnificationFilter:v.LINEAR,maximumAnisotropy:Math.min(l,e(this._maximumAnisotropy,l))})}n.generateMipmap(f.NICEST),n.setSampler(s)}else{var u=r.cache.imageryLayer_nonMipmapSampler;t(u)||(u=r.cache.imageryLayer_nonMipmapSampler=r.createSampler({wrapS:g.CLAMP_TO_EDGE,wrapT:g.CLAMP_TO_EDGE,minificationFilter:y.LINEAR,magnificationFilter:v.LINEAR})),n.setSampler(u)}i.state=S.READY},R.prototype.getImageryFromCache=function(e,r,i,n){var o=M(e,r,i),a=this._imageryCache[o];return t(a)||(a=new C(this,e,r,i,n),this._imageryCache[o]=a),a.addReference(),a},R.prototype.removeImageryFromCache=function(e){var t=M(e.x,e.y,e.level);delete this._imageryCache[t]};var L={u_textureDimensions:function(){return this.textureDimensions},u_texture:function(){return this.texture},u_northLatitude:function(){return this.northLatitude},u_southLatitude:function(){return this.southLatitude},u_southMercatorYLow:function(){return this.southMercatorYLow},u_southMercatorYHigh:function(){return this.southMercatorYHigh},u_oneOverMercatorHeight:function(){return this.oneOverMercatorHeight},textureDimensions:new o,texture:void 0,northLatitude:0,southLatitude:0,southMercatorYHigh:0,southMercatorYLow:0,oneOverMercatorHeight:0},z=u.supportsTypedArrays()?new Float32Array(1):void 0;return R}),r("Scene/TileReplacementQueue",["../Core/defined","./ImageryState","./TerrainState"],function(e,t,r){"use strict";function i(e,t){var r=t.replacementPrevious,i=t.replacementNext;t===e._lastBeforeStartOfFrame&&(e._lastBeforeStartOfFrame=i),t===e.head?e.head=i:r.replacementNext=i,t===e.tail?e.tail=r:i.replacementPrevious=r,t.replacementPrevious=void 0,t.replacementNext=void 0,--e.count}var n=function(){this.head=void 0,this.tail=void 0,this.count=0,this._lastBeforeStartOfFrame=void 0};return n.prototype.markStartOfRenderFrame=function(){this._lastBeforeStartOfFrame=this.head},n.prototype.trimTiles=function(n){for(var o=this.tail,a=!0;a&&e(this._lastBeforeStartOfFrame)&&this.count>n&&e(o);){a=o!==this._lastBeforeStartOfFrame;for(var s=o.replacementPrevious,l=o.loadedTerrain,u=e(l)&&(l.state===r.RECEIVING||l.state===r.TRANSFORMING),c=o.upsampledTerrain,h=e(c)&&(c.state===r.RECEIVING||c.state===r.TRANSFORMING),d=!u&&!h,m=o.imagery,p=0,f=m.length;d&&f>p;++p){var v=m[p];d=!e(v.loadingImagery)||v.loadingImagery.state!==t.TRANSITIONING}d&&(o.freeResources(),i(this,o)),o=s}},n.prototype.markTileRendered=function(t){var r=this.head;return r===t?(t===this._lastBeforeStartOfFrame&&(this._lastBeforeStartOfFrame=t.replacementNext),void 0):(++this.count,e(r)?((e(t.replacementPrevious)||e(t.replacementNext))&&i(this,t),t.replacementPrevious=void 0,t.replacementNext=r,r.replacementPrevious=t,this.head=t,void 0):(t.replacementPrevious=void 0,t.replacementNext=void 0,this.head=t,this.tail=t,void 0))},n}),r("Scene/CentralBodySurface",["../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/FeatureDetection","../Core/DeveloperError","../Core/EllipsoidalOccluder","../Core/Intersect","../Core/Matrix4","../Core/PrimitiveType","../Core/Queue","../Core/WebMercatorProjection","../Renderer/DrawCommand","../Renderer/Pass","./ImageryLayer","./ImageryState","./SceneMode","./TerrainProvider","./TileReplacementQueue","./TileState","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E){"use strict";function b(e,r){var i=e.loadingImagery;t(i)||(i=e.readyImagery);var n=r.loadingImagery;return t(n)||(n=r.readyImagery),i.imageryLayer._layerIndex-n.imageryLayer._layerIndex}function T(e){if(e._imageryLayerCollection._update(),e._layerOrderChanged){e._layerOrderChanged=!1;for(var r=e._tileReplacementQueue.head;t(r);)r.imagery.sort(b),r=r.replacementNext}}function A(e,r,i){var n=e._debug;if(!n.suspendLodUpdate){var o,a,s=e._tilesToRenderByTextureCount;for(o=0,a=s.length;a>o;++o){var l=s[o];t(l)&&(l.length=0)}var u=e._tileTraversalQueue;if(u.clear(),n.maxDepth=0,n.tilesVisited=0,n.tilesCulled=0,n.tilesRendered=0,n.texturesRendered=0,n.tilesWaitingForChildren=0,e._tileLoadQueue.length=0,e._tileReplacementQueue.markStartOfRenderFrame(),!t(e._levelZeroTiles)){if(!e._terrainProvider.isReady())return;var c=e._terrainProvider.getTilingScheme();e._levelZeroTiles=c.createLevelZeroTiles()}var h=i.camera.positionWC,d=e._terrainProvider.getTilingScheme().getEllipsoid(),m=d.cartesianToCartographic(h,W);e._ellipsoidalOccluder.setCameraPosition(h);var p,f=e._levelZeroTiles;for(o=0,a=f.length;a>o;++o)p=f[o],e._tileReplacementQueue.markTileRendered(p),p.state!==S.READY&&L(e,p),p.isRenderable&&I(e,i,p)?u.enqueue(p):(++n.tilesCulled,p.isRenderable||++n.tilesWaitingForChildren);for(;t(p=u.dequeue());)if(++n.tilesVisited,e._tileReplacementQueue.markTileRendered(p),p.level>n.maxDepth&&(n.maxDepth=p.level),D(e,r,i,h,m,p)<e._maximumScreenSpaceError)M(e,p);else if(R(e,i,p)){var v=p.children;for(o=0,a=v.length;a>o;++o)I(e,i,v[o])?u.enqueue(v[o]):++n.tilesCulled}else++n.tilesWaitingForChildren,M(e,p);n.enableDebugOutput&&(n.tilesVisited!==n.lastTilesVisited||n.tilesRendered!==n.lastTilesRendered||n.texturesRendered!==n.lastTexturesRendered||n.tilesCulled!==n.lastTilesCulled||n.maxDepth!==n.lastMaxDepth||n.tilesWaitingForChildren!==n.lastTilesWaitingForChildren)&&(console.log("Visited "+n.tilesVisited+", Rendered: "+n.tilesRendered+", Textures: "+n.texturesRendered+", Culled: "+n.tilesCulled+", Max Depth: "+n.maxDepth+", Waiting for children: "+n.tilesWaitingForChildren),n.lastTilesVisited=n.tilesVisited,n.lastTilesRendered=n.tilesRendered,n.lastTexturesRendered=n.texturesRendered,n.lastTilesCulled=n.tilesCulled,n.lastMaxDepth=n.maxDepth,n.lastTilesWaitingForChildren=n.tilesWaitingForChildren)}}function D(e,t,r,i,n,o){if(r.mode===w.SCENE2D)return P(e,t,r,i,n,o);var a=o.extent,s=1;if(r.mode===w.SCENE3D){var l=0;a.south>0?l=a.south:a.north<0&&(l=a.north),s=Math.cos(l)}var u=s*e._terrainProvider.getLevelMaximumGeometricError(o.level),c=Math.sqrt(O(r,i,n,o));o.distance=c;var h=t.getDrawingBufferHeight(),d=r.camera,m=d.frustum,p=m.fovy;return u*h/(2*c*Math.tan(.5*p))}function P(e,t,r,i,n,o){var a=r.camera,s=a.frustum,l=t.getDrawingBufferWidth(),u=t.getDrawingBufferHeight(),c=e._terrainProvider.getLevelMaximumGeometricError(o.level),h=Math.max(s.top-s.bottom,s.right-s.left)/Math.max(l,u);return c/h}function M(e,r){for(var i=0,n=r.imagery,o=0,a=n.length;a>o;++o){var s=n[o];t(s.readyImagery)&&0!==s.readyImagery.imageryLayer.alpha&&++i}var l=e._tilesToRenderByTextureCount[i];t(l)||(l=[],e._tilesToRenderByTextureCount[i]=l),l.push(r);var u=e._debug;++u.tilesRendered,u.texturesRendered+=i}function I(e,r,n){var a=r.cullingVolume,s=n.boundingSphere3D;if(r.mode!==w.SCENE3D&&(s=q,i.fromExtentWithHeights2D(n.extent,r.scene2D.projection,n.minimumHeight,n.maximumHeight,s),o.fromElements(s.center.z,s.center.x,s.center.y,s.center),r.mode===w.MORPHING&&(s=i.union(n.boundingSphere3D,s,s))),a.getVisibility(s)===h.OUTSIDE)return!1;if(r.mode===w.SCENE3D){var l=n.occludeePointInScaledSpace;return t(l)?e._ellipsoidalOccluder.isScaledSpacePointVisible(l):!0}return!0}function O(e,t,r,i){var n=i.southwestCornerCartesian,a=i.northeastCornerCartesian,s=i.westNormal,l=i.southNormal,u=i.eastNormal,c=i.northNormal,h=i.maximumHeight;e.mode!==w.SCENE3D&&(n=e.scene2D.projection.project(i.extent.getSouthwest(),G),n.z=n.y,n.y=n.x,n.x=0,a=e.scene2D.projection.project(i.extent.getNortheast(),H),a.z=a.y,a.y=a.x,a.x=0,s=j,u=o.UNIT_Y,l=Y,c=o.UNIT_Z,h=0);var d,m=o.subtract(t,n,X),p=o.dot(m,s),f=o.dot(m,l),v=o.subtract(t,a,X),y=o.dot(v,u),g=o.dot(v,c);d=e.mode===w.SCENE3D?r.height:t.x;var _=d-h,C=0;return p>0?C+=p*p:y>0&&(C+=y*y),f>0?C+=f*f:g>0&&(C+=g*g),_>0&&(C+=_*_),C}function R(e,t,r){for(var i=!0,n=r.getChildren(),o=0,a=n.length;a>o;++o){var s=n[o];e._tileReplacementQueue.markTileRendered(s),s.state!==S.READY&&L(e,s),s.isRenderable||(i=!1)}return i}function L(e,t){e._tileLoadQueue.push(t)
}function z(e,t){var r=e._tileLoadQueue,i=e._terrainProvider,n=e._imageryLayerCollection;if(0!==r.length){e._tileReplacementQueue.trimTiles(e._tileCacheSize);for(var o=Date.now(),a=e._loadQueueTimeSlice,s=o+a,l=r.length-1,u=l;u>=0;--u){var c=r[u];if(e._tileReplacementQueue.markTileRendered(c),c.processStateMachine(t,i,n),Date.now()>=s)break}}}function N(e,t){return e.distance-t.distance}function B(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])}function F(e){var t={u_center3D:function(){return this.center3D},u_tileExtent:function(){return this.tileExtent},u_modifiedModelView:function(){return this.modifiedModelView},u_dayTextures:function(){return this.dayTextures},u_dayTextureTranslationAndScale:function(){return this.dayTextureTranslationAndScale},u_dayTextureTexCoordsExtent:function(){return this.dayTextureTexCoordsExtent},u_dayTextureAlpha:function(){return this.dayTextureAlpha},u_dayTextureBrightness:function(){return this.dayTextureBrightness},u_dayTextureContrast:function(){return this.dayTextureContrast},u_dayTextureHue:function(){return this.dayTextureHue},u_dayTextureSaturation:function(){return this.dayTextureSaturation},u_dayTextureOneOverGamma:function(){return this.dayTextureOneOverGamma},u_dayIntensity:function(){return this.dayIntensity},u_southAndNorthLatitude:function(){return this.southAndNorthLatitude},u_southMercatorYLowAndHighAndOneOverHeight:function(){return this.southMercatorYLowAndHighAndOneOverHeight},u_waterMask:function(){return this.waterMask},u_waterMaskTranslationAndScale:function(){return this.waterMaskTranslationAndScale},center3D:void 0,modifiedModelView:new d,tileExtent:new a,dayTextures:[],dayTextureTranslationAndScale:[],dayTextureTexCoordsExtent:[],dayTextureAlpha:[],dayTextureBrightness:[],dayTextureContrast:[],dayTextureHue:[],dayTextureSaturation:[],dayTextureOneOverGamma:[],dayIntensity:0,southAndNorthLatitude:new n,southMercatorYLowAndHighAndOneOverHeight:new o,waterMask:void 0,waterMaskTranslationAndScale:new a};return B(t,e),t}function V(e,r,n,s,l,u,c,h){for(var p=n.camera.viewMatrix,C=r.getMaximumTextureImageUnits(),x=e._tileCommands,S=e._tileCommandUniformMaps,E=-1,b=e._tilesToRenderByTextureCount,T=0,A=b.length;A>T;++T){var D=b[T];if(t(D)&&0!==D.length){D.sort(N);for(var P=0,M=D.length;M>P;P++){var I=D[P],O=I.center,R=K,L=0,z=0,B=0,V=0,U=0;if(n.mode!==w.SCENE3D){var W=l.project(I.extent.getSouthwest(),et),q=l.project(I.extent.getNortheast(),tt);if(R.x=W.x,R.y=W.y,R.z=q.x,R.w=q.y,n.mode!==w.MORPHING&&(O=Q,O.x=0,O.y=.5*(R.z+R.x),O.z=.5*(R.w+R.y),R.x-=O.y,R.y-=O.z,R.z-=O.y,R.w-=O.z),l instanceof f){L=I.extent.south,z=I.extent.north;var G=f.geodeticLatitudeToMercatorAngle(L),H=f.geodeticLatitudeToMercatorAngle(z);Z[0]=G,B=Z[0],V=G-Z[0],U=1/(H-G)}}var j=$;j.x=O.x,j.y=O.y,j.z=O.z,j.w=1,d.multiplyByVector(p,j,j),d.setColumn(p,3,j,J);var Y=I.imagery,X=0,rt=Y.length;do{var it=0;++E;var nt=x[E];t(nt)||(nt=new v,nt.owner=I,nt.cull=!1,nt.boundingVolume=new i,x[E]=nt,S[E]=F(u)),nt.owner=I,nt.debugShowBoundingVolume=I===e._debug.boundingSphereTile;var ot=S[E];ot.center3D=I.center,a.clone(R,ot.tileExtent),ot.southAndNorthLatitude.x=L,ot.southAndNorthLatitude.y=z,ot.southMercatorYLowAndHighAndOneOverHeight.x=V,ot.southMercatorYLowAndHighAndOneOverHeight.y=B,ot.southMercatorYLowAndHighAndOneOverHeight.z=U,d.clone(J,ot.modifiedModelView);for(var at=!1,st=!1,lt=!1,ut=!1,ct=!1,ht=!1;C>it&&rt>X;){var dt=Y[X],mt=dt.readyImagery;if(++X,t(mt)&&mt.state===_.READY&&0!==mt.imageryLayer.alpha){var pt=mt.imageryLayer;t(dt.textureTranslationAndScale)||(dt.textureTranslationAndScale=pt._calculateTextureTranslationAndScale(I,dt)),ot.dayTextures[it]=mt.texture,ot.dayTextureTranslationAndScale[it]=dt.textureTranslationAndScale,ot.dayTextureTexCoordsExtent[it]=dt.textureCoordinateExtent,ot.dayTextureAlpha[it]="function"==typeof pt.alpha?pt.alpha(n,pt,mt.x,mt.y,mt.level):pt.alpha,ht=ht||1!==ot.dayTextureAlpha[it],ot.dayTextureBrightness[it]="function"==typeof pt.brightness?pt.brightness(n,pt,mt.x,mt.y,mt.level):pt.brightness,at=at||ot.dayTextureBrightness[it]!==g.DEFAULT_BRIGHTNESS,ot.dayTextureContrast[it]="function"==typeof pt.contrast?pt.contrast(n,pt,mt.x,mt.y,mt.level):pt.contrast,st=st||ot.dayTextureContrast[it]!==g.DEFAULT_CONTRAST,ot.dayTextureHue[it]="function"==typeof pt.hue?pt.hue(n,pt,mt.x,mt.y,mt.level):pt.hue,lt=lt||ot.dayTextureHue[it]!==g.DEFAULT_HUE,ot.dayTextureSaturation[it]="function"==typeof pt.saturation?pt.saturation(n,pt,mt.x,mt.y,mt.level):pt.saturation,ut=ut||ot.dayTextureSaturation[it]!==g.DEFAULT_SATURATION,ot.dayTextureOneOverGamma[it]="function"==typeof pt.gamma?1/pt.gamma(n,pt,mt.x,mt.y,mt.level):1/pt.gamma,ct=ct||ot.dayTextureOneOverGamma[it]!==1/g.DEFAULT_GAMMA,++it}}ot.dayTextures.length=it,ot.waterMask=I.waterMaskTexture,a.clone(I.waterMaskTranslationAndScale,ot.waterMaskTranslationAndScale),c.push(nt),nt.shaderProgram=s.getShaderProgram(r,T,at,st,lt,ut,ct,ht),nt.renderState=h,nt.primitiveType=m.TRIANGLES,nt.vertexArray=I.vertexArray,nt.uniformMap=ot,nt.pass=y.OPAQUE,e._debug.wireframe&&(k(r,e,I),t(I.wireframeVertexArray)&&(nt.vertexArray=I.wireframeVertexArray,nt.primitiveType=m.LINES));var ft=nt.boundingVolume;n.mode!==w.SCENE3D?(i.fromExtentWithHeights2D(I.extent,n.scene2D.projection,I.minimumHeight,I.maximumHeight,ft),o.fromElements(ft.center.z,ft.center.x,ft.center.y,ft.center),n.mode===w.MORPHING&&(ft=i.union(I.boundingSphere3D,ft,ft))):i.clone(I.boundingSphere3D,ft)}while(rt>X)}}}x.length=Math.max(0,E+1)}function k(e,r,i){if(!t(i.wireframeVertexArray)&&!t(i.meshForWireframePromise)&&(i.meshForWireframePromise=i.terrainData.createMesh(r._terrainProvider.getTilingScheme(),i.x,i.y,i.level),t(i.meshForWireframePromise))){var n=i.vertexArray;E(i.meshForWireframePromise,function(t){i.vertexArray===n&&(i.wireframeVertexArray=C.createWireframeVertexArray(e,i.vertexArray,t)),i.meshForWireframePromise=void 0})}}var U=function(e){if(!t(e.terrainProvider))throw new u("options.terrainProvider is required.");if(!t(e.imageryLayerCollection))throw new u("options.imageryLayerCollection is required.");this._terrainProvider=e.terrainProvider,this._imageryLayerCollection=e.imageryLayerCollection,this._imageryLayerCollection.layerAdded.addEventListener(U.prototype._onLayerAdded,this),this._imageryLayerCollection.layerRemoved.addEventListener(U.prototype._onLayerRemoved,this),this._imageryLayerCollection.layerMoved.addEventListener(U.prototype._onLayerMoved,this),this._imageryLayerCollection.layerShownOrHidden.addEventListener(U.prototype._onLayerShownOrHidden,this),this._layerOrderChanged=!1;var r=this._terrainProvider.getTilingScheme();this._levelZeroTiles=void 0,this._tilesToRenderByTextureCount=[],this._tileCommands=[],this._tileCommandUniformMaps=[],this._tileTraversalQueue=new p,this._tileLoadQueue=[],this._tileReplacementQueue=new x,this._maximumScreenSpaceError=2,this._tileCacheSize=100,this._loadQueueTimeSlice=5;var i=r.getEllipsoid();this._ellipsoidalOccluder=new c(i,o.ZERO),this._debug={enableDebugOutput:!1,wireframe:!1,boundingSphereTile:void 0,maxDepth:0,tilesVisited:0,tilesCulled:0,tilesRendered:0,texturesRendered:0,tilesWaitingForChildren:0,lastMaxDepth:-1,lastTilesVisited:-1,lastTilesCulled:-1,lastTilesRendered:-1,lastTexturesRendered:-1,lastTilesWaitingForChildren:-1,suspendLodUpdate:!1}};U.prototype.update=function(e,t,r,i,n,o,a){T(this),A(this,e,t),z(this,e,t),V(this,e,t,n,a,i,r,o)},U.prototype.getTerrainProvider=function(){return this._terrainProvider},U.prototype.setTerrainProvider=function(e){if(this._terrainProvider!==e){if(!t(e))throw new u("terrainProvider is required.");this._terrainProvider=e;var r=this._tileReplacementQueue;r.head=void 0,r.tail=void 0,r.count=0;var i=this._levelZeroTiles;if(t(i))for(var n=0;n<i.length;++n)i[n].freeResources();this._levelZeroTiles=void 0}},U.prototype._onLayerAdded=function(e){if(t(this._levelZeroTiles)&&e.show){for(var r=this._tileReplacementQueue.head;t(r);)e._createTileImagerySkeletons(r,this._terrainProvider)&&(r.state=S.LOADING),r=r.replacementNext;this._layerOrderChanged=!0}},U.prototype._onLayerRemoved=function(e){if(t(this._levelZeroTiles))for(var r=this._tileReplacementQueue.head;t(r);){for(var i=r.imagery,n=-1,o=0,a=0,s=i.length;s>a;++a){var l=i[a],u=l.loadingImagery;if(t(u)||(u=l.readyImagery),u.imageryLayer===e)-1===n&&(n=a),l.freeResources(),++o;else if(-1!==n)break}-1!==n&&i.splice(n,o),e.isBaseLayer()&&(r.isRenderable=!1),r=r.replacementNext}},U.prototype._onLayerMoved=function(){t(this._levelZeroTiles)&&(this._layerOrderChanged=!0)},U.prototype._onLayerShownOrHidden=function(e,r,i){t(this._levelZeroTiles)&&(i?this._onLayerAdded(e,r):this._onLayerRemoved(e,r))},U.prototype.isDestroyed=function(){return!1},U.prototype.destroy=function(){var e=this._levelZeroTiles;if(t(e))for(var i=0;i<e.length;++i)e[i].freeResources();return this._imageryLayerCollection.destroy(),r(this)};var W=new s,q=new i,G=new o,H=new o,j=o.negate(o.UNIT_Y),Y=o.negate(o.UNIT_Z),X=new o;U.prototype.debugShowBoundingSphereOfTileAt=function(e){for(var r,i,n=this._tilesToRenderByTextureCount,a=0;a<n.length&&!t(r);++a){var s=n[a];if(t(s))for(var l=0;l<s.length;++l)if(i=s[l],i.extent.contains(e)){r=i;break}}t(r)&&console.log("x: "+r.x+" y: "+r.y+" level: "+r.level+" radius: "+r.boundingSphere3D.radius+" center magnitude: "+o.magnitude(r.boundingSphere3D.center)),this._debug.boundingSphereTile=r},U.prototype.debugToggleLodUpdate=function(){this._debug.suspendLodUpdate=!this._debug.suspendLodUpdate};var Z=l.supportsTypedArrays()?new Float32Array(1):void 0,J=new d,K=new a,Q=new o,$=new a,et=new o,tt=new o;return U}),r("Scene/CentralBodySurfaceShaderSet",["../Core/defined","../Core/destroyObject","../Core/defaultValue"],function(e,t){"use strict";function r(e){this.baseVertexShaderString=void 0,this.baseFragmentShaderString=void 0,this._attributeIndices=e,this._shaders={}}function i(e,t,r,i,n,o,a){var s="";return s+=e,t&&(s+="_brightness"),r&&(s+="_contrast"),i&&(s+="_hue"),n&&(s+="_saturation"),o&&(s+="_gamma"),a&&(s+="_alpha"),s}return r.prototype.invalidateShaders=function(){var e=this._shaders;for(var t in e)e.hasOwnProperty(t)&&e[t].release();this._shaders={}},r.prototype.getShaderProgram=function(t,r,n,o,a,s,l,u){var c=i(r,n,o,a,s,l,u),h=this._shaders[c];if(!e(h)){for(var d=this.baseVertexShaderString,m=(n?"#define APPLY_BRIGHTNESS\n":"")+(o?"#define APPLY_CONTRAST\n":"")+(a?"#define APPLY_HUE\n":"")+(s?"#define APPLY_SATURATION\n":"")+(l?"#define APPLY_GAMMA\n":"")+(u?"#define APPLY_ALPHA\n":"")+"#define TEXTURE_UNITS "+r+"\n"+this.baseFragmentShaderString+"\n"+"vec3 computeDayColor(vec3 initialColor, vec2 textureCoordinates)\n"+"{\n"+"    vec3 color = initialColor;\n",p=0;r>p;++p)m+="color = sampleAndBlend(\n   color,\n   u_dayTextures["+p+"],\n"+"   textureCoordinates,\n"+"   u_dayTextureTexCoordsExtent["+p+"],\n"+"   u_dayTextureTranslationAndScale["+p+"],\n"+(u?"   u_dayTextureAlpha["+p+"],\n":"1.0,\n")+(n?"   u_dayTextureBrightness["+p+"],\n":"0.0,\n")+(o?"   u_dayTextureContrast["+p+"],\n":"0.0,\n")+(a?"   u_dayTextureHue["+p+"],\n":"0.0,\n")+(s?"   u_dayTextureSaturation["+p+"],\n":"0.0,\n")+(l?"   u_dayTextureOneOverGamma["+p+"]);\n":"0.0);\n");m+="    return color;\n}",h=t.getShaderCache().getShaderProgram(d,m,this._attributeIndices),this._shaders[c]=h}return h},r.prototype.destroy=function(){return this.invalidateShaders(),t(this)},r}),r("Scene/EllipsoidTerrainProvider",["../Core/defaultValue","../Core/defined","../Core/Ellipsoid","../Core/Event","./HeightmapTerrainData","./TerrainProvider","./GeographicTilingScheme"],function(e,t,r,i,n,o,a){"use strict";var s=function(s){s=e(s,{}),this._tilingScheme=s.tilingScheme,t(this._tilingScheme)||(this._tilingScheme=new a({ellipsoid:e(s.ellipsoid,r.WGS84)})),this._levelZeroMaximumGeometricError=o.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.getEllipsoid(),64,this._tilingScheme.getNumberOfXTilesAtLevel(0));var l=16,u=16;this._terrainData=new n({buffer:new Uint8Array(l*u),width:16,height:16}),this._errorEvent=new i};return s.prototype.requestTileGeometry=function(){return this._terrainData},s.prototype.getErrorEvent=function(){return this._errorEvent},s.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},s.prototype.getCredit=function(){return void 0},s.prototype.getTilingScheme=function(){return this._tilingScheme},s.prototype.hasWaterMask=function(){return!1},s.prototype.isReady=function(){return!0},s}),r("Scene/ImageryLayerCollection",["../Core/DeveloperError","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/Event","../Core/Math","./ImageryLayer"],function(e,t,r,i,n,o,a){"use strict";function s(t,i){if(!r(i))throw new e("layer is required.");var n=t.indexOf(i);if(-1===n)throw new e("layer is not in this collection.");return n}function l(e,t,r){var i=e._layers;if(t=o.clamp(t,0,i.length-1),r=o.clamp(r,0,i.length-1),t!==r){var n=i[t];i[t]=i[r],i[r]=n,e._update(),e.layerMoved.raiseEvent(n,r,t)}}var u=function(){this._layers=[],this.layerAdded=new n,this.layerRemoved=new n,this.layerMoved=new n,this.layerShownOrHidden=new n};return u.prototype.add=function(t,i){if(!r(t))throw new e("layer is required.");if(r(i)){if(0>i)throw new e("index must be greater than or equal to zero.");if(i>this._layers.length)throw new e("index must be less than or equal to the number of layers.");this._layers.splice(i,0,t)}else i=this._layers.length,this._layers.push(t);this._update(),this.layerAdded.raiseEvent(t,i)},u.prototype.addImageryProvider=function(t,i){if(!r(t))throw new e("imageryProvider is required.");var n=new a(t);return this.add(n,i),n},u.prototype.remove=function(e,r){r=t(r,!0);var i=this._layers.indexOf(e);return-1!==i?(this._layers.splice(i,1),this._update(),this.layerRemoved.raiseEvent(e,i),r&&e.destroy(),!0):!1},u.prototype.removeAll=function(e){e=t(e,!0);for(var r=this._layers,i=0,n=r.length;n>i;i++){var o=r[i];this.layerRemoved.raiseEvent(o,i),e&&o.destroy()}this._layers=[]},u.prototype.contains=function(e){return-1!==this.indexOf(e)},u.prototype.indexOf=function(e){return this._layers.indexOf(e)},u.prototype.get=function(t){if(!r(t))throw new e("index is required.","index");return this._layers[t]},u.prototype.getLength=function(){return this._layers.length},u.prototype.raise=function(e){var t=s(this._layers,e);l(this,t,t+1)},u.prototype.lower=function(e){var t=s(this._layers,e);l(this,t,t-1)},u.prototype.raiseToTop=function(e){var t=s(this._layers,e);t!==this._layers.length-1&&(this._layers.splice(t,1),this._layers.push(e),this._update(),this.layerMoved.raiseEvent(e,this._layers.length-1,t))},u.prototype.lowerToBottom=function(e){var t=s(this._layers,e);0!==t&&(this._layers.splice(t,1),this._layers.splice(0,0,e),this._update(),this.layerMoved.raiseEvent(e,0,t))},u.prototype.isDestroyed=function(){return!1},u.prototype.destroy=function(){return this.removeAll(!0),i(this)},u.prototype._update=function(){for(var e,t,i=!0,n=this._layers,o=0,a=n.length;a>o;++o)t=n[o],t._layerIndex=o,t.show?(t._isBaseLayer=i,i=!1):t._isBaseLayer=!1,t.show!==t._show&&(r(t._show)&&(r(e)||(e=[]),e.push(t)),t._show=t.show);if(r(e))for(o=0,a=e.length;a>o;++o)t=e[o],this.layerShownOrHidden.raiseEvent(t,t._layerIndex,t.show)},u}),r("Shaders/CentralBodyFS",[],function(){"use strict";return"#if TEXTURE_UNITS > 0\nuniform sampler2D u_dayTextures[TEXTURE_UNITS];\nuniform vec4 u_dayTextureTranslationAndScale[TEXTURE_UNITS];\n#ifdef APPLY_ALPHA\nuniform float u_dayTextureAlpha[TEXTURE_UNITS];\n#endif\n#ifdef APPLY_BRIGHTNESS\nuniform float u_dayTextureBrightness[TEXTURE_UNITS];\n#endif\n#ifdef APPLY_CONTRAST\nuniform float u_dayTextureContrast[TEXTURE_UNITS];\n#endif\n#ifdef APPLY_HUE\nuniform float u_dayTextureHue[TEXTURE_UNITS];\n#endif\n#ifdef APPLY_SATURATION\nuniform float u_dayTextureSaturation[TEXTURE_UNITS];\n#endif\n#ifdef APPLY_GAMMA\nuniform float u_dayTextureOneOverGamma[TEXTURE_UNITS];\n#endif\nuniform vec4 u_dayTextureTexCoordsExtent[TEXTURE_UNITS];\n#endif\n#ifdef SHOW_REFLECTIVE_OCEAN\nuniform sampler2D u_waterMask;\nuniform vec4 u_waterMaskTranslationAndScale;\nuniform float u_zoomedOutOceanSpecularIntensity;\n#endif\n#ifdef SHOW_OCEAN_WAVES\nuniform sampler2D u_oceanNormalMap;\n#endif\n#ifdef ENABLE_LIGHTING\nuniform vec2 u_lightingFadeDistance;\n#endif\nvarying vec3 v_positionMC;\nvarying vec3 v_positionEC;\nvarying vec2 v_textureCoordinates;\nvec3 sampleAndBlend(\nvec3 previousColor,\nsampler2D texture,\nvec2 tileTextureCoordinates,\nvec4 textureCoordinateExtent,\nvec4 textureCoordinateTranslationAndScale,\nfloat textureAlpha,\nfloat textureBrightness,\nfloat textureContrast,\nfloat textureHue,\nfloat textureSaturation,\nfloat textureOneOverGamma)\n{\nvec2 alphaMultiplier = step(textureCoordinateExtent.st, tileTextureCoordinates);\ntextureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;\nalphaMultiplier = step(vec2(0.0), textureCoordinateExtent.pq - tileTextureCoordinates);\ntextureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;\nvec2 translation = textureCoordinateTranslationAndScale.xy;\nvec2 scale = textureCoordinateTranslationAndScale.zw;\nvec2 textureCoordinates = tileTextureCoordinates * scale + translation;\nvec4 sample = texture2D(texture, textureCoordinates);\nvec3 color = sample.rgb;\nfloat alpha = sample.a;\n#ifdef APPLY_BRIGHTNESS\ncolor = mix(vec3(0.0), color, textureBrightness);\n#endif\n#ifdef APPLY_CONTRAST\ncolor = mix(vec3(0.5), color, textureContrast);\n#endif\n#ifdef APPLY_HUE\ncolor = czm_hue(color, textureHue);\n#endif\n#ifdef APPLY_SATURATION\ncolor = czm_saturation(color, textureSaturation);\n#endif\n#ifdef APPLY_GAMMA\ncolor = pow(color, vec3(textureOneOverGamma));\n#endif\nreturn mix(previousColor, color, alpha * textureAlpha);\n}\nvec3 computeDayColor(vec3 initialColor, vec2 textureCoordinates);\nvec4 computeWaterColor(vec3 positionEyeCoordinates, vec2 textureCoordinates, mat3 enuToEye, vec3 imageryColor, float specularMapValue);\nvoid main()\n{\nvec3 initialColor = vec3(0.0, 0.0, 0.5);\nvec3 startDayColor = computeDayColor(initialColor, clamp(v_textureCoordinates, 0.0, 1.0));\n#ifdef SHOW_TILE_BOUNDARIES\nif (v_textureCoordinates.x < (1.0/256.0) || v_textureCoordinates.x > (255.0/256.0) ||\nv_textureCoordinates.y < (1.0/256.0) || v_textureCoordinates.y > (255.0/256.0))\n{\nstartDayColor = vec3(1.0, 0.0, 0.0);\n}\n#endif\nvec4 color = vec4(startDayColor, 1.0);\n#if defined(SHOW_REFLECTIVE_OCEAN) || defined(ENABLE_LIGHTING)\nvec3 normalMC = normalize(czm_geodeticSurfaceNormal(v_positionMC, vec3(0.0), vec3(1.0)));\nvec3 normalEC = normalize(czm_normal3D * normalMC);\n#endif\n#ifdef SHOW_REFLECTIVE_OCEAN\nvec2 waterMaskTranslation = u_waterMaskTranslationAndScale.xy;\nvec2 waterMaskScale = u_waterMaskTranslationAndScale.zw;\nvec2 waterMaskTextureCoordinates = v_textureCoordinates * waterMaskScale + waterMaskTranslation;\nfloat mask = texture2D(u_waterMask, waterMaskTextureCoordinates).r;\nif (mask > 0.0)\n{\nmat3 enuToEye = czm_eastNorthUpToEyeCoordinates(v_positionMC, normalEC);\nvec2 ellipsoidTextureCoordinates = czm_ellipsoidWgs84TextureCoordinates(normalMC);\nvec2 ellipsoidFlippedTextureCoordinates = czm_ellipsoidWgs84TextureCoordinates(normalMC.zyx);\nvec2 textureCoordinates = mix(ellipsoidTextureCoordinates, ellipsoidFlippedTextureCoordinates, czm_morphTime * smoothstep(0.9, 0.95, normalMC.z));\ncolor = computeWaterColor(v_positionEC, textureCoordinates, enuToEye, startDayColor, mask);\n}\n#endif\n#ifdef ENABLE_LIGHTING\nfloat diffuseIntensity = clamp(czm_getLambertDiffuse(czm_sunDirectionEC, normalEC) * 5.0 + 0.3, 0.0, 1.0);\nfloat cameraDist = length(czm_view[3]);\nfloat fadeOutDist = u_lightingFadeDistance.x;\nfloat fadeInDist = u_lightingFadeDistance.y;\nfloat t = clamp((cameraDist - fadeOutDist) / (fadeInDist - fadeOutDist), 0.0, 1.0);\ndiffuseIntensity = mix(1.0, diffuseIntensity, t);\ngl_FragColor = vec4(color.rgb * diffuseIntensity, color.a);\n#else\ngl_FragColor = color;\n#endif\n}\n#ifdef SHOW_REFLECTIVE_OCEAN\nfloat waveFade(float edge0, float edge1, float x)\n{\nfloat y = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);\nreturn pow(1.0 - y, 5.0);\n}\nconst float oceanFrequency = 125000.0;\nconst float oceanAnimationSpeed = 0.006;\nconst float oceanAmplitude = 2.0;\nconst float oceanSpecularIntensity = 0.5;\nvec4 computeWaterColor(vec3 positionEyeCoordinates, vec2 textureCoordinates, mat3 enuToEye, vec3 imageryColor, float specularMapValue)\n{\nfloat time = czm_frameNumber * oceanAnimationSpeed;\nvec3 positionToEyeEC = -positionEyeCoordinates;\nfloat positionToEyeECLength = length(positionToEyeEC);\nvec3 normalizedpositionToEyeEC = normalize(normalize(positionToEyeEC));\nfloat waveIntensity = waveFade(70000.0, 1000000.0, positionToEyeECLength);\n#ifdef SHOW_OCEAN_WAVES\nvec4 noise = czm_getWaterNoise(u_oceanNormalMap, textureCoordinates * oceanFrequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / oceanAmplitude));\nnormalTangentSpace.xy *= waveIntensity;\nnormalTangentSpace = normalize(normalTangentSpace);\n#else\nvec3 normalTangentSpace = vec3(0.0, 0.0, 1.0);\n#endif\nvec3 normalEC = enuToEye * normalTangentSpace;\nconst vec3 waveHighlightColor = vec3(0.3, 0.45, 0.6);\nfloat diffuseIntensity = czm_getLambertDiffuse(czm_sunDirectionEC, normalEC);\nvec3 diffuseHighlight = waveHighlightColor * diffuseIntensity;\n#ifdef SHOW_OCEAN_WAVES\nfloat tsPerturbationRatio = normalTangentSpace.z;\nvec3 nonDiffuseHighlight = mix(waveHighlightColor * 5.0 * (1.0 - tsPerturbationRatio), vec3(0.0), diffuseIntensity);\n#else\nvec3 nonDiffuseHighlight = vec3(0.0);\n#endif\nfloat specularIntensity = czm_getSpecular(czm_sunDirectionEC, normalizedpositionToEyeEC, normalEC, 10.0) + 0.25 * czm_getSpecular(czm_moonDirectionEC, normalizedpositionToEyeEC, normalEC, 10.0);\nfloat surfaceReflectance = mix(0.0, mix(u_zoomedOutOceanSpecularIntensity, oceanSpecularIntensity, waveIntensity), specularMapValue);\nfloat specular = specularIntensity * surfaceReflectance;\nreturn vec4(imageryColor + diffuseHighlight + nonDiffuseHighlight + specular, 1.0);\n}\n#endif\n"}),r("Shaders/CentralBodyFSDepth",[],function(){"use strict";return"varying vec4 positionEC;\nvoid main()\n{\nczm_ellipsoid ellipsoid = czm_getWgs84EllipsoidEC();\nvec3 direction = normalize(positionEC.xyz);\nczm_ray ray = czm_ray(vec3(0.0), direction);\nczm_raySegment intersection = czm_rayEllipsoidIntersectionInterval(ray, ellipsoid);\nif (!czm_isEmpty(intersection))\n{\ngl_FragColor = vec4(1.0, 1.0, 0.0, 1.0);\n}\nelse\n{\ndiscard;\n}\n}\n"}),r("Shaders/CentralBodyFSPole",[],function(){"use strict";return"uniform vec3 u_color;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\nczm_ellipsoid ellipsoid = czm_getWgs84EllipsoidEC();\nvec3 direction = normalize(czm_windowToEyeCoordinates(gl_FragCoord).xyz);\nczm_ray ray = czm_ray(vec3(0.0), direction);\nczm_raySegment intersection = czm_rayEllipsoidIntersectionInterval(ray, ellipsoid);\nif (!czm_isEmpty(intersection))\n{\nvec3 positionEC = czm_pointAlongRay(ray, intersection.start);\nvec3 positionMC = (czm_inverseModelView * vec4(positionEC, 1.0)).xyz;\nvec3 normalMC = normalize(czm_geodeticSurfaceNormal(positionMC, vec3(0.0), vec3(1.0)));\nvec3 normalEC = normalize(czm_normal * normalMC);\nvec3 startDayColor = u_color;\ngl_FragColor = vec4(startDayColor, 1.0);\n}\nelse\n{\ndiscard;\n}\n}\n"}),r("Shaders/CentralBodyVS",[],function(){"use strict";return"attribute vec4 position3DAndHeight;\nattribute vec2 textureCoordinates;\nuniform vec3 u_center3D;\nuniform mat4 u_modifiedModelView;\nuniform vec4 u_tileExtent;\nuniform vec2 u_southAndNorthLatitude;\nuniform vec3 u_southMercatorYLowAndHighAndOneOverHeight;\nvarying vec3 v_positionMC;\nvarying vec3 v_positionEC;\nvarying vec2 v_textureCoordinates;\nvec4 getPosition(vec3 position3DWC);\nfloat get2DYPositionFraction();\nvec4 getPosition3DMode(vec3 position3DWC)\n{\nreturn czm_projection * (u_modifiedModelView * vec4(position3DAndHeight.xyz, 1.0));\n}\nfloat get2DMercatorYPositionFraction()\n{\nconst float maxTileWidth = 0.003068;\nfloat positionFraction = textureCoordinates.y;\nfloat southLatitude = u_southAndNorthLatitude.x;\nfloat northLatitude = u_southAndNorthLatitude.y;\nif (northLatitude - southLatitude > maxTileWidth)\n{\nfloat southMercatorYLow = u_southMercatorYLowAndHighAndOneOverHeight.x;\nfloat southMercatorYHigh = u_southMercatorYLowAndHighAndOneOverHeight.y;\nfloat oneOverMercatorHeight = u_southMercatorYLowAndHighAndOneOverHeight.z;\nfloat currentLatitude = mix(southLatitude, northLatitude, textureCoordinates.y);\ncurrentLatitude = clamp(currentLatitude, -czm_webMercatorMaxLatitude, czm_webMercatorMaxLatitude);\npositionFraction = czm_latitudeToWebMercatorFraction(currentLatitude, southMercatorYLow, southMercatorYHigh, oneOverMercatorHeight);\n}\nreturn positionFraction;\n}\nfloat get2DGeographicYPositionFraction()\n{\nreturn textureCoordinates.y;\n}\nvec4 getPositionPlanarEarth(vec3 position3DWC, float height2D)\n{\nfloat yPositionFraction = get2DYPositionFraction();\nvec4 rtcPosition2D = vec4(height2D, mix(u_tileExtent.st, u_tileExtent.pq, vec2(textureCoordinates.x, yPositionFraction)), 1.0);\nreturn czm_projection * (u_modifiedModelView * rtcPosition2D);\n}\nvec4 getPosition2DMode(vec3 position3DWC)\n{\nreturn getPositionPlanarEarth(position3DWC, 0.0);\n}\nvec4 getPositionColumbusViewMode(vec3 position3DWC)\n{\nreturn getPositionPlanarEarth(position3DWC, position3DAndHeight.w);\n}\nvec4 getPositionMorphingMode(vec3 position3DWC)\n{\nfloat yPositionFraction = get2DYPositionFraction();\nvec4 position2DWC = vec4(0.0, mix(u_tileExtent.st, u_tileExtent.pq, vec2(textureCoordinates.x, yPositionFraction)), 1.0);\nvec4 morphPosition = czm_columbusViewMorph(position2DWC, vec4(position3DWC, 1.0), czm_morphTime);\nreturn czm_modelViewProjection * morphPosition;\n}\nvoid main()\n{\nvec3 position3DWC = position3DAndHeight.xyz + u_center3D;\ngl_Position = getPosition(position3DWC);\n#if defined(SHOW_REFLECTIVE_OCEAN) || defined(ENABLE_LIGHTING)\nv_positionEC = (czm_modelView3D * vec4(position3DWC, 1.0)).xyz;\nv_positionMC = position3DWC;\n#endif\nv_textureCoordinates = textureCoordinates;\n}\n"}),r("Shaders/CentralBodyVSDepth",[],function(){"use strict";return"attribute vec4 position;\nvarying vec4 positionEC;\nvoid main()\n{\npositionEC = czm_modelView * position;\ngl_Position = czm_projection * positionEC;\n}\n"}),r("Shaders/CentralBodyVSPole",[],function(){"use strict";return"attribute vec4 position;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\nfloat x = (position.x - czm_viewport.x) / czm_viewport.z;\nfloat y = (position.y - czm_viewport.y) / czm_viewport.w;\nv_textureCoordinates = vec2(x, y);\ngl_Position = czm_viewportOrthographic * position;\n}\n"}),r("Scene/CentralBody",["../Core/buildModuleUrl","../Core/combine","../Core/loadImage","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/BoundingRectangle","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/ComponentDatatype","../Core/Ellipsoid","../Core/Extent","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/Intersect","../Core/Math","../Core/Matrix4","../Core/Occluder","../Core/PrimitiveType","../Core/Transforms","../Renderer/BufferUsage","../Renderer/ClearCommand","../Renderer/DepthFunction","../Renderer/DrawCommand","../Renderer/createShaderSource","../Renderer/Pass","./CentralBodySurface","./CentralBodySurfaceShaderSet","./EllipsoidTerrainProvider","./ImageryLayerCollection","./SceneMode","./TerrainProvider","../Shaders/CentralBodyFS","../Shaders/CentralBodyFSDepth","../Shaders/CentralBodyFSPole","../Shaders/CentralBodyVS","../Shaders/CentralBodyVSDepth","../Shaders/CentralBodyVSPole","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_,w,C,x,S,E,b,T,A,D,P,M,I,O,R,L,z,N,B,F,V,k,U,W){"use strict";function q(e,t){var r=e._ellipsoid.getRadii(),i=t.camera.positionWC,n=u.multiplyComponents(e._ellipsoid.getOneOverRadii(),i,Z),o=u.magnitude(n),a=u.normalize(n,J),s=u.normalize(u.cross(u.UNIT_Z,n,K),K),l=u.normalize(u.cross(a,s,Q),Q),c=Math.sqrt(u.magnitudeSquared(n)-1),h=u.multiplyByScalar(a,1/o,Z),d=c/o,m=u.multiplyByScalar(s,d,J),p=u.multiplyByScalar(l,d,K),f=u.add(h,p,Q);u.subtract(f,m,f),u.multiplyComponents(r,f,f),u.pack(f,X,0);var v=u.subtract(h,p,Q);u.subtract(v,m,v),u.multiplyComponents(r,v,v),u.pack(v,X,3);var y=u.add(h,p,Q);u.add(y,m,y),u.multiplyComponents(r,y,y),u.pack(y,X,6);var g=u.subtract(h,p,Q);return u.add(g,m,g),u.multiplyComponents(r,g,g),u.pack(g,X,9),X}function G(e,t,r,i,n,o){var s,l=e._ellipsoid.cartographicToCartesian(new c(0,i)),h=e._ellipsoid.cartographicToCartesian(new c(Math.PI,i)),d=.5*u.magnitude(u.subtract(l,h)),m=e._ellipsoid.cartographicToCartesian(new c(0,r)),p=t.camera.direction;s=1-u.dot(u.negate(u.UNIT_Z),p)<_.EPSILON6?u.UNIT_X:u.normalize(u.cross(p,u.UNIT_Z));var f=u.add(m,u.multiplyByScalar(s,d)),v=u.add(m,u.multiplyByScalar(u.normalize(u.cross(u.UNIT_Z,s)),d));S.pointToWindowCoordinates(n,o,m,m),S.pointToWindowCoordinates(n,o,f,f),S.pointToWindowCoordinates(n,o,v,v);var y=Math.floor(Math.max(u.distance(v,m),u.distance(f,m))),g=y;return new a(Math.floor(m.x)-y,Math.floor(m.y)-g,2*y,2*g)}function H(e,r,i){var o=e._surface._terrainProvider;if(i.mode===L.SCENE3D&&o.isReady()){var a=o.getTilingScheme().getExtent(),l=r.getUniformState().getViewProjection(),u=$;u.width=r.getDrawingBufferWidth(),u.height=r.getDrawingBufferHeight();var c,d,p,f,x,S,b,T=w.computeViewportTransformation(u,0,1,et),A=.05,D=e._occluder;a.north<_.PI_OVER_TWO&&(c=new m(-Math.PI,a.north,Math.PI,_.PI_OVER_TWO),d=s.fromExtent3D(c,e._ellipsoid),p=i.cullingVolume.getVisibility(d)===g.OUTSIDE,f=C.computeOccludeePointFromExtent(c,e._ellipsoid),x=f&&!D.isPointVisible(f,0)||!D.isBoundingSphereVisible(d),e._drawNorthPole=!p&&!x,e._drawNorthPole&&(b=G(e,i,c.north,c.south-A,l,T),tt[0]=b.x,tt[1]=b.y,tt[2]=b.x+b.width,tt[3]=b.y,tt[4]=b.x+b.width,tt[5]=b.y+b.height,tt[6]=b.x,tt[7]=b.y+b.height,n(e._northPoleCommand.vertexArray)?e._northPoleCommand.vertexArray.getAttribute(0).vertexBuffer.copyFromArrayView(tt):(e._northPoleCommand.boundingVolume=s.fromExtent3D(c,e._ellipsoid),S=new v({attributes:{position:new y({componentDatatype:h.FLOAT,componentsPerAttribute:2,values:tt})}}),e._northPoleCommand.vertexArray=r.createVertexArrayFromGeometry({geometry:S,attributeIndices:{position:0},bufferUsage:E.STREAM_DRAW})))),a.south>-_.PI_OVER_TWO&&(c=new m(-Math.PI,-_.PI_OVER_TWO,Math.PI,a.south),d=s.fromExtent3D(c,e._ellipsoid),p=i.cullingVolume.getVisibility(d)===g.OUTSIDE,f=C.computeOccludeePointFromExtent(c,e._ellipsoid),x=f&&!D.isPointVisible(f)||!D.isBoundingSphereVisible(d),e._drawSouthPole=!p&&!x,e._drawSouthPole&&(b=G(e,i,c.south,c.north+A,l,T),tt[0]=b.x,tt[1]=b.y,tt[2]=b.x+b.width,tt[3]=b.y,tt[4]=b.x+b.width,tt[5]=b.y+b.height,tt[6]=b.x,tt[7]=b.y+b.height,n(e._southPoleCommand.vertexArray)?e._southPoleCommand.vertexArray.getAttribute(0).vertexBuffer.copyFromArrayView(tt):(e._southPoleCommand.boundingVolume=s.fromExtent3D(c,e._ellipsoid),S=new v({attributes:{position:new y({componentDatatype:h.FLOAT,componentsPerAttribute:2,values:tt})}}),e._southPoleCommand.vertexArray=r.createVertexArrayFromGeometry({geometry:S,attributeIndices:{position:0},bufferUsage:E.STREAM_DRAW}))));var P=0,M=e._imageryLayerCollection.getLength()>0?e._imageryLayerCollection.get(0):void 0;n(M)&&n(M.getImageryProvider())&&n(M.getImageryProvider().getPoleIntensity)&&(P=M.getImageryProvider().getPoleIntensity());var I={u_dayIntensity:function(){return P}},O=e;if(!n(e._northPoleCommand.uniformMap)){var R=t([I,{u_color:function(){return O.northPoleColor}}],!1,!1);e._northPoleCommand.uniformMap=t([R,e._drawUniforms],!1,!1)}if(!n(e._southPoleCommand.uniformMap)){var z=t([I,{u_color:function(){return O.southPoleColor}}],!1,!1);e._southPoleCommand.uniformMap=t([z,e._drawUniforms],!1,!1)}}}function j(e,t){var r=t.creditDisplay,i=e._surface._terrainProvider.getCredit();n(i)&&r.addCredit(i);for(var o=e._imageryLayerCollection,a=0,s=o.getLength();s>a;++a){var l=o.get(a);
l.show&&(i=l.getImageryProvider().getCredit(),n(i)&&r.addCredit(i))}}var Y=function(t){t=i(t,d.WGS84);var r=new O({ellipsoid:t}),n=new R;this.terrainProvider=r,this._ellipsoid=t,this._imageryLayerCollection=n,this._surface=new M({terrainProvider:r,imageryLayerCollection:n}),this._occluder=new C(new s(u.ZERO,t.getMinimumRadius()),u.ZERO),this._surfaceShaderSet=new I(z.attributeIndices),this._rsColor=void 0,this._rsColorWithoutDepthTest=void 0;var o=new b;o.depth=1,o.stencil=0,o.owner=this,this._clearDepthCommand=o,this._depthCommand=new A,this._depthCommand.primitiveType=x.TRIANGLES,this._depthCommand.boundingVolume=new s(u.ZERO,t.getMaximumRadius()),this._depthCommand.pass=P.OPAQUE,this._depthCommand.owner=this,this._northPoleCommand=new A,this._northPoleCommand.primitiveType=x.TRIANGLE_FAN,this._northPoleCommand.pass=P.OPAQUE,this._northPoleCommand.owner=this,this._southPoleCommand=new A,this._southPoleCommand.primitiveType=x.TRIANGLE_FAN,this._southPoleCommand.pass=P.OPAQUE,this._southPoleCommand.owner=this,this._drawNorthPole=!1,this._drawSouthPole=!1,this.northPoleColor=new u(2/255,6/255,18/255),this.southPoleColor=new u(1,1,1),this.show=!0,this._mode=L.SCENE3D,this._projection=void 0,this.oceanNormalMapUrl=e("Assets/Textures/waterNormalsSmall.jpg"),this.depthTestAgainstTerrain=!1,this.maximumScreenSpaceError=2,this.tileCacheSize=100,this.enableLighting=!1,this._enableLighting=!1,this.lightingFadeOutDistance=65e5,this.lightingFadeInDistance=9e6,this._lastOceanNormalMapUrl=void 0,this._oceanNormalMap=void 0,this._zoomedOutOceanSpecularIntensity=.5,this._showingPrettyOcean=!1,this._hasWaterMask=!1,this._lightingFadeDistance=new l(this.lightingFadeOutDistance,this.lightingFadeInDistance);var a=this;this._drawUniforms={u_zoomedOutOceanSpecularIntensity:function(){return a._zoomedOutOceanSpecularIntensity},u_oceanNormalMap:function(){return a._oceanNormalMap},u_lightingFadeDistance:function(){return a._lightingFadeDistance}}};Y.prototype.getEllipsoid=function(){return this._ellipsoid},Y.prototype.getImageryLayers=function(){return this._imageryLayerCollection};var X=p.supportsTypedArrays()?new Float32Array(12):[],Z=new u,J=new u,K=new u,Q=new u,$=new a,et=new w,tt=p.supportsTypedArrays()?new Float32Array(8):[];return Y.prototype.update=function(e,t,i){if(this.show){var o=e.getDrawingBufferWidth(),a=e.getDrawingBufferHeight();if(0!==o&&0!==a){var s=t.mode,l=t.scene2D.projection,u=!1;this._mode===s&&n(this._rsColor)||(u=!0,s===L.SCENE3D||s===L.COLUMBUS_VIEW?(this._rsColor=e.createRenderState({cull:{enabled:!0},depthTest:{enabled:!0}}),this._rsColorWithoutDepthTest=e.createRenderState({cull:{enabled:!0}}),this._depthCommand.renderState=e.createRenderState({cull:{enabled:!0},depthTest:{enabled:!0,func:T.ALWAYS},colorMask:{red:!1,green:!1,blue:!1,alpha:!1}})):(this._rsColor=e.createRenderState({cull:{enabled:!0}}),this._rsColorWithoutDepthTest=e.createRenderState({cull:{enabled:!0}}),this._depthCommand.renderState=e.createRenderState({cull:{enabled:!0}}))),this._northPoleCommand.renderState=this._rsColorWithoutDepthTest,this._southPoleCommand.renderState=this._rsColorWithoutDepthTest;var c=q(this,t);if(this._depthCommand.vertexArray)this._depthCommand.vertexArray.getAttribute(0).vertexBuffer.copyFromArrayView(c);else{var d=new v({attributes:{position:new y({componentDatatype:h.FLOAT,componentsPerAttribute:3,values:c})},indices:[0,1,2,2,1,3],primitiveType:x.TRIANGLES});this._depthCommand.vertexArray=e.createVertexArrayFromGeometry({geometry:d,attributeIndices:{position:0},bufferUsage:E.DYNAMIC_DRAW})}var m=e.getShaderCache();if(n(this._depthCommand.shaderProgram)||(this._depthCommand.shaderProgram=m.getShaderProgram(k,B,{position:0})),this._surface._terrainProvider.hasWaterMask()&&this.oceanNormalMapUrl!==this._lastOceanNormalMapUrl){this._lastOceanNormalMapUrl=this.oceanNormalMapUrl;var p=this;W(r(this.oceanNormalMapUrl),function(t){p._oceanNormalMap=p._oceanNormalMap&&p._oceanNormalMap.destroy(),p._oceanNormalMap=e.createTexture2D({source:t})})}var g=this._projection!==l,_=this._surface._terrainProvider.hasWaterMask(),w=this._hasWaterMask!==_,C=this._enableLighting!==this.enableLighting;if(!n(this._surfaceShaderSet)||!n(this._northPoleCommand.shaderProgram)||!n(this._southPoleCommand.shaderProgram)||u||g||w||C||n(this._oceanNormalMap)!==this._showingPrettyOcean){var S,b="vec4 getPosition(vec3 position3DWC) { return getPosition3DMode(position3DWC); }",A="vec4 getPosition(vec3 position3DWC) { return getPosition2DMode(position3DWC); }",P="vec4 getPosition(vec3 position3DWC) { return getPositionColumbusViewMode(position3DWC); }",M="vec4 getPosition(vec3 position3DWC) { return getPositionMorphingMode(position3DWC); }";switch(s){case L.SCENE3D:S=b;break;case L.SCENE2D:S=A;break;case L.COLUMBUS_VIEW:S=P;break;case L.MORPHING:S=M}var I,O="float get2DYPositionFraction() { return get2DGeographicYPositionFraction(); }",R="float get2DYPositionFraction() { return get2DMercatorYPositionFraction(); }";I=l instanceof f?O:R,this._surfaceShaderSet.baseVertexShaderString=D({defines:[_?"SHOW_REFLECTIVE_OCEAN":"",this.enableLighting?"ENABLE_LIGHTING":""],sources:[V,S,I]});var G=_&&n(this._oceanNormalMap);this._surfaceShaderSet.baseFragmentShaderString=D({defines:[_?"SHOW_REFLECTIVE_OCEAN":"",G?"SHOW_OCEAN_WAVES":"",this.enableLighting?"ENABLE_LIGHTING":""],sources:[N]}),this._surfaceShaderSet.invalidateShaders();var Y=m.replaceShaderProgram(this._northPoleCommand.shaderProgram,U,F,z.attributeIndices);this._northPoleCommand.shaderProgram=Y,this._southPoleCommand.shaderProgram=Y,this._showingPrettyOcean=n(this._oceanNormalMap),this._hasWaterMask=_,this._enableLighting=this.enableLighting}var X=t.camera.positionWC;this._occluder.setCameraPosition(X),H(this,e,t),this._mode=s,this._projection=l;var Z=t.passes;Z.render&&(s===L.SCENE3D&&(this._drawNorthPole&&i.push(this._northPoleCommand),this._drawSouthPole&&i.push(this._southPoleCommand)),this._zoomedOutOceanSpecularIntensity=s===L.SCENE3D?.5:0,this._lightingFadeDistance.x=this.lightingFadeOutDistance,this._lightingFadeDistance.y=this.lightingFadeInDistance,this._surface._maximumScreenSpaceError=this.maximumScreenSpaceError,this._surface._tileCacheSize=this.tileCacheSize,this._surface.setTerrainProvider(this.terrainProvider),this._surface.update(e,t,i,this._drawUniforms,this._surfaceShaderSet,this._rsColor,this._projection),j(this,t),(s===L.SCENE3D||s===L.COLUMBUS_VIEW)&&(this.depthTestAgainstTerrain||(i.push(this._clearDepthCommand),s===L.SCENE3D&&i.push(this._depthCommand)))),Z.pick&&i.push(this._depthCommand)}}},Y.prototype.isDestroyed=function(){return!1},Y.prototype.destroy=function(){return this._northPoleCommand.vertexArray=this._northPoleCommand.vertexArray&&this._northPoleCommand.vertexArray.destroy(),this._southPoleCommand.vertexArray=this._southPoleCommand.vertexArray&&this._southPoleCommand.vertexArray.destroy(),this._surfaceShaderSet=this._surfaceShaderSet&&this._surfaceShaderSet.destroy(),this._northPoleCommand.shaderProgram=this._northPoleCommand.shaderProgram&&this._northPoleCommand.shaderProgram.release(),this._southPoleCommand.shaderProgram=this._northPoleCommand.shaderProgram,this._depthCommand.shaderProgram=this._depthCommand.shaderProgram&&this._depthCommand.shaderProgram.release(),this._depthCommand.vertexArray=this._depthCommand.vertexArray&&this._depthCommand.vertexArray.destroy(),this._surface=this._surface&&this._surface.destroy(),this._oceanNormalMap=this._oceanNormalMap&&this._oceanNormalMap.destroy(),o(this)},Y}),r("Scene/CesiumTerrainProvider",["../Core/defaultValue","../Core/defined","../Core/loadArrayBuffer","../Core/throttleRequestByServer","../Core/DeveloperError","../Core/Event","./Credit","./GeographicTilingScheme","./HeightmapTerrainData","./TerrainProvider","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";var h=function(e){if(!t(e)||!t(e.url))throw new n("description.url is required.");this._url=e.url,this._proxy=e.proxy,this._tilingScheme=new s({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1}),this._heightmapWidth=65,this._levelZeroMaximumGeometricError=u.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.getEllipsoid(),this._heightmapWidth,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._terrainDataStructure={heightScale:.2,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1},this._errorEvent=new o;var r=e.credit;"string"==typeof r&&(r=new a(r)),this._credit=r};return h.prototype.requestTileGeometry=function(n,o,a,s){var u=this._tilingScheme.getNumberOfYTilesAtLevel(a),h=this._url+"/"+a+"/"+n+"/"+(u-o-1)+".terrain",d=this._proxy;t(d)&&(h=d.getURL(h));var m;if(s=e(s,!0)){if(m=i(h,r),!t(m))return void 0}else m=r(h);var p=this;return c(m,function(e){var t=new Uint16Array(e,0,p._heightmapWidth*p._heightmapWidth);return new l({buffer:t,childTileMask:new Uint8Array(e,t.byteLength,1)[0],waterMask:new Uint8Array(e,t.byteLength+1,e.byteLength-t.byteLength-1),width:p._heightmapWidth,height:p._heightmapWidth,structure:p._terrainDataStructure})})},h.prototype.getErrorEvent=function(){return this._errorEvent},h.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},h.prototype.getCredit=function(){return this._credit},h.prototype.getTilingScheme=function(){return this._tilingScheme},h.prototype.hasWaterMask=function(){return!0},h.prototype.isReady=function(){return!0},h}),r("Scene/CompositePrimitive",["../Core/createGuid","../Core/defined","../Core/destroyObject","../Core/DeveloperError"],function(e,t,r,i){"use strict";function n(e,t){if(!e.contains(t))throw new i("primitive is not in this composite.");return e._primitives.indexOf(t)}var o=function(){this._centralBody=void 0,this._primitives=[],this._guid=e(),this.destroyPrimitives=!0,this.show=!0};return o.prototype.getCentralBody=function(){return this._centralBody},o.prototype.setCentralBody=function(e){this._centralBody=this.destroyPrimitives&&this._centralBody&&this._centralBody.destroy(),this._centralBody=e},o.prototype.add=function(e){if(!t(e))throw new i("primitive is required.");var r=e._external=e._external||{},n=r._composites=r._composites||{};return n[this._guid]={composite:this},this._primitives.push(e),e},o.prototype.remove=function(e){if(this.contains(e)){var t=this._primitives.indexOf(e);if(-1!==t)return this._primitives.splice(t,1),delete e._external._composites[this._guid],this.destroyPrimitives&&e.destroy(),!0}return!1},o.prototype.removeAll=function(){if(this.destroyPrimitives)for(var e=this._primitives,t=e.length,r=0;t>r;++r)e[r].destroy();this._primitives=[]},o.prototype.contains=function(e){return!!(e&&e._external&&e._external._composites&&e._external._composites[this._guid])},o.prototype.raise=function(e){if(t(e)){var r=n(this,e),i=this._primitives;if(r!==i.length-1){var o=i[r];i[r]=i[r+1],i[r+1]=o}}},o.prototype.raiseToTop=function(e){if(t(e)){var r=n(this,e),i=this._primitives;r!==i.length-1&&(i.splice(r,1),i.push(e))}},o.prototype.lower=function(e){if(t(e)){var r=n(this,e),i=this._primitives;if(0!==r){var o=i[r];i[r]=i[r-1],i[r-1]=o}}},o.prototype.lowerToBottom=function(e){if(t(e)){var r=n(this,e),i=this._primitives;0!==r&&(i.splice(r,1),i.unshift(e))}},o.prototype.get=function(e){if(!t(e))throw new i("index is required.");return this._primitives[e]},o.prototype.getLength=function(){return this._primitives.length},o.prototype.update=function(e,t,r){if(this.show){this._centralBody&&this._centralBody.update(e,t,r);for(var i=this._primitives,n=i.length,o=0;n>o;++o)i[o].update(e,t,r)}},o.prototype.isDestroyed=function(){return!1},o.prototype.destroy=function(){return this.removeAll(),this._centralBody=this.destroyPrimitives&&this._centralBody&&this._centralBody.destroy(),r(this)},o}),r("Scene/CreditDisplay",["../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","./Credit"],function(e,t,r,i,n){"use strict";function o(e,r,i){if(!t(e.element)){var n=e.getText(),o=e.getLink(),a=document.createElement("span");if(e.hasLink()){var s=document.createElement("a");s.textContent=n,s.href=o,s.target="_blank",a.appendChild(s)}else a.textContent=n;a.className="cesium-credit-text",e.element=a}if(r.hasChildNodes()){var l=document.createElement("span");l.textContent=i,l.className="cesium-credit-delimiter",r.appendChild(l)}r.appendChild(e.element)}function a(e,r){if(!t(e.element)){var i=e.getText(),n=e.getLink(),o=document.createElement("span"),a=document.createElement("img");if(a.src=e.getImageUrl(),a.style["vertical-align"]="bottom",t(i)&&(a.alt=i,a.title=i),e.hasLink()){var s=document.createElement("a");s.appendChild(a),s.href=n,s.target="_blank",o.appendChild(s)}else o.appendChild(a);o.className="cesium-credit-image",e.element=o}r.appendChild(e.element)}function s(e,t){for(var r=e.length,i=0;r>i;i++){var o=e[i];if(n.equals(o,t))return!0}return!1}function l(e){var r=e.element;if(t(r)){var i=r.parentNode;if(!e.hasImage()){var n=r.previousSibling;null===n&&(n=r.nextSibling),null!==n&&i.removeChild(n)}i.removeChild(r)}}function u(e,t){var r,i,n,a=e._displayedCredits.textCredits;for(r=0;r<t.length;r++)n=t[r],i=a.indexOf(n),-1===i?o(n,e._textContainer,e._delimiter):a.splice(i,1);for(r=0;r<a.length;r++)n=a[r],l(n)}function c(e,t){var r,i,n,o=e._displayedCredits.imageCredits;for(r=0;r<t.length;r++)n=t[r],i=o.indexOf(n),-1===i?a(n,e._imageContainer):o.splice(i,1);for(r=0;r<o.length;r++)n=o[r],l(n)}var h=function(r,n){if(!t(r))throw new i("credit container is required");var o=document.createElement("span");o.className="cesium-credit-imageContainer";var a=document.createElement("span");a.className="cesium-credit-textContainer",r.appendChild(o),r.appendChild(a),this._delimiter=e(n," • "),this._container=r,this._textContainer=a,this._imageContainer=o,this._defaultImageCredits=[],this._defaultTextCredits=[],this._displayedCredits={imageCredits:[],textCredits:[]},this._currentFrameCredits={imageCredits:[],textCredits:[]}};return h.prototype.addCredit=function(e){if(!t(e))throw new i("credit must be defined");if(e.hasImage()){var r=this._currentFrameCredits.imageCredits;s(r,e)||s(this._defaultImageCredits,e)||r.push(e)}else{var n=this._currentFrameCredits.textCredits;s(n,e)||s(this._defaultTextCredits,e)||n.push(e)}},h.prototype.addDefaultCredit=function(e){if(!t(e))throw new i("credit must be defined");if(e.hasImage()){var r=this._defaultImageCredits;s(r,e)||r.push(e)}else{var n=this._defaultTextCredits;s(n,e)||n.push(e)}},h.prototype.removeDefaultCredit=function(e){if(!t(e))throw new i("credit must be defined");var r;e.hasImage()?(r=this._defaultImageCredits.indexOf(e),-1!==r&&this._defaultImageCredits.splice(r,1)):(r=this._defaultTextCredits.indexOf(e),-1!==r&&this._defaultTextCredits.splice(r,1))},h.prototype.beginFrame=function(){this._currentFrameCredits.imageCredits.length=0,this._currentFrameCredits.textCredits.length=0},h.prototype.endFrame=function(){var e=this._defaultTextCredits.concat(this._currentFrameCredits.textCredits),t=this._defaultImageCredits.concat(this._currentFrameCredits.imageCredits);u(this,e),c(this,t),this._displayedCredits.textCredits=e,this._displayedCredits.imageCredits=t},h.prototype.destroy=function(){return this._container.removeChild(this._textContainer),this._container.removeChild(this._imageContainer),r(this)},h.prototype.isDestroyed=function(){return!1},h}),r("Scene/DebugAppearance",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","./Appearance"],function(e,t,r,i){"use strict";var n=function(n){n=e(n,e.EMPTY_OBJECT);var o=n.attributeName;if(!t(o))throw new r("options.attributeName is required.");var a,s=e(n.glslDatatype,"vec3"),l="v_"+o;if("normal"===o||"binormal"===o|"tangent"===o)a="vec4 getColor() { return vec4(("+l+" + vec3(1.0)) * 0.5, 1.0); }\n";else switch("st"===o&&(s="vec2"),s){case"float":a="vec4 getColor() { return vec4(vec3("+l+"), 1.0); }\n";break;case"vec2":a="vec4 getColor() { return vec4("+l+", 0.0, 1.0); }\n";break;case"vec3":a="vec4 getColor() { return vec4("+l+", 1.0); }\n";break;case"vec4":a="vec4 getColor() { return "+l+"; }\n";break;default:throw new r("options.glslDatatype must be float, vec2, vec3, or vec4.")}var u="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute "+s+" "+o+";\n"+"varying "+s+" "+l+";\n"+"void main()\n"+"{\n"+"vec4 p = czm_translateRelativeToEye(position3DHigh, position3DLow);\n"+l+" = "+o+";\n"+"gl_Position = czm_modelViewProjectionRelativeToEye * p;\n"+"}",c="varying "+s+" "+l+";\n"+a+"\n"+"void main()\n"+"{\n"+"gl_FragColor = getColor();\n"+"}";this.material=void 0,this.vertexShaderSource=e(n.vertexShaderSource,u),this.fragmentShaderSource=e(n.fragmentShaderSource,c),this.renderState=e(n.renderState,i.getDefaultRenderState(!1,!1)),this.attributeName=o,this.glslDatatype=s,this.translucent=e(n.translucent,!1),this.closed=e(n.closed,!1)};return n.prototype.getFragmentShaderSource=i.prototype.getFragmentShaderSource,n.prototype.isTranslucent=i.prototype.isTranslucent,n.prototype.getRenderState=i.prototype.getRenderState,n}),r("Shaders/Appearances/PolylineColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec2 expandAndWidth;\nattribute vec4 color;\nvarying vec4 v_color;\nvoid main()\n{\nfloat expandDir = expandAndWidth.x;\nfloat width = abs(expandAndWidth.y) + 0.5;\nbool usePrev = expandAndWidth.y < 0.0;\nvec4 p = czm_computePosition();\nvec4 prev = czm_computePrevPosition();\nvec4 next = czm_computeNextPosition();\nv_color = color;\nvec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\ngl_Position = czm_viewportOrthographic * positionWC;\n}\n"}),r("Shaders/Appearances/PerInstanceFlatColorAppearanceFS",[],function(){"use strict";return"varying vec4 v_color;\nvoid main()\n{\ngl_FragColor = v_color;\n}\n"}),r("Scene/PolylineColorAppearance",["../Core/defaultValue","../Core/VertexFormat","./Appearance","../Renderer/createShaderSource","../Shaders/Appearances/PolylineColorAppearanceVS","../Shaders/Appearances/PerInstanceFlatColorAppearanceFS","../Shaders/PolylineCommon"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){t=e(t,e.EMPTY_OBJECT);var l=e(t.translucent,!0),u=!1,c=i({sources:[a,n]}),h=o,d=s.VERTEX_FORMAT;this.material=void 0,this.vertexShaderSource=e(t.vertexShaderSource,c),this.fragmentShaderSource=e(t.fragmentShaderSource,h),this.renderState=e(t.renderState,r.getDefaultRenderState(l,u)),this.vertexFormat=d,this.translucent=l,this.closed=u};return s.VERTEX_FORMAT=t.POSITION_ONLY,s.prototype.getFragmentShaderSource=r.prototype.getFragmentShaderSource,s.prototype.isTranslucent=r.prototype.isTranslucent,s.prototype.getRenderState=r.prototype.getRenderState,s}),r("Scene/DebugModelMatrixPrimitive",["../Core/defaultValue","../Core/defined","../Core/Cartesian3","../Core/Matrix4","../Core/Color","../Core/destroyObject","../Core/GeometryInstance","../Core/PolylineGeometry","./Primitive","./PolylineColorAppearance"],function(e,t,r,i,n,o,a,s,l,u){"use strict";var c=function(t){t=e(t,e.EMPTY_OBJECT),this.length=e(t.length,1e7),this._length=void 0,this.width=e(t.width,2),this._width=void 0,this.show=e(t.show,!0),this.modelMatrix=i.clone(e(t.modelMatrix,i.IDENTITY)),this._modelMatrix=new i,this.id=t.id,this._id=void 0,this._primitive=void 0};return c.prototype.update=function(e,o,c){this.show&&(t(this._primitive)&&i.equals(this._modelMatrix,this.modelMatrix)&&this._length===this.length&&this._width===this.width&&this._id===this.id||(this._modelMatrix=i.clone(this.modelMatrix,this._modelMatrix),this._length=this.length,this._width=this.width,this._id=this.id,t(this._primitive)&&this._primitive.destroy(),this._primitive=new l({geometryInstances:new a({geometry:s.createGeometry(new s({positions:[r.ZERO,r.UNIT_X,r.ZERO,r.UNIT_Y,r.ZERO,r.UNIT_Z],width:this.width,vertexFormat:u.VERTEX_FORMAT,colors:[n.RED,n.RED,n.GREEN,n.GREEN,n.BLUE,n.BLUE]})),modelMatrix:i.multiplyByUniformScale(this.modelMatrix,this.length),id:this.id,pickPrimitive:this}),appearance:new u,asynchronous:!1,allow3DOnly:i.equals(this.modelMatrix,i.IDENTITY)})),this._primitive.update(e,o,c))},c.prototype.isDestroyed=function(){return!1},c.prototype.destroy=function(){return this._primitive=this._primitive&&this._primitive.destroy(),o(this)},c}),r("Scene/ExtentPrimitive",["../Core/DeveloperError","../Core/defaultValue","../Core/defined","../Core/Color","../Core/destroyObject","../Core/Math","../Core/Extent","../Core/Ellipsoid","../Core/GeometryInstance","../Core/ExtentGeometry","./EllipsoidSurfaceAppearance","./Primitive","./Material"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";var m=function(e){e=t(e,t.EMPTY_OBJECT),this.ellipsoid=t(e.ellipsoid,s.WGS84),this._ellipsoid=void 0,this.extent=a.clone(e.extent),this._extent=void 0,this.granularity=t(e.granularity,o.RADIANS_PER_DEGREE),this._granularity=void 0,this.height=t(e.height,0),this._height=void 0,this.rotation=t(e.rotation,0),this._rotation=void 0,this.textureRotationAngle=t(e.textureRotationAngle,0),this._textureRotationAngle=void 0,this.show=t(e.show,!0);var r=d.fromType(d.ColorType);r.uniforms.color=new i(1,1,0,.5),this.material=t(e.material,r),this.id=e.id,this._id=void 0,this.asynchronous=t(e.asynchronous,!0),this.debugShowBoundingVolume=t(e.debugShowBoundingVolume,!1),this._primitive=void 0};return m.prototype.update=function(t,i,n){if(!r(this.ellipsoid))throw new e("this.ellipsoid must be defined.");if(!r(this.material))throw new e("this.material must be defined.");if(this.granularity<0)throw new e("this.granularity and scene2D/scene3D overrides must be greater than zero.");if(this.show&&r(this.extent)){if(!a.equals(this._extent,this.extent)||this._ellipsoid!==this.ellipsoid||this._granularity!==this.granularity||this._height!==this.height||this._rotation!==this.rotation||this._textureRotationAngle!==this.textureRotationAngle||this._id!==this.id){this._extent=a.clone(this.extent,this._extent),this._ellipsoid=this.ellipsoid,this._granularity=this.granularity,this._height=this.height,this._rotation=this.rotation,this._textureRotationAngle=this.textureRotationAngle,this._id=this.id;var o=new l({geometry:new u({extent:this.extent,vertexFormat:c.VERTEX_FORMAT,ellipsoid:this.ellipsoid,granularity:this.granularity,height:this.height,rotation:this.rotation,stRotation:this.textureRotationAngle}),id:this.id,pickPrimitive:this});r(this._primitive)&&this._primitive.destroy(),this._primitive=new h({geometryInstances:o,appearance:new c({aboveGround:this.height>0}),asynchronous:this.asynchronous})}var s=this._primitive;s.appearance.material=this.material,s.debugShowBoundingVolume=this.debugShowBoundingVolume,s.update(t,i,n)}},m.prototype.isDestroyed=function(){return!1},m.prototype.destroy=function(){return this._primitive=this._primitive&&this._primitive.destroy(),n(this)},m}),r("Scene/FrameState",["./SceneMode"],function(e){"use strict";var t=function(t){this.mode=e.SCENE3D,this.morphTime=e.SCENE3D.morphTime,this.frameNumber=0,this.time=void 0,this.scene2D={projection:void 0},this.camera=void 0,this.cullingVolume=void 0,this.occluder=void 0,this.passes={render:!1,pick:!1},this.creditDisplay=t,this.events=[]};return t}),r("Scene/FrustumCommands",["../Core/defaultValue"],function(e){"use strict";var t=function(t,r){this.near=e(t,0),this.far=e(r,0),this.opaqueCommands=[],this.translucentCommands=[]};return t}),r("Scene/GoogleEarthImageryProvider",["../Core/defaultValue","../Core/defined","../Core/loadText","../Core/DeveloperError","../Core/RuntimeError","../Core/Event","../Core/Extent","./ImageryProvider","./TileProviderError","./WebMercatorTilingScheme","./GeographicTilingScheme","./Credit","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function m(e,r,i,n){var o=e._imageUrlTemplate;o=o.replace("{x}",r),o=o.replace("{y}",i),o=o.replace("{zoom}",n+1);var a=e._proxy;return t(a)&&(o=a.getURL(o)),o}var p=function f(s){function m(e){var r;try{r=JSON.parse(e)}catch(i){r=JSON.parse(e.replace(/([\[\{,])[\n\r ]*([A-Za-z0-9]+)[\n\r ]*:/g,'$1"$2":'))}for(var o,s=0;s<r.layers.length;s++)if(r.layers[s].id===_._channel){o=r.layers[s];break}var h;if(!t(o))throw h="Could not find layer with channel (id) of "+_._channel+".",y=l.handleError(y,_,_._errorEvent,h,void 0,void 0,void 0,v),new n(h);if(!t(o.version))throw h="Could not find a version in channel (id) "+_._channel+".",y=l.handleError(y,_,_._errorEvent,h,void 0,void 0,void 0,v),new n(h);if(_._version=o.version,t(r.projection)&&"flat"===r.projection)_._tilingScheme=new c({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:2,extent:new a(-Math.PI,-Math.PI,Math.PI,Math.PI)});else{if(t(r.projection)&&"mercator"!==r.projection)throw h="Unsupported projection "+r.projection+".",y=l.handleError(y,_,_._errorEvent,h,void 0,void 0,void 0,v),new n(h);_._tilingScheme=new u({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:2})}_._imageUrlTemplate=_._imageUrlTemplate.replace("{request}",_._requestType).replace("{channel}",_._channel).replace("{version}",_._version),_._ready=!0,l.handleSuccess(y)}function p(){var e="An error occurred while accessing "+g+".";y=l.handleError(y,_,_._errorEvent,e,void 0,void 0,void 0,v)}function v(){var e=t(_._proxy)?_._proxy.getURL(g):g,i=r(e);d(i,m,p)}if(s=e(s,{}),!t(s.url))throw new i("description.url is required.");if(!t(s.channel))throw new i("description.channel is required.");this._url=s.url,this._path=e(s.path,"/default_map"),this._tileDiscardPolicy=s.tileDiscardPolicy,this._proxy=s.proxy,this._channel=s.channel,this._requestType="ImageryMaps",this._credit=new h("Google Imagery",f._logoData,"http://www.google.com/enterprise/mapsearth/products/earthenterprise.html"),this.defaultGamma=1.9,this._tilingScheme=void 0,this._version=void 0,this._tileWidth=256,this._tileHeight=256,this._maximumLevel=e(s.maximumLevel,23),this._imageUrlTemplate=this._url+this._path+"/query?request={request}&channel={channel}&version={version}&x={x}&y={y}&z={zoom}",this._errorEvent=new o,this._ready=!1;var y,g=this._url+this._path+"/query?request=Json&vars=geeServerDefs&is2d=t",_=this;v()};return p.prototype.getUrl=function(){return this._url},p.prototype.getPath=function(){return this._path},p.prototype.getProxy=function(){return this._proxy},p.prototype.getChannel=function(){return this._channel},p.prototype.getTileWidth=function(){if(!this._ready)throw new i("getTileWidth must not be called before the imagery provider is ready.");return this._tileWidth},p.prototype.getTileHeight=function(){if(!this._ready)throw new i("getTileHeight must not be called before the imagery provider is ready.");return this._tileHeight},p.prototype.getMaximumLevel=function(){if(!this._ready)throw new i("getMaximumLevel must not be called before the imagery provider is ready.");return this._maximumLevel},p.prototype.getMinimumLevel=function(){if(!this._ready)throw new i("getMaximumLevel must not be called before the imagery provider is ready.");return 0},p.prototype.getTilingScheme=function(){if(!this._ready)throw new i("getTilingScheme must not be called before the imagery provider is ready.");return this._tilingScheme},p.prototype.getTilingScheme=function(){if(!this._ready)throw new i("getTilingScheme must not be called before the imagery provider is ready.");return this._tilingScheme},p.prototype.getVersion=function(){if(!this._ready)throw new i("getVersion must not be called before the imagery provider is ready.");return this._version},p.prototype.getRequestType=function(){if(!this._ready)throw new i("getRequestType must not be called before the imagery provider is ready.");return this._requestType},p.prototype.getExtent=function(){if(!this._ready)throw new i("getExtent must not be called before the imagery provider is ready.");return this._tilingScheme.getExtent()},p.prototype.getTileDiscardPolicy=function(){if(!this._ready)throw new i("getTileDiscardPolicy must not be called before the imagery provider is ready.");return this._tileDiscardPolicy},p.prototype.getErrorEvent=function(){return this._errorEvent},p.prototype.isReady=function(){return this._ready},p.prototype.requestImage=function(e,t,r){if(!this._ready)throw new i("requestImage must not be called before the imagery provider is ready.");var n=m(this,e,t,r);return s.loadImage(this,n)},p.prototype.getCredit=function(){return this._credit},p._logoData="data:image/png;base64,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",p
}),r("Scene/GridImageryProvider",["../Core/defaultValue","../Core/Color","../Core/Event","./GeographicTilingScheme"],function(e,t,r,i){"use strict";var n=function(n){n=e(n,{}),this._tilingScheme=e(n.tilingScheme,new i),this._cells=e(n.cells,8),this._color=e(n.color,new t(1,1,1,.4)),this._glowColor=e(n.glowColor,new t(0,1,0,.05)),this._glowWidth=e(n.glowWidth,6),this._backgroundColor=e(n.backgroundColor,new t(0,.5,0,.2)),this._errorEvent=new r,this._tileWidth=e(n.tileWidth,256),this._tileHeight=e(n.tileHeight,256),this._canvasSize=e(n.canvasSize,256),this._canvas=this._createGridCanvas()};return n.prototype.getProxy=function(){return void 0},n.prototype.getTileWidth=function(){return this._tileWidth},n.prototype.getTileHeight=function(){return this._tileHeight},n.prototype.getMaximumLevel=function(){return void 0},n.prototype.getMinimumLevel=function(){return void 0},n.prototype.getTilingScheme=function(){return this._tilingScheme},n.prototype.getExtent=function(){return this._tilingScheme.getExtent()},n.prototype.getTileDiscardPolicy=function(){return void 0},n.prototype.getErrorEvent=function(){return this._errorEvent},n.prototype.isReady=function(){return!0},n.prototype._drawGrid=function(e){for(var t=0,r=this._canvasSize,i=0;i<=this._cells;++i){var n=i/this._cells,o=1+n*(r-1);e.moveTo(o,t),e.lineTo(o,r),e.moveTo(t,o),e.lineTo(r,o)}e.stroke()},n.prototype._createGridCanvas=function(){var e=document.createElement("canvas");e.width=this._canvasSize,e.height=this._canvasSize;var t=0,r=this._canvasSize,i=e.getContext("2d"),n=this._backgroundColor.toCssColorString();i.fillStyle=n,i.fillRect(t,t,r,r);var o=this._glowColor.toCssColorString();i.strokeStyle=o,i.lineWidth=this._glowWidth,i.strokeRect(t,t,r,r),this._drawGrid(i),i.lineWidth=.5*this._glowWidth,i.strokeRect(t,t,r,r),this._drawGrid(i);var a=this._color.toCssColorString();return i.strokeStyle=a,i.lineWidth=2,i.strokeRect(t,t,r,r),i.lineWidth=1,this._drawGrid(i),e},n.prototype.requestImage=function(){return this._canvas},n.prototype.getCredit=function(){return void 0},n}),r("Shaders/Appearances/BasicMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/BasicMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC;\n#ifdef FACE_FORWARD\nnormalEC = normalize(faceforward(v_normalEC, vec3(0.0, 0.0, 1.0), -v_normalEC));\n#else\nnormalEC = normalize(v_normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Shaders/Appearances/TexturedMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/TexturedMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC;\n#ifdef FACE_FORWARD\nnormalEC = normalize(faceforward(v_normalEC, vec3(0.0, 0.0, 1.0), -v_normalEC));\n#else\nnormalEC = normalize(v_normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Shaders/Appearances/AllMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 binormal;\nattribute vec2 st;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_binormalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_tangentEC = czm_normal * tangent;\nv_binormalEC = czm_normal * binormal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/AllMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_binormalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nmat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_binormalEC);\nvec3 normalEC;\n#ifdef FACE_FORWARD\nnormalEC = normalize(faceforward(v_normalEC, vec3(0.0, 0.0, 1.0), -v_normalEC));\n#else\nnormalEC = normalize(v_normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = tangentToEyeMatrix;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Scene/MaterialAppearance",["../Core/defaultValue","../Core/defined","../Core/freezeObject","../Core/VertexFormat","./Material","./Appearance","../Shaders/Appearances/BasicMaterialAppearanceVS","../Shaders/Appearances/BasicMaterialAppearanceFS","../Shaders/Appearances/TexturedMaterialAppearanceVS","../Shaders/Appearances/TexturedMaterialAppearanceFS","../Shaders/Appearances/AllMaterialAppearanceVS","../Shaders/Appearances/AllMaterialAppearanceFS"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";var d=function(r){r=e(r,e.EMPTY_OBJECT);var i=e(r.translucent,!0),a=e(r.closed,!1),s=e(r.materialSupport,d.MaterialSupport.TEXTURED);this.material=t(r.material)?r.material:n.fromType(n.ColorType),this.vertexShaderSource=e(r.vertexShaderSource,s.vertexShaderSource),this.fragmentShaderSource=e(r.fragmentShaderSource,s.fragmentShaderSource),this.renderState=e(r.renderState,o.getDefaultRenderState(i,a)),this.materialSupport=s,this.vertexFormat=s.vertexFormat,this.flat=e(r.flat,!1),this.faceForward=e(r.faceForward,!1),this.translucent=i,this.closed=a};return d.prototype.getFragmentShaderSource=o.prototype.getFragmentShaderSource,d.prototype.isTranslucent=o.prototype.isTranslucent,d.prototype.getRenderState=o.prototype.getRenderState,d.MaterialSupport={BASIC:r({vertexFormat:i.POSITION_AND_NORMAL,vertexShaderSource:a,fragmentShaderSource:s}),TEXTURED:r({vertexFormat:i.POSITION_NORMAL_AND_ST,vertexShaderSource:l,fragmentShaderSource:u}),ALL:r({vertexFormat:i.ALL,vertexShaderSource:c,fragmentShaderSource:h})},d}),r("Scene/Moon",["../Core/buildModuleUrl","../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/Ellipsoid","../Core/IauOrientationAxes","../Core/Matrix3","../Core/Matrix4","../Core/Simon1994PlanetaryPositions","../Core/Transforms","./EllipsoidPrimitive","./Material"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";var m=function(t){t=r(t,r.EMPTY_OBJECT);var n=t.textureUrl;i(n)||(n=e("Assets/Textures/moonSmall.jpg")),this.show=r(t.show,!0),this.textureUrl=n,this.ellipsoid=r(t.ellipsoid,o.MOON),this.onlySunLighting=r(t.onlySunLighting,!0),this._ellipsoidPrimitive=new h({radii:this.ellipsoid.getRadii(),material:d.fromType(d.ImageType),onlySunLighting:this.onlySunLighting,_owner:this}),this._axes=new a},p=new s,f=new s,v=new t;return m.prototype.update=function(e,t,r){if(this.show){var n=this._ellipsoidPrimitive;n.material.uniforms.image=this.textureUrl,n.onlySunLighting=this.onlySunLighting;var o=t.time;i(c.computeIcrfToFixedMatrix(o,p))||c.computeTemeToPseudoFixedMatrix(o,p);var a=this._axes.evaluate(o,f);s.transpose(a,a),s.multiply(p,a,a);var h=u.ComputeMoonPositionInEarthInertialFrame(o,v);s.multiplyByVector(p,h,h),l.fromRotationTranslation(a,h,n.modelMatrix),n.update(e,t,r)}},m.prototype.isDestroyed=function(){return!1},m.prototype.destroy=function(){return this._ellipsoid=this._ellipsoid&&this._ellipsoid.destroy(),n(this)},m}),r("Scene/NeverTileDiscardPolicy",[],function(){"use strict";var e=function(){};return e.prototype.isReady=function(){return!0},e.prototype.shouldDiscardImage=function(){return!1},e}),r("Scene/OpenStreetMapImageryProvider",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Event","./ImageryProvider","./WebMercatorTilingScheme","./Credit"],function(e,t,r,i,n,o,a){"use strict";function s(e,r,i,n){var o=e._url+n+"/"+r+"/"+i+"."+e._fileExtension,a=e._proxy;return t(a)&&(o=a.getURL(o)),o}var l=/\/$/,u=new a("MapQuest, Open Street Map and contributors, CC-BY-SA"),c=function(t){t=e(t,{});var r=e(t.url,"http://tile.openstreetmap.org/");l.test(r)||(r+="/"),this._url=r,this._fileExtension=e(t.fileExtension,"png"),this._proxy=t.proxy,this._tileDiscardPolicy=t.tileDiscardPolicy,this._tilingScheme=new o,this._tileWidth=256,this._tileHeight=256,this._maximumLevel=e(t.maximumLevel,18),this._extent=e(t.extent,this._tilingScheme.getExtent()),this._errorEvent=new i,this._ready=!0;var n=e(t.credit,u);"string"==typeof n&&(n=new a(n)),this._credit=n};return c.prototype.getUrl=function(){return this._url},c.prototype.getProxy=function(){return this._proxy},c.prototype.getTileWidth=function(){if(!this._ready)throw new r("getTileWidth must not be called before the imagery provider is ready.");return this._tileWidth},c.prototype.getTileHeight=function(){if(!this._ready)throw new r("getTileHeight must not be called before the imagery provider is ready.");return this._tileHeight},c.prototype.getMaximumLevel=function(){if(!this._ready)throw new r("getMaximumLevel must not be called before the imagery provider is ready.");return this._maximumLevel},c.prototype.getMinimumLevel=function(){if(!this._ready)throw new r("getMinimumLevel must not be called before the imagery provider is ready.");return 0},c.prototype.getTilingScheme=function(){if(!this._ready)throw new r("getTilingScheme must not be called before the imagery provider is ready.");return this._tilingScheme},c.prototype.getExtent=function(){if(!this._ready)throw new r("getExtent must not be called before the imagery provider is ready.");return this._extent},c.prototype.getTileDiscardPolicy=function(){if(!this._ready)throw new r("getTileDiscardPolicy must not be called before the imagery provider is ready.");return this._tileDiscardPolicy},c.prototype.getErrorEvent=function(){return this._errorEvent},c.prototype.isReady=function(){return this._ready},c.prototype.requestImage=function(e,t,i){if(!this._ready)throw new r("requestImage must not be called before the imagery provider is ready.");var o=s(this,e,t,i);return n.loadImage(this,o)},c.prototype.getCredit=function(){return this._credit},c}),r("Scene/OrthographicFrustum",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Matrix4","../Scene/CullingVolume"],function(e,t,r,i,n,o,a,s){"use strict";function l(t){if(!(e(t.right)&&e(t.left)&&e(t.top)&&e(t.bottom)&&e(t.near)&&e(t.far)))throw new r("right, left, top, bottom, near, or far parameters are not set.");if(t.top!==t._top||t.bottom!==t._bottom||t.left!==t._left||t.right!==t._right||t.near!==t._near||t.far!==t._far){if(t.left>t.right)throw new r("right must be greater than left.");if(t.bottom>t.top)throw new r("top must be greater than bottom.");if(t.near<=0||t.near>t.far)throw new r("near must be greater than zero and less than far.");t._left=t.left,t._right=t.right,t._top=t.top,t._bottom=t.bottom,t._near=t.near,t._far=t.far,t._orthographicMatrix=a.computeOrthographicOffCenter(t.left,t.right,t.bottom,t.top,t.near,t.far,t._orthographicMatrix)}}var u=function(){this.left=void 0,this._left=void 0,this.right=void 0,this._right=void 0,this.top=void 0,this._top=void 0,this.bottom=void 0,this._bottom=void 0,this.near=1,this._near=this.near,this.far=5e8,this._far=this.far,this._cullingVolume=new s,this._orthographicMatrix=void 0};t(u.prototype,{projectionMatrix:{get:function(){return l(this),this._orthographicMatrix}}});var c=new n,h=new n,d=new n,m=new n;return u.prototype.computeCullingVolume=function(t,i,a){if(!e(t))throw new r("position is required.");if(!e(i))throw new r("direction is required.");if(!e(a))throw new r("up is required.");var s=this._cullingVolume.planes,l=this.top,u=this.bottom,p=this.right,f=this.left,v=this.near,y=this.far,g=n.cross(i,a,c),_=h;n.multiplyByScalar(i,v,_),n.add(t,_,_);var w=d;n.multiplyByScalar(g,f,w),n.add(_,w,w);var C=s[0];return e(C)||(C=s[0]=new o),C.x=g.x,C.y=g.y,C.z=g.z,C.w=-n.dot(g,w),n.multiplyByScalar(g,p,w),n.add(_,w,w),C=s[1],e(C)||(C=s[1]=new o),C.x=-g.x,C.y=-g.y,C.z=-g.z,C.w=-n.dot(n.negate(g,m),w),n.multiplyByScalar(a,u,w),n.add(_,w,w),C=s[2],e(C)||(C=s[2]=new o),C.x=a.x,C.y=a.y,C.z=a.z,C.w=-n.dot(a,w),n.multiplyByScalar(a,l,w),n.add(_,w,w),C=s[3],e(C)||(C=s[3]=new o),C.x=-a.x,C.y=-a.y,C.z=-a.z,C.w=-n.dot(n.negate(a,m),w),C=s[4],e(C)||(C=s[4]=new o),C.x=i.x,C.y=i.y,C.z=i.z,C.w=-n.dot(i,_),n.multiplyByScalar(i,y,w),n.add(t,w,w),C=s[5],e(C)||(C=s[5]=new o),C.x=-i.x,C.y=-i.y,C.z=-i.z,C.w=-n.dot(n.negate(i,m),w),this._cullingVolume},u.prototype.getPixelSize=function(t,n,o){if(l(this),!e(t))throw new r("drawingBufferDimensions is required.");var a=t.x,s=t.y;if(0>=a)throw new r("drawingBufferDimensions.x must be greater than zero.");if(0>=s)throw new r("drawingBufferDimensions.y must be greater than zero.");var u=this.right-this.left,c=this.top-this.bottom,h=u/a,d=c/s;return e(o)?(o.x=h,o.y=d,o):new i(h,d)},u.prototype.clone=function(t){return e(t)||(t=new u),t.left=this.left,t.right=this.right,t.top=this.top,t.bottom=this.bottom,t.near=this.near,t.far=this.far,t._left=void 0,t._right=void 0,t._top=void 0,t._bottom=void 0,t._near=void 0,t._far=void 0,t},u.prototype.equals=function(t){return e(t)&&this.right===t.right&&this.left===t.left&&this.top===t.top&&this.bottom===t.bottom&&this.near===t.near&&this.far===t.far},u}),r("Shaders/Appearances/PerInstanceColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/PerInstanceColorAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC;\n#ifdef FACE_FORWARD\nnormalEC = normalize(faceforward(v_normalEC, vec3(0.0, 0.0, 1.0), -v_normalEC));\n#else\nnormalEC = normalize(v_normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getDefaultMaterial(materialInput);\nmaterial.diffuse = v_color.rgb;\nmaterial.alpha = v_color.a;\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n}\n"}),r("Shaders/Appearances/PerInstanceFlatColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Scene/PerInstanceColorAppearance",["../Core/defaultValue","../Core/VertexFormat","./Appearance","../Shaders/Appearances/PerInstanceColorAppearanceVS","../Shaders/Appearances/PerInstanceColorAppearanceFS","../Shaders/Appearances/PerInstanceFlatColorAppearanceVS","../Shaders/Appearances/PerInstanceFlatColorAppearanceFS"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){t=e(t,e.EMPTY_OBJECT);var l=e(t.translucent,!0),u=e(t.closed,!1),c=e(t.flat,!1),h=c?o:i,d=c?a:n,m=c?s.FLAT_VERTEX_FORMAT:s.VERTEX_FORMAT;this.material=void 0,this.vertexShaderSource=e(t.vertexShaderSource,h),this.fragmentShaderSource=e(t.fragmentShaderSource,d),this.renderState=e(t.renderState,r.getDefaultRenderState(l,u)),this.vertexFormat=m,this.flat=c,this.faceForward=e(t.faceForward,!1),this.translucent=l,this.closed=u};return s.VERTEX_FORMAT=t.POSITION_AND_NORMAL,s.FLAT_VERTEX_FORMAT=t.POSITION_ONLY,s.prototype.getFragmentShaderSource=r.prototype.getFragmentShaderSource,s.prototype.isTranslucent=r.prototype.isTranslucent,s.prototype.getRenderState=r.prototype.getRenderState,s}),r("Shaders/ViewportQuadVS",[],function(){"use strict";return"attribute vec4 position;\nattribute vec2 textureCoordinates;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\ngl_Position = position;\nv_textureCoordinates = textureCoordinates;\n}\n"}),r("Shaders/ViewportQuadFS",[],function(){"use strict";return"varying vec2 v_textureCoordinates;\nvoid main()\n{\nczm_materialInput materialInput;\nmaterialInput.s = v_textureCoordinates.s;\nmaterialInput.st = v_textureCoordinates;\nmaterialInput.str = vec3(v_textureCoordinates, 0.0);\nmaterialInput.normalEC = vec3(0.0, 0.0, -1.0);\nczm_material material = czm_getMaterial(materialInput);\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n}\n"}),r("Scene/ViewportQuad",["../Core/Color","../Core/destroyObject","../Core/defined","../Core/DeveloperError","../Core/BoundingRectangle","../Core/ComponentDatatype","../Core/PrimitiveType","../Core/Geometry","../Core/GeometryAttribute","./Material","../Renderer/BufferUsage","../Renderer/BlendingState","../Renderer/DrawCommand","../Renderer/createShaderSource","../Renderer/Pass","../Shaders/ViewportQuadVS","../Shaders/ViewportQuadFS"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v){"use strict";function y(e){var t=e.cache.viewportQuad_vertexArray;if(r(t))return t;var i=new s({attributes:{position:new l({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:[-1,-1,1,-1,1,1,-1,1]}),textureCoordinates:new l({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:[0,0,1,0,1,1,0,1]})},primitiveType:a.TRIANGLES});return t=e.createVertexArrayFromGeometry({geometry:i,attributeIndices:_,bufferUsage:c.STATIC_DRAW}),e.cache.viewportQuad_vertexArray=t,t}var g=function(t,i){this._va=void 0,this._overlayCommand=new d,this._overlayCommand.primitiveType=a.TRIANGLE_FAN,this._overlayCommand.pass=p.OVERLAY,this._overlayCommand.owner=this,this.show=!0,r(t)||(t=new n),this.rectangle=n.clone(t),r(i)||(i=u.fromType(u.ColorType),i.uniforms.color=new e(1,1,1,1)),this.material=i,this._material=void 0},_={position:0,textureCoordinates:1};return g.prototype.update=function(e,t,o){if(this.show){if(!r(this.material))throw new i("this.material must be defined.");if(!r(this.rectangle))throw new i("this.rectangle must be defined.");r(this._va)||(this._va=y(e),this._overlayCommand.vertexArray=this._va);var a=this._overlayCommand.renderState;r(a)&&n.equals(a.viewport,this.rectangle)||(this._overlayCommand.renderState=e.createRenderState({blending:h.ALPHA_BLEND,viewport:this.rectangle}));var s=t.passes;if(s.render){if(this._material!==this.material){this._material=this.material;var l=m({sources:[this._material.shaderSource,v]});this._overlayCommand.shaderProgram=e.getShaderCache().replaceShaderProgram(this._overlayCommand.shaderProgram,f,l,_)}this._material.update(e),this._overlayCommand.uniformMap=this._material._uniforms,o.push(this._overlayCommand)}}},g.prototype.isDestroyed=function(){return!1},g.prototype.destroy=function(){return this._overlayCommand.shaderProgram=this._overlayCommand.shaderProgram&&this._overlayCommand.shaderProgram.release(),t(this)},g}),r("Scene/PerformanceDisplay",["../Core/BoundingRectangle","../Core/Color","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Renderer/PixelFormat","./Material","./ViewportQuad"],function(e,t,r,i,n,o,a,s){"use strict";var l=t.fromCssColorString("#e52"),u=t.fromCssColorString("#de3"),c=t.fromCssColorString("rgba(0, 0, 30, 0.9)"),h=new e(0,0,80,40),d=function(e){e=r(e,r.EMPTY_OBJECT),this._fpsColor=r(e.fpsColor,l).toCssColorString(),this._frameTimeColor=r(e.frameTimeColor,u).toCssColorString(),this._backgroundColor=r(e.backgroundColor,c).toCssColorString(),this._font=r(e.font,"bold 10px Helvetica,Arial,sans-serif"),this._rectangle=r(e.rectangle,h),this._canvas=document.createElement("canvas"),this._canvas.width=this._rectangle.width,this._canvas.height=this._rectangle.height,this._canvasContext=this._canvas.getContext("2d"),this._canvasContext.font=this._font,this._canvasContext.lineWidth=1,this._bufferLength=this._rectangle.width,this._frameTimeSamples=new Array(this._bufferLength),this._fpsSamples=new Array(this._bufferLength);for(var t=0;t<this._bufferLength;t++)this._frameTimeSamples[t]=this._fpsSamples[t]=0;this._frameTimeIndex=0,this._fpsIndex=0,this._lastFpsSampleTime=void 0,this._frameCount=0,this._quad=void 0,this._time=void 0,this._texture=void 0,this._viewportHeight=0};return d.prototype.update=function(e,t,r){if(!i(this._time))return this._lastFpsSampleTime=this._time=Date.now(),void 0;var n=this._time,l=this._time=Date.now(),u=l-n;this._frameTimeSamples[this._frameTimeIndex++]=u,this._frameTimeIndex>=this._bufferLength&&(this._frameTimeIndex=0),this._frameCount++;var c=this._fps,h=l-this._lastFpsSampleTime;h>1e3&&(c=this._fps=0|1e3*this._frameCount/h,this._fpsSamples[this._fpsIndex++]=c,this._fpsIndex>=this._bufferLength&&(this._fpsIndex=0),this._lastFpsSampleTime=l,this._frameCount=0);var d=this._canvasContext,m=this._rectangle.width,p=this._rectangle.height;d.clearRect(0,0,m,p),d.fillStyle=this._backgroundColor,d.fillRect(0,0,m,p),i(c)&&(d.fillStyle=this._fpsColor,d.textAlign="left",d.fillText(c+" FPS",1,10)),d.fillStyle=this._frameTimeColor,d.textAlign="right",d.fillText(u+" MS",m-1,10);for(var f=0;f<this._bufferLength;f++)c=this._fpsSamples[(f+this._fpsIndex)%this._bufferLength],c>0&&this._drawLine(this._fpsColor,f,c/100),u=this._frameTimeSamples[(f+this._frameTimeIndex)%this._bufferLength],u>0&&this._drawLine(this._frameTimeColor,f,u/200);i(this._quad)||(this._quad=new s(void 0,a.fromType(a.ImageType))),i(this._texture)?this._texture.copyFrom(this._canvas):(this._texture=e.createTexture2D({source:this._canvas,pixelFormat:o.RGBA}),this._quad.material.uniforms.image=this._texture);var v=e.getDrawingBufferHeight();if(v!==this._viewportHeight){this._viewportHeight=v;var y=this._quad.rectangle;y.x=this._rectangle.x,y.y=v-p-this._rectangle.y,y.width=m,y.height=p}this._quad.update(e,t,r)},d.prototype._drawLine=function(e,t,r){var i=this._canvasContext,n=this._rectangle.height,o=n-10;t=.5+t,i.beginPath(),i.strokeStyle=e,i.moveTo(t,n);var a=r*o;a>o&&(a=o);var s=n-a;i.lineTo(t,s),i.stroke()},d.prototype.destroy=function(){return this._quad=this._quad.destroy(),n(this)},d}),r("Shaders/Appearances/PolylineMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec2 expandAndWidth;\nattribute vec2 st;\nvarying float v_width;\nvarying vec2 v_st;\nvoid main()\n{\nfloat expandDir = expandAndWidth.x;\nfloat width = abs(expandAndWidth.y) + 0.5;\nbool usePrev = expandAndWidth.y < 0.0;\nvec4 p = czm_computePosition();\nvec4 prev = czm_computePrevPosition();\nvec4 next = czm_computeNextPosition();\nv_width = width;\nv_st = st;\nvec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\ngl_Position = czm_viewportOrthographic * positionWC;\n}\n"}),r("Scene/PolylineMaterialAppearance",["../Core/defaultValue","../Core/defined","../Core/VertexFormat","./Material","./Appearance","../Renderer/createShaderSource","../Shaders/Appearances/PolylineMaterialAppearanceVS","../Shaders/PolylineFS","../Shaders/PolylineCommon"],function(e,t,r,i,n,o,a,s,l){"use strict";var u=function(r){r=e(r,e.EMPTY_OBJECT);var c=e(r.translucent,!0),h=!1,d=o({sources:[l,a]}),m=s,p=u.VERTEX_FORMAT;this.material=t(r.material)?r.material:i.fromType(i.ColorType),this.vertexShaderSource=e(r.vertexShaderSource,d),this.fragmentShaderSource=e(r.fragmentShaderSource,m),this.renderState=e(r.renderState,n.getDefaultRenderState(c,h)),this.vertexFormat=p,this.translucent=c,this.closed=h};return u.VERTEX_FORMAT=r.POSITION_AND_ST,u.prototype.getFragmentShaderSource=n.prototype.getFragmentShaderSource,u.prototype.isTranslucent=n.prototype.isTranslucent,u.prototype.getRenderState=n.prototype.getRenderState,u}),r("Scene/RectangularPyramidSensorVolume",["../Core/clone","../Core/Color","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Math","../Core/Matrix4","../Renderer/BufferUsage","./Material","./CustomSensorVolume"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";var h=function(n){n=r(n,r.EMPTY_OBJECT),this.show=r(n.show,!0),this.showIntersection=r(n.showIntersection,!0),this.showThroughEllipsoid=r(n.showThroughEllipsoid,!1),this.modelMatrix=s.clone(r(n.modelMatrix,s.IDENTITY)),this.bufferUsage=r(n.bufferUsage,l.STATIC_DRAW),this.radius=r(n.radius,Number.POSITIVE_INFINITY),this.xHalfAngle=r(n.xHalfAngle,a.PI_OVER_TWO),this._xHalfAngle=void 0,this.yHalfAngle=r(n.yHalfAngle,a.PI_OVER_TWO),this._yHalfAngle=void 0,this.material=i(n.material)?n.material:u.fromType(u.ColorType),this.intersectionColor=t.clone(r(n.intersectionColor,t.WHITE)),this.intersectionWidth=r(n.intersectionWidth,5),this.id=n.id;var o=e(n);o._pickIdThis=r(n._pickIdThis,this),this._customSensor=new c(o)};return h.prototype.update=function(e,t,r){if(this.xHalfAngle>a.PI_OVER_TWO||this.yHalfAngle>a.PI_OVER_TWO)throw new o("this.xHalfAngle and this.yHalfAngle must each be less than or equal to 90 degrees.");var i=this._customSensor;if(i.show=this.show,i.showIntersection=this.showIntersection,i.showThroughEllipsoid=this.showThroughEllipsoid,i.modelMatrix=this.modelMatrix,i.bufferUsage=this.bufferUsage,i.radius=this.radius,i.material=this.material,i.intersectionColor=this.intersectionColor,i.intersectionWidth=this.intersectionWidth,i.id=this.id,this._xHalfAngle!==this.xHalfAngle||this._yHalfAngle!==this.yHalfAngle){this._xHalfAngle=this.xHalfAngle,this._yHalfAngle=this.yHalfAngle;var n=Math.tan(Math.min(this.xHalfAngle,a.toRadians(89))),s=Math.tan(Math.min(this.yHalfAngle,a.toRadians(89))),l=Math.atan(n/s),u=Math.atan(Math.sqrt(n*n+s*s));i.setDirections([{clock:l,cone:u},{clock:a.toRadians(180)-l,cone:u},{clock:a.toRadians(180)+l,cone:u},{clock:-l,cone:u}])}i.update(e,t,r)},h.prototype.isDestroyed=function(){return!1},h.prototype.destroy=function(){return this._customSensor=this._customSensor&&this._customSensor.destroy(),n(this)},h}),r("Scene/ScreenSpaceCameraController",["../Core/defined","../Core/destroyObject","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/DeveloperError","../Core/Ellipsoid","../Core/KeyboardEventModifier","../Core/FAR","../Core/IntersectionTests","../Core/Math","../Core/Matrix4","../Core/Ray","../Core/Transforms","./AnimationCollection","./CameraEventAggregator","./CameraEventType","./CameraColumbusViewMode","./SceneMode"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,m,p,f,v,y,g,_){"use strict";function w(e,t){if(0>e)return 0;var r=25*(1-t);return Math.exp(-r*e)}function C(e){return r.equalsEpsilon(e.startPosition,e.endPosition,h.EPSILON14)}function x(t,n,o,a,s,l,u){var c=l[u];e(c)||(c=l[u]={startPosition:new r,endPosition:new r,motion:new r,active:!1});var h=t.getButtonPressTime(n,o),d=t.getButtonReleaseTime(n,o),m=h&&d&&(d.getTime()-h.getTime())/1e3,p=new Date,f=d&&(p.getTime()-d.getTime())/1e3;if(h&&d&&W>m){var v=w(f,a);if(c.active)r.clone(c.endPosition,c.startPosition),r.multiplyByScalar(c.motion,v,c.endPosition),r.add(c.startPosition,c.endPosition,c.endPosition),i.clone(r.ZERO,c.motion);else{var y=t.getLastMovement(n,o);if(!e(y)||C(y))return;c.motion.x=.5*(y.endPosition.x-y.startPosition.x),c.motion.y=.5*(y.endPosition.y-y.startPosition.y),r.clone(y.startPosition,c.startPosition),r.multiplyByScalar(c.motion,v,c.endPosition),r.add(c.startPosition,c.endPosition,c.endPosition),c.active=!0}if(isNaN(c.endPosition.x)||isNaN(c.endPosition.y)||C(c))return c.active=!1,void 0;t.isButtonDown(n,o)||s(l,c)}else c.active=!1}function S(t,r,i,n,o,a){if(e(i)){var s=t._aggregator;Array.isArray(i)||(q[0]=i,i=q);for(var l=i.length,u=0;l>u;++u){var c=i[u],h=e(c.eventType)?c.eventType:c,d=c.modifier,m=s.isMoving(h,d)&&s.getMovement(h,d);r&&(m?n(t,s.getMovement(h,d)):1>o&&x(s,h,d,o,n,t,a))}}}function E(t,r,i,n,o){var a=1;e(o)&&(a=h.clamp(Math.abs(o),.25,1));var s=t.minimumZoomDistance*a,l=t.maximumZoomDistance,u=n-s,c=i*u;c=h.clamp(c,t._minimumZoomRate,t._maximumZoomRate);var d=r.endPosition.y-r.startPosition.y,m=d/t._canvas.clientHeight;m=Math.min(m,t.maximumMovementRatio);var p=c*m;p>0&&Math.abs(n-s)<1||0>p&&Math.abs(n-l)<1||(s>n-p?p=n-s-1:n-p>l&&(p=n-l),t._cameraController.zoomIn(p))}function b(e,t){var r=e._cameraController,i=r.getPickRay(t.startPosition,G).origin,n=r.getPickRay(t.endPosition,H).origin;r.moveRight(i.x-n.x),r.moveUp(i.y-n.y)}function T(t,r){e(r.distance)&&(r=r.distance),E(t,r,t._zoomFactor,t._cameraController.getMagnitude())}function A(t,i){if(e(i.angleAndHeight))return D(t,i.angleAndHeight),void 0;var n=t._canvas.clientWidth,o=t._canvas.clientHeight,a=j;a.x=2/n*i.startPosition.x-1,a.y=2/o*(o-i.startPosition.y)-1,r.normalize(a,a);var s=Y;s.x=2/n*i.endPosition.x-1,s.y=2/o*(o-i.endPosition.y)-1,r.normalize(s,s);var l=Math.acos(a.x);a.y<0&&(l=h.TWO_PI-l);var u=Math.acos(s.x);s.y<0&&(u=h.TWO_PI-u);var c=u-l;t._cameraController.twistRight(c)}function D(e,t){var r=e._rotateFactor*e._rotateRateRangeAdjustment;r>e._maximumRotateRate&&(r=e._maximumRotateRate),r<e._minimumRotateRate&&(r=e._minimumRotateRate);var i=(t.endPosition.x-t.startPosition.x)/e._canvas.clientWidth;i=Math.min(i,e.maximumMovementRatio);var n=4*r*i*Math.PI;e._cameraController.twistRight(n)}function P(t){if(t._aggregator.anyButtonDown()&&t._animationCollection.removeAll(),S(t,t.enableTranslate,t.translateEventTypes,b,t.inertiaTranslate,"_lastInertiaTranslateMovement"),S(t,t.enableZoom,t.zoomEventTypes,T,t.inertiaZoom,"_lastInertiaZoomMovement"),S(t,t.enableRotate,t.tiltEventTypes,A,t.inertiaSpin,"_lastInertiaTiltMovement"),!(t._aggregator.anyButtonDown()||e(t._lastInertiaZoomMovement)&&t._lastInertiaZoomMovement.active||e(t._lastInertiaTranslateMovement)&&t._lastInertiaTranslateMovement.active||t._animationCollection.contains(t._animation))){var r=t._cameraController.createCorrectPositionAnimation(t.bounceAnimationTime);e(r)&&(t._animation=t._animationCollection.add(r))}t._animationCollection.update()}function M(e,t){var r=e._cameraController,n=r.getPickRay(t.startPosition,X),o=r.getPickRay(t.endPosition,Z),a=i.UNIT_X,s=n.origin,l=n.direction,u=-i.dot(a,s)/i.dot(a,l),c=i.multiplyByScalar(l,u,J);i.add(s,c,c),s=o.origin,l=o.direction,u=-i.dot(a,s)/i.dot(a,l);var d=i.multiplyByScalar(l,u,K);i.add(s,d,d);var m=i.subtract(c,d,Q),p=m.x;m.x=m.y,m.y=m.z,m.z=p;var f=i.magnitude(m);
f>h.EPSILON6&&(i.normalize(m,m),r.move(m,f))}function I(t,r){e(r.angleAndHeight)&&(r=r.angleAndHeight);var n=$;n.x=t._canvas.clientWidth/2,n.y=t._canvas.clientHeight/2;var o=t._cameraController.getPickRay(n,et),a=i.UNIT_X,l=o.origin,u=o.direction,c=-i.dot(a,l)/i.dot(a,u),h=i.multiplyByScalar(u,c,tt);i.add(l,h,h);var m=d.fromTranslation(h,rt),p=t._ellipsoid;t.setEllipsoid(s.UNIT_SPHERE),z(t,r,m,i.UNIT_Z),t.setEllipsoid(p)}function O(t,r){e(r.distance)&&(r=r.distance);var n=it;n.x=t._canvas.clientWidth/2,n.y=t._canvas.clientHeight/2;var o=t._cameraController.getPickRay(n,nt),a=i.UNIT_X,s=o.origin,l=o.direction,u=-i.dot(a,s)/i.dot(a,l);E(t,r,t._zoomFactor,u)}function R(t){if(t.columbusViewMode===g.LOCKED)S(t,t.enableRotate,t.rotateEventTypes,z,t.inertiaSpin,"_lastInertiaSpinMovement"),S(t,t.enableZoom,t.zoomEventTypes,B,t.inertiaZoom,"_lastInertiaZoomMovement");else{if(t._aggregator.anyButtonDown()&&t._animationCollection.removeAll(),S(t,t.enableTilt,t.tiltEventTypes,I,t.inertiaSpin,"_lastInertiaTiltMovement"),S(t,t.enableTranslate,t.translateEventTypes,M,t.inertiaTranslate,"_lastInertiaTranslateMovement"),S(t,t.enableZoom,t.zoomEventTypes,O,t.inertiaZoom,"_lastInertiaZoomMovement"),S(t,t.enableLook,t.lookEventTypes,V),!(t._aggregator.anyButtonDown()||e(t._lastInertiaZoomMovement)&&t._lastInertiaZoomMovement.active||e(t._lastInertiaTranslateMovement)&&t._lastInertiaTranslateMovement.active||t._animationCollection.contains(t._animation))){var r=t._cameraController.createCorrectPositionAnimation(t.bounceAnimationTime);e(r)&&(t._animation=t._animationCollection.add(r))}t._animationCollection.update()}}function L(t,r){e(t._cameraController.pickEllipsoid(r.startPosition,t._ellipsoid,ot))?N(t,r):z(t,r)}function z(t,r,n,o,a){var s=t._cameraController,l=s.constrainedAxis;e(o)&&(s.constrainedAxis=o);var u=i.magnitude(s._camera.position),c=t._rotateFactor*(u-t._rotateRateRangeAdjustment);c>t._maximumRotateRate&&(c=t._maximumRotateRate),c<t._minimumRotateRate&&(c=t._minimumRotateRate);var m=(r.startPosition.x-r.endPosition.x)/t._canvas.clientWidth,p=(r.startPosition.y-r.endPosition.y)/t._canvas.clientHeight;m=Math.min(m,t.maximumMovementRatio),p=Math.min(p,t.maximumMovementRatio);var f=2*c*m*Math.PI,v=c*p*Math.PI;if(e(s.constrainedAxis)&&!e(n)){var y=s._camera,g=i.normalize(y.position,st),_=i.equalsEpsilon(g,s.constrainedAxis,h.EPSILON2),w=i.equalsEpsilon(g,i.negate(s.constrainedAxis,lt),h.EPSILON2);if(!_&&!w){var C;C=i.dot(y.position,y.direction)+1<h.EPSILON4?y.up:y.direction;var x;i.equalsEpsilon(s.constrainedAxis,g,h.EPSILON2)?x=y.right:(x=i.cross(s.constrainedAxis,g,st),i.normalize(x,x));var S=i.dot(y.right,x),E=h.sign(S)<0?-1:1;S=Math.abs(S);var b=i.dot(C,s.constrainedAxis),T=i.dot(C,x),A=b>0&&T>0||0>b&&0>T?-1:1;b=Math.abs(b);var D=v;v=E*(v*b-A*f*(1-S)),f=E*(f*S+A*D*(1-b))}}if(s.rotateRight(f,n),s.rotateUp(v,n),e(a)){var P=i.clone(s._camera.directionWC,at),M=d.inverseTransformation(n,ut);P=d.multiplyByPointAsVector(M,P,P);var I=-i.dot(P,o),O=Math.acos(I);O>a&&(O-=a,s.rotateUp(-O,n))}s.constrainedAxis=l}function N(t,r){var n=t._cameraController,o=n.pickEllipsoid(r.startPosition,t._ellipsoid,ct),a=n.pickEllipsoid(r.endPosition,t._ellipsoid,ht);if(e(o)&&e(a))if(o=n._camera.worldToCameraCoordinates(o,o),a=n._camera.worldToCameraCoordinates(a,a),e(n.constrainedAxis)){var s=n.constrainedAxis,l=i.mostOrthogonalAxis(s,dt);i.cross(l,s,l),i.normalize(l,l);var u=i.cross(s,l,mt),c=i.magnitude(o),d=i.dot(s,o),m=Math.acos(d/c),p=i.multiplyByScalar(s,d,pt);i.subtract(o,p,p),i.normalize(p,p);var f=i.magnitude(a),v=i.dot(s,a),y=Math.acos(v/f),g=i.multiplyByScalar(s,v,ft);i.subtract(a,g,g),i.normalize(g,g);var _=Math.acos(i.dot(p,l));i.dot(p,u)<0&&(_=h.TWO_PI-_);var w=Math.acos(i.dot(g,l));i.dot(g,u)<0&&(w=h.TWO_PI-w);var C,x=_-w;C=i.equalsEpsilon(s,n._camera.position,h.EPSILON2)?n._camera.right:i.cross(s,n._camera.position,dt);var S,E=i.cross(s,C,dt),b=i.dot(E,i.subtract(o,s,mt)),T=i.dot(E,i.subtract(a,s,mt));S=b>0&&T>0?y-m:b>0&&0>=T?i.dot(n._camera.position,s)>0?-m-y:m+y:m-y,n.rotateRight(x),n.rotateUp(S)}else{i.normalize(o,o),i.normalize(a,a);var A=i.dot(o,a),D=i.cross(o,a,dt);if(1>A&&!i.equalsEpsilon(D,i.ZERO,h.EPSILON14)){var P=Math.acos(A);n.rotate(D,P)}}}function B(t,r){e(r.distance)&&(r=r.distance);var n=t._cameraController._camera,o=t._ellipsoid,a=o.cartesianToCartographic(n.position).height,s=i.normalize(n.position,vt);E(t,r,t._zoomFactor,a,i.dot(s,n.direction))}function F(t,r){e(r.angleAndHeight)&&(r=r.angleAndHeight);var n=t._cameraController,o=t._ellipsoid,a=.25*t.minimumZoomDistance,l=o.cartesianToCartographic(t._cameraController._camera.position).height;if(!(l-a-1<h.EPSILON3&&r.endPosition.y-r.startPosition.y<0)){var u=yt;u.x=t._canvas.clientWidth/2,u.y=t._canvas.clientHeight/2;var d,m=n.getPickRay(u,gt),f=c.rayEllipsoid(m,o);if(e(f))d=m.getPoint(f.start,wt);else{var v=c.grazingAltitudeLocation(m,o);if(!e(v))return;var y=o.cartesianToCartographic(v,_t);y.height=0,d=o.cartographicToCartesian(y,wt)}var g=n._camera;d=g.worldToCameraCoordinates(d,d);var _=p.eastNorthUpToFixedFrame(d,o,Ct),w=t._ellipsoid;t.setEllipsoid(s.UNIT_SPHERE);var C=.25*a/i.distance(d,g.position);z(t,r,_,i.UNIT_Z,h.PI_OVER_TWO-C),t.setEllipsoid(w)}}function V(t,r){var n=t._cameraController,o=xt;o.x=r.startPosition.x,o.y=0;var a=St;a.x=r.endPosition.x,a.y=0;var s=n.getPickRay(o,Et).direction,l=n.getPickRay(a,bt).direction,u=0,c=i.dot(s,l);1>c&&(u=Math.acos(c)),u=r.startPosition.x>r.endPosition.x?-u:u;var h=t._horizontalRotationAxis;e(h)?n.look(h,u):n.lookLeft(u),o.x=0,o.y=r.startPosition.y,a.x=0,a.y=r.endPosition.y,s=n.getPickRay(o,Et).direction,l=n.getPickRay(a,bt).direction,u=0,c=i.dot(s,l),1>c&&(u=Math.acos(c)),u=r.startPosition.y>r.endPosition.y?-u:u,n.lookUp(u)}function k(e){S(e,e.enableRotate,e.rotateEventTypes,L,e.inertiaSpin,"_lastInertiaSpinMovement"),S(e,e.enableZoom,e.zoomEventTypes,B,e.inertiaZoom,"_lastInertiaZoomMovement"),S(e,e.enableTilt,e.tiltEventTypes,F,e.inertiaSpin,"_lastInertiaTiltMovement"),S(e,e.enableLook,e.lookEventTypes,V)}var U=function(t,r){if(!e(t))throw new a("canvas is required.");if(!e(r))throw new a("cameraController is required.");this.enableTranslate=!0,this.enableZoom=!0,this.enableRotate=!0,this.enableTilt=!0,this.enableLook=!0,this.inertiaSpin=.9,this.inertiaTranslate=.9,this.inertiaZoom=.8,this.maximumMovementRatio=.1,this.columbusViewMode=g.FREE,this.bounceAnimationTime=3e3,this.minimumZoomDistance=20,this.maximumZoomDistance=Number.POSITIVE_INFINITY,this.translateEventTypes=y.LEFT_DRAG,this.zoomEventTypes=[y.RIGHT_DRAG,y.WHEEL,y.PINCH],this.rotateEventTypes=y.LEFT_DRAG,this.tiltEventTypes=[y.MIDDLE_DRAG,y.PINCH,{eventType:y.LEFT_DRAG,modifier:l.CTRL}],this.lookEventTypes={eventType:y.LEFT_DRAG,modifier:l.SHIFT},this._canvas=t,this._cameraController=r,this._ellipsoid=s.WGS84,this._aggregator=new v(t),this._lastInertiaSpinMovement=void 0,this._lastInertiaZoomMovement=void 0,this._lastInertiaTranslateMovement=void 0,this._lastInertiaWheelZoomMovement=void 0,this._lastInertiaTiltMovement=void 0,this._animationCollection=new f,this._animation=void 0,this._horizontalRotationAxis=void 0;var i=this._ellipsoid.getMaximumRadius();this._zoomFactor=5,this._rotateFactor=1/i,this._rotateRateRangeAdjustment=i,this._maximumRotateRate=1.77,this._minimumRotateRate=2e-4,this._translateFactor=1,this._minimumZoomRate=20,this._maximumZoomRate=u};U.prototype.getEllipsoid=function(){return this._ellipsoid},U.prototype.setEllipsoid=function(e){e=e||s.WGS84;var t=e.getMaximumRadius();this._ellipsoid=e,this._rotateFactor=1/t,this._rotateRateRangeAdjustment=t};var W=.4,q=[],G=new m,H=new m,j=new r,Y=new r,X=new m,Z=new m,J=new i,K=new i,Q=new i,$=new r,et=new m,tt=new i,rt=new d,it=new r,nt=new m,ot=new i,at=i.clone(i.ZERO),st=new i,lt=new i,ut=new d,ct=n.clone(n.UNIT_W),ht=n.clone(n.UNIT_W),dt=new i,mt=new i,pt=new i,ft=new i,vt=new i,yt=new r,gt=new m,_t=new o,wt=n.clone(n.UNIT_W),Ct=new d,xt=new r,St=new r,Et=new m,bt=new m;return U.prototype.update=function(e){e===_.SCENE2D?P(this):e===_.COLUMBUS_VIEW?(this._horizontalRotationAxis=i.UNIT_Z,R(this)):e===_.SCENE3D&&(this._horizontalRotationAxis=void 0,k(this)),this._aggregator.reset()},U.prototype.isDestroyed=function(){return!1},U.prototype.destroy=function(){return this._spinHandler=this._spinHandler&&this._spinHandler.destroy(),this._translateHandler=this._translateHandler&&this._translateHandler.destroy(),this._lookHandler=this._lookHandler&&this._lookHandler.destroy(),this._rotateHandler=this._rotateHandler&&this._rotateHandler.destroy(),this._zoomHandler=this._zoomHandler&&this._zoomHandler.destroy(),this._zoomWheelHandler=this._zoomWheelHandler&&this._zoomWheelHandler.destroy(),this._pinchHandler=this._pinchHandler&&this._pinchHandler.destroy(),t(this)},U}),r("Shaders/PostProcessFilters/AdditiveBlend",[],function(){"use strict";return"uniform sampler2D u_texture0;\nuniform sampler2D u_texture1;\nuniform vec2 u_center;\nuniform float u_radius;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\nvec4 color0 = texture2D(u_texture0, v_textureCoordinates);\nvec4 color1 = texture2D(u_texture1, v_textureCoordinates);\nfloat x = length(gl_FragCoord.xy - u_center) / u_radius;\nfloat t = smoothstep(0.5, 0.8, x);\ngl_FragColor = mix(color0 + color1, color0, t);\n}\n"}),r("Shaders/PostProcessFilters/BrightPass",[],function(){"use strict";return"uniform sampler2D u_texture;\nuniform float u_avgLuminance;\nuniform float u_threshold;\nuniform float u_offset;\nvarying vec2 v_textureCoordinates;\nfloat key(float avg)\n{\nfloat guess = 1.5 - (1.5 / (avg * 0.1 + 1.0));\nreturn max(0.0, guess) + 0.1;\n}\nvoid main()\n{\nvec4 color = texture2D(u_texture, v_textureCoordinates);\nvec3 xyz = czm_RGBToXYZ(color.rgb);\nfloat luminance = xyz.r;\nfloat scaledLum = key(u_avgLuminance) * luminance / u_avgLuminance;\nfloat brightLum = max(scaledLum - u_threshold, 0.0);\nfloat brightness = brightLum / (u_offset + brightLum);\nxyz.r = brightness;\ngl_FragColor = vec4(czm_XYZToRGB(xyz), 1.0);\n}\n"}),r("Shaders/PostProcessFilters/GaussianBlur1D",[],function(){"use strict";return"#define SAMPLES 8\nuniform float delta;\nuniform float sigma;\nuniform float direction;\nuniform sampler2D u_texture;\nuniform vec2 u_step;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\nvec2 st = v_textureCoordinates;\nvec2 dir = vec2(1.0 - direction, direction);\nvec3 g;\ng.x = 1.0 / (sqrt(czm_twoPi) * sigma);\ng.y = exp((-0.5 * delta * delta) / (sigma * sigma));\ng.z = g.y * g.y;\nvec4 result = texture2D(u_texture, st) * g.x;\nfor (int i = 1; i < SAMPLES; ++i)\n{\ng.xy *= g.yz;\nvec2 offset = float(i) * dir * u_step;\nresult += texture2D(u_texture, st - offset) * g.x;\nresult += texture2D(u_texture, st + offset) * g.x;\n}\ngl_FragColor = result;\n}\n"}),r("Shaders/PostProcessFilters/PassThrough",[],function(){"use strict";return"uniform sampler2D u_texture;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\ngl_FragColor = texture2D(u_texture, v_textureCoordinates);\n}\n"}),r("Scene/SunPostProcess",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian4","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Co