/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2013 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var o=r.clock,a=r.cone,s=e(r.magnitude,1),u=s*Math.sin(a);return n.x=u*Math.cos(o),n.y=u*Math.sin(o),n.z=s*Math.cos(a),n},i.fromElements=function(e,r,n,o){return t(o)?(o.x=e,o.y=r,o.z=n,o):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r):new i(e.x/n,e.y/n,e.z/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n):new i(e.x*r.x,e.y*r.y,e.z*r.z)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n):new i(e.x+r.x,e.y+r.y,e.z+r.z)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n):new i(e.x-r.x,e.y-r.y,e.z-r.z)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n):new i(e.x*r,e.y*r,e.z*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n):new i(e.x/r,e.y/r,e.z/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r):new i(-e.x,-e.y,-e.z)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i,u=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,u);var r=i.dot(s,u),n=i.magnitude(i.cross(s,u,s));return Math.atan2(n,r)};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n},i.cross=function(e,r,n){var o=e.x,a=e.y,s=e.z,u=r.x,l=r.y,c=r.z,f=a*c-s*l,m=s*u-o*c,h=o*l-a*u;return t(n)?(n.x=f,n.y=m,n.z=h,n):new i(f,m,h)},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n,i){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,r,n,o,a){return t(a)?(a.x=e,a.y=r,a.z=n,a.w=o,a):new i(e,r,n,o)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n++],o.w=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n.w=Math.min(e.w,r.w),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n.w=Math.max(e.w,r.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r.w=e.w/n,r):new i(e.x/n,e.y/n,e.z/n,e.w/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n.w=e.w*r.w,n):new i(e.x*r.x,e.y*r.y,e.z*r.z,e.w*r.w)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n):new i(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n):new i(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n):new i(e.x*r,e.y*r,e.z*r,e.w*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n):new i(e.x/r,e.y/r,e.z/r,e.w/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new i(-e.x,-e.y,-e.z,-e.w)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r.w=Math.abs(e.w),r):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z),Math.abs(e.w))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n&&Math.abs(e.w-r.w)<=n},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["./defaultValue","./defined","./DeveloperError","../ThirdParty/mersenne-twister"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.negativePiToPi=function(e){for(var t=i.EPSILON10,r=i.PI,n=i.TWO_PI;-(r+t)>e;)e+=n;if(-r>e)return-r;for(;e>r+t;)e-=n;return e>r?r:e},i.zeroToTwoPi=function(e){var t=e%i.TWO_PI;return 0>t?(t+i.TWO_PI)%i.TWO_PI:t},i.equalsEpsilon=function(t,r,n){return n=e(n,0),Math.abs(t-r)<=n};var o=[1];i.factorial=function(e){var t=o.length;if(e>=t)for(var r=o[t-1],n=t;e>=n;n++)o.push(r*n);return o[e]},i.incrementWrap=function(t,r,n){return n=e(n,0),++t,t>r&&(t=n),t},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,r){return t>e?t:e>r?r:e};var a=new n;return i.setRandomNumberSeed=function(e){a=new n(e)},i.nextRandomNumber=function(){return a.random()},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var o=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return o.fromDegrees=function(r,n,a,s){return r=i.toRadians(e(r,0)),n=i.toRadians(e(n,0)),a=e(a,0),t(s)?(s.longitude=r,s.latitude=n,s.height=a,s):new o(r,n,a)},o.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new r("epsilon is required and must be a number.");return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.toString=function(e){if(!t(e))throw new r("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return o.toString(this)},o}),define("Core/Ellipsoid",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic"],function(e,t,r,n,i,o,a){"use strict";var s=function(e,r,a){if(e=t(e,0),r=t(r,0),a=t(a,0),0>e||0>r||0>a)throw new n("All radii components must be greater than or equal to zero.");this._radii=new o(e,r,a),this._radiiSquared=new o(e*e,r*r,a*a),this._radiiToTheFourth=new o(e*e*e*e,r*r*r*r,a*a*a*a),this._oneOverRadii=new o(0===e?0:1/e,0===r?0:1/r,0===a?0:1/a),this._oneOverRadiiSquared=new o(0===e?0:1/(e*e),0===r?0:1/(r*r),0===a?0:1/(a*a)),this._minimumRadius=Math.min(e,r,a),this._maximumRadius=Math.max(e,r,a),this._centerToleranceSquared=i.EPSILON1};s.clone=function(e,t){if(!r(e))return void 0;var n=e._radii;return r(t)?(o.clone(n,t._radii),o.clone(e._radiiSquared,t._radiiSquared),o.clone(e._radiiToTheFourth,t._radiiToTheFourth),o.clone(e._oneOverRadii,t._oneOverRadii),o.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new s(n.x,n.y,n.z)},s.fromCartesian3=function(e){return r(e)?new s(e.x,e.y,e.z):new s},s.WGS84=e(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=e(new s(1,1,1)),s.MOON=e(new s(i.LUNAR_RADIUS,i.LUNAR_RADIUS,i.LUNAR_RADIUS)),s.prototype.getRadii=function(){return this._radii},s.prototype.getRadiiSquared=function(){return this._radiiSquared},s.prototype.getRadiiToTheFourth=function(){return this._radiiToTheFourth},s.prototype.getOneOverRadii=function(){return this._oneOverRadii},s.prototype.getOneOverRadiiSquared=function(){return this._oneOverRadiiSquared},s.prototype.getMinimumRadius=function(){return this._minimumRadius},s.prototype.getMaximumRadius=function(){return this._maximumRadius},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=o.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(e,t){if(!r(e))throw new n("cartographic is required.");var i=e.longitude,a=e.latitude,s=Math.cos(a),u=s*Math.cos(i),l=s*Math.sin(i),c=Math.sin(a);return r(t)||(t=new o),t.x=u,t.y=l,t.z=c,o.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(e,t){return t=o.multiplyComponents(e,this._oneOverRadiiSquared,t),o.normalize(t,t)};var u=new o,l=new o;s.prototype.cartographicToCartesian=function(e,t){var r=u,n=l;this.geodeticSurfaceNormalCartographic(e,r),o.multiplyComponents(this._radiiSquared,r,n);var i=Math.sqrt(o.dot(r,n));return o.divideByScalar(n,i,n),o.multiplyByScalar(r,e.height,r),o.add(n,r,t)},s.prototype.cartographicArrayToCartesianArray=function(e,t){if(!r(e))throw new n("cartographics is required.");var i=e.length;r(t)?t.length=i:t=new Array(i);for(var o=0;i>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var c=new o,f=new o,m=new o;s.prototype.cartesianToCartographic=function(e,t){var n=this.scaleToGeodeticSurface(e,f);if(!r(n))return void 0;var s=this.geodeticSurfaceNormal(n,c),u=o.subtract(e,n,m),l=Math.atan2(s.y,s.x),h=Math.asin(s.z),y=i.sign(o.dot(u,e))*o.magnitude(u);return r(t)?(t.longitude=l,t.latitude=h,t.height=y,t):new a(l,h,y)},s.prototype.cartesianArrayToCartographicArray=function(e,t){if(!r(e))throw new n("cartesians is required.");var i=e.length;r(t)?t.length=i:t=new Array(i);for(var o=0;i>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t};var h=new o,y=new o;return s.prototype.scaleToGeodeticSurface=function(e,t){if(!r(e))throw new n("cartesian is required.");var a=e.x,s=e.y,u=e.z,l=this._oneOverRadii,c=l.x,f=l.y,m=l.z,p=a*a*c*c,d=s*s*f*f,w=u*u*m*m,v=p+d+w,g=Math.sqrt(1/v),E=o.multiplyByScalar(e,g,h);if(v<this._centerToleranceSquared)return isFinite(g)?o.clone(E,t):void 0;var b=this._oneOverRadiiSquared,x=b.x,C=b.y,S=b.z,A=y;A.x=2*E.x*x,A.y=2*E.y*C,A.z=2*E.z*S;var M,T,O,I,N,R,z,L,P,D,F,q=(1-g)*o.magnitude(e)/(.5*o.magnitude(A)),_=0;do{q-=_,O=1/(1+q*x),I=1/(1+q*C),N=1/(1+q*S),R=O*O,z=I*I,L=N*N,P=R*O,D=z*I,F=L*N,M=p*R+d*z+w*L-1,T=p*P*x+d*D*C+w*F*S;var B=-2*T;_=M/B}while(Math.abs(M)>i.EPSILON12);return r(t)?(t.x=a*O,t.y=s*I,t.z=u*N,t):new o(a*O,s*I,u*N)},s.prototype.scaleToGeocentricSurface=function(e,t){if(!r(e))throw new n("cartesian is required.");var i=e.x,a=e.y,s=e.z,u=this._oneOverRadiiSquared,l=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return o.multiplyByScalar(e,l,t)},s.prototype.transformPositionToScaledSpace=function(e,t){return o.multiplyComponents(e,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(e,t){return o.multiplyComponents(e,this._radii,t)},s.prototype.equals=function(e){return this===e||r(e)&&o.equals(this._radii,e._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Ellipsoid"],function(e,t,r,n,i){"use strict";var o=function(t){this._ellipsoid=e(t,i.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return o.prototype.getEllipsoid=function(){return this._ellipsoid},o.prototype.project=function(e,n){var i=this._semimajorAxis,o=e.longitude*i,a=e.latitude*i,s=e.height;return t(n)?(n.x=o,n.y=a,n.z=s,n):new r(o,a,s)},o.prototype.unproject=function(e,r){var i=this._oneOverSemimajorAxis,o=e.x*i,a=e.y*i,s=e.z;return t(r)?(r.longitude=o,r.latitude=a,r.height=s,r):new n(o,a,s)},o}),define("Core/Enumeration",["./defined"],function(e){"use strict";var t=function(t,r,n){if(this.value=t,this.name=r,e(n))for(var i in n)n.hasOwnProperty(i)&&(this[i]=n[i])};return t.prototype.valueOf=function(){return this.value},t.prototype.toString=function(){return this.name},t}),define("Core/Intersect",["./Enumeration"],function(e){"use strict";var t={OUTSIDE:new e(-1,"OUTSIDE"),INTERSECTING:new e(0,"INTERSECTING"),INSIDE:new e(1,"INSIDE")};return t}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,o){"use strict";function a(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var n=e[l.getElementIndex(f[r],c[r])];t+=2*n*n}return Math.sqrt(t)}function u(e,t){for(var r=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var s=Math.abs(e[l.getElementIndex(f[a],c[a])]);s>n&&(i=a,n=s)}var u=1,m=0,h=c[i],y=f[i];if(Math.abs(e[l.getElementIndex(y,h)])>r){var p,d=e[l.getElementIndex(y,y)],w=e[l.getElementIndex(h,h)],v=e[l.getElementIndex(y,h)],g=(d-w)/2/v;p=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),u=1/Math.sqrt(1+p*p),m=p*u}return t=l.clone(l.IDENTITY,t),t[l.getElementIndex(h,h)]=t[l.getElementIndex(y,y)]=u,t[l.getElementIndex(y,h)]=m,t[l.getElementIndex(h,y)]=-m,t}var l=function(e,r,n,i,o,a,s,u,l){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(o,0),this[5]=t(u,0),this[6]=t(n,0),this[7]=t(a,0),this[8]=t(l,0)};l.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,n,i){return n=t(n,0),r(i)||(i=new l),i[0]=e[n],i[1]=e[n+1],i[2]=e[n+2],i[3]=e[n+3],i[4]=e[n+4],i[5]=e[n+5],i[6]=e[n+6],i[7]=e[n+7],i[8]=e[n+8],i[9]=e[n+9],i},l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,t){var n=e.x*e.x,i=e.x*e.y,o=e.x*e.z,a=e.x*e.w,s=e.y*e.y,u=e.y*e.z,c=e.y*e.w,f=e.z*e.z,m=e.z*e.w,h=e.w*e.w,y=n-s-f+h,p=2*(i-m),d=2*(o+c),w=2*(i+m),v=-n+s-f+h,g=2*(u-a),E=2*(o-c),b=2*(u+a),x=-n-s+f+h;return r(t)?(t[0]=y,t[1]=w,t[2]=E,t[3]=p,t[4]=v,t[5]=b,t[6]=d,t[7]=g,t[8]=x,t):new l(y,p,d,w,v,g,E,b,x)},l.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new l(e,0,0,0,e,0,0,0,e)},l.fromRotationX=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=i,t[6]=0,t[7]=-i,t[8]=n,t):new l(1,0,0,0,n,-i,0,i,n)},l.fromRotationY=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=n,t):new l(n,0,i,0,1,0,-i,0,n)},l.fromRotationZ=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=i,t[2]=0,t[3]=-i,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new l(n,-i,0,i,n,0,0,0,1)},l.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,t){return 3*e+t},l.getColumn=function(t,n,i){var o=3*n,a=t[o],s=t[o+1],u=t[o+2];return r(i)?(i.x=a,i.y=s,i.z=u,i):new e(a,s,u)},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var i=3*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n},l.getRow=function(t,n,i){var o=t[n],a=t[n+3],s=t[n+6];return r(i)?(i.x=o,i.y=a,i.z=s,i):new e(o,a,s)},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n},l.multiply=function(e,t,n){var i=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],s=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],f=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],m=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],h=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r(n)?(n[0]=i,n[1]=o,n[2]=a,n[3]=s,n[4]=u,n[5]=c,n[6]=f,n[7]=m,n[8]=h,n):new l(i,s,f,o,u,m,a,c,h)},l.multiplyByVector=function(t,n,i){var o=n.x,a=n.y,s=n.z,u=t[0]*o+t[3]*a+t[6]*s,l=t[1]*o+t[4]*a+t[7]*s,c=t[2]*o+t[5]*a+t[8]*s;return r(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByScalar=function(e,t,n){return r(n)?(n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n):new l(e[0]*t,e[3]*t,e[6]*t,e[1]*t,e[4]*t,e[7]*t,e[2]*t,e[5]*t,e[8]*t)},l.negate=function(e,t){return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t):new l(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},l.transpose=function(e,t){var n=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],c=e[2],f=e[5],m=e[8];return r(t)?(t[0]=n,t[1]=i,t[2]=o,t[3]=a,t[4]=s,t[5]=u,t[6]=c,t[7]=f,t[8]=m,t):new l(n,a,c,i,s,f,o,u,m)};var c=[1,0,0],f=[2,2,1],m=new l,h=new l;return l.getEigenDecomposition=function(e,t){var n=o.EPSILON20,i=10,c=0,f=0;r(t)||(t={});for(var y=t.unitary=l.clone(l.IDENTITY,t.unitary),p=t.diagonal=l.clone(e,t.diagonal),d=n*a(p);i>f&&s(p)>d;)u(p,m),l.transpose(m,h),l.multiply(p,m,p),l.multiply(h,p,p),l.multiply(y,m,y),++c>2&&(++f,c=0);return t},l.abs=function(e,t){return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t):new l(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},l.determinant=function(e){if(!r(e))throw new n("matrix is required");var t=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],l=e[2],c=e[5],f=e[8];return t*(s*f-c*u)+a*(c*o-i*f)+l*(i*u-s*o)},l.inverse=function(e,t){if(!r(e))throw new n("matrix is required");var i=e[0],a=e[1],s=e[2],u=e[3],c=e[4],f=e[5],m=e[6],h=e[7],y=e[8],p=l.determinant(e);if(Math.abs(p)<=o.EPSILON15)throw new n("matrix is not invertible");var d=new l(c*y-h*f,m*f-u*y,u*h-m*c,h*s-a*y,i*y-m*s,m*a-i*h,a*f-c*s,u*s-i*f,i*c-u*a),w=1/p;return l.multiplyByScalar(d,w,t)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},l.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},l.IDENTITY=i(new l(1,0,0,0,1,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,o,a,s,u){"use strict";var l=function(e,t,n,i,o,a,s,u,l,c,f,m,h,y,p,d){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(l,0),this[3]=r(h,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(c,0),this[7]=r(y,0),this[8]=r(n,0),this[9]=r(s,0),this[10]=r(f,0),this[11]=r(p,0),this[12]=r(i,0),this[13]=r(u,0),this[14]=r(m,0),this[15]=r(d,0)};l.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=function(e,t,i){return t=r(t,0),n(i)||(i=new l),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i[9]=e[t+9],i[10]=e[t+10],i[11]=e[t+11],i[12]=e[t+12],i[13]=e[t+13],i[14]=e[t+14],i[15]=e[t+15],i},l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(e,t,r){return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=0,r[4]=e[3],r[5]=e[4],r[6]=e[5],r[7]=0,r[8]=e[6],r[9]=e[7],r[10]=e[8],r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,r):new l(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},new s,l.fromTranslationQuaternionRotationScale=function(e,t,r,i){n(i)||(i=new l);var o=r.x,a=r.y,s=r.z,u=t.x*t.x,c=t.x*t.y,f=t.x*t.z,m=t.x*t.w,h=t.y*t.y,y=t.y*t.z,p=t.y*t.w,d=t.z*t.z,w=t.z*t.w,v=t.w*t.w,g=u-h-d+v,E=2*(c-w),b=2*(f+p),x=2*(c+w),C=-u+h-d+v,S=2*(y-m),A=2*(f-p),M=2*(y+m),T=-u-h+d+v;return i[0]=g*o,i[1]=x*o,i[2]=A*o,i[3]=0,i[4]=E*a,i[5]=C*a,i[6]=M*a,i[7]=0,i[8]=b*s,i[9]=S*s,i[10]=T*s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},l.fromTranslation=function(e,t){return l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,f=new e,m=new e;l.fromCamera=function(t,r){var i=t.eye,o=t.target,a=t.up;e.normalize(e.subtract(o,i,c),c),e.normalize(e.cross(c,a,f),f),e.normalize(e.cross(f,c,m),m);var s=f.x,u=f.y,h=f.z,y=c.x,p=c.y,d=c.z,w=m.x,v=m.y,g=m.z,E=i.x,b=i.y,x=i.z,C=s*-E+u*-b+h*-x,S=w*-E+v*-b+g*-x,A=y*E+p*b+d*x;return n(r)?(r[0]=s,r[1]=w,r[2]=-y,r[3]=0,r[4]=u,r[5]=v,r[6]=-p,r[7]=0,r[8]=h,r[9]=g,r[10]=-d,r[11]=0,r[12]=C,r[13]=S,r[14]=A,r[15]=1,r):new l(s,u,h,C,w,v,g,S,-y,-p,-d,A,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,r,i,o){var a=Math.tan(.5*e),s=1/a,u=s/t,c=(i+r)/(r-i),f=2*i*r/(r-i);return n(o)?(o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=f,o[15]=0,o):new l(u,0,0,0,0,s,0,0,0,0,c,f,0,0,-1,0)},l.computeOrthographicOffCenter=function(e,t,r,i,o,a,s){var u=1/(t-e),c=1/(i-r),f=1/(a-o),m=-(t+e)*u,h=-(i+r)*c,y=-(a+o)*f;return u*=2,c*=2,f*=-2,n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=m,s[13]=h,s[14]=y,s[15]=1,s):new l(u,0,0,m,0,c,0,h,0,0,f,y,0,0,0,1)},l.computePerspectiveOffCenter=function(e,t,r,i,o,a,s){var u=2*o/(t-e),c=2*o/(i-r),f=(t+e)/(t-e),m=(i+r)/(i-r),h=-(a+o)/(a-o),y=-1,p=-2*a*o/(a-o);return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=m,s[10]=h,s[11]=y,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s):new l(u,0,f,0,0,c,m,0,0,0,h,p,0,0,y,0)},l.computeInfinitePerspectiveOffCenter=function(e,t,r,i,o,a){var s=2*o/(t-e),u=2*o/(i-r),c=(t+e)/(t-e),f=(i+r)/(i-r),m=-1,h=-1,y=-2*o;return n(a)?(a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=m,a[11]=h,a[12]=0,a[13]=0,a[14]=y,a[15]=0,a):new l(s,0,c,0,0,u,f,0,0,0,m,y,0,0,h,0)},l.computeViewportTransformation=function(e,t,i,o){e=r(e,r.EMPTY_OBJECT);var a=r(e.x,0),s=r(e.y,0),u=r(e.width,0),c=r(e.height,0);t=r(t,0),i=r(i,1);var f=.5*u,m=.5*c,h=.5*(i-t),y=f,p=m,d=h,w=a+f,v=s+m,g=t+h,E=1;return n(o)?(o[0]=y,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=p,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=d,o[11]=0,o[12]=w,o[13]=v,o[14]=g,o[15]=E,o):new l(y,0,0,w,0,p,0,v,0,0,d,g,0,0,0,E)},l.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return 4*e+t},l.getColumn=function(e,r,i){var o=4*r,a=e[o],s=e[o+1],u=e[o+2],l=e[o+3];return n(i)?(i.x=a,i.y=s,i.z=u,i.w=l,i):new t(a,s,u,l)},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var i=4*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n[i+3]=r.w,n},l.getRow=function(e,r,i){var o=e[r],a=e[r+4],s=e[r+8],u=e[r+12];return n(i)?(i.x=o,i.y=a,i.z=s,i.w=u,i):new t(o,a,s,u)},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n},l.multiply=function(e,t,r){var i=e[0],o=e[1],a=e[2],s=e[3],u=e[4],c=e[5],f=e[6],m=e[7],h=e[8],y=e[9],p=e[10],d=e[11],w=e[12],v=e[13],g=e[14],E=e[15],b=t[0],x=t[1],C=t[2],S=t[3],A=t[4],M=t[5],T=t[6],O=t[7],I=t[8],N=t[9],R=t[10],z=t[11],L=t[12],P=t[13],D=t[14],F=t[15],q=i*b+u*x+h*C+w*S,_=o*b+c*x+y*C+v*S,B=a*b+f*x+p*C+g*S,U=s*b+m*x+d*C+E*S,G=i*A+u*M+h*T+w*O,W=o*A+c*M+y*T+v*O,Y=a*A+f*M+p*T+g*O,V=s*A+m*M+d*T+E*O,H=i*I+u*N+h*R+w*z,k=o*I+c*N+y*R+v*z,j=a*I+f*N+p*R+g*z,K=s*I+m*N+d*R+E*z,Z=i*L+u*P+h*D+w*F,X=o*L+c*P+y*D+v*F,Q=a*L+f*P+p*D+g*F,J=s*L+m*P+d*D+E*F;return n(r)?(r[0]=q,r[1]=_,r[2]=B,r[3]=U,r[4]=G,r[5]=W,r[6]=Y,r[7]=V,r[8]=H,r[9]=k,r[10]=j,r[11]=K,r[12]=Z,r[13]=X,r[14]=Q,r[15]=J,r):new l(q,G,H,Z,_,W,k,X,B,Y,j,Q,U,V,K,J)},l.multiplyTransformation=function(e,t,r){var i=e[0],o=e[1],a=e[2],s=e[4],u=e[5],c=e[6],f=e[8],m=e[9],h=e[10],y=e[12],p=e[13],d=e[14],w=t[0],v=t[1],g=t[2],E=t[4],b=t[5],x=t[6],C=t[8],S=t[9],A=t[10],M=t[12],T=t[13],O=t[14],I=i*w+s*v+f*g,N=o*w+u*v+m*g,R=a*w+c*v+h*g,z=i*E+s*b+f*x,L=o*E+u*b+m*x,P=a*E+c*b+h*x,D=i*C+s*S+f*A,F=o*C+u*S+m*A,q=a*C+c*S+h*A,_=i*M+s*T+f*O+y,B=o*M+u*T+m*O+p,U=a*M+c*T+h*O+d;
return n(r)?(r[0]=I,r[1]=N,r[2]=R,r[3]=0,r[4]=z,r[5]=L,r[6]=P,r[7]=0,r[8]=D,r[9]=F,r[10]=q,r[11]=0,r[12]=_,r[13]=B,r[14]=U,r[15]=1,r):new l(I,z,D,_,N,L,F,B,R,P,q,U,0,0,0,1)},l.multiplyByTranslation=function(e,t,r){var i=t.x,o=t.y,a=t.z,s=i*e[0]+o*e[4]+a*e[8]+e[12],u=i*e[1]+o*e[5]+a*e[9]+e[13],c=i*e[2]+o*e[6]+a*e[10]+e[14];return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=s,r[13]=u,r[14]=c,r[15]=e[15],r):new l(e[0],e[4],e[8],s,e[1],e[5],e[9],u,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var h=new e;return l.multiplyByUniformScale=function(e,t,r){return h.x=t,h.y=t,h.z=t,l.multiplyByScale(e,h,r)},l.multiplyByScale=function(e,t,r){var i=t.x,o=t.y,a=t.z;return 1===i&&1===o&&1===a?l.clone(e,r):n(r)?(r[0]=i*e[0],r[1]=i*e[1],r[2]=i*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=a*e[8],r[9]=a*e[9],r[10]=a*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r):new l(i*e[0],o*e[4],a*e[8],e[12],i*e[1],o*e[5],a*e[9],e[13],i*e[2],o*e[6],a*e[10],e[14],0,0,0,1)},l.multiplyByVector=function(e,r,i){var o=r.x,a=r.y,s=r.z,u=r.w,l=e[0]*o+e[4]*a+e[8]*s+e[12]*u,c=e[1]*o+e[5]*a+e[9]*s+e[13]*u,f=e[2]*o+e[6]*a+e[10]*s+e[14]*u,m=e[3]*o+e[7]*a+e[11]*s+e[15]*u;return n(i)?(i.x=l,i.y=c,i.z=f,i.w=m,i):new t(l,c,f,m)},l.multiplyByPointAsVector=function(t,r,i){var o=r.x,a=r.y,s=r.z,u=t[0]*o+t[4]*a+t[8]*s,l=t[1]*o+t[5]*a+t[9]*s,c=t[2]*o+t[6]*a+t[10]*s;return n(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByPoint=function(t,r,i){var o=r.x,a=r.y,s=r.z,u=t[0]*o+t[4]*a+t[8]*s+t[12],l=t[1]*o+t[5]*a+t[9]*s+t[13],c=t[2]*o+t[6]*a+t[10]*s+t[14];return n(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByScalar=function(e,t,r){return n(r)?(r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r):new l(e[0]*t,e[4]*t,e[8]*t,e[12]*t,e[1]*t,e[5]*t,e[9]*t,e[13]*t,e[2]*t,e[6]*t,e[10]*t,e[14]*t,e[3]*t,e[7]*t,e[11]*t,e[15]*t)},l.negate=function(e,t){return n(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t):new l(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},l.transpose=function(e,t){if(!n(t))return new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var r=e[1],i=e[2],o=e[3],a=e[6],s=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=s,t[14]=u,t[15]=e[15],t},l.abs=function(e,t){return n(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t):new l(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},l.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[11]===t[11]&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},l.getTranslation=function(t,r){return n(r)?(r.x=t[12],r.y=t[13],r.z=t[14],r):new e(t[12],t[13],t[14])},l.getRotation=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},l.inverse=function(e,t){var r=e[0],i=e[4],o=e[8],s=e[12],c=e[1],f=e[5],m=e[9],h=e[13],y=e[2],p=e[6],d=e[10],w=e[14],v=e[3],g=e[7],E=e[11],b=e[15],x=d*b,C=w*E,S=p*b,A=w*g,M=p*E,T=d*g,O=y*b,I=w*v,N=y*E,R=d*v,z=y*g,L=p*v,P=x*f+A*m+M*h-(C*f+S*m+T*h),D=C*c+O*m+R*h-(x*c+I*m+N*h),F=S*c+I*f+z*h-(A*c+O*f+L*h),q=T*c+N*f+L*m-(M*c+R*f+z*m),_=C*i+S*o+T*s-(x*i+A*o+M*s),B=x*r+I*o+N*s-(C*r+O*o+R*s),U=A*r+O*i+L*s-(S*r+I*i+z*s),G=M*r+R*i+z*o-(T*r+N*i+L*o);x=o*h,C=s*m,S=i*h,A=s*f,M=i*m,T=o*f,O=r*h,I=s*c,N=r*m,R=o*c,z=r*f,L=i*c;var W=x*g+A*E+M*b-(C*g+S*E+T*b),Y=C*v+O*E+R*b-(x*v+I*E+N*b),V=S*v+I*g+z*b-(A*v+O*g+L*b),H=T*v+N*g+L*E-(M*v+R*g+z*E),k=S*d+T*w+C*p-(M*w+x*p+A*d),j=N*w+x*y+I*d-(O*d+R*w+C*y),K=O*p+L*w+A*y-(z*w+S*y+I*p),Z=z*d+M*y+R*p-(N*p+L*d+T*y),X=r*P+i*D+o*F+s*q;if(Math.abs(X)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return X=1/X,n(t)?(t[0]=P*X,t[1]=D*X,t[2]=F*X,t[3]=q*X,t[4]=_*X,t[5]=B*X,t[6]=U*X,t[7]=G*X,t[8]=W*X,t[9]=Y*X,t[10]=V*X,t[11]=H*X,t[12]=k*X,t[13]=j*X,t[14]=K*X,t[15]=Z*X,t):new l(P*X,_*X,W*X,k*X,D*X,B*X,Y*X,j*X,F*X,U*X,V*X,K*X,q*X,G*X,H*X,Z*X)},l.inverseTransformation=function(e,t){var r=e[0],i=e[1],o=e[2],a=e[4],s=e[5],u=e[6],c=e[8],f=e[9],m=e[10],h=e[12],y=e[13],p=e[14],d=-r*h-i*y-o*p,w=-a*h-s*y-u*p,v=-c*h-f*y-m*p;return n(t)?(t[0]=r,t[1]=a,t[2]=c,t[3]=0,t[4]=i,t[5]=s,t[6]=f,t[7]=0,t[8]=o,t[9]=u,t[10]=m,t[11]=0,t[12]=d,t[13]=w,t[14]=v,t[15]=1,t):new l(r,i,o,d,a,s,u,w,c,f,m,v,0,0,0,1)},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/BoundingSphere",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Cartesian4","./Cartographic","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4"],function(e,t,r,n,i,o,a,s,u,l,c){"use strict";var f=function(t,r){this.center=n.clone(e(t,n.ZERO)),this.radius=e(r,0)},m=new n,h=new n,y=new n,p=new n,d=new n,w=new n,v=new n,g=new n,E=new n,b=new n,x=new n,C=new n;f.fromPoints=function(e,r){if(t(r)||(r=new f),!t(e)||0===e.length)return r.center=n.clone(n.ZERO,r.center),r.radius=0,r;for(var i=n.clone(e[0],v),o=n.clone(i,m),a=n.clone(i,h),s=n.clone(i,y),u=n.clone(i,p),l=n.clone(i,d),c=n.clone(i,w),S=e.length,A=1;S>A;A++){n.clone(e[A],i);var M=i.x,T=i.y,O=i.z;M<o.x&&n.clone(i,o),M>u.x&&n.clone(i,u),T<a.y&&n.clone(i,a),T>l.y&&n.clone(i,l),O<s.z&&n.clone(i,s),O>c.z&&n.clone(i,c)}var I=n.magnitudeSquared(n.subtract(u,o,g)),N=n.magnitudeSquared(n.subtract(l,a,g)),R=n.magnitudeSquared(n.subtract(c,s,g)),z=o,L=u,P=I;N>P&&(P=N,z=a,L=l),R>P&&(P=R,z=s,L=c);var D=E;D.x=.5*(z.x+L.x),D.y=.5*(z.y+L.y),D.z=.5*(z.z+L.z);var F=n.magnitudeSquared(n.subtract(L,D,g)),q=Math.sqrt(F),_=b;_.x=o.x,_.y=a.y,_.z=s.z;var B=x;B.x=u.x,B.y=l.y,B.z=c.z;var U=n.multiplyByScalar(n.add(_,B,g),.5,C),G=0;for(A=0;S>A;A++){n.clone(e[A],i);var W=n.magnitude(n.subtract(i,U,g));W>G&&(G=W);var Y=n.magnitudeSquared(n.subtract(i,D,g));if(Y>F){var V=Math.sqrt(Y);q=.5*(q+V),F=q*q;var H=V-q;D.x=(q*D.x+H*i.x)/V,D.y=(q*D.y+H*i.y)/V,D.z=(q*D.z+H*i.z)/V}}return G>q?(n.clone(D,r.center),r.radius=q):(n.clone(U,r.center),r.radius=G),r};var S=new s,A=new n,M=new n,T=new o,O=new o;f.fromExtent2D=function(e,t,r){return f.fromExtentWithHeights2D(e,t,0,0,r)},f.fromExtentWithHeights2D=function(r,i,o,a,s){if(t(s)||(s=new f),!t(r))return s.center=n.clone(n.ZERO,s.center),s.radius=0,s;i=e(i,S),r.getSouthwest(T),T.height=o,r.getNortheast(O),O.height=a;var u=i.project(T,A),l=i.project(O,M),c=l.x-u.x,m=l.y-u.y,h=l.z-u.z;s.radius=.5*Math.sqrt(c*c+m*m+h*h);var y=s.center;return y.x=u.x+.5*c,y.y=u.y+.5*m,y.z=u.z+.5*h,s};var I=[];f.fromExtent3D=function(r,n,i,o){n=e(n,a.WGS84),i=e(i,0);var s;return t(r)&&(s=r.subsample(n,i,I)),f.fromPoints(s,o)},f.fromVertices=function(r,i,o,a){if(t(a)||(a=new f),!t(r)||0===r.length)return a.center=n.clone(n.ZERO,a.center),a.radius=0,a;i=e(i,n.ZERO),o=e(o,3);var s=v;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var u=n.clone(s,m),l=n.clone(s,h),c=n.clone(s,y),S=n.clone(s,p),A=n.clone(s,d),M=n.clone(s,w),T=r.length,O=0;T>O;O+=o){var I=r[O]+i.x,N=r[O+1]+i.y,R=r[O+2]+i.z;s.x=I,s.y=N,s.z=R,I<u.x&&n.clone(s,u),I>S.x&&n.clone(s,S),N<l.y&&n.clone(s,l),N>A.y&&n.clone(s,A),R<c.z&&n.clone(s,c),R>M.z&&n.clone(s,M)}var z=n.magnitudeSquared(n.subtract(S,u,g)),L=n.magnitudeSquared(n.subtract(A,l,g)),P=n.magnitudeSquared(n.subtract(M,c,g)),D=u,F=S,q=z;L>q&&(q=L,D=l,F=A),P>q&&(q=P,D=c,F=M);var _=E;_.x=.5*(D.x+F.x),_.y=.5*(D.y+F.y),_.z=.5*(D.z+F.z);var B=n.magnitudeSquared(n.subtract(F,_,g)),U=Math.sqrt(B),G=b;G.x=u.x,G.y=l.y,G.z=c.z;var W=x;W.x=S.x,W.y=A.y,W.z=M.z;var Y=n.multiplyByScalar(n.add(G,W,g),.5,C),V=0;for(O=0;T>O;O+=o){s.x=r[O]+i.x,s.y=r[O+1]+i.y,s.z=r[O+2]+i.z;var H=n.magnitude(n.subtract(s,Y,g));H>V&&(V=H);var k=n.magnitudeSquared(n.subtract(s,_,g));if(k>B){var j=Math.sqrt(k);U=.5*(U+j),B=U*U;var K=j-U;_.x=(U*_.x+K*s.x)/j,_.y=(U*_.y+K*s.y)/j,_.z=(U*_.z+K*s.z)/j}}return V>U?(n.clone(_,a.center),a.radius=U):(n.clone(Y,a.center),a.radius=V),a},f.fromCornerPoints=function(e,r,i){t(i)||(i=new f);var o=i.center;return n.add(e,r,o),n.multiplyByScalar(o,.5,o),i.radius=n.distance(o,r),i},f.fromEllipsoid=function(e,r){return t(r)||(r=new f),n.clone(n.ZERO,r.center),r.radius=e.getMaximumRadius(),r},f.clone=function(e,r){return t(e)?t(r)?(r.center=n.clone(e.center,r.center),r.radius=e.radius,r):new f(e.center,e.radius):void 0};var N=new n,R=new n;f.union=function(e,r,i){t(i)||(i=new f);var o=e.center,a=r.center;n.add(o,a,R);var s=n.multiplyByScalar(R,.5,R),u=n.magnitude(n.subtract(o,s,N))+e.radius,l=n.magnitude(n.subtract(a,s,N))+r.radius;return i.radius=Math.max(u,l),n.clone(s,i.center),i};var z=new n;f.expand=function(e,t,r){r=f.clone(e,r);var i=n.magnitude(n.subtract(t,r.center,z));return i>r.radius&&(r.radius=i),r},f.intersect=function(e,t){var r=e.center,i=e.radius,o=n.dot(t,r)+t.w;return-i>o?u.OUTSIDE:i>o?u.INTERSECTING:u.INSIDE};var L=new n;f.transform=function(e,r,i){return t(i)||(i=new f),i.center=c.multiplyByPoint(r,e.center,i.center),i.radius=Math.max(n.magnitude(c.getColumn(r,0,L)),n.magnitude(c.getColumn(r,1,L)),n.magnitude(c.getColumn(r,2,L)))*e.radius,i},f.transformWithoutScale=function(e,r,n){return t(n)||(n=new f),n.center=c.multiplyByPoint(r,e.center,n.center),n.radius=e.radius,n};var P=new n;f.getPlaneDistances=function(e,r,i,o){t(o)||(o=new l);var a=n.subtract(e.center,r,P),s=n.multiplyByScalar(i,n.dot(i,a),P),u=n.magnitude(s);return o.start=u-e.radius,o.stop=u+e.radius,o};for(var D=new n,F=new n,q=new n,_=new n,B=new n,U=new o,G=new Array(8),W=0;8>W;++W)G[W]=new n;var Y=new s;return f.projectTo2D=function(t,r,i){r=e(r,Y);var o=r.getEllipsoid(),a=t.center,s=t.radius,u=o.geodeticSurfaceNormal(a,D),l=n.cross(n.UNIT_Z,u,F);n.normalize(l,l);var c=n.cross(u,l,q);n.normalize(c,c),n.multiplyByScalar(u,s,u),n.multiplyByScalar(c,s,c),n.multiplyByScalar(l,s,l);var m=n.negate(c,B),h=n.negate(l,_),y=G,p=y[0];n.add(u,c,p),n.add(p,l,p),p=y[1],n.add(u,c,p),n.add(p,h,p),p=y[2],n.add(u,m,p),n.add(p,h,p),p=y[3],n.add(u,m,p),n.add(p,l,p),n.negate(u,u),p=y[4],n.add(u,c,p),n.add(p,l,p),p=y[5],n.add(u,c,p),n.add(p,h,p),p=y[6],n.add(u,m,p),n.add(p,h,p),p=y[7],n.add(u,m,p),n.add(p,l,p);for(var d=y.length,w=0;d>w;++w){var v=y[w];n.add(a,v,v);var g=o.cartesianToCartographic(v,U);r.project(g,v)}i=f.fromPoints(y,i),a=i.center;var E=a.x,b=a.y,x=a.z;return a.x=x,a.y=E,a.z=b,i},f.equals=function(e,r){return e===r||t(e)&&t(r)&&n.equals(e.center,r.center)&&e.radius===r.radius},f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.union=function(e,t){return f.union(this,e,t)},f.prototype.expand=function(e,t){return f.expand(this,e,t)},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.getPlaneDistances=function(e,t,r){return f.getPlaneDistances(this,e,t,r)},f.prototype.projectTo2D=function(e,t){return f.projectTo2D(this,e,t)},f.prototype.equals=function(e){return f.equals(this,e)},f}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r):new i(e.x/n,e.y/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n):new i(e.x*r.x,e.y*r.y)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n):new i(e.x+r.x,e.y+r.y)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n):new i(e.x-r.x,e.y-r.y)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n):new i(e.x*r,e.y*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n):new i(e.x/r,e.y/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r):new i(-e.x,-e.y)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r):new i(Math.abs(e.x),Math.abs(e.y))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i,u=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,u),Math.acos(i.dot(s,u))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/Fullscreen",["./defined"],function(e){"use strict";var t,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return n.supportsFullscreen=function(){if(e(t))return t;t=!1;var n=document.body;if("function"==typeof n.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];i=u+"RequestFullscreen","function"==typeof n[i]?(r.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof n[i]&&(r.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?r.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(r.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?r.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(r.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),r.fullscreenerror=i)}return t},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[r.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[r.exitFullscreen]()},n.isFullscreenEnabled=function(){return n.supportsFullscreen()?document[r.fullscreenEnabled]:void 0},n.getFullscreenElement=function(){return n.supportsFullscreen()?document[r.fullscreenElement]:void 0},n.isFullscreen=function(){return n.supportsFullscreen()?null!==n.getFullscreenElement():void 0},n.getFullscreenChangeEventName=function(){return n.supportsFullscreen()?r.fullscreenchange:void 0},n.getFullscreenErrorEventName=function(){return n.supportsFullscreen()?r.fullscreenerror:void 0},n}),define("Core/FeatureDetection",["./defined","./Fullscreen"],function(e,t){"use strict";function r(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function n(){if(!e(f)){var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===t?f=!1:(f=!0,m=r(t[1]))}return f}function i(){return n()&&m}function o(){if(!e(h))if(n()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))h=!1;else{var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===t?h=!1:(h=!0,y=r(t[1]))}return h}function a(){return o()&&y}function s(){if(!e(p)){var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===t?p=!1:(p=!0,d=r(t[1]),d.isNightly=!!t[2])}return p}function u(){return s()&&d}function l(){if(!e(w)){var t=/ MSIE ([\.0-9]+)/.exec(navigator.userAgent);null===t?w=!1:(w=!0,v=r(t[1]))}return w}function c(){return l()&&v}var f,m,h,y,p,d,w,v,g,E={isChrome:n,chromeVersion:i,isSafari:o,safariVersion:a,isWebkit:s,webkitVersion:u,isInternetExplorer:l,internetExplorerVersion:c};return E.supportsCrossOriginImagery=function(){return e(g)||(g=o()&&u()[0]<536?!1:"withCredentials"in new XMLHttpRequest),g},E.supportsFullscreen=function(){return t.supportsFullscreen()},E.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},E}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./Enumeration"],function(e,t,r,n,i){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:new i(5120,"BYTE",{sizeInBytes:Int8Array.BYTES_PER_ELEMENT}),UNSIGNED_BYTE:new i(5121,"UNSIGNED_BYTE",{sizeInBytes:Uint8Array.BYTES_PER_ELEMENT}),SHORT:new i(5122,"SHORT",{sizeInBytes:Int16Array.BYTES_PER_ELEMENT}),UNSIGNED_SHORT:new i(5123,"UNSIGNED_SHORT",{sizeInBytes:Uint16Array.BYTES_PER_ELEMENT}),FLOAT:new i(5126,"FLOAT",{sizeInBytes:Float32Array.BYTES_PER_ELEMENT}),DOUBLE:new i(5130,"DOUBLE",{sizeInBytes:Float64Array.BYTES_PER_ELEMENT})};return o.validate=function(e){return t(e)&&t(e.value)&&(e.value===o.BYTE.value||e.value===o.UNSIGNED_BYTE.value||e.value===o.SHORT.value||e.value===o.UNSIGNED_SHORT.value||e.value===o.FLOAT.value||e.value===o.DOUBLE.value)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e.value){case o.BYTE.value:return new Int8Array(n);case o.UNSIGNED_BYTE.value:return new Uint8Array(n);case o.SHORT.value:return new Int16Array(n);case o.UNSIGNED_SHORT.value:return new Uint16Array(n);case o.FLOAT.value:return new Float32Array(n);case o.DOUBLE.value:return new Float64Array(n);default:throw new r("componentDatatype is not a valid enumeration value.")}},o.createArrayBufferView=function(n,i,a,s){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),s=e(s,(i.byteLength-a)/n.sizeInBytes),n.value){case o.BYTE.value:return new Int8Array(i,a,s);case o.UNSIGNED_BYTE.value:return new Uint8Array(i,a,s);case o.SHORT.value:return new Int16Array(i,a,s);case o.UNSIGNED_SHORT.value:return new Uint16Array(i,a,s);case o.FLOAT.value:return new Float32Array(i,a,s);case o.DOUBLE.value:return new Float64Array(i,a,s);default:throw new r("componentDatatype is not a valid enumeration value.")}},o}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,t,r){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(t){return e(t)&&(t===n.UNSIGNED_BYTE||t===n.UNSIGNED_SHORT||t===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new t("numberOfVertices is required.");return n>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/Extent",["./freezeObject","./defaultValue","./defined","./Ellipsoid","./Cartographic","./DeveloperError","./Math"],function(e,t,r,n,i,o,a){"use strict";var s=function(e,r,n,i){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(i,0)};s.fromDegrees=function(e,n,i,o,u){return e=a.toRadians(t(e,0)),n=a.toRadians(t(n,0)),i=a.toRadians(t(i,0)),o=a.toRadians(t(o,0)),r(u)?(u.west=e,u.south=n,u.east=i,u.north=o,u):new s(e,n,i,o)},s.fromCartographicArray=function(e,t){if(!r(e))throw new o("cartographics is required.");for(var n=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,l=0,c=e.length;c>l;l++){var f=e[l];n=Math.min(n,f.longitude),i=Math.max(i,f.longitude),a=Math.min(a,f.latitude),u=Math.max(u,f.latitude)}return r(t)?(t.west=n,t.south=a,t.east=i,t.north=u,t):new s(n,a,i,u)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){if("number"!=typeof t)throw new o("epsilon is required and must be a number.");return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.prototype.validate=function(){var e=this.north;if("number"!=typeof e)throw new o("north is required to be a number.");if(e<-a.PI_OVER_TWO||e>a.PI_OVER_TWO)throw new o("north must be in the interval [-Pi/2, Pi/2].");var t=this.south;if("number"!=typeof t)throw new o("south is required to be a number.");if(t<-a.PI_OVER_TWO||t>a.PI_OVER_TWO)throw new o("south must be in the interval [-Pi/2, Pi/2].");var r=this.west;if("number"!=typeof r)throw new o("west is required to be a number.");if(r<-Math.PI||r>Math.PI)throw new o("west must be in the interval [-Pi, Pi].");var n=this.east;if("number"!=typeof n)throw new o("east is required to be a number.");if(n<-Math.PI||n>Math.PI)throw new o("east must be in the interval [-Pi, Pi].")},s.prototype.getSouthwest=function(e){return r(e)?(e.longitude=this.west,e.latitude=this.south,e.height=0,e):new i(this.west,this.south)},s.prototype.getNorthwest=function(e){return r(e)?(e.longitude=this.west,e.latitude=this.north,e.height=0,e):new i(this.west,this.north)},s.prototype.getNortheast=function(e){return r(e)?(e.longitude=this.east,e.latitude=this.north,e.height=0,e):new i(this.east,this.north)},s.prototype.getSoutheast=function(e){return r(e)?(e.longitude=this.east,e.latitude=this.south,e.height=0,e):new i(this.east,this.south)},s.prototype.getCenter=function(e){return r(e)?(e.longitude=.5*(this.west+this.east),e.latitude=.5*(this.south+this.north),e.height=0,e):new i(.5*(this.west+this.east),.5*(this.south+this.north))},s.prototype.intersectWith=function(e,t){if(!r(e))throw new o("otherExtent is required.");var n=Math.max(this.west,e.west),i=Math.max(this.south,e.south),a=Math.min(this.east,e.east),u=Math.min(this.north,e.north);return r(t)?(t.west=n,t.south=i,t.east=a,t.north=u,t):new s(n,i,a,u)},s.prototype.contains=function(e){if(!r(e))throw new o("cartographic is required.");return e.longitude>=this.west&&e.longitude<=this.east&&e.latitude>=this.south&&e.latitude<=this.north},s.prototype.isEmpty=function(){return this.west>=this.east||this.south>=this.north};var u=new i;return s.prototype.subsample=function(e,i,o){e=t(e,n.WGS84),i=t(i,0),r(o)||(o=[]);var s=0,l=this.north,c=this.south,f=this.east,m=this.west,h=u;h.height=i,h.longitude=m,h.latitude=l,o[s]=e.cartographicToCartesian(h,o[s]),s++,h.longitude=f,o[s]=e.cartographicToCartesian(h,o[s]),s++,h.latitude=c,o[s]=e.cartographicToCartesian(h,o[s]),s++,h.longitude=m,o[s]=e.cartographicToCartesian(h,o[s]),s++,h.latitude=0>l?l:c>0?c:0;for(var y=1;8>y;++y){var p=-Math.PI+y*a.PI_OVER_TWO;p>m&&f>p&&(h.longitude=p,o[s]=e.cartographicToCartesian(h,o[s]),s++)}return 0===h.latitude&&(h.longitude=m,o[s]=e.cartographicToCartesian(h,o[s]),s++,h.longitude=f,o[s]=e.cartographicToCartesian(h,o[s]),s++),o.length=s,o},s.MAX_VALUE=e(new s(-Math.PI,-a.PI_OVER_TWO,Math.PI,a.PI_OVER_TWO)),s}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./BoundingSphere"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.attributes))throw new r("options.attributes is required.");if(!t(n.primitiveType))throw new r("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=a}return n},n}),define("Core/GeometryInstanceAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.value))throw new r("options.value is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.value=n.value};return n}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4","./Geometry","./GeometryInstanceAttribute"],function(e,t,r,n){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.geometry))throw new r("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{})};return i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i=new t,o=new t,a=new t,s=function(s,u,l,c,f){if(!(r(s)&&r(u)&&r(l)&&r(c)))throw new n("point, p0, p1, and p2 are required.");r(f)||(f=new t);var m,h,y,p,d,w,v,g;r(u.z)?(m=t.subtract(l,u,i),h=t.subtract(c,u,o),y=t.subtract(s,u,a),p=t.dot(m,m),d=t.dot(m,h),w=t.dot(m,y),v=t.dot(h,h),g=t.dot(h,y)):(m=e.subtract(l,u,i),h=e.subtract(c,u,o),y=e.subtract(s,u,a),p=e.dot(m,m),d=e.dot(m,h),w=e.dot(m,y),v=e.dot(h,h),g=e.dot(h,y));var E=1/(p*v-d*d);return f.y=(v*w-d*g)*E,f.z=(p*g-d*w)*E,f.x=1-f.y-f.z,f};return s}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!t(e))throw new r("value is required");t(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){if(!t(e))throw new r("cartesian is required");t(o)||(o=new n);var a=o.high,s=o.low;return n.encode(e.x,i),a.x=i.high,s.x=i.low,n.encode(e.y,i),a.y=i.high,s.y=i.low,n.encode(e.z,i),a.z=i.high,s.z=i.low,o};var o=new n;return n.writeElements=function(e,i,a){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("cartesianArray is required");if("number"!=typeof a||0>a)throw new r("index must be a number greater than or equal to 0.");n.fromCartesian(e,o);var s=o.high,u=o.low;i[a]=s.x,i[a+1]=s.y,i[a+2]=s.z,i[a+3]=u.x,i[a+4]=u.y,i[a+5]=u.z},n}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.discriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.realRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var s=Math.abs(o),u=Math.abs(n);if(u>s&&s/u<t.EPSILON14)return[0,0];if(s>u&&u/s<t.EPSILON14)return[];if(a=-o/n,0>a)return[];var l=Math.sqrt(a);return[-l,l]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var c=i*i,f=4*n*o,m=r(c,-f,t.EPSILON14);if(0>m)return[];var h=-.5*r(i,t.sign(i)*Math.sqrt(m),t.EPSILON14);return i>0?[h/n,o/h]:[o/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,o,a=e,s=t/3,u=r/3,l=n,c=a*u,f=s*l,m=s*s,h=u*u,y=a*u-m,p=a*l-s*u,d=s*l-h,w=4*y*d-p*p;if(0>w){var v,g,E;m*f>=c*h?(v=a,g=y,E=-2*s*y+a*p):(v=l,g=d,E=-l*p+2*u*d);var b=0>E?-1:1,x=-b*Math.abs(v)*Math.sqrt(-w);o=-E+x;var C=o/2,S=0>C?-Math.pow(-C,1/3):Math.pow(C,1/3),A=o===x?-S:-g/S;return i=0>=g?S+A:-E/(S*S+A*A+g),m*f>=c*h?[(i-s)/a]:[-l/(i+u)]}var M=y,T=-2*s*y+a*p,O=d,I=-l*p+2*u*d,N=Math.sqrt(w),R=Math.sqrt(3)/2,z=Math.abs(Math.atan2(a*N,-T)/3);i=2*Math.sqrt(-M);var L=Math.cos(z);o=i*L;var P=i*(-L/2-R*Math.sin(z)),D=o+P>2*s?o-s:P-s,F=a,q=D/F;z=Math.abs(Math.atan2(l*N,-I)/3),i=2*Math.sqrt(-O),L=Math.cos(z),o=i*L,P=i*(-L/2-R*Math.sin(z));var _=-l,B=2*u>o+P?o+u:P+u,U=_/B,G=F*B,W=-D*B-F*_,Y=D*_,V=(u*W-s*Y)/(-s*W+u*G);return V>=q?U>=q?U>=V?[q,V,U]:[q,U,V]:[U,q,V]:U>=q?[V,q,U]:U>=V?[V,U,q]:[U,V,q]}var n={};return n.discriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=t*t,a=r*r,s=n*n,u=i*i,l=18*t*r*n*i+a*s-27*o*u-4*(t*s*n+a*r*i);return l},n.realRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");
if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===n)return t.realRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];u=-a/n;var l=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[l,l,l]}return 0===a?(s=t.realRoots(n,0,o),0===s.Length?[0]:[s[0],0,s[1]]):r(n,0,o,a)}return 0===o?0===a?(u=-i/n,0>u?[u,0,0]:[0,0,u]):r(n,i,0,a):0===a?(s=t.realRoots(n,i,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):r(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./DeveloperError","./Math","./CubicRealPolynomial","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(e,i,o,a){var s=e*e,u=i-3*s/8,l=o-i*e/2+s*e/8,c=a-o*e/4+i*s/16-3*s*s/256,f=r.realRoots(1,2*u,u*u-4*c,-l*l);if(f.length>0){var m=-e/4,h=f[f.length-1];if(Math.abs(h)<t.EPSILON14){var y=n.realRoots(1,u,c);if(2===y.length){var p,d=y[0],w=y[1];if(d>=0&&w>=0){var v=Math.sqrt(d),g=Math.sqrt(w);return[m-g,m-v,m+v,m+g]}if(d>=0&&0>w)return p=Math.sqrt(d),[m-p,m+p];if(0>d&&w>=0)return p=Math.sqrt(w),[m-p,m+p]}return[]}if(h>0){var E=Math.sqrt(h),b=(u+h-l/E)/2,x=(u+h+l/E)/2,C=n.realRoots(1,E,b),S=n.realRoots(1,-E,x);return 0!==C.length?(C[0]+=m,C[1]+=m,0!==S.length?(S[0]+=m,S[1]+=m,C[1]<=S[0]?[C[0],C[1],S[0],S[1]]:S[1]<=C[0]?[S[0],S[1],C[0],C[1]]:C[0]>=S[0]&&C[1]<=S[1]?[S[0],C[0],C[1],S[1]]:S[0]>=C[0]&&S[1]<=C[1]?[C[0],S[0],S[1],C[1]]:C[0]>S[0]&&C[0]<S[1]?[S[0],C[0],S[1],C[1]]:[C[0],S[0],C[1],S[1]]):C):0!==S.length?(S[0]+=m,S[1]+=m,S):[]}}return[]}function o(e,i,o,a){var s=o*o,u=i*i,l=e*e,c=-2*i,f=o*e+u-4*a,m=l*a-o*i*e+s,h=r.realRoots(1,c,f,m);if(h.length>0){var y,p,d=h[0],w=i-d,v=w*w,g=e/2,E=w/2,b=v-4*a,x=v+4*Math.abs(a),C=l-4*d,S=l+4*Math.abs(d);if(0>d||C*x>b*S){var A=Math.sqrt(C);y=A/2,p=0===A?0:(e*E-o)/A}else{var M=Math.sqrt(b);y=0===M?0:(e*E-o)/M,p=M/2}var T,O;0===g&&0===y?(T=0,O=0):t.sign(g)===t.sign(y)?(T=g+y,O=d/T):(O=g-y,T=d/O);var I,N;0===E&&0===p?(I=0,N=0):t.sign(E)===t.sign(p)?(I=E+p,N=a/I):(N=E-p,I=a/N);var R=n.realRoots(1,T,I),z=n.realRoots(1,O,N);if(0!==R.length)return 0!==z.length?R[1]<=z[0]?[R[0],R[1],z[0],z[1]]:z[1]<=R[0]?[z[0],z[1],R[0],R[1]]:R[0]>=z[0]&&R[1]<=z[1]?[z[0],R[0],R[1],z[1]]:z[0]>=R[0]&&z[1]<=R[1]?[R[0],z[0],z[1],R[1]]:R[0]>z[0]&&R[0]<z[1]?[z[0],R[0],z[1],R[1]]:[R[0],z[0],R[1],z[1]]:R;if(0!==z.length)return z}return[]}var a={};return a.discriminant=function(t,r,n,i,o){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");if("number"!=typeof o)throw new e("e is a required number.");var a=t*t,s=a*t,u=r*r,l=u*r,c=n*n,f=c*n,m=i*i,h=m*i,y=o*o,p=y*o,d=u*c*m-4*l*h-4*t*f*m+18*t*r*n*h-27*a*m*m+256*s*p+o*(18*l*n*i-4*u*f+16*t*c*c-80*t*r*c*i-6*t*u*m+144*a*n*m)+y*(144*t*u*n-27*u*u-128*a*c-192*a*r*i);return d},a.realRoots=function(n,a,s,u,l){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof a)throw new e("b is a required number.");if("number"!=typeof s)throw new e("c is a required number.");if("number"!=typeof u)throw new e("d is a required number.");if("number"!=typeof l)throw new e("e is a required number.");if(Math.abs(n)<t.EPSILON15)return r.realRoots(a,s,u,l);var c=a/n,f=s/n,m=u/n,h=l/n,y=0>c?1:0;switch(y+=0>f?y+1:y,y+=0>m?y+1:y,y+=0>h?y+1:y){case 0:return i(c,f,m,h);case 1:return o(c,f,m,h);case 2:return o(c,f,m,h);case 3:return i(c,f,m,h);case 4:return i(c,f,m,h);case 5:return o(c,f,m,h);case 6:return i(c,f,m,h);case 7:return i(c,f,m,h);case 8:return o(c,f,m,h);case 9:return i(c,f,m,h);case 10:return i(c,f,m,h);case 11:return o(c,f,m,h);case 12:return i(c,f,m,h);case 13:return i(c,f,m,h);case 14:return i(c,f,m,h);case 15:return i(c,f,m,h);default:return void 0}},a}),define("Core/IntersectionTests",["./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,t,r,n,i,o,a,s){"use strict";function u(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}function l(e,t,i,l,c){var f,m=l*l,h=c*c,y=(e[o.COLUMN1ROW1]-e[o.COLUMN2ROW2])*h,p=c*(l*u(e[o.COLUMN1ROW0],e[o.COLUMN0ROW1],r.EPSILON15)+t.y),d=e[o.COLUMN0ROW0]*m+e[o.COLUMN2ROW2]*h+l*t.x+i,w=h*u(e[o.COLUMN2ROW1],e[o.COLUMN1ROW2],r.EPSILON15),v=c*(l*u(e[o.COLUMN2ROW0],e[o.COLUMN0ROW2])+t.z),g=[];if(0===v&&0===w){if(f=a.realRoots(y,p,d),0===f.length)return g;var E=f[0],b=Math.sqrt(Math.max(1-E*E,0));if(g.push(new n(l,c*E,c*-b)),g.push(new n(l,c*E,c*b)),2===f.length){var x=f[1],C=Math.sqrt(Math.max(1-x*x,0));g.push(new n(l,c*x,c*-C)),g.push(new n(l,c*x,c*C))}return g}var S=v*v,A=w*w,M=y*y,T=v*w,O=M+A,I=2*(p*y+T),N=2*d*y+p*p-A+S,R=2*(d*p-T),z=d*d-S;if(0===O&&0===I&&0===N&&0===R)return g;f=s.realRoots(O,I,N,R,z);var L=f.length;if(0===L)return g;for(var P=0;L>P;++P){var D,F=f[P],q=F*F,_=Math.max(1-q,0),B=Math.sqrt(_);D=r.sign(y)===r.sign(d)?u(y*q+d,p*F,r.EPSILON12):r.sign(d)===r.sign(p*F)?u(y*q,p*F+d,r.EPSILON12):u(y*q+p*F,d,r.EPSILON12);var U=u(w*F,v,r.EPSILON15),G=D*U;0>G?g.push(new n(l,c*F,c*B)):G>0?g.push(new n(l,c*F,c*-B)):0!==B?(g.push(new n(l,c*F,c*-B)),g.push(new n(l,c*F,c*B)),++P):g.push(new n(l,c*F,c*B))}return g}var c={};c.rayPlane=function(i,o,a){if(!e(i))throw new t("ray is required.");if(!e(o))throw new t("plane is required.");var s=i.origin,u=i.direction,l=o.normal,c=n.dot(l,u);if(Math.abs(c)<r.EPSILON15)return void 0;var f=(-o.distance-n.dot(l,s))/c;return 0>f?void 0:(a=n.multiplyByScalar(u,f,a),n.add(s,a,a))};var f=new n,m=new n;c.rayEllipsoid=function(r,i){if(!e(r))throw new t("ray is required.");if(!e(i))throw new t("ellipsoid is required.");var o,a,s,u,l,c=i.getOneOverRadii(),h=n.multiplyComponents(c,r.origin,f),y=n.multiplyComponents(c,r.direction,m),p=n.magnitudeSquared(h),d=n.dot(h,y);if(p>1){if(d>=0)return void 0;var w=d*d;if(o=p-1,a=n.magnitudeSquared(y),s=a*o,s>w)return void 0;if(w>s){u=d*d-s,l=-d+Math.sqrt(u);var v=l/a,g=o/l;return g>v?{start:v,stop:g}:{start:g,stop:v}}var E=Math.sqrt(o/a);return{start:E,stop:E}}return 1>p?(o=p-1,a=n.magnitudeSquared(y),s=a*o,u=d*d-s,l=-d+Math.sqrt(u),{start:0,stop:l/a}):0>d?(a=n.magnitudeSquared(y),{start:0,stop:-d/a}):void 0},c.grazingAltitudeLocation=function(a,s){if(!e(a))throw new t("ray is required.");if(!e(s))throw new t("ellipsoid is required.");var u=a.origin,c=a.direction,f=s.geodeticSurfaceNormal(u);if(n.dot(c,f)>=0)return u;var m,h,y=e(this.rayEllipsoid(a,s)),p=s.transformPositionToScaledSpace(c),d=n.normalize(p),w=n.mostOrthogonalAxis(p),v=n.normalize(n.cross(w,d)),g=n.normalize(n.cross(d,v)),E=new o(d.x,v.x,g.x,d.y,v.y,g.y,d.z,v.z,g.z),b=o.transpose(E),x=o.fromScale(s.getRadii()),C=o.fromScale(s.getOneOverRadii()),S=new o(0,c.z,-c.y,-c.z,0,c.x,c.y,-c.x,0),A=o.multiply(o.multiply(b,C),S),M=o.multiply(o.multiply(A,x),E),T=o.multiplyByVector(A,u),O=l(M,n.negate(T),0,0,1),I=O.length;if(I>0){for(var N=n.ZERO,R=Number.NEGATIVE_INFINITY,z=0;I>z;++z){m=o.multiplyByVector(x,o.multiplyByVector(E,O[z]));var L=n.normalize(n.subtract(m,u)),P=n.dot(L,c);P>R&&(R=P,N=m)}var D=s.cartesianToCartographic(N);return R=r.clamp(R,0,1),h=n.magnitude(n.subtract(N,u))*Math.sqrt(1-R*R),h=y?-h:h,s.cartographicToCartesian(new i(D.longitude,D.latitude,h))}return void 0};var h=new n;return c.lineSegmentPlane=function(i,o,a,s){if(!e(i))throw new t("endPoint0 is required.");if(!e(o))throw new t("endPoint1 is required.");if(!e(a))throw new t("plane is required.");var u=n.subtract(o,i,h),l=a.normal,c=n.dot(l,u);if(Math.abs(c)<r.EPSILON6)return void 0;var f=n.dot(l,i),m=-(a.distance+f)/c;return 0>m||m>1?void 0:(e(s)||(s=new n),n.multiplyByScalar(u,m,s),n.add(i,s,s),s)},c.trianglePlaneIntersection=function(r,i,o,a){if(!(e(r)&&e(i)&&e(o)&&e(a)))throw new t("p0, p1, p2, and plane are required.");var s=a.normal,u=a.distance,l=n.dot(s,r)+u<0,f=n.dot(s,i)+u<0,m=n.dot(s,o)+u<0,h=0;h+=l?1:0,h+=f?1:0,h+=m?1:0;var y,p;if((1===h||2===h)&&(y=new n,p=new n),1===h){if(l)return c.lineSegmentPlane(r,i,a,y),c.lineSegmentPlane(r,o,a,p),{positions:[r,i,o,y,p],indices:[0,3,4,1,2,4,1,4,3]};if(f)return c.lineSegmentPlane(i,o,a,y),c.lineSegmentPlane(i,r,a,p),{positions:[r,i,o,y,p],indices:[1,3,4,2,0,4,2,4,3]};if(m)return c.lineSegmentPlane(o,r,a,y),c.lineSegmentPlane(o,i,a,p),{positions:[r,i,o,y,p],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!l)return c.lineSegmentPlane(i,r,a,y),c.lineSegmentPlane(o,r,a,p),{positions:[r,i,o,y,p],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return c.lineSegmentPlane(o,i,a,y),c.lineSegmentPlane(r,i,a,p),{positions:[r,i,o,y,p],indices:[2,0,4,2,4,3,1,3,4]};if(!m)return c.lineSegmentPlane(r,o,a,y),c.lineSegmentPlane(i,o,a,p),{positions:[r,i,o,y,p],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n,i){if(!t(n))throw new r("normal is required.");if(!t(i))throw new r("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,o,a){if(!t(i))throw new r("point is required.");if(!t(o))throw new r("normal is required.");var s=-e.dot(o,i);return t(a)?(e.clone(o,a.normal),a.distance=s,a):new n(o,s)},n.getPointDistance=function(n,i){if(!t(n))throw new r("plane is required.");if(!t(i))throw new r("point is required.");return e.dot(n.normal,i)+n.distance},n.prototype.getPointDistance=function(e){return n.getPointDistance(this,e)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(t){return t===e.POINTS||t===e.LINES||t===e.LINE_LOOP||t===e.LINE_STRIP||t===e.TRIANGLES||t===e.TRIANGLE_STRIP||t===e.TRIANGLE_FAN}};return e}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var s=i.length;if(3>s||0!==s%3)throw new r("indices length must be a multiple of three.");if(0>=o)throw new r("maximumIndex must be greater than zero.");if(3>a)throw new r("cacheSize must be greater than two.");if(!t(o)){o=0;for(var u=0,l=i[u];s>u;)l>o&&(o=l),++u,l=i[u]}for(var c=[],f=0;o+1>f;f++)c[f]=0;for(var m=a+1,h=0;s>h;++h)m-c[i[h]]>a&&(c[i[h]]=m,++m);return(m-a+1)/(s/3)},n.tipsify=function(n){function i(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,t,r,n,o,a,s){for(var u,l=-1,c=-1,f=0;f<r.length;){var m=r[f];n[m].numLiveTriangles&&(u=0,o-n[m].timeStamp+2*n[m].numLiveTriangles<=t&&(u=o-n[m].timeStamp),(u>c||-1===c)&&(c=u,l=m)),++f}return-1===l?i(n,a,e,s):l}n=e(n,e.EMPTY_OBJECT);var a,s=n.indices,u=n.maximumIndex,l=e(n.cacheSize,24);if(!t(s))throw new r("indices is required.");var c=s.length;if(3>c||0!==c%3)throw new r("indices length must be a multiple of three.");if(0>=u)throw new r("maximumIndex must be greater than zero.");if(3>l)throw new r("cacheSize must be greater than two.");var f=0,m=0,h=s[m],y=c;if(t(u))f=u+1;else{for(;y>m;)h>f&&(f=h),++m,h=s[m];if(-1===f)return 0;++f}for(var p=[],d=0;f>d;d++)p[d]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};m=0;for(var w=0;y>m;)p[s[m]].vertexTriangles.push(w),++p[s[m]].numLiveTriangles,p[s[m+1]].vertexTriangles.push(w),++p[s[m+1]].numLiveTriangles,p[s[m+2]].vertexTriangles.push(w),++p[s[m+2]].numLiveTriangles,++w,m+=3;var v=0,g=l+1;a=1;var E,b,x=[],C=[],S=0,A=[],M=c/3,T=[];for(d=0;M>d;d++)T[d]=!1;for(var O,I;-1!==v;){x=[],b=p[v],I=b.vertexTriangles.length;for(var N=0;I>N;++N)if(w=b.vertexTriangles[N],!T[w]){T[w]=!0,m=w+w+w;for(var R=0;3>R;++R)O=s[m],x.push(O),C.push(O),A[S]=O,++S,E=p[O],--E.numLiveTriangles,g-E.timeStamp>l&&(E.timeStamp=g,++g),++m}v=o(s,l,x,p,g,C,f)}return A},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryPipeline",["./barycentricCoordinates","./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./EncodedCartesian3","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./GeographicProjection","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./Tipsify","./BoundingSphere","./Geometry","./GeometryAttribute"],function(e,t,r,n,i,o,a,s,u,l,c,f,m,h,y,p,d,w,v,g,E,b,x){"use strict";function C(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function S(e){for(var t=e.length,r=6*(t/3),n=w.createTypedArray(t,r),i=0,o=0;t>o;o+=3,i+=6)C(n,i,e[o],e[o+1],e[o+2]);return n}function A(e){var t=e.length;if(t>=3){var r=6*(t-2),n=w.createTypedArray(t,r);C(n,0,e[0],e[1],e[2]);for(var i=6,o=3;t>o;++o,i+=6)C(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function M(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=w.createTypedArray(t,r),i=e[0],o=0,a=1;t>a;++a,o+=6)C(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}function T(e){var t={};for(var n in e)if(e.hasOwnProperty(n)&&r(e[n])&&r(e[n].values)){var i=e[n];t[n]=new x({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function O(e,t,n){for(var i in t)if(t.hasOwnProperty(i)&&r(t[i])&&r(t[i].values))for(var o=t[i],a=0;a<o.componentsPerAttribute;++a)e[i].values.push(o.values[n*o.componentsPerAttribute+a])}function I(e,t){if(r(t))for(var n=t.values,i=n.length,a=0;i>a;a+=3)o.unpack(n,a,Z),h.multiplyByPoint(e,Z,Z),o.pack(Z,n,a)}function N(e,t){if(r(t))for(var n=t.values,i=n.length,a=0;i>a;a+=3)o.unpack(n,a,Z),m.multiplyByVector(e,Z,Z),Z=o.normalize(Z,Z),o.pack(Z,n,a)}function R(e){var t,n=e.length,i={},o=e[0].geometry.attributes;for(t in o)if(o.hasOwnProperty(t)&&r(o[t])&&r(o[t].values)){for(var a=o[t],s=a.values.length,u=!0,l=1;n>l;++l){var c=e[l].geometry.attributes[t];if(!r(c)||a.componentDatatype.value!==c.componentDatatype.value||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){u=!1;break}s+=c.values.length}u&&(i[t]=new x({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:d.createTypedArray(a.componentDatatype,s)}))}return i}function z(e){if(r(e.indices))return e;var t=b.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least three.");if(0!==t%3)throw new n("The number of vertices must be a multiple of three.");for(var i=w.createTypedArray(t,t),o=0;t>o;++o)i[o]=o;return e.indices=i,e}function L(e){var t=b.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least three.");var r=w.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var i=3,o=3;t>o;++o)r[i++]=o-1,r[i++]=0,r[i++]=o;return e.indices=r,e.primitiveType=v.TRIANGLES,e}function P(e){var t=b.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least 3.");var r=w.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var i=6,o=3;t-1>o;o+=2)r[i++]=o,r[i++]=o-1,r[i++]=o+1,t>o+2&&(r[i++]=o,r[i++]=o+1,r[i++]=o+2);return e.indices=r,e.primitiveType=v.TRIANGLES,e}function D(e){if(r(e.indices))return e;var t=b.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");if(0!==t%2)throw new n("The number of vertices must be a multiple of 2.");for(var i=w.createTypedArray(t,t),o=0;t>o;++o)i[o]=o;return e.indices=i,e}function F(e){var t=b.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");var r=w.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var i=2,o=2;t>o;++o)r[i++]=o-1,r[i++]=o;return e.indices=r,e.primitiveType=v.LINES,e}function q(e){var t=b.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");var r=w.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var i=2,o=2;t>o;++o)r[i++]=o-1,r[i++]=o;return r[i++]=t-1,r[i]=0,e.indices=r,e.primitiveType=v.LINES,e}function _(e){switch(e.primitiveType){case v.TRIANGLE_FAN:return L(e);case v.TRIANGLE_STRIP:return P(e);case v.TRIANGLES:return z(e);case v.LINE_STRIP:return F(e);case v.LINE_LOOP:return q(e);case v.LINES:return D(e)}return e}function B(e,t){Math.abs(e.y)<f.EPSILON11&&(e.y=t?-f.EPSILON11:f.EPSILON11)}function U(e,t,r,n){o.add(e,o.multiplyByScalar(o.subtract(t,e,ot),e.y/(e.y-t.y),ot),r),o.clone(r,n),B(r,!0),B(n,!1)}function G(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;var n=e.y<0,i=t.y<0,o=r.y<0;B(e,n),B(t,i),B(r,o);var a=0;a+=n?1:0,a+=i?1:0,a+=o?1:0;var s=ct.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(U(e,t,at,ut),U(e,r,st,lt),s[0]=0,s[3]=1,s[4]=2,s[6]=1):i?(U(t,r,at,ut),U(t,e,st,lt),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(U(r,e,at,ut),U(r,t,st,lt),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?i?o||(U(r,e,at,ut),U(r,t,st,lt),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(U(t,r,at,ut),U(t,e,st,lt),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(U(e,t,at,ut),U(e,r,st,lt),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=ct.positions;return u[0]=e,u[1]=t,u[2]=r,ct.length=3,(1===a||2===a)&&(u[3]=at,u[4]=st,u[5]=ut,u[6]=lt,ct.length=7),ct}function W(t,n,a,s,u,l,c,f){if(r(u)||r(l)||r(c)||r(f)){var m,h,y,p,d,w,v,g,E,b,x,C,S,A,M,T,O,I,N=s.positions,R=N[0],z=N[1],L=N[2];r(u)&&(m=o.fromArray(u,3*t),h=o.fromArray(u,3*n),y=o.fromArray(u,3*a)),r(l)&&(p=o.fromArray(l,3*t),d=o.fromArray(l,3*n),w=o.fromArray(l,3*a)),r(c)&&(v=o.fromArray(c,3*t),g=o.fromArray(c,3*n),E=o.fromArray(c,3*a)),r(f)&&(b=i.fromArray(f,2*t),x=i.fromArray(f,2*n),C=i.fromArray(f,2*a));for(var P=3;P<N.length;++P){var D=N[P],F=e(D,R,z,L);if(r(u)){S=o.multiplyByScalar(m,F.x,S),A=o.multiplyByScalar(h,F.y,A),M=o.multiplyByScalar(y,F.z,M);var q=o.add(S,A);o.add(q,M,q),o.normalize(q,q),u.push(q.x,q.y,q.z)}if(r(l)){S=o.multiplyByScalar(p,F.x,S),A=o.multiplyByScalar(d,F.y,A),M=o.multiplyByScalar(w,F.z,M);var _=o.add(S,A);o.add(_,M,_),o.normalize(_,_),l.push(_.x,_.y,_.z)}if(r(c)){S=o.multiplyByScalar(v,F.x,S),A=o.multiplyByScalar(g,F.y,A),M=o.multiplyByScalar(E,F.z,M);var B=o.add(S,A);o.add(B,M,B),o.normalize(B,B),c.push(B.x,B.y,B.z)}if(r(f)){T=i.multiplyByScalar(b,F.x,T),O=i.multiplyByScalar(x,F.y,O),I=i.multiplyByScalar(C,F.z,I);var U=i.add(T,O);i.add(U,I,U),f.push(U.x,U.y)}}}}function Y(e){for(var t=e.attributes,n=t.position.values,i=r(t.normal)?t.normal.values:void 0,a=r(t.binormal)?t.binormal.values:void 0,s=r(t.tangent)?t.tangent.values:void 0,u=r(t.st)?t.st.values:void 0,l=e.indices,c=Array.prototype.slice.call(n,0),f=r(i)?Array.prototype.slice.call(i,0):void 0,m=r(a)?Array.prototype.slice.call(a,0):void 0,h=r(s)?Array.prototype.slice.call(s,0):void 0,y=r(u)?Array.prototype.slice.call(u,0):void 0,p=[],v=l.length,g=0;v>g;g+=3){var E=l[g],x=l[g+1],C=l[g+2],S=o.fromArray(n,3*E),A=o.fromArray(n,3*x),M=o.fromArray(n,3*C),T=G(S,A,M);if(r(T))if(c[3*E+1]=T.positions[0].y,c[3*x+1]=T.positions[1].y,c[3*C+1]=T.positions[2].y,T.length>3){for(var O=c.length/3,I=0;I<T.indices.length;++I){var N=T.indices[I];3>N?p.push(l[g+N]):p.push(N-3+O)}for(var R=3;R<T.positions.length;++R){var z=T.positions[R];c.push(z.x,z.y,z.z)}W(E,x,C,T,f,m,h,y)}else p.push(E,x,C);else p.push(E,x,C)}e.attributes.position.values=new Float64Array(c),r(f)&&(t.normal.values=d.createTypedArray(t.normal.componentDatatype,f)),r(m)&&(t.binormal.values=d.createTypedArray(t.binormal.componentDatatype,m)),r(h)&&(t.tangent.values=d.createTypedArray(t.tangent.componentDatatype,h)),r(y)&&(t.st.values=d.createTypedArray(t.st.componentDatatype,y));var L=b.computeNumberOfVertices(e);e.indices=w.createTypedArray(L,p)}function V(e){for(var t=e.attributes,n=t.position.values,i=e.indices,a=Array.prototype.slice.call(n,0),s=[],u=y.fromPointNormal(o.ZERO,o.UNIT_Y),l=i.length,m=0;l>m;m+=2){var h=i[m],p=i[m+1],d=o.fromArray(n,3*h),v=o.fromArray(n,3*p);if(Math.abs(d.y)<f.EPSILON6&&(d.y=d.y<0?-f.EPSILON6:f.EPSILON6,a[3*h+1]=d.y),Math.abs(v.y)<f.EPSILON6&&(v.y=v.y<0?-f.EPSILON6:f.EPSILON6,a[3*p+1]=v.y),s.push(h),d.x<0||v.x<0){var g=c.lineSegmentPlane(d,v,u);if(r(g)){var E=o.multiplyByScalar(o.UNIT_Y,5*f.EPSILON9);d.y<0&&o.negate(E,E);var x=a.length/3;s.push(x,x+1);var C=o.add(g,E);a.push(C.x,C.y,C.z),o.negate(E,E),o.add(g,E,C),a.push(C.x,C.y,C.z)}}s.push(p)}e.attributes.position.values=new Float64Array(a);var S=b.computeNumberOfVertices(e);e.indices=w.createTypedArray(S,s)}var H={};H.toWireframe=function(e){if(!r(e))throw new n("geometry is required.");var t=e.indices;if(r(t)){switch(e.primitiveType){case v.TRIANGLES:e.indices=S(t);break;case v.TRIANGLE_STRIP:e.indices=A(t);break;case v.TRIANGLE_FAN:e.indices=M(t);break;default:throw new n("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=v.LINES}return e},H.createLineSegmentsForVectors=function(e,i,o){if(!r(e))throw new n("geometry is required.");if(!r(e.attributes.position))throw new n("geometry.attributes.position is required.");if(i=t(i,"normal"),!r(e.attributes[i]))throw new n("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+i+".");o=t(o,1e4);for(var a=e.attributes.position.values,s=e.attributes[i].values,u=a.length,l=new Float64Array(2*u),c=0,f=0;u>f;f+=3)l[c++]=a[f],l[c++]=a[f+1],l[c++]=a[f+2],l[c++]=a[f]+s[f]*o,l[c++]=a[f+1]+s[f+1]*o,l[c++]=a[f+2]+s[f+2]*o;var m,h=e.boundingSphere;return r(h)&&(m=new E(h.center,h.radius+o)),new b({attributes:{position:new x({componentDatatype:d.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:v.LINES,boundingSphere:m})},H.createAttributeIndices=function(e){if(!r(e))throw new n("geometry is required.");var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],o=e.attributes,a={},s=0,u=i.length;for(t=0;u>t;++t){var l=i[t];r(o[l])&&(a[l]=s++)}for(var c in o)o.hasOwnProperty(c)&&!r(a[c])&&(a[c]=s++);return a},H.reorderForPreVertexCache=function(e){if(!r(e))throw new n("geometry is required.");var t=b.computeNumberOfVertices(e),i=e.indices;if(r(i)){for(var o=new Int32Array(t),a=0;t>a;a++)o[a]=-1;for(var s,u=i,l=u.length,c=w.createTypedArray(t,l),f=0,m=0,h=0;l>f;)s=o[u[f]],-1!==s?c[m]=s:(s=u[f],o[s]=h,c[m]=h,++h),++f,++m;e.indices=c;var y=e.attributes;for(var p in y)if(y.hasOwnProperty(p)&&r(y[p])&&r(y[p].values)){for(var v=y[p],g=v.values,E=0,x=v.componentsPerAttribute,C=d.createTypedArray(v.componentDatatype,h*x);t>E;){var S=o[E];if(-1!==S)for(a=0;x>a;a++)C[x*S+a]=g[x*E+a];++E}v.values=C}}return e},H.reorderForPostVertexCache=function(e,t){if(!r(e))throw new n("geometry is required.");var i=e.indices;if(e.primitiveType===v.TRIANGLES&&r(i)){for(var o=i.length,a=0,s=0;o>s;s++)i[s]>a&&(a=i[s]);e.indices=g.tipsify({indices:i,maximumIndex:a,cacheSize:t})}return e},H.fitToUnsignedShortIndices=function(e){if(!r(e))throw new n("geometry is required.");if(r(e.indices)&&e.primitiveType!==v.TRIANGLES&&e.primitiveType!==v.LINES&&e.primitiveType!==v.POINTS)throw new n("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],i=b.computeNumberOfVertices(e);if(r(e.indices)&&i>f.SIXTY_FOUR_KILOBYTES){var o,a=[],s=[],u=0,l=T(e.attributes),c=e.indices,m=c.length;e.primitiveType===v.TRIANGLES?o=3:e.primitiveType===v.LINES?o=2:e.primitiveType===v.POINTS&&(o=1);for(var h=0;m>h;h+=o){for(var y=0;o>y;++y){var p=c[h+y],d=a[p];r(d)||(d=u++,a[p]=d,O(l,e.attributes,p)),s.push(d)}u+o>f.SIXTY_FOUR_KILOBYTES&&(t.push(new b({attributes:l,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),a=[],s=[],u=0,l=T(e.attributes))}0!==s.length&&t.push(new b({attributes:l,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else t.push(e);return t};var k=new o,j=new s;H.projectTo2D=function(e,t,i,a,s){if(!r(e))throw new n("geometry is required.");if(!r(t))throw new n("attributeName is required.");if(!r(i))throw new n("attributeName3D is required.");if(!r(a))throw new n("attributeName2D is required.");var u=e.attributes[t];if(!r(u))throw new n("geometry must have attribute matching the attributeName argument: "+t+".");if(u.componentDatatype.value!==d.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");s=r(s)?s:new p;for(var l=s.getEllipsoid(),c=u.values,f=new Float64Array(c.length),m=0,h=0;h<c.length;h+=3){var y=o.fromArray(c,h,k),w=l.cartesianToCartographic(y,j);if(!r(w))throw new n("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var v=s.project(w,k);f[m++]=v.x,f[m++]=v.y,f[m++]=v.z}return e.attributes[i]=u,e.attributes[a]=new x({componentDatatype:d.DOUBLE,componentsPerAttribute:3,values:f}),delete e.attributes[t],e};var K={high:0,low:0};H.encodeAttribute=function(e,t,i,o){if(!r(e))throw new n("geometry is required.");if(!r(t))throw new n("attributeName is required.");if(!r(i))throw new n("attributeHighName is required.");if(!r(o))throw new n("attributeLowName is required.");var a=e.attributes[t];if(!r(a))throw new n("geometry must have attribute matching the attributeName argument: "+t+".");if(a.componentDatatype.value!==d.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var s=a.values,l=s.length,c=new Float32Array(l),f=new Float32Array(l),m=0;l>m;++m)u.encode(s[m],K),c[m]=K.high,f[m]=K.low;var h=a.componentsPerAttribute;return e.attributes[i]=new x({componentDatatype:d.FLOAT,componentsPerAttribute:h,values:c}),e.attributes[o]=new x({componentDatatype:d.FLOAT,componentsPerAttribute:h,values:f}),delete e.attributes[t],e};var Z=new o,X=new h,Q=new m;H.transformToWorldCoordinates=function(e){if(!r(e))throw new n("instance is required.");var t=e.modelMatrix;if(h.equals(t,h.IDENTITY))return e;var i=e.geometry.attributes;I(t,i.position),I(t,i.prevPosition),I(t,i.nextPosition),(r(i.normal)||r(i.binormal)||r(i.tangent))&&(h.inverse(t,X),h.transpose(X,X),h.getRotation(X,Q),N(Q,i.normal),N(Q,i.binormal),N(Q,i.tangent));var o=e.geometry.boundingSphere;return r(o)&&(e.geometry.boundingSphere=E.transform(o,t,o)),e.modelMatrix=h.clone(h.IDENTITY),e},H.combine=function(e){if(!r(e)||e.length<1)throw new n("instances is required and must have length greater than zero.");var t,i,a,s,u=e.length,l=e[0].modelMatrix,c=r(e[0].geometry.indices),f=e[0].geometry.primitiveType;for(i=1;u>i;++i){if(!h.equals(e[i].modelMatrix,l))throw new n("All instances must have the same modelMatrix.");if(r(e[i].geometry.indices)!==c)throw new n("All instance geometries must have an indices or not have one.");if(e[i].geometry.primitiveType!==f)throw new n("All instance geometries must have the same primitiveType.")}var m,y,p,d=R(e);for(t in d)if(d.hasOwnProperty(t))for(m=d[t].values,s=0,i=0;u>i;++i)for(y=e[i].geometry.attributes[t].values,p=y.length,a=0;p>a;++a)m[s++]=y[a];var g;if(c){var x=0;for(i=0;u>i;++i)x+=e[i].geometry.indices.length;var C=b.computeNumberOfVertices(new b({attributes:d,primitiveType:v.POINTS})),S=w.createTypedArray(C,x),A=0,M=0;for(i=0;u>i;++i){var T=e[i].geometry.indices,O=T.length;for(s=0;O>s;++s)S[A++]=M+T[s];M+=b.computeNumberOfVertices(e[i].geometry)}g=S}var I,N=new o,z=0;for(i=0;u>i;++i){if(I=e[i].geometry.boundingSphere,!r(I)){N=void 0;break}o.add(I.center,N,N)}if(r(N))for(o.divideByScalar(N,u,N),i=0;u>i;++i){I=e[i].geometry.boundingSphere;var L=o.magnitude(o.subtract(I.center,N))+I.radius;L>z&&(z=L)}return new b({attributes:d,indices:g,primitiveType:f,boundingSphere:r(N)?new E(N,z):void 0})};var J=new o,$=new o,et=new o,tt=new o;H.computeNormal=function(e){if(!r(e))throw new n("geometry is required.");var t=e.attributes,i=e.indices;if(!r(t.position)||!r(t.position.values))throw new n("geometry.attributes.position.values is required.");if(!r(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==v.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,s=e.attributes.position.values.length/3,u=i.length,l=new Array(s),c=new Array(u/3),f=new Array(u),m=0;s>m;m++)l[m]={indexOffset:0,count:0,currentCount:0};var h=0;for(m=0;u>m;m+=3){var y=i[m],p=i[m+1],w=i[m+2],g=3*y,E=3*p,b=3*w;$.x=a[g],$.y=a[g+1],$.z=a[g+2],et.x=a[E],et.y=a[E+1],et.z=a[E+2],tt.x=a[b],tt.y=a[b+1],tt.z=a[b+2],l[y].count++,l[p].count++,l[w].count++,o.subtract(et,$,et),o.subtract(tt,$,tt),c[h]=o.cross(et,tt),h++}var C=0;for(m=0;s>m;m++)l[m].indexOffset+=C,C+=l[m].count;h=0;var S;for(m=0;u>m;m+=3){S=l[i[m]];var A=S.indexOffset+S.currentCount;f[A]=h,S.currentCount++,S=l[i[m+1]],A=S.indexOffset+S.currentCount,f[A]=h,S.currentCount++,S=l[i[m+2]],A=S.indexOffset+S.currentCount,f[A]=h,S.currentCount++,h++}var M=new Float32Array(3*s);for(m=0;s>m;m++){var T=3*m;if(S=l[m],S.count>0){for(o.clone(o.ZERO,J),h=0;h<S.count;h++)o.add(J,c[f[S.indexOffset+h]],J);o.normalize(J,J),M[T]=J.x,M[T+1]=J.y,M[T+2]=J.z}else M[T]=0,M[T+1]=0,M[T+2]=1}return e.attributes.normal=new x({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:M}),e};var rt=new o,nt=new o,it=new o;H.computeBinormalAndTangent=function(e){if(!r(e))throw new n("geometry is required.");var t=e.attributes,i=e.indices;if(!r(t.position)||!r(t.position.values))throw new n("geometry.attributes.position.values is required.");if(!r(t.normal)||!r(t.normal.values))throw new n("geometry.attributes.normal.values is required.");if(!r(t.st)||!r(t.st.values))throw new n("geometry.attributes.st.values is required.");if(!r(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==v.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,s=e.attributes.normal.values,u=e.attributes.st.values,l=e.attributes.position.values.length/3,c=i.length,f=new Array(3*l),m=0;m<f.length;m++)f[m]=0;var h,y,p;for(m=0;c>m;m+=3){var w=i[m],g=i[m+1],E=i[m+2];h=3*w,y=3*g,p=3*E;var b=2*w,C=2*g,S=2*E,A=a[h],M=a[h+1],T=a[h+2],O=u[b],I=u[b+1],N=u[C+1]-I,R=u[S+1]-I,z=1/((u[C]-O)*R-(u[S]-O)*N),L=(R*(a[y]-A)-N*(a[p]-A))*z,P=(R*(a[y+1]-M)-N*(a[p+1]-M))*z,D=(R*(a[y+2]-T)-N*(a[p+2]-T))*z;f[h]+=L,f[h+1]+=P,f[h+2]+=D,f[y]+=L,f[y+1]+=P,f[y+2]+=D,f[p]+=L,f[p+1]+=P,f[p+2]+=D}var F=new Float32Array(3*l),q=new Float32Array(3*l);for(m=0;l>m;m++){h=3*m,y=h+1,p=h+2;var _=o.fromArray(s,h,rt),B=o.fromArray(f,h,it),U=o.dot(_,B);o.multiplyByScalar(_,U,nt),o.normalize(o.subtract(B,nt,B),B),q[h]=B.x,q[y]=B.y,q[p]=B.z,o.normalize(o.cross(_,B,B),B),F[h]=B.x,F[y]=B.y,F[p]=B.z}return e.attributes.tangent=new x({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:q}),e.attributes.binormal=new x({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:F}),e};var ot=new o,at=new o,st=new o,ut=new o,lt=new o,ct={positions:new Array(7),indices:new Array(9)};return H.wrapLongitude=function(e){if(!r(e))throw new n("geometry is required.");var t=e.boundingSphere;if(r(t)){var i=t.center.x-t.radius;if(i>0||E.intersect(t,a.UNIT_Y)!==l.INTERSECTING)return e}return _(e),e.primitiveType===v.TRIANGLES?Y(e):e.primitiveType===v.LINES&&V(e),e},H}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color
};return t}),define("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n,i){"use strict";var o=function(e,r,n,i){this[0]=t(e,0),this[1]=t(n,0),this[2]=t(r,0),this[3]=t(i,0)};return o.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3]):void 0},o.fromArray=function(e,n,i){return n=t(n,0),r(i)||(i=new o),i[0]=e[n],i[1]=e[n+1],i[2]=e[n+2],i[3]=e[n+3],i},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new o(e,0,0,e)},o.fromRotation=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=i,t[2]=-i,t[3]=n,t):new o(n,-i,i,n)},o.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,t){return 2*e+t},o.getColumn=function(t,n,i){var o=2*n,a=t[o],s=t[o+1];return r(i)?(i.x=a,i.y=s,i):new e(a,s)},o.setColumn=function(e,t,r,n){n=o.clone(e,n);var i=2*t;return n[i]=r.x,n[i+1]=r.y,n},o.getRow=function(t,n,i){var o=t[n],a=t[n+2];return r(i)?(i.x=o,i.y=a,i):new e(o,a)},o.setRow=function(e,t,r,n){return n=o.clone(e,n),n[t]=r.x,n[t+2]=r.y,n},o.multiply=function(e,t,n){var i=e[0]*t[0]+e[2]*t[1],a=e[0]*t[2]+e[2]*t[3],s=e[1]*t[0]+e[3]*t[1],u=e[1]*t[2]+e[3]*t[3];return r(n)?(n[0]=i,n[1]=s,n[2]=a,n[3]=u,n):new o(i,a,s,u)},o.multiplyByVector=function(t,n,i){var o=t[0]*n.x+t[2]*n.y,a=t[1]*n.x+t[3]*n.y;return r(i)?(i.x=o,i.y=a,i):new e(o,a)},o.multiplyByScalar=function(e,t,n){return r(n)?(n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n):new o(e[0]*t,e[2]*t,e[1]*t,e[3]*t)},o.negate=function(e,t){return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t):new o(-e[0],-e[2],-e[1],-e[3])},o.transpose=function(e,t){var n=e[0],i=e[2],a=e[1],s=e[3];return r(t)?(t[0]=n,t[1]=i,t[2]=a,t[3]=s,t):new o(n,a,i,s)},o.abs=function(e,t){return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t):new o(Math.abs(e[0]),Math.abs(e[2]),Math.abs(e[1]),Math.abs(e[3]))},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n},o.IDENTITY=i(new o(1,0,0,1)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n"+"("+this[1]+", "+this[3]+")"},o}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,i,o,a){"use strict";var s,u=function(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)};u.fromAxisAngle=function(t,n,i){var o=n/2,a=Math.sin(o);s=e.normalize(t,s);var l=s.x*a,c=s.y*a,f=s.z*a,m=Math.cos(o);return r(i)?(i.x=l,i.y=c,i.z=f,i.w=m,i):new u(l,c,f,m)};var l=[1,2,0],c=new Array(3);u.fromRotationMatrix=function(e,t){var n,i,o,s,f,m=e[a.COLUMN0ROW0],h=e[a.COLUMN1ROW1],y=e[a.COLUMN2ROW2],p=m+h+y;if(p>0)n=Math.sqrt(p+1),f=.5*n,n=.5/n,i=(e[a.COLUMN1ROW2]-e[a.COLUMN2ROW1])*n,o=(e[a.COLUMN2ROW0]-e[a.COLUMN0ROW2])*n,s=(e[a.COLUMN0ROW1]-e[a.COLUMN1ROW0])*n;else{var d=l,w=0;h>m&&(w=1),y>m&&y>h&&(w=2);var v=d[w],g=d[v];n=Math.sqrt(e[a.getElementIndex(w,w)]-e[a.getElementIndex(v,v)]-e[a.getElementIndex(g,g)]+1);var E=c;E[w]=.5*n,n=.5/n,f=(e[a.getElementIndex(g,v)]-e[a.getElementIndex(v,g)])*n,E[v]=(e[a.getElementIndex(v,w)]+e[a.getElementIndex(w,v)])*n,E[g]=(e[a.getElementIndex(g,w)]+e[a.getElementIndex(w,g)])*n,i=-E[0],o=-E[1],s=-E[2]}return r(t)?(t.x=i,t.y=o,t.z=s,t.w=f,t):new u(i,o,s,f)};var f=new e,m=new e,h=new u,y=new u,p=new u;u.packedLength=4,u.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},u.unpack=function(e,n,i){return n=t(n,0),r(i)||(i=new u),i.x=e[n],i.y=e[n+1],i.z=e[n+2],i.w=e[n+3],i},u.packedInterpolationLength=3,u.convertPackedArrayForInterpolation=function(e,t,r,n){u.unpack(e,4*r,p),u.conjugate(p,p);for(var i=0,o=r-t+1;o>i;i++){var a=3*i;u.unpack(e,4*(t+i),h),u.multiply(h,p,h),h.w<0&&u.negate(h,h),u.getAxis(h,f);var s=u.getAngle(h);n[a]=f.x*s,n[a+1]=f.y*s,n[a+2]=f.z*s}},u.unpackInterpolationResult=function(t,n,i,o,a){r(a)||(a=new u),e.fromArray(t,0,m);var s=e.magnitude(m);return u.unpack(n,4*o,y),0===s?u.clone(u.IDENTITY,h):u.fromAxisAngle(m,s,h),u.multiply(h,y,a)},u.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new u(e.x,e.y,e.z,e.w):void 0},u.conjugate=function(e,t){return r(t)?(t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t):new u(-e.x,-e.y,-e.z,e.w)},u.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},u.magnitude=function(e){return Math.sqrt(u.magnitudeSquared(e))},u.normalize=function(e,t){var n=1/u.magnitude(e),i=e.x*n,o=e.y*n,a=e.z*n,s=e.w*n;return r(t)?(t.x=i,t.y=o,t.z=a,t.w=s,t):new u(i,o,a,s)},u.inverse=function(e,t){var r=u.magnitudeSquared(e);return t=u.conjugate(e,t),u.multiplyByScalar(t,1/r,t)},u.add=function(e,t,n){return r(n)?(n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n):new u(e.x+t.x,e.y+t.y,e.z+t.z,e.w+t.w)},u.subtract=function(e,t,n){return r(n)?(n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n):new u(e.x-t.x,e.y-t.y,e.z-t.z,e.w-t.w)},u.negate=function(e,t){return r(t)?(t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t):new u(-e.x,-e.y,-e.z,-e.w)},u.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},u.multiply=function(e,t,n){var i=e.x,o=e.y,a=e.z,s=e.w,l=t.x,c=t.y,f=t.z,m=t.w,h=s*l+i*m+o*f-a*c,y=s*c-i*f+o*m+a*l,p=s*f+i*c-o*l+a*m,d=s*m-i*l-o*c-a*f;return r(n)?(n.x=h,n.y=y,n.z=p,n.w=d,n):new u(h,y,p,d)},u.multiplyByScalar=function(e,t,n){return r(n)?(n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n):new u(e.x*t,e.y*t,e.z*t,e.w*t)},u.divideByScalar=function(e,t,n){return r(n)?(n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n):new u(e.x/t,e.y/t,e.z/t,e.w/t)},u.getAxis=function(t,n){var i=t.w;if(Math.abs(i-1)<o.EPSILON6)return r(n)?(n.x=n.y=n.z=0,n):new e;var a=1/Math.sqrt(1-i*i);return r(n)?(n.x=t.x*a,n.y=t.y*a,n.z=t.z*a,n):new e(t.x*a,t.y*a,t.z*a)},u.getAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var d;u.lerp=function(e,t,r,n){return d=u.multiplyByScalar(t,r,d),n=u.multiplyByScalar(e,1-r,n),u.add(d,n,n)};var w,v,g;u.slerp=function(e,t,r,n){var i=u.dot(e,t),a=t;if(0>i&&(i=-i,a=w=u.negate(t,w)),1-i<o.EPSILON6)return u.lerp(e,a,r,n);var s=Math.acos(i);return v=u.multiplyByScalar(e,Math.sin((1-r)*s),v),g=u.multiplyByScalar(a,Math.sin(r*s),g),n=u.add(v,g,n),u.multiplyByScalar(n,1/Math.sin(s),n)},u.log=function(t,n){var i=Math.acos(o.clamp(t.w,-1,1)),a=0;return 0!==i&&(a=i/Math.sin(i)),r(n)||(n=new e),e.multiplyByScalar(t,a,n)},new e,u.exp=function(t,n){var i=e.magnitude(t),o=0;return 0!==i&&(o=Math.sin(i)/i),r(n)||(n=new u),n.x=t.x*o,n.y=t.y*o,n.z=t.z*o,n.w=Math.cos(i),n};var E=new e,b=new e,x=new u,C=new u;return u.innerQuadrangle=function(t,r,n,i){var o=u.conjugate(r,x);u.multiply(o,n,C);var a=u.log(C,E);u.multiply(o,t,C);var s=u.log(C,b);return e.add(a,s,a),e.multiplyByScalar(a,.25,a),e.negate(a,a),u.exp(a,x),u.multiply(r,x,i)},u.squad=function(e,t,r,n,i,o){var a=u.slerp(e,t,i,x),s=u.slerp(r,n,i,C);return u.slerp(a,s,2*i*(1-i),o)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},u.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},u.ZERO=i(new u(0,0,0,0)),u.IDENTITY=i(new u(0,0,0,1)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},u}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,t){"use strict";var r=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1)};return r.POSITION_ONLY=t(new r({position:!0})),r.POSITION_AND_NORMAL=t(new r({position:!0,normal:!0})),r.POSITION_NORMAL_AND_ST=t(new r({position:!0,normal:!0,st:!0})),r.POSITION_AND_ST=t(new r({position:!0,st:!0})),r.ALL=t(new r({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),r.DEFAULT=r.POSITION_NORMAL_AND_ST,r}),define("Core/ExtentGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./Extent","./Geometry","./GeometryInstance","./GeometryPipeline","./GeographicProjection","./GeometryAttribute","./GeometryAttributes","./Math","./Matrix2","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,n,i,o,a,s,u,l,c,f,m,h,y,p,d,w,v,g,E,b,x){"use strict";function C(e,t){return e<-w.PI_OVER_TWO||e>w.PI_OVER_TWO?!1:t>w.PI||t<-w.PI?!1:!0}function S(e,r,n,i,o){var a=e.radiiSquared;z=D.latitude-e.granYCos*r+n*e.granXSin;var s=et(z),u=tt(z),l=a.z*u;L=D.longitude+r*e.granYSin+n*e.granXCos;var c=s*et(L),f=s*tt(L),m=a.x*c,h=a.y*f,y=rt(m*c+h*f+l*u),p=m/y,d=h/y,w=l/y;t(i)&&(Y.x=p+c*i,Y.y=d+f*i,Y.z=w+u*i),t(o)&&(j.x=p+c*o,j.y=d+f*o,j.z=w+u*o)}function A(e,t){var r=new f({attributes:new d,primitiveType:E.TRIANGLES});return e.position&&(r.attributes.position=new p({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:t.positions})),e.normal&&(r.attributes.normal=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(r.attributes.tangent=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.binormal&&(r.attributes.binormal=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.binormals})),r}function M(e,t,r,n,o){var a=e.length,s=t.normal?new Float32Array(a):void 0,u=t.tangent?new Float32Array(a):void 0,l=t.binormal?new Float32Array(a):void 0,c=0,f=n?a/2:0;a=n&&o?a/2:a;for(var m=0;a>m;m+=3){var h=i.fromArray(e,m,Y),y=c+1,p=c+2;(t.normal||t.tangent||t.binormal)&&(V=r.geodeticSurfaceNormal(h,V),(t.tangent||t.binormal)&&(i.cross(i.UNIT_Z,V,H),g.multiplyByVector(G,H,H),i.normalize(H,H),t.binormal&&i.normalize(i.cross(V,H,k),k)),n&&(t.normal&&(s[c]=V.x,s[y]=V.y,s[p]=V.z),t.tangent&&(u[c]=H.x,u[y]=H.y,u[p]=H.z),t.binormal&&(l[c]=k.x,l[y]=k.y,l[p]=k.z)),o&&(t.normal&&(s[c+f]=-V.x,s[y+f]=-V.y,s[p+f]=-V.z),t.tangent&&(u[c+f]=-H.x,u[y+f]=-H.y,u[p+f]=-H.z),t.binormal&&(l[c+f]=k.x,l[y+f]=k.y,l[p+f]=k.z))),c+=3}return A(t,{positions:e,normals:s,tangents:u,binormals:l})}function T(e,t,r){for(var n=e.length,o=t.normal?new Float32Array(n):void 0,a=t.tangent?new Float32Array(n):void 0,s=t.binormal?new Float32Array(n):void 0,u=0,l=!0,c=n/2,f=0;c>f;f+=3){var m=i.fromArray(e,f,Y),h=u+1,y=u+2;if(t.normal||t.tangent||t.binormal){var p=i.fromArray(e,f+3,X);if(l){var d=i.fromArray(e,f+c,Q);i.subtract(p,m,p),i.subtract(d,m,d),V=i.normalize(i.cross(d,p,V),V),l=!1}i.equalsEpsilon(p,m,w.EPSILON10)&&(l=!0),(t.tangent||t.binormal)&&(k=r.geodeticSurfaceNormal(m,k),t.tangent&&(H=i.normalize(i.cross(k,V,H),H))),t.normal&&(o[u]=V.x,o[h]=V.y,o[y]=V.z,o[u+c]=V.x,o[h+c]=V.y,o[y+c]=V.z),t.tangent&&(a[u]=H.x,a[h]=H.y,a[y]=H.z,a[u+c]=H.x,a[h+c]=H.y,a[y+c]=H.z),t.binormal&&(s[u]=k.x,s[h]=k.y,s[y]=k.z,s[u+c]=k.x,s[h+c]=k.y,s[y+c]=k.z)}u+=3}return A(t,{positions:e,normals:o,tangents:a,binormals:s})}function O(e,r,n,i,o){return J.x=(L-_.west)*i.lonScalar-.5,J.y=(z-_.south)*i.latScalar-.5,v.multiplyByVector(B,J,J),J.x+=.5,J.y+=.5,t(o)&&(n[r+o]=J.x,n[r+1+o]=J.y),n[r++]=J.x,n[r++]=J.y,r}function I(e,t,r){return e[t+r]=j.x,e[t++]=Y.x,e[t+r]=j.y,e[t++]=Y.y,e[t+r]=j.z,e[t++]=Y.z,e}function N(e,t){for(var n=t.ellipsoid,i=t.size,o=t.height,u=t.width,l=t.surfaceHeight,c=0,f=e.position?new Float64Array(3*i):void 0,m=e.st?new Float32Array(2*i):void 0,h=0,y=0;o>y;++y)for(var d=0;u>d;++d)S(t,y,d,l),f[h++]=Y.x,f[h++]=Y.y,f[h++]=Y.z,e.st&&(J.x=(L-_.west)*t.lonScalar-.5,J.y=(z-_.south)*t.latScalar-.5,v.multiplyByVector(B,J,J),J.x+=.5,J.y+=.5,m[c++]=J.x,m[c++]=J.y);for(var w=M(f,e,n,!0,!1),g=6*(u-1)*(o-1),E=s.createTypedArray(i,g),b=0,x=0,C=0;o-1>C;++C){for(var A=0;u-1>A;++A){var T=b,O=T+u,I=O+1,N=T+1;E[x++]=T,E[x++]=O,E[x++]=N,E[x++]=N,E[x++]=O,E[x++]=I,++b}++b}return w.indices=E,e.st&&(w.attributes.st=new p({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:m})),{boundingSphere:r.fromExtent3D(t.extent,n,l),geometry:w}}function R(t,n){var o=n.surfaceHeight,u=n.extrudedHeight,l=Math.min(u,o),c=Math.max(u,o);if(w.equalsEpsilon(l,c,.1))return N(t,n);var f,y=n.height,d=n.width,v=n.size,g=n.ellipsoid,E=e(n.closeTop,!0),b=e(n.closeBottom,!0),x=2*d+2*y-4,C=2*(x+4),A=new Float64Array(3*C),R=t.st?new Float32Array(2*C):void 0,z=0,L=0,P=0,D=3*(C/2);for(f=0;y>f;f++)S(n,f,z,c,l),A=I(A,L,D),L+=3,t.st&&(P=O(t,P,R,n,C));for(f=y-1,z=0;d>z;z++)S(n,f,z,c,l),A=I(A,L,D),L+=3,t.st&&(P=O(t,P,R,n,C));for(z=d-1,f=y-1;f>=0;f--)S(n,f,z,c,l),A=I(A,L,D),L+=3,t.st&&(P=O(t,P,R,n,C));for(f=0,z=d-1;z>=0;z--)S(n,f,z,c,l),A=I(A,L,D),L+=3,t.st&&(P=O(t,P,R,n,C));var F=T(A,t,g);t.st&&(F.attributes.st=new p({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:R}));var q,_,B,U,G,W=s.createTypedArray(C,6*x),V=A.length/6,H=0;for(G=0;V-1>G;G++){q=G,U=q+1;var k=i.fromArray(A,3*q,X),J=i.fromArray(A,3*U,Q);i.equalsEpsilon(k,J,w.EPSILON10)||(_=q+V,B=_+1,W[H++]=q,W[H++]=_,W[H++]=U,W[H++]=U,W[H++]=_,W[H++]=B)}if(F.indices=W,b||E){var $,et,tt=0,rt=0;E&&(tt+=v,rt+=6*(d-1)*(y-1),$=c),b&&(tt+=v,rt+=6*(d-1)*(y-1),et=l);var nt=new Float64Array(3*tt),it=t.st?new Float32Array(2*tt):void 0,ot=s.createTypedArray(tt,rt);for(L=0,P=0,D=b&&E?3*v:0,f=0;y>f;++f)for(z=0;d>z;++z)S(n,f,z,$,et),b&&(nt[L+D]=j.x,nt[L+1+D]=j.y,nt[L+2+D]=j.z),E&&(nt[L]=Y.x,nt[L+1]=Y.y,nt[L+2]=Y.z),t.st&&(P=O(t,P,it,n,2*v)),L+=3;var at=M(nt,t,g,E,b);t.st&&(at.attributes.st=new p({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:it}));var st=0;for(H=0,D/=3,G=0;y-1>G;++G){for(var ut=0;d-1>ut;++ut)q=H,_=q+d,B=_+1,U=q+1,b&&(ot[st++]=U+D,ot[st++]=_+D,ot[st++]=q+D,ot[st++]=B+D,ot[st++]=_+D,ot[st++]=U+D),E&&(ot[st++]=q,ot[st++]=_,ot[st++]=U,ot[st++]=U,ot[st++]=_,ot[st++]=B),++H;++H}at.indices=ot,F=h.combine([new m({geometry:at}),new m({geometry:F})])}var lt=r.fromExtent3D(n.extent,g,c,Z),ct=r.fromExtent3D(n.extent,g,l,K),ft=r.union(lt,ct);return{boundingSphere:ft,geometry:F}}var z,L,P=new i,D=new o,F=new o,q=new i,_=new c,B=new v,U=new v,G=new g,W=new y,Y=new i,V=new i,H=new i,k=new i,j=new i,K=new r,Z=new r,X=new i,Q=new i,J=new n,$=new b,et=Math.cos,tt=Math.sin,rt=Math.sqrt,nt=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.extent,i=e(r.granularity,w.RADIANS_PER_DEGREE),o=e(r.ellipsoid,l.WGS84),a=e(r.height,0),s=r.rotation,c=r.stRotation,f=e(r.vertexFormat,x.DEFAULT);if(!t(n))throw new u("extent is required.");if(n.validate(),n.east<n.west)throw new u("options.extent.east must be greater than options.extent.west");if(n.north<n.south)throw new u("options.extent.north must be greater than options.extent.south");this._extent=n,this._granularity=i,this._ellipsoid=o,this._surfaceHeight=a,this._rotation=s,this._stRotation=c,this._vertexFormat=f,this._extrudedHeight=r.extrudedHeight,this._closeTop=r.closeTop,this._closeBottom=r.closeBottom,this._workerName="createExtentGeometry"};return nt.createGeometry=function(e){var r=e._extent,n=e._granularity,o=e._ellipsoid,a=e._surfaceHeight,s=e._rotation,l=e._stRotation,m=e._vertexFormat,h=e._extrudedHeight,y=e._closeTop,p=e._closeBottom,w=Math.ceil((r.east-r.west)/n)+1,E=Math.ceil((r.north-r.south)/n)+1,x=(r.east-r.west)/(w-1),S=(r.north-r.south)/(E-1),A=o.getRadiiSquared();c.clone(r,_),r.getNorthwest(D),r.getCenter(F);var M=S,T=x,O=0,I=0;if(t(s)){var z=et(s);M*=z,T*=z;var L=tt(s);O=S*L,I=x*L,W.project(D,P),W.project(F,q),i.subtract(P,q,P),v.fromRotation(s,U),v.multiplyByVector(U,P,P),i.add(P,q,P),W.unproject(P,D);var Y=D.latitude,V=Y+(w-1)*I,H=Y-M*(E-1),k=Y-M*(E-1)+(w-1)*I,j=Math.max(Y,V,H,k),K=Math.min(Y,V,H,k),Z=D.longitude,Q=Z+(w-1)*T,J=Z+(E-1)*O,rt=Z+(E-1)*O+(w-1)*T,nt=Math.max(Z,Q,J,rt),it=Math.min(Z,Q,J,rt);if(!(C(j,it)&&C(j,nt)&&C(K,it)&&C(K,nt)))throw new u("Rotated extent is invalid.");_.north=j,_.south=K,_.east=nt,_.west=it}var ot=1/(_.east-_.west),at=1/(_.north-_.south),st=w*E;if(t(l)){v.fromRotation(-l,B);var ut=o.cartographicToCartesian(F,X);i.normalize(ut,ut),b.fromAxisAngle(ut,-l,$),g.fromQuaternion($,G)}else v.clone(v.IDENTITY,B),g.clone(g.IDENTITY,G);var lt,ct={granYCos:M,granYSin:O,granXCos:T,granXSin:I,radiiSquared:A,ellipsoid:o,lonScalar:ot,latScalar:at,extent:r,width:w,height:E,surfaceHeight:a,size:st,extrudedHeight:h,closeTop:y,closeBottom:p};lt=t(h)?R(m,ct):N(m,ct);var ft=lt.boundingSphere;return lt=lt.geometry,new f({attributes:new d(lt.attributes),indices:lt.indices,primitiveType:lt.primitiveType,boundingSphere:ft})},nt}),define("Core/Color",["./defaultValue","./defined","./freezeObject","./DeveloperError","./FeatureDetection","./Math"],function(e,t,r,n,i,o){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+6*(t-e)*(2/3-r):e}var s=function(t,r,n,i){this.red=e(t,1),this.green=e(r,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromBytes=function(t,r,n,i){return t=s.byteToFloat(e(t,255)),r=s.byteToFloat(e(r,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),new s(t,r,n,i)};var u,l,c;i.supportsTypedArrays()&&(u=new ArrayBuffer(4),l=new Uint32Array(u),c=new Uint8Array(u)),s.fromRgba=function(e){return l[0]=e,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(t,r,n,i){t=e(t,0)%1,r=e(r,0),n=e(n,0),i=e(i,1);var o=n,u=n,l=n;if(0!==r){var c;c=.5>n?n*(1+r):n+r-n*r;var f=2*n-c;o=a(f,c,t+1/3),u=a(f,c,t),l=a(f,c,t-1/3)}return new s(o,u,l,i)},s.fromRandom=function(r,i){r=e(r,e.EMPTY_OBJECT);var a=r.red;if(!t(a)){var u=e(r.minimumRed,0),l=e(r.maximumRed,1);if(u>l)throw new n("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(l-u)}var c=r.green;if(!t(c)){var f=e(r.minimumGreen,0),m=e(r.maximumGreen,1);if(f>m)throw new n("minimumGreen must be less than or equal to maximumGreen");c=f+o.nextRandomNumber()*(m-f)}var h=r.blue;if(!t(h)){var y=e(r.minimumBlue,0),p=e(r.maximumBlue,1);if(y>p)throw new n("minimumBlue must be less than or equal to maximumBlue");h=y+o.nextRandomNumber()*(p-y)}var d=r.alpha;if(!t(d)){var w=e(r.minimumAlpha,0),v=e(r.maximumAlpha,1);if(w>v)throw new n("minimumAlpha must be less than or equal to maximumAlpha");d=w+o.nextRandomNumber()*(v-w)}return t(i)?(i.red=a,i.green=c,i.blue=h,i.alpha=d,i):new s(a,c,h,d)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,m=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,h=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,y=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){if(!t(r))throw new n("color is required");var i=s[r.toUpperCase()];if(t(i))return s.clone(i);var o=f.exec(r);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=m.exec(r),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=h.exec(r),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=y.exec(r),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(r,i,o){if(!t(r))throw new n("value is required");if(!t(i))throw new n("array is required");o=e(o,0),i[o++]=r.red,i[o++]=r.green,i[o++]=r.blue,i[o]=r.alpha},s.unpack=function(r,i,o){if(!t(r))throw new n("array is required");return i=e(i,0),t(o)||(o=new s),o.red=r[i++],o.green=r[i++],o.blue=r[i++],o.alpha=r[i],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var r=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=n,e[2]=i,e[3]=o,e):[r,n,i,o]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),l[0]},s.ALICEBLUE=r(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=r(s.fromCssColorString("#FAEBD7")),s.AQUA=r(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=r(s.fromCssColorString("#7FFFD4")),s.AZURE=r(s.fromCssColorString("#F0FFFF")),s.BEIGE=r(s.fromCssColorString("#F5F5DC")),s.BISQUE=r(s.fromCssColorString("#FFE4C4")),s.BLACK=r(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=r(s.fromCssColorString("#FFEBCD")),s.BLUE=r(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=r(s.fromCssColorString("#8A2BE2")),s.BROWN=r(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=r(s.fromCssColorString("#DEB887")),s.CADETBLUE=r(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=r(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=r(s.fromCssColorString("#D2691E")),s.CORAL=r(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=r(s.fromCssColorString("#6495ED")),s.CORNSILK=r(s.fromCssColorString("#FFF8DC")),s.CRIMSON=r(s.fromCssColorString("#DC143C")),s.CYAN=r(s.fromCssColorString("#00FFFF")),s.DARKBLUE=r(s.fromCssColorString("#00008B")),s.DARKCYAN=r(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=r(s.fromCssColorString("#B8860B")),s.DARKGRAY=r(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=r(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=r(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=r(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=r(s.fromCssColorString("#556B2F")),s.DARKORANGE=r(s.fromCssColorString("#FF8C00")),s.DARKORCHID=r(s.fromCssColorString("#9932CC")),s.DARKRED=r(s.fromCssColorString("#8B0000")),s.DARKSALMON=r(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=r(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=r(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=r(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=r(s.fromCssColorString("#00CED1")),s.DARKVIOLET=r(s.fromCssColorString("#9400D3")),s.DEEPPINK=r(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=r(s.fromCssColorString("#00BFFF")),s.DIMGRAY=r(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=r(s.fromCssColorString("#1E90FF")),s.FIREBRICK=r(s.fromCssColorString("#B22222")),s.FLORALWHITE=r(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=r(s.fromCssColorString("#228B22")),s.FUSCHIA=r(s.fromCssColorString("#FF00FF")),s.GAINSBORO=r(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=r(s.fromCssColorString("#F8F8FF")),s.GOLD=r(s.fromCssColorString("#FFD700")),s.GOLDENROD=r(s.fromCssColorString("#DAA520")),s.GRAY=r(s.fromCssColorString("#808080")),s.GREEN=r(s.fromCssColorString("#008000")),s.GREENYELLOW=r(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=r(s.fromCssColorString("#F0FFF0")),s.HOTPINK=r(s.fromCssColorString("#FF69B4")),s.INDIANRED=r(s.fromCssColorString("#CD5C5C")),s.INDIGO=r(s.fromCssColorString("#4B0082")),s.IVORY=r(s.fromCssColorString("#FFFFF0")),s.KHAKI=r(s.fromCssColorString("#F0E68C")),s.LAVENDER=r(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=r(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=r(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=r(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=r(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=r(s.fromCssColorString("#F08080")),s.LIGHTCYAN=r(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=r(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=r(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=r(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=r(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=r(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=r(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=r(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=r(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=r(s.fromCssColorString("#FFFFE0")),s.LIME=r(s.fromCssColorString("#00FF00")),s.LIMEGREEN=r(s.fromCssColorString("#32CD32")),s.LINEN=r(s.fromCssColorString("#FAF0E6")),s.MAGENTA=r(s.fromCssColorString("#FF00FF")),s.MAROON=r(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=r(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=r(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=r(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=r(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=r(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=r(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=r(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=r(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=r(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=r(s.fromCssColorString("#191970")),s.MINTCREAM=r(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=r(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=r(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=r(s.fromCssColorString("#FFDEAD")),s.NAVY=r(s.fromCssColorString("#000080")),s.OLDLACE=r(s.fromCssColorString("#FDF5E6")),s.OLIVE=r(s.fromCssColorString("#808000")),s.OLIVEDRAB=r(s.fromCssColorString("#6B8E23")),s.ORANGE=r(s.fromCssColorString("#FFA500")),s.ORANGERED=r(s.fromCssColorString("#FF4500")),s.ORCHID=r(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=r(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=r(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=r(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=r(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=r(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=r(s.fromCssColorString("#FFDAB9")),s.PERU=r(s.fromCssColorString("#CD853F")),s.PINK=r(s.fromCssColorString("#FFC0CB")),s.PLUM=r(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=r(s.fromCssColorString("#B0E0E6")),s.PURPLE=r(s.fromCssColorString("#800080")),s.RED=r(s.fromCssColorString("#FF0000")),s.ROSYBROWN=r(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=r(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=r(s.fromCssColorString("#8B4513")),s.SALMON=r(s.fromCssColorString("#FA8072")),s.SANDYBROWN=r(s.fromCssColorString("#F4A460")),s.SEAGREEN=r(s.fromCssColorString("#2E8B57")),s.SEASHELL=r(s.fromCssColorString("#FFF5EE")),s.SIENNA=r(s.fromCssColorString("#A0522D")),s.SILVER=r(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=r(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=r(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=r(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=r(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=r(s.fromCssColorString("#00FF7F")),s.STEELBLUE=r(s.fromCssColorString("#4682B4")),s.TAN=r(s.fromCssColorString("#D2B48C")),s.TEAL=r(s.fromCssColorString("#008080")),s.THISTLE=r(s.fromCssColorString("#D8BFD8")),s.TOMATO=r(s.fromCssColorString("#FF6347")),s.TURQUOISE=r(s.fromCssColorString("#40E0D0")),s.VIOLET=r(s.fromCssColorString("#EE82EE")),s.WHEAT=r(s.fromCssColorString("#F5DEB3")),s.WHITE=r(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=r(s.fromCssColorString("#F5F5F5")),s.YELLOW=r(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=r(s.fromCssColorString("#9ACD32")),s}),define("Scene/PrimitivePipeline",["../Core/defined","../Core/defaultValue","../Core/Color","../Core/ComponentDatatype","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryPipeline","../Core/Matrix4"],function(e,t,r,n,i,o,a,s,u,l){"use strict";function c(e,t,r){var n,i=!r,o=e.length;if(!i&&o>1){var a=e[0].modelMatrix;for(n=1;o>n;++n)if(!l.equals(a,e[n].modelMatrix)){i=!0;break}}if(i)for(n=0;o>n;++n)u.transformToWorldCoordinates(e[n]);else l.clone(e[0].modelMatrix,t)}function f(e,t){for(var i=e.length,o=0;i>o;++o){var a=e[o],u=a.geometry,l=u.attributes,c=l.position,f=4*(c.values.length/c.componentsPerAttribute);l.pickColor=new s({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(f)});for(var m=t[o],h=r.floatToByte(m.red),y=r.floatToByte(m.green),p=r.floatToByte(m.blue),d=r.floatToByte(m.alpha),w=l.pickColor.values,v=0;f>v;v+=4)w[v]=h,w[v+1]=y,w[v+2]=p,w[v+3]=d}}function m(t){var r,n=t.length,i=[],o=t[0].attributes;for(r in o)if(o.hasOwnProperty(r)){for(var a=o[r],s=!0,u=1;n>u;++u){var l=t[u].attributes[r];if(!e(l)||a.componentDatatype.value!==l.componentDatatype.value||a.componentsPerAttribute!==l.componentsPerAttribute||a.normalize!==l.normalize){s=!1;break}}s&&i.push(r)}return i}function h(e,t){for(var r=e.length,i=0;r>i;++i)for(var o=e[i],u=o.attributes,l=o.geometry,c=a.computeNumberOfVertices(l),f=t.length,m=0;f>m;++m){for(var h=t[m],y=u[h],p=y.componentDatatype,d=y.value,w=d.length,v=n.createTypedArray(p,c*w),g=0;c>g;++g)v.set(d,g*w);l.attributes[h]=new s({componentDatatype:p,componentsPerAttribute:w,normalize:y.normalize,values:v})}}function y(e){var t,r=e.instances,o=e.pickIds,a=e.projection,s=e.elementIndexUintSupported,l=e.allow3DOnly,y=e.allowPicking,p=e.vertexCacheOptimize,d=e.modelMatrix,w=r.length,v=r[0].geometry.primitiveType;for(t=1;w>t;++t)if(r[t].geometry.primitiveType!==v)throw new i("All instance geometries must have the same primitiveType.");if(c(r,d,l),!l)for(t=0;w>t;++t)u.wrapLongitude(r[t].geometry);y&&f(r,o);var g=m(r);if(h(r,g),p)for(t=0;w>t;++t)u.reorderForPostVertexCache(r[t].geometry),u.reorderForPreVertexCache(r[t].geometry);var E,b=u.combine(r),x=b.attributes;if(l)for(E in x)x.hasOwnProperty(E)&&x[E].componentDatatype.value===n.DOUBLE.value&&u.encodeAttribute(b,E,E+"3DHigh",E+"3DLow");else for(E in x)if(x.hasOwnProperty(E)&&x[E].componentDatatype.value===n.DOUBLE.value){var C=E+"3D",S=E+"2D";u.projectTo2D(b,E,C,S,a),u.encodeAttribute(b,C,C+"High",C+"Low"),u.encodeAttribute(b,S,S+"High",S+"Low")}return s?[b]:u.fitToUnsignedShortIndices(b)}function p(e,t,r){for(var i=[],o=e.attributes,a=r.length,s=0;a>s;++s){var u=r[s],l=o[u],c=l.componentDatatype;c.value===n.DOUBLE.value&&(c=n.FLOAT);var f=n.createTypedArray(c,l.values);i.push({index:t[u],componentDatatype:c,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,values:f}),delete o[u]}return i}function d(r,n,i){for(var o=[],s=m(r),u=r.length,l={},c={},f=0;u>f;++f)for(var h=r[f],y=a.computeNumberOfVertices(h.geometry),p=s.length,d=0;p>d;++d)for(var w=s[d],v=i[w],g=y;g>0;){for(var E,b=t(c[w],0),x=n[b],C=x.length,S=0;C>S&&(E=x[S],E.index!==v);++S);e(o[f])||(o[f]={}),e(o[f][w])||(o[f][w]={dirty:!1,value:h.attributes[w].value,indices:[]});var A,M=E.values.length/E.componentsPerAttribute,T=t(l[w],0);M>T+g?(A=g,o[f][w].indices.push({attribute:E,offset:T,count:A}),l[w]=T+g):(A=M-T,o[f][w].indices.push({attribute:E,offset:T,count:A}),l[w]=0,c[w]=b+1),g-=A}return o}function w(e){return{type:e.constructor.name,buffer:e.buffer}}function v(e){return new E[e.type](e.buffer)}if(!o.supportsTypedArrays())return{};var g={};g.combineGeometry=function(e){for(var t={instances:e.instances,pickIds:e.pickIds,ellipsoid:e.ellipsoid,projection:e.projection,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:l.clone(e.modelMatrix)},r=y(t),n=u.createAttributeIndices(r[0]),i=t.instances,o=m(i),a=[],s=r.length,c=0;s>c;++c){var f=r[c];
a.push(p(f,n,o))}var h=d(i,a,n);return{geometries:r,modelMatrix:t.modelMatrix,attributeIndices:n,vaAttributes:a,vaAttributeIndices:h}};var E={Int8Array:Int8Array,Uint8Array:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};return g.transferGeometry=function(t,r){var n,i=t.attributes;for(var o in i)i.hasOwnProperty(o)&&e(i[o])&&e(i[o].values)&&(n=i[o].values,r.indexOf(i[o].values.buffer)<0&&r.push(n.buffer),e(n.type)||(i[o].values=w(n)));e(t.indices)&&(n=t.indices,r.push(n.buffer),e(n.type)||(t.indices=w(t.indices)))},g.transferGeometries=function(e,t){for(var r=e.length,n=0;r>n;++n)g.transferGeometry(e[n],t)},g.transferPerInstanceAttributes=function(e,t){for(var r=e.length,n=0;r>n;++n)for(var i=e[n],o=i.length,a=0;o>a;++a){var s=i[a].values;t.push(s.buffer),i[a].values=w(s)}},g.transferInstances=function(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n];g.transferGeometry(i.geometry,t)}},g.receiveGeometry=function(t){var r=t.attributes;for(var n in r)r.hasOwnProperty(n)&&e(r[n])&&e(r[n].values)&&(r[n].values=v(r[n].values));e(t.indices)&&(t.indices=v(t.indices))},g.receiveGeometries=function(e){for(var t=e.length,r=0;t>r;++r)g.receiveGeometry(e[r])},g.receivePerInstanceAttributes=function(e){for(var t=e.length,r=0;t>r;++r)for(var n=e[r],i=n.length,o=0;i>o;++o)n[o].values=v(n[o].values)},g.receiveInstances=function(e){for(var t=e.length,r=0;t>r;++r){var n=e[r];g.receiveGeometry(n.geometry)}},g}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined"],function(e,t){"use strict";var r=function(r){var n,i=[],o={id:void 0,result:void 0,error:void 0};return function(a){var s=a.data;i.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=r(s.parameters,i)}catch(u){o.error=u}t(n)||(n=e(self.webkitPostMessage,self.postMessage));try{n(o,i)}catch(u){o.result=void 0,o.error="postMessage failed with error: "+u+"\n  with responseMessage: "+JSON.stringify(o),n(o)}}};return r}),define("Workers/createExtentGeometry",["../Core/ExtentGeometry","../Core/Ellipsoid","../Core/Extent","../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,t,r,n,i){"use strict";function o(i,o){var a=i.geometry;a._ellipsoid=t.clone(a._ellipsoid),a._extent=r.clone(a._extent);var s=e.createGeometry(a);return n.transferGeometry(s,o),{geometry:s,index:i.index}}return i(o)})}();