/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2013 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var o=r.clock,a=r.cone,s=e(r.magnitude,1),u=s*Math.sin(a);return n.x=u*Math.cos(o),n.y=u*Math.sin(o),n.z=s*Math.cos(a),n},i.fromElements=function(e,r,n,o){return t(o)?(o.x=e,o.y=r,o.z=n,o):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r):new i(e.x/n,e.y/n,e.z/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n):new i(e.x*r.x,e.y*r.y,e.z*r.z)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n):new i(e.x+r.x,e.y+r.y,e.z+r.z)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n):new i(e.x-r.x,e.y-r.y,e.z-r.z)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n):new i(e.x*r,e.y*r,e.z*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n):new i(e.x/r,e.y/r,e.z/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r):new i(-e.x,-e.y,-e.z)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i,u=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,u);var r=i.dot(s,u),n=i.magnitude(i.cross(s,u,s));return Math.atan2(n,r)};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n},i.cross=function(e,r,n){var o=e.x,a=e.y,s=e.z,u=r.x,l=r.y,c=r.z,f=a*c-s*l,h=s*u-o*c,m=o*l-a*u;return t(n)?(n.x=f,n.y=h,n.z=m,n):new i(f,h,m)},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n,i){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,r,n,o,a){return t(a)?(a.x=e,a.y=r,a.z=n,a.w=o,a):new i(e,r,n,o)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n++],o.w=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n.w=Math.min(e.w,r.w),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n.w=Math.max(e.w,r.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r.w=e.w/n,r):new i(e.x/n,e.y/n,e.z/n,e.w/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n.w=e.w*r.w,n):new i(e.x*r.x,e.y*r.y,e.z*r.z,e.w*r.w)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n):new i(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n):new i(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n):new i(e.x*r,e.y*r,e.z*r,e.w*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n):new i(e.x/r,e.y/r,e.z/r,e.w/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new i(-e.x,-e.y,-e.z,-e.w)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r.w=Math.abs(e.w),r):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z),Math.abs(e.w))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n&&Math.abs(e.w-r.w)<=n},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["./defaultValue","./defined","./DeveloperError","../ThirdParty/mersenne-twister"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.negativePiToPi=function(e){for(var t=i.EPSILON10,r=i.PI,n=i.TWO_PI;-(r+t)>e;)e+=n;if(-r>e)return-r;for(;e>r+t;)e-=n;return e>r?r:e},i.zeroToTwoPi=function(e){var t=e%i.TWO_PI;return 0>t?(t+i.TWO_PI)%i.TWO_PI:t},i.equalsEpsilon=function(t,r,n){return n=e(n,0),Math.abs(t-r)<=n};var o=[1];i.factorial=function(e){var t=o.length;if(e>=t)for(var r=o[t-1],n=t;e>=n;n++)o.push(r*n);return o[e]},i.incrementWrap=function(t,r,n){return n=e(n,0),++t,t>r&&(t=n),t},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,r){return t>e?t:e>r?r:e};var a=new n;return i.setRandomNumberSeed=function(e){a=new n(e)},i.nextRandomNumber=function(){return a.random()},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var o=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return o.fromDegrees=function(r,n,a,s){return r=i.toRadians(e(r,0)),n=i.toRadians(e(n,0)),a=e(a,0),t(s)?(s.longitude=r,s.latitude=n,s.height=a,s):new o(r,n,a)},o.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new r("epsilon is required and must be a number.");return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.toString=function(e){if(!t(e))throw new r("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return o.toString(this)},o}),define("Core/Ellipsoid",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic"],function(e,t,r,n,i,o,a){"use strict";var s=function(e,r,a){if(e=t(e,0),r=t(r,0),a=t(a,0),0>e||0>r||0>a)throw new n("All radii components must be greater than or equal to zero.");this._radii=new o(e,r,a),this._radiiSquared=new o(e*e,r*r,a*a),this._radiiToTheFourth=new o(e*e*e*e,r*r*r*r,a*a*a*a),this._oneOverRadii=new o(0===e?0:1/e,0===r?0:1/r,0===a?0:1/a),this._oneOverRadiiSquared=new o(0===e?0:1/(e*e),0===r?0:1/(r*r),0===a?0:1/(a*a)),this._minimumRadius=Math.min(e,r,a),this._maximumRadius=Math.max(e,r,a),this._centerToleranceSquared=i.EPSILON1};s.clone=function(e,t){if(!r(e))return void 0;var n=e._radii;return r(t)?(o.clone(n,t._radii),o.clone(e._radiiSquared,t._radiiSquared),o.clone(e._radiiToTheFourth,t._radiiToTheFourth),o.clone(e._oneOverRadii,t._oneOverRadii),o.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new s(n.x,n.y,n.z)},s.fromCartesian3=function(e){return r(e)?new s(e.x,e.y,e.z):new s},s.WGS84=e(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=e(new s(1,1,1)),s.MOON=e(new s(i.LUNAR_RADIUS,i.LUNAR_RADIUS,i.LUNAR_RADIUS)),s.prototype.getRadii=function(){return this._radii},s.prototype.getRadiiSquared=function(){return this._radiiSquared},s.prototype.getRadiiToTheFourth=function(){return this._radiiToTheFourth},s.prototype.getOneOverRadii=function(){return this._oneOverRadii},s.prototype.getOneOverRadiiSquared=function(){return this._oneOverRadiiSquared},s.prototype.getMinimumRadius=function(){return this._minimumRadius},s.prototype.getMaximumRadius=function(){return this._maximumRadius},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=o.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(e,t){if(!r(e))throw new n("cartographic is required.");var i=e.longitude,a=e.latitude,s=Math.cos(a),u=s*Math.cos(i),l=s*Math.sin(i),c=Math.sin(a);return r(t)||(t=new o),t.x=u,t.y=l,t.z=c,o.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(e,t){return t=o.multiplyComponents(e,this._oneOverRadiiSquared,t),o.normalize(t,t)};var u=new o,l=new o;s.prototype.cartographicToCartesian=function(e,t){var r=u,n=l;this.geodeticSurfaceNormalCartographic(e,r),o.multiplyComponents(this._radiiSquared,r,n);var i=Math.sqrt(o.dot(r,n));return o.divideByScalar(n,i,n),o.multiplyByScalar(r,e.height,r),o.add(n,r,t)},s.prototype.cartographicArrayToCartesianArray=function(e,t){if(!r(e))throw new n("cartographics is required.");var i=e.length;r(t)?t.length=i:t=new Array(i);for(var o=0;i>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var c=new o,f=new o,h=new o;s.prototype.cartesianToCartographic=function(e,t){var n=this.scaleToGeodeticSurface(e,f);if(!r(n))return void 0;var s=this.geodeticSurfaceNormal(n,c),u=o.subtract(e,n,h),l=Math.atan2(s.y,s.x),m=Math.asin(s.z),y=i.sign(o.dot(u,e))*o.magnitude(u);return r(t)?(t.longitude=l,t.latitude=m,t.height=y,t):new a(l,m,y)},s.prototype.cartesianArrayToCartographicArray=function(e,t){if(!r(e))throw new n("cartesians is required.");var i=e.length;r(t)?t.length=i:t=new Array(i);for(var o=0;i>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t};var m=new o,y=new o;return s.prototype.scaleToGeodeticSurface=function(e,t){if(!r(e))throw new n("cartesian is required.");var a=e.x,s=e.y,u=e.z,l=this._oneOverRadii,c=l.x,f=l.y,h=l.z,d=a*a*c*c,p=s*s*f*f,v=u*u*h*h,w=d+p+v,g=Math.sqrt(1/w),E=o.multiplyByScalar(e,g,m);if(w<this._centerToleranceSquared)return isFinite(g)?o.clone(E,t):void 0;var C=this._oneOverRadiiSquared,b=C.x,S=C.y,x=C.z,M=y;M.x=2*E.x*b,M.y=2*E.y*S,M.z=2*E.z*x;var A,T,I,O,R,N,z,L,P,D,F,q=(1-g)*o.magnitude(e)/(.5*o.magnitude(M)),_=0;do{q-=_,I=1/(1+q*b),O=1/(1+q*S),R=1/(1+q*x),N=I*I,z=O*O,L=R*R,P=N*I,D=z*O,F=L*R,A=d*N+p*z+v*L-1,T=d*P*b+p*D*S+v*F*x;var B=-2*T;_=A/B}while(Math.abs(A)>i.EPSILON12);return r(t)?(t.x=a*I,t.y=s*O,t.z=u*R,t):new o(a*I,s*O,u*R)},s.prototype.scaleToGeocentricSurface=function(e,t){if(!r(e))throw new n("cartesian is required.");var i=e.x,a=e.y,s=e.z,u=this._oneOverRadiiSquared,l=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return o.multiplyByScalar(e,l,t)},s.prototype.transformPositionToScaledSpace=function(e,t){return o.multiplyComponents(e,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(e,t){return o.multiplyComponents(e,this._radii,t)},s.prototype.equals=function(e){return this===e||r(e)&&o.equals(this._radii,e._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Ellipsoid"],function(e,t,r,n,i){"use strict";var o=function(t){this._ellipsoid=e(t,i.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return o.prototype.getEllipsoid=function(){return this._ellipsoid},o.prototype.project=function(e,n){var i=this._semimajorAxis,o=e.longitude*i,a=e.latitude*i,s=e.height;return t(n)?(n.x=o,n.y=a,n.z=s,n):new r(o,a,s)},o.prototype.unproject=function(e,r){var i=this._oneOverSemimajorAxis,o=e.x*i,a=e.y*i,s=e.z;return t(r)?(r.longitude=o,r.latitude=a,r.height=s,r):new n(o,a,s)},o}),define("Core/Enumeration",["./defined"],function(e){"use strict";var t=function(t,r,n){if(this.value=t,this.name=r,e(n))for(var i in n)n.hasOwnProperty(i)&&(this[i]=n[i])};return t.prototype.valueOf=function(){return this.value},t.prototype.toString=function(){return this.name},t}),define("Core/Intersect",["./Enumeration"],function(e){"use strict";var t={OUTSIDE:new e(-1,"OUTSIDE"),INTERSECTING:new e(0,"INTERSECTING"),INSIDE:new e(1,"INSIDE")};return t}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,o){"use strict";function a(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var n=e[l.getElementIndex(f[r],c[r])];t+=2*n*n}return Math.sqrt(t)}function u(e,t){for(var r=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var s=Math.abs(e[l.getElementIndex(f[a],c[a])]);s>n&&(i=a,n=s)}var u=1,h=0,m=c[i],y=f[i];if(Math.abs(e[l.getElementIndex(y,m)])>r){var d,p=e[l.getElementIndex(y,y)],v=e[l.getElementIndex(m,m)],w=e[l.getElementIndex(y,m)],g=(p-v)/2/w;d=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),u=1/Math.sqrt(1+d*d),h=d*u}return t=l.clone(l.IDENTITY,t),t[l.getElementIndex(m,m)]=t[l.getElementIndex(y,y)]=u,t[l.getElementIndex(y,m)]=h,t[l.getElementIndex(m,y)]=-h,t}var l=function(e,r,n,i,o,a,s,u,l){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(o,0),this[5]=t(u,0),this[6]=t(n,0),this[7]=t(a,0),this[8]=t(l,0)};l.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,n,i){return n=t(n,0),r(i)||(i=new l),i[0]=e[n],i[1]=e[n+1],i[2]=e[n+2],i[3]=e[n+3],i[4]=e[n+4],i[5]=e[n+5],i[6]=e[n+6],i[7]=e[n+7],i[8]=e[n+8],i[9]=e[n+9],i},l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,t){var n=e.x*e.x,i=e.x*e.y,o=e.x*e.z,a=e.x*e.w,s=e.y*e.y,u=e.y*e.z,c=e.y*e.w,f=e.z*e.z,h=e.z*e.w,m=e.w*e.w,y=n-s-f+m,d=2*(i-h),p=2*(o+c),v=2*(i+h),w=-n+s-f+m,g=2*(u-a),E=2*(o-c),C=2*(u+a),b=-n-s+f+m;return r(t)?(t[0]=y,t[1]=v,t[2]=E,t[3]=d,t[4]=w,t[5]=C,t[6]=p,t[7]=g,t[8]=b,t):new l(y,d,p,v,w,g,E,C,b)},l.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new l(e,0,0,0,e,0,0,0,e)},l.fromRotationX=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=i,t[6]=0,t[7]=-i,t[8]=n,t):new l(1,0,0,0,n,-i,0,i,n)},l.fromRotationY=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=n,t):new l(n,0,i,0,1,0,-i,0,n)},l.fromRotationZ=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=i,t[2]=0,t[3]=-i,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new l(n,-i,0,i,n,0,0,0,1)},l.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,t){return 3*e+t},l.getColumn=function(t,n,i){var o=3*n,a=t[o],s=t[o+1],u=t[o+2];return r(i)?(i.x=a,i.y=s,i.z=u,i):new e(a,s,u)},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var i=3*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n},l.getRow=function(t,n,i){var o=t[n],a=t[n+3],s=t[n+6];return r(i)?(i.x=o,i.y=a,i.z=s,i):new e(o,a,s)},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n},l.multiply=function(e,t,n){var i=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],s=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],f=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],h=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],m=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r(n)?(n[0]=i,n[1]=o,n[2]=a,n[3]=s,n[4]=u,n[5]=c,n[6]=f,n[7]=h,n[8]=m,n):new l(i,s,f,o,u,h,a,c,m)},l.multiplyByVector=function(t,n,i){var o=n.x,a=n.y,s=n.z,u=t[0]*o+t[3]*a+t[6]*s,l=t[1]*o+t[4]*a+t[7]*s,c=t[2]*o+t[5]*a+t[8]*s;return r(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByScalar=function(e,t,n){return r(n)?(n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n):new l(e[0]*t,e[3]*t,e[6]*t,e[1]*t,e[4]*t,e[7]*t,e[2]*t,e[5]*t,e[8]*t)},l.negate=function(e,t){return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t):new l(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},l.transpose=function(e,t){var n=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],c=e[2],f=e[5],h=e[8];return r(t)?(t[0]=n,t[1]=i,t[2]=o,t[3]=a,t[4]=s,t[5]=u,t[6]=c,t[7]=f,t[8]=h,t):new l(n,a,c,i,s,f,o,u,h)};var c=[1,0,0],f=[2,2,1],h=new l,m=new l;return l.getEigenDecomposition=function(e,t){var n=o.EPSILON20,i=10,c=0,f=0;r(t)||(t={});for(var y=t.unitary=l.clone(l.IDENTITY,t.unitary),d=t.diagonal=l.clone(e,t.diagonal),p=n*a(d);i>f&&s(d)>p;)u(d,h),l.transpose(h,m),l.multiply(d,h,d),l.multiply(m,d,d),l.multiply(y,h,y),++c>2&&(++f,c=0);return t},l.abs=function(e,t){return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t):new l(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},l.determinant=function(e){if(!r(e))throw new n("matrix is required");var t=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],l=e[2],c=e[5],f=e[8];return t*(s*f-c*u)+a*(c*o-i*f)+l*(i*u-s*o)},l.inverse=function(e,t){if(!r(e))throw new n("matrix is required");var i=e[0],a=e[1],s=e[2],u=e[3],c=e[4],f=e[5],h=e[6],m=e[7],y=e[8],d=l.determinant(e);if(Math.abs(d)<=o.EPSILON15)throw new n("matrix is not invertible");var p=new l(c*y-m*f,h*f-u*y,u*m-h*c,m*s-a*y,i*y-h*s,h*a-i*m,a*f-c*s,u*s-i*f,i*c-u*a),v=1/d;return l.multiplyByScalar(p,v,t)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},l.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},l.IDENTITY=i(new l(1,0,0,0,1,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,o,a,s,u){"use strict";var l=function(e,t,n,i,o,a,s,u,l,c,f,h,m,y,d,p){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(l,0),this[3]=r(m,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(c,0),this[7]=r(y,0),this[8]=r(n,0),this[9]=r(s,0),this[10]=r(f,0),this[11]=r(d,0),this[12]=r(i,0),this[13]=r(u,0),this[14]=r(h,0),this[15]=r(p,0)};l.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=function(e,t,i){return t=r(t,0),n(i)||(i=new l),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i[9]=e[t+9],i[10]=e[t+10],i[11]=e[t+11],i[12]=e[t+12],i[13]=e[t+13],i[14]=e[t+14],i[15]=e[t+15],i},l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(e,t,r){return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=0,r[4]=e[3],r[5]=e[4],r[6]=e[5],r[7]=0,r[8]=e[6],r[9]=e[7],r[10]=e[8],r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,r):new l(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},new s,l.fromTranslationQuaternionRotationScale=function(e,t,r,i){n(i)||(i=new l);var o=r.x,a=r.y,s=r.z,u=t.x*t.x,c=t.x*t.y,f=t.x*t.z,h=t.x*t.w,m=t.y*t.y,y=t.y*t.z,d=t.y*t.w,p=t.z*t.z,v=t.z*t.w,w=t.w*t.w,g=u-m-p+w,E=2*(c-v),C=2*(f+d),b=2*(c+v),S=-u+m-p+w,x=2*(y-h),M=2*(f-d),A=2*(y+h),T=-u-m+p+w;return i[0]=g*o,i[1]=b*o,i[2]=M*o,i[3]=0,i[4]=E*a,i[5]=S*a,i[6]=A*a,i[7]=0,i[8]=C*s,i[9]=x*s,i[10]=T*s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},l.fromTranslation=function(e,t){return l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,f=new e,h=new e;l.fromCamera=function(t,r){var i=t.eye,o=t.target,a=t.up;e.normalize(e.subtract(o,i,c),c),e.normalize(e.cross(c,a,f),f),e.normalize(e.cross(f,c,h),h);var s=f.x,u=f.y,m=f.z,y=c.x,d=c.y,p=c.z,v=h.x,w=h.y,g=h.z,E=i.x,C=i.y,b=i.z,S=s*-E+u*-C+m*-b,x=v*-E+w*-C+g*-b,M=y*E+d*C+p*b;return n(r)?(r[0]=s,r[1]=v,r[2]=-y,r[3]=0,r[4]=u,r[5]=w,r[6]=-d,r[7]=0,r[8]=m,r[9]=g,r[10]=-p,r[11]=0,r[12]=S,r[13]=x,r[14]=M,r[15]=1,r):new l(s,u,m,S,v,w,g,x,-y,-d,-p,M,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,r,i,o){var a=Math.tan(.5*e),s=1/a,u=s/t,c=(i+r)/(r-i),f=2*i*r/(r-i);return n(o)?(o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=f,o[15]=0,o):new l(u,0,0,0,0,s,0,0,0,0,c,f,0,0,-1,0)},l.computeOrthographicOffCenter=function(e,t,r,i,o,a,s){var u=1/(t-e),c=1/(i-r),f=1/(a-o),h=-(t+e)*u,m=-(i+r)*c,y=-(a+o)*f;return u*=2,c*=2,f*=-2,n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=h,s[13]=m,s[14]=y,s[15]=1,s):new l(u,0,0,h,0,c,0,m,0,0,f,y,0,0,0,1)},l.computePerspectiveOffCenter=function(e,t,r,i,o,a,s){var u=2*o/(t-e),c=2*o/(i-r),f=(t+e)/(t-e),h=(i+r)/(i-r),m=-(a+o)/(a-o),y=-1,d=-2*a*o/(a-o);return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=h,s[10]=m,s[11]=y,s[12]=0,s[13]=0,s[14]=d,s[15]=0,s):new l(u,0,f,0,0,c,h,0,0,0,m,d,0,0,y,0)},l.computeInfinitePerspectiveOffCenter=function(e,t,r,i,o,a){var s=2*o/(t-e),u=2*o/(i-r),c=(t+e)/(t-e),f=(i+r)/(i-r),h=-1,m=-1,y=-2*o;return n(a)?(a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=h,a[11]=m,a[12]=0,a[13]=0,a[14]=y,a[15]=0,a):new l(s,0,c,0,0,u,f,0,0,0,h,y,0,0,m,0)},l.computeViewportTransformation=function(e,t,i,o){e=r(e,r.EMPTY_OBJECT);var a=r(e.x,0),s=r(e.y,0),u=r(e.width,0),c=r(e.height,0);t=r(t,0),i=r(i,1);var f=.5*u,h=.5*c,m=.5*(i-t),y=f,d=h,p=m,v=a+f,w=s+h,g=t+m,E=1;return n(o)?(o[0]=y,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=d,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=p,o[11]=0,o[12]=v,o[13]=w,o[14]=g,o[15]=E,o):new l(y,0,0,v,0,d,0,w,0,0,p,g,0,0,0,E)},l.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return 4*e+t},l.getColumn=function(e,r,i){var o=4*r,a=e[o],s=e[o+1],u=e[o+2],l=e[o+3];return n(i)?(i.x=a,i.y=s,i.z=u,i.w=l,i):new t(a,s,u,l)},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var i=4*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n[i+3]=r.w,n},l.getRow=function(e,r,i){var o=e[r],a=e[r+4],s=e[r+8],u=e[r+12];return n(i)?(i.x=o,i.y=a,i.z=s,i.w=u,i):new t(o,a,s,u)},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n},l.multiply=function(e,t,r){var i=e[0],o=e[1],a=e[2],s=e[3],u=e[4],c=e[5],f=e[6],h=e[7],m=e[8],y=e[9],d=e[10],p=e[11],v=e[12],w=e[13],g=e[14],E=e[15],C=t[0],b=t[1],S=t[2],x=t[3],M=t[4],A=t[5],T=t[6],I=t[7],O=t[8],R=t[9],N=t[10],z=t[11],L=t[12],P=t[13],D=t[14],F=t[15],q=i*C+u*b+m*S+v*x,_=o*C+c*b+y*S+w*x,B=a*C+f*b+d*S+g*x,U=s*C+h*b+p*S+E*x,G=i*M+u*A+m*T+v*I,W=o*M+c*A+y*T+w*I,Y=a*M+f*A+d*T+g*I,V=s*M+h*A+p*T+E*I,H=i*O+u*R+m*N+v*z,k=o*O+c*R+y*N+w*z,K=a*O+f*R+d*N+g*z,j=s*O+h*R+p*N+E*z,X=i*L+u*P+m*D+v*F,Z=o*L+c*P+y*D+w*F,Q=a*L+f*P+d*D+g*F,J=s*L+h*P+p*D+E*F;return n(r)?(r[0]=q,r[1]=_,r[2]=B,r[3]=U,r[4]=G,r[5]=W,r[6]=Y,r[7]=V,r[8]=H,r[9]=k,r[10]=K,r[11]=j,r[12]=X,r[13]=Z,r[14]=Q,r[15]=J,r):new l(q,G,H,X,_,W,k,Z,B,Y,K,Q,U,V,j,J)},l.multiplyTransformation=function(e,t,r){var i=e[0],o=e[1],a=e[2],s=e[4],u=e[5],c=e[6],f=e[8],h=e[9],m=e[10],y=e[12],d=e[13],p=e[14],v=t[0],w=t[1],g=t[2],E=t[4],C=t[5],b=t[6],S=t[8],x=t[9],M=t[10],A=t[12],T=t[13],I=t[14],O=i*v+s*w+f*g,R=o*v+u*w+h*g,N=a*v+c*w+m*g,z=i*E+s*C+f*b,L=o*E+u*C+h*b,P=a*E+c*C+m*b,D=i*S+s*x+f*M,F=o*S+u*x+h*M,q=a*S+c*x+m*M,_=i*A+s*T+f*I+y,B=o*A+u*T+h*I+d,U=a*A+c*T+m*I+p;
return n(r)?(r[0]=O,r[1]=R,r[2]=N,r[3]=0,r[4]=z,r[5]=L,r[6]=P,r[7]=0,r[8]=D,r[9]=F,r[10]=q,r[11]=0,r[12]=_,r[13]=B,r[14]=U,r[15]=1,r):new l(O,z,D,_,R,L,F,B,N,P,q,U,0,0,0,1)},l.multiplyByTranslation=function(e,t,r){var i=t.x,o=t.y,a=t.z,s=i*e[0]+o*e[4]+a*e[8]+e[12],u=i*e[1]+o*e[5]+a*e[9]+e[13],c=i*e[2]+o*e[6]+a*e[10]+e[14];return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=s,r[13]=u,r[14]=c,r[15]=e[15],r):new l(e[0],e[4],e[8],s,e[1],e[5],e[9],u,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var m=new e;return l.multiplyByUniformScale=function(e,t,r){return m.x=t,m.y=t,m.z=t,l.multiplyByScale(e,m,r)},l.multiplyByScale=function(e,t,r){var i=t.x,o=t.y,a=t.z;return 1===i&&1===o&&1===a?l.clone(e,r):n(r)?(r[0]=i*e[0],r[1]=i*e[1],r[2]=i*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=a*e[8],r[9]=a*e[9],r[10]=a*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r):new l(i*e[0],o*e[4],a*e[8],e[12],i*e[1],o*e[5],a*e[9],e[13],i*e[2],o*e[6],a*e[10],e[14],0,0,0,1)},l.multiplyByVector=function(e,r,i){var o=r.x,a=r.y,s=r.z,u=r.w,l=e[0]*o+e[4]*a+e[8]*s+e[12]*u,c=e[1]*o+e[5]*a+e[9]*s+e[13]*u,f=e[2]*o+e[6]*a+e[10]*s+e[14]*u,h=e[3]*o+e[7]*a+e[11]*s+e[15]*u;return n(i)?(i.x=l,i.y=c,i.z=f,i.w=h,i):new t(l,c,f,h)},l.multiplyByPointAsVector=function(t,r,i){var o=r.x,a=r.y,s=r.z,u=t[0]*o+t[4]*a+t[8]*s,l=t[1]*o+t[5]*a+t[9]*s,c=t[2]*o+t[6]*a+t[10]*s;return n(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByPoint=function(t,r,i){var o=r.x,a=r.y,s=r.z,u=t[0]*o+t[4]*a+t[8]*s+t[12],l=t[1]*o+t[5]*a+t[9]*s+t[13],c=t[2]*o+t[6]*a+t[10]*s+t[14];return n(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByScalar=function(e,t,r){return n(r)?(r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r):new l(e[0]*t,e[4]*t,e[8]*t,e[12]*t,e[1]*t,e[5]*t,e[9]*t,e[13]*t,e[2]*t,e[6]*t,e[10]*t,e[14]*t,e[3]*t,e[7]*t,e[11]*t,e[15]*t)},l.negate=function(e,t){return n(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t):new l(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},l.transpose=function(e,t){if(!n(t))return new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var r=e[1],i=e[2],o=e[3],a=e[6],s=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=s,t[14]=u,t[15]=e[15],t},l.abs=function(e,t){return n(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t):new l(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},l.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[11]===t[11]&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},l.getTranslation=function(t,r){return n(r)?(r.x=t[12],r.y=t[13],r.z=t[14],r):new e(t[12],t[13],t[14])},l.getRotation=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},l.inverse=function(e,t){var r=e[0],i=e[4],o=e[8],s=e[12],c=e[1],f=e[5],h=e[9],m=e[13],y=e[2],d=e[6],p=e[10],v=e[14],w=e[3],g=e[7],E=e[11],C=e[15],b=p*C,S=v*E,x=d*C,M=v*g,A=d*E,T=p*g,I=y*C,O=v*w,R=y*E,N=p*w,z=y*g,L=d*w,P=b*f+M*h+A*m-(S*f+x*h+T*m),D=S*c+I*h+N*m-(b*c+O*h+R*m),F=x*c+O*f+z*m-(M*c+I*f+L*m),q=T*c+R*f+L*h-(A*c+N*f+z*h),_=S*i+x*o+T*s-(b*i+M*o+A*s),B=b*r+O*o+R*s-(S*r+I*o+N*s),U=M*r+I*i+L*s-(x*r+O*i+z*s),G=A*r+N*i+z*o-(T*r+R*i+L*o);b=o*m,S=s*h,x=i*m,M=s*f,A=i*h,T=o*f,I=r*m,O=s*c,R=r*h,N=o*c,z=r*f,L=i*c;var W=b*g+M*E+A*C-(S*g+x*E+T*C),Y=S*w+I*E+N*C-(b*w+O*E+R*C),V=x*w+O*g+z*C-(M*w+I*g+L*C),H=T*w+R*g+L*E-(A*w+N*g+z*E),k=x*p+T*v+S*d-(A*v+b*d+M*p),K=R*v+b*y+O*p-(I*p+N*v+S*y),j=I*d+L*v+M*y-(z*v+x*y+O*d),X=z*p+A*y+N*d-(R*d+L*p+T*y),Z=r*P+i*D+o*F+s*q;if(Math.abs(Z)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return Z=1/Z,n(t)?(t[0]=P*Z,t[1]=D*Z,t[2]=F*Z,t[3]=q*Z,t[4]=_*Z,t[5]=B*Z,t[6]=U*Z,t[7]=G*Z,t[8]=W*Z,t[9]=Y*Z,t[10]=V*Z,t[11]=H*Z,t[12]=k*Z,t[13]=K*Z,t[14]=j*Z,t[15]=X*Z,t):new l(P*Z,_*Z,W*Z,k*Z,D*Z,B*Z,Y*Z,K*Z,F*Z,U*Z,V*Z,j*Z,q*Z,G*Z,H*Z,X*Z)},l.inverseTransformation=function(e,t){var r=e[0],i=e[1],o=e[2],a=e[4],s=e[5],u=e[6],c=e[8],f=e[9],h=e[10],m=e[12],y=e[13],d=e[14],p=-r*m-i*y-o*d,v=-a*m-s*y-u*d,w=-c*m-f*y-h*d;return n(t)?(t[0]=r,t[1]=a,t[2]=c,t[3]=0,t[4]=i,t[5]=s,t[6]=f,t[7]=0,t[8]=o,t[9]=u,t[10]=h,t[11]=0,t[12]=p,t[13]=v,t[14]=w,t[15]=1,t):new l(r,i,o,p,a,s,u,v,c,f,h,w,0,0,0,1)},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/BoundingSphere",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Cartesian4","./Cartographic","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4"],function(e,t,r,n,i,o,a,s,u,l,c){"use strict";var f=function(t,r){this.center=n.clone(e(t,n.ZERO)),this.radius=e(r,0)},h=new n,m=new n,y=new n,d=new n,p=new n,v=new n,w=new n,g=new n,E=new n,C=new n,b=new n,S=new n;f.fromPoints=function(e,r){if(t(r)||(r=new f),!t(e)||0===e.length)return r.center=n.clone(n.ZERO,r.center),r.radius=0,r;for(var i=n.clone(e[0],w),o=n.clone(i,h),a=n.clone(i,m),s=n.clone(i,y),u=n.clone(i,d),l=n.clone(i,p),c=n.clone(i,v),x=e.length,M=1;x>M;M++){n.clone(e[M],i);var A=i.x,T=i.y,I=i.z;A<o.x&&n.clone(i,o),A>u.x&&n.clone(i,u),T<a.y&&n.clone(i,a),T>l.y&&n.clone(i,l),I<s.z&&n.clone(i,s),I>c.z&&n.clone(i,c)}var O=n.magnitudeSquared(n.subtract(u,o,g)),R=n.magnitudeSquared(n.subtract(l,a,g)),N=n.magnitudeSquared(n.subtract(c,s,g)),z=o,L=u,P=O;R>P&&(P=R,z=a,L=l),N>P&&(P=N,z=s,L=c);var D=E;D.x=.5*(z.x+L.x),D.y=.5*(z.y+L.y),D.z=.5*(z.z+L.z);var F=n.magnitudeSquared(n.subtract(L,D,g)),q=Math.sqrt(F),_=C;_.x=o.x,_.y=a.y,_.z=s.z;var B=b;B.x=u.x,B.y=l.y,B.z=c.z;var U=n.multiplyByScalar(n.add(_,B,g),.5,S),G=0;for(M=0;x>M;M++){n.clone(e[M],i);var W=n.magnitude(n.subtract(i,U,g));W>G&&(G=W);var Y=n.magnitudeSquared(n.subtract(i,D,g));if(Y>F){var V=Math.sqrt(Y);q=.5*(q+V),F=q*q;var H=V-q;D.x=(q*D.x+H*i.x)/V,D.y=(q*D.y+H*i.y)/V,D.z=(q*D.z+H*i.z)/V}}return G>q?(n.clone(D,r.center),r.radius=q):(n.clone(U,r.center),r.radius=G),r};var x=new s,M=new n,A=new n,T=new o,I=new o;f.fromExtent2D=function(e,t,r){return f.fromExtentWithHeights2D(e,t,0,0,r)},f.fromExtentWithHeights2D=function(r,i,o,a,s){if(t(s)||(s=new f),!t(r))return s.center=n.clone(n.ZERO,s.center),s.radius=0,s;i=e(i,x),r.getSouthwest(T),T.height=o,r.getNortheast(I),I.height=a;var u=i.project(T,M),l=i.project(I,A),c=l.x-u.x,h=l.y-u.y,m=l.z-u.z;s.radius=.5*Math.sqrt(c*c+h*h+m*m);var y=s.center;return y.x=u.x+.5*c,y.y=u.y+.5*h,y.z=u.z+.5*m,s};var O=[];f.fromExtent3D=function(r,n,i,o){n=e(n,a.WGS84),i=e(i,0);var s;return t(r)&&(s=r.subsample(n,i,O)),f.fromPoints(s,o)},f.fromVertices=function(r,i,o,a){if(t(a)||(a=new f),!t(r)||0===r.length)return a.center=n.clone(n.ZERO,a.center),a.radius=0,a;i=e(i,n.ZERO),o=e(o,3);var s=w;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var u=n.clone(s,h),l=n.clone(s,m),c=n.clone(s,y),x=n.clone(s,d),M=n.clone(s,p),A=n.clone(s,v),T=r.length,I=0;T>I;I+=o){var O=r[I]+i.x,R=r[I+1]+i.y,N=r[I+2]+i.z;s.x=O,s.y=R,s.z=N,O<u.x&&n.clone(s,u),O>x.x&&n.clone(s,x),R<l.y&&n.clone(s,l),R>M.y&&n.clone(s,M),N<c.z&&n.clone(s,c),N>A.z&&n.clone(s,A)}var z=n.magnitudeSquared(n.subtract(x,u,g)),L=n.magnitudeSquared(n.subtract(M,l,g)),P=n.magnitudeSquared(n.subtract(A,c,g)),D=u,F=x,q=z;L>q&&(q=L,D=l,F=M),P>q&&(q=P,D=c,F=A);var _=E;_.x=.5*(D.x+F.x),_.y=.5*(D.y+F.y),_.z=.5*(D.z+F.z);var B=n.magnitudeSquared(n.subtract(F,_,g)),U=Math.sqrt(B),G=C;G.x=u.x,G.y=l.y,G.z=c.z;var W=b;W.x=x.x,W.y=M.y,W.z=A.z;var Y=n.multiplyByScalar(n.add(G,W,g),.5,S),V=0;for(I=0;T>I;I+=o){s.x=r[I]+i.x,s.y=r[I+1]+i.y,s.z=r[I+2]+i.z;var H=n.magnitude(n.subtract(s,Y,g));H>V&&(V=H);var k=n.magnitudeSquared(n.subtract(s,_,g));if(k>B){var K=Math.sqrt(k);U=.5*(U+K),B=U*U;var j=K-U;_.x=(U*_.x+j*s.x)/K,_.y=(U*_.y+j*s.y)/K,_.z=(U*_.z+j*s.z)/K}}return V>U?(n.clone(_,a.center),a.radius=U):(n.clone(Y,a.center),a.radius=V),a},f.fromCornerPoints=function(e,r,i){t(i)||(i=new f);var o=i.center;return n.add(e,r,o),n.multiplyByScalar(o,.5,o),i.radius=n.distance(o,r),i},f.fromEllipsoid=function(e,r){return t(r)||(r=new f),n.clone(n.ZERO,r.center),r.radius=e.getMaximumRadius(),r},f.clone=function(e,r){return t(e)?t(r)?(r.center=n.clone(e.center,r.center),r.radius=e.radius,r):new f(e.center,e.radius):void 0};var R=new n,N=new n;f.union=function(e,r,i){t(i)||(i=new f);var o=e.center,a=r.center;n.add(o,a,N);var s=n.multiplyByScalar(N,.5,N),u=n.magnitude(n.subtract(o,s,R))+e.radius,l=n.magnitude(n.subtract(a,s,R))+r.radius;return i.radius=Math.max(u,l),n.clone(s,i.center),i};var z=new n;f.expand=function(e,t,r){r=f.clone(e,r);var i=n.magnitude(n.subtract(t,r.center,z));return i>r.radius&&(r.radius=i),r},f.intersect=function(e,t){var r=e.center,i=e.radius,o=n.dot(t,r)+t.w;return-i>o?u.OUTSIDE:i>o?u.INTERSECTING:u.INSIDE};var L=new n;f.transform=function(e,r,i){return t(i)||(i=new f),i.center=c.multiplyByPoint(r,e.center,i.center),i.radius=Math.max(n.magnitude(c.getColumn(r,0,L)),n.magnitude(c.getColumn(r,1,L)),n.magnitude(c.getColumn(r,2,L)))*e.radius,i},f.transformWithoutScale=function(e,r,n){return t(n)||(n=new f),n.center=c.multiplyByPoint(r,e.center,n.center),n.radius=e.radius,n};var P=new n;f.getPlaneDistances=function(e,r,i,o){t(o)||(o=new l);var a=n.subtract(e.center,r,P),s=n.multiplyByScalar(i,n.dot(i,a),P),u=n.magnitude(s);return o.start=u-e.radius,o.stop=u+e.radius,o};for(var D=new n,F=new n,q=new n,_=new n,B=new n,U=new o,G=new Array(8),W=0;8>W;++W)G[W]=new n;var Y=new s;return f.projectTo2D=function(t,r,i){r=e(r,Y);var o=r.getEllipsoid(),a=t.center,s=t.radius,u=o.geodeticSurfaceNormal(a,D),l=n.cross(n.UNIT_Z,u,F);n.normalize(l,l);var c=n.cross(u,l,q);n.normalize(c,c),n.multiplyByScalar(u,s,u),n.multiplyByScalar(c,s,c),n.multiplyByScalar(l,s,l);var h=n.negate(c,B),m=n.negate(l,_),y=G,d=y[0];n.add(u,c,d),n.add(d,l,d),d=y[1],n.add(u,c,d),n.add(d,m,d),d=y[2],n.add(u,h,d),n.add(d,m,d),d=y[3],n.add(u,h,d),n.add(d,l,d),n.negate(u,u),d=y[4],n.add(u,c,d),n.add(d,l,d),d=y[5],n.add(u,c,d),n.add(d,m,d),d=y[6],n.add(u,h,d),n.add(d,m,d),d=y[7],n.add(u,h,d),n.add(d,l,d);for(var p=y.length,v=0;p>v;++v){var w=y[v];n.add(a,w,w);var g=o.cartesianToCartographic(w,U);r.project(g,w)}i=f.fromPoints(y,i),a=i.center;var E=a.x,C=a.y,b=a.z;return a.x=b,a.y=E,a.z=C,i},f.equals=function(e,r){return e===r||t(e)&&t(r)&&n.equals(e.center,r.center)&&e.radius===r.radius},f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.union=function(e,t){return f.union(this,e,t)},f.prototype.expand=function(e,t){return f.expand(this,e,t)},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.getPlaneDistances=function(e,t,r){return f.getPlaneDistances(this,e,t,r)},f.prototype.projectTo2D=function(e,t){return f.projectTo2D(this,e,t)},f.prototype.equals=function(e){return f.equals(this,e)},f}),define("Core/Fullscreen",["./defined"],function(e){"use strict";var t,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return n.supportsFullscreen=function(){if(e(t))return t;t=!1;var n=document.body;if("function"==typeof n.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];i=u+"RequestFullscreen","function"==typeof n[i]?(r.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof n[i]&&(r.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?r.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(r.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?r.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(r.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),r.fullscreenerror=i)}return t},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[r.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[r.exitFullscreen]()},n.isFullscreenEnabled=function(){return n.supportsFullscreen()?document[r.fullscreenEnabled]:void 0},n.getFullscreenElement=function(){return n.supportsFullscreen()?document[r.fullscreenElement]:void 0},n.isFullscreen=function(){return n.supportsFullscreen()?null!==n.getFullscreenElement():void 0},n.getFullscreenChangeEventName=function(){return n.supportsFullscreen()?r.fullscreenchange:void 0},n.getFullscreenErrorEventName=function(){return n.supportsFullscreen()?r.fullscreenerror:void 0},n}),define("Core/FeatureDetection",["./defined","./Fullscreen"],function(e,t){"use strict";function r(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function n(){if(!e(f)){var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===t?f=!1:(f=!0,h=r(t[1]))}return f}function i(){return n()&&h}function o(){if(!e(m))if(n()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))m=!1;else{var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===t?m=!1:(m=!0,y=r(t[1]))}return m}function a(){return o()&&y}function s(){if(!e(d)){var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===t?d=!1:(d=!0,p=r(t[1]),p.isNightly=!!t[2])}return d}function u(){return s()&&p}function l(){if(!e(v)){var t=/ MSIE ([\.0-9]+)/.exec(navigator.userAgent);null===t?v=!1:(v=!0,w=r(t[1]))}return v}function c(){return l()&&w}var f,h,m,y,d,p,v,w,g,E={isChrome:n,chromeVersion:i,isSafari:o,safariVersion:a,isWebkit:s,webkitVersion:u,isInternetExplorer:l,internetExplorerVersion:c};return E.supportsCrossOriginImagery=function(){return e(g)||(g=o()&&u()[0]<536?!1:"withCredentials"in new XMLHttpRequest),g},E.supportsFullscreen=function(){return t.supportsFullscreen()},E.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},E}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./Enumeration"],function(e,t,r,n,i){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:new i(5120,"BYTE",{sizeInBytes:Int8Array.BYTES_PER_ELEMENT}),UNSIGNED_BYTE:new i(5121,"UNSIGNED_BYTE",{sizeInBytes:Uint8Array.BYTES_PER_ELEMENT}),SHORT:new i(5122,"SHORT",{sizeInBytes:Int16Array.BYTES_PER_ELEMENT}),UNSIGNED_SHORT:new i(5123,"UNSIGNED_SHORT",{sizeInBytes:Uint16Array.BYTES_PER_ELEMENT}),FLOAT:new i(5126,"FLOAT",{sizeInBytes:Float32Array.BYTES_PER_ELEMENT}),DOUBLE:new i(5130,"DOUBLE",{sizeInBytes:Float64Array.BYTES_PER_ELEMENT})};return o.validate=function(e){return t(e)&&t(e.value)&&(e.value===o.BYTE.value||e.value===o.UNSIGNED_BYTE.value||e.value===o.SHORT.value||e.value===o.UNSIGNED_SHORT.value||e.value===o.FLOAT.value||e.value===o.DOUBLE.value)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e.value){case o.BYTE.value:return new Int8Array(n);case o.UNSIGNED_BYTE.value:return new Uint8Array(n);case o.SHORT.value:return new Int16Array(n);case o.UNSIGNED_SHORT.value:return new Uint16Array(n);case o.FLOAT.value:return new Float32Array(n);case o.DOUBLE.value:return new Float64Array(n);default:throw new r("componentDatatype is not a valid enumeration value.")}},o.createArrayBufferView=function(n,i,a,s){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),s=e(s,(i.byteLength-a)/n.sizeInBytes),n.value){case o.BYTE.value:return new Int8Array(i,a,s);case o.UNSIGNED_BYTE.value:return new Uint8Array(i,a,s);case o.SHORT.value:return new Int16Array(i,a,s);case o.UNSIGNED_SHORT.value:return new Uint16Array(i,a,s);case o.FLOAT.value:return new Float32Array(i,a,s);case o.DOUBLE.value:return new Float64Array(i,a,s);default:throw new r("componentDatatype is not a valid enumeration value.")}},o}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,t,r){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(t){return e(t)&&(t===n.UNSIGNED_BYTE||t===n.UNSIGNED_SHORT||t===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new t("numberOfVertices is required.");return n>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./BoundingSphere"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.attributes))throw new r("options.attributes is required.");if(!t(n.primitiveType))throw new r("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=a}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r):new i(e.x/n,e.y/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n):new i(e.x*r.x,e.y*r.y)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n):new i(e.x+r.x,e.y+r.y)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n):new i(e.x-r.x,e.y-r.y)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n):new i(e.x*r,e.y*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n):new i(e.x/r,e.y/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r):new i(-e.x,-e.y)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r):new i(Math.abs(e.x),Math.abs(e.y))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i,u=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,u),Math.acos(i.dot(s,u))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n,i){"use strict";var o=function(e,r,n,i){this[0]=t(e,0),this[1]=t(n,0),this[2]=t(r,0),this[3]=t(i,0)};return o.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3]):void 0},o.fromArray=function(e,n,i){return n=t(n,0),r(i)||(i=new o),i[0]=e[n],i[1]=e[n+1],i[2]=e[n+2],i[3]=e[n+3],i},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new o(e,0,0,e)},o.fromRotation=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=i,t[2]=-i,t[3]=n,t):new o(n,-i,i,n)},o.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,t){return 2*e+t},o.getColumn=function(t,n,i){var o=2*n,a=t[o],s=t[o+1];return r(i)?(i.x=a,i.y=s,i):new e(a,s)},o.setColumn=function(e,t,r,n){n=o.clone(e,n);var i=2*t;return n[i]=r.x,n[i+1]=r.y,n},o.getRow=function(t,n,i){var o=t[n],a=t[n+2];return r(i)?(i.x=o,i.y=a,i):new e(o,a)},o.setRow=function(e,t,r,n){return n=o.clone(e,n),n[t]=r.x,n[t+2]=r.y,n},o.multiply=function(e,t,n){var i=e[0]*t[0]+e[2]*t[1],a=e[0]*t[2]+e[2]*t[3],s=e[1]*t[0]+e[3]*t[1],u=e[1]*t[2]+e[3]*t[3];return r(n)?(n[0]=i,n[1]=s,n[2]=a,n[3]=u,n):new o(i,a,s,u)},o.multiplyByVector=function(t,n,i){var o=t[0]*n.x+t[2]*n.y,a=t[1]*n.x+t[3]*n.y;return r(i)?(i.x=o,i.y=a,i):new e(o,a)},o.multiplyByScalar=function(e,t,n){return r(n)?(n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n):new o(e[0]*t,e[2]*t,e[1]*t,e[3]*t)},o.negate=function(e,t){return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t):new o(-e[0],-e[2],-e[1],-e[3])},o.transpose=function(e,t){var n=e[0],i=e[2],a=e[1],s=e[3];return r(t)?(t[0]=n,t[1]=i,t[2]=a,t[3]=s,t):new o(n,a,i,s)},o.abs=function(e,t){return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t):new o(Math.abs(e[0]),Math.abs(e[2]),Math.abs(e[1]),Math.abs(e[3]))},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n},o.IDENTITY=i(new o(1,0,0,1)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n"+"("+this[1]+", "+this[3]+")"},o}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(t){return t===e.POINTS||t===e.LINES||t===e.LINE_LOOP||t===e.LINE_STRIP||t===e.TRIANGLES||t===e.TRIANGLE_STRIP||t===e.TRIANGLE_FAN}};return e}),define("Core/ExtentOutlineGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./Math","./Matrix2","./PrimitiveType"],function(e,t,r,n,i,o,a,s,u,l,c,f,h,m,y,d){"use strict";function p(e,t){return e<-m.PI_OVER_TWO||e>m.PI_OVER_TWO?!1:t>m.PI||t<-m.PI?!1:!0}function v(e,r,n,i,o){var a=e.radiiSquared;E=S.latitude-e.granYCos*r+n*e.granXSin;var s=z(E),u=L(E),l=a.z*u;C=S.longitude+r*e.granYSin+n*e.granXCos;var c=s*z(C),f=s*L(C),h=a.x*c,m=a.y*f,y=P(h*c+m*f+l*u),d=h/y,p=m/y,v=l/y;t(i)&&(I.x=d+c*i,I.y=p+f*i,I.z=v+u*i),t(o)&&(O.x=d+c*o,O.y=p+f*o,O.z=v+u*o)}function w(e){var t,n=e.extent,i=e.ellipsoid,o=e.size,s=e.height,u=e.width,l=e.surfaceHeight,c=new Float64Array(3*o),f=0,h=0;for(t=0;u>t;t++)v(e,h,t,l),c[f++]=I.x,c[f++]=I.y,c[f++]=I.z;for(t=u-1,h=1;s>h;h++)v(e,h,t,l),c[f++]=I.x,c[f++]=I.y,c[f++]=I.z;for(h=s-1,t=u-2;t>=0;t--)v(e,h,t,l),c[f++]=I.x,c[f++]=I.y,c[f++]=I.z;for(t=0,h=s-2;h>0;h--)v(e,h,t,l),c[f++]=I.x,c[f++]=I.y,c[f++]=I.z;for(var m=2*(c.length/3),y=a.createTypedArray(c.length/3,m),d=0,p=0;p<c.length/3-1;p++)y[d++]=p,y[d++]=p+1;return y[d++]=c.length/3-1,y[d++]=0,{boundingSphere:r.fromExtent3D(n,i,l),positions:c,indices:y}}function g(e,t){var n=e.surfaceHeight,i=Math.min(t,n),o=Math.max(t,n);if(m.equalsEpsilon(i,o,.1))return w(e);var s,u=e.extent,l=e.height,c=e.width,f=3*e.size,h=e.ellipsoid,y=0,d=0,p=new Float64Array(2*f);for(s=0;c>s;s++)v(e,d,s,o,i),p[y+f]=O.x,p[y+f+1]=O.y,p[y+f+2]=O.z,p[y++]=I.x,p[y++]=I.y,p[y++]=I.z;for(s=c-1,d=1;l>d;d++)v(e,d,s,o,i),p[y+f]=O.x,p[y+f+1]=O.y,p[y+f+2]=O.z,p[y++]=I.x,p[y++]=I.y,p[y++]=I.z;for(d=l-1,s=c-2;s>=0;s--)v(e,d,s,o,i),p[y+f]=O.x,p[y+f+1]=O.y,p[y+f+2]=O.z,p[y++]=I.x,p[y++]=I.y,p[y++]=I.z;for(s=0,d=l-2;d>0;d--)v(e,d,s,o,i),p[y+f]=O.x,p[y+f+1]=O.y,p[y+f+2]=O.z,p[y++]=I.x,p[y++]=I.y,p[y++]=I.z;for(var g=2*(p.length/3)+8,E=a.createTypedArray(p.length/3,g),C=p.length/6,b=0,S=0;C-1>S;S++)E[b++]=S,E[b++]=S+1,E[b++]=S+C,E[b++]=S+C+1;E[b++]=C-1,E[b++]=0,E[b++]=C+C-1,E[b++]=C,E[b++]=0,E[b++]=C,E[b++]=c-1,E[b++]=C+c-1,E[b++]=c+l-2,E[b++]=c+l-2+C,E[b++]=2*c+l-3,E[b++]=2*c+l-3+C;var x=r.fromExtent3D(u,h,o,N),M=r.fromExtent3D(u,h,i,R),A=r.union(x,M);return{boundingSphere:A,positions:p,indices:E}}var E,C,b=new n,S=new i,x=new i,M=new n,A=new y,T=new l,I=new n,O=new n,R=new r,N=new r,z=Math.cos,L=Math.sin,P=Math.sqrt,D=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.extent,i=e(r.granularity,m.RADIANS_PER_DEGREE),o=e(r.ellipsoid,u.WGS84),a=e(r.height,0),l=r.rotation;if(!t(n))throw new s("extent is required.");n.validate(),this._extent=n,this._granularity=i,this._ellipsoid=o,this._surfaceHeight=a,this._rotation=l,this._extrudedHeight=r.extrudedHeight,this._workerName="createExtentOutlineGeometry"};return D.createGeometry=function(e){var r=e._extent,i=e._granularity,a=e._ellipsoid,u=e._surfaceHeight,l=e._rotation,m=e._extrudedHeight,v=Math.ceil((r.east-r.west)/i)+1,E=Math.ceil((r.north-r.south)/i)+1,C=(r.east-r.west)/(v-1),I=(r.north-r.south)/(E-1),O=a.getRadiiSquared();r.getNorthwest(S),r.getCenter(x);var R=I,N=C,P=0,D=0;if(t(l)){var F=z(l);R*=F,N*=F;var q=L(l);P=I*q,D=C*q,T.project(S,b),T.project(x,M),n.subtract(b,M,b),y.fromRotation(l,A),y.multiplyByVector(A,b,b),n.add(b,M,b),T.unproject(b,S);var _=S.latitude,B=_+(v-1)*D,U=_-R*(E-1),G=_-R*(E-1)+(v-1)*D,W=Math.max(_,B,U,G),Y=Math.min(_,B,U,G),V=S.longitude,H=V+(v-1)*N,k=V+(E-1)*P,K=V+(E-1)*P+(v-1)*N,j=Math.max(V,H,k,K),X=Math.min(V,H,k,K);if(!(p(W,X)&&p(W,j)&&p(Y,X)&&p(Y,j)))throw new s("Rotated extent is invalid.")}var Z,Q=2*v+2*E-4,J={granYCos:R,granYSin:P,granXCos:N,granXSin:D,radiiSquared:O,ellipsoid:a,extent:r,width:v,height:E,surfaceHeight:u,size:Q};Z=t(m)?g(J,m):w(J);var $=new h({position:new f({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:Z.positions})});return new c({attributes:$,indices:Z.indices,primitiveType:d.LINES,boundingSphere:Z.boundingSphere})},D}),define("Core/Extent",["./freezeObject","./defaultValue","./defined","./Ellipsoid","./Cartographic","./DeveloperError","./Math"],function(e,t,r,n,i,o,a){"use strict";var s=function(e,r,n,i){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(i,0)};s.fromDegrees=function(e,n,i,o,u){return e=a.toRadians(t(e,0)),n=a.toRadians(t(n,0)),i=a.toRadians(t(i,0)),o=a.toRadians(t(o,0)),r(u)?(u.west=e,u.south=n,u.east=i,u.north=o,u):new s(e,n,i,o)},s.fromCartographicArray=function(e,t){if(!r(e))throw new o("cartographics is required.");for(var n=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,l=0,c=e.length;c>l;l++){var f=e[l];n=Math.min(n,f.longitude),i=Math.max(i,f.longitude),a=Math.min(a,f.latitude),u=Math.max(u,f.latitude)}return r(t)?(t.west=n,t.south=a,t.east=i,t.north=u,t):new s(n,a,i,u)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){if("number"!=typeof t)throw new o("epsilon is required and must be a number.");
return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.prototype.validate=function(){var e=this.north;if("number"!=typeof e)throw new o("north is required to be a number.");if(e<-a.PI_OVER_TWO||e>a.PI_OVER_TWO)throw new o("north must be in the interval [-Pi/2, Pi/2].");var t=this.south;if("number"!=typeof t)throw new o("south is required to be a number.");if(t<-a.PI_OVER_TWO||t>a.PI_OVER_TWO)throw new o("south must be in the interval [-Pi/2, Pi/2].");var r=this.west;if("number"!=typeof r)throw new o("west is required to be a number.");if(r<-Math.PI||r>Math.PI)throw new o("west must be in the interval [-Pi, Pi].");var n=this.east;if("number"!=typeof n)throw new o("east is required to be a number.");if(n<-Math.PI||n>Math.PI)throw new o("east must be in the interval [-Pi, Pi].")},s.prototype.getSouthwest=function(e){return r(e)?(e.longitude=this.west,e.latitude=this.south,e.height=0,e):new i(this.west,this.south)},s.prototype.getNorthwest=function(e){return r(e)?(e.longitude=this.west,e.latitude=this.north,e.height=0,e):new i(this.west,this.north)},s.prototype.getNortheast=function(e){return r(e)?(e.longitude=this.east,e.latitude=this.north,e.height=0,e):new i(this.east,this.north)},s.prototype.getSoutheast=function(e){return r(e)?(e.longitude=this.east,e.latitude=this.south,e.height=0,e):new i(this.east,this.south)},s.prototype.getCenter=function(e){return r(e)?(e.longitude=.5*(this.west+this.east),e.latitude=.5*(this.south+this.north),e.height=0,e):new i(.5*(this.west+this.east),.5*(this.south+this.north))},s.prototype.intersectWith=function(e,t){if(!r(e))throw new o("otherExtent is required.");var n=Math.max(this.west,e.west),i=Math.max(this.south,e.south),a=Math.min(this.east,e.east),u=Math.min(this.north,e.north);return r(t)?(t.west=n,t.south=i,t.east=a,t.north=u,t):new s(n,i,a,u)},s.prototype.contains=function(e){if(!r(e))throw new o("cartographic is required.");return e.longitude>=this.west&&e.longitude<=this.east&&e.latitude>=this.south&&e.latitude<=this.north},s.prototype.isEmpty=function(){return this.west>=this.east||this.south>=this.north};var u=new i;return s.prototype.subsample=function(e,i,o){e=t(e,n.WGS84),i=t(i,0),r(o)||(o=[]);var s=0,l=this.north,c=this.south,f=this.east,h=this.west,m=u;m.height=i,m.longitude=h,m.latitude=l,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.longitude=f,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.latitude=c,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.longitude=h,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.latitude=0>l?l:c>0?c:0;for(var y=1;8>y;++y){var d=-Math.PI+y*a.PI_OVER_TWO;d>h&&f>d&&(m.longitude=d,o[s]=e.cartographicToCartesian(m,o[s]),s++)}return 0===m.latitude&&(m.longitude=h,o[s]=e.cartographicToCartesian(m,o[s]),s++,m.longitude=f,o[s]=e.cartographicToCartesian(m,o[s]),s++),o.length=s,o},s.MAX_VALUE=e(new s(-Math.PI,-a.PI_OVER_TWO,Math.PI,a.PI_OVER_TWO)),s}),define("Core/Color",["./defaultValue","./defined","./freezeObject","./DeveloperError","./FeatureDetection","./Math"],function(e,t,r,n,i,o){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+6*(t-e)*(2/3-r):e}var s=function(t,r,n,i){this.red=e(t,1),this.green=e(r,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromBytes=function(t,r,n,i){return t=s.byteToFloat(e(t,255)),r=s.byteToFloat(e(r,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),new s(t,r,n,i)};var u,l,c;i.supportsTypedArrays()&&(u=new ArrayBuffer(4),l=new Uint32Array(u),c=new Uint8Array(u)),s.fromRgba=function(e){return l[0]=e,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(t,r,n,i){t=e(t,0)%1,r=e(r,0),n=e(n,0),i=e(i,1);var o=n,u=n,l=n;if(0!==r){var c;c=.5>n?n*(1+r):n+r-n*r;var f=2*n-c;o=a(f,c,t+1/3),u=a(f,c,t),l=a(f,c,t-1/3)}return new s(o,u,l,i)},s.fromRandom=function(r,i){r=e(r,e.EMPTY_OBJECT);var a=r.red;if(!t(a)){var u=e(r.minimumRed,0),l=e(r.maximumRed,1);if(u>l)throw new n("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(l-u)}var c=r.green;if(!t(c)){var f=e(r.minimumGreen,0),h=e(r.maximumGreen,1);if(f>h)throw new n("minimumGreen must be less than or equal to maximumGreen");c=f+o.nextRandomNumber()*(h-f)}var m=r.blue;if(!t(m)){var y=e(r.minimumBlue,0),d=e(r.maximumBlue,1);if(y>d)throw new n("minimumBlue must be less than or equal to maximumBlue");m=y+o.nextRandomNumber()*(d-y)}var p=r.alpha;if(!t(p)){var v=e(r.minimumAlpha,0),w=e(r.maximumAlpha,1);if(v>w)throw new n("minimumAlpha must be less than or equal to maximumAlpha");p=v+o.nextRandomNumber()*(w-v)}return t(i)?(i.red=a,i.green=c,i.blue=m,i.alpha=p,i):new s(a,c,m,p)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,m=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,y=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){if(!t(r))throw new n("color is required");var i=s[r.toUpperCase()];if(t(i))return s.clone(i);var o=f.exec(r);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=h.exec(r),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=m.exec(r),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=y.exec(r),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(r,i,o){if(!t(r))throw new n("value is required");if(!t(i))throw new n("array is required");o=e(o,0),i[o++]=r.red,i[o++]=r.green,i[o++]=r.blue,i[o]=r.alpha},s.unpack=function(r,i,o){if(!t(r))throw new n("array is required");return i=e(i,0),t(o)||(o=new s),o.red=r[i++],o.green=r[i++],o.blue=r[i++],o.alpha=r[i],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var r=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=n,e[2]=i,e[3]=o,e):[r,n,i,o]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),l[0]},s.ALICEBLUE=r(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=r(s.fromCssColorString("#FAEBD7")),s.AQUA=r(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=r(s.fromCssColorString("#7FFFD4")),s.AZURE=r(s.fromCssColorString("#F0FFFF")),s.BEIGE=r(s.fromCssColorString("#F5F5DC")),s.BISQUE=r(s.fromCssColorString("#FFE4C4")),s.BLACK=r(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=r(s.fromCssColorString("#FFEBCD")),s.BLUE=r(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=r(s.fromCssColorString("#8A2BE2")),s.BROWN=r(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=r(s.fromCssColorString("#DEB887")),s.CADETBLUE=r(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=r(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=r(s.fromCssColorString("#D2691E")),s.CORAL=r(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=r(s.fromCssColorString("#6495ED")),s.CORNSILK=r(s.fromCssColorString("#FFF8DC")),s.CRIMSON=r(s.fromCssColorString("#DC143C")),s.CYAN=r(s.fromCssColorString("#00FFFF")),s.DARKBLUE=r(s.fromCssColorString("#00008B")),s.DARKCYAN=r(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=r(s.fromCssColorString("#B8860B")),s.DARKGRAY=r(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=r(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=r(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=r(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=r(s.fromCssColorString("#556B2F")),s.DARKORANGE=r(s.fromCssColorString("#FF8C00")),s.DARKORCHID=r(s.fromCssColorString("#9932CC")),s.DARKRED=r(s.fromCssColorString("#8B0000")),s.DARKSALMON=r(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=r(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=r(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=r(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=r(s.fromCssColorString("#00CED1")),s.DARKVIOLET=r(s.fromCssColorString("#9400D3")),s.DEEPPINK=r(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=r(s.fromCssColorString("#00BFFF")),s.DIMGRAY=r(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=r(s.fromCssColorString("#1E90FF")),s.FIREBRICK=r(s.fromCssColorString("#B22222")),s.FLORALWHITE=r(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=r(s.fromCssColorString("#228B22")),s.FUSCHIA=r(s.fromCssColorString("#FF00FF")),s.GAINSBORO=r(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=r(s.fromCssColorString("#F8F8FF")),s.GOLD=r(s.fromCssColorString("#FFD700")),s.GOLDENROD=r(s.fromCssColorString("#DAA520")),s.GRAY=r(s.fromCssColorString("#808080")),s.GREEN=r(s.fromCssColorString("#008000")),s.GREENYELLOW=r(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=r(s.fromCssColorString("#F0FFF0")),s.HOTPINK=r(s.fromCssColorString("#FF69B4")),s.INDIANRED=r(s.fromCssColorString("#CD5C5C")),s.INDIGO=r(s.fromCssColorString("#4B0082")),s.IVORY=r(s.fromCssColorString("#FFFFF0")),s.KHAKI=r(s.fromCssColorString("#F0E68C")),s.LAVENDER=r(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=r(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=r(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=r(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=r(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=r(s.fromCssColorString("#F08080")),s.LIGHTCYAN=r(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=r(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=r(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=r(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=r(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=r(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=r(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=r(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=r(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=r(s.fromCssColorString("#FFFFE0")),s.LIME=r(s.fromCssColorString("#00FF00")),s.LIMEGREEN=r(s.fromCssColorString("#32CD32")),s.LINEN=r(s.fromCssColorString("#FAF0E6")),s.MAGENTA=r(s.fromCssColorString("#FF00FF")),s.MAROON=r(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=r(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=r(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=r(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=r(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=r(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=r(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=r(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=r(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=r(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=r(s.fromCssColorString("#191970")),s.MINTCREAM=r(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=r(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=r(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=r(s.fromCssColorString("#FFDEAD")),s.NAVY=r(s.fromCssColorString("#000080")),s.OLDLACE=r(s.fromCssColorString("#FDF5E6")),s.OLIVE=r(s.fromCssColorString("#808000")),s.OLIVEDRAB=r(s.fromCssColorString("#6B8E23")),s.ORANGE=r(s.fromCssColorString("#FFA500")),s.ORANGERED=r(s.fromCssColorString("#FF4500")),s.ORCHID=r(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=r(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=r(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=r(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=r(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=r(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=r(s.fromCssColorString("#FFDAB9")),s.PERU=r(s.fromCssColorString("#CD853F")),s.PINK=r(s.fromCssColorString("#FFC0CB")),s.PLUM=r(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=r(s.fromCssColorString("#B0E0E6")),s.PURPLE=r(s.fromCssColorString("#800080")),s.RED=r(s.fromCssColorString("#FF0000")),s.ROSYBROWN=r(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=r(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=r(s.fromCssColorString("#8B4513")),s.SALMON=r(s.fromCssColorString("#FA8072")),s.SANDYBROWN=r(s.fromCssColorString("#F4A460")),s.SEAGREEN=r(s.fromCssColorString("#2E8B57")),s.SEASHELL=r(s.fromCssColorString("#FFF5EE")),s.SIENNA=r(s.fromCssColorString("#A0522D")),s.SILVER=r(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=r(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=r(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=r(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=r(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=r(s.fromCssColorString("#00FF7F")),s.STEELBLUE=r(s.fromCssColorString("#4682B4")),s.TAN=r(s.fromCssColorString("#D2B48C")),s.TEAL=r(s.fromCssColorString("#008080")),s.THISTLE=r(s.fromCssColorString("#D8BFD8")),s.TOMATO=r(s.fromCssColorString("#FF6347")),s.TURQUOISE=r(s.fromCssColorString("#40E0D0")),s.VIOLET=r(s.fromCssColorString("#EE82EE")),s.WHEAT=r(s.fromCssColorString("#F5DEB3")),s.WHITE=r(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=r(s.fromCssColorString("#F5F5F5")),s.YELLOW=r(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=r(s.fromCssColorString("#9ACD32")),s}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i=new t,o=new t,a=new t,s=function(s,u,l,c,f){if(!(r(s)&&r(u)&&r(l)&&r(c)))throw new n("point, p0, p1, and p2 are required.");r(f)||(f=new t);var h,m,y,d,p,v,w,g;r(u.z)?(h=t.subtract(l,u,i),m=t.subtract(c,u,o),y=t.subtract(s,u,a),d=t.dot(h,h),p=t.dot(h,m),v=t.dot(h,y),w=t.dot(m,m),g=t.dot(m,y)):(h=e.subtract(l,u,i),m=e.subtract(c,u,o),y=e.subtract(s,u,a),d=e.dot(h,h),p=e.dot(h,m),v=e.dot(h,y),w=e.dot(m,m),g=e.dot(m,y));var E=1/(d*w-p*p);return f.y=(w*v-p*g)*E,f.z=(d*g-p*v)*E,f.x=1-f.y-f.z,f};return s}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!t(e))throw new r("value is required");t(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){if(!t(e))throw new r("cartesian is required");t(o)||(o=new n);var a=o.high,s=o.low;return n.encode(e.x,i),a.x=i.high,s.x=i.low,n.encode(e.y,i),a.y=i.high,s.y=i.low,n.encode(e.z,i),a.z=i.high,s.z=i.low,o};var o=new n;return n.writeElements=function(e,i,a){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("cartesianArray is required");if("number"!=typeof a||0>a)throw new r("index must be a number greater than or equal to 0.");n.fromCartesian(e,o);var s=o.high,u=o.low;i[a]=s.x,i[a+1]=s.y,i[a+2]=s.z,i[a+3]=u.x,i[a+4]=u.y,i[a+5]=u.z},n}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.discriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.realRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var s=Math.abs(o),u=Math.abs(n);if(u>s&&s/u<t.EPSILON14)return[0,0];if(s>u&&u/s<t.EPSILON14)return[];if(a=-o/n,0>a)return[];var l=Math.sqrt(a);return[-l,l]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var c=i*i,f=4*n*o,h=r(c,-f,t.EPSILON14);if(0>h)return[];var m=-.5*r(i,t.sign(i)*Math.sqrt(h),t.EPSILON14);return i>0?[m/n,o/m]:[o/m,m/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,o,a=e,s=t/3,u=r/3,l=n,c=a*u,f=s*l,h=s*s,m=u*u,y=a*u-h,d=a*l-s*u,p=s*l-m,v=4*y*p-d*d;if(0>v){var w,g,E;h*f>=c*m?(w=a,g=y,E=-2*s*y+a*d):(w=l,g=p,E=-l*d+2*u*p);var C=0>E?-1:1,b=-C*Math.abs(w)*Math.sqrt(-v);o=-E+b;var S=o/2,x=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),M=o===b?-x:-g/x;return i=0>=g?x+M:-E/(x*x+M*M+g),h*f>=c*m?[(i-s)/a]:[-l/(i+u)]}var A=y,T=-2*s*y+a*d,I=p,O=-l*d+2*u*p,R=Math.sqrt(v),N=Math.sqrt(3)/2,z=Math.abs(Math.atan2(a*R,-T)/3);i=2*Math.sqrt(-A);var L=Math.cos(z);o=i*L;var P=i*(-L/2-N*Math.sin(z)),D=o+P>2*s?o-s:P-s,F=a,q=D/F;z=Math.abs(Math.atan2(l*R,-O)/3),i=2*Math.sqrt(-I),L=Math.cos(z),o=i*L,P=i*(-L/2-N*Math.sin(z));var _=-l,B=2*u>o+P?o+u:P+u,U=_/B,G=F*B,W=-D*B-F*_,Y=D*_,V=(u*W-s*Y)/(-s*W+u*G);return V>=q?U>=q?U>=V?[q,V,U]:[q,U,V]:[U,q,V]:U>=q?[V,q,U]:U>=V?[V,U,q]:[U,V,q]}var n={};return n.discriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=t*t,a=r*r,s=n*n,u=i*i,l=18*t*r*n*i+a*s-27*o*u-4*(t*s*n+a*r*i);return l},n.realRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===n)return t.realRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];u=-a/n;var l=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[l,l,l]}return 0===a?(s=t.realRoots(n,0,o),0===s.Length?[0]:[s[0],0,s[1]]):r(n,0,o,a)}return 0===o?0===a?(u=-i/n,0>u?[u,0,0]:[0,0,u]):r(n,i,0,a):0===a?(s=t.realRoots(n,i,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):r(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./DeveloperError","./Math","./CubicRealPolynomial","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(e,i,o,a){var s=e*e,u=i-3*s/8,l=o-i*e/2+s*e/8,c=a-o*e/4+i*s/16-3*s*s/256,f=r.realRoots(1,2*u,u*u-4*c,-l*l);if(f.length>0){var h=-e/4,m=f[f.length-1];if(Math.abs(m)<t.EPSILON14){var y=n.realRoots(1,u,c);if(2===y.length){var d,p=y[0],v=y[1];if(p>=0&&v>=0){var w=Math.sqrt(p),g=Math.sqrt(v);return[h-g,h-w,h+w,h+g]}if(p>=0&&0>v)return d=Math.sqrt(p),[h-d,h+d];if(0>p&&v>=0)return d=Math.sqrt(v),[h-d,h+d]}return[]}if(m>0){var E=Math.sqrt(m),C=(u+m-l/E)/2,b=(u+m+l/E)/2,S=n.realRoots(1,E,C),x=n.realRoots(1,-E,b);return 0!==S.length?(S[0]+=h,S[1]+=h,0!==x.length?(x[0]+=h,x[1]+=h,S[1]<=x[0]?[S[0],S[1],x[0],x[1]]:x[1]<=S[0]?[x[0],x[1],S[0],S[1]]:S[0]>=x[0]&&S[1]<=x[1]?[x[0],S[0],S[1],x[1]]:x[0]>=S[0]&&x[1]<=S[1]?[S[0],x[0],x[1],S[1]]:S[0]>x[0]&&S[0]<x[1]?[x[0],S[0],x[1],S[1]]:[S[0],x[0],S[1],x[1]]):S):0!==x.length?(x[0]+=h,x[1]+=h,x):[]}}return[]}function o(e,i,o,a){var s=o*o,u=i*i,l=e*e,c=-2*i,f=o*e+u-4*a,h=l*a-o*i*e+s,m=r.realRoots(1,c,f,h);if(m.length>0){var y,d,p=m[0],v=i-p,w=v*v,g=e/2,E=v/2,C=w-4*a,b=w+4*Math.abs(a),S=l-4*p,x=l+4*Math.abs(p);if(0>p||S*b>C*x){var M=Math.sqrt(S);y=M/2,d=0===M?0:(e*E-o)/M}else{var A=Math.sqrt(C);y=0===A?0:(e*E-o)/A,d=A/2}var T,I;0===g&&0===y?(T=0,I=0):t.sign(g)===t.sign(y)?(T=g+y,I=p/T):(I=g-y,T=p/I);var O,R;0===E&&0===d?(O=0,R=0):t.sign(E)===t.sign(d)?(O=E+d,R=a/O):(R=E-d,O=a/R);var N=n.realRoots(1,T,O),z=n.realRoots(1,I,R);if(0!==N.length)return 0!==z.length?N[1]<=z[0]?[N[0],N[1],z[0],z[1]]:z[1]<=N[0]?[z[0],z[1],N[0],N[1]]:N[0]>=z[0]&&N[1]<=z[1]?[z[0],N[0],N[1],z[1]]:z[0]>=N[0]&&z[1]<=N[1]?[N[0],z[0],z[1],N[1]]:N[0]>z[0]&&N[0]<z[1]?[z[0],N[0],z[1],N[1]]:[N[0],z[0],N[1],z[1]]:N;if(0!==z.length)return z}return[]}var a={};return a.discriminant=function(t,r,n,i,o){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");if("number"!=typeof o)throw new e("e is a required number.");var a=t*t,s=a*t,u=r*r,l=u*r,c=n*n,f=c*n,h=i*i,m=h*i,y=o*o,d=y*o,p=u*c*h-4*l*m-4*t*f*h+18*t*r*n*m-27*a*h*h+256*s*d+o*(18*l*n*i-4*u*f+16*t*c*c-80*t*r*c*i-6*t*u*h+144*a*n*h)+y*(144*t*u*n-27*u*u-128*a*c-192*a*r*i);return p},a.realRoots=function(n,a,s,u,l){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof a)throw new e("b is a required number.");if("number"!=typeof s)throw new e("c is a required number.");if("number"!=typeof u)throw new e("d is a required number.");if("number"!=typeof l)throw new e("e is a required number.");if(Math.abs(n)<t.EPSILON15)return r.realRoots(a,s,u,l);var c=a/n,f=s/n,h=u/n,m=l/n,y=0>c?1:0;switch(y+=0>f?y+1:y,y+=0>h?y+1:y,y+=0>m?y+1:y){case 0:return i(c,f,h,m);case 1:return o(c,f,h,m);case 2:return o(c,f,h,m);case 3:return i(c,f,h,m);case 4:return i(c,f,h,m);case 5:return o(c,f,h,m);case 6:return i(c,f,h,m);case 7:return i(c,f,h,m);case 8:return o(c,f,h,m);case 9:return i(c,f,h,m);case 10:return i(c,f,h,m);case 11:return o(c,f,h,m);case 12:return i(c,f,h,m);case 13:return i(c,f,h,m);case 14:return i(c,f,h,m);case 15:return i(c,f,h,m);default:return void 0}},a}),define("Core/IntersectionTests",["./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,t,r,n,i,o,a,s){"use strict";function u(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}function l(e,t,i,l,c){var f,h=l*l,m=c*c,y=(e[o.COLUMN1ROW1]-e[o.COLUMN2ROW2])*m,d=c*(l*u(e[o.COLUMN1ROW0],e[o.COLUMN0ROW1],r.EPSILON15)+t.y),p=e[o.COLUMN0ROW0]*h+e[o.COLUMN2ROW2]*m+l*t.x+i,v=m*u(e[o.COLUMN2ROW1],e[o.COLUMN1ROW2],r.EPSILON15),w=c*(l*u(e[o.COLUMN2ROW0],e[o.COLUMN0ROW2])+t.z),g=[];if(0===w&&0===v){if(f=a.realRoots(y,d,p),0===f.length)return g;var E=f[0],C=Math.sqrt(Math.max(1-E*E,0));if(g.push(new n(l,c*E,c*-C)),g.push(new n(l,c*E,c*C)),2===f.length){var b=f[1],S=Math.sqrt(Math.max(1-b*b,0));g.push(new n(l,c*b,c*-S)),g.push(new n(l,c*b,c*S))}return g}var x=w*w,M=v*v,A=y*y,T=w*v,I=A+M,O=2*(d*y+T),R=2*p*y+d*d-M+x,N=2*(p*d-T),z=p*p-x;if(0===I&&0===O&&0===R&&0===N)return g;f=s.realRoots(I,O,R,N,z);var L=f.length;if(0===L)return g;for(var P=0;L>P;++P){var D,F=f[P],q=F*F,_=Math.max(1-q,0),B=Math.sqrt(_);D=r.sign(y)===r.sign(p)?u(y*q+p,d*F,r.EPSILON12):r.sign(p)===r.sign(d*F)?u(y*q,d*F+p,r.EPSILON12):u(y*q+d*F,p,r.EPSILON12);var U=u(v*F,w,r.EPSILON15),G=D*U;0>G?g.push(new n(l,c*F,c*B)):G>0?g.push(new n(l,c*F,c*-B)):0!==B?(g.push(new n(l,c*F,c*-B)),g.push(new n(l,c*F,c*B)),++P):g.push(new n(l,c*F,c*B))}return g}var c={};c.rayPlane=function(i,o,a){if(!e(i))throw new t("ray is required.");if(!e(o))throw new t("plane is required.");var s=i.origin,u=i.direction,l=o.normal,c=n.dot(l,u);if(Math.abs(c)<r.EPSILON15)return void 0;var f=(-o.distance-n.dot(l,s))/c;return 0>f?void 0:(a=n.multiplyByScalar(u,f,a),n.add(s,a,a))};var f=new n,h=new n;c.rayEllipsoid=function(r,i){if(!e(r))throw new t("ray is required.");if(!e(i))throw new t("ellipsoid is required.");var o,a,s,u,l,c=i.getOneOverRadii(),m=n.multiplyComponents(c,r.origin,f),y=n.multiplyComponents(c,r.direction,h),d=n.magnitudeSquared(m),p=n.dot(m,y);if(d>1){if(p>=0)return void 0;var v=p*p;if(o=d-1,a=n.magnitudeSquared(y),s=a*o,s>v)return void 0;if(v>s){u=p*p-s,l=-p+Math.sqrt(u);var w=l/a,g=o/l;return g>w?{start:w,stop:g}:{start:g,stop:w}}var E=Math.sqrt(o/a);return{start:E,stop:E}}return 1>d?(o=d-1,a=n.magnitudeSquared(y),s=a*o,u=p*p-s,l=-p+Math.sqrt(u),{start:0,stop:l/a}):0>p?(a=n.magnitudeSquared(y),{start:0,stop:-p/a}):void 0},c.grazingAltitudeLocation=function(a,s){if(!e(a))throw new t("ray is required.");if(!e(s))throw new t("ellipsoid is required.");var u=a.origin,c=a.direction,f=s.geodeticSurfaceNormal(u);if(n.dot(c,f)>=0)return u;var h,m,y=e(this.rayEllipsoid(a,s)),d=s.transformPositionToScaledSpace(c),p=n.normalize(d),v=n.mostOrthogonalAxis(d),w=n.normalize(n.cross(v,p)),g=n.normalize(n.cross(p,w)),E=new o(p.x,w.x,g.x,p.y,w.y,g.y,p.z,w.z,g.z),C=o.transpose(E),b=o.fromScale(s.getRadii()),S=o.fromScale(s.getOneOverRadii()),x=new o(0,c.z,-c.y,-c.z,0,c.x,c.y,-c.x,0),M=o.multiply(o.multiply(C,S),x),A=o.multiply(o.multiply(M,b),E),T=o.multiplyByVector(M,u),I=l(A,n.negate(T),0,0,1),O=I.length;if(O>0){for(var R=n.ZERO,N=Number.NEGATIVE_INFINITY,z=0;O>z;++z){h=o.multiplyByVector(b,o.multiplyByVector(E,I[z]));var L=n.normalize(n.subtract(h,u)),P=n.dot(L,c);P>N&&(N=P,R=h)}var D=s.cartesianToCartographic(R);return N=r.clamp(N,0,1),m=n.magnitude(n.subtract(R,u))*Math.sqrt(1-N*N),m=y?-m:m,s.cartographicToCartesian(new i(D.longitude,D.latitude,m))}return void 0};var m=new n;return c.lineSegmentPlane=function(i,o,a,s){if(!e(i))throw new t("endPoint0 is required.");if(!e(o))throw new t("endPoint1 is required.");if(!e(a))throw new t("plane is required.");var u=n.subtract(o,i,m),l=a.normal,c=n.dot(l,u);if(Math.abs(c)<r.EPSILON6)return void 0;var f=n.dot(l,i),h=-(a.distance+f)/c;return 0>h||h>1?void 0:(e(s)||(s=new n),n.multiplyByScalar(u,h,s),n.add(i,s,s),s)},c.trianglePlaneIntersection=function(r,i,o,a){if(!(e(r)&&e(i)&&e(o)&&e(a)))throw new t("p0, p1, p2, and plane are required.");var s=a.normal,u=a.distance,l=n.dot(s,r)+u<0,f=n.dot(s,i)+u<0,h=n.dot(s,o)+u<0,m=0;m+=l?1:0,m+=f?1:0,m+=h?1:0;var y,d;if((1===m||2===m)&&(y=new n,d=new n),1===m){if(l)return c.lineSegmentPlane(r,i,a,y),c.lineSegmentPlane(r,o,a,d),{positions:[r,i,o,y,d],indices:[0,3,4,1,2,4,1,4,3]};if(f)return c.lineSegmentPlane(i,o,a,y),c.lineSegmentPlane(i,r,a,d),{positions:[r,i,o,y,d],indices:[1,3,4,2,0,4,2,4,3]};if(h)return c.lineSegmentPlane(o,r,a,y),c.lineSegmentPlane(o,i,a,d),{positions:[r,i,o,y,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===m){if(!l)return c.lineSegmentPlane(i,r,a,y),c.lineSegmentPlane(o,r,a,d),{positions:[r,i,o,y,d],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return c.lineSegmentPlane(o,i,a,y),c.lineSegmentPlane(r,i,a,d),{positions:[r,i,o,y,d],indices:[2,0,4,2,4,3,1,3,4]};if(!h)return c.lineSegmentPlane(r,o,a,y),c.lineSegmentPlane(i,o,a,d),{positions:[r,i,o,y,d],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n,i){if(!t(n))throw new r("normal is required.");if(!t(i))throw new r("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,o,a){if(!t(i))throw new r("point is required.");if(!t(o))throw new r("normal is required.");var s=-e.dot(o,i);return t(a)?(e.clone(o,a.normal),a.distance=s,a):new n(o,s)},n.getPointDistance=function(n,i){if(!t(n))throw new r("plane is required.");if(!t(i))throw new r("point is required.");return e.dot(n.normal,i)+n.distance},n.prototype.getPointDistance=function(e){return n.getPointDistance(this,e)},n}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var s=i.length;if(3>s||0!==s%3)throw new r("indices length must be a multiple of three.");if(0>=o)throw new r("maximumIndex must be greater than zero.");if(3>a)throw new r("cacheSize must be greater than two.");if(!t(o)){o=0;for(var u=0,l=i[u];s>u;)l>o&&(o=l),++u,l=i[u]}for(var c=[],f=0;o+1>f;f++)c[f]=0;for(var h=a+1,m=0;s>m;++m)h-c[i[m]]>a&&(c[i[m]]=h,++h);return(h-a+1)/(s/3)},n.tipsify=function(n){function i(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,t,r,n,o,a,s){for(var u,l=-1,c=-1,f=0;f<r.length;){var h=r[f];n[h].numLiveTriangles&&(u=0,o-n[h].timeStamp+2*n[h].numLiveTriangles<=t&&(u=o-n[h].timeStamp),(u>c||-1===c)&&(c=u,l=h)),++f}return-1===l?i(n,a,e,s):l}n=e(n,e.EMPTY_OBJECT);var a,s=n.indices,u=n.maximumIndex,l=e(n.cacheSize,24);if(!t(s))throw new r("indices is required.");var c=s.length;if(3>c||0!==c%3)throw new r("indices length must be a multiple of three.");if(0>=u)throw new r("maximumIndex must be greater than zero.");if(3>l)throw new r("cacheSize must be greater than two.");var f=0,h=0,m=s[h],y=c;if(t(u))f=u+1;else{for(;y>h;)m>f&&(f=m),++h,m=s[h];if(-1===f)return 0;++f}for(var d=[],p=0;f>p;p++)d[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var v=0;y>h;)d[s[h]].vertexTriangles.push(v),++d[s[h]].numLiveTriangles,d[s[h+1]].vertexTriangles.push(v),++d[s[h+1]].numLiveTriangles,d[s[h+2]].vertexTriangles.push(v),++d[s[h+2]].numLiveTriangles,++v,h+=3;var w=0,g=l+1;a=1;var E,C,b=[],S=[],x=0,M=[],A=c/3,T=[];for(p=0;A>p;p++)T[p]=!1;for(var I,O;-1!==w;){b=[],C=d[w],O=C.vertexTriangles.length;for(var R=0;O>R;++R)if(v=C.vertexTriangles[R],!T[v]){T[v]=!0,h=v+v+v;for(var N=0;3>N;++N)I=s[h],b.push(I),S.push(I),M[x]=I,++x,E=d[I],--E.numLiveTriangles,g-E.timeStamp>l&&(E.timeStamp=g,++g),++h}w=o(s,l,b,d,g,S,f)}return M},n}),define("Core/GeometryPipeline",["./barycentricCoordinates","./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./EncodedCartesian3","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./GeographicProjection","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./Tipsify","./BoundingSphere","./Geometry","./GeometryAttribute"],function(e,t,r,n,i,o,a,s,u,l,c,f,h,m,y,d,p,v,w,g,E,C,b){"use strict";function S(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function x(e){for(var t=e.length,r=6*(t/3),n=v.createTypedArray(t,r),i=0,o=0;t>o;o+=3,i+=6)S(n,i,e[o],e[o+1],e[o+2]);return n}function M(e){var t=e.length;if(t>=3){var r=6*(t-2),n=v.createTypedArray(t,r);S(n,0,e[0],e[1],e[2]);for(var i=6,o=3;t>o;++o,i+=6)S(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function A(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=v.createTypedArray(t,r),i=e[0],o=0,a=1;t>a;++a,o+=6)S(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}function T(e){var t={};for(var n in e)if(e.hasOwnProperty(n)&&r(e[n])&&r(e[n].values)){var i=e[n];t[n]=new b({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function I(e,t,n){for(var i in t)if(t.hasOwnProperty(i)&&r(t[i])&&r(t[i].values))for(var o=t[i],a=0;a<o.componentsPerAttribute;++a)e[i].values.push(o.values[n*o.componentsPerAttribute+a])}function O(e,t){if(r(t))for(var n=t.values,i=n.length,a=0;i>a;a+=3)o.unpack(n,a,X),m.multiplyByPoint(e,X,X),o.pack(X,n,a)}function R(e,t){if(r(t))for(var n=t.values,i=n.length,a=0;i>a;a+=3)o.unpack(n,a,X),h.multiplyByVector(e,X,X),X=o.normalize(X,X),o.pack(X,n,a)}function N(e){var t,n=e.length,i={},o=e[0].geometry.attributes;for(t in o)if(o.hasOwnProperty(t)&&r(o[t])&&r(o[t].values)){for(var a=o[t],s=a.values.length,u=!0,l=1;n>l;++l){var c=e[l].geometry.attributes[t];if(!r(c)||a.componentDatatype.value!==c.componentDatatype.value||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){u=!1;break}s+=c.values.length}u&&(i[t]=new b({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:p.createTypedArray(a.componentDatatype,s)}))
}return i}function z(e){if(r(e.indices))return e;var t=C.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least three.");if(0!==t%3)throw new n("The number of vertices must be a multiple of three.");for(var i=v.createTypedArray(t,t),o=0;t>o;++o)i[o]=o;return e.indices=i,e}function L(e){var t=C.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least three.");var r=v.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var i=3,o=3;t>o;++o)r[i++]=o-1,r[i++]=0,r[i++]=o;return e.indices=r,e.primitiveType=w.TRIANGLES,e}function P(e){var t=C.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least 3.");var r=v.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var i=6,o=3;t-1>o;o+=2)r[i++]=o,r[i++]=o-1,r[i++]=o+1,t>o+2&&(r[i++]=o,r[i++]=o+1,r[i++]=o+2);return e.indices=r,e.primitiveType=w.TRIANGLES,e}function D(e){if(r(e.indices))return e;var t=C.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");if(0!==t%2)throw new n("The number of vertices must be a multiple of 2.");for(var i=v.createTypedArray(t,t),o=0;t>o;++o)i[o]=o;return e.indices=i,e}function F(e){var t=C.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");var r=v.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var i=2,o=2;t>o;++o)r[i++]=o-1,r[i++]=o;return e.indices=r,e.primitiveType=w.LINES,e}function q(e){var t=C.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");var r=v.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var i=2,o=2;t>o;++o)r[i++]=o-1,r[i++]=o;return r[i++]=t-1,r[i]=0,e.indices=r,e.primitiveType=w.LINES,e}function _(e){switch(e.primitiveType){case w.TRIANGLE_FAN:return L(e);case w.TRIANGLE_STRIP:return P(e);case w.TRIANGLES:return z(e);case w.LINE_STRIP:return F(e);case w.LINE_LOOP:return q(e);case w.LINES:return D(e)}return e}function B(e,t){Math.abs(e.y)<f.EPSILON11&&(e.y=t?-f.EPSILON11:f.EPSILON11)}function U(e,t,r,n){o.add(e,o.multiplyByScalar(o.subtract(t,e,ot),e.y/(e.y-t.y),ot),r),o.clone(r,n),B(r,!0),B(n,!1)}function G(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;var n=e.y<0,i=t.y<0,o=r.y<0;B(e,n),B(t,i),B(r,o);var a=0;a+=n?1:0,a+=i?1:0,a+=o?1:0;var s=ct.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(U(e,t,at,ut),U(e,r,st,lt),s[0]=0,s[3]=1,s[4]=2,s[6]=1):i?(U(t,r,at,ut),U(t,e,st,lt),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(U(r,e,at,ut),U(r,t,st,lt),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?i?o||(U(r,e,at,ut),U(r,t,st,lt),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(U(t,r,at,ut),U(t,e,st,lt),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(U(e,t,at,ut),U(e,r,st,lt),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=ct.positions;return u[0]=e,u[1]=t,u[2]=r,ct.length=3,(1===a||2===a)&&(u[3]=at,u[4]=st,u[5]=ut,u[6]=lt,ct.length=7),ct}function W(t,n,a,s,u,l,c,f){if(r(u)||r(l)||r(c)||r(f)){var h,m,y,d,p,v,w,g,E,C,b,S,x,M,A,T,I,O,R=s.positions,N=R[0],z=R[1],L=R[2];r(u)&&(h=o.fromArray(u,3*t),m=o.fromArray(u,3*n),y=o.fromArray(u,3*a)),r(l)&&(d=o.fromArray(l,3*t),p=o.fromArray(l,3*n),v=o.fromArray(l,3*a)),r(c)&&(w=o.fromArray(c,3*t),g=o.fromArray(c,3*n),E=o.fromArray(c,3*a)),r(f)&&(C=i.fromArray(f,2*t),b=i.fromArray(f,2*n),S=i.fromArray(f,2*a));for(var P=3;P<R.length;++P){var D=R[P],F=e(D,N,z,L);if(r(u)){x=o.multiplyByScalar(h,F.x,x),M=o.multiplyByScalar(m,F.y,M),A=o.multiplyByScalar(y,F.z,A);var q=o.add(x,M);o.add(q,A,q),o.normalize(q,q),u.push(q.x,q.y,q.z)}if(r(l)){x=o.multiplyByScalar(d,F.x,x),M=o.multiplyByScalar(p,F.y,M),A=o.multiplyByScalar(v,F.z,A);var _=o.add(x,M);o.add(_,A,_),o.normalize(_,_),l.push(_.x,_.y,_.z)}if(r(c)){x=o.multiplyByScalar(w,F.x,x),M=o.multiplyByScalar(g,F.y,M),A=o.multiplyByScalar(E,F.z,A);var B=o.add(x,M);o.add(B,A,B),o.normalize(B,B),c.push(B.x,B.y,B.z)}if(r(f)){T=i.multiplyByScalar(C,F.x,T),I=i.multiplyByScalar(b,F.y,I),O=i.multiplyByScalar(S,F.z,O);var U=i.add(T,I);i.add(U,O,U),f.push(U.x,U.y)}}}}function Y(e){for(var t=e.attributes,n=t.position.values,i=r(t.normal)?t.normal.values:void 0,a=r(t.binormal)?t.binormal.values:void 0,s=r(t.tangent)?t.tangent.values:void 0,u=r(t.st)?t.st.values:void 0,l=e.indices,c=Array.prototype.slice.call(n,0),f=r(i)?Array.prototype.slice.call(i,0):void 0,h=r(a)?Array.prototype.slice.call(a,0):void 0,m=r(s)?Array.prototype.slice.call(s,0):void 0,y=r(u)?Array.prototype.slice.call(u,0):void 0,d=[],w=l.length,g=0;w>g;g+=3){var E=l[g],b=l[g+1],S=l[g+2],x=o.fromArray(n,3*E),M=o.fromArray(n,3*b),A=o.fromArray(n,3*S),T=G(x,M,A);if(r(T))if(c[3*E+1]=T.positions[0].y,c[3*b+1]=T.positions[1].y,c[3*S+1]=T.positions[2].y,T.length>3){for(var I=c.length/3,O=0;O<T.indices.length;++O){var R=T.indices[O];3>R?d.push(l[g+R]):d.push(R-3+I)}for(var N=3;N<T.positions.length;++N){var z=T.positions[N];c.push(z.x,z.y,z.z)}W(E,b,S,T,f,h,m,y)}else d.push(E,b,S);else d.push(E,b,S)}e.attributes.position.values=new Float64Array(c),r(f)&&(t.normal.values=p.createTypedArray(t.normal.componentDatatype,f)),r(h)&&(t.binormal.values=p.createTypedArray(t.binormal.componentDatatype,h)),r(m)&&(t.tangent.values=p.createTypedArray(t.tangent.componentDatatype,m)),r(y)&&(t.st.values=p.createTypedArray(t.st.componentDatatype,y));var L=C.computeNumberOfVertices(e);e.indices=v.createTypedArray(L,d)}function V(e){for(var t=e.attributes,n=t.position.values,i=e.indices,a=Array.prototype.slice.call(n,0),s=[],u=y.fromPointNormal(o.ZERO,o.UNIT_Y),l=i.length,h=0;l>h;h+=2){var m=i[h],d=i[h+1],p=o.fromArray(n,3*m),w=o.fromArray(n,3*d);if(Math.abs(p.y)<f.EPSILON6&&(p.y=p.y<0?-f.EPSILON6:f.EPSILON6,a[3*m+1]=p.y),Math.abs(w.y)<f.EPSILON6&&(w.y=w.y<0?-f.EPSILON6:f.EPSILON6,a[3*d+1]=w.y),s.push(m),p.x<0||w.x<0){var g=c.lineSegmentPlane(p,w,u);if(r(g)){var E=o.multiplyByScalar(o.UNIT_Y,5*f.EPSILON9);p.y<0&&o.negate(E,E);var b=a.length/3;s.push(b,b+1);var S=o.add(g,E);a.push(S.x,S.y,S.z),o.negate(E,E),o.add(g,E,S),a.push(S.x,S.y,S.z)}}s.push(d)}e.attributes.position.values=new Float64Array(a);var x=C.computeNumberOfVertices(e);e.indices=v.createTypedArray(x,s)}var H={};H.toWireframe=function(e){if(!r(e))throw new n("geometry is required.");var t=e.indices;if(r(t)){switch(e.primitiveType){case w.TRIANGLES:e.indices=x(t);break;case w.TRIANGLE_STRIP:e.indices=M(t);break;case w.TRIANGLE_FAN:e.indices=A(t);break;default:throw new n("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=w.LINES}return e},H.createLineSegmentsForVectors=function(e,i,o){if(!r(e))throw new n("geometry is required.");if(!r(e.attributes.position))throw new n("geometry.attributes.position is required.");if(i=t(i,"normal"),!r(e.attributes[i]))throw new n("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+i+".");o=t(o,1e4);for(var a=e.attributes.position.values,s=e.attributes[i].values,u=a.length,l=new Float64Array(2*u),c=0,f=0;u>f;f+=3)l[c++]=a[f],l[c++]=a[f+1],l[c++]=a[f+2],l[c++]=a[f]+s[f]*o,l[c++]=a[f+1]+s[f+1]*o,l[c++]=a[f+2]+s[f+2]*o;var h,m=e.boundingSphere;return r(m)&&(h=new E(m.center,m.radius+o)),new C({attributes:{position:new b({componentDatatype:p.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:w.LINES,boundingSphere:h})},H.createAttributeIndices=function(e){if(!r(e))throw new n("geometry is required.");var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],o=e.attributes,a={},s=0,u=i.length;for(t=0;u>t;++t){var l=i[t];r(o[l])&&(a[l]=s++)}for(var c in o)o.hasOwnProperty(c)&&!r(a[c])&&(a[c]=s++);return a},H.reorderForPreVertexCache=function(e){if(!r(e))throw new n("geometry is required.");var t=C.computeNumberOfVertices(e),i=e.indices;if(r(i)){for(var o=new Int32Array(t),a=0;t>a;a++)o[a]=-1;for(var s,u=i,l=u.length,c=v.createTypedArray(t,l),f=0,h=0,m=0;l>f;)s=o[u[f]],-1!==s?c[h]=s:(s=u[f],o[s]=m,c[h]=m,++m),++f,++h;e.indices=c;var y=e.attributes;for(var d in y)if(y.hasOwnProperty(d)&&r(y[d])&&r(y[d].values)){for(var w=y[d],g=w.values,E=0,b=w.componentsPerAttribute,S=p.createTypedArray(w.componentDatatype,m*b);t>E;){var x=o[E];if(-1!==x)for(a=0;b>a;a++)S[b*x+a]=g[b*E+a];++E}w.values=S}}return e},H.reorderForPostVertexCache=function(e,t){if(!r(e))throw new n("geometry is required.");var i=e.indices;if(e.primitiveType===w.TRIANGLES&&r(i)){for(var o=i.length,a=0,s=0;o>s;s++)i[s]>a&&(a=i[s]);e.indices=g.tipsify({indices:i,maximumIndex:a,cacheSize:t})}return e},H.fitToUnsignedShortIndices=function(e){if(!r(e))throw new n("geometry is required.");if(r(e.indices)&&e.primitiveType!==w.TRIANGLES&&e.primitiveType!==w.LINES&&e.primitiveType!==w.POINTS)throw new n("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],i=C.computeNumberOfVertices(e);if(r(e.indices)&&i>f.SIXTY_FOUR_KILOBYTES){var o,a=[],s=[],u=0,l=T(e.attributes),c=e.indices,h=c.length;e.primitiveType===w.TRIANGLES?o=3:e.primitiveType===w.LINES?o=2:e.primitiveType===w.POINTS&&(o=1);for(var m=0;h>m;m+=o){for(var y=0;o>y;++y){var d=c[m+y],p=a[d];r(p)||(p=u++,a[d]=p,I(l,e.attributes,d)),s.push(p)}u+o>f.SIXTY_FOUR_KILOBYTES&&(t.push(new C({attributes:l,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),a=[],s=[],u=0,l=T(e.attributes))}0!==s.length&&t.push(new C({attributes:l,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else t.push(e);return t};var k=new o,K=new s;H.projectTo2D=function(e,t,i,a,s){if(!r(e))throw new n("geometry is required.");if(!r(t))throw new n("attributeName is required.");if(!r(i))throw new n("attributeName3D is required.");if(!r(a))throw new n("attributeName2D is required.");var u=e.attributes[t];if(!r(u))throw new n("geometry must have attribute matching the attributeName argument: "+t+".");if(u.componentDatatype.value!==p.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");s=r(s)?s:new d;for(var l=s.getEllipsoid(),c=u.values,f=new Float64Array(c.length),h=0,m=0;m<c.length;m+=3){var y=o.fromArray(c,m,k),v=l.cartesianToCartographic(y,K);if(!r(v))throw new n("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var w=s.project(v,k);f[h++]=w.x,f[h++]=w.y,f[h++]=w.z}return e.attributes[i]=u,e.attributes[a]=new b({componentDatatype:p.DOUBLE,componentsPerAttribute:3,values:f}),delete e.attributes[t],e};var j={high:0,low:0};H.encodeAttribute=function(e,t,i,o){if(!r(e))throw new n("geometry is required.");if(!r(t))throw new n("attributeName is required.");if(!r(i))throw new n("attributeHighName is required.");if(!r(o))throw new n("attributeLowName is required.");var a=e.attributes[t];if(!r(a))throw new n("geometry must have attribute matching the attributeName argument: "+t+".");if(a.componentDatatype.value!==p.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var s=a.values,l=s.length,c=new Float32Array(l),f=new Float32Array(l),h=0;l>h;++h)u.encode(s[h],j),c[h]=j.high,f[h]=j.low;var m=a.componentsPerAttribute;return e.attributes[i]=new b({componentDatatype:p.FLOAT,componentsPerAttribute:m,values:c}),e.attributes[o]=new b({componentDatatype:p.FLOAT,componentsPerAttribute:m,values:f}),delete e.attributes[t],e};var X=new o,Z=new m,Q=new h;H.transformToWorldCoordinates=function(e){if(!r(e))throw new n("instance is required.");var t=e.modelMatrix;if(m.equals(t,m.IDENTITY))return e;var i=e.geometry.attributes;O(t,i.position),O(t,i.prevPosition),O(t,i.nextPosition),(r(i.normal)||r(i.binormal)||r(i.tangent))&&(m.inverse(t,Z),m.transpose(Z,Z),m.getRotation(Z,Q),R(Q,i.normal),R(Q,i.binormal),R(Q,i.tangent));var o=e.geometry.boundingSphere;return r(o)&&(e.geometry.boundingSphere=E.transform(o,t,o)),e.modelMatrix=m.clone(m.IDENTITY),e},H.combine=function(e){if(!r(e)||e.length<1)throw new n("instances is required and must have length greater than zero.");var t,i,a,s,u=e.length,l=e[0].modelMatrix,c=r(e[0].geometry.indices),f=e[0].geometry.primitiveType;for(i=1;u>i;++i){if(!m.equals(e[i].modelMatrix,l))throw new n("All instances must have the same modelMatrix.");if(r(e[i].geometry.indices)!==c)throw new n("All instance geometries must have an indices or not have one.");if(e[i].geometry.primitiveType!==f)throw new n("All instance geometries must have the same primitiveType.")}var h,y,d,p=N(e);for(t in p)if(p.hasOwnProperty(t))for(h=p[t].values,s=0,i=0;u>i;++i)for(y=e[i].geometry.attributes[t].values,d=y.length,a=0;d>a;++a)h[s++]=y[a];var g;if(c){var b=0;for(i=0;u>i;++i)b+=e[i].geometry.indices.length;var S=C.computeNumberOfVertices(new C({attributes:p,primitiveType:w.POINTS})),x=v.createTypedArray(S,b),M=0,A=0;for(i=0;u>i;++i){var T=e[i].geometry.indices,I=T.length;for(s=0;I>s;++s)x[M++]=A+T[s];A+=C.computeNumberOfVertices(e[i].geometry)}g=x}var O,R=new o,z=0;for(i=0;u>i;++i){if(O=e[i].geometry.boundingSphere,!r(O)){R=void 0;break}o.add(O.center,R,R)}if(r(R))for(o.divideByScalar(R,u,R),i=0;u>i;++i){O=e[i].geometry.boundingSphere;var L=o.magnitude(o.subtract(O.center,R))+O.radius;L>z&&(z=L)}return new C({attributes:p,indices:g,primitiveType:f,boundingSphere:r(R)?new E(R,z):void 0})};var J=new o,$=new o,et=new o,tt=new o;H.computeNormal=function(e){if(!r(e))throw new n("geometry is required.");var t=e.attributes,i=e.indices;if(!r(t.position)||!r(t.position.values))throw new n("geometry.attributes.position.values is required.");if(!r(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==w.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,s=e.attributes.position.values.length/3,u=i.length,l=new Array(s),c=new Array(u/3),f=new Array(u),h=0;s>h;h++)l[h]={indexOffset:0,count:0,currentCount:0};var m=0;for(h=0;u>h;h+=3){var y=i[h],d=i[h+1],v=i[h+2],g=3*y,E=3*d,C=3*v;$.x=a[g],$.y=a[g+1],$.z=a[g+2],et.x=a[E],et.y=a[E+1],et.z=a[E+2],tt.x=a[C],tt.y=a[C+1],tt.z=a[C+2],l[y].count++,l[d].count++,l[v].count++,o.subtract(et,$,et),o.subtract(tt,$,tt),c[m]=o.cross(et,tt),m++}var S=0;for(h=0;s>h;h++)l[h].indexOffset+=S,S+=l[h].count;m=0;var x;for(h=0;u>h;h+=3){x=l[i[h]];var M=x.indexOffset+x.currentCount;f[M]=m,x.currentCount++,x=l[i[h+1]],M=x.indexOffset+x.currentCount,f[M]=m,x.currentCount++,x=l[i[h+2]],M=x.indexOffset+x.currentCount,f[M]=m,x.currentCount++,m++}var A=new Float32Array(3*s);for(h=0;s>h;h++){var T=3*h;if(x=l[h],x.count>0){for(o.clone(o.ZERO,J),m=0;m<x.count;m++)o.add(J,c[f[x.indexOffset+m]],J);o.normalize(J,J),A[T]=J.x,A[T+1]=J.y,A[T+2]=J.z}else A[T]=0,A[T+1]=0,A[T+2]=1}return e.attributes.normal=new b({componentDatatype:p.FLOAT,componentsPerAttribute:3,values:A}),e};var rt=new o,nt=new o,it=new o;H.computeBinormalAndTangent=function(e){if(!r(e))throw new n("geometry is required.");var t=e.attributes,i=e.indices;if(!r(t.position)||!r(t.position.values))throw new n("geometry.attributes.position.values is required.");if(!r(t.normal)||!r(t.normal.values))throw new n("geometry.attributes.normal.values is required.");if(!r(t.st)||!r(t.st.values))throw new n("geometry.attributes.st.values is required.");if(!r(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==w.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,s=e.attributes.normal.values,u=e.attributes.st.values,l=e.attributes.position.values.length/3,c=i.length,f=new Array(3*l),h=0;h<f.length;h++)f[h]=0;var m,y,d;for(h=0;c>h;h+=3){var v=i[h],g=i[h+1],E=i[h+2];m=3*v,y=3*g,d=3*E;var C=2*v,S=2*g,x=2*E,M=a[m],A=a[m+1],T=a[m+2],I=u[C],O=u[C+1],R=u[S+1]-O,N=u[x+1]-O,z=1/((u[S]-I)*N-(u[x]-I)*R),L=(N*(a[y]-M)-R*(a[d]-M))*z,P=(N*(a[y+1]-A)-R*(a[d+1]-A))*z,D=(N*(a[y+2]-T)-R*(a[d+2]-T))*z;f[m]+=L,f[m+1]+=P,f[m+2]+=D,f[y]+=L,f[y+1]+=P,f[y+2]+=D,f[d]+=L,f[d+1]+=P,f[d+2]+=D}var F=new Float32Array(3*l),q=new Float32Array(3*l);for(h=0;l>h;h++){m=3*h,y=m+1,d=m+2;var _=o.fromArray(s,m,rt),B=o.fromArray(f,m,it),U=o.dot(_,B);o.multiplyByScalar(_,U,nt),o.normalize(o.subtract(B,nt,B),B),q[m]=B.x,q[y]=B.y,q[d]=B.z,o.normalize(o.cross(_,B,B),B),F[m]=B.x,F[y]=B.y,F[d]=B.z}return e.attributes.tangent=new b({componentDatatype:p.FLOAT,componentsPerAttribute:3,values:q}),e.attributes.binormal=new b({componentDatatype:p.FLOAT,componentsPerAttribute:3,values:F}),e};var ot=new o,at=new o,st=new o,ut=new o,lt=new o,ct={positions:new Array(7),indices:new Array(9)};return H.wrapLongitude=function(e){if(!r(e))throw new n("geometry is required.");var t=e.boundingSphere;if(r(t)){var i=t.center.x-t.radius;if(i>0||E.intersect(t,a.UNIT_Y)!==l.INTERSECTING)return e}return _(e),e.primitiveType===w.TRIANGLES?Y(e):e.primitiveType===w.LINES&&V(e),e},H}),define("Scene/PrimitivePipeline",["../Core/defined","../Core/defaultValue","../Core/Color","../Core/ComponentDatatype","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryPipeline","../Core/Matrix4"],function(e,t,r,n,i,o,a,s,u,l){"use strict";function c(e,t,r){var n,i=!r,o=e.length;if(!i&&o>1){var a=e[0].modelMatrix;for(n=1;o>n;++n)if(!l.equals(a,e[n].modelMatrix)){i=!0;break}}if(i)for(n=0;o>n;++n)u.transformToWorldCoordinates(e[n]);else l.clone(e[0].modelMatrix,t)}function f(e,t){for(var i=e.length,o=0;i>o;++o){var a=e[o],u=a.geometry,l=u.attributes,c=l.position,f=4*(c.values.length/c.componentsPerAttribute);l.pickColor=new s({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(f)});for(var h=t[o],m=r.floatToByte(h.red),y=r.floatToByte(h.green),d=r.floatToByte(h.blue),p=r.floatToByte(h.alpha),v=l.pickColor.values,w=0;f>w;w+=4)v[w]=m,v[w+1]=y,v[w+2]=d,v[w+3]=p}}function h(t){var r,n=t.length,i=[],o=t[0].attributes;for(r in o)if(o.hasOwnProperty(r)){for(var a=o[r],s=!0,u=1;n>u;++u){var l=t[u].attributes[r];if(!e(l)||a.componentDatatype.value!==l.componentDatatype.value||a.componentsPerAttribute!==l.componentsPerAttribute||a.normalize!==l.normalize){s=!1;break}}s&&i.push(r)}return i}function m(e,t){for(var r=e.length,i=0;r>i;++i)for(var o=e[i],u=o.attributes,l=o.geometry,c=a.computeNumberOfVertices(l),f=t.length,h=0;f>h;++h){for(var m=t[h],y=u[m],d=y.componentDatatype,p=y.value,v=p.length,w=n.createTypedArray(d,c*v),g=0;c>g;++g)w.set(p,g*v);l.attributes[m]=new s({componentDatatype:d,componentsPerAttribute:v,normalize:y.normalize,values:w})}}function y(e){var t,r=e.instances,o=e.pickIds,a=e.projection,s=e.elementIndexUintSupported,l=e.allow3DOnly,y=e.allowPicking,d=e.vertexCacheOptimize,p=e.modelMatrix,v=r.length,w=r[0].geometry.primitiveType;for(t=1;v>t;++t)if(r[t].geometry.primitiveType!==w)throw new i("All instance geometries must have the same primitiveType.");if(c(r,p,l),!l)for(t=0;v>t;++t)u.wrapLongitude(r[t].geometry);y&&f(r,o);var g=h(r);if(m(r,g),d)for(t=0;v>t;++t)u.reorderForPostVertexCache(r[t].geometry),u.reorderForPreVertexCache(r[t].geometry);var E,C=u.combine(r),b=C.attributes;if(l)for(E in b)b.hasOwnProperty(E)&&b[E].componentDatatype.value===n.DOUBLE.value&&u.encodeAttribute(C,E,E+"3DHigh",E+"3DLow");else for(E in b)if(b.hasOwnProperty(E)&&b[E].componentDatatype.value===n.DOUBLE.value){var S=E+"3D",x=E+"2D";u.projectTo2D(C,E,S,x,a),u.encodeAttribute(C,S,S+"High",S+"Low"),u.encodeAttribute(C,x,x+"High",x+"Low")}return s?[C]:u.fitToUnsignedShortIndices(C)}function d(e,t,r){for(var i=[],o=e.attributes,a=r.length,s=0;a>s;++s){var u=r[s],l=o[u],c=l.componentDatatype;c.value===n.DOUBLE.value&&(c=n.FLOAT);var f=n.createTypedArray(c,l.values);i.push({index:t[u],componentDatatype:c,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,values:f}),delete o[u]}return i}function p(r,n,i){for(var o=[],s=h(r),u=r.length,l={},c={},f=0;u>f;++f)for(var m=r[f],y=a.computeNumberOfVertices(m.geometry),d=s.length,p=0;d>p;++p)for(var v=s[p],w=i[v],g=y;g>0;){for(var E,C=t(c[v],0),b=n[C],S=b.length,x=0;S>x&&(E=b[x],E.index!==w);++x);e(o[f])||(o[f]={}),e(o[f][v])||(o[f][v]={dirty:!1,value:m.attributes[v].value,indices:[]});var M,A=E.values.length/E.componentsPerAttribute,T=t(l[v],0);A>T+g?(M=g,o[f][v].indices.push({attribute:E,offset:T,count:M}),l[v]=T+g):(M=A-T,o[f][v].indices.push({attribute:E,offset:T,count:M}),l[v]=0,c[v]=C+1),g-=M}return o}function v(e){return{type:e.constructor.name,buffer:e.buffer}}function w(e){return new E[e.type](e.buffer)}if(!o.supportsTypedArrays())return{};var g={};g.combineGeometry=function(e){for(var t={instances:e.instances,pickIds:e.pickIds,ellipsoid:e.ellipsoid,projection:e.projection,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:l.clone(e.modelMatrix)},r=y(t),n=u.createAttributeIndices(r[0]),i=t.instances,o=h(i),a=[],s=r.length,c=0;s>c;++c){var f=r[c];a.push(d(f,n,o))}var m=p(i,a,n);return{geometries:r,modelMatrix:t.modelMatrix,attributeIndices:n,vaAttributes:a,vaAttributeIndices:m}};var E={Int8Array:Int8Array,Uint8Array:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};return g.transferGeometry=function(t,r){var n,i=t.attributes;for(var o in i)i.hasOwnProperty(o)&&e(i[o])&&e(i[o].values)&&(n=i[o].values,r.indexOf(i[o].values.buffer)<0&&r.push(n.buffer),e(n.type)||(i[o].values=v(n)));e(t.indices)&&(n=t.indices,r.push(n.buffer),e(n.type)||(t.indices=v(t.indices)))},g.transferGeometries=function(e,t){for(var r=e.length,n=0;r>n;++n)g.transferGeometry(e[n],t)},g.transferPerInstanceAttributes=function(e,t){for(var r=e.length,n=0;r>n;++n)for(var i=e[n],o=i.length,a=0;o>a;++a){var s=i[a].values;t.push(s.buffer),i[a].values=v(s)}},g.transferInstances=function(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n];g.transferGeometry(i.geometry,t)}},g.receiveGeometry=function(t){var r=t.attributes;for(var n in r)r.hasOwnProperty(n)&&e(r[n])&&e(r[n].values)&&(r[n].values=w(r[n].values));e(t.indices)&&(t.indices=w(t.indices))},g.receiveGeometries=function(e){for(var t=e.length,r=0;t>r;++r)g.receiveGeometry(e[r])},g.receivePerInstanceAttributes=function(e){for(var t=e.length,r=0;t>r;++r)for(var n=e[r],i=n.length,o=0;i>o;++o)n[o].values=w(n[o].values)},g.receiveInstances=function(e){for(var t=e.length,r=0;t>r;++r){var n=e[r];g.receiveGeometry(n.geometry)}},g}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined"],function(e,t){"use strict";var r=function(r){var n,i=[],o={id:void 0,result:void 0,error:void 0};return function(a){var s=a.data;i.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=r(s.parameters,i)}catch(u){o.error=u}t(n)||(n=e(self.webkitPostMessage,self.postMessage));try{n(o,i)}catch(u){o.result=void 0,o.error="postMessage failed with error: "+u+"\n  with responseMessage: "+JSON.stringify(o),n(o)}}};return r}),define("Workers/createExtentOutlineGeometry",["../Core/ExtentOutlineGeometry","../Core/Ellipsoid","../Core/Extent","../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,t,r,n,i){"use strict";function o(i,o){var a=i.geometry;a._ellipsoid=t.clone(a._ellipsoid),a._extent=r.clone(a._extent);var s=e.createGeometry(a);return n.transferGeometry(s,o),{geometry:s,index:i.index}}return i(o)})}();