/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2013 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/Fullscreen",["./defined"],function(e){"use strict";var t,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return n.supportsFullscreen=function(){if(e(t))return t;t=!1;var n=document.body;if("function"==typeof n.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];i=u+"RequestFullscreen","function"==typeof n[i]?(r.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof n[i]&&(r.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?r.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(r.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?r.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(r.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),r.fullscreenerror=i)}return t},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[r.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[r.exitFullscreen]()},n.isFullscreenEnabled=function(){return n.supportsFullscreen()?document[r.fullscreenEnabled]:void 0},n.getFullscreenElement=function(){return n.supportsFullscreen()?document[r.fullscreenElement]:void 0},n.isFullscreen=function(){return n.supportsFullscreen()?null!==n.getFullscreenElement():void 0},n.getFullscreenChangeEventName=function(){return n.supportsFullscreen()?r.fullscreenchange:void 0},n.getFullscreenErrorEventName=function(){return n.supportsFullscreen()?r.fullscreenerror:void 0},n}),define("Core/FeatureDetection",["./defined","./Fullscreen"],function(e,t){"use strict";function r(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function n(){if(!e(f)){var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===t?f=!1:(f=!0,m=r(t[1]))}return f}function i(){return n()&&m}function o(){if(!e(h))if(n()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))h=!1;else{var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===t?h=!1:(h=!0,d=r(t[1]))}return h}function a(){return o()&&d}function s(){if(!e(p)){var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===t?p=!1:(p=!0,y=r(t[1]),y.isNightly=!!t[2])}return p}function u(){return s()&&y}function l(){if(!e(v)){var t=/ MSIE ([\.0-9]+)/.exec(navigator.userAgent);null===t?v=!1:(v=!0,w=r(t[1]))}return v}function c(){return l()&&w}var f,m,h,d,p,y,v,w,g,E={isChrome:n,chromeVersion:i,isSafari:o,safariVersion:a,isWebkit:s,webkitVersion:u,isInternetExplorer:l,internetExplorerVersion:c};return E.supportsCrossOriginImagery=function(){return e(g)||(g=o()&&u()[0]<536?!1:"withCredentials"in new XMLHttpRequest),g},E.supportsFullscreen=function(){return t.supportsFullscreen()},E.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},E}),define("Core/Enumeration",["./defined"],function(e){"use strict";var t=function(t,r,n){if(this.value=t,this.name=r,e(n))for(var i in n)n.hasOwnProperty(i)&&(this[i]=n[i])};return t.prototype.valueOf=function(){return this.value},t.prototype.toString=function(){return this.name},t}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./Enumeration"],function(e,t,r,n,i){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:new i(5120,"BYTE",{sizeInBytes:Int8Array.BYTES_PER_ELEMENT}),UNSIGNED_BYTE:new i(5121,"UNSIGNED_BYTE",{sizeInBytes:Uint8Array.BYTES_PER_ELEMENT}),SHORT:new i(5122,"SHORT",{sizeInBytes:Int16Array.BYTES_PER_ELEMENT}),UNSIGNED_SHORT:new i(5123,"UNSIGNED_SHORT",{sizeInBytes:Uint16Array.BYTES_PER_ELEMENT}),FLOAT:new i(5126,"FLOAT",{sizeInBytes:Float32Array.BYTES_PER_ELEMENT}),DOUBLE:new i(5130,"DOUBLE",{sizeInBytes:Float64Array.BYTES_PER_ELEMENT})};return o.validate=function(e){return t(e)&&t(e.value)&&(e.value===o.BYTE.value||e.value===o.UNSIGNED_BYTE.value||e.value===o.SHORT.value||e.value===o.UNSIGNED_SHORT.value||e.value===o.FLOAT.value||e.value===o.DOUBLE.value)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e.value){case o.BYTE.value:return new Int8Array(n);case o.UNSIGNED_BYTE.value:return new Uint8Array(n);case o.SHORT.value:return new Int16Array(n);case o.UNSIGNED_SHORT.value:return new Uint16Array(n);case o.FLOAT.value:return new Float32Array(n);case o.DOUBLE.value:return new Float64Array(n);default:throw new r("componentDatatype is not a valid enumeration value.")}},o.createArrayBufferView=function(n,i,a,s){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),s=e(s,(i.byteLength-a)/n.sizeInBytes),n.value){case o.BYTE.value:return new Int8Array(i,a,s);case o.UNSIGNED_BYTE.value:return new Uint8Array(i,a,s);case o.SHORT.value:return new Int16Array(i,a,s);case o.UNSIGNED_SHORT.value:return new Uint16Array(i,a,s);case o.FLOAT.value:return new Float32Array(i,a,s);case o.DOUBLE.value:return new Float64Array(i,a,s);default:throw new r("componentDatatype is not a valid enumeration value.")}},o}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["./defaultValue","./defined","./DeveloperError","../ThirdParty/mersenne-twister"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.negativePiToPi=function(e){for(var t=i.EPSILON10,r=i.PI,n=i.TWO_PI;-(r+t)>e;)e+=n;if(-r>e)return-r;for(;e>r+t;)e-=n;return e>r?r:e},i.zeroToTwoPi=function(e){var t=e%i.TWO_PI;return 0>t?(t+i.TWO_PI)%i.TWO_PI:t},i.equalsEpsilon=function(t,r,n){return n=e(n,0),Math.abs(t-r)<=n};var o=[1];i.factorial=function(e){var t=o.length;if(e>=t)for(var r=o[t-1],n=t;e>=n;n++)o.push(r*n);return o[e]},i.incrementWrap=function(t,r,n){return n=e(n,0),++t,t>r&&(t=n),t},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,r){return t>e?t:e>r?r:e};var a=new n;return i.setRandomNumberSeed=function(e){a=new n(e)},i.nextRandomNumber=function(){return a.random()},i}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,t,r){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(t){return e(t)&&(t===n.UNSIGNED_BYTE||t===n.UNSIGNED_SHORT||t===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new t("numberOfVertices is required.");return n>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(t){return t===e.POINTS||t===e.LINES||t===e.LINE_LOOP||t===e.LINE_STRIP||t===e.TRIANGLES||t===e.TRIANGLE_STRIP||t===e.TRIANGLE_FAN}};return e}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var o=r.clock,a=r.cone,s=e(r.magnitude,1),u=s*Math.sin(a);return n.x=u*Math.cos(o),n.y=u*Math.sin(o),n.z=s*Math.cos(a),n},i.fromElements=function(e,r,n,o){return t(o)?(o.x=e,o.y=r,o.z=n,o):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r):new i(e.x/n,e.y/n,e.z/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n):new i(e.x*r.x,e.y*r.y,e.z*r.z)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n):new i(e.x+r.x,e.y+r.y,e.z+r.z)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n):new i(e.x-r.x,e.y-r.y,e.z-r.z)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n):new i(e.x*r,e.y*r,e.z*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n):new i(e.x/r,e.y/r,e.z/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r):new i(-e.x,-e.y,-e.z)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i,u=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,u);var r=i.dot(s,u),n=i.magnitude(i.cross(s,u,s));return Math.atan2(n,r)};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n},i.cross=function(e,r,n){var o=e.x,a=e.y,s=e.z,u=r.x,l=r.y,c=r.z,f=a*c-s*l,m=s*u-o*c,h=o*l-a*u;return t(n)?(n.x=f,n.y=m,n.z=h,n):new i(f,m,h)},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n,i){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,r,n,o,a){return t(a)?(a.x=e,a.y=r,a.z=n,a.w=o,a):new i(e,r,n,o)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n++],o.w=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n.w=Math.min(e.w,r.w),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n.w=Math.max(e.w,r.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r.w=e.w/n,r):new i(e.x/n,e.y/n,e.z/n,e.w/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n.w=e.w*r.w,n):new i(e.x*r.x,e.y*r.y,e.z*r.z,e.w*r.w)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n):new i(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n):new i(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n):new i(e.x*r,e.y*r,e.z*r,e.w*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n):new i(e.x/r,e.y/r,e.z/r,e.w/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new i(-e.x,-e.y,-e.z,-e.w)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r.w=Math.abs(e.w),r):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z),Math.abs(e.w))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n&&Math.abs(e.w-r.w)<=n},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var o=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return o.fromDegrees=function(r,n,a,s){return r=i.toRadians(e(r,0)),n=i.toRadians(e(n,0)),a=e(a,0),t(s)?(s.longitude=r,s.latitude=n,s.height=a,s):new o(r,n,a)},o.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new r("epsilon is required and must be a number.");return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.toString=function(e){if(!t(e))throw new r("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return o.toString(this)},o}),define("Core/Ellipsoid",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic"],function(e,t,r,n,i,o,a){"use strict";var s=function(e,r,a){if(e=t(e,0),r=t(r,0),a=t(a,0),0>e||0>r||0>a)throw new n("All radii components must be greater than or equal to zero.");this._radii=new o(e,r,a),this._radiiSquared=new o(e*e,r*r,a*a),this._radiiToTheFourth=new o(e*e*e*e,r*r*r*r,a*a*a*a),this._oneOverRadii=new o(0===e?0:1/e,0===r?0:1/r,0===a?0:1/a),this._oneOverRadiiSquared=new o(0===e?0:1/(e*e),0===r?0:1/(r*r),0===a?0:1/(a*a)),this._minimumRadius=Math.min(e,r,a),this._maximumRadius=Math.max(e,r,a),this._centerToleranceSquared=i.EPSILON1};s.clone=function(e,t){if(!r(e))return void 0;var n=e._radii;return r(t)?(o.clone(n,t._radii),o.clone(e._radiiSquared,t._radiiSquared),o.clone(e._radiiToTheFourth,t._radiiToTheFourth),o.clone(e._oneOverRadii,t._oneOverRadii),o.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new s(n.x,n.y,n.z)},s.fromCartesian3=function(e){return r(e)?new s(e.x,e.y,e.z):new s},s.WGS84=e(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=e(new s(1,1,1)),s.MOON=e(new s(i.LUNAR_RADIUS,i.LUNAR_RADIUS,i.LUNAR_RADIUS)),s.prototype.getRadii=function(){return this._radii},s.prototype.getRadiiSquared=function(){return this._radiiSquared},s.prototype.getRadiiToTheFourth=function(){return this._radiiToTheFourth},s.prototype.getOneOverRadii=function(){return this._oneOverRadii},s.prototype.getOneOverRadiiSquared=function(){return this._oneOverRadiiSquared},s.prototype.getMinimumRadius=function(){return this._minimumRadius},s.prototype.getMaximumRadius=function(){return this._maximumRadius},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=o.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(e,t){if(!r(e))throw new n("cartographic is required.");var i=e.longitude,a=e.latitude,s=Math.cos(a),u=s*Math.cos(i),l=s*Math.sin(i),c=Math.sin(a);return r(t)||(t=new o),t.x=u,t.y=l,t.z=c,o.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(e,t){return t=o.multiplyComponents(e,this._oneOverRadiiSquared,t),o.normalize(t,t)};var u=new o,l=new o;s.prototype.cartographicToCartesian=function(e,t){var r=u,n=l;this.geodeticSurfaceNormalCartographic(e,r),o.multiplyComponents(this._radiiSquared,r,n);var i=Math.sqrt(o.dot(r,n));return o.divideByScalar(n,i,n),o.multiplyByScalar(r,e.height,r),o.add(n,r,t)},s.prototype.cartographicArrayToCartesianArray=function(e,t){if(!r(e))throw new n("cartographics is required.");var i=e.length;r(t)?t.length=i:t=new Array(i);for(var o=0;i>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var c=new o,f=new o,m=new o;s.prototype.cartesianToCartographic=function(e,t){var n=this.scaleToGeodeticSurface(e,f);if(!r(n))return void 0;var s=this.geodeticSurfaceNormal(n,c),u=o.subtract(e,n,m),l=Math.atan2(s.y,s.x),h=Math.asin(s.z),d=i.sign(o.dot(u,e))*o.magnitude(u);return r(t)?(t.longitude=l,t.latitude=h,t.height=d,t):new a(l,h,d)},s.prototype.cartesianArrayToCartographicArray=function(e,t){if(!r(e))throw new n("cartesians is required.");var i=e.length;r(t)?t.length=i:t=new Array(i);for(var o=0;i>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t};var h=new o,d=new o;return s.prototype.scaleToGeodeticSurface=function(e,t){if(!r(e))throw new n("cartesian is required.");var a=e.x,s=e.y,u=e.z,l=this._oneOverRadii,c=l.x,f=l.y,m=l.z,p=a*a*c*c,y=s*s*f*f,v=u*u*m*m,w=p+y+v,g=Math.sqrt(1/w),E=o.multiplyByScalar(e,g,h);if(w<this._centerToleranceSquared)return isFinite(g)?o.clone(E,t):void 0;var S=this._oneOverRadiiSquared,C=S.x,b=S.y,A=S.z,M=d;M.x=2*E.x*C,M.y=2*E.y*b,M.z=2*E.z*A;var x,T,O,I,N,R,D,L,z,P,F,_=(1-g)*o.magnitude(e)/(.5*o.magnitude(M)),q=0;do{_-=q,O=1/(1+_*C),I=1/(1+_*b),N=1/(1+_*A),R=O*O,D=I*I,L=N*N,z=R*O,P=D*I,F=L*N,x=p*R+y*D+v*L-1,T=p*z*C+y*P*b+v*F*A;var B=-2*T;q=x/B}while(Math.abs(x)>i.EPSILON12);return r(t)?(t.x=a*O,t.y=s*I,t.z=u*N,t):new o(a*O,s*I,u*N)},s.prototype.scaleToGeocentricSurface=function(e,t){if(!r(e))throw new n("cartesian is required.");var i=e.x,a=e.y,s=e.z,u=this._oneOverRadiiSquared,l=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return o.multiplyByScalar(e,l,t)},s.prototype.transformPositionToScaledSpace=function(e,t){return o.multiplyComponents(e,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(e,t){return o.multiplyComponents(e,this._radii,t)},s.prototype.equals=function(e){return this===e||r(e)&&o.equals(this._radii,e._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Ellipsoid"],function(e,t,r,n,i){"use strict";var o=function(t){this._ellipsoid=e(t,i.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return o.prototype.getEllipsoid=function(){return this._ellipsoid},o.prototype.project=function(e,n){var i=this._semimajorAxis,o=e.longitude*i,a=e.latitude*i,s=e.height;return t(n)?(n.x=o,n.y=a,n.z=s,n):new r(o,a,s)},o.prototype.unproject=function(e,r){var i=this._oneOverSemimajorAxis,o=e.x*i,a=e.y*i,s=e.z;return t(r)?(r.longitude=o,r.latitude=a,r.height=s,r):new n(o,a,s)},o}),define("Core/Intersect",["./Enumeration"],function(e){"use strict";var t={OUTSIDE:new e(-1,"OUTSIDE"),INTERSECTING:new e(0,"INTERSECTING"),INSIDE:new e(1,"INSIDE")};return t}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,o){"use strict";function a(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var n=e[l.getElementIndex(f[r],c[r])];t+=2*n*n}return Math.sqrt(t)}function u(e,t){for(var r=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var s=Math.abs(e[l.getElementIndex(f[a],c[a])]);s>n&&(i=a,n=s)}var u=1,m=0,h=c[i],d=f[i];if(Math.abs(e[l.getElementIndex(d,h)])>r){var p,y=e[l.getElementIndex(d,d)],v=e[l.getElementIndex(h,h)],w=e[l.getElementIndex(d,h)],g=(y-v)/2/w;p=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),u=1/Math.sqrt(1+p*p),m=p*u}return t=l.clone(l.IDENTITY,t),t[l.getElementIndex(h,h)]=t[l.getElementIndex(d,d)]=u,t[l.getElementIndex(d,h)]=m,t[l.getElementIndex(h,d)]=-m,t}var l=function(e,r,n,i,o,a,s,u,l){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(o,0),this[5]=t(u,0),this[6]=t(n,0),this[7]=t(a,0),this[8]=t(l,0)};l.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,n,i){return n=t(n,0),r(i)||(i=new l),i[0]=e[n],i[1]=e[n+1],i[2]=e[n+2],i[3]=e[n+3],i[4]=e[n+4],i[5]=e[n+5],i[6]=e[n+6],i[7]=e[n+7],i[8]=e[n+8],i[9]=e[n+9],i},l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,t){var n=e.x*e.x,i=e.x*e.y,o=e.x*e.z,a=e.x*e.w,s=e.y*e.y,u=e.y*e.z,c=e.y*e.w,f=e.z*e.z,m=e.z*e.w,h=e.w*e.w,d=n-s-f+h,p=2*(i-m),y=2*(o+c),v=2*(i+m),w=-n+s-f+h,g=2*(u-a),E=2*(o-c),S=2*(u+a),C=-n-s+f+h;return r(t)?(t[0]=d,t[1]=v,t[2]=E,t[3]=p,t[4]=w,t[5]=S,t[6]=y,t[7]=g,t[8]=C,t):new l(d,p,y,v,w,g,E,S,C)},l.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new l(e,0,0,0,e,0,0,0,e)},l.fromRotationX=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=i,t[6]=0,t[7]=-i,t[8]=n,t):new l(1,0,0,0,n,-i,0,i,n)},l.fromRotationY=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=n,t):new l(n,0,i,0,1,0,-i,0,n)},l.fromRotationZ=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=i,t[2]=0,t[3]=-i,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new l(n,-i,0,i,n,0,0,0,1)},l.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,t){return 3*e+t},l.getColumn=function(t,n,i){var o=3*n,a=t[o],s=t[o+1],u=t[o+2];return r(i)?(i.x=a,i.y=s,i.z=u,i):new e(a,s,u)},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var i=3*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n},l.getRow=function(t,n,i){var o=t[n],a=t[n+3],s=t[n+6];return r(i)?(i.x=o,i.y=a,i.z=s,i):new e(o,a,s)},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n},l.multiply=function(e,t,n){var i=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],s=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],f=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],m=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],h=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r(n)?(n[0]=i,n[1]=o,n[2]=a,n[3]=s,n[4]=u,n[5]=c,n[6]=f,n[7]=m,n[8]=h,n):new l(i,s,f,o,u,m,a,c,h)},l.multiplyByVector=function(t,n,i){var o=n.x,a=n.y,s=n.z,u=t[0]*o+t[3]*a+t[6]*s,l=t[1]*o+t[4]*a+t[7]*s,c=t[2]*o+t[5]*a+t[8]*s;return r(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByScalar=function(e,t,n){return r(n)?(n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n):new l(e[0]*t,e[3]*t,e[6]*t,e[1]*t,e[4]*t,e[7]*t,e[2]*t,e[5]*t,e[8]*t)},l.negate=function(e,t){return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t):new l(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},l.transpose=function(e,t){var n=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],c=e[2],f=e[5],m=e[8];return r(t)?(t[0]=n,t[1]=i,t[2]=o,t[3]=a,t[4]=s,t[5]=u,t[6]=c,t[7]=f,t[8]=m,t):new l(n,a,c,i,s,f,o,u,m)};var c=[1,0,0],f=[2,2,1],m=new l,h=new l;return l.getEigenDecomposition=function(e,t){var n=o.EPSILON20,i=10,c=0,f=0;r(t)||(t={});for(var d=t.unitary=l.clone(l.IDENTITY,t.unitary),p=t.diagonal=l.clone(e,t.diagonal),y=n*a(p);i>f&&s(p)>y;)u(p,m),l.transpose(m,h),l.multiply(p,m,p),l.multiply(h,p,p),l.multiply(d,m,d),++c>2&&(++f,c=0);return t},l.abs=function(e,t){return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t):new l(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},l.determinant=function(e){if(!r(e))throw new n("matrix is required");var t=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],l=e[2],c=e[5],f=e[8];return t*(s*f-c*u)+a*(c*o-i*f)+l*(i*u-s*o)},l.inverse=function(e,t){if(!r(e))throw new n("matrix is required");var i=e[0],a=e[1],s=e[2],u=e[3],c=e[4],f=e[5],m=e[6],h=e[7],d=e[8],p=l.determinant(e);if(Math.abs(p)<=o.EPSILON15)throw new n("matrix is not invertible");var y=new l(c*d-h*f,m*f-u*d,u*h-m*c,h*s-a*d,i*d-m*s,m*a-i*h,a*f-c*s,u*s-i*f,i*c-u*a),v=1/p;return l.multiplyByScalar(y,v,t)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},l.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},l.IDENTITY=i(new l(1,0,0,0,1,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,o,a,s,u){"use strict";var l=function(e,t,n,i,o,a,s,u,l,c,f,m,h,d,p,y){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(l,0),this[3]=r(h,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(c,0),this[7]=r(d,0),this[8]=r(n,0),this[9]=r(s,0),this[10]=r(f,0),this[11]=r(p,0),this[12]=r(i,0),this[13]=r(u,0),this[14]=r(m,0),this[15]=r(y,0)
};l.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=function(e,t,i){return t=r(t,0),n(i)||(i=new l),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i[9]=e[t+9],i[10]=e[t+10],i[11]=e[t+11],i[12]=e[t+12],i[13]=e[t+13],i[14]=e[t+14],i[15]=e[t+15],i},l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(e,t,r){return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=0,r[4]=e[3],r[5]=e[4],r[6]=e[5],r[7]=0,r[8]=e[6],r[9]=e[7],r[10]=e[8],r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,r):new l(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},new s,l.fromTranslationQuaternionRotationScale=function(e,t,r,i){n(i)||(i=new l);var o=r.x,a=r.y,s=r.z,u=t.x*t.x,c=t.x*t.y,f=t.x*t.z,m=t.x*t.w,h=t.y*t.y,d=t.y*t.z,p=t.y*t.w,y=t.z*t.z,v=t.z*t.w,w=t.w*t.w,g=u-h-y+w,E=2*(c-v),S=2*(f+p),C=2*(c+v),b=-u+h-y+w,A=2*(d-m),M=2*(f-p),x=2*(d+m),T=-u-h+y+w;return i[0]=g*o,i[1]=C*o,i[2]=M*o,i[3]=0,i[4]=E*a,i[5]=b*a,i[6]=x*a,i[7]=0,i[8]=S*s,i[9]=A*s,i[10]=T*s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},l.fromTranslation=function(e,t){return l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,f=new e,m=new e;l.fromCamera=function(t,r){var i=t.eye,o=t.target,a=t.up;e.normalize(e.subtract(o,i,c),c),e.normalize(e.cross(c,a,f),f),e.normalize(e.cross(f,c,m),m);var s=f.x,u=f.y,h=f.z,d=c.x,p=c.y,y=c.z,v=m.x,w=m.y,g=m.z,E=i.x,S=i.y,C=i.z,b=s*-E+u*-S+h*-C,A=v*-E+w*-S+g*-C,M=d*E+p*S+y*C;return n(r)?(r[0]=s,r[1]=v,r[2]=-d,r[3]=0,r[4]=u,r[5]=w,r[6]=-p,r[7]=0,r[8]=h,r[9]=g,r[10]=-y,r[11]=0,r[12]=b,r[13]=A,r[14]=M,r[15]=1,r):new l(s,u,h,b,v,w,g,A,-d,-p,-y,M,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,r,i,o){var a=Math.tan(.5*e),s=1/a,u=s/t,c=(i+r)/(r-i),f=2*i*r/(r-i);return n(o)?(o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=f,o[15]=0,o):new l(u,0,0,0,0,s,0,0,0,0,c,f,0,0,-1,0)},l.computeOrthographicOffCenter=function(e,t,r,i,o,a,s){var u=1/(t-e),c=1/(i-r),f=1/(a-o),m=-(t+e)*u,h=-(i+r)*c,d=-(a+o)*f;return u*=2,c*=2,f*=-2,n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=m,s[13]=h,s[14]=d,s[15]=1,s):new l(u,0,0,m,0,c,0,h,0,0,f,d,0,0,0,1)},l.computePerspectiveOffCenter=function(e,t,r,i,o,a,s){var u=2*o/(t-e),c=2*o/(i-r),f=(t+e)/(t-e),m=(i+r)/(i-r),h=-(a+o)/(a-o),d=-1,p=-2*a*o/(a-o);return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=m,s[10]=h,s[11]=d,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s):new l(u,0,f,0,0,c,m,0,0,0,h,p,0,0,d,0)},l.computeInfinitePerspectiveOffCenter=function(e,t,r,i,o,a){var s=2*o/(t-e),u=2*o/(i-r),c=(t+e)/(t-e),f=(i+r)/(i-r),m=-1,h=-1,d=-2*o;return n(a)?(a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=m,a[11]=h,a[12]=0,a[13]=0,a[14]=d,a[15]=0,a):new l(s,0,c,0,0,u,f,0,0,0,m,d,0,0,h,0)},l.computeViewportTransformation=function(e,t,i,o){e=r(e,r.EMPTY_OBJECT);var a=r(e.x,0),s=r(e.y,0),u=r(e.width,0),c=r(e.height,0);t=r(t,0),i=r(i,1);var f=.5*u,m=.5*c,h=.5*(i-t),d=f,p=m,y=h,v=a+f,w=s+m,g=t+h,E=1;return n(o)?(o[0]=d,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=p,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=y,o[11]=0,o[12]=v,o[13]=w,o[14]=g,o[15]=E,o):new l(d,0,0,v,0,p,0,w,0,0,y,g,0,0,0,E)},l.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return 4*e+t},l.getColumn=function(e,r,i){var o=4*r,a=e[o],s=e[o+1],u=e[o+2],l=e[o+3];return n(i)?(i.x=a,i.y=s,i.z=u,i.w=l,i):new t(a,s,u,l)},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var i=4*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n[i+3]=r.w,n},l.getRow=function(e,r,i){var o=e[r],a=e[r+4],s=e[r+8],u=e[r+12];return n(i)?(i.x=o,i.y=a,i.z=s,i.w=u,i):new t(o,a,s,u)},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n},l.multiply=function(e,t,r){var i=e[0],o=e[1],a=e[2],s=e[3],u=e[4],c=e[5],f=e[6],m=e[7],h=e[8],d=e[9],p=e[10],y=e[11],v=e[12],w=e[13],g=e[14],E=e[15],S=t[0],C=t[1],b=t[2],A=t[3],M=t[4],x=t[5],T=t[6],O=t[7],I=t[8],N=t[9],R=t[10],D=t[11],L=t[12],z=t[13],P=t[14],F=t[15],_=i*S+u*C+h*b+v*A,q=o*S+c*C+d*b+w*A,B=a*S+f*C+p*b+g*A,U=s*S+m*C+y*b+E*A,G=i*M+u*x+h*T+v*O,Y=o*M+c*x+d*T+w*O,W=a*M+f*x+p*T+g*O,V=s*M+m*x+y*T+E*O,H=i*I+u*N+h*R+v*D,k=o*I+c*N+d*R+w*D,K=a*I+f*N+p*R+g*D,j=s*I+m*N+y*R+E*D,Z=i*L+u*z+h*P+v*F,Q=o*L+c*z+d*P+w*F,X=a*L+f*z+p*P+g*F,J=s*L+m*z+y*P+E*F;return n(r)?(r[0]=_,r[1]=q,r[2]=B,r[3]=U,r[4]=G,r[5]=Y,r[6]=W,r[7]=V,r[8]=H,r[9]=k,r[10]=K,r[11]=j,r[12]=Z,r[13]=Q,r[14]=X,r[15]=J,r):new l(_,G,H,Z,q,Y,k,Q,B,W,K,X,U,V,j,J)},l.multiplyTransformation=function(e,t,r){var i=e[0],o=e[1],a=e[2],s=e[4],u=e[5],c=e[6],f=e[8],m=e[9],h=e[10],d=e[12],p=e[13],y=e[14],v=t[0],w=t[1],g=t[2],E=t[4],S=t[5],C=t[6],b=t[8],A=t[9],M=t[10],x=t[12],T=t[13],O=t[14],I=i*v+s*w+f*g,N=o*v+u*w+m*g,R=a*v+c*w+h*g,D=i*E+s*S+f*C,L=o*E+u*S+m*C,z=a*E+c*S+h*C,P=i*b+s*A+f*M,F=o*b+u*A+m*M,_=a*b+c*A+h*M,q=i*x+s*T+f*O+d,B=o*x+u*T+m*O+p,U=a*x+c*T+h*O+y;return n(r)?(r[0]=I,r[1]=N,r[2]=R,r[3]=0,r[4]=D,r[5]=L,r[6]=z,r[7]=0,r[8]=P,r[9]=F,r[10]=_,r[11]=0,r[12]=q,r[13]=B,r[14]=U,r[15]=1,r):new l(I,D,P,q,N,L,F,B,R,z,_,U,0,0,0,1)},l.multiplyByTranslation=function(e,t,r){var i=t.x,o=t.y,a=t.z,s=i*e[0]+o*e[4]+a*e[8]+e[12],u=i*e[1]+o*e[5]+a*e[9]+e[13],c=i*e[2]+o*e[6]+a*e[10]+e[14];return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=s,r[13]=u,r[14]=c,r[15]=e[15],r):new l(e[0],e[4],e[8],s,e[1],e[5],e[9],u,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var h=new e;return l.multiplyByUniformScale=function(e,t,r){return h.x=t,h.y=t,h.z=t,l.multiplyByScale(e,h,r)},l.multiplyByScale=function(e,t,r){var i=t.x,o=t.y,a=t.z;return 1===i&&1===o&&1===a?l.clone(e,r):n(r)?(r[0]=i*e[0],r[1]=i*e[1],r[2]=i*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=a*e[8],r[9]=a*e[9],r[10]=a*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r):new l(i*e[0],o*e[4],a*e[8],e[12],i*e[1],o*e[5],a*e[9],e[13],i*e[2],o*e[6],a*e[10],e[14],0,0,0,1)},l.multiplyByVector=function(e,r,i){var o=r.x,a=r.y,s=r.z,u=r.w,l=e[0]*o+e[4]*a+e[8]*s+e[12]*u,c=e[1]*o+e[5]*a+e[9]*s+e[13]*u,f=e[2]*o+e[6]*a+e[10]*s+e[14]*u,m=e[3]*o+e[7]*a+e[11]*s+e[15]*u;return n(i)?(i.x=l,i.y=c,i.z=f,i.w=m,i):new t(l,c,f,m)},l.multiplyByPointAsVector=function(t,r,i){var o=r.x,a=r.y,s=r.z,u=t[0]*o+t[4]*a+t[8]*s,l=t[1]*o+t[5]*a+t[9]*s,c=t[2]*o+t[6]*a+t[10]*s;return n(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByPoint=function(t,r,i){var o=r.x,a=r.y,s=r.z,u=t[0]*o+t[4]*a+t[8]*s+t[12],l=t[1]*o+t[5]*a+t[9]*s+t[13],c=t[2]*o+t[6]*a+t[10]*s+t[14];return n(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByScalar=function(e,t,r){return n(r)?(r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r):new l(e[0]*t,e[4]*t,e[8]*t,e[12]*t,e[1]*t,e[5]*t,e[9]*t,e[13]*t,e[2]*t,e[6]*t,e[10]*t,e[14]*t,e[3]*t,e[7]*t,e[11]*t,e[15]*t)},l.negate=function(e,t){return n(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t):new l(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},l.transpose=function(e,t){if(!n(t))return new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var r=e[1],i=e[2],o=e[3],a=e[6],s=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=s,t[14]=u,t[15]=e[15],t},l.abs=function(e,t){return n(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t):new l(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},l.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[11]===t[11]&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},l.getTranslation=function(t,r){return n(r)?(r.x=t[12],r.y=t[13],r.z=t[14],r):new e(t[12],t[13],t[14])},l.getRotation=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},l.inverse=function(e,t){var r=e[0],i=e[4],o=e[8],s=e[12],c=e[1],f=e[5],m=e[9],h=e[13],d=e[2],p=e[6],y=e[10],v=e[14],w=e[3],g=e[7],E=e[11],S=e[15],C=y*S,b=v*E,A=p*S,M=v*g,x=p*E,T=y*g,O=d*S,I=v*w,N=d*E,R=y*w,D=d*g,L=p*w,z=C*f+M*m+x*h-(b*f+A*m+T*h),P=b*c+O*m+R*h-(C*c+I*m+N*h),F=A*c+I*f+D*h-(M*c+O*f+L*h),_=T*c+N*f+L*m-(x*c+R*f+D*m),q=b*i+A*o+T*s-(C*i+M*o+x*s),B=C*r+I*o+N*s-(b*r+O*o+R*s),U=M*r+O*i+L*s-(A*r+I*i+D*s),G=x*r+R*i+D*o-(T*r+N*i+L*o);C=o*h,b=s*m,A=i*h,M=s*f,x=i*m,T=o*f,O=r*h,I=s*c,N=r*m,R=o*c,D=r*f,L=i*c;var Y=C*g+M*E+x*S-(b*g+A*E+T*S),W=b*w+O*E+R*S-(C*w+I*E+N*S),V=A*w+I*g+D*S-(M*w+O*g+L*S),H=T*w+N*g+L*E-(x*w+R*g+D*E),k=A*y+T*v+b*p-(x*v+C*p+M*y),K=N*v+C*d+I*y-(O*y+R*v+b*d),j=O*p+L*v+M*d-(D*v+A*d+I*p),Z=D*y+x*d+R*p-(N*p+L*y+T*d),Q=r*z+i*P+o*F+s*_;if(Math.abs(Q)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return Q=1/Q,n(t)?(t[0]=z*Q,t[1]=P*Q,t[2]=F*Q,t[3]=_*Q,t[4]=q*Q,t[5]=B*Q,t[6]=U*Q,t[7]=G*Q,t[8]=Y*Q,t[9]=W*Q,t[10]=V*Q,t[11]=H*Q,t[12]=k*Q,t[13]=K*Q,t[14]=j*Q,t[15]=Z*Q,t):new l(z*Q,q*Q,Y*Q,k*Q,P*Q,B*Q,W*Q,K*Q,F*Q,U*Q,V*Q,j*Q,_*Q,G*Q,H*Q,Z*Q)},l.inverseTransformation=function(e,t){var r=e[0],i=e[1],o=e[2],a=e[4],s=e[5],u=e[6],c=e[8],f=e[9],m=e[10],h=e[12],d=e[13],p=e[14],y=-r*h-i*d-o*p,v=-a*h-s*d-u*p,w=-c*h-f*d-m*p;return n(t)?(t[0]=r,t[1]=a,t[2]=c,t[3]=0,t[4]=i,t[5]=s,t[6]=f,t[7]=0,t[8]=o,t[9]=u,t[10]=m,t[11]=0,t[12]=y,t[13]=v,t[14]=w,t[15]=1,t):new l(r,i,o,y,a,s,u,v,c,f,m,w,0,0,0,1)},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/BoundingSphere",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Cartesian4","./Cartographic","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4"],function(e,t,r,n,i,o,a,s,u,l,c){"use strict";var f=function(t,r){this.center=n.clone(e(t,n.ZERO)),this.radius=e(r,0)},m=new n,h=new n,d=new n,p=new n,y=new n,v=new n,w=new n,g=new n,E=new n,S=new n,C=new n,b=new n;f.fromPoints=function(e,r){if(t(r)||(r=new f),!t(e)||0===e.length)return r.center=n.clone(n.ZERO,r.center),r.radius=0,r;for(var i=n.clone(e[0],w),o=n.clone(i,m),a=n.clone(i,h),s=n.clone(i,d),u=n.clone(i,p),l=n.clone(i,y),c=n.clone(i,v),A=e.length,M=1;A>M;M++){n.clone(e[M],i);var x=i.x,T=i.y,O=i.z;x<o.x&&n.clone(i,o),x>u.x&&n.clone(i,u),T<a.y&&n.clone(i,a),T>l.y&&n.clone(i,l),O<s.z&&n.clone(i,s),O>c.z&&n.clone(i,c)}var I=n.magnitudeSquared(n.subtract(u,o,g)),N=n.magnitudeSquared(n.subtract(l,a,g)),R=n.magnitudeSquared(n.subtract(c,s,g)),D=o,L=u,z=I;N>z&&(z=N,D=a,L=l),R>z&&(z=R,D=s,L=c);var P=E;P.x=.5*(D.x+L.x),P.y=.5*(D.y+L.y),P.z=.5*(D.z+L.z);var F=n.magnitudeSquared(n.subtract(L,P,g)),_=Math.sqrt(F),q=S;q.x=o.x,q.y=a.y,q.z=s.z;var B=C;B.x=u.x,B.y=l.y,B.z=c.z;var U=n.multiplyByScalar(n.add(q,B,g),.5,b),G=0;for(M=0;A>M;M++){n.clone(e[M],i);var Y=n.magnitude(n.subtract(i,U,g));Y>G&&(G=Y);var W=n.magnitudeSquared(n.subtract(i,P,g));if(W>F){var V=Math.sqrt(W);_=.5*(_+V),F=_*_;var H=V-_;P.x=(_*P.x+H*i.x)/V,P.y=(_*P.y+H*i.y)/V,P.z=(_*P.z+H*i.z)/V}}return G>_?(n.clone(P,r.center),r.radius=_):(n.clone(U,r.center),r.radius=G),r};var A=new s,M=new n,x=new n,T=new o,O=new o;f.fromExtent2D=function(e,t,r){return f.fromExtentWithHeights2D(e,t,0,0,r)},f.fromExtentWithHeights2D=function(r,i,o,a,s){if(t(s)||(s=new f),!t(r))return s.center=n.clone(n.ZERO,s.center),s.radius=0,s;i=e(i,A),r.getSouthwest(T),T.height=o,r.getNortheast(O),O.height=a;var u=i.project(T,M),l=i.project(O,x),c=l.x-u.x,m=l.y-u.y,h=l.z-u.z;s.radius=.5*Math.sqrt(c*c+m*m+h*h);var d=s.center;return d.x=u.x+.5*c,d.y=u.y+.5*m,d.z=u.z+.5*h,s};var I=[];f.fromExtent3D=function(r,n,i,o){n=e(n,a.WGS84),i=e(i,0);var s;return t(r)&&(s=r.subsample(n,i,I)),f.fromPoints(s,o)},f.fromVertices=function(r,i,o,a){if(t(a)||(a=new f),!t(r)||0===r.length)return a.center=n.clone(n.ZERO,a.center),a.radius=0,a;i=e(i,n.ZERO),o=e(o,3);var s=w;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var u=n.clone(s,m),l=n.clone(s,h),c=n.clone(s,d),A=n.clone(s,p),M=n.clone(s,y),x=n.clone(s,v),T=r.length,O=0;T>O;O+=o){var I=r[O]+i.x,N=r[O+1]+i.y,R=r[O+2]+i.z;s.x=I,s.y=N,s.z=R,I<u.x&&n.clone(s,u),I>A.x&&n.clone(s,A),N<l.y&&n.clone(s,l),N>M.y&&n.clone(s,M),R<c.z&&n.clone(s,c),R>x.z&&n.clone(s,x)}var D=n.magnitudeSquared(n.subtract(A,u,g)),L=n.magnitudeSquared(n.subtract(M,l,g)),z=n.magnitudeSquared(n.subtract(x,c,g)),P=u,F=A,_=D;L>_&&(_=L,P=l,F=M),z>_&&(_=z,P=c,F=x);var q=E;q.x=.5*(P.x+F.x),q.y=.5*(P.y+F.y),q.z=.5*(P.z+F.z);var B=n.magnitudeSquared(n.subtract(F,q,g)),U=Math.sqrt(B),G=S;G.x=u.x,G.y=l.y,G.z=c.z;var Y=C;Y.x=A.x,Y.y=M.y,Y.z=x.z;var W=n.multiplyByScalar(n.add(G,Y,g),.5,b),V=0;for(O=0;T>O;O+=o){s.x=r[O]+i.x,s.y=r[O+1]+i.y,s.z=r[O+2]+i.z;var H=n.magnitude(n.subtract(s,W,g));H>V&&(V=H);var k=n.magnitudeSquared(n.subtract(s,q,g));if(k>B){var K=Math.sqrt(k);U=.5*(U+K),B=U*U;var j=K-U;q.x=(U*q.x+j*s.x)/K,q.y=(U*q.y+j*s.y)/K,q.z=(U*q.z+j*s.z)/K}}return V>U?(n.clone(q,a.center),a.radius=U):(n.clone(W,a.center),a.radius=V),a},f.fromCornerPoints=function(e,r,i){t(i)||(i=new f);var o=i.center;return n.add(e,r,o),n.multiplyByScalar(o,.5,o),i.radius=n.distance(o,r),i},f.fromEllipsoid=function(e,r){return t(r)||(r=new f),n.clone(n.ZERO,r.center),r.radius=e.getMaximumRadius(),r},f.clone=function(e,r){return t(e)?t(r)?(r.center=n.clone(e.center,r.center),r.radius=e.radius,r):new f(e.center,e.radius):void 0};var N=new n,R=new n;f.union=function(e,r,i){t(i)||(i=new f);var o=e.center,a=r.center;n.add(o,a,R);var s=n.multiplyByScalar(R,.5,R),u=n.magnitude(n.subtract(o,s,N))+e.radius,l=n.magnitude(n.subtract(a,s,N))+r.radius;return i.radius=Math.max(u,l),n.clone(s,i.center),i};var D=new n;f.expand=function(e,t,r){r=f.clone(e,r);var i=n.magnitude(n.subtract(t,r.center,D));return i>r.radius&&(r.radius=i),r},f.intersect=function(e,t){var r=e.center,i=e.radius,o=n.dot(t,r)+t.w;return-i>o?u.OUTSIDE:i>o?u.INTERSECTING:u.INSIDE};var L=new n;f.transform=function(e,r,i){return t(i)||(i=new f),i.center=c.multiplyByPoint(r,e.center,i.center),i.radius=Math.max(n.magnitude(c.getColumn(r,0,L)),n.magnitude(c.getColumn(r,1,L)),n.magnitude(c.getColumn(r,2,L)))*e.radius,i},f.transformWithoutScale=function(e,r,n){return t(n)||(n=new f),n.center=c.multiplyByPoint(r,e.center,n.center),n.radius=e.radius,n};var z=new n;f.getPlaneDistances=function(e,r,i,o){t(o)||(o=new l);var a=n.subtract(e.center,r,z),s=n.multiplyByScalar(i,n.dot(i,a),z),u=n.magnitude(s);return o.start=u-e.radius,o.stop=u+e.radius,o};for(var P=new n,F=new n,_=new n,q=new n,B=new n,U=new o,G=new Array(8),Y=0;8>Y;++Y)G[Y]=new n;var W=new s;return f.projectTo2D=function(t,r,i){r=e(r,W);var o=r.getEllipsoid(),a=t.center,s=t.radius,u=o.geodeticSurfaceNormal(a,P),l=n.cross(n.UNIT_Z,u,F);n.normalize(l,l);var c=n.cross(u,l,_);n.normalize(c,c),n.multiplyByScalar(u,s,u),n.multiplyByScalar(c,s,c),n.multiplyByScalar(l,s,l);var m=n.negate(c,B),h=n.negate(l,q),d=G,p=d[0];n.add(u,c,p),n.add(p,l,p),p=d[1],n.add(u,c,p),n.add(p,h,p),p=d[2],n.add(u,m,p),n.add(p,h,p),p=d[3],n.add(u,m,p),n.add(p,l,p),n.negate(u,u),p=d[4],n.add(u,c,p),n.add(p,l,p),p=d[5],n.add(u,c,p),n.add(p,h,p),p=d[6],n.add(u,m,p),n.add(p,h,p),p=d[7],n.add(u,m,p),n.add(p,l,p);for(var y=d.length,v=0;y>v;++v){var w=d[v];n.add(a,w,w);var g=o.cartesianToCartographic(w,U);r.project(g,w)}i=f.fromPoints(d,i),a=i.center;var E=a.x,S=a.y,C=a.z;return a.x=C,a.y=E,a.z=S,i},f.equals=function(e,r){return e===r||t(e)&&t(r)&&n.equals(e.center,r.center)&&e.radius===r.radius},f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.union=function(e,t){return f.union(this,e,t)},f.prototype.expand=function(e,t){return f.expand(this,e,t)},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.getPlaneDistances=function(e,t,r){return f.getPlaneDistances(this,e,t,r)},f.prototype.projectTo2D=function(e,t){return f.projectTo2D(this,e,t)},f.prototype.equals=function(e){return f.equals(this,e)},f}),define("Core/EllipsoidGeodesic",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Math","./Cartesian3","./Cartographic"],function(e,t,r,n,i,o,a,s){"use strict";function u(e){var t=e._uSquared,r=e._ellipsoid.getMaximumRadius(),n=e._ellipsoid.getMinimumRadius(),i=(r-n)/r,o=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-i)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),l=u*s,c=Math.atan2(s,o),f=u*a,m=f*f,h=1-m,d=Math.sqrt(h),p=t/4,y=p*p,v=y*p,w=y*y,g=1+p-3*y/4+5*v/4-175*w/64,E=1-p+15*y/8-35*v/8,S=1-3*p+35*y/4,C=1-5*p,b=g*c-E*Math.sin(2*c)*p/2-S*Math.sin(4*c)*y/16-C*Math.sin(6*c)*v/48-5*Math.sin(8*c)*w/512,A=e._constants;A.a=r,A.b=n,A.f=i,A.cosineHeading=o,A.sineHeading=a,A.tanU=s,A.cosineU=u,A.sineU=l,A.sigma=c,A.sineAlpha=f,A.sineSquaredAlpha=m,A.cosineSquaredAlpha=h,A.cosineAlpha=d,A.u2Over4=p,A.u4Over16=y,A.u6Over64=v,A.u8Over256=w,A.a0=g,A.a1=E,A.a2=S,A.a3=C,A.distanceRatio=b}function l(e,t){return e*t*(4+e*(4-3*t))/16}function c(e,t,r,n,i,o,a){var s=l(e,r);return(1-s)*e*t*(n+s*i*(a+s*o*(2*a*a-1)))}function f(e,t,r,n,i,a,s){var u,l,f,m,h,d=(t-r)/t,p=a-n,y=Math.atan((1-d)*Math.tan(i)),v=Math.atan((1-d)*Math.tan(s)),w=Math.cos(y),g=Math.sin(y),E=Math.cos(v),S=Math.sin(v),C=w*E,b=w*S,A=g*S,M=g*E,x=p,T=o.TWO_PI,O=Math.cos(x),I=Math.sin(x);do{O=Math.cos(x),I=Math.sin(x);var N=b-M*O;f=Math.sqrt(E*E*I*I+N*N),l=A+C*O,u=Math.atan2(f,l);var R;0===f?(R=0,m=1):(R=C*I/f,m=1-R*R),T=x,h=l-2*A/m,isNaN(h)&&(h=0),x=p+c(d,R,m,u,f,l,h)}while(Math.abs(x-T)>o.EPSILON12);var D=m*(t*t-r*r)/(r*r),L=1+D*(4096+D*(D*(320-175*D)-768))/16384,z=D*(256+D*(D*(74-47*D)-128))/1024,P=h*h,F=z*f*(h+z*(l*(2*P-1)-z*h*(4*f*f-3)*(4*P-3)/6)/4),_=r*L*(u-F),q=Math.atan2(E*I,b-M*O),B=Math.atan2(w*I,b*O-M);e._distance=_,e._startHeading=q,e._endHeading=B,e._uSquared=D}function m(e,t,r,i){var o=a.normalize(i.cartographicToCartesian(t,d),h),l=a.normalize(i.cartographicToCartesian(r,d),d);if(Math.abs(Math.abs(a.angleBetween(o,l))-Math.PI)<.0125)throw new n("geodesic position is not unique");f(e,i.getMaximumRadius(),i.getMinimumRadius(),t.longitude,t.latitude,r.longitude,r.latitude),t.height=0,r.height=0,e._start=s.clone(t,e._start),e._end=s.clone(r,e._end),u(e)}var h=new a,d=new a,p=function(e,n,o){var a=t(o,i.WGS84);this._ellipsoid=a,this._start=new s,this._end=new s,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,r(e)&&r(n)&&m(this,e,n,a)};return p.prototype.getSurfaceDistance=function(){if(!r(this._distance))throw new n("start and end must be set before calling funciton getSurfaceDistance");return this._distance},p.prototype.setEndPoints=function(e,t){if(!r(e))throw new n("start cartographic position is required");if(!r(t))throw new n("end cartgraphic position is required");m(this,e,t,this._ellipsoid)},p.prototype.getStart=function(){return this._start},p.prototype.getEnd=function(){return this._end},p.prototype.getStartHeading=function(){if(!r(this._distance))throw new n("start and end must be set before calling funciton getStartHeading");return this._startHeading},p.prototype.getEndHeading=function(){if(!r(this._distance))throw new n("start and end must be set before calling funciton getEndHeading");return this._endHeading},p.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},p.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!r(this._distance))throw new n("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,o=i.distanceRatio+e/i.b,a=Math.cos(2*o),u=Math.cos(4*o),l=Math.cos(6*o),f=Math.sin(2*o),m=Math.sin(4*o),h=Math.sin(6*o),d=Math.sin(8*o),p=o*o,y=o*p,v=i.u8Over256,w=i.u2Over4,g=i.u6Over64,E=i.u4Over16,S=2*y*v*a/3+o*(1-w+7*E/4-15*g/4+579*v/64-(E-15*g/4+187*v/16)*a-(5*g/4-115*v/16)*u-29*v*l/16)+(w/2-E+71*g/32-85*v/16)*f+(5*E/16-5*g/4+383*v/96)*m-p*((g-11*v/2)*f+5*v*m/2)+(29*g/96-29*v/16)*h+539*v*d/1536,C=Math.asin(Math.sin(S)*i.cosineAlpha),b=Math.atan(i.a/i.b*Math.tan(C));S-=i.sigma;var A=Math.cos(2*i.sigma+S),M=Math.sin(S),x=Math.cos(S),T=i.cosineU*x,O=i.sineU*M,I=Math.atan2(M*i.sineHeading,T-O*i.cosineHeading),N=I-c(i.f,i.sineAlpha,i.cosineSquaredAlpha,S,M,x,A);return r(t)?(t.longitude=this._start.longitude+N,t.latitude=b,t.height=0,t):new s(this._start.longitude+N,b,0)},p}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.discriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.realRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var s=Math.abs(o),u=Math.abs(n);if(u>s&&s/u<t.EPSILON14)return[0,0];if(s>u&&u/s<t.EPSILON14)return[];if(a=-o/n,0>a)return[];var l=Math.sqrt(a);return[-l,l]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var c=i*i,f=4*n*o,m=r(c,-f,t.EPSILON14);if(0>m)return[];var h=-.5*r(i,t.sign(i)*Math.sqrt(m),t.EPSILON14);return i>0?[h/n,o/h]:[o/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,o,a=e,s=t/3,u=r/3,l=n,c=a*u,f=s*l,m=s*s,h=u*u,d=a*u-m,p=a*l-s*u,y=s*l-h,v=4*d*y-p*p;if(0>v){var w,g,E;m*f>=c*h?(w=a,g=d,E=-2*s*d+a*p):(w=l,g=y,E=-l*p+2*u*y);var S=0>E?-1:1,C=-S*Math.abs(w)*Math.sqrt(-v);o=-E+C;var b=o/2,A=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),M=o===C?-A:-g/A;return i=0>=g?A+M:-E/(A*A+M*M+g),m*f>=c*h?[(i-s)/a]:[-l/(i+u)]}var x=d,T=-2*s*d+a*p,O=y,I=-l*p+2*u*y,N=Math.sqrt(v),R=Math.sqrt(3)/2,D=Math.abs(Math.atan2(a*N,-T)/3);i=2*Math.sqrt(-x);var L=Math.cos(D);o=i*L;var z=i*(-L/2-R*Math.sin(D)),P=o+z>2*s?o-s:z-s,F=a,_=P/F;D=Math.abs(Math.atan2(l*N,-I)/3),i=2*Math.sqrt(-O),L=Math.cos(D),o=i*L,z=i*(-L/2-R*Math.sin(D));var q=-l,B=2*u>o+z?o+u:z+u,U=q/B,G=F*B,Y=-P*B-F*q,W=P*q,V=(u*Y-s*W)/(-s*Y+u*G);return V>=_?U>=_?U>=V?[_,V,U]:[_,U,V]:[U,_,V]:U>=_?[V,_,U]:U>=V?[V,U,_]:[U,V,_]}var n={};return n.discriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=t*t,a=r*r,s=n*n,u=i*i,l=18*t*r*n*i+a*s-27*o*u-4*(t*s*n+a*r*i);return l},n.realRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===n)return t.realRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];u=-a/n;var l=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[l,l,l]}return 0===a?(s=t.realRoots(n,0,o),0===s.Length?[0]:[s[0],0,s[1]]):r(n,0,o,a)}return 0===o?0===a?(u=-i/n,0>u?[u,0,0]:[0,0,u]):r(n,i,0,a):0===a?(s=t.realRoots(n,i,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):r(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./DeveloperError","./Math","./CubicRealPolynomial","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(e,i,o,a){var s=e*e,u=i-3*s/8,l=o-i*e/2+s*e/8,c=a-o*e/4+i*s/16-3*s*s/256,f=r.realRoots(1,2*u,u*u-4*c,-l*l);if(f.length>0){var m=-e/4,h=f[f.length-1];if(Math.abs(h)<t.EPSILON14){var d=n.realRoots(1,u,c);if(2===d.length){var p,y=d[0],v=d[1];if(y>=0&&v>=0){var w=Math.sqrt(y),g=Math.sqrt(v);return[m-g,m-w,m+w,m+g]}if(y>=0&&0>v)return p=Math.sqrt(y),[m-p,m+p];if(0>y&&v>=0)return p=Math.sqrt(v),[m-p,m+p]}return[]}if(h>0){var E=Math.sqrt(h),S=(u+h-l/E)/2,C=(u+h+l/E)/2,b=n.realRoots(1,E,S),A=n.realRoots(1,-E,C);return 0!==b.length?(b[0]+=m,b[1]+=m,0!==A.length?(A[0]+=m,A[1]+=m,b[1]<=A[0]?[b[0],b[1],A[0],A[1]]:A[1]<=b[0]?[A[0],A[1],b[0],b[1]]:b[0]>=A[0]&&b[1]<=A[1]?[A[0],b[0],b[1],A[1]]:A[0]>=b[0]&&A[1]<=b[1]?[b[0],A[0],A[1],b[1]]:b[0]>A[0]&&b[0]<A[1]?[A[0],b[0],A[1],b[1]]:[b[0],A[0],b[1],A[1]]):b):0!==A.length?(A[0]+=m,A[1]+=m,A):[]}}return[]}function o(e,i,o,a){var s=o*o,u=i*i,l=e*e,c=-2*i,f=o*e+u-4*a,m=l*a-o*i*e+s,h=r.realRoots(1,c,f,m);if(h.length>0){var d,p,y=h[0],v=i-y,w=v*v,g=e/2,E=v/2,S=w-4*a,C=w+4*Math.abs(a),b=l-4*y,A=l+4*Math.abs(y);if(0>y||b*C>S*A){var M=Math.sqrt(b);d=M/2,p=0===M?0:(e*E-o)/M}else{var x=Math.sqrt(S);d=0===x?0:(e*E-o)/x,p=x/2}var T,O;0===g&&0===d?(T=0,O=0):t.sign(g)===t.sign(d)?(T=g+d,O=y/T):(O=g-d,T=y/O);var I,N;0===E&&0===p?(I=0,N=0):t.sign(E)===t.sign(p)?(I=E+p,N=a/I):(N=E-p,I=a/N);var R=n.realRoots(1,T,I),D=n.realRoots(1,O,N);if(0!==R.length)return 0!==D.length?R[1]<=D[0]?[R[0],R[1],D[0],D[1]]:D[1]<=R[0]?[D[0],D[1],R[0],R[1]]:R[0]>=D[0]&&R[1]<=D[1]?[D[0],R[0],R[1],D[1]]:D[0]>=R[0]&&D[1]<=R[1]?[R[0],D[0],D[1],R[1]]:R[0]>D[0]&&R[0]<D[1]?[D[0],R[0],D[1],R[1]]:[R[0],D[0],R[1],D[1]]:R;if(0!==D.length)return D}return[]}var a={};return a.discriminant=function(t,r,n,i,o){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");if("number"!=typeof o)throw new e("e is a required number.");var a=t*t,s=a*t,u=r*r,l=u*r,c=n*n,f=c*n,m=i*i,h=m*i,d=o*o,p=d*o,y=u*c*m-4*l*h-4*t*f*m+18*t*r*n*h-27*a*m*m+256*s*p+o*(18*l*n*i-4*u*f+16*t*c*c-80*t*r*c*i-6*t*u*m+144*a*n*m)+d*(144*t*u*n-27*u*u-128*a*c-192*a*r*i);return y},a.realRoots=function(n,a,s,u,l){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof a)throw new e("b is a required number.");if("number"!=typeof s)throw new e("c is a required number.");if("number"!=typeof u)throw new e("d is a required number.");if("number"!=typeof l)throw new e("e is a required number.");if(Math.abs(n)<t.EPSILON15)return r.realRoots(a,s,u,l);var c=a/n,f=s/n,m=u/n,h=l/n,d=0>c?1:0;switch(d+=0>f?d+1:d,d+=0>m?d+1:d,d+=0>h?d+1:d){case 0:return i(c,f,m,h);case 1:return o(c,f,m,h);case 2:return o(c,f,m,h);case 3:return i(c,f,m,h);case 4:return i(c,f,m,h);case 5:return o(c,f,m,h);case 6:return i(c,f,m,h);case 7:return i(c,f,m,h);case 8:return o(c,f,m,h);case 9:return i(c,f,m,h);case 10:return i(c,f,m,h);case 11:return o(c,f,m,h);case 12:return i(c,f,m,h);case 13:return i(c,f,m,h);case 14:return i(c,f,m,h);case 15:return i(c,f,m,h);default:return void 0}},a}),define("Core/IntersectionTests",["./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,t,r,n,i,o,a,s){"use strict";function u(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}function l(e,t,i,l,c){var f,m=l*l,h=c*c,d=(e[o.COLUMN1ROW1]-e[o.COLUMN2ROW2])*h,p=c*(l*u(e[o.COLUMN1ROW0],e[o.COLUMN0ROW1],r.EPSILON15)+t.y),y=e[o.COLUMN0ROW0]*m+e[o.COLUMN2ROW2]*h+l*t.x+i,v=h*u(e[o.COLUMN2ROW1],e[o.COLUMN1ROW2],r.EPSILON15),w=c*(l*u(e[o.COLUMN2ROW0],e[o.COLUMN0ROW2])+t.z),g=[];if(0===w&&0===v){if(f=a.realRoots(d,p,y),0===f.length)return g;var E=f[0],S=Math.sqrt(Math.max(1-E*E,0));if(g.push(new n(l,c*E,c*-S)),g.push(new n(l,c*E,c*S)),2===f.length){var C=f[1],b=Math.sqrt(Math.max(1-C*C,0));g.push(new n(l,c*C,c*-b)),g.push(new n(l,c*C,c*b))}return g}var A=w*w,M=v*v,x=d*d,T=w*v,O=x+M,I=2*(p*d+T),N=2*y*d+p*p-M+A,R=2*(y*p-T),D=y*y-A;if(0===O&&0===I&&0===N&&0===R)return g;f=s.realRoots(O,I,N,R,D);var L=f.length;if(0===L)return g;for(var z=0;L>z;++z){var P,F=f[z],_=F*F,q=Math.max(1-_,0),B=Math.sqrt(q);P=r.sign(d)===r.sign(y)?u(d*_+y,p*F,r.EPSILON12):r.sign(y)===r.sign(p*F)?u(d*_,p*F+y,r.EPSILON12):u(d*_+p*F,y,r.EPSILON12);var U=u(v*F,w,r.EPSILON15),G=P*U;0>G?g.push(new n(l,c*F,c*B)):G>0?g.push(new n(l,c*F,c*-B)):0!==B?(g.push(new n(l,c*F,c*-B)),g.push(new n(l,c*F,c*B)),++z):g.push(new n(l,c*F,c*B))}return g}var c={};c.rayPlane=function(i,o,a){if(!e(i))throw new t("ray is required.");if(!e(o))throw new t("plane is required.");var s=i.origin,u=i.direction,l=o.normal,c=n.dot(l,u);if(Math.abs(c)<r.EPSILON15)return void 0;var f=(-o.distance-n.dot(l,s))/c;return 0>f?void 0:(a=n.multiplyByScalar(u,f,a),n.add(s,a,a))};var f=new n,m=new n;c.rayEllipsoid=function(r,i){if(!e(r))throw new t("ray is required.");if(!e(i))throw new t("ellipsoid is required.");var o,a,s,u,l,c=i.getOneOverRadii(),h=n.multiplyComponents(c,r.origin,f),d=n.multiplyComponents(c,r.direction,m),p=n.magnitudeSquared(h),y=n.dot(h,d);if(p>1){if(y>=0)return void 0;var v=y*y;if(o=p-1,a=n.magnitudeSquared(d),s=a*o,s>v)return void 0;
if(v>s){u=y*y-s,l=-y+Math.sqrt(u);var w=l/a,g=o/l;return g>w?{start:w,stop:g}:{start:g,stop:w}}var E=Math.sqrt(o/a);return{start:E,stop:E}}return 1>p?(o=p-1,a=n.magnitudeSquared(d),s=a*o,u=y*y-s,l=-y+Math.sqrt(u),{start:0,stop:l/a}):0>y?(a=n.magnitudeSquared(d),{start:0,stop:-y/a}):void 0},c.grazingAltitudeLocation=function(a,s){if(!e(a))throw new t("ray is required.");if(!e(s))throw new t("ellipsoid is required.");var u=a.origin,c=a.direction,f=s.geodeticSurfaceNormal(u);if(n.dot(c,f)>=0)return u;var m,h,d=e(this.rayEllipsoid(a,s)),p=s.transformPositionToScaledSpace(c),y=n.normalize(p),v=n.mostOrthogonalAxis(p),w=n.normalize(n.cross(v,y)),g=n.normalize(n.cross(y,w)),E=new o(y.x,w.x,g.x,y.y,w.y,g.y,y.z,w.z,g.z),S=o.transpose(E),C=o.fromScale(s.getRadii()),b=o.fromScale(s.getOneOverRadii()),A=new o(0,c.z,-c.y,-c.z,0,c.x,c.y,-c.x,0),M=o.multiply(o.multiply(S,b),A),x=o.multiply(o.multiply(M,C),E),T=o.multiplyByVector(M,u),O=l(x,n.negate(T),0,0,1),I=O.length;if(I>0){for(var N=n.ZERO,R=Number.NEGATIVE_INFINITY,D=0;I>D;++D){m=o.multiplyByVector(C,o.multiplyByVector(E,O[D]));var L=n.normalize(n.subtract(m,u)),z=n.dot(L,c);z>R&&(R=z,N=m)}var P=s.cartesianToCartographic(N);return R=r.clamp(R,0,1),h=n.magnitude(n.subtract(N,u))*Math.sqrt(1-R*R),h=d?-h:h,s.cartographicToCartesian(new i(P.longitude,P.latitude,h))}return void 0};var h=new n;return c.lineSegmentPlane=function(i,o,a,s){if(!e(i))throw new t("endPoint0 is required.");if(!e(o))throw new t("endPoint1 is required.");if(!e(a))throw new t("plane is required.");var u=n.subtract(o,i,h),l=a.normal,c=n.dot(l,u);if(Math.abs(c)<r.EPSILON6)return void 0;var f=n.dot(l,i),m=-(a.distance+f)/c;return 0>m||m>1?void 0:(e(s)||(s=new n),n.multiplyByScalar(u,m,s),n.add(i,s,s),s)},c.trianglePlaneIntersection=function(r,i,o,a){if(!(e(r)&&e(i)&&e(o)&&e(a)))throw new t("p0, p1, p2, and plane are required.");var s=a.normal,u=a.distance,l=n.dot(s,r)+u<0,f=n.dot(s,i)+u<0,m=n.dot(s,o)+u<0,h=0;h+=l?1:0,h+=f?1:0,h+=m?1:0;var d,p;if((1===h||2===h)&&(d=new n,p=new n),1===h){if(l)return c.lineSegmentPlane(r,i,a,d),c.lineSegmentPlane(r,o,a,p),{positions:[r,i,o,d,p],indices:[0,3,4,1,2,4,1,4,3]};if(f)return c.lineSegmentPlane(i,o,a,d),c.lineSegmentPlane(i,r,a,p),{positions:[r,i,o,d,p],indices:[1,3,4,2,0,4,2,4,3]};if(m)return c.lineSegmentPlane(o,r,a,d),c.lineSegmentPlane(o,i,a,p),{positions:[r,i,o,d,p],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!l)return c.lineSegmentPlane(i,r,a,d),c.lineSegmentPlane(o,r,a,p),{positions:[r,i,o,d,p],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return c.lineSegmentPlane(o,i,a,d),c.lineSegmentPlane(r,i,a,p),{positions:[r,i,o,d,p],indices:[2,0,4,2,4,3,1,3,4]};if(!m)return c.lineSegmentPlane(r,o,a,d),c.lineSegmentPlane(i,o,a,p),{positions:[r,i,o,d,p],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n,i){if(!t(n))throw new r("normal is required.");if(!t(i))throw new r("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,o,a){if(!t(i))throw new r("point is required.");if(!t(o))throw new r("normal is required.");var s=-e.dot(o,i);return t(a)?(e.clone(o,a.normal),a.distance=s,a):new n(o,s)},n.getPointDistance=function(n,i){if(!t(n))throw new r("plane is required.");if(!t(i))throw new r("point is required.");return e.dot(n.normal,i)+n.distance},n.prototype.getPointDistance=function(e){return n.getPointDistance(this,e)},n}),define("Core/PolylinePipeline",["./defaultValue","./defined","./DeveloperError","./Cartographic","./Cartesian3","./Cartesian4","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./Math","./Matrix4","./Plane"],function(e,t,r,n,i,o,a,s,u,l,c,f){"use strict";function m(e,t,r,n){var o=n.scaleToGeodeticSurface(e,x),a=n.scaleToGeodeticSurface(t,T),s=i.angleBetween(o,a),u=Math.ceil(s/r),l=new Array(3*u),c=n.cartesianToCartographic(o,b),f=n.cartesianToCartographic(a,A);O.setEndPoints(c,f);var m=O.getSurfaceDistance()/u,h=0;c.height=0;var d=n.cartographicToCartesian(c,M);l[h++]=d.x,l[h++]=d.y,l[h++]=d.z;for(var p=1;u>p;p++){var y=O.interpolateUsingSurfaceDistance(p*m,A);d=n.cartographicToCartesian(y,M),l[h++]=d.x,l[h++]=d.y,l[h++]=d.z}return l}function h(e,t,r){var n=I;return r.geodeticSurfaceNormal(e,n),i.multiplyByScalar(n,t,n),i.add(e,n,e),e}var d={},p=new c,y=new i,v=new i,w=new f(i.ZERO,0),g=new i,E=new f(i.ZERO,0),S=new i,C=new i,b=new n,A=new n,M=new i,x=new i,T=new i,O=new s,I=new i,N=new i;return d.wrapLongitude=function(r,n){var o=[],a=[];if(t(r)&&r.length>0){n=e(n,c.IDENTITY);var s=c.inverseTransformation(n,p),l=c.multiplyByPoint(s,i.ZERO,y),m=c.multiplyByPointAsVector(s,i.UNIT_Y,v),h=f.fromPointNormal(l,m,w),d=c.multiplyByPointAsVector(s,i.UNIT_X,g),b=f.fromPointNormal(l,d,E),A=1;o.push(i.clone(r[0]));for(var M=o[0],x=r.length,T=1;x>T;++T){var O=r[T];if(f.getPointDistance(b,M)<0||f.getPointDistance(b,O)<0){var I=u.lineSegmentPlane(M,O,h,S);if(t(I)){var N=i.multiplyByScalar(m,5e-9,C);f.getPointDistance(h,M)<0&&i.negate(N,N),o.push(i.add(I,N)),a.push(A+1),i.negate(N,N),o.push(i.add(I,N)),A=1}}o.push(i.clone(r[T])),A++,M=O}a.push(A)}return{positions:o,lengths:a}},d.removeDuplicates=function(e){if(!t(e))throw new r("positions is required.");var n=e.length;if(2>n)return e.slice(0);var o=[];o.push(e[0]);for(var a=1;n>a;++a){var s=e[a-1],u=e[a];i.equals(s,u)||o.push(u)}return o},d.scaleToSurface=function(n,i,o){if(!t(n))throw new r("positions is required");i=e(i,l.RADIANS_PER_DEGREE),o=e(o,a.WGS84);for(var s=n.length,u=[],c=0;s-1>c;c++){var f=n[c],h=n[c+1];u=u.concat(m(f,h,i,o))}var d=n[s-1],p=o.cartesianToCartographic(d,b);p.height=0;var y=o.cartographicToCartesian(p,M);return u.push(y.x,y.y,y.z),u},d.scaleToGeodeticHeight=function(n,o,s,u){if(!t(n))throw new r("positions must be defined.");if(!t(o))throw new r("height must be defined");s=e(s,a.WGS84);var l,c,f=n.length,m=N;if(t(u)){if(u.length!==n.length)throw new r("result.length must be equal to positions.length");c=u}else c=new Array(n.length);if(0===o){for(l=0;f>l;l+=3)m=s.scaleToGeodeticSurface(i.fromArray(n,l,m),m),c[l]=m.x,c[l+1]=m.y,c[l+2]=m.z;return c}var d;if(Array.isArray(o)){if(o.length!==f/3)throw new r("height.length must be equal to positions.length");for(l=0;f>l;l+=3)d=o[l/3],m=i.fromArray(n,l,m),m=h(m,d,s),c[l]=m.x,c[l+1]=m.y,c[l+2]=m.z}else for(d=o,l=0;f>l;l+=3)m=i.fromArray(n,l,m),m=h(m,d,s),c[l]=m.x,c[l+1]=m.y,c[l+2]=m.z;return c},d}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,t){"use strict";var r=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1)};return r.POSITION_ONLY=t(new r({position:!0})),r.POSITION_AND_NORMAL=t(new r({position:!0,normal:!0})),r.POSITION_NORMAL_AND_ST=t(new r({position:!0,normal:!0,st:!0})),r.POSITION_AND_ST=t(new r({position:!0,st:!0})),r.ALL=t(new r({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),r.DEFAULT=r.POSITION_NORMAL_AND_ST,r}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./BoundingSphere"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.attributes))throw new r("options.attributes is required.");if(!t(n.primitiveType))throw new r("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=a}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/Color",["./defaultValue","./defined","./freezeObject","./DeveloperError","./FeatureDetection","./Math"],function(e,t,r,n,i,o){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+6*(t-e)*(2/3-r):e}var s=function(t,r,n,i){this.red=e(t,1),this.green=e(r,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromBytes=function(t,r,n,i){return t=s.byteToFloat(e(t,255)),r=s.byteToFloat(e(r,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),new s(t,r,n,i)};var u,l,c;i.supportsTypedArrays()&&(u=new ArrayBuffer(4),l=new Uint32Array(u),c=new Uint8Array(u)),s.fromRgba=function(e){return l[0]=e,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(t,r,n,i){t=e(t,0)%1,r=e(r,0),n=e(n,0),i=e(i,1);var o=n,u=n,l=n;if(0!==r){var c;c=.5>n?n*(1+r):n+r-n*r;var f=2*n-c;o=a(f,c,t+1/3),u=a(f,c,t),l=a(f,c,t-1/3)}return new s(o,u,l,i)},s.fromRandom=function(r,i){r=e(r,e.EMPTY_OBJECT);var a=r.red;if(!t(a)){var u=e(r.minimumRed,0),l=e(r.maximumRed,1);if(u>l)throw new n("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(l-u)}var c=r.green;if(!t(c)){var f=e(r.minimumGreen,0),m=e(r.maximumGreen,1);if(f>m)throw new n("minimumGreen must be less than or equal to maximumGreen");c=f+o.nextRandomNumber()*(m-f)}var h=r.blue;if(!t(h)){var d=e(r.minimumBlue,0),p=e(r.maximumBlue,1);if(d>p)throw new n("minimumBlue must be less than or equal to maximumBlue");h=d+o.nextRandomNumber()*(p-d)}var y=r.alpha;if(!t(y)){var v=e(r.minimumAlpha,0),w=e(r.maximumAlpha,1);if(v>w)throw new n("minimumAlpha must be less than or equal to maximumAlpha");y=v+o.nextRandomNumber()*(w-v)}return t(i)?(i.red=a,i.green=c,i.blue=h,i.alpha=y,i):new s(a,c,h,y)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,m=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,h=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,d=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){if(!t(r))throw new n("color is required");var i=s[r.toUpperCase()];if(t(i))return s.clone(i);var o=f.exec(r);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=m.exec(r),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=h.exec(r),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=d.exec(r),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(r,i,o){if(!t(r))throw new n("value is required");if(!t(i))throw new n("array is required");o=e(o,0),i[o++]=r.red,i[o++]=r.green,i[o++]=r.blue,i[o]=r.alpha},s.unpack=function(r,i,o){if(!t(r))throw new n("array is required");return i=e(i,0),t(o)||(o=new s),o.red=r[i++],o.green=r[i++],o.blue=r[i++],o.alpha=r[i],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var r=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=n,e[2]=i,e[3]=o,e):[r,n,i,o]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),l[0]},s.ALICEBLUE=r(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=r(s.fromCssColorString("#FAEBD7")),s.AQUA=r(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=r(s.fromCssColorString("#7FFFD4")),s.AZURE=r(s.fromCssColorString("#F0FFFF")),s.BEIGE=r(s.fromCssColorString("#F5F5DC")),s.BISQUE=r(s.fromCssColorString("#FFE4C4")),s.BLACK=r(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=r(s.fromCssColorString("#FFEBCD")),s.BLUE=r(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=r(s.fromCssColorString("#8A2BE2")),s.BROWN=r(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=r(s.fromCssColorString("#DEB887")),s.CADETBLUE=r(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=r(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=r(s.fromCssColorString("#D2691E")),s.CORAL=r(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=r(s.fromCssColorString("#6495ED")),s.CORNSILK=r(s.fromCssColorString("#FFF8DC")),s.CRIMSON=r(s.fromCssColorString("#DC143C")),s.CYAN=r(s.fromCssColorString("#00FFFF")),s.DARKBLUE=r(s.fromCssColorString("#00008B")),s.DARKCYAN=r(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=r(s.fromCssColorString("#B8860B")),s.DARKGRAY=r(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=r(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=r(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=r(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=r(s.fromCssColorString("#556B2F")),s.DARKORANGE=r(s.fromCssColorString("#FF8C00")),s.DARKORCHID=r(s.fromCssColorString("#9932CC")),s.DARKRED=r(s.fromCssColorString("#8B0000")),s.DARKSALMON=r(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=r(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=r(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=r(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=r(s.fromCssColorString("#00CED1")),s.DARKVIOLET=r(s.fromCssColorString("#9400D3")),s.DEEPPINK=r(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=r(s.fromCssColorString("#00BFFF")),s.DIMGRAY=r(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=r(s.fromCssColorString("#1E90FF")),s.FIREBRICK=r(s.fromCssColorString("#B22222")),s.FLORALWHITE=r(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=r(s.fromCssColorString("#228B22")),s.FUSCHIA=r(s.fromCssColorString("#FF00FF")),s.GAINSBORO=r(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=r(s.fromCssColorString("#F8F8FF")),s.GOLD=r(s.fromCssColorString("#FFD700")),s.GOLDENROD=r(s.fromCssColorString("#DAA520")),s.GRAY=r(s.fromCssColorString("#808080")),s.GREEN=r(s.fromCssColorString("#008000")),s.GREENYELLOW=r(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=r(s.fromCssColorString("#F0FFF0")),s.HOTPINK=r(s.fromCssColorString("#FF69B4")),s.INDIANRED=r(s.fromCssColorString("#CD5C5C")),s.INDIGO=r(s.fromCssColorString("#4B0082")),s.IVORY=r(s.fromCssColorString("#FFFFF0")),s.KHAKI=r(s.fromCssColorString("#F0E68C")),s.LAVENDER=r(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=r(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=r(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=r(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=r(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=r(s.fromCssColorString("#F08080")),s.LIGHTCYAN=r(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=r(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=r(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=r(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=r(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=r(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=r(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=r(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=r(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=r(s.fromCssColorString("#FFFFE0")),s.LIME=r(s.fromCssColorString("#00FF00")),s.LIMEGREEN=r(s.fromCssColorString("#32CD32")),s.LINEN=r(s.fromCssColorString("#FAF0E6")),s.MAGENTA=r(s.fromCssColorString("#FF00FF")),s.MAROON=r(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=r(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=r(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=r(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=r(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=r(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=r(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=r(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=r(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=r(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=r(s.fromCssColorString("#191970")),s.MINTCREAM=r(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=r(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=r(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=r(s.fromCssColorString("#FFDEAD")),s.NAVY=r(s.fromCssColorString("#000080")),s.OLDLACE=r(s.fromCssColorString("#FDF5E6")),s.OLIVE=r(s.fromCssColorString("#808000")),s.OLIVEDRAB=r(s.fromCssColorString("#6B8E23")),s.ORANGE=r(s.fromCssColorString("#FFA500")),s.ORANGERED=r(s.fromCssColorString("#FF4500")),s.ORCHID=r(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=r(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=r(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=r(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=r(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=r(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=r(s.fromCssColorString("#FFDAB9")),s.PERU=r(s.fromCssColorString("#CD853F")),s.PINK=r(s.fromCssColorString("#FFC0CB")),s.PLUM=r(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=r(s.fromCssColorString("#B0E0E6")),s.PURPLE=r(s.fromCssColorString("#800080")),s.RED=r(s.fromCssColorString("#FF0000")),s.ROSYBROWN=r(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=r(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=r(s.fromCssColorString("#8B4513")),s.SALMON=r(s.fromCssColorString("#FA8072")),s.SANDYBROWN=r(s.fromCssColorString("#F4A460")),s.SEAGREEN=r(s.fromCssColorString("#2E8B57")),s.SEASHELL=r(s.fromCssColorString("#FFF5EE")),s.SIENNA=r(s.fromCssColorString("#A0522D")),s.SILVER=r(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=r(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=r(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=r(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=r(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=r(s.fromCssColorString("#00FF7F")),s.STEELBLUE=r(s.fromCssColorString("#4682B4")),s.TAN=r(s.fromCssColorString("#D2B48C")),s.TEAL=r(s.fromCssColorString("#008080")),s.THISTLE=r(s.fromCssColorString("#D8BFD8")),s.TOMATO=r(s.fromCssColorString("#FF6347")),s.TURQUOISE=r(s.fromCssColorString("#40E0D0")),s.VIOLET=r(s.fromCssColorString("#EE82EE")),s.WHEAT=r(s.fromCssColorString("#F5DEB3")),s.WHITE=r(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=r(s.fromCssColorString("#F5F5F5")),s.YELLOW=r(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=r(s.fromCssColorString("#9ACD32")),s}),define("Core/PolylineGeometry",["./defined","./DeveloperError","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./defaultValue","./BoundingSphere","./Cartesian3","./PolylinePipeline","./VertexFormat","./Geometry","./GeometryAttribute","./GeometryAttributes","./Color"],function(e,t,r,n,i,o,a,s,u,l,c,f,m,h){"use strict";var d=function(r){r=o(r,o.EMPTY_OBJECT);var n=r.positions,i=r.colors,a=o(r.width,1),s=o(r.colorsPerVertex,!1);if(!e(n)||n.length<2)throw new t("At least two positions are required.");if(1>a)throw new t("width must be greater than or equal to one.");if(e(i)&&(s&&i.length<n.length||!s&&i.length<n.length-1))throw new t("colors has an invalid length.");this._positions=n,this._colors=i,this._width=a,this._perVertex=s,this._vertexFormat=o(r.vertexFormat,l.DEFAULT),this._workerName="createPolylineGeometry"},p=new s,y=new s,v=new s,w=new s;return d.createGeometry=function(t){var o,l,d,g=t._width,E=t._vertexFormat,S=t._colors,C=t._perVertex,b=u.wrapLongitude(t._positions),A=b.positions,M=b.lengths,x=0,T=M.length;for(o=0;T>o;++o)x+=4*M[o]-4;var O,I,N=new Float64Array(3*x),R=new Float64Array(3*x),D=new Float64Array(3*x),L=new Float32Array(2*x),z=E.st?new Float32Array(2*x):void 0,P=e(S)?new Uint8Array(4*x):void 0,F=0,_=0,q=0,B=0,U=0,G=0,Y=A.length;for(l=0;Y>l;++l){0===l?(I=p,s.subtract(A[0],A[1],I),s.add(A[0],I,I)):I=A[l-1],s.clone(I,v),s.clone(A[l],y),l===Y-1?(I=p,s.subtract(A[Y-1],A[Y-2],I),s.add(A[Y-1],I,I)):I=A[l+1],s.clone(I,w),O=M[U],l===G+O&&(G+=O,++U);var W,V,H=0===l-G,k=l===G+M[U]-1,K=H?2:0,j=k?2:4;if(e(P)){var Z=l-U;W=H||C?S[Z]:S[Z-1],k||(V=S[Z])}for(d=K;j>d;++d){s.pack(y,N,F),s.pack(v,R,F),s.pack(w,D,F),F+=3;var Q=0>d-2?-1:1;if(L[_++]=2*(d%2)-1,L[_++]=Q*g,E.st&&(z[q++]=l/(Y-1),z[q++]=Math.max(L[_-2],0)),e(P)){var X=2>d?W:V;P[B++]=h.floatToByte(X.red),P[B++]=h.floatToByte(X.green),P[B++]=h.floatToByte(X.blue),P[B++]=h.floatToByte(X.alpha)}}}var J=new m;J.position=new f({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:N}),J.prevPosition=new f({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:R}),J.nextPosition=new f({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:D}),J.expandAndWidth=new f({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:L}),E.st&&(J.st=new f({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:z})),e(P)&&(J.color=new f({componentDatatype:r.UNSIGNED_BYTE,componentsPerAttribute:4,values:P,normalize:!0})),T=M.length;var $=n.createTypedArray(x,6*A.length-6*T),et=0,tt=0;for(o=0;T>o;++o)for(O=M[o]-1,l=0;O>l;++l)$[tt++]=et,$[tt++]=et+2,$[tt++]=et+1,$[tt++]=et+1,$[tt++]=et+2,$[tt++]=et+3,et+=4;return new c({attributes:J,indices:$,primitiveType:i.TRIANGLES,boundingSphere:a.fromPoints(A)})},d}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r):new i(e.x/n,e.y/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n):new i(e.x*r.x,e.y*r.y)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n):new i(e.x+r.x,e.y+r.y)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n):new i(e.x-r.x,e.y-r.y)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n):new i(e.x*r,e.y*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n):new i(e.x/r,e.y/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r):new i(-e.x,-e.y)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r):new i(Math.abs(e.x),Math.abs(e.y))};var a=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,a),n=i.multiplyByScalar(e,1-r,n),i.add(a,n,n)};var s=new i,u=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,u),Math.acos(i.dot(s,u))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i=new t,o=new t,a=new t,s=function(s,u,l,c,f){if(!(r(s)&&r(u)&&r(l)&&r(c)))throw new n("point, p0, p1, and p2 are required.");r(f)||(f=new t);var m,h,d,p,y,v,w,g;r(u.z)?(m=t.subtract(l,u,i),h=t.subtract(c,u,o),d=t.subtract(s,u,a),p=t.dot(m,m),y=t.dot(m,h),v=t.dot(m,d),w=t.dot(h,h),g=t.dot(h,d)):(m=e.subtract(l,u,i),h=e.subtract(c,u,o),d=e.subtract(s,u,a),p=e.dot(m,m),y=e.dot(m,h),v=e.dot(m,d),w=e.dot(h,h),g=e.dot(h,d));var E=1/(p*w-y*y);return f.y=(w*v-y*g)*E,f.z=(p*g-y*v)*E,f.x=1-f.y-f.z,f};return s}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!t(e))throw new r("value is required");t(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){if(!t(e))throw new r("cartesian is required");t(o)||(o=new n);var a=o.high,s=o.low;return n.encode(e.x,i),a.x=i.high,s.x=i.low,n.encode(e.y,i),a.y=i.high,s.y=i.low,n.encode(e.z,i),a.z=i.high,s.z=i.low,o};var o=new n;return n.writeElements=function(e,i,a){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("cartesianArray is required");if("number"!=typeof a||0>a)throw new r("index must be a number greater than or equal to 0.");n.fromCartesian(e,o);var s=o.high,u=o.low;i[a]=s.x,i[a+1]=s.y,i[a+2]=s.z,i[a+3]=u.x,i[a+4]=u.y,i[a+5]=u.z},n}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var s=i.length;if(3>s||0!==s%3)throw new r("indices length must be a multiple of three.");if(0>=o)throw new r("maximumIndex must be greater than zero.");if(3>a)throw new r("cacheSize must be greater than two.");if(!t(o)){o=0;for(var u=0,l=i[u];s>u;)l>o&&(o=l),++u,l=i[u]}for(var c=[],f=0;o+1>f;f++)c[f]=0;for(var m=a+1,h=0;s>h;++h)m-c[i[h]]>a&&(c[i[h]]=m,++m);return(m-a+1)/(s/3)},n.tipsify=function(n){function i(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,t,r,n,o,a,s){for(var u,l=-1,c=-1,f=0;f<r.length;){var m=r[f];n[m].numLiveTriangles&&(u=0,o-n[m].timeStamp+2*n[m].numLiveTriangles<=t&&(u=o-n[m].timeStamp),(u>c||-1===c)&&(c=u,l=m)),++f}return-1===l?i(n,a,e,s):l}n=e(n,e.EMPTY_OBJECT);var a,s=n.indices,u=n.maximumIndex,l=e(n.cacheSize,24);if(!t(s))throw new r("indices is required.");var c=s.length;if(3>c||0!==c%3)throw new r("indices length must be a multiple of three.");if(0>=u)throw new r("maximumIndex must be greater than zero.");if(3>l)throw new r("cacheSize must be greater than two.");var f=0,m=0,h=s[m],d=c;if(t(u))f=u+1;else{for(;d>m;)h>f&&(f=h),++m,h=s[m];if(-1===f)return 0;++f}for(var p=[],y=0;f>y;y++)p[y]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};m=0;for(var v=0;d>m;)p[s[m]].vertexTriangles.push(v),++p[s[m]].numLiveTriangles,p[s[m+1]].vertexTriangles.push(v),++p[s[m+1]].numLiveTriangles,p[s[m+2]].vertexTriangles.push(v),++p[s[m+2]].numLiveTriangles,++v,m+=3;var w=0,g=l+1;a=1;var E,S,C=[],b=[],A=0,M=[],x=c/3,T=[];for(y=0;x>y;y++)T[y]=!1;for(var O,I;-1!==w;){C=[],S=p[w],I=S.vertexTriangles.length;for(var N=0;I>N;++N)if(v=S.vertexTriangles[N],!T[v]){T[v]=!0,m=v+v+v;for(var R=0;3>R;++R)O=s[m],C.push(O),b.push(O),M[A]=O,++A,E=p[O],--E.numLiveTriangles,g-E.timeStamp>l&&(E.timeStamp=g,++g),++m}w=o(s,l,C,p,g,b,f)}return M},n}),define("Core/GeometryPipeline",["./barycentricCoordinates","./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./EncodedCartesian3","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./GeographicProjection","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./Tipsify","./BoundingSphere","./Geometry","./GeometryAttribute"],function(e,t,r,n,i,o,a,s,u,l,c,f,m,h,d,p,y,v,w,g,E,S,C){"use strict";function b(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function A(e){for(var t=e.length,r=6*(t/3),n=v.createTypedArray(t,r),i=0,o=0;t>o;o+=3,i+=6)b(n,i,e[o],e[o+1],e[o+2]);return n}function M(e){var t=e.length;if(t>=3){var r=6*(t-2),n=v.createTypedArray(t,r);b(n,0,e[0],e[1],e[2]);for(var i=6,o=3;t>o;++o,i+=6)b(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function x(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=v.createTypedArray(t,r),i=e[0],o=0,a=1;t>a;++a,o+=6)b(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}function T(e){var t={};for(var n in e)if(e.hasOwnProperty(n)&&r(e[n])&&r(e[n].values)){var i=e[n];t[n]=new C({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function O(e,t,n){for(var i in t)if(t.hasOwnProperty(i)&&r(t[i])&&r(t[i].values))for(var o=t[i],a=0;a<o.componentsPerAttribute;++a)e[i].values.push(o.values[n*o.componentsPerAttribute+a])}function I(e,t){if(r(t))for(var n=t.values,i=n.length,a=0;i>a;a+=3)o.unpack(n,a,Z),h.multiplyByPoint(e,Z,Z),o.pack(Z,n,a)}function N(e,t){if(r(t))for(var n=t.values,i=n.length,a=0;i>a;a+=3)o.unpack(n,a,Z),m.multiplyByVector(e,Z,Z),Z=o.normalize(Z,Z),o.pack(Z,n,a)}function R(e){var t,n=e.length,i={},o=e[0].geometry.attributes;for(t in o)if(o.hasOwnProperty(t)&&r(o[t])&&r(o[t].values)){for(var a=o[t],s=a.values.length,u=!0,l=1;n>l;++l){var c=e[l].geometry.attributes[t];if(!r(c)||a.componentDatatype.value!==c.componentDatatype.value||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){u=!1;break}s+=c.values.length}u&&(i[t]=new C({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:y.createTypedArray(a.componentDatatype,s)}))}return i}function D(e){if(r(e.indices))return e;var t=S.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least three.");if(0!==t%3)throw new n("The number of vertices must be a multiple of three.");for(var i=v.createTypedArray(t,t),o=0;t>o;++o)i[o]=o;return e.indices=i,e}function L(e){var t=S.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least three.");var r=v.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var i=3,o=3;t>o;++o)r[i++]=o-1,r[i++]=0,r[i++]=o;return e.indices=r,e.primitiveType=w.TRIANGLES,e}function z(e){var t=S.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least 3.");
var r=v.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var i=6,o=3;t-1>o;o+=2)r[i++]=o,r[i++]=o-1,r[i++]=o+1,t>o+2&&(r[i++]=o,r[i++]=o+1,r[i++]=o+2);return e.indices=r,e.primitiveType=w.TRIANGLES,e}function P(e){if(r(e.indices))return e;var t=S.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");if(0!==t%2)throw new n("The number of vertices must be a multiple of 2.");for(var i=v.createTypedArray(t,t),o=0;t>o;++o)i[o]=o;return e.indices=i,e}function F(e){var t=S.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");var r=v.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var i=2,o=2;t>o;++o)r[i++]=o-1,r[i++]=o;return e.indices=r,e.primitiveType=w.LINES,e}function _(e){var t=S.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");var r=v.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var i=2,o=2;t>o;++o)r[i++]=o-1,r[i++]=o;return r[i++]=t-1,r[i]=0,e.indices=r,e.primitiveType=w.LINES,e}function q(e){switch(e.primitiveType){case w.TRIANGLE_FAN:return L(e);case w.TRIANGLE_STRIP:return z(e);case w.TRIANGLES:return D(e);case w.LINE_STRIP:return F(e);case w.LINE_LOOP:return _(e);case w.LINES:return P(e)}return e}function B(e,t){Math.abs(e.y)<f.EPSILON11&&(e.y=t?-f.EPSILON11:f.EPSILON11)}function U(e,t,r,n){o.add(e,o.multiplyByScalar(o.subtract(t,e,ot),e.y/(e.y-t.y),ot),r),o.clone(r,n),B(r,!0),B(n,!1)}function G(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;var n=e.y<0,i=t.y<0,o=r.y<0;B(e,n),B(t,i),B(r,o);var a=0;a+=n?1:0,a+=i?1:0,a+=o?1:0;var s=ct.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(U(e,t,at,ut),U(e,r,st,lt),s[0]=0,s[3]=1,s[4]=2,s[6]=1):i?(U(t,r,at,ut),U(t,e,st,lt),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(U(r,e,at,ut),U(r,t,st,lt),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?i?o||(U(r,e,at,ut),U(r,t,st,lt),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(U(t,r,at,ut),U(t,e,st,lt),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(U(e,t,at,ut),U(e,r,st,lt),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=ct.positions;return u[0]=e,u[1]=t,u[2]=r,ct.length=3,(1===a||2===a)&&(u[3]=at,u[4]=st,u[5]=ut,u[6]=lt,ct.length=7),ct}function Y(t,n,a,s,u,l,c,f){if(r(u)||r(l)||r(c)||r(f)){var m,h,d,p,y,v,w,g,E,S,C,b,A,M,x,T,O,I,N=s.positions,R=N[0],D=N[1],L=N[2];r(u)&&(m=o.fromArray(u,3*t),h=o.fromArray(u,3*n),d=o.fromArray(u,3*a)),r(l)&&(p=o.fromArray(l,3*t),y=o.fromArray(l,3*n),v=o.fromArray(l,3*a)),r(c)&&(w=o.fromArray(c,3*t),g=o.fromArray(c,3*n),E=o.fromArray(c,3*a)),r(f)&&(S=i.fromArray(f,2*t),C=i.fromArray(f,2*n),b=i.fromArray(f,2*a));for(var z=3;z<N.length;++z){var P=N[z],F=e(P,R,D,L);if(r(u)){A=o.multiplyByScalar(m,F.x,A),M=o.multiplyByScalar(h,F.y,M),x=o.multiplyByScalar(d,F.z,x);var _=o.add(A,M);o.add(_,x,_),o.normalize(_,_),u.push(_.x,_.y,_.z)}if(r(l)){A=o.multiplyByScalar(p,F.x,A),M=o.multiplyByScalar(y,F.y,M),x=o.multiplyByScalar(v,F.z,x);var q=o.add(A,M);o.add(q,x,q),o.normalize(q,q),l.push(q.x,q.y,q.z)}if(r(c)){A=o.multiplyByScalar(w,F.x,A),M=o.multiplyByScalar(g,F.y,M),x=o.multiplyByScalar(E,F.z,x);var B=o.add(A,M);o.add(B,x,B),o.normalize(B,B),c.push(B.x,B.y,B.z)}if(r(f)){T=i.multiplyByScalar(S,F.x,T),O=i.multiplyByScalar(C,F.y,O),I=i.multiplyByScalar(b,F.z,I);var U=i.add(T,O);i.add(U,I,U),f.push(U.x,U.y)}}}}function W(e){for(var t=e.attributes,n=t.position.values,i=r(t.normal)?t.normal.values:void 0,a=r(t.binormal)?t.binormal.values:void 0,s=r(t.tangent)?t.tangent.values:void 0,u=r(t.st)?t.st.values:void 0,l=e.indices,c=Array.prototype.slice.call(n,0),f=r(i)?Array.prototype.slice.call(i,0):void 0,m=r(a)?Array.prototype.slice.call(a,0):void 0,h=r(s)?Array.prototype.slice.call(s,0):void 0,d=r(u)?Array.prototype.slice.call(u,0):void 0,p=[],w=l.length,g=0;w>g;g+=3){var E=l[g],C=l[g+1],b=l[g+2],A=o.fromArray(n,3*E),M=o.fromArray(n,3*C),x=o.fromArray(n,3*b),T=G(A,M,x);if(r(T))if(c[3*E+1]=T.positions[0].y,c[3*C+1]=T.positions[1].y,c[3*b+1]=T.positions[2].y,T.length>3){for(var O=c.length/3,I=0;I<T.indices.length;++I){var N=T.indices[I];3>N?p.push(l[g+N]):p.push(N-3+O)}for(var R=3;R<T.positions.length;++R){var D=T.positions[R];c.push(D.x,D.y,D.z)}Y(E,C,b,T,f,m,h,d)}else p.push(E,C,b);else p.push(E,C,b)}e.attributes.position.values=new Float64Array(c),r(f)&&(t.normal.values=y.createTypedArray(t.normal.componentDatatype,f)),r(m)&&(t.binormal.values=y.createTypedArray(t.binormal.componentDatatype,m)),r(h)&&(t.tangent.values=y.createTypedArray(t.tangent.componentDatatype,h)),r(d)&&(t.st.values=y.createTypedArray(t.st.componentDatatype,d));var L=S.computeNumberOfVertices(e);e.indices=v.createTypedArray(L,p)}function V(e){for(var t=e.attributes,n=t.position.values,i=e.indices,a=Array.prototype.slice.call(n,0),s=[],u=d.fromPointNormal(o.ZERO,o.UNIT_Y),l=i.length,m=0;l>m;m+=2){var h=i[m],p=i[m+1],y=o.fromArray(n,3*h),w=o.fromArray(n,3*p);if(Math.abs(y.y)<f.EPSILON6&&(y.y=y.y<0?-f.EPSILON6:f.EPSILON6,a[3*h+1]=y.y),Math.abs(w.y)<f.EPSILON6&&(w.y=w.y<0?-f.EPSILON6:f.EPSILON6,a[3*p+1]=w.y),s.push(h),y.x<0||w.x<0){var g=c.lineSegmentPlane(y,w,u);if(r(g)){var E=o.multiplyByScalar(o.UNIT_Y,5*f.EPSILON9);y.y<0&&o.negate(E,E);var C=a.length/3;s.push(C,C+1);var b=o.add(g,E);a.push(b.x,b.y,b.z),o.negate(E,E),o.add(g,E,b),a.push(b.x,b.y,b.z)}}s.push(p)}e.attributes.position.values=new Float64Array(a);var A=S.computeNumberOfVertices(e);e.indices=v.createTypedArray(A,s)}var H={};H.toWireframe=function(e){if(!r(e))throw new n("geometry is required.");var t=e.indices;if(r(t)){switch(e.primitiveType){case w.TRIANGLES:e.indices=A(t);break;case w.TRIANGLE_STRIP:e.indices=M(t);break;case w.TRIANGLE_FAN:e.indices=x(t);break;default:throw new n("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=w.LINES}return e},H.createLineSegmentsForVectors=function(e,i,o){if(!r(e))throw new n("geometry is required.");if(!r(e.attributes.position))throw new n("geometry.attributes.position is required.");if(i=t(i,"normal"),!r(e.attributes[i]))throw new n("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+i+".");o=t(o,1e4);for(var a=e.attributes.position.values,s=e.attributes[i].values,u=a.length,l=new Float64Array(2*u),c=0,f=0;u>f;f+=3)l[c++]=a[f],l[c++]=a[f+1],l[c++]=a[f+2],l[c++]=a[f]+s[f]*o,l[c++]=a[f+1]+s[f+1]*o,l[c++]=a[f+2]+s[f+2]*o;var m,h=e.boundingSphere;return r(h)&&(m=new E(h.center,h.radius+o)),new S({attributes:{position:new C({componentDatatype:y.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:w.LINES,boundingSphere:m})},H.createAttributeIndices=function(e){if(!r(e))throw new n("geometry is required.");var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],o=e.attributes,a={},s=0,u=i.length;for(t=0;u>t;++t){var l=i[t];r(o[l])&&(a[l]=s++)}for(var c in o)o.hasOwnProperty(c)&&!r(a[c])&&(a[c]=s++);return a},H.reorderForPreVertexCache=function(e){if(!r(e))throw new n("geometry is required.");var t=S.computeNumberOfVertices(e),i=e.indices;if(r(i)){for(var o=new Int32Array(t),a=0;t>a;a++)o[a]=-1;for(var s,u=i,l=u.length,c=v.createTypedArray(t,l),f=0,m=0,h=0;l>f;)s=o[u[f]],-1!==s?c[m]=s:(s=u[f],o[s]=h,c[m]=h,++h),++f,++m;e.indices=c;var d=e.attributes;for(var p in d)if(d.hasOwnProperty(p)&&r(d[p])&&r(d[p].values)){for(var w=d[p],g=w.values,E=0,C=w.componentsPerAttribute,b=y.createTypedArray(w.componentDatatype,h*C);t>E;){var A=o[E];if(-1!==A)for(a=0;C>a;a++)b[C*A+a]=g[C*E+a];++E}w.values=b}}return e},H.reorderForPostVertexCache=function(e,t){if(!r(e))throw new n("geometry is required.");var i=e.indices;if(e.primitiveType===w.TRIANGLES&&r(i)){for(var o=i.length,a=0,s=0;o>s;s++)i[s]>a&&(a=i[s]);e.indices=g.tipsify({indices:i,maximumIndex:a,cacheSize:t})}return e},H.fitToUnsignedShortIndices=function(e){if(!r(e))throw new n("geometry is required.");if(r(e.indices)&&e.primitiveType!==w.TRIANGLES&&e.primitiveType!==w.LINES&&e.primitiveType!==w.POINTS)throw new n("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],i=S.computeNumberOfVertices(e);if(r(e.indices)&&i>f.SIXTY_FOUR_KILOBYTES){var o,a=[],s=[],u=0,l=T(e.attributes),c=e.indices,m=c.length;e.primitiveType===w.TRIANGLES?o=3:e.primitiveType===w.LINES?o=2:e.primitiveType===w.POINTS&&(o=1);for(var h=0;m>h;h+=o){for(var d=0;o>d;++d){var p=c[h+d],y=a[p];r(y)||(y=u++,a[p]=y,O(l,e.attributes,p)),s.push(y)}u+o>f.SIXTY_FOUR_KILOBYTES&&(t.push(new S({attributes:l,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),a=[],s=[],u=0,l=T(e.attributes))}0!==s.length&&t.push(new S({attributes:l,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else t.push(e);return t};var k=new o,K=new s;H.projectTo2D=function(e,t,i,a,s){if(!r(e))throw new n("geometry is required.");if(!r(t))throw new n("attributeName is required.");if(!r(i))throw new n("attributeName3D is required.");if(!r(a))throw new n("attributeName2D is required.");var u=e.attributes[t];if(!r(u))throw new n("geometry must have attribute matching the attributeName argument: "+t+".");if(u.componentDatatype.value!==y.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");s=r(s)?s:new p;for(var l=s.getEllipsoid(),c=u.values,f=new Float64Array(c.length),m=0,h=0;h<c.length;h+=3){var d=o.fromArray(c,h,k),v=l.cartesianToCartographic(d,K);if(!r(v))throw new n("Could not project point ("+d.x+", "+d.y+", "+d.z+") to 2D.");var w=s.project(v,k);f[m++]=w.x,f[m++]=w.y,f[m++]=w.z}return e.attributes[i]=u,e.attributes[a]=new C({componentDatatype:y.DOUBLE,componentsPerAttribute:3,values:f}),delete e.attributes[t],e};var j={high:0,low:0};H.encodeAttribute=function(e,t,i,o){if(!r(e))throw new n("geometry is required.");if(!r(t))throw new n("attributeName is required.");if(!r(i))throw new n("attributeHighName is required.");if(!r(o))throw new n("attributeLowName is required.");var a=e.attributes[t];if(!r(a))throw new n("geometry must have attribute matching the attributeName argument: "+t+".");if(a.componentDatatype.value!==y.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var s=a.values,l=s.length,c=new Float32Array(l),f=new Float32Array(l),m=0;l>m;++m)u.encode(s[m],j),c[m]=j.high,f[m]=j.low;var h=a.componentsPerAttribute;return e.attributes[i]=new C({componentDatatype:y.FLOAT,componentsPerAttribute:h,values:c}),e.attributes[o]=new C({componentDatatype:y.FLOAT,componentsPerAttribute:h,values:f}),delete e.attributes[t],e};var Z=new o,Q=new h,X=new m;H.transformToWorldCoordinates=function(e){if(!r(e))throw new n("instance is required.");var t=e.modelMatrix;if(h.equals(t,h.IDENTITY))return e;var i=e.geometry.attributes;I(t,i.position),I(t,i.prevPosition),I(t,i.nextPosition),(r(i.normal)||r(i.binormal)||r(i.tangent))&&(h.inverse(t,Q),h.transpose(Q,Q),h.getRotation(Q,X),N(X,i.normal),N(X,i.binormal),N(X,i.tangent));var o=e.geometry.boundingSphere;return r(o)&&(e.geometry.boundingSphere=E.transform(o,t,o)),e.modelMatrix=h.clone(h.IDENTITY),e},H.combine=function(e){if(!r(e)||e.length<1)throw new n("instances is required and must have length greater than zero.");var t,i,a,s,u=e.length,l=e[0].modelMatrix,c=r(e[0].geometry.indices),f=e[0].geometry.primitiveType;for(i=1;u>i;++i){if(!h.equals(e[i].modelMatrix,l))throw new n("All instances must have the same modelMatrix.");if(r(e[i].geometry.indices)!==c)throw new n("All instance geometries must have an indices or not have one.");if(e[i].geometry.primitiveType!==f)throw new n("All instance geometries must have the same primitiveType.")}var m,d,p,y=R(e);for(t in y)if(y.hasOwnProperty(t))for(m=y[t].values,s=0,i=0;u>i;++i)for(d=e[i].geometry.attributes[t].values,p=d.length,a=0;p>a;++a)m[s++]=d[a];var g;if(c){var C=0;for(i=0;u>i;++i)C+=e[i].geometry.indices.length;var b=S.computeNumberOfVertices(new S({attributes:y,primitiveType:w.POINTS})),A=v.createTypedArray(b,C),M=0,x=0;for(i=0;u>i;++i){var T=e[i].geometry.indices,O=T.length;for(s=0;O>s;++s)A[M++]=x+T[s];x+=S.computeNumberOfVertices(e[i].geometry)}g=A}var I,N=new o,D=0;for(i=0;u>i;++i){if(I=e[i].geometry.boundingSphere,!r(I)){N=void 0;break}o.add(I.center,N,N)}if(r(N))for(o.divideByScalar(N,u,N),i=0;u>i;++i){I=e[i].geometry.boundingSphere;var L=o.magnitude(o.subtract(I.center,N))+I.radius;L>D&&(D=L)}return new S({attributes:y,indices:g,primitiveType:f,boundingSphere:r(N)?new E(N,D):void 0})};var J=new o,$=new o,et=new o,tt=new o;H.computeNormal=function(e){if(!r(e))throw new n("geometry is required.");var t=e.attributes,i=e.indices;if(!r(t.position)||!r(t.position.values))throw new n("geometry.attributes.position.values is required.");if(!r(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==w.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,s=e.attributes.position.values.length/3,u=i.length,l=new Array(s),c=new Array(u/3),f=new Array(u),m=0;s>m;m++)l[m]={indexOffset:0,count:0,currentCount:0};var h=0;for(m=0;u>m;m+=3){var d=i[m],p=i[m+1],v=i[m+2],g=3*d,E=3*p,S=3*v;$.x=a[g],$.y=a[g+1],$.z=a[g+2],et.x=a[E],et.y=a[E+1],et.z=a[E+2],tt.x=a[S],tt.y=a[S+1],tt.z=a[S+2],l[d].count++,l[p].count++,l[v].count++,o.subtract(et,$,et),o.subtract(tt,$,tt),c[h]=o.cross(et,tt),h++}var b=0;for(m=0;s>m;m++)l[m].indexOffset+=b,b+=l[m].count;h=0;var A;for(m=0;u>m;m+=3){A=l[i[m]];var M=A.indexOffset+A.currentCount;f[M]=h,A.currentCount++,A=l[i[m+1]],M=A.indexOffset+A.currentCount,f[M]=h,A.currentCount++,A=l[i[m+2]],M=A.indexOffset+A.currentCount,f[M]=h,A.currentCount++,h++}var x=new Float32Array(3*s);for(m=0;s>m;m++){var T=3*m;if(A=l[m],A.count>0){for(o.clone(o.ZERO,J),h=0;h<A.count;h++)o.add(J,c[f[A.indexOffset+h]],J);o.normalize(J,J),x[T]=J.x,x[T+1]=J.y,x[T+2]=J.z}else x[T]=0,x[T+1]=0,x[T+2]=1}return e.attributes.normal=new C({componentDatatype:y.FLOAT,componentsPerAttribute:3,values:x}),e};var rt=new o,nt=new o,it=new o;H.computeBinormalAndTangent=function(e){if(!r(e))throw new n("geometry is required.");var t=e.attributes,i=e.indices;if(!r(t.position)||!r(t.position.values))throw new n("geometry.attributes.position.values is required.");if(!r(t.normal)||!r(t.normal.values))throw new n("geometry.attributes.normal.values is required.");if(!r(t.st)||!r(t.st.values))throw new n("geometry.attributes.st.values is required.");if(!r(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==w.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,s=e.attributes.normal.values,u=e.attributes.st.values,l=e.attributes.position.values.length/3,c=i.length,f=new Array(3*l),m=0;m<f.length;m++)f[m]=0;var h,d,p;for(m=0;c>m;m+=3){var v=i[m],g=i[m+1],E=i[m+2];h=3*v,d=3*g,p=3*E;var S=2*v,b=2*g,A=2*E,M=a[h],x=a[h+1],T=a[h+2],O=u[S],I=u[S+1],N=u[b+1]-I,R=u[A+1]-I,D=1/((u[b]-O)*R-(u[A]-O)*N),L=(R*(a[d]-M)-N*(a[p]-M))*D,z=(R*(a[d+1]-x)-N*(a[p+1]-x))*D,P=(R*(a[d+2]-T)-N*(a[p+2]-T))*D;f[h]+=L,f[h+1]+=z,f[h+2]+=P,f[d]+=L,f[d+1]+=z,f[d+2]+=P,f[p]+=L,f[p+1]+=z,f[p+2]+=P}var F=new Float32Array(3*l),_=new Float32Array(3*l);for(m=0;l>m;m++){h=3*m,d=h+1,p=h+2;var q=o.fromArray(s,h,rt),B=o.fromArray(f,h,it),U=o.dot(q,B);o.multiplyByScalar(q,U,nt),o.normalize(o.subtract(B,nt,B),B),_[h]=B.x,_[d]=B.y,_[p]=B.z,o.normalize(o.cross(q,B,B),B),F[h]=B.x,F[d]=B.y,F[p]=B.z}return e.attributes.tangent=new C({componentDatatype:y.FLOAT,componentsPerAttribute:3,values:_}),e.attributes.binormal=new C({componentDatatype:y.FLOAT,componentsPerAttribute:3,values:F}),e};var ot=new o,at=new o,st=new o,ut=new o,lt=new o,ct={positions:new Array(7),indices:new Array(9)};return H.wrapLongitude=function(e){if(!r(e))throw new n("geometry is required.");var t=e.boundingSphere;if(r(t)){var i=t.center.x-t.radius;if(i>0||E.intersect(t,a.UNIT_Y)!==l.INTERSECTING)return e}return q(e),e.primitiveType===w.TRIANGLES?W(e):e.primitiveType===w.LINES&&V(e),e},H}),define("Scene/PrimitivePipeline",["../Core/defined","../Core/defaultValue","../Core/Color","../Core/ComponentDatatype","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryPipeline","../Core/Matrix4"],function(e,t,r,n,i,o,a,s,u,l){"use strict";function c(e,t,r){var n,i=!r,o=e.length;if(!i&&o>1){var a=e[0].modelMatrix;for(n=1;o>n;++n)if(!l.equals(a,e[n].modelMatrix)){i=!0;break}}if(i)for(n=0;o>n;++n)u.transformToWorldCoordinates(e[n]);else l.clone(e[0].modelMatrix,t)}function f(e,t){for(var i=e.length,o=0;i>o;++o){var a=e[o],u=a.geometry,l=u.attributes,c=l.position,f=4*(c.values.length/c.componentsPerAttribute);l.pickColor=new s({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(f)});for(var m=t[o],h=r.floatToByte(m.red),d=r.floatToByte(m.green),p=r.floatToByte(m.blue),y=r.floatToByte(m.alpha),v=l.pickColor.values,w=0;f>w;w+=4)v[w]=h,v[w+1]=d,v[w+2]=p,v[w+3]=y}}function m(t){var r,n=t.length,i=[],o=t[0].attributes;for(r in o)if(o.hasOwnProperty(r)){for(var a=o[r],s=!0,u=1;n>u;++u){var l=t[u].attributes[r];if(!e(l)||a.componentDatatype.value!==l.componentDatatype.value||a.componentsPerAttribute!==l.componentsPerAttribute||a.normalize!==l.normalize){s=!1;break}}s&&i.push(r)}return i}function h(e,t){for(var r=e.length,i=0;r>i;++i)for(var o=e[i],u=o.attributes,l=o.geometry,c=a.computeNumberOfVertices(l),f=t.length,m=0;f>m;++m){for(var h=t[m],d=u[h],p=d.componentDatatype,y=d.value,v=y.length,w=n.createTypedArray(p,c*v),g=0;c>g;++g)w.set(y,g*v);l.attributes[h]=new s({componentDatatype:p,componentsPerAttribute:v,normalize:d.normalize,values:w})}}function d(e){var t,r=e.instances,o=e.pickIds,a=e.projection,s=e.elementIndexUintSupported,l=e.allow3DOnly,d=e.allowPicking,p=e.vertexCacheOptimize,y=e.modelMatrix,v=r.length,w=r[0].geometry.primitiveType;for(t=1;v>t;++t)if(r[t].geometry.primitiveType!==w)throw new i("All instance geometries must have the same primitiveType.");if(c(r,y,l),!l)for(t=0;v>t;++t)u.wrapLongitude(r[t].geometry);d&&f(r,o);var g=m(r);if(h(r,g),p)for(t=0;v>t;++t)u.reorderForPostVertexCache(r[t].geometry),u.reorderForPreVertexCache(r[t].geometry);var E,S=u.combine(r),C=S.attributes;if(l)for(E in C)C.hasOwnProperty(E)&&C[E].componentDatatype.value===n.DOUBLE.value&&u.encodeAttribute(S,E,E+"3DHigh",E+"3DLow");else for(E in C)if(C.hasOwnProperty(E)&&C[E].componentDatatype.value===n.DOUBLE.value){var b=E+"3D",A=E+"2D";u.projectTo2D(S,E,b,A,a),u.encodeAttribute(S,b,b+"High",b+"Low"),u.encodeAttribute(S,A,A+"High",A+"Low")}return s?[S]:u.fitToUnsignedShortIndices(S)}function p(e,t,r){for(var i=[],o=e.attributes,a=r.length,s=0;a>s;++s){var u=r[s],l=o[u],c=l.componentDatatype;c.value===n.DOUBLE.value&&(c=n.FLOAT);var f=n.createTypedArray(c,l.values);i.push({index:t[u],componentDatatype:c,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,values:f}),delete o[u]}return i}function y(r,n,i){for(var o=[],s=m(r),u=r.length,l={},c={},f=0;u>f;++f)for(var h=r[f],d=a.computeNumberOfVertices(h.geometry),p=s.length,y=0;p>y;++y)for(var v=s[y],w=i[v],g=d;g>0;){for(var E,S=t(c[v],0),C=n[S],b=C.length,A=0;b>A&&(E=C[A],E.index!==w);++A);e(o[f])||(o[f]={}),e(o[f][v])||(o[f][v]={dirty:!1,value:h.attributes[v].value,indices:[]});var M,x=E.values.length/E.componentsPerAttribute,T=t(l[v],0);x>T+g?(M=g,o[f][v].indices.push({attribute:E,offset:T,count:M}),l[v]=T+g):(M=x-T,o[f][v].indices.push({attribute:E,offset:T,count:M}),l[v]=0,c[v]=S+1),g-=M}return o}function v(e){return{type:e.constructor.name,buffer:e.buffer}}function w(e){return new E[e.type](e.buffer)}if(!o.supportsTypedArrays())return{};var g={};g.combineGeometry=function(e){for(var t={instances:e.instances,pickIds:e.pickIds,ellipsoid:e.ellipsoid,projection:e.projection,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:l.clone(e.modelMatrix)},r=d(t),n=u.createAttributeIndices(r[0]),i=t.instances,o=m(i),a=[],s=r.length,c=0;s>c;++c){var f=r[c];a.push(p(f,n,o))}var h=y(i,a,n);return{geometries:r,modelMatrix:t.modelMatrix,attributeIndices:n,vaAttributes:a,vaAttributeIndices:h}};var E={Int8Array:Int8Array,Uint8Array:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};return g.transferGeometry=function(t,r){var n,i=t.attributes;for(var o in i)i.hasOwnProperty(o)&&e(i[o])&&e(i[o].values)&&(n=i[o].values,r.indexOf(i[o].values.buffer)<0&&r.push(n.buffer),e(n.type)||(i[o].values=v(n)));e(t.indices)&&(n=t.indices,r.push(n.buffer),e(n.type)||(t.indices=v(t.indices)))},g.transferGeometries=function(e,t){for(var r=e.length,n=0;r>n;++n)g.transferGeometry(e[n],t)},g.transferPerInstanceAttributes=function(e,t){for(var r=e.length,n=0;r>n;++n)for(var i=e[n],o=i.length,a=0;o>a;++a){var s=i[a].values;t.push(s.buffer),i[a].values=v(s)}},g.transferInstances=function(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n];g.transferGeometry(i.geometry,t)}},g.receiveGeometry=function(t){var r=t.attributes;for(var n in r)r.hasOwnProperty(n)&&e(r[n])&&e(r[n].values)&&(r[n].values=w(r[n].values));e(t.indices)&&(t.indices=w(t.indices))},g.receiveGeometries=function(e){for(var t=e.length,r=0;t>r;++r)g.receiveGeometry(e[r])},g.receivePerInstanceAttributes=function(e){for(var t=e.length,r=0;t>r;++r)for(var n=e[r],i=n.length,o=0;i>o;++o)n[o].values=w(n[o].values)},g.receiveInstances=function(e){for(var t=e.length,r=0;t>r;++r){var n=e[r];g.receiveGeometry(n.geometry)}},g}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined"],function(e,t){"use strict";var r=function(r){var n,i=[],o={id:void 0,result:void 0,error:void 0};return function(a){var s=a.data;i.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=r(s.parameters,i)}catch(u){o.error=u}t(n)||(n=e(self.webkitPostMessage,self.postMessage));try{n(o,i)}catch(u){o.result=void 0,o.error="postMessage failed with error: "+u+"\n  with responseMessage: "+JSON.stringify(o),n(o)}}};return r}),define("Workers/createPolylineGeometry",["../Core/PolylineGeometry","../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,t,r){"use strict";function n(r,n){var i=r.geometry,o=e.createGeometry(i);return t.transferGeometry(o,n),{geometry:o,index:r.index}}return r(n)})}();