/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2013 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r=new Error;this.stack=r.stack};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/Fullscreen",["./defined"],function(e){"use strict";var r,t={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return n.supportsFullscreen=function(){if(e(r))return r;r=!1;var n=document.body;if("function"==typeof n.requestFullscreen)return t.requestFullscreen="requestFullscreen",t.exitFullscreen="exitFullscreen",t.fullscreenEnabled="fullscreenEnabled",t.fullscreenElement="fullscreenElement",t.fullscreenchange="fullscreenchange",t.fullscreenerror="fullscreenerror",r=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];i=s+"RequestFullscreen","function"==typeof n[i]?(t.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof n[i]&&(t.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?t.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(t.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?t.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(t.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?t.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(t.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),t.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),t.fullscreenerror=i)}return r},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[t.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[t.exitFullscreen]()},n.isFullscreenEnabled=function(){return n.supportsFullscreen()?document[t.fullscreenEnabled]:void 0},n.getFullscreenElement=function(){return n.supportsFullscreen()?document[t.fullscreenElement]:void 0},n.isFullscreen=function(){return n.supportsFullscreen()?null!==n.getFullscreenElement():void 0},n.getFullscreenChangeEventName=function(){return n.supportsFullscreen()?t.fullscreenchange:void 0},n.getFullscreenErrorEventName=function(){return n.supportsFullscreen()?t.fullscreenerror:void 0},n}),define("Core/FeatureDetection",["./defined","./Fullscreen"],function(e,r){"use strict";function t(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function n(){if(!e(f)){var r=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===r?f=!1:(f=!0,m=t(r[1]))}return f}function i(){return n()&&m}function o(){if(!e(h))if(n()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))h=!1;else{var r=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===r?h=!1:(h=!0,y=t(r[1]))}return h}function a(){return o()&&y}function u(){if(!e(p)){var r=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===r?p=!1:(p=!0,d=t(r[1]),d.isNightly=!!r[2])}return p}function s(){return u()&&d}function l(){if(!e(v)){var r=/ MSIE ([\.0-9]+)/.exec(navigator.userAgent);null===r?v=!1:(v=!0,w=t(r[1]))}return v}function c(){return l()&&w}var f,m,h,y,p,d,v,w,g,E={isChrome:n,chromeVersion:i,isSafari:o,safariVersion:a,isWebkit:u,webkitVersion:s,isInternetExplorer:l,internetExplorerVersion:c};return E.supportsCrossOriginImagery=function(){return e(g)||(g=o()&&s()[0]<536?!1:"withCredentials"in new XMLHttpRequest),g},E.supportsFullscreen=function(){return r.supportsFullscreen()},E.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},E}),define("Core/Enumeration",["./defined"],function(e){"use strict";var r=function(r,t,n){if(this.value=r,this.name=t,e(n))for(var i in n)n.hasOwnProperty(i)&&(this[i]=n[i])};return r.prototype.valueOf=function(){return this.value},r.prototype.toString=function(){return this.name},r}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./Enumeration"],function(e,r,t,n,i){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:new i(5120,"BYTE",{sizeInBytes:Int8Array.BYTES_PER_ELEMENT}),UNSIGNED_BYTE:new i(5121,"UNSIGNED_BYTE",{sizeInBytes:Uint8Array.BYTES_PER_ELEMENT}),SHORT:new i(5122,"SHORT",{sizeInBytes:Int16Array.BYTES_PER_ELEMENT}),UNSIGNED_SHORT:new i(5123,"UNSIGNED_SHORT",{sizeInBytes:Uint16Array.BYTES_PER_ELEMENT}),FLOAT:new i(5126,"FLOAT",{sizeInBytes:Float32Array.BYTES_PER_ELEMENT}),DOUBLE:new i(5130,"DOUBLE",{sizeInBytes:Float64Array.BYTES_PER_ELEMENT})};return o.validate=function(e){return r(e)&&r(e.value)&&(e.value===o.BYTE.value||e.value===o.UNSIGNED_BYTE.value||e.value===o.SHORT.value||e.value===o.UNSIGNED_SHORT.value||e.value===o.FLOAT.value||e.value===o.DOUBLE.value)},o.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e.value){case o.BYTE.value:return new Int8Array(n);case o.UNSIGNED_BYTE.value:return new Uint8Array(n);case o.SHORT.value:return new Int16Array(n);case o.UNSIGNED_SHORT.value:return new Uint16Array(n);case o.FLOAT.value:return new Float32Array(n);case o.DOUBLE.value:return new Float64Array(n);default:throw new t("componentDatatype is not a valid enumeration value.")}},o.createArrayBufferView=function(n,i,a,u){if(!r(n))throw new t("componentDatatype is required.");if(!r(i))throw new t("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/n.sizeInBytes),n.value){case o.BYTE.value:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE.value:return new Uint8Array(i,a,u);case o.SHORT.value:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT.value:return new Uint16Array(i,a,u);case o.FLOAT.value:return new Float32Array(i,a,u);case o.DOUBLE.value:return new Float64Array(i,a,u);default:throw new t("componentDatatype is not a valid enumeration value.")}},o}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["./defaultValue","./defined","./DeveloperError","../ThirdParty/mersenne-twister"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var r=i.TWO_PI,t=e-Math.floor(e/r)*r;return t<-Math.PI?t+r:t>=Math.PI?t-r:t},i.negativePiToPi=function(e){for(var r=i.EPSILON10,t=i.PI,n=i.TWO_PI;-(t+r)>e;)e+=n;if(-t>e)return-t;for(;e>t+r;)e-=n;return e>t?t:e},i.zeroToTwoPi=function(e){var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(r,t,n){return n=e(n,0),Math.abs(r-t)<=n};var o=[1];i.factorial=function(e){var r=o.length;if(e>=r)for(var t=o[r-1],n=r;e>=n;n++)o.push(t*n);return o[e]},i.incrementWrap=function(r,t,n){return n=e(n,0),++r,r>t&&(r=n),r},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,t){return r>e?r:e>t?t:e};var a=new n;return i.setRandomNumberSeed=function(e){a=new n(e)},i.nextRandomNumber=function(){return a.random()},i}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};i.fromSpherical=function(t,n){r(n)||(n=new i);var o=t.clock,a=t.cone,u=e(t.magnitude,1),s=u*Math.sin(a);return n.x=s*Math.cos(o),n.y=s*Math.sin(o),n.z=u*Math.cos(a),n},i.fromElements=function(e,t,n,o){return r(o)?(o.x=e,o.y=t,o.z=n,o):new i(e,t,n)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(r,t,n){n=e(n,0),t[n++]=r.x,t[n++]=r.y,t[n]=r.z},i.unpack=function(t,n,o){return n=e(n,0),r(o)||(o=new i),o.x=t[n++],o.y=t[n++],o.z=t[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.getMinimumByComponent=function(e,t,n){return r(n)||(n=new i),n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},i.getMaximumByComponent=function(e,t,n){return r(n)||(n=new i),n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,r){return i.subtract(e,r,o),i.magnitude(o)},i.normalize=function(e,t){var n=i.magnitude(e);return r(t)?(t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t):new i(e.x/n,e.y/n,e.z/n)},i.dot=function(e,r){return e.x*r.x+e.y*r.y+e.z*r.z},i.multiplyComponents=function(e,t,n){return r(n)?(n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n):new i(e.x*t.x,e.y*t.y,e.z*t.z)},i.add=function(e,t,n){return r(n)?(n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n):new i(e.x+t.x,e.y+t.y,e.z+t.z)},i.subtract=function(e,t,n){return r(n)?(n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n):new i(e.x-t.x,e.y-t.y,e.z-t.z)},i.multiplyByScalar=function(e,t,n){return r(n)?(n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n):new i(e.x*t,e.y*t,e.z*t)},i.divideByScalar=function(e,t,n){return r(n)?(n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n):new i(e.x/t,e.y/t,e.z/t)},i.negate=function(e,t){return r(t)?(t.x=-e.x,t.y=-e.y,t.z=-e.z,t):new i(-e.x,-e.y,-e.z)},i.abs=function(e,t){return r(t)?(t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z))};var a=new i;i.lerp=function(e,r,t,n){return i.multiplyByScalar(r,t,a),n=i.multiplyByScalar(e,1-t,n),i.add(a,n,n)};var u=new i,s=new i;i.angleBetween=function(e,r){i.normalize(e,u),i.normalize(r,s);var t=i.dot(u,s),n=i.magnitude(i.cross(u,s,u));return Math.atan2(n,t)};var l=new i;return i.mostOrthogonalAxis=function(e,r){var t=i.normalize(e,l);return i.abs(t,t),r=t.x<=t.y?t.x<=t.z?i.clone(i.UNIT_X,r):i.clone(i.UNIT_Z,r):t.y<=t.z?i.clone(i.UNIT_Y,r):i.clone(i.UNIT_Z,r)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},i.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n},i.cross=function(e,t,n){var o=e.x,a=e.y,u=e.z,s=t.x,l=t.y,c=t.z,f=a*c-u*l,m=u*s-o*c,h=o*l-a*s;return r(n)?(n.x=f,n.y=m,n.z=h,n):new i(f,m,h)},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,o,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=o,a):new i(e,t,n,o)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(r,t,n){n=e(n,0),t[n++]=r.x,t[n++]=r.y,t[n++]=r.z,t[n]=r.w},i.unpack=function(t,n,o){return n=e(n,0),r(o)||(o=new i),o.x=t[n++],o.y=t[n++],o.z=t[n++],o.w=t[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,t,n){return r(n)||(n=new i),n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},i.getMaximumByComponent=function(e,t,n){return r(n)||(n=new i),n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,r){return i.subtract(e,r,o),i.magnitude(o)},i.normalize=function(e,t){var n=i.magnitude(e);return r(t)?(t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t):new i(e.x/n,e.y/n,e.z/n,e.w/n)},i.dot=function(e,r){return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},i.multiplyComponents=function(e,t,n){return r(n)?(n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n):new i(e.x*t.x,e.y*t.y,e.z*t.z,e.w*t.w)},i.add=function(e,t,n){return r(n)?(n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n):new i(e.x+t.x,e.y+t.y,e.z+t.z,e.w+t.w)},i.subtract=function(e,t,n){return r(n)?(n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n):new i(e.x-t.x,e.y-t.y,e.z-t.z,e.w-t.w)},i.multiplyByScalar=function(e,t,n){return r(n)?(n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n):new i(e.x*t,e.y*t,e.z*t,e.w*t)},i.divideByScalar=function(e,t,n){return r(n)?(n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n):new i(e.x/t,e.y/t,e.z/t,e.w/t)},i.negate=function(e,t){return r(t)?(t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t):new i(-e.x,-e.y,-e.z,-e.w)},i.abs=function(e,t){return r(t)?(t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z),Math.abs(e.w))};var a=new i;i.lerp=function(e,r,t,n){return i.multiplyByScalar(r,t,a),n=i.multiplyByScalar(e,1-t,n),i.add(a,n,n)};var u=new i;return i.mostOrthogonalAxis=function(e,r){var t=i.normalize(e,u);return i.abs(t,t),r=t.x<=t.y?t.x<=t.z?t.x<=t.w?i.clone(i.UNIT_X,r):i.clone(i.UNIT_W,r):t.z<=t.w?i.clone(i.UNIT_Z,r):i.clone(i.UNIT_W,r):t.y<=t.z?t.y<=t.w?i.clone(i.UNIT_Y,r):i.clone(i.UNIT_W,r):t.z<=t.w?i.clone(i.UNIT_Z,r):i.clone(i.UNIT_W,r)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromDegrees=function(t,n,a,u){return t=i.toRadians(e(t,0)),n=i.toRadians(e(n,0)),a=e(a,0),r(u)?(u.longitude=t,u.latitude=n,u.height=a,u):new o(t,n,a)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return o.toString(this)},o}),define("Core/Ellipsoid",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic"],function(e,r,t,n,i,o,a){"use strict";var u=function(e,t,a){if(e=r(e,0),t=r(t,0),a=r(a,0),0>e||0>t||0>a)throw new n("All radii components must be greater than or equal to zero.");this._radii=new o(e,t,a),this._radiiSquared=new o(e*e,t*t,a*a),this._radiiToTheFourth=new o(e*e*e*e,t*t*t*t,a*a*a*a),this._oneOverRadii=new o(0===e?0:1/e,0===t?0:1/t,0===a?0:1/a),this._oneOverRadiiSquared=new o(0===e?0:1/(e*e),0===t?0:1/(t*t),0===a?0:1/(a*a)),this._minimumRadius=Math.min(e,t,a),this._maximumRadius=Math.max(e,t,a),this._centerToleranceSquared=i.EPSILON1};u.clone=function(e,r){if(!t(e))return void 0;var n=e._radii;return t(r)?(o.clone(n,r._radii),o.clone(e._radiiSquared,r._radiiSquared),o.clone(e._radiiToTheFourth,r._radiiToTheFourth),o.clone(e._oneOverRadii,r._oneOverRadii),o.clone(e._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=e._minimumRadius,r._maximumRadius=e._maximumRadius,r._centerToleranceSquared=e._centerToleranceSquared,r):new u(n.x,n.y,n.z)},u.fromCartesian3=function(e){return t(e)?new u(e.x,e.y,e.z):new u},u.WGS84=e(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=e(new u(1,1,1)),u.MOON=e(new u(i.LUNAR_RADIUS,i.LUNAR_RADIUS,i.LUNAR_RADIUS)),u.prototype.getRadii=function(){return this._radii},u.prototype.getRadiiSquared=function(){return this._radiiSquared},u.prototype.getRadiiToTheFourth=function(){return this._radiiToTheFourth},u.prototype.getOneOverRadii=function(){return this._oneOverRadii},u.prototype.getOneOverRadiiSquared=function(){return this._oneOverRadiiSquared},u.prototype.getMinimumRadius=function(){return this._minimumRadius},u.prototype.getMaximumRadius=function(){return this._maximumRadius},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.geocentricSurfaceNormal=o.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(e,r){if(!t(e))throw new n("cartographic is required.");var i=e.longitude,a=e.latitude,u=Math.cos(a),s=u*Math.cos(i),l=u*Math.sin(i),c=Math.sin(a);return t(r)||(r=new o),r.x=s,r.y=l,r.z=c,o.normalize(r,r)},u.prototype.geodeticSurfaceNormal=function(e,r){return r=o.multiplyComponents(e,this._oneOverRadiiSquared,r),o.normalize(r,r)};var s=new o,l=new o;u.prototype.cartographicToCartesian=function(e,r){var t=s,n=l;this.geodeticSurfaceNormalCartographic(e,t),o.multiplyComponents(this._radiiSquared,t,n);var i=Math.sqrt(o.dot(t,n));return o.divideByScalar(n,i,n),o.multiplyByScalar(t,e.height,t),o.add(n,t,r)},u.prototype.cartographicArrayToCartesianArray=function(e,r){if(!t(e))throw new n("cartographics is required.");var i=e.length;t(r)?r.length=i:r=new Array(i);for(var o=0;i>o;o++)r[o]=this.cartographicToCartesian(e[o],r[o]);return r};var c=new o,f=new o,m=new o;u.prototype.cartesianToCartographic=function(e,r){var n=this.scaleToGeodeticSurface(e,f);if(!t(n))return void 0;var u=this.geodeticSurfaceNormal(n,c),s=o.subtract(e,n,m),l=Math.atan2(u.y,u.x),h=Math.asin(u.z),y=i.sign(o.dot(s,e))*o.magnitude(s);return t(r)?(r.longitude=l,r.latitude=h,r.height=y,r):new a(l,h,y)},u.prototype.cartesianArrayToCartographicArray=function(e,r){if(!t(e))throw new n("cartesians is required.");var i=e.length;t(r)?r.length=i:r=new Array(i);for(var o=0;i>o;++o)r[o]=this.cartesianToCartographic(e[o],r[o]);return r};var h=new o,y=new o;return u.prototype.scaleToGeodeticSurface=function(e,r){if(!t(e))throw new n("cartesian is required.");var a=e.x,u=e.y,s=e.z,l=this._oneOverRadii,c=l.x,f=l.y,m=l.z,p=a*a*c*c,d=u*u*f*f,v=s*s*m*m,w=p+d+v,g=Math.sqrt(1/w),E=o.multiplyByScalar(e,g,h);if(w<this._centerToleranceSquared)return isFinite(g)?o.clone(E,r):void 0;var C=this._oneOverRadiiSquared,S=C.x,b=C.y,x=C.z,A=y;A.x=2*E.x*S,A.y=2*E.y*b,A.z=2*E.z*x;var T,M,I,O,N,R,z,L,D,F,P,B=(1-g)*o.magnitude(e)/(.5*o.magnitude(A)),q=0;do{B-=q,I=1/(1+B*S),O=1/(1+B*b),N=1/(1+B*x),R=I*I,z=O*O,L=N*N,D=R*I,F=z*O,P=L*N,T=p*R+d*z+v*L-1,M=p*D*S+d*F*b+v*P*x;var _=-2*M;q=T/_}while(Math.abs(T)>i.EPSILON12);return t(r)?(r.x=a*I,r.y=u*O,r.z=s*N,r):new o(a*I,u*O,s*N)},u.prototype.scaleToGeocentricSurface=function(e,r){if(!t(e))throw new n("cartesian is required.");var i=e.x,a=e.y,u=e.z,s=this._oneOverRadiiSquared,l=1/Math.sqrt(i*i*s.x+a*a*s.y+u*u*s.z);return o.multiplyByScalar(e,l,r)},u.prototype.transformPositionToScaledSpace=function(e,r){return o.multiplyComponents(e,this._oneOverRadii,r)},u.prototype.transformPositionFromScaledSpace=function(e,r){return o.multiplyComponents(e,this._radii,r)},u.prototype.equals=function(e){return this===e||t(e)&&o.equals(this._radii,e._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Core/GeographicProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Ellipsoid"],function(e,r,t,n,i){"use strict";var o=function(r){this._ellipsoid=e(r,i.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return o.prototype.getEllipsoid=function(){return this._ellipsoid},o.prototype.project=function(e,n){var i=this._semimajorAxis,o=e.longitude*i,a=e.latitude*i,u=e.height;return r(n)?(n.x=o,n.y=a,n.z=u,n):new t(o,a,u)},o.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,o=e.x*i,a=e.y*i,u=e.z;return r(t)?(t.longitude=o,t.latitude=a,t.height=u,t):new n(o,a,u)},o}),define("Core/Intersect",["./Enumeration"],function(e){"use strict";var r={OUTSIDE:new e(-1,"OUTSIDE"),INTERSECTING:new e(0,"INTERSECTING"),INSIDE:new e(1,"INSIDE")};return r}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[l.getElementIndex(f[t],c[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var u=Math.abs(e[l.getElementIndex(f[a],c[a])]);u>n&&(i=a,n=u)}var s=1,m=0,h=c[i],y=f[i];if(Math.abs(e[l.getElementIndex(y,h)])>t){var p,d=e[l.getElementIndex(y,y)],v=e[l.getElementIndex(h,h)],w=e[l.getElementIndex(y,h)],g=(d-v)/2/w;p=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),s=1/Math.sqrt(1+p*p),m=p*s}return r=l.clone(l.IDENTITY,r),r[l.getElementIndex(h,h)]=r[l.getElementIndex(y,y)]=s,r[l.getElementIndex(y,h)]=m,r[l.getElementIndex(h,y)]=-m,r}var l=function(e,t,n,i,o,a,u,s,l){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(l,0)};l.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,n,i){return n=r(n,0),t(i)||(i=new l),i[0]=e[n],i[1]=e[n+1],i[2]=e[n+2],i[3]=e[n+3],i[4]=e[n+4],i[5]=e[n+5],i[6]=e[n+6],i[7]=e[n+7],i[8]=e[n+8],i[9]=e[n+9],i},l.fromColumnMajorArray=function(e,r){return l.clone(e,r)},l.fromRowMajorArray=function(e,r){return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,r){var n=e.x*e.x,i=e.x*e.y,o=e.x*e.z,a=e.x*e.w,u=e.y*e.y,s=e.y*e.z,c=e.y*e.w,f=e.z*e.z,m=e.z*e.w,h=e.w*e.w,y=n-u-f+h,p=2*(i-m),d=2*(o+c),v=2*(i+m),w=-n+u-f+h,g=2*(s-a),E=2*(o-c),C=2*(s+a),S=-n-u+f+h;return t(r)?(r[0]=y,r[1]=v,r[2]=E,r[3]=p,r[4]=w,r[5]=C,r[6]=d,r[7]=g,r[8]=S,r):new l(y,p,d,v,w,g,E,C,S)},l.fromScale=function(e,r){return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,r){return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new l(e,0,0,0,e,0,0,0,e)},l.fromRotationX=function(e,r){var n=Math.cos(e),i=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=i,r[6]=0,r[7]=-i,r[8]=n,r):new l(1,0,0,0,n,-i,0,i,n)},l.fromRotationY=function(e,r){var n=Math.cos(e),i=Math.sin(e);return t(r)?(r[0]=n,r[1]=0,r[2]=-i,r[3]=0,r[4]=1,r[5]=0,r[6]=i,r[7]=0,r[8]=n,r):new l(n,0,i,0,1,0,-i,0,n)},l.fromRotationZ=function(e,r){var n=Math.cos(e),i=Math.sin(e);return t(r)?(r[0]=n,r[1]=i,r[2]=0,r[3]=-i,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new l(n,-i,0,i,n,0,0,0,1)},l.toArray=function(e,r){return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,r){return 3*e+r},l.getColumn=function(r,n,i){var o=3*n,a=r[o],u=r[o+1],s=r[o+2];return t(i)?(i.x=a,i.y=u,i.z=s,i):new e(a,u,s)},l.setColumn=function(e,r,t,n){n=l.clone(e,n);var i=3*r;return n[i]=t.x,n[i+1]=t.y,n[i+2]=t.z,n},l.getRow=function(r,n,i){var o=r[n],a=r[n+3],u=r[n+6];return t(i)?(i.x=o,i.y=a,i.z=u,i):new e(o,a,u)},l.setRow=function(e,r,t,n){return n=l.clone(e,n),n[r]=t.x,n[r+3]=t.y,n[r+6]=t.z,n},l.multiply=function(e,r,n){var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],a=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],m=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],h=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(n)?(n[0]=i,n[1]=o,n[2]=a,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=m,n[8]=h,n):new l(i,u,f,o,s,m,a,c,h)},l.multiplyByVector=function(r,n,i){var o=n.x,a=n.y,u=n.z,s=r[0]*o+r[3]*a+r[6]*u,l=r[1]*o+r[4]*a+r[7]*u,c=r[2]*o+r[5]*a+r[8]*u;return t(i)?(i.x=s,i.y=l,i.z=c,i):new e(s,l,c)},l.multiplyByScalar=function(e,r,n){return t(n)?(n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n):new l(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},l.negate=function(e,r){return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new l(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},l.transpose=function(e,r){var n=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],c=e[2],f=e[5],m=e[8];return t(r)?(r[0]=n,r[1]=i,r[2]=o,r[3]=a,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=m,r):new l(n,a,c,i,u,f,o,s,m)};var c=[1,0,0],f=[2,2,1],m=new l,h=new l;return l.getEigenDecomposition=function(e,r){var n=o.EPSILON20,i=10,c=0,f=0;t(r)||(r={});for(var y=r.unitary=l.clone(l.IDENTITY,r.unitary),p=r.diagonal=l.clone(e,r.diagonal),d=n*a(p);i>f&&u(p)>d;)s(p,m),l.transpose(m,h),l.multiply(p,m,p),l.multiply(h,p,p),l.multiply(y,m,y),++c>2&&(++f,c=0);return r},l.abs=function(e,r){return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new l(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},l.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],l=e[2],c=e[5],f=e[8];return r*(u*f-c*s)+a*(c*o-i*f)+l*(i*s-u*o)},l.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[1],u=e[2],s=e[3],c=e[4],f=e[5],m=e[6],h=e[7],y=e[8],p=l.determinant(e);if(Math.abs(p)<=o.EPSILON15)throw new n("matrix is not invertible");var d=new l(c*y-h*f,m*f-s*y,s*h-m*c,h*u-a*y,i*y-m*u,m*a-i*h,a*f-c*u,s*u-i*f,i*c-s*a),v=1/p;return l.multiplyByScalar(d,v,r)},l.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},l.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n&&Math.abs(e[4]-r[4])<=n&&Math.abs(e[5]-r[5])<=n&&Math.abs(e[6]-r[6])<=n&&Math.abs(e[7]-r[7])<=n&&Math.abs(e[8]-r[8])<=n},l.IDENTITY=i(new l(1,0,0,0,1,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,r){return l.equalsEpsilon(this,e,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r=new Error;this.stack=r.stack};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,u,s){"use strict";var l=function(e,r,n,i,o,a,u,s,l,c,f,m,h,y,p,d){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(l,0),this[3]=t(h,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(c,0),this[7]=t(y,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(f,0),this[11]=t(p,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(m,0),this[15]=t(d,0)
};l.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=function(e,r,i){return r=t(r,0),n(i)||(i=new l),i[0]=e[r],i[1]=e[r+1],i[2]=e[r+2],i[3]=e[r+3],i[4]=e[r+4],i[5]=e[r+5],i[6]=e[r+6],i[7]=e[r+7],i[8]=e[r+8],i[9]=e[r+9],i[10]=e[r+10],i[11]=e[r+11],i[12]=e[r+12],i[13]=e[r+13],i[14]=e[r+14],i[15]=e[r+15],i},l.fromColumnMajorArray=function(e,r){return l.clone(e,r)},l.fromRowMajorArray=function(e,r){return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(e,r,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new l(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new u,l.fromTranslationQuaternionRotationScale=function(e,r,t,i){n(i)||(i=new l);var o=t.x,a=t.y,u=t.z,s=r.x*r.x,c=r.x*r.y,f=r.x*r.z,m=r.x*r.w,h=r.y*r.y,y=r.y*r.z,p=r.y*r.w,d=r.z*r.z,v=r.z*r.w,w=r.w*r.w,g=s-h-d+w,E=2*(c-v),C=2*(f+p),S=2*(c+v),b=-s+h-d+w,x=2*(y-m),A=2*(f-p),T=2*(y+m),M=-s-h+d+w;return i[0]=g*o,i[1]=S*o,i[2]=A*o,i[3]=0,i[4]=E*a,i[5]=b*a,i[6]=T*a,i[7]=0,i[8]=C*u,i[9]=x*u,i[10]=M*u,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},l.fromTranslation=function(e,r){return l.fromRotationTranslation(u.IDENTITY,e,r)},l.fromScale=function(e,r){return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,r){return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,f=new e,m=new e;l.fromCamera=function(r,t){var i=r.eye,o=r.target,a=r.up;e.normalize(e.subtract(o,i,c),c),e.normalize(e.cross(c,a,f),f),e.normalize(e.cross(f,c,m),m);var u=f.x,s=f.y,h=f.z,y=c.x,p=c.y,d=c.z,v=m.x,w=m.y,g=m.z,E=i.x,C=i.y,S=i.z,b=u*-E+s*-C+h*-S,x=v*-E+w*-C+g*-S,A=y*E+p*C+d*S;return n(t)?(t[0]=u,t[1]=v,t[2]=-y,t[3]=0,t[4]=s,t[5]=w,t[6]=-p,t[7]=0,t[8]=h,t[9]=g,t[10]=-d,t[11]=0,t[12]=b,t[13]=x,t[14]=A,t[15]=1,t):new l(u,s,h,b,v,w,g,x,-y,-p,-d,A,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,r,t,i,o){var a=Math.tan(.5*e),u=1/a,s=u/r,c=(i+t)/(t-i),f=2*i*t/(t-i);return n(o)?(o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=u,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=f,o[15]=0,o):new l(s,0,0,0,0,u,0,0,0,0,c,f,0,0,-1,0)},l.computeOrthographicOffCenter=function(e,r,t,i,o,a,u){var s=1/(r-e),c=1/(i-t),f=1/(a-o),m=-(r+e)*s,h=-(i+t)*c,y=-(a+o)*f;return s*=2,c*=2,f*=-2,n(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=m,u[13]=h,u[14]=y,u[15]=1,u):new l(s,0,0,m,0,c,0,h,0,0,f,y,0,0,0,1)},l.computePerspectiveOffCenter=function(e,r,t,i,o,a,u){var s=2*o/(r-e),c=2*o/(i-t),f=(r+e)/(r-e),m=(i+t)/(i-t),h=-(a+o)/(a-o),y=-1,p=-2*a*o/(a-o);return n(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=m,u[10]=h,u[11]=y,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u):new l(s,0,f,0,0,c,m,0,0,0,h,p,0,0,y,0)},l.computeInfinitePerspectiveOffCenter=function(e,r,t,i,o,a){var u=2*o/(r-e),s=2*o/(i-t),c=(r+e)/(r-e),f=(i+t)/(i-t),m=-1,h=-1,y=-2*o;return n(a)?(a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=m,a[11]=h,a[12]=0,a[13]=0,a[14]=y,a[15]=0,a):new l(u,0,c,0,0,s,f,0,0,0,m,y,0,0,h,0)},l.computeViewportTransformation=function(e,r,i,o){e=t(e,t.EMPTY_OBJECT);var a=t(e.x,0),u=t(e.y,0),s=t(e.width,0),c=t(e.height,0);r=t(r,0),i=t(i,1);var f=.5*s,m=.5*c,h=.5*(i-r),y=f,p=m,d=h,v=a+f,w=u+m,g=r+h,E=1;return n(o)?(o[0]=y,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=p,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=d,o[11]=0,o[12]=v,o[13]=w,o[14]=g,o[15]=E,o):new l(y,0,0,v,0,p,0,w,0,0,d,g,0,0,0,E)},l.toArray=function(e,r){return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,r){return 4*e+r},l.getColumn=function(e,t,i){var o=4*t,a=e[o],u=e[o+1],s=e[o+2],l=e[o+3];return n(i)?(i.x=a,i.y=u,i.z=s,i.w=l,i):new r(a,u,s,l)},l.setColumn=function(e,r,t,n){n=l.clone(e,n);var i=4*r;return n[i]=t.x,n[i+1]=t.y,n[i+2]=t.z,n[i+3]=t.w,n},l.getRow=function(e,t,i){var o=e[t],a=e[t+4],u=e[t+8],s=e[t+12];return n(i)?(i.x=o,i.y=a,i.z=u,i.w=s,i):new r(o,a,u,s)},l.setRow=function(e,r,t,n){return n=l.clone(e,n),n[r]=t.x,n[r+4]=t.y,n[r+8]=t.z,n[r+12]=t.w,n},l.multiply=function(e,r,t){var i=e[0],o=e[1],a=e[2],u=e[3],s=e[4],c=e[5],f=e[6],m=e[7],h=e[8],y=e[9],p=e[10],d=e[11],v=e[12],w=e[13],g=e[14],E=e[15],C=r[0],S=r[1],b=r[2],x=r[3],A=r[4],T=r[5],M=r[6],I=r[7],O=r[8],N=r[9],R=r[10],z=r[11],L=r[12],D=r[13],F=r[14],P=r[15],B=i*C+s*S+h*b+v*x,q=o*C+c*S+y*b+w*x,_=a*C+f*S+p*b+g*x,U=u*C+m*S+d*b+E*x,G=i*A+s*T+h*M+v*I,Y=o*A+c*T+y*M+w*I,W=a*A+f*T+p*M+g*I,V=u*A+m*T+d*M+E*I,H=i*O+s*N+h*R+v*z,k=o*O+c*N+y*R+w*z,K=a*O+f*N+p*R+g*z,j=u*O+m*N+d*R+E*z,Z=i*L+s*D+h*F+v*P,Q=o*L+c*D+y*F+w*P,X=a*L+f*D+p*F+g*P,J=u*L+m*D+d*F+E*P;return n(t)?(t[0]=B,t[1]=q,t[2]=_,t[3]=U,t[4]=G,t[5]=Y,t[6]=W,t[7]=V,t[8]=H,t[9]=k,t[10]=K,t[11]=j,t[12]=Z,t[13]=Q,t[14]=X,t[15]=J,t):new l(B,G,H,Z,q,Y,k,Q,_,W,K,X,U,V,j,J)},l.multiplyTransformation=function(e,r,t){var i=e[0],o=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],m=e[9],h=e[10],y=e[12],p=e[13],d=e[14],v=r[0],w=r[1],g=r[2],E=r[4],C=r[5],S=r[6],b=r[8],x=r[9],A=r[10],T=r[12],M=r[13],I=r[14],O=i*v+u*w+f*g,N=o*v+s*w+m*g,R=a*v+c*w+h*g,z=i*E+u*C+f*S,L=o*E+s*C+m*S,D=a*E+c*C+h*S,F=i*b+u*x+f*A,P=o*b+s*x+m*A,B=a*b+c*x+h*A,q=i*T+u*M+f*I+y,_=o*T+s*M+m*I+p,U=a*T+c*M+h*I+d;return n(t)?(t[0]=O,t[1]=N,t[2]=R,t[3]=0,t[4]=z,t[5]=L,t[6]=D,t[7]=0,t[8]=F,t[9]=P,t[10]=B,t[11]=0,t[12]=q,t[13]=_,t[14]=U,t[15]=1,t):new l(O,z,F,q,N,L,P,_,R,D,B,U,0,0,0,1)},l.multiplyByTranslation=function(e,r,t){var i=r.x,o=r.y,a=r.z,u=i*e[0]+o*e[4]+a*e[8]+e[12],s=i*e[1]+o*e[5]+a*e[9]+e[13],c=i*e[2]+o*e[6]+a*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=u,t[13]=s,t[14]=c,t[15]=e[15],t):new l(e[0],e[4],e[8],u,e[1],e[5],e[9],s,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var h=new e;return l.multiplyByUniformScale=function(e,r,t){return h.x=r,h.y=r,h.z=r,l.multiplyByScale(e,h,t)},l.multiplyByScale=function(e,r,t){var i=r.x,o=r.y,a=r.z;return 1===i&&1===o&&1===a?l.clone(e,t):n(t)?(t[0]=i*e[0],t[1]=i*e[1],t[2]=i*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=a*e[8],t[9]=a*e[9],t[10]=a*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new l(i*e[0],o*e[4],a*e[8],e[12],i*e[1],o*e[5],a*e[9],e[13],i*e[2],o*e[6],a*e[10],e[14],0,0,0,1)},l.multiplyByVector=function(e,t,i){var o=t.x,a=t.y,u=t.z,s=t.w,l=e[0]*o+e[4]*a+e[8]*u+e[12]*s,c=e[1]*o+e[5]*a+e[9]*u+e[13]*s,f=e[2]*o+e[6]*a+e[10]*u+e[14]*s,m=e[3]*o+e[7]*a+e[11]*u+e[15]*s;return n(i)?(i.x=l,i.y=c,i.z=f,i.w=m,i):new r(l,c,f,m)},l.multiplyByPointAsVector=function(r,t,i){var o=t.x,a=t.y,u=t.z,s=r[0]*o+r[4]*a+r[8]*u,l=r[1]*o+r[5]*a+r[9]*u,c=r[2]*o+r[6]*a+r[10]*u;return n(i)?(i.x=s,i.y=l,i.z=c,i):new e(s,l,c)},l.multiplyByPoint=function(r,t,i){var o=t.x,a=t.y,u=t.z,s=r[0]*o+r[4]*a+r[8]*u+r[12],l=r[1]*o+r[5]*a+r[9]*u+r[13],c=r[2]*o+r[6]*a+r[10]*u+r[14];return n(i)?(i.x=s,i.y=l,i.z=c,i):new e(s,l,c)},l.multiplyByScalar=function(e,r,t){return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new l(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},l.negate=function(e,r){return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new l(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},l.transpose=function(e,r){if(!n(r))return new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],i=e[2],o=e[3],a=e[6],u=e[7],s=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=i,r[9]=a,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r},l.abs=function(e,r){return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new l(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},l.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},l.equalsEpsilon=function(e,r,t){return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},l.getTranslation=function(r,t){return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},l.getRotation=function(e,r){return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new u(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},l.inverse=function(e,r){var t=e[0],i=e[4],o=e[8],u=e[12],c=e[1],f=e[5],m=e[9],h=e[13],y=e[2],p=e[6],d=e[10],v=e[14],w=e[3],g=e[7],E=e[11],C=e[15],S=d*C,b=v*E,x=p*C,A=v*g,T=p*E,M=d*g,I=y*C,O=v*w,N=y*E,R=d*w,z=y*g,L=p*w,D=S*f+A*m+T*h-(b*f+x*m+M*h),F=b*c+I*m+R*h-(S*c+O*m+N*h),P=x*c+O*f+z*h-(A*c+I*f+L*h),B=M*c+N*f+L*m-(T*c+R*f+z*m),q=b*i+x*o+M*u-(S*i+A*o+T*u),_=S*t+O*o+N*u-(b*t+I*o+R*u),U=A*t+I*i+L*u-(x*t+O*i+z*u),G=T*t+R*i+z*o-(M*t+N*i+L*o);S=o*h,b=u*m,x=i*h,A=u*f,T=i*m,M=o*f,I=t*h,O=u*c,N=t*m,R=o*c,z=t*f,L=i*c;var Y=S*g+A*E+T*C-(b*g+x*E+M*C),W=b*w+I*E+R*C-(S*w+O*E+N*C),V=x*w+O*g+z*C-(A*w+I*g+L*C),H=M*w+N*g+L*E-(T*w+R*g+z*E),k=x*d+M*v+b*p-(T*v+S*p+A*d),K=N*v+S*y+O*d-(I*d+R*v+b*y),j=I*p+L*v+A*y-(z*v+x*y+O*p),Z=z*d+T*y+R*p-(N*p+L*d+M*y),Q=t*D+i*F+o*P+u*B;if(Math.abs(Q)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return Q=1/Q,n(r)?(r[0]=D*Q,r[1]=F*Q,r[2]=P*Q,r[3]=B*Q,r[4]=q*Q,r[5]=_*Q,r[6]=U*Q,r[7]=G*Q,r[8]=Y*Q,r[9]=W*Q,r[10]=V*Q,r[11]=H*Q,r[12]=k*Q,r[13]=K*Q,r[14]=j*Q,r[15]=Z*Q,r):new l(D*Q,q*Q,Y*Q,k*Q,F*Q,_*Q,W*Q,K*Q,P*Q,U*Q,V*Q,j*Q,B*Q,G*Q,H*Q,Z*Q)},l.inverseTransformation=function(e,r){var t=e[0],i=e[1],o=e[2],a=e[4],u=e[5],s=e[6],c=e[8],f=e[9],m=e[10],h=e[12],y=e[13],p=e[14],d=-t*h-i*y-o*p,v=-a*h-u*y-s*p,w=-c*h-f*y-m*p;return n(r)?(r[0]=t,r[1]=a,r[2]=c,r[3]=0,r[4]=i,r[5]=u,r[6]=f,r[7]=0,r[8]=o,r[9]=s,r[10]=m,r[11]=0,r[12]=d,r[13]=v,r[14]=w,r[15]=1,r):new l(t,i,o,d,a,u,s,v,c,f,m,w,0,0,0,1)},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,r){return l.equalsEpsilon(this,e,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/BoundingSphere",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Cartesian4","./Cartographic","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4"],function(e,r,t,n,i,o,a,u,s,l,c){"use strict";var f=function(r,t){this.center=n.clone(e(r,n.ZERO)),this.radius=e(t,0)},m=new n,h=new n,y=new n,p=new n,d=new n,v=new n,w=new n,g=new n,E=new n,C=new n,S=new n,b=new n;f.fromPoints=function(e,t){if(r(t)||(t=new f),!r(e)||0===e.length)return t.center=n.clone(n.ZERO,t.center),t.radius=0,t;for(var i=n.clone(e[0],w),o=n.clone(i,m),a=n.clone(i,h),u=n.clone(i,y),s=n.clone(i,p),l=n.clone(i,d),c=n.clone(i,v),x=e.length,A=1;x>A;A++){n.clone(e[A],i);var T=i.x,M=i.y,I=i.z;T<o.x&&n.clone(i,o),T>s.x&&n.clone(i,s),M<a.y&&n.clone(i,a),M>l.y&&n.clone(i,l),I<u.z&&n.clone(i,u),I>c.z&&n.clone(i,c)}var O=n.magnitudeSquared(n.subtract(s,o,g)),N=n.magnitudeSquared(n.subtract(l,a,g)),R=n.magnitudeSquared(n.subtract(c,u,g)),z=o,L=s,D=O;N>D&&(D=N,z=a,L=l),R>D&&(D=R,z=u,L=c);var F=E;F.x=.5*(z.x+L.x),F.y=.5*(z.y+L.y),F.z=.5*(z.z+L.z);var P=n.magnitudeSquared(n.subtract(L,F,g)),B=Math.sqrt(P),q=C;q.x=o.x,q.y=a.y,q.z=u.z;var _=S;_.x=s.x,_.y=l.y,_.z=c.z;var U=n.multiplyByScalar(n.add(q,_,g),.5,b),G=0;for(A=0;x>A;A++){n.clone(e[A],i);var Y=n.magnitude(n.subtract(i,U,g));Y>G&&(G=Y);var W=n.magnitudeSquared(n.subtract(i,F,g));if(W>P){var V=Math.sqrt(W);B=.5*(B+V),P=B*B;var H=V-B;F.x=(B*F.x+H*i.x)/V,F.y=(B*F.y+H*i.y)/V,F.z=(B*F.z+H*i.z)/V}}return G>B?(n.clone(F,t.center),t.radius=B):(n.clone(U,t.center),t.radius=G),t};var x=new u,A=new n,T=new n,M=new o,I=new o;f.fromExtent2D=function(e,r,t){return f.fromExtentWithHeights2D(e,r,0,0,t)},f.fromExtentWithHeights2D=function(t,i,o,a,u){if(r(u)||(u=new f),!r(t))return u.center=n.clone(n.ZERO,u.center),u.radius=0,u;i=e(i,x),t.getSouthwest(M),M.height=o,t.getNortheast(I),I.height=a;var s=i.project(M,A),l=i.project(I,T),c=l.x-s.x,m=l.y-s.y,h=l.z-s.z;u.radius=.5*Math.sqrt(c*c+m*m+h*h);var y=u.center;return y.x=s.x+.5*c,y.y=s.y+.5*m,y.z=s.z+.5*h,u};var O=[];f.fromExtent3D=function(t,n,i,o){n=e(n,a.WGS84),i=e(i,0);var u;return r(t)&&(u=t.subsample(n,i,O)),f.fromPoints(u,o)},f.fromVertices=function(t,i,o,a){if(r(a)||(a=new f),!r(t)||0===t.length)return a.center=n.clone(n.ZERO,a.center),a.radius=0,a;i=e(i,n.ZERO),o=e(o,3);var u=w;u.x=t[0]+i.x,u.y=t[1]+i.y,u.z=t[2]+i.z;for(var s=n.clone(u,m),l=n.clone(u,h),c=n.clone(u,y),x=n.clone(u,p),A=n.clone(u,d),T=n.clone(u,v),M=t.length,I=0;M>I;I+=o){var O=t[I]+i.x,N=t[I+1]+i.y,R=t[I+2]+i.z;u.x=O,u.y=N,u.z=R,O<s.x&&n.clone(u,s),O>x.x&&n.clone(u,x),N<l.y&&n.clone(u,l),N>A.y&&n.clone(u,A),R<c.z&&n.clone(u,c),R>T.z&&n.clone(u,T)}var z=n.magnitudeSquared(n.subtract(x,s,g)),L=n.magnitudeSquared(n.subtract(A,l,g)),D=n.magnitudeSquared(n.subtract(T,c,g)),F=s,P=x,B=z;L>B&&(B=L,F=l,P=A),D>B&&(B=D,F=c,P=T);var q=E;q.x=.5*(F.x+P.x),q.y=.5*(F.y+P.y),q.z=.5*(F.z+P.z);var _=n.magnitudeSquared(n.subtract(P,q,g)),U=Math.sqrt(_),G=C;G.x=s.x,G.y=l.y,G.z=c.z;var Y=S;Y.x=x.x,Y.y=A.y,Y.z=T.z;var W=n.multiplyByScalar(n.add(G,Y,g),.5,b),V=0;for(I=0;M>I;I+=o){u.x=t[I]+i.x,u.y=t[I+1]+i.y,u.z=t[I+2]+i.z;var H=n.magnitude(n.subtract(u,W,g));H>V&&(V=H);var k=n.magnitudeSquared(n.subtract(u,q,g));if(k>_){var K=Math.sqrt(k);U=.5*(U+K),_=U*U;var j=K-U;q.x=(U*q.x+j*u.x)/K,q.y=(U*q.y+j*u.y)/K,q.z=(U*q.z+j*u.z)/K}}return V>U?(n.clone(q,a.center),a.radius=U):(n.clone(W,a.center),a.radius=V),a},f.fromCornerPoints=function(e,t,i){r(i)||(i=new f);var o=i.center;return n.add(e,t,o),n.multiplyByScalar(o,.5,o),i.radius=n.distance(o,t),i},f.fromEllipsoid=function(e,t){return r(t)||(t=new f),n.clone(n.ZERO,t.center),t.radius=e.getMaximumRadius(),t},f.clone=function(e,t){return r(e)?r(t)?(t.center=n.clone(e.center,t.center),t.radius=e.radius,t):new f(e.center,e.radius):void 0};var N=new n,R=new n;f.union=function(e,t,i){r(i)||(i=new f);var o=e.center,a=t.center;n.add(o,a,R);var u=n.multiplyByScalar(R,.5,R),s=n.magnitude(n.subtract(o,u,N))+e.radius,l=n.magnitude(n.subtract(a,u,N))+t.radius;return i.radius=Math.max(s,l),n.clone(u,i.center),i};var z=new n;f.expand=function(e,r,t){t=f.clone(e,t);var i=n.magnitude(n.subtract(r,t.center,z));return i>t.radius&&(t.radius=i),t},f.intersect=function(e,r){var t=e.center,i=e.radius,o=n.dot(r,t)+r.w;return-i>o?s.OUTSIDE:i>o?s.INTERSECTING:s.INSIDE};var L=new n;f.transform=function(e,t,i){return r(i)||(i=new f),i.center=c.multiplyByPoint(t,e.center,i.center),i.radius=Math.max(n.magnitude(c.getColumn(t,0,L)),n.magnitude(c.getColumn(t,1,L)),n.magnitude(c.getColumn(t,2,L)))*e.radius,i},f.transformWithoutScale=function(e,t,n){return r(n)||(n=new f),n.center=c.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var D=new n;f.getPlaneDistances=function(e,t,i,o){r(o)||(o=new l);var a=n.subtract(e.center,t,D),u=n.multiplyByScalar(i,n.dot(i,a),D),s=n.magnitude(u);return o.start=s-e.radius,o.stop=s+e.radius,o};for(var F=new n,P=new n,B=new n,q=new n,_=new n,U=new o,G=new Array(8),Y=0;8>Y;++Y)G[Y]=new n;var W=new u;return f.projectTo2D=function(r,t,i){t=e(t,W);var o=t.getEllipsoid(),a=r.center,u=r.radius,s=o.geodeticSurfaceNormal(a,F),l=n.cross(n.UNIT_Z,s,P);n.normalize(l,l);var c=n.cross(s,l,B);n.normalize(c,c),n.multiplyByScalar(s,u,s),n.multiplyByScalar(c,u,c),n.multiplyByScalar(l,u,l);var m=n.negate(c,_),h=n.negate(l,q),y=G,p=y[0];n.add(s,c,p),n.add(p,l,p),p=y[1],n.add(s,c,p),n.add(p,h,p),p=y[2],n.add(s,m,p),n.add(p,h,p),p=y[3],n.add(s,m,p),n.add(p,l,p),n.negate(s,s),p=y[4],n.add(s,c,p),n.add(p,l,p),p=y[5],n.add(s,c,p),n.add(p,h,p),p=y[6],n.add(s,m,p),n.add(p,h,p),p=y[7],n.add(s,m,p),n.add(p,l,p);for(var d=y.length,v=0;d>v;++v){var w=y[v];n.add(a,w,w);var g=o.cartesianToCartographic(w,U);t.project(g,w)}i=f.fromPoints(y,i),a=i.center;var E=a.x,C=a.y,S=a.z;return a.x=S,a.y=E,a.z=C,i},f.equals=function(e,t){return e===t||r(e)&&r(t)&&n.equals(e.center,t.center)&&e.radius===t.radius},f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.union=function(e,r){return f.union(this,e,r)},f.prototype.expand=function(e,r){return f.expand(this,e,r)},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.getPlaneDistances=function(e,r,t){return f.getPlaneDistances(this,e,r,t)},f.prototype.projectTo2D=function(e,r){return f.projectTo2D(this,e,r)},f.prototype.equals=function(e){return f.equals(this,e)},f}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./BoundingSphere"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/Color",["./defaultValue","./defined","./freezeObject","./DeveloperError","./FeatureDetection","./Math"],function(e,r,t,n,i,o){"use strict";function a(e,r,t){return 0>t&&(t+=1),t>1&&(t-=1),1>6*t?e+6*(r-e)*t:1>2*t?r:2>3*t?e+6*(r-e)*(2/3-t):e}var u=function(r,t,n,i){this.red=e(r,1),this.green=e(t,1),this.blue=e(n,1),this.alpha=e(i,1)};u.fromBytes=function(r,t,n,i){return r=u.byteToFloat(e(r,255)),t=u.byteToFloat(e(t,255)),n=u.byteToFloat(e(n,255)),i=u.byteToFloat(e(i,255)),new u(r,t,n,i)};var s,l,c;i.supportsTypedArrays()&&(s=new ArrayBuffer(4),l=new Uint32Array(s),c=new Uint8Array(s)),u.fromRgba=function(e){return l[0]=e,u.fromBytes(c[0],c[1],c[2],c[3])},u.fromHsl=function(r,t,n,i){r=e(r,0)%1,t=e(t,0),n=e(n,0),i=e(i,1);var o=n,s=n,l=n;if(0!==t){var c;c=.5>n?n*(1+t):n+t-n*t;var f=2*n-c;o=a(f,c,r+1/3),s=a(f,c,r),l=a(f,c,r-1/3)}return new u(o,s,l,i)},u.fromRandom=function(t,i){t=e(t,e.EMPTY_OBJECT);var a=t.red;if(!r(a)){var s=e(t.minimumRed,0),l=e(t.maximumRed,1);if(s>l)throw new n("minimumRed must be less than or equal to maximumRed");a=s+o.nextRandomNumber()*(l-s)}var c=t.green;if(!r(c)){var f=e(t.minimumGreen,0),m=e(t.maximumGreen,1);if(f>m)throw new n("minimumGreen must be less than or equal to maximumGreen");c=f+o.nextRandomNumber()*(m-f)}var h=t.blue;if(!r(h)){var y=e(t.minimumBlue,0),p=e(t.maximumBlue,1);if(y>p)throw new n("minimumBlue must be less than or equal to maximumBlue");h=y+o.nextRandomNumber()*(p-y)}var d=t.alpha;if(!r(d)){var v=e(t.minimumAlpha,0),w=e(t.maximumAlpha,1);if(v>w)throw new n("minimumAlpha must be less than or equal to maximumAlpha");d=v+o.nextRandomNumber()*(w-v)}return r(i)?(i.red=a,i.green=c,i.blue=h,i.alpha=d,i):new u(a,c,h,d)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,m=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,h=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,y=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return u.fromCssColorString=function(t){if(!r(t))throw new n("color is required");var i=u[t.toUpperCase()];if(r(i))return u.clone(i);var o=f.exec(t);return null!==o?new u(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=m.exec(t),null!==o?new u(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=h.exec(t),null!==o?new u(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=y.exec(t),null!==o?u.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},u.packedLength=4,u.pack=function(t,i,o){if(!r(t))throw new n("value is required");if(!r(i))throw new n("array is required");o=e(o,0),i[o++]=t.red,i[o++]=t.green,i[o++]=t.blue,i[o]=t.alpha},u.unpack=function(t,i,o){if(!r(t))throw new n("array is required");return i=e(i,0),r(o)||(o=new u),o.red=t[i++],o.green=t[i++],o.blue=t[i++],o.alpha=t[i],o},u.byteToFloat=function(e){return e/255},u.floatToByte=function(e){return 1===e?255:0|256*e},u.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new u(e.red,e.green,e.blue,e.alpha):void 0},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},u.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},u.prototype.toCssColorString=function(){var e=u.floatToByte(this.red),r=u.floatToByte(this.green),t=u.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+r+","+t+")":"rgba("+e+","+r+","+t+","+this.alpha+")"},u.prototype.toBytes=function(e){var t=u.floatToByte(this.red),n=u.floatToByte(this.green),i=u.floatToByte(this.blue),o=u.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=o,e):[t,n,i,o]},u.prototype.toRgba=function(){return c[0]=u.floatToByte(this.red),c[1]=u.floatToByte(this.green),c[2]=u.floatToByte(this.blue),c[3]=u.floatToByte(this.alpha),l[0]},u.ALICEBLUE=t(u.fromCssColorString("#F0F8FF")),u.ANTIQUEWHITE=t(u.fromCssColorString("#FAEBD7")),u.AQUA=t(u.fromCssColorString("#00FFFF")),u.AQUAMARINE=t(u.fromCssColorString("#7FFFD4")),u.AZURE=t(u.fromCssColorString("#F0FFFF")),u.BEIGE=t(u.fromCssColorString("#F5F5DC")),u.BISQUE=t(u.fromCssColorString("#FFE4C4")),u.BLACK=t(u.fromCssColorString("#000000")),u.BLANCHEDALMOND=t(u.fromCssColorString("#FFEBCD")),u.BLUE=t(u.fromCssColorString("#0000FF")),u.BLUEVIOLET=t(u.fromCssColorString("#8A2BE2")),u.BROWN=t(u.fromCssColorString("#A52A2A")),u.BURLYWOOD=t(u.fromCssColorString("#DEB887")),u.CADETBLUE=t(u.fromCssColorString("#5F9EA0")),u.CHARTREUSE=t(u.fromCssColorString("#7FFF00")),u.CHOCOLATE=t(u.fromCssColorString("#D2691E")),u.CORAL=t(u.fromCssColorString("#FF7F50")),u.CORNFLOWERBLUE=t(u.fromCssColorString("#6495ED")),u.CORNSILK=t(u.fromCssColorString("#FFF8DC")),u.CRIMSON=t(u.fromCssColorString("#DC143C")),u.CYAN=t(u.fromCssColorString("#00FFFF")),u.DARKBLUE=t(u.fromCssColorString("#00008B")),u.DARKCYAN=t(u.fromCssColorString("#008B8B")),u.DARKGOLDENROD=t(u.fromCssColorString("#B8860B")),u.DARKGRAY=t(u.fromCssColorString("#A9A9A9")),u.DARKGREEN=t(u.fromCssColorString("#006400")),u.DARKGREY=u.DARKGRAY,u.DARKKHAKI=t(u.fromCssColorString("#BDB76B")),u.DARKMAGENTA=t(u.fromCssColorString("#8B008B")),u.DARKOLIVEGREEN=t(u.fromCssColorString("#556B2F")),u.DARKORANGE=t(u.fromCssColorString("#FF8C00")),u.DARKORCHID=t(u.fromCssColorString("#9932CC")),u.DARKRED=t(u.fromCssColorString("#8B0000")),u.DARKSALMON=t(u.fromCssColorString("#E9967A")),u.DARKSEAGREEN=t(u.fromCssColorString("#8FBC8F")),u.DARKSLATEBLUE=t(u.fromCssColorString("#483D8B")),u.DARKSLATEGRAY=t(u.fromCssColorString("#2F4F4F")),u.DARKSLATEGREY=u.DARKSLATEGRAY,u.DARKTURQUOISE=t(u.fromCssColorString("#00CED1")),u.DARKVIOLET=t(u.fromCssColorString("#9400D3")),u.DEEPPINK=t(u.fromCssColorString("#FF1493")),u.DEEPSKYBLUE=t(u.fromCssColorString("#00BFFF")),u.DIMGRAY=t(u.fromCssColorString("#696969")),u.DIMGREY=u.DIMGRAY,u.DODGERBLUE=t(u.fromCssColorString("#1E90FF")),u.FIREBRICK=t(u.fromCssColorString("#B22222")),u.FLORALWHITE=t(u.fromCssColorString("#FFFAF0")),u.FORESTGREEN=t(u.fromCssColorString("#228B22")),u.FUSCHIA=t(u.fromCssColorString("#FF00FF")),u.GAINSBORO=t(u.fromCssColorString("#DCDCDC")),u.GHOSTWHITE=t(u.fromCssColorString("#F8F8FF")),u.GOLD=t(u.fromCssColorString("#FFD700")),u.GOLDENROD=t(u.fromCssColorString("#DAA520")),u.GRAY=t(u.fromCssColorString("#808080")),u.GREEN=t(u.fromCssColorString("#008000")),u.GREENYELLOW=t(u.fromCssColorString("#ADFF2F")),u.GREY=u.GRAY,u.HONEYDEW=t(u.fromCssColorString("#F0FFF0")),u.HOTPINK=t(u.fromCssColorString("#FF69B4")),u.INDIANRED=t(u.fromCssColorString("#CD5C5C")),u.INDIGO=t(u.fromCssColorString("#4B0082")),u.IVORY=t(u.fromCssColorString("#FFFFF0")),u.KHAKI=t(u.fromCssColorString("#F0E68C")),u.LAVENDER=t(u.fromCssColorString("#E6E6FA")),u.LAVENDAR_BLUSH=t(u.fromCssColorString("#FFF0F5")),u.LAWNGREEN=t(u.fromCssColorString("#7CFC00")),u.LEMONCHIFFON=t(u.fromCssColorString("#FFFACD")),u.LIGHTBLUE=t(u.fromCssColorString("#ADD8E6")),u.LIGHTCORAL=t(u.fromCssColorString("#F08080")),u.LIGHTCYAN=t(u.fromCssColorString("#E0FFFF")),u.LIGHTGOLDENRODYELLOW=t(u.fromCssColorString("#FAFAD2")),u.LIGHTGRAY=t(u.fromCssColorString("#D3D3D3")),u.LIGHTGREEN=t(u.fromCssColorString("#90EE90")),u.LIGHTGREY=u.LIGHTGRAY,u.LIGHTPINK=t(u.fromCssColorString("#FFB6C1")),u.LIGHTSEAGREEN=t(u.fromCssColorString("#20B2AA")),u.LIGHTSKYBLUE=t(u.fromCssColorString("#87CEFA")),u.LIGHTSLATEGRAY=t(u.fromCssColorString("#778899")),u.LIGHTSLATEGREY=u.LIGHTSLATEGRAY,u.LIGHTSTEELBLUE=t(u.fromCssColorString("#B0C4DE")),u.LIGHTYELLOW=t(u.fromCssColorString("#FFFFE0")),u.LIME=t(u.fromCssColorString("#00FF00")),u.LIMEGREEN=t(u.fromCssColorString("#32CD32")),u.LINEN=t(u.fromCssColorString("#FAF0E6")),u.MAGENTA=t(u.fromCssColorString("#FF00FF")),u.MAROON=t(u.fromCssColorString("#800000")),u.MEDIUMAQUAMARINE=t(u.fromCssColorString("#66CDAA")),u.MEDIUMBLUE=t(u.fromCssColorString("#0000CD")),u.MEDIUMORCHID=t(u.fromCssColorString("#BA55D3")),u.MEDIUMPURPLE=t(u.fromCssColorString("#9370DB")),u.MEDIUMSEAGREEN=t(u.fromCssColorString("#3CB371")),u.MEDIUMSLATEBLUE=t(u.fromCssColorString("#7B68EE")),u.MEDIUMSPRINGGREEN=t(u.fromCssColorString("#00FA9A")),u.MEDIUMTURQUOISE=t(u.fromCssColorString("#48D1CC")),u.MEDIUMVIOLETRED=t(u.fromCssColorString("#C71585")),u.MIDNIGHTBLUE=t(u.fromCssColorString("#191970")),u.MINTCREAM=t(u.fromCssColorString("#F5FFFA")),u.MISTYROSE=t(u.fromCssColorString("#FFE4E1")),u.MOCCASIN=t(u.fromCssColorString("#FFE4B5")),u.NAVAJOWHITE=t(u.fromCssColorString("#FFDEAD")),u.NAVY=t(u.fromCssColorString("#000080")),u.OLDLACE=t(u.fromCssColorString("#FDF5E6")),u.OLIVE=t(u.fromCssColorString("#808000")),u.OLIVEDRAB=t(u.fromCssColorString("#6B8E23")),u.ORANGE=t(u.fromCssColorString("#FFA500")),u.ORANGERED=t(u.fromCssColorString("#FF4500")),u.ORCHID=t(u.fromCssColorString("#DA70D6")),u.PALEGOLDENROD=t(u.fromCssColorString("#EEE8AA")),u.PALEGREEN=t(u.fromCssColorString("#98FB98")),u.PALETURQUOISE=t(u.fromCssColorString("#AFEEEE")),u.PALEVIOLETRED=t(u.fromCssColorString("#DB7093")),u.PAPAYAWHIP=t(u.fromCssColorString("#FFEFD5")),u.PEACHPUFF=t(u.fromCssColorString("#FFDAB9")),u.PERU=t(u.fromCssColorString("#CD853F")),u.PINK=t(u.fromCssColorString("#FFC0CB")),u.PLUM=t(u.fromCssColorString("#DDA0DD")),u.POWDERBLUE=t(u.fromCssColorString("#B0E0E6")),u.PURPLE=t(u.fromCssColorString("#800080")),u.RED=t(u.fromCssColorString("#FF0000")),u.ROSYBROWN=t(u.fromCssColorString("#BC8F8F")),u.ROYALBLUE=t(u.fromCssColorString("#4169E1")),u.SADDLEBROWN=t(u.fromCssColorString("#8B4513")),u.SALMON=t(u.fromCssColorString("#FA8072")),u.SANDYBROWN=t(u.fromCssColorString("#F4A460")),u.SEAGREEN=t(u.fromCssColorString("#2E8B57")),u.SEASHELL=t(u.fromCssColorString("#FFF5EE")),u.SIENNA=t(u.fromCssColorString("#A0522D")),u.SILVER=t(u.fromCssColorString("#C0C0C0")),u.SKYBLUE=t(u.fromCssColorString("#87CEEB")),u.SLATEBLUE=t(u.fromCssColorString("#6A5ACD")),u.SLATEGRAY=t(u.fromCssColorString("#708090")),u.SLATEGREY=u.SLATEGRAY,u.SNOW=t(u.fromCssColorString("#FFFAFA")),u.SPRINGGREEN=t(u.fromCssColorString("#00FF7F")),u.STEELBLUE=t(u.fromCssColorString("#4682B4")),u.TAN=t(u.fromCssColorString("#D2B48C")),u.TEAL=t(u.fromCssColorString("#008080")),u.THISTLE=t(u.fromCssColorString("#D8BFD8")),u.TOMATO=t(u.fromCssColorString("#FF6347")),u.TURQUOISE=t(u.fromCssColorString("#40E0D0")),u.VIOLET=t(u.fromCssColorString("#EE82EE")),u.WHEAT=t(u.fromCssColorString("#F5DEB3")),u.WHITE=t(u.fromCssColorString("#FFFFFF")),u.WHITESMOKE=t(u.fromCssColorString("#F5F5F5")),u.YELLOW=t(u.fromCssColorString("#FFFF00")),u.YELLOWGREEN=t(u.fromCssColorString("#9ACD32")),u}),define("Core/SimplePolylineGeometry",["./defined","./DeveloperError","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./defaultValue","./BoundingSphere","./Geometry","./GeometryAttribute","./GeometryAttributes","./Color","./Cartesian3"],function(e,r,t,n,i,o,a,u,s,l,c,f){"use strict";
var m=function(t){t=o(t,o.EMPTY_OBJECT);var n=t.positions,i=t.colors,a=o(t.colorsPerVertex,!1);if(!e(n)||n.length<2)throw new r("At least two positions are required.");if(e(i)&&(a&&i.length<n.length||!a&&i.length<n.length-1))throw new r("colors has an invalid length.");this._positions=n,this._colors=i,this._perVertex=a,this._workerName="createSimplePolylineGeometry"};return m.createGeometry=function(r){var o,m=r._positions,h=r._colors,y=r._perVertex,p=e(h)&&!y,d=0,v=0,w=m.length,g=p?2*m.length-2:m.length,E=new Float64Array(3*g),C=e(h)?new Uint8Array(4*g):void 0;for(o=0;w>o;++o){var S,b=m[o];if(p&&o>0&&(f.pack(b,E,d),d+=3,S=h[o-1],C[v++]=c.floatToByte(S.red),C[v++]=c.floatToByte(S.green),C[v++]=c.floatToByte(S.blue),C[v++]=c.floatToByte(S.alpha)),p&&o===w-1)break;f.pack(b,E,d),d+=3,e(h)&&(S=h[o],C[v++]=c.floatToByte(S.red),C[v++]=c.floatToByte(S.green),C[v++]=c.floatToByte(S.blue),C[v++]=c.floatToByte(S.alpha))}var x=new l;x.position=new s({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:E}),e(h)&&(x.color=new s({componentDatatype:t.UNSIGNED_BYTE,componentsPerAttribute:4,values:C,normalize:!0}));var A=p?g:2*(g-1),T=n.createTypedArray(g,A),M=p?2:1;for(d=0,o=0;g-1>o;o+=M)T[d++]=o,T[d++]=o+1;return new u({attributes:x,indices:T,primitiveType:i.LINES,boundingSphere:a.fromPoints(m)})},m}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t){this.x=e(r,0),this.y=e(t,0)};i.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new i(e,t)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(r,t,n){n=e(n,0),t[n++]=r.x,t[n]=r.y},i.unpack=function(t,n,o){return n=e(n,0),r(o)||(o=new i),o.x=t[n++],o.y=t[n],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y)},i.getMinimumByComponent=function(e,t,n){return r(n)||(n=new i),n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},i.getMaximumByComponent=function(e,t,n){return r(n)||(n=new i),n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,r){return i.subtract(e,r,o),i.magnitude(o)},i.normalize=function(e,t){var n=i.magnitude(e);return r(t)?(t.x=e.x/n,t.y=e.y/n,t):new i(e.x/n,e.y/n)},i.dot=function(e,r){return e.x*r.x+e.y*r.y},i.multiplyComponents=function(e,t,n){return r(n)?(n.x=e.x*t.x,n.y=e.y*t.y,n):new i(e.x*t.x,e.y*t.y)},i.add=function(e,t,n){return r(n)?(n.x=e.x+t.x,n.y=e.y+t.y,n):new i(e.x+t.x,e.y+t.y)},i.subtract=function(e,t,n){return r(n)?(n.x=e.x-t.x,n.y=e.y-t.y,n):new i(e.x-t.x,e.y-t.y)},i.multiplyByScalar=function(e,t,n){return r(n)?(n.x=e.x*t,n.y=e.y*t,n):new i(e.x*t,e.y*t)},i.divideByScalar=function(e,t,n){return r(n)?(n.x=e.x/t,n.y=e.y/t,n):new i(e.x/t,e.y/t)},i.negate=function(e,t){return r(t)?(t.x=-e.x,t.y=-e.y,t):new i(-e.x,-e.y)},i.abs=function(e,t){return r(t)?(t.x=Math.abs(e.x),t.y=Math.abs(e.y),t):new i(Math.abs(e.x),Math.abs(e.y))};var a=new i;i.lerp=function(e,r,t,n){return i.multiplyByScalar(r,t,a),n=i.multiplyByScalar(e,1-t,n),i.add(a,n,n)};var u=new i,s=new i;i.angleBetween=function(e,r){return i.normalize(e,u),i.normalize(r,s),Math.acos(i.dot(u,s))};var l=new i;return i.mostOrthogonalAxis=function(e,r){var t=i.normalize(e,l);return i.abs(t,t),r=t.x<=t.y?i.clone(i.UNIT_X,r):i.clone(i.UNIT_Y,r)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},i.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,o=new r,a=new r,u=function(u,s,l,c,f){if(!(t(u)&&t(s)&&t(l)&&t(c)))throw new n("point, p0, p1, and p2 are required.");t(f)||(f=new r);var m,h,y,p,d,v,w,g;t(s.z)?(m=r.subtract(l,s,i),h=r.subtract(c,s,o),y=r.subtract(u,s,a),p=r.dot(m,m),d=r.dot(m,h),v=r.dot(m,y),w=r.dot(h,h),g=r.dot(h,y)):(m=e.subtract(l,s,i),h=e.subtract(c,s,o),y=e.subtract(u,s,a),p=e.dot(m,m),d=e.dot(m,h),v=e.dot(m,y),w=e.dot(h,h),g=e.dot(h,y));var E=1/(p*w-d*d);return f.y=(w*v-d*g)*E,f.z=(p*g-d*v)*E,f.x=1-f.y-f.z,f};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!r(e))throw new t("value is required");r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){if(!r(e))throw new t("cartesian is required");r(o)||(o=new n);var a=o.high,u=o.low;return n.encode(e.x,i),a.x=i.high,u.x=i.low,n.encode(e.y,i),a.y=i.high,u.y=i.low,n.encode(e.z,i),a.z=i.high,u.z=i.low,o};var o=new n;return n.writeElements=function(e,i,a){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("cartesianArray is required");if("number"!=typeof a||0>a)throw new t("index must be a number greater than or equal to 0.");n.fromCartesian(e,o);var u=o.high,s=o.low;i[a]=u.x,i[a+1]=u.y,i[a+2]=u.z,i[a+3]=s.x,i[a+4]=s.y,i[a+5]=s.z},n}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.discriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.realRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var u=Math.abs(o),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(a=-o/n,0>a)return[];var l=Math.sqrt(a);return[-l,l]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var c=i*i,f=4*n*o,m=t(c,-f,r.EPSILON14);if(0>m)return[];var h=-.5*t(i,r.sign(i)*Math.sqrt(m),r.EPSILON14);return i>0?[h/n,o/h]:[o/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,o,a=e,u=r/3,s=t/3,l=n,c=a*s,f=u*l,m=u*u,h=s*s,y=a*s-m,p=a*l-u*s,d=u*l-h,v=4*y*d-p*p;if(0>v){var w,g,E;m*f>=c*h?(w=a,g=y,E=-2*u*y+a*p):(w=l,g=d,E=-l*p+2*s*d);var C=0>E?-1:1,S=-C*Math.abs(w)*Math.sqrt(-v);o=-E+S;var b=o/2,x=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),A=o===S?-x:-g/x;return i=0>=g?x+A:-E/(x*x+A*A+g),m*f>=c*h?[(i-u)/a]:[-l/(i+s)]}var T=y,M=-2*u*y+a*p,I=d,O=-l*p+2*s*d,N=Math.sqrt(v),R=Math.sqrt(3)/2,z=Math.abs(Math.atan2(a*N,-M)/3);i=2*Math.sqrt(-T);var L=Math.cos(z);o=i*L;var D=i*(-L/2-R*Math.sin(z)),F=o+D>2*u?o-u:D-u,P=a,B=F/P;z=Math.abs(Math.atan2(l*N,-O)/3),i=2*Math.sqrt(-I),L=Math.cos(z),o=i*L,D=i*(-L/2-R*Math.sin(z));var q=-l,_=2*s>o+D?o+s:D+s,U=q/_,G=P*_,Y=-F*_-P*q,W=F*q,V=(s*Y-u*W)/(-u*Y+s*G);return V>=B?U>=B?U>=V?[B,V,U]:[B,U,V]:[U,B,V]:U>=B?[V,B,U]:U>=V?[V,U,B]:[U,V,B]}var n={};return n.discriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=t*t,u=n*n,s=i*i,l=18*r*t*n*i+a*u-27*o*s-4*(r*u*n+a*t*i);return l},n.realRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var u,s;if(0===n)return r.realRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];s=-a/n;var l=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[l,l,l]}return 0===a?(u=r.realRoots(n,0,o),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,o,a)}return 0===o?0===a?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,a):0===a?(u=r.realRoots(n,i,o),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./DeveloperError","./Math","./CubicRealPolynomial","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(e,i,o,a){var u=e*e,s=i-3*u/8,l=o-i*e/2+u*e/8,c=a-o*e/4+i*u/16-3*u*u/256,f=t.realRoots(1,2*s,s*s-4*c,-l*l);if(f.length>0){var m=-e/4,h=f[f.length-1];if(Math.abs(h)<r.EPSILON14){var y=n.realRoots(1,s,c);if(2===y.length){var p,d=y[0],v=y[1];if(d>=0&&v>=0){var w=Math.sqrt(d),g=Math.sqrt(v);return[m-g,m-w,m+w,m+g]}if(d>=0&&0>v)return p=Math.sqrt(d),[m-p,m+p];if(0>d&&v>=0)return p=Math.sqrt(v),[m-p,m+p]}return[]}if(h>0){var E=Math.sqrt(h),C=(s+h-l/E)/2,S=(s+h+l/E)/2,b=n.realRoots(1,E,C),x=n.realRoots(1,-E,S);return 0!==b.length?(b[0]+=m,b[1]+=m,0!==x.length?(x[0]+=m,x[1]+=m,b[1]<=x[0]?[b[0],b[1],x[0],x[1]]:x[1]<=b[0]?[x[0],x[1],b[0],b[1]]:b[0]>=x[0]&&b[1]<=x[1]?[x[0],b[0],b[1],x[1]]:x[0]>=b[0]&&x[1]<=b[1]?[b[0],x[0],x[1],b[1]]:b[0]>x[0]&&b[0]<x[1]?[x[0],b[0],x[1],b[1]]:[b[0],x[0],b[1],x[1]]):b):0!==x.length?(x[0]+=m,x[1]+=m,x):[]}}return[]}function o(e,i,o,a){var u=o*o,s=i*i,l=e*e,c=-2*i,f=o*e+s-4*a,m=l*a-o*i*e+u,h=t.realRoots(1,c,f,m);if(h.length>0){var y,p,d=h[0],v=i-d,w=v*v,g=e/2,E=v/2,C=w-4*a,S=w+4*Math.abs(a),b=l-4*d,x=l+4*Math.abs(d);if(0>d||b*S>C*x){var A=Math.sqrt(b);y=A/2,p=0===A?0:(e*E-o)/A}else{var T=Math.sqrt(C);y=0===T?0:(e*E-o)/T,p=T/2}var M,I;0===g&&0===y?(M=0,I=0):r.sign(g)===r.sign(y)?(M=g+y,I=d/M):(I=g-y,M=d/I);var O,N;0===E&&0===p?(O=0,N=0):r.sign(E)===r.sign(p)?(O=E+p,N=a/O):(N=E-p,O=a/N);var R=n.realRoots(1,M,O),z=n.realRoots(1,I,N);if(0!==R.length)return 0!==z.length?R[1]<=z[0]?[R[0],R[1],z[0],z[1]]:z[1]<=R[0]?[z[0],z[1],R[0],R[1]]:R[0]>=z[0]&&R[1]<=z[1]?[z[0],R[0],R[1],z[1]]:z[0]>=R[0]&&z[1]<=R[1]?[R[0],z[0],z[1],R[1]]:R[0]>z[0]&&R[0]<z[1]?[z[0],R[0],z[1],R[1]]:[R[0],z[0],R[1],z[1]]:R;if(0!==z.length)return z}return[]}var a={};return a.discriminant=function(r,t,n,i,o){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");if("number"!=typeof o)throw new e("e is a required number.");var a=r*r,u=a*r,s=t*t,l=s*t,c=n*n,f=c*n,m=i*i,h=m*i,y=o*o,p=y*o,d=s*c*m-4*l*h-4*r*f*m+18*r*t*n*h-27*a*m*m+256*u*p+o*(18*l*n*i-4*s*f+16*r*c*c-80*r*t*c*i-6*r*s*m+144*a*n*m)+y*(144*r*s*n-27*s*s-128*a*c-192*a*t*i);return d},a.realRoots=function(n,a,u,s,l){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof a)throw new e("b is a required number.");if("number"!=typeof u)throw new e("c is a required number.");if("number"!=typeof s)throw new e("d is a required number.");if("number"!=typeof l)throw new e("e is a required number.");if(Math.abs(n)<r.EPSILON15)return t.realRoots(a,u,s,l);var c=a/n,f=u/n,m=s/n,h=l/n,y=0>c?1:0;switch(y+=0>f?y+1:y,y+=0>m?y+1:y,y+=0>h?y+1:y){case 0:return i(c,f,m,h);case 1:return o(c,f,m,h);case 2:return o(c,f,m,h);case 3:return i(c,f,m,h);case 4:return i(c,f,m,h);case 5:return o(c,f,m,h);case 6:return i(c,f,m,h);case 7:return i(c,f,m,h);case 8:return o(c,f,m,h);case 9:return i(c,f,m,h);case 10:return i(c,f,m,h);case 11:return o(c,f,m,h);case 12:return i(c,f,m,h);case 13:return i(c,f,m,h);case 14:return i(c,f,m,h);case 15:return i(c,f,m,h);default:return void 0}},a}),define("Core/IntersectionTests",["./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,r,t,n,i,o,a,u){"use strict";function s(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}function l(e,r,i,l,c){var f,m=l*l,h=c*c,y=(e[o.COLUMN1ROW1]-e[o.COLUMN2ROW2])*h,p=c*(l*s(e[o.COLUMN1ROW0],e[o.COLUMN0ROW1],t.EPSILON15)+r.y),d=e[o.COLUMN0ROW0]*m+e[o.COLUMN2ROW2]*h+l*r.x+i,v=h*s(e[o.COLUMN2ROW1],e[o.COLUMN1ROW2],t.EPSILON15),w=c*(l*s(e[o.COLUMN2ROW0],e[o.COLUMN0ROW2])+r.z),g=[];if(0===w&&0===v){if(f=a.realRoots(y,p,d),0===f.length)return g;var E=f[0],C=Math.sqrt(Math.max(1-E*E,0));if(g.push(new n(l,c*E,c*-C)),g.push(new n(l,c*E,c*C)),2===f.length){var S=f[1],b=Math.sqrt(Math.max(1-S*S,0));g.push(new n(l,c*S,c*-b)),g.push(new n(l,c*S,c*b))}return g}var x=w*w,A=v*v,T=y*y,M=w*v,I=T+A,O=2*(p*y+M),N=2*d*y+p*p-A+x,R=2*(d*p-M),z=d*d-x;if(0===I&&0===O&&0===N&&0===R)return g;f=u.realRoots(I,O,N,R,z);var L=f.length;if(0===L)return g;for(var D=0;L>D;++D){var F,P=f[D],B=P*P,q=Math.max(1-B,0),_=Math.sqrt(q);F=t.sign(y)===t.sign(d)?s(y*B+d,p*P,t.EPSILON12):t.sign(d)===t.sign(p*P)?s(y*B,p*P+d,t.EPSILON12):s(y*B+p*P,d,t.EPSILON12);var U=s(v*P,w,t.EPSILON15),G=F*U;0>G?g.push(new n(l,c*P,c*_)):G>0?g.push(new n(l,c*P,c*-_)):0!==_?(g.push(new n(l,c*P,c*-_)),g.push(new n(l,c*P,c*_)),++D):g.push(new n(l,c*P,c*_))}return g}var c={};c.rayPlane=function(i,o,a){if(!e(i))throw new r("ray is required.");if(!e(o))throw new r("plane is required.");var u=i.origin,s=i.direction,l=o.normal,c=n.dot(l,s);if(Math.abs(c)<t.EPSILON15)return void 0;var f=(-o.distance-n.dot(l,u))/c;return 0>f?void 0:(a=n.multiplyByScalar(s,f,a),n.add(u,a,a))};var f=new n,m=new n;c.rayEllipsoid=function(t,i){if(!e(t))throw new r("ray is required.");if(!e(i))throw new r("ellipsoid is required.");var o,a,u,s,l,c=i.getOneOverRadii(),h=n.multiplyComponents(c,t.origin,f),y=n.multiplyComponents(c,t.direction,m),p=n.magnitudeSquared(h),d=n.dot(h,y);if(p>1){if(d>=0)return void 0;var v=d*d;if(o=p-1,a=n.magnitudeSquared(y),u=a*o,u>v)return void 0;if(v>u){s=d*d-u,l=-d+Math.sqrt(s);var w=l/a,g=o/l;return g>w?{start:w,stop:g}:{start:g,stop:w}}var E=Math.sqrt(o/a);return{start:E,stop:E}}return 1>p?(o=p-1,a=n.magnitudeSquared(y),u=a*o,s=d*d-u,l=-d+Math.sqrt(s),{start:0,stop:l/a}):0>d?(a=n.magnitudeSquared(y),{start:0,stop:-d/a}):void 0},c.grazingAltitudeLocation=function(a,u){if(!e(a))throw new r("ray is required.");if(!e(u))throw new r("ellipsoid is required.");var s=a.origin,c=a.direction,f=u.geodeticSurfaceNormal(s);if(n.dot(c,f)>=0)return s;var m,h,y=e(this.rayEllipsoid(a,u)),p=u.transformPositionToScaledSpace(c),d=n.normalize(p),v=n.mostOrthogonalAxis(p),w=n.normalize(n.cross(v,d)),g=n.normalize(n.cross(d,w)),E=new o(d.x,w.x,g.x,d.y,w.y,g.y,d.z,w.z,g.z),C=o.transpose(E),S=o.fromScale(u.getRadii()),b=o.fromScale(u.getOneOverRadii()),x=new o(0,c.z,-c.y,-c.z,0,c.x,c.y,-c.x,0),A=o.multiply(o.multiply(C,b),x),T=o.multiply(o.multiply(A,S),E),M=o.multiplyByVector(A,s),I=l(T,n.negate(M),0,0,1),O=I.length;if(O>0){for(var N=n.ZERO,R=Number.NEGATIVE_INFINITY,z=0;O>z;++z){m=o.multiplyByVector(S,o.multiplyByVector(E,I[z]));var L=n.normalize(n.subtract(m,s)),D=n.dot(L,c);D>R&&(R=D,N=m)}var F=u.cartesianToCartographic(N);return R=t.clamp(R,0,1),h=n.magnitude(n.subtract(N,s))*Math.sqrt(1-R*R),h=y?-h:h,u.cartographicToCartesian(new i(F.longitude,F.latitude,h))}return void 0};var h=new n;return c.lineSegmentPlane=function(i,o,a,u){if(!e(i))throw new r("endPoint0 is required.");if(!e(o))throw new r("endPoint1 is required.");if(!e(a))throw new r("plane is required.");var s=n.subtract(o,i,h),l=a.normal,c=n.dot(l,s);if(Math.abs(c)<t.EPSILON6)return void 0;var f=n.dot(l,i),m=-(a.distance+f)/c;return 0>m||m>1?void 0:(e(u)||(u=new n),n.multiplyByScalar(s,m,u),n.add(i,u,u),u)},c.trianglePlaneIntersection=function(t,i,o,a){if(!(e(t)&&e(i)&&e(o)&&e(a)))throw new r("p0, p1, p2, and plane are required.");var u=a.normal,s=a.distance,l=n.dot(u,t)+s<0,f=n.dot(u,i)+s<0,m=n.dot(u,o)+s<0,h=0;h+=l?1:0,h+=f?1:0,h+=m?1:0;var y,p;if((1===h||2===h)&&(y=new n,p=new n),1===h){if(l)return c.lineSegmentPlane(t,i,a,y),c.lineSegmentPlane(t,o,a,p),{positions:[t,i,o,y,p],indices:[0,3,4,1,2,4,1,4,3]};if(f)return c.lineSegmentPlane(i,o,a,y),c.lineSegmentPlane(i,t,a,p),{positions:[t,i,o,y,p],indices:[1,3,4,2,0,4,2,4,3]};if(m)return c.lineSegmentPlane(o,t,a,y),c.lineSegmentPlane(o,i,a,p),{positions:[t,i,o,y,p],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!l)return c.lineSegmentPlane(i,t,a,y),c.lineSegmentPlane(o,t,a,p),{positions:[t,i,o,y,p],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return c.lineSegmentPlane(o,i,a,y),c.lineSegmentPlane(t,i,a,p),{positions:[t,i,o,y,p],indices:[2,0,4,2,4,3,1,3,4]};if(!m)return c.lineSegmentPlane(t,o,a,y),c.lineSegmentPlane(i,o,a,p),{positions:[t,i,o,y,p],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,o,a){if(!r(i))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var u=-e.dot(o,i);return r(a)?(e.clone(o,a.normal),a.distance=u,a):new n(o,u)},n.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},n.prototype.getPointDistance=function(e){return n.getPointDistance(this,e)},n}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!r(i))throw new t("indices is required.");var u=i.length;if(3>u||0!==u%3)throw new t("indices length must be a multiple of three.");if(0>=o)throw new t("maximumIndex must be greater than zero.");if(3>a)throw new t("cacheSize must be greater than two.");if(!r(o)){o=0;for(var s=0,l=i[s];u>s;)l>o&&(o=l),++s,l=i[s]}for(var c=[],f=0;o+1>f;f++)c[f]=0;for(var m=a+1,h=0;u>h;++h)m-c[i[h]]>a&&(c[i[h]]=m,++m);return(m-a+1)/(u/3)},n.tipsify=function(n){function i(e,r,t,n){for(;r.length>=1;){var i=r[r.length-1];if(r.splice(r.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,r,t,n,o,a,u){for(var s,l=-1,c=-1,f=0;f<t.length;){var m=t[f];n[m].numLiveTriangles&&(s=0,o-n[m].timeStamp+2*n[m].numLiveTriangles<=r&&(s=o-n[m].timeStamp),(s>c||-1===c)&&(c=s,l=m)),++f}return-1===l?i(n,a,e,u):l}n=e(n,e.EMPTY_OBJECT);var a,u=n.indices,s=n.maximumIndex,l=e(n.cacheSize,24);if(!r(u))throw new t("indices is required.");var c=u.length;if(3>c||0!==c%3)throw new t("indices length must be a multiple of three.");if(0>=s)throw new t("maximumIndex must be greater than zero.");if(3>l)throw new t("cacheSize must be greater than two.");var f=0,m=0,h=u[m],y=c;if(r(s))f=s+1;else{for(;y>m;)h>f&&(f=h),++m,h=u[m];if(-1===f)return 0;++f}for(var p=[],d=0;f>d;d++)p[d]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};m=0;for(var v=0;y>m;)p[u[m]].vertexTriangles.push(v),++p[u[m]].numLiveTriangles,p[u[m+1]].vertexTriangles.push(v),++p[u[m+1]].numLiveTriangles,p[u[m+2]].vertexTriangles.push(v),++p[u[m+2]].numLiveTriangles,++v,m+=3;var w=0,g=l+1;a=1;var E,C,S=[],b=[],x=0,A=[],T=c/3,M=[];for(d=0;T>d;d++)M[d]=!1;for(var I,O;-1!==w;){S=[],C=p[w],O=C.vertexTriangles.length;for(var N=0;O>N;++N)if(v=C.vertexTriangles[N],!M[v]){M[v]=!0,m=v+v+v;for(var R=0;3>R;++R)I=u[m],S.push(I),b.push(I),A[x]=I,++x,E=p[I],--E.numLiveTriangles,g-E.timeStamp>l&&(E.timeStamp=g,++g),++m}w=o(u,l,S,p,g,b,f)}return A},n}),define("Core/GeometryPipeline",["./barycentricCoordinates","./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./EncodedCartesian3","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./GeographicProjection","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./Tipsify","./BoundingSphere","./Geometry","./GeometryAttribute"],function(e,r,t,n,i,o,a,u,s,l,c,f,m,h,y,p,d,v,w,g,E,C,S){"use strict";function b(e,r,t,n,i){e[r++]=t,e[r++]=n,e[r++]=n,e[r++]=i,e[r++]=i,e[r]=t}function x(e){for(var r=e.length,t=6*(r/3),n=v.createTypedArray(r,t),i=0,o=0;r>o;o+=3,i+=6)b(n,i,e[o],e[o+1],e[o+2]);return n}function A(e){var r=e.length;if(r>=3){var t=6*(r-2),n=v.createTypedArray(r,t);b(n,0,e[0],e[1],e[2]);for(var i=6,o=3;r>o;++o,i+=6)b(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function T(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),n=v.createTypedArray(r,t),i=e[0],o=0,a=1;r>a;++a,o+=6)b(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}function M(e){var r={};for(var n in e)if(e.hasOwnProperty(n)&&t(e[n])&&t(e[n].values)){var i=e[n];r[n]=new S({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return r}function I(e,r,n){for(var i in r)if(r.hasOwnProperty(i)&&t(r[i])&&t(r[i].values))for(var o=r[i],a=0;a<o.componentsPerAttribute;++a)e[i].values.push(o.values[n*o.componentsPerAttribute+a])}function O(e,r){if(t(r))for(var n=r.values,i=n.length,a=0;i>a;a+=3)o.unpack(n,a,Z),h.multiplyByPoint(e,Z,Z),o.pack(Z,n,a)}function N(e,r){if(t(r))for(var n=r.values,i=n.length,a=0;i>a;a+=3)o.unpack(n,a,Z),m.multiplyByVector(e,Z,Z),Z=o.normalize(Z,Z),o.pack(Z,n,a)}function R(e){var r,n=e.length,i={},o=e[0].geometry.attributes;for(r in o)if(o.hasOwnProperty(r)&&t(o[r])&&t(o[r].values)){for(var a=o[r],u=a.values.length,s=!0,l=1;n>l;++l){var c=e[l].geometry.attributes[r];if(!t(c)||a.componentDatatype.value!==c.componentDatatype.value||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){s=!1;break}u+=c.values.length}s&&(i[r]=new S({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:d.createTypedArray(a.componentDatatype,u)}))}return i}function z(e){if(t(e.indices))return e;var r=C.computeNumberOfVertices(e);if(3>r)throw new n("The number of vertices must be at least three.");if(0!==r%3)throw new n("The number of vertices must be a multiple of three.");for(var i=v.createTypedArray(r,r),o=0;r>o;++o)i[o]=o;return e.indices=i,e}function L(e){var r=C.computeNumberOfVertices(e);if(3>r)throw new n("The number of vertices must be at least three.");var t=v.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var i=3,o=3;r>o;++o)t[i++]=o-1,t[i++]=0,t[i++]=o;return e.indices=t,e.primitiveType=w.TRIANGLES,e}function D(e){var r=C.computeNumberOfVertices(e);if(3>r)throw new n("The number of vertices must be at least 3.");var t=v.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var i=6,o=3;r-1>o;o+=2)t[i++]=o,t[i++]=o-1,t[i++]=o+1,r>o+2&&(t[i++]=o,t[i++]=o+1,t[i++]=o+2);return e.indices=t,e.primitiveType=w.TRIANGLES,e}function F(e){if(t(e.indices))return e;var r=C.computeNumberOfVertices(e);if(2>r)throw new n("The number of vertices must be at least two.");if(0!==r%2)throw new n("The number of vertices must be a multiple of 2.");for(var i=v.createTypedArray(r,r),o=0;r>o;++o)i[o]=o;return e.indices=i,e}function P(e){var r=C.computeNumberOfVertices(e);if(2>r)throw new n("The number of vertices must be at least two.");var t=v.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var i=2,o=2;r>o;++o)t[i++]=o-1,t[i++]=o;return e.indices=t,e.primitiveType=w.LINES,e}function B(e){var r=C.computeNumberOfVertices(e);if(2>r)throw new n("The number of vertices must be at least two.");var t=v.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var i=2,o=2;r>o;++o)t[i++]=o-1,t[i++]=o;return t[i++]=r-1,t[i]=0,e.indices=t,e.primitiveType=w.LINES,e}function q(e){switch(e.primitiveType){case w.TRIANGLE_FAN:return L(e);case w.TRIANGLE_STRIP:return D(e);case w.TRIANGLES:return z(e);case w.LINE_STRIP:return P(e);case w.LINE_LOOP:return B(e);case w.LINES:return F(e)}return e}function _(e,r){Math.abs(e.y)<f.EPSILON11&&(e.y=r?-f.EPSILON11:f.EPSILON11)}function U(e,r,t,n){o.add(e,o.multiplyByScalar(o.subtract(r,e,or),e.y/(e.y-r.y),or),t),o.clone(t,n),_(t,!0),_(n,!1)}function G(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;var n=e.y<0,i=r.y<0,o=t.y<0;_(e,n),_(r,i),_(t,o);var a=0;a+=n?1:0,a+=i?1:0,a+=o?1:0;var u=cr.indices;1===a?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(U(e,r,ar,sr),U(e,t,ur,lr),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(U(r,t,ar,sr),U(r,e,ur,lr),u[0]=1,u[3]=2,u[4]=0,u[6]=2):o&&(U(t,e,ar,sr),U(t,r,ur,lr),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===a&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?o||(U(t,e,ar,sr),U(t,r,ur,lr),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(U(r,t,ar,sr),U(r,e,ur,lr),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(U(e,r,ar,sr),U(e,t,ur,lr),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=cr.positions;return s[0]=e,s[1]=r,s[2]=t,cr.length=3,(1===a||2===a)&&(s[3]=ar,s[4]=ur,s[5]=sr,s[6]=lr,cr.length=7),cr}function Y(r,n,a,u,s,l,c,f){if(t(s)||t(l)||t(c)||t(f)){var m,h,y,p,d,v,w,g,E,C,S,b,x,A,T,M,I,O,N=u.positions,R=N[0],z=N[1],L=N[2];t(s)&&(m=o.fromArray(s,3*r),h=o.fromArray(s,3*n),y=o.fromArray(s,3*a)),t(l)&&(p=o.fromArray(l,3*r),d=o.fromArray(l,3*n),v=o.fromArray(l,3*a)),t(c)&&(w=o.fromArray(c,3*r),g=o.fromArray(c,3*n),E=o.fromArray(c,3*a)),t(f)&&(C=i.fromArray(f,2*r),S=i.fromArray(f,2*n),b=i.fromArray(f,2*a));for(var D=3;D<N.length;++D){var F=N[D],P=e(F,R,z,L);if(t(s)){x=o.multiplyByScalar(m,P.x,x),A=o.multiplyByScalar(h,P.y,A),T=o.multiplyByScalar(y,P.z,T);var B=o.add(x,A);o.add(B,T,B),o.normalize(B,B),s.push(B.x,B.y,B.z)}if(t(l)){x=o.multiplyByScalar(p,P.x,x),A=o.multiplyByScalar(d,P.y,A),T=o.multiplyByScalar(v,P.z,T);var q=o.add(x,A);o.add(q,T,q),o.normalize(q,q),l.push(q.x,q.y,q.z)}if(t(c)){x=o.multiplyByScalar(w,P.x,x),A=o.multiplyByScalar(g,P.y,A),T=o.multiplyByScalar(E,P.z,T);var _=o.add(x,A);o.add(_,T,_),o.normalize(_,_),c.push(_.x,_.y,_.z)}if(t(f)){M=i.multiplyByScalar(C,P.x,M),I=i.multiplyByScalar(S,P.y,I),O=i.multiplyByScalar(b,P.z,O);var U=i.add(M,I);i.add(U,O,U),f.push(U.x,U.y)}}}}function W(e){for(var r=e.attributes,n=r.position.values,i=t(r.normal)?r.normal.values:void 0,a=t(r.binormal)?r.binormal.values:void 0,u=t(r.tangent)?r.tangent.values:void 0,s=t(r.st)?r.st.values:void 0,l=e.indices,c=Array.prototype.slice.call(n,0),f=t(i)?Array.prototype.slice.call(i,0):void 0,m=t(a)?Array.prototype.slice.call(a,0):void 0,h=t(u)?Array.prototype.slice.call(u,0):void 0,y=t(s)?Array.prototype.slice.call(s,0):void 0,p=[],w=l.length,g=0;w>g;g+=3){var E=l[g],S=l[g+1],b=l[g+2],x=o.fromArray(n,3*E),A=o.fromArray(n,3*S),T=o.fromArray(n,3*b),M=G(x,A,T);if(t(M))if(c[3*E+1]=M.positions[0].y,c[3*S+1]=M.positions[1].y,c[3*b+1]=M.positions[2].y,M.length>3){for(var I=c.length/3,O=0;O<M.indices.length;++O){var N=M.indices[O];3>N?p.push(l[g+N]):p.push(N-3+I)}for(var R=3;R<M.positions.length;++R){var z=M.positions[R];c.push(z.x,z.y,z.z)}Y(E,S,b,M,f,m,h,y)}else p.push(E,S,b);else p.push(E,S,b)}e.attributes.position.values=new Float64Array(c),t(f)&&(r.normal.values=d.createTypedArray(r.normal.componentDatatype,f)),t(m)&&(r.binormal.values=d.createTypedArray(r.binormal.componentDatatype,m)),t(h)&&(r.tangent.values=d.createTypedArray(r.tangent.componentDatatype,h)),t(y)&&(r.st.values=d.createTypedArray(r.st.componentDatatype,y));var L=C.computeNumberOfVertices(e);e.indices=v.createTypedArray(L,p)}function V(e){for(var r=e.attributes,n=r.position.values,i=e.indices,a=Array.prototype.slice.call(n,0),u=[],s=y.fromPointNormal(o.ZERO,o.UNIT_Y),l=i.length,m=0;l>m;m+=2){var h=i[m],p=i[m+1],d=o.fromArray(n,3*h),w=o.fromArray(n,3*p);if(Math.abs(d.y)<f.EPSILON6&&(d.y=d.y<0?-f.EPSILON6:f.EPSILON6,a[3*h+1]=d.y),Math.abs(w.y)<f.EPSILON6&&(w.y=w.y<0?-f.EPSILON6:f.EPSILON6,a[3*p+1]=w.y),u.push(h),d.x<0||w.x<0){var g=c.lineSegmentPlane(d,w,s);if(t(g)){var E=o.multiplyByScalar(o.UNIT_Y,5*f.EPSILON9);d.y<0&&o.negate(E,E);var S=a.length/3;u.push(S,S+1);var b=o.add(g,E);a.push(b.x,b.y,b.z),o.negate(E,E),o.add(g,E,b),a.push(b.x,b.y,b.z)}}u.push(p)}e.attributes.position.values=new Float64Array(a);var x=C.computeNumberOfVertices(e);e.indices=v.createTypedArray(x,u)}var H={};H.toWireframe=function(e){if(!t(e))throw new n("geometry is required.");var r=e.indices;if(t(r)){switch(e.primitiveType){case w.TRIANGLES:e.indices=x(r);break;case w.TRIANGLE_STRIP:e.indices=A(r);break;case w.TRIANGLE_FAN:e.indices=T(r);break;default:throw new n("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=w.LINES}return e},H.createLineSegmentsForVectors=function(e,i,o){if(!t(e))throw new n("geometry is required.");if(!t(e.attributes.position))throw new n("geometry.attributes.position is required.");if(i=r(i,"normal"),!t(e.attributes[i]))throw new n("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+i+".");o=r(o,1e4);for(var a=e.attributes.position.values,u=e.attributes[i].values,s=a.length,l=new Float64Array(2*s),c=0,f=0;s>f;f+=3)l[c++]=a[f],l[c++]=a[f+1],l[c++]=a[f+2],l[c++]=a[f]+u[f]*o,l[c++]=a[f+1]+u[f+1]*o,l[c++]=a[f+2]+u[f+2]*o;var m,h=e.boundingSphere;return t(h)&&(m=new E(h.center,h.radius+o)),new C({attributes:{position:new S({componentDatatype:d.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:w.LINES,boundingSphere:m})},H.createAttributeIndices=function(e){if(!t(e))throw new n("geometry is required.");var r,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],o=e.attributes,a={},u=0,s=i.length;for(r=0;s>r;++r){var l=i[r];t(o[l])&&(a[l]=u++)}for(var c in o)o.hasOwnProperty(c)&&!t(a[c])&&(a[c]=u++);return a},H.reorderForPreVertexCache=function(e){if(!t(e))throw new n("geometry is required.");var r=C.computeNumberOfVertices(e),i=e.indices;if(t(i)){for(var o=new Int32Array(r),a=0;r>a;a++)o[a]=-1;for(var u,s=i,l=s.length,c=v.createTypedArray(r,l),f=0,m=0,h=0;l>f;)u=o[s[f]],-1!==u?c[m]=u:(u=s[f],o[u]=h,c[m]=h,++h),++f,++m;e.indices=c;var y=e.attributes;for(var p in y)if(y.hasOwnProperty(p)&&t(y[p])&&t(y[p].values)){for(var w=y[p],g=w.values,E=0,S=w.componentsPerAttribute,b=d.createTypedArray(w.componentDatatype,h*S);r>E;){var x=o[E];if(-1!==x)for(a=0;S>a;a++)b[S*x+a]=g[S*E+a];++E}w.values=b}}return e},H.reorderForPostVertexCache=function(e,r){if(!t(e))throw new n("geometry is required.");var i=e.indices;if(e.primitiveType===w.TRIANGLES&&t(i)){for(var o=i.length,a=0,u=0;o>u;u++)i[u]>a&&(a=i[u]);e.indices=g.tipsify({indices:i,maximumIndex:a,cacheSize:r})}return e},H.fitToUnsignedShortIndices=function(e){if(!t(e))throw new n("geometry is required.");if(t(e.indices)&&e.primitiveType!==w.TRIANGLES&&e.primitiveType!==w.LINES&&e.primitiveType!==w.POINTS)throw new n("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],i=C.computeNumberOfVertices(e);if(t(e.indices)&&i>f.SIXTY_FOUR_KILOBYTES){var o,a=[],u=[],s=0,l=M(e.attributes),c=e.indices,m=c.length;e.primitiveType===w.TRIANGLES?o=3:e.primitiveType===w.LINES?o=2:e.primitiveType===w.POINTS&&(o=1);for(var h=0;m>h;h+=o){for(var y=0;o>y;++y){var p=c[h+y],d=a[p];t(d)||(d=s++,a[p]=d,I(l,e.attributes,p)),u.push(d)}s+o>f.SIXTY_FOUR_KILOBYTES&&(r.push(new C({attributes:l,indices:u,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),a=[],u=[],s=0,l=M(e.attributes))}0!==u.length&&r.push(new C({attributes:l,indices:u,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else r.push(e);return r};var k=new o,K=new u;H.projectTo2D=function(e,r,i,a,u){if(!t(e))throw new n("geometry is required.");if(!t(r))throw new n("attributeName is required.");if(!t(i))throw new n("attributeName3D is required.");if(!t(a))throw new n("attributeName2D is required.");var s=e.attributes[r];if(!t(s))throw new n("geometry must have attribute matching the attributeName argument: "+r+".");if(s.componentDatatype.value!==d.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");
u=t(u)?u:new p;for(var l=u.getEllipsoid(),c=s.values,f=new Float64Array(c.length),m=0,h=0;h<c.length;h+=3){var y=o.fromArray(c,h,k),v=l.cartesianToCartographic(y,K);if(!t(v))throw new n("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var w=u.project(v,k);f[m++]=w.x,f[m++]=w.y,f[m++]=w.z}return e.attributes[i]=s,e.attributes[a]=new S({componentDatatype:d.DOUBLE,componentsPerAttribute:3,values:f}),delete e.attributes[r],e};var j={high:0,low:0};H.encodeAttribute=function(e,r,i,o){if(!t(e))throw new n("geometry is required.");if(!t(r))throw new n("attributeName is required.");if(!t(i))throw new n("attributeHighName is required.");if(!t(o))throw new n("attributeLowName is required.");var a=e.attributes[r];if(!t(a))throw new n("geometry must have attribute matching the attributeName argument: "+r+".");if(a.componentDatatype.value!==d.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var u=a.values,l=u.length,c=new Float32Array(l),f=new Float32Array(l),m=0;l>m;++m)s.encode(u[m],j),c[m]=j.high,f[m]=j.low;var h=a.componentsPerAttribute;return e.attributes[i]=new S({componentDatatype:d.FLOAT,componentsPerAttribute:h,values:c}),e.attributes[o]=new S({componentDatatype:d.FLOAT,componentsPerAttribute:h,values:f}),delete e.attributes[r],e};var Z=new o,Q=new h,X=new m;H.transformToWorldCoordinates=function(e){if(!t(e))throw new n("instance is required.");var r=e.modelMatrix;if(h.equals(r,h.IDENTITY))return e;var i=e.geometry.attributes;O(r,i.position),O(r,i.prevPosition),O(r,i.nextPosition),(t(i.normal)||t(i.binormal)||t(i.tangent))&&(h.inverse(r,Q),h.transpose(Q,Q),h.getRotation(Q,X),N(X,i.normal),N(X,i.binormal),N(X,i.tangent));var o=e.geometry.boundingSphere;return t(o)&&(e.geometry.boundingSphere=E.transform(o,r,o)),e.modelMatrix=h.clone(h.IDENTITY),e},H.combine=function(e){if(!t(e)||e.length<1)throw new n("instances is required and must have length greater than zero.");var r,i,a,u,s=e.length,l=e[0].modelMatrix,c=t(e[0].geometry.indices),f=e[0].geometry.primitiveType;for(i=1;s>i;++i){if(!h.equals(e[i].modelMatrix,l))throw new n("All instances must have the same modelMatrix.");if(t(e[i].geometry.indices)!==c)throw new n("All instance geometries must have an indices or not have one.");if(e[i].geometry.primitiveType!==f)throw new n("All instance geometries must have the same primitiveType.")}var m,y,p,d=R(e);for(r in d)if(d.hasOwnProperty(r))for(m=d[r].values,u=0,i=0;s>i;++i)for(y=e[i].geometry.attributes[r].values,p=y.length,a=0;p>a;++a)m[u++]=y[a];var g;if(c){var S=0;for(i=0;s>i;++i)S+=e[i].geometry.indices.length;var b=C.computeNumberOfVertices(new C({attributes:d,primitiveType:w.POINTS})),x=v.createTypedArray(b,S),A=0,T=0;for(i=0;s>i;++i){var M=e[i].geometry.indices,I=M.length;for(u=0;I>u;++u)x[A++]=T+M[u];T+=C.computeNumberOfVertices(e[i].geometry)}g=x}var O,N=new o,z=0;for(i=0;s>i;++i){if(O=e[i].geometry.boundingSphere,!t(O)){N=void 0;break}o.add(O.center,N,N)}if(t(N))for(o.divideByScalar(N,s,N),i=0;s>i;++i){O=e[i].geometry.boundingSphere;var L=o.magnitude(o.subtract(O.center,N))+O.radius;L>z&&(z=L)}return new C({attributes:d,indices:g,primitiveType:f,boundingSphere:t(N)?new E(N,z):void 0})};var J=new o,$=new o,er=new o,rr=new o;H.computeNormal=function(e){if(!t(e))throw new n("geometry is required.");var r=e.attributes,i=e.indices;if(!t(r.position)||!t(r.position.values))throw new n("geometry.attributes.position.values is required.");if(!t(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==w.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,u=e.attributes.position.values.length/3,s=i.length,l=new Array(u),c=new Array(s/3),f=new Array(s),m=0;u>m;m++)l[m]={indexOffset:0,count:0,currentCount:0};var h=0;for(m=0;s>m;m+=3){var y=i[m],p=i[m+1],v=i[m+2],g=3*y,E=3*p,C=3*v;$.x=a[g],$.y=a[g+1],$.z=a[g+2],er.x=a[E],er.y=a[E+1],er.z=a[E+2],rr.x=a[C],rr.y=a[C+1],rr.z=a[C+2],l[y].count++,l[p].count++,l[v].count++,o.subtract(er,$,er),o.subtract(rr,$,rr),c[h]=o.cross(er,rr),h++}var b=0;for(m=0;u>m;m++)l[m].indexOffset+=b,b+=l[m].count;h=0;var x;for(m=0;s>m;m+=3){x=l[i[m]];var A=x.indexOffset+x.currentCount;f[A]=h,x.currentCount++,x=l[i[m+1]],A=x.indexOffset+x.currentCount,f[A]=h,x.currentCount++,x=l[i[m+2]],A=x.indexOffset+x.currentCount,f[A]=h,x.currentCount++,h++}var T=new Float32Array(3*u);for(m=0;u>m;m++){var M=3*m;if(x=l[m],x.count>0){for(o.clone(o.ZERO,J),h=0;h<x.count;h++)o.add(J,c[f[x.indexOffset+h]],J);o.normalize(J,J),T[M]=J.x,T[M+1]=J.y,T[M+2]=J.z}else T[M]=0,T[M+1]=0,T[M+2]=1}return e.attributes.normal=new S({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:T}),e};var tr=new o,nr=new o,ir=new o;H.computeBinormalAndTangent=function(e){if(!t(e))throw new n("geometry is required.");var r=e.attributes,i=e.indices;if(!t(r.position)||!t(r.position.values))throw new n("geometry.attributes.position.values is required.");if(!t(r.normal)||!t(r.normal.values))throw new n("geometry.attributes.normal.values is required.");if(!t(r.st)||!t(r.st.values))throw new n("geometry.attributes.st.values is required.");if(!t(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==w.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var a=e.attributes.position.values,u=e.attributes.normal.values,s=e.attributes.st.values,l=e.attributes.position.values.length/3,c=i.length,f=new Array(3*l),m=0;m<f.length;m++)f[m]=0;var h,y,p;for(m=0;c>m;m+=3){var v=i[m],g=i[m+1],E=i[m+2];h=3*v,y=3*g,p=3*E;var C=2*v,b=2*g,x=2*E,A=a[h],T=a[h+1],M=a[h+2],I=s[C],O=s[C+1],N=s[b+1]-O,R=s[x+1]-O,z=1/((s[b]-I)*R-(s[x]-I)*N),L=(R*(a[y]-A)-N*(a[p]-A))*z,D=(R*(a[y+1]-T)-N*(a[p+1]-T))*z,F=(R*(a[y+2]-M)-N*(a[p+2]-M))*z;f[h]+=L,f[h+1]+=D,f[h+2]+=F,f[y]+=L,f[y+1]+=D,f[y+2]+=F,f[p]+=L,f[p+1]+=D,f[p+2]+=F}var P=new Float32Array(3*l),B=new Float32Array(3*l);for(m=0;l>m;m++){h=3*m,y=h+1,p=h+2;var q=o.fromArray(u,h,tr),_=o.fromArray(f,h,ir),U=o.dot(q,_);o.multiplyByScalar(q,U,nr),o.normalize(o.subtract(_,nr,_),_),B[h]=_.x,B[y]=_.y,B[p]=_.z,o.normalize(o.cross(q,_,_),_),P[h]=_.x,P[y]=_.y,P[p]=_.z}return e.attributes.tangent=new S({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:B}),e.attributes.binormal=new S({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:P}),e};var or=new o,ar=new o,ur=new o,sr=new o,lr=new o,cr={positions:new Array(7),indices:new Array(9)};return H.wrapLongitude=function(e){if(!t(e))throw new n("geometry is required.");var r=e.boundingSphere;if(t(r)){var i=r.center.x-r.radius;if(i>0||E.intersect(r,a.UNIT_Y)!==l.INTERSECTING)return e}return q(e),e.primitiveType===w.TRIANGLES?W(e):e.primitiveType===w.LINES&&V(e),e},H}),define("Scene/PrimitivePipeline",["../Core/defined","../Core/defaultValue","../Core/Color","../Core/ComponentDatatype","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryPipeline","../Core/Matrix4"],function(e,r,t,n,i,o,a,u,s,l){"use strict";function c(e,r,t){var n,i=!t,o=e.length;if(!i&&o>1){var a=e[0].modelMatrix;for(n=1;o>n;++n)if(!l.equals(a,e[n].modelMatrix)){i=!0;break}}if(i)for(n=0;o>n;++n)s.transformToWorldCoordinates(e[n]);else l.clone(e[0].modelMatrix,r)}function f(e,r){for(var i=e.length,o=0;i>o;++o){var a=e[o],s=a.geometry,l=s.attributes,c=l.position,f=4*(c.values.length/c.componentsPerAttribute);l.pickColor=new u({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(f)});for(var m=r[o],h=t.floatToByte(m.red),y=t.floatToByte(m.green),p=t.floatToByte(m.blue),d=t.floatToByte(m.alpha),v=l.pickColor.values,w=0;f>w;w+=4)v[w]=h,v[w+1]=y,v[w+2]=p,v[w+3]=d}}function m(r){var t,n=r.length,i=[],o=r[0].attributes;for(t in o)if(o.hasOwnProperty(t)){for(var a=o[t],u=!0,s=1;n>s;++s){var l=r[s].attributes[t];if(!e(l)||a.componentDatatype.value!==l.componentDatatype.value||a.componentsPerAttribute!==l.componentsPerAttribute||a.normalize!==l.normalize){u=!1;break}}u&&i.push(t)}return i}function h(e,r){for(var t=e.length,i=0;t>i;++i)for(var o=e[i],s=o.attributes,l=o.geometry,c=a.computeNumberOfVertices(l),f=r.length,m=0;f>m;++m){for(var h=r[m],y=s[h],p=y.componentDatatype,d=y.value,v=d.length,w=n.createTypedArray(p,c*v),g=0;c>g;++g)w.set(d,g*v);l.attributes[h]=new u({componentDatatype:p,componentsPerAttribute:v,normalize:y.normalize,values:w})}}function y(e){var r,t=e.instances,o=e.pickIds,a=e.projection,u=e.elementIndexUintSupported,l=e.allow3DOnly,y=e.allowPicking,p=e.vertexCacheOptimize,d=e.modelMatrix,v=t.length,w=t[0].geometry.primitiveType;for(r=1;v>r;++r)if(t[r].geometry.primitiveType!==w)throw new i("All instance geometries must have the same primitiveType.");if(c(t,d,l),!l)for(r=0;v>r;++r)s.wrapLongitude(t[r].geometry);y&&f(t,o);var g=m(t);if(h(t,g),p)for(r=0;v>r;++r)s.reorderForPostVertexCache(t[r].geometry),s.reorderForPreVertexCache(t[r].geometry);var E,C=s.combine(t),S=C.attributes;if(l)for(E in S)S.hasOwnProperty(E)&&S[E].componentDatatype.value===n.DOUBLE.value&&s.encodeAttribute(C,E,E+"3DHigh",E+"3DLow");else for(E in S)if(S.hasOwnProperty(E)&&S[E].componentDatatype.value===n.DOUBLE.value){var b=E+"3D",x=E+"2D";s.projectTo2D(C,E,b,x,a),s.encodeAttribute(C,b,b+"High",b+"Low"),s.encodeAttribute(C,x,x+"High",x+"Low")}return u?[C]:s.fitToUnsignedShortIndices(C)}function p(e,r,t){for(var i=[],o=e.attributes,a=t.length,u=0;a>u;++u){var s=t[u],l=o[s],c=l.componentDatatype;c.value===n.DOUBLE.value&&(c=n.FLOAT);var f=n.createTypedArray(c,l.values);i.push({index:r[s],componentDatatype:c,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,values:f}),delete o[s]}return i}function d(t,n,i){for(var o=[],u=m(t),s=t.length,l={},c={},f=0;s>f;++f)for(var h=t[f],y=a.computeNumberOfVertices(h.geometry),p=u.length,d=0;p>d;++d)for(var v=u[d],w=i[v],g=y;g>0;){for(var E,C=r(c[v],0),S=n[C],b=S.length,x=0;b>x&&(E=S[x],E.index!==w);++x);e(o[f])||(o[f]={}),e(o[f][v])||(o[f][v]={dirty:!1,value:h.attributes[v].value,indices:[]});var A,T=E.values.length/E.componentsPerAttribute,M=r(l[v],0);T>M+g?(A=g,o[f][v].indices.push({attribute:E,offset:M,count:A}),l[v]=M+g):(A=T-M,o[f][v].indices.push({attribute:E,offset:M,count:A}),l[v]=0,c[v]=C+1),g-=A}return o}function v(e){return{type:e.constructor.name,buffer:e.buffer}}function w(e){return new E[e.type](e.buffer)}if(!o.supportsTypedArrays())return{};var g={};g.combineGeometry=function(e){for(var r={instances:e.instances,pickIds:e.pickIds,ellipsoid:e.ellipsoid,projection:e.projection,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:l.clone(e.modelMatrix)},t=y(r),n=s.createAttributeIndices(t[0]),i=r.instances,o=m(i),a=[],u=t.length,c=0;u>c;++c){var f=t[c];a.push(p(f,n,o))}var h=d(i,a,n);return{geometries:t,modelMatrix:r.modelMatrix,attributeIndices:n,vaAttributes:a,vaAttributeIndices:h}};var E={Int8Array:Int8Array,Uint8Array:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};return g.transferGeometry=function(r,t){var n,i=r.attributes;for(var o in i)i.hasOwnProperty(o)&&e(i[o])&&e(i[o].values)&&(n=i[o].values,t.indexOf(i[o].values.buffer)<0&&t.push(n.buffer),e(n.type)||(i[o].values=v(n)));e(r.indices)&&(n=r.indices,t.push(n.buffer),e(n.type)||(r.indices=v(r.indices)))},g.transferGeometries=function(e,r){for(var t=e.length,n=0;t>n;++n)g.transferGeometry(e[n],r)},g.transferPerInstanceAttributes=function(e,r){for(var t=e.length,n=0;t>n;++n)for(var i=e[n],o=i.length,a=0;o>a;++a){var u=i[a].values;r.push(u.buffer),i[a].values=v(u)}},g.transferInstances=function(e,r){for(var t=e.length,n=0;t>n;++n){var i=e[n];g.transferGeometry(i.geometry,r)}},g.receiveGeometry=function(r){var t=r.attributes;for(var n in t)t.hasOwnProperty(n)&&e(t[n])&&e(t[n].values)&&(t[n].values=w(t[n].values));e(r.indices)&&(r.indices=w(r.indices))},g.receiveGeometries=function(e){for(var r=e.length,t=0;r>t;++t)g.receiveGeometry(e[t])},g.receivePerInstanceAttributes=function(e){for(var r=e.length,t=0;r>t;++t)for(var n=e[t],i=n.length,o=0;i>o;++o)n[o].values=w(n[o].values)},g.receiveInstances=function(e){for(var r=e.length,t=0;r>t;++t){var n=e[t];g.receiveGeometry(n.geometry)}},g}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined"],function(e,r){"use strict";var t=function(t){var n,i=[],o={id:void 0,result:void 0,error:void 0};return function(a){var u=a.data;i.length=0,o.id=u.id,o.error=void 0,o.result=void 0;try{o.result=t(u.parameters,i)}catch(s){o.error=s}r(n)||(n=e(self.webkitPostMessage,self.postMessage));try{n(o,i)}catch(s){o.result=void 0,o.error="postMessage failed with error: "+s+"\n  with responseMessage: "+JSON.stringify(o),n(o)}}};return t}),define("Workers/createSimplePolylineGeometry",["../Core/SimplePolylineGeometry","../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,r,t){"use strict";function n(t,n){var i=t.geometry,o=e.createGeometry(i);return r.transferGeometry(o,n),{geometry:o,index:t.index}}return t(n)})}();