/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2013 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var t=function(t){return void 0!==t};return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var e=Object.freeze;return t(e)||(e=function(t){return t}),e}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";var e=function(t,e){return void 0!==t?t:e};return e.EMPTY_OBJECT=t({}),e}),define("Core/DeveloperError",["./defined"],function(t){"use strict";var e=function(t){this.name="DeveloperError",this.message=t;var e=new Error;this.stack=e.stack};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,n,r){"use strict";var i=function(e,n,r){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0)};i.fromSpherical=function(n,r){e(r)||(r=new i);var a=n.clock,o=n.cone,u=t(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(a),r.y=s*Math.sin(a),r.z=u*Math.cos(o),r},i.fromElements=function(t,n,r,a){return e(a)?(a.x=t,a.y=n,a.z=r,a):new i(t,n,r)},i.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n.z=t.z,n):new i(t.x,t.y,t.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r]=e.z},i.unpack=function(n,r,a){return r=t(r,0),e(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r],a},i.fromArray=i.unpack,i.getMaximumComponent=function(t){return Math.max(t.x,t.y,t.z)},i.getMinimumComponent=function(t){return Math.min(t.x,t.y,t.z)},i.getMinimumByComponent=function(t,n,r){return e(r)||(r=new i),r.x=Math.min(t.x,n.x),r.y=Math.min(t.y,n.y),r.z=Math.min(t.z,n.z),r},i.getMaximumByComponent=function(t,n,r){return e(r)||(r=new i),r.x=Math.max(t.x,n.x),r.y=Math.max(t.y,n.y),r.z=Math.max(t.z,n.z),r},i.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},i.magnitude=function(t){return Math.sqrt(i.magnitudeSquared(t))};var a=new i;i.distance=function(t,e){return i.subtract(t,e,a),i.magnitude(a)},i.normalize=function(t,n){var r=i.magnitude(t);return e(n)?(n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n):new i(t.x/r,t.y/r,t.z/r)},i.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z},i.multiplyComponents=function(t,n,r){return e(r)?(r.x=t.x*n.x,r.y=t.y*n.y,r.z=t.z*n.z,r):new i(t.x*n.x,t.y*n.y,t.z*n.z)},i.add=function(t,n,r){return e(r)?(r.x=t.x+n.x,r.y=t.y+n.y,r.z=t.z+n.z,r):new i(t.x+n.x,t.y+n.y,t.z+n.z)},i.subtract=function(t,n,r){return e(r)?(r.x=t.x-n.x,r.y=t.y-n.y,r.z=t.z-n.z,r):new i(t.x-n.x,t.y-n.y,t.z-n.z)},i.multiplyByScalar=function(t,n,r){return e(r)?(r.x=t.x*n,r.y=t.y*n,r.z=t.z*n,r):new i(t.x*n,t.y*n,t.z*n)},i.divideByScalar=function(t,n,r){return e(r)?(r.x=t.x/n,r.y=t.y/n,r.z=t.z/n,r):new i(t.x/n,t.y/n,t.z/n)},i.negate=function(t,n){return e(n)?(n.x=-t.x,n.y=-t.y,n.z=-t.z,n):new i(-t.x,-t.y,-t.z)},i.abs=function(t,n){return e(n)?(n.x=Math.abs(t.x),n.y=Math.abs(t.y),n.z=Math.abs(t.z),n):new i(Math.abs(t.x),Math.abs(t.y),Math.abs(t.z))};var o=new i;i.lerp=function(t,e,n,r){return i.multiplyByScalar(e,n,o),r=i.multiplyByScalar(t,1-n,r),i.add(o,r,r)};var u=new i,s=new i;i.angleBetween=function(t,e){i.normalize(t,u),i.normalize(e,s);var n=i.dot(u,s),r=i.magnitude(i.cross(u,s,u));return Math.atan2(r,n)};var h=new i;return i.mostOrthogonalAxis=function(t,e){var n=i.normalize(t,h);return i.abs(n,n),e=n.x<=n.y?n.x<=n.z?i.clone(i.UNIT_X,e):i.clone(i.UNIT_Z,e):n.y<=n.z?i.clone(i.UNIT_Y,e):i.clone(i.UNIT_Z,e)},i.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y&&t.z===n.z},i.equalsEpsilon=function(t,n,r){return t===n||e(t)&&e(n)&&Math.abs(t.x-n.x)<=r&&Math.abs(t.y-n.y)<=r&&Math.abs(t.z-n.z)<=r},i.cross=function(t,n,r){var a=t.x,o=t.y,u=t.z,s=n.x,h=n.y,c=n.z,l=o*c-u*h,d=u*s-a*c,f=a*h-o*s;return e(r)?(r.x=l,r.y=d,r.z=f,r):new i(l,d,f)},i.ZERO=r(new i(0,0,0)),i.UNIT_X=r(new i(1,0,0)),i.UNIT_Y=r(new i(0,1,0)),i.UNIT_Z=r(new i(0,0,1)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,e){return i.equalsEpsilon(this,t,e)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,n,r){"use strict";var i=function(e,n,r,i){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(i,0)};i.fromElements=function(t,n,r,a,o){return e(o)?(o.x=t,o.y=n,o.z=r,o.w=a,o):new i(t,n,r,a)},i.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n.z=t.z,n.w=t.w,n):new i(t.x,t.y,t.z,t.w):void 0},i.packedLength=4,i.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},i.unpack=function(n,r,a){return r=t(r,0),e(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r++],a.w=n[r],a},i.fromArray=i.unpack,i.getMaximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},i.getMinimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},i.getMinimumByComponent=function(t,n,r){return e(r)||(r=new i),r.x=Math.min(t.x,n.x),r.y=Math.min(t.y,n.y),r.z=Math.min(t.z,n.z),r.w=Math.min(t.w,n.w),r},i.getMaximumByComponent=function(t,n,r){return e(r)||(r=new i),r.x=Math.max(t.x,n.x),r.y=Math.max(t.y,n.y),r.z=Math.max(t.z,n.z),r.w=Math.max(t.w,n.w),r},i.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},i.magnitude=function(t){return Math.sqrt(i.magnitudeSquared(t))};var a=new i;i.distance=function(t,e){return i.subtract(t,e,a),i.magnitude(a)},i.normalize=function(t,n){var r=i.magnitude(t);return e(n)?(n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n):new i(t.x/r,t.y/r,t.z/r,t.w/r)},i.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},i.multiplyComponents=function(t,n,r){return e(r)?(r.x=t.x*n.x,r.y=t.y*n.y,r.z=t.z*n.z,r.w=t.w*n.w,r):new i(t.x*n.x,t.y*n.y,t.z*n.z,t.w*n.w)},i.add=function(t,n,r){return e(r)?(r.x=t.x+n.x,r.y=t.y+n.y,r.z=t.z+n.z,r.w=t.w+n.w,r):new i(t.x+n.x,t.y+n.y,t.z+n.z,t.w+n.w)},i.subtract=function(t,n,r){return e(r)?(r.x=t.x-n.x,r.y=t.y-n.y,r.z=t.z-n.z,r.w=t.w-n.w,r):new i(t.x-n.x,t.y-n.y,t.z-n.z,t.w-n.w)},i.multiplyByScalar=function(t,n,r){return e(r)?(r.x=t.x*n,r.y=t.y*n,r.z=t.z*n,r.w=t.w*n,r):new i(t.x*n,t.y*n,t.z*n,t.w*n)},i.divideByScalar=function(t,n,r){return e(r)?(r.x=t.x/n,r.y=t.y/n,r.z=t.z/n,r.w=t.w/n,r):new i(t.x/n,t.y/n,t.z/n,t.w/n)},i.negate=function(t,n){return e(n)?(n.x=-t.x,n.y=-t.y,n.z=-t.z,n.w=-t.w,n):new i(-t.x,-t.y,-t.z,-t.w)},i.abs=function(t,n){return e(n)?(n.x=Math.abs(t.x),n.y=Math.abs(t.y),n.z=Math.abs(t.z),n.w=Math.abs(t.w),n):new i(Math.abs(t.x),Math.abs(t.y),Math.abs(t.z),Math.abs(t.w))};var o=new i;i.lerp=function(t,e,n,r){return i.multiplyByScalar(e,n,o),r=i.multiplyByScalar(t,1-n,r),i.add(o,r,r)};var u=new i;return i.mostOrthogonalAxis=function(t,e){var n=i.normalize(t,u);return i.abs(n,n),e=n.x<=n.y?n.x<=n.z?n.x<=n.w?i.clone(i.UNIT_X,e):i.clone(i.UNIT_W,e):n.z<=n.w?i.clone(i.UNIT_Z,e):i.clone(i.UNIT_W,e):n.y<=n.z?n.y<=n.w?i.clone(i.UNIT_Y,e):i.clone(i.UNIT_W,e):n.z<=n.w?i.clone(i.UNIT_Z,e):i.clone(i.UNIT_W,e)},i.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y&&t.z===n.z&&t.w===n.w},i.equalsEpsilon=function(t,n,r){return t===n||e(t)&&e(n)&&Math.abs(t.x-n.x)<=r&&Math.abs(t.y-n.y)<=r&&Math.abs(t.z-n.z)<=r&&Math.abs(t.w-n.w)<=r},i.ZERO=r(new i(0,0,0,0)),i.UNIT_X=r(new i(1,0,0,0)),i.UNIT_Y=r(new i(0,1,0,0)),i.UNIT_Z=r(new i(0,0,1,0)),i.UNIT_W=r(new i(0,0,0,1)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,e){return i.equalsEpsilon(this,t,e)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^t>>>1^e[1&t];for(;n<this.N-1;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^t>>>1^e[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^e[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=2636928640&t<<7,t^=4022730752&t<<15,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["./defaultValue","./defined","./DeveloperError","../ThirdParty/mersenne-twister"],function(t,e,n,r){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(t){return t>0?1:0>t?-1:0},i.sinh=function(t){var e=Math.pow(Math.E,t),n=Math.pow(Math.E,-1*t);return.5*(e-n)},i.cosh=function(t){var e=Math.pow(Math.E,t),n=Math.pow(Math.E,-1*t);return.5*(e+n)},i.lerp=function(t,e,n){return(1-n)*t+n*e},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(t){return t*i.RADIANS_PER_DEGREE},i.toDegrees=function(t){return t*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(t){var e=i.TWO_PI,n=t-Math.floor(t/e)*e;return n<-Math.PI?n+e:n>=Math.PI?n-e:n},i.negativePiToPi=function(t){for(var e=i.EPSILON10,n=i.PI,r=i.TWO_PI;-(n+e)>t;)t+=r;if(-n>t)return-n;for(;t>n+e;)t-=r;return t>n?n:t},i.zeroToTwoPi=function(t){var e=t%i.TWO_PI;return 0>e?(e+i.TWO_PI)%i.TWO_PI:e},i.equalsEpsilon=function(e,n,r){return r=t(r,0),Math.abs(e-n)<=r};var a=[1];i.factorial=function(t){var e=a.length;if(t>=e)for(var n=a[e-1],r=e;t>=r;r++)a.push(n*r);return a[t]},i.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},i.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},i.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},i.clamp=function(t,e,n){return e>t?e:t>n?n:t};var o=new r;return i.setRandomNumberSeed=function(t){o=new r(t)},i.nextRandomNumber=function(){return o.random()},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)};return a.fromDegrees=function(n,r,o,u){return n=i.toRadians(t(n,0)),r=i.toRadians(t(r,0)),o=t(o,0),e(u)?(u.longitude=n,u.latitude=r,u.height=o,u):new a(n,r,o)},a.clone=function(t,n){return e(t)?e(n)?(n.longitude=t.longitude,n.latitude=t.latitude,n.height=t.height,n):new a(t.longitude,t.latitude,t.height):void 0},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.longitude===n.longitude&&t.latitude===n.latitude&&t.height===n.height},a.equalsEpsilon=function(t,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return t===r||e(t)&&e(r)&&Math.abs(t.longitude-r.longitude)<=i&&Math.abs(t.latitude-r.latitude)<=i&&Math.abs(t.height-r.height)<=i},a.toString=function(t){if(!e(t))throw new n("cartographic is required");return"("+t.longitude+", "+t.latitude+", "+t.height+")"},a.ZERO=r(new a(0,0,0)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e){return a.equalsEpsilon(this,t,e)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/Ellipsoid",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic"],function(t,e,n,r,i,a,o){"use strict";var u=function(t,n,o){if(t=e(t,0),n=e(n,0),o=e(o,0),0>t||0>n||0>o)throw new r("All radii components must be greater than or equal to zero.");this._radii=new a(t,n,o),this._radiiSquared=new a(t*t,n*n,o*o),this._radiiToTheFourth=new a(t*t*t*t,n*n*n*n,o*o*o*o),this._oneOverRadii=new a(0===t?0:1/t,0===n?0:1/n,0===o?0:1/o),this._oneOverRadiiSquared=new a(0===t?0:1/(t*t),0===n?0:1/(n*n),0===o?0:1/(o*o)),this._minimumRadius=Math.min(t,n,o),this._maximumRadius=Math.max(t,n,o),this._centerToleranceSquared=i.EPSILON1};u.clone=function(t,e){if(!n(t))return void 0;var r=t._radii;return n(e)?(a.clone(r,e._radii),a.clone(t._radiiSquared,e._radiiSquared),a.clone(t._radiiToTheFourth,e._radiiToTheFourth),a.clone(t._oneOverRadii,e._oneOverRadii),a.clone(t._oneOverRadiiSquared,e._oneOverRadiiSquared),e._minimumRadius=t._minimumRadius,e._maximumRadius=t._maximumRadius,e._centerToleranceSquared=t._centerToleranceSquared,e):new u(r.x,r.y,r.z)},u.fromCartesian3=function(t){return n(t)?new u(t.x,t.y,t.z):new u},u.WGS84=t(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=t(new u(1,1,1)),u.MOON=t(new u(i.LUNAR_RADIUS,i.LUNAR_RADIUS,i.LUNAR_RADIUS)),u.prototype.getRadii=function(){return this._radii},u.prototype.getRadiiSquared=function(){return this._radiiSquared},u.prototype.getRadiiToTheFourth=function(){return this._radiiToTheFourth},u.prototype.getOneOverRadii=function(){return this._oneOverRadii},u.prototype.getOneOverRadiiSquared=function(){return this._oneOverRadiiSquared},u.prototype.getMinimumRadius=function(){return this._minimumRadius},u.prototype.getMaximumRadius=function(){return this._maximumRadius},u.prototype.clone=function(t){return u.clone(this,t)},u.prototype.geocentricSurfaceNormal=a.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(t,e){if(!n(t))throw new r("cartographic is required.");var i=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(i),h=u*Math.sin(i),c=Math.sin(o);return n(e)||(e=new a),e.x=s,e.y=h,e.z=c,a.normalize(e,e)},u.prototype.geodeticSurfaceNormal=function(t,e){return e=a.multiplyComponents(t,this._oneOverRadiiSquared,e),a.normalize(e,e)};var s=new a,h=new a;u.prototype.cartographicToCartesian=function(t,e){var n=s,r=h;this.geodeticSurfaceNormalCartographic(t,n),a.multiplyComponents(this._radiiSquared,n,r);var i=Math.sqrt(a.dot(n,r));return a.divideByScalar(r,i,r),a.multiplyByScalar(n,t.height,n),a.add(r,n,e)},u.prototype.cartographicArrayToCartesianArray=function(t,e){if(!n(t))throw new r("cartographics is required.");var i=t.length;n(e)?e.length=i:e=new Array(i);for(var a=0;i>a;a++)e[a]=this.cartographicToCartesian(t[a],e[a]);return e};var c=new a,l=new a,d=new a;u.prototype.cartesianToCartographic=function(t,e){var r=this.scaleToGeodeticSurface(t,l);if(!n(r))return void 0;var u=this.geodeticSurfaceNormal(r,c),s=a.subtract(t,r,d),h=Math.atan2(u.y,u.x),f=Math.asin(u.z),m=i.sign(a.dot(s,t))*a.magnitude(s);return n(e)?(e.longitude=h,e.latitude=f,e.height=m,e):new o(h,f,m)},u.prototype.cartesianArrayToCartographicArray=function(t,e){if(!n(t))throw new r("cartesians is required.");var i=t.length;n(e)?e.length=i:e=new Array(i);for(var a=0;i>a;++a)e[a]=this.cartesianToCartographic(t[a],e[a]);return e};var f=new a,m=new a;return u.prototype.scaleToGeodeticSurface=function(t,e){if(!n(t))throw new r("cartesian is required.");var o=t.x,u=t.y,s=t.z,h=this._oneOverRadii,c=h.x,l=h.y,d=h.z,y=o*o*c*c,p=u*u*l*l,w=s*s*d*d,g=y+p+w,v=Math.sqrt(1/g),x=a.multiplyByScalar(t,v,f);if(g<this._centerToleranceSquared)return isFinite(v)?a.clone(x,e):void 0;var M=this._oneOverRadiiSquared,z=M.x,E=M.y,S=M.z,b=m;b.x=2*x.x*z,b.y=2*x.y*E,b.z=2*x.z*S;var O,R,_,T,I,P,C,N,q,U,A,L=(1-v)*a.magnitude(t)/(.5*a.magnitude(b)),W=0;do{L-=W,_=1/(1+L*z),T=1/(1+L*E),I=1/(1+L*S),P=_*_,C=T*T,N=I*I,q=P*_,U=C*T,A=N*I,O=y*P+p*C+w*N-1,R=y*q*z+p*U*E+w*A*S;var D=-2*R;W=O/D}while(Math.abs(O)>i.EPSILON12);return n(e)?(e.x=o*_,e.y=u*T,e.z=s*I,e):new a(o*_,u*T,s*I)},u.prototype.scaleToGeocentricSurface=function(t,e){if(!n(t))throw new r("cartesian is required.");var i=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,h=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return a.multiplyByScalar(t,h,e)},u.prototype.transformPositionToScaledSpace=function(t,e){return a.multiplyComponents(t,this._oneOverRadii,e)},u.prototype.transformPositionFromScaledSpace=function(t,e){return a.multiplyComponents(t,this._radii,e)},u.prototype.equals=function(t){return this===t||n(t)&&a.equals(this._radii,t._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Core/GeographicProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Ellipsoid"],function(t,e,n,r,i){"use strict";var a=function(e){this._ellipsoid=t(e,i.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return a.prototype.getEllipsoid=function(){return this._ellipsoid},a.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return e(r)?(r.x=a,r.y=o,r.z=u,r):new n(a,o,u)},a.prototype.unproject=function(t,n){var i=this._oneOverSemimajorAxis,a=t.x*i,o=t.y*i,u=t.z;return e(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new r(a,o,u)},a}),define("Core/Enumeration",["./defined"],function(t){"use strict";var e=function(e,n,r){if(this.value=e,this.name=n,t(r))for(var i in r)r.hasOwnProperty(i)&&(this[i]=r[i])};return e.prototype.valueOf=function(){return this.value},e.prototype.toString=function(){return this.name},e}),define("Core/Intersect",["./Enumeration"],function(t){"use strict";var e={OUTSIDE:new t(-1,"OUTSIDE"),INTERSECTING:new t(0,"INTERSECTING"),INSIDE:new t(1,"INSIDE")};return e}),define("Core/Interval",["./defaultValue"],function(t){"use strict";var e=function(e,n){this.start=t(e,0),this.stop=t(n,0)};return e}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i,a){"use strict";function o(t){for(var e=0,n=0;9>n;++n){var r=t[n];e+=r*r}return Math.sqrt(e)}function u(t){for(var e=0,n=0;3>n;++n){var r=t[h.getElementIndex(l[n],c[n])];e+=2*r*r}return Math.sqrt(e)}function s(t,e){for(var n=a.EPSILON15,r=0,i=1,o=0;3>o;++o){var u=Math.abs(t[h.getElementIndex(l[o],c[o])]);u>r&&(i=o,r=u)}var s=1,d=0,f=c[i],m=l[i];if(Math.abs(t[h.getElementIndex(m,f)])>n){var y,p=t[h.getElementIndex(m,m)],w=t[h.getElementIndex(f,f)],g=t[h.getElementIndex(m,f)],v=(p-w)/2/g;y=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),s=1/Math.sqrt(1+y*y),d=y*s}return e=h.clone(h.IDENTITY,e),e[h.getElementIndex(f,f)]=e[h.getElementIndex(m,m)]=s,e[h.getElementIndex(m,f)]=d,e[h.getElementIndex(f,m)]=-d,e}var h=function(t,n,r,i,a,o,u,s,h){this[0]=e(t,0),this[1]=e(i,0),this[2]=e(u,0),this[3]=e(n,0),this[4]=e(a,0),this[5]=e(s,0),this[6]=e(r,0),this[7]=e(o,0),this[8]=e(h,0)};h.clone=function(t,e){return n(t)?n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):new h(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8]):void 0},h.fromArray=function(t,r,i){return r=e(r,0),n(i)||(i=new h),i[0]=t[r],i[1]=t[r+1],i[2]=t[r+2],i[3]=t[r+3],i[4]=t[r+4],i[5]=t[r+5],i[6]=t[r+6],i[7]=t[r+7],i[8]=t[r+8],i[9]=t[r+9],i},h.fromColumnMajorArray=function(t,e){return h.clone(t,e)},h.fromRowMajorArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],e):new h(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},h.fromQuaternion=function(t,e){var r=t.x*t.x,i=t.x*t.y,a=t.x*t.z,o=t.x*t.w,u=t.y*t.y,s=t.y*t.z,c=t.y*t.w,l=t.z*t.z,d=t.z*t.w,f=t.w*t.w,m=r-u-l+f,y=2*(i-d),p=2*(a+c),w=2*(i+d),g=-r+u-l+f,v=2*(s-o),x=2*(a-c),M=2*(s+o),z=-r-u+l+f;return n(e)?(e[0]=m,e[1]=w,e[2]=x,e[3]=y,e[4]=g,e[5]=M,e[6]=p,e[7]=v,e[8]=z,e):new h(m,y,p,w,g,v,x,M,z)},h.fromScale=function(t,e){return n(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=t.y,e[5]=0,e[6]=0,e[7]=0,e[8]=t.z,e):new h(t.x,0,0,0,t.y,0,0,0,t.z)},h.fromUniformScale=function(t,e){return n(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=t,e[5]=0,e[6]=0,e[7]=0,e[8]=t,e):new h(t,0,0,0,t,0,0,0,t)},h.fromRotationX=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=r,e[5]=i,e[6]=0,e[7]=-i,e[8]=r,e):new h(1,0,0,0,r,-i,0,i,r)},h.fromRotationY=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=r,e[1]=0,e[2]=-i,e[3]=0,e[4]=1,e[5]=0,e[6]=i,e[7]=0,e[8]=r,e):new h(r,0,i,0,1,0,-i,0,r)},h.fromRotationZ=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=r,e[1]=i,e[2]=0,e[3]=-i,e[4]=r,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e):new h(r,-i,0,i,r,0,0,0,1)},h.toArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},h.getElementIndex=function(t,e){return 3*t+e},h.getColumn=function(e,r,i){var a=3*r,o=e[a],u=e[a+1],s=e[a+2];return n(i)?(i.x=o,i.y=u,i.z=s,i):new t(o,u,s)},h.setColumn=function(t,e,n,r){r=h.clone(t,r);var i=3*e;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},h.getRow=function(e,r,i){var a=e[r],o=e[r+3],u=e[r+6];return n(i)?(i.x=a,i.y=o,i.z=u,i):new t(a,o,u)},h.setRow=function(t,e,n,r){return r=h.clone(t,r),r[e]=n.x,r[e+3]=n.y,r[e+6]=n.z,r},h.multiply=function(t,e,r){var i=t[0]*e[0]+t[3]*e[1]+t[6]*e[2],a=t[1]*e[0]+t[4]*e[1]+t[7]*e[2],o=t[2]*e[0]+t[5]*e[1]+t[8]*e[2],u=t[0]*e[3]+t[3]*e[4]+t[6]*e[5],s=t[1]*e[3]+t[4]*e[4]+t[7]*e[5],c=t[2]*e[3]+t[5]*e[4]+t[8]*e[5],l=t[0]*e[6]+t[3]*e[7]+t[6]*e[8],d=t[1]*e[6]+t[4]*e[7]+t[7]*e[8],f=t[2]*e[6]+t[5]*e[7]+t[8]*e[8];return n(r)?(r[0]=i,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=c,r[6]=l,r[7]=d,r[8]=f,r):new h(i,u,l,a,s,d,o,c,f)},h.multiplyByVector=function(e,r,i){var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[3]*o+e[6]*u,h=e[1]*a+e[4]*o+e[7]*u,c=e[2]*a+e[5]*o+e[8]*u;return n(i)?(i.x=s,i.y=h,i.z=c,i):new t(s,h,c)},h.multiplyByScalar=function(t,e,r){return n(r)?(r[0]=t[0]*e,r[1]=t[1]*e,r[2]=t[2]*e,r[3]=t[3]*e,r[4]=t[4]*e,r[5]=t[5]*e,r[6]=t[6]*e,r[7]=t[7]*e,r[8]=t[8]*e,r):new h(t[0]*e,t[3]*e,t[6]*e,t[1]*e,t[4]*e,t[7]*e,t[2]*e,t[5]*e,t[8]*e)},h.negate=function(t,e){return n(e)?(e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e):new h(-t[0],-t[3],-t[6],-t[1],-t[4],-t[7],-t[2],-t[5],-t[8])},h.transpose=function(t,e){var r=t[0],i=t[3],a=t[6],o=t[1],u=t[4],s=t[7],c=t[2],l=t[5],d=t[8];return n(e)?(e[0]=r,e[1]=i,e[2]=a,e[3]=o,e[4]=u,e[5]=s,e[6]=c,e[7]=l,e[8]=d,e):new h(r,o,c,i,u,l,a,s,d)};var c=[1,0,0],l=[2,2,1],d=new h,f=new h;return h.getEigenDecomposition=function(t,e){var r=a.EPSILON20,i=10,c=0,l=0;n(e)||(e={});for(var m=e.unitary=h.clone(h.IDENTITY,e.unitary),y=e.diagonal=h.clone(t,e.diagonal),p=r*o(y);i>l&&u(y)>p;)s(y,d),h.transpose(d,f),h.multiply(y,d,y),h.multiply(f,y,y),h.multiply(m,d,m),++c>2&&(++l,c=0);return e},h.abs=function(t,e){return n(e)?(e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e):new h(Math.abs(t[0]),Math.abs(t[3]),Math.abs(t[6]),Math.abs(t[1]),Math.abs(t[4]),Math.abs(t[7]),Math.abs(t[2]),Math.abs(t[5]),Math.abs(t[8]))},h.determinant=function(t){if(!n(t))throw new r("matrix is required");var e=t[0],i=t[3],a=t[6],o=t[1],u=t[4],s=t[7],h=t[2],c=t[5],l=t[8];return e*(u*l-c*s)+o*(c*a-i*l)+h*(i*s-u*a)},h.inverse=function(t,e){if(!n(t))throw new r("matrix is required");var i=t[0],o=t[1],u=t[2],s=t[3],c=t[4],l=t[5],d=t[6],f=t[7],m=t[8],y=h.determinant(t);if(Math.abs(y)<=a.EPSILON15)throw new r("matrix is not invertible");var p=new h(c*m-f*l,d*l-s*m,s*f-d*c,f*u-o*m,i*m-d*u,d*o-i*f,o*l-c*u,s*u-i*l,i*c-s*o),w=1/y;return h.multiplyByScalar(p,w,e)},h.equals=function(t,e){return t===e||n(t)&&n(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},h.equalsEpsilon=function(t,e,r){return t===e||n(t)&&n(e)&&Math.abs(t[0]-e[0])<=r&&Math.abs(t[1]-e[1])<=r&&Math.abs(t[2]-e[2])<=r&&Math.abs(t[3]-e[3])<=r&&Math.abs(t[4]-e[4])<=r&&Math.abs(t[5]-e[5])<=r&&Math.abs(t[6]-e[6])<=r&&Math.abs(t[7]-e[7])<=r&&Math.abs(t[8]-e[8])<=r},h.IDENTITY=i(new h(1,0,0,0,1,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN1ROW0=3,h.COLUMN1ROW1=4,h.COLUMN1ROW2=5,h.COLUMN2ROW0=6,h.COLUMN2ROW1=7,h.COLUMN2ROW2=8,h.prototype.clone=function(t){return h.clone(this,t)},h.prototype.equals=function(t){return h.equals(this,t)},h.prototype.equalsEpsilon=function(t,e){return h.equalsEpsilon(this,t,e)},h.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},h}),define("Core/RuntimeError",["./defined"],function(t){"use strict";var e=function(t){this.name="RuntimeError",this.message=t;var e=new Error;this.stack=e.stack};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,e,n,r,i,a,o,u,s){"use strict";var h=function(t,e,r,i,a,o,u,s,h,c,l,d,f,m,y,p){this[0]=n(t,0),this[1]=n(a,0),this[2]=n(h,0),this[3]=n(f,0),this[4]=n(e,0),this[5]=n(o,0),this[6]=n(c,0),this[7]=n(m,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(d,0),this[15]=n(p,0)};h.clone=function(t,e){return r(t)?r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):new h(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15]):void 0},h.fromArray=function(t,e,i){return e=n(e,0),r(i)||(i=new h),i[0]=t[e],i[1]=t[e+1],i[2]=t[e+2],i[3]=t[e+3],i[4]=t[e+4],i[5]=t[e+5],i[6]=t[e+6],i[7]=t[e+7],i[8]=t[e+8],i[9]=t[e+9],i[10]=t[e+10],i[11]=t[e+11],i[12]=t[e+12],i[13]=t[e+13],i[14]=t[e+14],i[15]=t[e+15],i},h.fromColumnMajorArray=function(t,e){return h.clone(t,e)},h.fromRowMajorArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15],e):new h(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},h.fromRotationTranslation=function(t,e,n){return r(n)?(n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=0,n[4]=t[3],n[5]=t[4],n[6]=t[5],n[7]=0,n[8]=t[6],n[9]=t[7],n[10]=t[8],n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new h(t[0],t[3],t[6],e.x,t[1],t[4],t[7],e.y,t[2],t[5],t[8],e.z,0,0,0,1)},new u,h.fromTranslationQuaternionRotationScale=function(t,e,n,i){r(i)||(i=new h);var a=n.x,o=n.y,u=n.z,s=e.x*e.x,c=e.x*e.y,l=e.x*e.z,d=e.x*e.w,f=e.y*e.y,m=e.y*e.z,y=e.y*e.w,p=e.z*e.z,w=e.z*e.w,g=e.w*e.w,v=s-f-p+g,x=2*(c-w),M=2*(l+y),z=2*(c+w),E=-s+f-p+g,S=2*(m-d),b=2*(l-y),O=2*(m+d),R=-s-f+p+g;return i[0]=v*a,i[1]=z*a,i[2]=b*a,i[3]=0,i[4]=x*o,i[5]=E*o,i[6]=O*o,i[7]=0,i[8]=M*u,i[9]=S*u,i[10]=R*u,i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,i},h.fromTranslation=function(t,e){return h.fromRotationTranslation(u.IDENTITY,t,e)},h.fromScale=function(t,e){return r(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t.y,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t.z,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new h(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},h.fromUniformScale=function(t,e){return r(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new h(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var c=new t,l=new t,d=new t;h.fromCamera=function(e,n){var i=e.eye,a=e.target,o=e.up;t.normalize(t.subtract(a,i,c),c),t.normalize(t.cross(c,o,l),l),t.normalize(t.cross(l,c,d),d);var u=l.x,s=l.y,f=l.z,m=c.x,y=c.y,p=c.z,w=d.x,g=d.y,v=d.z,x=i.x,M=i.y,z=i.z,E=u*-x+s*-M+f*-z,S=w*-x+g*-M+v*-z,b=m*x+y*M+p*z;return r(n)?(n[0]=u,n[1]=w,n[2]=-m,n[3]=0,n[4]=s,n[5]=g,n[6]=-y,n[7]=0,n[8]=f,n[9]=v,n[10]=-p,n[11]=0,n[12]=E,n[13]=S,n[14]=b,n[15]=1,n):new h(u,s,f,E,w,g,v,S,-m,-y,-p,b,0,0,0,1)},h.computePerspectiveFieldOfView=function(t,e,n,i,a){var o=Math.tan(.5*t),u=1/o,s=u/e,c=(i+n)/(n-i),l=2*i*n/(n-i);return r(a)?(a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a):new h(s,0,0,0,0,u,0,0,0,0,c,l,0,0,-1,0)},h.computeOrthographicOffCenter=function(t,e,n,i,a,o,u){var s=1/(e-t),c=1/(i-n),l=1/(o-a),d=-(e+t)*s,f=-(i+n)*c,m=-(o+a)*l;return s*=2,c*=2,l*=-2,r(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=l,u[11]=0,u[12]=d,u[13]=f,u[14]=m,u[15]=1,u):new h(s,0,0,d,0,c,0,f,0,0,l,m,0,0,0,1)},h.computePerspectiveOffCenter=function(t,e,n,i,a,o,u){var s=2*a/(e-t),c=2*a/(i-n),l=(e+t)/(e-t),d=(i+n)/(i-n),f=-(o+a)/(o-a),m=-1,y=-2*o*a/(o-a);return r(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=d,u[10]=f,u[11]=m,u[12]=0,u[13]=0,u[14]=y,u[15]=0,u):new h(s,0,l,0,0,c,d,0,0,0,f,y,0,0,m,0)},h.computeInfinitePerspectiveOffCenter=function(t,e,n,i,a,o){var u=2*a/(e-t),s=2*a/(i-n),c=(e+t)/(e-t),l=(i+n)/(i-n),d=-1,f=-1,m=-2*a;return r(o)?(o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=d,o[11]=f,o[12]=0,o[13]=0,o[14]=m,o[15]=0,o):new h(u,0,c,0,0,s,l,0,0,0,d,m,0,0,f,0)},h.computeViewportTransformation=function(t,e,i,a){t=n(t,n.EMPTY_OBJECT);var o=n(t.x,0),u=n(t.y,0),s=n(t.width,0),c=n(t.height,0);e=n(e,0),i=n(i,1);var l=.5*s,d=.5*c,f=.5*(i-e),m=l,y=d,p=f,w=o+l,g=u+d,v=e+f,x=1;return r(a)?(a[0]=m,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=y,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=p,a[11]=0,a[12]=w,a[13]=g,a[14]=v,a[15]=x,a):new h(m,0,0,w,0,y,0,g,0,0,p,v,0,0,0,x)},h.toArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},h.getElementIndex=function(t,e){return 4*t+e},h.getColumn=function(t,n,i){var a=4*n,o=t[a],u=t[a+1],s=t[a+2],h=t[a+3];return r(i)?(i.x=o,i.y=u,i.z=s,i.w=h,i):new e(o,u,s,h)},h.setColumn=function(t,e,n,r){r=h.clone(t,r);var i=4*e;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},h.getRow=function(t,n,i){var a=t[n],o=t[n+4],u=t[n+8],s=t[n+12];return r(i)?(i.x=a,i.y=o,i.z=u,i.w=s,i):new e(a,o,u,s)},h.setRow=function(t,e,n,r){return r=h.clone(t,r),r[e]=n.x,r[e+4]=n.y,r[e+8]=n.z,r[e+12]=n.w,r},h.multiply=function(t,e,n){var i=t[0],a=t[1],o=t[2],u=t[3],s=t[4],c=t[5],l=t[6],d=t[7],f=t[8],m=t[9],y=t[10],p=t[11],w=t[12],g=t[13],v=t[14],x=t[15],M=e[0],z=e[1],E=e[2],S=e[3],b=e[4],O=e[5],R=e[6],_=e[7],T=e[8],I=e[9],P=e[10],C=e[11],N=e[12],q=e[13],U=e[14],A=e[15],L=i*M+s*z+f*E+w*S,W=a*M+c*z+m*E+g*S,D=o*M+l*z+y*E+v*S,V=u*M+d*z+p*E+x*S,B=i*b+s*O+f*R+w*_,j=a*b+c*O+m*R+g*_,k=o*b+l*O+y*R+v*_,H=u*b+d*O+p*R+x*_,F=i*T+s*I+f*P+w*C,G=a*T+c*I+m*P+g*C,Z=o*T+l*I+y*P+v*C,X=u*T+d*I+p*P+x*C,Y=i*N+s*q+f*U+w*A,K=a*N+c*q+m*U+g*A,J=o*N+l*q+y*U+v*A,Q=u*N+d*q+p*U+x*A;return r(n)?(n[0]=L,n[1]=W,n[2]=D,n[3]=V,n[4]=B,n[5]=j,n[6]=k,n[7]=H,n[8]=F,n[9]=G,n[10]=Z,n[11]=X,n[12]=Y,n[13]=K,n[14]=J,n[15]=Q,n):new h(L,B,F,Y,W,j,G,K,D,k,Z,J,V,H,X,Q)},h.multiplyTransformation=function(t,e,n){var i=t[0],a=t[1],o=t[2],u=t[4],s=t[5],c=t[6],l=t[8],d=t[9],f=t[10],m=t[12],y=t[13],p=t[14],w=e[0],g=e[1],v=e[2],x=e[4],M=e[5],z=e[6],E=e[8],S=e[9],b=e[10],O=e[12],R=e[13],_=e[14],T=i*w+u*g+l*v,I=a*w+s*g+d*v,P=o*w+c*g+f*v,C=i*x+u*M+l*z,N=a*x+s*M+d*z,q=o*x+c*M+f*z,U=i*E+u*S+l*b,A=a*E+s*S+d*b,L=o*E+c*S+f*b,W=i*O+u*R+l*_+m,D=a*O+s*R+d*_+y,V=o*O+c*R+f*_+p;
return r(n)?(n[0]=T,n[1]=I,n[2]=P,n[3]=0,n[4]=C,n[5]=N,n[6]=q,n[7]=0,n[8]=U,n[9]=A,n[10]=L,n[11]=0,n[12]=W,n[13]=D,n[14]=V,n[15]=1,n):new h(T,C,U,W,I,N,A,D,P,q,L,V,0,0,0,1)},h.multiplyByTranslation=function(t,e,n){var i=e.x,a=e.y,o=e.z,u=i*t[0]+a*t[4]+o*t[8]+t[12],s=i*t[1]+a*t[5]+o*t[9]+t[13],c=i*t[2]+a*t[6]+o*t[10]+t[14];return r(n)?(n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n[6]=t[6],n[7]=t[7],n[8]=t[8],n[9]=t[9],n[10]=t[10],n[11]=t[11],n[12]=u,n[13]=s,n[14]=c,n[15]=t[15],n):new h(t[0],t[4],t[8],u,t[1],t[5],t[9],s,t[2],t[6],t[10],c,t[3],t[7],t[11],t[15])};var f=new t;return h.multiplyByUniformScale=function(t,e,n){return f.x=e,f.y=e,f.z=e,h.multiplyByScale(t,f,n)},h.multiplyByScale=function(t,e,n){var i=e.x,a=e.y,o=e.z;return 1===i&&1===a&&1===o?h.clone(t,n):r(n)?(n[0]=i*t[0],n[1]=i*t[1],n[2]=i*t[2],n[3]=0,n[4]=a*t[4],n[5]=a*t[5],n[6]=a*t[6],n[7]=0,n[8]=o*t[8],n[9]=o*t[9],n[10]=o*t[10],n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=1,n):new h(i*t[0],a*t[4],o*t[8],t[12],i*t[1],a*t[5],o*t[9],t[13],i*t[2],a*t[6],o*t[10],t[14],0,0,0,1)},h.multiplyByVector=function(t,n,i){var a=n.x,o=n.y,u=n.z,s=n.w,h=t[0]*a+t[4]*o+t[8]*u+t[12]*s,c=t[1]*a+t[5]*o+t[9]*u+t[13]*s,l=t[2]*a+t[6]*o+t[10]*u+t[14]*s,d=t[3]*a+t[7]*o+t[11]*u+t[15]*s;return r(i)?(i.x=h,i.y=c,i.z=l,i.w=d,i):new e(h,c,l,d)},h.multiplyByPointAsVector=function(e,n,i){var a=n.x,o=n.y,u=n.z,s=e[0]*a+e[4]*o+e[8]*u,h=e[1]*a+e[5]*o+e[9]*u,c=e[2]*a+e[6]*o+e[10]*u;return r(i)?(i.x=s,i.y=h,i.z=c,i):new t(s,h,c)},h.multiplyByPoint=function(e,n,i){var a=n.x,o=n.y,u=n.z,s=e[0]*a+e[4]*o+e[8]*u+e[12],h=e[1]*a+e[5]*o+e[9]*u+e[13],c=e[2]*a+e[6]*o+e[10]*u+e[14];return r(i)?(i.x=s,i.y=h,i.z=c,i):new t(s,h,c)},h.multiplyByScalar=function(t,e,n){return r(n)?(n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n[9]=t[9]*e,n[10]=t[10]*e,n[11]=t[11]*e,n[12]=t[12]*e,n[13]=t[13]*e,n[14]=t[14]*e,n[15]=t[15]*e,n):new h(t[0]*e,t[4]*e,t[8]*e,t[12]*e,t[1]*e,t[5]*e,t[9]*e,t[13]*e,t[2]*e,t[6]*e,t[10]*e,t[14]*e,t[3]*e,t[7]*e,t[11]*e,t[15]*e)},h.negate=function(t,e){return r(e)?(e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e[9]=-t[9],e[10]=-t[10],e[11]=-t[11],e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=-t[15],e):new h(-t[0],-t[4],-t[8],-t[12],-t[1],-t[5],-t[9],-t[13],-t[2],-t[6],-t[10],-t[14],-t[3],-t[7],-t[11],-t[15])},h.transpose=function(t,e){if(!r(e))return new h(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]);var n=t[1],i=t[2],a=t[3],o=t[6],u=t[7],s=t[11];return e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=n,e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=i,e[9]=o,e[10]=t[10],e[11]=t[14],e[12]=a,e[13]=u,e[14]=s,e[15]=t[15],e},h.abs=function(t,e){return r(e)?(e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e[9]=Math.abs(t[9]),e[10]=Math.abs(t[10]),e[11]=Math.abs(t[11]),e[12]=Math.abs(t[12]),e[13]=Math.abs(t[13]),e[14]=Math.abs(t[14]),e[15]=Math.abs(t[15]),e):new h(Math.abs(t[0]),Math.abs(t[4]),Math.abs(t[8]),Math.abs(t[12]),Math.abs(t[1]),Math.abs(t[5]),Math.abs(t[9]),Math.abs(t[13]),Math.abs(t[2]),Math.abs(t[6]),Math.abs(t[10]),Math.abs(t[14]),Math.abs(t[3]),Math.abs(t[7]),Math.abs(t[11]),Math.abs(t[15]))},h.equals=function(t,e){return t===e||r(t)&&r(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},h.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n&&Math.abs(t[4]-e[4])<=n&&Math.abs(t[5]-e[5])<=n&&Math.abs(t[6]-e[6])<=n&&Math.abs(t[7]-e[7])<=n&&Math.abs(t[8]-e[8])<=n&&Math.abs(t[9]-e[9])<=n&&Math.abs(t[10]-e[10])<=n&&Math.abs(t[11]-e[11])<=n&&Math.abs(t[12]-e[12])<=n&&Math.abs(t[13]-e[13])<=n&&Math.abs(t[14]-e[14])<=n&&Math.abs(t[15]-e[15])<=n},h.getTranslation=function(e,n){return r(n)?(n.x=e[12],n.y=e[13],n.z=e[14],n):new t(e[12],e[13],e[14])},h.getRotation=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e):new u(t[0],t[4],t[8],t[1],t[5],t[9],t[2],t[6],t[10])},h.inverse=function(t,e){var n=t[0],i=t[4],a=t[8],u=t[12],c=t[1],l=t[5],d=t[9],f=t[13],m=t[2],y=t[6],p=t[10],w=t[14],g=t[3],v=t[7],x=t[11],M=t[15],z=p*M,E=w*x,S=y*M,b=w*v,O=y*x,R=p*v,_=m*M,T=w*g,I=m*x,P=p*g,C=m*v,N=y*g,q=z*l+b*d+O*f-(E*l+S*d+R*f),U=E*c+_*d+P*f-(z*c+T*d+I*f),A=S*c+T*l+C*f-(b*c+_*l+N*f),L=R*c+I*l+N*d-(O*c+P*l+C*d),W=E*i+S*a+R*u-(z*i+b*a+O*u),D=z*n+T*a+I*u-(E*n+_*a+P*u),V=b*n+_*i+N*u-(S*n+T*i+C*u),B=O*n+P*i+C*a-(R*n+I*i+N*a);z=a*f,E=u*d,S=i*f,b=u*l,O=i*d,R=a*l,_=n*f,T=u*c,I=n*d,P=a*c,C=n*l,N=i*c;var j=z*v+b*x+O*M-(E*v+S*x+R*M),k=E*g+_*x+P*M-(z*g+T*x+I*M),H=S*g+T*v+C*M-(b*g+_*v+N*M),F=R*g+I*v+N*x-(O*g+P*v+C*x),G=S*p+R*w+E*y-(O*w+z*y+b*p),Z=I*w+z*m+T*p-(_*p+P*w+E*m),X=_*y+N*w+b*m-(C*w+S*m+T*y),Y=C*p+O*m+P*y-(I*y+N*p+R*m),K=n*q+i*U+a*A+u*L;if(Math.abs(K)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return K=1/K,r(e)?(e[0]=q*K,e[1]=U*K,e[2]=A*K,e[3]=L*K,e[4]=W*K,e[5]=D*K,e[6]=V*K,e[7]=B*K,e[8]=j*K,e[9]=k*K,e[10]=H*K,e[11]=F*K,e[12]=G*K,e[13]=Z*K,e[14]=X*K,e[15]=Y*K,e):new h(q*K,W*K,j*K,G*K,U*K,D*K,k*K,Z*K,A*K,V*K,H*K,X*K,L*K,B*K,F*K,Y*K)},h.inverseTransformation=function(t,e){var n=t[0],i=t[1],a=t[2],o=t[4],u=t[5],s=t[6],c=t[8],l=t[9],d=t[10],f=t[12],m=t[13],y=t[14],p=-n*f-i*m-a*y,w=-o*f-u*m-s*y,g=-c*f-l*m-d*y;return r(e)?(e[0]=n,e[1]=o,e[2]=c,e[3]=0,e[4]=i,e[5]=u,e[6]=l,e[7]=0,e[8]=a,e[9]=s,e[10]=d,e[11]=0,e[12]=p,e[13]=w,e[14]=g,e[15]=1,e):new h(n,i,a,p,o,u,s,w,c,l,d,g,0,0,0,1)},h.IDENTITY=a(new h(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN0ROW3=3,h.COLUMN1ROW0=4,h.COLUMN1ROW1=5,h.COLUMN1ROW2=6,h.COLUMN1ROW3=7,h.COLUMN2ROW0=8,h.COLUMN2ROW1=9,h.COLUMN2ROW2=10,h.COLUMN2ROW3=11,h.COLUMN3ROW0=12,h.COLUMN3ROW1=13,h.COLUMN3ROW2=14,h.COLUMN3ROW3=15,h.prototype.clone=function(t){return h.clone(this,t)},h.prototype.equals=function(t){return h.equals(this,t)},h.prototype.equalsEpsilon=function(t,e){return h.equalsEpsilon(this,t,e)},h.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},h}),define("Core/BoundingSphere",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Cartesian4","./Cartographic","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4"],function(t,e,n,r,i,a,o,u,s,h,c){"use strict";var l=function(e,n){this.center=r.clone(t(e,r.ZERO)),this.radius=t(n,0)},d=new r,f=new r,m=new r,y=new r,p=new r,w=new r,g=new r,v=new r,x=new r,M=new r,z=new r,E=new r;l.fromPoints=function(t,n){if(e(n)||(n=new l),!e(t)||0===t.length)return n.center=r.clone(r.ZERO,n.center),n.radius=0,n;for(var i=r.clone(t[0],g),a=r.clone(i,d),o=r.clone(i,f),u=r.clone(i,m),s=r.clone(i,y),h=r.clone(i,p),c=r.clone(i,w),S=t.length,b=1;S>b;b++){r.clone(t[b],i);var O=i.x,R=i.y,_=i.z;O<a.x&&r.clone(i,a),O>s.x&&r.clone(i,s),R<o.y&&r.clone(i,o),R>h.y&&r.clone(i,h),_<u.z&&r.clone(i,u),_>c.z&&r.clone(i,c)}var T=r.magnitudeSquared(r.subtract(s,a,v)),I=r.magnitudeSquared(r.subtract(h,o,v)),P=r.magnitudeSquared(r.subtract(c,u,v)),C=a,N=s,q=T;I>q&&(q=I,C=o,N=h),P>q&&(q=P,C=u,N=c);var U=x;U.x=.5*(C.x+N.x),U.y=.5*(C.y+N.y),U.z=.5*(C.z+N.z);var A=r.magnitudeSquared(r.subtract(N,U,v)),L=Math.sqrt(A),W=M;W.x=a.x,W.y=o.y,W.z=u.z;var D=z;D.x=s.x,D.y=h.y,D.z=c.z;var V=r.multiplyByScalar(r.add(W,D,v),.5,E),B=0;for(b=0;S>b;b++){r.clone(t[b],i);var j=r.magnitude(r.subtract(i,V,v));j>B&&(B=j);var k=r.magnitudeSquared(r.subtract(i,U,v));if(k>A){var H=Math.sqrt(k);L=.5*(L+H),A=L*L;var F=H-L;U.x=(L*U.x+F*i.x)/H,U.y=(L*U.y+F*i.y)/H,U.z=(L*U.z+F*i.z)/H}}return B>L?(r.clone(U,n.center),n.radius=L):(r.clone(V,n.center),n.radius=B),n};var S=new u,b=new r,O=new r,R=new a,_=new a;l.fromExtent2D=function(t,e,n){return l.fromExtentWithHeights2D(t,e,0,0,n)},l.fromExtentWithHeights2D=function(n,i,a,o,u){if(e(u)||(u=new l),!e(n))return u.center=r.clone(r.ZERO,u.center),u.radius=0,u;i=t(i,S),n.getSouthwest(R),R.height=a,n.getNortheast(_),_.height=o;var s=i.project(R,b),h=i.project(_,O),c=h.x-s.x,d=h.y-s.y,f=h.z-s.z;u.radius=.5*Math.sqrt(c*c+d*d+f*f);var m=u.center;return m.x=s.x+.5*c,m.y=s.y+.5*d,m.z=s.z+.5*f,u};var T=[];l.fromExtent3D=function(n,r,i,a){r=t(r,o.WGS84),i=t(i,0);var u;return e(n)&&(u=n.subsample(r,i,T)),l.fromPoints(u,a)},l.fromVertices=function(n,i,a,o){if(e(o)||(o=new l),!e(n)||0===n.length)return o.center=r.clone(r.ZERO,o.center),o.radius=0,o;i=t(i,r.ZERO),a=t(a,3);var u=g;u.x=n[0]+i.x,u.y=n[1]+i.y,u.z=n[2]+i.z;for(var s=r.clone(u,d),h=r.clone(u,f),c=r.clone(u,m),S=r.clone(u,y),b=r.clone(u,p),O=r.clone(u,w),R=n.length,_=0;R>_;_+=a){var T=n[_]+i.x,I=n[_+1]+i.y,P=n[_+2]+i.z;u.x=T,u.y=I,u.z=P,T<s.x&&r.clone(u,s),T>S.x&&r.clone(u,S),I<h.y&&r.clone(u,h),I>b.y&&r.clone(u,b),P<c.z&&r.clone(u,c),P>O.z&&r.clone(u,O)}var C=r.magnitudeSquared(r.subtract(S,s,v)),N=r.magnitudeSquared(r.subtract(b,h,v)),q=r.magnitudeSquared(r.subtract(O,c,v)),U=s,A=S,L=C;N>L&&(L=N,U=h,A=b),q>L&&(L=q,U=c,A=O);var W=x;W.x=.5*(U.x+A.x),W.y=.5*(U.y+A.y),W.z=.5*(U.z+A.z);var D=r.magnitudeSquared(r.subtract(A,W,v)),V=Math.sqrt(D),B=M;B.x=s.x,B.y=h.y,B.z=c.z;var j=z;j.x=S.x,j.y=b.y,j.z=O.z;var k=r.multiplyByScalar(r.add(B,j,v),.5,E),H=0;for(_=0;R>_;_+=a){u.x=n[_]+i.x,u.y=n[_+1]+i.y,u.z=n[_+2]+i.z;var F=r.magnitude(r.subtract(u,k,v));F>H&&(H=F);var G=r.magnitudeSquared(r.subtract(u,W,v));if(G>D){var Z=Math.sqrt(G);V=.5*(V+Z),D=V*V;var X=Z-V;W.x=(V*W.x+X*u.x)/Z,W.y=(V*W.y+X*u.y)/Z,W.z=(V*W.z+X*u.z)/Z}}return H>V?(r.clone(W,o.center),o.radius=V):(r.clone(k,o.center),o.radius=H),o},l.fromCornerPoints=function(t,n,i){e(i)||(i=new l);var a=i.center;return r.add(t,n,a),r.multiplyByScalar(a,.5,a),i.radius=r.distance(a,n),i},l.fromEllipsoid=function(t,n){return e(n)||(n=new l),r.clone(r.ZERO,n.center),n.radius=t.getMaximumRadius(),n},l.clone=function(t,n){return e(t)?e(n)?(n.center=r.clone(t.center,n.center),n.radius=t.radius,n):new l(t.center,t.radius):void 0};var I=new r,P=new r;l.union=function(t,n,i){e(i)||(i=new l);var a=t.center,o=n.center;r.add(a,o,P);var u=r.multiplyByScalar(P,.5,P),s=r.magnitude(r.subtract(a,u,I))+t.radius,h=r.magnitude(r.subtract(o,u,I))+n.radius;return i.radius=Math.max(s,h),r.clone(u,i.center),i};var C=new r;l.expand=function(t,e,n){n=l.clone(t,n);var i=r.magnitude(r.subtract(e,n.center,C));return i>n.radius&&(n.radius=i),n},l.intersect=function(t,e){var n=t.center,i=t.radius,a=r.dot(e,n)+e.w;return-i>a?s.OUTSIDE:i>a?s.INTERSECTING:s.INSIDE};var N=new r;l.transform=function(t,n,i){return e(i)||(i=new l),i.center=c.multiplyByPoint(n,t.center,i.center),i.radius=Math.max(r.magnitude(c.getColumn(n,0,N)),r.magnitude(c.getColumn(n,1,N)),r.magnitude(c.getColumn(n,2,N)))*t.radius,i},l.transformWithoutScale=function(t,n,r){return e(r)||(r=new l),r.center=c.multiplyByPoint(n,t.center,r.center),r.radius=t.radius,r};var q=new r;l.getPlaneDistances=function(t,n,i,a){e(a)||(a=new h);var o=r.subtract(t.center,n,q),u=r.multiplyByScalar(i,r.dot(i,o),q),s=r.magnitude(u);return a.start=s-t.radius,a.stop=s+t.radius,a};for(var U=new r,A=new r,L=new r,W=new r,D=new r,V=new a,B=new Array(8),j=0;8>j;++j)B[j]=new r;var k=new u;return l.projectTo2D=function(e,n,i){n=t(n,k);var a=n.getEllipsoid(),o=e.center,u=e.radius,s=a.geodeticSurfaceNormal(o,U),h=r.cross(r.UNIT_Z,s,A);r.normalize(h,h);var c=r.cross(s,h,L);r.normalize(c,c),r.multiplyByScalar(s,u,s),r.multiplyByScalar(c,u,c),r.multiplyByScalar(h,u,h);var d=r.negate(c,D),f=r.negate(h,W),m=B,y=m[0];r.add(s,c,y),r.add(y,h,y),y=m[1],r.add(s,c,y),r.add(y,f,y),y=m[2],r.add(s,d,y),r.add(y,f,y),y=m[3],r.add(s,d,y),r.add(y,h,y),r.negate(s,s),y=m[4],r.add(s,c,y),r.add(y,h,y),y=m[5],r.add(s,c,y),r.add(y,f,y),y=m[6],r.add(s,d,y),r.add(y,f,y),y=m[7],r.add(s,d,y),r.add(y,h,y);for(var p=m.length,w=0;p>w;++w){var g=m[w];r.add(o,g,g);var v=a.cartesianToCartographic(g,V);n.project(v,g)}i=l.fromPoints(m,i),o=i.center;var x=o.x,M=o.y,z=o.z;return o.x=z,o.y=x,o.z=M,i},l.equals=function(t,n){return t===n||e(t)&&e(n)&&r.equals(t.center,n.center)&&t.radius===n.radius},l.prototype.clone=function(t){return l.clone(this,t)},l.prototype.union=function(t,e){return l.union(this,t,e)},l.prototype.expand=function(t,e){return l.expand(this,t,e)},l.prototype.intersect=function(t){return l.intersect(this,t)},l.prototype.getPlaneDistances=function(t,e,n){return l.getPlaneDistances(this,t,e,n)},l.prototype.projectTo2D=function(t,e){return l.projectTo2D(this,t,e)},l.prototype.equals=function(t){return l.equals(this,t)},l}),define("Core/EllipsoidalOccluder",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./BoundingSphere"],function(t,e,n,r,i){"use strict";function a(t,e,n){var i=t.transformPositionToScaledSpace(e,d),a=r.magnitudeSquared(i),o=Math.sqrt(a),u=r.divideByScalar(i,o,f);a=Math.max(1,a),o=Math.max(1,o);var s=r.dot(u,n),h=r.magnitude(r.cross(u,n)),c=1/o,l=Math.sqrt(a-1)*c;return 1/(s*c-h*l)}function o(t,e,n){return 0>=e||e===1/0||e!==e?void 0:r.multiplyByScalar(t,e,n)}function u(t,e){return t.transformPositionToScaledSpace(e,m),r.normalize(m,m)}var s=function(t,i){if(!e(t))throw new n("ellipsoid is required.");this._ellipsoid=t,this._cameraPosition=new r,this._cameraPositionInScaledSpace=new r,this._distanceToLimbInScaledSpaceSquared=0,e(i)&&this.setCameraPosition(i)};s.prototype.getEllipsoid=function(){return this._ellipsoid},s.prototype.setCameraPosition=function(t){var e=this._ellipsoid,n=e.transformPositionToScaledSpace(t,this._cameraPositionInScaledSpace),i=r.magnitudeSquared(n)-1;r.clone(t,this._cameraPosition),this._cameraPositionInScaledSpace=n,this._distanceToLimbInScaledSpaceSquared=i},s.prototype.getCameraPosition=function(){return this._cameraPosition};var h=new r;s.prototype.isPointVisible=function(t){var e=this._ellipsoid,n=e.transformPositionToScaledSpace(t,h);return this.isScaledSpacePointVisible(n)},s.prototype.isScaledSpacePointVisible=function(t){var e=this._cameraPositionInScaledSpace,n=this._distanceToLimbInScaledSpaceSquared,i=r.subtract(t,e,h),a=-r.dot(i,e),o=a>n&&a*a/r.magnitudeSquared(i)>n;return!o},s.prototype.computeHorizonCullingPoint=function(t,r,i){if(!e(t))throw new n("directionToPoint is required");if(!e(r))throw new n("positions is required");for(var s=this._ellipsoid,h=u(s,t),c=0,l=0,d=r.length;d>l;++l){var f=r[l],m=a(s,f,h);c=Math.max(c,m)}return o(h,c,i)};var c=new r;s.prototype.computeHorizonCullingPointFromVertices=function(i,s,h,l,d){if(!e(i))throw new n("directionToPoint is required");if(!e(s))throw new n("vertices is required");if(!e(h))throw new n("stride is required");l=t(l,r.ZERO);for(var f=this._ellipsoid,m=u(f,i),y=0,p=0,w=s.length;w>p;p+=h){c.x=s[p]+l.x,c.y=s[p+1]+l.y,c.z=s[p+2]+l.z;var g=a(f,c,m);y=Math.max(y,g)}return o(m,y,d)};var l=[];s.prototype.computeHorizonCullingPointFromExtent=function(t,a,o){if(!e(t))throw new n("extent is required.");var u=t.subsample(a,0,l),s=i.fromPoints(u);return r.magnitude(s.center)<.1*a.getMinimumRadius()?void 0:this.computeHorizonCullingPoint(s.center,u,o)};var d=new r,f=new r,m=new r;return s}),define("Core/Extent",["./freezeObject","./defaultValue","./defined","./Ellipsoid","./Cartographic","./DeveloperError","./Math"],function(t,e,n,r,i,a,o){"use strict";var u=function(t,n,r,i){this.west=e(t,0),this.south=e(n,0),this.east=e(r,0),this.north=e(i,0)};u.fromDegrees=function(t,r,i,a,s){return t=o.toRadians(e(t,0)),r=o.toRadians(e(r,0)),i=o.toRadians(e(i,0)),a=o.toRadians(e(a,0)),n(s)?(s.west=t,s.south=r,s.east=i,s.north=a,s):new u(t,r,i,a)},u.fromCartographicArray=function(t,e){if(!n(t))throw new a("cartographics is required.");for(var r=Number.MAX_VALUE,i=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,h=0,c=t.length;c>h;h++){var l=t[h];r=Math.min(r,l.longitude),i=Math.max(i,l.longitude),o=Math.min(o,l.latitude),s=Math.max(s,l.latitude)}return n(e)?(e.west=r,e.south=o,e.east=i,e.north=s,e):new u(r,o,i,s)},u.clone=function(t,e){return n(t)?n(e)?(e.west=t.west,e.south=t.south,e.east=t.east,e.north=t.north,e):new u(t.west,t.south,t.east,t.north):void 0},u.prototype.clone=function(t){return u.clone(this,t)},u.prototype.equals=function(t){return u.equals(this,t)},u.equals=function(t,e){return t===e||n(t)&&n(e)&&t.west===e.west&&t.south===e.south&&t.east===e.east&&t.north===e.north},u.prototype.equalsEpsilon=function(t,e){if("number"!=typeof e)throw new a("epsilon is required and must be a number.");return n(t)&&Math.abs(this.west-t.west)<=e&&Math.abs(this.south-t.south)<=e&&Math.abs(this.east-t.east)<=e&&Math.abs(this.north-t.north)<=e},u.prototype.validate=function(){var t=this.north;if("number"!=typeof t)throw new a("north is required to be a number.");if(t<-o.PI_OVER_TWO||t>o.PI_OVER_TWO)throw new a("north must be in the interval [-Pi/2, Pi/2].");var e=this.south;if("number"!=typeof e)throw new a("south is required to be a number.");if(e<-o.PI_OVER_TWO||e>o.PI_OVER_TWO)throw new a("south must be in the interval [-Pi/2, Pi/2].");var n=this.west;if("number"!=typeof n)throw new a("west is required to be a number.");if(n<-Math.PI||n>Math.PI)throw new a("west must be in the interval [-Pi, Pi].");var r=this.east;if("number"!=typeof r)throw new a("east is required to be a number.");if(r<-Math.PI||r>Math.PI)throw new a("east must be in the interval [-Pi, Pi].")},u.prototype.getSouthwest=function(t){return n(t)?(t.longitude=this.west,t.latitude=this.south,t.height=0,t):new i(this.west,this.south)},u.prototype.getNorthwest=function(t){return n(t)?(t.longitude=this.west,t.latitude=this.north,t.height=0,t):new i(this.west,this.north)},u.prototype.getNortheast=function(t){return n(t)?(t.longitude=this.east,t.latitude=this.north,t.height=0,t):new i(this.east,this.north)},u.prototype.getSoutheast=function(t){return n(t)?(t.longitude=this.east,t.latitude=this.south,t.height=0,t):new i(this.east,this.south)},u.prototype.getCenter=function(t){return n(t)?(t.longitude=.5*(this.west+this.east),t.latitude=.5*(this.south+this.north),t.height=0,t):new i(.5*(this.west+this.east),.5*(this.south+this.north))},u.prototype.intersectWith=function(t,e){if(!n(t))throw new a("otherExtent is required.");var r=Math.max(this.west,t.west),i=Math.max(this.south,t.south),o=Math.min(this.east,t.east),s=Math.min(this.north,t.north);return n(e)?(e.west=r,e.south=i,e.east=o,e.north=s,e):new u(r,i,o,s)},u.prototype.contains=function(t){if(!n(t))throw new a("cartographic is required.");return t.longitude>=this.west&&t.longitude<=this.east&&t.latitude>=this.south&&t.latitude<=this.north},u.prototype.isEmpty=function(){return this.west>=this.east||this.south>=this.north};var s=new i;return u.prototype.subsample=function(t,i,a){t=e(t,r.WGS84),i=e(i,0),n(a)||(a=[]);var u=0,h=this.north,c=this.south,l=this.east,d=this.west,f=s;f.height=i,f.longitude=d,f.latitude=h,a[u]=t.cartographicToCartesian(f,a[u]),u++,f.longitude=l,a[u]=t.cartographicToCartesian(f,a[u]),u++,f.latitude=c,a[u]=t.cartographicToCartesian(f,a[u]),u++,f.longitude=d,a[u]=t.cartographicToCartesian(f,a[u]),u++,f.latitude=0>h?h:c>0?c:0;for(var m=1;8>m;++m){var y=-Math.PI+m*o.PI_OVER_TWO;y>d&&l>y&&(f.longitude=y,a[u]=t.cartographicToCartesian(f,a[u]),u++)}return 0===f.latitude&&(f.longitude=d,a[u]=t.cartographicToCartesian(f,a[u]),u++,f.longitude=l,a[u]=t.cartographicToCartesian(f,a[u]),u++),a.length=u,a},u.MAX_VALUE=t(new u(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),u}),define("Core/HeightmapTessellator",["./defaultValue","./defined","./freezeObject","./DeveloperError","./Cartesian3","./Ellipsoid","./Math"],function(t,e,n,r,i,a,o){"use strict";var u={};return u.DEFAULT_STRUCTURE=n({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1}),u.computeVertices=function(n){if(!e(n)||!e(n.heightmap))throw new r("description.heightmap is required.");if(!e(n.width)||!e(n.height))throw new r("description.width and description.height are required.");if(!e(n.vertices))throw new r("description.vertices is required.");if(!e(n.nativeExtent))throw new r("description.nativeExtent is required.");if(!e(n.skirtHeight))throw new r("description.skirtHeight is required.");var s,h,c,l,d=Math.cos,f=Math.sin,m=Math.sqrt,y=Math.atan,p=Math.exp,w=o.PI_OVER_TWO,g=o.toRadians,v=n.vertices,x=n.heightmap,M=n.width,z=n.height,E=n.skirtHeight,S=t(n.isGeographic,!0),b=t(n.ellipsoid,a.WGS84),O=1/b.getMaximumRadius(),R=n.nativeExtent,_=n.extent;e(_)?(s=_.west,h=_.south,c=_.east,l=_.north):S?(s=g(R.west),h=g(R.south),c=g(R.east),l=g(R.north)):(s=R.west*O,h=w-2*y(p(-R.south*O)),c=R.east*O,l=w-2*y(p(-R.north*O)));var T=t(n.relativeToCenter,i.ZERO),I=t(n.structure,u.DEFAULT_STRUCTURE),P=t(I.heightScale,u.DEFAULT_STRUCTURE.heightScale),C=t(I.heightOffset,u.DEFAULT_STRUCTURE.heightOffset),N=t(I.elementsPerHeight,u.DEFAULT_STRUCTURE.elementsPerHeight),q=t(I.stride,u.DEFAULT_STRUCTURE.stride),U=t(I.elementMultiplier,u.DEFAULT_STRUCTURE.elementMultiplier),A=t(I.isBigEndian,u.DEFAULT_STRUCTURE.isBigEndian),L=(R.east-R.west)/(M-1),W=(R.north-R.south)/(z-1),D=b.getRadiiSquared(),V=D.x,B=D.y,j=D.z,k=0,H=65536,F=-65536,G=0,Z=z,X=0,Y=M;E>0&&(--G,++Z,--X,++Y);for(var K=G;Z>K;++K){var J=K;0>J&&(J=0),J>=z&&(J=z-1);var Q=R.north-W*J;Q=S?g(Q):w-2*y(p(-Q*O));for(var $=d(Q),te=f(Q),ee=j*te,ne=(Q-h)/(l-h),re=X;Y>re;++re){var ie=re;0>ie&&(ie=0),ie>=M&&(ie=M-1);var ae=R.west+L*ie;S?ae=g(ae):ae*=O;var oe,ue=J*M*q+ie*q;if(1===N)oe=x[ue];else{oe=0;var se;if(A)for(se=0;N>se;++se)oe=oe*U+x[ue+se];else for(se=N-1;se>=0;--se)oe=oe*U+x[ue+se]}oe=oe*P+C,F=Math.max(F,oe),H=Math.min(H,oe),(re!==ie||K!==J)&&(oe-=E);var he=$*d(ae),ce=$*f(ae),le=V*he,de=B*ce,fe=m(le*he+de*ce+ee*te),me=1/fe,ye=le*me,pe=de*me,we=ee*me;v[k++]=ye+he*oe-T.x,v[k++]=pe+ce*oe-T.y,v[k++]=we+te*oe-T.z,v[k++]=oe;var ge=(ae-s)/(c-s);v[k++]=ge,v[k++]=ne}}return{maximumHeight:F,minimumHeight:H}},u}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined"],function(t,e){"use strict";var n=function(n){var r,i=[],a={id:void 0,result:void 0,error:void 0};return function(o){var u=o.data;i.length=0,a.id=u.id,a.error=void 0,a.result=void 0;try{a.result=n(u.parameters,i)}catch(s){a.error=s}e(r)||(r=t(self.webkitPostMessage,self.postMessage));try{r(a,i)}catch(s){a.result=void 0,a.error="postMessage failed with error: "+s+"\n  with responseMessage: "+JSON.stringify(a),r(a)}}};return n}),define("Workers/createVerticesFromHeightmap",["../Core/BoundingSphere","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/Extent","../Core/HeightmapTessellator","./createTaskProcessorWorker"],function(t,e,n,r,i,a){"use strict";function o(a,o){var u=6,s=a.width,h=a.height;a.skirtHeight>0&&(s+=2,h+=2);var c=new Float32Array(s*h*u);o.push(c.buffer),a.ellipsoid=e.clone(a.ellipsoid),a.extent=r.clone(a.extent),a.vertices=c;var l=i.computeVertices(a),d=t.fromVertices(c,a.relativeToCenter,u),f=a.ellipsoid,m=new n(f),y=m.computeHorizonCullingPointFromVertices(a.relativeToCenter,c,u,a.relativeToCenter);return{vertices:c.buffer,numberOfAttributes:u,minimumHeight:l.minimumHeight,maximumHeight:l.maximumHeight,gridWidth:s,gridHeight:h,boundingSphere3D:d,occludeePointInScaledSpace:y}}return a(o)})}();