/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2013 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
 * @fileOverview
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var a=r.clock,o=r.cone,s=e(r.magnitude,1),u=s*Math.sin(o);return n.x=u*Math.cos(a),n.y=u*Math.sin(a),n.z=s*Math.cos(o),n},i.fromElements=function(e,r,n,a){return t(a)?(a.x=e,a.y=r,a.z=n,a):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n],a},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r):new i(e.x/n,e.y/n,e.z/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n):new i(e.x*r.x,e.y*r.y,e.z*r.z)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n):new i(e.x+r.x,e.y+r.y,e.z+r.z)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n):new i(e.x-r.x,e.y-r.y,e.z-r.z)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n):new i(e.x*r,e.y*r,e.z*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n):new i(e.x/r,e.y/r,e.z/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r):new i(-e.x,-e.y,-e.z)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z))};var o=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,o),n=i.multiplyByScalar(e,1-r,n),i.add(o,n,n)};var s=new i,u=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,u);var r=i.dot(s,u),n=i.magnitude(i.cross(s,u,s));return Math.atan2(n,r)};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n},i.cross=function(e,r,n){var a=e.x,o=e.y,s=e.z,u=r.x,l=r.y,c=r.z,f=o*c-s*l,h=s*u-a*c,m=a*l-o*u;return t(n)?(n.x=f,n.y=h,n.z=m,n):new i(f,h,m)},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n,i){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,r,n,a,o){return t(o)?(o.x=e,o.y=r,o.z=n,o.w=a,o):new i(e,r,n,a)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n++],a.w=r[n],a},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n.w=Math.min(e.w,r.w),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n.w=Math.max(e.w,r.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r.w=e.w/n,r):new i(e.x/n,e.y/n,e.z/n,e.w/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n.w=e.w*r.w,n):new i(e.x*r.x,e.y*r.y,e.z*r.z,e.w*r.w)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n):new i(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n):new i(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n):new i(e.x*r,e.y*r,e.z*r,e.w*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n):new i(e.x/r,e.y/r,e.z/r,e.w/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new i(-e.x,-e.y,-e.z,-e.w)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r.w=Math.abs(e.w),r):new i(Math.abs(e.x),Math.abs(e.y),Math.abs(e.z),Math.abs(e.w))};var o=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,o),n=i.multiplyByScalar(e,1-r,n),i.add(o,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n&&Math.abs(e.w-r.w)<=n},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["./defaultValue","./defined","./DeveloperError","../ThirdParty/mersenne-twister"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.negativePiToPi=function(e){for(var t=i.EPSILON10,r=i.PI,n=i.TWO_PI;-(r+t)>e;)e+=n;if(-r>e)return-r;for(;e>r+t;)e-=n;return e>r?r:e},i.zeroToTwoPi=function(e){var t=e%i.TWO_PI;return 0>t?(t+i.TWO_PI)%i.TWO_PI:t},i.equalsEpsilon=function(t,r,n){return n=e(n,0),Math.abs(t-r)<=n};var a=[1];i.factorial=function(e){var t=a.length;if(e>=t)for(var r=a[t-1],n=t;e>=n;n++)a.push(r*n);return a[e]},i.incrementWrap=function(t,r,n){return n=e(n,0),++t,t>r&&(t=n),t},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,r){return t>e?t:e>r?r:e};var o=new n;return i.setRandomNumberSeed=function(e){o=new n(e)},i.nextRandomNumber=function(){return o.random()},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return a.fromDegrees=function(r,n,o,s){return r=i.toRadians(e(r,0)),n=i.toRadians(e(n,0)),o=e(o,0),t(s)?(s.longitude=r,s.latitude=n,s.height=o,s):new a(r,n,o)},a.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new r("epsilon is required and must be a number.");return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.toString=function(e){if(!t(e))throw new r("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/Ellipsoid",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic"],function(e,t,r,n,i,a,o){"use strict";var s=function(e,r,o){if(e=t(e,0),r=t(r,0),o=t(o,0),0>e||0>r||0>o)throw new n("All radii components must be greater than or equal to zero.");this._radii=new a(e,r,o),this._radiiSquared=new a(e*e,r*r,o*o),this._radiiToTheFourth=new a(e*e*e*e,r*r*r*r,o*o*o*o),this._oneOverRadii=new a(0===e?0:1/e,0===r?0:1/r,0===o?0:1/o),this._oneOverRadiiSquared=new a(0===e?0:1/(e*e),0===r?0:1/(r*r),0===o?0:1/(o*o)),this._minimumRadius=Math.min(e,r,o),this._maximumRadius=Math.max(e,r,o),this._centerToleranceSquared=i.EPSILON1};s.clone=function(e,t){if(!r(e))return void 0;var n=e._radii;return r(t)?(a.clone(n,t._radii),a.clone(e._radiiSquared,t._radiiSquared),a.clone(e._radiiToTheFourth,t._radiiToTheFourth),a.clone(e._oneOverRadii,t._oneOverRadii),a.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new s(n.x,n.y,n.z)},s.fromCartesian3=function(e){return r(e)?new s(e.x,e.y,e.z):new s},s.WGS84=e(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=e(new s(1,1,1)),s.MOON=e(new s(i.LUNAR_RADIUS,i.LUNAR_RADIUS,i.LUNAR_RADIUS)),s.prototype.getRadii=function(){return this._radii},s.prototype.getRadiiSquared=function(){return this._radiiSquared},s.prototype.getRadiiToTheFourth=function(){return this._radiiToTheFourth},s.prototype.getOneOverRadii=function(){return this._oneOverRadii},s.prototype.getOneOverRadiiSquared=function(){return this._oneOverRadiiSquared},s.prototype.getMinimumRadius=function(){return this._minimumRadius},s.prototype.getMaximumRadius=function(){return this._maximumRadius},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=a.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(e,t){if(!r(e))throw new n("cartographic is required.");var i=e.longitude,o=e.latitude,s=Math.cos(o),u=s*Math.cos(i),l=s*Math.sin(i),c=Math.sin(o);return r(t)||(t=new a),t.x=u,t.y=l,t.z=c,a.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(e,t){return t=a.multiplyComponents(e,this._oneOverRadiiSquared,t),a.normalize(t,t)};var u=new a,l=new a;s.prototype.cartographicToCartesian=function(e,t){var r=u,n=l;this.geodeticSurfaceNormalCartographic(e,r),a.multiplyComponents(this._radiiSquared,r,n);var i=Math.sqrt(a.dot(r,n));return a.divideByScalar(n,i,n),a.multiplyByScalar(r,e.height,r),a.add(n,r,t)},s.prototype.cartographicArrayToCartesianArray=function(e,t){if(!r(e))throw new n("cartographics is required.");var i=e.length;r(t)?t.length=i:t=new Array(i);for(var a=0;i>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var c=new a,f=new a,h=new a;s.prototype.cartesianToCartographic=function(e,t){var n=this.scaleToGeodeticSurface(e,f);if(!r(n))return void 0;var s=this.geodeticSurfaceNormal(n,c),u=a.subtract(e,n,h),l=Math.atan2(s.y,s.x),m=Math.asin(s.z),d=i.sign(a.dot(u,e))*a.magnitude(u);return r(t)?(t.longitude=l,t.latitude=m,t.height=d,t):new o(l,m,d)},s.prototype.cartesianArrayToCartographicArray=function(e,t){if(!r(e))throw new n("cartesians is required.");var i=e.length;r(t)?t.length=i:t=new Array(i);for(var a=0;i>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t};var m=new a,d=new a;return s.prototype.scaleToGeodeticSurface=function(e,t){if(!r(e))throw new n("cartesian is required.");var o=e.x,s=e.y,u=e.z,l=this._oneOverRadii,c=l.x,f=l.y,h=l.z,p=o*o*c*c,y=s*s*f*f,v=u*u*h*h,w=p+y+v,g=Math.sqrt(1/w),E=a.multiplyByScalar(e,g,m);if(w<this._centerToleranceSquared)return isFinite(g)?a.clone(E,t):void 0;var S=this._oneOverRadiiSquared,C=S.x,x=S.y,b=S.z,T=d;T.x=2*E.x*C,T.y=2*E.y*x,T.z=2*E.z*b;var O,A,M,D,_,N,I,R,P,z,L,q=(1-g)*a.magnitude(e)/(.5*a.magnitude(T)),F=0;do{q-=F,M=1/(1+q*C),D=1/(1+q*x),_=1/(1+q*b),N=M*M,I=D*D,R=_*_,P=N*M,z=I*D,L=R*_,O=p*N+y*I+v*R-1,A=p*P*C+y*z*x+v*L*b;var U=-2*A;F=O/U}while(Math.abs(O)>i.EPSILON12);return r(t)?(t.x=o*M,t.y=s*D,t.z=u*_,t):new a(o*M,s*D,u*_)},s.prototype.scaleToGeocentricSurface=function(e,t){if(!r(e))throw new n("cartesian is required.");var i=e.x,o=e.y,s=e.z,u=this._oneOverRadiiSquared,l=1/Math.sqrt(i*i*u.x+o*o*u.y+s*s*u.z);return a.multiplyByScalar(e,l,t)},s.prototype.transformPositionToScaledSpace=function(e,t){return a.multiplyComponents(e,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(e,t){return a.multiplyComponents(e,this._radii,t)},s.prototype.equals=function(e){return this===e||r(e)&&a.equals(this._radii,e._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Ellipsoid"],function(e,t,r,n,i){"use strict";var a=function(t){this._ellipsoid=e(t,i.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return a.prototype.getEllipsoid=function(){return this._ellipsoid},a.prototype.project=function(e,n){var i=this._semimajorAxis,a=e.longitude*i,o=e.latitude*i,s=e.height;return t(n)?(n.x=a,n.y=o,n.z=s,n):new r(a,o,s)},a.prototype.unproject=function(e,r){var i=this._oneOverSemimajorAxis,a=e.x*i,o=e.y*i,s=e.z;return t(r)?(r.longitude=a,r.latitude=o,r.height=s,r):new n(a,o,s)},a}),define("Core/Enumeration",["./defined"],function(e){"use strict";var t=function(t,r,n){if(this.value=t,this.name=r,e(n))for(var i in n)n.hasOwnProperty(i)&&(this[i]=n[i])};return t.prototype.valueOf=function(){return this.value},t.prototype.toString=function(){return this.name},t}),define("Core/Intersect",["./Enumeration"],function(e){"use strict";var t={OUTSIDE:new e(-1,"OUTSIDE"),INTERSECTING:new e(0,"INTERSECTING"),INSIDE:new e(1,"INSIDE")};return t}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var n=e[l.getElementIndex(f[r],c[r])];t+=2*n*n}return Math.sqrt(t)}function u(e,t){for(var r=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var s=Math.abs(e[l.getElementIndex(f[o],c[o])]);s>n&&(i=o,n=s)}var u=1,h=0,m=c[i],d=f[i];if(Math.abs(e[l.getElementIndex(d,m)])>r){var p,y=e[l.getElementIndex(d,d)],v=e[l.getElementIndex(m,m)],w=e[l.getElementIndex(d,m)],g=(y-v)/2/w;p=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),u=1/Math.sqrt(1+p*p),h=p*u}return t=l.clone(l.IDENTITY,t),t[l.getElementIndex(m,m)]=t[l.getElementIndex(d,d)]=u,t[l.getElementIndex(d,m)]=h,t[l.getElementIndex(m,d)]=-h,t}var l=function(e,r,n,i,a,o,s,u,l){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(a,0),this[5]=t(u,0),this[6]=t(n,0),this[7]=t(o,0),this[8]=t(l,0)};l.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,n,i){return n=t(n,0),r(i)||(i=new l),i[0]=e[n],i[1]=e[n+1],i[2]=e[n+2],i[3]=e[n+3],i[4]=e[n+4],i[5]=e[n+5],i[6]=e[n+6],i[7]=e[n+7],i[8]=e[n+8],i[9]=e[n+9],i},l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,t){var n=e.x*e.x,i=e.x*e.y,a=e.x*e.z,o=e.x*e.w,s=e.y*e.y,u=e.y*e.z,c=e.y*e.w,f=e.z*e.z,h=e.z*e.w,m=e.w*e.w,d=n-s-f+m,p=2*(i-h),y=2*(a+c),v=2*(i+h),w=-n+s-f+m,g=2*(u-o),E=2*(a-c),S=2*(u+o),C=-n-s+f+m;return r(t)?(t[0]=d,t[1]=v,t[2]=E,t[3]=p,t[4]=w,t[5]=S,t[6]=y,t[7]=g,t[8]=C,t):new l(d,p,y,v,w,g,E,S,C)},l.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new l(e,0,0,0,e,0,0,0,e)},l.fromRotationX=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=i,t[6]=0,t[7]=-i,t[8]=n,t):new l(1,0,0,0,n,-i,0,i,n)},l.fromRotationY=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=n,t):new l(n,0,i,0,1,0,-i,0,n)},l.fromRotationZ=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=i,t[2]=0,t[3]=-i,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new l(n,-i,0,i,n,0,0,0,1)},l.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,t){return 3*e+t},l.getColumn=function(t,n,i){var a=3*n,o=t[a],s=t[a+1],u=t[a+2];return r(i)?(i.x=o,i.y=s,i.z=u,i):new e(o,s,u)},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var i=3*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n},l.getRow=function(t,n,i){var a=t[n],o=t[n+3],s=t[n+6];return r(i)?(i.x=a,i.y=o,i.z=s,i):new e(a,o,s)},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n},l.multiply=function(e,t,n){var i=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],o=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],s=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],f=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],h=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],m=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r(n)?(n[0]=i,n[1]=a,n[2]=o,n[3]=s,n[4]=u,n[5]=c,n[6]=f,n[7]=h,n[8]=m,n):new l(i,s,f,a,u,h,o,c,m)},l.multiplyByVector=function(t,n,i){var a=n.x,o=n.y,s=n.z,u=t[0]*a+t[3]*o+t[6]*s,l=t[1]*a+t[4]*o+t[7]*s,c=t[2]*a+t[5]*o+t[8]*s;return r(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByScalar=function(e,t,n){return r(n)?(n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n):new l(e[0]*t,e[3]*t,e[6]*t,e[1]*t,e[4]*t,e[7]*t,e[2]*t,e[5]*t,e[8]*t)},l.negate=function(e,t){return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t):new l(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},l.transpose=function(e,t){var n=e[0],i=e[3],a=e[6],o=e[1],s=e[4],u=e[7],c=e[2],f=e[5],h=e[8];return r(t)?(t[0]=n,t[1]=i,t[2]=a,t[3]=o,t[4]=s,t[5]=u,t[6]=c,t[7]=f,t[8]=h,t):new l(n,o,c,i,s,f,a,u,h)};var c=[1,0,0],f=[2,2,1],h=new l,m=new l;return l.getEigenDecomposition=function(e,t){var n=a.EPSILON20,i=10,c=0,f=0;r(t)||(t={});for(var d=t.unitary=l.clone(l.IDENTITY,t.unitary),p=t.diagonal=l.clone(e,t.diagonal),y=n*o(p);i>f&&s(p)>y;)u(p,h),l.transpose(h,m),l.multiply(p,h,p),l.multiply(m,p,p),l.multiply(d,h,d),++c>2&&(++f,c=0);return t},l.abs=function(e,t){return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t):new l(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},l.determinant=function(e){if(!r(e))throw new n("matrix is required");var t=e[0],i=e[3],a=e[6],o=e[1],s=e[4],u=e[7],l=e[2],c=e[5],f=e[8];return t*(s*f-c*u)+o*(c*a-i*f)+l*(i*u-s*a)},l.inverse=function(e,t){if(!r(e))throw new n("matrix is required");var i=e[0],o=e[1],s=e[2],u=e[3],c=e[4],f=e[5],h=e[6],m=e[7],d=e[8],p=l.determinant(e);if(Math.abs(p)<=a.EPSILON15)throw new n("matrix is not invertible");var y=new l(c*d-m*f,h*f-u*d,u*m-h*c,m*s-o*d,i*d-h*s,h*o-i*m,o*f-c*s,u*s-i*f,i*c-u*o),v=1/p;return l.multiplyByScalar(y,v,t)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},l.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},l.IDENTITY=i(new l(1,0,0,0,1,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t=new Error;this.stack=t.stack};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,s,u){"use strict";var l=function(e,t,n,i,a,o,s,u,l,c,f,h,m,d,p,y){this[0]=r(e,0),this[1]=r(a,0),this[2]=r(l,0),this[3]=r(m,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(c,0),this[7]=r(d,0),this[8]=r(n,0),this[9]=r(s,0),this[10]=r(f,0),this[11]=r(p,0),this[12]=r(i,0),this[13]=r(u,0),this[14]=r(h,0),this[15]=r(y,0)};l.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=function(e,t,i){return t=r(t,0),n(i)||(i=new l),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i[9]=e[t+9],i[10]=e[t+10],i[11]=e[t+11],i[12]=e[t+12],i[13]=e[t+13],i[14]=e[t+14],i[15]=e[t+15],i},l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(e,t,r){return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=0,r[4]=e[3],r[5]=e[4],r[6]=e[5],r[7]=0,r[8]=e[6],r[9]=e[7],r[10]=e[8],r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,r):new l(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},new s,l.fromTranslationQuaternionRotationScale=function(e,t,r,i){n(i)||(i=new l);var a=r.x,o=r.y,s=r.z,u=t.x*t.x,c=t.x*t.y,f=t.x*t.z,h=t.x*t.w,m=t.y*t.y,d=t.y*t.z,p=t.y*t.w,y=t.z*t.z,v=t.z*t.w,w=t.w*t.w,g=u-m-y+w,E=2*(c-v),S=2*(f+p),C=2*(c+v),x=-u+m-y+w,b=2*(d-h),T=2*(f-p),O=2*(d+h),A=-u-m+y+w;return i[0]=g*a,i[1]=C*a,i[2]=T*a,i[3]=0,i[4]=E*o,i[5]=x*o,i[6]=O*o,i[7]=0,i[8]=S*s,i[9]=b*s,i[10]=A*s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},l.fromTranslation=function(e,t){return l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,f=new e,h=new e;l.fromCamera=function(t,r){var i=t.eye,a=t.target,o=t.up;e.normalize(e.subtract(a,i,c),c),e.normalize(e.cross(c,o,f),f),e.normalize(e.cross(f,c,h),h);var s=f.x,u=f.y,m=f.z,d=c.x,p=c.y,y=c.z,v=h.x,w=h.y,g=h.z,E=i.x,S=i.y,C=i.z,x=s*-E+u*-S+m*-C,b=v*-E+w*-S+g*-C,T=d*E+p*S+y*C;return n(r)?(r[0]=s,r[1]=v,r[2]=-d,r[3]=0,r[4]=u,r[5]=w,r[6]=-p,r[7]=0,r[8]=m,r[9]=g,r[10]=-y,r[11]=0,r[12]=x,r[13]=b,r[14]=T,r[15]=1,r):new l(s,u,m,x,v,w,g,b,-d,-p,-y,T,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,r,i,a){var o=Math.tan(.5*e),s=1/o,u=s/t,c=(i+r)/(r-i),f=2*i*r/(r-i);return n(a)?(a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a):new l(u,0,0,0,0,s,0,0,0,0,c,f,0,0,-1,0)},l.computeOrthographicOffCenter=function(e,t,r,i,a,o,s){var u=1/(t-e),c=1/(i-r),f=1/(o-a),h=-(t+e)*u,m=-(i+r)*c,d=-(o+a)*f;return u*=2,c*=2,f*=-2,n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=h,s[13]=m,s[14]=d,s[15]=1,s):new l(u,0,0,h,0,c,0,m,0,0,f,d,0,0,0,1)},l.computePerspectiveOffCenter=function(e,t,r,i,a,o,s){var u=2*a/(t-e),c=2*a/(i-r),f=(t+e)/(t-e),h=(i+r)/(i-r),m=-(o+a)/(o-a),d=-1,p=-2*o*a/(o-a);return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=h,s[10]=m,s[11]=d,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s):new l(u,0,f,0,0,c,h,0,0,0,m,p,0,0,d,0)},l.computeInfinitePerspectiveOffCenter=function(e,t,r,i,a,o){var s=2*a/(t-e),u=2*a/(i-r),c=(t+e)/(t-e),f=(i+r)/(i-r),h=-1,m=-1,d=-2*a;return n(o)?(o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=u,o[6]=0,o[7]=0,o[8]=c,o[9]=f,o[10]=h,o[11]=m,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o):new l(s,0,c,0,0,u,f,0,0,0,h,d,0,0,m,0)},l.computeViewportTransformation=function(e,t,i,a){e=r(e,r.EMPTY_OBJECT);var o=r(e.x,0),s=r(e.y,0),u=r(e.width,0),c=r(e.height,0);t=r(t,0),i=r(i,1);var f=.5*u,h=.5*c,m=.5*(i-t),d=f,p=h,y=m,v=o+f,w=s+h,g=t+m,E=1;return n(a)?(a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=p,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=v,a[13]=w,a[14]=g,a[15]=E,a):new l(d,0,0,v,0,p,0,w,0,0,y,g,0,0,0,E)},l.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return 4*e+t},l.getColumn=function(e,r,i){var a=4*r,o=e[a],s=e[a+1],u=e[a+2],l=e[a+3];return n(i)?(i.x=o,i.y=s,i.z=u,i.w=l,i):new t(o,s,u,l)},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var i=4*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n[i+3]=r.w,n},l.getRow=function(e,r,i){var a=e[r],o=e[r+4],s=e[r+8],u=e[r+12];return n(i)?(i.x=a,i.y=o,i.z=s,i.w=u,i):new t(a,o,s,u)},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n},l.multiply=function(e,t,r){var i=e[0],a=e[1],o=e[2],s=e[3],u=e[4],c=e[5],f=e[6],h=e[7],m=e[8],d=e[9],p=e[10],y=e[11],v=e[12],w=e[13],g=e[14],E=e[15],S=t[0],C=t[1],x=t[2],b=t[3],T=t[4],O=t[5],A=t[6],M=t[7],D=t[8],_=t[9],N=t[10],I=t[11],R=t[12],P=t[13],z=t[14],L=t[15],q=i*S+u*C+m*x+v*b,F=a*S+c*C+d*x+w*b,U=o*S+f*C+p*x+g*b,B=s*S+h*C+y*x+E*b,G=i*T+u*O+m*A+v*M,W=a*T+c*O+d*A+w*M,Y=o*T+f*O+p*A+g*M,H=s*T+h*O+y*A+E*M,j=i*D+u*_+m*N+v*I,V=a*D+c*_+d*N+w*I,k=o*D+f*_+p*N+g*I,K=s*D+h*_+y*N+E*I,Z=i*R+u*P+m*z+v*L,X=a*R+c*P+d*z+w*L,J=o*R+f*P+p*z+g*L,Q=s*R+h*P+y*z+E*L;return n(r)?(r[0]=q,r[1]=F,r[2]=U,r[3]=B,r[4]=G,r[5]=W,r[6]=Y,r[7]=H,r[8]=j,r[9]=V,r[10]=k,r[11]=K,r[12]=Z,r[13]=X,r[14]=J,r[15]=Q,r):new l(q,G,j,Z,F,W,V,X,U,Y,k,J,B,H,K,Q)},l.multiplyTransformation=function(e,t,r){var i=e[0],a=e[1],o=e[2],s=e[4],u=e[5],c=e[6],f=e[8],h=e[9],m=e[10],d=e[12],p=e[13],y=e[14],v=t[0],w=t[1],g=t[2],E=t[4],S=t[5],C=t[6],x=t[8],b=t[9],T=t[10],O=t[12],A=t[13],M=t[14],D=i*v+s*w+f*g,_=a*v+u*w+h*g,N=o*v+c*w+m*g,I=i*E+s*S+f*C,R=a*E+u*S+h*C,P=o*E+c*S+m*C,z=i*x+s*b+f*T,L=a*x+u*b+h*T,q=o*x+c*b+m*T,F=i*O+s*A+f*M+d,U=a*O+u*A+h*M+p,B=o*O+c*A+m*M+y;
return n(r)?(r[0]=D,r[1]=_,r[2]=N,r[3]=0,r[4]=I,r[5]=R,r[6]=P,r[7]=0,r[8]=z,r[9]=L,r[10]=q,r[11]=0,r[12]=F,r[13]=U,r[14]=B,r[15]=1,r):new l(D,I,z,F,_,R,L,U,N,P,q,B,0,0,0,1)},l.multiplyByTranslation=function(e,t,r){var i=t.x,a=t.y,o=t.z,s=i*e[0]+a*e[4]+o*e[8]+e[12],u=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=s,r[13]=u,r[14]=c,r[15]=e[15],r):new l(e[0],e[4],e[8],s,e[1],e[5],e[9],u,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var m=new e;return l.multiplyByUniformScale=function(e,t,r){return m.x=t,m.y=t,m.z=t,l.multiplyByScale(e,m,r)},l.multiplyByScale=function(e,t,r){var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?l.clone(e,r):n(r)?(r[0]=i*e[0],r[1]=i*e[1],r[2]=i*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=o*e[8],r[9]=o*e[9],r[10]=o*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r):new l(i*e[0],a*e[4],o*e[8],e[12],i*e[1],a*e[5],o*e[9],e[13],i*e[2],a*e[6],o*e[10],e[14],0,0,0,1)},l.multiplyByVector=function(e,r,i){var a=r.x,o=r.y,s=r.z,u=r.w,l=e[0]*a+e[4]*o+e[8]*s+e[12]*u,c=e[1]*a+e[5]*o+e[9]*s+e[13]*u,f=e[2]*a+e[6]*o+e[10]*s+e[14]*u,h=e[3]*a+e[7]*o+e[11]*s+e[15]*u;return n(i)?(i.x=l,i.y=c,i.z=f,i.w=h,i):new t(l,c,f,h)},l.multiplyByPointAsVector=function(t,r,i){var a=r.x,o=r.y,s=r.z,u=t[0]*a+t[4]*o+t[8]*s,l=t[1]*a+t[5]*o+t[9]*s,c=t[2]*a+t[6]*o+t[10]*s;return n(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByPoint=function(t,r,i){var a=r.x,o=r.y,s=r.z,u=t[0]*a+t[4]*o+t[8]*s+t[12],l=t[1]*a+t[5]*o+t[9]*s+t[13],c=t[2]*a+t[6]*o+t[10]*s+t[14];return n(i)?(i.x=u,i.y=l,i.z=c,i):new e(u,l,c)},l.multiplyByScalar=function(e,t,r){return n(r)?(r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r):new l(e[0]*t,e[4]*t,e[8]*t,e[12]*t,e[1]*t,e[5]*t,e[9]*t,e[13]*t,e[2]*t,e[6]*t,e[10]*t,e[14]*t,e[3]*t,e[7]*t,e[11]*t,e[15]*t)},l.negate=function(e,t){return n(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t):new l(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},l.transpose=function(e,t){if(!n(t))return new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var r=e[1],i=e[2],a=e[3],o=e[6],s=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=s,t[14]=u,t[15]=e[15],t},l.abs=function(e,t){return n(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t):new l(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},l.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[11]===t[11]&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},l.getTranslation=function(t,r){return n(r)?(r.x=t[12],r.y=t[13],r.z=t[14],r):new e(t[12],t[13],t[14])},l.getRotation=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},l.inverse=function(e,t){var r=e[0],i=e[4],a=e[8],s=e[12],c=e[1],f=e[5],h=e[9],m=e[13],d=e[2],p=e[6],y=e[10],v=e[14],w=e[3],g=e[7],E=e[11],S=e[15],C=y*S,x=v*E,b=p*S,T=v*g,O=p*E,A=y*g,M=d*S,D=v*w,_=d*E,N=y*w,I=d*g,R=p*w,P=C*f+T*h+O*m-(x*f+b*h+A*m),z=x*c+M*h+N*m-(C*c+D*h+_*m),L=b*c+D*f+I*m-(T*c+M*f+R*m),q=A*c+_*f+R*h-(O*c+N*f+I*h),F=x*i+b*a+A*s-(C*i+T*a+O*s),U=C*r+D*a+_*s-(x*r+M*a+N*s),B=T*r+M*i+R*s-(b*r+D*i+I*s),G=O*r+N*i+I*a-(A*r+_*i+R*a);C=a*m,x=s*h,b=i*m,T=s*f,O=i*h,A=a*f,M=r*m,D=s*c,_=r*h,N=a*c,I=r*f,R=i*c;var W=C*g+T*E+O*S-(x*g+b*E+A*S),Y=x*w+M*E+N*S-(C*w+D*E+_*S),H=b*w+D*g+I*S-(T*w+M*g+R*S),j=A*w+_*g+R*E-(O*w+N*g+I*E),V=b*y+A*v+x*p-(O*v+C*p+T*y),k=_*v+C*d+D*y-(M*y+N*v+x*d),K=M*p+R*v+T*d-(I*v+b*d+D*p),Z=I*y+O*d+N*p-(_*p+R*y+A*d),X=r*P+i*z+a*L+s*q;if(Math.abs(X)<o.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return X=1/X,n(t)?(t[0]=P*X,t[1]=z*X,t[2]=L*X,t[3]=q*X,t[4]=F*X,t[5]=U*X,t[6]=B*X,t[7]=G*X,t[8]=W*X,t[9]=Y*X,t[10]=H*X,t[11]=j*X,t[12]=V*X,t[13]=k*X,t[14]=K*X,t[15]=Z*X,t):new l(P*X,F*X,W*X,V*X,z*X,U*X,Y*X,k*X,L*X,B*X,H*X,K*X,q*X,G*X,j*X,Z*X)},l.inverseTransformation=function(e,t){var r=e[0],i=e[1],a=e[2],o=e[4],s=e[5],u=e[6],c=e[8],f=e[9],h=e[10],m=e[12],d=e[13],p=e[14],y=-r*m-i*d-a*p,v=-o*m-s*d-u*p,w=-c*m-f*d-h*p;return n(t)?(t[0]=r,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=s,t[6]=f,t[7]=0,t[8]=a,t[9]=u,t[10]=h,t[11]=0,t[12]=y,t[13]=v,t[14]=w,t[15]=1,t):new l(r,i,a,y,o,s,u,v,c,f,h,w,0,0,0,1)},l.IDENTITY=a(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/BoundingSphere",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Cartesian4","./Cartographic","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4"],function(e,t,r,n,i,a,o,s,u,l,c){"use strict";var f=function(t,r){this.center=n.clone(e(t,n.ZERO)),this.radius=e(r,0)},h=new n,m=new n,d=new n,p=new n,y=new n,v=new n,w=new n,g=new n,E=new n,S=new n,C=new n,x=new n;f.fromPoints=function(e,r){if(t(r)||(r=new f),!t(e)||0===e.length)return r.center=n.clone(n.ZERO,r.center),r.radius=0,r;for(var i=n.clone(e[0],w),a=n.clone(i,h),o=n.clone(i,m),s=n.clone(i,d),u=n.clone(i,p),l=n.clone(i,y),c=n.clone(i,v),b=e.length,T=1;b>T;T++){n.clone(e[T],i);var O=i.x,A=i.y,M=i.z;O<a.x&&n.clone(i,a),O>u.x&&n.clone(i,u),A<o.y&&n.clone(i,o),A>l.y&&n.clone(i,l),M<s.z&&n.clone(i,s),M>c.z&&n.clone(i,c)}var D=n.magnitudeSquared(n.subtract(u,a,g)),_=n.magnitudeSquared(n.subtract(l,o,g)),N=n.magnitudeSquared(n.subtract(c,s,g)),I=a,R=u,P=D;_>P&&(P=_,I=o,R=l),N>P&&(P=N,I=s,R=c);var z=E;z.x=.5*(I.x+R.x),z.y=.5*(I.y+R.y),z.z=.5*(I.z+R.z);var L=n.magnitudeSquared(n.subtract(R,z,g)),q=Math.sqrt(L),F=S;F.x=a.x,F.y=o.y,F.z=s.z;var U=C;U.x=u.x,U.y=l.y,U.z=c.z;var B=n.multiplyByScalar(n.add(F,U,g),.5,x),G=0;for(T=0;b>T;T++){n.clone(e[T],i);var W=n.magnitude(n.subtract(i,B,g));W>G&&(G=W);var Y=n.magnitudeSquared(n.subtract(i,z,g));if(Y>L){var H=Math.sqrt(Y);q=.5*(q+H),L=q*q;var j=H-q;z.x=(q*z.x+j*i.x)/H,z.y=(q*z.y+j*i.y)/H,z.z=(q*z.z+j*i.z)/H}}return G>q?(n.clone(z,r.center),r.radius=q):(n.clone(B,r.center),r.radius=G),r};var b=new s,T=new n,O=new n,A=new a,M=new a;f.fromExtent2D=function(e,t,r){return f.fromExtentWithHeights2D(e,t,0,0,r)},f.fromExtentWithHeights2D=function(r,i,a,o,s){if(t(s)||(s=new f),!t(r))return s.center=n.clone(n.ZERO,s.center),s.radius=0,s;i=e(i,b),r.getSouthwest(A),A.height=a,r.getNortheast(M),M.height=o;var u=i.project(A,T),l=i.project(M,O),c=l.x-u.x,h=l.y-u.y,m=l.z-u.z;s.radius=.5*Math.sqrt(c*c+h*h+m*m);var d=s.center;return d.x=u.x+.5*c,d.y=u.y+.5*h,d.z=u.z+.5*m,s};var D=[];f.fromExtent3D=function(r,n,i,a){n=e(n,o.WGS84),i=e(i,0);var s;return t(r)&&(s=r.subsample(n,i,D)),f.fromPoints(s,a)},f.fromVertices=function(r,i,a,o){if(t(o)||(o=new f),!t(r)||0===r.length)return o.center=n.clone(n.ZERO,o.center),o.radius=0,o;i=e(i,n.ZERO),a=e(a,3);var s=w;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var u=n.clone(s,h),l=n.clone(s,m),c=n.clone(s,d),b=n.clone(s,p),T=n.clone(s,y),O=n.clone(s,v),A=r.length,M=0;A>M;M+=a){var D=r[M]+i.x,_=r[M+1]+i.y,N=r[M+2]+i.z;s.x=D,s.y=_,s.z=N,D<u.x&&n.clone(s,u),D>b.x&&n.clone(s,b),_<l.y&&n.clone(s,l),_>T.y&&n.clone(s,T),N<c.z&&n.clone(s,c),N>O.z&&n.clone(s,O)}var I=n.magnitudeSquared(n.subtract(b,u,g)),R=n.magnitudeSquared(n.subtract(T,l,g)),P=n.magnitudeSquared(n.subtract(O,c,g)),z=u,L=b,q=I;R>q&&(q=R,z=l,L=T),P>q&&(q=P,z=c,L=O);var F=E;F.x=.5*(z.x+L.x),F.y=.5*(z.y+L.y),F.z=.5*(z.z+L.z);var U=n.magnitudeSquared(n.subtract(L,F,g)),B=Math.sqrt(U),G=S;G.x=u.x,G.y=l.y,G.z=c.z;var W=C;W.x=b.x,W.y=T.y,W.z=O.z;var Y=n.multiplyByScalar(n.add(G,W,g),.5,x),H=0;for(M=0;A>M;M+=a){s.x=r[M]+i.x,s.y=r[M+1]+i.y,s.z=r[M+2]+i.z;var j=n.magnitude(n.subtract(s,Y,g));j>H&&(H=j);var V=n.magnitudeSquared(n.subtract(s,F,g));if(V>U){var k=Math.sqrt(V);B=.5*(B+k),U=B*B;var K=k-B;F.x=(B*F.x+K*s.x)/k,F.y=(B*F.y+K*s.y)/k,F.z=(B*F.z+K*s.z)/k}}return H>B?(n.clone(F,o.center),o.radius=B):(n.clone(Y,o.center),o.radius=H),o},f.fromCornerPoints=function(e,r,i){t(i)||(i=new f);var a=i.center;return n.add(e,r,a),n.multiplyByScalar(a,.5,a),i.radius=n.distance(a,r),i},f.fromEllipsoid=function(e,r){return t(r)||(r=new f),n.clone(n.ZERO,r.center),r.radius=e.getMaximumRadius(),r},f.clone=function(e,r){return t(e)?t(r)?(r.center=n.clone(e.center,r.center),r.radius=e.radius,r):new f(e.center,e.radius):void 0};var _=new n,N=new n;f.union=function(e,r,i){t(i)||(i=new f);var a=e.center,o=r.center;n.add(a,o,N);var s=n.multiplyByScalar(N,.5,N),u=n.magnitude(n.subtract(a,s,_))+e.radius,l=n.magnitude(n.subtract(o,s,_))+r.radius;return i.radius=Math.max(u,l),n.clone(s,i.center),i};var I=new n;f.expand=function(e,t,r){r=f.clone(e,r);var i=n.magnitude(n.subtract(t,r.center,I));return i>r.radius&&(r.radius=i),r},f.intersect=function(e,t){var r=e.center,i=e.radius,a=n.dot(t,r)+t.w;return-i>a?u.OUTSIDE:i>a?u.INTERSECTING:u.INSIDE};var R=new n;f.transform=function(e,r,i){return t(i)||(i=new f),i.center=c.multiplyByPoint(r,e.center,i.center),i.radius=Math.max(n.magnitude(c.getColumn(r,0,R)),n.magnitude(c.getColumn(r,1,R)),n.magnitude(c.getColumn(r,2,R)))*e.radius,i},f.transformWithoutScale=function(e,r,n){return t(n)||(n=new f),n.center=c.multiplyByPoint(r,e.center,n.center),n.radius=e.radius,n};var P=new n;f.getPlaneDistances=function(e,r,i,a){t(a)||(a=new l);var o=n.subtract(e.center,r,P),s=n.multiplyByScalar(i,n.dot(i,o),P),u=n.magnitude(s);return a.start=u-e.radius,a.stop=u+e.radius,a};for(var z=new n,L=new n,q=new n,F=new n,U=new n,B=new a,G=new Array(8),W=0;8>W;++W)G[W]=new n;var Y=new s;return f.projectTo2D=function(t,r,i){r=e(r,Y);var a=r.getEllipsoid(),o=t.center,s=t.radius,u=a.geodeticSurfaceNormal(o,z),l=n.cross(n.UNIT_Z,u,L);n.normalize(l,l);var c=n.cross(u,l,q);n.normalize(c,c),n.multiplyByScalar(u,s,u),n.multiplyByScalar(c,s,c),n.multiplyByScalar(l,s,l);var h=n.negate(c,U),m=n.negate(l,F),d=G,p=d[0];n.add(u,c,p),n.add(p,l,p),p=d[1],n.add(u,c,p),n.add(p,m,p),p=d[2],n.add(u,h,p),n.add(p,m,p),p=d[3],n.add(u,h,p),n.add(p,l,p),n.negate(u,u),p=d[4],n.add(u,c,p),n.add(p,l,p),p=d[5],n.add(u,c,p),n.add(p,m,p),p=d[6],n.add(u,h,p),n.add(p,m,p),p=d[7],n.add(u,h,p),n.add(p,l,p);for(var y=d.length,v=0;y>v;++v){var w=d[v];n.add(o,w,w);var g=a.cartesianToCartographic(w,B);r.project(g,w)}i=f.fromPoints(d,i),o=i.center;var E=o.x,S=o.y,C=o.z;return o.x=C,o.y=E,o.z=S,i},f.equals=function(e,r){return e===r||t(e)&&t(r)&&n.equals(e.center,r.center)&&e.radius===r.radius},f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.union=function(e,t){return f.union(this,e,t)},f.prototype.expand=function(e,t){return f.expand(this,e,t)},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.getPlaneDistances=function(e,t,r){return f.getPlaneDistances(this,e,t,r)},f.prototype.projectTo2D=function(e,t){return f.projectTo2D(this,e,t)},f.prototype.equals=function(e){return f.equals(this,e)},f}),define("Core/Fullscreen",["./defined"],function(e){"use strict";var t,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return n.supportsFullscreen=function(){if(e(t))return t;t=!1;var n=document.body;if("function"==typeof n.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,s=a.length;s>o;++o){var u=a[o];i=u+"RequestFullscreen","function"==typeof n[i]?(r.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof n[i]&&(r.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?r.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(r.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?r.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(r.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),r.fullscreenerror=i)}return t},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[r.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[r.exitFullscreen]()},n.isFullscreenEnabled=function(){return n.supportsFullscreen()?document[r.fullscreenEnabled]:void 0},n.getFullscreenElement=function(){return n.supportsFullscreen()?document[r.fullscreenElement]:void 0},n.isFullscreen=function(){return n.supportsFullscreen()?null!==n.getFullscreenElement():void 0},n.getFullscreenChangeEventName=function(){return n.supportsFullscreen()?r.fullscreenchange:void 0},n.getFullscreenErrorEventName=function(){return n.supportsFullscreen()?r.fullscreenerror:void 0},n}),define("Core/FeatureDetection",["./defined","./Fullscreen"],function(e,t){"use strict";function r(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function n(){if(!e(f)){var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===t?f=!1:(f=!0,h=r(t[1]))}return f}function i(){return n()&&h}function a(){if(!e(m))if(n()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))m=!1;else{var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===t?m=!1:(m=!0,d=r(t[1]))}return m}function o(){return a()&&d}function s(){if(!e(p)){var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===t?p=!1:(p=!0,y=r(t[1]),y.isNightly=!!t[2])}return p}function u(){return s()&&y}function l(){if(!e(v)){var t=/ MSIE ([\.0-9]+)/.exec(navigator.userAgent);null===t?v=!1:(v=!0,w=r(t[1]))}return v}function c(){return l()&&w}var f,h,m,d,p,y,v,w,g,E={isChrome:n,chromeVersion:i,isSafari:a,safariVersion:o,isWebkit:s,webkitVersion:u,isInternetExplorer:l,internetExplorerVersion:c};return E.supportsCrossOriginImagery=function(){return e(g)||(g=a()&&u()[0]<536?!1:"withCredentials"in new XMLHttpRequest),g},E.supportsFullscreen=function(){return t.supportsFullscreen()},E.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},E}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./Enumeration"],function(e,t,r,n,i){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:new i(5120,"BYTE",{sizeInBytes:Int8Array.BYTES_PER_ELEMENT}),UNSIGNED_BYTE:new i(5121,"UNSIGNED_BYTE",{sizeInBytes:Uint8Array.BYTES_PER_ELEMENT}),SHORT:new i(5122,"SHORT",{sizeInBytes:Int16Array.BYTES_PER_ELEMENT}),UNSIGNED_SHORT:new i(5123,"UNSIGNED_SHORT",{sizeInBytes:Uint16Array.BYTES_PER_ELEMENT}),FLOAT:new i(5126,"FLOAT",{sizeInBytes:Float32Array.BYTES_PER_ELEMENT}),DOUBLE:new i(5130,"DOUBLE",{sizeInBytes:Float64Array.BYTES_PER_ELEMENT})};return a.validate=function(e){return t(e)&&t(e.value)&&(e.value===a.BYTE.value||e.value===a.UNSIGNED_BYTE.value||e.value===a.SHORT.value||e.value===a.UNSIGNED_SHORT.value||e.value===a.FLOAT.value||e.value===a.DOUBLE.value)},a.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e.value){case a.BYTE.value:return new Int8Array(n);case a.UNSIGNED_BYTE.value:return new Uint8Array(n);case a.SHORT.value:return new Int16Array(n);case a.UNSIGNED_SHORT.value:return new Uint16Array(n);case a.FLOAT.value:return new Float32Array(n);case a.DOUBLE.value:return new Float64Array(n);default:throw new r("componentDatatype is not a valid enumeration value.")}},a.createArrayBufferView=function(n,i,o,s){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(o=e(o,0),s=e(s,(i.byteLength-o)/n.sizeInBytes),n.value){case a.BYTE.value:return new Int8Array(i,o,s);case a.UNSIGNED_BYTE.value:return new Uint8Array(i,o,s);case a.SHORT.value:return new Int16Array(i,o,s);case a.UNSIGNED_SHORT.value:return new Uint16Array(i,o,s);case a.FLOAT.value:return new Float32Array(i,o,s);case a.DOUBLE.value:return new Float64Array(i,o,s);default:throw new r("componentDatatype is not a valid enumeration value.")}},a}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,t,r){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(t){return e(t)&&(t===n.UNSIGNED_BYTE||t===n.UNSIGNED_SHORT||t===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new t("numberOfVertices is required.");return n>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./BoundingSphere"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.attributes))throw new r("options.attributes is required.");if(!t(n.primitiveType))throw new r("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(t){return t===e.POINTS||t===e.LINES||t===e.LINE_LOOP||t===e.LINE_STRIP||t===e.TRIANGLES||t===e.TRIANGLE_STRIP||t===e.TRIANGLE_FAN}};return e}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(r.path=t.authority&&""==t.path?"/"+this.path:t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.resolve=function(t,r){var n=s[t]||(s[t]=new e(t)),i=s[r]||(s[r]=new e(r));return n.resolve(i).toString()};var s={};return e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["require","./defined","./DeveloperError","../ThirdParty/Uri"],function(e,t,r,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),i=f.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(t(u))return u;var e;if(e="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!t(e))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return u=new n(e).resolve(new n(document.location.href))}function o(t){return e.toUrl("../"+t)}function s(e){return new n(e).resolve(a()).toString()}var u,l,c,f=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,h=function(r){t(l)||(l=t(e.toUrl)?o:s),t(c)||(c=document.createElement("a"));var n=l(r);return c.href=n,c.href=c.href,c.href};return h._cesiumScriptRegex=f,h}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,r){this.x=e,this.y=t,this.s=r};return e}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(r,n,i){if(!e(r))throw new t("array is required.");if(!e(n))throw new t("itemToFind is required.");if(!e(i))throw new t("comparator is required.");for(var a,o,s=0,u=r.length-1;u>=s;)if(a=~~((s+u)/2),o=i(r[a],n),0>o)s=a+1;else{if(!(o>0))return a;u=a-1}return~(u+1)};return r}),define("Core/TimeConstants",[],function(){"use strict";var e={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e}),define("Core/LeapSecond",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(r,n){if(!e(r))throw new t("date is required.");if(null===n||isNaN(n))throw new t("offset is required and must be a number.");this.julianDate=r,this.offset=n};return r.setLeapSeconds=function(e){if(!Array.isArray(e))throw new t("leapSeconds is required and must be an array.");r._leapSeconds=e,r._leapSeconds.sort(r.compareLeapSecondDate)},r.getLeapSeconds=function(){return r._leapSeconds},r.prototype.equals=function(e){return this.julianDate.equals(e.julianDate)&&this.offset===e.offset},r.compareLeapSecondDate=function(e,t){return e.julianDate.compareTo(t.julianDate)},r._leapSeconds=[],r}),define("Core/TimeStandard",[],function(){"use strict";var e={UTC:0,TAI:1};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return 0===t%4&&0!==t%100||0===t%400}return t}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},a=function(e,t,r,n,a,o){var s=n-e.length;return s>0&&(e=r||!a?i(e,n,o,r):e.slice(0,t.length)+i("",s,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,s,u){var l=e>>>0;return r=r&&l&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+i(l.toString(t),s||0,"0",!1),a(e,r,n,o,u)},s=function(e,t,r,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,i,o)},u=function(e,n,u,l,c,f,h){var m,d,p,y,v;if("%%"==e)return"%";for(var w=!1,g="",E=!1,S=!1,C=" ",x=u.length,b=0;u&&x>b;b++)switch(u.charAt(b)){case" ":g=" ";break;case"+":g="+";break;case"-":w=!0;break;case"'":C=u.charAt(b+1);break;case"0":E=!0;break;case"#":S=!0}if(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:0,0>l&&(l=-l,w=!0),!isFinite(l))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,v=n?t[n.slice(0,-1)]:t[r++],h){case"s":return s(String(v),w,l,f,E,C);case"c":return s(String.fromCharCode(+v),w,l,f,E);case"b":return o(v,2,S,w,l,f,E);case"o":return o(v,8,S,w,l,f,E);case"x":return o(v,16,S,w,l,f,E);case"X":return o(v,16,S,w,l,f,E).toUpperCase();case"u":return o(v,10,S,w,l,f,E);case"i":case"d":return m=+v||0,m=Math.round(m-m%1),d=0>m?"-":g,v=d+i(String(Math.abs(m)),f,"0",!1),a(v,d,w,l,E);case"e":case"E":case"f":case"F":case"g":case"G":return m=+v,d=0>m?"-":g,p=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],y=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],v=d+Math.abs(m)[p](f),a(v,d,w,l,E)[y]();default:return e}};return n.replace(e,u)}return e}),define("Core/JulianDate",["./DeveloperError","./binarySearch","./defined","./TimeConstants","./LeapSecond","./TimeStandard","./isLeapYear","../ThirdParty/sprintf"],function(e,t,r,n,i,a,o,s){"use strict";function u(e){y.julianDate=e;var r=i.getLeapSeconds(),n=t(r,y,i.compareLeapSecondDate);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var a=r[n].offset;if(n>0){var o=e.getSecondsDifference(r[n].julianDate);o>a&&(n--,a=r[n].offset)}e.addSeconds(a,e)}function l(e,r){y.julianDate=e;var n=i.getLeapSeconds(),a=t(n,y,i.compareLeapSecondDate);if(0>a&&(a=~a),0===a)return e.addSeconds(-n[0].offset,r);if(a>=n.length)return e.addSeconds(-n[a-1].offset,r);var o=e.getSecondsDifference(n[a].julianDate);return 0===o?e.addSeconds(-n[a].offset,r):1>=o?void 0:e.addSeconds(-n[--a].offset,r)}function c(e,t,i){var o=0|t/n.SECONDS_PER_DAY;return e+=o,t-=n.SECONDS_PER_DAY*o,0>t&&(e--,t+=n.SECONDS_PER_DAY),r(i)?(i._julianDayNumber=e,i._secondsOfDay=t,i):new A(e,t,a.TAI)}function f(e,t,r,i,a,o,s){var u=0|(t-14)/12,l=e+4800+u,c=(0|1461*l/4)+(0|367*(t-2-12*u)/12)-(0|3*((l+100)/100)/4)+r-32075;i-=12,0>i&&(i+=24);var f=o+(i*n.SECONDS_PER_HOUR+a*n.SECONDS_PER_MINUTE+s*n.SECONDS_PER_MILLISECOND);return f>=43200&&(c-=1),[c,f]}function h(e){return f(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds())}var m=function(e,t,r,n,i,a,o,s){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=s},d=[31,28,31,30,31,30,31,31,30,31,30,31],p=29,y={julianDate:void 0},v=/^(\d{4})$/,w=/^(\d{4})-(\d{2})$/,g=/^(\d{4})-?(\d{3})$/,E=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,S=/^(\d{4})-?(\d{2})-?(\d{2})$/,C=/([Z+\-])?(\d{2})?:?(\d{2})?$/,x=/^(\d{2})(\.\d+)?/.source+C.source,b=/^(\d{2}):?(\d{2})(\.\d+)?/.source+C.source,T=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+C.source,O="Valid ISO 8601 date string required.",A=function(t,i,o){this._julianDayNumber=void 0,this._secondsOfDay=void 0;var s,l;if(r(t)||r(i)||r(o)){if(r(o)){if(o!==a.UTC&&o!==a.TAI)throw new e("timeStandard is not a known TimeStandard.")}else o=a.UTC;if(null===t||isNaN(t))throw new e("julianDayNumber is required.");if(null===i||isNaN(i))throw new e("julianSecondsOfDay is required.");s=0|t,l=i+(t-s)*n.SECONDS_PER_DAY}else{var f=new Date,m=h(f);s=m[0],l=m[1],o=a.UTC}c(s,l,this),o===a.UTC&&u(this)};A.clone=function(e,t){return r(e)?r(t)?(t._julianDayNumber=e._julianDayNumber,t._secondsOfDay=e._secondsOfDay,t):new A(e._julianDayNumber,e._secondsOfDay,a.TAI):void 0},A.fromDate=function(t,r){if(!(t instanceof Date)||isNaN(t.getTime()))throw new e("date must be a valid JavaScript Date.");var n=h(t);return new A(n[0],n[1],r)},A.fromIso8601=function(t){if("string"!=typeof t)throw new e(O);t=t.replace(",",".");var n,i,s,u=t.split("T"),l=1,c=1,h=0,m=0,y=0,C=0,M=u[0],D=u[1];if(!r(M))throw new e(O);var _;if(u=M.match(S),null!==u){if(_=M.split("-").length-1,_>0&&2!==_)throw new e(O);n=+u[1],l=+u[2],c=+u[3]}else if(u=M.match(w),null!==u)n=+u[1],l=+u[2];else if(u=M.match(v),null!==u)n=+u[1];else{var N;if(u=M.match(g),null!==u){if(n=+u[1],N=+u[2],s=o(n),1>N||s&&N>366||!s&&N>365)throw new e(O)}else{if(u=M.match(E),null===u)throw new e(O);n=+u[1];var I=+u[2],R=+u[3]||0;if(_=M.split("-").length-1,_>0&&(!r(u[3])&&1!==_||r(u[3])&&2!==_))throw new e(O);var P=new Date(Date.UTC(n,0,4));N=7*I+R-P.getUTCDay()-3}i=new Date(Date.UTC(n,0,1)),i.setUTCDate(N),l=i.getUTCMonth()+1,c=i.getUTCDate()}if(s=o(n),1>l||l>12||1>c||(2!==l||!s)&&c>d[l-1]||s&&2===l&&c>p)throw new e(O);var z;if(r(D)){if(u=D.match(T),null!==u){if(_=D.split(":").length-1,_>0&&2!==_&&3!==_)throw new e(O);h=+u[1],m=+u[2],y=+u[3],C=1e3*+(u[4]||0),z=5
}else if(u=D.match(b),null!==u){if(_=D.split(":").length-1,_>0&&1!==_)throw new e(O);h=+u[1],m=+u[2],y=60*+(u[3]||0),z=4}else{if(u=D.match(x),null===u)throw new e(O);h=+u[1],m=60*+(u[2]||0),z=3}if(m>=60||y>=61||h>24||24===h&&(m>0||y>0||C>0))throw new e(O);var L=u[z],q=+u[z+1],F=+(u[z+2]||0);switch(L){case"+":h-=q,m-=F;break;case"-":h+=q,m+=F;break;case"Z":break;default:m+=new Date(Date.UTC(n,l-1,c,h,m)).getTimezoneOffset()}}else m+=new Date(Date.UTC(n,l-1,c)).getTimezoneOffset();var U=60===y;for(U&&y--;m>=60;)m-=60,h++;for(;h>=24;)h-=24,c++;for(i=s&&2===l?p:d[l-1];c>i;)c-=i,l++,l>12&&(l-=12,n++),i=s&&2===l?p:d[l-1];for(;0>m;)m+=60,h--;for(;0>h;)h+=24,c--;for(;1>c;)l--,1>l&&(l+=12,n--),i=s&&2===l?p:d[l-1],c+=i;var B=f(n,l,c,h,m,y,C),G=new A(B[0],B[1],a.UTC);return U&&G.addSeconds(1,G),G},A.fromTotalDays=function(t,r){if(null===t||isNaN(t))throw new e("totalDays is required.");return new A(t,0,r)},A.compare=function(e,t){var r=e._julianDayNumber-t._julianDayNumber;return 0!==r?r:e._secondsOfDay-t._secondsOfDay},A.equals=function(e,t){return e===t||r(e)&&r(t)&&e._julianDayNumber===t._julianDayNumber&&e._secondsOfDay===t._secondsOfDay},A.equalsEpsilon=function(t,r,n){if(null===n||isNaN(n))throw new e("epsilon is required and must be a number.");return Math.abs(t.getSecondsDifference(r))<=n},A.prototype.clone=function(e){return A.clone(this,e)},A.prototype.getTotalDays=function(){return this._julianDayNumber+this._secondsOfDay/n.SECONDS_PER_DAY},A.prototype.getJulianDayNumber=function(){return this._julianDayNumber},A.prototype.getJulianTimeFraction=function(){return this._secondsOfDay/n.SECONDS_PER_DAY},A.prototype.getSecondsOfDay=function(){return this._secondsOfDay};var M=new A(0,0,a.TAI);return A.prototype.toGregorianDate=function(){var e=!1,t=l(this,M);r(t)||(this.addSeconds(-1,M),t=l(M,M),e=!0);var i=t._julianDayNumber,a=t._secondsOfDay;a>=43200&&(i+=1);var o=0|i+68569,s=0|4*o/146097;o=0|o-(0|(146097*s+3)/4);var u=0|4e3*(o+1)/1461001;o=0|o-(0|1461*u/4)+31;var c=0|80*o/2447,f=0|o-(0|2447*c/80);o=0|c/11;var h=0|c+2-12*o,d=0|100*(s-49)+u+o,p=0|a/n.SECONDS_PER_HOUR,y=a-p*n.SECONDS_PER_HOUR,v=0|y/n.SECONDS_PER_MINUTE;y-=v*n.SECONDS_PER_MINUTE;var w=0|y,g=(y-w)/n.SECONDS_PER_MILLISECOND;return p+=12,p>23&&(p-=24),e&&(w+=1),new m(d,h,f,p,v,w,g,e)},A.prototype.toDate=function(){var e=this.toGregorianDate(),t=e.second;return e.isLeapSecond&&(t-=1),new Date(Date.UTC(e.year,e.month-1,e.day,e.hour,e.minute,t,e.millisecond))},A.prototype.toIso8601=function(e){var t,n=this.toGregorianDate();return r(e)||0===n.millisecond?r(e)&&0!==e?(t=(.01*n.millisecond).toFixed(e).replace(".","").slice(0,e),s("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",n.year,n.month,n.day,n.hour,n.minute,n.second,t)):s("%04d-%02d-%02dT%02d:%02d:%02dZ",n.year,n.month,n.day,n.hour,n.minute,n.second):(t=(.01*n.millisecond).toString().replace(".",""),s("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",n.year,n.month,n.day,n.hour,n.minute,n.second,t))},A.prototype.getSecondsDifference=function(e){var t=this,r=e,i=(r._julianDayNumber-t._julianDayNumber)*n.SECONDS_PER_DAY;return i+(r._secondsOfDay-t._secondsOfDay)},A.prototype.getMinutesDifference=function(e){return this.getSecondsDifference(e)/n.SECONDS_PER_MINUTE},A.prototype.getDaysDifference=function(e){var t=this,r=e,i=r._julianDayNumber-t._julianDayNumber,a=(r._secondsOfDay-t._secondsOfDay)/n.SECONDS_PER_DAY;return i+a},A.prototype.getTaiMinusUtc=function(){y.julianDate=this;var e=i.getLeapSeconds(),r=t(e,y,i.compareLeapSecondDate);return 0>r&&(r=~r,--r,0>r&&(r=0)),e[r].offset},A.prototype.addSeconds=function(t,r){if(null===t||isNaN(t))throw new e("seconds is required and must be a number.");return c(this._julianDayNumber,this._secondsOfDay+t,r)},A.prototype.addMinutes=function(t){if(null===t||isNaN(t))throw new e("duration is required and must be a number.");var r=this._secondsOfDay+t*n.SECONDS_PER_MINUTE;return new A(this._julianDayNumber,r,a.TAI)},A.prototype.addHours=function(t){if(null===t||isNaN(t))throw new e("duration is required and must be a number.");var r=this._secondsOfDay+t*n.SECONDS_PER_HOUR;return new A(this._julianDayNumber,r,a.TAI)},A.prototype.addDays=function(t){if(null===t||isNaN(t))throw new e("duration is required and must be a number.");var r=this._julianDayNumber+t;return new A(r,this._secondsOfDay,a.TAI)},A.prototype.lessThan=function(e){return A.compare(this,e)<0},A.prototype.lessThanOrEquals=function(e){return A.compare(this,e)<=0},A.prototype.greaterThan=function(e){return A.compare(this,e)>0},A.prototype.greaterThanOrEquals=function(e){return A.compare(this,e)>=0},A.prototype.compareTo=function(e){return A.compare(this,e)},A.prototype.equals=function(e){return A.equals(this,e)},A.prototype.equalsEpsilon=function(e,t){return A.equalsEpsilon(this,e,t)},0===i._leapSeconds.length&&(i._leapSeconds=[new i(new A(2441317,43210,a.TAI),10),new i(new A(2441499,43211,a.TAI),11),new i(new A(2441683,43212,a.TAI),12),new i(new A(2442048,43213,a.TAI),13),new i(new A(2442413,43214,a.TAI),14),new i(new A(2442778,43215,a.TAI),15),new i(new A(2443144,43216,a.TAI),16),new i(new A(2443509,43217,a.TAI),17),new i(new A(2443874,43218,a.TAI),18),new i(new A(2444239,43219,a.TAI),19),new i(new A(2444786,43220,a.TAI),20),new i(new A(2445151,43221,a.TAI),21),new i(new A(2445516,43222,a.TAI),22),new i(new A(2446247,43223,a.TAI),23),new i(new A(2447161,43224,a.TAI),24),new i(new A(2447892,43225,a.TAI),25),new i(new A(2448257,43226,a.TAI),26),new i(new A(2448804,43227,a.TAI),27),new i(new A(2449169,43228,a.TAI),28),new i(new A(2449534,43229,a.TAI),29),new i(new A(2450083,43230,a.TAI),30),new i(new A(2450630,43231,a.TAI),31),new i(new A(2451179,43232,a.TAI),32),new i(new A(2453736,43233,a.TAI),33),new i(new A(2454832,43234,a.TAI),34),new i(new A(2456109,43235,a.TAI),35)]),A}),define("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var o=r[a];n&&(o=t(o,n)),i[a]=o}return i};return t}),define("Core/RequestErrorEvent",["./defined"],function(e){"use strict";var t=function(e,t){this.statusCode=e,this.response=t};return t.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},t}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,i){return t(e).then(r,n,i)}function t(e){var t,r;return e instanceof n?t=e:s(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=i(e),t}function r(t){return e(t,a)}function n(e){this.then=e}function i(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return a(n)}});return r}function a(e){var r=new n(function(r,n){try{return n?t(n(e)):a(e)}catch(i){return a(i)}});return r}function o(){function e(e,t,r){return h(e,t,r)}function r(e){return d(e)}function i(e){return d(a(e))}function s(e){return m(e)}var u,l,c,f,h,m,d;return l=new n(e),u={then:e,resolve:r,reject:i,progress:s,promise:l,resolver:{resolve:r,reject:i,progress:s}},c=[],f=[],h=function(e,t,r){var n,i;return n=o(),i="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},c.push(function(r){r.then(e,t).then(n.resolve,n.reject,i)}),f.push(i),n.promise},m=function(e){return p(f,e),e},d=function(e){return e=t(e),h=e.then,d=t,m=v,p(c,e),f=c=S,e},u}function s(e){return e&&"function"==typeof e.then}function u(t,r,n,i,a){return y(2,arguments),e(t,function(t){function s(e){p(e)}function u(e){d(e)}var l,c,f,h,m,d,p,y,w,g;if(w=t.length>>>0,l=Math.max(0,Math.min(r,w)),f=[],c=w-l+1,h=[],m=o(),l)for(y=m.progress,p=function(e){h.push(e),--c||(d=p=v,m.reject(h))},d=function(e){f.push(e),--l||(d=p=v,m.resolve(f))},g=0;w>g;++g)g in t&&e(t[g],u,s,y);else m.resolve(f);return m.then(n,i,a)})}function l(e,t,r,n){function i(e){return t?t(e[0]):e[0]}return u(e,1,i,r,n)}function c(e,t,r,n){return y(1,arguments),h(e,w).then(t,r,n)}function f(){return h(arguments,w)}function h(t,r){return e(t,function(t){var n,i,a,s,u,l;if(a=i=t.length>>>0,n=[],l=o(),a)for(s=function(t,i){e(t,r).then(function(e){n[i]=e,--a||l.resolve(n)},l.reject)},u=0;i>u;u++)u in t?s(t[u],u):--a;else l.resolve(n);return l.promise})}function m(t,r){var n=E.call(arguments,1);return e(t,function(t){var i;return i=t.length,n[0]=function(t,n,a){return e(t,function(t){return e(n,function(e){return r(t,e,a,i)})})},g.apply(t,n)})}function d(t,r,n){var i=arguments.length>2;return e(t,function(e){return e=i?n:e,r.resolve(e),e},function(e){return r.reject(e),a(e)},r.progress)}function p(e,t){for(var r,n=0;r=e[n++];)r(t)}function y(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function v(){}function w(e){return e}var g,E,S;return e.defer=o,e.resolve=t,e.reject=r,e.join=f,e.all=c,e.map=h,e.reduce=m,e.any=l,e.some=u,e.chain=d,e.isPromise=s,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(S,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return c(t,function(t){return e.apply(S,t)})})}},E=[].slice,g=[].reduce||function(e){var t,r,n,i,a;if(a=0,t=Object(this),i=t.length>>>0,r=arguments,r.length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=i)throw new TypeError}else n=r[1];for(;i>a;++a)a in t&&(n=e(n,t[a],a,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/loadWithXhr",["./defined","./defaultValue","./DeveloperError","./RequestErrorEvent","../ThirdParty/when"],function(e,t,r,n,i){"use strict";var a=function(n){if(n=t(n,t.EMPTY_OBJECT),!e(n.url))throw new r("options.url is required.");var o=n.responseType,s=t(n.method,"GET"),u=n.data,l=n.headers;return i(n.url,function(e){var t=i.defer();return a.load(e,o,s,u,l,t),t.promise})};return a.load=function(t,r,i,a,o,s){var u=new XMLHttpRequest;if(u.open(i,t,!0),e(o))for(var l in o)o.hasOwnProperty(l)&&u.setRequestHeader(l,o[l]);e(r)&&(u.responseType=r),u.onload=function(){200===u.status?s.resolve(u.response):s.reject(new n(u.status,u.response))},u.onerror=function(){s.reject(new n)},u.send(a)},a.defaultLoad=a.load,a}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,headers:r})};return t}),define("Core/loadJson",["./clone","./defined","./loadText","./DeveloperError"],function(e,t,r,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!t(a))throw new n("url is required.");return t(o)?t(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,r(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/Iau2006XysData",["./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard","../ThirdParty/when"],function(e,t,r,n,i,a,o,s){"use strict";function u(e,t,r){var n=f;return n._julianDayNumber=t,n._secondsOfDay=r,e._sampleZeroDateTT.getDaysDifference(n)}function l(t,n){if(t._chunkDownloadsInProgress[n])return t._chunkDownloadsInProgress[n];var i=s.defer();t._chunkDownloadsInProgress[n]=i;var o,u=t._xysFileUrlTemplate;return o=r(u)?u.replace("{0}",n):e("Assets/IAU2006_XYS/IAU2006_XYS_"+n+".json"),s(a(o),function(e){t._chunkDownloadsInProgress[n]=!1;for(var r=t._samples,a=e.samples,o=3*n*t._samplesPerXysFile,s=0,u=a.length;u>s;++s)r[o+s]=a[s];i.resolve()}),i.promise}var c=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,o.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),a=this._xTable=new Array(r+1),s=Math.pow(this._stepSizeDays,r),u=0;r>=u;++u){n[u]=s,a[u]=u*this._stepSizeDays;for(var l=0;r>=l;++l)l!==u&&(n[u]*=u-l);n[u]=1/n[u]}this._work=new Array(r+1),this._coef=new Array(r+1)},f=new i(0,0,o.TAI);return c.prototype.preload=function(e,t,r,n){var i=u(this,e,t),a=u(this,r,n),o=0|i/this._stepSizeDays-this._interpolationOrder/2;0>o&&(o=0);var c=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;c>=this._totalSamples&&(c=this._totalSamples-1);for(var f=0|o/this._samplesPerXysFile,h=0|c/this._samplesPerXysFile,m=[],d=f;h>=d;++d)m.push(l(this,d));return s.all(m)},c.prototype.computeXysRadians=function(e,t,i){var a=u(this,e,t);if(0>a)return void 0;var o=0|a/this._stepSizeDays;if(o>=this._totalSamples)return void 0;var s=this._interpolationOrder,c=o-(0|s/2);0>c&&(c=0);var f=c+s;f>=this._totalSamples&&(f=this._totalSamples-1,c=f-s,0>c&&(c=0));var h=!1,m=this._samples;if(r(m[3*c])||(l(this,0|c/this._samplesPerXysFile),h=!0),r(m[3*f])||(l(this,0|f/this._samplesPerXysFile),h=!0),h)return void 0;r(i)?(i.x=0,i.y=0,i.s=0):i=new n(0,0,0);var d,p,y=a-c*this._stepSizeDays,v=this._work,w=this._denominators,g=this._coef,E=this._xTable;for(d=0;s>=d;++d)v[d]=y-E[d];for(d=0;s>=d;++d){for(g[d]=1,p=0;s>=p;++p)p!==d&&(g[d]*=v[p]);g[d]*=w[d];var S=3*(c+d);i.x+=g[d]*m[S++],i.y+=g[d]*m[S++],i.s+=g[d]*m[S]}return i},c}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n],a},i.fromArray=i.unpack,i.getMaximumComponent=function(e){return Math.max(e.x,e.y)},i.getMinimumComponent=function(e){return Math.min(e.x,e.y)},i.getMinimumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n},i.getMaximumByComponent=function(e,r,n){return t(n)||(n=new i),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.normalize=function(e,r){var n=i.magnitude(e);return t(r)?(r.x=e.x/n,r.y=e.y/n,r):new i(e.x/n,e.y/n)},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,r,n){return t(n)?(n.x=e.x*r.x,n.y=e.y*r.y,n):new i(e.x*r.x,e.y*r.y)},i.add=function(e,r,n){return t(n)?(n.x=e.x+r.x,n.y=e.y+r.y,n):new i(e.x+r.x,e.y+r.y)},i.subtract=function(e,r,n){return t(n)?(n.x=e.x-r.x,n.y=e.y-r.y,n):new i(e.x-r.x,e.y-r.y)},i.multiplyByScalar=function(e,r,n){return t(n)?(n.x=e.x*r,n.y=e.y*r,n):new i(e.x*r,e.y*r)},i.divideByScalar=function(e,r,n){return t(n)?(n.x=e.x/r,n.y=e.y/r,n):new i(e.x/r,e.y/r)},i.negate=function(e,r){return t(r)?(r.x=-e.x,r.y=-e.y,r):new i(-e.x,-e.y)},i.abs=function(e,r){return t(r)?(r.x=Math.abs(e.x),r.y=Math.abs(e.y),r):new i(Math.abs(e.x),Math.abs(e.y))};var o=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,o),n=i.multiplyByScalar(e,1-r,n),i.add(o,n,n)};var s=new i,u=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,u),Math.acos(i.dot(s,u))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("Core/EarthOrientationParameters",["./binarySearch","./defaultValue","./defined","./freezeObject","./loadJson","./EarthOrientationParametersSample","./JulianDate","./LeapSecond","./RuntimeError","./TimeConstants","./TimeStandard","../ThirdParty/when"],function(e,t,r,n,i,a,o,s,u,l,c,f){"use strict";function h(e,t){return o.compare(e.julianDate,t)}function m(t,n){if(!r(n.columnNames))return t._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!r(n.samples))return t._dataError="Error in loaded EOP data: The samples property is required.",void 0;var i=n.columnNames.indexOf("modifiedJulianDateUtc"),a=n.columnNames.indexOf("xPoleWanderRadians"),u=n.columnNames.indexOf("yPoleWanderRadians"),f=n.columnNames.indexOf("ut1MinusUtcSeconds"),m=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),d=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),p=n.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>u||0>f||0>m||0>d||0>p)return t._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var y=t._samples=n.samples,v=t._dates=[];t._dateColumn=i,t._xPoleWanderRadiansColumn=a,t._yPoleWanderRadiansColumn=u,t._ut1MinusUtcSecondsColumn=f,t._xCelestialPoleOffsetRadiansColumn=m,t._yCelestialPoleOffsetRadiansColumn=d,t._taiMinusUtcSecondsColumn=p,t._columnCount=n.columnNames.length,t._lastIndex=void 0;for(var w,g=t._addNewLeapSeconds,E=0,S=y.length;S>E;E+=t._columnCount){var C=y[E+i],x=y[E+p],b=C+l.MODIFIED_JULIAN_DATE_DIFFERENCE,T=new o(b,x,c.TAI);if(v.push(T),g){if(x!==w&&r(w)){var O=s.getLeapSeconds(),A=e(O,T,h);if(0>A){var M=new s(T,x);O.splice(~A,0,M)}}w=x}}}function d(e,t,r,n,i){var a=r*n;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function p(e,t,r){return t+e*(r-t)}function y(e,t,r,n,i,a,o){var s=e._columnCount;if(a>t.length-1)return o.xPoleWander=0,o.yPoleWander=0,o.xPoleOffset=0,o.yPoleOffset=0,o.ut1MinusUtc=0,o;var u=t[i],l=t[a];if(u.equals(l)||n.equals(u))return d(e,r,i,s,o),o;if(n.equals(l))return d(e,r,a,s,o),o;var c=u.getSecondsDifference(n)/u.getSecondsDifference(l),f=i*s,h=a*s,m=r[f+e._ut1MinusUtcSecondsColumn],y=r[h+e._ut1MinusUtcSecondsColumn],v=y-m;if(v>.5||-.5>v){var w=r[f+e._taiMinusUtcSecondsColumn],g=r[h+e._taiMinusUtcSecondsColumn];w!==g&&(l.equals(n)?m=y:y-=g-w)}return o.xPoleWander=p(c,r[f+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),o.yPoleWander=p(c,r[f+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),o.xPoleOffset=p(c,r[f+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),o.yPoleOffset=p(c,r[f+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),o.ut1MinusUtc=p(c,m,y),o}var v=function(e){if(e=t(e,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(e.addNewLeapSeconds,!0),r(e.data))m(this,e.data);else if(r(e.url)){var n=this;this._downloadPromise=f(i(e.url),function(e){m(n,e)},function(){n._dataError="An error occurred while retrieving the EOP data from the URL "+e.url+"."})}else m(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return v.NONE=n({getPromiseToLoad:function(){return f()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),v.prototype.getPromiseToLoad=function(){return f(this._downloadPromise)},v.prototype.compute=function(t,n){if(!r(this._samples)){if(r(this._dataError))throw new u(this._dataError);return void 0}if(r(n)||(n=new a(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var i=this._dates,s=this._lastIndex,l=0,c=0;if(r(s)){var f=i[s],h=i[s+1],m=f.lessThanOrEquals(t),d=!r(h),p=d||h.greaterThanOrEquals(t);if(m&&p)return l=s,!d&&h.equals(t)&&++l,c=l+1,y(this,i,this._samples,t,l,c,n),n}var v=e(i,t,o.compare,this._dateColumn);return v>=0?(v<i.length-1&&i[v+1].equals(t)&&++v,l=v,c=v):(c=~v,l=c-1,0>l&&(l=0)),this._lastIndex=l,y(this,i,this._samples,t,l,c,n),n},v}),define("Core/Transforms",["./defaultValue","./defined","./DeveloperError","./Iau2006XysData","./Iau2006XysSample","./Math","./Matrix3","./Matrix4","./Cartesian2","./Cartesian3","./Cartesian4","./TimeConstants","./Ellipsoid","./EarthOrientationParameters","./EarthOrientationParametersSample","../ThirdParty/when"],function(e,t,r,n,i,a,o,s,u,l,c,f,h,m,d,p){"use strict";var y={},v=new l,w=new l,g=new l;y.eastNorthUpToFixedFrame=function(r,n,i){if(a.equalsEpsilon(r.x,0,a.EPSILON14)&&a.equalsEpsilon(r.y,0,a.EPSILON14)){var o=a.sign(r.z);return t(i)?(i[0]=0,i[1]=1,i[2]=0,i[3]=0,i[4]=-o,i[5]=0,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=o,i[11]=0,i[12]=r.x,i[13]=r.y,i[14]=r.z,i[15]=1,i):new s(0,-o,0,r.x,1,0,0,r.y,0,0,o,r.z,0,0,0,1)}var u=v,c=w,f=g;return n=e(n,h.WGS84),n.geodeticSurfaceNormal(r,u),c.x=-r.y,c.y=r.x,c.z=0,l.normalize(c,c),l.cross(u,c,f),t(i)?(i[0]=c.x,i[1]=c.y,i[2]=c.z,i[3]=0,i[4]=f.x,i[5]=f.y,i[6]=f.z,i[7]=0,i[8]=u.x,i[9]=u.y,i[10]=u.z,i[11]=0,i[12]=r.x,i[13]=r.y,i[14]=r.z,i[15]=1,i):new s(c.x,f.x,u.x,r.x,c.y,f.y,u.y,r.y,c.z,f.z,u.z,r.z,0,0,0,1)};var E=new l,S=new l,C=new l;y.northEastDownToFixedFrame=function(r,n,i){if(a.equalsEpsilon(r.x,0,a.EPSILON14)&&a.equalsEpsilon(r.y,0,a.EPSILON14)){var o=a.sign(r.z);return t(i)?(i[0]=-o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=1,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=-o,i[11]=0,i[12]=r.x,i[13]=r.y,i[14]=r.z,i[15]=1,i):new s(-o,0,0,r.x,0,1,0,r.y,0,0,-o,r.z,0,0,0,1)}var u=E,c=S,f=C;return n=e(n,h.WGS84),n.geodeticSurfaceNormal(r,u),c.x=-r.y,c.y=r.x,c.z=0,l.normalize(c,c),l.cross(u,c,f),t(i)?(i[0]=f.x,i[1]=f.y,i[2]=f.z,i[3]=0,i[4]=c.x,i[5]=c.y,i[6]=c.z,i[7]=0,i[8]=-u.x,i[9]=-u.y,i[10]=-u.z,i[11]=0,i[12]=r.x,i[13]=r.y,i[14]=r.z,i[15]=1,i):new s(f.x,c.x,-u.x,r.x,f.y,c.y,-u.y,r.y,f.z,c.z,-u.z,r.z,0,0,0,1)};var x=24110.54841,b=8640184.812866,T=.093104,O=-62e-7,A=1.1772758384668e-19,M=72921158553e-15,D=a.TWO_PI/86400;y.computeTemeToPseudoFixedMatrix=function(e,r){var n,i=e.addSeconds(-e.getTaiMinusUtc()),s=i.getJulianDayNumber(),u=i.getSecondsOfDay(),l=s-2451545;n=u>=43200?(l+.5)/f.DAYS_PER_JULIAN_CENTURY:(l-.5)/f.DAYS_PER_JULIAN_CENTURY;var c=x+n*(b+n*(T+n*O)),h=c*D%a.TWO_PI,m=M+A*(s-2451545.5),d=(u+.5*f.SECONDS_PER_DAY)%f.SECONDS_PER_DAY,p=h+m*d,y=Math.cos(p),v=Math.sin(p);return t(r)?(r[0]=y,r[1]=-v,r[2]=0,r[3]=v,r[4]=y,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new o(y,v,0,-v,y,0,0,0,1)},y.iau2006XysData=new n,y.earthOrientationParameters=m.NONE;var _=32.184,N=2451545;y.preloadIcrfFixed=function(e){var t=e.start.getJulianDayNumber(),r=e.start.getSecondsOfDay()+_,n=e.stop.getJulianDayNumber(),i=e.stop.getSecondsOfDay()+_,a=y.iau2006XysData.preload(t,r,n,i),o=y.earthOrientationParameters.getPromiseToLoad();return p.all([a,o])},y.computeIcrfToFixedMatrix=function(e,r){var n=y.computeFixedToIcrfMatrix(e,r);return t(n)?o.transpose(n,r):void 0};var I=new i(0,0,0),R=new d(0,0,0,0,0,0),P=new o,z=new o;y.computeFixedToIcrfMatrix=function(e,r){var n=y.earthOrientationParameters.compute(e,R);if(!t(n))return void 0;var i=e.getJulianDayNumber(),s=e.getSecondsOfDay()+_,u=y.iau2006XysData.computeXysRadians(i,s,I);if(!t(u))return void 0;var l=u.x+n.xPoleOffset,c=u.y+n.yPoleOffset,h=1/(1+Math.sqrt(1-l*l-c*c)),m=P;m[0]=1-h*l*l,m[3]=-h*l*c,m[6]=l,m[1]=-h*l*c,m[4]=1-h*c*c,m[7]=c,m[2]=-l,m[5]=-c,m[8]=1-h*(l*l+c*c);var d=o.fromRotationZ(-u.s,z),p=o.multiply(m,d,P),v=e.getJulianDayNumber(),w=e.getSecondsOfDay()-e.getTaiMinusUtc()+n.ut1MinusUtc,g=v-2451545,E=w/f.SECONDS_PER_DAY,S=.779057273264+E+.00273781191135448*(g+E);S=S%1*a.TWO_PI;var C=o.fromRotationZ(S,z),x=o.multiply(p,C,P),b=Math.cos(n.xPoleWander),T=Math.cos(n.yPoleWander),O=Math.sin(n.xPoleWander),A=Math.sin(n.yPoleWander),M=i-N+s/f.SECONDS_PER_DAY;M/=36525;var D=-47e-6*M*a.RADIANS_PER_DEGREE/3600,L=Math.cos(D),q=Math.sin(D),F=z;return F[0]=b*L,F[1]=b*q,F[2]=O,F[3]=-T*q+A*O*L,F[4]=T*L+A*O*q,F[5]=-A*b,F[6]=-A*q-T*O*L,F[7]=A*L-T*O*q,F[8]=T*b,o.multiply(x,F,r)};var L=new c;return y.pointToWindowCoordinates=function(e,t,r,n){var i=L;return s.multiplyByVector(e,c.fromElements(r.x,r.y,r.z,1,i),i),c.multiplyByScalar(i,1/i.w,i),s.multiplyByVector(t,i,i),u.fromCartesian4(i,n)},y}),define("Core/AxisAlignedBoundingBox",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Intersect"],function(e,t,r,n,i){"use strict";var a=function(r,i,a){this.minimum=n.clone(e(r,n.ZERO)),this.maximum=n.clone(e(i,n.ZERO)),t(a)?a=n.clone(a):(a=n.add(this.minimum,this.maximum),n.multiplyByScalar(a,.5,a)),this.center=a};a.fromPoints=function(e,r){if(t(r)||(r=new a),!t(e)||0===e.length)return r.minimum=n.clone(n.ZERO,r.minimum),r.maximum=n.clone(n.ZERO,r.maximum),r.center=n.clone(n.ZERO,r.center),r;for(var i=e[0].x,o=e[0].y,s=e[0].z,u=e[0].x,l=e[0].y,c=e[0].z,f=e.length,h=1;f>h;h++){var m=e[h],d=m.x,p=m.y,y=m.z;i=Math.min(d,i),u=Math.max(d,u),o=Math.min(p,o),l=Math.max(p,l),s=Math.min(y,s),c=Math.max(y,c)}var v=r.minimum;v.x=i,v.y=o,v.z=s;var w=r.maximum;w.x=u,w.y=l,w.z=c;var g=n.add(v,w,r.center);return n.multiplyByScalar(g,.5,g),r},a.clone=function(e,r){return t(e)?t(r)?(r.minimum=n.clone(e.minimum,r.minimum),r.maximum=n.clone(e.maximum,r.maximum),r.center=n.clone(e.center,r.center),r):new a(e.minimum,e.maximum):void 0},a.equals=function(e,r){return e===r||t(e)&&t(r)&&n.equals(e.center,r.center)&&n.equals(e.minimum,r.minimum)&&n.equals(e.maximum,r.maximum)};var o=new n;return a.intersect=function(e,a){if(!t(e))throw new r("box is required.");if(!t(a))throw new r("plane is required.");o=n.subtract(e.maximum,e.minimum,o);var s=n.multiplyByScalar(o,.5,o),u=s.x*Math.abs(a.x)+s.y*Math.abs(a.y)+s.z*Math.abs(a.z),l=n.dot(e.center,a)+a.w;return l-u>0?i.INSIDE:0>l+u?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersect=function(e){return a.intersect(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.discriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.realRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var s=Math.abs(a),u=Math.abs(n);if(u>s&&s/u<t.EPSILON14)return[0,0];if(s>u&&u/s<t.EPSILON14)return[];if(o=-a/n,0>o)return[];var l=Math.sqrt(o);return[-l,l]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var c=i*i,f=4*n*a,h=r(c,-f,t.EPSILON14);if(0>h)return[];var m=-.5*r(i,t.sign(i)*Math.sqrt(h),t.EPSILON14);return i>0?[m/n,a/m]:[a/m,m/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,a,o=e,s=t/3,u=r/3,l=n,c=o*u,f=s*l,h=s*s,m=u*u,d=o*u-h,p=o*l-s*u,y=s*l-m,v=4*d*y-p*p;if(0>v){var w,g,E;h*f>=c*m?(w=o,g=d,E=-2*s*d+o*p):(w=l,g=y,E=-l*p+2*u*y);var S=0>E?-1:1,C=-S*Math.abs(w)*Math.sqrt(-v);a=-E+C;var x=a/2,b=0>x?-Math.pow(-x,1/3):Math.pow(x,1/3),T=a===C?-b:-g/b;return i=0>=g?b+T:-E/(b*b+T*T+g),h*f>=c*m?[(i-s)/o]:[-l/(i+u)]}var O=d,A=-2*s*d+o*p,M=y,D=-l*p+2*u*y,_=Math.sqrt(v),N=Math.sqrt(3)/2,I=Math.abs(Math.atan2(o*_,-A)/3);i=2*Math.sqrt(-O);var R=Math.cos(I);a=i*R;var P=i*(-R/2-N*Math.sin(I)),z=a+P>2*s?a-s:P-s,L=o,q=z/L;I=Math.abs(Math.atan2(l*_,-D)/3),i=2*Math.sqrt(-M),R=Math.cos(I),a=i*R,P=i*(-R/2-N*Math.sin(I));var F=-l,U=2*u>a+P?a+u:P+u,B=F/U,G=L*U,W=-z*U-L*F,Y=z*F,H=(u*W-s*Y)/(-s*W+u*G);return H>=q?B>=q?B>=H?[q,H,B]:[q,B,H]:[B,q,H]:B>=q?[H,q,B]:B>=H?[H,B,q]:[B,H,q]}var n={};return n.discriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=t*t,o=r*r,s=n*n,u=i*i,l=18*t*r*n*i+o*s-27*a*u-4*(t*s*n+o*r*i);return l},n.realRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var s,u;if(0===n)return t.realRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];u=-o/n;var l=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[l,l,l]}return 0===o?(s=t.realRoots(n,0,a),0===s.Length?[0]:[s[0],0,s[1]]):r(n,0,a,o)}return 0===a?0===o?(u=-i/n,0>u?[u,0,0]:[0,0,u]):r(n,i,0,o):0===o?(s=t.realRoots(n,i,a),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):r(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./DeveloperError","./Math","./CubicRealPolynomial","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(e,i,a,o){var s=e*e,u=i-3*s/8,l=a-i*e/2+s*e/8,c=o-a*e/4+i*s/16-3*s*s/256,f=r.realRoots(1,2*u,u*u-4*c,-l*l);if(f.length>0){var h=-e/4,m=f[f.length-1];if(Math.abs(m)<t.EPSILON14){var d=n.realRoots(1,u,c);if(2===d.length){var p,y=d[0],v=d[1];if(y>=0&&v>=0){var w=Math.sqrt(y),g=Math.sqrt(v);return[h-g,h-w,h+w,h+g]}if(y>=0&&0>v)return p=Math.sqrt(y),[h-p,h+p];if(0>y&&v>=0)return p=Math.sqrt(v),[h-p,h+p]}return[]}if(m>0){var E=Math.sqrt(m),S=(u+m-l/E)/2,C=(u+m+l/E)/2,x=n.realRoots(1,E,S),b=n.realRoots(1,-E,C);return 0!==x.length?(x[0]+=h,x[1]+=h,0!==b.length?(b[0]+=h,b[1]+=h,x[1]<=b[0]?[x[0],x[1],b[0],b[1]]:b[1]<=x[0]?[b[0],b[1],x[0],x[1]]:x[0]>=b[0]&&x[1]<=b[1]?[b[0],x[0],x[1],b[1]]:b[0]>=x[0]&&b[1]<=x[1]?[x[0],b[0],b[1],x[1]]:x[0]>b[0]&&x[0]<b[1]?[b[0],x[0],b[1],x[1]]:[x[0],b[0],x[1],b[1]]):x):0!==b.length?(b[0]+=h,b[1]+=h,b):[]}}return[]}function a(e,i,a,o){var s=a*a,u=i*i,l=e*e,c=-2*i,f=a*e+u-4*o,h=l*o-a*i*e+s,m=r.realRoots(1,c,f,h);if(m.length>0){var d,p,y=m[0],v=i-y,w=v*v,g=e/2,E=v/2,S=w-4*o,C=w+4*Math.abs(o),x=l-4*y,b=l+4*Math.abs(y);if(0>y||x*C>S*b){var T=Math.sqrt(x);d=T/2,p=0===T?0:(e*E-a)/T}else{var O=Math.sqrt(S);d=0===O?0:(e*E-a)/O,p=O/2}var A,M;0===g&&0===d?(A=0,M=0):t.sign(g)===t.sign(d)?(A=g+d,M=y/A):(M=g-d,A=y/M);var D,_;0===E&&0===p?(D=0,_=0):t.sign(E)===t.sign(p)?(D=E+p,_=o/D):(_=E-p,D=o/_);var N=n.realRoots(1,A,D),I=n.realRoots(1,M,_);if(0!==N.length)return 0!==I.length?N[1]<=I[0]?[N[0],N[1],I[0],I[1]]:I[1]<=N[0]?[I[0],I[1],N[0],N[1]]:N[0]>=I[0]&&N[1]<=I[1]?[I[0],N[0],N[1],I[1]]:I[0]>=N[0]&&I[1]<=N[1]?[N[0],I[0],I[1],N[1]]:N[0]>I[0]&&N[0]<I[1]?[I[0],N[0],I[1],N[1]]:[N[0],I[0],N[1],I[1]]:N;if(0!==I.length)return I}return[]}var o={};return o.discriminant=function(t,r,n,i,a){if("number"!=typeof t)throw new e("a is a required number.");
if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");if("number"!=typeof a)throw new e("e is a required number.");var o=t*t,s=o*t,u=r*r,l=u*r,c=n*n,f=c*n,h=i*i,m=h*i,d=a*a,p=d*a,y=u*c*h-4*l*m-4*t*f*h+18*t*r*n*m-27*o*h*h+256*s*p+a*(18*l*n*i-4*u*f+16*t*c*c-80*t*r*c*i-6*t*u*h+144*o*n*h)+d*(144*t*u*n-27*u*u-128*o*c-192*o*r*i);return y},o.realRoots=function(n,o,s,u,l){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof o)throw new e("b is a required number.");if("number"!=typeof s)throw new e("c is a required number.");if("number"!=typeof u)throw new e("d is a required number.");if("number"!=typeof l)throw new e("e is a required number.");if(Math.abs(n)<t.EPSILON15)return r.realRoots(o,s,u,l);var c=o/n,f=s/n,h=u/n,m=l/n,d=0>c?1:0;switch(d+=0>f?d+1:d,d+=0>h?d+1:d,d+=0>m?d+1:d){case 0:return i(c,f,h,m);case 1:return a(c,f,h,m);case 2:return a(c,f,h,m);case 3:return i(c,f,h,m);case 4:return i(c,f,h,m);case 5:return a(c,f,h,m);case 6:return i(c,f,h,m);case 7:return i(c,f,h,m);case 8:return a(c,f,h,m);case 9:return i(c,f,h,m);case 10:return i(c,f,h,m);case 11:return a(c,f,h,m);case 12:return i(c,f,h,m);case 13:return i(c,f,h,m);case 14:return i(c,f,h,m);case 15:return i(c,f,h,m);default:return void 0}},o}),define("Core/IntersectionTests",["./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,t,r,n,i,a,o,s){"use strict";function u(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}function l(e,t,i,l,c){var f,h=l*l,m=c*c,d=(e[a.COLUMN1ROW1]-e[a.COLUMN2ROW2])*m,p=c*(l*u(e[a.COLUMN1ROW0],e[a.COLUMN0ROW1],r.EPSILON15)+t.y),y=e[a.COLUMN0ROW0]*h+e[a.COLUMN2ROW2]*m+l*t.x+i,v=m*u(e[a.COLUMN2ROW1],e[a.COLUMN1ROW2],r.EPSILON15),w=c*(l*u(e[a.COLUMN2ROW0],e[a.COLUMN0ROW2])+t.z),g=[];if(0===w&&0===v){if(f=o.realRoots(d,p,y),0===f.length)return g;var E=f[0],S=Math.sqrt(Math.max(1-E*E,0));if(g.push(new n(l,c*E,c*-S)),g.push(new n(l,c*E,c*S)),2===f.length){var C=f[1],x=Math.sqrt(Math.max(1-C*C,0));g.push(new n(l,c*C,c*-x)),g.push(new n(l,c*C,c*x))}return g}var b=w*w,T=v*v,O=d*d,A=w*v,M=O+T,D=2*(p*d+A),_=2*y*d+p*p-T+b,N=2*(y*p-A),I=y*y-b;if(0===M&&0===D&&0===_&&0===N)return g;f=s.realRoots(M,D,_,N,I);var R=f.length;if(0===R)return g;for(var P=0;R>P;++P){var z,L=f[P],q=L*L,F=Math.max(1-q,0),U=Math.sqrt(F);z=r.sign(d)===r.sign(y)?u(d*q+y,p*L,r.EPSILON12):r.sign(y)===r.sign(p*L)?u(d*q,p*L+y,r.EPSILON12):u(d*q+p*L,y,r.EPSILON12);var B=u(v*L,w,r.EPSILON15),G=z*B;0>G?g.push(new n(l,c*L,c*U)):G>0?g.push(new n(l,c*L,c*-U)):0!==U?(g.push(new n(l,c*L,c*-U)),g.push(new n(l,c*L,c*U)),++P):g.push(new n(l,c*L,c*U))}return g}var c={};c.rayPlane=function(i,a,o){if(!e(i))throw new t("ray is required.");if(!e(a))throw new t("plane is required.");var s=i.origin,u=i.direction,l=a.normal,c=n.dot(l,u);if(Math.abs(c)<r.EPSILON15)return void 0;var f=(-a.distance-n.dot(l,s))/c;return 0>f?void 0:(o=n.multiplyByScalar(u,f,o),n.add(s,o,o))};var f=new n,h=new n;c.rayEllipsoid=function(r,i){if(!e(r))throw new t("ray is required.");if(!e(i))throw new t("ellipsoid is required.");var a,o,s,u,l,c=i.getOneOverRadii(),m=n.multiplyComponents(c,r.origin,f),d=n.multiplyComponents(c,r.direction,h),p=n.magnitudeSquared(m),y=n.dot(m,d);if(p>1){if(y>=0)return void 0;var v=y*y;if(a=p-1,o=n.magnitudeSquared(d),s=o*a,s>v)return void 0;if(v>s){u=y*y-s,l=-y+Math.sqrt(u);var w=l/o,g=a/l;return g>w?{start:w,stop:g}:{start:g,stop:w}}var E=Math.sqrt(a/o);return{start:E,stop:E}}return 1>p?(a=p-1,o=n.magnitudeSquared(d),s=o*a,u=y*y-s,l=-y+Math.sqrt(u),{start:0,stop:l/o}):0>y?(o=n.magnitudeSquared(d),{start:0,stop:-y/o}):void 0},c.grazingAltitudeLocation=function(o,s){if(!e(o))throw new t("ray is required.");if(!e(s))throw new t("ellipsoid is required.");var u=o.origin,c=o.direction,f=s.geodeticSurfaceNormal(u);if(n.dot(c,f)>=0)return u;var h,m,d=e(this.rayEllipsoid(o,s)),p=s.transformPositionToScaledSpace(c),y=n.normalize(p),v=n.mostOrthogonalAxis(p),w=n.normalize(n.cross(v,y)),g=n.normalize(n.cross(y,w)),E=new a(y.x,w.x,g.x,y.y,w.y,g.y,y.z,w.z,g.z),S=a.transpose(E),C=a.fromScale(s.getRadii()),x=a.fromScale(s.getOneOverRadii()),b=new a(0,c.z,-c.y,-c.z,0,c.x,c.y,-c.x,0),T=a.multiply(a.multiply(S,x),b),O=a.multiply(a.multiply(T,C),E),A=a.multiplyByVector(T,u),M=l(O,n.negate(A),0,0,1),D=M.length;if(D>0){for(var _=n.ZERO,N=Number.NEGATIVE_INFINITY,I=0;D>I;++I){h=a.multiplyByVector(C,a.multiplyByVector(E,M[I]));var R=n.normalize(n.subtract(h,u)),P=n.dot(R,c);P>N&&(N=P,_=h)}var z=s.cartesianToCartographic(_);return N=r.clamp(N,0,1),m=n.magnitude(n.subtract(_,u))*Math.sqrt(1-N*N),m=d?-m:m,s.cartographicToCartesian(new i(z.longitude,z.latitude,m))}return void 0};var m=new n;return c.lineSegmentPlane=function(i,a,o,s){if(!e(i))throw new t("endPoint0 is required.");if(!e(a))throw new t("endPoint1 is required.");if(!e(o))throw new t("plane is required.");var u=n.subtract(a,i,m),l=o.normal,c=n.dot(l,u);if(Math.abs(c)<r.EPSILON6)return void 0;var f=n.dot(l,i),h=-(o.distance+f)/c;return 0>h||h>1?void 0:(e(s)||(s=new n),n.multiplyByScalar(u,h,s),n.add(i,s,s),s)},c.trianglePlaneIntersection=function(r,i,a,o){if(!(e(r)&&e(i)&&e(a)&&e(o)))throw new t("p0, p1, p2, and plane are required.");var s=o.normal,u=o.distance,l=n.dot(s,r)+u<0,f=n.dot(s,i)+u<0,h=n.dot(s,a)+u<0,m=0;m+=l?1:0,m+=f?1:0,m+=h?1:0;var d,p;if((1===m||2===m)&&(d=new n,p=new n),1===m){if(l)return c.lineSegmentPlane(r,i,o,d),c.lineSegmentPlane(r,a,o,p),{positions:[r,i,a,d,p],indices:[0,3,4,1,2,4,1,4,3]};if(f)return c.lineSegmentPlane(i,a,o,d),c.lineSegmentPlane(i,r,o,p),{positions:[r,i,a,d,p],indices:[1,3,4,2,0,4,2,4,3]};if(h)return c.lineSegmentPlane(a,r,o,d),c.lineSegmentPlane(a,i,o,p),{positions:[r,i,a,d,p],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===m){if(!l)return c.lineSegmentPlane(i,r,o,d),c.lineSegmentPlane(a,r,o,p),{positions:[r,i,a,d,p],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return c.lineSegmentPlane(a,i,o,d),c.lineSegmentPlane(r,i,o,p),{positions:[r,i,a,d,p],indices:[2,0,4,2,4,3,1,3,4]};if(!h)return c.lineSegmentPlane(r,a,o,d),c.lineSegmentPlane(i,a,o,p),{positions:[r,i,a,d,p],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},c}),define("Core/Ray",["./DeveloperError","./defaultValue","./Cartesian3"],function(e,t,r){"use strict";var n=function(e,n){n=r.clone(t(n,r.ZERO)),r.equals(n,r.ZERO)||r.normalize(n,n),this.origin=r.clone(t(e,r.ZERO)),this.direction=n};return n.prototype.getPoint=function(t,n){if("number"!=typeof t)throw new e("t is a required number");return n=r.multiplyByScalar(this.direction,t,n),r.add(this.origin,n,n)},n}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n,i){if(!t(n))throw new r("normal is required.");if(!t(i))throw new r("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,a,o){if(!t(i))throw new r("point is required.");if(!t(a))throw new r("normal is required.");var s=-e.dot(a,i);return t(o)?(e.clone(a,o.normal),o.distance=s,o):new n(a,s)},n.getPointDistance=function(n,i){if(!t(n))throw new r("plane is required.");if(!t(i))throw new r("point is required.");return e.dot(n.normal,i)+n.distance},n.prototype.getPointDistance=function(e){return n.getPointDistance(this,e)},n}),define("Core/EllipsoidTangentPlane",["./defaultValue","./defined","./DeveloperError","./Transforms","./AxisAlignedBoundingBox","./IntersectionTests","./Cartesian2","./Cartesian3","./Ellipsoid","./Matrix4","./Ray","./Plane"],function(e,t,r,n,i,a,o,s,u,l,c,f){"use strict";var h=function(i,a){if(!t(i))throw new r("origin is required.");if(a=e(a,u.WGS84),i=a.scaleToGeodeticSurface(i),!t(i))throw new r("origin must not be at the center of the ellipsoid.");var o=n.eastNorthUpToFixedFrame(i,a);this._ellipsoid=a,this._origin=s.clone(i),this._xAxis=s.fromCartesian4(l.getColumn(o,0)),this._yAxis=s.fromCartesian4(l.getColumn(o,1));var c=s.fromCartesian4(l.getColumn(o,2));this._plane=f.fromPointNormal(i,c)},m=new i;h.fromPoints=function(e,n){if(!t(e))throw new r("cartesians is required.");var a=i.fromPoints(e,m);return new h(a.center,n)},h.prototype.getEllipsoid=function(){return this._ellipsoid},h.prototype.getOrigin=function(){return this._origin};var d=new c,p=new s;h.prototype.projectPointOntoPlane=function(e,n){if(!t(e))throw new r("cartesian is required.");var i=d;i.origin=e,s.normalize(e,i.direction);var u=a.rayPlane(i,this._plane,p);if(t(u)||(s.negate(i.direction,i.direction),u=a.rayPlane(i,this._plane,p)),t(u)){var l=s.subtract(u,this._origin,u),c=s.dot(this._xAxis,l),f=s.dot(this._yAxis,l);return t(n)?(n.x=c,n.y=f,n):new o(c,f)}return void 0},h.prototype.projectPointsOntoPlane=function(e,n){if(!t(e))throw new r("cartesians is required.");t(n)||(n=[]);for(var i=0,a=e.length,o=0;a>o;o++){var s=this.projectPointOntoPlane(e[o],n[i]);t(s)&&(n[i]=s,i++)}return n.length=i,n};var y=new s;return h.prototype.projectPointsOntoEllipsoid=function(e,n){if(!t(e))throw new r("cartesians is required.");var i=e.length;t(n)?n.length=i:n=new Array(i);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,l=this._yAxis,c=y,f=0;i>f;++f){var h=e[f];s.multiplyByScalar(u,h.x,c);var m=n[f]=s.add(o,c,n[f]);s.multiplyByScalar(l,h.y,c),s.add(m,c,m),a.scaleToGeocentricSurface(m,m)}return n},h}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i=new t,a=new t,o=new t,s=function(s,u,l,c,f){if(!(r(s)&&r(u)&&r(l)&&r(c)))throw new n("point, p0, p1, and p2 are required.");r(f)||(f=new t);var h,m,d,p,y,v,w,g;r(u.z)?(h=t.subtract(l,u,i),m=t.subtract(c,u,a),d=t.subtract(s,u,o),p=t.dot(h,h),y=t.dot(h,m),v=t.dot(h,d),w=t.dot(m,m),g=t.dot(m,d)):(h=e.subtract(l,u,i),m=e.subtract(c,u,a),d=e.subtract(s,u,o),p=e.dot(h,h),y=e.dot(h,m),v=e.dot(h,d),w=e.dot(m,m),g=e.dot(m,d));var E=1/(p*w-y*y);return f.y=(w*v-y*g)*E,f.z=(p*g-y*v)*E,f.x=1-f.y-f.z,f};return s}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3","./DeveloperError"],function(e,t){"use strict";var r=new t,n=function(t,n,i,a){return e(t,n,i,a,r),r.x>0&&r.y>0&&r.z>0};return n}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this.length--,r},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",["./Enumeration"],function(e){"use strict";var t={CLOCKWISE:new e(2304,"CLOCKWISE"),COUNTER_CLOCKWISE:new e(2305,"COUNTER_CLOCKWISE"),validate:function(e){return e===t.CLOCKWISE||e===t.COUNTER_CLOCKWISE}};return t}),define("Core/PolygonPipeline",["./DeveloperError","./Math","./Cartesian2","./Cartesian3","./defined","./Geometry","./GeometryAttribute","./Ellipsoid","./EllipsoidTangentPlane","./defaultValue","./pointInsideTriangle","./ComponentDatatype","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,n,i,a,o,s,u,l,c,f,h,m,d){"use strict";function p(e,t,n){var i=r.subtract(t,e),a=r.subtract(n,t);return i.x*a.y-i.y*a.x>=0}function y(e){for(var t=e[0].x,r=0,n=0;n<e.length;n++)e[n].x>t&&(t=e[n].x,r=n);return r}function v(e){for(var t=e[0][0].x,r=0,n=0;n<e.length;n++){var i=e[n][y(e[n])].x;i>t&&(t=i,r=n)}return r}function w(e){for(var t=[],r=0;r<e.length;r++){var n=e[(r-1+e.length)%e.length],i=e[r],a=e[(r+1)%e.length];p(n,i,a)||t.push(i)}return t}function g(e,t){for(var n=0;n<e.length;n++)if(r.equals(t,e[n]))return n;return-1}function E(e,t,i){i=l(i,[]);var a=Number.MAX_VALUE,o=y(t),s=new r(t[o].x,e.y);i.push(o),i.push((o+1)%t.length);for(var u=t[0].x,c=u,f=1;f<t.length;++f)t[f].x<u?u=t[f].x:t[f].x>c&&(c=t[f].x);c+=c-u;var h=new n(c,e.y,0);for(f=0;f<t.length;f++){var m=t[f],d=t[(f+1)%t.length];if((m.x>=e.x||d.x>=e.x)&&(m.y>=e.y&&d.y<=e.y||m.y<=e.y&&d.y>=e.y)){var p=(d.y-m.y)*(h.x-e.x)-(d.x-m.x)*(h.y-e.y);if(0!==p){p=1/p;var v=((d.x-m.x)*(e.y-m.y)-(d.y-m.y)*(e.x-m.x))*p,w=((h.x-e.x)*(e.y-m.y)-(h.y-e.y)*(e.x-m.x))*p;if(v>=0&&1>=v&&w>=0&&1>=w){var g=new r(e.x+v*(h.x-e.x),e.y+v*(h.y-e.y)),E=r.subtract(g,e);p=r.magnitudeSquared(E),a>p&&(s=g,a=p,i[0]=f,i[1]=(f+1)%t.length)}}}}return s}function S(e,t){var n=v(t),i=t[n],a=y(i),o=i[a],s=[],u=E(o,e,s),l=g(e,u);if(-1!==l)return l;var f=r.magnitudeSquared(r.subtract(e[s[0]],o)),h=r.magnitudeSquared(r.subtract(e[s[1]],o)),m=h>f?e[s[0]]:e[s[1]],d=w(e),p=d.indexOf(m);-1!==p&&d.splice(p,1);for(var S=[],C=0;C<d.length;C++){var x=d[C];c(x,o,u,m)&&S.push(x)}var b=Number.MAX_VALUE;if(S.length>0){var T=new r(1,0);for(C=0;C<S.length;C++){var O=r.subtract(S[C],o),A=r.magnitude(T)*r.magnitudeSquared(O);if(0!==A){var M=Math.abs(Math.acos(r.dot(T,O)/A));b>M&&(b=M,m=S[C])}}}return e.indexOf(m)}function C(e,t,r){for(var i=Y.computeWindingOrder2D(e),a=0;a<t.length;a++){var o=t[a];n.equals(o[0],o[o.length-1])||o.push(o[0]);var s=Y.computeWindingOrder2D(o);s===i&&o.reverse()}var l=u.fromPoints(e,r),c=l.projectPointsOntoPlane(e),f=[];for(a=0;a<t.length;a++)f.push(l.projectPointsOntoPlane(t[a]));var h=S(c,f),m=v(f),d=y(f[m]),p=t[m],w=[];for(a=0;a<e.length;a++)w.push(e[a]);var g,E=[];if(0!==d)for(g=0;g<=p.length;g++){var C=(g+d)%p.length;0!==C&&E.push(p[C])}else for(g=0;g<p.length;g++)E.push(p[(g+d)%p.length]);var x=w.lastIndexOf(e[h]);E.push(e[x]);var b=w.slice(0,x+1),T=w.slice(x+1);return w=b.concat(E,T),t.splice(m,1),w}function x(e){var t="0."+Math.sin(F).toString().substr(5);F+=.2;var r=Math.floor(t*e);return r===e&&r--,r}function b(e,t,n){return T(e,t,n)&&T(t,e,n)&&!P(n[e].position,n[t].position,n)&&!r.equals(n[e].position,n[t].position)}function T(e,t,i){M(e,i);var a=i[e],o=i[t],s=A(e,i,U),u=A(e,i,B),l=r.subtract(i[s].position,a.position),c=r.subtract(i[u].position,a.position),f=r.subtract(o.position,a.position);return l=new n(l.x,l.y,0),c=new n(c.x,c.y,0),f=new n(f.x,f.y,0),D(l,f)?O(l,f):D(c,f)?O(c,f):_(l,c)?R(l,c,f)?!0:!1:N(l,c)?I(l,c,f)?!1:!0:void 0}function O(e,t){return r.magnitude(t)<r.magnitude(e)}function A(e,t,r){var n=e+r;return 0>n&&(n=t.length-1),n===t.length&&(n=0),M(n,t),n}function M(t,i){var a=t-1,o=t+1;0>a&&(a=i.length-1),o===i.length&&(o=0);var s=r.subtract(i[a].position,i[t].position),u=r.subtract(i[o].position,i[t].position);if(s=new n(s.x,s.y,0),u=new n(u.x,u.y,0),D(s,u)){var l=new e("Superfluous vertex found.");throw l.vertexIndex=t,l}}function D(e,t){return 0===n.cross(e,t).z}function _(e,t){return n.cross(e,t).z<0}function N(e,t){return n.cross(e,t).z>0}function I(e,t,r){return n.cross(e,r).z>0&&n.cross(r,t).z>0}function R(e,t,r){return n.cross(e,r).z<0&&n.cross(r,t).z<0}function P(e,t,n){for(var i=0;i<n.length;i++){var a,o=n[i].position;if(a=i<n.length-1?n[i+1].position:n[0].position,!(r.equals(e,o)||r.equals(t,a)||r.equals(e,a)||r.equals(t,o))){var s=(t.y-e.y)/(t.x-e.x),u=(a.y-o.y)/(a.x-o.x);if(!(s===u||isNaN(s)&&isNaN(u))){var l;l=isNaN(s)?e.x:isNaN(u)?o.x:(e.y-o.y-s*e.x+u*o.x)/(u-s);var c=s*l+e.y-s*e.x,f=new r(l,c);if(!(r.equals(f,e)||r.equals(f,t)||r.equals(f,o)||r.equals(f,a))){var h=L(l,e.x,t.x)&&L(c,e.y,t.y)&&L(l,o.x,a.x)&&L(c,o.y,a.y);if(h)return!0}}}}return!1}function z(e){var t=e[0].position,i=e[1].position,a=e[2].position,o=r.subtract(i,t),s=r.subtract(a,t);return o=new n(o.x,o.y,0),s=new n(s.x,s.y,0),D(o,s)}function L(e,t,r){return(e>t||e>r)&&(t>e||r>e)||t===r&&t===e}function q(t){var r=t.length;if(3===r)return z(t)?[]:[t[0].index,t[1].index,t[2].index];if(t.length<3)throw new e("Invalid polygon: must have at least three vertices.");for(var n=!1,i=0;!n;){var a=10*t.length;if(i>a)return[];i++;for(var o=x(t.length),s=o+1;Math.abs(o-s)<2||Math.abs(o-s)>t.length-2;)s=x(t.length);if(o>s){var u=o;o=s,s=u}try{if(b(o,s,t)){var l=t.splice(o,s-o+1,t[o],t[s]);return q(t).concat(q(l))}}catch(c){if(c.hasOwnProperty("vertexIndex"))return t.splice(c.vertexIndex,1),q(t);throw c}}}var F=0,U=-1,B=1,G=new n,W=new n,Y={removeDuplicates:function(t){if(!i(t))throw new e("positions is required.");var r=t.length;if(3>r)throw new e("At least three positions are required.");for(var a=[],o=r-1,s=0;r>s;o=s++){var u=t[o],l=t[s];n.equals(u,l)||a.push(l)}return a},computeArea2D:function(t){if(!i(t))throw new e("positions is required.");var r=t.length;if(3>r)throw new e("At least three positions are required.");for(var n=0,a=r-1,o=0;r>o;a=o++){var s=t[a],u=t[o];n+=s.x*u.y-u.x*s.y}return.5*n},computeWindingOrder2D:function(e){var t=Y.computeArea2D(e);return t>=0?d.COUNTER_CLOCKWISE:d.CLOCKWISE},triangulate:function(t){if(!i(t))throw new e("positions is required.");var r=t.length;if(3>r)throw new e("At least three positions are required.");for(var n=[],a=0;r>a;++a)n[a]={position:t[a],index:a};return q(n)},resetSeed:function(e){F=l(e,0)},computeSubdivision:function(r,s,u){if(!i(r))throw new e("positions is required.");if(!i(s))throw new e("indices is required.");if(s.length<3)throw new e("At least three indices are required.");if(0!==s.length%3)throw new e("The number of indices must be divisable by three.");if(u=l(u,t.RADIANS_PER_DEGREE),0>=u)throw new e("granularity must be greater than zero.");for(var c=new m,d=s.length,p=0;d>p;p+=3)c.enqueue({i0:s[p],i1:s[p+1],i2:s[p+2]});for(var y,v=r.slice(0),w=[],g={};c.length>0;){var E,S,C=c.dequeue(),x=v[C.i0],b=v[C.i1],T=v[C.i2],O=n.angleBetween(x,b),A=n.angleBetween(b,T),M=n.angleBetween(T,x),D=Math.max(O,Math.max(A,M));D>u?O===D?(E=Math.min(C.i0,C.i1).toString()+" "+Math.max(C.i0,C.i1).toString(),y=g[E],y||(S=n.add(x,b),n.multiplyByScalar(S,.5,S),v.push(S),y=v.length-1,g[E]=y),c.enqueue({i0:C.i0,i1:y,i2:C.i2}),c.enqueue({i0:y,i1:C.i1,i2:C.i2})):A===D?(E=Math.min(C.i1,C.i2).toString()+" "+Math.max(C.i1,C.i2).toString(),y=g[E],y||(S=n.add(b,T),n.multiplyByScalar(S,.5,S),v.push(S),y=v.length-1,g[E]=y),c.enqueue({i0:C.i1,i1:y,i2:C.i0}),c.enqueue({i0:y,i1:C.i2,i2:C.i0})):M===D&&(E=Math.min(C.i2,C.i0).toString()+" "+Math.max(C.i2,C.i0).toString(),y=g[E],y||(S=n.add(T,x),n.multiplyByScalar(S,.5,S),v.push(S),y=v.length-1,g[E]=y),c.enqueue({i0:C.i2,i1:y,i2:C.i1}),c.enqueue({i0:y,i1:C.i0,i2:C.i1})):(w.push(C.i0),w.push(C.i1),w.push(C.i2))}var _=v.length,N=new Array(3*_),I=0;for(y=0;_>y;y++){var R=v[y];N[I++]=R.x,N[I++]=R.y,N[I++]=R.z}return new a({attributes:{position:new o({componentDatatype:f.DOUBLE,componentsPerAttribute:3,values:N})},indices:w,primitiveType:h.TRIANGLES})},scaleToGeodeticHeight:function(e,t,r,a){r=l(r,s.WGS84);var o=G,u=W;if(t=l(t,0),a=l(a,!0),i(e)&&i(e.attributes)&&i(e.attributes.position))for(var c=e.attributes.position.values,f=c.length,h=0;f>h;h+=3)n.fromArray(c,h,u),a&&(u=r.scaleToGeodeticSurface(u,u)),o=r.geodeticSurfaceNormal(u,o),n.multiplyByScalar(o,t,o),n.add(u,o,u),c[h]=u.x,c[h+1]=u.y,c[h+2]=u.z;return e},eliminateHoles:function(t,r,a){if(!i(t))throw new e("outerRing is required.");if(0===t.length)throw new e("outerRing must not be empty.");if(!i(r))throw new e("innerRings is required.");a=l(a,s.WGS84);for(var o=[],u=0;u<r.length;u++){for(var c=[],f=0;f<r[u].length;f++)c.push(n.clone(r[u][f]));o.push(c)}for(var h=t;o.length>0;)h=C(h,o,a);return h}};return Y}),define("Core/EllipsoidGeodesic",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Math","./Cartesian3","./Cartographic"],function(e,t,r,n,i,a,o,s){"use strict";function u(e){var t=e._uSquared,r=e._ellipsoid.getMaximumRadius(),n=e._ellipsoid.getMinimumRadius(),i=(r-n)/r,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),s=(1-i)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),l=u*s,c=Math.atan2(s,a),f=u*o,h=f*f,m=1-h,d=Math.sqrt(m),p=t/4,y=p*p,v=y*p,w=y*y,g=1+p-3*y/4+5*v/4-175*w/64,E=1-p+15*y/8-35*v/8,S=1-3*p+35*y/4,C=1-5*p,x=g*c-E*Math.sin(2*c)*p/2-S*Math.sin(4*c)*y/16-C*Math.sin(6*c)*v/48-5*Math.sin(8*c)*w/512,b=e._constants;b.a=r,b.b=n,b.f=i,b.cosineHeading=a,b.sineHeading=o,b.tanU=s,b.cosineU=u,b.sineU=l,b.sigma=c,b.sineAlpha=f,b.sineSquaredAlpha=h,b.cosineSquaredAlpha=m,b.cosineAlpha=d,b.u2Over4=p,b.u4Over16=y,b.u6Over64=v,b.u8Over256=w,b.a0=g,b.a1=E,b.a2=S,b.a3=C,b.distanceRatio=x}function l(e,t){return e*t*(4+e*(4-3*t))/16}function c(e,t,r,n,i,a,o){var s=l(e,r);return(1-s)*e*t*(n+s*i*(o+s*a*(2*o*o-1)))}function f(e,t,r,n,i,o,s){var u,l,f,h,m,d=(t-r)/t,p=o-n,y=Math.atan((1-d)*Math.tan(i)),v=Math.atan((1-d)*Math.tan(s)),w=Math.cos(y),g=Math.sin(y),E=Math.cos(v),S=Math.sin(v),C=w*E,x=w*S,b=g*S,T=g*E,O=p,A=a.TWO_PI,M=Math.cos(O),D=Math.sin(O);do{M=Math.cos(O),D=Math.sin(O);var _=x-T*M;f=Math.sqrt(E*E*D*D+_*_),l=b+C*M,u=Math.atan2(f,l);var N;0===f?(N=0,h=1):(N=C*D/f,h=1-N*N),A=O,m=l-2*b/h,isNaN(m)&&(m=0),O=p+c(d,N,h,u,f,l,m)}while(Math.abs(O-A)>a.EPSILON12);var I=h*(t*t-r*r)/(r*r),R=1+I*(4096+I*(I*(320-175*I)-768))/16384,P=I*(256+I*(I*(74-47*I)-128))/1024,z=m*m,L=P*f*(m+P*(l*(2*z-1)-P*m*(4*f*f-3)*(4*z-3)/6)/4),q=r*R*(u-L),F=Math.atan2(E*D,x-T*M),U=Math.atan2(w*D,x*M-T);e._distance=q,e._startHeading=F,e._endHeading=U,e._uSquared=I}function h(e,t,r,i){var a=o.normalize(i.cartographicToCartesian(t,d),m),l=o.normalize(i.cartographicToCartesian(r,d),d);if(Math.abs(Math.abs(o.angleBetween(a,l))-Math.PI)<.0125)throw new n("geodesic position is not unique");f(e,i.getMaximumRadius(),i.getMinimumRadius(),t.longitude,t.latitude,r.longitude,r.latitude),t.height=0,r.height=0,e._start=s.clone(t,e._start),e._end=s.clone(r,e._end),u(e)}var m=new o,d=new o,p=function(e,n,a){var o=t(a,i.WGS84);this._ellipsoid=o,this._start=new s,this._end=new s,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,r(e)&&r(n)&&h(this,e,n,o)};return p.prototype.getSurfaceDistance=function(){if(!r(this._distance))throw new n("start and end must be set before calling funciton getSurfaceDistance");return this._distance},p.prototype.setEndPoints=function(e,t){if(!r(e))throw new n("start cartographic position is required");if(!r(t))throw new n("end cartgraphic position is required");h(this,e,t,this._ellipsoid)},p.prototype.getStart=function(){return this._start},p.prototype.getEnd=function(){return this._end},p.prototype.getStartHeading=function(){if(!r(this._distance))throw new n("start and end must be set before calling funciton getStartHeading");return this._startHeading},p.prototype.getEndHeading=function(){if(!r(this._distance))throw new n("start and end must be set before calling funciton getEndHeading");return this._endHeading},p.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},p.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!r(this._distance))throw new n("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,a=i.distanceRatio+e/i.b,o=Math.cos(2*a),u=Math.cos(4*a),l=Math.cos(6*a),f=Math.sin(2*a),h=Math.sin(4*a),m=Math.sin(6*a),d=Math.sin(8*a),p=a*a,y=a*p,v=i.u8Over256,w=i.u2Over4,g=i.u6Over64,E=i.u4Over16,S=2*y*v*o/3+a*(1-w+7*E/4-15*g/4+579*v/64-(E-15*g/4+187*v/16)*o-(5*g/4-115*v/16)*u-29*v*l/16)+(w/2-E+71*g/32-85*v/16)*f+(5*E/16-5*g/4+383*v/96)*h-p*((g-11*v/2)*f+5*v*h/2)+(29*g/96-29*v/16)*m+539*v*d/1536,C=Math.asin(Math.sin(S)*i.cosineAlpha),x=Math.atan(i.a/i.b*Math.tan(C));S-=i.sigma;var b=Math.cos(2*i.sigma+S),T=Math.sin(S),O=Math.cos(S),A=i.cosineU*O,M=i.sineU*T,D=Math.atan2(T*i.sineHeading,A-M*i.cosineHeading),_=D-c(i.f,i.sineAlpha,i.cosineSquaredAlpha,S,T,O,b);return r(t)?(t.longitude=this._start.longitude+_,t.latitude=x,t.height=0,t):new s(this._start.longitude+_,x,0)},p}),define("Core/PolylinePipeline",["./defaultValue","./defined","./DeveloperError","./Cartographic","./Cartesian3","./Cartesian4","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./Math","./Matrix4","./Plane"],function(e,t,r,n,i,a,o,s,u,l,c,f){"use strict";function h(e,t,r,n){var a=n.scaleToGeodeticSurface(e,O),o=n.scaleToGeodeticSurface(t,A),s=i.angleBetween(a,o),u=Math.ceil(s/r),l=new Array(3*u),c=n.cartesianToCartographic(a,x),f=n.cartesianToCartographic(o,b);M.setEndPoints(c,f);var h=M.getSurfaceDistance()/u,m=0;c.height=0;var d=n.cartographicToCartesian(c,T);l[m++]=d.x,l[m++]=d.y,l[m++]=d.z;for(var p=1;u>p;p++){var y=M.interpolateUsingSurfaceDistance(p*h,b);d=n.cartographicToCartesian(y,T),l[m++]=d.x,l[m++]=d.y,l[m++]=d.z}return l}function m(e,t,r){var n=D;return r.geodeticSurfaceNormal(e,n),i.multiplyByScalar(n,t,n),i.add(e,n,e),e}var d={},p=new c,y=new i,v=new i,w=new f(i.ZERO,0),g=new i,E=new f(i.ZERO,0),S=new i,C=new i,x=new n,b=new n,T=new i,O=new i,A=new i,M=new s,D=new i,_=new i;return d.wrapLongitude=function(r,n){var a=[],o=[];if(t(r)&&r.length>0){n=e(n,c.IDENTITY);var s=c.inverseTransformation(n,p),l=c.multiplyByPoint(s,i.ZERO,y),h=c.multiplyByPointAsVector(s,i.UNIT_Y,v),m=f.fromPointNormal(l,h,w),d=c.multiplyByPointAsVector(s,i.UNIT_X,g),x=f.fromPointNormal(l,d,E),b=1;a.push(i.clone(r[0]));for(var T=a[0],O=r.length,A=1;O>A;++A){var M=r[A];if(f.getPointDistance(x,T)<0||f.getPointDistance(x,M)<0){var D=u.lineSegmentPlane(T,M,m,S);if(t(D)){var _=i.multiplyByScalar(h,5e-9,C);f.getPointDistance(m,T)<0&&i.negate(_,_),a.push(i.add(D,_)),o.push(b+1),i.negate(_,_),a.push(i.add(D,_)),b=1}}a.push(i.clone(r[A])),b++,T=M}o.push(b)}return{positions:a,lengths:o}},d.removeDuplicates=function(e){if(!t(e))throw new r("positions is required.");var n=e.length;if(2>n)return e.slice(0);var a=[];a.push(e[0]);for(var o=1;n>o;++o){var s=e[o-1],u=e[o];i.equals(s,u)||a.push(u)}return a},d.scaleToSurface=function(n,i,a){if(!t(n))throw new r("positions is required");i=e(i,l.RADIANS_PER_DEGREE),a=e(a,o.WGS84);for(var s=n.length,u=[],c=0;s-1>c;c++){var f=n[c],m=n[c+1];u=u.concat(h(f,m,i,a))}var d=n[s-1],p=a.cartesianToCartographic(d,x);p.height=0;var y=a.cartographicToCartesian(p,T);return u.push(y.x,y.y,y.z),u},d.scaleToGeodeticHeight=function(n,a,s,u){if(!t(n))throw new r("positions must be defined.");if(!t(a))throw new r("height must be defined");s=e(s,o.WGS84);var l,c,f=n.length,h=_;if(t(u)){if(u.length!==n.length)throw new r("result.length must be equal to positions.length");c=u}else c=new Array(n.length);if(0===a){for(l=0;f>l;l+=3)h=s.scaleToGeodeticSurface(i.fromArray(n,l,h),h),c[l]=h.x,c[l+1]=h.y,c[l+2]=h.z;return c}var d;if(Array.isArray(a)){if(a.length!==f/3)throw new r("height.length must be equal to positions.length");for(l=0;f>l;l+=3)d=a[l/3],h=i.fromArray(n,l,h),h=m(h,d,s),c[l]=h.x,c[l+1]=h.y,c[l+2]=h.z}else for(d=a,l=0;f>l;l+=3)h=i.fromArray(n,l,h),h=m(h,d,s),c[l]=h.x,c[l+1]=h.y,c[l+2]=h.z;return c},d}),define("Core/WallGeometryLibrary",["./defined","./Cartographic","./Cartesian3","./DeveloperError","./EllipsoidTangentPlane","./PolygonPipeline","./PolylinePipeline","./Math","./WindingOrder"],function(e,t,r,n,i,a,o,s,u){"use strict";function l(e,t,n,i,a){var o,s=r.angleBetween(e,t),u=Math.ceil(s/a),l=new Array(u);if(n===i){for(o=0;u>o;o++)l[o]=n;return l}var c=i-n,f=c/u;for(o=1;u>o;o++){var h=n+o*f;l[o]=h}return l[0]=n,l}function c(e,t){return s.equalsEpsilon(e.latitude,t.latitude,s.EPSILON6)&&s.equalsEpsilon(e.longitude,t.longitude,s.EPSILON6)}function f(r,n,i,a){var o=e(a),s=e(i),u=[],l=[],f=o?[]:void 0,h=n.length;if(2>h)return n.slice(0);var p=n[0];u.push(p);var y=r.cartesianToCartographic(p,m);s&&(y.height=i[0]),l.push(y.height),o&&f.push(a[0]);for(var v=1;h>v;++v){var w=n[v],g=r.cartesianToCartographic(w,d);s&&(g.height=i[v]),c(y,g)?y.height<g.height&&(l[l.length-1]=g.height):(u.push(w),l.push(g.height),o&&f.push(a[v])),t.clone(g,y)}return{positions:u,topHeights:l,bottomHeights:f}}var h={},m=new t,d=new t;return h.computePositions=function(t,r,s,c,h,m){var d=f(t,r,s,c);if(r=d.positions,s=d.topHeights,c=d.bottomHeights,r.length<2)throw new n("unique positions must be greater than or equal to 2");var p=e(c);if(r.length>=3){var y=i.fromPoints(r,t),v=y.projectPointsOntoPlane(r);a.computeWindingOrder2D(v)===u.CLOCKWISE&&(r.reverse(),s.reverse(),p&&c.reverse())}var w,g=r.length,E=[],S=p?[]:void 0,C=[];for(w=0;g-1>w;w++){var x=r[w],b=r[w+1],T=s[w],O=s[w+1];E=E.concat(l(x,b,T,O,h)),m&&E.push(O),p&&(x=r[w],b=r[w+1],T=c[w],O=c[w+1],S=S.concat(l(x,b,T,O,h)),m&&S.push(O)),m&&(C=C.concat(o.scaleToSurface([x,b],h,t)))}m||(C=o.scaleToSurface(r,h,t),E.push(s[g-1]),p&&S.push(c[g-1]));var A=p?o.scaleToGeodeticHeight(C,S,t):C.slice(0),M=o.scaleToGeodeticHeight(C,E,t);return{newWallPositions:C,bottomPositions:A,topPositions:M}},h}),define("Core/WallOutlineGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./Math","./PrimitiveType","./WallGeometryLibrary"],function(e,t,r,n,i,a,o,s,u,l,c,f,h,m,d){"use strict";var p=new n,y=new n,v=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.positions,i=r.maximumHeights,a=r.minimumHeights;if(!t(n))throw new s("positions is required.");if(t(i)&&i.length!==n.length)throw new s("positions and maximumHeights must have the same length.");if(t(a)&&a.length!==n.length)throw new s("positions and minimumHeights must have the same length.");var o=e(r.granularity,h.RADIANS_PER_DEGREE),l=e(r.ellipsoid,u.WGS84);this._positions=n,this._minimumHeights=a,this._maximumHeights=i,this._granularity=o,this._ellipsoid=l,this._workerName="createWallOutlineGeometry"};return v.fromConstantHeights=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.positions;if(!t(n))throw new s("options.positions is required.");var i,a,o=r.minimumHeight,u=r.maximumHeight,l=t(o),c=t(u);if(l||c){var f=n.length;i=l?new Array(f):void 0,a=c?new Array(f):void 0;for(var h=0;f>h;++h)l&&(i[h]=o),c&&(a[h]=u)}var m={positions:n,maximumHeights:a,minimumHeights:i,ellipsoid:r.ellipsoid};return new v(m)},v.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,s=e._maximumHeights,u=e._granularity,v=e._ellipsoid,w=d.computePositions(v,t,s,i,u,!1),g=w.newWallPositions,E=w.bottomPositions,S=w.topPositions,C=g.length,x=2*C,b=new Float64Array(x),T=0;C/=3;var O;for(O=0;C>O;++O){var A=3*O,M=n.fromArray(S,A,p),D=n.fromArray(E,A,y);b[T++]=D.x,b[T++]=D.y,b[T++]=D.z,b[T++]=M.x,b[T++]=M.y,b[T++]=M.z}var _=new f({position:new c({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:b})}),N=x/3;x=2*N-4+N;var I=o.createTypedArray(N,x),R=0;for(O=0;N-2>O;O+=2){var P=O,z=O+2,L=n.fromArray(b,3*P,p),q=n.fromArray(b,3*z,y);if(!n.equalsEpsilon(L,q,h.EPSILON6)){var F=O+1,U=O+3;I[R++]=F,I[R++]=P,I[R++]=F,I[R++]=U,I[R++]=P,I[R++]=z}}return I[R++]=N-2,I[R++]=N-1,new l({attributes:_,indices:I,primitiveType:m.LINES,boundingSphere:new r.fromVertices(b)})},v}),define("Core/Color",["./defaultValue","./defined","./freezeObject","./DeveloperError","./FeatureDetection","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+6*(t-e)*(2/3-r):e}var s=function(t,r,n,i){this.red=e(t,1),this.green=e(r,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromBytes=function(t,r,n,i){return t=s.byteToFloat(e(t,255)),r=s.byteToFloat(e(r,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),new s(t,r,n,i)};var u,l,c;i.supportsTypedArrays()&&(u=new ArrayBuffer(4),l=new Uint32Array(u),c=new Uint8Array(u)),s.fromRgba=function(e){return l[0]=e,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(t,r,n,i){t=e(t,0)%1,r=e(r,0),n=e(n,0),i=e(i,1);var a=n,u=n,l=n;if(0!==r){var c;c=.5>n?n*(1+r):n+r-n*r;var f=2*n-c;a=o(f,c,t+1/3),u=o(f,c,t),l=o(f,c,t-1/3)}return new s(a,u,l,i)},s.fromRandom=function(r,i){r=e(r,e.EMPTY_OBJECT);var o=r.red;if(!t(o)){var u=e(r.minimumRed,0),l=e(r.maximumRed,1);if(u>l)throw new n("minimumRed must be less than or equal to maximumRed");o=u+a.nextRandomNumber()*(l-u)}var c=r.green;if(!t(c)){var f=e(r.minimumGreen,0),h=e(r.maximumGreen,1);if(f>h)throw new n("minimumGreen must be less than or equal to maximumGreen");
c=f+a.nextRandomNumber()*(h-f)}var m=r.blue;if(!t(m)){var d=e(r.minimumBlue,0),p=e(r.maximumBlue,1);if(d>p)throw new n("minimumBlue must be less than or equal to maximumBlue");m=d+a.nextRandomNumber()*(p-d)}var y=r.alpha;if(!t(y)){var v=e(r.minimumAlpha,0),w=e(r.maximumAlpha,1);if(v>w)throw new n("minimumAlpha must be less than or equal to maximumAlpha");y=v+a.nextRandomNumber()*(w-v)}return t(i)?(i.red=o,i.green=c,i.blue=m,i.alpha=y,i):new s(o,c,m,y)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,m=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,d=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){if(!t(r))throw new n("color is required");var i=s[r.toUpperCase()];if(t(i))return s.clone(i);var a=f.exec(r);return null!==a?new s(parseInt(a[1],16)/15,parseInt(a[2],16)/15,parseInt(a[3],16)/15):(a=h.exec(r),null!==a?new s(parseInt(a[1],16)/255,parseInt(a[2],16)/255,parseInt(a[3],16)/255):(a=m.exec(r),null!==a?new s(parseFloat(a[1])/("%"===a[1].substr(-1)?100:255),parseFloat(a[2])/("%"===a[2].substr(-1)?100:255),parseFloat(a[3])/("%"===a[3].substr(-1)?100:255),parseFloat(e(a[4],"1.0"))):(a=d.exec(r),null!==a?s.fromHsl(parseFloat(a[1])/360,parseFloat(a[2])/100,parseFloat(a[3])/100,parseFloat(e(a[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(r,i,a){if(!t(r))throw new n("value is required");if(!t(i))throw new n("array is required");a=e(a,0),i[a++]=r.red,i[a++]=r.green,i[a++]=r.blue,i[a]=r.alpha},s.unpack=function(r,i,a){if(!t(r))throw new n("array is required");return i=e(i,0),t(a)||(a=new s),a.red=r[i++],a.green=r[i++],a.blue=r[i++],a.alpha=r[i],a},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var r=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),a=s.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=n,e[2]=i,e[3]=a,e):[r,n,i,a]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),l[0]},s.ALICEBLUE=r(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=r(s.fromCssColorString("#FAEBD7")),s.AQUA=r(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=r(s.fromCssColorString("#7FFFD4")),s.AZURE=r(s.fromCssColorString("#F0FFFF")),s.BEIGE=r(s.fromCssColorString("#F5F5DC")),s.BISQUE=r(s.fromCssColorString("#FFE4C4")),s.BLACK=r(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=r(s.fromCssColorString("#FFEBCD")),s.BLUE=r(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=r(s.fromCssColorString("#8A2BE2")),s.BROWN=r(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=r(s.fromCssColorString("#DEB887")),s.CADETBLUE=r(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=r(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=r(s.fromCssColorString("#D2691E")),s.CORAL=r(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=r(s.fromCssColorString("#6495ED")),s.CORNSILK=r(s.fromCssColorString("#FFF8DC")),s.CRIMSON=r(s.fromCssColorString("#DC143C")),s.CYAN=r(s.fromCssColorString("#00FFFF")),s.DARKBLUE=r(s.fromCssColorString("#00008B")),s.DARKCYAN=r(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=r(s.fromCssColorString("#B8860B")),s.DARKGRAY=r(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=r(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=r(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=r(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=r(s.fromCssColorString("#556B2F")),s.DARKORANGE=r(s.fromCssColorString("#FF8C00")),s.DARKORCHID=r(s.fromCssColorString("#9932CC")),s.DARKRED=r(s.fromCssColorString("#8B0000")),s.DARKSALMON=r(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=r(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=r(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=r(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=r(s.fromCssColorString("#00CED1")),s.DARKVIOLET=r(s.fromCssColorString("#9400D3")),s.DEEPPINK=r(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=r(s.fromCssColorString("#00BFFF")),s.DIMGRAY=r(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=r(s.fromCssColorString("#1E90FF")),s.FIREBRICK=r(s.fromCssColorString("#B22222")),s.FLORALWHITE=r(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=r(s.fromCssColorString("#228B22")),s.FUSCHIA=r(s.fromCssColorString("#FF00FF")),s.GAINSBORO=r(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=r(s.fromCssColorString("#F8F8FF")),s.GOLD=r(s.fromCssColorString("#FFD700")),s.GOLDENROD=r(s.fromCssColorString("#DAA520")),s.GRAY=r(s.fromCssColorString("#808080")),s.GREEN=r(s.fromCssColorString("#008000")),s.GREENYELLOW=r(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=r(s.fromCssColorString("#F0FFF0")),s.HOTPINK=r(s.fromCssColorString("#FF69B4")),s.INDIANRED=r(s.fromCssColorString("#CD5C5C")),s.INDIGO=r(s.fromCssColorString("#4B0082")),s.IVORY=r(s.fromCssColorString("#FFFFF0")),s.KHAKI=r(s.fromCssColorString("#F0E68C")),s.LAVENDER=r(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=r(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=r(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=r(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=r(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=r(s.fromCssColorString("#F08080")),s.LIGHTCYAN=r(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=r(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=r(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=r(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=r(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=r(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=r(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=r(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=r(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=r(s.fromCssColorString("#FFFFE0")),s.LIME=r(s.fromCssColorString("#00FF00")),s.LIMEGREEN=r(s.fromCssColorString("#32CD32")),s.LINEN=r(s.fromCssColorString("#FAF0E6")),s.MAGENTA=r(s.fromCssColorString("#FF00FF")),s.MAROON=r(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=r(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=r(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=r(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=r(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=r(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=r(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=r(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=r(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=r(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=r(s.fromCssColorString("#191970")),s.MINTCREAM=r(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=r(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=r(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=r(s.fromCssColorString("#FFDEAD")),s.NAVY=r(s.fromCssColorString("#000080")),s.OLDLACE=r(s.fromCssColorString("#FDF5E6")),s.OLIVE=r(s.fromCssColorString("#808000")),s.OLIVEDRAB=r(s.fromCssColorString("#6B8E23")),s.ORANGE=r(s.fromCssColorString("#FFA500")),s.ORANGERED=r(s.fromCssColorString("#FF4500")),s.ORCHID=r(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=r(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=r(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=r(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=r(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=r(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=r(s.fromCssColorString("#FFDAB9")),s.PERU=r(s.fromCssColorString("#CD853F")),s.PINK=r(s.fromCssColorString("#FFC0CB")),s.PLUM=r(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=r(s.fromCssColorString("#B0E0E6")),s.PURPLE=r(s.fromCssColorString("#800080")),s.RED=r(s.fromCssColorString("#FF0000")),s.ROSYBROWN=r(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=r(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=r(s.fromCssColorString("#8B4513")),s.SALMON=r(s.fromCssColorString("#FA8072")),s.SANDYBROWN=r(s.fromCssColorString("#F4A460")),s.SEAGREEN=r(s.fromCssColorString("#2E8B57")),s.SEASHELL=r(s.fromCssColorString("#FFF5EE")),s.SIENNA=r(s.fromCssColorString("#A0522D")),s.SILVER=r(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=r(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=r(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=r(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=r(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=r(s.fromCssColorString("#00FF7F")),s.STEELBLUE=r(s.fromCssColorString("#4682B4")),s.TAN=r(s.fromCssColorString("#D2B48C")),s.TEAL=r(s.fromCssColorString("#008080")),s.THISTLE=r(s.fromCssColorString("#D8BFD8")),s.TOMATO=r(s.fromCssColorString("#FF6347")),s.TURQUOISE=r(s.fromCssColorString("#40E0D0")),s.VIOLET=r(s.fromCssColorString("#EE82EE")),s.WHEAT=r(s.fromCssColorString("#F5DEB3")),s.WHITE=r(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=r(s.fromCssColorString("#F5F5F5")),s.YELLOW=r(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=r(s.fromCssColorString("#9ACD32")),s}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!t(e))throw new r("value is required");t(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){if(!t(e))throw new r("cartesian is required");t(a)||(a=new n);var o=a.high,s=a.low;return n.encode(e.x,i),o.x=i.high,s.x=i.low,n.encode(e.y,i),o.y=i.high,s.y=i.low,n.encode(e.z,i),o.z=i.high,s.z=i.low,a};var a=new n;return n.writeElements=function(e,i,o){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("cartesianArray is required");if("number"!=typeof o||0>o)throw new r("index must be a number greater than or equal to 0.");n.fromCartesian(e,a);var s=a.high,u=a.low;i[o]=s.x,i[o+1]=s.y,i[o+2]=s.z,i[o+3]=u.x,i[o+4]=u.y,i[o+5]=u.z},n}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var s=i.length;if(3>s||0!==s%3)throw new r("indices length must be a multiple of three.");if(0>=a)throw new r("maximumIndex must be greater than zero.");if(3>o)throw new r("cacheSize must be greater than two.");if(!t(a)){a=0;for(var u=0,l=i[u];s>u;)l>a&&(a=l),++u,l=i[u]}for(var c=[],f=0;a+1>f;f++)c[f]=0;for(var h=o+1,m=0;s>m;++m)h-c[i[m]]>o&&(c[i[m]]=h,++h);return(h-o+1)/(s/3)},n.tipsify=function(n){function i(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>o;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function a(e,t,r,n,a,o,s){for(var u,l=-1,c=-1,f=0;f<r.length;){var h=r[f];n[h].numLiveTriangles&&(u=0,a-n[h].timeStamp+2*n[h].numLiveTriangles<=t&&(u=a-n[h].timeStamp),(u>c||-1===c)&&(c=u,l=h)),++f}return-1===l?i(n,o,e,s):l}n=e(n,e.EMPTY_OBJECT);var o,s=n.indices,u=n.maximumIndex,l=e(n.cacheSize,24);if(!t(s))throw new r("indices is required.");var c=s.length;if(3>c||0!==c%3)throw new r("indices length must be a multiple of three.");if(0>=u)throw new r("maximumIndex must be greater than zero.");if(3>l)throw new r("cacheSize must be greater than two.");var f=0,h=0,m=s[h],d=c;if(t(u))f=u+1;else{for(;d>h;)m>f&&(f=m),++h,m=s[h];if(-1===f)return 0;++f}for(var p=[],y=0;f>y;y++)p[y]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var v=0;d>h;)p[s[h]].vertexTriangles.push(v),++p[s[h]].numLiveTriangles,p[s[h+1]].vertexTriangles.push(v),++p[s[h+1]].numLiveTriangles,p[s[h+2]].vertexTriangles.push(v),++p[s[h+2]].numLiveTriangles,++v,h+=3;var w=0,g=l+1;o=1;var E,S,C=[],x=[],b=0,T=[],O=c/3,A=[];for(y=0;O>y;y++)A[y]=!1;for(var M,D;-1!==w;){C=[],S=p[w],D=S.vertexTriangles.length;for(var _=0;D>_;++_)if(v=S.vertexTriangles[_],!A[v]){A[v]=!0,h=v+v+v;for(var N=0;3>N;++N)M=s[h],C.push(M),x.push(M),T[b]=M,++b,E=p[M],--E.numLiveTriangles,g-E.timeStamp>l&&(E.timeStamp=g,++g),++h}w=a(s,l,C,p,g,x,f)}return T},n}),define("Core/GeometryPipeline",["./barycentricCoordinates","./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./EncodedCartesian3","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./GeographicProjection","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./Tipsify","./BoundingSphere","./Geometry","./GeometryAttribute"],function(e,t,r,n,i,a,o,s,u,l,c,f,h,m,d,p,y,v,w,g,E,S,C){"use strict";function x(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function b(e){for(var t=e.length,r=6*(t/3),n=v.createTypedArray(t,r),i=0,a=0;t>a;a+=3,i+=6)x(n,i,e[a],e[a+1],e[a+2]);return n}function T(e){var t=e.length;if(t>=3){var r=6*(t-2),n=v.createTypedArray(t,r);x(n,0,e[0],e[1],e[2]);for(var i=6,a=3;t>a;++a,i+=6)x(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function O(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=v.createTypedArray(t,r),i=e[0],a=0,o=1;t>o;++o,a+=6)x(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function A(e){var t={};for(var n in e)if(e.hasOwnProperty(n)&&r(e[n])&&r(e[n].values)){var i=e[n];t[n]=new C({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function M(e,t,n){for(var i in t)if(t.hasOwnProperty(i)&&r(t[i])&&r(t[i].values))for(var a=t[i],o=0;o<a.componentsPerAttribute;++o)e[i].values.push(a.values[n*a.componentsPerAttribute+o])}function D(e,t){if(r(t))for(var n=t.values,i=n.length,o=0;i>o;o+=3)a.unpack(n,o,Z),m.multiplyByPoint(e,Z,Z),a.pack(Z,n,o)}function _(e,t){if(r(t))for(var n=t.values,i=n.length,o=0;i>o;o+=3)a.unpack(n,o,Z),h.multiplyByVector(e,Z,Z),Z=a.normalize(Z,Z),a.pack(Z,n,o)}function N(e){var t,n=e.length,i={},a=e[0].geometry.attributes;for(t in a)if(a.hasOwnProperty(t)&&r(a[t])&&r(a[t].values)){for(var o=a[t],s=o.values.length,u=!0,l=1;n>l;++l){var c=e[l].geometry.attributes[t];if(!r(c)||o.componentDatatype.value!==c.componentDatatype.value||o.componentsPerAttribute!==c.componentsPerAttribute||o.normalize!==c.normalize){u=!1;break}s+=c.values.length}u&&(i[t]=new C({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:y.createTypedArray(o.componentDatatype,s)}))}return i}function I(e){if(r(e.indices))return e;var t=S.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least three.");if(0!==t%3)throw new n("The number of vertices must be a multiple of three.");for(var i=v.createTypedArray(t,t),a=0;t>a;++a)i[a]=a;return e.indices=i,e}function R(e){var t=S.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least three.");var r=v.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var i=3,a=3;t>a;++a)r[i++]=a-1,r[i++]=0,r[i++]=a;return e.indices=r,e.primitiveType=w.TRIANGLES,e}function P(e){var t=S.computeNumberOfVertices(e);if(3>t)throw new n("The number of vertices must be at least 3.");var r=v.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var i=6,a=3;t-1>a;a+=2)r[i++]=a,r[i++]=a-1,r[i++]=a+1,t>a+2&&(r[i++]=a,r[i++]=a+1,r[i++]=a+2);return e.indices=r,e.primitiveType=w.TRIANGLES,e}function z(e){if(r(e.indices))return e;var t=S.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");if(0!==t%2)throw new n("The number of vertices must be a multiple of 2.");for(var i=v.createTypedArray(t,t),a=0;t>a;++a)i[a]=a;return e.indices=i,e}function L(e){var t=S.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");var r=v.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var i=2,a=2;t>a;++a)r[i++]=a-1,r[i++]=a;return e.indices=r,e.primitiveType=w.LINES,e}function q(e){var t=S.computeNumberOfVertices(e);if(2>t)throw new n("The number of vertices must be at least two.");var r=v.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var i=2,a=2;t>a;++a)r[i++]=a-1,r[i++]=a;return r[i++]=t-1,r[i]=0,e.indices=r,e.primitiveType=w.LINES,e}function F(e){switch(e.primitiveType){case w.TRIANGLE_FAN:return R(e);case w.TRIANGLE_STRIP:return P(e);case w.TRIANGLES:return I(e);case w.LINE_STRIP:return L(e);case w.LINE_LOOP:return q(e);case w.LINES:return z(e)}return e}function U(e,t){Math.abs(e.y)<f.EPSILON11&&(e.y=t?-f.EPSILON11:f.EPSILON11)}function B(e,t,r,n){a.add(e,a.multiplyByScalar(a.subtract(t,e,at),e.y/(e.y-t.y),at),r),a.clone(r,n),U(r,!0),U(n,!1)}function G(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;var n=e.y<0,i=t.y<0,a=r.y<0;U(e,n),U(t,i),U(r,a);var o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var s=ct.indices;1===o?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(B(e,t,ot,ut),B(e,r,st,lt),s[0]=0,s[3]=1,s[4]=2,s[6]=1):i?(B(t,r,ot,ut),B(t,e,st,lt),s[0]=1,s[3]=2,s[4]=0,s[6]=2):a&&(B(r,e,ot,ut),B(r,t,st,lt),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===o&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?i?a||(B(r,e,ot,ut),B(r,t,st,lt),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(B(t,r,ot,ut),B(t,e,st,lt),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(B(e,t,ot,ut),B(e,r,st,lt),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=ct.positions;return u[0]=e,u[1]=t,u[2]=r,ct.length=3,(1===o||2===o)&&(u[3]=ot,u[4]=st,u[5]=ut,u[6]=lt,ct.length=7),ct}function W(t,n,o,s,u,l,c,f){if(r(u)||r(l)||r(c)||r(f)){var h,m,d,p,y,v,w,g,E,S,C,x,b,T,O,A,M,D,_=s.positions,N=_[0],I=_[1],R=_[2];r(u)&&(h=a.fromArray(u,3*t),m=a.fromArray(u,3*n),d=a.fromArray(u,3*o)),r(l)&&(p=a.fromArray(l,3*t),y=a.fromArray(l,3*n),v=a.fromArray(l,3*o)),r(c)&&(w=a.fromArray(c,3*t),g=a.fromArray(c,3*n),E=a.fromArray(c,3*o)),r(f)&&(S=i.fromArray(f,2*t),C=i.fromArray(f,2*n),x=i.fromArray(f,2*o));for(var P=3;P<_.length;++P){var z=_[P],L=e(z,N,I,R);if(r(u)){b=a.multiplyByScalar(h,L.x,b),T=a.multiplyByScalar(m,L.y,T),O=a.multiplyByScalar(d,L.z,O);var q=a.add(b,T);a.add(q,O,q),a.normalize(q,q),u.push(q.x,q.y,q.z)}if(r(l)){b=a.multiplyByScalar(p,L.x,b),T=a.multiplyByScalar(y,L.y,T),O=a.multiplyByScalar(v,L.z,O);var F=a.add(b,T);a.add(F,O,F),a.normalize(F,F),l.push(F.x,F.y,F.z)}if(r(c)){b=a.multiplyByScalar(w,L.x,b),T=a.multiplyByScalar(g,L.y,T),O=a.multiplyByScalar(E,L.z,O);var U=a.add(b,T);a.add(U,O,U),a.normalize(U,U),c.push(U.x,U.y,U.z)}if(r(f)){A=i.multiplyByScalar(S,L.x,A),M=i.multiplyByScalar(C,L.y,M),D=i.multiplyByScalar(x,L.z,D);var B=i.add(A,M);i.add(B,D,B),f.push(B.x,B.y)}}}}function Y(e){for(var t=e.attributes,n=t.position.values,i=r(t.normal)?t.normal.values:void 0,o=r(t.binormal)?t.binormal.values:void 0,s=r(t.tangent)?t.tangent.values:void 0,u=r(t.st)?t.st.values:void 0,l=e.indices,c=Array.prototype.slice.call(n,0),f=r(i)?Array.prototype.slice.call(i,0):void 0,h=r(o)?Array.prototype.slice.call(o,0):void 0,m=r(s)?Array.prototype.slice.call(s,0):void 0,d=r(u)?Array.prototype.slice.call(u,0):void 0,p=[],w=l.length,g=0;w>g;g+=3){var E=l[g],C=l[g+1],x=l[g+2],b=a.fromArray(n,3*E),T=a.fromArray(n,3*C),O=a.fromArray(n,3*x),A=G(b,T,O);if(r(A))if(c[3*E+1]=A.positions[0].y,c[3*C+1]=A.positions[1].y,c[3*x+1]=A.positions[2].y,A.length>3){for(var M=c.length/3,D=0;D<A.indices.length;++D){var _=A.indices[D];3>_?p.push(l[g+_]):p.push(_-3+M)}for(var N=3;N<A.positions.length;++N){var I=A.positions[N];c.push(I.x,I.y,I.z)}W(E,C,x,A,f,h,m,d)}else p.push(E,C,x);else p.push(E,C,x)}e.attributes.position.values=new Float64Array(c),r(f)&&(t.normal.values=y.createTypedArray(t.normal.componentDatatype,f)),r(h)&&(t.binormal.values=y.createTypedArray(t.binormal.componentDatatype,h)),r(m)&&(t.tangent.values=y.createTypedArray(t.tangent.componentDatatype,m)),r(d)&&(t.st.values=y.createTypedArray(t.st.componentDatatype,d));var R=S.computeNumberOfVertices(e);e.indices=v.createTypedArray(R,p)}function H(e){for(var t=e.attributes,n=t.position.values,i=e.indices,o=Array.prototype.slice.call(n,0),s=[],u=d.fromPointNormal(a.ZERO,a.UNIT_Y),l=i.length,h=0;l>h;h+=2){var m=i[h],p=i[h+1],y=a.fromArray(n,3*m),w=a.fromArray(n,3*p);if(Math.abs(y.y)<f.EPSILON6&&(y.y=y.y<0?-f.EPSILON6:f.EPSILON6,o[3*m+1]=y.y),Math.abs(w.y)<f.EPSILON6&&(w.y=w.y<0?-f.EPSILON6:f.EPSILON6,o[3*p+1]=w.y),s.push(m),y.x<0||w.x<0){var g=c.lineSegmentPlane(y,w,u);if(r(g)){var E=a.multiplyByScalar(a.UNIT_Y,5*f.EPSILON9);y.y<0&&a.negate(E,E);var C=o.length/3;s.push(C,C+1);var x=a.add(g,E);o.push(x.x,x.y,x.z),a.negate(E,E),a.add(g,E,x),o.push(x.x,x.y,x.z)}}s.push(p)}e.attributes.position.values=new Float64Array(o);var b=S.computeNumberOfVertices(e);e.indices=v.createTypedArray(b,s)}var j={};j.toWireframe=function(e){if(!r(e))throw new n("geometry is required.");var t=e.indices;if(r(t)){switch(e.primitiveType){case w.TRIANGLES:e.indices=b(t);break;case w.TRIANGLE_STRIP:e.indices=T(t);break;case w.TRIANGLE_FAN:e.indices=O(t);break;default:throw new n("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=w.LINES}return e},j.createLineSegmentsForVectors=function(e,i,a){if(!r(e))throw new n("geometry is required.");if(!r(e.attributes.position))throw new n("geometry.attributes.position is required.");if(i=t(i,"normal"),!r(e.attributes[i]))throw new n("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+i+".");a=t(a,1e4);for(var o=e.attributes.position.values,s=e.attributes[i].values,u=o.length,l=new Float64Array(2*u),c=0,f=0;u>f;f+=3)l[c++]=o[f],l[c++]=o[f+1],l[c++]=o[f+2],l[c++]=o[f]+s[f]*a,l[c++]=o[f+1]+s[f+1]*a,l[c++]=o[f+2]+s[f+2]*a;var h,m=e.boundingSphere;return r(m)&&(h=new E(m.center,m.radius+a)),new S({attributes:{position:new C({componentDatatype:y.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:w.LINES,boundingSphere:h})},j.createAttributeIndices=function(e){if(!r(e))throw new n("geometry is required.");var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],a=e.attributes,o={},s=0,u=i.length;for(t=0;u>t;++t){var l=i[t];r(a[l])&&(o[l]=s++)}for(var c in a)a.hasOwnProperty(c)&&!r(o[c])&&(o[c]=s++);return o},j.reorderForPreVertexCache=function(e){if(!r(e))throw new n("geometry is required.");var t=S.computeNumberOfVertices(e),i=e.indices;if(r(i)){for(var a=new Int32Array(t),o=0;t>o;o++)a[o]=-1;for(var s,u=i,l=u.length,c=v.createTypedArray(t,l),f=0,h=0,m=0;l>f;)s=a[u[f]],-1!==s?c[h]=s:(s=u[f],a[s]=m,c[h]=m,++m),++f,++h;e.indices=c;var d=e.attributes;for(var p in d)if(d.hasOwnProperty(p)&&r(d[p])&&r(d[p].values)){for(var w=d[p],g=w.values,E=0,C=w.componentsPerAttribute,x=y.createTypedArray(w.componentDatatype,m*C);t>E;){var b=a[E];if(-1!==b)for(o=0;C>o;o++)x[C*b+o]=g[C*E+o];++E}w.values=x}}return e},j.reorderForPostVertexCache=function(e,t){if(!r(e))throw new n("geometry is required.");var i=e.indices;if(e.primitiveType===w.TRIANGLES&&r(i)){for(var a=i.length,o=0,s=0;a>s;s++)i[s]>o&&(o=i[s]);e.indices=g.tipsify({indices:i,maximumIndex:o,cacheSize:t})}return e},j.fitToUnsignedShortIndices=function(e){if(!r(e))throw new n("geometry is required.");if(r(e.indices)&&e.primitiveType!==w.TRIANGLES&&e.primitiveType!==w.LINES&&e.primitiveType!==w.POINTS)throw new n("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],i=S.computeNumberOfVertices(e);if(r(e.indices)&&i>f.SIXTY_FOUR_KILOBYTES){var a,o=[],s=[],u=0,l=A(e.attributes),c=e.indices,h=c.length;e.primitiveType===w.TRIANGLES?a=3:e.primitiveType===w.LINES?a=2:e.primitiveType===w.POINTS&&(a=1);for(var m=0;h>m;m+=a){for(var d=0;a>d;++d){var p=c[m+d],y=o[p];r(y)||(y=u++,o[p]=y,M(l,e.attributes,p)),s.push(y)}u+a>f.SIXTY_FOUR_KILOBYTES&&(t.push(new S({attributes:l,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),o=[],s=[],u=0,l=A(e.attributes))}0!==s.length&&t.push(new S({attributes:l,indices:s,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else t.push(e);return t};var V=new a,k=new s;j.projectTo2D=function(e,t,i,o,s){if(!r(e))throw new n("geometry is required.");if(!r(t))throw new n("attributeName is required.");if(!r(i))throw new n("attributeName3D is required.");if(!r(o))throw new n("attributeName2D is required.");var u=e.attributes[t];if(!r(u))throw new n("geometry must have attribute matching the attributeName argument: "+t+".");if(u.componentDatatype.value!==y.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");s=r(s)?s:new p;for(var l=s.getEllipsoid(),c=u.values,f=new Float64Array(c.length),h=0,m=0;m<c.length;m+=3){var d=a.fromArray(c,m,V),v=l.cartesianToCartographic(d,k);if(!r(v))throw new n("Could not project point ("+d.x+", "+d.y+", "+d.z+") to 2D.");var w=s.project(v,V);f[h++]=w.x,f[h++]=w.y,f[h++]=w.z}return e.attributes[i]=u,e.attributes[o]=new C({componentDatatype:y.DOUBLE,componentsPerAttribute:3,values:f}),delete e.attributes[t],e};var K={high:0,low:0};j.encodeAttribute=function(e,t,i,a){if(!r(e))throw new n("geometry is required.");if(!r(t))throw new n("attributeName is required.");if(!r(i))throw new n("attributeHighName is required.");if(!r(a))throw new n("attributeLowName is required.");var o=e.attributes[t];if(!r(o))throw new n("geometry must have attribute matching the attributeName argument: "+t+".");if(o.componentDatatype.value!==y.DOUBLE.value)throw new n("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var s=o.values,l=s.length,c=new Float32Array(l),f=new Float32Array(l),h=0;l>h;++h)u.encode(s[h],K),c[h]=K.high,f[h]=K.low;var m=o.componentsPerAttribute;return e.attributes[i]=new C({componentDatatype:y.FLOAT,componentsPerAttribute:m,values:c}),e.attributes[a]=new C({componentDatatype:y.FLOAT,componentsPerAttribute:m,values:f}),delete e.attributes[t],e};var Z=new a,X=new m,J=new h;j.transformToWorldCoordinates=function(e){if(!r(e))throw new n("instance is required.");var t=e.modelMatrix;if(m.equals(t,m.IDENTITY))return e;var i=e.geometry.attributes;D(t,i.position),D(t,i.prevPosition),D(t,i.nextPosition),(r(i.normal)||r(i.binormal)||r(i.tangent))&&(m.inverse(t,X),m.transpose(X,X),m.getRotation(X,J),_(J,i.normal),_(J,i.binormal),_(J,i.tangent));var a=e.geometry.boundingSphere;return r(a)&&(e.geometry.boundingSphere=E.transform(a,t,a)),e.modelMatrix=m.clone(m.IDENTITY),e},j.combine=function(e){if(!r(e)||e.length<1)throw new n("instances is required and must have length greater than zero.");var t,i,o,s,u=e.length,l=e[0].modelMatrix,c=r(e[0].geometry.indices),f=e[0].geometry.primitiveType;for(i=1;u>i;++i){if(!m.equals(e[i].modelMatrix,l))throw new n("All instances must have the same modelMatrix.");if(r(e[i].geometry.indices)!==c)throw new n("All instance geometries must have an indices or not have one.");if(e[i].geometry.primitiveType!==f)throw new n("All instance geometries must have the same primitiveType.")}var h,d,p,y=N(e);for(t in y)if(y.hasOwnProperty(t))for(h=y[t].values,s=0,i=0;u>i;++i)for(d=e[i].geometry.attributes[t].values,p=d.length,o=0;p>o;++o)h[s++]=d[o];var g;if(c){var C=0;for(i=0;u>i;++i)C+=e[i].geometry.indices.length;var x=S.computeNumberOfVertices(new S({attributes:y,primitiveType:w.POINTS})),b=v.createTypedArray(x,C),T=0,O=0;for(i=0;u>i;++i){var A=e[i].geometry.indices,M=A.length;for(s=0;M>s;++s)b[T++]=O+A[s];O+=S.computeNumberOfVertices(e[i].geometry)}g=b}var D,_=new a,I=0;for(i=0;u>i;++i){if(D=e[i].geometry.boundingSphere,!r(D)){_=void 0;break}a.add(D.center,_,_)}if(r(_))for(a.divideByScalar(_,u,_),i=0;u>i;++i){D=e[i].geometry.boundingSphere;var R=a.magnitude(a.subtract(D.center,_))+D.radius;R>I&&(I=R)}return new S({attributes:y,indices:g,primitiveType:f,boundingSphere:r(_)?new E(_,I):void 0})};var Q=new a,$=new a,et=new a,tt=new a;j.computeNormal=function(e){if(!r(e))throw new n("geometry is required.");var t=e.attributes,i=e.indices;if(!r(t.position)||!r(t.position.values))throw new n("geometry.attributes.position.values is required.");if(!r(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==w.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var o=e.attributes.position.values,s=e.attributes.position.values.length/3,u=i.length,l=new Array(s),c=new Array(u/3),f=new Array(u),h=0;s>h;h++)l[h]={indexOffset:0,count:0,currentCount:0};var m=0;for(h=0;u>h;h+=3){var d=i[h],p=i[h+1],v=i[h+2],g=3*d,E=3*p,S=3*v;$.x=o[g],$.y=o[g+1],$.z=o[g+2],et.x=o[E],et.y=o[E+1],et.z=o[E+2],tt.x=o[S],tt.y=o[S+1],tt.z=o[S+2],l[d].count++,l[p].count++,l[v].count++,a.subtract(et,$,et),a.subtract(tt,$,tt),c[m]=a.cross(et,tt),m++}var x=0;for(h=0;s>h;h++)l[h].indexOffset+=x,x+=l[h].count;m=0;var b;for(h=0;u>h;h+=3){b=l[i[h]];var T=b.indexOffset+b.currentCount;f[T]=m,b.currentCount++,b=l[i[h+1]],T=b.indexOffset+b.currentCount,f[T]=m,b.currentCount++,b=l[i[h+2]],T=b.indexOffset+b.currentCount,f[T]=m,b.currentCount++,m++}var O=new Float32Array(3*s);for(h=0;s>h;h++){var A=3*h;if(b=l[h],b.count>0){for(a.clone(a.ZERO,Q),m=0;m<b.count;m++)a.add(Q,c[f[b.indexOffset+m]],Q);a.normalize(Q,Q),O[A]=Q.x,O[A+1]=Q.y,O[A+2]=Q.z}else O[A]=0,O[A+1]=0,O[A+2]=1}return e.attributes.normal=new C({componentDatatype:y.FLOAT,componentsPerAttribute:3,values:O}),e};var rt=new a,nt=new a,it=new a;j.computeBinormalAndTangent=function(e){if(!r(e))throw new n("geometry is required.");var t=e.attributes,i=e.indices;if(!r(t.position)||!r(t.position.values))throw new n("geometry.attributes.position.values is required.");if(!r(t.normal)||!r(t.normal.values))throw new n("geometry.attributes.normal.values is required.");if(!r(t.st)||!r(t.st.values))throw new n("geometry.attributes.st.values is required.");if(!r(i))throw new n("geometry.indices is required.");if(i.length<2||0!==i.length%3)throw new n("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==w.TRIANGLES)throw new n("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var o=e.attributes.position.values,s=e.attributes.normal.values,u=e.attributes.st.values,l=e.attributes.position.values.length/3,c=i.length,f=new Array(3*l),h=0;h<f.length;h++)f[h]=0;var m,d,p;for(h=0;c>h;h+=3){var v=i[h],g=i[h+1],E=i[h+2];m=3*v,d=3*g,p=3*E;var S=2*v,x=2*g,b=2*E,T=o[m],O=o[m+1],A=o[m+2],M=u[S],D=u[S+1],_=u[x+1]-D,N=u[b+1]-D,I=1/((u[x]-M)*N-(u[b]-M)*_),R=(N*(o[d]-T)-_*(o[p]-T))*I,P=(N*(o[d+1]-O)-_*(o[p+1]-O))*I,z=(N*(o[d+2]-A)-_*(o[p+2]-A))*I;f[m]+=R,f[m+1]+=P,f[m+2]+=z,f[d]+=R,f[d+1]+=P,f[d+2]+=z,f[p]+=R,f[p+1]+=P,f[p+2]+=z}var L=new Float32Array(3*l),q=new Float32Array(3*l);for(h=0;l>h;h++){m=3*h,d=m+1,p=m+2;var F=a.fromArray(s,m,rt),U=a.fromArray(f,m,it),B=a.dot(F,U);a.multiplyByScalar(F,B,nt),a.normalize(a.subtract(U,nt,U),U),q[m]=U.x,q[d]=U.y,q[p]=U.z,a.normalize(a.cross(F,U,U),U),L[m]=U.x,L[d]=U.y,L[p]=U.z}return e.attributes.tangent=new C({componentDatatype:y.FLOAT,componentsPerAttribute:3,values:q}),e.attributes.binormal=new C({componentDatatype:y.FLOAT,componentsPerAttribute:3,values:L}),e};var at=new a,ot=new a,st=new a,ut=new a,lt=new a,ct={positions:new Array(7),indices:new Array(9)};return j.wrapLongitude=function(e){if(!r(e))throw new n("geometry is required.");var t=e.boundingSphere;if(r(t)){var i=t.center.x-t.radius;if(i>0||E.intersect(t,o.UNIT_Y)!==l.INTERSECTING)return e
}return F(e),e.primitiveType===w.TRIANGLES?Y(e):e.primitiveType===w.LINES&&H(e),e},j}),define("Scene/PrimitivePipeline",["../Core/defined","../Core/defaultValue","../Core/Color","../Core/ComponentDatatype","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryPipeline","../Core/Matrix4"],function(e,t,r,n,i,a,o,s,u,l){"use strict";function c(e,t,r){var n,i=!r,a=e.length;if(!i&&a>1){var o=e[0].modelMatrix;for(n=1;a>n;++n)if(!l.equals(o,e[n].modelMatrix)){i=!0;break}}if(i)for(n=0;a>n;++n)u.transformToWorldCoordinates(e[n]);else l.clone(e[0].modelMatrix,t)}function f(e,t){for(var i=e.length,a=0;i>a;++a){var o=e[a],u=o.geometry,l=u.attributes,c=l.position,f=4*(c.values.length/c.componentsPerAttribute);l.pickColor=new s({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(f)});for(var h=t[a],m=r.floatToByte(h.red),d=r.floatToByte(h.green),p=r.floatToByte(h.blue),y=r.floatToByte(h.alpha),v=l.pickColor.values,w=0;f>w;w+=4)v[w]=m,v[w+1]=d,v[w+2]=p,v[w+3]=y}}function h(t){var r,n=t.length,i=[],a=t[0].attributes;for(r in a)if(a.hasOwnProperty(r)){for(var o=a[r],s=!0,u=1;n>u;++u){var l=t[u].attributes[r];if(!e(l)||o.componentDatatype.value!==l.componentDatatype.value||o.componentsPerAttribute!==l.componentsPerAttribute||o.normalize!==l.normalize){s=!1;break}}s&&i.push(r)}return i}function m(e,t){for(var r=e.length,i=0;r>i;++i)for(var a=e[i],u=a.attributes,l=a.geometry,c=o.computeNumberOfVertices(l),f=t.length,h=0;f>h;++h){for(var m=t[h],d=u[m],p=d.componentDatatype,y=d.value,v=y.length,w=n.createTypedArray(p,c*v),g=0;c>g;++g)w.set(y,g*v);l.attributes[m]=new s({componentDatatype:p,componentsPerAttribute:v,normalize:d.normalize,values:w})}}function d(e){var t,r=e.instances,a=e.pickIds,o=e.projection,s=e.elementIndexUintSupported,l=e.allow3DOnly,d=e.allowPicking,p=e.vertexCacheOptimize,y=e.modelMatrix,v=r.length,w=r[0].geometry.primitiveType;for(t=1;v>t;++t)if(r[t].geometry.primitiveType!==w)throw new i("All instance geometries must have the same primitiveType.");if(c(r,y,l),!l)for(t=0;v>t;++t)u.wrapLongitude(r[t].geometry);d&&f(r,a);var g=h(r);if(m(r,g),p)for(t=0;v>t;++t)u.reorderForPostVertexCache(r[t].geometry),u.reorderForPreVertexCache(r[t].geometry);var E,S=u.combine(r),C=S.attributes;if(l)for(E in C)C.hasOwnProperty(E)&&C[E].componentDatatype.value===n.DOUBLE.value&&u.encodeAttribute(S,E,E+"3DHigh",E+"3DLow");else for(E in C)if(C.hasOwnProperty(E)&&C[E].componentDatatype.value===n.DOUBLE.value){var x=E+"3D",b=E+"2D";u.projectTo2D(S,E,x,b,o),u.encodeAttribute(S,x,x+"High",x+"Low"),u.encodeAttribute(S,b,b+"High",b+"Low")}return s?[S]:u.fitToUnsignedShortIndices(S)}function p(e,t,r){for(var i=[],a=e.attributes,o=r.length,s=0;o>s;++s){var u=r[s],l=a[u],c=l.componentDatatype;c.value===n.DOUBLE.value&&(c=n.FLOAT);var f=n.createTypedArray(c,l.values);i.push({index:t[u],componentDatatype:c,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,values:f}),delete a[u]}return i}function y(r,n,i){for(var a=[],s=h(r),u=r.length,l={},c={},f=0;u>f;++f)for(var m=r[f],d=o.computeNumberOfVertices(m.geometry),p=s.length,y=0;p>y;++y)for(var v=s[y],w=i[v],g=d;g>0;){for(var E,S=t(c[v],0),C=n[S],x=C.length,b=0;x>b&&(E=C[b],E.index!==w);++b);e(a[f])||(a[f]={}),e(a[f][v])||(a[f][v]={dirty:!1,value:m.attributes[v].value,indices:[]});var T,O=E.values.length/E.componentsPerAttribute,A=t(l[v],0);O>A+g?(T=g,a[f][v].indices.push({attribute:E,offset:A,count:T}),l[v]=A+g):(T=O-A,a[f][v].indices.push({attribute:E,offset:A,count:T}),l[v]=0,c[v]=S+1),g-=T}return a}function v(e){return{type:e.constructor.name,buffer:e.buffer}}function w(e){return new E[e.type](e.buffer)}if(!a.supportsTypedArrays())return{};var g={};g.combineGeometry=function(e){for(var t={instances:e.instances,pickIds:e.pickIds,ellipsoid:e.ellipsoid,projection:e.projection,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:l.clone(e.modelMatrix)},r=d(t),n=u.createAttributeIndices(r[0]),i=t.instances,a=h(i),o=[],s=r.length,c=0;s>c;++c){var f=r[c];o.push(p(f,n,a))}var m=y(i,o,n);return{geometries:r,modelMatrix:t.modelMatrix,attributeIndices:n,vaAttributes:o,vaAttributeIndices:m}};var E={Int8Array:Int8Array,Uint8Array:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};return g.transferGeometry=function(t,r){var n,i=t.attributes;for(var a in i)i.hasOwnProperty(a)&&e(i[a])&&e(i[a].values)&&(n=i[a].values,r.indexOf(i[a].values.buffer)<0&&r.push(n.buffer),e(n.type)||(i[a].values=v(n)));e(t.indices)&&(n=t.indices,r.push(n.buffer),e(n.type)||(t.indices=v(t.indices)))},g.transferGeometries=function(e,t){for(var r=e.length,n=0;r>n;++n)g.transferGeometry(e[n],t)},g.transferPerInstanceAttributes=function(e,t){for(var r=e.length,n=0;r>n;++n)for(var i=e[n],a=i.length,o=0;a>o;++o){var s=i[o].values;t.push(s.buffer),i[o].values=v(s)}},g.transferInstances=function(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n];g.transferGeometry(i.geometry,t)}},g.receiveGeometry=function(t){var r=t.attributes;for(var n in r)r.hasOwnProperty(n)&&e(r[n])&&e(r[n].values)&&(r[n].values=w(r[n].values));e(t.indices)&&(t.indices=w(t.indices))},g.receiveGeometries=function(e){for(var t=e.length,r=0;t>r;++r)g.receiveGeometry(e[r])},g.receivePerInstanceAttributes=function(e){for(var t=e.length,r=0;t>r;++r)for(var n=e[r],i=n.length,a=0;i>a;++a)n[a].values=w(n[a].values)},g.receiveInstances=function(e){for(var t=e.length,r=0;t>r;++r){var n=e[r];g.receiveGeometry(n.geometry)}},g}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined"],function(e,t){"use strict";var r=function(r){var n,i=[],a={id:void 0,result:void 0,error:void 0};return function(o){var s=o.data;i.length=0,a.id=s.id,a.error=void 0,a.result=void 0;try{a.result=r(s.parameters,i)}catch(u){a.error=u}t(n)||(n=e(self.webkitPostMessage,self.postMessage));try{n(a,i)}catch(u){a.result=void 0,a.error="postMessage failed with error: "+u+"\n  with responseMessage: "+JSON.stringify(a),n(a)}}};return r}),define("Workers/createWallOutlineGeometry",["../Core/WallOutlineGeometry","../Core/Ellipsoid","../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,t,r,n){"use strict";function i(n,i){var a=n.geometry;a._ellipsoid=t.clone(a._ellipsoid);var o=e.createGeometry(a);return r.transferGeometry(o,i),{geometry:o,index:n.index}}return n(i)})}();