import sys

from setuptools import setup, find_packages


extra_setup = {}
if sys.version_info >= (3,):
    extra_setup['use_2to3'] = True

setup(
    name='nose-progressive',
    version='1.2.1',
    description='Nose plugin to show progress bar and tracebacks during tests',
    long_description=open('README.rst').read(),
    author='Erik Rose',
    author_email='erikrose@grinchcentral.com',
    license='GPL',
    packages=find_packages(exclude=['ez_setup']),
    install_requires=['Nose>=0.11.0', 'blessings>=1.1,<2.0'],
    url='',
    include_package_data=True,
    entry_points="""
        [nose.plugins.0.10]
        noseprogressive = noseprogressive:ProgressivePlugin
        """,
    classifiers = [
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Topic :: Software Development :: Testing'
        ],
    **extra_setup
)
