#!/usr/bin/env python
# encoding=utf-8

import imp
import os

# DO NOT EDIT THIS FILE (so it can be safely updated)
# Edits should go to a local_settings.py file in same folder.

# Python module.function path to your handler
NOSMSD_HANDLER = 'nosmsd.handlers.printout'

# Should incoming script switch locale before launching the handler?
NOSMSD_GETTEXT = False
NOSMSD_GETTEXT_LOCALE = 'en_US.UTF-8'

# Full Path to virtual-env 'site-packages' folder
NOSMSD_VENV_PATH = None

# DATABASE DEFINITION
# TYPES: Sqlite, MySQL, Postgres
NOSMSD_DATABASE = {'type': 'Sqlite', 'name': 'gammu-smsd.db'}

# DB Options are backend dependant.
# See sqlite3, MySQLdb and psycopg2 drivers for details.
# Sqlite requires none.
# MySQL example: {'user': 'myuser', 'passwd': 'mypasswd',
#                 'host': 'localhost', 'use_unicode': True}
NOSMSD_DATABASE_OPTIONS = {}

# whether a multipart SMS can have
# parts with different encoding.
# Numerous phones does not support this.
NOSMSD_MIX_ENCODING_PARTS = False

# try to find local settings to retrieve VENV path
for fpath in ['/etc/nosmsd.conf.py',
              os.path.expanduser('~/.nosmsd.conf.py'),
              os.path.expanduser('~/nosmsd.conf.py'),
              'nosmsd.conf.py']:
    try:
        imp.load_source('local_settings', fpath)
        break
    except (IOError, ImportError):
        continue
try:
    local_settings = __import__('settings')
    from local_settings import *
except ImportError as e:
    pass

# create and fill dict with
# variables from settings and local_settings module.
dicko = {}
for var in dir():
    if var.startswith('__') or var.islower():
        continue
    dicko[var] = eval(var)


class Options(dict, object):
    """ dumb dict store giving inst.var access to var property """

    def __init__(self, **kwargs):
        dict.__init__(self, **kwargs)

    def __getattribute__(self, name):
        try:
            return self[name]
        except:
            return None

# instanciate and fill-up settings dict.
settings = Options(**dicko)
