import hashlib
import os
import sys
from getpass import getpass

user = os.path.expanduser('~')


class SetupConfig(object):
    # If left None "Not_So_TUF" will be used
    APP_NAME = None

    # Directory for updater to downlaod and
    # verify files.  If left blank will be place
    # in the users home directory Unix ".Not_So_TUF"
    # windows "Not_So_Tuf"
    APP_DATA_DIR = None

    # If set more debug info will be printed to console
    DEBUG = False

    # Work directory on dev machine for framework to
    # do its business. sign updates, get hashes etc...
    # If None a data folder will be created in the
    # current directory
    DEV_DATA_DIR = None

    # Length of keys to sign and verify files with
    # If left None 2048 key size will be used
    KEY_LENGTH = None

    # Name made for your private key. If left
    # None "Not_So_TUF.pem" will be used
    PRIVATE_KEY_NAME = None

    # Public Key used by your app to verify update data
    # REQUIRED
    PUBLIC_KEY = None

    # Name made for your public key.  If left
    # None "Not_So_TUF.pub" will be used
    PUBLIC_KEY_NAME = None

    # Online repository where you host your packages
    # and version file
    # REQUIRED
    UPDATE_URL = None

    # Support for patch updates
    UPDATE_PATCHES = True

    def add_private_key_name(self, name):
        self.PRIVATE_KEY_NAME = name + '.pem'

    def add_public_key_name(self, name):
        self.PUBLIC_KEY_NAME = name + '.pub'


def path_fixer(path):
    # Removing ' & " in case user used them
    # for path with spaces
    path.replace("'", "")
    path.replace('"', '')

    # Correcting the path with spaces to work
    # without quotes
    path.replace (' ', '\ ')


def get_correct_answer(question, default=None, required=False,
                       password=False, create_account=False):
    while 1:
        if default is None:
            msg = ''
        else:
            msg = '\n[DEFAULT] -> {}'.format(default)
        prompt = question + msg + '\n--> '
        if password:
            answer = getpass(prompt)
            if create_account is False:
                return answer
            print '\n\n'
            answer1 = getpass('Again ' + prompt)
            if answer == answer1:
                return answer
            print 'Passwords didn\'t match\n'
            continue
        else:
            answer = raw_input(prompt)
        if answer == '' and required is True:
            print 'You have to enter a value\n\n'
            raw_input('Press enter to continue')
            print '\n\n'
            continue
        if answer == '' and default is not None:
            answer = default
        _ans = ask_yes_no('You entered {}, is this correct?'.format(answer))
        if _ans:
            return answer


def ask_yes_no(question, default='no'):
    default = default.lower()
    yes = ['yes', 'ye', 'y']
    no = ['no', 'n']
    if default in no:
        help = '[N/y]?'
        default = False
    else:
        default = True
        help = '[Y/n]?'
    while 1:
        display = question + '\n' + help
        answer = raw_input(display)
        if answer == '':
            return default
        if answer in yes:
            return True
        elif answer in no:
            return False
        else:
            print 'Please answer yes or no only!\n'
            raw_input('Press enter to continue')
            print '\n\n\n\n'


def install_check():
    user = os.path.expanduser('~')
    if sys.platform != 'win32':
        path = os.path.join(user, '.not_so_tuf')
    else:
        path = os.path.join(user, 'AppData', 'Roaming', 'not_so_tuf')
    if not os.path.exists(path):
        os.mkdir(path)
        return False
    return True

if sys.platform == 'win32':
    clear = 'cls'
    settings_dir = os.path.join(user, 'not_so_tuf')
else:
    clear = 'clear'
    settings_dir = os.path.join(user, '.not_so_tuf')


def password_hasher(x):
    digest = sha_digest(x)
    for d in range(0, 100001):
        digest = sha_digest(digest)
    return digest


def sha_digest(data):
    return hashlib.sha256(data).hexdigest()
